/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import java.io.Serializable;
import java.util.Properties;
import kafka.api.ApiVersion;
import kafka.api.ApiVersion$;
import kafka.api.KAFKA_0_10_0_IV1$;
import kafka.api.KAFKA_0_10_2_IV0$;
import kafka.api.KAFKA_0_9_0$;
import kafka.api.KAFKA_1_0_IV0$;
import kafka.api.KAFKA_2_2_IV0$;
import kafka.api.KAFKA_2_4_IV0$;
import kafka.api.KAFKA_2_4_IV1$;
import kafka.api.LeaderAndIsr;
import kafka.api.LeaderAndIsr$;
import kafka.cluster.Broker;
import kafka.cluster.EndPoint;
import kafka.controller.AbstractControllerBrokerRequestBatch;
import kafka.controller.ControllerChannelManagerTest$MockControllerBrokerRequestBatch$;
import kafka.controller.ControllerChannelManagerTest$SentRequest$;
import kafka.controller.ControllerContext;
import kafka.controller.ControllerEvent;
import kafka.controller.LeaderAndIsrResponseReceived;
import kafka.controller.LeaderIsrAndControllerEpoch;
import kafka.controller.ReplicaAssignment;
import kafka.controller.StateChangeLogger;
import kafka.controller.TopicDeletionStopReplicaResponseReceived;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.LeaderAndIsrRequestData;
import org.apache.kafka.common.message.LeaderAndIsrResponseData;
import org.apache.kafka.common.message.StopReplicaResponseData;
import org.apache.kafka.common.message.UpdateMetadataRequestData;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractControlRequest;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.LeaderAndIsrRequest;
import org.apache.kafka.common.requests.LeaderAndIsrResponse;
import org.apache.kafka.common.requests.StopReplicaRequest;
import org.apache.kafka.common.requests.StopReplicaResponse;
import org.apache.kafka.common.requests.UpdateMetadataRequest;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.junit.Assert;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.TraversableForwarder;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.BufferLike;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.Map$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\r=e\u0001B&M\u0001ECQ\u0001\u0017\u0001\u0005\u0002eCq\u0001\u0018\u0001C\u0002\u0013%Q\f\u0003\u0004b\u0001\u0001\u0006IA\u0018\u0005\bE\u0002\u0011\r\u0011\"\u0003^\u0011\u0019\u0019\u0007\u0001)A\u0005=\"9A\r\u0001b\u0001\n\u0013)\u0007B\u00027\u0001A\u0003%a\rC\u0004n\u0001\t\u0007I\u0011\u00028\t\rI\u0004\u0001\u0015!\u0003p\u000b\u0011\u0019\b\u0001\u0001;\t\u000f\u0005\r\u0002\u0001\"\u0001\u0002&!9\u00111\b\u0001\u0005\u0002\u0005\u0015\u0002bBA \u0001\u0011\u0005\u0011Q\u0005\u0005\b\u0003\u0007\u0002A\u0011AA\u0013\u0011\u001d\t9\u0005\u0001C\u0005\u0003\u0013Bq!!\u001a\u0001\t\u0003\t)\u0003C\u0004\u0002j\u0001!\t!!\n\t\u000f\u00055\u0004\u0001\"\u0001\u0002&!9\u0011\u0011\u000f\u0001\u0005\u0002\u0005\u0015\u0002bBA;\u0001\u0011\u0005\u0011Q\u0005\u0005\b\u0003s\u0002A\u0011BA>\u0011\u001d\t\u0019\t\u0001C\u0001\u0003KAq!a\"\u0001\t\u0003\t)\u0003C\u0004\u0002\f\u0002!\t!!\n\t\u000f\u0005=\u0005\u0001\"\u0001\u0002&!9\u00111\u0013\u0001\u0005\u0002\u0005\u0015\u0002bBAL\u0001\u0011\u0005\u0011Q\u0005\u0005\b\u00037\u0003A\u0011AA\u0013\u0011\u001d\ty\n\u0001C\u0005\u0003CCq!!+\u0001\t\u0013\tY\u000bC\u0004\u0003\b\u0002!IA!#\t\u000f\t=\u0005\u0001\"\u0003\u0003\u0012\"9!q\u0013\u0001\u0005\n\te\u0005b\u0002BV\u0001\u0011%!Q\u0016\u0004\u0007\u0003;\u0004A)a8\t\u0015\u000558E!f\u0001\n\u0003\ty\u000f\u0003\u0006\u0002t\u000e\u0012\t\u0012)A\u0005\u0003cD!\"!>$\u0005+\u0007I\u0011AA|\u0011)\u0011)a\tB\tB\u0003%\u0011\u0011 \u0005\u00071\u000e\"\tAa\u0002\t\u0013\t51%!A\u0005\u0002\t=\u0001\"\u0003B\u000bGE\u0005I\u0011\u0001B\f\u0011%\u0011\tcII\u0001\n\u0003\u0011\u0019\u0003C\u0005\u0003:\r\n\t\u0011\"\u0011\u0003<!A!QJ\u0012\u0002\u0002\u0013\u0005Q\fC\u0005\u0003P\r\n\t\u0011\"\u0001\u0003R!I!QL\u0012\u0002\u0002\u0013\u0005#q\f\u0005\n\u0005[\u001a\u0013\u0011!C\u0001\u0005_B\u0011B!\u001f$\u0003\u0003%\tEa\u001f\t\u0013\tu4%!A\u0005B\t}\u0004\"\u0003BAG\u0005\u0005I\u0011\tBB\u000f%\u0011I\u000eAA\u0001\u0012\u0013\u0011YNB\u0005\u0002^\u0002\t\t\u0011#\u0003\u0003^\"1\u0001,\u000eC\u0001\u0005WD\u0011B! 6\u0003\u0003%)Ea \t\u0013\t5X'!A\u0005\u0002\n=\b\"\u0003B{k\u0005\u0005I\u0011\u0011B|\r\u0019\u0019I\u0001\u0001\u0003\u0004\f!Q11\u0003\u001e\u0003\u0002\u0003\u0006IAa,\t\u0011\u0011T$\u0011!Q\u0001\n\u0019Da\u0001\u0017\u001e\u0005\u0002\rU\u0001\"CB\u000fu\t\u0007I\u0011AB\u0010\u0011!\u0019\u0019D\u000fQ\u0001\n\r\u0005\u0002\"CA`u\t\u0007I\u0011AB\u001b\u0011!\u0019yD\u000fQ\u0001\n\r]\u0002bBB!u\u0011\u000531\t\u0005\b\u0007\u0013RD\u0011IB&\u0011\u001d\u00199F\u000fC\u0001\u00073Bqa!\u001a;\t\u0003\u00199\u0007C\u0004\u0004ti\"\ta!\u001e\b\u0013\r\u0005\u0005!!A\t\n\r\re!CB\u0005\u0001\u0005\u0005\t\u0012BBC\u0011\u0019A\u0006\n\"\u0001\u0004\b\"I1\u0011\u0012%\u0012\u0002\u0013\u000511\u0012\u0002\u001d\u0007>tGO]8mY\u0016\u00148\t[1o]\u0016dW*\u00198bO\u0016\u0014H+Z:u\u0015\tie*\u0001\u0006d_:$(o\u001c7mKJT\u0011aT\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001!\u000b\u0005\u0002T-6\tAKC\u0001V\u0003\u0015\u00198-\u00197b\u0013\t9FK\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003i\u0003\"a\u0017\u0001\u000e\u00031\u000bAbY8oiJ|G\u000e\\3s\u0013\u0012,\u0012A\u0018\t\u0003'~K!\u0001\u0019+\u0003\u0007%sG/A\u0007d_:$(o\u001c7mKJLE\rI\u0001\u0010G>tGO]8mY\u0016\u0014X\t]8dQ\u0006\u00012m\u001c8ue>dG.\u001a:Fa>\u001c\u0007\u000eI\u0001\u0007G>tg-[4\u0016\u0003\u0019\u0004\"a\u001a6\u000e\u0003!T!!\u001b(\u0002\rM,'O^3s\u0013\tY\u0007NA\u0006LC\u001a\\\u0017mQ8oM&<\u0017aB2p]\u001aLw\rI\u0001\u0007Y><w-\u001a:\u0016\u0003=\u0004\"a\u00179\n\u0005Ed%!E*uCR,7\t[1oO\u0016dunZ4fe\u00069An\\4hKJ\u0004#AD\"p]R\u0014x\u000e\u001c*fcV,7\u000f\u001e\u0019\u0004k\u0006E\u0001#\u0002<\u0002\b\u00055abA<\u0002\u00045\t\u0001P\u0003\u0002zu\u0006A!/Z9vKN$8O\u0003\u0002|y\u000611m\\7n_:T!aT?\u000b\u0005y|\u0018AB1qC\u000eDWM\u0003\u0002\u0002\u0002\u0005\u0019qN]4\n\u0007\u0005\u0015\u00010\u0001\fBEN$(/Y2u\u0007>tGO]8m%\u0016\fX/Z:u\u0013\u0011\tI!a\u0003\u0003\u000f\t+\u0018\u000e\u001c3fe*\u0019\u0011Q\u0001=\u0011\t\u0005=\u0011\u0011\u0003\u0007\u0001\t-\t\u0019BCA\u0001\u0002\u0003\u0015\t!!\u0006\u0003\u0007}#\u0013'\u0005\u0003\u0002\u0018\u0005u\u0001cA*\u0002\u001a%\u0019\u00111\u0004+\u0003\u000f9{G\u000f[5oOB\u0019q/a\b\n\u0007\u0005\u0005\u0002P\u0001\fBEN$(/Y2u\u0007>tGO]8m%\u0016\fX/Z:u\u0003m!Xm\u001d;MK\u0006$WM]!oI&\u001b(OU3rk\u0016\u001cHoU3oiR\u0011\u0011q\u0005\t\u0004'\u0006%\u0012bAA\u0016)\n!QK\\5uQ\rY\u0011q\u0006\t\u0005\u0003c\t9$\u0004\u0002\u00024)\u0019\u0011QG@\u0002\u000b),h.\u001b;\n\t\u0005e\u00121\u0007\u0002\u0005)\u0016\u001cH/\u0001\u000fuKN$H*Z1eKJ\fe\u000eZ%teJ+\u0017/^3ti&\u001bh*Z<)\u00071\ty#\u0001\u001cuKN$H*Z1eKJ\fe\u000eZ%teJ+\u0017/^3tiN+g\u000e\u001e+p\u0019&4Xm\u0014:TQV$H/\u001b8h\t><hN\u0011:pW\u0016\u00148\u000fK\u0002\u000e\u0003_\t!\u0006^3ti2+\u0017\rZ3s\u0003:$\u0017j\u001d:J]R,'O\u0011:pW\u0016\u0014\bK]8u_\u000e|GNV3sg&|g\u000eK\u0002\u000f\u0003_\t\u0001\b^3ti2+\u0017\rZ3s\u0003:$\u0017j\u001d:SKF,Xm\u001d;G_2dwn^:J]R,'O\u0011:pW\u0016\u0014\bK]8u_\u000e|GNV3sg&|g\u000e\u0006\u0004\u0002(\u0005-\u00131\f\u0005\b\u0003\u001bz\u0001\u0019AA(\u0003iIg\u000e^3s\u0005J|7.\u001a:Qe>$xnY8m-\u0016\u00148/[8o!\u0011\t\t&a\u0016\u000e\u0005\u0005M#bAA+\u001d\u0006\u0019\u0011\r]5\n\t\u0005e\u00131\u000b\u0002\u000b\u0003BLg+\u001a:tS>t\u0007bBA/\u001f\u0001\u0007\u0011qL\u0001\u001cKb\u0004Xm\u0019;fI2+\u0017\rZ3s\u0003:$\u0017j\u001d:WKJ\u001c\u0018n\u001c8\u0011\u0007M\u000b\t'C\u0002\u0002dQ\u0013Qa\u00155peR\fQ\u0004^3tiV\u0003H-\u0019;f\u001b\u0016$\u0018\rZ1uCJ+\u0017/^3tiN+g\u000e\u001e\u0015\u0004!\u0005=\u0012!\u0010;fgR,\u0006\u000fZ1uK6+G/\u00193bi\u0006$u.Z:O_RLen\u00197vI\u0016\u0004\u0016M\u001d;ji&|gn],ji\"|W\u000f\u001e'fC\u0012,'/\u00118e\u0013N\u0014\bfA\t\u00020\u0005aC/Z:u+B$\u0017\r^3NKR\fG-\u0019;b%\u0016\fX/Z:u\tV\u0014\u0018N\\4U_BL7\rR3mKRLwN\u001c\u0015\u0004%\u0005=\u0012a\r;fgR,\u0006\u000fZ1uK6+G/\u00193bi\u0006Len\u00197vI\u0016\u001cH*\u001b<f\u001fJ\u001c\u0006.\u001e;uS:<Gi\\<o\u0005J|7.\u001a:tQ\r\u0019\u0012qF\u0001-i\u0016\u001cH/\u00169eCR,W*\u001a;bI\u0006$\u0018-\u00138uKJ\u0014%o\\6feB\u0013x\u000e^8d_24VM]:j_:D3\u0001FA\u0018\u0003M\"Xm\u001d;Va\u0012\fG/Z'fi\u0006$\u0017\r^1G_2dwn^:J]R,'O\u0011:pW\u0016\u0014\bK]8u_\u000e|GNV3sg&|g\u000e\u0006\u0004\u0002(\u0005u\u0014q\u0010\u0005\b\u0003\u001b*\u0002\u0019AA(\u0011\u001d\t\t)\u0006a\u0001\u0003?\nQ$\u001a=qK\u000e$X\rZ+qI\u0006$X-T3uC\u0012\fG/\u0019,feNLwN\\\u0001\u001bi\u0016\u001cHo\u0015;paJ+\u0007\u000f\\5dCJ+\u0017/^3tiN+g\u000e\u001e\u0015\u0004-\u0005=\u0012A\r;fgR\u001cFo\u001c9SKBd\u0017nY1SKF,Xm\u001d;t/\"LG.\u001a+pa&\u001c\u0017+^3vK\u00124uN\u001d#fY\u0016$\u0018n\u001c8)\u0007]\ty#\u0001\u0019uKN$8\u000b^8q%\u0016\u0004H.[2b%\u0016\fX/Z:ug^C\u0017\u000e\\3U_BL7\rR3mKRLwN\\*uCJ$X\r\u001a\u0015\u00041\u0005=\u0012A\f;fgRl\u0015\u000e_3e\t\u0016dW\r^3B]\u0012tu\u000e\u001e#fY\u0016$Xm\u0015;paJ+\u0007\u000f\\5dCJ+\u0017/^3tiND3!GA\u0018\u0003u!Xm\u001d;Ti>\u0004(+\u001a9mS\u000e\fwI]8vaN\u0014\u0015P\u0011:pW\u0016\u0014\bf\u0001\u000e\u00020\u0005\u0019D/Z:u'R|\u0007OU3qY&\u001c\u0017mU3oi>sG.\u001f+p\u0019&4X-\u00118e'\",H\u000f^5oO\u0012{wO\u001c\"s_.,'o\u001d\u0015\u00047\u0005=\u0012!\u000b;fgR\u001cFo\u001c9SKBd\u0017nY1J]R,'O\u0011:pW\u0016\u0014\bK]8u_\u000e|GNV3sg&|g\u000eK\u0002\u001d\u0003_\t\u0001\u0007^3tiN#x\u000e\u001d*fa2L7-\u0019$pY2|wo]%oi\u0016\u0014(I]8lKJ\u0004&o\u001c;pG>dg+\u001a:tS>tGCBA\u0014\u0003G\u000b)\u000bC\u0004\u0002Nu\u0001\r!a\u0014\t\u000f\u0005\u001dV\u00041\u0001\u0002`\u0005\tS\r\u001f9fGR,Gm\u0015;paJ+\u0007\u000f\\5dCJ+\u0017/^3tiZ+'o]5p]\u0006\t\u0013\r\u001d9msN#x\u000e\u001d*fa2L7-\u0019*fgB|gn]3DC2d'-Y2lgR1\u0011qEAW\u0003{Cq!a,\u001f\u0001\u0004\t\t,A\u0003feJ|'\u000f\u0005\u0003\u00024\u0006eVBAA[\u0015\r\t9L_\u0001\taJ|Go\\2pY&!\u00111XA[\u0005\u0019)%O]8sg\"9\u0011q\u0018\u0010A\u0002\u0005\u0005\u0017\u0001D:f]R\u0014V-];fgR\u001c\bCBAb\u0003'\fIN\u0004\u0003\u0002F\u0006=g\u0002BAd\u0003\u001bl!!!3\u000b\u0007\u0005-\u0007+\u0001\u0004=e>|GOP\u0005\u0002+&\u0019\u0011\u0011\u001b+\u0002\u000fA\f7m[1hK&!\u0011Q[Al\u0005\u0011a\u0015n\u001d;\u000b\u0007\u0005EG\u000bE\u0002\u0002\\\u000ej\u0011\u0001\u0001\u0002\f'\u0016tGOU3rk\u0016\u001cHo\u0005\u0004$%\u0006\u0005\u0018q\u001d\t\u0004'\u0006\r\u0018bAAs)\n9\u0001K]8ek\u000e$\bcA*\u0002j&\u0019\u00111\u001e+\u0003\u0019M+'/[1mSj\f'\r\\3\u0002\u000fI,\u0017/^3tiV\u0011\u0011\u0011\u001f\t\u0004\u00037T\u0011\u0001\u0003:fcV,7\u000f\u001e\u0011\u0002!I,7\u000f]8og\u0016\u001c\u0015\r\u001c7cC\u000e\\WCAA}!\u001d\u0019\u00161`A\u0000\u0003OI1!!@U\u0005%1UO\\2uS>t\u0017\u0007E\u0002x\u0005\u0003I1Aa\u0001y\u0005A\t%m\u001d;sC\u000e$(+Z:q_:\u001cX-A\tsKN\u0004xN\\:f\u0007\u0006dGNY1dW\u0002\"b!!7\u0003\n\t-\u0001bBAwQ\u0001\u0007\u0011\u0011\u001f\u0005\b\u0003kD\u0003\u0019AA}\u0003\u0011\u0019w\u000e]=\u0015\r\u0005e'\u0011\u0003B\n\u0011%\ti/\u000bI\u0001\u0002\u0004\t\t\u0010C\u0005\u0002v&\u0002\n\u00111\u0001\u0002z\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nTC\u0001B\ra\u0011\u0011YBa\b\u0011\u000bY\f9A!\b\u0011\t\u0005=!q\u0004\u0003\f\u0003'Q\u0013\u0011!A\u0001\u0006\u0003\t)\"\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\t\u0015\"\u0006BA}\u0005OY#A!\u000b\u0011\t\t-\"QG\u0007\u0003\u0005[QAAa\f\u00032\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0005g!\u0016AC1o]>$\u0018\r^5p]&!!q\u0007B\u0017\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\tu\u0002\u0003\u0002B \u0005\u0013j!A!\u0011\u000b\t\t\r#QI\u0001\u0005Y\u0006twM\u0003\u0002\u0003H\u0005!!.\u0019<b\u0013\u0011\u0011YE!\u0011\u0003\rM#(/\u001b8h\u00031\u0001(o\u001c3vGR\f%/\u001b;z\u00039\u0001(o\u001c3vGR,E.Z7f]R$BAa\u0015\u0003ZA\u00191K!\u0016\n\u0007\t]CKA\u0002B]fD\u0001Ba\u0017/\u0003\u0003\u0005\rAX\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\t\u0005\u0004C\u0002B2\u0005S\u0012\u0019&\u0004\u0002\u0003f)\u0019!q\r+\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0003l\t\u0015$\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$BA!\u001d\u0003xA\u00191Ka\u001d\n\u0007\tUDKA\u0004C_>dW-\u00198\t\u0013\tm\u0003'!AA\u0002\tM\u0013\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u0003y\u000b\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0005{\ta!Z9vC2\u001cH\u0003\u0002B9\u0005\u000bC\u0011Ba\u00174\u0003\u0003\u0005\rAa\u0015\u0002E\u0005\u0004\b\u000f\\=MK\u0006$WM]!oI&\u001b(OU3ta>t7/Z\"bY2\u0014\u0017mY6t)\u0019\t9Ca#\u0003\u000e\"9\u0011qV\u0010A\u0002\u0005E\u0006bBA`?\u0001\u0007\u0011\u0011Y\u0001\rGJ,\u0017\r^3D_:4\u0017n\u001a\u000b\u0004M\nM\u0005b\u0002BKA\u0001\u0007\u0011qJ\u0001\u0013S:$XM\u001d\"s_.,'OV3sg&|g.A\tsKBd\u0017nY1BgNLwM\\7f]R$BAa'\u0003\"B\u00191L!(\n\u0007\t}EJA\tSKBd\u0017nY1BgNLwM\\7f]RDqAa)\"\u0001\u0004\u0011)+\u0001\u0005sKBd\u0017nY1t!\u0015\t\u0019Ma*_\u0013\u0011\u0011I+a6\u0003\u0007M+\u0017/A\u0006j]&$8i\u001c8uKb$HC\u0003BX\u0005k\u0013IL!5\u0003VB\u00191L!-\n\u0007\tMFJA\tD_:$(o\u001c7mKJ\u001cuN\u001c;fqRDqAa.#\u0001\u0004\u0011)+A\u0004ce>\\WM]:\t\u000f\tm&\u00051\u0001\u0003>\u00061Ao\u001c9jGN\u0004bAa0\u0003H\n5g\u0002\u0002Ba\u0005\u0007\u00042!a2U\u0013\r\u0011)\rV\u0001\u0007!J,G-\u001a4\n\t\t%'1\u001a\u0002\u0004'\u0016$(b\u0001Bc)B!!q\u0018Bh\u0013\u0011\u0011YEa3\t\r\tM'\u00051\u0001_\u00035qW/\u001c)beRLG/[8og\"1!q\u001b\u0012A\u0002y\u000b\u0011C]3qY&\u001c\u0017\r^5p]\u001a\u000b7\r^8s\u0003-\u0019VM\u001c;SKF,Xm\u001d;\u0011\u0007\u0005mWgE\u00036\u0005?\f9\u000f\u0005\u0006\u0003b\n\u001d\u0018\u0011_A}\u00033l!Aa9\u000b\u0007\t\u0015H+A\u0004sk:$\u0018.\\3\n\t\t%(1\u001d\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:\u0014DC\u0001Bn\u0003\u0015\t\u0007\u000f\u001d7z)\u0019\tIN!=\u0003t\"9\u0011Q\u001e\u001dA\u0002\u0005E\bbBA{q\u0001\u0007\u0011\u0011`\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\u0011Ip!\u0002\u0011\u000bM\u0013YPa@\n\u0007\tuHK\u0001\u0004PaRLwN\u001c\t\b'\u000e\u0005\u0011\u0011_A}\u0013\r\u0019\u0019\u0001\u0016\u0002\u0007)V\u0004H.\u001a\u001a\t\u0013\r\u001d\u0011(!AA\u0002\u0005e\u0017a\u0001=%a\t\u0001Sj\\2l\u0007>tGO]8mY\u0016\u0014(I]8lKJ\u0014V-];fgR\u0014\u0015\r^2i'\rQ4Q\u0002\t\u00047\u000e=\u0011bAB\t\u0019\n!\u0013IY:ue\u0006\u001cGoQ8oiJ|G\u000e\\3s\u0005J|7.\u001a:SKF,Xm\u001d;CCR\u001c\u0007.A\u0004d_:$X\r\u001f;\u0015\r\r]1\u0011DB\u000e!\r\tYN\u000f\u0005\b\u0007'i\u0004\u0019\u0001BX\u0011\u001d!W\b%AA\u0002\u0019\f!b]3oi\u00163XM\u001c;t+\t\u0019\t\u0003\u0005\u0004\u0004$\r%2QF\u0007\u0003\u0007KQAaa\n\u0003f\u00059Q.\u001e;bE2,\u0017\u0002BB\u0016\u0007K\u0011!\u0002T5ti\n+hMZ3s!\rY6qF\u0005\u0004\u0007ca%aD\"p]R\u0014x\u000e\u001c7fe\u00163XM\u001c;\u0002\u0017M,g\u000e^#wK:$8\u000fI\u000b\u0003\u0007o\u0001raa\t\u0004:y\u001bi$\u0003\u0003\u0004<\r\u0015\"aA'baB111EB\u0015\u00033\fQb]3oiJ+\u0017/^3tiN\u0004\u0013!C:f]\u0012,e/\u001a8u)\u0011\t9c!\u0012\t\u000f\r\u001d#\t1\u0001\u0004.\u0005)QM^3oi\u0006Y1/\u001a8e%\u0016\fX/Z:u)!\t9c!\u0014\u0004R\rM\u0003BBB(\u0007\u0002\u0007a,\u0001\u0005ce>\\WM]%e\u0011\u001d\tio\u0011a\u0001\u0003cD\u0011b!\u0016D!\u0003\u0005\r!!?\u0002\u0011\r\fG\u000e\u001c2bG.\fQdY8mY\u0016\u001cGo\u0015;paJ+\u0007\u000f\\5dCJ+\u0017/^3tiN4uN\u001d\u000b\u0005\u00077\u001a\u0019\u0007\u0005\u0004\u0002D\u0006M7Q\f\t\u0004o\u000e}\u0013bAB1q\n\u00112\u000b^8q%\u0016\u0004H.[2b%\u0016\fX/Z:u\u0011\u0019\u0019y\u0005\u0012a\u0001=\u0006\u00013m\u001c7mK\u000e$X\u000b\u001d3bi\u0016lU\r^1eCR\f'+Z9vKN$8OR8s)\u0011\u0019Ig!\u001d\u0011\r\u0005\r\u00171[B6!\r98QN\u0005\u0004\u0007_B(!F+qI\u0006$X-T3uC\u0012\fG/\u0019*fcV,7\u000f\u001e\u0005\u0007\u0007\u001f*\u0005\u0019\u00010\u0002=\r|G\u000e\\3di2+\u0017\rZ3s\u0003:$\u0017j\u001d:SKF,Xm\u001d;t\r>\u0014H\u0003BB<\u0007\u007f\u0002b!a1\u0002T\u000ee\u0004cA<\u0004|%\u00191Q\u0010=\u0003'1+\u0017\rZ3s\u0003:$\u0017j\u001d:SKF,Xm\u001d;\t\r\r=c\t1\u0001_\u0003\u0001junY6D_:$(o\u001c7mKJ\u0014%o\\6feJ+\u0017/^3ti\n\u000bGo\u00195\u0011\u0007\u0005m\u0007j\u0005\u0002I%R\u001111Q\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\r5%f\u00014\u0003(\u0001")
public class ControllerChannelManagerTest {
    private volatile ControllerChannelManagerTest$SentRequest$ SentRequest$module;
    private volatile ControllerChannelManagerTest$MockControllerBrokerRequestBatch$ MockControllerBrokerRequestBatch$module;
    private final int controllerId;
    private final int controllerEpoch;
    private final KafkaConfig kafka$controller$ControllerChannelManagerTest$$config = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(this.controllerId(), "zkConnect", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20()));
    private final StateChangeLogger kafka$controller$ControllerChannelManagerTest$$logger = new StateChangeLogger(this.controllerId(), true, (Option)None$.MODULE$);

    private ControllerChannelManagerTest$SentRequest$ SentRequest() {
        if (this.SentRequest$module == null) {
            this.SentRequest$lzycompute$1();
        }
        return this.SentRequest$module;
    }

    private ControllerChannelManagerTest$MockControllerBrokerRequestBatch$ MockControllerBrokerRequestBatch() {
        if (this.MockControllerBrokerRequestBatch$module == null) {
            this.MockControllerBrokerRequestBatch$lzycompute$1();
        }
        return this.MockControllerBrokerRequestBatch$module;
    }

    private int controllerId() {
        return this.controllerId;
    }

    private int controllerEpoch() {
        return this.controllerEpoch;
    }

    public KafkaConfig kafka$controller$ControllerChannelManagerTest$$config() {
        return this.kafka$controller$ControllerChannelManagerTest$$config;
    }

    public StateChangeLogger kafka$controller$ControllerChannelManagerTest$$logger() {
        return this.kafka$controller$ControllerChannelManagerTest$$logger;
    }

    @Test
    public void testLeaderAndIsrRequestSent() {
        ControllerContext context = this.initContext((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))), (scala.collection.immutable.Set<String>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo", "bar"}))), 2, 3);
        MockControllerBrokerRequestBatch batch = new MockControllerBrokerRequestBatch(context, this.MockControllerBrokerRequestBatch().$lessinit$greater$default$2());
        scala.collection.immutable.Map partitions = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 0)), (Object)LeaderAndIsr$.MODULE$.apply(1, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 1)), (Object)LeaderAndIsr$.MODULE$.apply(2, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("bar", 1)), (Object)LeaderAndIsr$.MODULE$.apply(3, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 3}))))}));
        batch.newBatch();
        partitions.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            ControllerChannelManagerTest.$anonfun$testLeaderAndIsrRequestSent$1(this, context, batch, x0$1);
            return BoxedUnit.UNIT;
        });
        batch.sendRequestsToBrokers(this.controllerEpoch());
        List<LeaderAndIsrRequest> leaderAndIsrRequests = batch.collectLeaderAndIsrRequestsFor(2);
        List<UpdateMetadataRequest> updateMetadataRequests = batch.collectUpdateMetadataRequestsFor(2);
        Assert.assertEquals((long)1L, (long)leaderAndIsrRequests.size());
        Assert.assertEquals((long)1L, (long)updateMetadataRequests.size());
        LeaderAndIsrRequest leaderAndIsrRequest = (LeaderAndIsrRequest)leaderAndIsrRequests.head();
        Assert.assertEquals((long)this.controllerId(), (long)leaderAndIsrRequest.controllerId());
        Assert.assertEquals((long)this.controllerEpoch(), (long)leaderAndIsrRequest.controllerEpoch());
        Assert.assertEquals((Object)partitions.keySet(), (Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(leaderAndIsrRequest.partitionStates()).asScala()).map((Function1 & Serializable & scala.Serializable)p -> new TopicPartition(p.topicName(), p.partitionIndex()), Iterable$.MODULE$.canBuildFrom())).toSet());
        Assert.assertEquals((Object)partitions.map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            TopicPartition k = (TopicPartition)tuple2._1();
            LeaderAndIsr v = (LeaderAndIsr)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)k, (Object)BoxesRunTime.boxToInteger((int)v.leader()));
            return tuple22;
        }, scala.collection.immutable.Map$.MODULE$.canBuildFrom()), (Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(leaderAndIsrRequest.partitionStates()).asScala()).map((Function1 & Serializable & scala.Serializable)p -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(p.topicName(), p.partitionIndex())), (Object)BoxesRunTime.boxToInteger((int)p.leader())), Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()));
        Assert.assertEquals((Object)partitions.map((Function1 & Serializable & scala.Serializable)x0$3 -> {
            Tuple2 tuple2 = x0$3;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            TopicPartition k = (TopicPartition)tuple2._1();
            LeaderAndIsr v = (LeaderAndIsr)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)k, (Object)v.isr());
            return tuple22;
        }, scala.collection.immutable.Map$.MODULE$.canBuildFrom()), (Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(leaderAndIsrRequest.partitionStates()).asScala()).map((Function1 & Serializable & scala.Serializable)p -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(p.topicName(), p.partitionIndex())), JavaConverters$.MODULE$.asScalaBufferConverter(p.isr()).asScala()), Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()));
        this.applyLeaderAndIsrResponseCallbacks(Errors.NONE, (List<SentRequest>)((ListBuffer)batch.sentRequests().apply((Object)BoxesRunTime.boxToInteger((int)2))).toList());
        Assert.assertEquals((long)1L, (long)batch.sentEvents().size());
        ControllerEvent controllerEvent = (ControllerEvent)batch.sentEvents().head();
        if (!(controllerEvent instanceof LeaderAndIsrResponseReceived)) {
            throw new MatchError((Object)controllerEvent);
        }
        LeaderAndIsrResponseReceived leaderAndIsrResponseReceived = (LeaderAndIsrResponseReceived)controllerEvent;
        AbstractResponse response = leaderAndIsrResponseReceived.LeaderAndIsrResponseObj();
        int brokerId = leaderAndIsrResponseReceived.brokerId();
        Tuple2 tuple2 = new Tuple2((Object)response, (Object)BoxesRunTime.boxToInteger((int)brokerId));
        Tuple2 tuple22 = tuple2;
        AbstractResponse response2 = (AbstractResponse)tuple22._1();
        int brokerId2 = tuple22._2$mcI$sp();
        LeaderAndIsrResponse leaderAndIsrResponse = (LeaderAndIsrResponse)response2;
        Assert.assertEquals((long)2L, (long)brokerId2);
        Assert.assertEquals((Object)partitions.keySet(), (Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(leaderAndIsrResponse.partitions()).asScala()).map((Function1 & Serializable & scala.Serializable)p -> new TopicPartition(p.topicName(), p.partitionIndex()), Buffer$.MODULE$.canBuildFrom())).toSet());
    }

    @Test
    public void testLeaderAndIsrRequestIsNew() {
        ControllerContext context = this.initContext((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))), (scala.collection.immutable.Set<String>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo", "bar"}))), 2, 3);
        MockControllerBrokerRequestBatch batch = new MockControllerBrokerRequestBatch(context, this.MockControllerBrokerRequestBatch().$lessinit$greater$default$2());
        TopicPartition partition = new TopicPartition("foo", 0);
        LeaderAndIsr leaderAndIsr = LeaderAndIsr$.MODULE$.apply(1, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})));
        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(leaderAndIsr, this.controllerEpoch());
        context.partitionLeadershipInfo().put((Object)partition, (Object)leaderIsrAndControllerEpoch);
        batch.newBatch();
        batch.addLeaderAndIsrRequestForBrokers((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})), partition, leaderIsrAndControllerEpoch, this.replicaAssignment((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})))), true);
        batch.addLeaderAndIsrRequestForBrokers((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})), partition, leaderIsrAndControllerEpoch, this.replicaAssignment((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})))), false);
        batch.sendRequestsToBrokers(this.controllerEpoch());
        List<LeaderAndIsrRequest> leaderAndIsrRequests = batch.collectLeaderAndIsrRequestsFor(2);
        List<UpdateMetadataRequest> updateMetadataRequests = batch.collectUpdateMetadataRequestsFor(2);
        Assert.assertEquals((long)1L, (long)leaderAndIsrRequests.size());
        Assert.assertEquals((long)1L, (long)updateMetadataRequests.size());
        LeaderAndIsrRequest leaderAndIsrRequest = (LeaderAndIsrRequest)leaderAndIsrRequests.head();
        Iterable partitionStates = (Iterable)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(leaderAndIsrRequest.partitionStates()).asScala();
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partition})), (Object)partitionStates.map((Function1 & Serializable & scala.Serializable)p -> new TopicPartition(p.topicName(), p.partitionIndex()), Iterable$.MODULE$.canBuildFrom()));
        Option partitionState = partitionStates.find((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)ControllerChannelManagerTest.$anonfun$testLeaderAndIsrRequestIsNew$2(partition, p)));
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToBoolean((boolean)true)), (Object)partitionState.map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.isNew())));
    }

    @Test
    public void testLeaderAndIsrRequestSentToLiveOrShuttingDownBrokers() {
        ControllerContext context = this.initContext((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))), (scala.collection.immutable.Set<String>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo", "bar"}))), 2, 3);
        MockControllerBrokerRequestBatch batch = new MockControllerBrokerRequestBatch(context, this.MockControllerBrokerRequestBatch().$lessinit$greater$default$2());
        context.shuttingDownBrokerIds().add((Object)BoxesRunTime.boxToInteger((int)2));
        context.removeLiveBrokers((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3})));
        TopicPartition partition = new TopicPartition("foo", 0);
        LeaderAndIsr leaderAndIsr = LeaderAndIsr$.MODULE$.apply(1, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})));
        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(leaderAndIsr, this.controllerEpoch());
        context.partitionLeadershipInfo().put((Object)partition, (Object)leaderIsrAndControllerEpoch);
        batch.newBatch();
        batch.addLeaderAndIsrRequestForBrokers((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), partition, leaderIsrAndControllerEpoch, this.replicaAssignment((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})))), false);
        batch.sendRequestsToBrokers(this.controllerEpoch());
        Assert.assertEquals((long)0L, (long)batch.sentEvents().size());
        Assert.assertEquals((long)2L, (long)batch.sentRequests().size());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})), (Object)batch.sentRequests().keySet());
        ((IterableLike)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2}))).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)brokerId -> {
            List<LeaderAndIsrRequest> leaderAndIsrRequests = batch.collectLeaderAndIsrRequestsFor(brokerId);
            List<UpdateMetadataRequest> updateMetadataRequests = batch.collectUpdateMetadataRequestsFor(brokerId);
            Assert.assertEquals((long)1L, (long)leaderAndIsrRequests.size());
            Assert.assertEquals((long)1L, (long)updateMetadataRequests.size());
            LeaderAndIsrRequest leaderAndIsrRequest = (LeaderAndIsrRequest)leaderAndIsrRequests.head();
            Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partition})), (Object)((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(leaderAndIsrRequest.partitionStates()).asScala()).map((Function1 & Serializable & scala.Serializable)p -> new TopicPartition(p.topicName(), p.partitionIndex()), Iterable$.MODULE$.canBuildFrom()));
        });
    }

    @Test
    public void testLeaderAndIsrInterBrokerProtocolVersion() {
        this.testLeaderAndIsrRequestFollowsInterBrokerProtocolVersion(ApiVersion$.MODULE$.latestVersion(), ApiKeys.LEADER_AND_ISR.latestVersion());
        ApiVersion$.MODULE$.allVersions().foreach((Function1 & Serializable & scala.Serializable)apiVersion -> {
            ControllerChannelManagerTest.$anonfun$testLeaderAndIsrInterBrokerProtocolVersion$1(this, apiVersion);
            return BoxedUnit.UNIT;
        });
    }

    private void testLeaderAndIsrRequestFollowsInterBrokerProtocolVersion(ApiVersion interBrokerProtocolVersion, short expectedLeaderAndIsrVersion) {
        ControllerContext context = this.initContext((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))), (scala.collection.immutable.Set<String>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo", "bar"}))), 2, 3);
        KafkaConfig config = this.createConfig(interBrokerProtocolVersion);
        MockControllerBrokerRequestBatch batch = new MockControllerBrokerRequestBatch(context, config);
        TopicPartition partition = new TopicPartition("foo", 0);
        LeaderAndIsr leaderAndIsr = LeaderAndIsr$.MODULE$.apply(1, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})));
        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(leaderAndIsr, this.controllerEpoch());
        context.partitionLeadershipInfo().put((Object)partition, (Object)leaderIsrAndControllerEpoch);
        batch.newBatch();
        batch.addLeaderAndIsrRequestForBrokers((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})), partition, leaderIsrAndControllerEpoch, this.replicaAssignment((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})))), false);
        batch.sendRequestsToBrokers(this.controllerEpoch());
        List<LeaderAndIsrRequest> leaderAndIsrRequests = batch.collectLeaderAndIsrRequestsFor(2);
        Assert.assertEquals((long)1L, (long)leaderAndIsrRequests.size());
        Assert.assertEquals((String)new StringBuilder(24).append("IBP ").append(interBrokerProtocolVersion).append(" should use version ").append(expectedLeaderAndIsrVersion).toString(), (long)expectedLeaderAndIsrVersion, (long)((AbstractRequest)leaderAndIsrRequests.head()).version());
    }

    @Test
    public void testUpdateMetadataRequestSent() {
        ControllerContext context = this.initContext((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))), (scala.collection.immutable.Set<String>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo", "bar"}))), 2, 3);
        MockControllerBrokerRequestBatch batch = new MockControllerBrokerRequestBatch(context, this.MockControllerBrokerRequestBatch().$lessinit$greater$default$2());
        scala.collection.immutable.Map partitions = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 0)), (Object)LeaderAndIsr$.MODULE$.apply(1, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 1)), (Object)LeaderAndIsr$.MODULE$.apply(2, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("bar", 1)), (Object)LeaderAndIsr$.MODULE$.apply(3, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 3}))))}));
        partitions.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            TopicPartition partition = (TopicPartition)tuple2._1();
            LeaderAndIsr leaderAndIsr = (LeaderAndIsr)tuple2._2();
            Option option = context.partitionLeadershipInfo().put((Object)partition, (Object)new LeaderIsrAndControllerEpoch(leaderAndIsr, this.controllerEpoch()));
            return option;
        });
        batch.newBatch();
        batch.addUpdateMetadataRequestForBrokers((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})), (Set)partitions.keySet());
        batch.sendRequestsToBrokers(this.controllerEpoch());
        List<UpdateMetadataRequest> updateMetadataRequests = batch.collectUpdateMetadataRequestsFor(2);
        Assert.assertEquals((long)1L, (long)updateMetadataRequests.size());
        UpdateMetadataRequest updateMetadataRequest = (UpdateMetadataRequest)updateMetadataRequests.head();
        Buffer partitionStates = ((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(updateMetadataRequest.partitionStates()).asScala()).toBuffer();
        Assert.assertEquals((long)3L, (long)partitionStates.size());
        Assert.assertEquals((Object)partitions.map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            TopicPartition k = (TopicPartition)tuple2._1();
            LeaderAndIsr v = (LeaderAndIsr)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)k, (Object)BoxesRunTime.boxToInteger((int)v.leader()));
            return tuple22;
        }, scala.collection.immutable.Map$.MODULE$.canBuildFrom()), (Object)((TraversableOnce)partitionStates.map((Function1 & Serializable & scala.Serializable)ps -> new Tuple2((Object)new TopicPartition(ps.topicName(), ps.partitionIndex()), (Object)BoxesRunTime.boxToInteger((int)ps.leader())), Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()));
        Assert.assertEquals((Object)partitions.map((Function1 & Serializable & scala.Serializable)x0$3 -> {
            Tuple2 tuple2 = x0$3;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            TopicPartition k = (TopicPartition)tuple2._1();
            LeaderAndIsr v = (LeaderAndIsr)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)k, (Object)v.isr());
            return tuple22;
        }, scala.collection.immutable.Map$.MODULE$.canBuildFrom()), (Object)((TraversableOnce)partitionStates.map((Function1 & Serializable & scala.Serializable)ps -> new Tuple2((Object)new TopicPartition(ps.topicName(), ps.partitionIndex()), JavaConverters$.MODULE$.asScalaBufferConverter(ps.isr()).asScala()), Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()));
        Assert.assertEquals((long)this.controllerId(), (long)updateMetadataRequest.controllerId());
        Assert.assertEquals((long)this.controllerEpoch(), (long)updateMetadataRequest.controllerEpoch());
        Assert.assertEquals((long)3L, (long)updateMetadataRequest.liveBrokers().size());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(updateMetadataRequest.liveBrokers()).asScala()).map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToInteger((int)x$3.id()), Buffer$.MODULE$.canBuildFrom())).toSet());
    }

    @Test
    public void testUpdateMetadataDoesNotIncludePartitionsWithoutLeaderAndIsr() {
        ControllerContext context = this.initContext((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))), (scala.collection.immutable.Set<String>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo", "bar"}))), 2, 3);
        MockControllerBrokerRequestBatch batch = new MockControllerBrokerRequestBatch(context, this.MockControllerBrokerRequestBatch().$lessinit$greater$default$2());
        scala.collection.immutable.Set partitions = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("foo", 0), new TopicPartition("foo", 1), new TopicPartition("bar", 1)}));
        batch.newBatch();
        batch.addUpdateMetadataRequestForBrokers((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})), (Set)partitions);
        batch.sendRequestsToBrokers(this.controllerEpoch());
        Assert.assertEquals((long)0L, (long)batch.sentEvents().size());
        Assert.assertEquals((long)1L, (long)batch.sentRequests().size());
        Assert.assertTrue((boolean)batch.sentRequests().contains((Object)BoxesRunTime.boxToInteger((int)2)));
        List<UpdateMetadataRequest> updateMetadataRequests = batch.collectUpdateMetadataRequestsFor(2);
        Assert.assertEquals((long)1L, (long)updateMetadataRequests.size());
        UpdateMetadataRequest updateMetadataRequest = (UpdateMetadataRequest)updateMetadataRequests.head();
        Assert.assertEquals((long)0L, (long)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(updateMetadataRequest.partitionStates()).asScala()).size());
        Assert.assertEquals((long)3L, (long)updateMetadataRequest.liveBrokers().size());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(updateMetadataRequest.liveBrokers()).asScala()).map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToInteger((int)x$4.id()), Buffer$.MODULE$.canBuildFrom())).toSet());
    }

    @Test
    public void testUpdateMetadataRequestDuringTopicDeletion() {
        ControllerContext context = this.initContext((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))), (scala.collection.immutable.Set<String>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo", "bar"}))), 2, 3);
        MockControllerBrokerRequestBatch batch = new MockControllerBrokerRequestBatch(context, this.MockControllerBrokerRequestBatch().$lessinit$greater$default$2());
        scala.collection.immutable.Map partitions = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 0)), (Object)LeaderAndIsr$.MODULE$.apply(1, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 1)), (Object)LeaderAndIsr$.MODULE$.apply(2, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("bar", 1)), (Object)LeaderAndIsr$.MODULE$.apply(3, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 3}))))}));
        partitions.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            TopicPartition partition = (TopicPartition)tuple2._1();
            LeaderAndIsr leaderAndIsr = (LeaderAndIsr)tuple2._2();
            Option option = context.partitionLeadershipInfo().put((Object)partition, (Object)new LeaderIsrAndControllerEpoch(leaderAndIsr, this.controllerEpoch()));
            return option;
        });
        context.queueTopicDeletion((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo"})));
        batch.newBatch();
        batch.addUpdateMetadataRequestForBrokers((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})), (Set)partitions.keySet());
        batch.sendRequestsToBrokers(this.controllerEpoch());
        List<UpdateMetadataRequest> updateMetadataRequests = batch.collectUpdateMetadataRequestsFor(2);
        Assert.assertEquals((long)1L, (long)updateMetadataRequests.size());
        UpdateMetadataRequest updateMetadataRequest = (UpdateMetadataRequest)updateMetadataRequests.head();
        Assert.assertEquals((long)3L, (long)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(updateMetadataRequest.partitionStates()).asScala()).size());
        Assert.assertTrue((boolean)((IterableLike)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(updateMetadataRequest.partitionStates()).asScala()).filter((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)ControllerChannelManagerTest.$anonfun$testUpdateMetadataRequestDuringTopicDeletion$2(x$5)))).map((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToInteger((int)x$6.leader()), Iterable$.MODULE$.canBuildFrom())).forall((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)leaderId -> leaderId == LeaderAndIsr$.MODULE$.LeaderDuringDelete()));
        Assert.assertEquals((Object)((TraversableLike)partitions.filter((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)ControllerChannelManagerTest.$anonfun$testUpdateMetadataRequestDuringTopicDeletion$5(x0$2)))).map((Function1 & Serializable & scala.Serializable)x0$3 -> {
            Tuple2 tuple2 = x0$3;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            TopicPartition k = (TopicPartition)tuple2._1();
            LeaderAndIsr v = (LeaderAndIsr)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)k, (Object)BoxesRunTime.boxToInteger((int)v.leader()));
            return tuple22;
        }, scala.collection.immutable.Map$.MODULE$.canBuildFrom()), (Object)((TraversableOnce)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(updateMetadataRequest.partitionStates()).asScala()).filter((Function1 & Serializable & scala.Serializable)ps -> BoxesRunTime.boxToBoolean((boolean)ControllerChannelManagerTest.$anonfun$testUpdateMetadataRequestDuringTopicDeletion$7(ps)))).map((Function1 & Serializable & scala.Serializable)ps -> new Tuple2((Object)new TopicPartition(ps.topicName(), ps.partitionIndex()), (Object)BoxesRunTime.boxToInteger((int)ps.leader())), Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()));
        Assert.assertEquals((Object)partitions.map((Function1 & Serializable & scala.Serializable)x0$4 -> {
            Tuple2 tuple2 = x0$4;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            TopicPartition k = (TopicPartition)tuple2._1();
            LeaderAndIsr v = (LeaderAndIsr)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)k, (Object)v.isr());
            return tuple22;
        }, scala.collection.immutable.Map$.MODULE$.canBuildFrom()), (Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(updateMetadataRequest.partitionStates()).asScala()).map((Function1 & Serializable & scala.Serializable)ps -> new Tuple2((Object)new TopicPartition(ps.topicName(), ps.partitionIndex()), JavaConverters$.MODULE$.asScalaBufferConverter(ps.isr()).asScala()), Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()));
        Assert.assertEquals((long)3L, (long)updateMetadataRequest.liveBrokers().size());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(updateMetadataRequest.liveBrokers()).asScala()).map((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToInteger((int)x$7.id()), Buffer$.MODULE$.canBuildFrom())).toSet());
    }

    @Test
    public void testUpdateMetadataIncludesLiveOrShuttingDownBrokers() {
        ControllerContext context = this.initContext((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))), (scala.collection.immutable.Set<String>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo", "bar"}))), 2, 3);
        MockControllerBrokerRequestBatch batch = new MockControllerBrokerRequestBatch(context, this.MockControllerBrokerRequestBatch().$lessinit$greater$default$2());
        context.shuttingDownBrokerIds().add((Object)BoxesRunTime.boxToInteger((int)2));
        context.removeLiveBrokers((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3})));
        batch.newBatch();
        batch.addUpdateMetadataRequestForBrokers((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Set)Predef$.MODULE$.Set().empty());
        batch.sendRequestsToBrokers(this.controllerEpoch());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})), (Object)batch.sentRequests().keySet());
        ((IterableLike)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2}))).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)brokerId -> {
            List<UpdateMetadataRequest> updateMetadataRequests = batch.collectUpdateMetadataRequestsFor(brokerId);
            Assert.assertEquals((long)1L, (long)updateMetadataRequests.size());
            UpdateMetadataRequest updateMetadataRequest = (UpdateMetadataRequest)updateMetadataRequests.head();
            Assert.assertEquals((long)0L, (long)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(updateMetadataRequest.partitionStates()).asScala()).size());
            Assert.assertEquals((long)2L, (long)updateMetadataRequest.liveBrokers().size());
            Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})), (Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(updateMetadataRequest.liveBrokers()).asScala()).map((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToInteger((int)x$8.id()), Buffer$.MODULE$.canBuildFrom())).toSet());
        });
    }

    @Test
    public void testUpdateMetadataInterBrokerProtocolVersion() {
        this.testUpdateMetadataFollowsInterBrokerProtocolVersion(ApiVersion$.MODULE$.latestVersion(), ApiKeys.UPDATE_METADATA.latestVersion());
        ApiVersion$.MODULE$.allVersions().foreach((Function1 & Serializable & scala.Serializable)apiVersion -> {
            ControllerChannelManagerTest.$anonfun$testUpdateMetadataInterBrokerProtocolVersion$1(this, apiVersion);
            return BoxedUnit.UNIT;
        });
    }

    private void testUpdateMetadataFollowsInterBrokerProtocolVersion(ApiVersion interBrokerProtocolVersion, short expectedUpdateMetadataVersion) {
        ControllerContext context = this.initContext((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))), (scala.collection.immutable.Set<String>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo", "bar"}))), 2, 3);
        KafkaConfig config = this.createConfig(interBrokerProtocolVersion);
        MockControllerBrokerRequestBatch batch = new MockControllerBrokerRequestBatch(context, config);
        batch.newBatch();
        batch.addUpdateMetadataRequestForBrokers((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})), (Set)Predef$.MODULE$.Set().empty());
        batch.sendRequestsToBrokers(this.controllerEpoch());
        Assert.assertEquals((long)0L, (long)batch.sentEvents().size());
        Assert.assertEquals((long)1L, (long)batch.sentRequests().size());
        Assert.assertTrue((boolean)batch.sentRequests().contains((Object)BoxesRunTime.boxToInteger((int)2)));
        List<UpdateMetadataRequest> requests = batch.collectUpdateMetadataRequestsFor(2);
        List allVersions = (List)requests.map((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToShort((short)x$9.version()), List$.MODULE$.canBuildFrom());
        Assert.assertTrue((String)new StringBuilder(45).append("IBP ").append(interBrokerProtocolVersion).append(" should use version ").append(expectedUpdateMetadataVersion).append(", ").append("but found versions ").append(allVersions).toString(), (boolean)allVersions.forall((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)ControllerChannelManagerTest.$anonfun$testUpdateMetadataFollowsInterBrokerProtocolVersion$2(expectedUpdateMetadataVersion, BoxesRunTime.unboxToShort((Object)x$10)))));
    }

    @Test
    public void testStopReplicaRequestSent() {
        ControllerContext context = this.initContext((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))), (scala.collection.immutable.Set<String>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo", "bar"}))), 2, 3);
        MockControllerBrokerRequestBatch batch = new MockControllerBrokerRequestBatch(context, this.MockControllerBrokerRequestBatch().$lessinit$greater$default$2());
        scala.collection.immutable.Set partitions = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("foo", 0), new TopicPartition("foo", 1), new TopicPartition("bar", 1)}));
        batch.newBatch();
        partitions.foreach((Function1 & Serializable & scala.Serializable)partition -> {
            batch.addStopReplicaRequestForBrokers((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})), partition, false);
            return BoxedUnit.UNIT;
        });
        batch.sendRequestsToBrokers(this.controllerEpoch());
        Assert.assertEquals((long)0L, (long)batch.sentEvents().size());
        Assert.assertEquals((long)1L, (long)batch.sentRequests().size());
        Assert.assertTrue((boolean)batch.sentRequests().contains((Object)BoxesRunTime.boxToInteger((int)2)));
        ListBuffer sentRequests = (ListBuffer)batch.sentRequests().apply((Object)BoxesRunTime.boxToInteger((int)2));
        Assert.assertEquals((long)1L, (long)sentRequests.size());
        List<StopReplicaRequest> sentStopReplicaRequests = batch.collectStopReplicaRequestsFor(2);
        Assert.assertEquals((long)1L, (long)sentStopReplicaRequests.size());
        StopReplicaRequest stopReplicaRequest = (StopReplicaRequest)sentStopReplicaRequests.head();
        Assert.assertFalse((boolean)stopReplicaRequest.deletePartitions());
        Assert.assertEquals((Object)partitions, (Object)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(stopReplicaRequest.partitions()).asScala()).toSet());
        this.applyStopReplicaResponseCallbacks(Errors.NONE, (List<SentRequest>)((ListBuffer)batch.sentRequests().apply((Object)BoxesRunTime.boxToInteger((int)2))).toList());
        Assert.assertEquals((long)0L, (long)batch.sentEvents().size());
    }

    @Test
    public void testStopReplicaRequestsWhileTopicQueuedForDeletion() {
        ControllerContext context = this.initContext((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))), (scala.collection.immutable.Set<String>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo", "bar"}))), 2, 3);
        MockControllerBrokerRequestBatch batch = new MockControllerBrokerRequestBatch(context, this.MockControllerBrokerRequestBatch().$lessinit$greater$default$2());
        scala.collection.immutable.Set partitions = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("foo", 0), new TopicPartition("foo", 1), new TopicPartition("bar", 1)}));
        context.queueTopicDeletion((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo"})));
        batch.newBatch();
        partitions.foreach((Function1 & Serializable & scala.Serializable)partition -> {
            batch.addStopReplicaRequestForBrokers((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})), partition, true);
            return BoxedUnit.UNIT;
        });
        batch.sendRequestsToBrokers(this.controllerEpoch());
        Assert.assertEquals((long)0L, (long)batch.sentEvents().size());
        Assert.assertEquals((long)1L, (long)batch.sentRequests().size());
        Assert.assertTrue((boolean)batch.sentRequests().contains((Object)BoxesRunTime.boxToInteger((int)2)));
        ListBuffer sentRequests = (ListBuffer)batch.sentRequests().apply((Object)BoxesRunTime.boxToInteger((int)2));
        Assert.assertEquals((long)1L, (long)sentRequests.size());
        List<StopReplicaRequest> sentStopReplicaRequests = batch.collectStopReplicaRequestsFor(2);
        Assert.assertEquals((long)1L, (long)sentStopReplicaRequests.size());
        Assert.assertEquals((Object)partitions, (Object)((TraversableOnce)sentStopReplicaRequests.flatMap((Function1 & Serializable & scala.Serializable)x$11 -> (Iterable)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(x$11.partitions()).asScala(), List$.MODULE$.canBuildFrom())).toSet());
        Assert.assertTrue((boolean)sentStopReplicaRequests.forall((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)x$12.deletePartitions())));
        this.applyStopReplicaResponseCallbacks(Errors.NONE, (List<SentRequest>)((ListBuffer)batch.sentRequests().apply((Object)BoxesRunTime.boxToInteger((int)2))).toList());
        Assert.assertEquals((long)0L, (long)batch.sentEvents().size());
    }

    @Test
    public void testStopReplicaRequestsWhileTopicDeletionStarted() {
        ControllerContext context = this.initContext((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))), (scala.collection.immutable.Set<String>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo", "bar"}))), 2, 3);
        MockControllerBrokerRequestBatch batch = new MockControllerBrokerRequestBatch(context, this.MockControllerBrokerRequestBatch().$lessinit$greater$default$2());
        scala.collection.immutable.Set partitions = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("foo", 0), new TopicPartition("foo", 1), new TopicPartition("bar", 1)}));
        context.queueTopicDeletion((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo"})));
        context.beginTopicDeletion((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo"})));
        batch.newBatch();
        partitions.foreach((Function1 & Serializable & scala.Serializable)partition -> {
            batch.addStopReplicaRequestForBrokers((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})), partition, true);
            return BoxedUnit.UNIT;
        });
        batch.sendRequestsToBrokers(this.controllerEpoch());
        Assert.assertEquals((long)0L, (long)batch.sentEvents().size());
        Assert.assertEquals((long)1L, (long)batch.sentRequests().size());
        Assert.assertTrue((boolean)batch.sentRequests().contains((Object)BoxesRunTime.boxToInteger((int)2)));
        ListBuffer sentRequests = (ListBuffer)batch.sentRequests().apply((Object)BoxesRunTime.boxToInteger((int)2));
        Assert.assertEquals((long)1L, (long)sentRequests.size());
        List<StopReplicaRequest> sentStopReplicaRequests = batch.collectStopReplicaRequestsFor(2);
        Assert.assertEquals((long)1L, (long)sentStopReplicaRequests.size());
        Assert.assertEquals((Object)partitions, (Object)((TraversableOnce)sentStopReplicaRequests.flatMap((Function1 & Serializable & scala.Serializable)x$13 -> (Iterable)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(x$13.partitions()).asScala(), List$.MODULE$.canBuildFrom())).toSet());
        Assert.assertTrue((boolean)sentStopReplicaRequests.forall((Function1 & Serializable & scala.Serializable)x$14 -> BoxesRunTime.boxToBoolean((boolean)x$14.deletePartitions())));
        this.applyStopReplicaResponseCallbacks(Errors.NONE, (List<SentRequest>)((ListBuffer)batch.sentRequests().apply((Object)BoxesRunTime.boxToInteger((int)2))).toList());
        Assert.assertEquals((long)1L, (long)batch.sentEvents().size());
        scala.collection.immutable.Set includedPartitions = ((TraversableForwarder)batch.sentEvents().flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            ControllerEvent controllerEvent = x0$1;
            if (!(controllerEvent instanceof TopicDeletionStopReplicaResponseReceived)) {
                throw Assertions$.MODULE$.fail(new StringBuilder(23).append("Unexpected sent event: ").append(controllerEvent).toString(), new Position("ControllerChannelManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 475));
            }
            TopicDeletionStopReplicaResponseReceived topicDeletionStopReplicaResponseReceived = (TopicDeletionStopReplicaResponseReceived)controllerEvent;
            Set set = topicDeletionStopReplicaResponseReceived.partitionErrors().keySet();
            return set;
        }, ListBuffer$.MODULE$.canBuildFrom())).toSet();
        Assert.assertEquals((Object)partitions.filter((Function1 & Serializable & scala.Serializable)x$15 -> BoxesRunTime.boxToBoolean((boolean)ControllerChannelManagerTest.$anonfun$testStopReplicaRequestsWhileTopicDeletionStarted$5(x$15))), (Object)includedPartitions);
    }

    @Test
    public void testMixedDeleteAndNotDeleteStopReplicaRequests() {
        ControllerContext context = this.initContext((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))), (scala.collection.immutable.Set<String>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo", "bar"}))), 2, 3);
        MockControllerBrokerRequestBatch batch = new MockControllerBrokerRequestBatch(context, this.MockControllerBrokerRequestBatch().$lessinit$greater$default$2());
        scala.collection.immutable.Set deletePartitions = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("foo", 0), new TopicPartition("foo", 1)}));
        scala.collection.immutable.Set nonDeletePartitions = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("bar", 0), new TopicPartition("bar", 1)}));
        batch.newBatch();
        deletePartitions.foreach((Function1 & Serializable & scala.Serializable)partition -> {
            batch.addStopReplicaRequestForBrokers((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})), partition, true);
            return BoxedUnit.UNIT;
        });
        nonDeletePartitions.foreach((Function1 & Serializable & scala.Serializable)partition -> {
            batch.addStopReplicaRequestForBrokers((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})), partition, false);
            return BoxedUnit.UNIT;
        });
        batch.sendRequestsToBrokers(this.controllerEpoch());
        Assert.assertEquals((long)0L, (long)batch.sentEvents().size());
        Assert.assertEquals((long)1L, (long)batch.sentRequests().size());
        Assert.assertTrue((boolean)batch.sentRequests().contains((Object)BoxesRunTime.boxToInteger((int)2)));
        ListBuffer sentRequests = (ListBuffer)batch.sentRequests().apply((Object)BoxesRunTime.boxToInteger((int)2));
        Assert.assertEquals((long)2L, (long)sentRequests.size());
        List<StopReplicaRequest> sentStopReplicaRequests = batch.collectStopReplicaRequestsFor(2);
        Assert.assertEquals((long)2L, (long)sentStopReplicaRequests.size());
        Tuple2 tuple2 = sentStopReplicaRequests.partition((Function1 & Serializable & scala.Serializable)x$16 -> BoxesRunTime.boxToBoolean((boolean)x$16.deletePartitions()));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        List deleteRequests = (List)tuple2._1();
        List nonDeleteRequests = (List)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)deleteRequests, (Object)nonDeleteRequests);
        Tuple2 tuple23 = tuple22;
        List deleteRequests2 = (List)tuple23._1();
        List nonDeleteRequests2 = (List)tuple23._2();
        Assert.assertEquals((long)1L, (long)deleteRequests2.size());
        Assert.assertEquals((Object)deletePartitions, (Object)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(((StopReplicaRequest)deleteRequests2.head()).partitions()).asScala()).toSet());
        Assert.assertEquals((long)1L, (long)nonDeleteRequests2.size());
        Assert.assertEquals((Object)nonDeletePartitions, (Object)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(((StopReplicaRequest)nonDeleteRequests2.head()).partitions()).asScala()).toSet());
    }

    @Test
    public void testStopReplicaGroupsByBroker() {
        ControllerContext context = this.initContext((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))), (scala.collection.immutable.Set<String>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo", "bar"}))), 2, 3);
        MockControllerBrokerRequestBatch batch = new MockControllerBrokerRequestBatch(context, this.MockControllerBrokerRequestBatch().$lessinit$greater$default$2());
        scala.collection.immutable.Set partitions = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("foo", 0), new TopicPartition("foo", 1), new TopicPartition("bar", 1)}));
        batch.newBatch();
        partitions.foreach((Function1 & Serializable & scala.Serializable)partition -> {
            batch.addStopReplicaRequestForBrokers((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})), partition, false);
            return BoxedUnit.UNIT;
        });
        batch.sendRequestsToBrokers(this.controllerEpoch());
        Assert.assertEquals((long)0L, (long)batch.sentEvents().size());
        Assert.assertEquals((long)2L, (long)batch.sentRequests().size());
        Assert.assertTrue((boolean)batch.sentRequests().contains((Object)BoxesRunTime.boxToInteger((int)2)));
        Assert.assertTrue((boolean)batch.sentRequests().contains((Object)BoxesRunTime.boxToInteger((int)3)));
        ListBuffer sentRequests = (ListBuffer)batch.sentRequests().apply((Object)BoxesRunTime.boxToInteger((int)2));
        Assert.assertEquals((long)1L, (long)sentRequests.size());
        ((IterableLike)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3}))).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)brokerId -> {
            List<StopReplicaRequest> sentStopReplicaRequests = batch.collectStopReplicaRequestsFor(brokerId);
            Assert.assertEquals((long)1L, (long)sentStopReplicaRequests.size());
            StopReplicaRequest stopReplicaRequest = (StopReplicaRequest)sentStopReplicaRequests.head();
            Assert.assertFalse((boolean)stopReplicaRequest.deletePartitions());
            Assert.assertEquals((Object)partitions, (Object)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(stopReplicaRequest.partitions()).asScala()).toSet());
            this.applyStopReplicaResponseCallbacks(Errors.NONE, (List<SentRequest>)((ListBuffer)batch.sentRequests().apply((Object)BoxesRunTime.boxToInteger((int)2))).toList());
            Assert.assertEquals((long)0L, (long)batch.sentEvents().size());
        });
    }

    @Test
    public void testStopReplicaSentOnlyToLiveAndShuttingDownBrokers() {
        ControllerContext context = this.initContext((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))), (scala.collection.immutable.Set<String>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo", "bar"}))), 2, 3);
        MockControllerBrokerRequestBatch batch = new MockControllerBrokerRequestBatch(context, this.MockControllerBrokerRequestBatch().$lessinit$greater$default$2());
        context.shuttingDownBrokerIds().add((Object)BoxesRunTime.boxToInteger((int)2));
        context.removeLiveBrokers((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3})));
        scala.collection.immutable.Set partitions = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("foo", 0), new TopicPartition("foo", 1), new TopicPartition("bar", 1)}));
        batch.newBatch();
        partitions.foreach((Function1 & Serializable & scala.Serializable)partition -> {
            batch.addStopReplicaRequestForBrokers((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})), partition, false);
            return BoxedUnit.UNIT;
        });
        batch.sendRequestsToBrokers(this.controllerEpoch());
        Assert.assertEquals((long)0L, (long)batch.sentEvents().size());
        Assert.assertEquals((long)1L, (long)batch.sentRequests().size());
        Assert.assertTrue((boolean)batch.sentRequests().contains((Object)BoxesRunTime.boxToInteger((int)2)));
        ListBuffer sentRequests = (ListBuffer)batch.sentRequests().apply((Object)BoxesRunTime.boxToInteger((int)2));
        Assert.assertEquals((long)1L, (long)sentRequests.size());
        List<StopReplicaRequest> sentStopReplicaRequests = batch.collectStopReplicaRequestsFor(2);
        Assert.assertEquals((long)1L, (long)sentStopReplicaRequests.size());
        StopReplicaRequest stopReplicaRequest = (StopReplicaRequest)sentStopReplicaRequests.head();
        Assert.assertFalse((boolean)stopReplicaRequest.deletePartitions());
        Assert.assertEquals((Object)partitions, (Object)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(stopReplicaRequest.partitions()).asScala()).toSet());
    }

    @Test
    public void testStopReplicaInterBrokerProtocolVersion() {
        this.testStopReplicaFollowsInterBrokerProtocolVersion(ApiVersion$.MODULE$.latestVersion(), ApiKeys.STOP_REPLICA.latestVersion());
        ApiVersion$.MODULE$.allVersions().foreach((Function1 & Serializable & scala.Serializable)apiVersion -> {
            ControllerChannelManagerTest.$anonfun$testStopReplicaInterBrokerProtocolVersion$1(this, apiVersion);
            return BoxedUnit.UNIT;
        });
    }

    private void testStopReplicaFollowsInterBrokerProtocolVersion(ApiVersion interBrokerProtocolVersion, short expectedStopReplicaRequestVersion) {
        ControllerContext context = this.initContext((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))), (scala.collection.immutable.Set<String>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo"}))), 2, 3);
        KafkaConfig config = this.createConfig(interBrokerProtocolVersion);
        MockControllerBrokerRequestBatch batch = new MockControllerBrokerRequestBatch(context, config);
        TopicPartition partition = new TopicPartition("foo", 0);
        batch.newBatch();
        batch.addStopReplicaRequestForBrokers((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})), partition, false);
        batch.sendRequestsToBrokers(this.controllerEpoch());
        Assert.assertEquals((long)0L, (long)batch.sentEvents().size());
        Assert.assertEquals((long)1L, (long)batch.sentRequests().size());
        Assert.assertTrue((boolean)batch.sentRequests().contains((Object)BoxesRunTime.boxToInteger((int)2)));
        List<StopReplicaRequest> requests = batch.collectStopReplicaRequestsFor(2);
        List allVersions = (List)requests.map((Function1 & Serializable & scala.Serializable)x$18 -> BoxesRunTime.boxToShort((short)x$18.version()), List$.MODULE$.canBuildFrom());
        Assert.assertTrue((String)new StringBuilder(45).append("IBP ").append(interBrokerProtocolVersion).append(" should use version ").append(expectedStopReplicaRequestVersion).append(", ").append("but found versions ").append(allVersions).toString(), (boolean)allVersions.forall((Function1 & Serializable & scala.Serializable)x$19 -> BoxesRunTime.boxToBoolean((boolean)ControllerChannelManagerTest.$anonfun$testStopReplicaFollowsInterBrokerProtocolVersion$2(expectedStopReplicaRequestVersion, BoxesRunTime.unboxToShort((Object)x$19)))));
    }

    private void applyStopReplicaResponseCallbacks(Errors error, List<SentRequest> sentRequests) {
        ((List)sentRequests.filter((Function1 & Serializable & scala.Serializable)x$20 -> BoxesRunTime.boxToBoolean((boolean)ControllerChannelManagerTest.$anonfun$applyStopReplicaResponseCallbacks$1(x$20)))).foreach((Function1 & Serializable & scala.Serializable)sentRequest -> {
            ControllerChannelManagerTest.$anonfun$applyStopReplicaResponseCallbacks$2(error, sentRequest);
            return BoxedUnit.UNIT;
        });
    }

    private void applyLeaderAndIsrResponseCallbacks(Errors error, List<SentRequest> sentRequests) {
        ((List)((TraversableLike)sentRequests.filter((Function1 & Serializable & scala.Serializable)x$21 -> BoxesRunTime.boxToBoolean((boolean)ControllerChannelManagerTest.$anonfun$applyLeaderAndIsrResponseCallbacks$1(x$21)))).filter((Function1 & Serializable & scala.Serializable)x$22 -> BoxesRunTime.boxToBoolean((boolean)ControllerChannelManagerTest.$anonfun$applyLeaderAndIsrResponseCallbacks$2(x$22)))).foreach((Function1 & Serializable & scala.Serializable)sentRequest -> {
            ControllerChannelManagerTest.$anonfun$applyLeaderAndIsrResponseCallbacks$3(error, sentRequest);
            return BoxedUnit.UNIT;
        });
    }

    private KafkaConfig createConfig(ApiVersion interBrokerVersion) {
        Properties props = new Properties();
        props.put(KafkaConfig$.MODULE$.BrokerIdProp(), ((Object)BoxesRunTime.boxToInteger((int)this.controllerId())).toString());
        props.put(KafkaConfig$.MODULE$.ZkConnectProp(), "zkConnect");
        props.put(KafkaConfig$.MODULE$.InterBrokerProtocolVersionProp(), interBrokerVersion.version());
        props.put(KafkaConfig$.MODULE$.LogMessageFormatVersionProp(), interBrokerVersion.version());
        return KafkaConfig$.MODULE$.fromProps(props);
    }

    private ReplicaAssignment replicaAssignment(Seq<Object> replicas) {
        return new ReplicaAssignment(replicas, (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$));
    }

    private ControllerContext initContext(Seq<Object> brokers, scala.collection.immutable.Set<String> topics, int numPartitions, int replicationFactor) {
        ControllerContext context = new ControllerContext();
        scala.collection.immutable.Map brokerEpochs = ((TraversableOnce)brokers.map((Function1 & Serializable & scala.Serializable)brokerId -> ControllerChannelManagerTest.$anonfun$initContext$1(BoxesRunTime.unboxToInt((Object)brokerId)), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        context.setLiveBrokerAndEpochs((Map)brokerEpochs);
        IntRef leaderIndex = IntRef.create((int)0);
        topics.foreach((Function1 & Serializable & scala.Serializable)topic -> {
            ControllerChannelManagerTest.$anonfun$initContext$2(numPartitions, replicationFactor, brokers, leaderIndex, context, topic);
            return BoxedUnit.UNIT;
        });
        return context;
    }

    private final void SentRequest$lzycompute$1() {
        ControllerChannelManagerTest controllerChannelManagerTest = this;
        synchronized (controllerChannelManagerTest) {
            if (this.SentRequest$module == null) {
                this.SentRequest$module = new ControllerChannelManagerTest$SentRequest$(this);
            }
        }
    }

    private final void MockControllerBrokerRequestBatch$lzycompute$1() {
        ControllerChannelManagerTest controllerChannelManagerTest = this;
        synchronized (controllerChannelManagerTest) {
            if (this.MockControllerBrokerRequestBatch$module == null) {
                this.MockControllerBrokerRequestBatch$module = new ControllerChannelManagerTest$MockControllerBrokerRequestBatch$(this);
            }
        }
    }

    public static final /* synthetic */ void $anonfun$testLeaderAndIsrRequestSent$1(ControllerChannelManagerTest $this, ControllerContext context$1, MockControllerBrokerRequestBatch batch$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TopicPartition partition = (TopicPartition)tuple2._1();
        LeaderAndIsr leaderAndIsr = (LeaderAndIsr)tuple2._2();
        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(leaderAndIsr, $this.controllerEpoch());
        context$1.partitionLeadershipInfo().put((Object)partition, (Object)leaderIsrAndControllerEpoch);
        batch$1.addLeaderAndIsrRequestForBrokers((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})), partition, leaderIsrAndControllerEpoch, $this.replicaAssignment((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})))), false);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$testLeaderAndIsrRequestIsNew$2(TopicPartition partition$1, LeaderAndIsrRequestData.LeaderAndIsrPartitionState p) {
        String string = p.topicName();
        String string2 = partition$1.topic();
        return !(string != null ? !string.equals(string2) : string2 != null) && p.partitionIndex() == partition$1.partition();
    }

    public static final /* synthetic */ void $anonfun$testLeaderAndIsrInterBrokerProtocolVersion$1(ControllerChannelManagerTest $this, ApiVersion apiVersion) {
        int leaderAndIsrRequestVersion = apiVersion.$greater$eq((Object)KAFKA_2_4_IV1$.MODULE$) ? 4 : (apiVersion.$greater$eq((Object)KAFKA_2_4_IV0$.MODULE$) ? 3 : (apiVersion.$greater$eq((Object)KAFKA_2_2_IV0$.MODULE$) ? 2 : (apiVersion.$greater$eq((Object)KAFKA_1_0_IV0$.MODULE$) ? 1 : 0)));
        $this.testLeaderAndIsrRequestFollowsInterBrokerProtocolVersion(apiVersion, (short)leaderAndIsrRequestVersion);
    }

    public static final /* synthetic */ boolean $anonfun$testUpdateMetadataRequestDuringTopicDeletion$2(UpdateMetadataRequestData.UpdateMetadataPartitionState x$5) {
        String string = x$5.topicName();
        String string2 = "foo";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testUpdateMetadataRequestDuringTopicDeletion$5(Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TopicPartition k = (TopicPartition)tuple2._1();
        String string = k.topic();
        String string2 = "bar";
        boolean bl = !(string != null ? !string.equals(string2) : string2 != null);
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$testUpdateMetadataRequestDuringTopicDeletion$7(UpdateMetadataRequestData.UpdateMetadataPartitionState ps) {
        String string = ps.topicName();
        String string2 = "bar";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$testUpdateMetadataInterBrokerProtocolVersion$1(ControllerChannelManagerTest $this, ApiVersion apiVersion) {
        int updateMetadataRequestVersion = apiVersion.$greater$eq((Object)KAFKA_2_4_IV1$.MODULE$) ? 6 : (apiVersion.$greater$eq((Object)KAFKA_2_2_IV0$.MODULE$) ? 5 : (apiVersion.$greater$eq((Object)KAFKA_1_0_IV0$.MODULE$) ? 4 : (apiVersion.$greater$eq((Object)KAFKA_0_10_2_IV0$.MODULE$) ? 3 : (apiVersion.$greater$eq((Object)KAFKA_0_10_0_IV1$.MODULE$) ? 2 : (apiVersion.$greater$eq((Object)KAFKA_0_9_0$.MODULE$) ? 1 : 0)))));
        $this.testUpdateMetadataFollowsInterBrokerProtocolVersion(apiVersion, (short)updateMetadataRequestVersion);
    }

    public static final /* synthetic */ boolean $anonfun$testUpdateMetadataFollowsInterBrokerProtocolVersion$2(short expectedUpdateMetadataVersion$1, short x$10) {
        return x$10 == expectedUpdateMetadataVersion$1;
    }

    public static final /* synthetic */ boolean $anonfun$testStopReplicaRequestsWhileTopicDeletionStarted$5(TopicPartition x$15) {
        String string = x$15.topic();
        String string2 = "foo";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$testStopReplicaInterBrokerProtocolVersion$1(ControllerChannelManagerTest $this, ApiVersion apiVersion) {
        if (apiVersion.$less((Object)KAFKA_2_2_IV0$.MODULE$)) {
            $this.testStopReplicaFollowsInterBrokerProtocolVersion(apiVersion, (short)0);
        } else if (apiVersion.$less((Object)KAFKA_2_4_IV1$.MODULE$)) {
            $this.testStopReplicaFollowsInterBrokerProtocolVersion(apiVersion, (short)1);
        } else {
            $this.testStopReplicaFollowsInterBrokerProtocolVersion(apiVersion, (short)2);
        }
    }

    public static final /* synthetic */ boolean $anonfun$testStopReplicaFollowsInterBrokerProtocolVersion$2(short expectedStopReplicaRequestVersion$1, short x$19) {
        return x$19 == expectedStopReplicaRequestVersion$1;
    }

    public static final /* synthetic */ boolean $anonfun$applyStopReplicaResponseCallbacks$1(SentRequest x$20) {
        return x$20.responseCallback() != null;
    }

    public static final /* synthetic */ void $anonfun$applyStopReplicaResponseCallbacks$2(Errors error$1, SentRequest sentRequest) {
        AbstractResponse abstractResponse;
        StopReplicaRequest stopReplicaRequest = (StopReplicaRequest)sentRequest.request().build();
        Errors errors = error$1;
        Errors errors2 = Errors.NONE;
        if (!(errors != null ? !errors.equals(errors2) : errors2 != null)) {
            java.util.List partitionErrors = (java.util.List)JavaConverters$.MODULE$.bufferAsJavaListConverter(((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(stopReplicaRequest.partitions()).asScala()).map((Function1 & Serializable & scala.Serializable)tp -> new StopReplicaResponseData.StopReplicaPartitionError().setTopicName(tp.topic()).setPartitionIndex(tp.partition()).setErrorCode(error$1.code()), Iterable$.MODULE$.canBuildFrom())).toBuffer()).asJava();
            abstractResponse = new StopReplicaResponse(new StopReplicaResponseData().setPartitionErrors(partitionErrors));
        } else {
            abstractResponse = stopReplicaRequest.getErrorResponse((Throwable)error$1.exception());
        }
        AbstractResponse stopReplicaResponse = abstractResponse;
        sentRequest.responseCallback().apply((Object)stopReplicaResponse);
    }

    public static final /* synthetic */ boolean $anonfun$applyLeaderAndIsrResponseCallbacks$1(SentRequest x$21) {
        ApiKeys apiKeys = x$21.request().apiKey();
        ApiKeys apiKeys2 = ApiKeys.LEADER_AND_ISR;
        return !(apiKeys != null ? !apiKeys.equals(apiKeys2) : apiKeys2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$applyLeaderAndIsrResponseCallbacks$2(SentRequest x$22) {
        return x$22.responseCallback() != null;
    }

    public static final /* synthetic */ void $anonfun$applyLeaderAndIsrResponseCallbacks$3(Errors error$2, SentRequest sentRequest) {
        LeaderAndIsrRequest leaderAndIsrRequest = (LeaderAndIsrRequest)sentRequest.request().build();
        Iterable partitionErrors = (Iterable)((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(leaderAndIsrRequest.partitionStates()).asScala()).map((Function1 & Serializable & scala.Serializable)p -> new LeaderAndIsrResponseData.LeaderAndIsrPartitionError().setTopicName(p.topicName()).setPartitionIndex(p.partitionIndex()).setErrorCode(error$2.code()), Iterable$.MODULE$.canBuildFrom());
        LeaderAndIsrResponse leaderAndIsrResponse = new LeaderAndIsrResponse(new LeaderAndIsrResponseData().setErrorCode(error$2.code()).setPartitionErrors((java.util.List)JavaConverters$.MODULE$.bufferAsJavaListConverter(partitionErrors.toBuffer()).asJava()));
        sentRequest.responseCallback().apply((Object)leaderAndIsrResponse);
    }

    public static final /* synthetic */ Tuple2 $anonfun$initContext$1(int brokerId) {
        EndPoint endpoint = new EndPoint("localhost", 9900 + brokerId, new ListenerName("PLAINTEXT"), SecurityProtocol.PLAINTEXT);
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Broker(brokerId, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EndPoint[]{endpoint})), (Option)None$.MODULE$)), (Object)BoxesRunTime.boxToLong((long)1L));
    }

    public static final /* synthetic */ void $anonfun$initContext$2(int numPartitions$1, int replicationFactor$1, Seq brokers$1, IntRef leaderIndex$1, ControllerContext context$4, String topic) {
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numPartitions$1).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)partitionId -> {
            TopicPartition partition = new TopicPartition(topic, partitionId);
            IndexedSeq replicas = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), replicationFactor$1).map((Function1)(JFunction1.mcII.sp & Serializable & scala.Serializable)i -> {
                void var3_3;
                int replica = BoxesRunTime.unboxToInt((Object)brokers$1.apply((i + leaderIndex$1.elem) % brokers$1.size()));
                return (int)var3_3;
            }, IndexedSeq$.MODULE$.canBuildFrom());
            context$4.updatePartitionReplicaAssignment(partition, (Seq)replicas);
            ++leaderIndex$1.elem;
        });
    }

    public ControllerChannelManagerTest() {
        this.controllerId = 1;
        this.controllerEpoch = 1;
    }

    public class MockControllerBrokerRequestBatch
    extends AbstractControllerBrokerRequestBatch {
        private final ListBuffer<ControllerEvent> sentEvents;
        private final scala.collection.mutable.Map<Object, ListBuffer<SentRequest>> sentRequests;

        public ListBuffer<ControllerEvent> sentEvents() {
            return this.sentEvents;
        }

        public scala.collection.mutable.Map<Object, ListBuffer<SentRequest>> sentRequests() {
            return this.sentRequests;
        }

        public void sendEvent(ControllerEvent event) {
            this.sentEvents().append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ControllerEvent[]{event}));
        }

        public void sendRequest(int brokerId, AbstractControlRequest.Builder<? extends AbstractControlRequest> request, Function1<AbstractResponse, BoxedUnit> callback) {
            this.sentRequests().getOrElseUpdate((Object)BoxesRunTime.boxToInteger((int)brokerId), (Function0 & Serializable & scala.Serializable)() -> (ListBuffer)ListBuffer$.MODULE$.empty());
            ((BufferLike)this.sentRequests().apply((Object)BoxesRunTime.boxToInteger((int)brokerId))).append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SentRequest[]{new SentRequest(this.kafka$controller$ControllerChannelManagerTest$MockControllerBrokerRequestBatch$$$outer(), request, callback)}));
        }

        public List<StopReplicaRequest> collectStopReplicaRequestsFor(int brokerId) {
            List list;
            Option option = this.sentRequests().get((Object)BoxesRunTime.boxToInteger((int)brokerId));
            if (option instanceof Some) {
                Some some = (Some)option;
                ListBuffer requests = (ListBuffer)some.value();
                list = ((ListBuffer)((TraversableLike)requests.filter((Function1 & Serializable & scala.Serializable)x$23 -> BoxesRunTime.boxToBoolean((boolean)MockControllerBrokerRequestBatch.$anonfun$collectStopReplicaRequestsFor$1(x$23)))).map((Function1 & Serializable & scala.Serializable)x$24 -> (StopReplicaRequest)x$24.request().build(), ListBuffer$.MODULE$.canBuildFrom())).toList();
            } else if (None$.MODULE$.equals(option)) {
                list = List$.MODULE$.empty();
            } else {
                throw new MatchError((Object)option);
            }
            return list;
        }

        public List<UpdateMetadataRequest> collectUpdateMetadataRequestsFor(int brokerId) {
            List list;
            Option option = this.sentRequests().get((Object)BoxesRunTime.boxToInteger((int)brokerId));
            if (option instanceof Some) {
                Some some = (Some)option;
                ListBuffer requests = (ListBuffer)some.value();
                list = ((ListBuffer)((TraversableLike)requests.filter((Function1 & Serializable & scala.Serializable)x$25 -> BoxesRunTime.boxToBoolean((boolean)MockControllerBrokerRequestBatch.$anonfun$collectUpdateMetadataRequestsFor$1(x$25)))).map((Function1 & Serializable & scala.Serializable)x$26 -> (UpdateMetadataRequest)x$26.request().build(), ListBuffer$.MODULE$.canBuildFrom())).toList();
            } else if (None$.MODULE$.equals(option)) {
                list = List$.MODULE$.empty();
            } else {
                throw new MatchError((Object)option);
            }
            return list;
        }

        public List<LeaderAndIsrRequest> collectLeaderAndIsrRequestsFor(int brokerId) {
            List list;
            Option option = this.sentRequests().get((Object)BoxesRunTime.boxToInteger((int)brokerId));
            if (option instanceof Some) {
                Some some = (Some)option;
                ListBuffer requests = (ListBuffer)some.value();
                list = ((ListBuffer)((TraversableLike)requests.filter((Function1 & Serializable & scala.Serializable)x$27 -> BoxesRunTime.boxToBoolean((boolean)MockControllerBrokerRequestBatch.$anonfun$collectLeaderAndIsrRequestsFor$1(x$27)))).map((Function1 & Serializable & scala.Serializable)x$28 -> (LeaderAndIsrRequest)x$28.request().build(), ListBuffer$.MODULE$.canBuildFrom())).toList();
            } else if (None$.MODULE$.equals(option)) {
                list = List$.MODULE$.empty();
            } else {
                throw new MatchError((Object)option);
            }
            return list;
        }

        public /* synthetic */ ControllerChannelManagerTest kafka$controller$ControllerChannelManagerTest$MockControllerBrokerRequestBatch$$$outer() {
            return ControllerChannelManagerTest.this;
        }

        public static final /* synthetic */ boolean $anonfun$collectStopReplicaRequestsFor$1(SentRequest x$23) {
            ApiKeys apiKeys = x$23.request().apiKey();
            ApiKeys apiKeys2 = ApiKeys.STOP_REPLICA;
            return !(apiKeys != null ? !apiKeys.equals(apiKeys2) : apiKeys2 != null);
        }

        public static final /* synthetic */ boolean $anonfun$collectUpdateMetadataRequestsFor$1(SentRequest x$25) {
            ApiKeys apiKeys = x$25.request().apiKey();
            ApiKeys apiKeys2 = ApiKeys.UPDATE_METADATA;
            return !(apiKeys != null ? !apiKeys.equals(apiKeys2) : apiKeys2 != null);
        }

        public static final /* synthetic */ boolean $anonfun$collectLeaderAndIsrRequestsFor$1(SentRequest x$27) {
            ApiKeys apiKeys = x$27.request().apiKey();
            ApiKeys apiKeys2 = ApiKeys.LEADER_AND_ISR;
            return !(apiKeys != null ? !apiKeys.equals(apiKeys2) : apiKeys2 != null);
        }

        public MockControllerBrokerRequestBatch(ControllerContext context, KafkaConfig config) {
            if (ControllerChannelManagerTest.this == null) {
                throw null;
            }
            super(config, context, ControllerChannelManagerTest.this.kafka$controller$ControllerChannelManagerTest$$logger());
            this.sentEvents = (ListBuffer)ListBuffer$.MODULE$.empty();
            this.sentRequests = Map$.MODULE$.empty();
        }
    }

    public class SentRequest
    implements Product,
    scala.Serializable {
        private final AbstractControlRequest.Builder<? extends AbstractControlRequest> request;
        private final Function1<AbstractResponse, BoxedUnit> responseCallback;
        public final /* synthetic */ ControllerChannelManagerTest $outer;

        public AbstractControlRequest.Builder<? extends AbstractControlRequest> request() {
            return this.request;
        }

        public Function1<AbstractResponse, BoxedUnit> responseCallback() {
            return this.responseCallback;
        }

        public SentRequest copy(AbstractControlRequest.Builder<? extends AbstractControlRequest> request, Function1<AbstractResponse, BoxedUnit> responseCallback) {
            return new SentRequest(this.kafka$controller$ControllerChannelManagerTest$SentRequest$$$outer(), request, responseCallback);
        }

        public AbstractControlRequest.Builder<? extends AbstractControlRequest> copy$default$1() {
            return this.request();
        }

        public Function1<AbstractResponse, BoxedUnit> copy$default$2() {
            return this.responseCallback();
        }

        public String productPrefix() {
            return "SentRequest";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            AbstractControlRequest.Builder<? extends AbstractControlRequest> builder;
            int n = x$1;
            switch (n) {
                case 0: {
                    builder = this.request();
                    break;
                }
                case 1: {
                    builder = this.responseCallback();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
            }
            return builder;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof SentRequest;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof SentRequest)) return false;
            if (((SentRequest)object).kafka$controller$ControllerChannelManagerTest$SentRequest$$$outer() != this.kafka$controller$ControllerChannelManagerTest$SentRequest$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            SentRequest sentRequest = (SentRequest)x$1;
            AbstractControlRequest.Builder<? extends AbstractControlRequest> builder = this.request();
            AbstractControlRequest.Builder<? extends AbstractControlRequest> builder2 = sentRequest.request();
            if (builder == null) {
                if (builder2 != null) {
                    return false;
                }
            } else if (!builder.equals(builder2)) return false;
            Function1<AbstractResponse, BoxedUnit> function1 = this.responseCallback();
            Function1<AbstractResponse, BoxedUnit> function12 = sentRequest.responseCallback();
            if (function1 == null) {
                if (function12 != null) {
                    return false;
                }
            } else if (!function1.equals(function12)) return false;
            if (!sentRequest.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ ControllerChannelManagerTest kafka$controller$ControllerChannelManagerTest$SentRequest$$$outer() {
            return this.$outer;
        }

        public SentRequest(ControllerChannelManagerTest $outer, AbstractControlRequest.Builder<? extends AbstractControlRequest> request, Function1<AbstractResponse, BoxedUnit> responseCallback) {
            this.request = request;
            this.responseCallback = responseCallback;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }
}

