/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import kafka.api.LeaderAndIsr$;
import kafka.cluster.Broker;
import kafka.controller.ControllerChannelManager;
import kafka.controller.ControllerChannelManager$;
import kafka.controller.ControllerContext;
import kafka.controller.StateChangeLogger;
import kafka.server.HostedPartition;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import kafka.zk.ZooKeeperTestHarness;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.LeaderAndIsrRequestData;
import org.apache.kafka.common.message.UpdateMetadataRequestData;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractControlRequest;
import org.apache.kafka.common.requests.LeaderAndIsrRequest;
import org.apache.kafka.common.requests.StopReplicaRequest;
import org.apache.kafka.common.requests.UpdateMetadataRequest;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Time;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.mutable.Buffer;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.VolatileBooleanRef;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005%c\u0001\u0002\u000b\u0016\u0001iAQ!\t\u0001\u0005\u0002\tBq!\n\u0001C\u0002\u0013\u0005a\u0005\u0003\u0004.\u0001\u0001\u0006Ia\n\u0005\b]\u0001\u0011\r\u0011\"\u0001'\u0011\u0019y\u0003\u0001)A\u0005O!9\u0001\u0007\u0001a\u0001\n\u0003\t\u0004bB!\u0001\u0001\u0004%\tA\u0011\u0005\u0007\u0011\u0002\u0001\u000b\u0015\u0002\u001a\t\u000b%\u0003A\u0011\t&\t\u000bQ\u0003A\u0011\t&\t\u000be\u0003A\u0011\u0001&\t\u000by\u0003A\u0011\u0001&\t\u000b\u0001\u0004A\u0011\u0001&\t\u000b\t\u0004A\u0011\u0001&\t\u000b\u0011\u0004A\u0011B3\t\u000b-\u0004A\u0011\u00027\t\u000b5\u0004A\u0011\u00028\t\u000b]\u0004A\u0011\u0002=\t\u000f\u0005]\u0002\u0001\"\u0003\u0002:\tQ\"I]8lKJ,\u0005o\\2i\u0013:$Xm\u001a:bi&|g\u000eV3ti*\u0011acF\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003a\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u00017A\u0011AdH\u0007\u0002;)\u0011adF\u0001\u0003u.L!\u0001I\u000f\u0003)i{wnS3fa\u0016\u0014H+Z:u\u0011\u0006\u0014h.Z:t\u0003\u0019a\u0014N\\5u}Q\t1\u0005\u0005\u0002%\u00015\tQ#A\u0005ce>\\WM]%ecU\tq\u0005\u0005\u0002)W5\t\u0011FC\u0001+\u0003\u0015\u00198-\u00197b\u0013\ta\u0013FA\u0002J]R\f!B\u0019:pW\u0016\u0014\u0018\nZ\u0019!\u0003%\u0011'o\\6fe&#''\u0001\u0006ce>\\WM]%ee\u0001\nqa]3sm\u0016\u00148/F\u00013!\r\u00194H\u0010\b\u0003ier!!\u000e\u001d\u000e\u0003YR!aN\r\u0002\rq\u0012xn\u001c;?\u0013\u0005Q\u0013B\u0001\u001e*\u0003\u001d\u0001\u0018mY6bO\u0016L!\u0001P\u001f\u0003\u0007M+\u0017O\u0003\u0002;SA\u0011AeP\u0005\u0003\u0001V\u00111bS1gW\u0006\u001cVM\u001d<fe\u0006Y1/\u001a:wKJ\u001cx\fJ3r)\t\u0019e\t\u0005\u0002)\t&\u0011Q)\u000b\u0002\u0005+:LG\u000fC\u0004H\u000f\u0005\u0005\t\u0019\u0001\u001a\u0002\u0007a$\u0013'\u0001\u0005tKJ4XM]:!\u0003\u0015\u0019X\r^+q)\u0005\u0019\u0005FA\u0005M!\ti%+D\u0001O\u0015\ty\u0005+A\u0003kk:LGOC\u0001R\u0003\ry'oZ\u0005\u0003':\u0013aAQ3g_J,\u0017\u0001\u0003;fCJ$un\u001e8)\u0005)1\u0006CA'X\u0013\tAfJA\u0003BMR,'/\u0001\u0016uKN$(+\u001a9mS\u000e\fW*\u00198bO\u0016\u0014(I]8lKJ,\u0005o\\2i\u001b\u0006$8\r[3t/&$\bNW6)\u0005-Y\u0006CA']\u0013\tifJ\u0001\u0003UKN$\u0018a\u000b;fgR\u001cuN\u001c;s_2dWM\u001d\"s_.,'/\u00129pG\"\u001c\u0015m\u00195f\u001b\u0006$8\r[3t/&$\bNW6)\u00051Y\u0016\u0001\u000b;fgR\u001cuN\u001c;s_2\u0014V-];fgR<\u0016\u000e\u001e5D_J\u0014Xm\u0019;Ce>\\WM]#q_\u000eD\u0007FA\u0007\\\u0003\u0019\"Xm\u001d;D_:$(o\u001c7SKF,Xm\u001d;XSRD7\u000b^1mK\n\u0013xn[3s\u000bB|7\r\u001b\u0015\u0003\u001dm\u000b\u0011\u0005^3ti\u000e{g\u000e\u001e:pYJ+\u0017/^3ti^KG\u000f\u001b\"s_.,'/\u00129pG\"$\"a\u00114\t\u000b\u001d|\u0001\u0019\u00015\u0002+%\u001cX\t]8dQ&s'+Z9vKN$8\u000b^1mKB\u0011\u0001&[\u0005\u0003U&\u0012qAQ8pY\u0016\fg.A\u0007hKR\u001cuN\u001c;s_2dWM]\u000b\u0002}\u0005i3\r[3dW\u000e{g\u000e\u001e:pY2,'O\u0011:pW\u0016\u0014X\t]8dQN\u001c\u0015m\u00195f\u001b\u0006$8\r[3t/&$\bNW6\u0015\u0005\r{\u0007\"\u00029\u0012\u0001\u0004\t\u0018!E2p]R\u0014x\u000e\u001c7fe\u000e{g\u000e^3yiB\u0011!/^\u0007\u0002g*\u0011AoF\u0001\u000bG>tGO]8mY\u0016\u0014\u0018B\u0001<t\u0005E\u0019uN\u001c;s_2dWM]\"p]R,\u0007\u0010^\u0001(g\u0016tG-\u00118e-\u0016\u0014\u0018NZ=Ti\u0006dWM\u0011:pW\u0016\u0014X\t]8dQ&s'+Z:q_:\u001cX\rF\u0002DszDQA\u001f\nA\u0002m\f\u0001dY8oiJ|G\u000e\\3s\u0007\"\fgN\\3m\u001b\u0006t\u0017mZ3s!\t\u0011H0\u0003\u0002~g\nA2i\u001c8ue>dG.\u001a:DQ\u0006tg.\u001a7NC:\fw-\u001a:\t\r}\u0014\u0002\u0019AA\u0001\u0003\u001d\u0011W/\u001b7eKJ\u0004D!a\u0001\u0002&A1\u0011QAA\u000e\u0003CqA!a\u0002\u0002\u00185\u0011\u0011\u0011\u0002\u0006\u0005\u0003\u0017\ti!\u0001\u0005sKF,Xm\u001d;t\u0015\u0011\ty!!\u0005\u0002\r\r|W.\\8o\u0015\rA\u00121\u0003\u0006\u0004\u0003+\u0001\u0016AB1qC\u000eDW-\u0003\u0003\u0002\u001a\u0005%\u0011AF!cgR\u0014\u0018m\u0019;D_:$(o\u001c7SKF,Xm\u001d;\n\t\u0005u\u0011q\u0004\u0002\b\u0005VLG\u000eZ3s\u0015\u0011\tI\"!\u0003\u0011\t\u0005\r\u0012Q\u0005\u0007\u0001\t-\t9C`A\u0001\u0002\u0003\u0015\t!!\u000b\u0003\u0007}#\u0013'\u0005\u0003\u0002,\u0005E\u0002c\u0001\u0015\u0002.%\u0019\u0011qF\u0015\u0003\u000f9{G\u000f[5oOB!\u0011qAA\u001a\u0013\u0011\t)$!\u0003\u0003-\u0005\u00137\u000f\u001e:bGR\u001cuN\u001c;s_2\u0014V-];fgR\fqd]3oI\u0006sGMV3sS\u001aL8+^2dKN\u001ch-\u001e7SKN\u0004xN\\:f)\u0015\u0019\u00151HA\u001f\u0011\u0015Q8\u00031\u0001|\u0011\u0019y8\u00031\u0001\u0002@A\"\u0011\u0011IA#!\u0019\t)!a\u0007\u0002DA!\u00111EA#\t1\t9%!\u0010\u0002\u0002\u0003\u0005)\u0011AA\u0015\u0005\ryFE\r")
public class BrokerEpochIntegrationTest
extends ZooKeeperTestHarness {
    private final int brokerId1;
    private final int brokerId2;
    private Seq<KafkaServer> servers = (Seq)Seq$.MODULE$.empty();

    public int brokerId1() {
        return this.brokerId1;
    }

    public int brokerId2() {
        return this.brokerId2;
    }

    public Seq<KafkaServer> servers() {
        return this.servers;
    }

    public void servers_$eq(Seq<KafkaServer> x$1) {
        this.servers = x$1;
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        Seq configs = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Properties[]{TestUtils$.MODULE$.createBrokerConfig(this.brokerId1(), this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20()), TestUtils$.MODULE$.createBrokerConfig(this.brokerId2(), this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20())}));
        configs.foreach((Function1 & Serializable & scala.Serializable)config -> config.setProperty(KafkaConfig$.MODULE$.AutoLeaderRebalanceEnableProp(), ((Object)BoxesRunTime.boxToBoolean((boolean)false)).toString()));
        this.servers_$eq((Seq<KafkaServer>)((Seq)configs.map((Function1 & Serializable & scala.Serializable)config -> TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(config), TestUtils$.MODULE$.createServer$default$2()), Seq$.MODULE$.canBuildFrom())));
    }

    @Override
    @After
    public void tearDown() {
        TestUtils$.MODULE$.shutdownServers(this.servers());
        super.tearDown();
    }

    @Test
    public void testReplicaManagerBrokerEpochMatchesWithZk() {
        Map brokerAndEpochs = this.zkClient().getAllBrokerAndEpochsInCluster();
        Assert.assertEquals((long)brokerAndEpochs.size(), (long)this.servers().size());
        brokerAndEpochs.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            BrokerEpochIntegrationTest.$anonfun$testReplicaManagerBrokerEpochMatchesWithZk$1(this, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testControllerBrokerEpochCacheMatchesWithZk() {
        KafkaServer controller = this.getController();
        KafkaServer otherBroker = (KafkaServer)this.servers().find((Function1 & Serializable & scala.Serializable)e -> BoxesRunTime.boxToBoolean((boolean)BrokerEpochIntegrationTest.$anonfun$testControllerBrokerEpochCacheMatchesWithZk$1(controller, e))).get();
        this.checkControllerBrokerEpochsCacheMatchesWithZk(controller.kafkaController().controllerContext());
        otherBroker.shutdown();
        this.checkControllerBrokerEpochsCacheMatchesWithZk(controller.kafkaController().controllerContext());
        otherBroker.startup();
        this.checkControllerBrokerEpochsCacheMatchesWithZk(controller.kafkaController().controllerContext());
    }

    @Test
    public void testControlRequestWithCorrectBrokerEpoch() {
        this.testControlRequestWithBrokerEpoch(false);
    }

    @Test
    public void testControlRequestWithStaleBrokerEpoch() {
        this.testControlRequestWithBrokerEpoch(true);
    }

    private void testControlRequestWithBrokerEpoch(boolean isEpochInRequestStale) {
        TopicPartition tp = new TopicPartition("new-topic", 0);
        TestUtils$.MODULE$.createTopic(this.zkClient(), tp.topic(), (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId1(), this.brokerId2()})))}))), this.servers());
        int controllerId = 2;
        int controllerEpoch = ((Tuple2)this.zkClient().getControllerEpoch().get())._1$mcI$sp();
        KafkaConfig controllerConfig = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(controllerId, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20()));
        SecurityProtocol securityProtocol = SecurityProtocol.PLAINTEXT;
        ListenerName listenerName = ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol);
        scala.collection.immutable.Map brokerAndEpochs = ((TraversableOnce)this.servers().map((Function1 & Serializable & scala.Serializable)s -> new Tuple2((Object)new Broker(s.config().brokerId(), "localhost", TestUtils$.MODULE$.boundPort((KafkaServer)s, TestUtils$.MODULE$.boundPort$default$2()), listenerName, securityProtocol), (Object)BoxesRunTime.boxToLong((long)s.kafkaController().brokerEpoch())), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        Iterable nodes = (Iterable)brokerAndEpochs.keys().map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.node(listenerName), scala.collection.Iterable$.MODULE$.canBuildFrom());
        ControllerContext controllerContext = new ControllerContext();
        controllerContext.setLiveBrokerAndEpochs((Map)brokerAndEpochs);
        Metrics metrics = new Metrics();
        ControllerChannelManager controllerChannelManager = new ControllerChannelManager(controllerContext, controllerConfig, Time.SYSTEM, metrics, new StateChangeLogger(controllerId, true, (Option)None$.MODULE$), ControllerChannelManager$.MODULE$.$lessinit$greater$default$6());
        controllerChannelManager.startup();
        KafkaServer broker2 = (KafkaServer)this.servers().apply(this.brokerId2());
        long epochInRequest = isEpochInRequestStale ? broker2.kafkaController().brokerEpoch() - 1L : broker2.kafkaController().brokerEpoch();
        try {
            Object object;
            Seq partitionStates = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LeaderAndIsrRequestData.LeaderAndIsrPartitionState[]{new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setTopicName(tp.topic()).setPartitionIndex(tp.partition()).setControllerEpoch(controllerEpoch).setLeader(this.brokerId2()).setLeaderEpoch(LeaderAndIsr$.MODULE$.initialLeaderEpoch() + 1).setIsr((List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId1(), this.brokerId2()}))).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1), Seq$.MODULE$.canBuildFrom())).asJava()).setZkVersion(LeaderAndIsr$.MODULE$.initialZKVersion()).setReplicas((List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1}))).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1), Seq$.MODULE$.canBuildFrom())).asJava()).setIsNew(false)}));
            LeaderAndIsrRequest.Builder requestBuilder = new LeaderAndIsrRequest.Builder(ApiKeys.LEADER_AND_ISR.latestVersion(), controllerId, controllerEpoch, epochInRequest, (List)JavaConverters$.MODULE$.seqAsJavaListConverter(partitionStates).asJava(), (Collection)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)nodes.toSet()).asJava());
            if (isEpochInRequestStale) {
                this.sendAndVerifyStaleBrokerEpochInResponse(controllerChannelManager, (AbstractControlRequest.Builder<? extends AbstractControlRequest>)requestBuilder);
                object = BoxedUnit.UNIT;
            } else {
                this.sendAndVerifySuccessfulResponse(controllerChannelManager, (AbstractControlRequest.Builder<? extends AbstractControlRequest>)requestBuilder);
                object = BoxesRunTime.boxToInteger((int)TestUtils$.MODULE$.waitUntilLeaderIsKnown((Seq<KafkaServer>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaServer[]{broker2}))), tp, 10000L));
            }
            Seq partitionStates2 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UpdateMetadataRequestData.UpdateMetadataPartitionState[]{new UpdateMetadataRequestData.UpdateMetadataPartitionState().setTopicName(tp.topic()).setPartitionIndex(tp.partition()).setControllerEpoch(controllerEpoch).setLeader(this.brokerId2()).setLeaderEpoch(LeaderAndIsr$.MODULE$.initialLeaderEpoch() + 1).setIsr((List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId1(), this.brokerId2()}))).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1), Seq$.MODULE$.canBuildFrom())).asJava()).setZkVersion(LeaderAndIsr$.MODULE$.initialZKVersion()).setReplicas((List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1}))).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1), Seq$.MODULE$.canBuildFrom())).asJava())}));
            Buffer liveBrokers = ((TraversableOnce)brokerAndEpochs.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Broker broker = (Broker)tuple2._1();
                SecurityProtocol securityProtocol = SecurityProtocol.PLAINTEXT;
                ListenerName listenerName = ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol);
                Node node = broker.node(listenerName);
                Seq endpoints = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UpdateMetadataRequestData.UpdateMetadataEndpoint[]{new UpdateMetadataRequestData.UpdateMetadataEndpoint().setHost(node.host()).setPort(node.port()).setSecurityProtocol(securityProtocol.id).setListener(listenerName.value())}));
                UpdateMetadataRequestData.UpdateMetadataBroker updateMetadataBroker = new UpdateMetadataRequestData.UpdateMetadataBroker().setId(broker.id()).setEndpoints((List)JavaConverters$.MODULE$.seqAsJavaListConverter(endpoints).asJava()).setRack((String)broker.rack().orNull(Predef$.MODULE$.$conforms()));
                return updateMetadataBroker;
            }, Iterable$.MODULE$.canBuildFrom())).toBuffer();
            UpdateMetadataRequest.Builder requestBuilder2 = new UpdateMetadataRequest.Builder(ApiKeys.UPDATE_METADATA.latestVersion(), controllerId, controllerEpoch, epochInRequest, (List)JavaConverters$.MODULE$.seqAsJavaListConverter(partitionStates2).asJava(), (List)JavaConverters$.MODULE$.bufferAsJavaListConverter(liveBrokers).asJava());
            if (isEpochInRequestStale) {
                this.sendAndVerifyStaleBrokerEpochInResponse(controllerChannelManager, (AbstractControlRequest.Builder<? extends AbstractControlRequest>)requestBuilder2);
            } else {
                this.sendAndVerifySuccessfulResponse(controllerChannelManager, (AbstractControlRequest.Builder<? extends AbstractControlRequest>)requestBuilder2);
                TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaServer[]{broker2}))), tp.topic(), tp.partition(), 10000L);
                Assert.assertEquals((long)this.brokerId2(), (long)((UpdateMetadataRequestData.UpdateMetadataPartitionState)broker2.metadataCache().getPartitionInfo(tp.topic(), tp.partition()).get()).leader());
            }
            StopReplicaRequest.Builder requestBuilder3 = new StopReplicaRequest.Builder(ApiKeys.STOP_REPLICA.latestVersion(), controllerId, controllerEpoch, epochInRequest, true, (Collection)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp}))).asJava());
            if (isEpochInRequestStale) {
                this.sendAndVerifyStaleBrokerEpochInResponse(controllerChannelManager, (AbstractControlRequest.Builder<? extends AbstractControlRequest>)requestBuilder3);
            } else {
                this.sendAndVerifySuccessfulResponse(controllerChannelManager, (AbstractControlRequest.Builder<? extends AbstractControlRequest>)requestBuilder3);
                Assert.assertEquals((Object)HostedPartition.None$.MODULE$, (Object)broker2.replicaManager().getPartition(tp));
            }
        }
        finally {
            controllerChannelManager.shutdown();
            metrics.close();
        }
    }

    private KafkaServer getController() {
        int controllerId = TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), TestUtils$.MODULE$.waitUntilControllerElected$default$2());
        return (KafkaServer)((IterableLike)this.servers().filter((Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToBoolean((boolean)BrokerEpochIntegrationTest.$anonfun$getController$1(controllerId, s)))).head();
    }

    private void checkControllerBrokerEpochsCacheMatchesWithZk(ControllerContext controllerContext) {
        Map brokerAndEpochs = this.zkClient().getAllBrokerAndEpochsInCluster();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            Map brokerEpochsInControllerContext = controllerContext.liveBrokerIdAndEpochs();
            return brokerAndEpochs.size() != brokerEpochsInControllerContext.size() ? false : brokerAndEpochs.forall((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)BrokerEpochIntegrationTest.$anonfun$checkControllerBrokerEpochsCacheMatchesWithZk$2(brokerEpochsInControllerContext, x0$1)));
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Broker epoch mismatches", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
    }

    private void sendAndVerifyStaleBrokerEpochInResponse(ControllerChannelManager controllerChannelManager, AbstractControlRequest.Builder<? extends AbstractControlRequest> builder) {
        BooleanRef staleBrokerEpochDetected = BooleanRef.create((boolean)false);
        controllerChannelManager.sendRequest(this.brokerId2(), builder, (Function1 & Serializable & scala.Serializable)response -> {
            staleBrokerEpochDetected.elem = response.errorCounts().containsKey(Errors.STALE_BROKER_EPOCH);
            return BoxedUnit.UNIT;
        });
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> staleBrokerEpochDetected$1.elem, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Broker epoch should be stale", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        Assert.assertTrue((String)"Stale broker epoch not detected by the broker", (boolean)staleBrokerEpochDetected.elem);
    }

    private void sendAndVerifySuccessfulResponse(ControllerChannelManager controllerChannelManager, AbstractControlRequest.Builder<? extends AbstractControlRequest> builder) {
        VolatileBooleanRef succeed = VolatileBooleanRef.create((boolean)false);
        controllerChannelManager.sendRequest(this.brokerId2(), builder, (Function1 & Serializable & scala.Serializable)response -> {
            succeed.elem = response.errorCounts().isEmpty() || response.errorCounts().containsKey(Errors.NONE) && response.errorCounts().size() == 1;
            return BoxedUnit.UNIT;
        });
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> succeed$1.elem, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Should receive response with no errors", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
    }

    public static final /* synthetic */ boolean $anonfun$testReplicaManagerBrokerEpochMatchesWithZk$2(Broker broker$1, KafkaServer e) {
        return e.config().brokerId() == broker$1.id();
    }

    public static final /* synthetic */ void $anonfun$testReplicaManagerBrokerEpochMatchesWithZk$1(BrokerEpochIntegrationTest $this, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Broker broker = (Broker)tuple2._1();
        long epoch = tuple2._2$mcJ$sp();
        Option brokerServer = $this.servers().find((Function1 & Serializable & scala.Serializable)e -> BoxesRunTime.boxToBoolean((boolean)BrokerEpochIntegrationTest.$anonfun$testReplicaManagerBrokerEpochMatchesWithZk$2(broker, e)));
        Assert.assertTrue((boolean)brokerServer.isDefined());
        Assert.assertEquals((long)epoch, (long)((KafkaServer)brokerServer.get()).kafkaController().brokerEpoch());
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$testControllerBrokerEpochCacheMatchesWithZk$1(KafkaServer controller$1, KafkaServer e) {
        return e.config().brokerId() != controller$1.config().brokerId();
    }

    public static final /* synthetic */ boolean $anonfun$getController$1(int controllerId$1, KafkaServer s) {
        return s.config().brokerId() == controllerId$1;
    }

    public static final /* synthetic */ boolean $anonfun$checkControllerBrokerEpochsCacheMatchesWithZk$2(Map brokerEpochsInControllerContext$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Broker broker = (Broker)tuple2._1();
        long epoch = tuple2._2$mcJ$sp();
        boolean bl = brokerEpochsInControllerContext$1.get((Object)BoxesRunTime.boxToInteger((int)broker.id())).contains((Object)BoxesRunTime.boxToLong((long)epoch));
        return bl;
    }

    public BrokerEpochIntegrationTest() {
        this.brokerId1 = 0;
        this.brokerId2 = 1;
    }
}

