/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import kafka.network.SocketServer;
import kafka.server.BaseRequestTest;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.message.DeleteTopicsRequestData;
import org.apache.kafka.common.message.DeleteTopicsResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.DeleteTopicsRequest;
import org.apache.kafka.common.requests.DeleteTopicsResponse;
import org.apache.kafka.common.requests.MetadataRequest;
import org.apache.kafka.common.requests.MetadataResponse;
import org.junit.Assert;
import org.junit.Test;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001u4Aa\u0003\u0007\u0001#!)a\u0003\u0001C\u0001/!)\u0011\u0004\u0001C\u00015!)!\u0006\u0001C\u0005W!)\u0011\b\u0001C\u00015!)1\b\u0001C\u0005y!)A\u000b\u0001C\u00015!)a\u000b\u0001C\u0005/\")!\f\u0001C\u00057\"9\u0001\u000eAI\u0001\n\u0013I\u0007\"\u0002;\u0001\t\u0013)(a\u0006#fY\u0016$X\rV8qS\u000e\u001c(+Z9vKN$H+Z:u\u0015\tia\"\u0001\u0004tKJ4XM\u001d\u0006\u0002\u001f\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\u0013!\t\u0019B#D\u0001\r\u0013\t)BBA\bCCN,'+Z9vKN$H+Z:u\u0003\u0019a\u0014N\\5u}Q\t\u0001\u0004\u0005\u0002\u0014\u0001\u0005aB/Z:u-\u0006d\u0017\u000e\u001a#fY\u0016$X\rV8qS\u000e\u0014V-];fgR\u001cH#A\u000e\u0011\u0005qyR\"A\u000f\u000b\u0003y\tQa]2bY\u0006L!\u0001I\u000f\u0003\tUs\u0017\u000e\u001e\u0015\u0003\u0005\t\u0002\"a\t\u0015\u000e\u0003\u0011R!!\n\u0014\u0002\u000b),h.\u001b;\u000b\u0003\u001d\n1a\u001c:h\u0013\tICE\u0001\u0003UKN$\u0018\u0001\t<bY&$\u0017\r^3WC2LG\rR3mKR,Gk\u001c9jGJ+\u0017/^3tiN$\"a\u0007\u0017\t\u000b5\u001a\u0001\u0019\u0001\u0018\u0002\u000fI,\u0017/^3tiB\u0011qfN\u0007\u0002a)\u0011\u0011GM\u0001\te\u0016\fX/Z:ug*\u00111\u0007N\u0001\u0007G>lWn\u001c8\u000b\u0005=)$B\u0001\u001c'\u0003\u0019\t\u0007/Y2iK&\u0011\u0001\b\r\u0002\u0014\t\u0016dW\r^3U_BL7m\u001d*fcV,7\u000f^\u0001\u001di\u0016\u001cH/\u0012:s_J$U\r\\3uKR{\u0007/[2SKF,Xm\u001d;tQ\t!!%\u0001\u0011wC2LG-\u0019;f\u000bJ\u0014xN\u001d#fY\u0016$X\rV8qS\u000e\u0014V-];fgR\u001cHcA\u000e>}!)Q&\u0002a\u0001]!)q(\u0002a\u0001\u0001\u0006\u0001R\r\u001f9fGR,GMU3ta>t7/\u001a\t\u0005\u0003\"[eJ\u0004\u0002C\rB\u00111)H\u0007\u0002\t*\u0011Q\tE\u0001\u0007yI|w\u000e\u001e \n\u0005\u001dk\u0012A\u0002)sK\u0012,g-\u0003\u0002J\u0015\n\u0019Q*\u00199\u000b\u0005\u001dk\u0002CA!M\u0013\ti%J\u0001\u0004TiJLgn\u001a\t\u0003\u001fJk\u0011\u0001\u0015\u0006\u0003#J\n\u0001\u0002\u001d:pi>\u001cw\u000e\\\u0005\u0003'B\u0013a!\u0012:s_J\u001c\u0018!\u0005;fgRtu\u000e^\"p]R\u0014x\u000e\u001c7fe\"\u0012aAI\u0001\u0017m\u0006d\u0017\u000eZ1uKR{\u0007/[2Jg\u0012+G.\u001a;fIR\u00111\u0004\u0017\u0005\u00063\u001e\u0001\raS\u0001\u0006i>\u0004\u0018nY\u0001\u0018g\u0016tG\rR3mKR,Gk\u001c9jGN\u0014V-];fgR$2\u0001X0a!\tyS,\u0003\u0002_a\t!B)\u001a7fi\u0016$v\u000e]5dgJ+7\u000f]8og\u0016DQ!\f\u0005A\u00029Bq!\u0019\u0005\u0011\u0002\u0003\u0007!-\u0001\u0007t_\u000e\\W\r^*feZ,'\u000f\u0005\u0002dM6\tAM\u0003\u0002f\u001d\u00059a.\u001a;x_J\\\u0017BA4e\u00051\u0019vnY6fiN+'O^3s\u0003\u0005\u001aXM\u001c3EK2,G/\u001a+pa&\u001c7OU3rk\u0016\u001cH\u000f\n3fM\u0006,H\u000e\u001e\u00133+\u0005Q'F\u00012lW\u0005a\u0007CA7s\u001b\u0005q'BA8q\u0003%)hn\u00195fG.,GM\u0003\u0002r;\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\u0005Mt'!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006\u00192/\u001a8e\u001b\u0016$\u0018\rZ1uCJ+\u0017/^3tiR\u0011a/\u001f\t\u0003_]L!\u0001\u001f\u0019\u0003!5+G/\u00193bi\u0006\u0014Vm\u001d9p]N,\u0007\"B\u0017\u000b\u0001\u0004Q\bCA\u0018|\u0013\ta\bGA\bNKR\fG-\u0019;b%\u0016\fX/Z:u\u0001")
public class DeleteTopicsRequestTest
extends BaseRequestTest {
    @Test
    public void testValidDeleteTopicRequests() {
        int timeout = 10000;
        this.createTopic("topic-1", 1, 1, this.createTopic$default$4());
        this.validateValidDeleteTopicRequests((DeleteTopicsRequest)new DeleteTopicsRequest.Builder(new DeleteTopicsRequestData().setTopicNames(Arrays.asList((Object[])new String[]{"topic-1"})).setTimeoutMs(timeout)).build());
        this.createTopic("topic-3", 5, 2, this.createTopic$default$4());
        this.createTopic("topic-4", 1, 2, this.createTopic$default$4());
        this.validateValidDeleteTopicRequests((DeleteTopicsRequest)new DeleteTopicsRequest.Builder(new DeleteTopicsRequestData().setTopicNames(Arrays.asList((Object[])new String[]{"topic-3", "topic-4"})).setTimeoutMs(timeout)).build());
    }

    private void validateValidDeleteTopicRequests(DeleteTopicsRequest request) {
        DeleteTopicsResponse response = this.sendDeleteTopicsRequest(request, this.sendDeleteTopicsRequest$default$2());
        Option error = ((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(response.errorCounts()).asScala()).find((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)DeleteTopicsRequestTest.$anonfun$validateValidDeleteTopicRequests$1(x$1)));
        Assert.assertTrue((String)new StringBuilder(33).append("There should be no errors, found ").append(JavaConverters$.MODULE$.collectionAsScalaIterableConverter((Collection)response.data().responses()).asScala()).toString(), (boolean)error.isEmpty());
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(request.data().topicNames()).asScala()).foreach((Function1 & Serializable & scala.Serializable)topic -> {
            this.validateTopicIsDeleted(topic);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testErrorDeleteTopicRequests() {
        int timeout = 30000;
        String timeoutTopic = "invalid-timeout";
        this.validateErrorDeleteTopicRequests((DeleteTopicsRequest)new DeleteTopicsRequest.Builder(new DeleteTopicsRequestData().setTopicNames(Arrays.asList((Object[])new String[]{"invalid-topic"})).setTimeoutMs(timeout)).build(), (Map<String, Errors>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"invalid-topic"), (Object)Errors.UNKNOWN_TOPIC_OR_PARTITION)}))));
        this.createTopic("partial-topic-1", 1, 1, this.createTopic$default$4());
        this.validateErrorDeleteTopicRequests((DeleteTopicsRequest)new DeleteTopicsRequest.Builder(new DeleteTopicsRequestData().setTopicNames(Arrays.asList((Object[])new String[]{"partial-topic-1", "partial-invalid-topic"})).setTimeoutMs(timeout)).build(), (Map<String, Errors>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partial-topic-1"), (Object)Errors.NONE), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partial-invalid-topic"), (Object)Errors.UNKNOWN_TOPIC_OR_PARTITION)}))));
        this.createTopic(timeoutTopic, 5, 2, this.createTopic$default$4());
        this.validateErrorDeleteTopicRequests((DeleteTopicsRequest)new DeleteTopicsRequest.Builder(new DeleteTopicsRequestData().setTopicNames(Arrays.asList((Object[])new String[]{timeoutTopic})).setTimeoutMs(0)).build(), (Map<String, Errors>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)timeoutTopic), (Object)Errors.REQUEST_TIMED_OUT)}))));
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> !((KafkaServer)this.servers().head()).metadataCache().contains(timeoutTopic), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(23).append("Topic ").append(timeoutTopic).append(" is never deleted").toString(), TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        this.validateTopicIsDeleted(timeoutTopic);
    }

    private void validateErrorDeleteTopicRequests(DeleteTopicsRequest request, Map<String, Errors> expectedResponse) {
        DeleteTopicsResponse response = this.sendDeleteTopicsRequest(request, this.sendDeleteTopicsRequest$default$2());
        DeleteTopicsResponseData.DeletableTopicResultCollection errors = response.data().responses();
        int errorCount = BoxesRunTime.unboxToInt((Object)((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(response.errorCounts()).asScala()).foldLeft((Object)BoxesRunTime.boxToInteger((int)0), (Function2 & Serializable & scala.Serializable)(x$2, x$3) -> BoxesRunTime.boxToInteger((int)DeleteTopicsRequestTest.$anonfun$validateErrorDeleteTopicRequests$1(BoxesRunTime.unboxToInt((Object)x$2), x$3))));
        Assert.assertEquals((String)"The response size should match", (long)expectedResponse.size(), (long)errorCount);
        expectedResponse.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            DeleteTopicsRequestTest.$anonfun$validateErrorDeleteTopicRequests$2(this, expectedResponse, errors, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testNotController() {
        DeleteTopicsRequest request = (DeleteTopicsRequest)new DeleteTopicsRequest.Builder(new DeleteTopicsRequestData().setTopicNames(Collections.singletonList("not-controller")).setTimeoutMs(1000)).build();
        DeleteTopicsResponse response = this.sendDeleteTopicsRequest(request, this.notControllerSocketServer());
        short error = response.data().responses().find("not-controller").errorCode();
        Assert.assertEquals((String)"Expected controller error when routed incorrectly", (long)Errors.NOT_CONTROLLER.code(), (long)error);
    }

    private void validateTopicIsDeleted(String topic) {
        Iterable metadata = (Iterable)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(this.sendMetadataRequest((MetadataRequest)new MetadataRequest.Builder((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)topic, (List)Nil$.MODULE$)).asJava(), true).build()).topicMetadata()).asScala();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> !metadata.exists((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)DeleteTopicsRequestTest.$anonfun$validateTopicIsDeleted$2(topic, p))), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(27).append("The topic ").append(topic).append(" should not exist").toString(), TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
    }

    private DeleteTopicsResponse sendDeleteTopicsRequest(DeleteTopicsRequest request, SocketServer socketServer) {
        ByteBuffer response = this.connectAndSend((AbstractRequest)request, ApiKeys.DELETE_TOPICS, socketServer, this.connectAndSend$default$4(), this.connectAndSend$default$5());
        return DeleteTopicsResponse.parse((ByteBuffer)response, (short)request.version());
    }

    private SocketServer sendDeleteTopicsRequest$default$2() {
        return this.controllerSocketServer();
    }

    private MetadataResponse sendMetadataRequest(MetadataRequest request) {
        ByteBuffer response = this.connectAndSend((AbstractRequest)request, ApiKeys.METADATA, this.connectAndSend$default$3(), this.connectAndSend$default$4(), this.connectAndSend$default$5());
        return MetadataResponse.parse((ByteBuffer)response, (short)request.version());
    }

    public static final /* synthetic */ boolean $anonfun$validateValidDeleteTopicRequests$1(Tuple2 x$1) {
        Object object = x$1._1();
        Errors errors = Errors.NONE;
        return object == null ? errors != null : !object.equals(errors);
    }

    public static final /* synthetic */ int $anonfun$validateErrorDeleteTopicRequests$1(int x$2, Tuple2 x$3) {
        return x$2 + Predef$.MODULE$.Integer2int((Integer)x$3._2());
    }

    public static final /* synthetic */ void $anonfun$validateErrorDeleteTopicRequests$2(DeleteTopicsRequestTest $this, Map expectedResponse$1, DeleteTopicsResponseData.DeletableTopicResultCollection errors$1, Tuple2 x0$1) {
        BoxedUnit boxedUnit;
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String topic = (String)tuple2._1();
            Errors expectedError = (Errors)tuple2._2();
            Assert.assertEquals((String)"The response error should match", (long)((Errors)expectedResponse$1.apply((Object)topic)).code(), (long)errors$1.find(topic).errorCode());
            Errors errors = expectedError;
            Errors errors2 = Errors.NONE;
            if (!(errors != null ? !errors.equals(errors2) : errors2 != null)) {
                $this.validateTopicIsDeleted(topic);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit2 = boxedUnit;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$validateTopicIsDeleted$2(String topic$1, MetadataResponse.TopicMetadata p) {
        if (!p.topic().equals(topic$1)) return false;
        Errors errors = p.error();
        Errors errors2 = Errors.NONE;
        if (errors != null) {
            if (!errors.equals(errors2)) return false;
            return true;
        }
        if (errors2 == null) return true;
        return false;
    }
}

