/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.io.Serializable;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.api.Request$;
import kafka.cluster.Partition;
import kafka.log.Log;
import kafka.log.LogManager;
import kafka.server.BrokerTopicStats;
import kafka.server.FetchDataInfo;
import kafka.server.FetchDataInfo$;
import kafka.server.FetchHighWatermark$;
import kafka.server.FetchIsolation;
import kafka.server.FetchLogEnd$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.LogDirFailureChannel;
import kafka.server.LogOffsetMetadata;
import kafka.server.LogOffsetMetadata$;
import kafka.server.LogReadResult;
import kafka.server.MetadataCache;
import kafka.server.QuotaFactory;
import kafka.server.QuotaFactory$;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaManager$;
import kafka.server.ReplicaQuota;
import kafka.utils.KafkaScheduler;
import kafka.utils.MockTime;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.utils.Time;
import org.easymock.EasyMock;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.Array$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005Uf\u0001\u0002\u0016,\u0001ABQa\u000e\u0001\u0005\u0002aBqa\u000f\u0001C\u0002\u0013\u0005A\b\u0003\u0004A\u0001\u0001\u0006I!\u0010\u0005\b\u0003\u0002\u0011\r\u0011\"\u0001C\u0011\u00191\u0005\u0001)A\u0005\u0007\"9q\t\u0001b\u0001\n\u0003a\u0004B\u0002%\u0001A\u0003%Q\bC\u0004J\u0001\t\u0007I\u0011\u0001&\t\rM\u0003\u0001\u0015!\u0003L\u0011\u001d!\u0006A1A\u0005\u0002UCaa\u0018\u0001!\u0002\u00131\u0006b\u00021\u0001\u0005\u0004%\t!\u0019\u0005\u0007Q\u0002\u0001\u000b\u0011\u00022\t\u000f%\u0004!\u0019!C\u0001U\"1q\u000f\u0001Q\u0001\n-Dq\u0001\u001f\u0001C\u0002\u0013\u0005A\b\u0003\u0004z\u0001\u0001\u0006I!\u0010\u0005\bu\u0002\u0011\r\u0011\"\u0001=\u0011\u0019Y\b\u0001)A\u0005{!9A\u0010\u0001b\u0001\n\u0003\u0011\u0005BB?\u0001A\u0003%1\tC\u0004\u007f\u0001\t\u0007I\u0011\u0001\"\t\r}\u0004\u0001\u0015!\u0003D\u0011%\t\t\u0001\u0001b\u0001\n\u0003\t\u0019\u0001\u0003\u0005\u0002\u0012\u0001\u0001\u000b\u0011BA\u0003\u0011%\t\u0019\u0002\u0001b\u0001\n\u0003\t\u0019\u0001\u0003\u0005\u0002\u0016\u0001\u0001\u000b\u0011BA\u0003\u0011%\t9\u0002\u0001b\u0001\n\u0003\tI\u0002\u0003\u0005\u0002(\u0001\u0001\u000b\u0011BA\u000e\u0011!\tI\u0003\u0001b\u0001\n\u0003\u0011\u0005bBA\u0016\u0001\u0001\u0006Ia\u0011\u0005\n\u0003[\u0001!\u0019!C\u0001\u0003_A\u0001\"!\u000f\u0001A\u0003%\u0011\u0011\u0007\u0005\n\u0003w\u0001!\u0019!C\u0001\u0003{A\u0001\"a\u001d\u0001A\u0003%\u0011q\b\u0005\f\u0003k\u0002\u0001\u0019!a\u0001\n\u0003\t9\bC\u0006\u0002\u0000\u0001\u0001\r\u00111A\u0005\u0002\u0005\u0005\u0005bCAG\u0001\u0001\u0007\t\u0011)Q\u0005\u0003sBq!a$\u0001\t\u0003\t\t\nC\u0004\u0002\"\u0002!\t!!%\t\u000f\u0005-\u0006\u0001\"\u0001\u0002\u0012\ny1+[7qY\u00164U\r^2i)\u0016\u001cHO\u0003\u0002-[\u000511/\u001a:wKJT\u0011AL\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001\u0011\u0007\u0005\u00023k5\t1GC\u00015\u0003\u0015\u00198-\u00197b\u0013\t14G\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003e\u0002\"A\u000f\u0001\u000e\u0003-\n1C]3qY&\u001c\u0017\rT1h)&lW-T1y\u001bN,\u0012!\u0010\t\u0003eyJ!aP\u001a\u0003\t1{gnZ\u0001\u0015e\u0016\u0004H.[2b\u0019\u0006<G+[7f\u001b\u0006DXj\u001d\u0011\u0002+I,\u0007\u000f\\5dC\u001a+Go\u00195XC&$X*\u0019=NgV\t1\t\u0005\u00023\t&\u0011Qi\r\u0002\u0004\u0013:$\u0018A\u0006:fa2L7-\u0019$fi\u000eDw+Y5u\u001b\u0006DXj\u001d\u0011\u0002+I,\u0007\u000f\\5dC2\u000bw-T1y\u001b\u0016\u001c8/Y4fg\u00061\"/\u001a9mS\u000e\fG*Y4NCblUm]:bO\u0016\u001c\b%A\bpm\u0016\u0014(/\u001b3j]\u001e\u0004&o\u001c9t+\u0005Y\u0005C\u0001'R\u001b\u0005i%B\u0001(P\u0003\u0011)H/\u001b7\u000b\u0003A\u000bAA[1wC&\u0011!+\u0014\u0002\u000b!J|\u0007/\u001a:uS\u0016\u001c\u0018\u0001E8wKJ\u0014\u0018\u000eZ5oOB\u0013x\u000e]:!\u0003\u001d\u0019wN\u001c4jON,\u0012A\u0016\t\u0004/jcV\"\u0001-\u000b\u0005e\u001b\u0014AC2pY2,7\r^5p]&\u00111\f\u0017\u0002\u0004'\u0016\f\bC\u0001\u001e^\u0013\tq6FA\u0006LC\u001a\\\u0017mQ8oM&<\u0017\u0001C2p]\u001aLwm\u001d\u0011\u0002\tQLW.Z\u000b\u0002EB\u00111MZ\u0007\u0002I*\u0011Q-L\u0001\u0006kRLGn]\u0005\u0003O\u0012\u0014\u0001\"T8dWRKW.Z\u0001\u0006i&lW\rI\u0001\b[\u0016$(/[2t+\u0005Y\u0007C\u00017v\u001b\u0005i'BA5o\u0015\ty\u0007/\u0001\u0004d_6lwN\u001c\u0006\u0003]ET!A]:\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005!\u0018aA8sO&\u0011a/\u001c\u0002\b\u001b\u0016$(/[2t\u0003!iW\r\u001e:jGN\u0004\u0013!\u00037fC\u0012,'\u000fT#P\u0003)aW-\u00193fe2+u\nI\u0001\fM>dGn\\<fe2+u*\u0001\u0007g_2dwn^3s\u0019\u0016{\u0005%A\u0006qCJ$\u0018\u000e^5p]\";\u0016\u0001\u00049beRLG/[8o\u0011^\u0003\u0013!\u00034fi\u000eD7+\u001b>f\u0003)1W\r^2i'&TX\rI\u0001\u000be\u0016\u001cwN\u001d3U_\";VCAA\u0003!\u0011\t9!!\u0004\u000e\u0005\u0005%!bAA\u0006]\u00061!/Z2pe\u0012LA!a\u0004\u0002\n\ta1+[7qY\u0016\u0014VmY8sI\u0006Y!/Z2pe\u0012$v\u000eS,!\u0003-\u0011XmY8sIR{G*R(\u0002\u0019I,7m\u001c:e)>dUi\u0014\u0011\u0002\u000bQ|\u0007/[2\u0016\u0005\u0005m\u0001\u0003BA\u000f\u0003Gi!!a\b\u000b\u0007\u0005\u0005r*\u0001\u0003mC:<\u0017\u0002BA\u0013\u0003?\u0011aa\u0015;sS:<\u0017A\u0002;pa&\u001c\u0007%A\u0006qCJ$\u0018\u000e^5p]&#\u0017\u0001\u00049beRLG/[8o\u0013\u0012\u0004\u0013A\u0004;pa&\u001c\u0007+\u0019:uSRLwN\\\u000b\u0003\u0003c\u0001B!a\r\u000265\ta.C\u0002\u000289\u0014a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g.A\bu_BL7\rU1si&$\u0018n\u001c8!\u0003%1W\r^2i\u0013:4w.\u0006\u0002\u0002@A!qKWA!!\u001d\u0011\u00141IA\u0019\u0003\u000fJ1!!\u00124\u0005\u0019!V\u000f\u001d7feA!\u0011\u0011JA7\u001d\u0011\tY%a\u001a\u000f\t\u00055\u00131\r\b\u0005\u0003\u001f\n\tG\u0004\u0003\u0002R\u0005}c\u0002BA*\u0003;rA!!\u0016\u0002\\5\u0011\u0011q\u000b\u0006\u0004\u00033z\u0013A\u0002\u001fs_>$h(C\u0001u\u0013\t\u00118/\u0003\u0002/c&\u0011q\u000e]\u0005\u0004\u0003Kr\u0017\u0001\u0003:fcV,7\u000f^:\n\t\u0005%\u00141N\u0001\r\r\u0016$8\r\u001b*fcV,7\u000f\u001e\u0006\u0004\u0003Kr\u0017\u0002BA8\u0003c\u0012Q\u0002U1si&$\u0018n\u001c8ECR\f'\u0002BA5\u0003W\n!BZ3uG\"LeNZ8!\u00039\u0011X\r\u001d7jG\u0006l\u0015M\\1hKJ,\"!!\u001f\u0011\u0007i\nY(C\u0002\u0002~-\u0012aBU3qY&\u001c\u0017-T1oC\u001e,'/\u0001\nsKBd\u0017nY1NC:\fw-\u001a:`I\u0015\fH\u0003BAB\u0003\u0013\u00032AMAC\u0013\r\t9i\r\u0002\u0005+:LG\u000fC\u0005\u0002\f\u0016\n\t\u00111\u0001\u0002z\u0005\u0019\u0001\u0010J\u0019\u0002\u001fI,\u0007\u000f\\5dC6\u000bg.Y4fe\u0002\nQa]3u+B$\"!a!)\u0007\u001d\n)\n\u0005\u0003\u0002\u0018\u0006uUBAAM\u0015\r\tYj]\u0001\u0006UVt\u0017\u000e^\u0005\u0005\u0003?\u000bIJ\u0001\u0004CK\u001a|'/Z\u0001\ti\u0016\f'\u000fR8x]\"\u001a\u0001&!*\u0011\t\u0005]\u0015qU\u0005\u0005\u0003S\u000bIJA\u0003BMR,'/A\buKN$(+Z1e\rJ|W\u000eT8hQ\rI\u0013q\u0016\t\u0005\u0003/\u000b\t,\u0003\u0003\u00024\u0006e%\u0001\u0002+fgR\u0004")
public class SimpleFetchTest {
    private final long replicaLagTimeMaxMs;
    private final int replicaFetchWaitMaxMs;
    private final long replicaLagMaxMessages;
    private final Properties overridingProps = new Properties();
    private final Seq<KafkaConfig> configs;
    private final MockTime time;
    private final Metrics metrics;
    private final long leaderLEO;
    private final long followerLEO;
    private final int partitionHW;
    private final int fetchSize;
    private final SimpleRecord recordToHW;
    private final SimpleRecord recordToLEO;
    private final String topic;
    private final int partitionId;
    private final TopicPartition topicPartition;
    private final Seq<Tuple2<TopicPartition, FetchRequest.PartitionData>> fetchInfo;
    private ReplicaManager replicaManager;

    public long replicaLagTimeMaxMs() {
        return this.replicaLagTimeMaxMs;
    }

    public int replicaFetchWaitMaxMs() {
        return this.replicaFetchWaitMaxMs;
    }

    public long replicaLagMaxMessages() {
        return this.replicaLagMaxMessages;
    }

    public Properties overridingProps() {
        return this.overridingProps;
    }

    public Seq<KafkaConfig> configs() {
        return this.configs;
    }

    public MockTime time() {
        return this.time;
    }

    public Metrics metrics() {
        return this.metrics;
    }

    public long leaderLEO() {
        return this.leaderLEO;
    }

    public long followerLEO() {
        return this.followerLEO;
    }

    public int partitionHW() {
        return this.partitionHW;
    }

    public int fetchSize() {
        return this.fetchSize;
    }

    public SimpleRecord recordToHW() {
        return this.recordToHW;
    }

    public SimpleRecord recordToLEO() {
        return this.recordToLEO;
    }

    public String topic() {
        return this.topic;
    }

    public int partitionId() {
        return this.partitionId;
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public Seq<Tuple2<TopicPartition, FetchRequest.PartitionData>> fetchInfo() {
        return this.fetchInfo;
    }

    public ReplicaManager replicaManager() {
        return this.replicaManager;
    }

    public void replicaManager_$eq(ReplicaManager x$1) {
        this.replicaManager = x$1;
    }

    @Before
    public void setUp() {
        KafkaZkClient kafkaZkClient = (KafkaZkClient)EasyMock.createNiceMock(KafkaZkClient.class);
        EasyMock.replay((Object[])new Object[]{kafkaZkClient});
        KafkaScheduler scheduler = (KafkaScheduler)EasyMock.createNiceMock(KafkaScheduler.class);
        EasyMock.replay((Object[])new Object[]{scheduler});
        Log log = (Log)EasyMock.createNiceMock(Log.class);
        EasyMock.expect((Object)BoxesRunTime.boxToLong((long)log.logStartOffset())).andReturn((Object)BoxesRunTime.boxToLong((long)0L)).anyTimes();
        EasyMock.expect((Object)BoxesRunTime.boxToLong((long)log.logEndOffset())).andReturn((Object)BoxesRunTime.boxToLong((long)this.leaderLEO())).anyTimes();
        EasyMock.expect((Object)log.dir()).andReturn((Object)TestUtils$.MODULE$.tempDir()).anyTimes();
        EasyMock.expect((Object)log.logEndOffsetMetadata()).andReturn((Object)new LogOffsetMetadata(this.leaderLEO(), LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3())).anyTimes();
        EasyMock.expect((Object)log.maybeIncrementHighWatermark((LogOffsetMetadata)EasyMock.anyObject())).andReturn((Object)new Some((Object)new LogOffsetMetadata((long)this.partitionHW(), LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()))).anyTimes();
        EasyMock.expect((Object)BoxesRunTime.boxToLong((long)log.highWatermark())).andReturn((Object)BoxesRunTime.boxToLong((long)this.partitionHW())).anyTimes();
        EasyMock.expect((Object)BoxesRunTime.boxToLong((long)log.lastStableOffset())).andReturn((Object)BoxesRunTime.boxToLong((long)this.partitionHW())).anyTimes();
        EasyMock.expect((Object)log.read(0L, this.fetchSize(), (FetchIsolation)FetchHighWatermark$.MODULE$, true)).andReturn((Object)new FetchDataInfo(new LogOffsetMetadata(0L, 0L, 0), (Records)MemoryRecords.withRecords((CompressionType)CompressionType.NONE, (SimpleRecord[])new SimpleRecord[]{this.recordToHW()}), FetchDataInfo$.MODULE$.apply$default$3(), FetchDataInfo$.MODULE$.apply$default$4())).anyTimes();
        EasyMock.expect((Object)log.read(0L, this.fetchSize(), (FetchIsolation)FetchLogEnd$.MODULE$, true)).andReturn((Object)new FetchDataInfo(new LogOffsetMetadata(0L, 0L, 0), (Records)MemoryRecords.withRecords((CompressionType)CompressionType.NONE, (SimpleRecord[])new SimpleRecord[]{this.recordToLEO()}), FetchDataInfo$.MODULE$.apply$default$3(), FetchDataInfo$.MODULE$.apply$default$4())).anyTimes();
        EasyMock.replay((Object[])new Object[]{log});
        LogManager logManager = (LogManager)EasyMock.createMock(LogManager.class);
        EasyMock.expect((Object)logManager.getLog(this.topicPartition(), false)).andReturn((Object)new Some((Object)log)).anyTimes();
        EasyMock.expect((Object)logManager.liveLogDirs()).andReturn((Object)Predef$.MODULE$.wrapRefArray((Object[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(File.class)))).anyTimes();
        EasyMock.replay((Object[])new Object[]{logManager});
        this.replicaManager_$eq(new ReplicaManager((KafkaConfig)this.configs().head(), this.metrics(), (Time)this.time(), kafkaZkClient, (Scheduler)scheduler, logManager, new AtomicBoolean(false), QuotaFactory$.MODULE$.instantiate((KafkaConfig)this.configs().head(), this.metrics(), (Time)this.time(), ""), new BrokerTopicStats(), new MetadataCache(((KafkaConfig)this.configs().head()).brokerId()), new LogDirFailureChannel(((KafkaConfig)this.configs().head()).logDirs().size()), ReplicaManager$.MODULE$.$lessinit$greater$default$12()));
        Partition partition = this.replicaManager().createPartition(new TopicPartition(this.topic(), this.partitionId()));
        log.updateHighWatermark((long)this.partitionHW());
        partition.leaderReplicaIdOpt_$eq((Option)new Some((Object)BoxesRunTime.boxToInteger((int)((KafkaConfig)this.configs().head()).brokerId())));
        partition.setLog(log, false);
        int followerId = ((KafkaConfig)this.configs().apply(1)).brokerId();
        Seq allReplicas = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{((KafkaConfig)this.configs().head()).brokerId(), followerId}));
        partition.updateAssignmentAndIsr(allReplicas, allReplicas.toSet());
        LogOffsetMetadata leo = new LogOffsetMetadata(this.followerLEO(), 0L, (int)this.followerLEO());
        partition.updateFollowerFetchState(followerId, leo, 0L, this.time().milliseconds(), leo.messageOffset(), partition.localLogOrException().highWatermark());
    }

    @After
    public void tearDown() {
        this.replicaManager().shutdown(false);
        this.metrics().close();
    }

    @Test
    public void testReadFromLog() {
        BrokerTopicStats brokerTopicStats = new BrokerTopicStats();
        long initialTopicCount = brokerTopicStats.topicStats(this.topic()).totalFetchRequestRate().count();
        long initialAllTopicsCount = brokerTopicStats.allTopicsStats().totalFetchRequestRate().count();
        Option readCommittedRecords = this.replicaManager().readFromLocalLog(Request$.MODULE$.OrdinaryConsumerId(), true, (FetchIsolation)FetchHighWatermark$.MODULE$, Integer.MAX_VALUE, false, this.fetchInfo(), (ReplicaQuota)QuotaFactory.UnboundedQuota$.MODULE$, (Option)None$.MODULE$).find((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)SimpleFetchTest.$anonfun$testReadFromLog$1(this, x$2)));
        Record firstReadRecord = (Record)((LogReadResult)((Tuple2)readCommittedRecords.get())._2()).info().records().records().iterator().next();
        Assert.assertEquals((String)"Reading committed data should return messages only up to high watermark", (Object)this.recordToHW(), (Object)new SimpleRecord(firstReadRecord));
        Option readAllRecords = this.replicaManager().readFromLocalLog(Request$.MODULE$.OrdinaryConsumerId(), true, (FetchIsolation)FetchLogEnd$.MODULE$, Integer.MAX_VALUE, false, this.fetchInfo(), (ReplicaQuota)QuotaFactory.UnboundedQuota$.MODULE$, (Option)None$.MODULE$).find((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)SimpleFetchTest.$anonfun$testReadFromLog$2(this, x$3)));
        Record firstRecord = (Record)((LogReadResult)((Tuple2)readAllRecords.get())._2()).info().records().records().iterator().next();
        Assert.assertEquals((String)"Reading any data can return messages up to the end of the log", (Object)this.recordToLEO(), (Object)new SimpleRecord(firstRecord));
        Assert.assertEquals((String)"Counts should increment after fetch", (long)(initialTopicCount + 2L), (long)brokerTopicStats.topicStats(this.topic()).totalFetchRequestRate().count());
        Assert.assertEquals((String)"Counts should increment after fetch", (long)(initialAllTopicsCount + 2L), (long)brokerTopicStats.allTopicsStats().totalFetchRequestRate().count());
    }

    public static final /* synthetic */ boolean $anonfun$testReadFromLog$1(SimpleFetchTest $this, Tuple2 x$2) {
        Object object = x$2._1();
        TopicPartition topicPartition = $this.topicPartition();
        return !(object != null ? !object.equals(topicPartition) : topicPartition != null);
    }

    public static final /* synthetic */ boolean $anonfun$testReadFromLog$2(SimpleFetchTest $this, Tuple2 x$3) {
        Object object = x$3._1();
        TopicPartition topicPartition = $this.topicPartition();
        return !(object != null ? !object.equals(topicPartition) : topicPartition != null);
    }

    public SimpleFetchTest() {
        this.replicaLagTimeMaxMs = 100L;
        this.replicaFetchWaitMaxMs = 100;
        this.replicaLagMaxMessages = 10L;
        this.overridingProps().put(KafkaConfig$.MODULE$.ReplicaLagTimeMaxMsProp(), ((Object)BoxesRunTime.boxToLong((long)this.replicaLagTimeMaxMs())).toString());
        this.overridingProps().put(KafkaConfig$.MODULE$.ReplicaFetchWaitMaxMsProp(), ((Object)BoxesRunTime.boxToInteger((int)this.replicaFetchWaitMaxMs())).toString());
        this.configs = (Seq)TestUtils$.MODULE$.createBrokerConfigs(2, TestUtils$.MODULE$.MockZkConnect(), TestUtils$.MODULE$.createBrokerConfigs$default$3(), TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13(), TestUtils$.MODULE$.createBrokerConfigs$default$14(), TestUtils$.MODULE$.createBrokerConfigs$default$15(), TestUtils$.MODULE$.createBrokerConfigs$default$16()).map((Function1 & Serializable & scala.Serializable)x$1 -> KafkaConfig$.MODULE$.fromProps(x$1, this.overridingProps()), Seq$.MODULE$.canBuildFrom());
        this.time = new MockTime();
        this.metrics = new Metrics();
        this.leaderLEO = 20L;
        this.followerLEO = 15L;
        this.partitionHW = 5;
        this.fetchSize = 100;
        this.recordToHW = new SimpleRecord("recordToHW".getBytes());
        this.recordToLEO = new SimpleRecord("recordToLEO".getBytes());
        this.topic = "test-topic";
        this.partitionId = 0;
        this.topicPartition = new TopicPartition(this.topic(), this.partitionId());
        this.fetchInfo = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)new FetchRequest.PartitionData(0L, 0L, this.fetchSize(), Optional.empty()))}));
    }
}

