/*
 * Decompiled with CFR 0.152.
 */
package kafka.utils.json;

import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Serializable;
import kafka.utils.Json$;
import kafka.utils.json.DecodeJson;
import kafka.utils.json.DecodeJson$;
import kafka.utils.json.JsonObject;
import kafka.utils.json.JsonValue;
import org.junit.Assert;
import org.junit.Test;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.Map$;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.Vector$;
import scala.package$;
import scala.reflect.Manifest;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.control.Exception$;

@ScalaSignature(bytes="\u0006\u0001\u0005=d\u0001B\u000e\u001d\u0001\rBQA\u000b\u0001\u0005\u0002-Bq!\b\u0001C\u0002\u0013%a\u0006\u0003\u0004;\u0001\u0001\u0006Ia\f\u0005\u0006w\u0001!I\u0001\u0010\u0005\u0006\u0005\u0002!Ia\u0011\u0005\u0006G\u0002!I\u0001\u001a\u0005\u0006[\u0002!\tA\u001c\u0005\b\u0003#\u0001A\u0011AA\n\u0011\u001d\t9\u0003\u0001C\u0001\u0003'Aq!a\u000b\u0001\t\u0003\t\u0019\u0002C\u0004\u00020\u0001!\t!a\u0005\t\u000f\u0005M\u0002\u0001\"\u0001\u0002\u0014!9\u0011q\u0007\u0001\u0005\u0002\u0005M\u0001bBA\u001e\u0001\u0011\u0005\u00111\u0003\u0005\b\u0003\u007f\u0001A\u0011AA\n\u0011\u001d\t\u0019\u0005\u0001C\u0001\u0003'Aq!a\u0012\u0001\t\u0003\t\u0019\u0002C\u0004\u0002L\u0001!\t!a\u0005\t\u000f\u0005=\u0003\u0001\"\u0001\u0002\u0014!9\u00111\u000b\u0001\u0005\u0002\u0005M\u0001bBA,\u0001\u0011\u0005\u00111\u0003\u0005\b\u00037\u0002A\u0011AA\n\u0011\u001d\ty\u0006\u0001C\u0001\u0003'Aq!a\u0019\u0001\t\u0003\t\u0019\u0002C\u0004\u0002h\u0001!\t!a\u0005\t\u000f\u0005-\u0004\u0001\"\u0001\u0002\u0014\ti!j]8o-\u0006dW/\u001a+fgRT!!\b\u0010\u0002\t)\u001cxN\u001c\u0006\u0003?\u0001\nQ!\u001e;jYNT\u0011!I\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001A\u0005\u0005\u0002&Q5\taEC\u0001(\u0003\u0015\u00198-\u00197b\u0013\tIcE\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u00031\u0002\"!\f\u0001\u000e\u0003q)\u0012a\f\t\u0003a]r!!M\u001b\u0011\u0005I2S\"A\u001a\u000b\u0005Q\u0012\u0013A\u0002\u001fs_>$h(\u0003\u00027M\u00051\u0001K]3eK\u001aL!\u0001O\u001d\u0003\rM#(/\u001b8h\u0015\t1d%A\u0003kg>t\u0007%A\u0003qCJ\u001cX\r\u0006\u0002>\u0001B\u0011QFP\u0005\u0003\u007fq\u0011\u0011BS:p]Z\u000bG.^3\t\u000b\u0005#\u0001\u0019A\u0018\u0002\u0003M\f\u0001\"Y:tKJ$Hk\\\u000b\u0003\tB#2!R-\\)\t1\u0015\n\u0005\u0002&\u000f&\u0011\u0001J\n\u0002\u0005+:LG\u000fC\u0004K\u000b\u0005\u0005\t9A&\u0002\u0015\u00154\u0018\u000eZ3oG\u0016$\u0013\u0007E\u0002.\u0019:K!!\u0014\u000f\u0003\u0015\u0011+7m\u001c3f\u0015N|g\u000e\u0005\u0002P!2\u0001A!B)\u0006\u0005\u0004\u0011&!\u0001+\u0012\u0005M3\u0006CA\u0013U\u0013\t)fEA\u0004O_RD\u0017N\\4\u0011\u0005\u0015:\u0016B\u0001-'\u0005\r\te.\u001f\u0005\u00065\u0016\u0001\rAT\u0001\tKb\u0004Xm\u0019;fI\")A,\u0002a\u0001;\u0006I!n]8o-\u0006dW/\u001a\t\u0005Ky\u0003W(\u0003\u0002`M\tIa)\u001e8di&|g.\r\t\u0003[\u0005L!A\u0019\u000f\u0003\u0015)\u001bxN\\(cU\u0016\u001cG/A\u0007bgN,'\u000f\u001e+p\r\u0006LGn]\u000b\u0003K.$\"A\u001a7\u0015\u0005\u0019;\u0007b\u00025\u0007\u0003\u0003\u0005\u001d![\u0001\u000bKZLG-\u001a8dK\u0012\u0012\u0004cA\u0017MUB\u0011qj\u001b\u0003\u0006#\u001a\u0011\rA\u0015\u0005\u00069\u001a\u0001\r!X\u0001\fCN\u001cXM\u001d;UQJ|w/\u0006\u0002poR\u0019\u0001/a\u0002\u0015\u0005\u0019\u000b\bb\u0002:\b\u0003\u0003\u0005\u001da]\u0001\u000bKZLG-\u001a8dK\u0012\u001a\u0004c\u0001\u0019um&\u0011Q/\u000f\u0002\t\u001b\u0006t\u0017NZ3tiB\u0011qj\u001e\u0003\u0006q\u001e\u0011\r!\u001f\u0002\u0002\u000bF\u00111K\u001f\t\u0004w\u0006\u0005aB\u0001?\u007f\u001d\t\u0011T0C\u0001(\u0013\tyh%A\u0004qC\u000e\\\u0017mZ3\n\t\u0005\r\u0011Q\u0001\u0002\n)\"\u0014xn^1cY\u0016T!a \u0014\t\u0011\u0005%q\u0001\"a\u0001\u0003\u0017\tAAY8esB!Q%!\u0004G\u0013\r\tyA\n\u0002\ty\tLh.Y7f}\u0005\u0001B/Z:u\u0003NT5o\u001c8PE*,7\r\u001e\u000b\u0002\r\"\u001a\u0001\"a\u0006\u0011\t\u0005e\u00111E\u0007\u0003\u00037QA!!\b\u0002 \u0005)!.\u001e8ji*\u0011\u0011\u0011E\u0001\u0004_J<\u0017\u0002BA\u0013\u00037\u0011A\u0001V3ti\u00061B/Z:u\u0003NT5o\u001c8PE*,7\r^(qi&|g\u000eK\u0002\n\u0003/\tq\u0002^3ti\u0006\u001b(j]8o\u0003J\u0014\u0018-\u001f\u0015\u0004\u0015\u0005]\u0011!\u0006;fgR\f5OS:p]\u0006\u0013(/Y=PaRLwN\u001c\u0015\u0004\u0017\u0005]\u0011!\u0005;fgRT5o\u001c8PE*,7\r^$fi\"\u001aA\"a\u0006\u0002'Q,7\u000f\u001e&t_:|%M[3di\u0006\u0003\b\u000f\\=)\u00075\t9\"\u0001\fuKN$(j]8o\u001f\nTWm\u0019;Ji\u0016\u0014\u0018\r^8sQ\rq\u0011qC\u0001\u0016i\u0016\u001cHOS:p]\u0006\u0013(/Y=Ji\u0016\u0014\u0018\r^8sQ\ry\u0011qC\u0001\u0014i\u0016\u001cHOS:p]Z\u000bG.^3FcV\fGn\u001d\u0015\u0004!\u0005]\u0011!\u0006;fgRT5o\u001c8WC2,X\rS1tQ\u000e{G-\u001a\u0015\u0004#\u0005]\u0011!\u0006;fgRT5o\u001c8WC2,X\rV8TiJLgn\u001a\u0015\u0004%\u0005]\u0011!\u0005;fgR$UmY8eK\n{w\u000e\\3b]\"\u001a1#a\u0006\u0002!Q,7\u000f\u001e#fG>$Wm\u0015;sS:<\u0007f\u0001\u000b\u0002\u0018\u0005iA/Z:u\t\u0016\u001cw\u000eZ3J]RD3!FA\f\u00039!Xm\u001d;EK\u000e|G-\u001a'p]\u001eD3AFA\f\u0003A!Xm\u001d;EK\u000e|G-\u001a#pk\ndW\rK\u0002\u0018\u0003/\tQ\u0002^3ti\u0012+7m\u001c3f'\u0016\f\bf\u0001\r\u0002\u0018\u0005iA/Z:u\t\u0016\u001cw\u000eZ3NCBD3!GA\f\u0003A!Xm\u001d;EK\u000e|G-Z(qi&|g\u000eK\u0002\u001b\u0003/\u0001")
public class JsonValueTest {
    private final String json = new StringOps(Predef$.MODULE$.augmentString("\n    |{\n    |  \"boolean\": false,\n    |  \"int\": 1234,\n    |  \"long\": 3000000000,\n    |  \"double\": 16.244355,\n    |  \"string\": \"string\",\n    |  \"number_as_string\": \"123\",\n    |  \"array\": [4.0, 11.1, 44.5],\n    |  \"object\": {\n    |    \"a\": true,\n    |    \"b\": false\n    |  },\n    |  \"null\": null\n    |}\n   ")).stripMargin();

    private String json() {
        return this.json;
    }

    private JsonValue parse(String s) {
        return (JsonValue)Json$.MODULE$.parseFull(s).getOrElse((Function0 & Serializable & scala.Serializable)() -> scala.sys.package$.MODULE$.error(new StringBuilder(22).append("Failed to parse json: ").append(s).toString()));
    }

    private <T> void assertTo(T expected, Function1<JsonObject, JsonValue> jsonValue, DecodeJson<T> evidence$1) {
        JsonValue parsed = (JsonValue)jsonValue.apply((Object)this.parse(this.json()).asJsonObject());
        Assert.assertEquals((Object)package$.MODULE$.Right().apply(expected), (Object)parsed.toEither(evidence$1));
        Assert.assertEquals(expected, (Object)parsed.to(evidence$1));
    }

    private <T> void assertToFails(Function1<JsonObject, JsonValue> jsonValue, DecodeJson<T> evidence$2) {
        JsonValue parsed = (JsonValue)jsonValue.apply((Object)this.parse(this.json()).asJsonObject());
        Assert.assertTrue((boolean)parsed.toEither(evidence$2).isLeft());
        this.assertThrow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> parsed.to(evidence$2), ManifestFactory$.MODULE$.classType(JsonMappingException.class));
    }

    public <E extends Throwable> void assertThrow(Function0<BoxedUnit> body, Manifest<E> evidence$3) {
        Class klass = Predef$.MODULE$.manifest(evidence$3).runtimeClass();
        Exception$.MODULE$.catchingPromiscuously((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Class[]{klass})).opt(body).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            JsonValueTest.$anonfun$assertThrow$1(klass, x$1);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testAsJsonObject() {
        JsonObject parsed = this.parse(this.json()).asJsonObject();
        JsonValue obj = parsed.apply("object");
        Assert.assertEquals((Object)obj, (Object)obj.asJsonObject());
        this.assertThrow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> parsed.apply("array").asJsonObject(), ManifestFactory$.MODULE$.classType(JsonMappingException.class));
    }

    @Test
    public void testAsJsonObjectOption() {
        JsonObject parsed = this.parse(this.json()).asJsonObject();
        Assert.assertTrue((boolean)parsed.apply("object").asJsonObjectOption().isDefined());
        Assert.assertEquals((Object)None$.MODULE$, (Object)parsed.apply("array").asJsonObjectOption());
    }

    @Test
    public void testAsJsonArray() {
        JsonObject parsed = this.parse(this.json()).asJsonObject();
        JsonValue array = parsed.apply("array");
        Assert.assertEquals((Object)array, (Object)array.asJsonArray());
        this.assertThrow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> parsed.apply("object").asJsonArray(), ManifestFactory$.MODULE$.classType(JsonMappingException.class));
    }

    @Test
    public void testAsJsonArrayOption() {
        JsonObject parsed = this.parse(this.json()).asJsonObject();
        Assert.assertTrue((boolean)parsed.apply("array").asJsonArrayOption().isDefined());
        Assert.assertEquals((Object)None$.MODULE$, (Object)parsed.apply("object").asJsonArrayOption());
    }

    @Test
    public void testJsonObjectGet() {
        JsonObject parsed = this.parse(this.json()).asJsonObject();
        Assert.assertEquals((Object)new Some((Object)this.parse("{\"a\":true,\"b\":false}")), (Object)parsed.get("object"));
        Assert.assertEquals((Object)None$.MODULE$, (Object)parsed.get("aaaaa"));
    }

    @Test
    public void testJsonObjectApply() {
        JsonObject parsed = this.parse(this.json()).asJsonObject();
        Assert.assertEquals((Object)this.parse("{\"a\":true,\"b\":false}"), (Object)parsed.apply("object"));
        this.assertThrow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> parsed.apply("aaaaaaaa"), ManifestFactory$.MODULE$.classType(JsonMappingException.class));
    }

    @Test
    public void testJsonObjectIterator() {
        Assert.assertEquals((Object)package$.MODULE$.Vector().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)this.parse("true")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)this.parse("false"))})), (Object)this.parse(this.json()).asJsonObject().apply("object").asJsonObject().iterator().toVector());
    }

    @Test
    public void testJsonArrayIterator() {
        Assert.assertEquals((Object)((TraversableLike)package$.MODULE$.Vector().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"4.0", "11.1", "44.5"}))).map((Function1 & Serializable & scala.Serializable)s -> this.parse((String)s), Vector$.MODULE$.canBuildFrom()), (Object)this.parse(this.json()).asJsonObject().apply("array").asJsonArray().iterator().toVector());
    }

    @Test
    public void testJsonValueEquals() {
        Assert.assertEquals((Object)this.parse(this.json()), (Object)this.parse(this.json()));
        Assert.assertEquals((Object)this.parse("{\"blue\": true, \"red\": false}"), (Object)this.parse("{\"red\": false, \"blue\": true}"));
        Assert.assertNotEquals((Object)this.parse("{\"blue\": true, \"red\": true}"), (Object)this.parse("{\"red\": false, \"blue\": true}"));
        Assert.assertEquals((Object)this.parse("[1, 2, 3]"), (Object)this.parse("[1, 2, 3]"));
        Assert.assertNotEquals((Object)this.parse("[1, 2, 3]"), (Object)this.parse("[2, 1, 3]"));
        Assert.assertEquals((Object)this.parse("1344"), (Object)this.parse("1344"));
        Assert.assertNotEquals((Object)this.parse("1344"), (Object)this.parse("144"));
    }

    @Test
    public void testJsonValueHashCode() {
        Assert.assertEquals((long)new ObjectMapper().readTree(this.json()).hashCode(), (long)this.parse(this.json()).hashCode());
    }

    @Test
    public void testJsonValueToString() {
        String js = "{\"boolean\":false,\"int\":1234,\"array\":[4.0,11.1,44.5],\"object\":{\"a\":true,\"b\":false}}";
        Assert.assertEquals((Object)js, (Object)this.parse(js).toString());
    }

    @Test
    public void testDecodeBoolean() {
        this.assertTo((Object)BoxesRunTime.boxToBoolean((boolean)false), (Function1<JsonObject, JsonValue>)(Function1 & Serializable & scala.Serializable)x$2 -> x$2.apply("boolean"), (DecodeJson)DecodeJson.DecodeBoolean$.MODULE$);
        this.assertToFails((Function1<JsonObject, JsonValue>)(Function1 & Serializable & scala.Serializable)x$3 -> x$3.apply("int"), (DecodeJson)DecodeJson.DecodeBoolean$.MODULE$);
    }

    @Test
    public void testDecodeString() {
        this.assertTo((Object)"string", (Function1<JsonObject, JsonValue>)(Function1 & Serializable & scala.Serializable)x$4 -> x$4.apply("string"), (DecodeJson)DecodeJson.DecodeString$.MODULE$);
        this.assertTo((Object)"123", (Function1<JsonObject, JsonValue>)(Function1 & Serializable & scala.Serializable)x$5 -> x$5.apply("number_as_string"), (DecodeJson)DecodeJson.DecodeString$.MODULE$);
        this.assertToFails((Function1<JsonObject, JsonValue>)(Function1 & Serializable & scala.Serializable)x$6 -> x$6.apply("int"), (DecodeJson)DecodeJson.DecodeString$.MODULE$);
        this.assertToFails((Function1<JsonObject, JsonValue>)(Function1 & Serializable & scala.Serializable)x$7 -> x$7.apply("array"), (DecodeJson)DecodeJson.DecodeString$.MODULE$);
    }

    @Test
    public void testDecodeInt() {
        this.assertTo((Object)BoxesRunTime.boxToInteger((int)1234), (Function1<JsonObject, JsonValue>)(Function1 & Serializable & scala.Serializable)x$8 -> x$8.apply("int"), (DecodeJson)DecodeJson.DecodeInt$.MODULE$);
        this.assertToFails((Function1<JsonObject, JsonValue>)(Function1 & Serializable & scala.Serializable)x$9 -> x$9.apply("long"), (DecodeJson)DecodeJson.DecodeInt$.MODULE$);
    }

    @Test
    public void testDecodeLong() {
        this.assertTo((Object)BoxesRunTime.boxToLong((long)3000000000L), (Function1<JsonObject, JsonValue>)(Function1 & Serializable & scala.Serializable)x$10 -> x$10.apply("long"), (DecodeJson)DecodeJson.DecodeLong$.MODULE$);
        this.assertTo((Object)BoxesRunTime.boxToLong((long)1234L), (Function1<JsonObject, JsonValue>)(Function1 & Serializable & scala.Serializable)x$11 -> x$11.apply("int"), (DecodeJson)DecodeJson.DecodeLong$.MODULE$);
        this.assertToFails((Function1<JsonObject, JsonValue>)(Function1 & Serializable & scala.Serializable)x$12 -> x$12.apply("string"), (DecodeJson)DecodeJson.DecodeLong$.MODULE$);
    }

    @Test
    public void testDecodeDouble() {
        this.assertTo((Object)BoxesRunTime.boxToDouble((double)16.244355), (Function1<JsonObject, JsonValue>)(Function1 & Serializable & scala.Serializable)x$13 -> x$13.apply("double"), (DecodeJson)DecodeJson.DecodeDouble$.MODULE$);
        this.assertTo((Object)BoxesRunTime.boxToDouble((double)1234.0), (Function1<JsonObject, JsonValue>)(Function1 & Serializable & scala.Serializable)x$14 -> x$14.apply("int"), (DecodeJson)DecodeJson.DecodeDouble$.MODULE$);
        this.assertTo((Object)BoxesRunTime.boxToDouble((double)3.0E9), (Function1<JsonObject, JsonValue>)(Function1 & Serializable & scala.Serializable)x$15 -> x$15.apply("long"), (DecodeJson)DecodeJson.DecodeDouble$.MODULE$);
        this.assertToFails((Function1<JsonObject, JsonValue>)(Function1 & Serializable & scala.Serializable)x$16 -> x$16.apply("string"), (DecodeJson)DecodeJson.DecodeDouble$.MODULE$);
    }

    @Test
    public void testDecodeSeq() {
        this.assertTo(Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{4.0, 11.1, 44.5})), (Function1<JsonObject, JsonValue>)(Function1 & Serializable & scala.Serializable)x$17 -> x$17.apply("array"), DecodeJson$.MODULE$.decodeSeq((DecodeJson)DecodeJson.DecodeDouble$.MODULE$, Predef$.MODULE$.fallbackStringCanBuildFrom()));
        this.assertToFails((Function1<JsonObject, JsonValue>)(Function1 & Serializable & scala.Serializable)x$18 -> x$18.apply("string"), DecodeJson$.MODULE$.decodeSeq((DecodeJson)DecodeJson.DecodeDouble$.MODULE$, Predef$.MODULE$.fallbackStringCanBuildFrom()));
        this.assertToFails((Function1<JsonObject, JsonValue>)(Function1 & Serializable & scala.Serializable)x$19 -> x$19.apply("object"), DecodeJson$.MODULE$.decodeSeq((DecodeJson)DecodeJson.DecodeDouble$.MODULE$, Predef$.MODULE$.fallbackStringCanBuildFrom()));
        this.assertToFails((Function1<JsonObject, JsonValue>)(Function1 & Serializable & scala.Serializable)x$20 -> x$20.apply("array"), DecodeJson$.MODULE$.decodeSeq((DecodeJson)DecodeJson.DecodeString$.MODULE$, Predef$.MODULE$.fallbackStringCanBuildFrom()));
    }

    @Test
    public void testDecodeMap() {
        this.assertTo(Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)BoxesRunTime.boxToBoolean((boolean)true)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)BoxesRunTime.boxToBoolean((boolean)false))})), (Function1<JsonObject, JsonValue>)(Function1 & Serializable & scala.Serializable)x$21 -> x$21.apply("object"), DecodeJson$.MODULE$.decodeMap((DecodeJson)DecodeJson.DecodeBoolean$.MODULE$, Map$.MODULE$.canBuildFrom()));
        this.assertToFails((Function1<JsonObject, JsonValue>)(Function1 & Serializable & scala.Serializable)x$22 -> x$22.apply("object"), DecodeJson$.MODULE$.decodeMap((DecodeJson)DecodeJson.DecodeInt$.MODULE$, Map$.MODULE$.canBuildFrom()));
        this.assertToFails((Function1<JsonObject, JsonValue>)(Function1 & Serializable & scala.Serializable)x$23 -> x$23.apply("object"), DecodeJson$.MODULE$.decodeMap((DecodeJson)DecodeJson.DecodeString$.MODULE$, Map$.MODULE$.canBuildFrom()));
        this.assertToFails((Function1<JsonObject, JsonValue>)(Function1 & Serializable & scala.Serializable)x$24 -> x$24.apply("array"), DecodeJson$.MODULE$.decodeMap((DecodeJson)DecodeJson.DecodeDouble$.MODULE$, Map$.MODULE$.canBuildFrom()));
    }

    @Test
    public void testDecodeOption() {
        this.assertTo(None$.MODULE$, (Function1<JsonObject, JsonValue>)(Function1 & Serializable & scala.Serializable)x$25 -> x$25.apply("null"), DecodeJson$.MODULE$.decodeOption((DecodeJson)DecodeJson.DecodeInt$.MODULE$));
        this.assertTo(new Some((Object)BoxesRunTime.boxToInteger((int)1234)), (Function1<JsonObject, JsonValue>)(Function1 & Serializable & scala.Serializable)x$26 -> x$26.apply("int"), DecodeJson$.MODULE$.decodeOption((DecodeJson)DecodeJson.DecodeInt$.MODULE$));
        this.assertToFails((Function1<JsonObject, JsonValue>)(Function1 & Serializable & scala.Serializable)x$27 -> x$27.apply("int"), DecodeJson$.MODULE$.decodeOption((DecodeJson)DecodeJson.DecodeString$.MODULE$));
    }

    public static final /* synthetic */ void $anonfun$assertThrow$1(Class klass$1, BoxedUnit x$1) {
        Assert.fail((String)new StringBuilder(53).append("Expected `").append(klass$1).append("` to be thrown, but no exception was thrown").toString());
    }
}

