/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.util.Arrays;
import kafka.log.OffsetMap;
import kafka.log.SkimpyOffsetMap$;
import kafka.utils.CoreUtils$;
import org.apache.kafka.common.utils.Utils;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.math.package$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005=f\u0001\u0002\u00180\u0001QB\u0001b\u0010\u0001\u0003\u0006\u0004%\t\u0001\u0011\u0005\t\t\u0002\u0011\t\u0011)A\u0005\u0003\"AQ\t\u0001BC\u0002\u0013\u0005a\t\u0003\u0005S\u0001\t\u0005\t\u0015!\u0003H\u0011\u0015\u0019\u0006\u0001\"\u0001U\u0011\u001dA\u0006A1A\u0005\neCaA\u0019\u0001!\u0002\u0013Q\u0006bB2\u0001\u0005\u0004%I\u0001\u001a\u0005\u0007W\u0002\u0001\u000b\u0011B3\t\u000f1\u0004!\u0019!C\u0005\u0001\"1Q\u000e\u0001Q\u0001\n\u0005CqA\u001c\u0001C\u0002\u0013%q\u000e\u0003\u0004w\u0001\u0001\u0006I\u0001\u001d\u0005\bo\u0002\u0011\r\u0011\"\u0003p\u0011\u0019A\b\u0001)A\u0005a\"9\u0011\u0010\u0001a\u0001\n\u0013\u0001\u0005b\u0002>\u0001\u0001\u0004%Ia\u001f\u0005\b\u0003\u0007\u0001\u0001\u0015)\u0003B\u0011%\t)\u0001\u0001a\u0001\n\u0013\t9\u0001C\u0005\u0002\u0010\u0001\u0001\r\u0011\"\u0003\u0002\u0012!A\u0011Q\u0003\u0001!B\u0013\tI\u0001C\u0005\u0002\u0018\u0001\u0001\r\u0011\"\u0003\u0002\b!I\u0011\u0011\u0004\u0001A\u0002\u0013%\u00111\u0004\u0005\t\u0003?\u0001\u0001\u0015)\u0003\u0002\n!I\u0011\u0011\u0005\u0001A\u0002\u0013%\u0011q\u0001\u0005\n\u0003G\u0001\u0001\u0019!C\u0005\u0003KA\u0001\"!\u000b\u0001A\u0003&\u0011\u0011\u0002\u0005\t\u0003W\u0001!\u0019!C\u0001\u0001\"9\u0011Q\u0006\u0001!\u0002\u0013\t\u0005\u0002CA\u0018\u0001\t\u0007I\u0011\u0001!\t\u000f\u0005E\u0002\u0001)A\u0005\u0003\"9\u00111\u0007\u0001\u0005B\u0005U\u0002bBA \u0001\u0011%\u0011\u0011\t\u0005\b\u0003\u001b\u0002A\u0011IA(\u0011\u001d\t\u0019\u0006\u0001C!\u0003+Ba!a\u0016\u0001\t\u0003\u0002\u0005bBA-\u0001\u0011\u0005\u00111\f\u0005\b\u0003G\u0002A\u0011IA\u0004\u0011\u001d\t)\u0007\u0001C!\u0003OBq!a\u001b\u0001\t\u0013\ti\u0007C\u0004\u0002x\u0001!I!!\u001f\b\u0013\u0005=u&!A\t\u0002\u0005Ee\u0001\u0003\u00180\u0003\u0003E\t!a%\t\rM[C\u0011AAK\u0011%\t9jKI\u0001\n\u0003\tIJA\bTW&l\u0007/_(gMN,G/T1q\u0015\t\u0001\u0014'A\u0002m_\u001eT\u0011AM\u0001\u0006W\u000647.Y\u0002\u0001'\r\u0001Qg\u000f\t\u0003mej\u0011a\u000e\u0006\u0002q\u0005)1oY1mC&\u0011!h\u000e\u0002\u0007\u0003:L(+\u001a4\u0011\u0005qjT\"A\u0018\n\u0005yz#!C(gMN,G/T1q\u0003\u0019iW-\\8ssV\t\u0011\t\u0005\u00027\u0005&\u00111i\u000e\u0002\u0004\u0013:$\u0018aB7f[>\u0014\u0018\u0010I\u0001\u000eQ\u0006\u001c\b.\u00117h_JLG\u000f[7\u0016\u0003\u001d\u0003\"\u0001S(\u000f\u0005%k\u0005C\u0001&8\u001b\u0005Y%B\u0001'4\u0003\u0019a$o\\8u}%\u0011ajN\u0001\u0007!J,G-\u001a4\n\u0005A\u000b&AB*ue&twM\u0003\u0002Oo\u0005q\u0001.Y:i\u00032<wN]5uQ6\u0004\u0013A\u0002\u001fj]&$h\bF\u0002V-^\u0003\"\u0001\u0010\u0001\t\u000b}*\u0001\u0019A!\t\u000f\u0015+\u0001\u0013!a\u0001\u000f\u0006)!-\u001f;fgV\t!\f\u0005\u0002\\A6\tAL\u0003\u0002^=\u0006\u0019a.[8\u000b\u0003}\u000bAA[1wC&\u0011\u0011\r\u0018\u0002\u000b\u0005f$XMQ;gM\u0016\u0014\u0018A\u00022zi\u0016\u001c\b%\u0001\u0004eS\u001e,7\u000f^\u000b\u0002KB\u0011a-[\u0007\u0002O*\u0011\u0001NX\u0001\tg\u0016\u001cWO]5us&\u0011!n\u001a\u0002\u000e\u001b\u0016\u001c8/Y4f\t&<Wm\u001d;\u0002\u000f\u0011Lw-Z:uA\u0005A\u0001.Y:i'&TX-A\u0005iCND7+\u001b>fA\u0005)\u0001.Y:icU\t\u0001\u000fE\u00027cNL!A]\u001c\u0003\u000b\u0005\u0013(/Y=\u0011\u0005Y\"\u0018BA;8\u0005\u0011\u0011\u0015\u0010^3\u0002\r!\f7\u000f[\u0019!\u0003\u0015A\u0017m\u001d53\u0003\u0019A\u0017m\u001d53A\u00059QM\u001c;sS\u0016\u001c\u0018aC3oiJLWm]0%KF$\"\u0001`@\u0011\u0005Yj\u0018B\u0001@8\u0005\u0011)f.\u001b;\t\u0011\u0005\u0005\u0011#!AA\u0002\u0005\u000b1\u0001\u001f\u00132\u0003!)g\u000e\u001e:jKN\u0004\u0013a\u00027p_.,\bo]\u000b\u0003\u0003\u0013\u00012ANA\u0006\u0013\r\tia\u000e\u0002\u0005\u0019>tw-A\u0006m_>\\W\u000f]:`I\u0015\fHc\u0001?\u0002\u0014!I\u0011\u0011\u0001\u000b\u0002\u0002\u0003\u0007\u0011\u0011B\u0001\tY>|7.\u001e9tA\u00051\u0001O]8cKN\f!\u0002\u001d:pE\u0016\u001cx\fJ3r)\ra\u0018Q\u0004\u0005\n\u0003\u00039\u0012\u0011!a\u0001\u0003\u0013\tq\u0001\u001d:pE\u0016\u001c\b%\u0001\u0006mCN$xJ\u001a4tKR\fa\u0002\\1ti>3gm]3u?\u0012*\u0017\u000fF\u0002}\u0003OA\u0011\"!\u0001\u001b\u0003\u0003\u0005\r!!\u0003\u0002\u00171\f7\u000f^(gMN,G\u000fI\u0001\u000eEf$Xm\u001d)fe\u0016sGO]=\u0002\u001d\tLH/Z:QKJ,e\u000e\u001e:zA\u0005)1\u000f\\8ug\u000611\u000f\\8ug\u0002\n1\u0001];u)\u0015a\u0018qGA\u001e\u0011\u0019\tI\u0004\ta\u00015\u0006\u00191.Z=\t\u000f\u0005u\u0002\u00051\u0001\u0002\n\u00051qN\u001a4tKR\fq![:F[B$\u0018\u0010\u0006\u0003\u0002D\u0005%\u0003c\u0001\u001c\u0002F%\u0019\u0011qI\u001c\u0003\u000f\t{w\u000e\\3b]\"1\u00111J\u0011A\u0002\u0005\u000b\u0001\u0002]8tSRLwN\\\u0001\u0004O\u0016$H\u0003BA\u0005\u0003#Ba!!\u000f#\u0001\u0004Q\u0016!B2mK\u0006\u0014H#\u0001?\u0002\tML'0Z\u0001\u000eG>dG.[:j_:\u0014\u0016\r^3\u0016\u0005\u0005u\u0003c\u0001\u001c\u0002`%\u0019\u0011\u0011M\u001c\u0003\r\u0011{WO\u00197f\u00031a\u0017\r^3ti>3gm]3u\u0003I)\b\u000fZ1uK2\u000bG/Z:u\u001f\u001a47/\u001a;\u0015\u0007q\fI\u0007C\u0004\u0002>\u001d\u0002\r!!\u0003\u0002\u0015A|7/\u001b;j_:|e\rF\u0003B\u0003_\n\u0019\b\u0003\u0004\u0002r!\u0002\r\u0001]\u0001\u0005Q\u0006\u001c\b\u000e\u0003\u0004\u0002v!\u0002\r!Q\u0001\bCR$X-\u001c9u\u0003!A\u0017m\u001d5J]R|G#\u0002?\u0002|\u0005u\u0004BBA\u001dS\u0001\u0007!\f\u0003\u0004\u0002\u0000%\u0002\r\u0001]\u0001\u0007EV4g-\u001a:)\u0007\u0001\t\u0019\t\u0005\u0003\u0002\u0006\u0006-UBAAD\u0015\r\tI)M\u0001\u0006kRLGn]\u0005\u0005\u0003\u001b\u000b9IA\u0007o_:$\bN]3bIN\fg-Z\u0001\u0010'.LW\u000e]=PM\u001a\u001cX\r^'baB\u0011AhK\n\u0003WU\"\"!!%\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00133+\t\tYJK\u0002H\u0003;[#!a(\u0011\t\u0005\u0005\u00161V\u0007\u0003\u0003GSA!!*\u0002(\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003S;\u0014AC1o]>$\u0018\r^5p]&!\u0011QVAR\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a")
public class SkimpyOffsetMap
implements OffsetMap {
    private final int memory;
    private final String hashAlgorithm;
    private final ByteBuffer bytes;
    private final MessageDigest digest;
    private final int hashSize;
    private final byte[] hash1;
    private final byte[] hash2;
    private int entries;
    private long lookups;
    private long probes;
    private long lastOffset;
    private final int bytesPerEntry;
    private final int slots;

    public static String $lessinit$greater$default$2() {
        return SkimpyOffsetMap$.MODULE$.$lessinit$greater$default$2();
    }

    @Override
    public double utilization() {
        return OffsetMap.utilization$(this);
    }

    public int memory() {
        return this.memory;
    }

    public String hashAlgorithm() {
        return this.hashAlgorithm;
    }

    private ByteBuffer bytes() {
        return this.bytes;
    }

    private MessageDigest digest() {
        return this.digest;
    }

    private int hashSize() {
        return this.hashSize;
    }

    private byte[] hash1() {
        return this.hash1;
    }

    private byte[] hash2() {
        return this.hash2;
    }

    private int entries() {
        return this.entries;
    }

    private void entries_$eq(int x$1) {
        this.entries = x$1;
    }

    private long lookups() {
        return this.lookups;
    }

    private void lookups_$eq(long x$1) {
        this.lookups = x$1;
    }

    private long probes() {
        return this.probes;
    }

    private void probes_$eq(long x$1) {
        this.probes = x$1;
    }

    private long lastOffset() {
        return this.lastOffset;
    }

    private void lastOffset_$eq(long x$1) {
        this.lastOffset = x$1;
    }

    public int bytesPerEntry() {
        return this.bytesPerEntry;
    }

    @Override
    public int slots() {
        return this.slots;
    }

    @Override
    public void put(ByteBuffer key, long offset) {
        Predef$.MODULE$.require(this.entries() < this.slots(), (Function0 & java.io.Serializable & Serializable)() -> "Attempt to add a new entry to a full offset map.");
        this.lookups_$eq(this.lookups() + 1L);
        this.hashInto(key, this.hash1());
        int attempt = 0;
        int pos = this.positionOf(this.hash1(), attempt);
        while (!this.isEmpty(pos)) {
            this.bytes().position(pos);
            this.bytes().get(this.hash2());
            if (Arrays.equals(this.hash1(), this.hash2())) {
                this.bytes().putLong(offset);
                this.lastOffset_$eq(offset);
                return;
            }
            pos = this.positionOf(this.hash1(), ++attempt);
        }
        this.bytes().position(pos);
        this.bytes().put(this.hash1());
        this.bytes().putLong(offset);
        this.lastOffset_$eq(offset);
        this.entries_$eq(this.entries() + 1);
    }

    private boolean isEmpty(int position) {
        return this.bytes().getLong(position) == 0L && this.bytes().getLong(position + 8) == 0L && this.bytes().getLong(position + 16) == 0L;
    }

    @Override
    public long get(ByteBuffer key) {
        this.lookups_$eq(this.lookups() + 1L);
        this.hashInto(key, this.hash1());
        int attempt = 0;
        int pos = 0;
        int maxAttempts = this.slots() + this.hashSize() - 4;
        do {
            if (attempt >= maxAttempts) {
                return -1L;
            }
            pos = this.positionOf(this.hash1(), attempt);
            this.bytes().position(pos);
            if (this.isEmpty(pos)) {
                return -1L;
            }
            this.bytes().get(this.hash2());
            ++attempt;
        } while (!Arrays.equals(this.hash1(), this.hash2()));
        return this.bytes().getLong();
    }

    @Override
    public void clear() {
        this.entries_$eq(0);
        this.lookups_$eq(0L);
        this.probes_$eq(0L);
        this.lastOffset_$eq(-1L);
        Arrays.fill(this.bytes().array(), this.bytes().arrayOffset(), this.bytes().arrayOffset() + this.bytes().limit(), (byte)0);
    }

    @Override
    public int size() {
        return this.entries();
    }

    public double collisionRate() {
        return (double)(this.probes() - this.lookups()) / (double)this.lookups();
    }

    @Override
    public long latestOffset() {
        return this.lastOffset();
    }

    @Override
    public void updateLatestOffset(long offset) {
        this.lastOffset_$eq(offset);
    }

    private int positionOf(byte[] hash, int attempt) {
        int probe = CoreUtils$.MODULE$.readInt(hash, package$.MODULE$.min(attempt, this.hashSize() - 4)) + package$.MODULE$.max(0, attempt - this.hashSize() + 4);
        int slot = Utils.abs((int)probe) % this.slots();
        this.probes_$eq(this.probes() + 1L);
        return slot * this.bytesPerEntry();
    }

    private void hashInto(ByteBuffer key, byte[] buffer) {
        key.mark();
        this.digest().update(key);
        key.reset();
        this.digest().digest(buffer, 0, this.hashSize());
    }

    public SkimpyOffsetMap(int memory, String hashAlgorithm) {
        this.memory = memory;
        this.hashAlgorithm = hashAlgorithm;
        OffsetMap.$init$(this);
        this.bytes = ByteBuffer.allocate(memory);
        this.digest = MessageDigest.getInstance(hashAlgorithm);
        this.hashSize = this.digest().getDigestLength();
        this.hash1 = new byte[this.hashSize()];
        this.hash2 = new byte[this.hashSize()];
        this.entries = 0;
        this.lookups = 0L;
        this.probes = 0L;
        this.lastOffset = -1L;
        this.bytesPerEntry = this.hashSize() + 8;
        this.slots = memory / this.bytesPerEntry();
    }
}

