/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kafka.api.LeaderAndIsr$;
import kafka.cluster.Broker;
import kafka.cluster.EndPoint;
import kafka.controller.StateChangeLogger;
import kafka.server.MetadataCache$MetadataSnapshot$;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.internals.Topic;
import org.apache.kafka.common.message.UpdateMetadataRequestData;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.MetadataResponse;
import org.apache.kafka.common.requests.UpdateMetadataRequest;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.AnyRefMap;
import scala.collection.mutable.AnyRefMap$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.LongMap;
import scala.collection.mutable.LongMap$;
import scala.collection.mutable.Map$;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\ree\u0001\u0002 @\u0001\u0011C\u0001\"\u0015\u0001\u0003\u0002\u0003\u0006IA\u0015\u0005\u0006+\u0002!\tA\u0016\u0005\b5\u0002\u0011\r\u0011\"\u0003\\\u0011\u0019A\u0007\u0001)A\u00059\"9\u0011\u000e\u0001a\u0001\n\u0013Q\u0007\"\u0003B\r\u0001\u0001\u0007I\u0011\u0002B\u000e\u0011\u001d\u0011)\u0003\u0001Q!\n-D\u0011Ba\f\u0001\u0005\u0004%IA!\r\t\u0011\t}\u0002\u0001)A\u0005\u0005gAqA!\u0011\u0001\t\u0013\u0011\u0019\u0005C\u0004\u0003t\u0001!IA!\u001e\t\u000f\t}\u0005\u0001\"\u0003\u0003\"\"9!1\u0016\u0001\u0005\u0002\t5\u0006\"\u0003Bd\u0001E\u0005I\u0011\u0001Be\u0011%\u0011i\rAI\u0001\n\u0003\u0011I\rC\u0004\u0003P\u0002!\tA!5\t\u000f\tM\u0007\u0001\"\u0001\u0003V\"9!q\u001a\u0001\u0005\n\t}\u0007b\u0002Bj\u0001\u0011%!1\u001d\u0005\b\u0005W\u0004A\u0011\u0001Bw\u0011\u001d\u0011\t\u0010\u0001C\u0001\u0005gDqA!?\u0001\t\u0003\u0011Y\u0010C\u0004\u0003\u0000\u0002!Ia!\u0001\t\u000f\r=\u0001\u0001\"\u0001\u0004\u0012!91\u0011\u0004\u0001\u0005\u0002\rm\u0001bBB\u0012\u0001\u0011\u00051Q\u0005\u0005\b\u0007_\u0001A\u0011AA*\u0011\u001d\u0019\t\u0004\u0001C\u0001\u0007gAqa!\u0011\u0001\t\u0003\u0019\u0019\u0005C\u0004\u0004V\u0001!\taa\u0016\t\u000f\rU\u0003\u0001\"\u0001\u0004\\!91q\f\u0001\u0005\n\r\u0005d\u0001B7\u0001\u0001:D\u0001\"^\u0011\u0003\u0016\u0004%\tA\u001e\u0005\n\u0003\u001f\n#\u0011#Q\u0001\n]D!\"!\u0015\"\u0005+\u0007I\u0011AA*\u0011)\tY&\tB\tB\u0003%\u0011Q\u000b\u0005\u000b\u0003;\n#Q3A\u0005\u0002\u0005}\u0003BCA8C\tE\t\u0015!\u0003\u0002b!Q\u0011\u0011O\u0011\u0003\u0016\u0004%\t!a\u001d\t\u0015\u0005M\u0015E!E!\u0002\u0013\t)\b\u0003\u0004VC\u0011\u0005\u0011Q\u0013\u0005\n\u0003?\u000b\u0013\u0011!C\u0001\u0003CC\u0011\"a+\"#\u0003%\t!!,\t\u0013\u0005\r\u0017%%A\u0005\u0002\u0005\u0015\u0007\"CAeCE\u0005I\u0011AAf\u0011%\ty-II\u0001\n\u0003\t\t\u000eC\u0005\u0002V\u0006\n\t\u0011\"\u0011\u0002X\"I\u00111]\u0011\u0002\u0002\u0013\u0005\u0011Q\u001d\u0005\n\u0003O\f\u0013\u0011!C\u0001\u0003SD\u0011\"!>\"\u0003\u0003%\t%a>\t\u0013\u0005}\u0018%!A\u0005\u0002\t\u0005\u0001\"\u0003B\u0006C\u0005\u0005I\u0011\tB\u0007\u0011%\u0011y!IA\u0001\n\u0003\u0012\t\u0002C\u0005\u0003\u0014\u0005\n\t\u0011\"\u0011\u0003\u0016\u001dI1\u0011\u000e\u0001\u0002\u0002#\u000511\u000e\u0004\t[\u0002\t\t\u0011#\u0001\u0004n!1Q+\u000fC\u0001\u0007wB\u0011Ba\u0004:\u0003\u0003%)E!\u0005\t\u0013\ru\u0014(!A\u0005\u0002\u000e}\u0004\"CBEs\u0005\u0005I\u0011QBF\u00055iU\r^1eCR\f7)Y2iK*\u0011\u0001)Q\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003\t\u000bQa[1gW\u0006\u001c\u0001aE\u0002\u0001\u000b.\u0003\"AR%\u000e\u0003\u001dS\u0011\u0001S\u0001\u0006g\u000e\fG.Y\u0005\u0003\u0015\u001e\u0013a!\u00118z%\u00164\u0007C\u0001'P\u001b\u0005i%B\u0001(B\u0003\u0015)H/\u001b7t\u0013\t\u0001VJA\u0004M_\u001e<\u0017N\\4\u0002\u0011\t\u0014xn[3s\u0013\u0012\u0004\"AR*\n\u0005Q;%aA%oi\u00061A(\u001b8jiz\"\"aV-\u0011\u0005a\u0003Q\"A \t\u000bE\u0013\u0001\u0019\u0001*\u0002+A\f'\u000f^5uS>tW*\u001a;bI\u0006$\u0018\rT8dWV\tA\f\u0005\u0002^M6\taL\u0003\u0002`A\u0006)An\\2lg*\u0011\u0011MY\u0001\u000bG>t7-\u001e:sK:$(BA2e\u0003\u0011)H/\u001b7\u000b\u0003\u0015\fAA[1wC&\u0011qM\u0018\u0002\u0017%\u0016,g\u000e\u001e:b]R\u0014V-\u00193Xe&$X\rT8dW\u00061\u0002/\u0019:uSRLwN\\'fi\u0006$\u0017\r^1M_\u000e\\\u0007%\u0001\tnKR\fG-\u0019;b':\f\u0007o\u001d5piV\t1\u000e\u0005\u0002mC5\t\u0001A\u0001\tNKR\fG-\u0019;b':\f\u0007o\u001d5piN!\u0011%R8s!\t1\u0005/\u0003\u0002r\u000f\n9\u0001K]8ek\u000e$\bC\u0001$t\u0013\t!xI\u0001\u0007TKJL\u0017\r\\5{C\ndW-A\bqCJ$\u0018\u000e^5p]N#\u0018\r^3t+\u00059\b#\u0002=~\u007f\u0006UQ\"A=\u000b\u0005i\\\u0018aB7vi\u0006\u0014G.\u001a\u0006\u0003y\u001e\u000b!bY8mY\u0016\u001cG/[8o\u0013\tq\u0018PA\u0005B]f\u0014VMZ'baB!\u0011\u0011AA\b\u001d\u0011\t\u0019!a\u0003\u0011\u0007\u0005\u0015q)\u0004\u0002\u0002\b)\u0019\u0011\u0011B\"\u0002\rq\u0012xn\u001c;?\u0013\r\tiaR\u0001\u0007!J,G-\u001a4\n\t\u0005E\u00111\u0003\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u00055q\tE\u0003y\u0003/\tY\"C\u0002\u0002\u001ae\u0014q\u0001T8oO6\u000b\u0007\u000f\u0005\u0003\u0002\u001e\u0005%c\u0002BA\u0010\u0003\u0007rA!!\t\u0002>9!\u00111EA\u001c\u001d\u0011\t)#a\r\u000f\t\u0005\u001d\u0012Q\u0006\b\u0005\u0003\u000b\tI#\u0003\u0002\u0002,\u0005\u0019qN]4\n\t\u0005=\u0012\u0011G\u0001\u0007CB\f7\r[3\u000b\u0005\u0005-\u0012b\u0001\"\u00026)!\u0011qFA\u0019\u0013\u0011\tI$a\u000f\u0002\r\r|W.\\8o\u0015\r\u0011\u0015QG\u0005\u0005\u0003\u007f\t\t%A\u0004nKN\u001c\u0018mZ3\u000b\t\u0005e\u00121H\u0005\u0005\u0003\u000b\n9%A\rVa\u0012\fG/Z'fi\u0006$\u0017\r^1SKF,Xm\u001d;ECR\f'\u0002BA \u0003\u0003JA!a\u0013\u0002N\taR\u000b\u001d3bi\u0016lU\r^1eCR\f\u0007+\u0019:uSRLwN\\*uCR,'\u0002BA#\u0003\u000f\n\u0001\u0003]1si&$\u0018n\u001c8Ti\u0006$Xm\u001d\u0011\u0002\u0019\r|g\u000e\u001e:pY2,'/\u00133\u0016\u0005\u0005U\u0003\u0003\u0002$\u0002XIK1!!\u0017H\u0005\u0019y\u0005\u000f^5p]\u0006i1m\u001c8ue>dG.\u001a:JI\u0002\nA\"\u00197jm\u0016\u0014%o\\6feN,\"!!\u0019\u0011\u000ba\f9\"a\u0019\u0011\t\u0005\u0015\u00141N\u0007\u0003\u0003OR1!!\u001bB\u0003\u001d\u0019G.^:uKJLA!!\u001c\u0002h\t1!I]8lKJ\fQ\"\u00197jm\u0016\u0014%o\\6feN\u0004\u0013AC1mSZ,gj\u001c3fgV\u0011\u0011Q\u000f\t\u0006q\u0006]\u0011q\u000f\t\t\u0003s\nY(a \u0002\f6\t10C\u0002\u0002~m\u00141!T1q!\u0011\t\t)a\"\u000e\u0005\u0005\r%\u0002BAC\u0003\u0003\nqA\\3uo>\u00148.\u0003\u0003\u0002\n\u0006\r%\u0001\u0004'jgR,g.\u001a:OC6,\u0007\u0003BAG\u0003\u001fk!!!\u0011\n\t\u0005E\u0015\u0011\t\u0002\u0005\u001d>$W-A\u0006bY&4XMT8eKN\u0004C#C6\u0002\u0018\u0006e\u00151TAO\u0011\u0015)(\u00061\u0001x\u0011\u001d\t\tF\u000ba\u0001\u0003+Bq!!\u0018+\u0001\u0004\t\t\u0007C\u0004\u0002r)\u0002\r!!\u001e\u0002\t\r|\u0007/\u001f\u000b\nW\u0006\r\u0016QUAT\u0003SCq!^\u0016\u0011\u0002\u0003\u0007q\u000fC\u0005\u0002R-\u0002\n\u00111\u0001\u0002V!I\u0011QL\u0016\u0011\u0002\u0003\u0007\u0011\u0011\r\u0005\n\u0003cZ\u0003\u0013!a\u0001\u0003k\nabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u00020*\u001aq/!-,\u0005\u0005M\u0006\u0003BA[\u0003\u007fk!!a.\u000b\t\u0005e\u00161X\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!0H\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003\u0003\f9LA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fabY8qs\u0012\"WMZ1vYR$#'\u0006\u0002\u0002H*\"\u0011QKAY\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIM*\"!!4+\t\u0005\u0005\u0014\u0011W\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00135+\t\t\u0019N\u000b\u0003\u0002v\u0005E\u0016!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0002ZB!\u00111\\Aq\u001b\t\tiNC\u0002\u0002`\u0012\fA\u0001\\1oO&!\u0011\u0011CAo\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\u0005\u0011\u0016A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0003W\f\t\u0010E\u0002G\u0003[L1!a<H\u0005\r\te.\u001f\u0005\t\u0003g\u0014\u0014\u0011!a\u0001%\u0006\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!!?\u0011\r\u0005e\u00141`Av\u0013\r\tip\u001f\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u0003\u0004\t%\u0001c\u0001$\u0003\u0006%\u0019!qA$\u0003\u000f\t{w\u000e\\3b]\"I\u00111\u001f\u001b\u0002\u0002\u0003\u0007\u00111^\u0001\tQ\u0006\u001c\bnQ8eKR\t!+\u0001\u0005u_N#(/\u001b8h)\t\tI.\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0005\u0007\u00119\u0002C\u0005\u0002t^\n\t\u00111\u0001\u0002l\u0006!R.\u001a;bI\u0006$\u0018m\u00158baNDw\u000e^0%KF$BA!\b\u0003$A\u0019aIa\b\n\u0007\t\u0005rI\u0001\u0003V]&$\b\u0002CAz\r\u0005\u0005\t\u0019A6\u0002#5,G/\u00193bi\u0006\u001cf.\u00199tQ>$\b\u0005K\u0002\b\u0005S\u00012A\u0012B\u0016\u0013\r\u0011ic\u0012\u0002\tm>d\u0017\r^5mK\u0006\t2\u000f^1uK\u000eC\u0017M\\4f\u0019><w-\u001a:\u0016\u0005\tM\u0002\u0003\u0002B\u001b\u0005wi!Aa\u000e\u000b\u0007\te\u0012)\u0001\u0006d_:$(o\u001c7mKJLAA!\u0010\u00038\t\t2\u000b^1uK\u000eC\u0017M\\4f\u0019><w-\u001a:\u0002%M$\u0018\r^3DQ\u0006tw-\u001a'pO\u001e,'\u000fI\u0001\rO\u0016$XI\u001c3q_&tGo\u001d\u000b\u000b\u0005\u000b\u0012YEa\u0014\u0003l\t=\u0004CBA=\u0005\u000f\nY)C\u0002\u0003Jm\u00141aU3r\u0011\u0019\u0011iE\u0003a\u0001W\u0006A1O\\1qg\"|G\u000fC\u0004\u0003R)\u0001\rAa\u0015\u0002\u000f\t\u0014xn[3sgB1!Q\u000bB0\u0005KrAAa\u0016\u0003\\9!\u0011Q\u0001B-\u0013\u0005A\u0015b\u0001B/\u000f\u00069\u0001/Y2lC\u001e,\u0017\u0002\u0002B1\u0005G\u0012\u0001\"\u0013;fe\u0006\u0014G.\u001a\u0006\u0004\u0005;:\u0005\u0003BAn\u0005OJAA!\u001b\u0002^\n9\u0011J\u001c;fO\u0016\u0014\bb\u0002B7\u0015\u0001\u0007\u0011qP\u0001\rY&\u001cH/\u001a8fe:\u000bW.\u001a\u0005\b\u0005cR\u0001\u0019\u0001B\u0002\u0003i1\u0017\u000e\u001c;feVs\u0017M^1jY\u0006\u0014G.Z#oIB|\u0017N\u001c;t\u0003Q9W\r\u001e)beRLG/[8o\u001b\u0016$\u0018\rZ1uCRa!q\u000fBH\u0005#\u0013)Ja&\u0003\u001cB)a)a\u0016\u0003zA1!Q\u000bB0\u0005w\u0002BA! \u0003\n:!!q\u0010BC\u001b\t\u0011\tI\u0003\u0003\u0003\u0004\u0006\u0005\u0013\u0001\u0003:fcV,7\u000f^:\n\t\t\u001d%\u0011Q\u0001\u0011\u001b\u0016$\u0018\rZ1uCJ+7\u000f]8og\u0016LAAa#\u0003\u000e\n\t\u0002+\u0019:uSRLwN\\'fi\u0006$\u0017\r^1\u000b\t\t\u001d%\u0011\u0011\u0005\u0007\u0005\u001bZ\u0001\u0019A6\t\r\tM5\u00021\u0001\u0000\u0003\u0015!x\u000e]5d\u0011\u001d\u0011ig\u0003a\u0001\u0003\u007fBqA!'\f\u0001\u0004\u0011\u0019!A\rfeJ|'/\u00168bm\u0006LG.\u00192mK\u0016sG\r]8j]R\u001c\bb\u0002BO\u0017\u0001\u0007!1A\u0001\u001aKJ\u0014xN]+oCZ\f\u0017\u000e\\1cY\u0016d\u0015n\u001d;f]\u0016\u00148/\u0001\thKR\fE.\u001b<f\u000b:$\u0007o\\5oiRA!1\u0015BS\u0005O\u0013I\u000bE\u0003G\u0003/\nY\t\u0003\u0004\u0003N1\u0001\ra\u001b\u0005\u0006#2\u0001\rA\u0015\u0005\b\u0005[b\u0001\u0019AA@\u0003A9W\r\u001e+pa&\u001cW*\u001a;bI\u0006$\u0018\r\u0006\u0006\u00030\n]&\u0011\u0019Bb\u0005\u000b\u0004b!!\u001f\u0003H\tE\u0006\u0003\u0002B?\u0005gKAA!.\u0003\u000e\niAk\u001c9jG6+G/\u00193bi\u0006DqA!/\u000e\u0001\u0004\u0011Y,\u0001\u0004u_BL7m\u001d\t\u0006\u0003s\u0012il`\u0005\u0004\u0005\u007f[(aA*fi\"9!QN\u0007A\u0002\u0005}\u0004\"\u0003BM\u001bA\u0005\t\u0019\u0001B\u0002\u0011%\u0011i*\u0004I\u0001\u0002\u0004\u0011\u0019!\u0001\u000ehKR$v\u000e]5d\u001b\u0016$\u0018\rZ1uC\u0012\"WMZ1vYR$3'\u0006\u0002\u0003L*\"!1AAY\u0003i9W\r\u001e+pa&\u001cW*\u001a;bI\u0006$\u0018\r\n3fM\u0006,H\u000e\u001e\u00135\u000319W\r^!mYR{\u0007/[2t)\t\u0011Y,\u0001\thKR\fE\u000e\u001c)beRLG/[8ogR\u0011!q\u001b\t\u0007\u0003s\u0012iL!7\u0011\t\u00055%1\\\u0005\u0005\u0005;\f\tE\u0001\bU_BL7\rU1si&$\u0018n\u001c8\u0015\t\tm&\u0011\u001d\u0005\u0007\u0005\u001b\u0012\u0002\u0019A6\u0015\t\t\u0015(\u0011\u001e\t\t\u0003\u0003\u00119O!7\u0002\u001c%!\u0011QPA\n\u0011\u0019\u0011ie\u0005a\u0001W\u0006!r-\u001a;O_:,\u00050[:uS:<Gk\u001c9jGN$BAa/\u0003p\"9!\u0011\u0018\u000bA\u0002\tm\u0016AD4fi\u0006c\u0017N^3Ce>\\WM\u001d\u000b\u0005\u0005k\u00149\u0010E\u0003G\u0003/\n\u0019\u0007C\u0003R+\u0001\u0007!+A\bhKR\fE.\u001b<f\u0005J|7.\u001a:t+\t\u0011i\u0010\u0005\u0004\u0002z\t\u001d\u00131M\u0001\u0019C\u0012$wJ]+qI\u0006$X\rU1si&$\u0018n\u001c8J]\u001a|GC\u0003B\u000f\u0007\u0007\u0019)aa\u0002\u0004\f!)Qo\u0006a\u0001o\"1!1S\fA\u0002}Daa!\u0003\u0018\u0001\u0004\u0011\u0016a\u00039beRLG/[8o\u0013\u0012Dqa!\u0004\u0018\u0001\u0004\tY\"A\u0005ti\u0006$X-\u00138g_\u0006\u0001r-\u001a;QCJ$\u0018\u000e^5p]&sgm\u001c\u000b\u0007\u0007'\u0019)ba\u0006\u0011\u000b\u0019\u000b9&a\u0007\t\r\tM\u0005\u00041\u0001\u0000\u0011\u0019\u0019I\u0001\u0007a\u0001%\u0006Qr-\u001a;QCJ$\u0018\u000e^5p]2+\u0017\rZ3s\u000b:$\u0007o\\5oiRA!1UB\u000f\u0007?\u0019\t\u0003\u0003\u0004\u0003\u0014f\u0001\ra \u0005\u0007\u0007\u0013I\u0002\u0019\u0001*\t\u000f\t5\u0014\u00041\u0001\u0002\u0000\u0005ar-\u001a;QCJ$\u0018\u000e^5p]J+\u0007\u000f\\5dC\u0016sG\r]8j]R\u001cHCBB\u0014\u0007S\u0019i\u0003E\u0004\u0002\u0002\t\u001d(+a#\t\u000f\r-\"\u00041\u0001\u0003Z\u0006\u0011A\u000f\u001d\u0005\b\u0005[R\u0002\u0019AA@\u0003=9W\r^\"p]R\u0014x\u000e\u001c7fe&#\u0017AE4fi\u000ecWo\u001d;fe6+G/\u00193bi\u0006$ba!\u000e\u0004<\r}\u0002\u0003BAG\u0007oIAa!\u000f\u0002B\t91\t\\;ti\u0016\u0014\bBBB\u001f9\u0001\u0007q0A\u0005dYV\u001cH/\u001a:JI\"9!Q\u000e\u000fA\u0002\u0005}\u0014AD;qI\u0006$X-T3uC\u0012\fG/\u0019\u000b\u0007\u0007\u000b\u001a9ea\u0013\u0011\r\u0005e$q\tBm\u0011\u0019\u0019I%\ba\u0001%\u0006i1m\u001c:sK2\fG/[8o\u0013\u0012Dqa!\u0014\u001e\u0001\u0004\u0019y%A\u000bva\u0012\fG/Z'fi\u0006$\u0017\r^1SKF,Xm\u001d;\u0011\t\t}4\u0011K\u0005\u0005\u0007'\u0012\tIA\u000bVa\u0012\fG/Z'fi\u0006$\u0017\r^1SKF,Xm\u001d;\u0002\u0011\r|g\u000e^1j]N$BAa\u0001\u0004Z!1!1\u0013\u0010A\u0002}$BAa\u0001\u0004^!911F\u0010A\u0002\te\u0017a\u0005:f[>4X\rU1si&$\u0018n\u001c8J]\u001a|G\u0003\u0003B\u0002\u0007G\u001a)ga\u001a\t\u000bU\u0004\u0003\u0019A<\t\r\tM\u0005\u00051\u0001\u0000\u0011\u0019\u0019I\u0001\ta\u0001%\u0006\u0001R*\u001a;bI\u0006$\u0018m\u00158baNDw\u000e\u001e\t\u0003Yf\u001aB!OB8eBa1\u0011OB<o\u0006U\u0013\u0011MA;W6\u001111\u000f\u0006\u0004\u0007k:\u0015a\u0002:v]RLW.Z\u0005\u0005\u0007s\u001a\u0019HA\tBEN$(/Y2u\rVt7\r^5p]R\"\"aa\u001b\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u0013-\u001c\tia!\u0004\u0006\u000e\u001d\u0005\"B;=\u0001\u00049\bbBA)y\u0001\u0007\u0011Q\u000b\u0005\b\u0003;b\u0004\u0019AA1\u0011\u001d\t\t\b\u0010a\u0001\u0003k\nq!\u001e8baBd\u0017\u0010\u0006\u0003\u0004\u000e\u000eU\u0005#\u0002$\u0002X\r=\u0005C\u0003$\u0004\u0012^\f)&!\u0019\u0002v%\u001911S$\u0003\rQ+\b\u000f\\35\u0011!\u00199*PA\u0001\u0002\u0004Y\u0017a\u0001=%a\u0001")
public class MetadataCache
implements Logging {
    private volatile MetadataCache$MetadataSnapshot$ MetadataSnapshot$module;
    private final int brokerId;
    private final ReentrantReadWriteLock partitionMetadataLock;
    private volatile MetadataSnapshot metadataSnapshot;
    private final StateChangeLogger stateChangeLogger;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    public MetadataCache$MetadataSnapshot$ MetadataSnapshot() {
        if (this.MetadataSnapshot$module == null) {
            this.MetadataSnapshot$lzycompute$1();
        }
        return this.MetadataSnapshot$module;
    }

    private Logger logger$lzycompute() {
        MetadataCache metadataCache = this;
        synchronized (metadataCache) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private ReentrantReadWriteLock partitionMetadataLock() {
        return this.partitionMetadataLock;
    }

    private MetadataSnapshot metadataSnapshot() {
        return this.metadataSnapshot;
    }

    private void metadataSnapshot_$eq(MetadataSnapshot x$1) {
        this.metadataSnapshot = x$1;
    }

    private StateChangeLogger stateChangeLogger() {
        return this.stateChangeLogger;
    }

    private Seq<Node> getEndpoints(MetadataSnapshot snapshot, Iterable<Integer> brokers, ListenerName listenerName, boolean filterUnavailableEndpoints) {
        ArrayBuffer result = new ArrayBuffer(package$.MODULE$.min(snapshot.aliveBrokers().size(), brokers.size()));
        brokers.foreach((Function1 & Serializable & scala.Serializable)brokerId -> {
            MetadataCache.$anonfun$getEndpoints$1(this, snapshot, listenerName, filterUnavailableEndpoints, result, brokerId);
            return BoxedUnit.UNIT;
        });
        return result;
    }

    private Option<Iterable<MetadataResponse.PartitionMetadata>> getPartitionMetadata(MetadataSnapshot snapshot, String topic, ListenerName listenerName, boolean errorUnavailableEndpoints, boolean errorUnavailableListeners) {
        return snapshot.partitionStates().get((Object)topic).map((Function1 & Serializable & scala.Serializable)partitions -> (Iterable)partitions.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            MetadataResponse.PartitionMetadata partitionMetadata;
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            long partitionId = tuple2._1$mcJ$sp();
            UpdateMetadataRequestData.UpdateMetadataPartitionState partitionState = (UpdateMetadataRequestData.UpdateMetadataPartitionState)tuple2._2();
            TopicPartition topicPartition = new TopicPartition(topic, (int)partitionId);
            int leaderBrokerId = partitionState.leader();
            int leaderEpoch = partitionState.leaderEpoch();
            Option<Node> maybeLeader = this.getAliveEndpoint(snapshot, leaderBrokerId, listenerName);
            Buffer replicas = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(partitionState.replicas()).asScala();
            Seq<Node> replicaInfo = this.getEndpoints(snapshot, (Iterable<Integer>)replicas, listenerName, errorUnavailableEndpoints);
            Seq<Node> offlineReplicaInfo = this.getEndpoints(snapshot, (Iterable<Integer>)((Iterable)JavaConverters$.MODULE$.asScalaBufferConverter(partitionState.offlineReplicas()).asScala()), listenerName, errorUnavailableEndpoints);
            Buffer isr = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(partitionState.isr()).asScala();
            Seq<Node> isrInfo = this.getEndpoints(snapshot, (Iterable<Integer>)isr, listenerName, errorUnavailableEndpoints);
            Option<Node> option = maybeLeader;
            if (None$.MODULE$.equals(option)) {
                Errors errors;
                if (!snapshot.aliveBrokers().contains((long)$this.brokerId)) {
                    this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(56).append("Error while fetching metadata for ").append(topicPartition).append(": leader not available").toString());
                    errors = Errors.LEADER_NOT_AVAILABLE;
                } else {
                    this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(66).append("Error while fetching metadata for ").append(topicPartition).append(": listener ").append(listenerName).append(" not found on leader ").append(leaderBrokerId).toString());
                    errors = errorUnavailableListeners ? Errors.LISTENER_NOT_FOUND : Errors.LEADER_NOT_AVAILABLE;
                }
                Errors error = errors;
                partitionMetadata = new MetadataResponse.PartitionMetadata(error, (int)partitionId, Node.noNode(), Optional.empty(), (List)JavaConverters$.MODULE$.seqAsJavaListConverter(replicaInfo).asJava(), (List)JavaConverters$.MODULE$.seqAsJavaListConverter(isrInfo).asJava(), (List)JavaConverters$.MODULE$.seqAsJavaListConverter(offlineReplicaInfo).asJava());
                return partitionMetadata;
            } else {
                MetadataResponse.PartitionMetadata partitionMetadata2;
                if (!(option instanceof Some)) throw new MatchError(option);
                Some some = (Some)option;
                Node leader = (Node)some.value();
                if (replicaInfo.size() < replicas.size()) {
                    this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> {
                        Seq seq = (Seq)replicaInfo.map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.id()), Seq$.MODULE$.canBuildFrom());
                        return new StringBuilder(92).append("Error while fetching metadata for ").append(topicPartition).append(": replica information not available for ").append("following brokers ").append(((TraversableOnce)replicas.filterNot((Function1 & Serializable & scala.Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)seq.contains(elem)))).mkString(",")).toString();
                    });
                    partitionMetadata2 = new MetadataResponse.PartitionMetadata(Errors.REPLICA_NOT_AVAILABLE, (int)partitionId, leader, Optional.empty(), (List)JavaConverters$.MODULE$.seqAsJavaListConverter(replicaInfo).asJava(), (List)JavaConverters$.MODULE$.seqAsJavaListConverter(isrInfo).asJava(), (List)JavaConverters$.MODULE$.seqAsJavaListConverter(offlineReplicaInfo).asJava());
                } else if (isrInfo.size() < isr.size()) {
                    this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> {
                        Seq seq = (Seq)isrInfo.map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.id()), Seq$.MODULE$.canBuildFrom());
                        return new StringBuilder(100).append("Error while fetching metadata for ").append(topicPartition).append(": in sync replica information not available for ").append("following brokers ").append(((TraversableOnce)isr.filterNot((Function1 & Serializable & scala.Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)seq.contains(elem)))).mkString(",")).toString();
                    });
                    partitionMetadata2 = new MetadataResponse.PartitionMetadata(Errors.REPLICA_NOT_AVAILABLE, (int)partitionId, leader, Optional.empty(), (List)JavaConverters$.MODULE$.seqAsJavaListConverter(replicaInfo).asJava(), (List)JavaConverters$.MODULE$.seqAsJavaListConverter(isrInfo).asJava(), (List)JavaConverters$.MODULE$.seqAsJavaListConverter(offlineReplicaInfo).asJava());
                } else {
                    partitionMetadata2 = new MetadataResponse.PartitionMetadata(Errors.NONE, (int)partitionId, leader, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)), (List)JavaConverters$.MODULE$.seqAsJavaListConverter(replicaInfo).asJava(), (List)JavaConverters$.MODULE$.seqAsJavaListConverter(isrInfo).asJava(), (List)JavaConverters$.MODULE$.seqAsJavaListConverter(offlineReplicaInfo).asJava());
                }
                partitionMetadata = partitionMetadata2;
            }
            return partitionMetadata;
        }, scala.collection.mutable.Iterable$.MODULE$.canBuildFrom()));
    }

    private Option<Node> getAliveEndpoint(MetadataSnapshot snapshot, int brokerId, ListenerName listenerName) {
        return snapshot.aliveNodes().get((long)brokerId).flatMap((Function1 & Serializable & scala.Serializable)x$3 -> x$3.get((Object)listenerName));
    }

    public Seq<MetadataResponse.TopicMetadata> getTopicMetadata(Set<String> topics, ListenerName listenerName, boolean errorUnavailableEndpoints, boolean errorUnavailableListeners) {
        MetadataSnapshot snapshot = this.metadataSnapshot();
        return (Seq)topics.toSeq().flatMap((Function1 & Serializable & scala.Serializable)topic -> Option$.MODULE$.option2Iterable(this.getPartitionMetadata(snapshot, (String)topic, listenerName, errorUnavailableEndpoints, errorUnavailableListeners).map((Function1 & Serializable & scala.Serializable)partitionMetadata -> new MetadataResponse.TopicMetadata(Errors.NONE, topic, Topic.isInternal((String)topic), (List)JavaConverters$.MODULE$.bufferAsJavaListConverter(partitionMetadata.toBuffer()).asJava()))), Seq$.MODULE$.canBuildFrom());
    }

    public boolean getTopicMetadata$default$3() {
        return false;
    }

    public boolean getTopicMetadata$default$4() {
        return false;
    }

    public Set<String> getAllTopics() {
        return this.getAllTopics(this.metadataSnapshot());
    }

    public Set<TopicPartition> getAllPartitions() {
        return ((TraversableOnce)this.metadataSnapshot().partitionStates().flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String topicName = (String)tuple2._1();
            LongMap partitionsAndStates = (LongMap)tuple2._2();
            Iterable iterable = (Iterable)partitionsAndStates.keys().map((Function1 & Serializable & scala.Serializable)partitionId -> MetadataCache.$anonfun$getAllPartitions$2(topicName, BoxesRunTime.unboxToLong((Object)partitionId)), scala.collection.Iterable$.MODULE$.canBuildFrom());
            return iterable;
        }, scala.collection.mutable.Iterable$.MODULE$.canBuildFrom())).toSet();
    }

    private Set<String> getAllTopics(MetadataSnapshot snapshot) {
        return snapshot.partitionStates().keySet();
    }

    private scala.collection.immutable.Map<TopicPartition, UpdateMetadataRequestData.UpdateMetadataPartitionState> getAllPartitions(MetadataSnapshot snapshot) {
        return ((TraversableOnce)snapshot.partitionStates().flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String topic = (String)tuple2._1();
            LongMap partitionStates = (LongMap)tuple2._2();
            scala.collection.mutable.Map map = (scala.collection.mutable.Map)partitionStates.map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                Tuple2 tuple2 = x0$2;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                long partition = tuple2._1$mcJ$sp();
                UpdateMetadataRequestData.UpdateMetadataPartitionState state = (UpdateMetadataRequestData.UpdateMetadataPartitionState)tuple2._2();
                Tuple2 tuple22 = new Tuple2((Object)new TopicPartition(topic, (int)partition), (Object)state);
                return tuple22;
            }, Map$.MODULE$.canBuildFrom());
            return map;
        }, AnyRefMap$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public Set<String> getNonExistingTopics(Set<String> topics) {
        return (Set)topics.$minus$minus((GenTraversableOnce)this.metadataSnapshot().partitionStates().keySet());
    }

    public Option<Broker> getAliveBroker(int brokerId) {
        return this.metadataSnapshot().aliveBrokers().get((long)brokerId);
    }

    public Seq<Broker> getAliveBrokers() {
        return this.metadataSnapshot().aliveBrokers().values().toBuffer();
    }

    private void addOrUpdatePartitionInfo(AnyRefMap<String, LongMap<UpdateMetadataRequestData.UpdateMetadataPartitionState>> partitionStates, String topic, int partitionId, UpdateMetadataRequestData.UpdateMetadataPartitionState stateInfo) {
        LongMap infos = (LongMap)partitionStates.getOrElseUpdate((Object)topic, (Function0 & Serializable & scala.Serializable)() -> LongMap$.MODULE$.apply((Seq)Nil$.MODULE$));
        infos.update((long)partitionId, (Object)stateInfo);
    }

    public Option<UpdateMetadataRequestData.UpdateMetadataPartitionState> getPartitionInfo(String topic, int partitionId) {
        return this.metadataSnapshot().partitionStates().get((Object)topic).flatMap((Function1 & Serializable & scala.Serializable)x$4 -> x$4.get((long)partitionId));
    }

    public Option<Node> getPartitionLeaderEndpoint(String topic, int partitionId, ListenerName listenerName) {
        MetadataSnapshot snapshot = this.metadataSnapshot();
        return snapshot.partitionStates().get((Object)topic).flatMap((Function1 & Serializable & scala.Serializable)x$5 -> x$5.get((long)partitionId)).map((Function1 & Serializable & scala.Serializable)partitionInfo -> {
            Node node;
            int leaderId = partitionInfo.leader();
            Option option = snapshot.aliveNodes().get((long)leaderId);
            if (option instanceof Some) {
                Some some = (Some)option;
                Map nodeMap = (Map)some.value();
                node = (Node)nodeMap.getOrElse((Object)listenerName, (Function0 & Serializable & scala.Serializable)() -> Node.noNode());
            } else if (None$.MODULE$.equals(option)) {
                node = Node.noNode();
            } else {
                throw new MatchError((Object)option);
            }
            return node;
        });
    }

    public scala.collection.immutable.Map<Object, Node> getPartitionReplicaEndpoints(TopicPartition tp, ListenerName listenerName) {
        MetadataSnapshot snapshot = this.metadataSnapshot();
        return (scala.collection.immutable.Map)snapshot.partitionStates().get((Object)tp.topic()).flatMap((Function1 & Serializable & scala.Serializable)x$6 -> x$6.get((long)tp.partition())).map((Function1 & Serializable & scala.Serializable)partitionInfo -> {
            List replicaIds = partitionInfo.replicas();
            return (scala.collection.immutable.Map)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(replicaIds).asScala()).map((Function1 & Serializable & scala.Serializable)replicaId -> {
                Node node;
                Object object = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)replicaId));
                Option option = snapshot.aliveBrokers().get(replicaId.longValue());
                if (option instanceof Some) {
                    Some some = (Some)option;
                    Broker broker = (Broker)some.value();
                    node = (Node)broker.getNode(listenerName).getOrElse((Function0 & Serializable & scala.Serializable)() -> Node.noNode());
                } else if (None$.MODULE$.equals(option)) {
                    node = Node.noNode();
                } else {
                    throw new MatchError((Object)option);
                }
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(object, (Object)node);
            }, Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()).filter((Function1 & Serializable & scala.Serializable)pair -> BoxesRunTime.boxToBoolean((boolean)MetadataCache.$anonfun$getPartitionReplicaEndpoints$5(pair)));
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.Map().empty());
    }

    public Option<Object> getControllerId() {
        return this.metadataSnapshot().controllerId();
    }

    public Cluster getClusterMetadata(String clusterId, ListenerName listenerName) {
        MetadataSnapshot snapshot = this.metadataSnapshot();
        LongMap nodes = (LongMap)snapshot.aliveNodes().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            long id = tuple2._1$mcJ$sp();
            Map nodes = (Map)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToLong((long)id), nodes.get((Object)listenerName).orNull(Predef$.MODULE$.$conforms()));
            return tuple22;
        }, LongMap$.MODULE$.canBuildFrom());
        scala.collection.immutable.Iterable partitions = (scala.collection.immutable.Iterable)((TraversableLike)this.getAllPartitions(snapshot).filter((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)MetadataCache.$anonfun$getClusterMetadata$2(x0$2)))).map((Function1 & Serializable & scala.Serializable)x0$3 -> {
            Tuple2 tuple2 = x0$3;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            TopicPartition tp = (TopicPartition)tuple2._1();
            UpdateMetadataRequestData.UpdateMetadataPartitionState state = (UpdateMetadataRequestData.UpdateMetadataPartitionState)tuple2._2();
            PartitionInfo partitionInfo = new PartitionInfo(tp.topic(), tp.partition(), MetadataCache.node$1(Predef$.MODULE$.int2Integer(state.leader()), nodes), (Node[])((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(state.replicas()).asScala()).map((Function1 & Serializable & scala.Serializable)id -> MetadataCache.node$1(id, nodes), Buffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Node.class)), (Node[])((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(state.isr()).asScala()).map((Function1 & Serializable & scala.Serializable)id -> MetadataCache.node$1(id, nodes), Buffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Node.class)), (Node[])((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(state.offlineReplicas()).asScala()).map((Function1 & Serializable & scala.Serializable)id -> MetadataCache.node$1(id, nodes), Buffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Node.class)));
            return partitionInfo;
        }, Iterable$.MODULE$.canBuildFrom());
        java.util.Set unauthorizedTopics = Collections.emptySet();
        java.util.Set internalTopics = (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)this.getAllTopics(snapshot).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)MetadataCache.$anonfun$getClusterMetadata$7(x$1)))).asJava();
        return new Cluster(clusterId, (Collection)JavaConverters$.MODULE$.bufferAsJavaListConverter(((TraversableOnce)nodes.values().filter((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)MetadataCache.$anonfun$getClusterMetadata$8(x$7)))).toBuffer()).asJava(), (Collection)JavaConverters$.MODULE$.bufferAsJavaListConverter(partitions.toBuffer()).asJava(), unauthorizedTopics, internalTopics, (Node)snapshot.controllerId().map((Function1 & Serializable & scala.Serializable)id -> MetadataCache.node$1(Predef$.MODULE$.int2Integer(BoxesRunTime.unboxToInt((Object)id)), nodes)).orNull(Predef$.MODULE$.$conforms()));
    }

    public Seq<TopicPartition> updateMetadata(int correlationId, UpdateMetadataRequest updateMetadataRequest) {
        return (Seq)CoreUtils$.MODULE$.inWriteLock(this.partitionMetadataLock(), (Function0 & Serializable & scala.Serializable)() -> {
            LongMap aliveBrokers = new LongMap(this.metadataSnapshot().aliveBrokers().size());
            LongMap aliveNodes = new LongMap(this.metadataSnapshot().aliveNodes().size());
            int n = updateMetadataRequest.controllerId();
            switch (n) {
                default: 
            }
            None$ controllerId = n < 0 ? None$.MODULE$ : new Some((Object)BoxesRunTime.boxToInteger((int)n));
            ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(updateMetadataRequest.liveBrokers()).asScala()).foreach((Function1 & Serializable & scala.Serializable)broker -> {
                MetadataCache.$anonfun$updateMetadata$2(aliveBrokers, aliveNodes, broker);
                return BoxedUnit.UNIT;
            });
            aliveNodes.get((long)$this.brokerId).foreach((Function1 & Serializable & scala.Serializable)listenerMap -> {
                MetadataCache.$anonfun$updateMetadata$4(this, aliveNodes, listenerMap);
                return BoxedUnit.UNIT;
            });
            ArrayBuffer deletedPartitions = new ArrayBuffer();
            if (!updateMetadataRequest.partitionStates().iterator().hasNext()) {
                this.metadataSnapshot_$eq(new MetadataSnapshot(this, this.metadataSnapshot().partitionStates(), (Option<Object>)controllerId, (LongMap<Broker>)aliveBrokers, (LongMap<Map<ListenerName, Node>>)aliveNodes));
            } else {
                AnyRefMap partitionStates = new AnyRefMap(this.metadataSnapshot().partitionStates().size());
                this.metadataSnapshot().partitionStates().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    Tuple2 tuple2 = x0$1;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    String topic = (String)tuple2._1();
                    LongMap oldPartitionStates = (LongMap)tuple2._2();
                    LongMap copy = new LongMap(oldPartitionStates.size());
                    copy.$plus$plus$eq((TraversableOnce)oldPartitionStates);
                    AnyRefMap anyRefMap = partitionStates.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic), (Object)copy));
                    return anyRefMap;
                });
                ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(updateMetadataRequest.partitionStates()).asScala()).foreach((Function1 & Serializable & scala.Serializable)info -> {
                    BoxedUnit boxedUnit;
                    int controllerId = updateMetadataRequest.controllerId();
                    int controllerEpoch = updateMetadataRequest.controllerEpoch();
                    TopicPartition tp = new TopicPartition(info.topicName(), info.partitionIndex());
                    if (info.leader() == LeaderAndIsr$.MODULE$.LeaderDuringDelete()) {
                        this.removePartitionInfo((AnyRefMap<String, LongMap<UpdateMetadataRequestData.UpdateMetadataPartitionState>>)partitionStates, tp.topic(), tp.partition());
                        this.stateChangeLogger().trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(124).append("Deleted partition ").append(tp).append(" from metadata cache in response to UpdateMetadata ").append("request sent by controller ").append(controllerId).append(" epoch ").append(controllerEpoch).append(" with correlation id ").append(correlationId).toString());
                        boxedUnit = deletedPartitions.$plus$eq((Object)tp);
                    } else {
                        this.addOrUpdatePartitionInfo((AnyRefMap<String, LongMap<UpdateMetadataRequestData.UpdateMetadataPartitionState>>)partitionStates, tp.topic(), tp.partition(), (UpdateMetadataRequestData.UpdateMetadataPartitionState)info);
                        this.stateChangeLogger().trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(120).append("Cached leader info ").append(info).append(" for partition ").append(tp).append(" in response to ").append("UpdateMetadata request sent by controller ").append(controllerId).append(" epoch ").append(controllerEpoch).append(" with correlation id ").append(correlationId).toString());
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    return boxedUnit;
                });
                this.metadataSnapshot_$eq(new MetadataSnapshot(this, (AnyRefMap<String, LongMap<UpdateMetadataRequestData.UpdateMetadataPartitionState>>)partitionStates, (Option<Object>)controllerId, (LongMap<Broker>)aliveBrokers, (LongMap<Map<ListenerName, Node>>)aliveNodes));
            }
            return deletedPartitions;
        });
    }

    public boolean contains(String topic) {
        return this.metadataSnapshot().partitionStates().contains((Object)topic);
    }

    public boolean contains(TopicPartition tp) {
        return this.getPartitionInfo(tp.topic(), tp.partition()).isDefined();
    }

    private boolean removePartitionInfo(AnyRefMap<String, LongMap<UpdateMetadataRequestData.UpdateMetadataPartitionState>> partitionStates, String topic, int partitionId) {
        return partitionStates.get((Object)topic).exists((Function1 & Serializable & scala.Serializable)infos -> BoxesRunTime.boxToBoolean((boolean)MetadataCache.$anonfun$removePartitionInfo$1(partitionId, partitionStates, topic, infos)));
    }

    private final void MetadataSnapshot$lzycompute$1() {
        MetadataCache metadataCache = this;
        synchronized (metadataCache) {
            if (this.MetadataSnapshot$module == null) {
                this.MetadataSnapshot$module = new MetadataCache$MetadataSnapshot$(this);
            }
        }
    }

    public static final /* synthetic */ void $anonfun$getEndpoints$1(MetadataCache $this, MetadataSnapshot snapshot$1, ListenerName listenerName$1, boolean filterUnavailableEndpoints$1, ArrayBuffer result$1, Integer brokerId) {
        None$ none$;
        Option<Node> option = $this.getAliveEndpoint(snapshot$1, Predef$.MODULE$.Integer2int(brokerId), listenerName$1);
        if (None$.MODULE$.equals(option)) {
            none$ = !filterUnavailableEndpoints$1 ? new Some((Object)new Node(Predef$.MODULE$.Integer2int(brokerId), "", -1)) : None$.MODULE$;
        } else if (option instanceof Some) {
            Some some = (Some)option;
            Node node = (Node)some.value();
            none$ = new Some((Object)node);
        } else {
            throw new MatchError(option);
        }
        None$ endpoint = none$;
        endpoint.foreach((Function1 & Serializable & scala.Serializable)elem -> result$1.$plus$eq(elem));
    }

    public static final /* synthetic */ TopicPartition $anonfun$getAllPartitions$2(String topicName$1, long partitionId) {
        return new TopicPartition(topicName$1, (int)partitionId);
    }

    public static final /* synthetic */ boolean $anonfun$getPartitionReplicaEndpoints$5(Tuple2 pair) {
        Tuple2 tuple2 = pair;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Node node = (Node)tuple2._2();
        boolean bl = !node.isEmpty();
        return bl;
    }

    private static final Node node$1(Integer id, LongMap nodes$1) {
        return (Node)nodes$1.get((long)Predef$.MODULE$.Integer2int(id)).orNull(Predef$.MODULE$.$conforms());
    }

    public static final /* synthetic */ boolean $anonfun$getClusterMetadata$2(Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        UpdateMetadataRequestData.UpdateMetadataPartitionState state = (UpdateMetadataRequestData.UpdateMetadataPartitionState)tuple2._2();
        boolean bl = state.leader() != LeaderAndIsr$.MODULE$.LeaderDuringDelete();
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$getClusterMetadata$7(String x$1) {
        return Topic.isInternal((String)x$1);
    }

    public static final /* synthetic */ boolean $anonfun$getClusterMetadata$8(Node x$7) {
        return x$7 != null;
    }

    public static final /* synthetic */ void $anonfun$updateMetadata$2(LongMap aliveBrokers$1, LongMap aliveNodes$1, UpdateMetadataRequestData.UpdateMetadataBroker broker) {
        HashMap nodes = new HashMap();
        ArrayBuffer endPoints = new ArrayBuffer();
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(broker.endpoints()).asScala()).foreach((Function1 & Serializable & scala.Serializable)ep -> {
            ListenerName listenerName = new ListenerName(ep.listener());
            endPoints.$plus$eq((Object)new EndPoint(ep.host(), ep.port(), listenerName, SecurityProtocol.forId((short)ep.securityProtocol())));
            return nodes.put(listenerName, new Node(broker.id(), ep.host(), ep.port()));
        });
        aliveBrokers$1.update((long)broker.id(), (Object)new Broker(broker.id(), (Seq<EndPoint>)endPoints, (Option<String>)Option$.MODULE$.apply((Object)broker.rack())));
        aliveNodes$1.update((long)broker.id(), JavaConverters$.MODULE$.mapAsScalaMapConverter(nodes).asScala());
    }

    public static final /* synthetic */ boolean $anonfun$updateMetadata$5(Set listeners$1, Map x$8) {
        Set set = x$8.keySet();
        Set set2 = listeners$1;
        return !(set != null ? !set.equals(set2) : set2 != null);
    }

    public static final /* synthetic */ void $anonfun$updateMetadata$4(MetadataCache $this, LongMap aliveNodes$1, Map listenerMap) {
        block0: {
            Set listeners = listenerMap.keySet();
            if (aliveNodes$1.values().forall((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)MetadataCache.$anonfun$updateMetadata$5(listeners, x$8)))) break block0;
            $this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Listeners are not identical across brokers: ").append(aliveNodes$1).toString());
        }
    }

    public static final /* synthetic */ boolean $anonfun$removePartitionInfo$1(int partitionId$3, AnyRefMap partitionStates$2, String topic$4, LongMap infos) {
        infos.remove((Object)BoxesRunTime.boxToLong((long)partitionId$3));
        Object object = infos.isEmpty() ? partitionStates$2.remove((Object)topic$4) : BoxedUnit.UNIT;
        return true;
    }

    public MetadataCache(int brokerId) {
        this.brokerId = brokerId;
        Logging.$init$(this);
        this.partitionMetadataLock = new ReentrantReadWriteLock();
        this.metadataSnapshot = new MetadataSnapshot(this, (AnyRefMap<String, LongMap<UpdateMetadataRequestData.UpdateMetadataPartitionState>>)AnyRefMap$.MODULE$.empty(), (Option<Object>)None$.MODULE$, (LongMap<Broker>)LongMap$.MODULE$.empty(), (LongMap<Map<ListenerName, Node>>)LongMap$.MODULE$.empty());
        this.logIdent_$eq(new StringBuilder(26).append("[MetadataCache brokerId=").append(brokerId).append("] ").toString());
        this.stateChangeLogger = new StateChangeLogger(brokerId, false, (Option<Object>)None$.MODULE$);
    }

    public class MetadataSnapshot
    implements Product,
    scala.Serializable {
        private final AnyRefMap<String, LongMap<UpdateMetadataRequestData.UpdateMetadataPartitionState>> partitionStates;
        private final Option<Object> controllerId;
        private final LongMap<Broker> aliveBrokers;
        private final LongMap<Map<ListenerName, Node>> aliveNodes;
        public final /* synthetic */ MetadataCache $outer;

        public AnyRefMap<String, LongMap<UpdateMetadataRequestData.UpdateMetadataPartitionState>> partitionStates() {
            return this.partitionStates;
        }

        public Option<Object> controllerId() {
            return this.controllerId;
        }

        public LongMap<Broker> aliveBrokers() {
            return this.aliveBrokers;
        }

        public LongMap<Map<ListenerName, Node>> aliveNodes() {
            return this.aliveNodes;
        }

        public MetadataSnapshot copy(AnyRefMap<String, LongMap<UpdateMetadataRequestData.UpdateMetadataPartitionState>> partitionStates, Option<Object> controllerId, LongMap<Broker> aliveBrokers, LongMap<Map<ListenerName, Node>> aliveNodes) {
            return new MetadataSnapshot(this.kafka$server$MetadataCache$MetadataSnapshot$$$outer(), partitionStates, controllerId, aliveBrokers, aliveNodes);
        }

        public AnyRefMap<String, LongMap<UpdateMetadataRequestData.UpdateMetadataPartitionState>> copy$default$1() {
            return this.partitionStates();
        }

        public Option<Object> copy$default$2() {
            return this.controllerId();
        }

        public LongMap<Broker> copy$default$3() {
            return this.aliveBrokers();
        }

        public LongMap<Map<ListenerName, Node>> copy$default$4() {
            return this.aliveNodes();
        }

        public String productPrefix() {
            return "MetadataSnapshot";
        }

        public int productArity() {
            return 4;
        }

        public Object productElement(int x$1) {
            AnyRefMap<String, LongMap<UpdateMetadataRequestData.UpdateMetadataPartitionState>> anyRefMap;
            int n = x$1;
            switch (n) {
                case 0: {
                    anyRefMap = this.partitionStates();
                    break;
                }
                case 1: {
                    anyRefMap = this.controllerId();
                    break;
                }
                case 2: {
                    anyRefMap = this.aliveBrokers();
                    break;
                }
                case 3: {
                    anyRefMap = this.aliveNodes();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
            }
            return anyRefMap;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof MetadataSnapshot;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof MetadataSnapshot)) return false;
            if (((MetadataSnapshot)object).kafka$server$MetadataCache$MetadataSnapshot$$$outer() != this.kafka$server$MetadataCache$MetadataSnapshot$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            MetadataSnapshot metadataSnapshot = (MetadataSnapshot)x$1;
            AnyRefMap<String, LongMap<UpdateMetadataRequestData.UpdateMetadataPartitionState>> anyRefMap = this.partitionStates();
            AnyRefMap<String, LongMap<UpdateMetadataRequestData.UpdateMetadataPartitionState>> anyRefMap2 = metadataSnapshot.partitionStates();
            if (anyRefMap == null) {
                if (anyRefMap2 != null) {
                    return false;
                }
            } else if (!anyRefMap.equals(anyRefMap2)) return false;
            Option<Object> option = this.controllerId();
            Option<Object> option2 = metadataSnapshot.controllerId();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            LongMap<Broker> longMap = this.aliveBrokers();
            LongMap<Broker> longMap2 = metadataSnapshot.aliveBrokers();
            if (longMap == null) {
                if (longMap2 != null) {
                    return false;
                }
            } else if (!longMap.equals(longMap2)) return false;
            LongMap<Map<ListenerName, Node>> longMap3 = this.aliveNodes();
            LongMap<Map<ListenerName, Node>> longMap4 = metadataSnapshot.aliveNodes();
            if (longMap3 == null) {
                if (longMap4 != null) {
                    return false;
                }
            } else if (!longMap3.equals(longMap4)) return false;
            if (!metadataSnapshot.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ MetadataCache kafka$server$MetadataCache$MetadataSnapshot$$$outer() {
            return this.$outer;
        }

        public MetadataSnapshot(MetadataCache $outer, AnyRefMap<String, LongMap<UpdateMetadataRequestData.UpdateMetadataPartitionState>> partitionStates, Option<Object> controllerId, LongMap<Broker> aliveBrokers, LongMap<Map<ListenerName, Node>> aliveNodes) {
            this.partitionStates = partitionStates;
            this.controllerId = controllerId;
            this.aliveBrokers = aliveBrokers;
            this.aliveNodes = aliveNodes;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }
}

