/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.epoch;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kafka.server.checkpoints.LeaderEpochCheckpoint;
import kafka.server.epoch.EpochEntry;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import org.apache.kafka.common.TopicPartition;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005Ec\u0001\u0002\r\u001a\u0001\u0001B\u0001\"\f\u0001\u0003\u0002\u0003\u0006IA\f\u0005\ts\u0001\u0011\t\u0011)A\u0005u!A\u0001\t\u0001B\u0001B\u0003%\u0011\tC\u0003H\u0001\u0011\u0005\u0001\nC\u0004O\u0001\t\u0007I\u0011B(\t\rq\u0003\u0001\u0015!\u0003Q\u0011\u001di\u0006\u00011A\u0005\nyCqA\u001b\u0001A\u0002\u0013%1\u000e\u0003\u0004r\u0001\u0001\u0006Ka\u0018\u0005\u0006e\u0002!\ta\u001d\u0005\u0006u\u0002!Ia\u001f\u0005\u0006}\u0002!\ta \u0005\b\u0003\u000f\u0001A\u0011AA\u0005\u0011\u001d\t\t\u0002\u0001C\u0001\u0003'Aq!a\u0006\u0001\t\u0003\tI\u0002C\u0004\u0002&\u0001!\t!a\n\t\u000f\u00055\u0002\u0001\"\u0001\u00020!9\u00111\u0007\u0001\u0005\u0002\u0005U\u0002bBA\u001c\u0001\u0011\u0005\u0011Q\u0007\u0005\b\u0003s\u0001A\u0011AA\u001e\u0011\u001d\t)\u0005\u0001C\u0005\u0003'Aq!a\u0012\u0001\t\u0013\t)\u0004C\u0004\u0002J\u0001!I!a\u0013\u0003)1+\u0017\rZ3s\u000bB|7\r\u001b$jY\u0016\u001c\u0015m\u00195f\u0015\tQ2$A\u0003fa>\u001c\u0007N\u0003\u0002\u001d;\u000511/\u001a:wKJT\u0011AH\u0001\u0006W\u000647.Y\u0002\u0001'\r\u0001\u0011e\n\t\u0003E\u0015j\u0011a\t\u0006\u0002I\u0005)1oY1mC&\u0011ae\t\u0002\u0007\u0003:L(+\u001a4\u0011\u0005!ZS\"A\u0015\u000b\u0005)j\u0012!B;uS2\u001c\u0018B\u0001\u0017*\u0005\u001daunZ4j]\u001e\fa\u0002^8qS\u000e\u0004\u0016M\u001d;ji&|g\u000e\u0005\u00020o5\t\u0001G\u0003\u00022e\u000511m\\7n_:T!AH\u001a\u000b\u0005Q*\u0014AB1qC\u000eDWMC\u00017\u0003\ry'oZ\u0005\u0003qA\u0012a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g.\u0001\u0007m_\u001e,e\u000eZ(gMN,G\u000fE\u0002#wuJ!\u0001P\u0012\u0003\u0013\u0019+hn\u0019;j_:\u0004\u0004C\u0001\u0012?\u0013\ty4E\u0001\u0003M_:<\u0017AC2iK\u000e\\\u0007o\\5oiB\u0011!)R\u0007\u0002\u0007*\u0011AiG\u0001\fG\",7m\u001b9pS:$8/\u0003\u0002G\u0007\n)B*Z1eKJ,\u0005o\\2i\u0007\",7m\u001b9pS:$\u0018A\u0002\u001fj]&$h\b\u0006\u0003J\u00172k\u0005C\u0001&\u0001\u001b\u0005I\u0002\"B\u0017\u0005\u0001\u0004q\u0003\"B\u001d\u0005\u0001\u0004Q\u0004\"\u0002!\u0005\u0001\u0004\t\u0015\u0001\u00027pG.,\u0012\u0001\u0015\t\u0003#jk\u0011A\u0015\u0006\u0003'R\u000bQ\u0001\\8dWNT!!\u0016,\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0002X1\u0006!Q\u000f^5m\u0015\u0005I\u0016\u0001\u00026bm\u0006L!a\u0017*\u0003-I+WM\u001c;sC:$(+Z1e/JLG/\u001a'pG.\fQ\u0001\\8dW\u0002\na!\u001a9pG\"\u001cX#A0\u0011\u0007\u0001,w-D\u0001b\u0015\t\u00117-A\u0004nkR\f'\r\\3\u000b\u0005\u0011\u001c\u0013AC2pY2,7\r^5p]&\u0011a-\u0019\u0002\f\u0003J\u0014\u0018-\u001f\"vM\u001a,'\u000f\u0005\u0002KQ&\u0011\u0011.\u0007\u0002\u000b\u000bB|7\r[#oiJL\u0018AC3q_\u000eD7o\u0018\u0013fcR\u0011An\u001c\t\u0003E5L!A\\\u0012\u0003\tUs\u0017\u000e\u001e\u0005\ba\"\t\t\u00111\u0001`\u0003\rAH%M\u0001\bKB|7\r[:!\u0003\u0019\t7o]5h]R\u0019A\u000e\u001e=\t\u000biQ\u0001\u0019A;\u0011\u0005\t2\u0018BA<$\u0005\rIe\u000e\u001e\u0005\u0006s*\u0001\r!P\u0001\fgR\f'\u000f^(gMN,G/A\tueVt7-\u0019;f\u0003:$\u0017\t\u001d9f]\u0012$\"\u0001\u001c?\t\u000bu\\\u0001\u0019A4\u0002\u001b\u0015tGO]=U_\u0006\u0003\b/\u001a8e\u0003!qwN\\#naRLXCAA\u0001!\r\u0011\u00131A\u0005\u0004\u0003\u000b\u0019#a\u0002\"p_2,\u0017M\\\u0001\fY\u0006$Xm\u001d;Fa>\u001c\u0007.\u0006\u0002\u0002\fA!!%!\u0004v\u0013\r\tya\t\u0002\u0007\u001fB$\u0018n\u001c8\u0002\u001b\u0015\f'\u000f\\5fgR,e\u000e\u001e:z+\t\t)\u0002\u0005\u0003#\u0003\u001b9\u0017\u0001D3oI>3gm]3u\r>\u0014H\u0003BA\u000e\u0003C\u0001RAIA\u000fkvJ1!a\b$\u0005\u0019!V\u000f\u001d7fe!1\u00111E\bA\u0002U\faB]3rk\u0016\u001cH/\u001a3Fa>\u001c\u0007.A\bueVt7-\u0019;f\rJ|W.\u00128e)\ra\u0017\u0011\u0006\u0005\u0007\u0003W\u0001\u0002\u0019A\u001f\u0002\u0013\u0015tGm\u00144gg\u0016$\u0018!\u0005;sk:\u001c\u0017\r^3Ge>l7\u000b^1siR\u0019A.!\r\t\u000be\f\u0002\u0019A\u001f\u0002\u001b\rdW-\u0019:B]\u00124E.^:i)\u0005a\u0017!B2mK\u0006\u0014\u0018\u0001D3q_\u000eDWI\u001c;sS\u0016\u001cXCAA\u001f!\u0015\ty$!\u0011h\u001b\u0005\u0019\u0017bAA\"G\n\u00191+Z9\u0002\u00171\fG/Z:u\u000b:$(/_\u0001\u0006M2,8\u000f[\u0001\u0015m\u0006d\u0017\u000eZ1uK\u0006sG-T1zE\u0016<\u0016M\u001d8\u0015\u00071\fi\u0005\u0003\u0004\u0002P]\u0001\raZ\u0001\u0006K:$(/\u001f")
public class LeaderEpochFileCache
implements Logging {
    private final Function0<Object> logEndOffset;
    private final LeaderEpochCheckpoint checkpoint;
    private final ReentrantReadWriteLock lock;
    private ArrayBuffer<EpochEntry> epochs;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        LeaderEpochFileCache leaderEpochFileCache = this;
        synchronized (leaderEpochFileCache) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private ReentrantReadWriteLock lock() {
        return this.lock;
    }

    private ArrayBuffer<EpochEntry> epochs() {
        return this.epochs;
    }

    private void epochs_$eq(ArrayBuffer<EpochEntry> x$1) {
        this.epochs = x$1;
    }

    public void assign(int epoch, long startOffset) {
        CoreUtils$.MODULE$.inWriteLock(this.lock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            block0: {
                EpochEntry lastEntry;
                boolean updateNeeded;
                boolean bl = this.epochs().isEmpty() ? true : (updateNeeded = (lastEntry = (EpochEntry)this.epochs().last()).epoch() != epoch || startOffset < lastEntry.startOffset());
                if (!updateNeeded) break block0;
                this.truncateAndAppend(new EpochEntry(epoch, startOffset));
                this.flush();
            }
        });
    }

    private void truncateAndAppend(EpochEntry entryToAppend) {
        block2: {
            ArrayBuffer removedEpochs;
            block1: {
                this.validateAndMaybeWarn(entryToAppend);
                Tuple2 tuple2 = this.epochs().partition((Function1 & Serializable & scala.Serializable)entry -> BoxesRunTime.boxToBoolean((boolean)LeaderEpochFileCache.$anonfun$truncateAndAppend$1(entryToAppend, entry)));
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                ArrayBuffer retainedEpochs = (ArrayBuffer)tuple2._1();
                ArrayBuffer removedEpochs2 = (ArrayBuffer)tuple2._2();
                Tuple2 tuple22 = new Tuple2((Object)retainedEpochs, (Object)removedEpochs2);
                Tuple2 tuple23 = tuple22;
                ArrayBuffer retainedEpochs2 = (ArrayBuffer)tuple23._1();
                removedEpochs = (ArrayBuffer)tuple23._2();
                this.epochs_$eq((ArrayBuffer<EpochEntry>)((ArrayBuffer)retainedEpochs2.$colon$plus((Object)entryToAppend, ArrayBuffer$.MODULE$.canBuildFrom())));
                if (!removedEpochs.isEmpty()) break block1;
                this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(55).append("Appended new epoch entry ").append(entryToAppend).append(". Cache now contains ").append(this.epochs().size()).append(" entries.").toString());
                break block2;
            }
            if (removedEpochs.size() <= 1 && ((EpochEntry)removedEpochs.head()).startOffset() == entryToAppend.startOffset()) break block2;
            this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(88).append("New epoch entry ").append(entryToAppend).append(" caused truncation of conflicting entries ").append(removedEpochs).append(". ").append("Cache now contains ").append(this.epochs().size()).append(" entries.").toString());
        }
    }

    public boolean nonEmpty() {
        return BoxesRunTime.unboxToBoolean(CoreUtils$.MODULE$.inReadLock(this.lock(), (JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.epochs().nonEmpty()));
    }

    public Option<Object> latestEpoch() {
        return (Option)CoreUtils$.MODULE$.inReadLock(this.lock(), (Function0 & Serializable & scala.Serializable)() -> this.epochs().lastOption().map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.epoch())));
    }

    public Option<EpochEntry> earliestEntry() {
        return (Option)CoreUtils$.MODULE$.inReadLock(this.lock(), (Function0 & Serializable & scala.Serializable)() -> this.epochs().headOption());
    }

    public Tuple2<Object, Object> endOffsetFor(int requestedEpoch) {
        return (Tuple2)CoreUtils$.MODULE$.inReadLock(this.lock(), (Function0 & Serializable & scala.Serializable)() -> {
            void var3_9;
            Tuple2.mcIJ.sp sp2;
            if (requestedEpoch == -1) {
                sp2 = new Tuple2.mcIJ.sp(-1, -1L);
            } else if (this.latestEpoch().contains((Object)BoxesRunTime.boxToInteger((int)requestedEpoch))) {
                sp2 = new Tuple2.mcIJ.sp(requestedEpoch, $this.logEndOffset.apply$mcJ$sp());
            } else {
                Tuple2 tuple2 = this.epochs().partition((Function1 & Serializable & scala.Serializable)e -> BoxesRunTime.boxToBoolean((boolean)LeaderEpochFileCache.$anonfun$endOffsetFor$2(requestedEpoch, e)));
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                ArrayBuffer subsequentEpochs = (ArrayBuffer)tuple2._1();
                ArrayBuffer previousEpochs = (ArrayBuffer)tuple2._2();
                Tuple2 tuple22 = new Tuple2((Object)subsequentEpochs, (Object)previousEpochs);
                Tuple2 tuple23 = tuple22;
                ArrayBuffer subsequentEpochs2 = (ArrayBuffer)tuple23._1();
                ArrayBuffer previousEpochs2 = (ArrayBuffer)tuple23._2();
                sp2 = subsequentEpochs2.isEmpty() ? new Tuple2.mcIJ.sp(-1, -1L) : (previousEpochs2.isEmpty() ? new Tuple2.mcIJ.sp(requestedEpoch, ((EpochEntry)subsequentEpochs2.head()).startOffset()) : new Tuple2.mcIJ.sp(((EpochEntry)previousEpochs2.last()).epoch(), ((EpochEntry)subsequentEpochs2.head()).startOffset()));
            }
            Tuple2.mcIJ.sp epochAndOffset = sp2;
            this.debug((Function0<String>)((Function0 & Serializable & scala.Serializable)() -> LeaderEpochFileCache.$anonfun$endOffsetFor$3(this, requestedEpoch, (Tuple2)epochAndOffset)));
            return var3_9;
        });
    }

    public void truncateFromEnd(long endOffset) {
        CoreUtils$.MODULE$.inWriteLock(this.lock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            block1: {
                if (endOffset < 0L || !this.latestEntry().exists((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)LeaderEpochFileCache.$anonfun$truncateFromEnd$2(endOffset, x$4)))) break block1;
                Tuple2 tuple2 = this.epochs().partition((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)LeaderEpochFileCache.$anonfun$truncateFromEnd$3(endOffset, x$5)));
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                ArrayBuffer subsequentEntries = (ArrayBuffer)tuple2._1();
                ArrayBuffer previousEntries = (ArrayBuffer)tuple2._2();
                Tuple2 tuple22 = new Tuple2((Object)subsequentEntries, (Object)previousEntries);
                Tuple2 tuple23 = tuple22;
                ArrayBuffer subsequentEntries2 = (ArrayBuffer)tuple23._1();
                ArrayBuffer previousEntries2 = (ArrayBuffer)tuple23._2();
                this.epochs_$eq((ArrayBuffer<EpochEntry>)previousEntries2);
                this.flush();
                this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(97).append("Cleared entries ").append(subsequentEntries2).append(" from epoch cache after ").append("truncating to end offset ").append(endOffset).append(", leaving ").append(this.epochs().size()).append(" entries in the cache.").toString());
            }
        });
    }

    public void truncateFromStart(long startOffset) {
        CoreUtils$.MODULE$.inWriteLock(this.lock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            block1: {
                if (!this.epochs().nonEmpty()) break block1;
                Tuple2 tuple2 = this.epochs().partition((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)LeaderEpochFileCache.$anonfun$truncateFromStart$2(startOffset, x$7)));
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                ArrayBuffer subsequentEntries = (ArrayBuffer)tuple2._1();
                ArrayBuffer previousEntries = (ArrayBuffer)tuple2._2();
                Tuple2 tuple22 = new Tuple2((Object)subsequentEntries, (Object)previousEntries);
                Tuple2 tuple23 = tuple22;
                ArrayBuffer subsequentEntries2 = (ArrayBuffer)tuple23._1();
                ArrayBuffer previousEntries2 = (ArrayBuffer)tuple23._2();
                previousEntries2.lastOption().foreach((Function1 & Serializable & scala.Serializable)firstBeforeStartOffset -> {
                    LeaderEpochFileCache.$anonfun$truncateFromStart$3(this, startOffset, subsequentEntries2, previousEntries2, firstBeforeStartOffset);
                    return BoxedUnit.UNIT;
                });
            }
        });
    }

    public void clearAndFlush() {
        CoreUtils$.MODULE$.inWriteLock(this.lock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.epochs().clear();
            this.flush();
        });
    }

    public void clear() {
        CoreUtils$.MODULE$.inWriteLock(this.lock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.epochs().clear());
    }

    public Seq<EpochEntry> epochEntries() {
        return this.epochs();
    }

    private Option<EpochEntry> latestEntry() {
        return this.epochs().lastOption();
    }

    private void flush() {
        this.checkpoint.write((Seq<EpochEntry>)this.epochs());
    }

    private void validateAndMaybeWarn(EpochEntry entry) {
        if (entry.epoch() < 0) {
            throw new IllegalArgumentException(new StringBuilder(46).append("Received invalid partition leader epoch entry ").append(entry).toString());
        }
        this.latestEntry().foreach((Function1 & Serializable & scala.Serializable)latest -> {
            LeaderEpochFileCache.$anonfun$validateAndMaybeWarn$1(this, entry, latest);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$truncateAndAppend$1(EpochEntry entryToAppend$1, EpochEntry entry) {
        return entry.epoch() < entryToAppend$1.epoch() && entry.startOffset() < entryToAppend$1.startOffset();
    }

    public static final /* synthetic */ boolean $anonfun$endOffsetFor$2(int requestedEpoch$1, EpochEntry e) {
        return e.epoch() > requestedEpoch$1;
    }

    public static final /* synthetic */ String $anonfun$endOffsetFor$3(LeaderEpochFileCache $this, int requestedEpoch$1, Tuple2 epochAndOffset$1) {
        return new StringBuilder(103).append("Processed end offset request for epoch ").append(requestedEpoch$1).append(" and returning epoch ").append(epochAndOffset$1._1$mcI$sp()).append(" ").append("with end offset ").append(epochAndOffset$1._2$mcJ$sp()).append(" from epoch cache of size ").append($this.epochs().size()).toString();
    }

    public static final /* synthetic */ boolean $anonfun$truncateFromEnd$2(long endOffset$1, EpochEntry x$4) {
        return x$4.startOffset() >= endOffset$1;
    }

    public static final /* synthetic */ boolean $anonfun$truncateFromEnd$3(long endOffset$1, EpochEntry x$5) {
        return x$5.startOffset() >= endOffset$1;
    }

    public static final /* synthetic */ boolean $anonfun$truncateFromStart$2(long startOffset$2, EpochEntry x$7) {
        return x$7.startOffset() > startOffset$2;
    }

    public static final /* synthetic */ void $anonfun$truncateFromStart$3(LeaderEpochFileCache $this, long startOffset$2, ArrayBuffer subsequentEntries$2, ArrayBuffer previousEntries$1, EpochEntry firstBeforeStartOffset) {
        EpochEntry updatedFirstEntry;
        EpochEntry epochEntry = updatedFirstEntry = new EpochEntry(firstBeforeStartOffset.epoch(), startOffset$2);
        $this.epochs_$eq((ArrayBuffer<EpochEntry>)((ArrayBuffer)subsequentEntries$2.$plus$colon((Object)epochEntry, ArrayBuffer$.MODULE$.canBuildFrom())));
        $this.flush();
        $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(99).append("Cleared entries ").append(previousEntries$1).append(" and rewrote first entry ").append(updatedFirstEntry).append(" after ").append("truncating to start offset ").append(startOffset$2).append(", leaving ").append($this.epochs().size()).append(" in the cache.").toString());
    }

    public static final /* synthetic */ void $anonfun$validateAndMaybeWarn$1(LeaderEpochFileCache $this, EpochEntry entry$1, EpochEntry latest) {
        block1: {
            block0: {
                if (entry$1.epoch() >= latest.epoch()) break block0;
                $this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(143).append("Received leader epoch assignment ").append(entry$1).append(" which has an epoch less than the epoch ").append("of the latest entry ").append(latest).append(". This implies messages have arrived out of order.").toString());
                break block1;
            }
            if (entry$1.startOffset() >= latest.startOffset()) break block1;
            $this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(171).append("Received leader epoch assignment ").append(entry$1).append(" which has a starting offset which is less than ").append("the starting offset of the latest entry ").append(latest).append(". This implies messages have arrived out of order.").toString());
        }
    }

    public LeaderEpochFileCache(TopicPartition topicPartition, Function0<Object> logEndOffset, LeaderEpochCheckpoint checkpoint) {
        this.logEndOffset = logEndOffset;
        this.checkpoint = checkpoint;
        Logging.$init$(this);
        this.logIdent_$eq(new StringBuilder(20).append("[LeaderEpochCache ").append(topicPartition).append("] ").toString());
        this.lock = new ReentrantReadWriteLock();
        this.epochs = (ArrayBuffer)CoreUtils$.MODULE$.inWriteLock(this.lock(), (Function0 & Serializable & scala.Serializable)() -> {
            Seq<EpochEntry> read = $this.checkpoint.read();
            return new ArrayBuffer(read.size()).$plus$plus$eq(read);
        });
    }
}

