/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.File;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import kafka.api.BaseAdminIntegrationTest;
import kafka.api.PlaintextAdminIntegrationTest$;
import kafka.log.Log;
import kafka.log.LogConfig$;
import kafka.log.LogManager;
import kafka.security.authorizer.AclEntry$;
import kafka.server.Defaults$;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.Log4jController$;
import kafka.utils.TestUtils$;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AdminClientConfig;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.clients.admin.AlterConfigsOptions;
import org.apache.kafka.clients.admin.AlterConfigsResult;
import org.apache.kafka.clients.admin.AlterReplicaLogDirsOptions;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.clients.admin.ConsumerGroupDescription;
import org.apache.kafka.clients.admin.ConsumerGroupListing;
import org.apache.kafka.clients.admin.CreatePartitionsOptions;
import org.apache.kafka.clients.admin.CreatePartitionsResult;
import org.apache.kafka.clients.admin.CreateTopicsOptions;
import org.apache.kafka.clients.admin.DeleteConsumerGroupOffsetsResult;
import org.apache.kafka.clients.admin.DeleteConsumerGroupsResult;
import org.apache.kafka.clients.admin.DeleteRecordsResult;
import org.apache.kafka.clients.admin.DeletedRecords;
import org.apache.kafka.clients.admin.DescribeClusterResult;
import org.apache.kafka.clients.admin.DescribeConfigsResult;
import org.apache.kafka.clients.admin.DescribeConsumerGroupsOptions;
import org.apache.kafka.clients.admin.DescribeConsumerGroupsResult;
import org.apache.kafka.clients.admin.DescribeReplicaLogDirsResult;
import org.apache.kafka.clients.admin.DescribeTopicsOptions;
import org.apache.kafka.clients.admin.ElectLeadersOptions;
import org.apache.kafka.clients.admin.ElectLeadersResult;
import org.apache.kafka.clients.admin.KafkaAdminClient;
import org.apache.kafka.clients.admin.KafkaAdminClientTest;
import org.apache.kafka.clients.admin.ListConsumerGroupsResult;
import org.apache.kafka.clients.admin.MemberDescription;
import org.apache.kafka.clients.admin.MemberToRemove;
import org.apache.kafka.clients.admin.NewPartitionReassignment;
import org.apache.kafka.clients.admin.NewPartitions;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.admin.RecordsToDelete;
import org.apache.kafka.clients.admin.RemoveMembersFromConsumerGroupOptions;
import org.apache.kafka.clients.admin.RemoveMembersFromConsumerGroupResult;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.consumer.OffsetAndTimestamp;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.ConsumerGroupState;
import org.apache.kafka.common.ElectionType;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.TopicPartitionInfo;
import org.apache.kafka.common.TopicPartitionReplica;
import org.apache.kafka.common.acl.AccessControlEntry;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.acl.AclPermissionType;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.ElectionNotNeededException;
import org.apache.kafka.common.errors.EligibleLeadersNotAvailableException;
import org.apache.kafka.common.errors.GroupIdNotFoundException;
import org.apache.kafka.common.errors.GroupNotEmptyException;
import org.apache.kafka.common.errors.GroupSubscribedToTopicException;
import org.apache.kafka.common.errors.InterruptException;
import org.apache.kafka.common.errors.InvalidPartitionsException;
import org.apache.kafka.common.errors.InvalidReplicaAssignmentException;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.errors.InvalidTopicException;
import org.apache.kafka.common.errors.LeaderNotAvailableException;
import org.apache.kafka.common.errors.NotLeaderForPartitionException;
import org.apache.kafka.common.errors.OffsetOutOfRangeException;
import org.apache.kafka.common.errors.PreferredLeaderNotAvailableException;
import org.apache.kafka.common.errors.SecurityDisabledException;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.errors.TopicExistsException;
import org.apache.kafka.common.errors.UnknownMemberIdException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.requests.DescribeLogDirsResponse;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.resource.ResourcePattern;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenSet;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction0;
import scala.util.Random$;

@ScalaSignature(bytes="\u0006\u0001\r5a\u0001\u0002&L\u0001ACQ!\u0016\u0001\u0005\u0002YCq\u0001\u0017\u0001C\u0002\u0013\u0005\u0011\f\u0003\u0004c\u0001\u0001\u0006IA\u0017\u0005\bG\u0002\u0011\r\u0011\"\u0001e\u0011\u0019Y\u0007\u0001)A\u0005K\"9A\u000e\u0001b\u0001\n\u0003i\u0007BB=\u0001A\u0003%a\u000eC\u0005{\u0001\u0001\u0007\t\u0019!C\u0005w\"Y\u0011Q\u0001\u0001A\u0002\u0003\u0007I\u0011BA\u0004\u0011)\t\u0019\u0002\u0001a\u0001\u0002\u0003\u0006K\u0001 \u0005\n\u0003+\u0001!\u0019!C\u0005\u0003/A\u0001\"!\u0010\u0001A\u0003%\u0011\u0011\u0004\u0005\b\u0003\u007f\u0001A\u0011IA!\u0011\u001d\t\t\u0006\u0001C!\u0003\u0003Bq!a\u0017\u0001\t\u0003\t\t\u0005C\u0004\u0002f\u0001!\t!!\u0011\t\u000f\u0005%\u0004\u0001\"\u0001\u0002B!9\u0011Q\u000e\u0001\u0005\u0002\u0005\u0005\u0003bBA9\u0001\u0011\u0005\u0011\u0011\t\u0005\b\u0003k\u0002A\u0011AA!\u0011\u001d\tI\b\u0001C\u0001\u0003\u0003Bq!! \u0001\t\u0003\t\t\u0005C\u0004\u0002\u0002\u0002!\t!!\u0011\t\u000f\u0005\u0015\u0005\u0001\"\u0001\u0002B!9\u0011\u0011\u0012\u0001\u0005\u0002\u0005\u0005\u0003bBAG\u0001\u0011\u0005\u0011\u0011\t\u0005\b\u0003#\u0003A\u0011AA!\u0011\u001d\t)\n\u0001C\u0001\u0003\u0003Bq!!'\u0001\t\u0003\t\t\u0005C\u0004\u0002\u001e\u0002!\t!!\u0011\t\u000f\u0005\u0005\u0006\u0001\"\u0001\u0002B!9\u0011Q\u0015\u0001\u0005\u0002\u0005\u0005\u0003bBAU\u0001\u0011\u0005\u0011\u0011\t\u0005\b\u0003[\u0003A\u0011AA!\u0011\u001d\t\t\f\u0001C\u0005\u0003gCq!!6\u0001\t\u0013\t9\u000eC\u0004\u0002n\u0002!\t!!\u0011\t\u000f\u0005E\b\u0001\"\u0001\u0002B!9\u0011Q\u001f\u0001\u0005\u0002\u0005\u0005\u0003bBA}\u0001\u0011\u0005\u0011\u0011\t\u0005\b\u0003{\u0004A\u0011AA!\u0011\u001d\u0011\t\u0001\u0001C\u0001\u0003\u0003BqA!\u0002\u0001\t\u0003\t\t\u0005C\u0004\u0003\n\u0001!\t!!\u0011\t\u000f\t5\u0001\u0001\"\u0001\u0002B!9!\u0011\u0003\u0001\u0005\u0002\u0005\u0005\u0003b\u0002B\u000b\u0001\u0011\u0005\u0011\u0011\t\u0005\b\u00053\u0001A\u0011AA!\u0011\u001d\u0011i\u0002\u0001C\u0001\u0003\u0003BqA!\t\u0001\t\u0003\t\t\u0005C\u0004\u0003&\u0001!\t!!\u0011\t\u000f\t%\u0002\u0001\"\u0001\u0002B!9!Q\u0006\u0001\u0005\u0002\u0005\u0005\u0003b\u0002B\u0019\u0001\u0011\u0005\u0011\u0011\t\u0005\b\u0005k\u0001A\u0011AA!\u0011\u001d\u0011I\u0004\u0001C\u0001\u0003\u0003BqA!\u0010\u0001\t\u0003\t\t\u0005C\u0004\u0003B\u0001!\t!!\u0011\t\u000f\t\u0015\u0003\u0001\"\u0001\u0002B!9!\u0011\n\u0001\u0005\u0002\u0005\u0005\u0003b\u0002B+\u0001\u0011\u0005\u0011\u0011\t\u0005\b\u00057\u0002A\u0011AA!\u0011\u001d\u0011\t\u0007\u0001C\u0001\u0003\u0003BqAa\u001a\u0001\t\u0003\t\t\u0005C\u0004\u0003n\u0001!\tAa\u001c\t\u0013\t]\u0005!%A\u0005\u0002\te\u0005b\u0002BX\u0001\u0011\u0005!\u0011\u0017\u0005\b\u0005s\u0003A\u0011BA!\u000f\u001d\u0011Yl\u0013E\u0001\u0005{3aAS&\t\u0002\t}\u0006BB+G\t\u0003\u00119\rC\u0004\u0003J\u001a#\tAa3\t\u000f\t}g\t\"\u0001\u0003b\ni\u0002\u000b\\1j]R,\u0007\u0010^!e[&t\u0017J\u001c;fOJ\fG/[8o)\u0016\u001cHO\u0003\u0002M\u001b\u0006\u0019\u0011\r]5\u000b\u00039\u000bQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001#B\u0011!kU\u0007\u0002\u0017&\u0011Ak\u0013\u0002\u0019\u0005\u0006\u001cX-\u00113nS:Le\u000e^3he\u0006$\u0018n\u001c8UKN$\u0018A\u0002\u001fj]&$h\bF\u0001X!\t\u0011\u0006!A\u0003u_BL7-F\u0001[!\tY\u0006-D\u0001]\u0015\tif,\u0001\u0003mC:<'\"A0\u0002\t)\fg/Y\u0005\u0003Cr\u0013aa\u0015;sS:<\u0017A\u0002;pa&\u001c\u0007%A\u0005qCJ$\u0018\u000e^5p]V\tQ\r\u0005\u0002gS6\tqMC\u0001i\u0003\u0015\u00198-\u00197b\u0013\tQwMA\u0002J]R\f!\u0002]1si&$\u0018n\u001c8!\u00039!x\u000e]5d!\u0006\u0014H/\u001b;j_:,\u0012A\u001c\t\u0003_^l\u0011\u0001\u001d\u0006\u0003cJ\faaY8n[>t'B\u0001(t\u0015\t!X/\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002m\u0006\u0019qN]4\n\u0005a\u0004(A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\\\u0001\u0010i>\u0004\u0018n\u0019)beRLG/[8oA\u0005Q\"M]8lKJdunZ4fe\u000e{gNZ5h%\u0016\u001cx.\u001e:dKV\tA\u0010E\u0002~\u0003\u0003i\u0011A \u0006\u0003\u007fB\faaY8oM&<\u0017bAA\u0002}\nq1i\u001c8gS\u001e\u0014Vm]8ve\u000e,\u0017A\b2s_.,'\u000fT8hO\u0016\u00148i\u001c8gS\u001e\u0014Vm]8ve\u000e,w\fJ3r)\u0011\tI!a\u0004\u0011\u0007\u0019\fY!C\u0002\u0002\u000e\u001d\u0014A!\u00168ji\"A\u0011\u0011C\u0005\u0002\u0002\u0003\u0007A0A\u0002yIE\n1D\u0019:pW\u0016\u0014Hj\\4hKJ\u001cuN\u001c4jOJ+7o\\;sG\u0016\u0004\u0013\u0001F2iC:<W\r\u001a\"s_.,'\u000fT8hO\u0016\u00148/\u0006\u0002\u0002\u001aA1\u00111DA\u0013\u0003Si!!!\b\u000b\t\u0005}\u0011\u0011E\u0001\b[V$\u0018M\u00197f\u0015\r\t\u0019cZ\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA\u0014\u0003;\u00111aU3u!\u0011\tY#!\u000f\u000f\t\u00055\u0012Q\u0007\t\u0004\u0003_9WBAA\u0019\u0015\r\t\u0019dT\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005]r-\u0001\u0004Qe\u0016$WMZ\u0005\u0004C\u0006m\"bAA\u001cO\u0006)2\r[1oO\u0016$'I]8lKJdunZ4feN\u0004\u0013!B:fiV\u0003HCAA\u0005Q\ri\u0011Q\t\t\u0005\u0003\u000f\ni%\u0004\u0002\u0002J)\u0019\u00111J;\u0002\u000b),h.\u001b;\n\t\u0005=\u0013\u0011\n\u0002\u0007\u0005\u00164wN]3\u0002\u0011Q,\u0017M\u001d#po:D3ADA+!\u0011\t9%a\u0016\n\t\u0005e\u0013\u0011\n\u0002\u0006\u0003\u001a$XM]\u0001\ni\u0016\u001cHo\u00117pg\u0016D3aDA0!\u0011\t9%!\u0019\n\t\u0005\r\u0014\u0011\n\u0002\u0005)\u0016\u001cH/A\u0007uKN$H*[:u\u001d>$Wm\u001d\u0015\u0004!\u0005}\u0013!\r;fgR\u001c%/Z1uK\u0016C\u0018n\u001d;j]\u001e$v\u000e]5dgRC'o\\<U_BL7-\u0012=jgR\u001cX\t_2faRLwN\u001c\u0015\u0004#\u0005}\u0013a\u0005;fgRlU\r^1eCR\f'+\u001a4sKND\u0007f\u0001\n\u0002`\u0005aB/Z:u\t\u0016\u001c8M]5cK:{g.\u0012=jgRLgn\u001a+pa&\u001c\u0007fA\n\u0002`\u0005\u0019B/Z:u\t\u0016\u001c8M]5cK\u000ecWo\u001d;fe\"\u001aA#a\u0018\u0002'Q,7\u000f\u001e#fg\u000e\u0014\u0018NY3M_\u001e$\u0015N]:)\u0007U\ty&\u0001\u000euKN$H)Z:de&\u0014WMU3qY&\u001c\u0017\rT8h\t&\u00148\u000fK\u0002\u0017\u0003?\nq\u0003^3ti\u0006cG/\u001a:SKBd\u0017nY1M_\u001e$\u0015N]:)\u0007]\ty&A\u000euKN$H)Z:de&\u0014W-\u00118e\u00032$XM]\"p]\u001aLwm\u001d\u0015\u00041\u0005}\u0013\u0001\u0006;fgR\u001c%/Z1uKB\u000b'\u000f^5uS>t7\u000fK\u0002\u001a\u0003?\n!\u0004^3tiN+Wm[!gi\u0016\u0014H)\u001a7fi\u0016\u0014VmY8sIND3AGA0\u0003q!Xm\u001d;M_\u001e\u001cF/\u0019:u\u001f\u001a47/\u001a;DQ\u0016\u001c7\u000e]8j]RD3aGA0\u0003\u0011\"Xm\u001d;M_\u001e\u001cF/\u0019:u\u001f\u001a47/\u001a;BMR,'\u000fR3mKR,'+Z2pe\u0012\u001c\bf\u0001\u000f\u0002`\u00059D/Z:u%\u0016\u0004H.[2b\u0007\u0006tg)\u001a;dQ\u001a\u0013x.\u001c'pON#\u0018M\u001d;PM\u001a\u001cX\r^!gi\u0016\u0014H)\u001a7fi\u0016\u0014VmY8sIND3!HA0\u0003\t\"Xm\u001d;BYR,'\u000fT8h\t&\u00148/\u00114uKJ$U\r\\3uKJ+7m\u001c:eg\"\u001aa$a\u0018\u0002KQ,7\u000f^(gMN,Go\u001d$peRKW.Z:BMR,'\u000fR3mKR,'+Z2pe\u0012\u001c\bfA\u0010\u0002`\u0005iB/Z:u\u0007>t7/^7f\u0003\u001a$XM\u001d#fY\u0016$XMU3d_J$7\u000fK\u0002!\u0003?\na\u0004^3ti\u0012+G.\u001a;f%\u0016\u001cwN\u001d3t/&$\b.\u0012=dKB$\u0018n\u001c8)\u0007\u0005\ny&A\u000euKN$H)Z:de&\u0014WmQ8oM&<7OR8s)>\u0004\u0018n\u0019\u0015\u0004E\u0005}\u0013!H:vEN\u001c'/\u001b2f\u0003:$w+Y5u\r>\u0014\u0018i]:jO:lWM\u001c;\u0015\r\u0005%\u0011QWA\\\u0011\u0019A6\u00051\u0001\u0002*!9\u0011\u0011X\u0012A\u0002\u0005m\u0016\u0001C2p]N,X.\u001a:\u0011\u0011\u0005u\u0016QYAe\u0003\u0013l!!a0\u000b\t\u0005e\u0016\u0011\u0019\u0006\u0004\u0003\u0007\u0014\u0018aB2mS\u0016tGo]\u0005\u0005\u0003\u000f\fyLA\u0007LC\u001a\\\u0017mQ8ogVlWM\u001d\t\u0006M\u0006-\u0017qZ\u0005\u0004\u0003\u001b<'!B!se\u0006L\bc\u00014\u0002R&\u0019\u00111[4\u0003\t\tKH/Z\u0001\fg\u0016tGMU3d_J$7\u000f\u0006\u0005\u0002\n\u0005e\u0017q]Av\u0011\u001d\tY\u000e\na\u0001\u0003;\f\u0001\u0002\u001d:pIV\u001cWM\u001d\t\t\u0003?\f\u0019/!3\u0002J6\u0011\u0011\u0011\u001d\u0006\u0005\u00037\f\t-\u0003\u0003\u0002f\u0006\u0005(!D&bM.\f\u0007K]8ek\u000e,'\u000f\u0003\u0004\u0002j\u0012\u0002\r!Z\u0001\u000b]Vl'+Z2pe\u0012\u001c\b\"\u00027%\u0001\u0004q\u0017a\u0006;fgRLeN^1mS\u0012\fE\u000e^3s\u0007>tg-[4tQ\r)\u0013qL\u0001\u0012i\u0016\u001cH/Q2m\u001fB,'/\u0019;j_:\u001c\bf\u0001\u0014\u0002`\u0005\u0001B/Z:u\t\u0016d\u0017-_3e\u00072|7/\u001a\u0015\u0004O\u0005}\u0013A\u0004;fgR4uN]2f\u00072|7/\u001a\u0015\u0004Q\u0005}\u0013A\u0007;fgRl\u0015N\\5nk6\u0014V-];fgR$\u0016.\\3pkR\u001c\bfA\u0015\u0002`\u0005AB/Z:u\u0007\u0006dG.\u00138GY&<\u0007\u000e\u001e+j[\u0016|W\u000f^:)\u0007)\ny&\u0001\nuKN$8i\u001c8tk6,'o\u0012:pkB\u001c\bfA\u0016\u0002`\u0005qB/Z:u\t\u0016dW\r^3D_:\u001cX/\\3s\u000fJ|W\u000f](gMN,Go\u001d\u0015\u0004Y\u0005}\u0013!\u0007;fgR,E.Z2u!J,g-\u001a:sK\u0012dU-\u00193feND3!LA0\u0003\u0019\"Xm\u001d;FY\u0016\u001cG/\u00168dY\u0016\fg\u000eT3bI\u0016\u00148OR8s\u001f:,\u0007+\u0019:uSRLwN\u001c\u0015\u0004]\u0005}\u0013\u0001\u000b;fgR,E.Z2u+:\u001cG.Z1o\u0019\u0016\fG-\u001a:t\r>\u0014X*\u00198z!\u0006\u0014H/\u001b;j_:\u001c\bfA\u0018\u0002`\u00059C/Z:u\u000b2,7\r^+oG2,\u0017M\u001c'fC\u0012,'o\u001d$pe\u0006cG\u000eU1si&$\u0018n\u001c8tQ\r\u0001\u0014qL\u0001,i\u0016\u001cH/\u00127fGR,fn\u00197fC:dU-\u00193feN4uN]+oW:|wO\u001c)beRLG/[8og\"\u001a\u0011'a\u0018\u0002QQ,7\u000f^#mK\u000e$XK\\2mK\u0006tG*Z1eKJ\u001cx\u000b[3o\u001d>d\u0015N^3Ce>\\WM]:)\u0007I\ny&A\u000euKN$X\t\\3diVs7\r\\3b]2+\u0017\rZ3sg:{w\u000e\u001d\u0015\u0004g\u0005}\u0013A\b;fgR,E.Z2u+:\u001cG.Z1o\u0019\u0016\fG-\u001a:t\u0003:$gj\\8qQ\r!\u0014qL\u00019i\u0016\u001cH\u000fT5tiJ+\u0017m]:jO:lWM\u001c;t\t>,7OT8u'\"|wOT8o%\u0016\f7o]5h]&tw\rU1si&$\u0018n\u001c8tQ\r)\u0014qL\u00012i\u0016\u001cH\u000fT5tiJ+\u0017m]:jO:lWM\u001c;t\t>,7OT8u'\"|w\u000fR3mKR,G\rU1si&$\u0018n\u001c8tQ\r1\u0014qL\u0001!i\u0016\u001cHOV1mS\u0012Len\u0019:f[\u0016tG/\u00197BYR,'oQ8oM&<7\u000fK\u00028\u0003?\n!\u0005^3ti&sg/\u00197jI&s7M]3nK:$\u0018\r\\!mi\u0016\u00148i\u001c8gS\u001e\u001c\bf\u0001\u001d\u0002`\u00051C/Z:u\u0013:4\u0018\r\\5e\u00032$XM\u001d)beRLG/[8o%\u0016\f7o]5h]6,g\u000e^:)\u0007e\ny&\u0001\nuKN$Hj\u001c8h)>\u0004\u0018n\u0019(b[\u0016\u001c\bf\u0001\u001e\u0002`\u0005!C/Z:u\t\u0016\u001c8M]5cK\u000e{gNZ5hg\u001a{'\u000fT8hi)dun\u001a'fm\u0016d7\u000fK\u0002<\u0003?\nA\u0006^3ti&s7M]3nK:$\u0018\r\\!mi\u0016\u00148i\u001c8gS\u001e\u001chi\u001c:M_\u001e$$\u000eT8h\u0019\u00164X\r\\:)\u0007q\u0012i\u0005\u0005\u0003\u0002H\t=\u0013\u0002\u0002B)\u0003\u0013\u0012a!S4o_J,\u0007f\u0001\u001f\u0002`\u00059E/Z:u\u0013:\u001c'/Z7f]R\fG.\u00117uKJ\u001cuN\u001c4jON4uN\u001d'pORRGj\\4MKZ,Gn]\"b]J+7/\u001a;M_\u001e<WM\u001d+p\u0007V\u0014(/\u001a8u%>|G\u000fK\u0002>\u0005\u001bB3!PA0\u0003\u0005#Xm\u001d;J]\u000e\u0014X-\\3oi\u0006d\u0017\t\u001c;fe\u000e{gNZ5hg\u001a{'\u000fT8hi)dun\u001a'fm\u0016d7oQ1o]>$(+Z:fiJ{w\u000e\u001e'pO\u001e,'\u000fK\u0002?\u0005\u001bB3APA0\u0003%#Xm\u001d;J]\u000e\u0014X-\\3oi\u0006d\u0017\t\u001c;fe\u000e{gNZ5hg\u001a{'\u000fT8hi)dun\u001a'fm\u0016d7\u000fR8fg:{GoV8sW^KG\u000f[%om\u0006d\u0017\u000eZ\"p]\u001aLwm\u001d\u0015\u0004\u007f\t5\u0003fA \u0002`\u0005aC/Z:u\u00032$XM]\"p]\u001aLwm\u001d$pe2{w\r\u000e6M_\u001edUM^3mg\u0012{Wm\u001d(pi^{'o\u001b\u0015\u0004\u0001\n5\u0003f\u0001!\u0002`\u0005\u0011\u0012\r\u001c;fe\n\u0013xn[3s\u0019><w-\u001a:t)\u0019\tIA!\u001d\u0003\u000e\"9!1O!A\u0002\tU\u0014aB3oiJLWm\u001d\t\u0007\u0005o\u0012iH!!\u000e\u0005\te$b\u0001B>=\u0006!Q\u000f^5m\u0013\u0011\u0011yH!\u001f\u0003\u0015\r{G\u000e\\3di&|g\u000e\u0005\u0003\u0003\u0004\n%UB\u0001BC\u0015\u0011\u00119)!1\u0002\u000b\u0005$W.\u001b8\n\t\t-%Q\u0011\u0002\u000e\u00032$XM]\"p]\u001aLwm\u00149\t\u0013\t=\u0015\t%AA\u0002\tE\u0015\u0001\u0004<bY&$\u0017\r^3P]2L\bc\u00014\u0003\u0014&\u0019!QS4\u0003\u000f\t{w\u000e\\3b]\u0006a\u0012\r\u001c;fe\n\u0013xn[3s\u0019><w-\u001a:tI\u0011,g-Y;mi\u0012\u0012TC\u0001BNU\u0011\u0011\tJ!(,\u0005\t}\u0005\u0003\u0002BQ\u0005Wk!Aa)\u000b\t\t\u0015&qU\u0001\nk:\u001c\u0007.Z2lK\u0012T1A!+h\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0005[\u0013\u0019KA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fQ\u0003Z3tGJL'-\u001a\"s_.,'\u000fT8hO\u0016\u00148\u000f\u0006\u0002\u00034B!!1\u0011B[\u0013\u0011\u00119L!\"\u0003\r\r{gNZ5h\u0003U!X-\u0019:e_^t'I]8lKJdunZ4feN\fQ\u0004\u00157bS:$X\r\u001f;BI6Lg.\u00138uK\u001e\u0014\u0018\r^5p]R+7\u000f\u001e\t\u0003%\u001a\u001b2A\u0012Ba!\r1'1Y\u0005\u0004\u0005\u000b<'AB!osJ+g\r\u0006\u0002\u0003>\u000612\r[3dWZ\u000bG.\u001b3BYR,'oQ8oM&<7\u000f\u0006\u0005\u0002\n\t5'q\u001bBn\u0011\u001d\u0011y\r\u0013a\u0001\u0005#\faa\u00197jK:$\b\u0003\u0002BB\u0005'LAA!6\u0003\u0006\n)\u0011\tZ7j]\"1!\u0011\u001c%A\u0002q\fa\u0002^8qS\u000e\u0014Vm]8ve\u000e,\u0017\u0007\u0003\u0004\u0003^\"\u0003\r\u0001`\u0001\u000fi>\u0004\u0018n\u0019*fg>,(oY33\u0003a\u0019\u0007.Z2l\u0013:4\u0018\r\\5e\u00032$XM]\"p]\u001aLwm\u001d\u000b\t\u0003\u0013\u0011\u0019Oa=\u0004\f!9!Q]%A\u0002\t\u001d\u0018\u0001\u0003>l\u00072LWM\u001c;\u0011\t\t%(q^\u0007\u0003\u0005WT1A!<N\u0003\tQ8.\u0003\u0003\u0003r\n-(!D&bM.\f'l[\"mS\u0016tG\u000fC\u0004\u0003v&\u0003\rAa>\u0002\u000fM,'O^3sgB1!\u0011 B~\u0005\u007fl!!!\t\n\t\tu\u0018\u0011\u0005\u0002\u0004'\u0016\f\b\u0003BB\u0001\u0007\u000fi!aa\u0001\u000b\u0007\r\u0015Q*\u0001\u0004tKJ4XM]\u0005\u0005\u0007\u0013\u0019\u0019AA\u0006LC\u001a\\\u0017mU3sm\u0016\u0014\bb\u0002Bh\u0013\u0002\u0007!\u0011\u001b")
public class PlaintextAdminIntegrationTest
extends BaseAdminIntegrationTest {
    private final String topic;
    private final int partition;
    private final TopicPartition topicPartition = new TopicPartition(this.topic(), this.partition());
    private ConfigResource brokerLoggerConfigResource;
    private final Set<String> changedBrokerLoggers = (Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);

    public static void checkInvalidAlterConfigs(KafkaZkClient kafkaZkClient, Seq<KafkaServer> seq, Admin admin) {
        PlaintextAdminIntegrationTest$.MODULE$.checkInvalidAlterConfigs(kafkaZkClient, seq, admin);
    }

    public static void checkValidAlterConfigs(Admin admin, ConfigResource configResource, ConfigResource configResource2) {
        PlaintextAdminIntegrationTest$.MODULE$.checkValidAlterConfigs(admin, configResource, configResource2);
    }

    public String topic() {
        return this.topic;
    }

    public int partition() {
        return this.partition;
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    private ConfigResource brokerLoggerConfigResource() {
        return this.brokerLoggerConfigResource;
    }

    private void brokerLoggerConfigResource_$eq(ConfigResource x$1) {
        this.brokerLoggerConfigResource = x$1;
    }

    private Set<String> changedBrokerLoggers() {
        return this.changedBrokerLoggers;
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.brokerLoggerConfigResource_$eq(new ConfigResource(ConfigResource.Type.BROKER_LOGGER, ((Object)BoxesRunTime.boxToInteger((int)((KafkaServer)this.servers().head()).config().brokerId())).toString()));
    }

    @Override
    @After
    public void tearDown() {
        this.teardownBrokerLoggers();
        super.tearDown();
    }

    @Test
    public void testClose() {
        Admin client = Admin.create(this.createConfig());
        client.close();
        client.close();
    }

    @Test
    public void testListNodes() {
        List nodeStrs;
        this.client_$eq(Admin.create(this.createConfig()));
        List brokerStrs = (List)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.brokerList().split(","))).toList().sorted((Ordering)Ordering.String$.MODULE$);
        while ((nodeStrs = (List)((TraversableOnce)((Iterable)JavaConverters$.MODULE$.collectionAsScalaIterableConverter((Collection)this.client().describeCluster().nodes().get()).asScala()).map((Function1 & Serializable & scala.Serializable)node -> new StringBuilder(1).append(node.host()).append(":").append(node.port()).toString(), scala.collection.Iterable$.MODULE$.canBuildFrom())).toList().sorted((Ordering)Ordering.String$.MODULE$)).size() < brokerStrs.size()) {
        }
        Assert.assertEquals((Object)brokerStrs.mkString(","), (Object)nodeStrs.mkString(","));
    }

    @Test
    public void testCreateExistingTopicsThrowTopicExistsException() {
        this.client_$eq(Admin.create(this.createConfig()));
        String topic = "mytopic";
        Seq topics = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic}));
        Seq newTopics = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NewTopic[]{new NewTopic(topic, 1, (short)1)}));
        this.client().createTopics((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(newTopics).asJava()).all().get();
        this.waitForTopics(this.client(), (Seq<String>)topics, (Seq<String>)Nil$.MODULE$);
        Seq newTopicsWithInvalidRF = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NewTopic[]{new NewTopic(topic, 1, (short)(this.servers().size() + 1))}));
        Assert.assertTrue((boolean)(((ExecutionException)Assertions$.MODULE$.intercept((Function0 & Serializable & scala.Serializable)() -> (Void)this.client().createTopics((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(newTopicsWithInvalidRF).asJava(), new CreateTopicsOptions().validateOnly(true)).all().get(), ClassTag$.MODULE$.apply(ExecutionException.class), new Position("PlaintextAdminIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 112))).getCause() instanceof TopicExistsException));
    }

    @Test
    public void testMetadataRefresh() {
        this.client_$eq(Admin.create(this.createConfig()));
        Seq topics = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"mytopic"}));
        Seq newTopics = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NewTopic[]{new NewTopic("mytopic", 3, (short)3)}));
        this.client().createTopics((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(newTopics).asJava()).all().get();
        this.waitForTopics(this.client(), (Seq<String>)topics, (Seq<String>)Nil$.MODULE$);
        KafkaServer controller = (KafkaServer)this.servers().find((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)PlaintextAdminIntegrationTest.$anonfun$testMetadataRefresh$1(this, x$1))).get();
        controller.shutdown();
        controller.awaitShutdown();
        java.util.Map topicDesc = (java.util.Map)this.client().describeTopics((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(topics).asJava()).all().get();
        Assert.assertEquals((Object)topics.toSet(), (Object)JavaConverters$.MODULE$.asScalaSetConverter(topicDesc.keySet()).asScala());
    }

    @Test
    public void testDescribeNonExistingTopic() {
        this.client_$eq(Admin.create(this.createConfig()));
        String existingTopic = "existing-topic";
        this.client().createTopics((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{existingTopic}))).map((Function1 & Serializable & scala.Serializable)x$2 -> new NewTopic(x$2, 1, (short)1), Seq$.MODULE$.canBuildFrom())).asJava()).all().get();
        this.waitForTopics(this.client(), (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{existingTopic}))), (Seq<String>)Nil$.MODULE$);
        String nonExistingTopic = "non-existing";
        java.util.Map results = this.client().describeTopics((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{nonExistingTopic, existingTopic}))).asJava()).values();
        Assert.assertEquals((Object)existingTopic, (Object)((TopicDescription)((KafkaFuture)results.get(existingTopic)).get()).name());
        boolean cfr_ignored_0 = ((Throwable)Assertions$.MODULE$.intercept((Function0 & Serializable & scala.Serializable)() -> (TopicDescription)((KafkaFuture)results.get(nonExistingTopic)).get(), ClassTag$.MODULE$.apply(ExecutionException.class), new Position("PlaintextAdminIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 147))).getCause() instanceof UnknownTopicOrPartitionException;
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.zkClient().getTopicPartitionCount(nonExistingTopic));
    }

    @Test
    public void testDescribeCluster() {
        this.client_$eq(Admin.create(this.createConfig()));
        DescribeClusterResult result = this.client().describeCluster();
        Collection nodes = (Collection)result.nodes().get();
        String clusterId = (String)result.clusterId().get();
        Assert.assertEquals((Object)((KafkaServer)this.servers().head()).dataPlaneRequestProcessor().clusterId(), (Object)clusterId);
        Node controller = (Node)result.controller().get();
        Option option = ((KafkaServer)this.servers().head()).dataPlaneRequestProcessor().metadataCache().getControllerId();
        if (option == null) {
            throw null;
        }
        Option getOrElse_this = option;
        Object object = getOrElse_this.isEmpty() ? BoxesRunTime.boxToInteger((int)PlaintextAdminIntegrationTest.$anonfun$testDescribeCluster$1()) : getOrElse_this.get();
        Assert.assertEquals((long)BoxesRunTime.unboxToInt((Object)object), (long)controller.id());
        String[] brokers = this.brokerList().split(",");
        Assert.assertEquals((long)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])brokers)).size(), (long)nodes.size());
        ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(nodes).asScala()).foreach((Function1 & Serializable & scala.Serializable)node -> {
            PlaintextAdminIntegrationTest.$anonfun$testDescribeCluster$2(brokers, node);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testDescribeLogDirs() {
        this.client_$eq(Admin.create(this.createConfig()));
        String topic = "topic";
        scala.collection.immutable.Map partitionsByBroker = this.createTopic(topic, 10, 1, this.createTopic$default$4()).groupBy((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToInteger((int)PlaintextAdminIntegrationTest.$anonfun$testDescribeLogDirs$1(x0$1))).mapValues((Function1 & Serializable & scala.Serializable)x$3 -> x$3.keys().toSeq());
        int n = 0;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        IndexedSeq brokers = (IndexedSeq)RichInt$.MODULE$.until$extension0(n, this.brokerCount()).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1), IndexedSeq$.MODULE$.canBuildFrom());
        java.util.Map logDirInfosByBroker = (java.util.Map)this.client().describeLogDirs((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)brokers).asJava()).all().get();
        int n2 = 0;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        Range range = RichInt$.MODULE$.until$extension0(n2, this.brokerCount());
        if (range == null) {
            throw null;
        }
        Range foreach$mVc$sp_this = range;
        if (!foreach$mVc$sp_this.isEmpty()) {
            int foreach$mVc$sp_i = foreach$mVc$sp_this.start();
            while (true) {
                PlaintextAdminIntegrationTest.$anonfun$testDescribeLogDirs$4(this, partitionsByBroker, logDirInfosByBroker, topic, foreach$mVc$sp_i);
                if (foreach$mVc$sp_i == foreach$mVc$sp_this.scala$collection$immutable$Range$$lastElement()) break;
                foreach$mVc$sp_i += foreach$mVc$sp_this.step();
            }
        }
    }

    @Test
    public void testDescribeReplicaLogDirs() {
        this.client_$eq(Admin.create(this.createConfig()));
        String topic = "topic";
        Seq replicas = ((TraversableOnce)this.createTopic(topic, 10, 1, this.createTopic$default$4()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            int partition = x0$1._1$mcI$sp();
            int brokerId = x0$1._2$mcI$sp();
            TopicPartitionReplica topicPartitionReplica = new TopicPartitionReplica(topic, partition, brokerId);
            return topicPartitionReplica;
        }, Iterable$.MODULE$.canBuildFrom())).toSeq();
        java.util.Map replicaDirInfos = (java.util.Map)this.client().describeReplicaLogDirs(JavaConverters$.MODULE$.asJavaCollectionConverter((Iterable)replicas).asJavaCollection()).all().get();
        ((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(replicaDirInfos).asScala()).foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
            PlaintextAdminIntegrationTest.$anonfun$testDescribeReplicaLogDirs$2(this, x0$2);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testAlterReplicaLogDirs() {
        void apply_executor;
        void apply_body;
        this.client_$eq(Admin.create(this.createConfig()));
        String topic = "topic";
        TopicPartition tp = new TopicPartition(topic, 0);
        scala.collection.immutable.Map randomNums = ((TraversableOnce)this.servers().map((Function1 & Serializable & scala.Serializable)server -> {
            void $minus$greater$extension_y;
            void $minus$greater$extension_$this;
            Integer n = BoxesRunTime.boxToInteger((int)Random$.MODULE$.nextInt(2));
            Object object = Predef$.MODULE$.ArrowAssoc(server);
            if (Predef.ArrowAssoc$.MODULE$ == null) {
                throw null;
            }
            return new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        }, Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        scala.collection.immutable.Map firstReplicaAssignment = ((TraversableOnce)this.servers().map((Function1 & Serializable & scala.Serializable)server -> {
            void $minus$greater$extension_$this;
            String logDir = new File((String)server.config().logDirs().apply(BoxesRunTime.unboxToInt((Object)randomNums.apply(server)))).getAbsolutePath();
            Object object = Predef$.MODULE$.ArrowAssoc((Object)new TopicPartitionReplica(topic, 0, server.config().brokerId()));
            if (Predef.ArrowAssoc$.MODULE$ == null) {
                throw null;
            }
            return new Tuple2((Object)$minus$greater$extension_$this, (Object)logDir);
        }, Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        scala.collection.immutable.Map secondReplicaAssignment = ((TraversableOnce)this.servers().map((Function1 & Serializable & scala.Serializable)server -> {
            void $minus$greater$extension_$this;
            String logDir = new File((String)server.config().logDirs().apply(1 - BoxesRunTime.unboxToInt((Object)randomNums.apply(server)))).getAbsolutePath();
            Object object = Predef$.MODULE$.ArrowAssoc((Object)new TopicPartitionReplica(topic, 0, server.config().brokerId()));
            if (Predef.ArrowAssoc$.MODULE$ == null) {
                throw null;
            }
            return new Tuple2((Object)$minus$greater$extension_$this, (Object)logDir);
        }, Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        ((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(this.client().alterReplicaLogDirs((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)firstReplicaAssignment).asJava(), new AlterReplicaLogDirsOptions()).values()).asScala()).values().foreach((Function1 & Serializable & scala.Serializable)future -> {
            PlaintextAdminIntegrationTest.$anonfun$testAlterReplicaLogDirs$4(future);
            return BoxedUnit.UNIT;
        });
        this.createTopic(topic, 1, this.brokerCount(), this.createTopic$default$4());
        this.servers().foreach((Function1 & Serializable & scala.Serializable)server -> {
            PlaintextAdminIntegrationTest.$anonfun$testAlterReplicaLogDirs$6(tp, firstReplicaAssignment, topic, server);
            return BoxedUnit.UNIT;
        });
        this.client().alterReplicaLogDirs((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)secondReplicaAssignment).asJava(), new AlterReplicaLogDirsOptions()).all().get();
        this.servers().foreach((Function1 & Serializable & scala.Serializable)server -> {
            PlaintextAdminIntegrationTest.$anonfun$testAlterReplicaLogDirs$7(tp, secondReplicaAssignment, topic, server);
            return BoxedUnit.UNIT;
        });
        AtomicBoolean running = new AtomicBoolean(true);
        AtomicInteger numMessages = new AtomicInteger();
        Future$ future$ = Future$.MODULE$;
        ExecutionContext executionContext = ExecutionContext.Implicits$.MODULE$.global();
        JFunction0.mcI.sp & Serializable & scala.Serializable intersect = (JFunction0.mcI.sp & Serializable & scala.Serializable)() -> {
            int n;
            String x$5 = TestUtils$.MODULE$.getBrokerListStrFromServers((Seq<KafkaServer>)this.servers(), this.securityProtocol());
            SecurityProtocol x$6 = this.securityProtocol();
            Option<File> x$7 = this.trustStoreFile();
            int x$8 = 0;
            int x$9 = 10000;
            int x$10 = -1;
            long x$11 = TestUtils$.MODULE$.createProducer$default$3();
            long x$12 = TestUtils$.MODULE$.createProducer$default$4();
            int x$13 = TestUtils$.MODULE$.createProducer$default$6();
            int x$14 = TestUtils$.MODULE$.createProducer$default$7();
            int x$15 = TestUtils$.MODULE$.createProducer$default$8();
            String x$16 = TestUtils$.MODULE$.createProducer$default$9();
            Option<Properties> x$17 = TestUtils$.MODULE$.createProducer$default$13();
            ByteArraySerializer x$18 = TestUtils$.MODULE$.createProducer$default$14();
            ByteArraySerializer x$19 = TestUtils$.MODULE$.createProducer$default$15();
            boolean x$20 = TestUtils$.MODULE$.createProducer$default$16();
            try (KafkaProducer producer = TestUtils$.MODULE$.createProducer(x$5, x$10, x$11, x$12, x$8, x$13, x$14, x$15, x$16, x$9, x$6, x$7, x$17, x$18, x$19, x$20);){
                while (running.get()) {
                    Future future = producer.send(new ProducerRecord(topic, (Object)new StringBuilder(21).append("xxxxxxxxxxxxxxxxxxxx-").append(numMessages).toString().getBytes()));
                    numMessages.incrementAndGet();
                    future.get(10L, TimeUnit.SECONDS);
                }
                n = numMessages.get();
            }
            return n;
        };
        if (future$ == null) {
            throw null;
        }
        scala.concurrent.Future future2 = future$.unit().map(arg_0 -> Future$.$anonfun$apply$1((Function0)apply_body, arg_0), (ExecutionContext)apply_executor);
        try {
            long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
            long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
            if (TestUtils$.MODULE$ == null) {
                throw null;
            }
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!PlaintextAdminIntegrationTest.$anonfun$testAlterReplicaLogDirs$11(numMessages)) {
                void waitUntilTrue_pause;
                void waitUntilTrue_waitTimeMs;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    throw Assertions$.MODULE$.fail(PlaintextAdminIntegrationTest.$anonfun$testAlterReplicaLogDirs$12(numMessages, future2), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 845));
                }
                if (Predef$.MODULE$ == null) {
                    throw null;
                }
                Thread.sleep(RichLong$.MODULE$.min$extension((long)waitUntilTrue_waitTimeMs, (long)waitUntilTrue_pause));
            }
            this.client().alterReplicaLogDirs((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)firstReplicaAssignment).asJava(), new AlterReplicaLogDirsOptions()).all().get();
            this.servers().foreach((Function1 & Serializable & scala.Serializable)server -> {
                PlaintextAdminIntegrationTest.$anonfun$testAlterReplicaLogDirs$13(tp, firstReplicaAssignment, topic, future2, server);
                return BoxedUnit.UNIT;
            });
            int currentMessagesNum = numMessages.get();
            long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
            long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
            if (TestUtils$.MODULE$ == null) {
                throw null;
            }
            long waitUntilTrue_startTime2 = System.currentTimeMillis();
            while (!PlaintextAdminIntegrationTest.$anonfun$testAlterReplicaLogDirs$16(numMessages, currentMessagesNum)) {
                void waitUntilTrue_pause;
                void waitUntilTrue_waitTimeMs;
                if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                    throw Assertions$.MODULE$.fail(PlaintextAdminIntegrationTest.$anonfun$testAlterReplicaLogDirs$17(numMessages, currentMessagesNum, future2), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 845));
                }
                if (Predef$.MODULE$ == null) {
                    throw null;
                }
                Thread.sleep(RichLong$.MODULE$.min$extension((long)waitUntilTrue_waitTimeMs, (long)waitUntilTrue_pause));
            }
        }
        finally {
            running.set(false);
        }
        int finalNumMessages = BoxesRunTime.unboxToInt((Object)Await$.MODULE$.result((Awaitable)future2, (Duration)Duration$.MODULE$.apply(20L, TimeUnit.SECONDS)));
        Buffer<KafkaServer> x$23 = this.servers();
        SecurityProtocol x$26 = this.securityProtocol();
        Option<File> x$27 = this.trustStoreFile();
        String x$28 = TestUtils$.MODULE$.consumeTopicRecords$default$4();
        long x$29 = TestUtils$.MODULE$.consumeTopicRecords$default$7();
        ((IterableLike)TestUtils$.MODULE$.consumeTopicRecords((Seq<KafkaServer>)x$23, topic, finalNumMessages, x$28, x$26, x$27, x$29).zipWithIndex(Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            PlaintextAdminIntegrationTest.$anonfun$testAlterReplicaLogDirs$18(x0$1);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testDescribeAndAlterConfigs() {
        this.client_$eq(Admin.create(this.createConfig()));
        String topic1 = "describe-alter-configs-topic-1";
        ConfigResource topicResource1 = new ConfigResource(ConfigResource.Type.TOPIC, topic1);
        Properties topicConfig1 = new Properties();
        topicConfig1.setProperty(LogConfig$.MODULE$.MaxMessageBytesProp(), "500000");
        topicConfig1.setProperty(LogConfig$.MODULE$.RetentionMsProp(), "60000000");
        this.createTopic(topic1, 1, 1, topicConfig1);
        String topic2 = "describe-alter-configs-topic-2";
        ConfigResource topicResource2 = new ConfigResource(ConfigResource.Type.TOPIC, topic2);
        this.createTopic(topic2, 1, 1, this.createTopic$default$4());
        ConfigResource brokerResource1 = new ConfigResource(ConfigResource.Type.BROKER, ((Object)BoxesRunTime.boxToInteger((int)((KafkaServer)this.servers().apply(1)).config().brokerId())).toString());
        ConfigResource brokerResource2 = new ConfigResource(ConfigResource.Type.BROKER, ((Object)BoxesRunTime.boxToInteger((int)((KafkaServer)this.servers().apply(2)).config().brokerId())).toString());
        Seq configResources = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ConfigResource[]{topicResource1, topicResource2, brokerResource1, brokerResource2}));
        java.util.Map configs = (java.util.Map)this.client().describeConfigs((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(configResources).asJava()).all().get();
        Assert.assertEquals((long)4L, (long)configs.size());
        ConfigEntry maxMessageBytes1 = ((Config)configs.get(topicResource1)).get(LogConfig$.MODULE$.MaxMessageBytesProp());
        Assert.assertEquals((Object)LogConfig$.MODULE$.MaxMessageBytesProp(), (Object)maxMessageBytes1.name());
        Assert.assertEquals((Object)topicConfig1.get(LogConfig$.MODULE$.MaxMessageBytesProp()), (Object)maxMessageBytes1.value());
        Assert.assertFalse((boolean)maxMessageBytes1.isDefault());
        Assert.assertFalse((boolean)maxMessageBytes1.isSensitive());
        Assert.assertFalse((boolean)maxMessageBytes1.isReadOnly());
        Assert.assertEquals((Object)topicConfig1.get(LogConfig$.MODULE$.RetentionMsProp()), (Object)((Config)configs.get(topicResource1)).get(LogConfig$.MODULE$.RetentionMsProp()).value());
        ConfigEntry maxMessageBytes2 = ((Config)configs.get(topicResource2)).get(LogConfig$.MODULE$.MaxMessageBytesProp());
        Assert.assertEquals((Object)((Object)BoxesRunTime.boxToInteger((int)Defaults$.MODULE$.MessageMaxBytes())).toString(), (Object)maxMessageBytes2.value());
        Assert.assertEquals((Object)LogConfig$.MODULE$.MaxMessageBytesProp(), (Object)maxMessageBytes2.name());
        Assert.assertTrue((boolean)maxMessageBytes2.isDefault());
        Assert.assertFalse((boolean)maxMessageBytes2.isSensitive());
        Assert.assertFalse((boolean)maxMessageBytes2.isReadOnly());
        Assert.assertEquals((long)((KafkaServer)this.servers().apply(1)).config().values().size(), (long)((Config)configs.get(brokerResource1)).entries().size());
        Assert.assertEquals((Object)((Object)BoxesRunTime.boxToInteger((int)((KafkaServer)this.servers().apply(1)).config().brokerId())).toString(), (Object)((Config)configs.get(brokerResource1)).get(KafkaConfig$.MODULE$.BrokerIdProp()).value());
        ConfigEntry listenerSecurityProtocolMap = ((Config)configs.get(brokerResource1)).get(KafkaConfig$.MODULE$.ListenerSecurityProtocolMapProp());
        Assert.assertEquals((Object)((KafkaServer)this.servers().apply(1)).config().getString(KafkaConfig$.MODULE$.ListenerSecurityProtocolMapProp()), (Object)listenerSecurityProtocolMap.value());
        Assert.assertEquals((Object)KafkaConfig$.MODULE$.ListenerSecurityProtocolMapProp(), (Object)listenerSecurityProtocolMap.name());
        Assert.assertFalse((boolean)listenerSecurityProtocolMap.isDefault());
        Assert.assertFalse((boolean)listenerSecurityProtocolMap.isSensitive());
        Assert.assertFalse((boolean)listenerSecurityProtocolMap.isReadOnly());
        ConfigEntry truststorePassword = ((Config)configs.get(brokerResource1)).get(KafkaConfig$.MODULE$.SslTruststorePasswordProp());
        Assert.assertEquals((Object)KafkaConfig$.MODULE$.SslTruststorePasswordProp(), (Object)truststorePassword.name());
        Assert.assertNull((Object)truststorePassword.value());
        Assert.assertFalse((boolean)truststorePassword.isDefault());
        Assert.assertTrue((boolean)truststorePassword.isSensitive());
        Assert.assertFalse((boolean)truststorePassword.isReadOnly());
        ConfigEntry compressionType = ((Config)configs.get(brokerResource1)).get(KafkaConfig$.MODULE$.CompressionTypeProp());
        Assert.assertEquals((Object)((KafkaServer)this.servers().apply(1)).config().compressionType(), (Object)compressionType.value());
        Assert.assertEquals((Object)KafkaConfig$.MODULE$.CompressionTypeProp(), (Object)compressionType.name());
        Assert.assertTrue((boolean)compressionType.isDefault());
        Assert.assertFalse((boolean)compressionType.isSensitive());
        Assert.assertFalse((boolean)compressionType.isReadOnly());
        Assert.assertEquals((long)((KafkaServer)this.servers().apply(2)).config().values().size(), (long)((Config)configs.get(brokerResource2)).entries().size());
        Assert.assertEquals((Object)((Object)BoxesRunTime.boxToInteger((int)((KafkaServer)this.servers().apply(2)).config().brokerId())).toString(), (Object)((Config)configs.get(brokerResource2)).get(KafkaConfig$.MODULE$.BrokerIdProp()).value());
        Assert.assertEquals((Object)((KafkaServer)this.servers().apply(2)).config().logCleanerThreads().toString(), (Object)((Config)configs.get(brokerResource2)).get(KafkaConfig$.MODULE$.LogCleanerThreadsProp()).value());
        PlaintextAdminIntegrationTest$.MODULE$.checkValidAlterConfigs(this.client(), topicResource1, topicResource2);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCreatePartitions() {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        void $minus$greater$extension_y2;
        void $minus$greater$extension_$this2;
        void $minus$greater$extension_y3;
        void $minus$greater$extension_$this3;
        void $minus$greater$extension_y4;
        void $minus$greater$extension_$this4;
        void $minus$greater$extension_y5;
        void $minus$greater$extension_$this5;
        void $minus$greater$extension_y6;
        void $minus$greater$extension_$this6;
        void $minus$greater$extension_y7;
        void $minus$greater$extension_$this7;
        this.client_$eq(Admin.create(this.createConfig()));
        String topic1 = "create-partitions-topic-1";
        this.createTopic(topic1, 1, 1, this.createTopic$default$4());
        String topic2 = "create-partitions-topic-2";
        this.createTopic(topic2, 1, 2, this.createTopic$default$4());
        TopicDescription topic1_metadata = this.getTopicMetadata(this.client(), topic1, this.getTopicMetadata$default$3(), this.getTopicMetadata$default$4());
        TopicDescription topic2_metadata = this.getTopicMetadata(this.client(), topic2, this.getTopicMetadata$default$3(), this.getTopicMetadata$default$4());
        Assert.assertEquals((long)1L, (long)topic1_metadata.partitions().size());
        Assert.assertEquals((long)1L, (long)topic2_metadata.partitions().size());
        CreatePartitionsOptions validateOnly = new CreatePartitionsOptions().validateOnly(true);
        CreatePartitionsOptions actuallyDoIt = new CreatePartitionsOptions().validateOnly(false);
        Tuple2[] tuple2Array = new Tuple2[1];
        NewPartitions newPartitions = NewPartitions.increaseTo((int)3);
        Object object = Predef$.MODULE$.ArrowAssoc((Object)topic1);
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this7, (Object)$minus$greater$extension_y7);
        ObjectRef alterResult = ObjectRef.create((Object)this.client().createPartitions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array))).asJava(), validateOnly));
        ObjectRef altered = ObjectRef.create((Object)((Void)((KafkaFuture)((CreatePartitionsResult)alterResult.elem).values().get(topic1)).get()));
        Assert.assertEquals((long)1L, (long)this.numPartitions$1(topic1, PlaintextAdminIntegrationTest.numPartitions$default$2$1()));
        Tuple2[] tuple2Array2 = new Tuple2[1];
        NewPartitions newPartitions2 = NewPartitions.increaseTo((int)3);
        Object object2 = Predef$.MODULE$.ArrowAssoc((Object)topic1);
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array2[0] = new Tuple2((Object)$minus$greater$extension_$this6, (Object)$minus$greater$extension_y6);
        alterResult.elem = this.client().createPartitions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array2))).asJava(), actuallyDoIt);
        altered.elem = (Void)((KafkaFuture)((CreatePartitionsResult)alterResult.elem).values().get(topic1)).get();
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!PlaintextAdminIntegrationTest.$anonfun$testCreatePartitions$1(this, topic1)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                throw Assertions$.MODULE$.fail(PlaintextAdminIntegrationTest.$anonfun$testCreatePartitions$2(), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 845));
            }
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension((long)waitUntilTrue_waitTimeMs, (long)waitUntilTrue_pause));
        }
        java.util.List<Object> newPartition2Assignments = Arrays.asList((Object[])new java.util.List[]{Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1)}), Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2)})});
        Tuple2[] tuple2Array3 = new Tuple2[1];
        NewPartitions newPartitions3 = NewPartitions.increaseTo((int)3, newPartition2Assignments);
        Object object3 = Predef$.MODULE$.ArrowAssoc((Object)topic2);
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array3[0] = new Tuple2((Object)$minus$greater$extension_$this5, (Object)$minus$greater$extension_y5);
        alterResult.elem = this.client().createPartitions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array3))).asJava(), validateOnly);
        altered.elem = (Void)((KafkaFuture)((CreatePartitionsResult)alterResult.elem).values().get(topic2)).get();
        Assert.assertEquals((long)1L, (long)this.numPartitions$1(topic2, PlaintextAdminIntegrationTest.numPartitions$default$2$1()));
        Tuple2[] tuple2Array4 = new Tuple2[1];
        NewPartitions newPartitions4 = NewPartitions.increaseTo((int)3, newPartition2Assignments);
        Object object4 = Predef$.MODULE$.ArrowAssoc((Object)topic2);
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array4[0] = new Tuple2((Object)$minus$greater$extension_$this4, (Object)$minus$greater$extension_y4);
        alterResult.elem = this.client().createPartitions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array4))).asJava(), actuallyDoIt);
        altered.elem = (Void)((KafkaFuture)((CreatePartitionsResult)alterResult.elem).values().get(topic2)).get();
        java.util.List actualPartitions2 = this.partitions$1(topic2, (Option)new Some((Object)BoxesRunTime.boxToInteger((int)3)));
        Assert.assertEquals((long)3L, (long)actualPartitions2.size());
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1})), (Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(((TopicPartitionInfo)actualPartitions2.get(1)).replicas()).asScala()).map((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToInteger((int)x$8.id()), Buffer$.MODULE$.canBuildFrom())).toList());
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})), (Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(((TopicPartitionInfo)actualPartitions2.get(2)).replicas()).asScala()).map((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToInteger((int)x$9.id()), Buffer$.MODULE$.canBuildFrom())).toList());
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CreatePartitionsOptions[]{validateOnly, actuallyDoIt}))).foreach((Function1 & Serializable & scala.Serializable)option -> {
            PlaintextAdminIntegrationTest.$anonfun$testCreatePartitions$5(this, alterResult, topic1, topic2, newPartition2Assignments, altered, option);
            return BoxedUnit.UNIT;
        });
        Tuple2[] tuple2Array5 = new Tuple2[2];
        NewPartitions newPartitions5 = NewPartitions.increaseTo((int)4);
        Object object5 = Predef$.MODULE$.ArrowAssoc((Object)topic1);
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array5[0] = new Tuple2((Object)$minus$greater$extension_$this3, (Object)$minus$greater$extension_y3);
        NewPartitions newPartitions6 = NewPartitions.increaseTo((int)2);
        Object object6 = Predef$.MODULE$.ArrowAssoc((Object)topic2);
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array5[1] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y2);
        alterResult.elem = this.client().createPartitions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array5))).asJava(), actuallyDoIt);
        altered.elem = (Void)((KafkaFuture)((CreatePartitionsResult)alterResult.elem).values().get(topic1)).get();
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!PlaintextAdminIntegrationTest.$anonfun$testCreatePartitions$6(this, topic1)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                throw Assertions$.MODULE$.fail(PlaintextAdminIntegrationTest.$anonfun$testCreatePartitions$7(), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 845));
            }
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension((long)waitUntilTrue_waitTimeMs, (long)waitUntilTrue_pause));
        }
        try {
            altered.elem = (Void)((KafkaFuture)((CreatePartitionsResult)alterResult.elem).values().get(topic2)).get();
        }
        catch (ExecutionException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof InvalidPartitionsException));
            Assert.assertEquals((Object)"Topic currently has 3 partitions, which is higher than the requested 2.", (Object)e.getCause().getMessage());
            Assert.assertEquals((long)3L, (long)this.numPartitions$1(topic2, PlaintextAdminIntegrationTest.numPartitions$default$2$1()));
        }
        ((KafkaFuture)this.client().deleteTopics(Arrays.asList((Object[])new String[]{topic1})).values().get(topic1)).get();
        Tuple2[] tuple2Array6 = new Tuple2[1];
        NewPartitions newPartitions7 = NewPartitions.increaseTo((int)4);
        Object object7 = Predef$.MODULE$.ArrowAssoc((Object)topic1);
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array6[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        alterResult.elem = this.client().createPartitions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array6))).asJava(), validateOnly);
        try {
            altered.elem = (Void)((KafkaFuture)((CreatePartitionsResult)alterResult.elem).values().get(topic1)).get();
            Assert.fail((String)"Expect InvalidTopicException when the topic is queued for deletion");
            return;
        }
        catch (ExecutionException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof InvalidTopicException));
            Assert.assertEquals((Object)"The topic is queued for deletion.", (Object)e.getCause().getMessage());
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testSeekAfterDeleteRecords() {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        void $minus$greater$extension_y2;
        void $minus$greater$extension_$this2;
        this.createTopic(this.topic(), 2, this.brokerCount(), this.createTopic$default$4());
        this.client_$eq(Admin.create(this.createConfig()));
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        this.subscribeAndWaitForAssignment(this.topic(), consumer);
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, 10, this.topicPartition());
        consumer.seekToBeginning(Collections.singleton(this.topicPartition()));
        Assert.assertEquals((long)0L, (long)consumer.position(this.topicPartition()));
        Tuple2[] tuple2Array = new Tuple2[1];
        RecordsToDelete recordsToDelete = RecordsToDelete.beforeOffset((long)5L);
        Object object = Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y2);
        long lowWatermark = ((DeletedRecords)((KafkaFuture)this.client().deleteRecords((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array))).asJava()).lowWatermarks().get(this.topicPartition())).get()).lowWatermark();
        Assert.assertEquals((long)5L, (long)lowWatermark);
        consumer.seekToBeginning(Collections.singletonList(this.topicPartition()));
        Assert.assertEquals((long)5L, (long)consumer.position(this.topicPartition()));
        consumer.seek(this.topicPartition(), 7L);
        Assert.assertEquals((long)7L, (long)consumer.position(this.topicPartition()));
        Tuple2[] tuple2Array2 = new Tuple2[1];
        RecordsToDelete recordsToDelete2 = RecordsToDelete.beforeOffset((long)-1L);
        Object object2 = Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array2[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        this.client().deleteRecords((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array2))).asJava()).all().get();
        consumer.seekToBeginning(Collections.singletonList(this.topicPartition()));
        Assert.assertEquals((long)10L, (long)consumer.position(this.topicPartition()));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testLogStartOffsetCheckpoint() {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        this.createTopic(this.topic(), 2, this.brokerCount(), this.createTopic$default$4());
        this.client_$eq(Admin.create(this.createConfig()));
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        this.subscribeAndWaitForAssignment(this.topic(), consumer);
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, 10, this.topicPartition());
        Tuple2[] tuple2Array = new Tuple2[1];
        RecordsToDelete recordsToDelete = RecordsToDelete.beforeOffset((long)5L);
        Object object = Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        ObjectRef result = ObjectRef.create((Object)this.client().deleteRecords((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array))).asJava()));
        ObjectRef lowWatermark = ObjectRef.create((Object)new Some((Object)BoxesRunTime.boxToLong((long)((DeletedRecords)((KafkaFuture)((DeleteRecordsResult)result.elem).lowWatermarks().get(this.topicPartition())).get()).lowWatermark())));
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)5)), (Object)((Option)lowWatermark.elem));
        int n = 0;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        Range range = RichInt$.MODULE$.until$extension0(n, this.brokerCount());
        if (range == null) {
            throw null;
        }
        Range foreach$mVc$sp_this = range;
        if (!foreach$mVc$sp_this.isEmpty()) {
            int foreach$mVc$sp_i = foreach$mVc$sp_this.start();
            while (true) {
                this.killBroker(foreach$mVc$sp_i);
                if (foreach$mVc$sp_i == foreach$mVc$sp_this.scala$collection$immutable$Range$$lastElement()) break;
                foreach$mVc$sp_i += foreach$mVc$sp_this.step();
            }
        }
        this.restartDeadBrokers();
        this.client().close();
        this.brokerList_$eq(TestUtils$.MODULE$.bootstrapServers((Seq<KafkaServer>)this.servers(), this.listenerName()));
        this.client_$eq(Admin.create(this.createConfig()));
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!PlaintextAdminIntegrationTest.$anonfun$testLogStartOffsetCheckpoint$2(this, result, lowWatermark)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                throw Assertions$.MODULE$.fail(PlaintextAdminIntegrationTest.$anonfun$testLogStartOffsetCheckpoint$3(lowWatermark), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 845));
            }
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension((long)waitUntilTrue_waitTimeMs, (long)waitUntilTrue_pause));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testLogStartOffsetAfterDeleteRecords() {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        this.createTopic(this.topic(), 2, this.brokerCount(), this.createTopic$default$4());
        this.client_$eq(Admin.create(this.createConfig()));
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        this.subscribeAndWaitForAssignment(this.topic(), consumer);
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, 10, this.topicPartition());
        Tuple2[] tuple2Array = new Tuple2[1];
        RecordsToDelete recordsToDelete = RecordsToDelete.beforeOffset((long)3L);
        Object object = Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        long lowWatermark = ((DeletedRecords)((KafkaFuture)this.client().deleteRecords((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array))).asJava()).lowWatermarks().get(this.topicPartition())).get()).lowWatermark();
        Assert.assertEquals((long)3L, (long)lowWatermark);
        int n = 0;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        Range range = RichInt$.MODULE$.until$extension0(n, this.brokerCount());
        if (range == null) {
            throw null;
        }
        Range foreach$mVc$sp_this = range;
        if (!foreach$mVc$sp_this.isEmpty()) {
            int foreach$mVc$sp_i = foreach$mVc$sp_this.start();
            while (true) {
                PlaintextAdminIntegrationTest.$anonfun$testLogStartOffsetAfterDeleteRecords$1(this, foreach$mVc$sp_i);
                if (foreach$mVc$sp_i == foreach$mVc$sp_this.scala$collection$immutable$Range$$lastElement()) break;
                foreach$mVc$sp_i += foreach$mVc$sp_this.step();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testReplicaCanFetchFromLogStartOffsetAfterDeleteRecords() {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        void $minus$greater$extension_y2;
        void $minus$greater$extension_$this2;
        int followerIndex = BoxesRunTime.unboxToInt((Object)this.createTopic(this.topic(), 1, this.brokerCount(), this.createTopic$default$4()).apply((Object)BoxesRunTime.boxToInteger((int)0))) != ((KafkaServer)this.servers().apply(0)).config().brokerId() ? 0 : 1;
        this.killBroker(followerIndex);
        this.client_$eq(Admin.create(this.createConfig()));
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, 100, this.topicPartition());
        Tuple2[] tuple2Array = new Tuple2[1];
        RecordsToDelete recordsToDelete = RecordsToDelete.beforeOffset((long)3L);
        Object object = Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y2);
        this.client().deleteRecords((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array))).asJava()).all().get();
        this.restartDeadBrokers();
        this.waitForFollowerLog$1(3L, 100L, followerIndex);
        int n = 0;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        Range range = RichInt$.MODULE$.until$extension0(n, this.brokerCount());
        if (range == null) {
            throw null;
        }
        Range foreach$mVc$sp_this = range;
        if (!foreach$mVc$sp_this.isEmpty()) {
            int foreach$mVc$sp_i = foreach$mVc$sp_this.start();
            while (true) {
                PlaintextAdminIntegrationTest.$anonfun$testReplicaCanFetchFromLogStartOffsetAfterDeleteRecords$7(this, foreach$mVc$sp_i);
                if (foreach$mVc$sp_i == foreach$mVc$sp_this.scala$collection$immutable$Range$$lastElement()) break;
                foreach$mVc$sp_i += foreach$mVc$sp_this.step();
            }
        }
        this.killBroker(followerIndex);
        this.sendRecords(producer, 100, this.topicPartition());
        Tuple2[] tuple2Array2 = new Tuple2[1];
        RecordsToDelete recordsToDelete2 = RecordsToDelete.beforeOffset((long)117L);
        Object object2 = Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array2[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        this.client().deleteRecords((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array2))).asJava()).all().get();
        this.restartDeadBrokers();
        this.waitForFollowerLog$1(117L, 200L, followerIndex);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testAlterLogDirsAfterDeleteRecords() {
        void $minus$greater$extension_$this;
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this2;
        this.client_$eq(Admin.create(this.createConfig()));
        this.createTopic(this.topic(), 1, this.brokerCount(), this.createTopic$default$4());
        int expectedLEO = 100;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, expectedLEO, this.topicPartition());
        Tuple2[] tuple2Array = new Tuple2[1];
        RecordsToDelete recordsToDelete = RecordsToDelete.beforeOffset((long)3L);
        Object object = Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y);
        this.client().deleteRecords((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array))).asJava()).all().get();
        int n = 0;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        Range range = RichInt$.MODULE$.until$extension0(n, this.brokerCount());
        if (range == null) {
            throw null;
        }
        Range foreach$mVc$sp_this = range;
        if (!foreach$mVc$sp_this.isEmpty()) {
            int foreach$mVc$sp_i = foreach$mVc$sp_this.start();
            while (true) {
                PlaintextAdminIntegrationTest.$anonfun$testAlterLogDirsAfterDeleteRecords$1(this, expectedLEO, foreach$mVc$sp_i);
                if (foreach$mVc$sp_i == foreach$mVc$sp_this.scala$collection$immutable$Range$$lastElement()) break;
                foreach$mVc$sp_i += foreach$mVc$sp_this.step();
            }
        }
        String futureLogDir = (String)((KafkaServer)this.servers().apply(0)).config().logDirs().apply(1);
        TopicPartitionReplica futureReplica = new TopicPartitionReplica(this.topic(), 0, ((KafkaServer)this.servers().apply(0)).config().brokerId());
        Tuple2[] tuple2Array2 = new Tuple2[1];
        Object object2 = Predef$.MODULE$.ArrowAssoc((Object)futureReplica);
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array2[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)futureLogDir);
        this.client().alterReplicaLogDirs((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array2))).asJava()).all().get();
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!PlaintextAdminIntegrationTest.$anonfun$testAlterLogDirsAfterDeleteRecords$2(this, futureLogDir)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                throw Assertions$.MODULE$.fail(PlaintextAdminIntegrationTest.$anonfun$testAlterLogDirsAfterDeleteRecords$3(), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 845));
            }
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension((long)waitUntilTrue_waitTimeMs, (long)waitUntilTrue_pause));
        }
        Assert.assertEquals((long)3L, (long)((Log)((KafkaServer)this.servers().head()).replicaManager().localLog(this.topicPartition()).get()).logStartOffset());
        Assert.assertEquals((long)expectedLEO, (long)((Log)((KafkaServer)this.servers().head()).replicaManager().localLog(this.topicPartition()).get()).logEndOffset());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testOffsetsForTimesAfterDeleteRecords() {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        void $minus$greater$extension_y2;
        void $minus$greater$extension_$this2;
        void $minus$greater$extension_y3;
        void $minus$greater$extension_$this3;
        void $minus$greater$extension_y4;
        void $minus$greater$extension_$this4;
        void $minus$greater$extension_y5;
        void $minus$greater$extension_$this5;
        this.createTopic(this.topic(), 2, this.brokerCount(), this.createTopic$default$4());
        this.client_$eq(Admin.create(this.createConfig()));
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        this.subscribeAndWaitForAssignment(this.topic(), consumer);
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, 10, this.topicPartition());
        Tuple2[] tuple2Array = new Tuple2[1];
        Long l = 0L;
        Object object = Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this5, (Object)$minus$greater$extension_y5);
        Assert.assertEquals((long)0L, (long)((OffsetAndTimestamp)consumer.offsetsForTimes((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array))).asJava()).get(this.topicPartition())).offset());
        Tuple2[] tuple2Array2 = new Tuple2[1];
        RecordsToDelete recordsToDelete = RecordsToDelete.beforeOffset((long)5L);
        Object object2 = Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array2[0] = new Tuple2((Object)$minus$greater$extension_$this4, (Object)$minus$greater$extension_y4);
        this.client().deleteRecords((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array2))).asJava()).all().get();
        Tuple2[] tuple2Array3 = new Tuple2[1];
        Long l2 = 0L;
        Object object3 = Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array3[0] = new Tuple2((Object)$minus$greater$extension_$this3, (Object)$minus$greater$extension_y3);
        Assert.assertEquals((long)5L, (long)((OffsetAndTimestamp)consumer.offsetsForTimes((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array3))).asJava()).get(this.topicPartition())).offset());
        Tuple2[] tuple2Array4 = new Tuple2[1];
        RecordsToDelete recordsToDelete2 = RecordsToDelete.beforeOffset((long)-1L);
        Object object4 = Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array4[0] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y2);
        this.client().deleteRecords((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array4))).asJava()).all().get();
        Tuple2[] tuple2Array5 = new Tuple2[1];
        Long l3 = 0L;
        Object object5 = Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array5[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        Assert.assertNull(consumer.offsetsForTimes((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array5))).asJava()).get(this.topicPartition()));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testConsumeAfterDeleteRecords() {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        void $minus$greater$extension_y2;
        void $minus$greater$extension_$this2;
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        this.subscribeAndWaitForAssignment(this.topic(), consumer);
        this.client_$eq(Admin.create(this.createConfig()));
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, 10, this.topicPartition());
        TestUtils$.MODULE$.consumeRecords(consumer, 10, TestUtils$.MODULE$.consumeRecords$default$3());
        Tuple2[] tuple2Array = new Tuple2[1];
        RecordsToDelete recordsToDelete = RecordsToDelete.beforeOffset((long)3L);
        Object object = Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y2);
        this.client().deleteRecords((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array))).asJava()).all().get();
        consumer.seek(this.topicPartition(), 1L);
        TestUtils$.MODULE$.consumeRecords(consumer, 7, TestUtils$.MODULE$.consumeRecords$default$3());
        Tuple2[] tuple2Array2 = new Tuple2[1];
        RecordsToDelete recordsToDelete2 = RecordsToDelete.beforeOffset((long)8L);
        Object object2 = Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array2[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        this.client().deleteRecords((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array2))).asJava()).all().get();
        consumer.seek(this.topicPartition(), 1L);
        TestUtils$.MODULE$.consumeRecords(consumer, 2, TestUtils$.MODULE$.consumeRecords$default$3());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDeleteRecordsWithException() {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        this.subscribeAndWaitForAssignment(this.topic(), consumer);
        this.client_$eq(Admin.create(this.createConfig()));
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, 10, this.topicPartition());
        Tuple2[] tuple2Array = new Tuple2[1];
        RecordsToDelete recordsToDelete = RecordsToDelete.beforeOffset((long)5L);
        Object object = Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        Assert.assertEquals((long)5L, (long)((DeletedRecords)((KafkaFuture)this.client().deleteRecords((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array))).asJava()).lowWatermarks().get(this.topicPartition())).get()).lowWatermark());
        Throwable cause = ((Throwable)Assertions$.MODULE$.intercept((Function0 & Serializable & scala.Serializable)() -> {
            void $minus$greater$extension_y;
            void $minus$greater$extension_$this;
            Tuple2[] tuple2Array = new Tuple2[1];
            RecordsToDelete recordsToDelete = RecordsToDelete.beforeOffset((long)20L);
            Object object = Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition());
            if (Predef.ArrowAssoc$.MODULE$ == null) {
                throw null;
            }
            tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
            return (DeletedRecords)((KafkaFuture)this.client().deleteRecords((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array))).asJava()).lowWatermarks().get(this.topicPartition())).get();
        }, ClassTag$.MODULE$.apply(ExecutionException.class), new Position("PlaintextAdminIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 859))).getCause();
        Assert.assertEquals(OffsetOutOfRangeException.class, cause.getClass());
        TopicPartition nonExistPartition = new TopicPartition(this.topic(), 3);
        cause = ((Throwable)Assertions$.MODULE$.intercept((Function0 & Serializable & scala.Serializable)() -> {
            void $minus$greater$extension_y;
            void $minus$greater$extension_$this;
            Tuple2[] tuple2Array = new Tuple2[1];
            RecordsToDelete recordsToDelete = RecordsToDelete.beforeOffset((long)20L);
            Object object = Predef$.MODULE$.ArrowAssoc((Object)nonExistPartition);
            if (Predef.ArrowAssoc$.MODULE$ == null) {
                throw null;
            }
            tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
            return (DeletedRecords)((KafkaFuture)this.client().deleteRecords((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array))).asJava()).lowWatermarks().get(nonExistPartition)).get();
        }, ClassTag$.MODULE$.apply(ExecutionException.class), new Position("PlaintextAdminIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 866))).getCause();
        Assert.assertEquals(LeaderNotAvailableException.class, cause.getClass());
    }

    @Test
    public void testDescribeConfigsForTopic() {
        this.createTopic(this.topic(), 2, this.brokerCount(), this.createTopic$default$4());
        this.client_$eq(Admin.create(this.createConfig()));
        ConfigResource existingTopic = new ConfigResource(ConfigResource.Type.TOPIC, this.topic());
        ((KafkaFuture)this.client().describeConfigs(Collections.singletonList(existingTopic)).values().get(existingTopic)).get();
        ConfigResource nonExistentTopic = new ConfigResource(ConfigResource.Type.TOPIC, "unknown");
        DescribeConfigsResult describeResult1 = this.client().describeConfigs(Collections.singletonList(nonExistentTopic));
        Assert.assertTrue((boolean)(((Throwable)Assertions$.MODULE$.intercept((Function0 & Serializable & scala.Serializable)() -> (Config)((KafkaFuture)describeResult1.values().get(nonExistentTopic)).get(), ClassTag$.MODULE$.apply(ExecutionException.class), new Position("PlaintextAdminIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 883))).getCause() instanceof UnknownTopicOrPartitionException));
        ConfigResource invalidTopic = new ConfigResource(ConfigResource.Type.TOPIC, "(invalid topic)");
        DescribeConfigsResult describeResult2 = this.client().describeConfigs(Collections.singletonList(invalidTopic));
        Assert.assertTrue((boolean)(((Throwable)Assertions$.MODULE$.intercept((Function0 & Serializable & scala.Serializable)() -> (Config)((KafkaFuture)describeResult2.values().get(invalidTopic)).get(), ClassTag$.MODULE$.apply(ExecutionException.class), new Position("PlaintextAdminIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 888))).getCause() instanceof InvalidTopicException));
    }

    /*
     * WARNING - void declaration
     */
    private void subscribeAndWaitForAssignment(String topic, KafkaConsumer<byte[], byte[]> consumer) {
        void pollUntilTrue_action;
        consumer.subscribe(Collections.singletonList(topic));
        long l = TestUtils$.MODULE$.pollUntilTrue$default$4();
        JFunction0.mcZ.sp & Serializable & scala.Serializable intersect = (JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> !consumer.assignment().isEmpty();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long pollUntilTrue_x$3 = 0L;
        long pollUntilTrue_waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TestUtils$.$anonfun$pollUntilTrue$1(consumer, (Function0)pollUntilTrue_action)) {
            void pollUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > pollUntilTrue_waitUntilTrue_startTime + pollUntilTrue_waitTimeMs) {
                throw Assertions$.MODULE$.fail(PlaintextAdminIntegrationTest.$anonfun$subscribeAndWaitForAssignment$2(), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 845));
            }
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension((long)pollUntilTrue_waitTimeMs, pollUntilTrue_x$3));
        }
    }

    private void sendRecords(KafkaProducer<byte[], byte[]> producer, int numRecords, TopicPartition topicPartition) {
        int n = 0;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        ((IndexedSeq)RichInt$.MODULE$.until$extension0(n, numRecords).map((Function1 & Serializable & scala.Serializable)i -> PlaintextAdminIntegrationTest.$anonfun$sendRecords$1(this, topicPartition, producer, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x$10 -> (RecordMetadata)x$10.get());
    }

    @Test
    public void testInvalidAlterConfigs() {
        this.client_$eq(Admin.create(this.createConfig()));
        PlaintextAdminIntegrationTest$.MODULE$.checkInvalidAlterConfigs(this.zkClient(), (Seq<KafkaServer>)this.servers(), this.client());
    }

    @Test
    public void testAclOperations() {
        AclBinding acl = new AclBinding(new ResourcePattern(ResourceType.TOPIC, "mytopic3", PatternType.LITERAL), new AccessControlEntry("User:ANONYMOUS", "*", AclOperation.DESCRIBE, AclPermissionType.ALLOW));
        this.client_$eq(Admin.create(this.createConfig()));
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals(this.client().describeAcls(AclBindingFilter.ANY).values(), SecurityDisabledException.class, TestUtils$.MODULE$.assertFutureExceptionTypeEquals$default$3());
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals(this.client().createAcls(Collections.singleton(acl)).all(), SecurityDisabledException.class, TestUtils$.MODULE$.assertFutureExceptionTypeEquals$default$3());
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals(this.client().deleteAcls(Collections.singleton(acl.toFilter())).all(), SecurityDisabledException.class, TestUtils$.MODULE$.assertFutureExceptionTypeEquals$default$3());
    }

    @Test
    public void testDelayedClose() {
        this.client_$eq(Admin.create(this.createConfig()));
        Seq newTopics = (Seq)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"mytopic", "mytopic2"}))).map((Function1 & Serializable & scala.Serializable)x$11 -> new NewTopic(x$11, 1, (short)1), Seq$.MODULE$.canBuildFrom());
        KafkaFuture future = this.client().createTopics((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(newTopics).asJava(), new CreateTopicsOptions().validateOnly(true)).all();
        this.client().close(java.time.Duration.ofHours(2L));
        KafkaFuture future2 = this.client().createTopics((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(newTopics).asJava(), new CreateTopicsOptions().validateOnly(true)).all();
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals(future2, TimeoutException.class, TestUtils$.MODULE$.assertFutureExceptionTypeEquals$default$3());
        future.get();
        this.client().close(java.time.Duration.ofMinutes(30L));
    }

    @Test
    public void testForceClose() {
        java.util.Map<String, Object> config = this.createConfig();
        config.put("bootstrap.servers", new StringBuilder(10).append("localhost:").append(TestUtils$.MODULE$.IncorrectBrokerPort()).toString());
        this.client_$eq(Admin.create(config));
        KafkaFuture future = this.client().createTopics((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"mytopic", "mytopic2"}))).map((Function1 & Serializable & scala.Serializable)x$12 -> new NewTopic(x$12, 1, (short)1), Seq$.MODULE$.canBuildFrom())).asJava(), new CreateTopicsOptions().timeoutMs(Predef$.MODULE$.int2Integer(900000))).all();
        this.client().close(java.time.Duration.ZERO);
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals(future, TimeoutException.class, TestUtils$.MODULE$.assertFutureExceptionTypeEquals$default$3());
    }

    @Test
    public void testMinimumRequestTimeouts() {
        java.util.Map<String, Object> config = this.createConfig();
        config.put("bootstrap.servers", new StringBuilder(10).append("localhost:").append(TestUtils$.MODULE$.IncorrectBrokerPort()).toString());
        config.put("request.timeout.ms", "0");
        this.client_$eq(Admin.create(config));
        long startTimeMs = Time.SYSTEM.milliseconds();
        KafkaFuture future = this.client().createTopics((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"mytopic", "mytopic2"}))).map((Function1 & Serializable & scala.Serializable)x$13 -> new NewTopic(x$13, 1, (short)1), Seq$.MODULE$.canBuildFrom())).asJava(), new CreateTopicsOptions().timeoutMs(Predef$.MODULE$.int2Integer(2))).all();
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals(future, TimeoutException.class, TestUtils$.MODULE$.assertFutureExceptionTypeEquals$default$3());
        long endTimeMs = Time.SYSTEM.milliseconds();
        Assert.assertTrue((String)"Expected the timeout to take at least one millisecond.", (endTimeMs > startTimeMs ? 1 : 0) != 0);
    }

    @Test
    public void testCallInFlightTimeouts() {
        java.util.Map<String, Object> config = this.createConfig();
        config.put("default.api.timeout.ms", "100000000");
        KafkaAdminClientTest.FailureInjectingTimeoutProcessorFactory factory = new KafkaAdminClientTest.FailureInjectingTimeoutProcessorFactory();
        this.client_$eq((Admin)KafkaAdminClientTest.createInternal((AdminClientConfig)new AdminClientConfig(config), (KafkaAdminClient.TimeoutProcessorFactory)factory));
        KafkaFuture future = this.client().createTopics((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"mytopic", "mytopic2"}))).map((Function1 & Serializable & scala.Serializable)x$14 -> new NewTopic(x$14, 1, (short)1), Seq$.MODULE$.canBuildFrom())).asJava(), new CreateTopicsOptions().validateOnly(true)).all();
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals(future, TimeoutException.class, TestUtils$.MODULE$.assertFutureExceptionTypeEquals$default$3());
        this.client().createTopics((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"mytopic3", "mytopic4"}))).map((Function1 & Serializable & scala.Serializable)x$15 -> new NewTopic(x$15, 1, (short)1), Seq$.MODULE$.canBuildFrom())).asJava(), new CreateTopicsOptions().validateOnly(true)).all().get();
        Assert.assertEquals((long)1L, (long)factory.failuresInjected());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testConsumerGroups() {
        java.util.Map<String, Object> config = this.createConfig();
        this.client_$eq(Admin.create(config));
        try {
            ListConsumerGroupsResult list1 = this.client().listConsumerGroups();
            Assert.assertTrue((0 == ((Collection)list1.all().get()).size() ? 1 : 0) != 0);
            Assert.assertTrue((0 == ((Collection)list1.errors().get()).size() ? 1 : 0) != 0);
            Assert.assertTrue((0 == ((Collection)list1.valid().get()).size() ? 1 : 0) != 0);
            String testTopicName = "test_topic";
            int testNumPartitions = 2;
            this.client().createTopics(Collections.singleton(new NewTopic(testTopicName, testNumPartitions, (short)1))).all().get();
            this.waitForTopics(this.client(), (Seq<String>)new .colon.colon((Object)testTopicName, (List)Nil$.MODULE$), (Seq<String>)Nil$.MODULE$);
            KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
            try {
                producer.send(new ProducerRecord(testTopicName, Predef$.MODULE$.int2Integer(0), null, null)).get();
            }
            finally {
                Utils.closeQuietly(producer, (String)"producer");
            }
            String testGroupId = "test_group_id";
            String testClientId = "test_client_id";
            String testInstanceId = "test_instance_id";
            String fakeGroupId = "fake_group_id";
            Properties newConsumerConfig = new Properties(this.consumerConfig());
            newConsumerConfig.setProperty("group.id", testGroupId);
            newConsumerConfig.setProperty("client.id", testClientId);
            newConsumerConfig.setProperty("group.instance.id", testInstanceId);
            ByteArrayDeserializer x$2 = this.createConsumer$default$1();
            ByteArrayDeserializer x$3 = this.createConsumer$default$2();
            List<String> x$4 = this.createConsumer$default$4();
            KafkaConsumer consumer = this.createConsumer(x$2, x$3, newConsumerConfig, x$4);
            CountDownLatch latch = new CountDownLatch(1);
            try {
                Thread consumerThread = new Thread(null, consumer, testTopicName, latch){
                    private final KafkaConsumer consumer$2;
                    private final String testTopicName$1;
                    private final CountDownLatch latch$1;

                    public void run() {
                        this.consumer$2.subscribe(Collections.singleton(this.testTopicName$1));
                        try {
                            while (true) {
                                this.consumer$2.poll(java.time.Duration.ofSeconds(5L));
                                if (!this.consumer$2.assignment().isEmpty() && this.latch$1.getCount() > 0L) {
                                    this.latch$1.countDown();
                                }
                                this.consumer$2.commitSync();
                            }
                        }
                        catch (InterruptException interruptException) {
                            return;
                        }
                    }
                    {
                        this.consumer$2 = consumer$2;
                        this.testTopicName$1 = testTopicName$1;
                        this.latch$1 = latch$1;
                    }
                };
                try {
                    consumerThread.start();
                    Assert.assertTrue((boolean)latch.await(30000L, TimeUnit.MILLISECONDS));
                    long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
                    long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
                    if (TestUtils$.MODULE$ == null) {
                        throw null;
                    }
                    long waitUntilTrue_startTime = System.currentTimeMillis();
                    while (!PlaintextAdminIntegrationTest.$anonfun$testConsumerGroups$1(this, testGroupId)) {
                        void waitUntilTrue_pause;
                        void waitUntilTrue_waitTimeMs;
                        if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                            throw Assertions$.MODULE$.fail(PlaintextAdminIntegrationTest.$anonfun$testConsumerGroups$3(testGroupId), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 845));
                        }
                        if (Predef$.MODULE$ == null) {
                            throw null;
                        }
                        Thread.sleep(RichLong$.MODULE$.min$extension((long)waitUntilTrue_waitTimeMs, (long)waitUntilTrue_pause));
                    }
                    DescribeConsumerGroupsResult describeWithFakeGroupResult = this.client().describeConsumerGroups((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{testGroupId, fakeGroupId}))).asJava(), new DescribeConsumerGroupsOptions().includeAuthorizedOperations(true));
                    Assert.assertEquals((long)2L, (long)describeWithFakeGroupResult.describedGroups().size());
                    Assert.assertTrue((boolean)describeWithFakeGroupResult.describedGroups().containsKey(testGroupId));
                    ConsumerGroupDescription testGroupDescription = (ConsumerGroupDescription)((KafkaFuture)describeWithFakeGroupResult.describedGroups().get(testGroupId)).get();
                    Assert.assertEquals((Object)testGroupId, (Object)testGroupDescription.groupId());
                    Assert.assertFalse((boolean)testGroupDescription.isSimpleConsumerGroup());
                    Assert.assertEquals((long)1L, (long)testGroupDescription.members().size());
                    MemberDescription member = (MemberDescription)testGroupDescription.members().iterator().next();
                    Assert.assertEquals((Object)testClientId, (Object)member.clientId());
                    java.util.Set topicPartitions = member.assignment().topicPartitions();
                    Assert.assertEquals((long)testNumPartitions, (long)topicPartitions.size());
                    Assert.assertEquals((long)testNumPartitions, (long)((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter(topicPartitions).asScala()).count((Function1 & Serializable & scala.Serializable)tp -> BoxesRunTime.boxToBoolean((boolean)PlaintextAdminIntegrationTest.$anonfun$testConsumerGroups$4(testTopicName, tp))));
                    java.util.Set expectedOperations = (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((scala.collection.Set)AclEntry$.MODULE$.supportedOperations(ResourceType.GROUP)).asJava();
                    Assert.assertEquals((Object)expectedOperations, (Object)testGroupDescription.authorizedOperations());
                    Assert.assertTrue((boolean)describeWithFakeGroupResult.describedGroups().containsKey(fakeGroupId));
                    ConsumerGroupDescription fakeGroupDescription = (ConsumerGroupDescription)((KafkaFuture)describeWithFakeGroupResult.describedGroups().get(fakeGroupId)).get();
                    Assert.assertEquals((Object)fakeGroupId, (Object)fakeGroupDescription.groupId());
                    Assert.assertEquals((long)0L, (long)fakeGroupDescription.members().size());
                    Assert.assertEquals((Object)"", (Object)fakeGroupDescription.partitionAssignor());
                    Assert.assertEquals((Object)ConsumerGroupState.DEAD, (Object)fakeGroupDescription.state());
                    Assert.assertEquals((Object)expectedOperations, (Object)fakeGroupDescription.authorizedOperations());
                    Assert.assertEquals((long)2L, (long)((java.util.Map)describeWithFakeGroupResult.all().get()).size());
                    long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
                    long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
                    if (TestUtils$.MODULE$ == null) {
                        throw null;
                    }
                    long waitUntilTrue_startTime2 = System.currentTimeMillis();
                    while (!PlaintextAdminIntegrationTest.$anonfun$testConsumerGroups$5(this, testGroupId, testTopicName)) {
                        void waitUntilTrue_pause;
                        void waitUntilTrue_waitTimeMs;
                        if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                            throw Assertions$.MODULE$.fail(PlaintextAdminIntegrationTest.$anonfun$testConsumerGroups$6(), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 845));
                        }
                        if (Predef$.MODULE$ == null) {
                            throw null;
                        }
                        Thread.sleep(RichLong$.MODULE$.min$extension((long)waitUntilTrue_waitTimeMs, (long)waitUntilTrue_pause));
                    }
                    String invalidInstanceId = "invalid-instance-id";
                    RemoveMembersFromConsumerGroupResult removeMembersResult = this.client().removeMembersFromConsumerGroup(testGroupId, new RemoveMembersFromConsumerGroupOptions(Collections.singleton(new MemberToRemove(invalidInstanceId))));
                    TestUtils$.MODULE$.assertFutureExceptionTypeEquals(removeMembersResult.all(), UnknownMemberIdException.class, TestUtils$.MODULE$.assertFutureExceptionTypeEquals$default$3());
                    KafkaFuture firstMemberFuture = removeMembersResult.memberResult(new MemberToRemove(invalidInstanceId));
                    TestUtils$.MODULE$.assertFutureExceptionTypeEquals(firstMemberFuture, UnknownMemberIdException.class, TestUtils$.MODULE$.assertFutureExceptionTypeEquals$default$3());
                    DeleteConsumerGroupsResult deleteResult = this.client().deleteConsumerGroups((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{testGroupId, fakeGroupId}))).asJava());
                    Assert.assertEquals((long)2L, (long)deleteResult.deletedGroups().size());
                    Assert.assertTrue((boolean)deleteResult.deletedGroups().containsKey(fakeGroupId));
                    TestUtils$.MODULE$.assertFutureExceptionTypeEquals((KafkaFuture)deleteResult.deletedGroups().get(fakeGroupId), GroupIdNotFoundException.class, TestUtils$.MODULE$.assertFutureExceptionTypeEquals$default$3());
                    Assert.assertTrue((boolean)deleteResult.deletedGroups().containsKey(testGroupId));
                    TestUtils$.MODULE$.assertFutureExceptionTypeEquals((KafkaFuture)deleteResult.deletedGroups().get(testGroupId), GroupNotEmptyException.class, TestUtils$.MODULE$.assertFutureExceptionTypeEquals$default$3());
                    removeMembersResult = this.client().removeMembersFromConsumerGroup(testGroupId, new RemoveMembersFromConsumerGroupOptions(Collections.singleton(new MemberToRemove(testInstanceId))));
                    Assert.assertNull((Object)removeMembersResult.all().get());
                    Assert.assertNull((Object)removeMembersResult.memberResult(new MemberToRemove(testInstanceId)).get());
                    DescribeConsumerGroupsResult describeTestGroupResult = this.client().describeConsumerGroups((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{testGroupId}))).asJava(), new DescribeConsumerGroupsOptions().includeAuthorizedOperations(true));
                    Assert.assertEquals((long)1L, (long)describeTestGroupResult.describedGroups().size());
                    testGroupDescription = (ConsumerGroupDescription)((KafkaFuture)describeTestGroupResult.describedGroups().get(testGroupId)).get();
                    Assert.assertEquals((Object)testGroupId, (Object)testGroupDescription.groupId());
                    Assert.assertFalse((boolean)testGroupDescription.isSimpleConsumerGroup());
                    Assert.assertTrue((boolean)testGroupDescription.members().isEmpty());
                    deleteResult = this.client().deleteConsumerGroups((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{testGroupId}))).asJava());
                    Assert.assertEquals((long)1L, (long)deleteResult.deletedGroups().size());
                    Assert.assertTrue((boolean)deleteResult.deletedGroups().containsKey(testGroupId));
                    Assert.assertNull((Object)((KafkaFuture)deleteResult.deletedGroups().get(testGroupId)).get());
                }
                finally {
                    consumerThread.interrupt();
                    consumerThread.join();
                }
            }
            finally {
                Utils.closeQuietly(consumer, (String)"consumer");
            }
        }
        finally {
            Utils.closeQuietly((AutoCloseable)this.client(), (String)"adminClient");
        }
    }

    @Test
    public void testDeleteConsumerGroupOffsets() {
        java.util.Map<String, Object> config = this.createConfig();
        this.client_$eq(Admin.create(config));
        try {
            String testTopicName = "test_topic";
            String testGroupId = "test_group_id";
            String testClientId = "test_client_id";
            String fakeGroupId = "fake_group_id";
            TopicPartition tp1 = new TopicPartition(testTopicName, 0);
            TopicPartition tp2 = new TopicPartition("foo", 0);
            this.client().createTopics(Collections.singleton(new NewTopic(testTopicName, 1, (short)1))).all().get();
            this.waitForTopics(this.client(), (Seq<String>)new .colon.colon((Object)testTopicName, (List)Nil$.MODULE$), (Seq<String>)Nil$.MODULE$);
            KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
            try {
                producer.send(new ProducerRecord(testTopicName, Predef$.MODULE$.int2Integer(0), null, null)).get();
            }
            finally {
                Utils.closeQuietly(producer, (String)"producer");
            }
            Properties newConsumerConfig = new Properties(this.consumerConfig());
            newConsumerConfig.setProperty("group.id", testGroupId);
            newConsumerConfig.setProperty("client.id", testClientId);
            newConsumerConfig.setProperty("max.poll.interval.ms", ((Object)BoxesRunTime.boxToInteger((int)Integer.MAX_VALUE)).toString());
            newConsumerConfig.setProperty("session.timeout.ms", ((Object)BoxesRunTime.boxToInteger((int)Defaults$.MODULE$.GroupMaxSessionTimeoutMs())).toString());
            ByteArrayDeserializer x$2 = this.createConsumer$default$1();
            ByteArrayDeserializer x$3 = this.createConsumer$default$2();
            List<String> x$4 = this.createConsumer$default$4();
            KafkaConsumer consumer = this.createConsumer(x$2, x$3, newConsumerConfig, x$4);
            try {
                TestUtils$.MODULE$.subscribeAndWaitForRecords(testTopicName, consumer, TestUtils$.MODULE$.subscribeAndWaitForRecords$default$3());
                consumer.commitSync();
                DeleteConsumerGroupOffsetsResult offsetDeleteResult = this.client().deleteConsumerGroupOffsets(testGroupId, (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((scala.collection.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp1, tp2}))).asJava());
                TestUtils$.MODULE$.assertFutureExceptionTypeEquals(offsetDeleteResult.all(), GroupSubscribedToTopicException.class, TestUtils$.MODULE$.assertFutureExceptionTypeEquals$default$3());
                TestUtils$.MODULE$.assertFutureExceptionTypeEquals(offsetDeleteResult.partitionResult(tp1), GroupSubscribedToTopicException.class, TestUtils$.MODULE$.assertFutureExceptionTypeEquals$default$3());
                TestUtils$.MODULE$.assertFutureExceptionTypeEquals(offsetDeleteResult.partitionResult(tp2), UnknownTopicOrPartitionException.class, TestUtils$.MODULE$.assertFutureExceptionTypeEquals$default$3());
                DeleteConsumerGroupOffsetsResult fakeDeleteResult = this.client().deleteConsumerGroupOffsets(fakeGroupId, (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((scala.collection.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp1, tp2}))).asJava());
                TestUtils$.MODULE$.assertFutureExceptionTypeEquals(fakeDeleteResult.all(), GroupIdNotFoundException.class, TestUtils$.MODULE$.assertFutureExceptionTypeEquals$default$3());
                TestUtils$.MODULE$.assertFutureExceptionTypeEquals(fakeDeleteResult.partitionResult(tp1), GroupIdNotFoundException.class, TestUtils$.MODULE$.assertFutureExceptionTypeEquals$default$3());
                TestUtils$.MODULE$.assertFutureExceptionTypeEquals(fakeDeleteResult.partitionResult(tp2), GroupIdNotFoundException.class, TestUtils$.MODULE$.assertFutureExceptionTypeEquals$default$3());
            }
            finally {
                Utils.closeQuietly(consumer, (String)"consumer");
            }
            DeleteConsumerGroupOffsetsResult offsetDeleteResult = this.client().deleteConsumerGroupOffsets(testGroupId, (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((scala.collection.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp1, tp2}))).asJava());
            TestUtils$.MODULE$.assertFutureExceptionTypeEquals(offsetDeleteResult.all(), UnknownTopicOrPartitionException.class, TestUtils$.MODULE$.assertFutureExceptionTypeEquals$default$3());
            Assert.assertNull((Object)offsetDeleteResult.partitionResult(tp1).get());
            TestUtils$.MODULE$.assertFutureExceptionTypeEquals(offsetDeleteResult.partitionResult(tp2), UnknownTopicOrPartitionException.class, TestUtils$.MODULE$.assertFutureExceptionTypeEquals$default$3());
        }
        finally {
            Utils.closeQuietly((AutoCloseable)this.client(), (String)"adminClient");
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testElectPreferredLeaders() {
        void $minus$greater$extension_$this;
        void $minus$greater$extension_$this2;
        this.client_$eq(Admin.create(this.createConfig()));
        Seq prefer0 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        Seq prefer1 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 0}));
        Seq prefer2 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 0, 1}));
        TopicPartition partition1 = new TopicPartition("elect-preferred-leaders-topic-1", 0);
        Tuple2[] tuple2Array = new Tuple2[1];
        Object object = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)partition1.partition()));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)prefer0);
        TestUtils$.MODULE$.createTopic(this.zkClient(), partition1.topic(), (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array))), (Seq<KafkaServer>)this.servers());
        TopicPartition partition2 = new TopicPartition("elect-preferred-leaders-topic-2", 0);
        Tuple2[] tuple2Array2 = new Tuple2[1];
        Object object2 = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)partition2.partition()));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array2[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)prefer0);
        TestUtils$.MODULE$.createTopic(this.zkClient(), partition2.topic(), (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array2))), (Seq<KafkaServer>)this.servers());
        TestUtils$.MODULE$.assertLeader(this.client(), partition1, 0);
        TestUtils$.MODULE$.assertLeader(this.client(), partition2, 0);
        ElectLeadersResult electResult = this.client().electLeaders(ElectionType.PREFERRED, (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((scala.collection.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partition1}))).asJava());
        Throwable exception = (Throwable)((Optional)((java.util.Map)electResult.partitions().get()).get(partition1)).get();
        Assert.assertEquals(ElectionNotNeededException.class, exception.getClass());
        Assert.assertEquals((Object)"Leader election not needed for topic partition", (Object)exception.getMessage());
        TestUtils$.MODULE$.assertLeader(this.client(), partition1, 0);
        electResult = this.client().electLeaders(ElectionType.PREFERRED, null);
        Assert.assertTrue((boolean)((java.util.Map)electResult.partitions().get()).isEmpty());
        TestUtils$.MODULE$.assertLeader(this.client(), partition1, 0);
        TestUtils$.MODULE$.assertLeader(this.client(), partition2, 0);
        this.changePreferredLeader$1(prefer1, partition1, partition2);
        electResult = this.client().electLeaders(ElectionType.PREFERRED, (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((scala.collection.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partition1}))).asJava());
        Assert.assertEquals((Object)JavaConverters$.MODULE$.setAsJavaSetConverter((scala.collection.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partition1}))).asJava(), ((java.util.Map)electResult.partitions().get()).keySet());
        Assert.assertFalse((boolean)((Optional)((java.util.Map)electResult.partitions().get()).get(partition1)).isPresent());
        TestUtils$.MODULE$.assertLeader(this.client(), partition1, 1);
        Assert.assertFalse((boolean)((java.util.Map)electResult.partitions().get()).containsKey(partition2));
        TestUtils$.MODULE$.assertLeader(this.client(), partition2, 0);
        electResult = this.client().electLeaders(ElectionType.PREFERRED, null);
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partition2})), (Object)JavaConverters$.MODULE$.asScalaSetConverter(((java.util.Map)electResult.partitions().get()).keySet()).asScala());
        Assert.assertFalse((boolean)((Optional)((java.util.Map)electResult.partitions().get()).get(partition2)).isPresent());
        TestUtils$.MODULE$.assertLeader(this.client(), partition2, 1);
        TopicPartition unknownPartition = new TopicPartition("topic-does-not-exist", 0);
        electResult = this.client().electLeaders(ElectionType.PREFERRED, (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((scala.collection.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{unknownPartition}))).asJava());
        Assert.assertEquals((Object)JavaConverters$.MODULE$.setAsJavaSetConverter((scala.collection.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{unknownPartition}))).asJava(), ((java.util.Map)electResult.partitions().get()).keySet());
        exception = (Throwable)((Optional)((java.util.Map)electResult.partitions().get()).get(unknownPartition)).get();
        Assert.assertEquals(UnknownTopicOrPartitionException.class, exception.getClass());
        Assert.assertEquals((Object)"The partition does not exist.", (Object)exception.getMessage());
        TestUtils$.MODULE$.assertLeader(this.client(), partition1, 1);
        TestUtils$.MODULE$.assertLeader(this.client(), partition2, 1);
        this.changePreferredLeader$1(prefer2, partition1, partition2);
        electResult = this.client().electLeaders(ElectionType.PREFERRED, (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((scala.collection.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{unknownPartition, partition1}))).asJava());
        Assert.assertEquals((Object)JavaConverters$.MODULE$.setAsJavaSetConverter((scala.collection.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{unknownPartition, partition1}))).asJava(), ((java.util.Map)electResult.partitions().get()).keySet());
        TestUtils$.MODULE$.assertLeader(this.client(), partition1, 2);
        TestUtils$.MODULE$.assertLeader(this.client(), partition2, 1);
        exception = (Throwable)((Optional)((java.util.Map)electResult.partitions().get()).get(unknownPartition)).get();
        Assert.assertEquals(UnknownTopicOrPartitionException.class, exception.getClass());
        Assert.assertEquals((Object)"The partition does not exist.", (Object)exception.getMessage());
        electResult = this.client().electLeaders(ElectionType.PREFERRED, (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((scala.collection.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partition2}))).asJava());
        Assert.assertEquals((Object)JavaConverters$.MODULE$.setAsJavaSetConverter((scala.collection.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partition2}))).asJava(), ((java.util.Map)electResult.partitions().get()).keySet());
        Assert.assertFalse((boolean)((Optional)((java.util.Map)electResult.partitions().get()).get(partition2)).isPresent());
        TestUtils$.MODULE$.assertLeader(this.client(), partition2, 2);
        this.changePreferredLeader$1(prefer1, partition1, partition2);
        ((KafkaServer)this.servers().apply(1)).shutdown();
        TestUtils$.MODULE$.waitForBrokersOutOfIsr(this.client(), (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partition1, partition2}))), (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1}))));
        ElectLeadersOptions shortTimeout = (ElectLeadersOptions)new ElectLeadersOptions().timeoutMs(Predef$.MODULE$.int2Integer(10000));
        electResult = this.client().electLeaders(ElectionType.PREFERRED, (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((scala.collection.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partition1}))).asJava(), shortTimeout);
        Assert.assertEquals((Object)JavaConverters$.MODULE$.setAsJavaSetConverter((scala.collection.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partition1}))).asJava(), ((java.util.Map)electResult.partitions().get()).keySet());
        exception = (Throwable)((Optional)((java.util.Map)electResult.partitions().get()).get(partition1)).get();
        Assert.assertEquals(PreferredLeaderNotAvailableException.class, exception.getClass());
        Assert.assertTrue((String)new StringBuilder(14).append("Wrong message ").append(exception.getMessage()).toString(), (boolean)exception.getMessage().contains("Failed to elect leader for partition elect-preferred-leaders-topic-1-0 under strategy PreferredReplicaPartitionLeaderElectionStrategy"));
        TestUtils$.MODULE$.assertLeader(this.client(), partition1, 2);
        electResult = this.client().electLeaders(ElectionType.PREFERRED, null, shortTimeout);
        exception = (Throwable)((Optional)((java.util.Map)electResult.partitions().get()).get(partition1)).get();
        Assert.assertEquals(PreferredLeaderNotAvailableException.class, exception.getClass());
        Assert.assertTrue((String)new StringBuilder(14).append("Wrong message ").append(exception.getMessage()).toString(), (boolean)exception.getMessage().contains("Failed to elect leader for partition elect-preferred-leaders-topic-1-0 under strategy PreferredReplicaPartitionLeaderElectionStrategy"));
        exception = (Throwable)((Optional)((java.util.Map)electResult.partitions().get()).get(partition2)).get();
        Assert.assertEquals(PreferredLeaderNotAvailableException.class, exception.getClass());
        Assert.assertTrue((String)new StringBuilder(14).append("Wrong message ").append(exception.getMessage()).toString(), (boolean)exception.getMessage().contains("Failed to elect leader for partition elect-preferred-leaders-topic-2-0 under strategy PreferredReplicaPartitionLeaderElectionStrategy"));
        TestUtils$.MODULE$.assertLeader(this.client(), partition1, 2);
        TestUtils$.MODULE$.assertLeader(this.client(), partition2, 2);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testElectUncleanLeadersForOnePartition() {
        void $minus$greater$extension_$this;
        this.client_$eq(Admin.create(this.createConfig()));
        int broker1 = 1;
        int broker2 = 2;
        Seq assignment1 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{broker1, broker2}));
        TopicPartition partition1 = new TopicPartition("unclean-test-topic-1", 0);
        Tuple2[] tuple2Array = new Tuple2[1];
        Object object = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)partition1.partition()));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)assignment1);
        TestUtils$.MODULE$.createTopic(this.zkClient(), partition1.topic(), (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array))), (Seq<KafkaServer>)this.servers());
        TestUtils$.MODULE$.assertLeader(this.client(), partition1, broker1);
        ((KafkaServer)this.servers().apply(broker2)).shutdown();
        TestUtils$.MODULE$.waitForBrokersOutOfIsr(this.client(), (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partition1}))), (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{broker2}))));
        ((KafkaServer)this.servers().apply(broker1)).shutdown();
        TestUtils$.MODULE$.assertNoLeader(this.client(), partition1);
        ((KafkaServer)this.servers().apply(broker2)).startup();
        Assert.assertFalse((boolean)((Optional)((java.util.Map)this.client().electLeaders(ElectionType.UNCLEAN, (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((scala.collection.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partition1}))).asJava()).partitions().get()).get(partition1)).isPresent());
        TestUtils$.MODULE$.assertLeader(this.client(), partition1, broker2);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testElectUncleanLeadersForManyPartitions() {
        void $minus$greater$extension_$this;
        void $minus$greater$extension_$this2;
        this.client_$eq(Admin.create(this.createConfig()));
        int broker1 = 1;
        int broker2 = 2;
        Seq assignment1 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{broker1, broker2}));
        Seq assignment2 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{broker1, broker2}));
        String topic = "unclean-test-topic-1";
        TopicPartition partition1 = new TopicPartition(topic, 0);
        TopicPartition partition2 = new TopicPartition(topic, 1);
        Tuple2[] tuple2Array = new Tuple2[2];
        Object object = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)partition1.partition()));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)assignment1);
        Object object2 = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)partition2.partition()));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[1] = new Tuple2((Object)$minus$greater$extension_$this, (Object)assignment2);
        TestUtils$.MODULE$.createTopic(this.zkClient(), topic, (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array))), (Seq<KafkaServer>)this.servers());
        TestUtils$.MODULE$.assertLeader(this.client(), partition1, broker1);
        TestUtils$.MODULE$.assertLeader(this.client(), partition2, broker1);
        ((KafkaServer)this.servers().apply(broker2)).shutdown();
        TestUtils$.MODULE$.waitForBrokersOutOfIsr(this.client(), (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partition1, partition2}))), (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{broker2}))));
        ((KafkaServer)this.servers().apply(broker1)).shutdown();
        TestUtils$.MODULE$.assertNoLeader(this.client(), partition1);
        TestUtils$.MODULE$.assertNoLeader(this.client(), partition2);
        ((KafkaServer)this.servers().apply(broker2)).startup();
        ElectLeadersResult electResult = this.client().electLeaders(ElectionType.UNCLEAN, (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((scala.collection.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partition1, partition2}))).asJava());
        Assert.assertFalse((boolean)((Optional)((java.util.Map)electResult.partitions().get()).get(partition1)).isPresent());
        Assert.assertFalse((boolean)((Optional)((java.util.Map)electResult.partitions().get()).get(partition2)).isPresent());
        TestUtils$.MODULE$.assertLeader(this.client(), partition1, broker2);
        TestUtils$.MODULE$.assertLeader(this.client(), partition2, broker2);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testElectUncleanLeadersForAllPartitions() {
        void $minus$greater$extension_$this;
        void $minus$greater$extension_$this2;
        this.client_$eq(Admin.create(this.createConfig()));
        int broker1 = 1;
        int broker2 = 2;
        int broker3 = 0;
        Seq assignment1 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{broker1, broker2}));
        Seq assignment2 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{broker1, broker3}));
        String topic = "unclean-test-topic-1";
        TopicPartition partition1 = new TopicPartition(topic, 0);
        TopicPartition partition2 = new TopicPartition(topic, 1);
        Tuple2[] tuple2Array = new Tuple2[2];
        Object object = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)partition1.partition()));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)assignment1);
        Object object2 = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)partition2.partition()));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[1] = new Tuple2((Object)$minus$greater$extension_$this, (Object)assignment2);
        TestUtils$.MODULE$.createTopic(this.zkClient(), topic, (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array))), (Seq<KafkaServer>)this.servers());
        TestUtils$.MODULE$.assertLeader(this.client(), partition1, broker1);
        TestUtils$.MODULE$.assertLeader(this.client(), partition2, broker1);
        ((KafkaServer)this.servers().apply(broker2)).shutdown();
        TestUtils$.MODULE$.waitForBrokersOutOfIsr(this.client(), (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partition1}))), (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{broker2}))));
        ((KafkaServer)this.servers().apply(broker1)).shutdown();
        TestUtils$.MODULE$.assertNoLeader(this.client(), partition1);
        TestUtils$.MODULE$.assertLeader(this.client(), partition2, broker3);
        ((KafkaServer)this.servers().apply(broker2)).startup();
        ElectLeadersResult electResult = this.client().electLeaders(ElectionType.UNCLEAN, null);
        Assert.assertFalse((boolean)((Optional)((java.util.Map)electResult.partitions().get()).get(partition1)).isPresent());
        Assert.assertFalse((boolean)((java.util.Map)electResult.partitions().get()).containsKey(partition2));
        TestUtils$.MODULE$.assertLeader(this.client(), partition1, broker2);
        TestUtils$.MODULE$.assertLeader(this.client(), partition2, broker3);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testElectUncleanLeadersForUnknownPartitions() {
        void $minus$greater$extension_$this;
        this.client_$eq(Admin.create(this.createConfig()));
        int broker1 = 1;
        int broker2 = 2;
        Seq assignment1 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{broker1, broker2}));
        String topic = "unclean-test-topic-1";
        TopicPartition unknownPartition = new TopicPartition(topic, 1);
        TopicPartition unknownTopic = new TopicPartition("unknown-topic", 0);
        Tuple2[] tuple2Array = new Tuple2[1];
        Object object = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)assignment1);
        TestUtils$.MODULE$.createTopic(this.zkClient(), topic, (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array))), (Seq<KafkaServer>)this.servers());
        TestUtils$.MODULE$.assertLeader(this.client(), new TopicPartition(topic, 0), broker1);
        ElectLeadersResult electResult = this.client().electLeaders(ElectionType.UNCLEAN, (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((scala.collection.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{unknownPartition, unknownTopic}))).asJava());
        Assert.assertTrue((boolean)(((Optional)((java.util.Map)electResult.partitions().get()).get(unknownPartition)).get() instanceof UnknownTopicOrPartitionException));
        Assert.assertTrue((boolean)(((Optional)((java.util.Map)electResult.partitions().get()).get(unknownTopic)).get() instanceof UnknownTopicOrPartitionException));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testElectUncleanLeadersWhenNoLiveBrokers() {
        void $minus$greater$extension_$this;
        this.client_$eq(Admin.create(this.createConfig()));
        int broker1 = 1;
        int broker2 = 2;
        Seq assignment1 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{broker1, broker2}));
        String topic = "unclean-test-topic-1";
        TopicPartition partition1 = new TopicPartition(topic, 0);
        Tuple2[] tuple2Array = new Tuple2[1];
        Object object = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)partition1.partition()));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)assignment1);
        TestUtils$.MODULE$.createTopic(this.zkClient(), topic, (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array))), (Seq<KafkaServer>)this.servers());
        TestUtils$.MODULE$.assertLeader(this.client(), partition1, broker1);
        ((KafkaServer)this.servers().apply(broker2)).shutdown();
        TestUtils$.MODULE$.waitForBrokersOutOfIsr(this.client(), (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partition1}))), (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{broker2}))));
        ((KafkaServer)this.servers().apply(broker1)).shutdown();
        TestUtils$.MODULE$.assertNoLeader(this.client(), partition1);
        Assert.assertTrue((boolean)(((Optional)((java.util.Map)this.client().electLeaders(ElectionType.UNCLEAN, (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((scala.collection.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partition1}))).asJava()).partitions().get()).get(partition1)).get() instanceof EligibleLeadersNotAvailableException));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testElectUncleanLeadersNoop() {
        void $minus$greater$extension_$this;
        this.client_$eq(Admin.create(this.createConfig()));
        int broker1 = 1;
        int broker2 = 2;
        Seq assignment1 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{broker1, broker2}));
        String topic = "unclean-test-topic-1";
        TopicPartition partition1 = new TopicPartition(topic, 0);
        Tuple2[] tuple2Array = new Tuple2[1];
        Object object = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)partition1.partition()));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)assignment1);
        TestUtils$.MODULE$.createTopic(this.zkClient(), topic, (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array))), (Seq<KafkaServer>)this.servers());
        TestUtils$.MODULE$.assertLeader(this.client(), partition1, broker1);
        ((KafkaServer)this.servers().apply(broker1)).shutdown();
        TestUtils$.MODULE$.assertLeader(this.client(), partition1, broker2);
        ((KafkaServer)this.servers().apply(broker1)).startup();
        Assert.assertTrue((boolean)(((Optional)((java.util.Map)this.client().electLeaders(ElectionType.UNCLEAN, (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((scala.collection.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partition1}))).asJava()).partitions().get()).get(partition1)).get() instanceof ElectionNotNeededException));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testElectUncleanLeadersAndNoop() {
        void $minus$greater$extension_$this;
        void $minus$greater$extension_$this2;
        this.client_$eq(Admin.create(this.createConfig()));
        int broker1 = 1;
        int broker2 = 2;
        int broker3 = 0;
        Seq assignment1 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{broker1, broker2}));
        Seq assignment2 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{broker1, broker3}));
        String topic = "unclean-test-topic-1";
        TopicPartition partition1 = new TopicPartition(topic, 0);
        TopicPartition partition2 = new TopicPartition(topic, 1);
        Tuple2[] tuple2Array = new Tuple2[2];
        Object object = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)partition1.partition()));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)assignment1);
        Object object2 = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)partition2.partition()));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[1] = new Tuple2((Object)$minus$greater$extension_$this, (Object)assignment2);
        TestUtils$.MODULE$.createTopic(this.zkClient(), topic, (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array))), (Seq<KafkaServer>)this.servers());
        TestUtils$.MODULE$.assertLeader(this.client(), partition1, broker1);
        TestUtils$.MODULE$.assertLeader(this.client(), partition2, broker1);
        ((KafkaServer)this.servers().apply(broker2)).shutdown();
        TestUtils$.MODULE$.waitForBrokersOutOfIsr(this.client(), (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partition1}))), (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{broker2}))));
        ((KafkaServer)this.servers().apply(broker1)).shutdown();
        TestUtils$.MODULE$.assertNoLeader(this.client(), partition1);
        TestUtils$.MODULE$.assertLeader(this.client(), partition2, broker3);
        ((KafkaServer)this.servers().apply(broker2)).startup();
        ElectLeadersResult electResult = this.client().electLeaders(ElectionType.UNCLEAN, (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((scala.collection.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partition1, partition2}))).asJava());
        Assert.assertFalse((boolean)((Optional)((java.util.Map)electResult.partitions().get()).get(partition1)).isPresent());
        Assert.assertTrue((boolean)(((Optional)((java.util.Map)electResult.partitions().get()).get(partition2)).get() instanceof ElectionNotNeededException));
        TestUtils$.MODULE$.assertLeader(this.client(), partition1, broker2);
        TestUtils$.MODULE$.assertLeader(this.client(), partition2, broker3);
    }

    @Test
    public void testListReassignmentsDoesNotShowNonReassigningPartitions() {
        this.client_$eq(Admin.create(this.createConfig()));
        String topic = "list-reassignments-no-reassignments";
        this.createTopic(topic, 1, 3, this.createTopic$default$4());
        TopicPartition tp = new TopicPartition(topic, 0);
        java.util.Map reassignmentsMap = (java.util.Map)this.client().listPartitionReassignments((java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((scala.collection.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp}))).asJava()).reassignments().get();
        Assert.assertEquals((long)0L, (long)reassignmentsMap.size());
        java.util.Map allReassignmentsMap = (java.util.Map)this.client().listPartitionReassignments().reassignments().get();
        Assert.assertEquals((long)0L, (long)allReassignmentsMap.size());
    }

    @Test
    public void testListReassignmentsDoesNotShowDeletedPartitions() {
        this.client_$eq(Admin.create(this.createConfig()));
        String topic = "list-reassignments-no-reassignments";
        TopicPartition tp = new TopicPartition(topic, 0);
        java.util.Map reassignmentsMap = (java.util.Map)this.client().listPartitionReassignments((java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((scala.collection.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp}))).asJava()).reassignments().get();
        Assert.assertEquals((long)0L, (long)reassignmentsMap.size());
        java.util.Map allReassignmentsMap = (java.util.Map)this.client().listPartitionReassignments().reassignments().get();
        Assert.assertEquals((long)0L, (long)allReassignmentsMap.size());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testValidIncrementalAlterConfigs() {
        void $minus$greater$extension_$this;
        void $minus$greater$extension_$this2;
        void $minus$greater$extension_$this3;
        void $minus$greater$extension_$this4;
        void $minus$greater$extension_$this5;
        this.client_$eq(Admin.create(this.createConfig()));
        String topic1 = "incremental-alter-configs-topic-1";
        ConfigResource topic1Resource = new ConfigResource(ConfigResource.Type.TOPIC, topic1);
        Properties topic1CreateConfigs = new Properties();
        topic1CreateConfigs.setProperty(LogConfig$.MODULE$.RetentionMsProp(), "60000000");
        topic1CreateConfigs.setProperty(LogConfig$.MODULE$.CleanupPolicyProp(), LogConfig$.MODULE$.Compact());
        this.createTopic(topic1, 1, 1, topic1CreateConfigs);
        String topic2 = "incremental-alter-configs-topic-2";
        ConfigResource topic2Resource = new ConfigResource(ConfigResource.Type.TOPIC, topic2);
        this.createTopic(topic2, this.createTopic$default$2(), this.createTopic$default$3(), this.createTopic$default$4());
        Collection topic1AlterConfigs = JavaConverters$.MODULE$.asJavaCollectionConverter((Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AlterConfigOp[]{new AlterConfigOp(new ConfigEntry(LogConfig$.MODULE$.FlushMsProp(), "1000"), AlterConfigOp.OpType.SET), new AlterConfigOp(new ConfigEntry(LogConfig$.MODULE$.CleanupPolicyProp(), LogConfig$.MODULE$.Delete()), AlterConfigOp.OpType.APPEND), new AlterConfigOp(new ConfigEntry(LogConfig$.MODULE$.RetentionMsProp(), ""), AlterConfigOp.OpType.DELETE)}))).asJavaCollection();
        Collection topic2AlterConfigs = JavaConverters$.MODULE$.asJavaCollectionConverter((Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AlterConfigOp[]{new AlterConfigOp(new ConfigEntry(LogConfig$.MODULE$.MinCleanableDirtyRatioProp(), "0.9"), AlterConfigOp.OpType.SET), new AlterConfigOp(new ConfigEntry(LogConfig$.MODULE$.CompressionTypeProp(), "lz4"), AlterConfigOp.OpType.SET)}))).asJavaCollection();
        Tuple2[] tuple2Array = new Tuple2[2];
        Object object = Predef$.MODULE$.ArrowAssoc((Object)topic1Resource);
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this5, (Object)topic1AlterConfigs);
        Object object2 = Predef$.MODULE$.ArrowAssoc((Object)topic2Resource);
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[1] = new Tuple2((Object)$minus$greater$extension_$this4, (Object)topic2AlterConfigs);
        AlterConfigsResult alterResult = this.client().incrementalAlterConfigs((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array))).asJava());
        Assert.assertEquals((Object)JavaConverters$.MODULE$.setAsJavaSetConverter((scala.collection.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ConfigResource[]{topic1Resource, topic2Resource}))).asJava(), alterResult.values().keySet());
        alterResult.all().get();
        java.util.Map configs = (java.util.Map)this.client().describeConfigs((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ConfigResource[]{topic1Resource, topic2Resource}))).asJava()).all().get();
        Assert.assertEquals((long)2L, (long)configs.size());
        Assert.assertEquals((Object)"1000", (Object)((Config)configs.get(topic1Resource)).get(LogConfig$.MODULE$.FlushMsProp()).value());
        Assert.assertEquals((Object)"compact,delete", (Object)((Config)configs.get(topic1Resource)).get(LogConfig$.MODULE$.CleanupPolicyProp()).value());
        Assert.assertEquals((Object)((Object)BoxesRunTime.boxToInteger((int)(Defaults$.MODULE$.LogRetentionHours() * 60 * 60 * 1000))).toString(), (Object)((Config)configs.get(topic1Resource)).get(LogConfig$.MODULE$.RetentionMsProp()).value());
        Assert.assertEquals((Object)"0.9", (Object)((Config)configs.get(topic2Resource)).get(LogConfig$.MODULE$.MinCleanableDirtyRatioProp()).value());
        Assert.assertEquals((Object)"lz4", (Object)((Config)configs.get(topic2Resource)).get(LogConfig$.MODULE$.CompressionTypeProp()).value());
        topic1AlterConfigs = (Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AlterConfigOp[]{new AlterConfigOp(new ConfigEntry(LogConfig$.MODULE$.CleanupPolicyProp(), LogConfig$.MODULE$.Compact()), AlterConfigOp.OpType.SUBTRACT)}))).asJava();
        Tuple2[] tuple2Array2 = new Tuple2[1];
        Object object3 = Predef$.MODULE$.ArrowAssoc((Object)topic1Resource);
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array2[0] = new Tuple2((Object)$minus$greater$extension_$this3, (Object)topic1AlterConfigs);
        alterResult = this.client().incrementalAlterConfigs((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array2))).asJava());
        alterResult.all().get();
        configs = (java.util.Map)this.client().describeConfigs((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ConfigResource[]{topic1Resource}))).asJava()).all().get();
        Assert.assertEquals((Object)"delete", (Object)((Config)configs.get(topic1Resource)).get(LogConfig$.MODULE$.CleanupPolicyProp()).value());
        Assert.assertEquals((Object)"1000", (Object)((Config)configs.get(topic1Resource)).get(LogConfig$.MODULE$.FlushMsProp()).value());
        topic1AlterConfigs = (Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AlterConfigOp[]{new AlterConfigOp(new ConfigEntry(LogConfig$.MODULE$.CleanupPolicyProp(), LogConfig$.MODULE$.Compact()), AlterConfigOp.OpType.APPEND)}))).asJava();
        Tuple2[] tuple2Array3 = new Tuple2[1];
        Object object4 = Predef$.MODULE$.ArrowAssoc((Object)topic1Resource);
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array3[0] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)topic1AlterConfigs);
        alterResult = this.client().incrementalAlterConfigs((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array3))).asJava(), new AlterConfigsOptions().validateOnly(true));
        alterResult.all().get();
        configs = (java.util.Map)this.client().describeConfigs((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ConfigResource[]{topic1Resource}))).asJava()).all().get();
        Assert.assertEquals((Object)"delete", (Object)((Config)configs.get(topic1Resource)).get(LogConfig$.MODULE$.CleanupPolicyProp()).value());
        topic1AlterConfigs = (Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AlterConfigOp[]{new AlterConfigOp(new ConfigEntry(LogConfig$.MODULE$.CompressionTypeProp(), "zip"), AlterConfigOp.OpType.SET)}))).asJava();
        Tuple2[] tuple2Array4 = new Tuple2[1];
        Object object5 = Predef$.MODULE$.ArrowAssoc((Object)topic1Resource);
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array4[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)topic1AlterConfigs);
        alterResult = this.client().incrementalAlterConfigs((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array4))).asJava(), new AlterConfigsOptions().validateOnly(true));
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals((KafkaFuture)alterResult.values().get(topic1Resource), InvalidRequestException.class, (Option<String>)new Some((Object)"Invalid config value for resource"));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testInvalidIncrementalAlterConfigs() {
        void $minus$greater$extension_$this;
        void $minus$greater$extension_$this2;
        void $minus$greater$extension_$this3;
        void $minus$greater$extension_$this4;
        void $minus$greater$extension_$this5;
        this.client_$eq(Admin.create(this.createConfig()));
        String topic1 = "incremental-alter-configs-topic-1";
        ConfigResource topic1Resource = new ConfigResource(ConfigResource.Type.TOPIC, topic1);
        this.createTopic(topic1, this.createTopic$default$2(), this.createTopic$default$3(), this.createTopic$default$4());
        String topic2 = "incremental-alter-configs-topic-2";
        ConfigResource topic2Resource = new ConfigResource(ConfigResource.Type.TOPIC, topic2);
        this.createTopic(topic2, this.createTopic$default$2(), this.createTopic$default$3(), this.createTopic$default$4());
        Collection topic1AlterConfigs = JavaConverters$.MODULE$.asJavaCollectionConverter((Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AlterConfigOp[]{new AlterConfigOp(new ConfigEntry(LogConfig$.MODULE$.MinCleanableDirtyRatioProp(), "0.75"), AlterConfigOp.OpType.SET), new AlterConfigOp(new ConfigEntry(LogConfig$.MODULE$.MinCleanableDirtyRatioProp(), "0.65"), AlterConfigOp.OpType.SET), new AlterConfigOp(new ConfigEntry(LogConfig$.MODULE$.CompressionTypeProp(), "gzip"), AlterConfigOp.OpType.SET)}))).asJavaCollection();
        Collection topic2AlterConfigs = JavaConverters$.MODULE$.asJavaCollectionConverter((Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AlterConfigOp[]{new AlterConfigOp(new ConfigEntry(LogConfig$.MODULE$.MinCleanableDirtyRatioProp(), "0.9"), AlterConfigOp.OpType.SET)}))).asJavaCollection();
        Tuple2[] tuple2Array = new Tuple2[2];
        Object object = Predef$.MODULE$.ArrowAssoc((Object)topic1Resource);
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this5, (Object)topic1AlterConfigs);
        Object object2 = Predef$.MODULE$.ArrowAssoc((Object)topic2Resource);
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[1] = new Tuple2((Object)$minus$greater$extension_$this4, (Object)topic2AlterConfigs);
        AlterConfigsResult alterResult = this.client().incrementalAlterConfigs((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array))).asJava());
        Assert.assertEquals((Object)JavaConverters$.MODULE$.setAsJavaSetConverter((scala.collection.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ConfigResource[]{topic1Resource, topic2Resource}))).asJava(), alterResult.values().keySet());
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals((KafkaFuture)alterResult.values().get(topic1Resource), InvalidRequestException.class, (Option<String>)new Some((Object)"Error due to duplicate config keys"));
        ((KafkaFuture)alterResult.values().get(topic2Resource)).get();
        java.util.Map configs = (java.util.Map)this.client().describeConfigs((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ConfigResource[]{topic1Resource, topic2Resource}))).asJava()).all().get();
        Assert.assertEquals((long)2L, (long)configs.size());
        Assert.assertEquals((Object)((Object)BoxesRunTime.boxToDouble((double)Defaults$.MODULE$.LogCleanerMinCleanRatio())).toString(), (Object)((Config)configs.get(topic1Resource)).get(LogConfig$.MODULE$.MinCleanableDirtyRatioProp()).value());
        Assert.assertEquals((Object)Defaults$.MODULE$.CompressionType().toString(), (Object)((Config)configs.get(topic1Resource)).get(LogConfig$.MODULE$.CompressionTypeProp()).value());
        Assert.assertEquals((Object)"0.9", (Object)((Config)configs.get(topic2Resource)).get(LogConfig$.MODULE$.MinCleanableDirtyRatioProp()).value());
        topic1AlterConfigs = JavaConverters$.MODULE$.asJavaCollectionConverter((Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AlterConfigOp[]{new AlterConfigOp(new ConfigEntry(LogConfig$.MODULE$.CompressionTypeProp(), "gzip"), AlterConfigOp.OpType.APPEND)}))).asJavaCollection();
        topic2AlterConfigs = JavaConverters$.MODULE$.asJavaCollectionConverter((Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AlterConfigOp[]{new AlterConfigOp(new ConfigEntry(LogConfig$.MODULE$.CompressionTypeProp(), "snappy"), AlterConfigOp.OpType.SUBTRACT)}))).asJavaCollection();
        Tuple2[] tuple2Array2 = new Tuple2[2];
        Object object3 = Predef$.MODULE$.ArrowAssoc((Object)topic1Resource);
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array2[0] = new Tuple2((Object)$minus$greater$extension_$this3, (Object)topic1AlterConfigs);
        Object object4 = Predef$.MODULE$.ArrowAssoc((Object)topic2Resource);
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array2[1] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)topic2AlterConfigs);
        alterResult = this.client().incrementalAlterConfigs((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array2))).asJava());
        Assert.assertEquals((Object)JavaConverters$.MODULE$.setAsJavaSetConverter((scala.collection.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ConfigResource[]{topic1Resource, topic2Resource}))).asJava(), alterResult.values().keySet());
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals((KafkaFuture)alterResult.values().get(topic1Resource), InvalidRequestException.class, (Option<String>)new Some((Object)"Config value append is not allowed for config"));
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals((KafkaFuture)alterResult.values().get(topic2Resource), InvalidRequestException.class, (Option<String>)new Some((Object)"Config value subtract is not allowed for config"));
        topic1AlterConfigs = JavaConverters$.MODULE$.asJavaCollectionConverter((Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AlterConfigOp[]{new AlterConfigOp(new ConfigEntry(LogConfig$.MODULE$.MinCleanableDirtyRatioProp(), "1.1"), AlterConfigOp.OpType.SET)}))).asJavaCollection();
        Tuple2[] tuple2Array3 = new Tuple2[1];
        Object object5 = Predef$.MODULE$.ArrowAssoc((Object)topic1Resource);
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array3[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)topic1AlterConfigs);
        alterResult = this.client().incrementalAlterConfigs((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array3))).asJava());
        Assert.assertEquals((Object)JavaConverters$.MODULE$.setAsJavaSetConverter((scala.collection.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ConfigResource[]{topic1Resource}))).asJava(), alterResult.values().keySet());
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals((KafkaFuture)alterResult.values().get(topic1Resource), InvalidRequestException.class, (Option<String>)new Some((Object)"Invalid config value for resource"));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testInvalidAlterPartitionReassignments() {
        void $minus$greater$extension_$this;
        void $minus$greater$extension_$this2;
        void $minus$greater$extension_$this3;
        void $minus$greater$extension_$this4;
        void $minus$greater$extension_$this5;
        void $minus$greater$extension_$this6;
        void $minus$greater$extension_$this7;
        void $minus$greater$extension_$this8;
        this.client_$eq(Admin.create(this.createConfig()));
        String topic = "alter-reassignments-topic-1";
        TopicPartition tp1 = new TopicPartition(topic, 0);
        TopicPartition tp2 = new TopicPartition(topic, 1);
        TopicPartition tp3 = new TopicPartition(topic, 2);
        this.createTopic(topic, 4, this.createTopic$default$3(), this.createTopic$default$4());
        int n = 0;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        Optional<NewPartitionReassignment> validAssignment = Optional.of(new NewPartitionReassignment((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)RichInt$.MODULE$.until$extension0(n, this.brokerCount()).map((Function1 & Serializable & scala.Serializable)x$17 -> PlaintextAdminIntegrationTest.$anonfun$testInvalidAlterPartitionReassignments$1(BoxesRunTime.unboxToInt((Object)x$17)), IndexedSeq$.MODULE$.canBuildFrom())).asJava()));
        TopicPartition nonExistentTp1 = new TopicPartition("topicA", 0);
        TopicPartition nonExistentTp2 = new TopicPartition(topic, 4);
        Tuple2[] tuple2Array = new Tuple2[5];
        Object object = Predef$.MODULE$.ArrowAssoc((Object)tp1);
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this8, validAssignment);
        Object object2 = Predef$.MODULE$.ArrowAssoc((Object)tp2);
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[1] = new Tuple2((Object)$minus$greater$extension_$this7, validAssignment);
        Object object3 = Predef$.MODULE$.ArrowAssoc((Object)tp3);
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[2] = new Tuple2((Object)$minus$greater$extension_$this6, validAssignment);
        Object object4 = Predef$.MODULE$.ArrowAssoc((Object)nonExistentTp1);
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[3] = new Tuple2((Object)$minus$greater$extension_$this5, validAssignment);
        Object object5 = Predef$.MODULE$.ArrowAssoc((Object)nonExistentTp2);
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[4] = new Tuple2((Object)$minus$greater$extension_$this4, validAssignment);
        java.util.Map nonExistentPartitionsResult = this.client().alterPartitionReassignments((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array))).asJava()).values();
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals((KafkaFuture)nonExistentPartitionsResult.get(nonExistentTp1), UnknownTopicOrPartitionException.class, TestUtils$.MODULE$.assertFutureExceptionTypeEquals$default$3());
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals((KafkaFuture)nonExistentPartitionsResult.get(nonExistentTp2), UnknownTopicOrPartitionException.class, TestUtils$.MODULE$.assertFutureExceptionTypeEquals$default$3());
        int n2 = 0;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        Optional<NewPartitionReassignment> extraNonExistentReplica = Optional.of(new NewPartitionReassignment((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)RichInt$.MODULE$.until$extension0(n2, this.brokerCount() + 1).map((Function1 & Serializable & scala.Serializable)x$18 -> PlaintextAdminIntegrationTest.$anonfun$testInvalidAlterPartitionReassignments$2(BoxesRunTime.unboxToInt((Object)x$18)), IndexedSeq$.MODULE$.canBuildFrom())).asJava()));
        Optional<NewPartitionReassignment> negativeIdReplica = Optional.of(new NewPartitionReassignment((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{-3, -2, -1}))).map((Function1 & Serializable & scala.Serializable)x$19 -> PlaintextAdminIntegrationTest.$anonfun$testInvalidAlterPartitionReassignments$3(BoxesRunTime.unboxToInt((Object)x$19)), Seq$.MODULE$.canBuildFrom())).asJava()));
        Optional<NewPartitionReassignment> duplicateReplica = Optional.of(new NewPartitionReassignment((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 1}))).map((Function1 & Serializable & scala.Serializable)x$20 -> PlaintextAdminIntegrationTest.$anonfun$testInvalidAlterPartitionReassignments$4(BoxesRunTime.unboxToInt((Object)x$20)), Seq$.MODULE$.canBuildFrom())).asJava()));
        Tuple2[] tuple2Array2 = new Tuple2[3];
        Object object6 = Predef$.MODULE$.ArrowAssoc((Object)tp1);
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array2[0] = new Tuple2((Object)$minus$greater$extension_$this3, extraNonExistentReplica);
        Object object7 = Predef$.MODULE$.ArrowAssoc((Object)tp2);
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array2[1] = new Tuple2((Object)$minus$greater$extension_$this2, negativeIdReplica);
        Object object8 = Predef$.MODULE$.ArrowAssoc((Object)tp3);
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array2[2] = new Tuple2((Object)$minus$greater$extension_$this, duplicateReplica);
        java.util.Map invalidReplicaResult = this.client().alterPartitionReassignments((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array2))).asJava()).values();
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals((KafkaFuture)invalidReplicaResult.get(tp1), InvalidReplicaAssignmentException.class, TestUtils$.MODULE$.assertFutureExceptionTypeEquals$default$3());
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals((KafkaFuture)invalidReplicaResult.get(tp2), InvalidReplicaAssignmentException.class, TestUtils$.MODULE$.assertFutureExceptionTypeEquals$default$3());
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals((KafkaFuture)invalidReplicaResult.get(tp3), InvalidReplicaAssignmentException.class, TestUtils$.MODULE$.assertFutureExceptionTypeEquals$default$3());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testLongTopicNames() {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        Admin client = Admin.create(this.createConfig());
        String longTopicName = String.join((CharSequence)"", Collections.nCopies(249, "x"));
        String invalidTopicName = String.join((CharSequence)"", Collections.nCopies(250, "x"));
        Seq newTopics2 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NewTopic[]{new NewTopic(invalidTopicName, 3, (short)3), new NewTopic(longTopicName, 3, (short)3)}));
        java.util.Map results = client.createTopics((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(newTopics2).asJava()).values();
        Assert.assertTrue((boolean)results.containsKey(longTopicName));
        ((KafkaFuture)results.get(longTopicName)).get();
        Assert.assertTrue((boolean)results.containsKey(invalidTopicName));
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals((KafkaFuture)results.get(invalidTopicName), InvalidTopicException.class, TestUtils$.MODULE$.assertFutureExceptionTypeEquals$default$3());
        Tuple2[] tuple2Array = new Tuple2[1];
        Object object = ((KafkaServer)this.servers().apply(0)).config().logDirs().apply(0);
        Object object2 = Predef$.MODULE$.ArrowAssoc((Object)new TopicPartitionReplica(longTopicName, 0, 0));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals(client.alterReplicaLogDirs((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array))).asJava()).all(), InvalidTopicException.class, TestUtils$.MODULE$.assertFutureExceptionTypeEquals$default$3());
        client.close();
    }

    @Test
    public void testDescribeConfigsForLog4jLogLevels() {
        this.client_$eq(Admin.create(this.createConfig()));
        Config loggerConfig = this.describeBrokerLoggers();
        String rootLogLevel = loggerConfig.get(Log4jController$.MODULE$.ROOT_LOGGER()).value();
        ConfigEntry logCleanerLogLevelConfig = loggerConfig.get("kafka.cluster.Replica");
        Assert.assertEquals((Object)rootLogLevel, (Object)logCleanerLogLevelConfig.value());
        Assert.assertEquals((Object)"kafka.cluster.Replica", (Object)logCleanerLogLevelConfig.name());
        Assert.assertEquals((Object)ConfigEntry.ConfigSource.DYNAMIC_BROKER_LOGGER_CONFIG, (Object)logCleanerLogLevelConfig.source());
        Assert.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)logCleanerLogLevelConfig.isReadOnly()));
        Assert.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)logCleanerLogLevelConfig.isSensitive()));
        Assert.assertTrue((boolean)logCleanerLogLevelConfig.synonyms().isEmpty());
    }

    @Test
    @Ignore
    public void testIncrementalAlterConfigsForLog4jLogLevels() {
        this.client_$eq(Admin.create(this.createConfig()));
        Config initialLoggerConfig = this.describeBrokerLoggers();
        String initialRootLogLevel = initialLoggerConfig.get(Log4jController$.MODULE$.ROOT_LOGGER()).value();
        Assert.assertEquals((Object)initialRootLogLevel, (Object)initialLoggerConfig.get("kafka.controller.KafkaController").value());
        Assert.assertEquals((Object)initialRootLogLevel, (Object)initialLoggerConfig.get("kafka.log.LogCleaner").value());
        Assert.assertEquals((Object)initialRootLogLevel, (Object)initialLoggerConfig.get("kafka.server.ReplicaManager").value());
        String newRootLogLevel = "DEBUG";
        Collection alterRootLoggerEntry = JavaConverters$.MODULE$.asJavaCollectionConverter((Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AlterConfigOp[]{new AlterConfigOp(new ConfigEntry(Log4jController$.MODULE$.ROOT_LOGGER(), newRootLogLevel), AlterConfigOp.OpType.SET)}))).asJavaCollection();
        this.alterBrokerLoggers(alterRootLoggerEntry, true);
        Config validatedLoggerConfig = this.describeBrokerLoggers();
        Assert.assertEquals((Object)initialRootLogLevel, (Object)validatedLoggerConfig.get(Log4jController$.MODULE$.ROOT_LOGGER()).value());
        Assert.assertEquals((Object)initialRootLogLevel, (Object)validatedLoggerConfig.get("kafka.controller.KafkaController").value());
        Assert.assertEquals((Object)initialRootLogLevel, (Object)validatedLoggerConfig.get("kafka.log.LogCleaner").value());
        Assert.assertEquals((Object)initialRootLogLevel, (Object)validatedLoggerConfig.get("kafka.server.ReplicaManager").value());
        Assert.assertEquals((Object)initialRootLogLevel, (Object)validatedLoggerConfig.get("kafka.zookeeper.ZooKeeperClient").value());
        this.alterBrokerLoggers(alterRootLoggerEntry, this.alterBrokerLoggers$default$2());
        Config changedRootLoggerConfig = this.describeBrokerLoggers();
        Assert.assertEquals((Object)newRootLogLevel, (Object)changedRootLoggerConfig.get(Log4jController$.MODULE$.ROOT_LOGGER()).value());
        Assert.assertEquals((Object)newRootLogLevel, (Object)changedRootLoggerConfig.get("kafka.controller.KafkaController").value());
        Assert.assertEquals((Object)newRootLogLevel, (Object)changedRootLoggerConfig.get("kafka.log.LogCleaner").value());
        Assert.assertEquals((Object)newRootLogLevel, (Object)changedRootLoggerConfig.get("kafka.server.ReplicaManager").value());
        Assert.assertEquals((Object)newRootLogLevel, (Object)changedRootLoggerConfig.get("kafka.zookeeper.ZooKeeperClient").value());
        Collection alterZKLoggerEntry = JavaConverters$.MODULE$.asJavaCollectionConverter((Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AlterConfigOp[]{new AlterConfigOp(new ConfigEntry("kafka.zookeeper.ZooKeeperClient", "ERROR"), AlterConfigOp.OpType.SET)}))).asJavaCollection();
        this.alterBrokerLoggers(alterZKLoggerEntry, this.alterBrokerLoggers$default$2());
        Config changedZKLoggerConfig = this.describeBrokerLoggers();
        Assert.assertEquals((Object)"ERROR", (Object)changedZKLoggerConfig.get("kafka.zookeeper.ZooKeeperClient").value());
        Collection alterLogLevelsEntries = JavaConverters$.MODULE$.asJavaCollectionConverter((Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AlterConfigOp[]{new AlterConfigOp(new ConfigEntry("kafka.controller.KafkaController", "INFO"), AlterConfigOp.OpType.SET), new AlterConfigOp(new ConfigEntry("kafka.log.LogCleaner", "ERROR"), AlterConfigOp.OpType.SET), new AlterConfigOp(new ConfigEntry("kafka.server.ReplicaManager", "TRACE"), AlterConfigOp.OpType.SET), new AlterConfigOp(new ConfigEntry("kafka.zookeeper.ZooKeeperClient", ""), AlterConfigOp.OpType.DELETE)}))).asJavaCollection();
        this.alterBrokerLoggers(alterLogLevelsEntries, this.alterBrokerLoggers$default$2());
        Config alteredLoggerConfig = this.describeBrokerLoggers();
        Assert.assertEquals((Object)newRootLogLevel, (Object)alteredLoggerConfig.get(Log4jController$.MODULE$.ROOT_LOGGER()).value());
        Assert.assertEquals((Object)"INFO", (Object)alteredLoggerConfig.get("kafka.controller.KafkaController").value());
        Assert.assertEquals((Object)"ERROR", (Object)alteredLoggerConfig.get("kafka.log.LogCleaner").value());
        Assert.assertEquals((Object)"TRACE", (Object)alteredLoggerConfig.get("kafka.server.ReplicaManager").value());
        Assert.assertEquals((Object)newRootLogLevel, (Object)alteredLoggerConfig.get("kafka.zookeeper.ZooKeeperClient").value());
    }

    @Test
    @Ignore
    public void testIncrementalAlterConfigsForLog4jLogLevelsCanResetLoggerToCurrentRoot() {
        this.client_$eq(Admin.create(this.createConfig()));
        String initialRootLogLevel = "TRACE";
        Collection alterRootLoggerEntry = JavaConverters$.MODULE$.asJavaCollectionConverter((Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AlterConfigOp[]{new AlterConfigOp(new ConfigEntry(Log4jController$.MODULE$.ROOT_LOGGER(), initialRootLogLevel), AlterConfigOp.OpType.SET)}))).asJavaCollection();
        this.alterBrokerLoggers(alterRootLoggerEntry, this.alterBrokerLoggers$default$2());
        Config initialLoggerConfig = this.describeBrokerLoggers();
        Assert.assertEquals((Object)initialRootLogLevel, (Object)initialLoggerConfig.get(Log4jController$.MODULE$.ROOT_LOGGER()).value());
        Assert.assertEquals((Object)initialRootLogLevel, (Object)initialLoggerConfig.get("kafka.controller.KafkaController").value());
        Collection alterControllerLoggerEntry = JavaConverters$.MODULE$.asJavaCollectionConverter((Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AlterConfigOp[]{new AlterConfigOp(new ConfigEntry("kafka.controller.KafkaController", "INFO"), AlterConfigOp.OpType.SET)}))).asJavaCollection();
        this.alterBrokerLoggers(alterControllerLoggerEntry, this.alterBrokerLoggers$default$2());
        Config changedControllerLoggerConfig = this.describeBrokerLoggers();
        Assert.assertEquals((Object)initialRootLogLevel, (Object)changedControllerLoggerConfig.get(Log4jController$.MODULE$.ROOT_LOGGER()).value());
        Assert.assertEquals((Object)"INFO", (Object)changedControllerLoggerConfig.get("kafka.controller.KafkaController").value());
        Collection deleteControllerLoggerEntry = JavaConverters$.MODULE$.asJavaCollectionConverter((Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AlterConfigOp[]{new AlterConfigOp(new ConfigEntry("kafka.controller.KafkaController", ""), AlterConfigOp.OpType.DELETE)}))).asJavaCollection();
        this.alterBrokerLoggers(deleteControllerLoggerEntry, this.alterBrokerLoggers$default$2());
        Config deletedControllerLoggerConfig = this.describeBrokerLoggers();
        Assert.assertEquals((Object)initialRootLogLevel, (Object)deletedControllerLoggerConfig.get(Log4jController$.MODULE$.ROOT_LOGGER()).value());
        Assert.assertEquals((Object)initialRootLogLevel, (Object)deletedControllerLoggerConfig.get("kafka.controller.KafkaController").value());
        String newRootLogLevel = "ERROR";
        Collection newAlterRootLoggerEntry = JavaConverters$.MODULE$.asJavaCollectionConverter((Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AlterConfigOp[]{new AlterConfigOp(new ConfigEntry(Log4jController$.MODULE$.ROOT_LOGGER(), newRootLogLevel), AlterConfigOp.OpType.SET)}))).asJavaCollection();
        this.alterBrokerLoggers(newAlterRootLoggerEntry, this.alterBrokerLoggers$default$2());
        Config newRootLoggerConfig = this.describeBrokerLoggers();
        Assert.assertEquals((Object)newRootLogLevel, (Object)newRootLoggerConfig.get(Log4jController$.MODULE$.ROOT_LOGGER()).value());
        Assert.assertEquals((Object)newRootLogLevel, (Object)newRootLoggerConfig.get("kafka.controller.KafkaController").value());
    }

    @Test
    @Ignore
    public void testIncrementalAlterConfigsForLog4jLogLevelsCannotResetRootLogger() {
        this.client_$eq(Admin.create(this.createConfig()));
        Collection deleteRootLoggerEntry = JavaConverters$.MODULE$.asJavaCollectionConverter((Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AlterConfigOp[]{new AlterConfigOp(new ConfigEntry(Log4jController$.MODULE$.ROOT_LOGGER(), ""), AlterConfigOp.OpType.DELETE)}))).asJavaCollection();
        Assert.assertTrue((boolean)(((Throwable)Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.alterBrokerLoggers(deleteRootLoggerEntry, this.alterBrokerLoggers$default$2()), ClassTag$.MODULE$.apply(ExecutionException.class), new Position("PlaintextAdminIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1998))).getCause() instanceof InvalidRequestException));
    }

    @Test
    @Ignore
    public void testIncrementalAlterConfigsForLog4jLogLevelsDoesNotWorkWithInvalidConfigs() {
        this.client_$eq(Admin.create(this.createConfig()));
        String validLoggerName = "kafka.server.KafkaRequestHandler";
        ConfigEntry expectedValidLoggerLogLevel = this.describeBrokerLoggers().get(validLoggerName);
        Collection appendLogLevelEntries = JavaConverters$.MODULE$.asJavaCollectionConverter((Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AlterConfigOp[]{new AlterConfigOp(new ConfigEntry("kafka.server.KafkaRequestHandler", "INFO"), AlterConfigOp.OpType.SET), new AlterConfigOp(new ConfigEntry("kafka.network.SocketServer", "ERROR"), AlterConfigOp.OpType.APPEND)}))).asJavaCollection();
        Assert.assertTrue((boolean)(((Throwable)Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.alterBrokerLoggers(appendLogLevelEntries, this.alterBrokerLoggers$default$2()), ClassTag$.MODULE$.apply(ExecutionException.class), new Position("PlaintextAdminIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2018))).getCause() instanceof InvalidRequestException));
        this.assertLogLevelDidNotChange$1(expectedValidLoggerLogLevel, validLoggerName);
        Collection subtractLogLevelEntries = JavaConverters$.MODULE$.asJavaCollectionConverter((Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AlterConfigOp[]{new AlterConfigOp(new ConfigEntry("kafka.server.KafkaRequestHandler", "INFO"), AlterConfigOp.OpType.SET), new AlterConfigOp(new ConfigEntry("kafka.network.SocketServer", "ERROR"), AlterConfigOp.OpType.SUBTRACT)}))).asJavaCollection();
        Assert.assertTrue((boolean)(((Throwable)Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.alterBrokerLoggers(subtractLogLevelEntries, this.alterBrokerLoggers$default$2()), ClassTag$.MODULE$.apply(ExecutionException.class), new Position("PlaintextAdminIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2025))).getCause() instanceof InvalidRequestException));
        this.assertLogLevelDidNotChange$1(expectedValidLoggerLogLevel, validLoggerName);
        Collection invalidLogLevelLogLevelEntries = JavaConverters$.MODULE$.asJavaCollectionConverter((Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AlterConfigOp[]{new AlterConfigOp(new ConfigEntry("kafka.server.KafkaRequestHandler", "INFO"), AlterConfigOp.OpType.SET), new AlterConfigOp(new ConfigEntry("kafka.network.SocketServer", "OFF"), AlterConfigOp.OpType.SET)}))).asJavaCollection();
        Assert.assertTrue((boolean)(((Throwable)Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.alterBrokerLoggers(invalidLogLevelLogLevelEntries, this.alterBrokerLoggers$default$2()), ClassTag$.MODULE$.apply(ExecutionException.class), new Position("PlaintextAdminIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2032))).getCause() instanceof InvalidRequestException));
        this.assertLogLevelDidNotChange$1(expectedValidLoggerLogLevel, validLoggerName);
        Collection invalidLoggerNameLogLevelEntries = JavaConverters$.MODULE$.asJavaCollectionConverter((Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AlterConfigOp[]{new AlterConfigOp(new ConfigEntry("kafka.server.KafkaRequestHandler", "INFO"), AlterConfigOp.OpType.SET), new AlterConfigOp(new ConfigEntry("Some Other LogCleaner", "ERROR"), AlterConfigOp.OpType.SET)}))).asJavaCollection();
        Assert.assertTrue((boolean)(((Throwable)Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.alterBrokerLoggers(invalidLoggerNameLogLevelEntries, this.alterBrokerLoggers$default$2()), ClassTag$.MODULE$.apply(ExecutionException.class), new Position("PlaintextAdminIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2039))).getCause() instanceof InvalidRequestException));
        this.assertLogLevelDidNotChange$1(expectedValidLoggerLogLevel, validLoggerName);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    @Ignore
    public void testAlterConfigsForLog4jLogLevelsDoesNotWork() {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        this.client_$eq(Admin.create(this.createConfig()));
        Collection alterLogLevelsEntries = JavaConverters$.MODULE$.asJavaCollectionConverter((Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ConfigEntry[]{new ConfigEntry("kafka.controller.KafkaController", "INFO")}))).asJavaCollection();
        Tuple2[] tuple2Array = new Tuple2[1];
        Config config = new Config(alterLogLevelsEntries);
        Object object = Predef$.MODULE$.ArrowAssoc((Object)this.brokerLoggerConfigResource());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        AlterConfigsResult alterResult = this.client().alterConfigs((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array))).asJava());
        Assert.assertTrue((boolean)(((Throwable)Assertions$.MODULE$.intercept((Function0 & Serializable & scala.Serializable)() -> (Void)((KafkaFuture)alterResult.values().get(this.brokerLoggerConfigResource())).get(), ClassTag$.MODULE$.apply(ExecutionException.class), new Position("PlaintextAdminIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2055))).getCause() instanceof InvalidRequestException));
    }

    /*
     * WARNING - void declaration
     */
    public void alterBrokerLoggers(Collection<AlterConfigOp> entries, boolean validateOnly) {
        void $minus$greater$extension_$this;
        if (!validateOnly) {
            ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(entries).asScala()).foreach((Function1 & Serializable & scala.Serializable)entry -> BoxesRunTime.boxToBoolean((boolean)PlaintextAdminIntegrationTest.$anonfun$alterBrokerLoggers$1(this, entry)));
        }
        Tuple2[] tuple2Array = new Tuple2[1];
        Object object = Predef$.MODULE$.ArrowAssoc((Object)this.brokerLoggerConfigResource());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this, entries);
        ((KafkaFuture)this.client().incrementalAlterConfigs((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array))).asJava(), new AlterConfigsOptions().validateOnly(validateOnly)).values().get(this.brokerLoggerConfigResource())).get();
    }

    public boolean alterBrokerLoggers$default$2() {
        return false;
    }

    public Config describeBrokerLoggers() {
        return (Config)((KafkaFuture)this.client().describeConfigs(Collections.singletonList(this.brokerLoggerConfigResource())).values().get(this.brokerLoggerConfigResource())).get();
    }

    private void teardownBrokerLoggers() {
        if (this.changedBrokerLoggers().nonEmpty()) {
            scala.collection.immutable.Set validLoggers = ((TraversableOnce)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(this.describeBrokerLoggers().entries()).asScala()).filterNot((Function1 & Serializable & scala.Serializable)x$21 -> BoxesRunTime.boxToBoolean((boolean)PlaintextAdminIntegrationTest.$anonfun$teardownBrokerLoggers$1(x$21)))).map((Function1 & Serializable & scala.Serializable)x$22 -> x$22.name(), scala.collection.Iterable$.MODULE$.canBuildFrom())).toSet();
            Collection unsetBrokerLoggersEntries = JavaConverters$.MODULE$.asJavaCollectionConverter((Iterable)((SetLike)this.changedBrokerLoggers().intersect((GenSet)validLoggers)).map((Function1 & Serializable & scala.Serializable)logger -> new AlterConfigOp(new ConfigEntry(logger, ""), AlterConfigOp.OpType.DELETE), Set$.MODULE$.canBuildFrom())).asJavaCollection();
            this.alterBrokerLoggers(JavaConverters$.MODULE$.asJavaCollectionConverter((Iterable)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry(Log4jController$.MODULE$.ROOT_LOGGER(), "FATAL"), AlterConfigOp.OpType.SET), (List)Nil$.MODULE$)).asJavaCollection(), this.alterBrokerLoggers$default$2());
            this.alterBrokerLoggers(unsetBrokerLoggersEntries, this.alterBrokerLoggers$default$2());
            this.changedBrokerLoggers().clear();
        }
    }

    public static final /* synthetic */ boolean $anonfun$testMetadataRefresh$1(PlaintextAdminIntegrationTest $this, KafkaServer x$1) {
        return x$1.config().brokerId() == TestUtils$.MODULE$.waitUntilControllerElected($this.zkClient(), TestUtils$.MODULE$.waitUntilControllerElected$default$2());
    }

    public static final /* synthetic */ int $anonfun$testDescribeCluster$1() {
        return -1;
    }

    public static final /* synthetic */ void $anonfun$testDescribeCluster$2(String[] brokers$1, Node node) {
        String hostStr = new StringBuilder(1).append(node.host()).append(":").append(node.port()).toString();
        Assert.assertTrue((String)new StringBuilder(45).append("Unknown host:port pair ").append(hostStr).append(" in brokerVersionInfos").toString(), (boolean)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])brokers$1)).contains((Object)hostStr));
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ int $anonfun$testDescribeLogDirs$1(Tuple2 x0$1) {
        void var1_1;
        if (x0$1 == null) {
            throw new MatchError(null);
        }
        int leaderId = x0$1._2$mcI$sp();
        return (int)var1_1;
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeLogDirs$5(int brokerId$1, KafkaServer x$4) {
        return x$4.config().brokerId() == brokerId$1;
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeLogDirs$7(String topic$1, TopicPartition x$5) {
        String string = x$5.topic();
        return !(string != null ? !string.equals(topic$1) : topic$1 != null);
    }

    public static final /* synthetic */ void $anonfun$testDescribeLogDirs$10(KafkaServer server$1, String logDir$1, TopicPartition tp) {
        LogManager qual$1 = server$1.logManager();
        boolean x$2 = qual$1.getLog$default$2();
        Assert.assertEquals((Object)((Log)qual$1.getLog(tp, x$2).get()).dir().getParent(), (Object)logDir$1);
    }

    public static final /* synthetic */ void $anonfun$testDescribeLogDirs$9(KafkaServer server$1, Tuple2 x0$3) {
        if (x0$3 != null) {
            String logDir = (String)x0$3._1();
            DescribeLogDirsResponse.LogDirInfo logDirInfo = (DescribeLogDirsResponse.LogDirInfo)x0$3._2();
            ((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(logDirInfo.replicaInfos).asScala()).keys().foreach((Function1 & Serializable & scala.Serializable)tp -> {
                PlaintextAdminIntegrationTest.$anonfun$testDescribeLogDirs$10(server$1, logDir, tp);
                return BoxedUnit.UNIT;
            });
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$testDescribeLogDirs$4(PlaintextAdminIntegrationTest $this, scala.collection.immutable.Map partitionsByBroker$1, java.util.Map logDirInfosByBroker$1, String topic$1, int brokerId) {
        KafkaServer server = (KafkaServer)$this.servers().find((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)PlaintextAdminIntegrationTest.$anonfun$testDescribeLogDirs$5(brokerId, x$4))).get();
        Seq expectedPartitions = (Seq)partitionsByBroker$1.apply((Object)BoxesRunTime.boxToInteger((int)brokerId));
        java.util.Map logDirInfos = (java.util.Map)logDirInfosByBroker$1.get(BoxesRunTime.boxToInteger((int)brokerId));
        Map replicaInfos = ((MapLike)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(logDirInfos).asScala()).flatMap((Function1 & Serializable & scala.Serializable)x0$2 -> {
            if (x0$2 == null) {
                throw new MatchError(null);
            }
            DescribeLogDirsResponse.LogDirInfo logDirInfo = (DescribeLogDirsResponse.LogDirInfo)x0$2._2();
            scala.collection.mutable.Map map = (scala.collection.mutable.Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(logDirInfo.replicaInfos).asScala();
            return map;
        }, Map$.MODULE$.canBuildFrom())).filterKeys((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)PlaintextAdminIntegrationTest.$anonfun$testDescribeLogDirs$7(topic$1, x$5)));
        Assert.assertEquals((Object)expectedPartitions.toSet(), (Object)((TraversableOnce)replicaInfos.keys().map((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToInteger((int)x$6.partition()), scala.collection.Iterable$.MODULE$.canBuildFrom())).toSet());
        ((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(logDirInfos).asScala()).foreach((Function1 & Serializable & scala.Serializable)x0$3 -> {
            PlaintextAdminIntegrationTest.$anonfun$testDescribeLogDirs$9(server, x0$3);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeReplicaLogDirs$3(TopicPartitionReplica topicPartitionReplica$1, KafkaServer x$7) {
        return x$7.config().brokerId() == topicPartitionReplica$1.brokerId();
    }

    public static final /* synthetic */ void $anonfun$testDescribeReplicaLogDirs$2(PlaintextAdminIntegrationTest $this, Tuple2 x0$2) {
        if (x0$2 != null) {
            TopicPartitionReplica topicPartitionReplica = (TopicPartitionReplica)x0$2._1();
            DescribeReplicaLogDirsResult.ReplicaLogDirInfo replicaDirInfo = (DescribeReplicaLogDirsResult.ReplicaLogDirInfo)x0$2._2();
            KafkaServer server = (KafkaServer)$this.servers().find((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)PlaintextAdminIntegrationTest.$anonfun$testDescribeReplicaLogDirs$3(topicPartitionReplica, x$7))).get();
            TopicPartition tp = new TopicPartition(topicPartitionReplica.topic(), topicPartitionReplica.partition());
            LogManager qual$1 = server.logManager();
            boolean x$2 = qual$1.getLog$default$2();
            Assert.assertEquals((Object)((Log)qual$1.getLog(tp, x$2).get()).dir().getParent(), (Object)replicaDirInfo.getCurrentReplicaLogDir());
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$testAlterReplicaLogDirs$4(KafkaFuture future) {
        Assert.assertTrue((boolean)(((ExecutionException)Assertions$.MODULE$.intercept((Function0 & Serializable & scala.Serializable)() -> (Void)future.get(), ClassTag$.MODULE$.apply(ExecutionException.class), new Position("PlaintextAdminIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 231))).getCause() instanceof UnknownTopicOrPartitionException));
    }

    public static final /* synthetic */ void $anonfun$testAlterReplicaLogDirs$6(TopicPartition tp$1, scala.collection.immutable.Map firstReplicaAssignment$1, String topic$3, KafkaServer server) {
        LogManager qual$1 = server.logManager();
        boolean x$2 = qual$1.getLog$default$2();
        String logDir = ((Log)qual$1.getLog(tp$1, x$2).get()).dir().getParent();
        Assert.assertEquals((Object)firstReplicaAssignment$1.apply((Object)new TopicPartitionReplica(topic$3, 0, server.config().brokerId())), (Object)logDir);
    }

    public static final /* synthetic */ boolean $anonfun$testAlterReplicaLogDirs$8(KafkaServer server$2, TopicPartition tp$1, scala.collection.immutable.Map secondReplicaAssignment$1, String topic$3) {
        LogManager qual$2 = server$2.logManager();
        boolean x$4 = qual$2.getLog$default$2();
        String logDir = ((Log)qual$2.getLog(tp$1, x$4).get()).dir().getParent();
        Object object = secondReplicaAssignment$1.apply((Object)new TopicPartitionReplica(topic$3, 0, server$2.config().brokerId()));
        return !(object != null ? !object.equals(logDir) : logDir != null);
    }

    public static final /* synthetic */ String $anonfun$testAlterReplicaLogDirs$9() {
        return "timed out waiting for replica movement";
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$testAlterReplicaLogDirs$7(TopicPartition tp$1, scala.collection.immutable.Map secondReplicaAssignment$1, String topic$3, KafkaServer server) {
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!PlaintextAdminIntegrationTest.$anonfun$testAlterReplicaLogDirs$8(server, tp$1, secondReplicaAssignment$1, topic$3)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                throw Assertions$.MODULE$.fail(PlaintextAdminIntegrationTest.$anonfun$testAlterReplicaLogDirs$9(), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 845));
            }
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension((long)waitUntilTrue_waitTimeMs, (long)waitUntilTrue_pause));
        }
    }

    public static final /* synthetic */ boolean $anonfun$testAlterReplicaLogDirs$11(AtomicInteger numMessages$1) {
        return numMessages$1.get() > 10;
    }

    public static final /* synthetic */ String $anonfun$testAlterReplicaLogDirs$12(AtomicInteger numMessages$1, scala.concurrent.Future producerFuture$1) {
        return new StringBuilder(60).append("only ").append(numMessages$1).append(" messages are produced before timeout. Producer future ").append(producerFuture$1.value()).toString();
    }

    public static final /* synthetic */ boolean $anonfun$testAlterReplicaLogDirs$14(KafkaServer server$3, TopicPartition tp$1, scala.collection.immutable.Map firstReplicaAssignment$1, String topic$3) {
        LogManager qual$3 = server$3.logManager();
        boolean x$22 = qual$3.getLog$default$2();
        String logDir = ((Log)qual$3.getLog(tp$1, x$22).get()).dir().getParent();
        Object object = firstReplicaAssignment$1.apply((Object)new TopicPartitionReplica(topic$3, 0, server$3.config().brokerId()));
        return !(object != null ? !object.equals(logDir) : logDir != null);
    }

    public static final /* synthetic */ String $anonfun$testAlterReplicaLogDirs$15(scala.concurrent.Future producerFuture$1) {
        return new StringBuilder(56).append("timed out waiting for replica movement. Producer future ").append(producerFuture$1.value()).toString();
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$testAlterReplicaLogDirs$13(TopicPartition tp$1, scala.collection.immutable.Map firstReplicaAssignment$1, String topic$3, scala.concurrent.Future producerFuture$1, KafkaServer server) {
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!PlaintextAdminIntegrationTest.$anonfun$testAlterReplicaLogDirs$14(server, tp$1, firstReplicaAssignment$1, topic$3)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                throw Assertions$.MODULE$.fail(PlaintextAdminIntegrationTest.$anonfun$testAlterReplicaLogDirs$15(producerFuture$1), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 845));
            }
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension((long)waitUntilTrue_waitTimeMs, (long)waitUntilTrue_pause));
        }
    }

    public static final /* synthetic */ boolean $anonfun$testAlterReplicaLogDirs$16(AtomicInteger numMessages$1, int currentMessagesNum$1) {
        return numMessages$1.get() - currentMessagesNum$1 > 10;
    }

    public static final /* synthetic */ String $anonfun$testAlterReplicaLogDirs$17(AtomicInteger numMessages$1, int currentMessagesNum$1, scala.concurrent.Future producerFuture$1) {
        return new StringBuilder(83).append("only ").append(numMessages$1.get() - currentMessagesNum$1).append(" messages are produced within timeout after replica movement. Producer future ").append(producerFuture$1.value()).toString();
    }

    public static final /* synthetic */ void $anonfun$testAlterReplicaLogDirs$18(Tuple2 x0$1) {
        if (x0$1 != null) {
            ConsumerRecord consumerRecord = (ConsumerRecord)x0$1._1();
            int index = x0$1._2$mcI$sp();
            Assert.assertEquals((Object)new StringBuilder(21).append("xxxxxxxxxxxxxxxxxxxx-").append(index).toString(), (Object)new String((byte[])consumerRecord.value()));
            return;
        }
        throw new MatchError(null);
    }

    private final java.util.List partitions$1(String topic, Option expectedNumPartitionsOpt) {
        Admin x$1 = this.client();
        DescribeTopicsOptions x$4 = this.getTopicMetadata$default$3();
        return this.getTopicMetadata(x$1, topic, x$4, (Option<Object>)expectedNumPartitionsOpt).partitions();
    }

    private final int numPartitions$1(String topic, Option expectedNumPartitionsOpt) {
        return this.partitions$1(topic, expectedNumPartitionsOpt).size();
    }

    private static final Option numPartitions$default$2$1() {
        return None$.MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$testCreatePartitions$1(PlaintextAdminIntegrationTest $this, String topic1$1) {
        return $this.numPartitions$1(topic1$1, PlaintextAdminIntegrationTest.numPartitions$default$2$1()) == 3;
    }

    public static final /* synthetic */ String $anonfun$testCreatePartitions$2() {
        return "Timed out waiting for new partitions to appear";
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$testCreatePartitions$5(PlaintextAdminIntegrationTest $this, ObjectRef alterResult$1, String topic1$1, String topic2$1, java.util.List newPartition2Assignments$1, ObjectRef altered$1, CreatePartitionsOptions option) {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        void $minus$greater$extension_y2;
        void $minus$greater$extension_$this2;
        void $minus$greater$extension_y3;
        void $minus$greater$extension_$this3;
        void $minus$greater$extension_y4;
        void $minus$greater$extension_$this4;
        void $minus$greater$extension_y5;
        void $minus$greater$extension_$this5;
        void $minus$greater$extension_y6;
        void $minus$greater$extension_$this6;
        void $minus$greater$extension_y7;
        void $minus$greater$extension_$this7;
        void $minus$greater$extension_y8;
        void $minus$greater$extension_$this8;
        void $minus$greater$extension_y9;
        void $minus$greater$extension_$this9;
        void $minus$greater$extension_y10;
        void $minus$greater$extension_$this10;
        void $minus$greater$extension_y11;
        void $minus$greater$extension_$this11;
        void $minus$greater$extension_y12;
        void $minus$greater$extension_$this12;
        void $minus$greater$extension_y13;
        void $minus$greater$extension_$this13;
        String desc = option.validateOnly() ? "validateOnly" : "validateOnly=false";
        Tuple2[] tuple2Array = new Tuple2[1];
        NewPartitions newPartitions = NewPartitions.increaseTo((int)1);
        Object object = Predef$.MODULE$.ArrowAssoc((Object)topic1$1);
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this13, (Object)$minus$greater$extension_y13);
        alterResult$1.elem = $this.client().createPartitions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array))).asJava(), option);
        try {
            ((KafkaFuture)((CreatePartitionsResult)alterResult$1.elem).values().get(topic1$1)).get();
            Assert.fail((String)new StringBuilder(63).append(desc).append(": Expect InvalidPartitionsException when newCount is a decrease").toString());
        }
        catch (ExecutionException e) {
            Assert.assertTrue((String)desc, (boolean)(e.getCause() instanceof InvalidPartitionsException));
            Assert.assertEquals((String)desc, (Object)"Topic currently has 3 partitions, which is higher than the requested 1.", (Object)e.getCause().getMessage());
            Assert.assertEquals((String)desc, (long)3L, (long)$this.numPartitions$1(topic1$1, PlaintextAdminIntegrationTest.numPartitions$default$2$1()));
        }
        Tuple2[] tuple2Array2 = new Tuple2[1];
        NewPartitions newPartitions2 = NewPartitions.increaseTo((int)3);
        Object object2 = Predef$.MODULE$.ArrowAssoc((Object)topic2$1);
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array2[0] = new Tuple2((Object)$minus$greater$extension_$this12, (Object)$minus$greater$extension_y12);
        alterResult$1.elem = $this.client().createPartitions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array2))).asJava(), option);
        try {
            ((KafkaFuture)((CreatePartitionsResult)alterResult$1.elem).values().get(topic2$1)).get();
            Assert.fail((String)new StringBuilder(58).append(desc).append(": Expect InvalidPartitionsException when requesting a noop").toString());
        }
        catch (ExecutionException e) {
            Assert.assertTrue((String)desc, (boolean)(e.getCause() instanceof InvalidPartitionsException));
            Assert.assertEquals((String)desc, (Object)"Topic already has 3 partitions.", (Object)e.getCause().getMessage());
            Assert.assertEquals((String)desc, (long)3L, (long)$this.numPartitions$1(topic2$1, (Option)new Some((Object)BoxesRunTime.boxToInteger((int)3))));
        }
        Tuple2[] tuple2Array3 = new Tuple2[1];
        NewPartitions newPartitions3 = NewPartitions.increaseTo((int)3, (java.util.List)newPartition2Assignments$1);
        Object object3 = Predef$.MODULE$.ArrowAssoc((Object)topic2$1);
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array3[0] = new Tuple2((Object)$minus$greater$extension_$this11, (Object)$minus$greater$extension_y11);
        alterResult$1.elem = $this.client().createPartitions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array3))).asJava(), option);
        try {
            ((KafkaFuture)((CreatePartitionsResult)alterResult$1.elem).values().get(topic2$1)).get();
        }
        catch (ExecutionException e) {
            Assert.assertTrue((String)desc, (boolean)(e.getCause() instanceof InvalidPartitionsException));
            Assert.assertEquals((String)desc, (Object)"Topic already has 3 partitions.", (Object)e.getCause().getMessage());
            Assert.assertEquals((String)desc, (long)3L, (long)$this.numPartitions$1(topic2$1, (Option)new Some((Object)BoxesRunTime.boxToInteger((int)3))));
        }
        Tuple2[] tuple2Array4 = new Tuple2[1];
        NewPartitions newPartitions4 = NewPartitions.increaseTo((int)3, (java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableOnce)((SeqLike)JavaConverters$.MODULE$.asScalaBufferConverter(newPartition2Assignments$1).asScala()).reverse()).toList()).asJava()));
        Object object4 = Predef$.MODULE$.ArrowAssoc((Object)topic2$1);
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array4[0] = new Tuple2((Object)$minus$greater$extension_$this10, (Object)$minus$greater$extension_y10);
        alterResult$1.elem = $this.client().createPartitions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array4))).asJava(), option);
        try {
            ((KafkaFuture)((CreatePartitionsResult)alterResult$1.elem).values().get(topic2$1)).get();
        }
        catch (ExecutionException e) {
            Assert.assertTrue((String)desc, (boolean)(e.getCause() instanceof InvalidPartitionsException));
            Assert.assertEquals((String)desc, (Object)"Topic already has 3 partitions.", (Object)e.getCause().getMessage());
            Assert.assertEquals((String)desc, (long)3L, (long)$this.numPartitions$1(topic2$1, (Option)new Some((Object)BoxesRunTime.boxToInteger((int)3))));
        }
        String unknownTopic = "an-unknown-topic";
        Tuple2[] tuple2Array5 = new Tuple2[1];
        NewPartitions newPartitions5 = NewPartitions.increaseTo((int)2);
        Object object5 = Predef$.MODULE$.ArrowAssoc((Object)unknownTopic);
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array5[0] = new Tuple2((Object)$minus$greater$extension_$this9, (Object)$minus$greater$extension_y9);
        alterResult$1.elem = $this.client().createPartitions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array5))).asJava(), option);
        try {
            ((KafkaFuture)((CreatePartitionsResult)alterResult$1.elem).values().get(unknownTopic)).get();
            Assert.fail((String)new StringBuilder(58).append(desc).append(": Expect InvalidTopicException when using an unknown topic").toString());
        }
        catch (ExecutionException e) {
            Assert.assertTrue((String)desc, (boolean)(e.getCause() instanceof UnknownTopicOrPartitionException));
            Assert.assertEquals((String)desc, (Object)"The topic 'an-unknown-topic' does not exist.", (Object)e.getCause().getMessage());
        }
        Tuple2[] tuple2Array6 = new Tuple2[1];
        NewPartitions newPartitions6 = NewPartitions.increaseTo((int)-22);
        Object object6 = Predef$.MODULE$.ArrowAssoc((Object)topic1$1);
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array6[0] = new Tuple2((Object)$minus$greater$extension_$this8, (Object)$minus$greater$extension_y8);
        alterResult$1.elem = $this.client().createPartitions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array6))).asJava(), option);
        try {
            altered$1.elem = (Void)((KafkaFuture)((CreatePartitionsResult)alterResult$1.elem).values().get(topic1$1)).get();
            Assert.fail((String)new StringBuilder(60).append(desc).append(": Expect InvalidPartitionsException when newCount is invalid").toString());
        }
        catch (ExecutionException e) {
            Assert.assertTrue((String)desc, (boolean)(e.getCause() instanceof InvalidPartitionsException));
            Assert.assertEquals((String)desc, (Object)"Topic currently has 3 partitions, which is higher than the requested -22.", (Object)e.getCause().getMessage());
            Assert.assertEquals((String)desc, (long)3L, (long)$this.numPartitions$1(topic1$1, PlaintextAdminIntegrationTest.numPartitions$default$2$1()));
        }
        Tuple2[] tuple2Array7 = new Tuple2[1];
        NewPartitions newPartitions7 = NewPartitions.increaseTo((int)4, Arrays.asList((Object[])new java.util.List[]{Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2)})}));
        Object object7 = Predef$.MODULE$.ArrowAssoc((Object)topic1$1);
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array7[0] = new Tuple2((Object)$minus$greater$extension_$this7, (Object)$minus$greater$extension_y7);
        alterResult$1.elem = $this.client().createPartitions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array7))).asJava(), option);
        try {
            altered$1.elem = (Void)((KafkaFuture)((CreatePartitionsResult)alterResult$1.elem).values().get(topic1$1)).get();
            Assert.fail((String)new StringBuilder(71).append(desc).append(": Expect InvalidPartitionsException when #brokers != replication factor").toString());
        }
        catch (ExecutionException e) {
            Assert.assertTrue((String)desc, (boolean)(e.getCause() instanceof InvalidReplicaAssignmentException));
            Assert.assertEquals((String)desc, (Object)"Inconsistent replication factor between partitions, partition 0 has 1 while partitions [3] have replication factors [2], respectively.", (Object)e.getCause().getMessage());
            Assert.assertEquals((String)desc, (long)3L, (long)$this.numPartitions$1(topic1$1, PlaintextAdminIntegrationTest.numPartitions$default$2$1()));
        }
        Tuple2[] tuple2Array8 = new Tuple2[1];
        NewPartitions newPartitions8 = NewPartitions.increaseTo((int)6, Arrays.asList((Object[])new java.util.List[]{Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(1)})}));
        Object object8 = Predef$.MODULE$.ArrowAssoc((Object)topic1$1);
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array8[0] = new Tuple2((Object)$minus$greater$extension_$this6, (Object)$minus$greater$extension_y6);
        alterResult$1.elem = $this.client().createPartitions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array8))).asJava(), option);
        try {
            altered$1.elem = (Void)((KafkaFuture)((CreatePartitionsResult)alterResult$1.elem).values().get(topic1$1)).get();
            Assert.fail((String)new StringBuilder(83).append(desc).append(": Expect InvalidReplicaAssignmentException when #assignments != newCount - oldCount").toString());
        }
        catch (ExecutionException e) {
            Assert.assertTrue((String)desc, (boolean)(e.getCause() instanceof InvalidReplicaAssignmentException));
            Assert.assertEquals((String)desc, (Object)"Increasing the number of partitions by 3 but 1 assignments provided.", (Object)e.getCause().getMessage());
            Assert.assertEquals((String)desc, (long)3L, (long)$this.numPartitions$1(topic1$1, PlaintextAdminIntegrationTest.numPartitions$default$2$1()));
        }
        Tuple2[] tuple2Array9 = new Tuple2[1];
        NewPartitions newPartitions9 = NewPartitions.increaseTo((int)4, Arrays.asList((Object[])new java.util.List[]{Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(1)}), Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(2)})}));
        Object object9 = Predef$.MODULE$.ArrowAssoc((Object)topic1$1);
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array9[0] = new Tuple2((Object)$minus$greater$extension_$this5, (Object)$minus$greater$extension_y5);
        alterResult$1.elem = $this.client().createPartitions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array9))).asJava(), option);
        try {
            altered$1.elem = (Void)((KafkaFuture)((CreatePartitionsResult)alterResult$1.elem).values().get(topic1$1)).get();
            Assert.fail((String)new StringBuilder(83).append(desc).append(": Expect InvalidReplicaAssignmentException when #assignments != newCount - oldCount").toString());
        }
        catch (ExecutionException e) {
            Assert.assertTrue((String)desc, (boolean)(e.getCause() instanceof InvalidReplicaAssignmentException));
            Assert.assertEquals((String)desc, (Object)"Increasing the number of partitions by 1 but 2 assignments provided.", (Object)e.getCause().getMessage());
            Assert.assertEquals((String)desc, (long)3L, (long)$this.numPartitions$1(topic1$1, PlaintextAdminIntegrationTest.numPartitions$default$2$1()));
        }
        Tuple2[] tuple2Array10 = new Tuple2[1];
        NewPartitions newPartitions10 = NewPartitions.increaseTo((int)4, Arrays.asList((Object[])new java.util.List[]{Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(1)})}));
        Object object10 = Predef$.MODULE$.ArrowAssoc((Object)topic1$1);
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array10[0] = new Tuple2((Object)$minus$greater$extension_$this4, (Object)$minus$greater$extension_y4);
        alterResult$1.elem = $this.client().createPartitions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array10))).asJava(), option);
        try {
            altered$1.elem = (Void)((KafkaFuture)((CreatePartitionsResult)alterResult$1.elem).values().get(topic1$1)).get();
            Assert.fail((String)new StringBuilder(81).append(desc).append(": Expect InvalidReplicaAssignmentException when assignments has duplicate brokers").toString());
        }
        catch (ExecutionException e) {
            Assert.assertTrue((String)desc, (boolean)(e.getCause() instanceof InvalidReplicaAssignmentException));
            Assert.assertEquals((String)desc, (Object)"Duplicate brokers not allowed in replica assignment: 1, 1 for partition id 3.", (Object)e.getCause().getMessage());
            Assert.assertEquals((String)desc, (long)3L, (long)$this.numPartitions$1(topic1$1, PlaintextAdminIntegrationTest.numPartitions$default$2$1()));
        }
        Tuple2[] tuple2Array11 = new Tuple2[1];
        NewPartitions newPartitions11 = NewPartitions.increaseTo((int)5, Arrays.asList((Object[])new java.util.List[]{Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(1)}), Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(0)})}));
        Object object11 = Predef$.MODULE$.ArrowAssoc((Object)topic1$1);
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array11[0] = new Tuple2((Object)$minus$greater$extension_$this3, (Object)$minus$greater$extension_y3);
        alterResult$1.elem = $this.client().createPartitions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array11))).asJava(), option);
        try {
            altered$1.elem = (Void)((KafkaFuture)((CreatePartitionsResult)alterResult$1.elem).values().get(topic1$1)).get();
            Assert.fail((String)new StringBuilder(94).append(desc).append(": Expect InvalidReplicaAssignmentException when assignments have differently sized inner lists").toString());
        }
        catch (ExecutionException e) {
            Assert.assertTrue((String)desc, (boolean)(e.getCause() instanceof InvalidReplicaAssignmentException));
            Assert.assertEquals((String)desc, (Object)"Inconsistent replication factor between partitions, partition 0 has 1 while partitions [4] have replication factors [2], respectively.", (Object)e.getCause().getMessage());
            Assert.assertEquals((String)desc, (long)3L, (long)$this.numPartitions$1(topic1$1, PlaintextAdminIntegrationTest.numPartitions$default$2$1()));
        }
        Tuple2[] tuple2Array12 = new Tuple2[1];
        NewPartitions newPartitions12 = NewPartitions.increaseTo((int)4, Arrays.asList((Object[])new java.util.List[]{Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(12)})}));
        Object object12 = Predef$.MODULE$.ArrowAssoc((Object)topic1$1);
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array12[0] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y2);
        alterResult$1.elem = $this.client().createPartitions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array12))).asJava(), option);
        try {
            altered$1.elem = (Void)((KafkaFuture)((CreatePartitionsResult)alterResult$1.elem).values().get(topic1$1)).get();
            Assert.fail((String)new StringBuilder(86).append(desc).append(": Expect InvalidReplicaAssignmentException when assignments contains an unknown broker").toString());
        }
        catch (ExecutionException e) {
            Assert.assertTrue((String)desc, (boolean)(e.getCause() instanceof InvalidReplicaAssignmentException));
            Assert.assertEquals((String)desc, (Object)"Unknown broker(s) in replica assignment: 12.", (Object)e.getCause().getMessage());
            Assert.assertEquals((String)desc, (long)3L, (long)$this.numPartitions$1(topic1$1, PlaintextAdminIntegrationTest.numPartitions$default$2$1()));
        }
        Tuple2[] tuple2Array13 = new Tuple2[1];
        NewPartitions newPartitions13 = NewPartitions.increaseTo((int)4, Collections.emptyList());
        Object object13 = Predef$.MODULE$.ArrowAssoc((Object)topic1$1);
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array13[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        alterResult$1.elem = $this.client().createPartitions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array13))).asJava(), option);
        try {
            altered$1.elem = (Void)((KafkaFuture)((CreatePartitionsResult)alterResult$1.elem).values().get(topic1$1)).get();
            Assert.fail((String)new StringBuilder(68).append(desc).append(": Expect InvalidReplicaAssignmentException when assignments is empty").toString());
            return;
        }
        catch (ExecutionException e) {
            Assert.assertTrue((String)desc, (boolean)(e.getCause() instanceof InvalidReplicaAssignmentException));
            Assert.assertEquals((String)desc, (Object)"Increasing the number of partitions by 1 but 0 assignments provided.", (Object)e.getCause().getMessage());
            Assert.assertEquals((String)desc, (long)3L, (long)$this.numPartitions$1(topic1$1, PlaintextAdminIntegrationTest.numPartitions$default$2$1()));
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$testCreatePartitions$6(PlaintextAdminIntegrationTest $this, String topic1$1) {
        return $this.numPartitions$1(topic1$1, PlaintextAdminIntegrationTest.numPartitions$default$2$1()) == 4;
    }

    public static final /* synthetic */ String $anonfun$testCreatePartitions$7() {
        return "Timed out waiting for new partitions to appear";
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ boolean $anonfun$testLogStartOffsetCheckpoint$2(PlaintextAdminIntegrationTest $this, ObjectRef result$1, ObjectRef lowWatermark$1) {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        Tuple2[] tuple2Array = new Tuple2[1];
        RecordsToDelete recordsToDelete = RecordsToDelete.beforeOffset((long)0L);
        Object object = Predef$.MODULE$.ArrowAssoc((Object)$this.topicPartition());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        result$1.elem = $this.client().deleteRecords((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array))).asJava());
        lowWatermark$1.elem = None$.MODULE$;
        KafkaFuture future = (KafkaFuture)((DeleteRecordsResult)result$1.elem).lowWatermarks().get($this.topicPartition());
        try {
            lowWatermark$1.elem = new Some((Object)BoxesRunTime.boxToLong((long)((DeletedRecords)future.get()).lowWatermark()));
            return ((Option)lowWatermark$1.elem).contains((Object)BoxesRunTime.boxToLong((long)5L));
        }
        catch (Throwable throwable) {
            ExecutionException executionException;
            if (!(throwable instanceof ExecutionException) || !((executionException = (ExecutionException)throwable).getCause() instanceof LeaderNotAvailableException) && !(executionException.getCause() instanceof NotLeaderForPartitionException)) {
                throw throwable;
            }
            boolean bl = false;
            return bl;
        }
    }

    public static final /* synthetic */ String $anonfun$testLogStartOffsetCheckpoint$4() {
        return "no response within the timeout";
    }

    public static final /* synthetic */ String $anonfun$testLogStartOffsetCheckpoint$3(ObjectRef lowWatermark$1) {
        Option option = (Option)lowWatermark$1.elem;
        if (option == null) {
            throw null;
        }
        Option getOrElse_this = option;
        Object object = getOrElse_this.isEmpty() ? PlaintextAdminIntegrationTest.$anonfun$testLogStartOffsetCheckpoint$4() : getOrElse_this.get();
        return new StringBuilder(56).append("Expected low watermark of the partition to be 5 but got ").append(object).toString();
    }

    public static final /* synthetic */ void $anonfun$testLogStartOffsetAfterDeleteRecords$1(PlaintextAdminIntegrationTest $this, int i) {
        Assert.assertEquals((long)3L, (long)((Log)((KafkaServer)$this.servers().apply(i)).replicaManager().localLog($this.topicPartition()).get()).logStartOffset());
    }

    public static final /* synthetic */ boolean $anonfun$testReplicaCanFetchFromLogStartOffsetAfterDeleteRecords$1(PlaintextAdminIntegrationTest $this, int followerIndex$1) {
        Option option = ((KafkaServer)$this.servers().apply(followerIndex$1)).replicaManager().localLog($this.topicPartition());
        None$ none$ = None$.MODULE$;
        return option == null ? none$ != null : !option.equals(none$);
    }

    public static final /* synthetic */ String $anonfun$testReplicaCanFetchFromLogStartOffsetAfterDeleteRecords$2() {
        return "Expected follower to create replica for partition";
    }

    public static final /* synthetic */ boolean $anonfun$testReplicaCanFetchFromLogStartOffsetAfterDeleteRecords$3(PlaintextAdminIntegrationTest $this, int followerIndex$1, long expectedStartOffset$1) {
        return ((Log)((KafkaServer)$this.servers().apply(followerIndex$1)).replicaManager().localLog($this.topicPartition()).get()).logStartOffset() == expectedStartOffset$1;
    }

    public static final /* synthetic */ String $anonfun$testReplicaCanFetchFromLogStartOffsetAfterDeleteRecords$4(long expectedStartOffset$1) {
        return new StringBuilder(51).append("Expected follower to discover new log start offset ").append(expectedStartOffset$1).toString();
    }

    public static final /* synthetic */ boolean $anonfun$testReplicaCanFetchFromLogStartOffsetAfterDeleteRecords$5(PlaintextAdminIntegrationTest $this, int followerIndex$1, long expectedEndOffset$1) {
        return ((Log)((KafkaServer)$this.servers().apply(followerIndex$1)).replicaManager().localLog($this.topicPartition()).get()).logEndOffset() == expectedEndOffset$1;
    }

    public static final /* synthetic */ String $anonfun$testReplicaCanFetchFromLogStartOffsetAfterDeleteRecords$6(long expectedEndOffset$1) {
        return new StringBuilder(48).append("Expected follower to catch up to log end offset ").append(expectedEndOffset$1).toString();
    }

    /*
     * WARNING - void declaration
     */
    private final void waitForFollowerLog$1(long expectedStartOffset, long expectedEndOffset, int followerIndex$1) {
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!PlaintextAdminIntegrationTest.$anonfun$testReplicaCanFetchFromLogStartOffsetAfterDeleteRecords$1(this, followerIndex$1)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                throw Assertions$.MODULE$.fail(PlaintextAdminIntegrationTest.$anonfun$testReplicaCanFetchFromLogStartOffsetAfterDeleteRecords$2(), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 845));
            }
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension((long)waitUntilTrue_waitTimeMs, (long)waitUntilTrue_pause));
        }
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!PlaintextAdminIntegrationTest.$anonfun$testReplicaCanFetchFromLogStartOffsetAfterDeleteRecords$3(this, followerIndex$1, expectedStartOffset)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                throw Assertions$.MODULE$.fail(PlaintextAdminIntegrationTest.$anonfun$testReplicaCanFetchFromLogStartOffsetAfterDeleteRecords$4(expectedStartOffset), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 845));
            }
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension((long)waitUntilTrue_waitTimeMs, (long)waitUntilTrue_pause));
        }
        long l5 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l6 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!PlaintextAdminIntegrationTest.$anonfun$testReplicaCanFetchFromLogStartOffsetAfterDeleteRecords$5(this, followerIndex$1, expectedEndOffset)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs) {
                throw Assertions$.MODULE$.fail(PlaintextAdminIntegrationTest.$anonfun$testReplicaCanFetchFromLogStartOffsetAfterDeleteRecords$6(expectedEndOffset), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 845));
            }
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension((long)waitUntilTrue_waitTimeMs, (long)waitUntilTrue_pause));
        }
    }

    public static final /* synthetic */ void $anonfun$testReplicaCanFetchFromLogStartOffsetAfterDeleteRecords$7(PlaintextAdminIntegrationTest $this, int i) {
        Assert.assertEquals((long)3L, (long)((Log)((KafkaServer)$this.servers().apply(i)).replicaManager().localLog($this.topicPartition()).get()).logStartOffset());
    }

    public static final /* synthetic */ void $anonfun$testAlterLogDirsAfterDeleteRecords$1(PlaintextAdminIntegrationTest $this, int expectedLEO$1, int i) {
        Assert.assertEquals((long)3L, (long)((Log)((KafkaServer)$this.servers().apply(i)).replicaManager().localLog($this.topicPartition()).get()).logStartOffset());
        Assert.assertEquals((long)expectedLEO$1, (long)((Log)((KafkaServer)$this.servers().apply(i)).replicaManager().localLog($this.topicPartition()).get()).logEndOffset());
    }

    public static final /* synthetic */ boolean $anonfun$testAlterLogDirsAfterDeleteRecords$2(PlaintextAdminIntegrationTest $this, String futureLogDir$1) {
        String string = futureLogDir$1;
        LogManager qual$1 = ((KafkaServer)$this.servers().apply(0)).logManager();
        TopicPartition x$1 = $this.topicPartition();
        boolean x$2 = qual$1.getLog$default$2();
        String string2 = ((Log)qual$1.getLog(x$1, x$2).get()).dir().getParent();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ String $anonfun$testAlterLogDirsAfterDeleteRecords$3() {
        return "timed out waiting for replica movement";
    }

    public static final /* synthetic */ String $anonfun$subscribeAndWaitForAssignment$2() {
        return "Expected non-empty assignment";
    }

    public static final /* synthetic */ Future $anonfun$sendRecords$1(PlaintextAdminIntegrationTest $this, TopicPartition topicPartition$1, KafkaProducer producer$1, int i) {
        ProducerRecord record = new ProducerRecord(topicPartition$1.topic(), Predef$.MODULE$.int2Integer(topicPartition$1.partition()), (Object)String.valueOf(BoxesRunTime.boxToInteger((int)i)).getBytes(), (Object)String.valueOf(BoxesRunTime.boxToInteger((int)i)).getBytes());
        $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(21).append("Sending this record: ").append(record).toString());
        return producer$1.send(record);
    }

    public static final /* synthetic */ boolean $anonfun$testConsumerGroups$2(String testGroupId$1, ConsumerGroupListing x$16) {
        String string = x$16.groupId();
        return !(string != null ? !string.equals(testGroupId$1) : testGroupId$1 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testConsumerGroups$1(PlaintextAdminIntegrationTest $this, String testGroupId$1) {
        return ((Iterable)((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter((Collection)$this.client().listConsumerGroups().all().get()).asScala()).filter((Function1 & Serializable & scala.Serializable)x$16 -> BoxesRunTime.boxToBoolean((boolean)PlaintextAdminIntegrationTest.$anonfun$testConsumerGroups$2(testGroupId$1, x$16)))).nonEmpty();
    }

    public static final /* synthetic */ String $anonfun$testConsumerGroups$3(String testGroupId$1) {
        return new StringBuilder(28).append("Expected to be able to list ").append(testGroupId$1).toString();
    }

    public static final /* synthetic */ boolean $anonfun$testConsumerGroups$4(String testTopicName$1, TopicPartition tp) {
        return tp.topic().equals(testTopicName$1);
    }

    public static final /* synthetic */ boolean $anonfun$testConsumerGroups$5(PlaintextAdminIntegrationTest $this, String testGroupId$1, String testTopicName$1) {
        TopicPartition part;
        java.util.Map parts = (java.util.Map)$this.client().listConsumerGroupOffsets(testGroupId$1).partitionsToOffsetAndMetadata().get();
        return parts.containsKey(part = new TopicPartition(testTopicName$1, 0)) && ((OffsetAndMetadata)parts.get(part)).offset() == 1L;
    }

    public static final /* synthetic */ String $anonfun$testConsumerGroups$6() {
        return "Expected the offset for partition 0 to eventually become 1.";
    }

    private final int preferredLeader$1(TopicPartition topicPartition) {
        return ((Node)((TopicPartitionInfo)this.getTopicMetadata(this.client(), topicPartition.topic(), this.getTopicMetadata$default$3(), this.getTopicMetadata$default$4()).partitions().get(topicPartition.partition())).replicas().get(0)).id();
    }

    public static final /* synthetic */ boolean $anonfun$testElectPreferredLeaders$1(PlaintextAdminIntegrationTest $this, TopicPartition partition1$1, int preferred$1, TopicPartition partition2$1) {
        return $this.preferredLeader$1(partition1$1) == preferred$1 && $this.preferredLeader$1(partition2$1) == preferred$1;
    }

    public static final /* synthetic */ String $anonfun$testElectPreferredLeaders$2(PlaintextAdminIntegrationTest $this, int preferred$1, TopicPartition partition1$1, TopicPartition partition2$1) {
        return new StringBuilder(50).append("Expected preferred leader to become ").append(preferred$1).append(", but is ").append($this.preferredLeader$1(partition1$1)).append(" and ").append($this.preferredLeader$1(partition2$1)).toString();
    }

    /*
     * WARNING - void declaration
     */
    private final void changePreferredLeader$1(Seq newAssignment, TopicPartition partition1$1, TopicPartition partition2$1) {
        int preferred = BoxesRunTime.unboxToInt((Object)newAssignment.head());
        int prior1 = BoxesRunTime.unboxToInt((Object)this.zkClient().getLeaderForPartition(partition1$1).get());
        int prior2 = BoxesRunTime.unboxToInt((Object)this.zkClient().getLeaderForPartition(partition2$1).get());
        scala.collection.immutable.Map m = Predef$.MODULE$.Map().empty();
        if (prior1 != preferred) {
            void $minus$greater$extension_$this;
            Object object = Predef$.MODULE$.ArrowAssoc((Object)partition1$1);
            if (Predef.ArrowAssoc$.MODULE$ == null) {
                throw null;
            }
            m = m.$plus(new Tuple2((Object)$minus$greater$extension_$this, (Object)newAssignment));
        }
        if (prior2 != preferred) {
            void $minus$greater$extension_$this;
            Object object = Predef$.MODULE$.ArrowAssoc((Object)partition2$1);
            if (Predef.ArrowAssoc$.MODULE$ == null) {
                throw null;
            }
            m = m.$plus(new Tuple2((Object)$minus$greater$extension_$this, (Object)newAssignment));
        }
        this.zkClient().createPartitionReassignment((Map)m);
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = 10000L;
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!PlaintextAdminIntegrationTest.$anonfun$testElectPreferredLeaders$1(this, partition1$1, preferred, partition2$1)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                throw Assertions$.MODULE$.fail(PlaintextAdminIntegrationTest.$anonfun$testElectPreferredLeaders$2(this, preferred, partition1$1, partition2$1), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 845));
            }
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension((long)waitUntilTrue_waitTimeMs, (long)waitUntilTrue_pause));
        }
        TestUtils$.MODULE$.assertLeader(this.client(), partition1$1, prior1);
        TestUtils$.MODULE$.assertLeader(this.client(), partition2$1, prior2);
    }

    public static final /* synthetic */ Integer $anonfun$testInvalidAlterPartitionReassignments$1(int x$17) {
        return BoxesRunTime.boxToInteger((int)x$17);
    }

    public static final /* synthetic */ Integer $anonfun$testInvalidAlterPartitionReassignments$2(int x$18) {
        return BoxesRunTime.boxToInteger((int)x$18);
    }

    public static final /* synthetic */ Integer $anonfun$testInvalidAlterPartitionReassignments$3(int x$19) {
        return BoxesRunTime.boxToInteger((int)x$19);
    }

    public static final /* synthetic */ Integer $anonfun$testInvalidAlterPartitionReassignments$4(int x$20) {
        return BoxesRunTime.boxToInteger((int)x$20);
    }

    private final void assertLogLevelDidNotChange$1(ConfigEntry expectedValidLoggerLogLevel$1, String validLoggerName$1) {
        Assert.assertEquals((Object)expectedValidLoggerLogLevel$1, (Object)this.describeBrokerLoggers().get(validLoggerName$1));
    }

    public static final /* synthetic */ boolean $anonfun$alterBrokerLoggers$1(PlaintextAdminIntegrationTest $this, AlterConfigOp entry) {
        return $this.changedBrokerLoggers().add((Object)entry.configEntry().name());
    }

    public static final /* synthetic */ boolean $anonfun$teardownBrokerLoggers$1(ConfigEntry x$21) {
        return x$21.name().equals(Log4jController$.MODULE$.ROOT_LOGGER());
    }

    public PlaintextAdminIntegrationTest() {
        this.topic = "topic";
        this.partition = 0;
    }
}

