/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import java.io.Serializable;
import java.util.Properties;
import kafka.api.ApiVersion;
import kafka.api.ApiVersion$;
import kafka.api.KAFKA_0_10_0_IV1$;
import kafka.api.KAFKA_0_10_2_IV0$;
import kafka.api.KAFKA_0_9_0$;
import kafka.api.KAFKA_1_0_IV0$;
import kafka.api.KAFKA_2_2_IV0$;
import kafka.api.KAFKA_2_4_IV0$;
import kafka.api.KAFKA_2_4_IV1$;
import kafka.api.LeaderAndIsr;
import kafka.api.LeaderAndIsr$;
import kafka.cluster.Broker;
import kafka.cluster.EndPoint;
import kafka.controller.AbstractControllerBrokerRequestBatch;
import kafka.controller.ControllerChannelManagerTest$MockControllerBrokerRequestBatch$;
import kafka.controller.ControllerChannelManagerTest$SentRequest$;
import kafka.controller.ControllerContext;
import kafka.controller.ControllerEvent;
import kafka.controller.LeaderAndIsrResponseReceived;
import kafka.controller.LeaderIsrAndControllerEpoch;
import kafka.controller.ReplicaAssignment;
import kafka.controller.ReplicaAssignment$;
import kafka.controller.StateChangeLogger;
import kafka.controller.TopicDeletionStopReplicaResponseReceived;
import kafka.controller.UpdateMetadataResponseReceived;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.LeaderAndIsrRequestData;
import org.apache.kafka.common.message.LeaderAndIsrResponseData;
import org.apache.kafka.common.message.StopReplicaResponseData;
import org.apache.kafka.common.message.UpdateMetadataRequestData;
import org.apache.kafka.common.message.UpdateMetadataResponseData;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractControlRequest;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.LeaderAndIsrRequest;
import org.apache.kafka.common.requests.LeaderAndIsrResponse;
import org.apache.kafka.common.requests.StopReplicaRequest;
import org.apache.kafka.common.requests.StopReplicaResponse;
import org.apache.kafka.common.requests.UpdateMetadataRequest;
import org.apache.kafka.common.requests.UpdateMetadataResponse;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.junit.Assert;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.LinearSeqOptimized;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.CanBuildFrom;
import scala.collection.generic.TraversableForwarder;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.BufferLike;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.Map$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\ree\u0001\u0002'N\u0001ICQ!\u0017\u0001\u0005\u0002iCq!\u0018\u0001C\u0002\u0013%a\f\u0003\u0004c\u0001\u0001\u0006Ia\u0018\u0005\bG\u0002\u0011\r\u0011\"\u0003_\u0011\u0019!\u0007\u0001)A\u0005?\"9Q\r\u0001b\u0001\n\u00131\u0007BB7\u0001A\u0003%q\rC\u0004o\u0001\t\u0007I\u0011B8\t\rM\u0004\u0001\u0015!\u0003q\u000b\u0011!\b\u0001A;\t\u000f\u0005\u0015\u0002\u0001\"\u0001\u0002(!9\u0011Q\b\u0001\u0005\u0002\u0005\u001d\u0002bBA!\u0001\u0011\u0005\u0011q\u0005\u0005\b\u0003\u000b\u0002A\u0011AA\u0014\u0011\u001d\tI\u0005\u0001C\u0005\u0003\u0017Bq!a\u001a\u0001\t\u0003\t9\u0003C\u0004\u0002l\u0001!\t!a\n\t\u000f\u0005=\u0004\u0001\"\u0001\u0002(!9\u00111\u000f\u0001\u0005\u0002\u0005\u001d\u0002bBA<\u0001\u0011\u0005\u0011q\u0005\u0005\b\u0003w\u0002A\u0011BA?\u0011\u001d\t)\t\u0001C\u0001\u0003OAq!!#\u0001\t\u0003\t9\u0003C\u0004\u0002\u000e\u0002!\t!a\n\t\u000f\u0005E\u0005\u0001\"\u0001\u0002(!9\u0011Q\u0013\u0001\u0005\u0002\u0005\u001d\u0002bBAM\u0001\u0011\u0005\u0011q\u0005\u0005\b\u0003;\u0003A\u0011AA\u0014\u0011\u001d\t\t\u000b\u0001C\u0005\u0003GCq!a+\u0001\t\u0013\ti\u000bC\u0004\u0003\n\u0002!IAa#\t\u000f\tE\u0005\u0001\"\u0003\u0003\u0014\"9!\u0011\u0014\u0001\u0005\n\tm\u0005b\u0002BQ\u0001\u0011%!1\u0015\u0005\b\u0005k\u0003A\u0011\u0002B\\\r\u0019\ty\u000e\u0001#\u0002b\"Q\u0011q\u001e\u0013\u0003\u0016\u0004%\t!!=\t\u0015\u0005UHE!E!\u0002\u0013\t\u0019\u0010\u0003\u0006\u0002x\u0012\u0012)\u001a!C\u0001\u0003sD!Ba\u0002%\u0005#\u0005\u000b\u0011BA~\u0011\u0019IF\u0005\"\u0001\u0003\n!I!q\u0002\u0013\u0002\u0002\u0013\u0005!\u0011\u0003\u0005\n\u0005/!\u0013\u0013!C\u0001\u00053A\u0011Ba\t%#\u0003%\tA!\n\t\u0013\tmB%!A\u0005B\tu\u0002\u0002\u0003B(I\u0005\u0005I\u0011\u00010\t\u0013\tEC%!A\u0005\u0002\tM\u0003\"\u0003B0I\u0005\u0005I\u0011\tB1\u0011%\u0011y\u0007JA\u0001\n\u0003\u0011\t\bC\u0005\u0003|\u0011\n\t\u0011\"\u0011\u0003~!I!q\u0010\u0013\u0002\u0002\u0013\u0005#\u0011\u0011\u0005\n\u0005\u0007#\u0013\u0011!C!\u0005\u000b;\u0011Ba9\u0001\u0003\u0003EIA!:\u0007\u0013\u0005}\u0007!!A\t\n\t\u001d\bBB-7\t\u0003\u0011)\u0010C\u0005\u0003\u0000Y\n\t\u0011\"\u0012\u0003\u0002\"I!q\u001f\u001c\u0002\u0002\u0013\u0005%\u0011 \u0005\n\u0005\u007f4\u0014\u0011!CA\u0007\u00031aaa\u0005\u0001\t\rU\u0001BCB\u000fw\t\u0005\t\u0015!\u0003\u0003:\"AQm\u000fB\u0001B\u0003%q\r\u0003\u0004Zw\u0011\u00051q\u0004\u0005\n\u0007OY$\u0019!C\u0001\u0007SA\u0001b!\u0010<A\u0003%11\u0006\u0005\n\u0003\u0003\\$\u0019!C\u0001\u0007\u007fA\u0001b!\u0013<A\u0003%1\u0011\t\u0005\b\u0007\u0017ZD\u0011IB'\u0011\u001d\u0019\u0019f\u000fC!\u0007+Bqa!\u0019<\t\u0003\u0019\u0019\u0007C\u0004\u0004pm\"\ta!\u001d\t\u000f\ru4\b\"\u0001\u0004\u0000\u001dI11\u0012\u0001\u0002\u0002#%1Q\u0012\u0004\n\u0007'\u0001\u0011\u0011!E\u0005\u0007\u001fCa!W%\u0005\u0002\rE\u0005\"CBJ\u0013F\u0005I\u0011ABK\u0005q\u0019uN\u001c;s_2dWM]\"iC:tW\r\\'b]\u0006<WM\u001d+fgRT!AT(\u0002\u0015\r|g\u000e\u001e:pY2,'OC\u0001Q\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001A*\u0011\u0005Q;V\"A+\u000b\u0003Y\u000bQa]2bY\u0006L!\u0001W+\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\t1\f\u0005\u0002]\u00015\tQ*\u0001\u0007d_:$(o\u001c7mKJLE-F\u0001`!\t!\u0006-\u0003\u0002b+\n\u0019\u0011J\u001c;\u0002\u001b\r|g\u000e\u001e:pY2,'/\u00133!\u0003=\u0019wN\u001c;s_2dWM]#q_\u000eD\u0017\u0001E2p]R\u0014x\u000e\u001c7fe\u0016\u0003xn\u00195!\u0003\u0019\u0019wN\u001c4jOV\tq\r\u0005\u0002iW6\t\u0011N\u0003\u0002k\u001f\u000611/\u001a:wKJL!\u0001\\5\u0003\u0017-\u000bgm[1D_:4\u0017nZ\u0001\bG>tg-[4!\u0003\u0019awnZ4feV\t\u0001\u000f\u0005\u0002]c&\u0011!/\u0014\u0002\u0012'R\fG/Z\"iC:<W\rT8hO\u0016\u0014\u0018a\u00027pO\u001e,'\u000f\t\u0002\u000f\u0007>tGO]8m%\u0016\fX/Z:ua\r1\u00181\u0003\t\u0006o\u0006%\u0011q\u0002\b\u0004q\u0006\u0015Q\"A=\u000b\u0005i\\\u0018\u0001\u0003:fcV,7\u000f^:\u000b\u0005ql\u0018AB2p[6|gN\u0003\u0002Q}*\u0019q0!\u0001\u0002\r\u0005\u0004\u0018m\u00195f\u0015\t\t\u0019!A\u0002pe\u001eL1!a\u0002z\u0003Y\t%m\u001d;sC\u000e$8i\u001c8ue>d'+Z9vKN$\u0018\u0002BA\u0006\u0003\u001b\u0011qAQ;jY\u0012,'OC\u0002\u0002\be\u0004B!!\u0005\u0002\u00141\u0001AaCA\u000b\u0015\u0005\u0005\t\u0011!B\u0001\u0003/\u00111a\u0018\u00132#\u0011\tI\"a\b\u0011\u0007Q\u000bY\"C\u0002\u0002\u001eU\u0013qAT8uQ&tw\rE\u0002y\u0003CI1!a\tz\u0005Y\t%m\u001d;sC\u000e$8i\u001c8ue>d'+Z9vKN$\u0018a\u0007;fgRdU-\u00193fe\u0006sG-S:s%\u0016\fX/Z:u'\u0016tG\u000f\u0006\u0002\u0002*A\u0019A+a\u000b\n\u0007\u00055RK\u0001\u0003V]&$\bfA\u0006\u00022A!\u00111GA\u001d\u001b\t\t)D\u0003\u0003\u00028\u0005\u0005\u0011!\u00026v]&$\u0018\u0002BA\u001e\u0003k\u0011A\u0001V3ti\u0006aB/Z:u\u0019\u0016\fG-\u001a:B]\u0012L5O\u001d*fcV,7\u000f^%t\u001d\u0016<\bf\u0001\u0007\u00022\u00051D/Z:u\u0019\u0016\fG-\u001a:B]\u0012L5O\u001d*fcV,7\u000f^*f]R$v\u000eT5wK>\u00138\u000b[;ui&tw\rR8x]\n\u0013xn[3sg\"\u001aQ\"!\r\u0002UQ,7\u000f\u001e'fC\u0012,'/\u00118e\u0013N\u0014\u0018J\u001c;fe\n\u0013xn[3s!J|Go\\2pYZ+'o]5p]\"\u001aa\"!\r\u0002qQ,7\u000f\u001e'fC\u0012,'/\u00118e\u0013N\u0014(+Z9vKN$hi\u001c7m_^\u001c\u0018J\u001c;fe\n\u0013xn[3s!J|Go\\2pYZ+'o]5p]R1\u0011\u0011FA'\u0003;Bq!a\u0014\u0010\u0001\u0004\t\t&\u0001\u000ej]R,'O\u0011:pW\u0016\u0014\bK]8u_\u000e|GNV3sg&|g\u000e\u0005\u0003\u0002T\u0005eSBAA+\u0015\r\t9fT\u0001\u0004CBL\u0017\u0002BA.\u0003+\u0012!\"\u00119j-\u0016\u00148/[8o\u0011\u001d\tyf\u0004a\u0001\u0003C\n1$\u001a=qK\u000e$X\r\u001a'fC\u0012,'/\u00118e\u0013N\u0014h+\u001a:tS>t\u0007c\u0001+\u0002d%\u0019\u0011QM+\u0003\u000bMCwN\u001d;\u0002;Q,7\u000f^+qI\u0006$X-T3uC\u0012\fG/\u0019*fcV,7\u000f^*f]RD3\u0001EA\u0019\u0003u\"Xm\u001d;Va\u0012\fG/Z'fi\u0006$\u0017\r^1E_\u0016\u001chj\u001c;J]\u000edW\u000fZ3QCJ$\u0018\u000e^5p]N<\u0016\u000e\u001e5pkRdU-\u00193fe\u0006sG-S:sQ\r\t\u0012\u0011G\u0001-i\u0016\u001cH/\u00169eCR,W*\u001a;bI\u0006$\u0018MU3rk\u0016\u001cH\u000fR;sS:<Gk\u001c9jG\u0012+G.\u001a;j_:D3AEA\u0019\u0003M\"Xm\u001d;Va\u0012\fG/Z'fi\u0006$\u0017\r^1J]\u000edW\u000fZ3t\u0019&4Xm\u0014:TQV$H/\u001b8h\t><hN\u0011:pW\u0016\u00148\u000fK\u0002\u0014\u0003c\tA\u0006^3tiV\u0003H-\u0019;f\u001b\u0016$\u0018\rZ1uC&sG/\u001a:Ce>\\WM\u001d)s_R|7m\u001c7WKJ\u001c\u0018n\u001c8)\u0007Q\t\t$A\u001auKN$X\u000b\u001d3bi\u0016lU\r^1eCR\fgi\u001c7m_^\u001c\u0018J\u001c;fe\n\u0013xn[3s!J|Go\\2pYZ+'o]5p]R1\u0011\u0011FA@\u0003\u0003Cq!a\u0014\u0016\u0001\u0004\t\t\u0006C\u0004\u0002\u0004V\u0001\r!!\u0019\u0002;\u0015D\b/Z2uK\u0012,\u0006\u000fZ1uK6+G/\u00193bi\u00064VM]:j_:\f!\u0004^3tiN#x\u000e\u001d*fa2L7-\u0019*fcV,7\u000f^*f]RD3AFA\u0019\u0003I\"Xm\u001d;Ti>\u0004(+\u001a9mS\u000e\f'+Z9vKN$8o\u00165jY\u0016$v\u000e]5d#V,W/\u001a3G_J$U\r\\3uS>t\u0007fA\f\u00022\u0005\u0001D/Z:u'R|\u0007OU3qY&\u001c\u0017MU3rk\u0016\u001cHo],iS2,Gk\u001c9jG\u0012+G.\u001a;j_:\u001cF/\u0019:uK\u0012D3\u0001GA\u0019\u00039\"Xm\u001d;NSb,G\rR3mKR,\u0017I\u001c3O_R$U\r\\3uKN#x\u000e\u001d*fa2L7-\u0019*fcV,7\u000f^:)\u0007e\t\t$A\u000fuKN$8\u000b^8q%\u0016\u0004H.[2b\u000fJ|W\u000f]:Cs\n\u0013xn[3sQ\rQ\u0012\u0011G\u00014i\u0016\u001cHo\u0015;paJ+\u0007\u000f\\5dCN+g\u000e^(oYf$v\u000eT5wK\u0006sGm\u00155viRLgn\u001a#po:\u0014%o\\6feND3aGA\u0019\u0003%\"Xm\u001d;Ti>\u0004(+\u001a9mS\u000e\f\u0017J\u001c;fe\n\u0013xn[3s!J|Go\\2pYZ+'o]5p]\"\u001aA$!\r\u0002aQ,7\u000f^*u_B\u0014V\r\u001d7jG\u00064u\u000e\u001c7poNLe\u000e^3s\u0005J|7.\u001a:Qe>$xnY8m-\u0016\u00148/[8o)\u0019\tI#!*\u0002(\"9\u0011qJ\u000fA\u0002\u0005E\u0003bBAU;\u0001\u0007\u0011\u0011M\u0001\"Kb\u0004Xm\u0019;fIN#x\u000e\u001d*fa2L7-\u0019*fcV,7\u000f\u001e,feNLwN\\\u0001\"CB\u0004H._*u_B\u0014V\r\u001d7jG\u0006\u0014Vm\u001d9p]N,7)\u00197mE\u0006\u001c7n\u001d\u000b\u0007\u0003S\ty+a0\t\u000f\u0005Ef\u00041\u0001\u00024\u0006)QM\u001d:peB!\u0011QWA^\u001b\t\t9LC\u0002\u0002:n\f\u0001\u0002\u001d:pi>\u001cw\u000e\\\u0005\u0005\u0003{\u000b9L\u0001\u0004FeJ|'o\u001d\u0005\b\u0003\u0003t\u0002\u0019AAb\u00031\u0019XM\u001c;SKF,Xm\u001d;t!\u0019\t)-!6\u0002\\:!\u0011qYAi\u001d\u0011\tI-a4\u000e\u0005\u0005-'bAAg#\u00061AH]8pizJ\u0011AV\u0005\u0004\u0003',\u0016a\u00029bG.\fw-Z\u0005\u0005\u0003/\fIN\u0001\u0003MSN$(bAAj+B\u0019\u0011Q\u001c\u0013\u000e\u0003\u0001\u00111bU3oiJ+\u0017/^3tiN1AeUAr\u0003S\u00042\u0001VAs\u0013\r\t9/\u0016\u0002\b!J|G-^2u!\r!\u00161^\u0005\u0004\u0003[,&\u0001D*fe&\fG.\u001b>bE2,\u0017a\u0002:fcV,7\u000f^\u000b\u0003\u0003g\u00042!!8\u000b\u0003!\u0011X-];fgR\u0004\u0013\u0001\u0005:fgB|gn]3DC2d'-Y2l+\t\tY\u0010E\u0004U\u0003{\u0014\t!!\u000b\n\u0007\u0005}XKA\u0005Gk:\u001cG/[8ocA\u0019\u0001Pa\u0001\n\u0007\t\u0015\u0011P\u0001\tBEN$(/Y2u%\u0016\u001c\bo\u001c8tK\u0006\t\"/Z:q_:\u001cXmQ1mY\n\f7m\u001b\u0011\u0015\r\u0005m'1\u0002B\u0007\u0011\u001d\ty/\u000ba\u0001\u0003gDq!a>*\u0001\u0004\tY0\u0001\u0003d_BLHCBAn\u0005'\u0011)\u0002C\u0005\u0002p*\u0002\n\u00111\u0001\u0002t\"I\u0011q\u001f\u0016\u0011\u0002\u0003\u0007\u00111`\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\u0011Y\u0002\r\u0003\u0003\u001e\t\u0005\u0002#B<\u0002\n\t}\u0001\u0003BA\t\u0005C!1\"!\u0006,\u0003\u0003\u0005\tQ!\u0001\u0002\u0018\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012TC\u0001B\u0014U\u0011\tYP!\u000b,\u0005\t-\u0002\u0003\u0002B\u0017\u0005oi!Aa\f\u000b\t\tE\"1G\u0001\nk:\u001c\u0007.Z2lK\u0012T1A!\u000eV\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0005s\u0011yCA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXC\u0001B !\u0011\u0011\tEa\u0013\u000e\u0005\t\r#\u0002\u0002B#\u0005\u000f\nA\u0001\\1oO*\u0011!\u0011J\u0001\u0005U\u00064\u0018-\u0003\u0003\u0003N\t\r#AB*ue&tw-\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\tU#1\f\t\u0004)\n]\u0013b\u0001B-+\n\u0019\u0011I\\=\t\u0011\tus&!AA\u0002}\u000b1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XC\u0001B2!\u0019\u0011)Ga\u001b\u0003V5\u0011!q\r\u0006\u0004\u0005S*\u0016AC2pY2,7\r^5p]&!!Q\u000eB4\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\t\tM$\u0011\u0010\t\u0004)\nU\u0014b\u0001B<+\n9!i\\8mK\u0006t\u0007\"\u0003B/c\u0005\u0005\t\u0019\u0001B+\u0003!A\u0017m\u001d5D_\u0012,G#A0\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"Aa\u0010\u0002\r\u0015\fX/\u00197t)\u0011\u0011\u0019Ha\"\t\u0013\tuC'!AA\u0002\tU\u0013AI1qa2LH*Z1eKJ\fe\u000eZ%teJ+7\u000f]8og\u0016\u001c\u0015\r\u001c7cC\u000e\\7\u000f\u0006\u0004\u0002*\t5%q\u0012\u0005\b\u0003c{\u0002\u0019AAZ\u0011\u001d\t\tm\ba\u0001\u0003\u0007\fA%\u00199qYf,\u0006\u000fZ1uK6+G/\u00193bi\u0006\u0014Vm\u001d9p]N,7)\u00197mE\u0006\u001c7n\u001d\u000b\u0007\u0003S\u0011)Ja&\t\u000f\u0005E\u0006\u00051\u0001\u00024\"9\u0011\u0011\u0019\u0011A\u0002\u0005\r\u0017\u0001D2sK\u0006$XmQ8oM&<GcA4\u0003\u001e\"9!qT\u0011A\u0002\u0005E\u0013AE5oi\u0016\u0014(I]8lKJ4VM]:j_:\f\u0011C]3qY&\u001c\u0017-Q:tS\u001etW.\u001a8u)\u0011\u0011)Ka+\u0011\u0007q\u00139+C\u0002\u0003*6\u0013\u0011CU3qY&\u001c\u0017-Q:tS\u001etW.\u001a8u\u0011\u001d\u0011iK\ta\u0001\u0005_\u000b\u0001B]3qY&\u001c\u0017m\u001d\t\u0006\u0003\u000b\u0014\tlX\u0005\u0005\u0005g\u000bINA\u0002TKF\f1\"\u001b8ji\u000e{g\u000e^3yiRQ!\u0011\u0018B`\u0005\u0007\u0014YNa8\u0011\u0007q\u0013Y,C\u0002\u0003>6\u0013\u0011cQ8oiJ|G\u000e\\3s\u0007>tG/\u001a=u\u0011\u001d\u0011\tm\ta\u0001\u0005_\u000bqA\u0019:pW\u0016\u00148\u000fC\u0004\u0003F\u000e\u0002\rAa2\u0002\rQ|\u0007/[2t!\u0019\u0011IM!5\u0003X:!!1\u001aBg!\r\tI-V\u0005\u0004\u0005\u001f,\u0016A\u0002)sK\u0012,g-\u0003\u0003\u0003T\nU'aA*fi*\u0019!qZ+\u0011\t\t%'\u0011\\\u0005\u0005\u0005\u001b\u0012)\u000e\u0003\u0004\u0003^\u000e\u0002\raX\u0001\u000e]Vl\u0007+\u0019:uSRLwN\\:\t\r\t\u00058\u00051\u0001`\u0003E\u0011X\r\u001d7jG\u0006$\u0018n\u001c8GC\u000e$xN]\u0001\f'\u0016tGOU3rk\u0016\u001cH\u000fE\u0002\u0002^Z\u001aRA\u000eBu\u0003S\u0004\"Ba;\u0003r\u0006M\u00181`An\u001b\t\u0011iOC\u0002\u0003pV\u000bqA];oi&lW-\u0003\u0003\u0003t\n5(!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8oeQ\u0011!Q]\u0001\u0006CB\u0004H.\u001f\u000b\u0007\u00037\u0014YP!@\t\u000f\u0005=\u0018\b1\u0001\u0002t\"9\u0011q_\u001dA\u0002\u0005m\u0018aB;oCB\u0004H.\u001f\u000b\u0005\u0007\u0007\u0019y\u0001E\u0003U\u0007\u000b\u0019I!C\u0002\u0004\bU\u0013aa\u00149uS>t\u0007c\u0002+\u0004\f\u0005M\u00181`\u0005\u0004\u0007\u001b)&A\u0002+va2,'\u0007C\u0005\u0004\u0012i\n\t\u00111\u0001\u0002\\\u0006\u0019\u0001\u0010\n\u0019\u0003A5{7m[\"p]R\u0014x\u000e\u001c7fe\n\u0013xn[3s%\u0016\fX/Z:u\u0005\u0006$8\r[\n\u0004w\r]\u0001c\u0001/\u0004\u001a%\u001911D'\u0003I\u0005\u00137\u000f\u001e:bGR\u001cuN\u001c;s_2dWM\u001d\"s_.,'OU3rk\u0016\u001cHOQ1uG\"\fqaY8oi\u0016DH\u000f\u0006\u0004\u0004\"\r\r2Q\u0005\t\u0004\u0003;\\\u0004bBB\u000f}\u0001\u0007!\u0011\u0018\u0005\bKz\u0002\n\u00111\u0001h\u0003)\u0019XM\u001c;Fm\u0016tGo]\u000b\u0003\u0007W\u0001ba!\f\u00044\r]RBAB\u0018\u0015\u0011\u0019\tDa\u001a\u0002\u000f5,H/\u00192mK&!1QGB\u0018\u0005)a\u0015n\u001d;Ck\u001a4WM\u001d\t\u00049\u000ee\u0012bAB\u001e\u001b\ny1i\u001c8ue>dG.\u001a:Fm\u0016tG/A\u0006tK:$XI^3oiN\u0004SCAB!!\u001d\u0019ica\u0011`\u0007\u000fJAa!\u0012\u00040\t\u0019Q*\u00199\u0011\r\r521GAn\u00035\u0019XM\u001c;SKF,Xm\u001d;tA\u0005I1/\u001a8e\u000bZ,g\u000e\u001e\u000b\u0005\u0003S\u0019y\u0005C\u0004\u0004R\r\u0003\raa\u000e\u0002\u000b\u00154XM\u001c;\u0002\u0017M,g\u000e\u001a*fcV,7\u000f\u001e\u000b\t\u0003S\u00199fa\u0017\u0004^!11\u0011\f#A\u0002}\u000b\u0001B\u0019:pW\u0016\u0014\u0018\n\u001a\u0005\b\u0003_$\u0005\u0019AAz\u0011%\u0019y\u0006\u0012I\u0001\u0002\u0004\tY0\u0001\u0005dC2d'-Y2l\u0003u\u0019w\u000e\u001c7fGR\u001cFo\u001c9SKBd\u0017nY1SKF,Xm\u001d;t\r>\u0014H\u0003BB3\u0007[\u0002b!!2\u0002V\u000e\u001d\u0004c\u0001=\u0004j%\u001911N=\u0003%M#x\u000e\u001d*fa2L7-\u0019*fcV,7\u000f\u001e\u0005\u0007\u00073*\u0005\u0019A0\u0002A\r|G\u000e\\3diV\u0003H-\u0019;f\u001b\u0016$\u0018\rZ1uCJ+\u0017/^3tiN4uN\u001d\u000b\u0005\u0007g\u001aY\b\u0005\u0004\u0002F\u0006U7Q\u000f\t\u0004q\u000e]\u0014bAB=s\n)R\u000b\u001d3bi\u0016lU\r^1eCR\f'+Z9vKN$\bBBB-\r\u0002\u0007q,\u0001\u0010d_2dWm\u0019;MK\u0006$WM]!oI&\u001b(OU3rk\u0016\u001cHo\u001d$peR!1\u0011QBE!\u0019\t)-!6\u0004\u0004B\u0019\u0001p!\"\n\u0007\r\u001d\u0015PA\nMK\u0006$WM]!oI&\u001b(OU3rk\u0016\u001cH\u000f\u0003\u0004\u0004Z\u001d\u0003\raX\u0001!\u001b>\u001c7nQ8oiJ|G\u000e\\3s\u0005J|7.\u001a:SKF,Xm\u001d;CCR\u001c\u0007\u000eE\u0002\u0002^&\u001b\"!S*\u0015\u0005\r5\u0015a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$#'\u0006\u0002\u0004\u0018*\u001aqM!\u000b")
public class ControllerChannelManagerTest {
    private volatile ControllerChannelManagerTest$SentRequest$ SentRequest$module;
    private volatile ControllerChannelManagerTest$MockControllerBrokerRequestBatch$ MockControllerBrokerRequestBatch$module;
    private final int controllerId;
    private final int controllerEpoch;
    private final KafkaConfig kafka$controller$ControllerChannelManagerTest$$config = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(this.controllerId(), "zkConnect", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20()));
    private final StateChangeLogger kafka$controller$ControllerChannelManagerTest$$logger = new StateChangeLogger(this.controllerId(), true, (Option)None$.MODULE$);

    private ControllerChannelManagerTest$SentRequest$ SentRequest() {
        if (this.SentRequest$module == null) {
            this.SentRequest$lzycompute$1();
        }
        return this.SentRequest$module;
    }

    private ControllerChannelManagerTest$MockControllerBrokerRequestBatch$ MockControllerBrokerRequestBatch() {
        if (this.MockControllerBrokerRequestBatch$module == null) {
            this.MockControllerBrokerRequestBatch$lzycompute$1();
        }
        return this.MockControllerBrokerRequestBatch$module;
    }

    private int controllerId() {
        return this.controllerId;
    }

    private int controllerEpoch() {
        return this.controllerEpoch;
    }

    public KafkaConfig kafka$controller$ControllerChannelManagerTest$$config() {
        return this.kafka$controller$ControllerChannelManagerTest$$config;
    }

    public StateChangeLogger kafka$controller$ControllerChannelManagerTest$$logger() {
        return this.kafka$controller$ControllerChannelManagerTest$$logger;
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testLeaderAndIsrRequestSent() {
        void var9_15;
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        void $minus$greater$extension_y2;
        void $minus$greater$extension_$this2;
        void $minus$greater$extension_y3;
        void $minus$greater$extension_$this3;
        ControllerContext context = this.initContext((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))), (scala.collection.immutable.Set<String>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo", "bar"}))), 2, 3);
        MockControllerBrokerRequestBatch batch = new MockControllerBrokerRequestBatch(context, this.MockControllerBrokerRequestBatch().$lessinit$greater$default$2());
        Tuple2[] tuple2Array = new Tuple2[3];
        LeaderAndIsr leaderAndIsr = LeaderAndIsr$.MODULE$.apply(1, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})));
        Object object = Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 0));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this3, (Object)$minus$greater$extension_y3);
        LeaderAndIsr leaderAndIsr2 = LeaderAndIsr$.MODULE$.apply(2, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})));
        Object object2 = Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 1));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[1] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y2);
        LeaderAndIsr leaderAndIsr3 = LeaderAndIsr$.MODULE$.apply(3, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 3})));
        Object object3 = Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("bar", 1));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[2] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        scala.collection.immutable.Map partitions = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array));
        batch.newBatch();
        partitions.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            ControllerChannelManagerTest.$anonfun$testLeaderAndIsrRequestSent$1(this, context, batch, x0$1);
            return BoxedUnit.UNIT;
        });
        batch.sendRequestsToBrokers(this.controllerEpoch());
        List<LeaderAndIsrRequest> leaderAndIsrRequests = batch.collectLeaderAndIsrRequestsFor(2);
        List<UpdateMetadataRequest> updateMetadataRequests = batch.collectUpdateMetadataRequestsFor(2);
        Assert.assertEquals((long)1L, (long)leaderAndIsrRequests.size());
        Assert.assertEquals((long)1L, (long)updateMetadataRequests.size());
        LeaderAndIsrRequest leaderAndIsrRequest = (LeaderAndIsrRequest)leaderAndIsrRequests.head();
        Assert.assertEquals((long)this.controllerId(), (long)leaderAndIsrRequest.controllerId());
        Assert.assertEquals((long)this.controllerEpoch(), (long)leaderAndIsrRequest.controllerEpoch());
        Assert.assertEquals((Object)partitions.keySet(), (Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(leaderAndIsrRequest.partitionStates()).asScala()).map((Function1 & Serializable & scala.Serializable)p -> new TopicPartition(p.topicName(), p.partitionIndex()), Iterable$.MODULE$.canBuildFrom())).toSet());
        Assert.assertEquals((Object)partitions.map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            if (x0$2 == null) {
                throw new MatchError(null);
            }
            TopicPartition k = (TopicPartition)x0$2._1();
            LeaderAndIsr v = (LeaderAndIsr)x0$2._2();
            Tuple2 tuple2 = new Tuple2((Object)k, (Object)BoxesRunTime.boxToInteger((int)v.leader()));
            return tuple2;
        }, scala.collection.immutable.Map$.MODULE$.canBuildFrom()), (Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(leaderAndIsrRequest.partitionStates()).asScala()).map((Function1 & Serializable & scala.Serializable)p -> {
            void $minus$greater$extension_y;
            void $minus$greater$extension_$this;
            Integer n = BoxesRunTime.boxToInteger((int)p.leader());
            Object object = Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(p.topicName(), p.partitionIndex()));
            if (Predef.ArrowAssoc$.MODULE$ == null) {
                throw null;
            }
            return new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        }, Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()));
        Assert.assertEquals((Object)partitions.map((Function1 & Serializable & scala.Serializable)x0$3 -> {
            if (x0$3 == null) {
                throw new MatchError(null);
            }
            TopicPartition k = (TopicPartition)x0$3._1();
            LeaderAndIsr v = (LeaderAndIsr)x0$3._2();
            Tuple2 tuple2 = new Tuple2((Object)k, (Object)v.isr());
            return tuple2;
        }, scala.collection.immutable.Map$.MODULE$.canBuildFrom()), (Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(leaderAndIsrRequest.partitionStates()).asScala()).map((Function1 & Serializable & scala.Serializable)p -> {
            void $minus$greater$extension_y;
            void $minus$greater$extension_$this;
            Object object = JavaConverters$.MODULE$.asScalaBufferConverter(p.isr()).asScala();
            Object object2 = Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(p.topicName(), p.partitionIndex()));
            if (Predef.ArrowAssoc$.MODULE$ == null) {
                throw null;
            }
            return new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        }, Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()));
        this.applyLeaderAndIsrResponseCallbacks(Errors.NONE, (List<SentRequest>)((ListBuffer)batch.sentRequests().apply((Object)BoxesRunTime.boxToInteger((int)2))).toList());
        Assert.assertEquals((long)1L, (long)batch.sentEvents().size());
        ControllerEvent controllerEvent = (ControllerEvent)batch.sentEvents().head();
        if (!(controllerEvent instanceof LeaderAndIsrResponseReceived)) {
            throw new MatchError((Object)controllerEvent);
        }
        LeaderAndIsrResponseReceived leaderAndIsrResponseReceived = (LeaderAndIsrResponseReceived)controllerEvent;
        LeaderAndIsrResponse leaderAndIsrResponse = leaderAndIsrResponseReceived.leaderAndIsrResponse();
        int n = leaderAndIsrResponseReceived.brokerId();
        Assert.assertEquals((long)2L, (long)n);
        Assert.assertEquals((Object)partitions.keySet(), (Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(var9_15.partitions()).asScala()).map((Function1 & Serializable & scala.Serializable)p -> new TopicPartition(p.topicName(), p.partitionIndex()), Buffer$.MODULE$.canBuildFrom())).toSet());
    }

    @Test
    public void testLeaderAndIsrRequestIsNew() {
        ControllerContext context = this.initContext((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))), (scala.collection.immutable.Set<String>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo", "bar"}))), 2, 3);
        MockControllerBrokerRequestBatch batch = new MockControllerBrokerRequestBatch(context, this.MockControllerBrokerRequestBatch().$lessinit$greater$default$2());
        TopicPartition partition = new TopicPartition("foo", 0);
        LeaderAndIsr leaderAndIsr = LeaderAndIsr$.MODULE$.apply(1, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})));
        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(leaderAndIsr, this.controllerEpoch());
        context.partitionLeadershipInfo().put((Object)partition, (Object)leaderIsrAndControllerEpoch);
        batch.newBatch();
        batch.addLeaderAndIsrRequestForBrokers((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})), partition, leaderIsrAndControllerEpoch, this.replicaAssignment((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})))), true);
        batch.addLeaderAndIsrRequestForBrokers((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})), partition, leaderIsrAndControllerEpoch, this.replicaAssignment((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})))), false);
        batch.sendRequestsToBrokers(this.controllerEpoch());
        List<LeaderAndIsrRequest> leaderAndIsrRequests = batch.collectLeaderAndIsrRequestsFor(2);
        List<UpdateMetadataRequest> updateMetadataRequests = batch.collectUpdateMetadataRequestsFor(2);
        Assert.assertEquals((long)1L, (long)leaderAndIsrRequests.size());
        Assert.assertEquals((long)1L, (long)updateMetadataRequests.size());
        LeaderAndIsrRequest leaderAndIsrRequest = (LeaderAndIsrRequest)leaderAndIsrRequests.head();
        Iterable partitionStates = (Iterable)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(leaderAndIsrRequest.partitionStates()).asScala();
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partition})), (Object)partitionStates.map((Function1 & Serializable & scala.Serializable)p -> new TopicPartition(p.topicName(), p.partitionIndex()), Iterable$.MODULE$.canBuildFrom()));
        Option partitionState = partitionStates.find((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)ControllerChannelManagerTest.$anonfun$testLeaderAndIsrRequestIsNew$2(partition, p)));
        if (partitionState == null) {
            throw null;
        }
        Object object = partitionState.isEmpty() ? None$.MODULE$ : new Some((Object)BoxesRunTime.boxToBoolean((boolean)((LeaderAndIsrRequestData.LeaderAndIsrPartitionState)partitionState.get()).isNew()));
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToBoolean((boolean)true)), (Object)object);
    }

    @Test
    public void testLeaderAndIsrRequestSentToLiveOrShuttingDownBrokers() {
        ControllerContext context = this.initContext((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))), (scala.collection.immutable.Set<String>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo", "bar"}))), 2, 3);
        MockControllerBrokerRequestBatch batch = new MockControllerBrokerRequestBatch(context, this.MockControllerBrokerRequestBatch().$lessinit$greater$default$2());
        context.shuttingDownBrokerIds().add((Object)BoxesRunTime.boxToInteger((int)2));
        context.removeLiveBrokers((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3})));
        TopicPartition partition = new TopicPartition("foo", 0);
        LeaderAndIsr leaderAndIsr = LeaderAndIsr$.MODULE$.apply(1, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})));
        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(leaderAndIsr, this.controllerEpoch());
        context.partitionLeadershipInfo().put((Object)partition, (Object)leaderIsrAndControllerEpoch);
        batch.newBatch();
        batch.addLeaderAndIsrRequestForBrokers((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), partition, leaderIsrAndControllerEpoch, this.replicaAssignment((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})))), false);
        batch.sendRequestsToBrokers(this.controllerEpoch());
        Assert.assertEquals((long)0L, (long)batch.sentEvents().size());
        Assert.assertEquals((long)2L, (long)batch.sentRequests().size());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})), (Object)batch.sentRequests().keySet());
        ((IterableLike)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2}))).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)brokerId -> {
            List<LeaderAndIsrRequest> leaderAndIsrRequests = batch.collectLeaderAndIsrRequestsFor(brokerId);
            List<UpdateMetadataRequest> updateMetadataRequests = batch.collectUpdateMetadataRequestsFor(brokerId);
            Assert.assertEquals((long)1L, (long)leaderAndIsrRequests.size());
            Assert.assertEquals((long)1L, (long)updateMetadataRequests.size());
            LeaderAndIsrRequest leaderAndIsrRequest = (LeaderAndIsrRequest)leaderAndIsrRequests.head();
            Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partition})), (Object)((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(leaderAndIsrRequest.partitionStates()).asScala()).map((Function1 & Serializable & scala.Serializable)p -> new TopicPartition(p.topicName(), p.partitionIndex()), Iterable$.MODULE$.canBuildFrom()));
        });
    }

    @Test
    public void testLeaderAndIsrInterBrokerProtocolVersion() {
        this.testLeaderAndIsrRequestFollowsInterBrokerProtocolVersion(ApiVersion$.MODULE$.latestVersion(), ApiKeys.LEADER_AND_ISR.latestVersion());
        ApiVersion$.MODULE$.allVersions().foreach((Function1 & Serializable & scala.Serializable)apiVersion -> {
            ControllerChannelManagerTest.$anonfun$testLeaderAndIsrInterBrokerProtocolVersion$1(this, apiVersion);
            return BoxedUnit.UNIT;
        });
    }

    private void testLeaderAndIsrRequestFollowsInterBrokerProtocolVersion(ApiVersion interBrokerProtocolVersion, short expectedLeaderAndIsrVersion) {
        ControllerContext context = this.initContext((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))), (scala.collection.immutable.Set<String>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo", "bar"}))), 2, 3);
        KafkaConfig config = this.createConfig(interBrokerProtocolVersion);
        MockControllerBrokerRequestBatch batch = new MockControllerBrokerRequestBatch(context, config);
        TopicPartition partition = new TopicPartition("foo", 0);
        LeaderAndIsr leaderAndIsr = LeaderAndIsr$.MODULE$.apply(1, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})));
        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(leaderAndIsr, this.controllerEpoch());
        context.partitionLeadershipInfo().put((Object)partition, (Object)leaderIsrAndControllerEpoch);
        batch.newBatch();
        batch.addLeaderAndIsrRequestForBrokers((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})), partition, leaderIsrAndControllerEpoch, this.replicaAssignment((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})))), false);
        batch.sendRequestsToBrokers(this.controllerEpoch());
        List<LeaderAndIsrRequest> leaderAndIsrRequests = batch.collectLeaderAndIsrRequestsFor(2);
        Assert.assertEquals((long)1L, (long)leaderAndIsrRequests.size());
        Assert.assertEquals((String)new StringBuilder(24).append("IBP ").append(interBrokerProtocolVersion).append(" should use version ").append(expectedLeaderAndIsrVersion).toString(), (long)expectedLeaderAndIsrVersion, (long)((AbstractRequest)leaderAndIsrRequests.head()).version());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testUpdateMetadataRequestSent() {
        void var9_15;
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        void $minus$greater$extension_y2;
        void $minus$greater$extension_$this2;
        void $minus$greater$extension_y3;
        void $minus$greater$extension_$this3;
        ControllerContext context = this.initContext((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))), (scala.collection.immutable.Set<String>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo", "bar"}))), 2, 3);
        MockControllerBrokerRequestBatch batch = new MockControllerBrokerRequestBatch(context, this.MockControllerBrokerRequestBatch().$lessinit$greater$default$2());
        Tuple2[] tuple2Array = new Tuple2[3];
        LeaderAndIsr leaderAndIsr = LeaderAndIsr$.MODULE$.apply(1, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})));
        Object object = Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 0));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this3, (Object)$minus$greater$extension_y3);
        LeaderAndIsr leaderAndIsr2 = LeaderAndIsr$.MODULE$.apply(2, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})));
        Object object2 = Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 1));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[1] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y2);
        LeaderAndIsr leaderAndIsr3 = LeaderAndIsr$.MODULE$.apply(3, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 3})));
        Object object3 = Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("bar", 1));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[2] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        scala.collection.immutable.Map partitions = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array));
        partitions.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            TopicPartition partition = (TopicPartition)x0$1._1();
            LeaderAndIsr leaderAndIsr = (LeaderAndIsr)x0$1._2();
            Option option = context.partitionLeadershipInfo().put((Object)partition, (Object)new LeaderIsrAndControllerEpoch(leaderAndIsr, this.controllerEpoch()));
            return option;
        });
        batch.newBatch();
        batch.addUpdateMetadataRequestForBrokers((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})), (Set)partitions.keySet());
        batch.sendRequestsToBrokers(this.controllerEpoch());
        List<UpdateMetadataRequest> updateMetadataRequests = batch.collectUpdateMetadataRequestsFor(2);
        Assert.assertEquals((long)1L, (long)updateMetadataRequests.size());
        UpdateMetadataRequest updateMetadataRequest = (UpdateMetadataRequest)updateMetadataRequests.head();
        Buffer partitionStates = ((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(updateMetadataRequest.partitionStates()).asScala()).toBuffer();
        Assert.assertEquals((long)3L, (long)partitionStates.size());
        Assert.assertEquals((Object)partitions.map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            if (x0$2 == null) {
                throw new MatchError(null);
            }
            TopicPartition k = (TopicPartition)x0$2._1();
            LeaderAndIsr v = (LeaderAndIsr)x0$2._2();
            Tuple2 tuple2 = new Tuple2((Object)k, (Object)BoxesRunTime.boxToInteger((int)v.leader()));
            return tuple2;
        }, scala.collection.immutable.Map$.MODULE$.canBuildFrom()), (Object)((TraversableOnce)partitionStates.map((Function1 & Serializable & scala.Serializable)ps -> new Tuple2((Object)new TopicPartition(ps.topicName(), ps.partitionIndex()), (Object)BoxesRunTime.boxToInteger((int)ps.leader())), Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()));
        Assert.assertEquals((Object)partitions.map((Function1 & Serializable & scala.Serializable)x0$3 -> {
            if (x0$3 == null) {
                throw new MatchError(null);
            }
            TopicPartition k = (TopicPartition)x0$3._1();
            LeaderAndIsr v = (LeaderAndIsr)x0$3._2();
            Tuple2 tuple2 = new Tuple2((Object)k, (Object)v.isr());
            return tuple2;
        }, scala.collection.immutable.Map$.MODULE$.canBuildFrom()), (Object)((TraversableOnce)partitionStates.map((Function1 & Serializable & scala.Serializable)ps -> new Tuple2((Object)new TopicPartition(ps.topicName(), ps.partitionIndex()), JavaConverters$.MODULE$.asScalaBufferConverter(ps.isr()).asScala()), Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()));
        Assert.assertEquals((long)this.controllerId(), (long)updateMetadataRequest.controllerId());
        Assert.assertEquals((long)this.controllerEpoch(), (long)updateMetadataRequest.controllerEpoch());
        Assert.assertEquals((long)3L, (long)updateMetadataRequest.liveBrokers().size());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(updateMetadataRequest.liveBrokers()).asScala()).map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToInteger((int)x$3.id()), Buffer$.MODULE$.canBuildFrom())).toSet());
        this.applyUpdateMetadataResponseCallbacks(Errors.STALE_BROKER_EPOCH, (List<SentRequest>)((ListBuffer)batch.sentRequests().apply((Object)BoxesRunTime.boxToInteger((int)2))).toList());
        Assert.assertEquals((long)1L, (long)batch.sentEvents().size());
        ControllerEvent controllerEvent = (ControllerEvent)batch.sentEvents().head();
        if (!(controllerEvent instanceof UpdateMetadataResponseReceived)) {
            throw new MatchError((Object)controllerEvent);
        }
        UpdateMetadataResponseReceived updateMetadataResponseReceived = (UpdateMetadataResponseReceived)controllerEvent;
        UpdateMetadataResponse updateMetadataResponse = updateMetadataResponseReceived.updateMetadataResponse();
        int n = updateMetadataResponseReceived.brokerId();
        Assert.assertEquals((long)2L, (long)n);
        Assert.assertEquals((Object)Errors.STALE_BROKER_EPOCH, (Object)var9_15.error());
    }

    @Test
    public void testUpdateMetadataDoesNotIncludePartitionsWithoutLeaderAndIsr() {
        ControllerContext context = this.initContext((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))), (scala.collection.immutable.Set<String>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo", "bar"}))), 2, 3);
        MockControllerBrokerRequestBatch batch = new MockControllerBrokerRequestBatch(context, this.MockControllerBrokerRequestBatch().$lessinit$greater$default$2());
        scala.collection.immutable.Set partitions = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("foo", 0), new TopicPartition("foo", 1), new TopicPartition("bar", 1)}));
        batch.newBatch();
        batch.addUpdateMetadataRequestForBrokers((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})), (Set)partitions);
        batch.sendRequestsToBrokers(this.controllerEpoch());
        Assert.assertEquals((long)0L, (long)batch.sentEvents().size());
        Assert.assertEquals((long)1L, (long)batch.sentRequests().size());
        Assert.assertTrue((boolean)batch.sentRequests().contains((Object)BoxesRunTime.boxToInteger((int)2)));
        List<UpdateMetadataRequest> updateMetadataRequests = batch.collectUpdateMetadataRequestsFor(2);
        Assert.assertEquals((long)1L, (long)updateMetadataRequests.size());
        UpdateMetadataRequest updateMetadataRequest = (UpdateMetadataRequest)updateMetadataRequests.head();
        Assert.assertEquals((long)0L, (long)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(updateMetadataRequest.partitionStates()).asScala()).size());
        Assert.assertEquals((long)3L, (long)updateMetadataRequest.liveBrokers().size());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(updateMetadataRequest.liveBrokers()).asScala()).map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToInteger((int)x$5.id()), Buffer$.MODULE$.canBuildFrom())).toSet());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testUpdateMetadataRequestDuringTopicDeletion() {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        void $minus$greater$extension_y2;
        void $minus$greater$extension_$this2;
        void $minus$greater$extension_y3;
        void $minus$greater$extension_$this3;
        ControllerContext context = this.initContext((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))), (scala.collection.immutable.Set<String>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo", "bar"}))), 2, 3);
        MockControllerBrokerRequestBatch batch = new MockControllerBrokerRequestBatch(context, this.MockControllerBrokerRequestBatch().$lessinit$greater$default$2());
        Tuple2[] tuple2Array = new Tuple2[3];
        LeaderAndIsr leaderAndIsr = LeaderAndIsr$.MODULE$.apply(1, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})));
        Object object = Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 0));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this3, (Object)$minus$greater$extension_y3);
        LeaderAndIsr leaderAndIsr2 = LeaderAndIsr$.MODULE$.apply(2, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})));
        Object object2 = Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 1));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[1] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y2);
        LeaderAndIsr leaderAndIsr3 = LeaderAndIsr$.MODULE$.apply(3, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 3})));
        Object object3 = Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("bar", 1));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[2] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        scala.collection.immutable.Map partitions = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array));
        partitions.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            TopicPartition partition = (TopicPartition)x0$1._1();
            LeaderAndIsr leaderAndIsr = (LeaderAndIsr)x0$1._2();
            Option option = context.partitionLeadershipInfo().put((Object)partition, (Object)new LeaderIsrAndControllerEpoch(leaderAndIsr, this.controllerEpoch()));
            return option;
        });
        context.queueTopicDeletion((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo"})));
        batch.newBatch();
        batch.addUpdateMetadataRequestForBrokers((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})), (Set)partitions.keySet());
        batch.sendRequestsToBrokers(this.controllerEpoch());
        List<UpdateMetadataRequest> updateMetadataRequests = batch.collectUpdateMetadataRequestsFor(2);
        Assert.assertEquals((long)1L, (long)updateMetadataRequests.size());
        UpdateMetadataRequest updateMetadataRequest = (UpdateMetadataRequest)updateMetadataRequests.head();
        Assert.assertEquals((long)3L, (long)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(updateMetadataRequest.partitionStates()).asScala()).size());
        Assert.assertTrue((boolean)((IterableLike)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(updateMetadataRequest.partitionStates()).asScala()).filter((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)ControllerChannelManagerTest.$anonfun$testUpdateMetadataRequestDuringTopicDeletion$2(x$6)))).map((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToInteger((int)x$7.leader()), Iterable$.MODULE$.canBuildFrom())).forall((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)leaderId -> leaderId == LeaderAndIsr$.MODULE$.LeaderDuringDelete()));
        Assert.assertEquals((Object)((TraversableLike)partitions.filter((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)ControllerChannelManagerTest.$anonfun$testUpdateMetadataRequestDuringTopicDeletion$5(x0$2)))).map((Function1 & Serializable & scala.Serializable)x0$3 -> {
            if (x0$3 == null) {
                throw new MatchError(null);
            }
            TopicPartition k = (TopicPartition)x0$3._1();
            LeaderAndIsr v = (LeaderAndIsr)x0$3._2();
            Tuple2 tuple2 = new Tuple2((Object)k, (Object)BoxesRunTime.boxToInteger((int)v.leader()));
            return tuple2;
        }, scala.collection.immutable.Map$.MODULE$.canBuildFrom()), (Object)((TraversableOnce)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(updateMetadataRequest.partitionStates()).asScala()).filter((Function1 & Serializable & scala.Serializable)ps -> BoxesRunTime.boxToBoolean((boolean)ControllerChannelManagerTest.$anonfun$testUpdateMetadataRequestDuringTopicDeletion$7(ps)))).map((Function1 & Serializable & scala.Serializable)ps -> new Tuple2((Object)new TopicPartition(ps.topicName(), ps.partitionIndex()), (Object)BoxesRunTime.boxToInteger((int)ps.leader())), Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()));
        Assert.assertEquals((Object)partitions.map((Function1 & Serializable & scala.Serializable)x0$4 -> {
            if (x0$4 == null) {
                throw new MatchError(null);
            }
            TopicPartition k = (TopicPartition)x0$4._1();
            LeaderAndIsr v = (LeaderAndIsr)x0$4._2();
            Tuple2 tuple2 = new Tuple2((Object)k, (Object)v.isr());
            return tuple2;
        }, scala.collection.immutable.Map$.MODULE$.canBuildFrom()), (Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(updateMetadataRequest.partitionStates()).asScala()).map((Function1 & Serializable & scala.Serializable)ps -> new Tuple2((Object)new TopicPartition(ps.topicName(), ps.partitionIndex()), JavaConverters$.MODULE$.asScalaBufferConverter(ps.isr()).asScala()), Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()));
        Assert.assertEquals((long)3L, (long)updateMetadataRequest.liveBrokers().size());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(updateMetadataRequest.liveBrokers()).asScala()).map((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToInteger((int)x$8.id()), Buffer$.MODULE$.canBuildFrom())).toSet());
    }

    @Test
    public void testUpdateMetadataIncludesLiveOrShuttingDownBrokers() {
        ControllerContext context = this.initContext((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))), (scala.collection.immutable.Set<String>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo", "bar"}))), 2, 3);
        MockControllerBrokerRequestBatch batch = new MockControllerBrokerRequestBatch(context, this.MockControllerBrokerRequestBatch().$lessinit$greater$default$2());
        context.shuttingDownBrokerIds().add((Object)BoxesRunTime.boxToInteger((int)2));
        context.removeLiveBrokers((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3})));
        batch.newBatch();
        batch.addUpdateMetadataRequestForBrokers((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Set)Predef$.MODULE$.Set().empty());
        batch.sendRequestsToBrokers(this.controllerEpoch());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})), (Object)batch.sentRequests().keySet());
        ((IterableLike)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2}))).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)brokerId -> {
            List<UpdateMetadataRequest> updateMetadataRequests = batch.collectUpdateMetadataRequestsFor(brokerId);
            Assert.assertEquals((long)1L, (long)updateMetadataRequests.size());
            UpdateMetadataRequest updateMetadataRequest = (UpdateMetadataRequest)updateMetadataRequests.head();
            Assert.assertEquals((long)0L, (long)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(updateMetadataRequest.partitionStates()).asScala()).size());
            Assert.assertEquals((long)2L, (long)updateMetadataRequest.liveBrokers().size());
            Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})), (Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(updateMetadataRequest.liveBrokers()).asScala()).map((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToInteger((int)x$9.id()), Buffer$.MODULE$.canBuildFrom())).toSet());
        });
    }

    @Test
    public void testUpdateMetadataInterBrokerProtocolVersion() {
        this.testUpdateMetadataFollowsInterBrokerProtocolVersion(ApiVersion$.MODULE$.latestVersion(), ApiKeys.UPDATE_METADATA.latestVersion());
        ApiVersion$.MODULE$.allVersions().foreach((Function1 & Serializable & scala.Serializable)apiVersion -> {
            ControllerChannelManagerTest.$anonfun$testUpdateMetadataInterBrokerProtocolVersion$1(this, apiVersion);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    private void testUpdateMetadataFollowsInterBrokerProtocolVersion(ApiVersion interBrokerProtocolVersion, short expectedUpdateMetadataVersion) {
        boolean bl;
        String string;
        block9: {
            Object object;
            void map_bf;
            ControllerContext context = this.initContext((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))), (scala.collection.immutable.Set<String>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo", "bar"}))), 2, 3);
            KafkaConfig config = this.createConfig(interBrokerProtocolVersion);
            MockControllerBrokerRequestBatch batch = new MockControllerBrokerRequestBatch(context, config);
            batch.newBatch();
            batch.addUpdateMetadataRequestForBrokers((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})), (Set)Predef$.MODULE$.Set().empty());
            batch.sendRequestsToBrokers(this.controllerEpoch());
            Assert.assertEquals((long)0L, (long)batch.sentEvents().size());
            Assert.assertEquals((long)1L, (long)batch.sentRequests().size());
            Assert.assertTrue((boolean)batch.sentRequests().contains((Object)BoxesRunTime.boxToInteger((int)2)));
            List<UpdateMetadataRequest> requests = batch.collectUpdateMetadataRequestsFor(2);
            CanBuildFrom canBuildFrom = List$.MODULE$.canBuildFrom();
            Function1 & Serializable & scala.Serializable intersect = (Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToShort((short)x$10.version());
            if (requests == null) {
                throw null;
            }
            if (map_bf == List$.MODULE$.ReusableCBF()) {
                if (requests == Nil$.MODULE$) {
                    object = Nil$.MODULE$;
                } else {
                    .colon.colon map_h;
                    .colon.colon map_t = map_h = new .colon.colon((Object)BoxesRunTime.boxToShort((short)((UpdateMetadataRequest)requests.head()).version()), (List)Nil$.MODULE$);
                    for (List map_rest = (List)requests.tail(); map_rest != Nil$.MODULE$; map_rest = (List)map_rest.tail()) {
                        .colon.colon map_nx = new .colon.colon((Object)BoxesRunTime.boxToShort((short)((UpdateMetadataRequest)map_rest.head()).version()), (List)Nil$.MODULE$);
                        map_t.tl_$eq((List)map_nx);
                        map_t = map_nx;
                    }
                    object = map_h;
                }
            } else {
                void map_f;
                object = TraversableLike.map$(requests, (Function1)map_f, (CanBuildFrom)map_bf);
            }
            List allVersions = (List)object;
            string = new StringBuilder(45).append("IBP ").append(interBrokerProtocolVersion).append(" should use version ").append(expectedUpdateMetadataVersion).append(", ").append("but found versions ").append(allVersions).toString();
            if (allVersions == null) {
                throw null;
            }
            List forall_these = allVersions;
            while (!forall_these.isEmpty()) {
                Object object2 = forall_these.head();
                if (!ControllerChannelManagerTest.$anonfun$testUpdateMetadataFollowsInterBrokerProtocolVersion$2(expectedUpdateMetadataVersion, BoxesRunTime.unboxToShort((Object)object2))) {
                    bl = false;
                    break block9;
                }
                forall_these = (LinearSeqOptimized)forall_these.tail();
            }
            bl = true;
        }
        Assert.assertTrue((String)string, (boolean)bl);
    }

    @Test
    public void testStopReplicaRequestSent() {
        ControllerContext context = this.initContext((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))), (scala.collection.immutable.Set<String>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo", "bar"}))), 2, 3);
        MockControllerBrokerRequestBatch batch = new MockControllerBrokerRequestBatch(context, this.MockControllerBrokerRequestBatch().$lessinit$greater$default$2());
        scala.collection.immutable.Set partitions = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("foo", 0), new TopicPartition("foo", 1), new TopicPartition("bar", 1)}));
        batch.newBatch();
        partitions.foreach((Function1 & Serializable & scala.Serializable)partition -> {
            batch.addStopReplicaRequestForBrokers((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})), partition, false);
            return BoxedUnit.UNIT;
        });
        batch.sendRequestsToBrokers(this.controllerEpoch());
        Assert.assertEquals((long)0L, (long)batch.sentEvents().size());
        Assert.assertEquals((long)1L, (long)batch.sentRequests().size());
        Assert.assertTrue((boolean)batch.sentRequests().contains((Object)BoxesRunTime.boxToInteger((int)2)));
        ListBuffer sentRequests = (ListBuffer)batch.sentRequests().apply((Object)BoxesRunTime.boxToInteger((int)2));
        Assert.assertEquals((long)1L, (long)sentRequests.size());
        List<StopReplicaRequest> sentStopReplicaRequests = batch.collectStopReplicaRequestsFor(2);
        Assert.assertEquals((long)1L, (long)sentStopReplicaRequests.size());
        StopReplicaRequest stopReplicaRequest = (StopReplicaRequest)sentStopReplicaRequests.head();
        Assert.assertFalse((boolean)stopReplicaRequest.deletePartitions());
        Assert.assertEquals((Object)partitions, (Object)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(stopReplicaRequest.partitions()).asScala()).toSet());
        this.applyStopReplicaResponseCallbacks(Errors.NONE, (List<SentRequest>)((ListBuffer)batch.sentRequests().apply((Object)BoxesRunTime.boxToInteger((int)2))).toList());
        Assert.assertEquals((long)0L, (long)batch.sentEvents().size());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testStopReplicaRequestsWhileTopicQueuedForDeletion() {
        boolean bl;
        MockControllerBrokerRequestBatch batch;
        block7: {
            Object object;
            void flatMap_bf;
            ControllerContext context = this.initContext((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))), (scala.collection.immutable.Set<String>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo", "bar"}))), 2, 3);
            batch = new MockControllerBrokerRequestBatch(context, this.MockControllerBrokerRequestBatch().$lessinit$greater$default$2());
            scala.collection.immutable.Set partitions = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("foo", 0), new TopicPartition("foo", 1), new TopicPartition("bar", 1)}));
            context.queueTopicDeletion((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo"})));
            batch.newBatch();
            partitions.foreach((Function1 & Serializable & scala.Serializable)partition -> {
                batch.addStopReplicaRequestForBrokers((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})), partition, true);
                return BoxedUnit.UNIT;
            });
            batch.sendRequestsToBrokers(this.controllerEpoch());
            Assert.assertEquals((long)0L, (long)batch.sentEvents().size());
            Assert.assertEquals((long)1L, (long)batch.sentRequests().size());
            Assert.assertTrue((boolean)batch.sentRequests().contains((Object)BoxesRunTime.boxToInteger((int)2)));
            ListBuffer sentRequests = (ListBuffer)batch.sentRequests().apply((Object)BoxesRunTime.boxToInteger((int)2));
            Assert.assertEquals((long)1L, (long)sentRequests.size());
            LinearSeqOptimized sentStopReplicaRequests = batch.collectStopReplicaRequestsFor(2);
            Assert.assertEquals((long)1L, (long)sentStopReplicaRequests.size());
            CanBuildFrom canBuildFrom = List$.MODULE$.canBuildFrom();
            Function1 & Serializable & scala.Serializable flatMap_f = (Function1 & Serializable & scala.Serializable)x$12 -> (Iterable)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(x$12.partitions()).asScala();
            if (flatMap_bf == List$.MODULE$.ReusableCBF()) {
                if (sentStopReplicaRequests == Nil$.MODULE$) {
                    object = Nil$.MODULE$;
                } else {
                    BooleanRef flatMap_found = BooleanRef.create((boolean)false);
                    ObjectRef flatMap_h = ObjectRef.create(null);
                    ObjectRef flatMap_t = ObjectRef.create(null);
                    for (LinearSeqOptimized flatMap_rest = sentStopReplicaRequests; flatMap_rest != Nil$.MODULE$; flatMap_rest = (List)flatMap_rest.tail()) {
                        ControllerChannelManagerTest.$anonfun$testStopReplicaRequestsWhileTopicQueuedForDeletion$2((StopReplicaRequest)flatMap_rest.head()).seq().foreach(arg_0 -> List.$anonfun$flatMap$1$adapted((BooleanRef)flatMap_found, (ObjectRef)flatMap_h, (ObjectRef)flatMap_t, arg_0));
                    }
                    object = !flatMap_found.elem ? Nil$.MODULE$ : (.colon.colon)flatMap_h.elem;
                }
            } else {
                object = TraversableLike.flatMap$(sentStopReplicaRequests, (Function1)flatMap_f, (CanBuildFrom)flatMap_bf);
            }
            Assert.assertEquals((Object)partitions, (Object)((TraversableOnce)object).toSet());
            LinearSeqOptimized forall_these = sentStopReplicaRequests;
            while (!forall_these.isEmpty()) {
                if (!((StopReplicaRequest)forall_these.head()).deletePartitions()) {
                    bl = false;
                    break block7;
                }
                forall_these = (LinearSeqOptimized)forall_these.tail();
            }
            bl = true;
        }
        Assert.assertTrue((boolean)bl);
        this.applyStopReplicaResponseCallbacks(Errors.NONE, (List<SentRequest>)((ListBuffer)batch.sentRequests().apply((Object)BoxesRunTime.boxToInteger((int)2))).toList());
        Assert.assertEquals((long)0L, (long)batch.sentEvents().size());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testStopReplicaRequestsWhileTopicDeletionStarted() {
        void flatMap_bf;
        void flatMap_f;
        boolean bl;
        scala.collection.immutable.Set partitions;
        MockControllerBrokerRequestBatch batch;
        block8: {
            Object object;
            void flatMap_bf2;
            ControllerContext context = this.initContext((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))), (scala.collection.immutable.Set<String>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo", "bar"}))), 2, 3);
            batch = new MockControllerBrokerRequestBatch(context, this.MockControllerBrokerRequestBatch().$lessinit$greater$default$2());
            partitions = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("foo", 0), new TopicPartition("foo", 1), new TopicPartition("bar", 1)}));
            context.queueTopicDeletion((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo"})));
            context.beginTopicDeletion((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo"})));
            batch.newBatch();
            partitions.foreach((Function1 & Serializable & scala.Serializable)partition -> {
                batch.addStopReplicaRequestForBrokers((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})), partition, true);
                return BoxedUnit.UNIT;
            });
            batch.sendRequestsToBrokers(this.controllerEpoch());
            Assert.assertEquals((long)0L, (long)batch.sentEvents().size());
            Assert.assertEquals((long)1L, (long)batch.sentRequests().size());
            Assert.assertTrue((boolean)batch.sentRequests().contains((Object)BoxesRunTime.boxToInteger((int)2)));
            ListBuffer sentRequests = (ListBuffer)batch.sentRequests().apply((Object)BoxesRunTime.boxToInteger((int)2));
            Assert.assertEquals((long)1L, (long)sentRequests.size());
            LinearSeqOptimized sentStopReplicaRequests = batch.collectStopReplicaRequestsFor(2);
            Assert.assertEquals((long)1L, (long)sentStopReplicaRequests.size());
            CanBuildFrom canBuildFrom = List$.MODULE$.canBuildFrom();
            Function1 & Serializable & scala.Serializable flatMap_f2 = (Function1 & Serializable & scala.Serializable)x$14 -> (Iterable)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(x$14.partitions()).asScala();
            if (flatMap_bf2 == List$.MODULE$.ReusableCBF()) {
                if (sentStopReplicaRequests == Nil$.MODULE$) {
                    object = Nil$.MODULE$;
                } else {
                    BooleanRef flatMap_found = BooleanRef.create((boolean)false);
                    ObjectRef flatMap_h = ObjectRef.create(null);
                    ObjectRef flatMap_t = ObjectRef.create(null);
                    for (LinearSeqOptimized flatMap_rest = sentStopReplicaRequests; flatMap_rest != Nil$.MODULE$; flatMap_rest = (List)flatMap_rest.tail()) {
                        ControllerChannelManagerTest.$anonfun$testStopReplicaRequestsWhileTopicDeletionStarted$2((StopReplicaRequest)flatMap_rest.head()).seq().foreach(arg_0 -> List.$anonfun$flatMap$1$adapted((BooleanRef)flatMap_found, (ObjectRef)flatMap_h, (ObjectRef)flatMap_t, arg_0));
                    }
                    object = !flatMap_found.elem ? Nil$.MODULE$ : (.colon.colon)flatMap_h.elem;
                }
            } else {
                object = TraversableLike.flatMap$(sentStopReplicaRequests, (Function1)flatMap_f2, (CanBuildFrom)flatMap_bf2);
            }
            Assert.assertEquals((Object)partitions, (Object)((TraversableOnce)object).toSet());
            LinearSeqOptimized forall_these = sentStopReplicaRequests;
            while (!forall_these.isEmpty()) {
                if (!((StopReplicaRequest)forall_these.head()).deletePartitions()) {
                    bl = false;
                    break block8;
                }
                forall_these = (LinearSeqOptimized)forall_these.tail();
            }
            bl = true;
        }
        Assert.assertTrue((boolean)bl);
        this.applyStopReplicaResponseCallbacks(Errors.NONE, (List<SentRequest>)((ListBuffer)batch.sentRequests().apply((Object)BoxesRunTime.boxToInteger((int)2))).toList());
        Assert.assertEquals((long)1L, (long)batch.sentEvents().size());
        ListBuffer<ControllerEvent> listBuffer = batch.sentEvents();
        CanBuildFrom canBuildFrom = ListBuffer$.MODULE$.canBuildFrom();
        Function1 & Serializable & scala.Serializable intersect = (Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (!(x0$1 instanceof TopicDeletionStopReplicaResponseReceived)) {
                throw Assertions$.MODULE$.fail(new StringBuilder(23).append("Unexpected sent event: ").append(x0$1).toString(), new Position("ControllerChannelManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 481));
            }
            Set set = ((TopicDeletionStopReplicaResponseReceived)x0$1).partitionErrors().keySet();
            return set;
        };
        if (listBuffer == null) {
            throw null;
        }
        scala.collection.immutable.Set includedPartitions = ((TraversableForwarder)TraversableLike.flatMap$(listBuffer, (Function1)flatMap_f, (CanBuildFrom)flatMap_bf)).toSet();
        Assert.assertEquals((Object)partitions.filter((Function1 & Serializable & scala.Serializable)x$16 -> BoxesRunTime.boxToBoolean((boolean)ControllerChannelManagerTest.$anonfun$testStopReplicaRequestsWhileTopicDeletionStarted$5(x$16))), (Object)includedPartitions);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testMixedDeleteAndNotDeleteStopReplicaRequests() {
        void var9_9;
        void var8_8;
        ControllerContext context = this.initContext((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))), (scala.collection.immutable.Set<String>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo", "bar"}))), 2, 3);
        MockControllerBrokerRequestBatch batch = new MockControllerBrokerRequestBatch(context, this.MockControllerBrokerRequestBatch().$lessinit$greater$default$2());
        scala.collection.immutable.Set deletePartitions = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("foo", 0), new TopicPartition("foo", 1)}));
        scala.collection.immutable.Set nonDeletePartitions = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("bar", 0), new TopicPartition("bar", 1)}));
        batch.newBatch();
        deletePartitions.foreach((Function1 & Serializable & scala.Serializable)partition -> {
            batch.addStopReplicaRequestForBrokers((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})), partition, true);
            return BoxedUnit.UNIT;
        });
        nonDeletePartitions.foreach((Function1 & Serializable & scala.Serializable)partition -> {
            batch.addStopReplicaRequestForBrokers((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})), partition, false);
            return BoxedUnit.UNIT;
        });
        batch.sendRequestsToBrokers(this.controllerEpoch());
        Assert.assertEquals((long)0L, (long)batch.sentEvents().size());
        Assert.assertEquals((long)1L, (long)batch.sentRequests().size());
        Assert.assertTrue((boolean)batch.sentRequests().contains((Object)BoxesRunTime.boxToInteger((int)2)));
        ListBuffer sentRequests = (ListBuffer)batch.sentRequests().apply((Object)BoxesRunTime.boxToInteger((int)2));
        Assert.assertEquals((long)2L, (long)sentRequests.size());
        List<StopReplicaRequest> sentStopReplicaRequests = batch.collectStopReplicaRequestsFor(2);
        Assert.assertEquals((long)2L, (long)sentStopReplicaRequests.size());
        Tuple2 tuple2 = sentStopReplicaRequests.partition((Function1 & Serializable & scala.Serializable)x$17 -> BoxesRunTime.boxToBoolean((boolean)x$17.deletePartitions()));
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        List deleteRequests = (List)tuple2._1();
        List nonDeleteRequests = (List)tuple2._2();
        void deleteRequests2 = var8_8;
        void nonDeleteRequests2 = var9_9;
        Assert.assertEquals((long)1L, (long)deleteRequests2.size());
        Assert.assertEquals((Object)deletePartitions, (Object)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(((StopReplicaRequest)deleteRequests2.head()).partitions()).asScala()).toSet());
        Assert.assertEquals((long)1L, (long)nonDeleteRequests2.size());
        Assert.assertEquals((Object)nonDeletePartitions, (Object)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(((StopReplicaRequest)nonDeleteRequests2.head()).partitions()).asScala()).toSet());
    }

    @Test
    public void testStopReplicaGroupsByBroker() {
        ControllerContext context = this.initContext((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))), (scala.collection.immutable.Set<String>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo", "bar"}))), 2, 3);
        MockControllerBrokerRequestBatch batch = new MockControllerBrokerRequestBatch(context, this.MockControllerBrokerRequestBatch().$lessinit$greater$default$2());
        scala.collection.immutable.Set partitions = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("foo", 0), new TopicPartition("foo", 1), new TopicPartition("bar", 1)}));
        batch.newBatch();
        partitions.foreach((Function1 & Serializable & scala.Serializable)partition -> {
            batch.addStopReplicaRequestForBrokers((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})), partition, false);
            return BoxedUnit.UNIT;
        });
        batch.sendRequestsToBrokers(this.controllerEpoch());
        Assert.assertEquals((long)0L, (long)batch.sentEvents().size());
        Assert.assertEquals((long)2L, (long)batch.sentRequests().size());
        Assert.assertTrue((boolean)batch.sentRequests().contains((Object)BoxesRunTime.boxToInteger((int)2)));
        Assert.assertTrue((boolean)batch.sentRequests().contains((Object)BoxesRunTime.boxToInteger((int)3)));
        ListBuffer sentRequests = (ListBuffer)batch.sentRequests().apply((Object)BoxesRunTime.boxToInteger((int)2));
        Assert.assertEquals((long)1L, (long)sentRequests.size());
        ((IterableLike)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3}))).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)brokerId -> {
            List<StopReplicaRequest> sentStopReplicaRequests = batch.collectStopReplicaRequestsFor(brokerId);
            Assert.assertEquals((long)1L, (long)sentStopReplicaRequests.size());
            StopReplicaRequest stopReplicaRequest = (StopReplicaRequest)sentStopReplicaRequests.head();
            Assert.assertFalse((boolean)stopReplicaRequest.deletePartitions());
            Assert.assertEquals((Object)partitions, (Object)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(stopReplicaRequest.partitions()).asScala()).toSet());
            this.applyStopReplicaResponseCallbacks(Errors.NONE, (List<SentRequest>)((ListBuffer)batch.sentRequests().apply((Object)BoxesRunTime.boxToInteger((int)2))).toList());
            Assert.assertEquals((long)0L, (long)batch.sentEvents().size());
        });
    }

    @Test
    public void testStopReplicaSentOnlyToLiveAndShuttingDownBrokers() {
        ControllerContext context = this.initContext((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))), (scala.collection.immutable.Set<String>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo", "bar"}))), 2, 3);
        MockControllerBrokerRequestBatch batch = new MockControllerBrokerRequestBatch(context, this.MockControllerBrokerRequestBatch().$lessinit$greater$default$2());
        context.shuttingDownBrokerIds().add((Object)BoxesRunTime.boxToInteger((int)2));
        context.removeLiveBrokers((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3})));
        scala.collection.immutable.Set partitions = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("foo", 0), new TopicPartition("foo", 1), new TopicPartition("bar", 1)}));
        batch.newBatch();
        partitions.foreach((Function1 & Serializable & scala.Serializable)partition -> {
            batch.addStopReplicaRequestForBrokers((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})), partition, false);
            return BoxedUnit.UNIT;
        });
        batch.sendRequestsToBrokers(this.controllerEpoch());
        Assert.assertEquals((long)0L, (long)batch.sentEvents().size());
        Assert.assertEquals((long)1L, (long)batch.sentRequests().size());
        Assert.assertTrue((boolean)batch.sentRequests().contains((Object)BoxesRunTime.boxToInteger((int)2)));
        ListBuffer sentRequests = (ListBuffer)batch.sentRequests().apply((Object)BoxesRunTime.boxToInteger((int)2));
        Assert.assertEquals((long)1L, (long)sentRequests.size());
        List<StopReplicaRequest> sentStopReplicaRequests = batch.collectStopReplicaRequestsFor(2);
        Assert.assertEquals((long)1L, (long)sentStopReplicaRequests.size());
        StopReplicaRequest stopReplicaRequest = (StopReplicaRequest)sentStopReplicaRequests.head();
        Assert.assertFalse((boolean)stopReplicaRequest.deletePartitions());
        Assert.assertEquals((Object)partitions, (Object)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(stopReplicaRequest.partitions()).asScala()).toSet());
    }

    @Test
    public void testStopReplicaInterBrokerProtocolVersion() {
        this.testStopReplicaFollowsInterBrokerProtocolVersion(ApiVersion$.MODULE$.latestVersion(), ApiKeys.STOP_REPLICA.latestVersion());
        ApiVersion$.MODULE$.allVersions().foreach((Function1 & Serializable & scala.Serializable)apiVersion -> {
            ControllerChannelManagerTest.$anonfun$testStopReplicaInterBrokerProtocolVersion$1(this, apiVersion);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    private void testStopReplicaFollowsInterBrokerProtocolVersion(ApiVersion interBrokerProtocolVersion, short expectedStopReplicaRequestVersion) {
        boolean bl;
        String string;
        block9: {
            Object object;
            void map_bf;
            ControllerContext context = this.initContext((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))), (scala.collection.immutable.Set<String>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo"}))), 2, 3);
            KafkaConfig config = this.createConfig(interBrokerProtocolVersion);
            MockControllerBrokerRequestBatch batch = new MockControllerBrokerRequestBatch(context, config);
            TopicPartition partition = new TopicPartition("foo", 0);
            batch.newBatch();
            batch.addStopReplicaRequestForBrokers((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})), partition, false);
            batch.sendRequestsToBrokers(this.controllerEpoch());
            Assert.assertEquals((long)0L, (long)batch.sentEvents().size());
            Assert.assertEquals((long)1L, (long)batch.sentRequests().size());
            Assert.assertTrue((boolean)batch.sentRequests().contains((Object)BoxesRunTime.boxToInteger((int)2)));
            List<StopReplicaRequest> requests = batch.collectStopReplicaRequestsFor(2);
            CanBuildFrom canBuildFrom = List$.MODULE$.canBuildFrom();
            Function1 & Serializable & scala.Serializable intersect = (Function1 & Serializable & scala.Serializable)x$19 -> BoxesRunTime.boxToShort((short)x$19.version());
            if (requests == null) {
                throw null;
            }
            if (map_bf == List$.MODULE$.ReusableCBF()) {
                if (requests == Nil$.MODULE$) {
                    object = Nil$.MODULE$;
                } else {
                    .colon.colon map_h;
                    .colon.colon map_t = map_h = new .colon.colon((Object)BoxesRunTime.boxToShort((short)((StopReplicaRequest)requests.head()).version()), (List)Nil$.MODULE$);
                    for (List map_rest = (List)requests.tail(); map_rest != Nil$.MODULE$; map_rest = (List)map_rest.tail()) {
                        .colon.colon map_nx = new .colon.colon((Object)BoxesRunTime.boxToShort((short)((StopReplicaRequest)map_rest.head()).version()), (List)Nil$.MODULE$);
                        map_t.tl_$eq((List)map_nx);
                        map_t = map_nx;
                    }
                    object = map_h;
                }
            } else {
                void map_f;
                object = TraversableLike.map$(requests, (Function1)map_f, (CanBuildFrom)map_bf);
            }
            List allVersions = (List)object;
            string = new StringBuilder(45).append("IBP ").append(interBrokerProtocolVersion).append(" should use version ").append(expectedStopReplicaRequestVersion).append(", ").append("but found versions ").append(allVersions).toString();
            if (allVersions == null) {
                throw null;
            }
            List forall_these = allVersions;
            while (!forall_these.isEmpty()) {
                Object object2 = forall_these.head();
                if (!ControllerChannelManagerTest.$anonfun$testStopReplicaFollowsInterBrokerProtocolVersion$2(expectedStopReplicaRequestVersion, BoxesRunTime.unboxToShort((Object)object2))) {
                    bl = false;
                    break block9;
                }
                forall_these = (LinearSeqOptimized)forall_these.tail();
            }
            bl = true;
        }
        Assert.assertTrue((String)string, (boolean)bl);
    }

    private void applyStopReplicaResponseCallbacks(Errors error, List<SentRequest> sentRequests) {
        List list = (List)sentRequests.filter((Function1 & Serializable & scala.Serializable)x$21 -> BoxesRunTime.boxToBoolean((boolean)ControllerChannelManagerTest.$anonfun$applyStopReplicaResponseCallbacks$1(x$21)));
        if (list == null) {
            throw null;
        }
        List foreach_these = list;
        while (!foreach_these.isEmpty()) {
            SentRequest sentRequest = (SentRequest)foreach_these.head();
            ControllerChannelManagerTest.$anonfun$applyStopReplicaResponseCallbacks$2(error, sentRequest);
            foreach_these = (List)foreach_these.tail();
        }
    }

    private void applyLeaderAndIsrResponseCallbacks(Errors error, List<SentRequest> sentRequests) {
        List list = (List)((TraversableLike)sentRequests.filter((Function1 & Serializable & scala.Serializable)x$22 -> BoxesRunTime.boxToBoolean((boolean)ControllerChannelManagerTest.$anonfun$applyLeaderAndIsrResponseCallbacks$1(x$22)))).filter((Function1 & Serializable & scala.Serializable)x$23 -> BoxesRunTime.boxToBoolean((boolean)ControllerChannelManagerTest.$anonfun$applyLeaderAndIsrResponseCallbacks$2(x$23)));
        if (list == null) {
            throw null;
        }
        List foreach_these = list;
        while (!foreach_these.isEmpty()) {
            SentRequest sentRequest = (SentRequest)foreach_these.head();
            ControllerChannelManagerTest.$anonfun$applyLeaderAndIsrResponseCallbacks$3(error, sentRequest);
            foreach_these = (List)foreach_these.tail();
        }
    }

    private void applyUpdateMetadataResponseCallbacks(Errors error, List<SentRequest> sentRequests) {
        List list = (List)((TraversableLike)sentRequests.filter((Function1 & Serializable & scala.Serializable)x$24 -> BoxesRunTime.boxToBoolean((boolean)ControllerChannelManagerTest.$anonfun$applyUpdateMetadataResponseCallbacks$1(x$24)))).filter((Function1 & Serializable & scala.Serializable)x$25 -> BoxesRunTime.boxToBoolean((boolean)ControllerChannelManagerTest.$anonfun$applyUpdateMetadataResponseCallbacks$2(x$25)));
        if (list == null) {
            throw null;
        }
        List foreach_these = list;
        while (!foreach_these.isEmpty()) {
            SentRequest sentRequest = (SentRequest)foreach_these.head();
            ControllerChannelManagerTest.$anonfun$applyUpdateMetadataResponseCallbacks$3(error, sentRequest);
            foreach_these = (List)foreach_these.tail();
        }
    }

    private KafkaConfig createConfig(ApiVersion interBrokerVersion) {
        Properties props = new Properties();
        props.put(KafkaConfig$.MODULE$.BrokerIdProp(), ((Object)BoxesRunTime.boxToInteger((int)this.controllerId())).toString());
        props.put(KafkaConfig$.MODULE$.ZkConnectProp(), "zkConnect");
        props.put(KafkaConfig$.MODULE$.InterBrokerProtocolVersionProp(), interBrokerVersion.version());
        props.put(KafkaConfig$.MODULE$.LogMessageFormatVersionProp(), interBrokerVersion.version());
        return KafkaConfig$.MODULE$.fromProps(props);
    }

    private ReplicaAssignment replicaAssignment(Seq<Object> replicas) {
        return ReplicaAssignment$.MODULE$.apply(replicas, (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$));
    }

    private ControllerContext initContext(Seq<Object> brokers, scala.collection.immutable.Set<String> topics, int numPartitions, int replicationFactor) {
        ControllerContext context = new ControllerContext();
        scala.collection.immutable.Map brokerEpochs = ((TraversableOnce)brokers.map((Function1 & Serializable & scala.Serializable)brokerId -> ControllerChannelManagerTest.$anonfun$initContext$1(BoxesRunTime.unboxToInt((Object)brokerId)), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        context.setLiveBrokerAndEpochs((Map)brokerEpochs);
        IntRef leaderIndex = IntRef.create((int)0);
        topics.foreach((Function1 & Serializable & scala.Serializable)topic -> {
            ControllerChannelManagerTest.$anonfun$initContext$2(numPartitions, replicationFactor, brokers, leaderIndex, context, topic);
            return BoxedUnit.UNIT;
        });
        return context;
    }

    private final void SentRequest$lzycompute$1() {
        synchronized (this) {
            if (this.SentRequest$module == null) {
                this.SentRequest$module = new ControllerChannelManagerTest$SentRequest$(this);
            }
            return;
        }
    }

    private final void MockControllerBrokerRequestBatch$lzycompute$1() {
        synchronized (this) {
            if (this.MockControllerBrokerRequestBatch$module == null) {
                this.MockControllerBrokerRequestBatch$module = new ControllerChannelManagerTest$MockControllerBrokerRequestBatch$(this);
            }
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$testLeaderAndIsrRequestSent$1(ControllerChannelManagerTest $this, ControllerContext context$1, MockControllerBrokerRequestBatch batch$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            TopicPartition partition = (TopicPartition)x0$1._1();
            LeaderAndIsr leaderAndIsr = (LeaderAndIsr)x0$1._2();
            LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(leaderAndIsr, $this.controllerEpoch());
            context$1.partitionLeadershipInfo().put((Object)partition, (Object)leaderIsrAndControllerEpoch);
            batch$1.addLeaderAndIsrRequestForBrokers((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})), partition, leaderIsrAndControllerEpoch, $this.replicaAssignment((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})))), false);
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$testLeaderAndIsrRequestIsNew$2(TopicPartition partition$1, LeaderAndIsrRequestData.LeaderAndIsrPartitionState p) {
        String string = p.topicName();
        String string2 = partition$1.topic();
        return !(string != null ? !string.equals(string2) : string2 != null) && p.partitionIndex() == partition$1.partition();
    }

    public static final /* synthetic */ void $anonfun$testLeaderAndIsrInterBrokerProtocolVersion$1(ControllerChannelManagerTest $this, ApiVersion apiVersion) {
        int leaderAndIsrRequestVersion = apiVersion.$greater$eq((Object)KAFKA_2_4_IV1$.MODULE$) ? 4 : (apiVersion.$greater$eq((Object)KAFKA_2_4_IV0$.MODULE$) ? 3 : (apiVersion.$greater$eq((Object)KAFKA_2_2_IV0$.MODULE$) ? 2 : (apiVersion.$greater$eq((Object)KAFKA_1_0_IV0$.MODULE$) ? 1 : 0)));
        $this.testLeaderAndIsrRequestFollowsInterBrokerProtocolVersion(apiVersion, (short)leaderAndIsrRequestVersion);
    }

    public static final /* synthetic */ boolean $anonfun$testUpdateMetadataRequestDuringTopicDeletion$2(UpdateMetadataRequestData.UpdateMetadataPartitionState x$6) {
        String string = x$6.topicName();
        String string2 = "foo";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$testUpdateMetadataRequestDuringTopicDeletion$5(Tuple2 x0$2) {
        if (x0$2 == null) {
            throw new MatchError(null);
        }
        String string = ((TopicPartition)x0$2._1()).topic();
        String string2 = "bar";
        boolean bl = string != null && string.equals(string2);
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$testUpdateMetadataRequestDuringTopicDeletion$7(UpdateMetadataRequestData.UpdateMetadataPartitionState ps) {
        String string = ps.topicName();
        String string2 = "bar";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ void $anonfun$testUpdateMetadataInterBrokerProtocolVersion$1(ControllerChannelManagerTest $this, ApiVersion apiVersion) {
        int updateMetadataRequestVersion = apiVersion.$greater$eq((Object)KAFKA_2_4_IV1$.MODULE$) ? 6 : (apiVersion.$greater$eq((Object)KAFKA_2_2_IV0$.MODULE$) ? 5 : (apiVersion.$greater$eq((Object)KAFKA_1_0_IV0$.MODULE$) ? 4 : (apiVersion.$greater$eq((Object)KAFKA_0_10_2_IV0$.MODULE$) ? 3 : (apiVersion.$greater$eq((Object)KAFKA_0_10_0_IV1$.MODULE$) ? 2 : (apiVersion.$greater$eq((Object)KAFKA_0_9_0$.MODULE$) ? 1 : 0)))));
        $this.testUpdateMetadataFollowsInterBrokerProtocolVersion(apiVersion, (short)updateMetadataRequestVersion);
    }

    public static final /* synthetic */ boolean $anonfun$testUpdateMetadataFollowsInterBrokerProtocolVersion$2(short expectedUpdateMetadataVersion$1, short x$11) {
        return x$11 == expectedUpdateMetadataVersion$1;
    }

    public static final /* synthetic */ boolean $anonfun$testStopReplicaRequestsWhileTopicDeletionStarted$5(TopicPartition x$16) {
        String string = x$16.topic();
        String string2 = "foo";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ void $anonfun$testStopReplicaInterBrokerProtocolVersion$1(ControllerChannelManagerTest $this, ApiVersion apiVersion) {
        if (apiVersion.$less((Object)KAFKA_2_2_IV0$.MODULE$)) {
            $this.testStopReplicaFollowsInterBrokerProtocolVersion(apiVersion, (short)0);
            return;
        }
        if (apiVersion.$less((Object)KAFKA_2_4_IV1$.MODULE$)) {
            $this.testStopReplicaFollowsInterBrokerProtocolVersion(apiVersion, (short)1);
            return;
        }
        $this.testStopReplicaFollowsInterBrokerProtocolVersion(apiVersion, (short)2);
    }

    public static final /* synthetic */ boolean $anonfun$testStopReplicaFollowsInterBrokerProtocolVersion$2(short expectedStopReplicaRequestVersion$1, short x$20) {
        return x$20 == expectedStopReplicaRequestVersion$1;
    }

    public static final /* synthetic */ boolean $anonfun$applyStopReplicaResponseCallbacks$1(SentRequest x$21) {
        return x$21.responseCallback() != null;
    }

    public static final /* synthetic */ void $anonfun$applyStopReplicaResponseCallbacks$2(Errors error$1, SentRequest sentRequest) {
        AbstractResponse abstractResponse;
        StopReplicaRequest stopReplicaRequest = (StopReplicaRequest)sentRequest.request().build();
        Errors errors = error$1;
        Errors errors2 = Errors.NONE;
        if (!(errors != null ? !errors.equals(errors2) : errors2 != null)) {
            java.util.List partitionErrors = (java.util.List)JavaConverters$.MODULE$.bufferAsJavaListConverter(((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(stopReplicaRequest.partitions()).asScala()).map((Function1 & Serializable & scala.Serializable)tp -> new StopReplicaResponseData.StopReplicaPartitionError().setTopicName(tp.topic()).setPartitionIndex(tp.partition()).setErrorCode(error$1.code()), Iterable$.MODULE$.canBuildFrom())).toBuffer()).asJava();
            abstractResponse = new StopReplicaResponse(new StopReplicaResponseData().setPartitionErrors(partitionErrors));
        } else {
            abstractResponse = stopReplicaRequest.getErrorResponse((Throwable)error$1.exception());
        }
        AbstractResponse stopReplicaResponse = abstractResponse;
        sentRequest.responseCallback().apply((Object)stopReplicaResponse);
    }

    public static final /* synthetic */ boolean $anonfun$applyLeaderAndIsrResponseCallbacks$1(SentRequest x$22) {
        ApiKeys apiKeys = x$22.request().apiKey();
        ApiKeys apiKeys2 = ApiKeys.LEADER_AND_ISR;
        return !(apiKeys != null ? !apiKeys.equals(apiKeys2) : apiKeys2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$applyLeaderAndIsrResponseCallbacks$2(SentRequest x$23) {
        return x$23.responseCallback() != null;
    }

    public static final /* synthetic */ void $anonfun$applyLeaderAndIsrResponseCallbacks$3(Errors error$2, SentRequest sentRequest) {
        LeaderAndIsrRequest leaderAndIsrRequest = (LeaderAndIsrRequest)sentRequest.request().build();
        Iterable partitionErrors = (Iterable)((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(leaderAndIsrRequest.partitionStates()).asScala()).map((Function1 & Serializable & scala.Serializable)p -> new LeaderAndIsrResponseData.LeaderAndIsrPartitionError().setTopicName(p.topicName()).setPartitionIndex(p.partitionIndex()).setErrorCode(error$2.code()), Iterable$.MODULE$.canBuildFrom());
        LeaderAndIsrResponse leaderAndIsrResponse = new LeaderAndIsrResponse(new LeaderAndIsrResponseData().setErrorCode(error$2.code()).setPartitionErrors((java.util.List)JavaConverters$.MODULE$.bufferAsJavaListConverter(partitionErrors.toBuffer()).asJava()));
        sentRequest.responseCallback().apply((Object)leaderAndIsrResponse);
    }

    public static final /* synthetic */ boolean $anonfun$applyUpdateMetadataResponseCallbacks$1(SentRequest x$24) {
        ApiKeys apiKeys = x$24.request().apiKey();
        ApiKeys apiKeys2 = ApiKeys.UPDATE_METADATA;
        return !(apiKeys != null ? !apiKeys.equals(apiKeys2) : apiKeys2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$applyUpdateMetadataResponseCallbacks$2(SentRequest x$25) {
        return x$25.responseCallback() != null;
    }

    public static final /* synthetic */ void $anonfun$applyUpdateMetadataResponseCallbacks$3(Errors error$3, SentRequest sentRequest) {
        UpdateMetadataResponse response = new UpdateMetadataResponse(new UpdateMetadataResponseData().setErrorCode(error$3.code()));
        sentRequest.responseCallback().apply((Object)response);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ Tuple2 $anonfun$initContext$1(int brokerId) {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        EndPoint endpoint = new EndPoint("localhost", 9900 + brokerId, new ListenerName("PLAINTEXT"), SecurityProtocol.PLAINTEXT);
        Long l = BoxesRunTime.boxToLong((long)1L);
        Object object = Predef$.MODULE$.ArrowAssoc((Object)new Broker(brokerId, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EndPoint[]{endpoint})), (Option)None$.MODULE$));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        return new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
    }

    public static final /* synthetic */ void $anonfun$initContext$3(String topic$1, int replicationFactor$1, Seq brokers$1, IntRef leaderIndex$1, ControllerContext context$4, int partitionId) {
        TopicPartition partition = new TopicPartition(topic$1, partitionId);
        int n = 0;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        IndexedSeq replicas = (IndexedSeq)RichInt$.MODULE$.until$extension0(n, replicationFactor$1).map((Function1)(JFunction1.mcII.sp & Serializable & scala.Serializable)i -> BoxesRunTime.unboxToInt((Object)brokers$1.apply((i + leaderIndex$1.elem) % brokers$1.size())), IndexedSeq$.MODULE$.canBuildFrom());
        context$4.updatePartitionFullReplicaAssignment(partition, ReplicaAssignment$.MODULE$.apply((Seq)replicas));
        ++leaderIndex$1.elem;
    }

    public static final /* synthetic */ void $anonfun$initContext$2(int numPartitions$1, int replicationFactor$1, Seq brokers$1, IntRef leaderIndex$1, ControllerContext context$4, String topic) {
        int n = 0;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        Range range = RichInt$.MODULE$.until$extension0(n, numPartitions$1);
        if (range == null) {
            throw null;
        }
        Range foreach$mVc$sp_this = range;
        if (!foreach$mVc$sp_this.isEmpty()) {
            int foreach$mVc$sp_i = foreach$mVc$sp_this.start();
            while (true) {
                ControllerChannelManagerTest.$anonfun$initContext$3(topic, replicationFactor$1, brokers$1, leaderIndex$1, context$4, foreach$mVc$sp_i);
                if (foreach$mVc$sp_i == foreach$mVc$sp_this.scala$collection$immutable$Range$$lastElement()) break;
                foreach$mVc$sp_i += foreach$mVc$sp_this.step();
            }
        }
    }

    public ControllerChannelManagerTest() {
        this.controllerId = 1;
        this.controllerEpoch = 1;
    }

    public static final /* synthetic */ Object $anonfun$testLeaderAndIsrRequestIsNew$3$adapted(LeaderAndIsrRequestData.LeaderAndIsrPartitionState x$2) {
        return BoxesRunTime.boxToBoolean((boolean)x$2.isNew());
    }

    public static final /* synthetic */ Object $anonfun$testUpdateMetadataFollowsInterBrokerProtocolVersion$2$adapted(short expectedUpdateMetadataVersion$1, Object x$11) {
        return BoxesRunTime.boxToBoolean((boolean)ControllerChannelManagerTest.$anonfun$testUpdateMetadataFollowsInterBrokerProtocolVersion$2(expectedUpdateMetadataVersion$1, BoxesRunTime.unboxToShort((Object)x$11)));
    }

    public static final /* synthetic */ Object $anonfun$testStopReplicaRequestsWhileTopicQueuedForDeletion$3$adapted(StopReplicaRequest x$13) {
        return BoxesRunTime.boxToBoolean((boolean)x$13.deletePartitions());
    }

    public static final /* synthetic */ Object $anonfun$testStopReplicaRequestsWhileTopicDeletionStarted$3$adapted(StopReplicaRequest x$15) {
        return BoxesRunTime.boxToBoolean((boolean)x$15.deletePartitions());
    }

    public static final /* synthetic */ Object $anonfun$testStopReplicaFollowsInterBrokerProtocolVersion$2$adapted(short expectedStopReplicaRequestVersion$1, Object x$20) {
        return BoxesRunTime.boxToBoolean((boolean)ControllerChannelManagerTest.$anonfun$testStopReplicaFollowsInterBrokerProtocolVersion$2(expectedStopReplicaRequestVersion$1, BoxesRunTime.unboxToShort((Object)x$20)));
    }

    public static final /* synthetic */ Object $anonfun$applyStopReplicaResponseCallbacks$2$adapted(Errors error$1, SentRequest sentRequest) {
        ControllerChannelManagerTest.$anonfun$applyStopReplicaResponseCallbacks$2(error$1, sentRequest);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$applyLeaderAndIsrResponseCallbacks$3$adapted(Errors error$2, SentRequest sentRequest) {
        ControllerChannelManagerTest.$anonfun$applyLeaderAndIsrResponseCallbacks$3(error$2, sentRequest);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$applyUpdateMetadataResponseCallbacks$3$adapted(Errors error$3, SentRequest sentRequest) {
        ControllerChannelManagerTest.$anonfun$applyUpdateMetadataResponseCallbacks$3(error$3, sentRequest);
        return BoxedUnit.UNIT;
    }

    public class MockControllerBrokerRequestBatch
    extends AbstractControllerBrokerRequestBatch {
        private final ListBuffer<ControllerEvent> sentEvents;
        private final scala.collection.mutable.Map<Object, ListBuffer<SentRequest>> sentRequests;

        public ListBuffer<ControllerEvent> sentEvents() {
            return this.sentEvents;
        }

        public scala.collection.mutable.Map<Object, ListBuffer<SentRequest>> sentRequests() {
            return this.sentRequests;
        }

        public void sendEvent(ControllerEvent event) {
            this.sentEvents().append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ControllerEvent[]{event}));
        }

        public void sendRequest(int brokerId, AbstractControlRequest.Builder<? extends AbstractControlRequest> request, Function1<AbstractResponse, BoxedUnit> callback) {
            this.sentRequests().getOrElseUpdate((Object)BoxesRunTime.boxToInteger((int)brokerId), (Function0 & Serializable & scala.Serializable)() -> (ListBuffer)ListBuffer$.MODULE$.empty());
            ((BufferLike)this.sentRequests().apply((Object)BoxesRunTime.boxToInteger((int)brokerId))).append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SentRequest[]{new SentRequest(this.kafka$controller$ControllerChannelManagerTest$MockControllerBrokerRequestBatch$$$outer(), request, callback)}));
        }

        /*
         * WARNING - void declaration
         */
        public List<StopReplicaRequest> collectStopReplicaRequestsFor(int brokerId) {
            List list;
            Option option = this.sentRequests().get((Object)BoxesRunTime.boxToInteger((int)brokerId));
            if (option instanceof Some) {
                void filter_p;
                ListBuffer requests = (ListBuffer)((Some)option).value();
                Function1 & Serializable & scala.Serializable intersect = (Function1 & Serializable & scala.Serializable)x$26 -> BoxesRunTime.boxToBoolean((boolean)MockControllerBrokerRequestBatch.$anonfun$collectStopReplicaRequestsFor$1(x$26));
                if (requests == null) {
                    throw null;
                }
                list = ((ListBuffer)((TraversableLike)requests.filterImpl((Function1)filter_p, false)).map((Function1 & Serializable & scala.Serializable)x$27 -> (StopReplicaRequest)x$27.request().build(), ListBuffer$.MODULE$.canBuildFrom())).toList();
            } else if (None$.MODULE$.equals(option)) {
                list = List$.MODULE$.empty();
            } else {
                throw new MatchError((Object)option);
            }
            return list;
        }

        /*
         * WARNING - void declaration
         */
        public List<UpdateMetadataRequest> collectUpdateMetadataRequestsFor(int brokerId) {
            List list;
            Option option = this.sentRequests().get((Object)BoxesRunTime.boxToInteger((int)brokerId));
            if (option instanceof Some) {
                void filter_p;
                ListBuffer requests = (ListBuffer)((Some)option).value();
                Function1 & Serializable & scala.Serializable intersect = (Function1 & Serializable & scala.Serializable)x$28 -> BoxesRunTime.boxToBoolean((boolean)MockControllerBrokerRequestBatch.$anonfun$collectUpdateMetadataRequestsFor$1(x$28));
                if (requests == null) {
                    throw null;
                }
                list = ((ListBuffer)((TraversableLike)requests.filterImpl((Function1)filter_p, false)).map((Function1 & Serializable & scala.Serializable)x$29 -> (UpdateMetadataRequest)x$29.request().build(), ListBuffer$.MODULE$.canBuildFrom())).toList();
            } else if (None$.MODULE$.equals(option)) {
                list = List$.MODULE$.empty();
            } else {
                throw new MatchError((Object)option);
            }
            return list;
        }

        /*
         * WARNING - void declaration
         */
        public List<LeaderAndIsrRequest> collectLeaderAndIsrRequestsFor(int brokerId) {
            List list;
            Option option = this.sentRequests().get((Object)BoxesRunTime.boxToInteger((int)brokerId));
            if (option instanceof Some) {
                void filter_p;
                ListBuffer requests = (ListBuffer)((Some)option).value();
                Function1 & Serializable & scala.Serializable intersect = (Function1 & Serializable & scala.Serializable)x$30 -> BoxesRunTime.boxToBoolean((boolean)MockControllerBrokerRequestBatch.$anonfun$collectLeaderAndIsrRequestsFor$1(x$30));
                if (requests == null) {
                    throw null;
                }
                list = ((ListBuffer)((TraversableLike)requests.filterImpl((Function1)filter_p, false)).map((Function1 & Serializable & scala.Serializable)x$31 -> (LeaderAndIsrRequest)x$31.request().build(), ListBuffer$.MODULE$.canBuildFrom())).toList();
            } else if (None$.MODULE$.equals(option)) {
                list = List$.MODULE$.empty();
            } else {
                throw new MatchError((Object)option);
            }
            return list;
        }

        public /* synthetic */ ControllerChannelManagerTest kafka$controller$ControllerChannelManagerTest$MockControllerBrokerRequestBatch$$$outer() {
            return ControllerChannelManagerTest.this;
        }

        public static final /* synthetic */ boolean $anonfun$collectStopReplicaRequestsFor$1(SentRequest x$26) {
            ApiKeys apiKeys = x$26.request().apiKey();
            ApiKeys apiKeys2 = ApiKeys.STOP_REPLICA;
            return !(apiKeys != null ? !apiKeys.equals(apiKeys2) : apiKeys2 != null);
        }

        public static final /* synthetic */ boolean $anonfun$collectUpdateMetadataRequestsFor$1(SentRequest x$28) {
            ApiKeys apiKeys = x$28.request().apiKey();
            ApiKeys apiKeys2 = ApiKeys.UPDATE_METADATA;
            return !(apiKeys != null ? !apiKeys.equals(apiKeys2) : apiKeys2 != null);
        }

        public static final /* synthetic */ boolean $anonfun$collectLeaderAndIsrRequestsFor$1(SentRequest x$30) {
            ApiKeys apiKeys = x$30.request().apiKey();
            ApiKeys apiKeys2 = ApiKeys.LEADER_AND_ISR;
            return !(apiKeys != null ? !apiKeys.equals(apiKeys2) : apiKeys2 != null);
        }

        public MockControllerBrokerRequestBatch(ControllerContext context, KafkaConfig config) {
            if (ControllerChannelManagerTest.this == null) {
                throw null;
            }
            super(config, context, ControllerChannelManagerTest.this.kafka$controller$ControllerChannelManagerTest$$logger());
            this.sentEvents = (ListBuffer)ListBuffer$.MODULE$.empty();
            this.sentRequests = Map$.MODULE$.empty();
        }
    }

    public class SentRequest
    implements Product,
    scala.Serializable {
        private final AbstractControlRequest.Builder<? extends AbstractControlRequest> request;
        private final Function1<AbstractResponse, BoxedUnit> responseCallback;
        public final /* synthetic */ ControllerChannelManagerTest $outer;

        public AbstractControlRequest.Builder<? extends AbstractControlRequest> request() {
            return this.request;
        }

        public Function1<AbstractResponse, BoxedUnit> responseCallback() {
            return this.responseCallback;
        }

        public SentRequest copy(AbstractControlRequest.Builder<? extends AbstractControlRequest> request, Function1<AbstractResponse, BoxedUnit> responseCallback) {
            return new SentRequest(this.kafka$controller$ControllerChannelManagerTest$SentRequest$$$outer(), request, responseCallback);
        }

        public AbstractControlRequest.Builder<? extends AbstractControlRequest> copy$default$1() {
            return this.request();
        }

        public Function1<AbstractResponse, BoxedUnit> copy$default$2() {
            return this.responseCallback();
        }

        public String productPrefix() {
            return "SentRequest";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            switch (x$1) {
                case 0: {
                    return this.request();
                }
                case 1: {
                    return this.responseCallback();
                }
            }
            throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof SentRequest;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            if (!(x$1 instanceof SentRequest)) return false;
            if (((SentRequest)x$1).kafka$controller$ControllerChannelManagerTest$SentRequest$$$outer() != this.kafka$controller$ControllerChannelManagerTest$SentRequest$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            SentRequest sentRequest = (SentRequest)x$1;
            AbstractControlRequest.Builder<? extends AbstractControlRequest> builder = this.request();
            AbstractControlRequest.Builder<? extends AbstractControlRequest> builder2 = sentRequest.request();
            if (builder == null) {
                if (builder2 != null) {
                    return false;
                }
            } else if (!builder.equals(builder2)) return false;
            Function1<AbstractResponse, BoxedUnit> function1 = this.responseCallback();
            Function1<AbstractResponse, BoxedUnit> function12 = sentRequest.responseCallback();
            if (function1 == null) {
                if (function12 != null) {
                    return false;
                }
            } else if (!function1.equals(function12)) return false;
            if (!sentRequest.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ ControllerChannelManagerTest kafka$controller$ControllerChannelManagerTest$SentRequest$$$outer() {
            return this.$outer;
        }

        public SentRequest(ControllerChannelManagerTest $outer, AbstractControlRequest.Builder<? extends AbstractControlRequest> request, Function1<AbstractResponse, BoxedUnit> responseCallback) {
            this.request = request;
            this.responseCallback = responseCallback;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }
}

