/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.transaction;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.coordinator.transaction.CompleteAbort$;
import kafka.coordinator.transaction.CompleteCommit$;
import kafka.coordinator.transaction.CoordinatorEpochAndTxnMetadata;
import kafka.coordinator.transaction.Dead$;
import kafka.coordinator.transaction.Empty$;
import kafka.coordinator.transaction.InitProducerIdResult;
import kafka.coordinator.transaction.Ongoing$;
import kafka.coordinator.transaction.PrepareAbort$;
import kafka.coordinator.transaction.PrepareCommit$;
import kafka.coordinator.transaction.PrepareEpochFence$;
import kafka.coordinator.transaction.ProducerIdManager;
import kafka.coordinator.transaction.TransactionConfig;
import kafka.coordinator.transaction.TransactionCoordinator$;
import kafka.coordinator.transaction.TransactionMarkerChannelManager;
import kafka.coordinator.transaction.TransactionMetadata;
import kafka.coordinator.transaction.TransactionMetadata$;
import kafka.coordinator.transaction.TransactionState;
import kafka.coordinator.transaction.TransactionStateManager;
import kafka.coordinator.transaction.TransactionalIdAndProducerIdEpoch;
import kafka.coordinator.transaction.TxnTransitMetadata;
import kafka.server.KafkaConfig;
import kafka.server.MetadataCache;
import kafka.server.ReplicaManager;
import kafka.utils.Logging;
import kafka.utils.Scheduler;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.TransactionResult;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.ProducerIdAndEpoch;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.Function5;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Set;
import scala.collection.mutable.Set$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0001\t=w!B\u0012%\u0011\u0003Yc!B\u0017%\u0011\u0003q\u0003\"B\u001b\u0002\t\u00031\u0004\"B\u001c\u0002\t\u0003A\u0004b\u0002Ba\u0003\u0011%!1\u0019\u0005\b\u0005\u0013\fA\u0011\u0002Bf\r\u0011iC\u0005\u0001\u001e\t\u0011\u00053!\u0011!Q\u0001\n\tC\u0001\"\u0012\u0004\u0003\u0002\u0003\u0006IA\u0012\u0005\t\u0013\u001a\u0011\t\u0011)A\u0005\u0015\"AQJ\u0002B\u0001B\u0003%a\n\u0003\u0005R\r\t\u0005\t\u0015!\u0003S\u0011!)fA!A!\u0002\u00131\u0006\u0002C-\u0007\u0005\u0003\u0005\u000b\u0011\u0002.\t\u0011\u00194!\u0011!Q\u0001\n\u001dDQ!\u000e\u0004\u0005\u0002),Aa\u001d\u0004\u0001i\u0016!QP\u0002\u0001\u007f\u000b\u0015\tYA\u0002\u0001\u007f\u000b\u0019\tiA\u0002\u0001\u0002\u0010!I\u0011q\b\u0004C\u0002\u0013%\u0011\u0011\t\u0005\t\u000372\u0001\u0015!\u0003\u0002D!9\u0011Q\f\u0004\u0005\u0002\u0005}\u0003bBAI\r\u0011%\u00111\u0013\u0005\b\u0003o3A\u0011AA]\u0011\u001d\tiO\u0002C\u0001\u0003_Dq!a>\u0007\t\u0003\tI\u0010C\u0004\u0003\u0002\u0019!IAa\u0001\t\u000f\t-b\u0001\"\u0001\u0003.!9!Q\b\u0004\u0005\u0002\t}\u0002b\u0002B%\r\u0011\u0005!1\n\u0005\b\u0005\u001f2A\u0011\u0002B)\u0011\u001d\u0011\u0019F\u0002C\u0001\u0005+B\u0011B!\u0019\u0007#\u0003%\tAa\u0019\t\u000f\ted\u0001\"\u0001\u0003R\u00051BK]1og\u0006\u001cG/[8o\u0007>|'\u000fZ5oCR|'O\u0003\u0002&M\u0005YAO]1og\u0006\u001cG/[8o\u0015\t9\u0003&A\u0006d_>\u0014H-\u001b8bi>\u0014(\"A\u0015\u0002\u000b-\fgm[1\u0004\u0001A\u0011A&A\u0007\u0002I\t1BK]1og\u0006\u001cG/[8o\u0007>|'\u000fZ5oCR|'o\u0005\u0002\u0002_A\u0011\u0001gM\u0007\u0002c)\t!'A\u0003tG\u0006d\u0017-\u0003\u00025c\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#A\u0016\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u001fe\u0012YHa#\u0003\u0016\n]%q\u0015B[\u0005\u007f\u0003\"\u0001\f\u0004\u0014\u0007\u0019y3\b\u0005\u0002=\u007f5\tQH\u0003\u0002?Q\u0005)Q\u000f^5mg&\u0011\u0001)\u0010\u0002\b\u0019><w-\u001b8h\u0003!\u0011'o\\6fe&#\u0007C\u0001\u0019D\u0013\t!\u0015GA\u0002J]R\f\u0011\u0002\u001e=o\u0007>tg-[4\u0011\u00051:\u0015B\u0001%%\u0005E!&/\u00198tC\u000e$\u0018n\u001c8D_:4\u0017nZ\u0001\ng\u000eDW\rZ;mKJ\u0004\"\u0001P&\n\u00051k$!C*dQ\u0016$W\u000f\\3s\u0003E\u0001(o\u001c3vG\u0016\u0014\u0018\nZ'b]\u0006<WM\u001d\t\u0003Y=K!\u0001\u0015\u0013\u0003#A\u0013x\u000eZ;dKJLE-T1oC\u001e,'/\u0001\u0006uq:l\u0015M\\1hKJ\u0004\"\u0001L*\n\u0005Q##a\u0006+sC:\u001c\u0018m\u0019;j_:\u001cF/\u0019;f\u001b\u0006t\u0017mZ3s\u0003]!\bP\\'be.,'o\u00115b]:,G.T1oC\u001e,'\u000f\u0005\u0002-/&\u0011\u0001\f\n\u0002 )J\fgn]1di&|g.T1sW\u0016\u00148\t[1o]\u0016dW*\u00198bO\u0016\u0014\u0018\u0001\u0002;j[\u0016\u0004\"a\u00173\u000e\u0003qS!AP/\u000b\u0005y{\u0016AB2p[6|gN\u0003\u0002*A*\u0011\u0011MY\u0001\u0007CB\f7\r[3\u000b\u0003\r\f1a\u001c:h\u0013\t)GL\u0001\u0003US6,\u0017A\u00037pO\u000e{g\u000e^3yiB\u00111\f[\u0005\u0003Sr\u0013!\u0002T8h\u0007>tG/\u001a=u)%I4\u000e\\7o_B\f(\u000fC\u0003B\u001f\u0001\u0007!\tC\u0003F\u001f\u0001\u0007a\tC\u0003J\u001f\u0001\u0007!\nC\u0003N\u001f\u0001\u0007a\nC\u0003R\u001f\u0001\u0007!\u000bC\u0003V\u001f\u0001\u0007a\u000bC\u0003Z\u001f\u0001\u0007!\fC\u0003g\u001f\u0001\u0007qM\u0001\fJ]&$\bK]8ek\u000e,'/\u00133DC2d'-Y2l!\u0011\u0001To\u001e>\n\u0005Y\f$!\u0003$v]\u000e$\u0018n\u001c82!\ta\u00030\u0003\u0002zI\t!\u0012J\\5u!J|G-^2fe&#'+Z:vYR\u0004\"\u0001M>\n\u0005q\f$\u0001B+oSR\u0014Q#\u00113e!\u0006\u0014H/\u001b;j_:\u001c8)\u00197mE\u0006\u001c7\u000e\u0005\u00031k~T\b\u0003BA\u0001\u0003\u000fi!!a\u0001\u000b\u0007\u0005\u0015Q,\u0001\u0005qe>$xnY8m\u0013\u0011\tI!a\u0001\u0003\r\u0015\u0013(o\u001c:t\u00059)e\u000e\u001a+y]\u000e\u000bG\u000e\u001c2bG.\u0014\u0011\"\u00119j%\u0016\u001cX\u000f\u001c;\u0016\t\u0005E\u0011Q\u0006\t\b\u0003'\t\u0019c`A\u0015\u001d\u0011\t)\"a\b\u000f\t\u0005]\u0011QD\u0007\u0003\u00033Q1!a\u0007+\u0003\u0019a$o\\8u}%\t!'C\u0002\u0002\"E\nq\u0001]1dW\u0006<W-\u0003\u0003\u0002&\u0005\u001d\"AB#ji\",'OC\u0002\u0002\"E\u0002B!a\u000b\u0002.1\u0001AaBA\u0018'\t\u0007\u0011\u0011\u0007\u0002\u0002)F!\u00111GA\u001d!\r\u0001\u0014QG\u0005\u0004\u0003o\t$a\u0002(pi\"Lgn\u001a\t\u0004a\u0005m\u0012bAA\u001fc\t\u0019\u0011I\\=\u0002\u0011%\u001c\u0018i\u0019;jm\u0016,\"!a\u0011\u0011\t\u0005\u0015\u0013qK\u0007\u0003\u0003\u000fRA!!\u0013\u0002L\u00051\u0011\r^8nS\u000eTA!!\u0014\u0002P\u0005Q1m\u001c8dkJ\u0014XM\u001c;\u000b\t\u0005E\u00131K\u0001\u0005kRLGN\u0003\u0002\u0002V\u0005!!.\u0019<b\u0013\u0011\tI&a\u0012\u0003\u001b\u0005#x.\\5d\u0005>|G.Z1o\u0003%I7/Q2uSZ,\u0007%\u0001\u000biC:$G.Z%oSR\u0004&o\u001c3vG\u0016\u0014\u0018\n\u001a\u000b\nu\u0006\u0005\u0014QOA=\u0003\u0013Cq!a\u0019\u0017\u0001\u0004\t)'A\bue\u0006t7/Y2uS>t\u0017\r\\%e!\u0011\t9'a\u001c\u000f\t\u0005%\u00141\u000e\t\u0004\u0003/\t\u0014bAA7c\u00051\u0001K]3eK\u001aLA!!\u001d\u0002t\t11\u000b\u001e:j]\u001eT1!!\u001c2\u0011\u0019\t9H\u0006a\u0001\u0005\u0006!BO]1og\u0006\u001cG/[8o)&lWm\\;u\u001bNDq!a\u001f\u0017\u0001\u0004\ti(\u0001\u000efqB,7\r^3e!J|G-^2fe&#\u0017I\u001c3Fa>\u001c\u0007\u000eE\u00031\u0003\u007f\n\u0019)C\u0002\u0002\u0002F\u0012aa\u00149uS>t\u0007cA.\u0002\u0006&\u0019\u0011q\u0011/\u0003%A\u0013x\u000eZ;dKJLE-\u00118e\u000bB|7\r\u001b\u0005\b\u0003\u00173\u0002\u0019AAG\u0003A\u0011Xm\u001d9p]N,7)\u00197mE\u0006\u001c7\u000eE\u0002\u0002\u0010Bi\u0011AB\u0001\u001daJ,\u0007/\u0019:f\u0013:LG\u000f\u0015:pIV\u001cWM]%e)J\fgn]5u)1\t)*a)\u0002&\u0006\u001d\u00161VA[!\u0015\tyiEAL!\u0019\u0001\u0014\u0011\u0014\"\u0002\u001e&\u0019\u00111T\u0019\u0003\rQ+\b\u000f\\33!\ra\u0013qT\u0005\u0004\u0003C##A\u0005+y]R\u0013\u0018M\\:ji6+G/\u00193bi\u0006Dq!a\u0019\u0018\u0001\u0004\t)\u0007\u0003\u0004\u0002x]\u0001\rA\u0011\u0005\u0007\u0003S;\u0002\u0019\u0001\"\u0002!\r|wN\u001d3j]\u0006$xN]#q_\u000eD\u0007bBAW/\u0001\u0007\u0011qV\u0001\fibtW*\u001a;bI\u0006$\u0018\rE\u0002-\u0003cK1!a-%\u0005M!&/\u00198tC\u000e$\u0018n\u001c8NKR\fG-\u0019;b\u0011\u001d\tYh\u0006a\u0001\u0003{\n\u0001\u0005[1oI2,\u0017\t\u001a3QCJ$\u0018\u000e^5p]N$v\u000e\u0016:b]N\f7\r^5p]RY!0a/\u0002>\u0006\u001d\u0017\u0011[Au\u0011\u001d\t\u0019\u0007\u0007a\u0001\u0003KBq!a0\u0019\u0001\u0004\t\t-\u0001\u0006qe>$WoY3s\u0013\u0012\u00042\u0001MAb\u0013\r\t)-\r\u0002\u0005\u0019>tw\rC\u0004\u0002Jb\u0001\r!a3\u0002\u001bA\u0014x\u000eZ;dKJ,\u0005o\\2i!\r\u0001\u0014QZ\u0005\u0004\u0003\u001f\f$!B*i_J$\bbBAj1\u0001\u0007\u0011Q[\u0001\u000ba\u0006\u0014H/\u001b;j_:\u001c\bCBAl\u0003;\f\t/\u0004\u0002\u0002Z*\u0019\u00111\\\u0019\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002`\u0006e'aA*fiB!\u00111]As\u001b\u0005i\u0016bAAt;\nqAk\u001c9jGB\u000b'\u000f^5uS>t\u0007bBAF1\u0001\u0007\u00111\u001e\t\u0004\u0003\u001f\u000b\u0012AC8o\u000b2,7\r^5p]R)!0!=\u0002v\"1\u00111_\rA\u0002\t\u000b1\u0003\u001e=o)>\u0004\u0018n\u0019)beRLG/[8o\u0013\u0012Da!!+\u001a\u0001\u0004\u0011\u0015!D8o%\u0016\u001c\u0018n\u001a8bi&|g\u000eF\u0003{\u0003w\fi\u0010\u0003\u0004\u0002tj\u0001\rA\u0011\u0005\b\u0003SS\u0002\u0019AA\u0000!\u0011\u0001\u0014q\u0010\"\u0002O1|w-\u00138wC2LGm\u0015;bi\u0016$&/\u00198tSRLwN\\!oIJ+G/\u001e:o\u000bJ\u0014xN\u001d\u000b\t\u0005\u000b\u0011yA!\u0005\u0003\u001cA9!q\u0001B\u0006\u007f\u0006MRB\u0001B\u0005\u0015\r\t\t&M\u0005\u0005\u0005\u001b\u0011IA\u0001\u0003MK\u001a$\bbBA27\u0001\u0007\u0011Q\r\u0005\b\u0005'Y\u0002\u0019\u0001B\u000b\u0003A!(/\u00198tC\u000e$\u0018n\u001c8Ti\u0006$X\rE\u0002-\u0005/I1A!\u0007%\u0005A!&/\u00198tC\u000e$\u0018n\u001c8Ti\u0006$X\rC\u0004\u0003\u001em\u0001\rAa\b\u0002#Q\u0014\u0018M\\:bGRLwN\u001c*fgVdG\u000f\u0005\u0003\u0003\"\t\u001dRB\u0001B\u0012\u0015\r\u0011)#X\u0001\te\u0016\fX/Z:ug&!!\u0011\u0006B\u0012\u0005E!&/\u00198tC\u000e$\u0018n\u001c8SKN,H\u000e^\u0001\u0015Q\u0006tG\r\\3F]\u0012$&/\u00198tC\u000e$\u0018n\u001c8\u0015\u0017i\u0014yC!\r\u00034\tU\"\u0011\b\u0005\b\u0003Gb\u0002\u0019AA3\u0011\u001d\ty\f\ba\u0001\u0003\u0003Dq!!3\u001d\u0001\u0004\tY\rC\u0004\u00038q\u0001\rAa\b\u0002\u001fQDh.T1sW\u0016\u0014(+Z:vYRDq!a#\u001d\u0001\u0004\u0011Y\u0004E\u0002\u0002\u0010J\tq\u0003\u001e:b]N\f7\r^5p]R{\u0007/[2D_:4\u0017nZ:\u0016\u0005\t\u0005\u0003\u0003\u0002B\"\u0005\u000bj!!a\u0014\n\t\t\u001d\u0013q\n\u0002\u000b!J|\u0007/\u001a:uS\u0016\u001c\u0018\u0001\u00049beRLG/[8o\r>\u0014Hc\u0001\"\u0003N!9\u00111\r\u0010A\u0002\u0005\u0015\u0014!G1c_J$H+[7fI>+H\u000f\u0016:b]N\f7\r^5p]N$\u0012A_\u0001\bgR\f'\u000f^;q)\rQ(q\u000b\u0005\n\u00053\u0002\u0003\u0013!a\u0001\u00057\nq$\u001a8bE2,GK]1og\u0006\u001cG/[8oC2LE-\u0012=qSJ\fG/[8o!\r\u0001$QL\u0005\u0004\u0005?\n$a\u0002\"p_2,\u0017M\\\u0001\u0012gR\f'\u000f^;qI\u0011,g-Y;mi\u0012\nTC\u0001B3U\u0011\u0011YFa\u001a,\u0005\t%\u0004\u0003\u0002B6\u0005kj!A!\u001c\u000b\t\t=$\u0011O\u0001\nk:\u001c\u0007.Z2lK\u0012T1Aa\u001d2\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0005o\u0012iGA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\f\u0001b\u001d5vi\u0012|wO\u001c\u0005\b\u0005{\u001a\u0001\u0019\u0001B@\u0003\u0019\u0019wN\u001c4jOB!!\u0011\u0011BD\u001b\t\u0011\u0019IC\u0002\u0003\u0006\"\naa]3sm\u0016\u0014\u0018\u0002\u0002BE\u0005\u0007\u00131bS1gW\u0006\u001cuN\u001c4jO\"9!QR\u0002A\u0002\t=\u0015A\u0004:fa2L7-Y'b]\u0006<WM\u001d\t\u0005\u0005\u0003\u0013\t*\u0003\u0003\u0003\u0014\n\r%A\u0004*fa2L7-Y'b]\u0006<WM\u001d\u0005\u0006\u0013\u000e\u0001\rA\u0013\u0005\b\u00053\u001b\u0001\u0019\u0001BN\u0003!Q8n\u00117jK:$\b\u0003\u0002BO\u0005Gk!Aa(\u000b\u0007\t\u0005\u0006&\u0001\u0002{W&!!Q\u0015BP\u00055Y\u0015MZ6b5.\u001cE.[3oi\"9!\u0011V\u0002A\u0002\t-\u0016aB7fiJL7m\u001d\t\u0005\u0005[\u0013\t,\u0004\u0002\u00030*\u0019!\u0011V/\n\t\tM&q\u0016\u0002\b\u001b\u0016$(/[2t\u0011\u001d\u00119l\u0001a\u0001\u0005s\u000bQ\"\\3uC\u0012\fG/Y\"bG\",\u0007\u0003\u0002BA\u0005wKAA!0\u0003\u0004\niQ*\u001a;bI\u0006$\u0018mQ1dQ\u0016DQ!W\u0002A\u0002i\u000bA#\u001b8jiR\u0013\u0018M\\:bGRLwN\\#se>\u0014HcA<\u0003F\"1!q\u0019\u0003A\u0002}\fQ!\u001a:s_J\fq#\u001b8jiR\u0013\u0018M\\:bGRLwN\\'fi\u0006$\u0017\r^1\u0015\u0007]\u0014i\rC\u0004\u0002.\u0016\u0001\r!!(")
public class TransactionCoordinator
implements Logging {
    private final TransactionConfig txnConfig;
    private final Scheduler scheduler;
    private final ProducerIdManager producerIdManager;
    private final TransactionStateManager txnManager;
    private final TransactionMarkerChannelManager txnMarkerChannelManager;
    private final Time time;
    private final AtomicBoolean isActive;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static TransactionCoordinator apply(KafkaConfig kafkaConfig, ReplicaManager replicaManager, Scheduler scheduler, KafkaZkClient kafkaZkClient, Metrics metrics, MetadataCache metadataCache, Time time) {
        return TransactionCoordinator$.MODULE$.apply(kafkaConfig, replicaManager, scheduler, kafkaZkClient, metrics, metadataCache, time);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private AtomicBoolean isActive() {
        return this.isActive;
    }

    public void handleInitProducerId(String transactionalId, int transactionTimeoutMs, Option<ProducerIdAndEpoch> expectedProducerIdAndEpoch, Function1<InitProducerIdResult, BoxedUnit> responseCallback) {
        Tuple2 tuple2;
        Either either;
        Either either2;
        if (transactionalId == null) {
            long producerId = this.producerIdManager.generateProducerId();
            responseCallback.apply((Object)new InitProducerIdResult(producerId, 0, Errors.NONE));
            return;
        }
        if (transactionalId.isEmpty()) {
            responseCallback.apply((Object)TransactionCoordinator$.MODULE$.kafka$coordinator$transaction$TransactionCoordinator$$initTransactionError(Errors.INVALID_REQUEST));
            return;
        }
        if (!this.txnManager.validateTransactionTimeoutMs(transactionTimeoutMs)) {
            responseCallback.apply((Object)TransactionCoordinator$.MODULE$.kafka$coordinator$transaction$TransactionCoordinator$$initTransactionError(Errors.INVALID_TRANSACTION_TIMEOUT));
            return;
        }
        Either.RightProjection rightProjection = this.txnManager.getTransactionState(transactionalId).right();
        if (rightProjection == null) {
            throw null;
        }
        Either.RightProjection flatMap_this = rightProjection;
        Either either3 = flatMap_this.e();
        if (either3 instanceof Right) {
            Option option = (Option)((Right)either3).value();
            either2 = TransactionCoordinator.$anonfun$handleInitProducerId$1(this, transactionalId, transactionTimeoutMs, option);
        } else {
            either2 = flatMap_this.e();
        }
        Either.RightProjection rightProjection2 = either2.right();
        if (rightProjection2 == null) {
            throw null;
        }
        Either.RightProjection flatMap_this2 = rightProjection2;
        Either either4 = flatMap_this2.e();
        if (either4 instanceof Right) {
            CoordinatorEpochAndTxnMetadata coordinatorEpochAndTxnMetadata = (CoordinatorEpochAndTxnMetadata)((Right)either4).value();
            either = TransactionCoordinator.$anonfun$handleInitProducerId$2(this, transactionalId, transactionTimeoutMs, expectedProducerIdAndEpoch, coordinatorEpochAndTxnMetadata);
        } else {
            either = flatMap_this2.e();
        }
        if (either instanceof Left) {
            Errors error2 = (Errors)((Left)either).value();
            BoxedUnit cfr_ignored_0 = (BoxedUnit)responseCallback.apply((Object)TransactionCoordinator$.MODULE$.kafka$coordinator$transaction$TransactionCoordinator$$initTransactionError(error2));
            return;
        }
        if (either instanceof Right && (tuple2 = (Tuple2)((Right)either).value()) != null) {
            int coordinatorEpoch = tuple2._1$mcI$sp();
            TxnTransitMetadata newMetadata = (TxnTransitMetadata)tuple2._2();
            TransactionState transactionState = newMetadata.txnState();
            PrepareEpochFence$ prepareEpochFence$ = PrepareEpochFence$.MODULE$;
            if (!(transactionState != null ? !transactionState.equals(prepareEpochFence$) : prepareEpochFence$ != null)) {
                this.handleEndTransaction(transactionalId, newMetadata.producerId(), newMetadata.producerEpoch(), TransactionResult.ABORT, (Function1<Errors, BoxedUnit>)(Function1 & Serializable & scala.Serializable)error -> {
                    Errors errors = error;
                    Errors errors2 = Errors.NONE;
                    if (errors == null ? errors2 != null : !errors.equals(errors2)) {
                        responseCallback.apply((Object)TransactionCoordinator$.MODULE$.kafka$coordinator$transaction$TransactionCoordinator$$initTransactionError((Errors)error));
                    } else {
                        responseCallback.apply((Object)TransactionCoordinator$.MODULE$.kafka$coordinator$transaction$TransactionCoordinator$$initTransactionError(Errors.CONCURRENT_TRANSACTIONS));
                    }
                    return BoxedUnit.UNIT;
                });
                return;
            }
            this.txnManager.appendTransactionToLog(transactionalId, coordinatorEpoch, newMetadata, (Function1<Errors, BoxedUnit>)(Function1 & Serializable & scala.Serializable)error -> {
                Errors errors = error;
                Errors errors2 = Errors.NONE;
                if (!(errors != null ? !errors.equals(errors2) : errors2 != null)) {
                    this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(99).append("Initialized transactionalId ").append(transactionalId).append(" with producerId ").append(newMetadata.producerId()).append(" and producer ").append("epoch ").append(newMetadata.producerEpoch()).append(" on partition ").append("__transaction_state").append("-").append($this.txnManager.partitionFor(transactionalId)).toString());
                    responseCallback.apply((Object)TransactionCoordinator$.MODULE$.kafka$coordinator$transaction$TransactionCoordinator$$initTransactionMetadata(newMetadata));
                } else {
                    this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(61).append("Returning ").append(error).append(" error code to client for ").append(transactionalId).append("'s InitProducerId request").toString());
                    responseCallback.apply((Object)TransactionCoordinator$.MODULE$.kafka$coordinator$transaction$TransactionCoordinator$$initTransactionError((Errors)error));
                }
                return BoxedUnit.UNIT;
            }, this.txnManager.appendTransactionToLog$default$5());
            return;
        }
        throw new MatchError((Object)either);
    }

    private Either<Errors, Tuple2<Object, TxnTransitMetadata>> prepareInitProducerIdTransit(String transactionalId, int transactionTimeoutMs, int coordinatorEpoch, TransactionMetadata txnMetadata, Option<ProducerIdAndEpoch> expectedProducerIdAndEpoch) {
        Left left;
        ProducerIdAndEpoch producerIdAndEpoch;
        if (txnMetadata.pendingTransitionInProgress()) {
            return package$.MODULE$.Left().apply((Object)Errors.CONCURRENT_TRANSACTIONS);
        }
        if (expectedProducerIdAndEpoch == null) {
            throw null;
        }
        boolean bl = expectedProducerIdAndEpoch.isEmpty() || TransactionCoordinator.isValidProducerId$1(producerIdAndEpoch = (ProducerIdAndEpoch)expectedProducerIdAndEpoch.get(), txnMetadata);
        if (!bl) {
            return package$.MODULE$.Left().apply((Object)Errors.INVALID_PRODUCER_EPOCH);
        }
        TransactionState transactionState = txnMetadata.state();
        boolean bl2 = PrepareAbort$.MODULE$.equals(transactionState) ? true : PrepareCommit$.MODULE$.equals(transactionState);
        if (bl2) {
            left = package$.MODULE$.Left().apply((Object)Errors.CONCURRENT_TRANSACTIONS);
        } else {
            boolean bl3 = CompleteAbort$.MODULE$.equals(transactionState) ? true : (CompleteCommit$.MODULE$.equals(transactionState) ? true : Empty$.MODULE$.equals(transactionState));
            if (bl3) {
                Left left2;
                Right transitMetadataResult;
                Right right;
                ProducerIdAndEpoch producerIdAndEpoch2;
                boolean bl4;
                if (txnMetadata.isProducerEpochExhausted() && (bl4 = expectedProducerIdAndEpoch.isEmpty() || TransactionCoordinator.$anonfun$prepareInitProducerIdTransit$2(txnMetadata, producerIdAndEpoch2 = (ProducerIdAndEpoch)expectedProducerIdAndEpoch.get()))) {
                    long newProducerId = this.producerIdManager.generateProducerId();
                    right = package$.MODULE$.Right().apply((Object)txnMetadata.prepareProducerIdRotation(newProducerId, transactionTimeoutMs, this.time.milliseconds(), expectedProducerIdAndEpoch.isDefined()));
                } else {
                    Object object = expectedProducerIdAndEpoch.isEmpty() ? None$.MODULE$ : new Some((Object)BoxesRunTime.boxToShort((short)((ProducerIdAndEpoch)expectedProducerIdAndEpoch.get()).epoch));
                    right = transitMetadataResult = txnMetadata.prepareIncrementProducerEpoch(transactionTimeoutMs, (Option<Object>)object, this.time.milliseconds());
                }
                if (transitMetadataResult instanceof Right) {
                    TxnTransitMetadata transitMetadata = (TxnTransitMetadata)((Right)transitMetadataResult).value();
                    left2 = package$.MODULE$.Right().apply((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)coordinatorEpoch), (Object)transitMetadata));
                } else if (transitMetadataResult instanceof Left) {
                    Errors err = (Errors)((Left)transitMetadataResult).value();
                    left2 = package$.MODULE$.Left().apply((Object)err);
                } else {
                    throw new MatchError((Object)transitMetadataResult);
                }
                left = left2;
            } else if (Ongoing$.MODULE$.equals(transactionState)) {
                left = package$.MODULE$.Right().apply((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)coordinatorEpoch), (Object)txnMetadata.prepareFenceProducerEpoch()));
            } else {
                boolean bl5 = Dead$.MODULE$.equals(transactionState) ? true : PrepareEpochFence$.MODULE$.equals(transactionState);
                if (bl5) {
                    String errorMsg = new StringBuilder(103).append("Found transactionalId ").append(transactionalId).append(" with state ").append(txnMetadata.state()).append(". ").append("This is illegal as we should never have transitioned to this state.").toString();
                    this.fatal((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> errorMsg);
                    throw new IllegalStateException(errorMsg);
                }
                throw new MatchError((Object)transactionState);
            }
        }
        return left;
    }

    public void handleAddPartitionsToTransaction(String transactionalId, long producerId, short producerEpoch, Set<TopicPartition> partitions, Function1<Errors, BoxedUnit> responseCallback) {
        Tuple2 tuple2;
        Either either;
        if (transactionalId == null || transactionalId.isEmpty()) {
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(60).append("Returning ").append(Errors.INVALID_REQUEST).append(" error code to client for ").append(transactionalId).append("'s AddPartitions request").toString());
            responseCallback.apply((Object)Errors.INVALID_REQUEST);
            return;
        }
        Either.RightProjection rightProjection = this.txnManager.getTransactionState(transactionalId).right();
        if (rightProjection == null) {
            throw null;
        }
        Either.RightProjection flatMap_this = rightProjection;
        Either either2 = flatMap_this.e();
        if (either2 instanceof Right) {
            Option option = (Option)((Right)either2).value();
            either = TransactionCoordinator.$anonfun$handleAddPartitionsToTransaction$2(this, producerId, producerEpoch, partitions, option);
        } else {
            either = flatMap_this.e();
        }
        if (either instanceof Left) {
            Errors err = (Errors)((Left)either).value();
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(60).append("Returning ").append(err).append(" error code to client for ").append(transactionalId).append("'s AddPartitions request").toString());
            BoxedUnit cfr_ignored_0 = (BoxedUnit)responseCallback.apply((Object)err);
            return;
        }
        if (either instanceof Right && (tuple2 = (Tuple2)((Right)either).value()) != null) {
            int coordinatorEpoch = tuple2._1$mcI$sp();
            TxnTransitMetadata newMetadata = (TxnTransitMetadata)tuple2._2();
            this.txnManager.appendTransactionToLog(transactionalId, coordinatorEpoch, newMetadata, responseCallback, this.txnManager.appendTransactionToLog$default$5());
            return;
        }
        throw new MatchError((Object)either);
    }

    public void onElection(int txnTopicPartitionId, int coordinatorEpoch2) {
        this.txnMarkerChannelManager.removeMarkersForTxnTopicPartition(txnTopicPartitionId);
        this.txnManager.loadTransactionsForTxnTopicPartition(txnTopicPartitionId, coordinatorEpoch2, (Function5<String, Object, TransactionResult, TransactionMetadata, TxnTransitMetadata, BoxedUnit>)(Function5 & Serializable & scala.Serializable)(transactionalId, coordinatorEpoch, txnResult, txnMetadata, newMetadata) -> {
            this.txnMarkerChannelManager.addTxnMarkersToSend(transactionalId, BoxesRunTime.unboxToInt((Object)coordinatorEpoch), txnResult, txnMetadata, newMetadata);
            return BoxedUnit.UNIT;
        });
    }

    public void onResignation(int txnTopicPartitionId, Option<Object> coordinatorEpoch) {
        if (coordinatorEpoch instanceof Some) {
            int epoch = BoxesRunTime.unboxToInt((Object)((Some)coordinatorEpoch).value());
            this.txnManager.removeTransactionsForTxnTopicPartition(txnTopicPartitionId, epoch);
        } else if (None$.MODULE$.equals(coordinatorEpoch)) {
            this.txnManager.removeTransactionsForTxnTopicPartition(txnTopicPartitionId);
        } else {
            throw new MatchError(coordinatorEpoch);
        }
        this.txnMarkerChannelManager.removeMarkersForTxnTopicPartition(txnTopicPartitionId);
    }

    private Left<Errors, Nothing$> logInvalidStateTransitionAndReturnError(String transactionalId, TransactionState transactionState, TransactionResult transactionResult) {
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(79).append("TransactionalId: ").append(transactionalId).append("'s state is ").append(transactionState).append(", but received transaction ").append("marker result to send: ").append(transactionResult).toString());
        return package$.MODULE$.Left().apply((Object)Errors.INVALID_TXN_STATE);
    }

    public void handleEndTransaction(String transactionalId, long producerId, short producerEpoch, TransactionResult txnMarkerResult, Function1<Errors, BoxedUnit> responseCallback) {
        Tuple2 tuple2;
        Either either;
        if (transactionalId == null || transactionalId.isEmpty()) {
            responseCallback.apply((Object)Errors.INVALID_REQUEST);
            return;
        }
        Either.RightProjection rightProjection = this.txnManager.getTransactionState(transactionalId).right();
        if (rightProjection == null) {
            throw null;
        }
        Either.RightProjection flatMap_this = rightProjection;
        Either either2 = flatMap_this.e();
        if (either2 instanceof Right) {
            Option option = (Option)((Right)either2).value();
            either = TransactionCoordinator.$anonfun$handleEndTransaction$1(this, producerId, producerEpoch, txnMarkerResult, transactionalId, option);
        } else {
            either = flatMap_this.e();
        }
        if (either instanceof Left) {
            Errors err = (Errors)((Left)either).value();
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(116).append("Aborting append of ").append(txnMarkerResult).append(" to transaction log with coordinator and returning ").append(err).append(" error to client for ").append(transactionalId).append("'s EndTransaction request").toString());
            BoxedUnit cfr_ignored_0 = (BoxedUnit)responseCallback.apply((Object)err);
            return;
        }
        if (either instanceof Right && (tuple2 = (Tuple2)((Right)either).value()) != null) {
            int coordinatorEpoch = tuple2._1$mcI$sp();
            TxnTransitMetadata newMetadata = (TxnTransitMetadata)tuple2._2();
            this.txnManager.appendTransactionToLog(transactionalId, coordinatorEpoch, newMetadata, (Function1<Errors, BoxedUnit>)(Function1 & Serializable & scala.Serializable)error -> {
                Errors errors = error;
                Errors errors2 = Errors.NONE;
                if (!(errors != null ? !errors.equals(errors2) : errors2 != null)) {
                    Either either;
                    Either.RightProjection rightProjection = $this.txnManager.getTransactionState(transactionalId).right();
                    if (rightProjection == null) {
                        throw null;
                    }
                    Either.RightProjection $anonfun$handleEndTransaction$12_sendTxnMarkersCallback$1_flatMap_this = rightProjection;
                    Either either2 = $anonfun$handleEndTransaction$12_sendTxnMarkersCallback$1_flatMap_this.e();
                    if (either2 instanceof Right) {
                        Option option = (Option)((Right)either2).value();
                        either = TransactionCoordinator.$anonfun$handleEndTransaction$5(this, transactionalId, coordinatorEpoch, producerId, producerEpoch, txnMarkerResult, option);
                    } else {
                        either = $anonfun$handleEndTransaction$12_sendTxnMarkersCallback$1_flatMap_this.e();
                    }
                    if (either instanceof Left) {
                        Errors $anonfun$handleEndTransaction$12_sendTxnMarkersCallback$1_err = (Errors)((Left)either).value();
                        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(135).append("Aborting sending of transaction markers after appended ").append(txnMarkerResult).append(" to transaction log and returning ").append(sendTxnMarkersCallback$1_err).append(" error to client for ").append(transactionalId).append("'s EndTransaction request").toString());
                        BoxedUnit cfr_ignored_0 = (BoxedUnit)responseCallback.apply((Object)$anonfun$handleEndTransaction$12_sendTxnMarkersCallback$1_err);
                        return BoxedUnit.UNIT;
                    } else {
                        Tuple2 tuple2;
                        if (!(either instanceof Right) || (tuple2 = (Tuple2)((Right)either).value()) == null) throw new MatchError((Object)either);
                        TransactionMetadata $anonfun$handleEndTransaction$12_sendTxnMarkersCallback$1_txnMetadata = (TransactionMetadata)tuple2._1();
                        TxnTransitMetadata $anonfun$handleEndTransaction$12_sendTxnMarkersCallback$1_newPreSendMetadata = (TxnTransitMetadata)tuple2._2();
                        responseCallback.apply((Object)Errors.NONE);
                        $this.txnMarkerChannelManager.addTxnMarkersToSend(transactionalId, coordinatorEpoch, txnMarkerResult, $anonfun$handleEndTransaction$12_sendTxnMarkersCallback$1_txnMetadata, $anonfun$handleEndTransaction$12_sendTxnMarkersCallback$1_newPreSendMetadata);
                    }
                    return BoxedUnit.UNIT;
                } else {
                    this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(172).append("Aborting sending of transaction markers and returning ").append(error).append(" error to client for ").append(transactionalId).append("'s EndTransaction request of ").append(txnMarkerResult).append(", ").append("since appending ").append(newMetadata).append(" to transaction log with coordinator epoch ").append(coordinatorEpoch).append(" failed").toString());
                    responseCallback.apply(error);
                }
                return BoxedUnit.UNIT;
            }, this.txnManager.appendTransactionToLog$default$5());
            return;
        }
        throw new MatchError((Object)either);
    }

    public Properties transactionTopicConfigs() {
        return this.txnManager.transactionTopicConfigs();
    }

    public int partitionFor(String transactionalId) {
        return this.txnManager.partitionFor(transactionalId);
    }

    private void abortTimedOutTransactions() {
        this.txnManager.timedOutTransactions().foreach((Function1 & Serializable & scala.Serializable)txnIdAndPidEpoch -> {
            TransactionCoordinator.$anonfun$abortTimedOutTransactions$4(this, txnIdAndPidEpoch);
            return BoxedUnit.UNIT;
        });
    }

    public void startup(boolean enableTransactionalIdExpiration) {
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Starting up.");
        this.scheduler.startup();
        this.scheduler.schedule("transaction-abort", (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.abortTimedOutTransactions(), this.txnConfig.abortTimedOutTransactionsIntervalMs(), this.txnConfig.abortTimedOutTransactionsIntervalMs(), this.scheduler.schedule$default$5());
        if (enableTransactionalIdExpiration) {
            this.txnManager.enableTransactionalIdExpiration();
        }
        this.txnMarkerChannelManager.start();
        this.isActive().set(true);
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Startup complete.");
    }

    public boolean startup$default$1() {
        return true;
    }

    public void shutdown() {
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Shutting down.");
        this.isActive().set(false);
        this.scheduler.shutdown();
        this.producerIdManager.shutdown();
        this.txnManager.shutdown();
        this.txnMarkerChannelManager.shutdown();
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Shutdown complete.");
    }

    public static final /* synthetic */ Either $anonfun$handleInitProducerId$1(TransactionCoordinator $this, String transactionalId$1, int transactionTimeoutMs$1, Option x0$1) {
        Either<Errors, CoordinatorEpochAndTxnMetadata> either;
        if (None$.MODULE$.equals(x0$1)) {
            long producerId = $this.producerIdManager.generateProducerId();
            long x$3 = -1L;
            short x$4 = -1;
            short x$5 = -1;
            Empty$ x$7 = Empty$.MODULE$;
            scala.collection.mutable.Set x$8 = Set$.MODULE$.empty();
            long x$9 = $this.time.milliseconds();
            long x$10 = TransactionMetadata$.MODULE$.$lessinit$greater$default$9();
            TransactionMetadata createdMetadata = new TransactionMetadata(transactionalId$1, producerId, x$3, x$4, x$5, transactionTimeoutMs$1, x$7, (scala.collection.mutable.Set<TopicPartition>)x$8, x$10, x$9);
            either = $this.txnManager.putTransactionStateIfNotExists(createdMetadata);
        } else if (x0$1 instanceof Some) {
            CoordinatorEpochAndTxnMetadata epochAndTxnMetadata = (CoordinatorEpochAndTxnMetadata)((Some)x0$1).value();
            either = package$.MODULE$.Right().apply((Object)epochAndTxnMetadata);
        } else {
            throw new MatchError((Object)x0$1);
        }
        return either;
    }

    public static final /* synthetic */ Either $anonfun$handleInitProducerId$2(TransactionCoordinator $this, String transactionalId$1, int transactionTimeoutMs$1, Option expectedProducerIdAndEpoch$1, CoordinatorEpochAndTxnMetadata existingEpochAndMetadata) {
        int coordinatorEpoch = existingEpochAndMetadata.coordinatorEpoch();
        TransactionMetadata txnMetadata = existingEpochAndMetadata.transactionMetadata();
        return (Either)txnMetadata.inLock((Function0 & Serializable & scala.Serializable)() -> $this.prepareInitProducerIdTransit(transactionalId$1, transactionTimeoutMs$1, coordinatorEpoch, txnMetadata, (Option<ProducerIdAndEpoch>)expectedProducerIdAndEpoch$1));
    }

    private static final void sendRetriableErrorCallback$1(Errors error, Function1 responseCallback$1) {
        Errors errors = error;
        Errors errors2 = Errors.NONE;
        if (errors == null ? errors2 != null : !errors.equals(errors2)) {
            responseCallback$1.apply((Object)TransactionCoordinator$.MODULE$.kafka$coordinator$transaction$TransactionCoordinator$$initTransactionError(error));
            return;
        }
        responseCallback$1.apply((Object)TransactionCoordinator$.MODULE$.kafka$coordinator$transaction$TransactionCoordinator$$initTransactionError(Errors.CONCURRENT_TRANSACTIONS));
    }

    public static final /* synthetic */ void $anonfun$handleInitProducerId$4(Function1 responseCallback$1, Errors error) {
        Errors errors = error;
        Errors errors2 = Errors.NONE;
        if (errors == null ? errors2 != null : !errors.equals(errors2)) {
            responseCallback$1.apply((Object)TransactionCoordinator$.MODULE$.kafka$coordinator$transaction$TransactionCoordinator$$initTransactionError(error));
            return;
        }
        responseCallback$1.apply((Object)TransactionCoordinator$.MODULE$.kafka$coordinator$transaction$TransactionCoordinator$$initTransactionError(Errors.CONCURRENT_TRANSACTIONS));
    }

    private final void sendPidResponseCallback$1(Errors error, String transactionalId$1, TxnTransitMetadata newMetadata$1, Function1 responseCallback$1) {
        Errors errors = error;
        Errors errors2 = Errors.NONE;
        if (!(errors != null ? !errors.equals(errors2) : errors2 != null)) {
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(99).append("Initialized transactionalId ").append(transactionalId).append(" with producerId ").append(newMetadata.producerId()).append(" and producer ").append("epoch ").append(newMetadata.producerEpoch()).append(" on partition ").append("__transaction_state").append("-").append($this.txnManager.partitionFor(transactionalId)).toString());
            responseCallback$1.apply((Object)TransactionCoordinator$.MODULE$.kafka$coordinator$transaction$TransactionCoordinator$$initTransactionMetadata(newMetadata$1));
            return;
        }
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(61).append("Returning ").append(error).append(" error code to client for ").append(transactionalId).append("'s InitProducerId request").toString());
        responseCallback$1.apply((Object)TransactionCoordinator$.MODULE$.kafka$coordinator$transaction$TransactionCoordinator$$initTransactionError(error));
    }

    public static final /* synthetic */ void $anonfun$handleInitProducerId$7(TransactionCoordinator $this, String transactionalId$1, TxnTransitMetadata newMetadata$1, Function1 responseCallback$1, Errors error) {
        Errors errors = error;
        Errors errors2 = Errors.NONE;
        if (!(errors != null ? !errors.equals(errors2) : errors2 != null)) {
            $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(99).append("Initialized transactionalId ").append(transactionalId).append(" with producerId ").append(newMetadata.producerId()).append(" and producer ").append("epoch ").append(newMetadata.producerEpoch()).append(" on partition ").append("__transaction_state").append("-").append($this.txnManager.partitionFor(transactionalId)).toString());
            responseCallback$1.apply((Object)TransactionCoordinator$.MODULE$.kafka$coordinator$transaction$TransactionCoordinator$$initTransactionMetadata(newMetadata$1));
            return;
        }
        $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(61).append("Returning ").append(error).append(" error code to client for ").append(transactionalId).append("'s InitProducerId request").toString());
        responseCallback$1.apply((Object)TransactionCoordinator$.MODULE$.kafka$coordinator$transaction$TransactionCoordinator$$initTransactionError(error));
    }

    private static final boolean isValidProducerId$1(ProducerIdAndEpoch producerIdAndEpoch, TransactionMetadata txnMetadata$2) {
        return txnMetadata$2.producerEpoch() == -1 || producerIdAndEpoch.producerId == txnMetadata$2.producerId() || producerIdAndEpoch.producerId == txnMetadata$2.lastProducerId() && TransactionMetadata$.MODULE$.isEpochExhausted(producerIdAndEpoch.epoch);
    }

    public static final /* synthetic */ boolean $anonfun$prepareInitProducerIdTransit$2(TransactionMetadata txnMetadata$2, ProducerIdAndEpoch x$1) {
        return x$1.epoch == txnMetadata$2.producerEpoch();
    }

    public static final /* synthetic */ Either $anonfun$handleAddPartitionsToTransaction$2(TransactionCoordinator $this, long producerId$1, short producerEpoch$1, Set partitions$1, Option x0$1) {
        Left left;
        if (None$.MODULE$.equals(x0$1)) {
            left = package$.MODULE$.Left().apply((Object)Errors.INVALID_PRODUCER_ID_MAPPING);
        } else if (x0$1 instanceof Some) {
            CoordinatorEpochAndTxnMetadata epochAndMetadata = (CoordinatorEpochAndTxnMetadata)((Some)x0$1).value();
            int coordinatorEpoch = epochAndMetadata.coordinatorEpoch();
            TransactionMetadata txnMetadata = epochAndMetadata.transactionMetadata();
            left = (Either)txnMetadata.inLock((Function0 & Serializable & scala.Serializable)() -> {
                block8: {
                    block7: {
                        if (txnMetadata.producerId() != producerId$1) {
                            return package$.MODULE$.Left().apply((Object)Errors.INVALID_PRODUCER_ID_MAPPING);
                        }
                        if (txnMetadata.producerEpoch() != producerEpoch$1) {
                            return package$.MODULE$.Left().apply((Object)Errors.INVALID_PRODUCER_EPOCH);
                        }
                        if (txnMetadata.pendingTransitionInProgress()) {
                            return package$.MODULE$.Left().apply((Object)Errors.CONCURRENT_TRANSACTIONS);
                        }
                        TransactionState transactionState = txnMetadata.state();
                        PrepareCommit$ prepareCommit$ = PrepareCommit$.MODULE$;
                        if (!(transactionState == null ? prepareCommit$ != null : !transactionState.equals(prepareCommit$))) break block7;
                        TransactionState transactionState2 = txnMetadata.state();
                        PrepareAbort$ prepareAbort$ = PrepareAbort$.MODULE$;
                        if (transactionState2 != null ? !transactionState2.equals(prepareAbort$) : prepareAbort$ != null) break block8;
                    }
                    return package$.MODULE$.Left().apply((Object)Errors.CONCURRENT_TRANSACTIONS);
                }
                TransactionState transactionState = txnMetadata.state();
                Ongoing$ ongoing$ = Ongoing$.MODULE$;
                if (!(transactionState != null ? !transactionState.equals(ongoing$) : ongoing$ != null) && partitions$1.subsetOf(txnMetadata.topicPartitions())) {
                    return package$.MODULE$.Left().apply((Object)Errors.NONE);
                }
                return package$.MODULE$.Right().apply((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)coordinatorEpoch), (Object)txnMetadata.prepareAddPartitions((scala.collection.immutable.Set<TopicPartition>)partitions$1.toSet(), $this.time.milliseconds())));
            });
        } else {
            throw new MatchError((Object)x0$1);
        }
        return left;
    }

    public static final /* synthetic */ Either $anonfun$handleEndTransaction$1(TransactionCoordinator $this, long producerId$2, short producerEpoch$2, TransactionResult txnMarkerResult$1, String transactionalId$4, Option x0$1) {
        Left left;
        if (None$.MODULE$.equals(x0$1)) {
            left = package$.MODULE$.Left().apply((Object)Errors.INVALID_PRODUCER_ID_MAPPING);
        } else if (x0$1 instanceof Some) {
            CoordinatorEpochAndTxnMetadata epochAndTxnMetadata = (CoordinatorEpochAndTxnMetadata)((Some)x0$1).value();
            TransactionMetadata txnMetadata = epochAndTxnMetadata.transactionMetadata();
            int coordinatorEpoch = epochAndTxnMetadata.coordinatorEpoch();
            left = (Either)txnMetadata.inLock((Function0 & Serializable & scala.Serializable)() -> {
                Right right;
                TransactionState transactionState;
                if (txnMetadata.producerId() != producerId$2) {
                    return package$.MODULE$.Left().apply((Object)Errors.INVALID_PRODUCER_ID_MAPPING);
                }
                if (producerEpoch$2 < txnMetadata.producerEpoch()) {
                    return package$.MODULE$.Left().apply((Object)Errors.INVALID_PRODUCER_EPOCH);
                }
                if (txnMetadata.pendingTransitionInProgress()) {
                    Object object = txnMetadata.pendingState().get();
                    PrepareEpochFence$ prepareEpochFence$ = PrepareEpochFence$.MODULE$;
                    if (object == null ? prepareEpochFence$ != null : !object.equals(prepareEpochFence$)) {
                        return package$.MODULE$.Left().apply((Object)Errors.CONCURRENT_TRANSACTIONS);
                    }
                }
                if (Ongoing$.MODULE$.equals(transactionState = txnMetadata.state())) {
                    Product nextState;
                    TransactionResult transactionResult = txnMarkerResult$1;
                    TransactionResult transactionResult2 = TransactionResult.COMMIT;
                    Product product = nextState = !(transactionResult != null ? !transactionResult.equals(transactionResult2) : transactionResult2 != null) ? PrepareCommit$.MODULE$ : PrepareAbort$.MODULE$;
                    PrepareAbort$ prepareAbort$ = PrepareAbort$.MODULE$;
                    if (!(product != null ? !product.equals(prepareAbort$) : prepareAbort$ != null) && txnMetadata.pendingState().contains((Object)PrepareEpochFence$.MODULE$)) {
                        txnMetadata.pendingState_$eq((Option<TransactionState>)None$.MODULE$);
                        txnMetadata.lastProducerEpoch_$eq(txnMetadata.producerEpoch());
                        txnMetadata.producerEpoch_$eq(producerEpoch$2);
                    }
                    right = package$.MODULE$.Right().apply((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)coordinatorEpoch), (Object)txnMetadata.prepareAbortOrCommit((TransactionState)nextState, $this.time.milliseconds())));
                } else if (CompleteCommit$.MODULE$.equals(transactionState)) {
                    TransactionResult transactionResult = txnMarkerResult$1;
                    TransactionResult transactionResult3 = TransactionResult.COMMIT;
                    right = !(transactionResult != null ? !transactionResult.equals(transactionResult3) : transactionResult3 != null) ? package$.MODULE$.Left().apply((Object)Errors.NONE) : $this.logInvalidStateTransitionAndReturnError(transactionalId$4, txnMetadata.state(), txnMarkerResult$1);
                } else if (CompleteAbort$.MODULE$.equals(transactionState)) {
                    TransactionResult transactionResult = txnMarkerResult$1;
                    TransactionResult transactionResult4 = TransactionResult.ABORT;
                    right = !(transactionResult != null ? !transactionResult.equals(transactionResult4) : transactionResult4 != null) ? package$.MODULE$.Left().apply((Object)Errors.NONE) : $this.logInvalidStateTransitionAndReturnError(transactionalId$4, txnMetadata.state(), txnMarkerResult$1);
                } else if (PrepareCommit$.MODULE$.equals(transactionState)) {
                    TransactionResult transactionResult = txnMarkerResult$1;
                    TransactionResult transactionResult5 = TransactionResult.COMMIT;
                    right = !(transactionResult != null ? !transactionResult.equals(transactionResult5) : transactionResult5 != null) ? package$.MODULE$.Left().apply((Object)Errors.CONCURRENT_TRANSACTIONS) : $this.logInvalidStateTransitionAndReturnError(transactionalId$4, txnMetadata.state(), txnMarkerResult$1);
                } else if (PrepareAbort$.MODULE$.equals(transactionState)) {
                    TransactionResult transactionResult = txnMarkerResult$1;
                    TransactionResult transactionResult6 = TransactionResult.ABORT;
                    right = !(transactionResult != null ? !transactionResult.equals(transactionResult6) : transactionResult6 != null) ? package$.MODULE$.Left().apply((Object)Errors.CONCURRENT_TRANSACTIONS) : $this.logInvalidStateTransitionAndReturnError(transactionalId$4, txnMetadata.state(), txnMarkerResult$1);
                } else if (Empty$.MODULE$.equals(transactionState)) {
                    right = $this.logInvalidStateTransitionAndReturnError(transactionalId$4, txnMetadata.state(), txnMarkerResult$1);
                } else {
                    boolean bl = Dead$.MODULE$.equals(transactionState) ? true : PrepareEpochFence$.MODULE$.equals(transactionState);
                    if (bl) {
                        String errorMsg = new StringBuilder(103).append("Found transactionalId ").append(transactionalId$4).append(" with state ").append(txnMetadata.state()).append(". ").append("This is illegal as we should never have transitioned to this state.").toString();
                        $this.fatal((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> errorMsg);
                        throw new IllegalStateException(errorMsg);
                    }
                    throw new MatchError((Object)transactionState);
                }
                return right;
            });
        } else {
            throw new MatchError((Object)x0$1);
        }
        return left;
    }

    public static final /* synthetic */ Either $anonfun$handleEndTransaction$5(TransactionCoordinator $this, String transactionalId$4, int coordinatorEpoch$4, long producerId$2, short producerEpoch$2, TransactionResult txnMarkerResult$1, Option x0$1) {
        Left left;
        if (None$.MODULE$.equals(x0$1)) {
            String errorMsg = new StringBuilder(118).append("The coordinator still owns the transaction partition for ").append(transactionalId$4).append(", but there is ").append("no metadata in the cache; this is not expected").toString();
            $this.fatal((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> errorMsg);
            throw new IllegalStateException(errorMsg);
        }
        if (x0$1 instanceof Some) {
            CoordinatorEpochAndTxnMetadata epochAndMetadata = (CoordinatorEpochAndTxnMetadata)((Some)x0$1).value();
            if (epochAndMetadata.coordinatorEpoch() == coordinatorEpoch$4) {
                TransactionMetadata txnMetadata = epochAndMetadata.transactionMetadata();
                left = (Either)txnMetadata.inLock((Function0 & Serializable & scala.Serializable)() -> {
                    Left<Errors, Nothing$> left;
                    if (txnMetadata.producerId() != producerId$2) {
                        return package$.MODULE$.Left().apply((Object)Errors.INVALID_PRODUCER_ID_MAPPING);
                    }
                    if (txnMetadata.producerEpoch() != producerEpoch$2) {
                        return package$.MODULE$.Left().apply((Object)Errors.INVALID_PRODUCER_EPOCH);
                    }
                    if (txnMetadata.pendingTransitionInProgress()) {
                        return package$.MODULE$.Left().apply((Object)Errors.CONCURRENT_TRANSACTIONS);
                    }
                    TransactionState transactionState = txnMetadata.state();
                    boolean bl = Empty$.MODULE$.equals(transactionState) ? true : (Ongoing$.MODULE$.equals(transactionState) ? true : (CompleteCommit$.MODULE$.equals(transactionState) ? true : CompleteAbort$.MODULE$.equals(transactionState)));
                    if (bl) {
                        left = $this.logInvalidStateTransitionAndReturnError(transactionalId$4, txnMetadata.state(), txnMarkerResult$1);
                    } else if (PrepareCommit$.MODULE$.equals(transactionState)) {
                        TransactionResult transactionResult = txnMarkerResult$1;
                        TransactionResult transactionResult2 = TransactionResult.COMMIT;
                        left = (transactionResult == null ? transactionResult2 != null : !transactionResult.equals(transactionResult2)) ? $this.logInvalidStateTransitionAndReturnError(transactionalId$4, txnMetadata.state(), txnMarkerResult$1) : package$.MODULE$.Right().apply((Object)new Tuple2((Object)txnMetadata, (Object)txnMetadata.prepareComplete($this.time.milliseconds())));
                    } else if (PrepareAbort$.MODULE$.equals(transactionState)) {
                        TransactionResult transactionResult = txnMarkerResult$1;
                        TransactionResult transactionResult3 = TransactionResult.ABORT;
                        left = (transactionResult == null ? transactionResult3 != null : !transactionResult.equals(transactionResult3)) ? $this.logInvalidStateTransitionAndReturnError(transactionalId$4, txnMetadata.state(), txnMarkerResult$1) : package$.MODULE$.Right().apply((Object)new Tuple2((Object)txnMetadata, (Object)txnMetadata.prepareComplete($this.time.milliseconds())));
                    } else {
                        boolean bl2 = Dead$.MODULE$.equals(transactionState) ? true : PrepareEpochFence$.MODULE$.equals(transactionState);
                        if (bl2) {
                            String errorMsg = new StringBuilder(103).append("Found transactionalId ").append(transactionalId$4).append(" with state ").append(txnMetadata.state()).append(". ").append("This is illegal as we should never have transitioned to this state.").toString();
                            $this.fatal((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> errorMsg);
                            throw new IllegalStateException(errorMsg);
                        }
                        throw new MatchError((Object)transactionState);
                    }
                    return left;
                });
            } else {
                $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(114).append("The transaction coordinator epoch has changed to ").append(epochAndMetadata.coordinatorEpoch()).append(" after ").append(txnMarkerResult$1).append(" was ").append("successfully appended to the log for ").append(transactionalId$4).append(" with old epoch ").append(coordinatorEpoch$4).toString());
                left = package$.MODULE$.Left().apply((Object)Errors.NOT_COORDINATOR);
            }
        } else {
            throw new MatchError((Object)x0$1);
        }
        Left left2 = left;
        return left2;
    }

    private final void sendTxnMarkersCallback$1(Errors error, String transactionalId$4, int coordinatorEpoch$4, long producerId$2, short producerEpoch$2, TransactionResult txnMarkerResult$1, Function1 responseCallback$2, TxnTransitMetadata newMetadata$2) {
        Errors errors = error;
        Errors errors2 = Errors.NONE;
        if (!(errors != null ? !errors.equals(errors2) : errors2 != null)) {
            Tuple2 tuple2;
            Either either;
            Either.RightProjection rightProjection = this.txnManager.getTransactionState(transactionalId$4).right();
            if (rightProjection == null) {
                throw null;
            }
            Either.RightProjection flatMap_this = rightProjection;
            Either either2 = flatMap_this.e();
            if (either2 instanceof Right) {
                Option option = (Option)((Right)either2).value();
                either = TransactionCoordinator.$anonfun$handleEndTransaction$5(this, transactionalId$4, coordinatorEpoch$4, producerId$2, producerEpoch$2, txnMarkerResult$1, option);
            } else {
                either = flatMap_this.e();
            }
            if (either instanceof Left) {
                Errors err = (Errors)((Left)either).value();
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(135).append("Aborting sending of transaction markers after appended ").append(txnMarkerResult).append(" to transaction log and returning ").append(sendTxnMarkersCallback$1_err).append(" error to client for ").append(transactionalId).append("'s EndTransaction request").toString());
                BoxedUnit cfr_ignored_0 = (BoxedUnit)responseCallback$2.apply((Object)err);
                return;
            }
            if (either instanceof Right && (tuple2 = (Tuple2)((Right)either).value()) != null) {
                TransactionMetadata txnMetadata = (TransactionMetadata)tuple2._1();
                TxnTransitMetadata newPreSendMetadata = (TxnTransitMetadata)tuple2._2();
                responseCallback$2.apply((Object)Errors.NONE);
                this.txnMarkerChannelManager.addTxnMarkersToSend(transactionalId$4, coordinatorEpoch$4, txnMarkerResult$1, txnMetadata, newPreSendMetadata);
                return;
            }
            throw new MatchError((Object)either);
        }
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(172).append("Aborting sending of transaction markers and returning ").append(error).append(" error to client for ").append(transactionalId).append("'s EndTransaction request of ").append(txnMarkerResult).append(", ").append("since appending ").append(newMetadata).append(" to transaction log with coordinator epoch ").append(coordinatorEpoch).append(" failed").toString());
        responseCallback$2.apply((Object)error);
    }

    public static final /* synthetic */ void $anonfun$handleEndTransaction$12(TransactionCoordinator $this, String transactionalId$4, int coordinatorEpoch$4, long producerId$2, short producerEpoch$2, TransactionResult txnMarkerResult$1, Function1 responseCallback$2, TxnTransitMetadata newMetadata$2, Errors error) {
        Errors errors = error;
        Errors errors2 = Errors.NONE;
        if (!(errors != null ? !errors.equals(errors2) : errors2 != null)) {
            Tuple2 tuple2;
            Either either;
            Either.RightProjection rightProjection = $this.txnManager.getTransactionState(transactionalId$4).right();
            if (rightProjection == null) {
                throw null;
            }
            Either.RightProjection sendTxnMarkersCallback$1_flatMap_this = rightProjection;
            Either either2 = sendTxnMarkersCallback$1_flatMap_this.e();
            if (either2 instanceof Right) {
                Option option = (Option)((Right)either2).value();
                either = TransactionCoordinator.$anonfun$handleEndTransaction$5($this, transactionalId$4, coordinatorEpoch$4, producerId$2, producerEpoch$2, txnMarkerResult$1, option);
            } else {
                either = sendTxnMarkersCallback$1_flatMap_this.e();
            }
            if (either instanceof Left) {
                Errors sendTxnMarkersCallback$1_err = (Errors)((Left)either).value();
                $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(135).append("Aborting sending of transaction markers after appended ").append(txnMarkerResult).append(" to transaction log and returning ").append(sendTxnMarkersCallback$1_err).append(" error to client for ").append(transactionalId).append("'s EndTransaction request").toString());
                BoxedUnit cfr_ignored_0 = (BoxedUnit)responseCallback$2.apply((Object)sendTxnMarkersCallback$1_err);
                return;
            }
            if (either instanceof Right && (tuple2 = (Tuple2)((Right)either).value()) != null) {
                TransactionMetadata sendTxnMarkersCallback$1_txnMetadata = (TransactionMetadata)tuple2._1();
                TxnTransitMetadata sendTxnMarkersCallback$1_newPreSendMetadata = (TxnTransitMetadata)tuple2._2();
                responseCallback$2.apply((Object)Errors.NONE);
                $this.txnMarkerChannelManager.addTxnMarkersToSend(transactionalId$4, coordinatorEpoch$4, txnMarkerResult$1, sendTxnMarkersCallback$1_txnMetadata, sendTxnMarkersCallback$1_newPreSendMetadata);
                return;
            }
            throw new MatchError((Object)either);
        }
        $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(172).append("Aborting sending of transaction markers and returning ").append(error).append(" error to client for ").append(transactionalId).append("'s EndTransaction request of ").append(txnMarkerResult).append(", ").append("since appending ").append(newMetadata).append(" to transaction log with coordinator epoch ").append(coordinatorEpoch).append(" failed").toString());
        responseCallback$2.apply((Object)error);
    }

    private final void onComplete$1(TransactionalIdAndProducerIdEpoch txnIdAndPidEpoch, Errors error) {
        if (Errors.NONE.equals(error)) {
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(77).append("Completed rollback of ongoing transaction for transactionalId ").append(txnIdAndPidEpoch.transactionalId()).append(" due to timeout").toString());
            return;
        }
        boolean bl = Errors.INVALID_PRODUCER_ID_MAPPING.equals(error) ? true : (Errors.INVALID_PRODUCER_EPOCH.equals(error) ? true : Errors.CONCURRENT_TRANSACTIONS.equals(error));
        if (bl) {
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(85).append("Rollback of ongoing transaction for transactionalId ").append(txnIdAndPidEpoch.transactionalId()).append(" ").append("has been cancelled due to error ").append(error).toString());
            return;
        }
        this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(73).append("Rollback of ongoing transaction for transactionalId ").append(txnIdAndPidEpoch.transactionalId()).append(" ").append("failed due to error ").append(error).toString());
    }

    public static final /* synthetic */ void $anonfun$abortTimedOutTransactions$5(TransactionCoordinator $this, TransactionalIdAndProducerIdEpoch txnIdAndPidEpoch$2, Option x0$1) {
        if (None$.MODULE$.equals(x0$1)) {
            $this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(75).append("Could not find transaction metadata when trying to timeout transaction for ").append(txnIdAndPidEpoch$2).toString());
            return;
        }
        if (x0$1 instanceof Some) {
            TransactionMetadata txnMetadata = ((CoordinatorEpochAndTxnMetadata)((Some)x0$1).value()).transactionMetadata();
            Option transitMetadataOpt = (Option)txnMetadata.inLock((Function0 & Serializable & scala.Serializable)() -> {
                if (txnMetadata.producerId() != txnIdAndPidEpoch$2.producerId()) {
                    $this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(101).append("Found incorrect producerId when expiring transactionalId: ").append(txnIdAndPidEpoch$2.transactionalId()).append(". ").append("Expected producerId: ").append(txnIdAndPidEpoch$2.producerId()).append(". Found producerId: ").append(txnMetadata.producerId()).toString());
                    return None$.MODULE$;
                }
                if (txnMetadata.pendingTransitionInProgress()) {
                    $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(82).append("Skipping abort of timed out transaction ").append(txnIdAndPidEpoch$2).append(" since there is a ").append("pending state transition").toString());
                    return None$.MODULE$;
                }
                return new Some((Object)txnMetadata.prepareFenceProducerEpoch());
            });
            if (transitMetadataOpt == null) {
                throw null;
            }
            if (!transitMetadataOpt.isEmpty()) {
                TxnTransitMetadata txnTransitMetadata = (TxnTransitMetadata)transitMetadataOpt.get();
                $this.handleEndTransaction(txnMetadata.transactionalId(), txnTransitMetadata.producerId(), txnTransitMetadata.producerEpoch(), TransactionResult.ABORT, (Function1<Errors, BoxedUnit>)(Function1 & Serializable & scala.Serializable)error -> {
                    $this.onComplete$1(txnIdAndPidEpoch$2, error);
                    return BoxedUnit.UNIT;
                });
                return;
            }
        } else {
            throw new MatchError((Object)x0$1);
        }
    }

    public static final /* synthetic */ void $anonfun$abortTimedOutTransactions$4(TransactionCoordinator $this, TransactionalIdAndProducerIdEpoch txnIdAndPidEpoch) {
        Either.RightProjection rightProjection = $this.txnManager.getTransactionState(txnIdAndPidEpoch.transactionalId()).right();
        if (rightProjection == null) {
            throw null;
        }
        Either either = rightProjection.e();
        if (either instanceof Right) {
            Option option = (Option)((Right)either).value();
            TransactionCoordinator.$anonfun$abortTimedOutTransactions$5($this, txnIdAndPidEpoch, option);
            return;
        }
    }

    public TransactionCoordinator(int brokerId, TransactionConfig txnConfig, Scheduler scheduler, ProducerIdManager producerIdManager, TransactionStateManager txnManager, TransactionMarkerChannelManager txnMarkerChannelManager, Time time, LogContext logContext) {
        this.txnConfig = txnConfig;
        this.scheduler = scheduler;
        this.producerIdManager = producerIdManager;
        this.txnManager = txnManager;
        this.txnMarkerChannelManager = txnMarkerChannelManager;
        this.time = time;
        Logging.$init$(this);
        this.logIdent_$eq(logContext.logPrefix());
        this.isActive = new AtomicBoolean(false);
    }

    public static final /* synthetic */ Object $anonfun$prepareInitProducerIdTransit$1$adapted(TransactionMetadata txnMetadata$2, ProducerIdAndEpoch producerIdAndEpoch) {
        return BoxesRunTime.boxToBoolean((boolean)TransactionCoordinator.isValidProducerId$1(producerIdAndEpoch, txnMetadata$2));
    }

    public static final /* synthetic */ Object $anonfun$prepareInitProducerIdTransit$2$adapted(TransactionMetadata txnMetadata$2, ProducerIdAndEpoch x$1) {
        return BoxesRunTime.boxToBoolean((boolean)TransactionCoordinator.$anonfun$prepareInitProducerIdTransit$2(txnMetadata$2, x$1));
    }

    public static final /* synthetic */ Object $anonfun$prepareInitProducerIdTransit$3$adapted(ProducerIdAndEpoch x$2) {
        return BoxesRunTime.boxToShort((short)x$2.epoch);
    }

    public static final /* synthetic */ Object $anonfun$abortTimedOutTransactions$10$adapted(TransactionCoordinator $this, TransactionMetadata txnMetadata$6, TransactionalIdAndProducerIdEpoch txnIdAndPidEpoch$2, TxnTransitMetadata txnTransitMetadata) {
        $this.handleEndTransaction(txnMetadata$6.transactionalId(), txnTransitMetadata.producerId(), txnTransitMetadata.producerEpoch(), TransactionResult.ABORT, (Function1<Errors, BoxedUnit>)(Function1 & Serializable & scala.Serializable)error -> {
            $this.onComplete$1(txnIdAndPidEpoch$2, error);
            return BoxedUnit.UNIT;
        });
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$abortTimedOutTransactions$5$adapted(TransactionCoordinator $this, TransactionalIdAndProducerIdEpoch txnIdAndPidEpoch$2, Option x0$1) {
        TransactionCoordinator.$anonfun$abortTimedOutTransactions$5($this, txnIdAndPidEpoch$2, x0$1);
        return BoxedUnit.UNIT;
    }
}

