/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import kafka.log.Log;
import kafka.log.LogSegment;
import kafka.utils.Logging;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

public final class LogCleanerManager$
implements Logging {
    public static LogCleanerManager$ MODULE$;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    static {
        new LogCleanerManager$();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public boolean isCompactAndDelete(Log log) {
        return log.config().compact() && log.config().delete();
    }

    public long maxCompactionDelay(Log log, long firstDirtyOffset, long now) {
        long maxCompactionLagMs;
        long cleanUntilTime;
        Iterable<LogSegment> dirtyNonActiveSegments = log.nonActiveLogSegmentsFrom(firstDirtyOffset);
        Iterable firstBatchTimestamps = (Iterable)log.getFirstBatchTimestampForSegments(dirtyNonActiveSegments).filter((Function1)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)x$5 -> x$5 > 0L);
        long earliestDirtySegmentTimestamp = firstBatchTimestamps.nonEmpty() ? BoxesRunTime.unboxToLong((Object)firstBatchTimestamps.min((Ordering)Ordering.Long$.MODULE$)) : Long.MAX_VALUE;
        if (earliestDirtySegmentTimestamp < (cleanUntilTime = now - (maxCompactionLagMs = package$.MODULE$.max(Predef$.MODULE$.Long2long(log.config().maxCompactionLagMs()), 0L)))) {
            return cleanUntilTime - earliestDirtySegmentTimestamp;
        }
        return 0L;
    }

    public Tuple2<Object, Object> cleanableOffsets(Log log, Option<Object> lastCleanOffset, long now) {
        None$ none$;
        long l;
        long logStartOffset = log.logStartOffset();
        if (lastCleanOffset == null) {
            throw null;
        }
        Object object = lastCleanOffset.isEmpty() ? BoxesRunTime.boxToLong((long)logStartOffset) : lastCleanOffset.get();
        long checkpointDirtyOffset = BoxesRunTime.unboxToLong((Object)object);
        if (checkpointDirtyOffset < logStartOffset) {
            if (!this.isCompactAndDelete(log) && this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn(this.msgWithLogIdent(LogCleanerManager$.$anonfun$cleanableOffsets$2(log, logStartOffset, checkpointDirtyOffset)));
            }
            l = logStartOffset;
        } else if (checkpointDirtyOffset > log.logEndOffset()) {
            if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn(this.msgWithLogIdent(LogCleanerManager$.$anonfun$cleanableOffsets$3(log, checkpointDirtyOffset, logStartOffset)));
            }
            l = logStartOffset;
        } else {
            l = checkpointDirtyOffset;
        }
        long firstDirtyOffset = l;
        long minCompactionLagMs = package$.MODULE$.max(Predef$.MODULE$.Long2long(log.config().compactionLagMs()), 0L);
        Option[] optionArray = new Option[3];
        optionArray[0] = log.firstUnstableOffset();
        optionArray[1] = Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)log.activeSegment().baseOffset()));
        if (minCompactionLagMs > 0L) {
            Option option = log.nonActiveLogSegmentsFrom(firstDirtyOffset).find((Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToBoolean((boolean)LogCleanerManager$.$anonfun$cleanableOffsets$4(now, minCompactionLagMs, log, s)));
            if (option == null) {
                throw null;
            }
            Option map_this = option;
            Object object2 = map_this.isEmpty() ? None$.MODULE$ : new Some((Object)BoxesRunTime.boxToLong((long)((LogSegment)map_this.get()).baseOffset()));
            none$ = object2;
        } else {
            none$ = None$.MODULE$;
        }
        optionArray[2] = none$;
        long firstUncleanableDirtyOffset = BoxesRunTime.unboxToLong((Object)((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])optionArray)).flatten((Function1 & Serializable & scala.Serializable)xo -> Option$.MODULE$.option2Iterable(xo))).min((Ordering)Ordering.Long$.MODULE$));
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug(this.msgWithLogIdent(LogCleanerManager$.$anonfun$cleanableOffsets$8(log, lastCleanOffset, now, firstDirtyOffset, firstUncleanableDirtyOffset)));
        }
        return new Tuple2.mcJJ.sp(firstDirtyOffset, package$.MODULE$.max(firstDirtyOffset, firstUncleanableDirtyOffset));
    }

    public Tuple2<Object, Object> calculateCleanableBytes(Log log, long firstDirtyOffset, long uncleanableOffset) {
        Option option = log.nonActiveLogSegmentsFrom(uncleanableOffset).headOption();
        if (option == null) {
            throw null;
        }
        Option getOrElse_this = option;
        Object object = getOrElse_this.isEmpty() ? log.activeSegment() : getOrElse_this.get();
        long firstUncleanableOffset = ((LogSegment)object).baseOffset();
        long cleanableBytes = BoxesRunTime.unboxToLong((Object)((TraversableOnce)log.logSegments(firstDirtyOffset, package$.MODULE$.max(firstDirtyOffset, firstUncleanableOffset)).map((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToLong((long)x$7.size()), Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
        return new Tuple2.mcJJ.sp(firstUncleanableOffset, cleanableBytes);
    }

    public static final /* synthetic */ String $anonfun$cleanableOffsets$2(Log log$2, long logStartOffset$1, long checkpointDirtyOffset$1) {
        return new StringBuilder(96).append("Resetting first dirty offset of ").append(log$2.name()).append(" to log start offset ").append(logStartOffset$1).append(" ").append("since the checkpointed offset ").append(checkpointDirtyOffset$1).append(" is invalid.").toString();
    }

    public static final /* synthetic */ String $anonfun$cleanableOffsets$3(Log log$2, long checkpointDirtyOffset$1, long logStartOffset$1) {
        return new StringBuilder(130).append("The last checkpoint dirty offset for partition ").append(log$2.name()).append(" is ").append(checkpointDirtyOffset$1).append(", ").append("which is larger than the log end offset ").append(log$2.logEndOffset()).append(". Resetting to the log start offset ").append(logStartOffset$1).append(".").toString();
    }

    public static final /* synthetic */ String $anonfun$cleanableOffsets$5(Log log$2, LogSegment s$1, long now$3, long minCompactionLagMs$1, boolean isUncleanable$1) {
        return new StringBuilder(131).append("Checking if log segment may be cleaned: log='").append(log$2.name()).append("' segment.baseOffset=").append(s$1.baseOffset()).append(" ").append("segment.largestTimestamp=").append(s$1.largestTimestamp()).append("; now - compactionLag=").append(now$3 - minCompactionLagMs$1).append("; ").append("is uncleanable=").append(isUncleanable$1).toString();
    }

    public static final /* synthetic */ boolean $anonfun$cleanableOffsets$4(long now$3, long minCompactionLagMs$1, Log log$2, LogSegment s) {
        boolean isUncleanable = s.largestTimestamp() > now$3 - minCompactionLagMs$1;
        LogCleanerManager$ logCleanerManager$ = MODULE$;
        if (logCleanerManager$ == null) {
            throw null;
        }
        LogCleanerManager$ debug_this = logCleanerManager$;
        if (debug_this.logger().underlying().isDebugEnabled()) {
            debug_this.logger().underlying().debug(debug_this.msgWithLogIdent(LogCleanerManager$.$anonfun$cleanableOffsets$5(log$2, s, now$3, minCompactionLagMs$1, isUncleanable)));
        }
        return isUncleanable;
    }

    public static final /* synthetic */ String $anonfun$cleanableOffsets$8(Log log$2, Option lastCleanOffset$1, long now$3, long firstDirtyOffset$1, long firstUncleanableDirtyOffset$1) {
        return new StringBuilder(139).append("Finding range of cleanable offsets for log=").append(log$2.name()).append(". Last clean offset=").append(lastCleanOffset$1).append(" ").append("now=").append(now$3).append(" => firstDirtyOffset=").append(firstDirtyOffset$1).append(" firstUncleanableOffset=").append(firstUncleanableDirtyOffset$1).append(" ").append("activeSegment.baseOffset=").append(log$2.activeSegment().baseOffset()).toString();
    }

    private LogCleanerManager$() {
        MODULE$ = this;
        Logging.$init$(this);
    }

    public static final /* synthetic */ Object $anonfun$cleanableOffsets$6$adapted(LogSegment x$6) {
        return BoxesRunTime.boxToLong((long)x$6.baseOffset());
    }
}

