/*
 * Decompiled with CFR 0.152.
 */
package kafka.network;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.Timer;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import kafka.metrics.KafkaMetricsGroup;
import kafka.network.AbstractServerThread;
import kafka.network.ConnectionQuotas;
import kafka.network.Processor$;
import kafka.network.Processor$ConnectionId$;
import kafka.network.RequestChannel;
import kafka.network.SocketServer$;
import kafka.security.CredentialProvider;
import kafka.server.KafkaConfig;
import kafka.utils.CoreUtils$;
import kafka.utils.NotNothing$;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.Reconfigurable;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.memory.MemoryPool;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.Measurable;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.stats.CumulativeSum;
import org.apache.kafka.common.network.ChannelBuilder;
import org.apache.kafka.common.network.ChannelBuilders;
import org.apache.kafka.common.network.ClientInformation;
import org.apache.kafka.common.network.KafkaChannel;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.NetworkReceive;
import org.apache.kafka.common.network.Selector;
import org.apache.kafka.common.network.Send;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.requests.ApiVersionsRequest;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.security.authenticator.CredentialCache;
import org.apache.kafka.common.security.token.delegation.internals.DelegationTokenCache;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.LinkedHashMap$;
import scala.collection.mutable.Map$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.util.control.ControlThrowable;

@ScalaSignature(bytes="\u0006\u0001\u0011UuAB6m\u0011\u0003q\u0007O\u0002\u0004sY\"\u0005an\u001d\u0005\u0006u\u0006!\t\u0001 \u0005\b{\u0006\u0011\r\u0011\"\u0001\u007f\u0011\u001d\ty!\u0001Q\u0001\n}D\u0001\"!\u0005\u0002\u0005\u0004%\tA \u0005\b\u0003'\t\u0001\u0015!\u0003\u0000\u0011!\t)\"\u0001b\u0001\n\u0003q\bbBA\f\u0003\u0001\u0006Ia \u0005\n\u00033\t!\u0019!C\u0001\u00037A\u0001\"a\t\u0002A\u0003%\u0011Q\u0004\u0005\n\u0003K\t\u0011\u0013!C\u0001\u0003O1aA\u001d7\u0001]\u0006u\u0002BCA)\u0019\t\u0015\r\u0011\"\u0001\u0002\u001c!Q\u00111\u000b\u0007\u0003\u0002\u0003\u0006I!!\b\t\u0015\u0005UCB!A!\u0002\u0013\t9\u0006\u0003\u0006\u0002r1\u0011\t\u0011)A\u0005\u0003;A!\"a\u001d\r\u0005\u0003\u0005\u000b\u0011BA;\u0011)\tY\b\u0004B\u0001B\u0003%\u0011Q\u0010\u0005\u000b\u0003\u0007c!\u0011!Q\u0001\n\u0005\u0015\u0005BCAF\u0019\t\u0005\t\u0015!\u0003\u0002\u001e!Q\u0011Q\u0012\u0007\u0003\u0002\u0003\u0006I!a$\t\u0015\u0005eEB!A!\u0002\u0013\tY\n\u0003\u0006\u0002,2\u0011\t\u0011)A\u0005\u0003[C!\"a\u0013\r\u0005\u0003\u0005\u000b\u0011BA]\u0011)\t\u0019\r\u0004B\u0001B\u0003%\u0011Q\u0019\u0005\u000b\u0003\u001fd!\u0011!Q\u0001\n\u0005E\u0007BCAo\u0019\t\u0005\t\u0015!\u0003\u0002`\"Q\u0011Q\u001d\u0007\u0003\u0002\u0003\u0006I!!\b\t\ridA\u0011AAt\u000f\u001d\u0011I\u0001\u0004E\u0005\u0005\u00171qAa\u0004\r\u0011\u0013\u0011\t\u0002\u0003\u0004{?\u0011\u0005!\u0011\u0004\u0005\b\u00057yB\u0011\u0001B\u000f\u0011%\u0011\tmHA\u0001\n\u0003\u0013\u0019\rC\u0005\u0003P~\t\t\u0011\"!\u0003R\u001a9!q\u0002\u0007AY\n\u001d\u0002B\u0003B\u0018I\tU\r\u0011\"\u0001\u00032!Q!q\t\u0013\u0003\u0012\u0003\u0006IAa\r\t\u0015\t%CE!f\u0001\n\u0003\tY\u0002\u0003\u0006\u0003L\u0011\u0012\t\u0012)A\u0005\u0003;A!B!\u0014%\u0005+\u0007I\u0011\u0001B\u0019\u0011)\u0011y\u0005\nB\tB\u0003%!1\u0007\u0005\u000b\u0005#\"#Q3A\u0005\u0002\u0005m\u0001B\u0003B*I\tE\t\u0015!\u0003\u0002\u001e!Q!Q\u000b\u0013\u0003\u0016\u0004%\t!a\u0007\t\u0015\t]CE!E!\u0002\u0013\ti\u0002\u0003\u0004{I\u0011\u0005!\u0011\f\u0005\b\u0005K\"C\u0011\tB4\u0011%\u0011I\u0007JA\u0001\n\u0003\u0011Y\u0007C\u0005\u0003x\u0011\n\n\u0011\"\u0001\u0003z!I!Q\u0010\u0013\u0012\u0002\u0013\u0005\u0011q\u0005\u0005\n\u0005\u007f\"\u0013\u0013!C\u0001\u0005sB\u0011B!!%#\u0003%\t!a\n\t\u0013\t\rE%%A\u0005\u0002\u0005\u001d\u0002\u0002\u0003BCI\u0005\u0005I\u0011\t@\t\u0013\t\u001dE%!A\u0005\u0002\u0005m\u0001\"\u0003BEI\u0005\u0005I\u0011\u0001BF\u0011%\u00119\nJA\u0001\n\u0003\u0012I\nC\u0005\u0003(\u0012\n\t\u0011\"\u0001\u0003*\"I!1\u0017\u0013\u0002\u0002\u0013\u0005#Q\u0017\u0005\n\u0005o#\u0013\u0011!C!\u0005sC\u0011Ba8\r\u0005\u0004%IA!9\t\u0011\r\rA\u0002)A\u0005\u0005GD\u0011b!\u0002\r\u0005\u0004%Iaa\u0002\t\u0011\r\rB\u0002)A\u0005\u0007\u0013A\u0011b!\n\r\u0005\u0004%Iaa\n\t\u0011\r=B\u0002)A\u0005\u0007SA!b!\r\r\u0005\u0004%\tA\\B\u001a\u0011!\u0019Y\u0004\u0004Q\u0001\n\rU\u0002\"CB\u001f\u0019\t\u0007I\u0011AB \u0011!\u0019i\u0005\u0004Q\u0001\n\r\u0005\u0003\"CB(\u0019\t\u0007I\u0011BB)\u0011!\u0019Y\u0006\u0004Q\u0001\n\rM\u0003\"CB/\u0019\t\u0007I\u0011BB0\u0011!\u00199\u0007\u0004Q\u0001\n\r\u0005\u0004\u0002CB5\u0019\u0011EAna\u001b\t\u0013\r]D\u00021A\u0005\n\u0005m\u0001\"CB=\u0019\u0001\u0007I\u0011BB>\u0011!\u0019)\t\u0004Q!\n\u0005u\u0001bBBD\u0019\u0011\u00053\u0011\u0012\u0005\b\u0007\u0017cA\u0011BBG\u0011\u001d\u0019I\u000b\u0004C\u0005\u0007WCqa!.\r\t\u0013\u0019I\t\u0003\u0005\u000482!\t\u0002\\B]\u0011\u001d\u0019I\r\u0004C\u0005\u0007\u0017Dqa!;\r\t\u0013\u0019I\tC\u0004\u0004l2!Ia!#\t\u000f\r5H\u0002\"\u0003\u0004\n\"91q\u001e\u0007\u0005\n\rE\bbBB{\u0019\u0011%1\u0011\u0012\u0005\b\u0007odA\u0011BBE\u0011\u001d\u0019I\u0010\u0004C\u0005\u0007wDq\u0001\"\u0001\r\t\u0003!\u0019\u0001C\u0004\u0005(1!Ia!#\t\u000f\u0011%B\u0002\"\u0003\u0004\n\"A1q \u0007\u0005\u00121$Y\u0003\u0003\u0005\u0005>1!\t\u0001\u001cC \u0011\u001d!\u0019\u0005\u0004C\u0005\t\u000bB\u0001\u0002b\u0012\r\t\u0003a\u00171\u0004\u0005\t\t\u0013bA\u0011\u00017\u0002\u001c!AA1\n\u0007\u0005\u00021$i\u0005C\u0004\u0005Z1!I\u0001b\u0017\t\u000f\u0011\u0015E\u0002\"\u0003\u0005\b\"AA1\u0012\u0007\u0005\u00021$i\tC\u0004\u0005\u00122!\te!#\t\u000f\u0011ME\u0002\"\u0011\u0004\n\u0006I\u0001K]8dKN\u001cxN\u001d\u0006\u0003[:\fqA\\3uo>\u00148NC\u0001p\u0003\u0015Y\u0017MZ6b!\t\t\u0018!D\u0001m\u0005%\u0001&o\\2fgN|'o\u0005\u0002\u0002iB\u0011Q\u000f_\u0007\u0002m*\tq/A\u0003tG\u0006d\u0017-\u0003\u0002zm\n1\u0011I\\=SK\u001a\fa\u0001P5oSRt4\u0001\u0001\u000b\u0002a\u0006)\u0012\n\u001a7f!\u0016\u00148-\u001a8u\u001b\u0016$(/[2OC6,W#A@\u0011\t\u0005\u0005\u00111B\u0007\u0003\u0003\u0007QA!!\u0002\u0002\b\u0005!A.\u00198h\u0015\t\tI!\u0001\u0003kCZ\f\u0017\u0002BA\u0007\u0003\u0007\u0011aa\u0015;sS:<\u0017AF%eY\u0016\u0004VM]2f]RlU\r\u001e:jG:\u000bW.\u001a\u0011\u000239+Go^8sWB\u0013xnY3tg>\u0014X*\u001a;sS\u000e$\u0016mZ\u0001\u001b\u001d\u0016$xo\u001c:l!J|7-Z:t_JlU\r\u001e:jGR\u000bw\rI\u0001\u0012\u0019&\u001cH/\u001a8fe6+GO]5d)\u0006<\u0017A\u0005'jgR,g.\u001a:NKR\u0014\u0018n\u0019+bO\u0002\n1cQ8o]\u0016\u001cG/[8o#V,W/Z*ju\u0016,\"!!\b\u0011\u0007U\fy\"C\u0002\u0002\"Y\u00141!\u00138u\u0003Q\u0019uN\u001c8fGRLwN\\)vKV,7+\u001b>fA\u0005aB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIE*TCAA\u0015U\u0011\ti\"a\u000b,\u0005\u00055\u0002\u0003BA\u0018\u0003si!!!\r\u000b\t\u0005M\u0012QG\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a\u000ew\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003w\t\tDA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\u001cR\u0001DA \u0003\u000b\u00022!]A!\u0013\r\t\u0019\u0005\u001c\u0002\u0015\u0003\n\u001cHO]1diN+'O^3s)\"\u0014X-\u00193\u0011\t\u0005\u001d\u0013QJ\u0007\u0003\u0003\u0013R1!a\u0013o\u0003\u001diW\r\u001e:jGNLA!a\u0014\u0002J\t\t2*\u00194lC6+GO]5dg\u001e\u0013x.\u001e9\u0002\u0005%$\u0017aA5eA\u0005!A/[7f!\u0011\tI&!\u001c\u000e\u0005\u0005m#\u0002BA/\u0003?\nQ!\u001e;jYNTA!!\u0019\u0002d\u000511m\\7n_:T1a\\A3\u0015\u0011\t9'!\u001b\u0002\r\u0005\u0004\u0018m\u00195f\u0015\t\tY'A\u0002pe\u001eLA!a\u001c\u0002\\\t!A+[7f\u00039i\u0017\r\u001f*fcV,7\u000f^*ju\u0016\faB]3rk\u0016\u001cHo\u00115b]:,G\u000eE\u0002r\u0003oJ1!!\u001fm\u00059\u0011V-];fgR\u001c\u0005.\u00198oK2\f\u0001cY8o]\u0016\u001cG/[8o#V|G/Y:\u0011\u0007E\fy(C\u0002\u0002\u00022\u0014\u0001cQ8o]\u0016\u001cG/[8o#V|G/Y:\u0002)\r|gN\\3di&|gn]'bq&#G.Z't!\r)\u0018qQ\u0005\u0004\u0003\u00133(\u0001\u0002'p]\u001e\f1DZ1jY\u0016$\u0017)\u001e;iK:$\u0018nY1uS>tG)\u001a7bs6\u001b\u0018\u0001\u00047jgR,g.\u001a:OC6,\u0007\u0003BAI\u0003+k!!a%\u000b\u00075\fy&\u0003\u0003\u0002\u0018\u0006M%\u0001\u0004'jgR,g.\u001a:OC6,\u0017\u0001E:fGV\u0014\u0018\u000e^=Qe>$xnY8m!\u0011\ti*a*\u000e\u0005\u0005}%\u0002BAQ\u0003G\u000bA!Y;uQ*!\u0011QUA0\u0003!\u0019XmY;sSRL\u0018\u0002BAU\u0003?\u0013\u0001cU3dkJLG/\u001f)s_R|7m\u001c7\u0002\r\r|gNZ5h!\u0011\ty+!.\u000e\u0005\u0005E&bAAZ]\u000611/\u001a:wKJLA!a.\u00022\nY1*\u00194lC\u000e{gNZ5h!\u0011\tY,a0\u000e\u0005\u0005u&\u0002BA&\u0003?JA!!1\u0002>\n9Q*\u001a;sS\u000e\u001c\u0018AE2sK\u0012,g\u000e^5bYB\u0013xN^5eKJ\u0004B!a2\u0002L6\u0011\u0011\u0011\u001a\u0006\u0004\u0003Ks\u0017\u0002BAg\u0003\u0013\u0014!c\u0011:fI\u0016tG/[1m!J|g/\u001b3fe\u0006QQ.Z7pef\u0004vn\u001c7\u0011\t\u0005M\u0017\u0011\\\u0007\u0003\u0003+TA!a6\u0002`\u00051Q.Z7pefLA!a7\u0002V\nQQ*Z7pef\u0004vn\u001c7\u0002\u00151|wmQ8oi\u0016DH\u000f\u0005\u0003\u0002Z\u0005\u0005\u0018\u0002BAr\u00037\u0012!\u0002T8h\u0007>tG/\u001a=u\u0003M\u0019wN\u001c8fGRLwN\\)vKV,7+\u001b>f)\u0001\nI/a;\u0002n\u0006=\u0018\u0011_Az\u0003k\f90!?\u0002|\u0006u\u0018q B\u0001\u0005\u0007\u0011)Aa\u0002\u0011\u0005Ed\u0001bBA);\u0001\u0007\u0011Q\u0004\u0005\b\u0003+j\u0002\u0019AA,\u0011\u001d\t\t(\ba\u0001\u0003;Aq!a\u001d\u001e\u0001\u0004\t)\bC\u0004\u0002|u\u0001\r!! \t\u000f\u0005\rU\u00041\u0001\u0002\u0006\"9\u00111R\u000fA\u0002\u0005u\u0001bBAG;\u0001\u0007\u0011q\u0012\u0005\b\u00033k\u0002\u0019AAN\u0011\u001d\tY+\ba\u0001\u0003[Cq!a\u0013\u001e\u0001\u0004\tI\fC\u0004\u0002Dv\u0001\r!!2\t\u000f\u0005=W\u00041\u0001\u0002R\"9\u0011Q\\\u000fA\u0002\u0005}\u0007\"CAs;A\u0005\t\u0019AA\u000f\u00031\u0019uN\u001c8fGRLwN\\%e!\r\u0011iaH\u0007\u0002\u0019\ta1i\u001c8oK\u000e$\u0018n\u001c8JIN!q\u0004\u001eB\n!\r)(QC\u0005\u0004\u0005/1(\u0001D*fe&\fG.\u001b>bE2,GC\u0001B\u0006\u0003)1'o\\7TiJLgn\u001a\u000b\u0005\u0005?\u0011i\fE\u0003v\u0005C\u0011)#C\u0002\u0003$Y\u0014aa\u00149uS>t\u0007c\u0001B\u0007IM1A\u0005\u001eB\u0015\u0005'\u00012!\u001eB\u0016\u0013\r\u0011iC\u001e\u0002\b!J|G-^2u\u0003%awnY1m\u0011>\u001cH/\u0006\u0002\u00034A!!Q\u0007B\"\u001d\u0011\u00119Da\u0010\u0011\u0007\teb/\u0004\u0002\u0003<)\u0019!QH>\u0002\rq\u0012xn\u001c;?\u0013\r\u0011\tE^\u0001\u0007!J,G-\u001a4\n\t\u00055!Q\t\u0006\u0004\u0005\u00032\u0018A\u00037pG\u0006d\u0007j\\:uA\u0005IAn\\2bYB{'\u000f^\u0001\u000bY>\u001c\u0017\r\u001c)peR\u0004\u0013A\u0003:f[>$X\rS8ti\u0006Y!/Z7pi\u0016Dun\u001d;!\u0003)\u0011X-\\8uKB{'\u000f^\u0001\fe\u0016lw\u000e^3Q_J$\b%A\u0003j]\u0012,\u00070\u0001\u0004j]\u0012,\u0007\u0010\t\u000b\r\u0005K\u0011YF!\u0018\u0003`\t\u0005$1\r\u0005\b\u0005_y\u0003\u0019\u0001B\u001a\u0011\u001d\u0011Ie\fa\u0001\u0003;AqA!\u00140\u0001\u0004\u0011\u0019\u0004C\u0004\u0003R=\u0002\r!!\b\t\u000f\tUs\u00061\u0001\u0002\u001e\u0005AAo\\*ue&tw\r\u0006\u0002\u00034\u0005!1m\u001c9z)1\u0011)C!\u001c\u0003p\tE$1\u000fB;\u0011%\u0011y#\rI\u0001\u0002\u0004\u0011\u0019\u0004C\u0005\u0003JE\u0002\n\u00111\u0001\u0002\u001e!I!QJ\u0019\u0011\u0002\u0003\u0007!1\u0007\u0005\n\u0005#\n\u0004\u0013!a\u0001\u0003;A\u0011B!\u00162!\u0003\u0005\r!!\b\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011!1\u0010\u0016\u0005\u0005g\tY#\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%g\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\"\u0014AD2paf$C-\u001a4bk2$H%N\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!!Q\u0012BJ!\r)(qR\u0005\u0004\u0005#3(aA!os\"I!QS\u001d\u0002\u0002\u0003\u0007\u0011QD\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\tm\u0005C\u0002BO\u0005G\u0013i)\u0004\u0002\u0003 *\u0019!\u0011\u0015<\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0003&\n}%\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$BAa+\u00032B\u0019QO!,\n\u0007\t=fOA\u0004C_>dW-\u00198\t\u0013\tU5(!AA\u0002\t5\u0015\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u0005\u0005u\u0011AB3rk\u0006d7\u000f\u0006\u0003\u0003,\nm\u0006\"\u0003BK{\u0005\u0005\t\u0019\u0001BG\u0011\u001d\u0011y,\ta\u0001\u0005g\t\u0011a]\u0001\u0006CB\u0004H.\u001f\u000b\r\u0005K\u0011)Ma2\u0003J\n-'Q\u001a\u0005\b\u0005_\u0011\u0003\u0019\u0001B\u001a\u0011\u001d\u0011IE\ta\u0001\u0003;AqA!\u0014#\u0001\u0004\u0011\u0019\u0004C\u0004\u0003R\t\u0002\r!!\b\t\u000f\tU#\u00051\u0001\u0002\u001e\u00059QO\\1qa2LH\u0003\u0002Bj\u00057\u0004R!\u001eB\u0011\u0005+\u0004R\"\u001eBl\u0005g\tiBa\r\u0002\u001e\u0005u\u0011b\u0001Bmm\n1A+\u001e9mKVB\u0011B!8$\u0003\u0003\u0005\rA!\n\u0002\u0007a$\u0003'\u0001\boK^\u001cuN\u001c8fGRLwN\\:\u0016\u0005\t\r\bC\u0002Bs\u0005_\u0014\u00190\u0004\u0002\u0003h*!!\u0011\u001eBv\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0005\u0005[\f9!\u0001\u0003vi&d\u0017\u0002\u0002By\u0005O\u0014!#\u0011:sCf\u0014En\\2lS:<\u0017+^3vKB!!Q\u001fB\u0000\u001b\t\u00119P\u0003\u0003\u0003z\nm\u0018\u0001C2iC:tW\r\\:\u000b\t\tu\u0018qA\u0001\u0004]&|\u0017\u0002BB\u0001\u0005o\u0014QbU8dW\u0016$8\t[1o]\u0016d\u0017a\u00048fo\u000e{gN\\3di&|gn\u001d\u0011\u0002#%tg\r\\5hQR\u0014Vm\u001d9p]N,7/\u0006\u0002\u0004\nAA11BB\t\u0005g\u0019)\"\u0004\u0002\u0004\u000e)!1q\u0002BP\u0003\u001diW\u000f^1cY\u0016LAaa\u0005\u0004\u000e\t\u0019Q*\u00199\u0011\t\r]1Q\u0004\b\u0004c\u000ee\u0011bAB\u000eY\u0006q!+Z9vKN$8\t[1o]\u0016d\u0017\u0002BB\u0010\u0007C\u0011\u0001BU3ta>t7/\u001a\u0006\u0004\u00077a\u0017AE5oM2Lw\r\u001b;SKN\u0004xN\\:fg\u0002\nQB]3ta>t7/Z)vKV,WCAB\u0015!\u0019\u0011)oa\u000b\u0004\u0016%!1Q\u0006Bt\u0005Ma\u0015N\\6fI\ncwnY6j]\u001e$U-];f\u00039\u0011Xm\u001d9p]N,\u0017+^3vK\u0002\n!\"\\3ue&\u001cG+Y4t+\t\u0019)\u0004\u0005\u0004\u00048\rerp`\u0007\u0003\u0005WLAaa\u0005\u0003l\u0006YQ.\u001a;sS\u000e$\u0016mZ:!\u0003u)\u0007\u0010]5sK\u0012\u001cuN\u001c8fGRLwN\\:LS2dW\rZ\"pk:$XCAB!!\u0011\u0019\u0019e!\u0013\u000e\u0005\r\u0015#\u0002BB$\u0003{\u000bQa\u001d;biNLAaa\u0013\u0004F\ti1)^7vY\u0006$\u0018N^3Tk6\fa$\u001a=qSJ,GmQ8o]\u0016\u001cG/[8og.KG\u000e\\3e\u0007>,h\u000e\u001e\u0011\u0002O\u0015D\b/\u001b:fI\u000e{gN\\3di&|gn]&jY2,GmQ8v]RlU\r\u001e:jG:\u000bW.Z\u000b\u0003\u0007'\u0002Ba!\u0016\u0004X5\u0011\u0011qL\u0005\u0005\u00073\nyF\u0001\u0006NKR\u0014\u0018n\u0019(b[\u0016\f\u0001&\u001a=qSJ,GmQ8o]\u0016\u001cG/[8og.KG\u000e\\3e\u0007>,h\u000e^'fiJL7MT1nK\u0002\n\u0001b]3mK\u000e$xN]\u000b\u0003\u0007C\u0002B!!%\u0004d%!1QMAJ\u0005!\u0019V\r\\3di>\u0014\u0018!C:fY\u0016\u001cGo\u001c:!\u00039\u0019'/Z1uKN+G.Z2u_J$Ba!\u0019\u0004n!91q\u000e'A\u0002\rE\u0014AD2iC:tW\r\u001c\"vS2$WM\u001d\t\u0005\u0003#\u001b\u0019(\u0003\u0003\u0004v\u0005M%AD\"iC:tW\r\u001c\"vS2$WM]\u0001\u0014]\u0016DHoQ8o]\u0016\u001cG/[8o\u0013:$W\r_\u0001\u0018]\u0016DHoQ8o]\u0016\u001cG/[8o\u0013:$W\r_0%KF$Ba! \u0004\u0004B\u0019Qoa \n\u0007\r\u0005eO\u0001\u0003V]&$\b\"\u0003BK\u001d\u0006\u0005\t\u0019AA\u000f\u0003QqW\r\u001f;D_:tWm\u0019;j_:Le\u000eZ3yA\u0005\u0019!/\u001e8\u0015\u0005\ru\u0014\u0001\u00059s_\u000e,7o]#yG\u0016\u0004H/[8o)\u0019\u0019iha$\u0004\u0014\"91\u0011S)A\u0002\tM\u0012\u0001D3se>\u0014X*Z:tC\u001e,\u0007bBBK#\u0002\u00071qS\u0001\ni\"\u0014xn^1cY\u0016\u0004Ba!'\u0004$:!11TBP\u001d\u0011\u0011Id!(\n\u0003]L1a!)w\u0003\u001d\u0001\u0018mY6bO\u0016LAa!*\u0004(\nIA\u000b\u001b:po\u0006\u0014G.\u001a\u0006\u0004\u0007C3\u0018a\u00069s_\u000e,7o]\"iC:tW\r\\#yG\u0016\u0004H/[8o)!\u0019ih!,\u00042\u000eM\u0006bBBX%\u0002\u0007!1G\u0001\nG\"\fgN\\3m\u0013\u0012Dqa!%S\u0001\u0004\u0011\u0019\u0004C\u0004\u0004\u0016J\u0003\raa&\u0002'A\u0014xnY3tg:+wOU3ta>t7/Z:\u0002\u0019M,g\u000e\u001a*fgB|gn]3\u0015\r\ru41XB`\u0011\u001d\u0019i\f\u0016a\u0001\u0007+\t\u0001B]3ta>t7/\u001a\u0005\b\u0007\u0003$\u0006\u0019ABb\u00031\u0011Xm\u001d9p]N,7+\u001a8e!\u0011\t\tj!2\n\t\r\u001d\u00171\u0013\u0002\u0005'\u0016tG-\u0001\to_^t\u0015M\\8t'V\u0004\b\u000f\\5feV\u00111Q\u001a\n\u0007\u0007\u001f\u001c\u0019n!7\u0007\r\rEW\u000bABg\u00051a$/\u001a4j]\u0016lWM\u001c;?!\u0011\t\ta!6\n\t\r]\u00171\u0001\u0002\u0007\u001f\nTWm\u0019;\u0011\r\rm7\u0011]Bs\u001b\t\u0019iN\u0003\u0003\u0004`\n-\u0018\u0001\u00034v]\u000e$\u0018n\u001c8\n\t\r\r8Q\u001c\u0002\t'V\u0004\b\u000f\\5feB!\u0011\u0011ABt\u0013\u0011\tI)a\u0001\u0002\tA|G\u000e\\\u0001\u0019aJ|7-Z:t\u0007>l\u0007\u000f\\3uK\u0012\u0014VmY3jm\u0016\u001c\u0018!\u00069s_\u000e,7o]\"p[BdW\r^3e'\u0016tGm]\u0001\u0015kB$\u0017\r^3SKF,Xm\u001d;NKR\u0014\u0018nY:\u0015\t\ru41\u001f\u0005\b\u0007{K\u0006\u0019AB\u000b\u0003M\u0001(o\\2fgN$\u0015n]2p]:,7\r^3e\u0003Y\u0019Gn\\:f\u000bb\u001cWm]:D_:tWm\u0019;j_:\u001c\u0018!B2m_N,G\u0003BB?\u0007{Dqaa@]\u0001\u0004\u0011\u0019$\u0001\u0007d_:tWm\u0019;j_:LE-\u0001\u0004bG\u000e,\u0007\u000f\u001e\u000b\t\u0005W#)\u0001\"\u0003\u0005\u000e!9AqA/A\u0002\tM\u0018!D:pG.,Go\u00115b]:,G\u000eC\u0004\u0005\fu\u0003\rAa+\u0002\u00115\f\u0017P\u00117pG.Dq\u0001b\u0004^\u0001\u0004!\t\"\u0001\rbG\u000e,\u0007\u000f^8s\u0013\u0012dW\rU3sG\u0016tG/T3uKJ\u0004B\u0001b\u0005\u0005$5\u0011AQ\u0003\u0006\u0005\t/!I\"\u0001\u0003d_J,'\u0002BA&\t7QA\u0001\"\b\u0005 \u00051\u00110Y7nKJT!\u0001\"\t\u0002\u0007\r|W.\u0003\u0003\u0005&\u0011U!!B'fi\u0016\u0014\u0018aF2p]\u001aLw-\u001e:f\u001d\u0016<8i\u001c8oK\u000e$\u0018n\u001c8t\u0003!\u0019Gn\\:f\u00032dG\u0003\u0002B\u001a\t[Aq\u0001b\fa\u0001\u0004!\t$\u0001\u0004t_\u000e\\W\r\u001e\t\u0005\tg!I$\u0004\u0002\u00056)!AqGA\u0004\u0003\rqW\r^\u0005\u0005\tw!)D\u0001\u0004T_\u000e\\W\r^\u0001\u0010K:\fX/Z;f%\u0016\u001c\bo\u001c8tKR!1Q\u0010C!\u0011\u001d\u0019i,\u0019a\u0001\u0007+\tq\u0002Z3rk\u0016,XMU3ta>t7/\u001a\u000b\u0003\u0007+\t\u0011C]3ta>t7/Z)vKV,7+\u001b>f\u0003UIgN\u001a7jO\"$(+Z:q_:\u001cXmQ8v]R\fAc\u001c9f]>\u00138\t\\8tS:<7\t[1o]\u0016dG\u0003\u0002C(\t/\u0002R!\u001eB\u0011\t#\u0002B!!%\u0005T%!AQKAJ\u00051Y\u0015MZ6b\u0007\"\fgN\\3m\u0011\u001d\u0019y0\u001aa\u0001\u0005g\ta\u0003[1oI2,7\t[1o]\u0016dW*\u001e;f\u000bZ,g\u000e\u001e\u000b\u0007\u0007{\"i\u0006b\u0018\t\u000f\r}h\r1\u0001\u00034!9A\u0011\r4A\u0002\u0011\r\u0014!B3wK:$\b\u0003\u0002C3\t\u007frA\u0001b\u001a\u0005|9!A\u0011\u000eC=\u001d\u0011!Y\u0007b\u001e\u000f\t\u00115DQ\u000f\b\u0005\t_\"\u0019H\u0004\u0003\u0003:\u0011E\u0014BAA6\u0013\u0011\t9'!\u001b\n\u0007=\f)'\u0003\u0003\u0002b\u0005\r\u0014bA7\u0002`%!AQPAJ\u00031Y\u0015MZ6b\u0007\"\fgN\\3m\u0013\u0011!\t\tb!\u0003!\rC\u0017M\u001c8fY6+H/Z#wK:$(\u0002\u0002C?\u0003'\u000b\u0001\u0003\u001e:z+:lW\u000f^3DQ\u0006tg.\u001a7\u0015\t\ruD\u0011\u0012\u0005\b\u0007\u007f<\u0007\u0019\u0001B\u001a\u0003\u001d\u0019\u0007.\u00198oK2$B\u0001b\u0014\u0005\u0010\"91q 5A\u0002\tM\u0012AB<bW\u0016,\b/\u0001\u0005tQV$Hm\\<o\u0001")
public class Processor
extends AbstractServerThread
implements KafkaMetricsGroup {
    private volatile Processor$ConnectionId$ ConnectionId$module;
    private final int id;
    public final Time kafka$network$Processor$$time;
    private final int maxRequestSize;
    private final RequestChannel requestChannel;
    private final ConnectionQuotas connectionQuotas;
    private final long connectionsMaxIdleMs;
    private final int failedAuthenticationDelayMs;
    private final ListenerName listenerName;
    private final SecurityProtocol securityProtocol;
    private final KafkaConfig config;
    private final Metrics metrics;
    private final MemoryPool memoryPool;
    private final LogContext logContext;
    private final int connectionQueueSize;
    private final ArrayBlockingQueue<SocketChannel> newConnections;
    private final scala.collection.mutable.Map<String, RequestChannel.Response> inflightResponses;
    private final LinkedBlockingDeque<RequestChannel.Response> responseQueue;
    private final java.util.Map<String, String> metricTags;
    private final CumulativeSum expiredConnectionsKilledCount;
    private final MetricName expiredConnectionsKilledCountMetricName;
    private final Selector selector;
    private int nextConnectionIndex;

    public static int $lessinit$greater$default$15() {
        return Processor$.MODULE$.$lessinit$greater$default$15();
    }

    public static int ConnectionQueueSize() {
        return Processor$.MODULE$.ConnectionQueueSize();
    }

    public static String ListenerMetricTag() {
        return Processor$.MODULE$.ListenerMetricTag();
    }

    public static String NetworkProcessorMetricTag() {
        return Processor$.MODULE$.NetworkProcessorMetricTag();
    }

    public static String IdlePercentMetricName() {
        return Processor$.MODULE$.IdlePercentMetricName();
    }

    @Override
    public com.yammer.metrics.core.MetricName metricName(String name, Map<String, String> tags) {
        return KafkaMetricsGroup.metricName$(this, name, tags);
    }

    @Override
    public com.yammer.metrics.core.MetricName explicitMetricName(String group, String typeName, String name, Map<String, String> tags) {
        return KafkaMetricsGroup.explicitMetricName$(this, group, typeName, name, tags);
    }

    @Override
    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup.newGauge$(this, name, metric, tags);
    }

    @Override
    public <T> Map<String, String> newGauge$default$3() {
        return KafkaMetricsGroup.newGauge$default$3$(this);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newMeter$(this, name, eventType, timeUnit, tags);
    }

    @Override
    public Map<String, String> newMeter$default$4() {
        return KafkaMetricsGroup.newMeter$default$4$(this);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup.newHistogram$(this, name, biased, tags);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup.newHistogram$default$2$(this);
    }

    @Override
    public Map<String, String> newHistogram$default$3() {
        return KafkaMetricsGroup.newHistogram$default$3$(this);
    }

    @Override
    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newTimer$(this, name, durationUnit, rateUnit, tags);
    }

    @Override
    public Map<String, String> newTimer$default$4() {
        return KafkaMetricsGroup.newTimer$default$4$(this);
    }

    @Override
    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup.removeMetric$(this, name, tags);
    }

    @Override
    public Map<String, String> removeMetric$default$2() {
        return KafkaMetricsGroup.removeMetric$default$2$(this);
    }

    private Processor$ConnectionId$ ConnectionId() {
        if (this.ConnectionId$module == null) {
            this.ConnectionId$lzycompute$1();
        }
        return this.ConnectionId$module;
    }

    public int id() {
        return this.id;
    }

    private ArrayBlockingQueue<SocketChannel> newConnections() {
        return this.newConnections;
    }

    private scala.collection.mutable.Map<String, RequestChannel.Response> inflightResponses() {
        return this.inflightResponses;
    }

    private LinkedBlockingDeque<RequestChannel.Response> responseQueue() {
        return this.responseQueue;
    }

    public java.util.Map<String, String> metricTags() {
        return this.metricTags;
    }

    public CumulativeSum expiredConnectionsKilledCount() {
        return this.expiredConnectionsKilledCount;
    }

    private MetricName expiredConnectionsKilledCountMetricName() {
        return this.expiredConnectionsKilledCountMetricName;
    }

    private Selector selector() {
        return this.selector;
    }

    public Selector createSelector(ChannelBuilder channelBuilder) {
        if (channelBuilder instanceof Reconfigurable) {
            this.config.addReconfigurable((Reconfigurable)channelBuilder);
        }
        return new Selector(this.maxRequestSize, this.connectionsMaxIdleMs, this.failedAuthenticationDelayMs, this.metrics, this.kafka$network$Processor$$time, "socket-server", this.metricTags(), false, true, channelBuilder, this.memoryPool, this.logContext);
    }

    private int nextConnectionIndex() {
        return this.nextConnectionIndex;
    }

    private void nextConnectionIndex_$eq(int x$1) {
        this.nextConnectionIndex = x$1;
    }

    @Override
    public void run() {
        this.startupComplete();
        try {
            while (this.isRunning()) {
                try {
                    this.configureNewConnections();
                    this.processNewResponses();
                    this.poll();
                    this.processCompletedReceives();
                    this.processCompletedSends();
                    this.processDisconnected();
                    this.closeExcessConnections();
                }
                catch (Throwable e) {
                    this.processException("Processor got uncaught exception.", e);
                }
            }
        }
        finally {
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(29).append("Closing selector - processor ").append(this.id()).toString());
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.closeAll(), this, Level.ERROR);
            this.shutdownComplete();
        }
    }

    private void processException(String errorMessage, Throwable throwable) {
        if (throwable instanceof ControlThrowable) {
            throw (Throwable)((ControlThrowable)throwable);
        }
        this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> errorMessage, (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> throwable);
    }

    private void processChannelException(String channelId, String errorMessage, Throwable throwable) {
        if (this.openOrClosingChannel(channelId).isDefined()) {
            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(36).append("Closing socket for ").append(channelId).append(" because of error").toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> throwable);
            this.close(channelId);
        }
        this.processException(errorMessage, throwable);
    }

    private void processNewResponses() {
        RequestChannel.Response currentResponse;
        while ((currentResponse = this.dequeueResponse()) != null) {
            String channelId = currentResponse.request().context().connectionId;
            try {
                if (currentResponse instanceof RequestChannel.NoOpResponse) {
                    RequestChannel.NoOpResponse noOpResponse = (RequestChannel.NoOpResponse)currentResponse;
                    this.updateRequestMetrics(noOpResponse);
                    this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(69).append("Socket server received empty response to send, registering for read: ").append(noOpResponse).toString());
                    this.handleChannelMuteEvent(channelId, KafkaChannel.ChannelMuteEvent.RESPONSE_SENT);
                    this.tryUnmuteChannel(channelId);
                    continue;
                }
                if (currentResponse instanceof RequestChannel.SendResponse) {
                    RequestChannel.SendResponse sendResponse = (RequestChannel.SendResponse)currentResponse;
                    this.sendResponse(sendResponse, sendResponse.responseSend());
                    continue;
                }
                if (currentResponse instanceof RequestChannel.CloseConnectionResponse) {
                    RequestChannel.CloseConnectionResponse closeConnectionResponse = (RequestChannel.CloseConnectionResponse)currentResponse;
                    this.updateRequestMetrics(closeConnectionResponse);
                    this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Closing socket connection actively according to the response code.");
                    this.close(channelId);
                    continue;
                }
                if (currentResponse instanceof RequestChannel.StartThrottlingResponse) {
                    this.handleChannelMuteEvent(channelId, KafkaChannel.ChannelMuteEvent.THROTTLE_STARTED);
                    continue;
                }
                if (currentResponse instanceof RequestChannel.EndThrottlingResponse) {
                    this.handleChannelMuteEvent(channelId, KafkaChannel.ChannelMuteEvent.THROTTLE_ENDED);
                    this.tryUnmuteChannel(channelId);
                    continue;
                }
                throw new IllegalArgumentException(new StringBuilder(23).append("Unknown response type: ").append(currentResponse.getClass()).toString());
            }
            catch (Throwable e) {
                this.processChannelException(channelId, new StringBuilder(40).append("Exception while processing response for ").append(channelId).toString(), e);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void sendResponse(RequestChannel.Response response, Send responseSend) {
        String connectionId = response.request().context().connectionId;
        this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(85).append("Socket server received response to send to ").append(connectionId).append(", registering for write and sending data: ").append(response).toString());
        if (this.channel(connectionId).isEmpty()) {
            this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(93).append("Attempting to send response via channel for which there is no open connection, connection id ").append(connectionId).toString());
            response.request().updateRequestMetrics(0L, response);
        }
        if (this.openOrClosingChannel(connectionId).isDefined()) {
            void $minus$greater$extension_$this;
            this.selector().send(responseSend);
            Object object = Predef$.MODULE$.ArrowAssoc((Object)connectionId);
            if (Predef.ArrowAssoc$.MODULE$ == null) {
                throw null;
            }
            this.inflightResponses().$plus$eq(new Tuple2((Object)$minus$greater$extension_$this, (Object)response));
        }
    }

    private Supplier<Long> nowNanosSupplier() {
        return new Supplier<Long>(this){
            private final /* synthetic */ Processor $outer;

            public Long get() {
                return Predef$.MODULE$.long2Long(this.$outer.kafka$network$Processor$$time.nanoseconds());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
    }

    private void poll() {
        int pollTimeout = this.newConnections().isEmpty() ? 300 : 0;
        try {
            this.selector().poll((long)pollTimeout);
            return;
        }
        catch (Throwable throwable) {
            boolean bl = throwable instanceof IllegalStateException ? true : throwable instanceof IOException;
            if (bl) {
                this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(22).append("Processor ").append(this.id()).append(" poll failed").toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> throwable);
                return;
            }
            throw throwable;
        }
    }

    private void processCompletedReceives() {
        ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(this.selector().completedReceives()).asScala()).foreach((Function1 & Serializable & scala.Serializable)receive -> {
            Processor.$anonfun$processCompletedReceives$1(this, receive);
            return BoxedUnit.UNIT;
        });
    }

    private void processCompletedSends() {
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.selector().completedSends()).asScala()).foreach((Function1 & Serializable & scala.Serializable)send -> {
            Processor.$anonfun$processCompletedSends$1(this, send);
            return BoxedUnit.UNIT;
        });
    }

    private void updateRequestMetrics(RequestChannel.Response response) {
        RequestChannel.Request request = response.request();
        Option<KafkaChannel> option = this.openOrClosingChannel(request.context().connectionId);
        if (option == null) {
            throw null;
        }
        Option<KafkaChannel> fold_this = option;
        long l = fold_this.isEmpty() ? Processor.$anonfun$updateRequestMetrics$1() : ((KafkaChannel)fold_this.get()).getAndResetNetworkThreadTimeNanos();
        request.updateRequestMetrics(l, response);
    }

    private void processDisconnected() {
        ((IterableLike)JavaConverters$.MODULE$.asScalaSetConverter(this.selector().disconnected().keySet()).asScala()).foreach((Function1 & Serializable & scala.Serializable)connectionId -> {
            Processor.$anonfun$processDisconnected$1(this, connectionId);
            return BoxedUnit.UNIT;
        });
    }

    private void closeExcessConnections() {
        KafkaChannel channel;
        if (this.connectionQuotas.maxConnectionsExceeded(this.listenerName) && (channel = this.selector().lowestPriorityChannel()) != null) {
            this.close(channel.id());
            return;
        }
    }

    private void close(String connectionId) {
        Option<KafkaChannel> option = this.openOrClosingChannel(connectionId);
        if (option == null) {
            throw null;
        }
        Option<KafkaChannel> foreach_this = option;
        if (!foreach_this.isEmpty()) {
            KafkaChannel kafkaChannel = (KafkaChannel)foreach_this.get();
            Processor.$anonfun$close$4(this, connectionId, kafkaChannel);
            return;
        }
    }

    public boolean accept(SocketChannel socketChannel, boolean mayBlock, Meter acceptorIdlePercentMeter) {
        boolean accepted;
        boolean bl;
        if (this.newConnections().offer(socketChannel)) {
            bl = true;
        } else if (mayBlock) {
            long startNs = this.kafka$network$Processor$$time.nanoseconds();
            this.newConnections().put(socketChannel);
            acceptorIdlePercentMeter.mark(this.kafka$network$Processor$$time.nanoseconds() - startNs);
            bl = true;
        } else {
            bl = accepted = false;
        }
        if (accepted) {
            this.wakeup();
        }
        return accepted;
    }

    private void configureNewConnections() {
        int connectionsProcessed = 0;
        while (connectionsProcessed < this.connectionQueueSize && !this.newConnections().isEmpty()) {
            SocketChannel channel = this.newConnections().poll();
            try {
                this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Processor ").append(this.id()).append(" listening to new connection from ").append(channel.socket().getRemoteSocketAddress()).toString());
                this.selector().register(this.connectionId(channel.socket()), channel);
                ++connectionsProcessed;
            }
            catch (Throwable e) {
                SocketAddress remoteAddress = channel.socket().getRemoteSocketAddress();
                this.close(this.listenerName, channel);
                this.processException(new StringBuilder(34).append("Processor ").append(this.id()).append(" closed connection from ").append(remoteAddress).toString(), e);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void closeAll() {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.selector().channels()).asScala()).foreach((Function1 & Serializable & scala.Serializable)channel -> {
            this.close(channel.id());
            return BoxedUnit.UNIT;
        });
        this.selector().close();
        Tuple2[] tuple2Array = new Tuple2[1];
        String string = ((Object)BoxesRunTime.boxToInteger((int)this.id())).toString();
        Object object = Predef$.MODULE$.ArrowAssoc((Object)Processor$.MODULE$.NetworkProcessorMetricTag());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        this.removeMetric(Processor$.MODULE$.IdlePercentMetricName(), (Map<String, String>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array))));
    }

    public String connectionId(Socket socket) {
        String localHost = socket.getLocalAddress().getHostAddress();
        int localPort = socket.getLocalPort();
        String remoteHost = socket.getInetAddress().getHostAddress();
        int remotePort = socket.getPort();
        String connId = new ConnectionId(this, localHost, localPort, remoteHost, remotePort, this.nextConnectionIndex()).toString();
        this.nextConnectionIndex_$eq(this.nextConnectionIndex() == Integer.MAX_VALUE ? 0 : this.nextConnectionIndex() + 1);
        return connId;
    }

    public void enqueueResponse(RequestChannel.Response response) {
        this.responseQueue().put(response);
        this.wakeup();
    }

    /*
     * WARNING - void declaration
     */
    private RequestChannel.Response dequeueResponse() {
        void var1_1;
        RequestChannel.Response response = this.responseQueue().poll();
        if (response != null) {
            response.request().responseDequeueTimeNanos_$eq(Time.SYSTEM.nanoseconds());
        }
        return var1_1;
    }

    public int responseQueueSize() {
        return this.responseQueue().size();
    }

    public int inflightResponseCount() {
        return this.inflightResponses().size();
    }

    public Option<KafkaChannel> openOrClosingChannel(String connectionId) {
        Option option = Option$.MODULE$.apply((Object)this.selector().channel(connectionId));
        if (option == null) {
            throw null;
        }
        Option orElse_this = option;
        Option option2 = orElse_this.isEmpty() ? Option$.MODULE$.apply((Object)this.selector().closingChannel(connectionId)) : orElse_this;
        return option2;
    }

    private void handleChannelMuteEvent(String connectionId, KafkaChannel.ChannelMuteEvent event) {
        Option<KafkaChannel> option = this.openOrClosingChannel(connectionId);
        if (option == null) {
            throw null;
        }
        Option<KafkaChannel> foreach_this = option;
        if (!foreach_this.isEmpty()) {
            KafkaChannel kafkaChannel = (KafkaChannel)foreach_this.get();
            kafkaChannel.handleChannelMuteEvent(event);
            return;
        }
    }

    private void tryUnmuteChannel(String connectionId) {
        Option<KafkaChannel> option = this.openOrClosingChannel(connectionId);
        if (option == null) {
            throw null;
        }
        Option<KafkaChannel> foreach_this = option;
        if (!foreach_this.isEmpty()) {
            KafkaChannel kafkaChannel = (KafkaChannel)foreach_this.get();
            Processor.$anonfun$tryUnmuteChannel$1(this, kafkaChannel);
            return;
        }
    }

    public Option<KafkaChannel> channel(String connectionId) {
        return Option$.MODULE$.apply((Object)this.selector().channel(connectionId));
    }

    @Override
    public void wakeup() {
        this.selector().wakeup();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void shutdown() {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        super.shutdown();
        Tuple2[] tuple2Array = new Tuple2[1];
        String string = ((Object)BoxesRunTime.boxToInteger((int)this.id())).toString();
        Object object = Predef$.MODULE$.ArrowAssoc((Object)"networkProcessor");
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        this.removeMetric("IdlePercent", (Map<String, String>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array))));
        this.metrics.removeMetric(this.expiredConnectionsKilledCountMetricName());
    }

    private final void ConnectionId$lzycompute$1() {
        synchronized (this) {
            if (this.ConnectionId$module == null) {
                this.ConnectionId$module = new Processor$ConnectionId$(this);
            }
            return;
        }
    }

    public static final /* synthetic */ double $anonfun$new$2() {
        return 0.0;
    }

    public static final /* synthetic */ double $anonfun$new$3(KafkaMetric m) {
        return Math.min(BoxesRunTime.unboxToDouble((Object)m.metricValue()), 1.0);
    }

    public final /* synthetic */ double kafka$network$Processor$$$anonfun$new$1() {
        Option option = Option$.MODULE$.apply((Object)this.metrics.metric(this.metrics.metricName("io-wait-ratio", SocketServer$.MODULE$.MetricsGroup(), this.metricTags())));
        if (option == null) {
            throw null;
        }
        Option fold_this = option;
        double d = fold_this.isEmpty() ? Processor.$anonfun$new$2() : Processor.$anonfun$new$3((KafkaMetric)fold_this.get());
        return d;
    }

    public static final /* synthetic */ void $anonfun$processCompletedReceives$1(Processor $this, NetworkReceive receive) {
        block9: {
            try {
                Option<KafkaChannel> option = $this.openOrClosingChannel(receive.source());
                if (option instanceof Some) {
                    KafkaChannel channel = (KafkaChannel)((Some)option).value();
                    RequestHeader header = RequestHeader.parse((ByteBuffer)receive.payload());
                    ApiKeys apiKeys = header.apiKey();
                    ApiKeys apiKeys2 = ApiKeys.SASL_HANDSHAKE;
                    if (!(apiKeys != null ? !apiKeys.equals(apiKeys2) : apiKeys2 != null) && channel.maybeBeginServerReauthentication(receive, $this.nowNanosSupplier())) {
                        $this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(25).append("Begin re-authentication: ").append(channel).toString());
                    } else {
                        long nowNanos = $this.kafka$network$Processor$$time.nanoseconds();
                        if (channel.serverAuthenticationSessionExpired(nowNanos)) {
                            $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(34).append("Disconnecting expired channel: ").append(channel).append(" : ").append(header).toString());
                            $this.close(channel.id());
                            $this.expiredConnectionsKilledCount().record(null, 1.0, 0L);
                        } else {
                            ApiVersionsRequest apiVersionsRequest;
                            String connectionId = receive.source();
                            RequestContext context = new RequestContext(header, connectionId, channel.socketAddress(), channel.principal(), $this.listenerName, $this.securityProtocol, channel.channelMetadataRegistry().clientInformation());
                            RequestChannel.Request req = new RequestChannel.Request($this.id(), context, nowNanos, $this.memoryPool, receive.payload(), $this.requestChannel.metrics());
                            ApiKeys apiKeys3 = header.apiKey();
                            ApiKeys apiKeys4 = ApiKeys.API_VERSIONS;
                            if (!(apiKeys3 != null ? !apiKeys3.equals(apiKeys4) : apiKeys4 != null) && (apiVersionsRequest = (ApiVersionsRequest)req.body(ClassTag$.MODULE$.apply(ApiVersionsRequest.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals()))).isValid()) {
                                channel.channelMetadataRegistry().registerClientInformation(new ClientInformation(apiVersionsRequest.data.clientSoftwareName(), apiVersionsRequest.data.clientSoftwareVersion()));
                            }
                            $this.requestChannel.sendRequest(req);
                            $this.selector().mute(connectionId);
                            $this.handleChannelMuteEvent(connectionId, KafkaChannel.ChannelMuteEvent.REQUEST_RECEIVED);
                        }
                    }
                    break block9;
                }
                if (None$.MODULE$.equals(option)) {
                    throw new IllegalStateException(new StringBuilder(66).append("Channel ").append(receive.source()).append(" removed from selector before processing completed receive").toString());
                }
                throw new MatchError(option);
            }
            catch (Throwable e) {
                $this.processChannelException(receive.source(), new StringBuilder(40).append("Exception while processing request from ").append(receive.source()).toString(), e);
            }
        }
    }

    public static final /* synthetic */ Nothing$ $anonfun$processCompletedSends$2(Send send$1) {
        throw new IllegalStateException(new StringBuilder(51).append("Send for ").append(send$1.destination()).append(" completed, but not in `inflightResponses`").toString());
    }

    public static final /* synthetic */ void $anonfun$processCompletedSends$3(Send send$1, Function1 onComplete) {
        onComplete.apply((Object)send$1);
    }

    public static final /* synthetic */ void $anonfun$processCompletedSends$1(Processor $this, Send send) {
        try {
            Option option = $this.inflightResponses().remove((Object)send.destination());
            if (option == null) {
                throw null;
            }
            Option getOrElse_this = option;
            if (getOrElse_this.isEmpty()) {
                throw Processor.$anonfun$processCompletedSends$2(send);
            }
            RequestChannel.Response response = (RequestChannel.Response)getOrElse_this.get();
            $this.updateRequestMetrics(response);
            Option<Function1<Send, BoxedUnit>> option2 = response.onComplete();
            if (option2 == null) {
                throw null;
            }
            Option<Function1<Send, BoxedUnit>> foreach_this = option2;
            if (!foreach_this.isEmpty()) {
                ((Function1)foreach_this.get()).apply((Object)send);
            }
            $this.handleChannelMuteEvent(send.destination(), KafkaChannel.ChannelMuteEvent.RESPONSE_SENT);
            $this.tryUnmuteChannel(send.destination());
            return;
        }
        catch (Throwable e) {
            $this.processChannelException(send.destination(), new StringBuilder(45).append("Exception while processing completed send to ").append(send.destination()).toString(), e);
            return;
        }
    }

    public static final /* synthetic */ long $anonfun$updateRequestMetrics$1() {
        return 0L;
    }

    public static final /* synthetic */ Nothing$ $anonfun$processDisconnected$2(String connectionId$2) {
        throw new IllegalStateException(new StringBuilder(36).append("connectionId has unexpected format: ").append(connectionId$2).toString());
    }

    public static final /* synthetic */ void $anonfun$processDisconnected$1(Processor $this, String connectionId) {
        try {
            Option<ConnectionId> option = $this.ConnectionId().fromString(connectionId);
            if (option == null) {
                throw null;
            }
            Option<ConnectionId> getOrElse_this = option;
            if (getOrElse_this.isEmpty()) {
                throw Processor.$anonfun$processDisconnected$2(connectionId);
            }
            String remoteHost = ((ConnectionId)getOrElse_this.get()).remoteHost();
            Option option2 = $this.inflightResponses().remove((Object)connectionId);
            if (option2 == null) {
                throw null;
            }
            Option foreach_this = option2;
            if (!foreach_this.isEmpty()) {
                RequestChannel.Response response = (RequestChannel.Response)foreach_this.get();
                $this.updateRequestMetrics(response);
            }
            $this.connectionQuotas.dec($this.listenerName, InetAddress.getByName(remoteHost));
            return;
        }
        catch (Throwable e) {
            $this.processException(new StringBuilder(44).append("Exception while processing disconnection of ").append(connectionId).toString(), e);
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$close$4(Processor $this, String connectionId$3, KafkaChannel channel) {
        $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(28).append("Closing selector connection ").append(connectionId$3).toString());
        InetAddress address = channel.socketAddress();
        if (address != null) {
            $this.connectionQuotas.dec($this.listenerName, address);
        }
        $this.selector().close(connectionId$3);
        Option option = $this.inflightResponses().remove((Object)connectionId$3);
        if (option == null) {
            throw null;
        }
        Option foreach_this = option;
        if (!foreach_this.isEmpty()) {
            RequestChannel.Response response = (RequestChannel.Response)foreach_this.get();
            $this.updateRequestMetrics(response);
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$tryUnmuteChannel$1(Processor $this, KafkaChannel c) {
        $this.selector().unmute(c.id());
    }

    /*
     * WARNING - void declaration
     */
    public Processor(int id, Time time, int maxRequestSize, RequestChannel requestChannel, ConnectionQuotas connectionQuotas, long connectionsMaxIdleMs, int failedAuthenticationDelayMs, ListenerName listenerName, SecurityProtocol securityProtocol, KafkaConfig config, Metrics metrics, CredentialProvider credentialProvider, MemoryPool memoryPool, LogContext logContext, int connectionQueueSize) {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        void $minus$greater$extension_y2;
        void $minus$greater$extension_$this2;
        void $minus$greater$extension_y3;
        void $minus$greater$extension_$this3;
        this.id = id;
        this.kafka$network$Processor$$time = time;
        this.maxRequestSize = maxRequestSize;
        this.requestChannel = requestChannel;
        this.connectionQuotas = connectionQuotas;
        this.connectionsMaxIdleMs = connectionsMaxIdleMs;
        this.failedAuthenticationDelayMs = failedAuthenticationDelayMs;
        this.listenerName = listenerName;
        this.securityProtocol = securityProtocol;
        this.config = config;
        this.metrics = metrics;
        this.memoryPool = memoryPool;
        this.logContext = logContext;
        this.connectionQueueSize = connectionQueueSize;
        super(connectionQuotas);
        KafkaMetricsGroup.$init$(this);
        this.newConnections = new ArrayBlockingQueue(connectionQueueSize);
        this.inflightResponses = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.responseQueue = new LinkedBlockingDeque();
        Tuple2[] tuple2Array = new Tuple2[2];
        String string = listenerName.value();
        Object object = Predef$.MODULE$.ArrowAssoc((Object)Processor$.MODULE$.ListenerMetricTag());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this3, (Object)$minus$greater$extension_y3);
        String string2 = ((Object)BoxesRunTime.boxToInteger((int)id)).toString();
        Object object2 = Predef$.MODULE$.ArrowAssoc((Object)Processor$.MODULE$.NetworkProcessorMetricTag());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[1] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y2);
        this.metricTags = (java.util.Map)JavaConverters$.MODULE$.mutableMapAsJavaMapConverter((scala.collection.mutable.Map)LinkedHashMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array))).asJava();
        Tuple2[] tuple2Array2 = new Tuple2[1];
        String string3 = ((Object)BoxesRunTime.boxToInteger((int)id)).toString();
        Object object3 = Predef$.MODULE$.ArrowAssoc((Object)Processor$.MODULE$.NetworkProcessorMetricTag());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array2[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        this.newGauge(Processor$.MODULE$.IdlePercentMetricName(), new Gauge<Object>(this){
            private final /* synthetic */ Processor $outer;

            public final double value() {
                return this.$outer.kafka$network$Processor$$$anonfun$new$1();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, (Map<String, String>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array2))));
        this.expiredConnectionsKilledCount = new CumulativeSum();
        this.expiredConnectionsKilledCountMetricName = metrics.metricName("expired-connections-killed-count", "socket-server-metrics", this.metricTags());
        metrics.addMetric(this.expiredConnectionsKilledCountMetricName(), (Measurable)this.expiredConnectionsKilledCount());
        this.selector = this.createSelector(ChannelBuilders.serverChannelBuilder((ListenerName)listenerName, (listenerName.equals(config.interBrokerListenerName()) ? 1 : 0) != 0, (SecurityProtocol)securityProtocol, (AbstractConfig)config, (CredentialCache)credentialProvider.credentialCache(), (DelegationTokenCache)credentialProvider.tokenCache(), (Time)time, (LogContext)logContext));
        this.nextConnectionIndex = 0;
    }

    public static final /* synthetic */ Object $anonfun$updateRequestMetrics$2$adapted(KafkaChannel x$17) {
        return BoxesRunTime.boxToLong((long)x$17.getAndResetNetworkThreadTimeNanos());
    }

    public static final /* synthetic */ Object $anonfun$close$4$adapted(Processor $this, String connectionId$3, KafkaChannel channel) {
        Processor.$anonfun$close$4($this, connectionId$3, channel);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$handleChannelMuteEvent$1$adapted(KafkaChannel.ChannelMuteEvent event$1, KafkaChannel c) {
        c.handleChannelMuteEvent(event$1);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$tryUnmuteChannel$1$adapted(Processor $this, KafkaChannel c) {
        Processor.$anonfun$tryUnmuteChannel$1($this, c);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$new$3$adapted(KafkaMetric m) {
        return BoxesRunTime.boxToDouble((double)Processor.$anonfun$new$3(m));
    }

    public static final /* synthetic */ Object $anonfun$processCompletedSends$3$adapted(Send send$1, Function1 onComplete) {
        onComplete.apply((Object)send$1);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$processDisconnected$3$adapted(Processor $this, RequestChannel.Response response) {
        $this.updateRequestMetrics(response);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$close$6$adapted(Processor $this, RequestChannel.Response response) {
        $this.updateRequestMetrics(response);
        return BoxedUnit.UNIT;
    }

    public class ConnectionId
    implements Product,
    scala.Serializable {
        private final String localHost;
        private final int localPort;
        private final String remoteHost;
        private final int remotePort;
        private final int index;
        public final /* synthetic */ Processor $outer;

        public String localHost() {
            return this.localHost;
        }

        public int localPort() {
            return this.localPort;
        }

        public String remoteHost() {
            return this.remoteHost;
        }

        public int remotePort() {
            return this.remotePort;
        }

        public int index() {
            return this.index;
        }

        public String toString() {
            return new StringBuilder(4).append(this.localHost()).append(":").append(this.localPort()).append("-").append(this.remoteHost()).append(":").append(this.remotePort()).append("-").append(this.index()).toString();
        }

        public ConnectionId copy(String localHost, int localPort, String remoteHost, int remotePort, int index) {
            return new ConnectionId(this.kafka$network$Processor$ConnectionId$$$outer(), localHost, localPort, remoteHost, remotePort, index);
        }

        public String copy$default$1() {
            return this.localHost();
        }

        public int copy$default$2() {
            return this.localPort();
        }

        public String copy$default$3() {
            return this.remoteHost();
        }

        public int copy$default$4() {
            return this.remotePort();
        }

        public int copy$default$5() {
            return this.index();
        }

        public String productPrefix() {
            return "ConnectionId";
        }

        public int productArity() {
            return 5;
        }

        public Object productElement(int x$1) {
            switch (x$1) {
                case 0: {
                    return this.localHost();
                }
                case 1: {
                    return BoxesRunTime.boxToInteger((int)this.localPort());
                }
                case 2: {
                    return this.remoteHost();
                }
                case 3: {
                    return BoxesRunTime.boxToInteger((int)this.remotePort());
                }
                case 4: {
                    return BoxesRunTime.boxToInteger((int)this.index());
                }
            }
            throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof ConnectionId;
        }

        public int hashCode() {
            return Statics.finalizeHash((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)-889275714, (int)Statics.anyHash((Object)this.localHost())), (int)this.localPort()), (int)Statics.anyHash((Object)this.remoteHost())), (int)this.remotePort()), (int)this.index()), (int)5);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            if (!(x$1 instanceof ConnectionId)) return false;
            if (((ConnectionId)x$1).kafka$network$Processor$ConnectionId$$$outer() != this.kafka$network$Processor$ConnectionId$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            ConnectionId connectionId = (ConnectionId)x$1;
            String string = this.localHost();
            String string2 = connectionId.localHost();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (this.localPort() != connectionId.localPort()) return false;
            String string3 = this.remoteHost();
            String string4 = connectionId.remoteHost();
            if (string3 == null) {
                if (string4 != null) {
                    return false;
                }
            } else if (!string3.equals(string4)) return false;
            if (this.remotePort() != connectionId.remotePort()) return false;
            if (this.index() != connectionId.index()) return false;
            if (!connectionId.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ Processor kafka$network$Processor$ConnectionId$$$outer() {
            return this.$outer;
        }

        public ConnectionId(Processor $outer, String localHost, int localPort, String remoteHost, int remotePort, int index) {
            this.localHost = localHost;
            this.localPort = localPort;
            this.remoteHost = remoteHost;
            this.remotePort = remotePort;
            this.index = index;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }
}

