/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.Serializable;
import java.util.Optional;
import joptsimple.OptionException;
import kafka.admin.ConsumerGroupCommand;
import kafka.admin.ConsumerGroupCommand$;
import kafka.admin.ConsumerGroupCommandTest;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.ConsumerGroupListing;
import org.apache.kafka.common.ConsumerGroupState;
import org.apache.kafka.common.TopicPartition;
import org.junit.Assert;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Predef$;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ObjectRef;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001Y2Aa\u0002\u0005\u0001\u001b!)!\u0003\u0001C\u0001'!)Q\u0003\u0001C\u0001-!)a\u0005\u0001C\u0001-!)\u0001\u0007\u0001C\u0001-!)!\u0007\u0001C\u0001-!)A\u0007\u0001C\u0001-\t)B*[:u\u0007>t7/^7fe\u001e\u0013x.\u001e9UKN$(BA\u0005\u000b\u0003\u0015\tG-\\5o\u0015\u0005Y\u0011!B6bM.\f7\u0001A\n\u0003\u00019\u0001\"a\u0004\t\u000e\u0003!I!!\u0005\u0005\u00031\r{gn];nKJ<%o\\;q\u0007>lW.\u00198e)\u0016\u001cH/\u0001\u0004=S:LGO\u0010\u000b\u0002)A\u0011q\u0002A\u0001\u0017i\u0016\u001cH\u000fT5ti\u000e{gn];nKJ<%o\\;qgR\tq\u0003\u0005\u0002\u001975\t\u0011DC\u0001\u001b\u0003\u0015\u00198-\u00197b\u0013\ta\u0012D\u0001\u0003V]&$\bF\u0001\u0002\u001f!\tyB%D\u0001!\u0015\t\t#%A\u0003kk:LGOC\u0001$\u0003\ry'oZ\u0005\u0003K\u0001\u0012A\u0001V3ti\u0006IC/Z:u\u0019&\u001cHoV5uQVs'/Z2pO:L'0\u001a3OK^\u001cuN\\:v[\u0016\u0014x\n\u001d;j_:DCa\u0001\u0010)S\u0005AQ\r\u001f9fGR,GmI\u0001+!\tYc&D\u0001-\u0015\u0005i\u0013A\u00036paR\u001c\u0018.\u001c9mK&\u0011q\u0006\f\u0002\u0010\u001fB$\u0018n\u001c8Fq\u000e,\u0007\u000f^5p]\u0006\u0001C/Z:u\u0019&\u001cHoQ8ogVlWM]$s_V\u00048oV5uQN#\u0018\r^3tQ\t!a$A\u0011uKN$8i\u001c8tk6,'o\u0012:pkB\u001cF/\u0019;fg\u001a\u0013x.\\*ue&tw\r\u000b\u0002\u0006=\u0005!B/Z:u\u0019&\u001cHo\u0012:pkB\u001cu.\\7b]\u0012D#A\u0002\u0010")
public class ListConsumerGroupTest
extends ConsumerGroupCommandTest {
    /*
     * WARNING - void declaration
     */
    @Test
    public void testListConsumerGroups() {
        String simpleGroup = "simple-group";
        Iterable<TopicPartition> x$2 = this.addSimpleGroupExecutor$default$1();
        this.addSimpleGroupExecutor(x$2, simpleGroup);
        this.addConsumerGroupExecutor(1, this.addConsumerGroupExecutor$default$2(), this.addConsumerGroupExecutor$default$3(), this.addConsumerGroupExecutor$default$4(), this.addConsumerGroupExecutor$default$5(), this.addConsumerGroupExecutor$default$6());
        String[] cgcArgs = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--list"});
        ConsumerGroupCommand.ConsumerGroupService service = this.getConsumerGroupService(cgcArgs);
        Set expectedGroups = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.group(), simpleGroup}));
        ObjectRef foundGroups = ObjectRef.create((Object)Predef$.MODULE$.Set().empty());
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ListConsumerGroupTest.$anonfun$testListConsumerGroups$1(foundGroups, service, expectedGroups)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                throw Assertions$.MODULE$.fail(ListConsumerGroupTest.$anonfun$testListConsumerGroups$2(expectedGroups, foundGroups), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 842));
            }
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension((long)waitUntilTrue_waitTimeMs, (long)waitUntilTrue_pause));
        }
    }

    @Test(expected=OptionException.class)
    public void testListWithUnrecognizedNewConsumerOption() {
        String[] cgcArgs = (String[])((Object[])new String[]{"--new-consumer", "--bootstrap-server", this.brokerList(), "--list"});
        this.getConsumerGroupService(cgcArgs);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testListConsumerGroupsWithStates() {
        String simpleGroup = "simple-group";
        Iterable<TopicPartition> x$2 = this.addSimpleGroupExecutor$default$1();
        this.addSimpleGroupExecutor(x$2, simpleGroup);
        this.addConsumerGroupExecutor(1, this.addConsumerGroupExecutor$default$2(), this.addConsumerGroupExecutor$default$3(), this.addConsumerGroupExecutor$default$4(), this.addConsumerGroupExecutor$default$5(), this.addConsumerGroupExecutor$default$6());
        String[] cgcArgs = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--list", "--state"});
        ConsumerGroupCommand.ConsumerGroupService service = this.getConsumerGroupService(cgcArgs);
        Set expectedListing = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ConsumerGroupListing[]{new ConsumerGroupListing(simpleGroup, true, Optional.of(ConsumerGroupState.EMPTY)), new ConsumerGroupListing(this.group(), false, Optional.of(ConsumerGroupState.STABLE))}));
        ObjectRef foundListing = ObjectRef.create((Object)Predef$.MODULE$.Set().empty());
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ListConsumerGroupTest.$anonfun$testListConsumerGroupsWithStates$1(foundListing, service, expectedListing)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                throw Assertions$.MODULE$.fail(ListConsumerGroupTest.$anonfun$testListConsumerGroupsWithStates$2(expectedListing, foundListing), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 842));
            }
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension((long)waitUntilTrue_waitTimeMs, (long)waitUntilTrue_pause));
        }
        Set expectedListingStable = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ConsumerGroupListing[]{new ConsumerGroupListing(this.group(), false, Optional.of(ConsumerGroupState.STABLE))}));
        foundListing.elem = Predef$.MODULE$.Set().empty();
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!ListConsumerGroupTest.$anonfun$testListConsumerGroupsWithStates$3(foundListing, service, expectedListingStable)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                throw Assertions$.MODULE$.fail(ListConsumerGroupTest.$anonfun$testListConsumerGroupsWithStates$4(expectedListingStable, foundListing), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 842));
            }
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension((long)waitUntilTrue_waitTimeMs, (long)waitUntilTrue_pause));
        }
    }

    @Test
    public void testConsumerGroupStatesFromString() {
        Set result = ConsumerGroupCommand$.MODULE$.consumerGroupStatesFromString("Stable");
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ConsumerGroupState[]{ConsumerGroupState.STABLE})), (Object)result);
        result = ConsumerGroupCommand$.MODULE$.consumerGroupStatesFromString("Stable, PreparingRebalance");
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ConsumerGroupState[]{ConsumerGroupState.STABLE, ConsumerGroupState.PREPARING_REBALANCE})), (Object)result);
        result = ConsumerGroupCommand$.MODULE$.consumerGroupStatesFromString("Dead,CompletingRebalance,");
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ConsumerGroupState[]{ConsumerGroupState.DEAD, ConsumerGroupState.COMPLETING_REBALANCE})), (Object)result);
        Assertions$.MODULE$.assertThrows((Function0 & Serializable & scala.Serializable)() -> ConsumerGroupCommand$.MODULE$.consumerGroupStatesFromString("bad, wrong"), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("ListConsumerGroupTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 93));
        Assertions$.MODULE$.assertThrows((Function0 & Serializable & scala.Serializable)() -> ConsumerGroupCommand$.MODULE$.consumerGroupStatesFromString("stable"), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("ListConsumerGroupTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 97));
        Assertions$.MODULE$.assertThrows((Function0 & Serializable & scala.Serializable)() -> ConsumerGroupCommand$.MODULE$.consumerGroupStatesFromString("  bad, Stable"), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("ListConsumerGroupTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 101));
        Assertions$.MODULE$.assertThrows((Function0 & Serializable & scala.Serializable)() -> ConsumerGroupCommand$.MODULE$.consumerGroupStatesFromString("   ,   ,"), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("ListConsumerGroupTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 105));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testListGroupCommand() {
        String simpleGroup = "simple-group";
        Iterable<TopicPartition> x$2 = this.addSimpleGroupExecutor$default$1();
        this.addSimpleGroupExecutor(x$2, simpleGroup);
        this.addConsumerGroupExecutor(1, this.addConsumerGroupExecutor$default$2(), this.addConsumerGroupExecutor$default$3(), this.addConsumerGroupExecutor$default$4(), this.addConsumerGroupExecutor$default$5(), this.addConsumerGroupExecutor$default$6());
        ObjectRef out = ObjectRef.create((Object)"");
        ObjectRef cgcArgs = ObjectRef.create((Object)((String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--list"})));
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ListConsumerGroupTest.$anonfun$testListGroupCommand$1(this, out, cgcArgs, simpleGroup)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                throw Assertions$.MODULE$.fail(ListConsumerGroupTest.$anonfun$testListGroupCommand$3(this, simpleGroup, out), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 842));
            }
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension((long)waitUntilTrue_waitTimeMs, (long)waitUntilTrue_pause));
        }
        cgcArgs.elem = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--list", "--state"});
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!ListConsumerGroupTest.$anonfun$testListGroupCommand$4(this, out, cgcArgs, simpleGroup)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                throw Assertions$.MODULE$.fail(ListConsumerGroupTest.$anonfun$testListGroupCommand$6(this, simpleGroup, out), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 842));
            }
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension((long)waitUntilTrue_waitTimeMs, (long)waitUntilTrue_pause));
        }
        cgcArgs.elem = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--list", "--state", "Stable"});
        long l5 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l6 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!ListConsumerGroupTest.$anonfun$testListGroupCommand$7(this, out, cgcArgs)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs) {
                throw Assertions$.MODULE$.fail(ListConsumerGroupTest.$anonfun$testListGroupCommand$9(this, out), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 842));
            }
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension((long)waitUntilTrue_waitTimeMs, (long)waitUntilTrue_pause));
        }
    }

    public static final /* synthetic */ boolean $anonfun$testListConsumerGroups$1(ObjectRef foundGroups$1, ConsumerGroupCommand.ConsumerGroupService service$1, Set expectedGroups$1) {
        foundGroups$1.elem = service$1.listConsumerGroups().toSet();
        Set set = expectedGroups$1;
        Set set2 = (Set)foundGroups$1.elem;
        return !(set != null ? !set.equals(set2) : set2 != null);
    }

    public static final /* synthetic */ String $anonfun$testListConsumerGroups$2(Set expectedGroups$1, ObjectRef foundGroups$1) {
        return new StringBuilder(44).append("Expected --list to show groups ").append(expectedGroups$1).append(", but found ").append((Set)foundGroups$1.elem).append(".").toString();
    }

    public static final /* synthetic */ boolean $anonfun$testListConsumerGroupsWithStates$1(ObjectRef foundListing$1, ConsumerGroupCommand.ConsumerGroupService service$2, Set expectedListing$1) {
        foundListing$1.elem = service$2.listConsumerGroupsWithState(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ConsumerGroupState.values())).toSet()).toSet();
        Set set = expectedListing$1;
        Set set2 = (Set)foundListing$1.elem;
        return !(set != null ? !set.equals(set2) : set2 != null);
    }

    public static final /* synthetic */ String $anonfun$testListConsumerGroupsWithStates$2(Set expectedListing$1, ObjectRef foundListing$1) {
        return new StringBuilder(36).append("Expected to show groups ").append(expectedListing$1).append(", but found ").append((Set)foundListing$1.elem).toString();
    }

    public static final /* synthetic */ boolean $anonfun$testListConsumerGroupsWithStates$3(ObjectRef foundListing$1, ConsumerGroupCommand.ConsumerGroupService service$2, Set expectedListingStable$1) {
        foundListing$1.elem = service$2.listConsumerGroupsWithState((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ConsumerGroupState[]{ConsumerGroupState.STABLE}))).toSet();
        Set set = expectedListingStable$1;
        Set set2 = (Set)foundListing$1.elem;
        return !(set != null ? !set.equals(set2) : set2 != null);
    }

    public static final /* synthetic */ String $anonfun$testListConsumerGroupsWithStates$4(Set expectedListingStable$1, ObjectRef foundListing$1) {
        return new StringBuilder(36).append("Expected to show groups ").append(expectedListingStable$1).append(", but found ").append((Set)foundListing$1.elem).toString();
    }

    public static final /* synthetic */ boolean $anonfun$testListGroupCommand$1(ListConsumerGroupTest $this, ObjectRef out$1, ObjectRef cgcArgs$1, String simpleGroup$1) {
        out$1.elem = TestUtils$.MODULE$.grabConsoleOutput((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ConsumerGroupCommand$.MODULE$.main((String[])cgcArgs$1.elem));
        return !((String)out$1.elem).contains("STATE") && ((String)out$1.elem).contains(simpleGroup$1) && ((String)out$1.elem).contains($this.group());
    }

    public static final /* synthetic */ String $anonfun$testListGroupCommand$3(ListConsumerGroupTest $this, String simpleGroup$1, ObjectRef out$1) {
        return new StringBuilder(45).append("Expected to find ").append(simpleGroup$1).append(", ").append($this.group()).append(" and no header, but found ").append((String)out$1.elem).toString();
    }

    public static final /* synthetic */ boolean $anonfun$testListGroupCommand$4(ListConsumerGroupTest $this, ObjectRef out$1, ObjectRef cgcArgs$1, String simpleGroup$1) {
        out$1.elem = TestUtils$.MODULE$.grabConsoleOutput((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ConsumerGroupCommand$.MODULE$.main((String[])cgcArgs$1.elem));
        return ((String)out$1.elem).contains("STATE") && ((String)out$1.elem).contains(simpleGroup$1) && ((String)out$1.elem).contains($this.group());
    }

    public static final /* synthetic */ String $anonfun$testListGroupCommand$6(ListConsumerGroupTest $this, String simpleGroup$1, ObjectRef out$1) {
        return new StringBuilder(46).append("Expected to find ").append(simpleGroup$1).append(", ").append($this.group()).append(" and the header, but found ").append((String)out$1.elem).toString();
    }

    public static final /* synthetic */ boolean $anonfun$testListGroupCommand$7(ListConsumerGroupTest $this, ObjectRef out$1, ObjectRef cgcArgs$1) {
        out$1.elem = TestUtils$.MODULE$.grabConsoleOutput((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ConsumerGroupCommand$.MODULE$.main((String[])cgcArgs$1.elem));
        return ((String)out$1.elem).contains("STATE") && ((String)out$1.elem).contains($this.group()) && ((String)out$1.elem).contains("Stable");
    }

    public static final /* synthetic */ String $anonfun$testListGroupCommand$9(ListConsumerGroupTest $this, ObjectRef out$1) {
        return new StringBuilder(60).append("Expected to find ").append($this.group()).append(" in state Stable and the header, but found ").append((String)out$1.elem).toString();
    }
}

