/*
 * Decompiled with CFR 0.152.
 */
package kafka.network;

import com.yammer.metrics.core.Meter;
import java.io.File;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import kafka.metrics.KafkaMetricsGroup$;
import kafka.network.ConnectionQuotas;
import kafka.network.ConnectionQuotasTest$ListenerDesc$;
import kafka.network.Processor$;
import kafka.network.TooManyConnectionsException;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.RichLong;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\t\re\u0001B\u00193\u0001]BQA\u0010\u0001\u0005\u0002}BqA\u0011\u0001C\u0002\u0013%1\t\u0003\u0004R\u0001\u0001\u0006I\u0001\u0012\u0005\b%\u0002\u0011\r\u0011\"\u0003T\u0011\u001d\tY\b\u0001Q\u0001\nQC\u0011\"! \u0001\u0005\u0004%I!a \t\u0011\u0005\r\u0006\u0001)A\u0005\u0003\u0003C\u0001\"!*\u0001\u0005\u0004%I!\u001e\u0005\b\u0003O\u0003\u0001\u0015!\u0003w\u0011!\tI\u000b\u0001b\u0001\n\u0013)\bbBAV\u0001\u0001\u0006IA\u001e\u0004\u0005I\u0002\u0001U\r\u0003\u0005m\u0019\tU\r\u0011\"\u0001n\u0011!\u0019HB!E!\u0002\u0013q\u0007\u0002\u0003;\r\u0005+\u0007I\u0011A;\t\u0011qd!\u0011#Q\u0001\nYDQA\u0010\u0007\u0005\u0002uDq!!\u0001\r\t\u0003\n\u0019\u0001C\u0005\u0002\u001a1\t\t\u0011\"\u0001\u0002\u001c!I\u0011\u0011\u0005\u0007\u0012\u0002\u0013\u0005\u00111\u0005\u0005\n\u0003sa\u0011\u0013!C\u0001\u0003wA\u0011\"a\u0010\r\u0003\u0003%\t%!\u0011\t\u0013\u0005\rC\"!A\u0005\u0002\u0005\u0015\u0003\"CA'\u0019\u0005\u0005I\u0011AA(\u0011%\tY\u0006DA\u0001\n\u0003\ni\u0006C\u0005\u0002f1\t\t\u0011\"\u0001\u0002h!I\u0011\u0011\u000f\u0007\u0002\u0002\u0013\u0005\u00131\u000f\u0005\n\u0003kb\u0011\u0011!C!\u0003o:\u0011\"!,\u0001\u0003\u0003E\t!a,\u0007\u0011\u0011\u0004\u0011\u0011!E\u0001\u0003cCaA\u0010\u0010\u0005\u0002\u0005}\u0006\"CA\u0001=\u0005\u0005IQIAa\u0011%\t\u0019MHA\u0001\n\u0003\u000b)\rC\u0005\u0002Lz\t\t\u0011\"!\u0002N\"9\u0011q\u001c\u0001\u0005\u0002\u0005\u0005\bbBAx\u0001\u0011\u0005\u0011\u0011\u001f\u0005\b\u0005\u000f\u0001A\u0011AAy\u0011\u001d\u0011\t\u0002\u0001C\u0001\u0003cDqAa\u0007\u0001\t\u0003\t\t\u0010C\u0004\u0003 \u0001!\t!!=\t\u000f\t\r\u0002\u0001\"\u0001\u0002r\"9!q\u0005\u0001\u0005\u0002\u0005E\bb\u0002B\u0016\u0001\u0011\u0005\u0011\u0011\u001f\u0005\b\u0005_\u0001A\u0011\u0002B\u0019\u0011\u001d\u0011i\u0005\u0001C\u0005\u0005\u001fB\u0011B!\u001a\u0001#\u0003%IAa\u001a\t\u000f\t5\u0003\u0001\"\u0003\u0003l!9!\u0011\u0010\u0001\u0005\n\tm$\u0001F\"p]:,7\r^5p]F+x\u000e^1t)\u0016\u001cHO\u0003\u00024i\u00059a.\u001a;x_J\\'\"A\u001b\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001\u0001\u000f\t\u0003sqj\u0011A\u000f\u0006\u0002w\u0005)1oY1mC&\u0011QH\u000f\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005\u0001\u0005CA!\u0001\u001b\u0005\u0011\u0014\u0001\u0002;j[\u0016,\u0012\u0001\u0012\t\u0003\u000b>k\u0011A\u0012\u0006\u0003\u000f\"\u000bQ!\u001e;jYNT!!\u0013&\u0002\r\r|W.\\8o\u0015\t)4J\u0003\u0002M\u001b\u00061\u0011\r]1dQ\u0016T\u0011AT\u0001\u0004_J<\u0017B\u0001)G\u0005!iunY6US6,\u0017!\u0002;j[\u0016\u0004\u0013!\u00037jgR,g.\u001a:t+\u0005!\u0006\u0003B+Y5\nl\u0011A\u0016\u0006\u0003/j\n!bY8mY\u0016\u001cG/[8o\u0013\tIfKA\u0002NCB\u0004\"a\u00171\u000e\u0003qS!!\u00180\u0002\t1\fgn\u001a\u0006\u0002?\u0006!!.\u0019<b\u0013\t\tGL\u0001\u0004TiJLgn\u001a\t\u0003G2i\u0011\u0001\u0001\u0002\r\u0019&\u001cH/\u001a8fe\u0012+7oY\n\u0005\u0019a2\u0017\u000e\u0005\u0002:O&\u0011\u0001N\u000f\u0002\b!J|G-^2u!\tI$.\u0003\u0002lu\ta1+\u001a:jC2L'0\u00192mK\u0006aA.[:uK:,'OT1nKV\ta\u000e\u0005\u0002pc6\t\u0001O\u0003\u00024\u0011&\u0011!\u000f\u001d\u0002\r\u0019&\u001cH/\u001a8fe:\u000bW.Z\u0001\u000eY&\u001cH/\u001a8fe:\u000bW.\u001a\u0011\u0002\u0013\u0011,g-Y;mi&\u0003X#\u0001<\u0011\u0005]TX\"\u0001=\u000b\u0005et\u0016a\u00018fi&\u00111\u0010\u001f\u0002\f\u0013:,G/\u00113ee\u0016\u001c8/\u0001\u0006eK\u001a\fW\u000f\u001c;Ja\u0002\"2A\u0019@\u0000\u0011\u0015a\u0017\u00031\u0001o\u0011\u0015!\u0018\u00031\u0001w\u0003!!xn\u0015;sS:<GCAA\u0003!\u0011\t9!!\u0006\u000f\t\u0005%\u0011\u0011\u0003\t\u0004\u0003\u0017QTBAA\u0007\u0015\r\tyAN\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005M!(\u0001\u0004Qe\u0016$WMZ\u0005\u0004C\u0006]!bAA\nu\u0005!1m\u001c9z)\u0015\u0011\u0017QDA\u0010\u0011\u001da7\u0003%AA\u00029Dq\u0001^\n\u0011\u0002\u0003\u0007a/\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005\u0015\"f\u00018\u0002(-\u0012\u0011\u0011\u0006\t\u0005\u0003W\t)$\u0004\u0002\u0002.)!\u0011qFA\u0019\u0003%)hn\u00195fG.,GMC\u0002\u00024i\n!\"\u00198o_R\fG/[8o\u0013\u0011\t9$!\f\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u0005u\"f\u0001<\u0002(\u0005i\u0001O]8ek\u000e$\bK]3gSb,\u0012AW\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0003\u000f\u00022!OA%\u0013\r\tYE\u000f\u0002\u0004\u0013:$\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0003#\n9\u0006E\u0002:\u0003'J1!!\u0016;\u0005\r\te.\u001f\u0005\n\u00033B\u0012\u0011!a\u0001\u0003\u000f\n1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAA0!\u0015)\u0016\u0011MA)\u0013\r\t\u0019G\u0016\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u0002j\u0005=\u0004cA\u001d\u0002l%\u0019\u0011Q\u000e\u001e\u0003\u000f\t{w\u000e\\3b]\"I\u0011\u0011\f\u000e\u0002\u0002\u0003\u0007\u0011\u0011K\u0001\tQ\u0006\u001c\bnQ8eKR\u0011\u0011qI\u0001\u0007KF,\u0018\r\\:\u0015\t\u0005%\u0014\u0011\u0010\u0005\n\u00033b\u0012\u0011!a\u0001\u0003#\n!\u0002\\5ti\u0016tWM]:!\u0003Q\u0011Gn\\2lK\u0012\u0004VM]2f]RlU\r^3sgV\u0011\u0011\u0011\u0011\t\t\u0003\u0007\u000bI)!\u0002\u0002\f6\u0011\u0011Q\u0011\u0006\u0004\u0003\u000f3\u0016aB7vi\u0006\u0014G.Z\u0005\u00043\u0006\u0015\u0005\u0003BAG\u0003?k!!a$\u000b\t\u0005E\u00151S\u0001\u0005G>\u0014XM\u0003\u0003\u0002\u0016\u0006]\u0015aB7fiJL7m\u001d\u0006\u0005\u00033\u000bY*\u0001\u0004zC6lWM\u001d\u0006\u0003\u0003;\u000b1aY8n\u0013\u0011\t\t+a$\u0003\u000b5+G/\u001a:\u0002+\tdwnY6fIB+'oY3oi6+G/\u001a:tA\u0005I1N\\8x]\"{7\u000f^\u0001\u000bW:|wO\u001c%pgR\u0004\u0013aC;oW:|wO\u001c%pgR\fA\"\u001e8l]><h\u000eS8ti\u0002\nA\u0002T5ti\u0016tWM\u001d#fg\u000e\u0004\"a\u0019\u0010\u0014\ty\t\u0019,\u001b\t\b\u0003k\u000bYL\u001c<c\u001b\t\t9LC\u0002\u0002:j\nqA];oi&lW-\u0003\u0003\u0002>\u0006]&!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8oeQ\u0011\u0011q\u0016\u000b\u00025\u0006)\u0011\r\u001d9msR)!-a2\u0002J\")A.\ta\u0001]\")A/\ta\u0001m\u00069QO\\1qa2LH\u0003BAh\u00037\u0004R!OAi\u0003+L1!a5;\u0005\u0019y\u0005\u000f^5p]B)\u0011(a6om&\u0019\u0011\u0011\u001c\u001e\u0003\rQ+\b\u000f\\33\u0011!\tiNIA\u0001\u0002\u0004\u0011\u0017a\u0001=%a\u00051#M]8lKJ\u0004&o\u001c9t/&$\b\u000eR3gCVdGoQ8o]\u0016\u001cG/[8o\u0019&l\u0017\u000e^:\u0016\u0005\u0005\r\b\u0003BAs\u0003Wl!!a:\u000b\u0007\u0005%h,\u0001\u0003vi&d\u0017\u0002BAw\u0003O\u0014!\u0002\u0015:pa\u0016\u0014H/[3t\u0003\u0015\u0019X\r^+q)\t\t\u0019\u0010E\u0002:\u0003kL1!a>;\u0005\u0011)f.\u001b;)\u0007\u0011\nY\u0010\u0005\u0003\u0002~\n\rQBAA\u0000\u0015\r\u0011\t!T\u0001\u0006UVt\u0017\u000e^\u0005\u0005\u0005\u000b\tyP\u0001\u0004CK\u001a|'/Z\u0001\ti\u0016\f'\u000fR8x]\"\u001aQEa\u0003\u0011\t\u0005u(QB\u0005\u0005\u0005\u001f\tyPA\u0003BMR,'/A\fuKN$h)Y5m/\",gNT8MSN$XM\\3sg\"\u001aaE!\u0006\u0011\t\u0005u(qC\u0005\u0005\u00053\tyP\u0001\u0003UKN$\u0018!\b;fgR4\u0015-\u001b7EK\u000e\u0014X-\\3oi\u001a{'/\u00168l]><h.\u00139)\u0007\u001d\u0012)\"A\u0010uKN$hj\\\"p]:,7\r^5p]2KW.\u001b;t\u0005f$UMZ1vYRD3\u0001\u000bB\u000b\u0003]!Xm\u001d;NCb\u001cuN\u001c8fGRLwN\\:QKJL\u0005\u000fK\u0002*\u0005+\t\u0001\u0005^3ti6\u000b\u0007P\u0011:pW\u0016\u0014x+\u001b3f\u0007>tg.Z2uS>tG*[7ji\"\u001a!F!\u0006\u0002?Q,7\u000f^'bq2K7\u000f^3oKJ\u001cuN\u001c8fGRLwN\u001c'j[&$8\u000fK\u0002,\u0005+\tQ#\u00193e\u0019&\u001cH/\u001a8feN\fe\u000e\u001a,fe&4\u0017\u0010\u0006\u0004\u0002t\nM\"1\t\u0005\b\u0005ka\u0003\u0019\u0001B\u001c\u0003\u0019\u0019wN\u001c4jOB!!\u0011\bB \u001b\t\u0011YDC\u0002\u0003>Q\naa]3sm\u0016\u0014\u0018\u0002\u0002B!\u0005w\u00111bS1gW\u0006\u001cuN\u001c4jO\"9!Q\t\u0017A\u0002\t\u001d\u0013\u0001E2p]:,7\r^5p]F+x\u000e^1t!\r\t%\u0011J\u0005\u0004\u0005\u0017\u0012$\u0001E\"p]:,7\r^5p]F+x\u000e^1t\u0003E\t7mY3qi\u000e{gN\\3di&|gn\u001d\u000b\u000b\u0003g\u0014\tFa\u0015\u0003X\t\u0005\u0004b\u0002B#[\u0001\u0007!q\t\u0005\u0007\u0005+j\u0003\u0019\u00012\u0002\u00191L7\u000f^3oKJ$Um]2\t\u000f\teS\u00061\u0001\u0003\\\u0005qa.^7D_:tWm\u0019;j_:\u001c\bcA\u001d\u0003^%\u0019!q\f\u001e\u0003\t1{gn\u001a\u0005\n\u0005Gj\u0003\u0013!a\u0001\u00057\na\u0002^5nK&sG/\u001a:wC2l5/A\u000ebG\u000e,\u0007\u000f^\"p]:,7\r^5p]N$C-\u001a4bk2$H\u0005N\u000b\u0003\u0005SRCAa\u0017\u0002(Qa\u00111\u001fB7\u0005_\u0012\tH!\u001e\u0003x!9!QI\u0018A\u0002\t\u001d\u0003\"\u000270\u0001\u0004q\u0007B\u0002B:_\u0001\u0007a/A\u0004bI\u0012\u0014Xm]:\t\u000f\tes\u00061\u0001\u0003\\!9!1M\u0018A\u0002\tm\u0013!H1dG\u0016\u0004HoQ8o]\u0016\u001cG/[8og\u0006\u0013wN^3Ja2KW.\u001b;\u0015\u0011\u0005M(Q\u0010B@\u0005\u0003CqA!\u00121\u0001\u0004\u00119\u0005\u0003\u0004\u0003VA\u0002\rA\u0019\u0005\b\u00053\u0002\u0004\u0019\u0001B.\u0001")
public class ConnectionQuotasTest {
    private volatile ConnectionQuotasTest$ListenerDesc$ ListenerDesc$module;
    private final MockTime time = new MockTime();
    private final Map<String, ListenerDesc> listeners;
    private final scala.collection.mutable.Map<String, Meter> blockedPercentMeters;
    private final InetAddress knownHost;
    private final InetAddress unknownHost;

    public ConnectionQuotasTest$ListenerDesc$ ListenerDesc() {
        if (this.ListenerDesc$module == null) {
            this.ListenerDesc$lzycompute$1();
        }
        return this.ListenerDesc$module;
    }

    private MockTime time() {
        return this.time;
    }

    private Map<String, ListenerDesc> listeners() {
        return this.listeners;
    }

    private scala.collection.mutable.Map<String, Meter> blockedPercentMeters() {
        return this.blockedPercentMeters;
    }

    private InetAddress knownHost() {
        return this.knownHost;
    }

    private InetAddress unknownHost() {
        return this.unknownHost;
    }

    /*
     * WARNING - void declaration
     */
    public Properties brokerPropsWithDefaultConnectionLimits() {
        void var1_21;
        int x$1 = 0;
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        int x$3 = 0;
        boolean x$4 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$5 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$6 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$7 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$8 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$9 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$10 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$11 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$12 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$13 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$14 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$15 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$16 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        int x$17 = TestUtils$.MODULE$.createBrokerConfig$default$17();
        boolean x$18 = TestUtils$.MODULE$.createBrokerConfig$default$18();
        int x$19 = TestUtils$.MODULE$.createBrokerConfig$default$19();
        short x$20 = TestUtils$.MODULE$.createBrokerConfig$default$20();
        Properties props = TestUtils$.MODULE$.createBrokerConfig(x$1, x$2, x$4, x$5, x$3, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20);
        props.put(KafkaConfig$.MODULE$.ListenersProp(), "EXTERNAL://localhost:0,REPLICATION://localhost:1,ADMIN://localhost:2");
        props.put(KafkaConfig$.MODULE$.InterBrokerListenerNameProp(), "REPLICATION");
        props.put(KafkaConfig$.MODULE$.ListenerSecurityProtocolMapProp(), "EXTERNAL:PLAINTEXT,REPLICATION:PLAINTEXT,ADMIN:PLAINTEXT");
        return var1_21;
    }

    @Before
    public void setUp() {
        TestUtils$.MODULE$.clearYammerMetrics();
        this.listeners().keys().foreach((Function1 & Serializable & scala.Serializable)name -> {
            void $minus$greater$extension_$this;
            Tuple2[] tuple2Array = new Tuple2[1];
            Object object = Predef$.MODULE$.ArrowAssoc((Object)Processor$.MODULE$.ListenerMetricTag());
            if (Predef.ArrowAssoc$.MODULE$ == null) {
                throw null;
            }
            tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this, name);
            return this.blockedPercentMeters().put(name, (Object)KafkaMetricsGroup$.MODULE$.newMeter(new StringBuilder(14).append((String)name).append("BlockedPercent").toString(), "blocked time", TimeUnit.NANOSECONDS, (Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array))));
        });
    }

    @After
    public void tearDown() {
        TestUtils$.MODULE$.clearYammerMetrics();
        this.blockedPercentMeters().clear();
    }

    @Test
    public void testFailWhenNoListeners() {
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(this.brokerPropsWithDefaultConnectionLimits());
        ConnectionQuotas connectionQuotas = new ConnectionQuotas(config, (Time)this.time());
        ExecutorService executor = Executors.newSingleThreadExecutor();
        try {
            ListenerDesc listener = (ListenerDesc)this.listeners().apply((Object)"EXTERNAL");
            executor.submit(() -> Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> connectionQuotas.inc(listener.listenerName(), listener.defaultIp(), (Meter)this.blockedPercentMeters().apply((Object)"EXTERNAL")), ClassTag$.MODULE$.apply(RuntimeException.class), new Position("ConnectionQuotasTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 91))).get(5L, TimeUnit.SECONDS);
        }
        finally {
            executor.shutdownNow();
        }
    }

    @Test
    public void testFailDecrementForUnknownIp() {
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(this.brokerPropsWithDefaultConnectionLimits());
        ConnectionQuotas connectionQuotas = new ConnectionQuotas(config, (Time)this.time());
        this.addListenersAndVerify(config, connectionQuotas);
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> connectionQuotas.dec(((ListenerDesc)this.listeners().apply((Object)"EXTERNAL")).listenerName(), this.unknownHost()), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("ConnectionQuotasTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 107));
    }

    @Test
    public void testNoConnectionLimitsByDefault() {
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(this.brokerPropsWithDefaultConnectionLimits());
        ConnectionQuotas connectionQuotas = new ConnectionQuotas(config, (Time)this.time());
        this.addListenersAndVerify(config, connectionQuotas);
        ExecutorService executor = Executors.newFixedThreadPool(this.listeners().size());
        try {
            int numConnections = 10000;
            ((Iterable)this.listeners().values().map((Function1 & Serializable & scala.Serializable)listener -> executor.submit(() -> this.acceptConnections(connectionQuotas, (ListenerDesc)listener, numConnections, this.acceptConnections$default$4())), Iterable$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x$1 -> x$1.get(10L, TimeUnit.SECONDS));
            this.listeners().values().foreach((Function1 & Serializable & scala.Serializable)listener -> {
                ConnectionQuotasTest.$anonfun$testNoConnectionLimitsByDefault$4(numConnections, connectionQuotas, listener);
                return BoxedUnit.UNIT;
            });
        }
        finally {
            executor.shutdownNow();
        }
    }

    @Test
    public void testMaxConnectionsPerIp() {
        int maxConnectionsPerIp = 17;
        Properties props = this.brokerPropsWithDefaultConnectionLimits();
        props.put(KafkaConfig$.MODULE$.MaxConnectionsPerIpProp(), ((Object)BoxesRunTime.boxToInteger((int)maxConnectionsPerIp)).toString());
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        ConnectionQuotas connectionQuotas = new ConnectionQuotas(config, (Time)this.time());
        this.addListenersAndVerify(config, connectionQuotas);
        ExecutorService executor = Executors.newFixedThreadPool(this.listeners().size());
        try {
            ListenerDesc externalListener = (ListenerDesc)this.listeners().apply((Object)"EXTERNAL");
            executor.submit(() -> this.acceptConnections(connectionQuotas, externalListener, maxConnectionsPerIp, this.acceptConnections$default$4())).get(5L, TimeUnit.SECONDS);
            Assert.assertEquals((String)new StringBuilder(26).append("Number of connections on ").append(externalListener).append(":").toString(), (long)maxConnectionsPerIp, (long)connectionQuotas.get(externalListener.defaultIp()));
            executor.submit(() -> this.acceptConnectionsAboveIpLimit(connectionQuotas, externalListener, 2L)).get(5L, TimeUnit.SECONDS);
            Assert.assertEquals((String)new StringBuilder(26).append("Number of connections on ").append(externalListener).append(":").toString(), (long)(maxConnectionsPerIp + 2), (long)connectionQuotas.get(externalListener.defaultIp()));
            executor.submit(() -> this.acceptConnections(connectionQuotas, externalListener.listenerName(), this.knownHost(), maxConnectionsPerIp, 0L)).get(5L, TimeUnit.SECONDS);
            int n = 0;
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Range range = RichInt$.MODULE$.until$extension0(n, 4);
            if (range == null) {
                throw null;
            }
            Range foreach$mVc$sp_this = range;
            if (!foreach$mVc$sp_this.isEmpty()) {
                int foreach$mVc$sp_i = foreach$mVc$sp_this.start();
                while (true) {
                    connectionQuotas.dec(externalListener.listenerName(), externalListener.defaultIp());
                    if (foreach$mVc$sp_i == foreach$mVc$sp_this.scala$collection$immutable$Range$$lastElement()) break;
                    foreach$mVc$sp_i += foreach$mVc$sp_this.step();
                }
            }
            Assert.assertEquals((String)new StringBuilder(26).append("Number of connections on ").append(externalListener).append(":").toString(), (long)(maxConnectionsPerIp - 2), (long)connectionQuotas.get(externalListener.defaultIp()));
            executor.submit(() -> this.acceptConnections(connectionQuotas, externalListener, 2L, this.acceptConnections$default$4())).get(5L, TimeUnit.SECONDS);
            Assert.assertEquals((String)new StringBuilder(26).append("Number of connections on ").append(externalListener).append(":").toString(), (long)maxConnectionsPerIp, (long)connectionQuotas.get(externalListener.defaultIp()));
        }
        finally {
            executor.shutdownNow();
        }
    }

    @Test
    public void testMaxBrokerWideConnectionLimit() {
        int maxConnections = 800;
        Properties props = this.brokerPropsWithDefaultConnectionLimits();
        props.put(KafkaConfig$.MODULE$.MaxConnectionsProp(), ((Object)BoxesRunTime.boxToInteger((int)maxConnections)).toString());
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        ConnectionQuotas connectionQuotas = new ConnectionQuotas(config, (Time)this.time());
        this.addListenersAndVerify(config, connectionQuotas);
        ExecutorService executor = Executors.newFixedThreadPool(this.listeners().size());
        try {
            Assert.assertEquals((long)0L, (long)((Meter)this.blockedPercentMeters().apply((Object)"EXTERNAL")).count());
            executor.submit(() -> this.acceptConnections(connectionQuotas, (ListenerDesc)this.listeners().apply((Object)"EXTERNAL"), maxConnections, 1L)).get(5L, TimeUnit.SECONDS);
            Assert.assertEquals((String)new StringBuilder(26).append("Number of connections on ").append(this.listeners().apply((Object)"EXTERNAL")).append(":").toString(), (long)maxConnections, (long)connectionQuotas.get(((ListenerDesc)this.listeners().apply((Object)"EXTERNAL")).defaultIp()));
            Assert.assertEquals((long)0L, (long)((Meter)this.blockedPercentMeters().apply((Object)"EXTERNAL")).count());
            Assert.assertFalse((String)"Total number of connections is exactly the maximum.", (boolean)connectionQuotas.maxConnectionsExceeded(((ListenerDesc)this.listeners().apply((Object)"EXTERNAL")).listenerName()));
            Future<?> future = executor.submit(() -> this.acceptConnections(connectionQuotas, (ListenerDesc)this.listeners().apply((Object)"EXTERNAL"), 1L, this.acceptConnections$default$4()));
            Assertions$.MODULE$.intercept((Function0 & Serializable & scala.Serializable)() -> future.get(100L, TimeUnit.MILLISECONDS), ClassTag$.MODULE$.apply(TimeoutException.class), new Position("ConnectionQuotasTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 218));
            this.time().sleep(3L);
            connectionQuotas.dec(((ListenerDesc)this.listeners().apply((Object)"EXTERNAL")).listenerName(), ((ListenerDesc)this.listeners().apply((Object)"EXTERNAL")).defaultIp());
            future.get(1L, TimeUnit.SECONDS);
            Assert.assertEquals((String)new StringBuilder(26).append("Number of connections on ").append(this.listeners().apply((Object)"EXTERNAL")).append(":").toString(), (long)maxConnections, (long)connectionQuotas.get(((ListenerDesc)this.listeners().apply((Object)"EXTERNAL")).defaultIp()));
            Assert.assertTrue((String)"Expected BlockedPercentMeter metric to be recorded", (((Meter)this.blockedPercentMeters().apply((Object)"EXTERNAL")).count() > 0L ? 1 : 0) != 0);
            executor.submit(() -> this.acceptConnections(connectionQuotas, (ListenerDesc)this.listeners().apply((Object)"REPLICATION"), 1L, this.acceptConnections$default$4())).get(5L, TimeUnit.SECONDS);
            Assert.assertTrue((String)"Expected the number of connections to exceed the maximum.", (boolean)connectionQuotas.maxConnectionsExceeded(((ListenerDesc)this.listeners().apply((Object)"EXTERNAL")).listenerName()));
            Future<?> future1 = executor.submit(() -> this.acceptConnections(connectionQuotas, (ListenerDesc)this.listeners().apply((Object)"ADMIN"), 1L, this.acceptConnections$default$4()));
            Assertions$.MODULE$.intercept((Function0 & Serializable & scala.Serializable)() -> future1.get(1L, TimeUnit.SECONDS), ClassTag$.MODULE$.apply(TimeoutException.class), new Position("ConnectionQuotasTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 242));
            executor.submit(() -> this.acceptConnections(connectionQuotas, (ListenerDesc)this.listeners().apply((Object)"REPLICATION"), 1L, this.acceptConnections$default$4())).get(5L, TimeUnit.SECONDS);
            int n = 0;
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Range range = RichInt$.MODULE$.until$extension0(n, 2);
            if (range == null) {
                throw null;
            }
            Range foreach$mVc$sp_this = range;
            if (!foreach$mVc$sp_this.isEmpty()) {
                int foreach$mVc$sp_i = foreach$mVc$sp_this.start();
                while (true) {
                    connectionQuotas.dec(((ListenerDesc)this.listeners().apply((Object)"EXTERNAL")).listenerName(), ((ListenerDesc)this.listeners().apply((Object)"EXTERNAL")).defaultIp());
                    if (foreach$mVc$sp_i == foreach$mVc$sp_this.scala$collection$immutable$Range$$lastElement()) break;
                    foreach$mVc$sp_i += foreach$mVc$sp_this.step();
                }
            }
            Assertions$.MODULE$.intercept((Function0 & Serializable & scala.Serializable)() -> future1.get(100L, TimeUnit.MILLISECONDS), ClassTag$.MODULE$.apply(TimeoutException.class), new Position("ConnectionQuotasTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 252));
            connectionQuotas.dec(((ListenerDesc)this.listeners().apply((Object)"EXTERNAL")).listenerName(), ((ListenerDesc)this.listeners().apply((Object)"EXTERNAL")).defaultIp());
            future1.get(1L, TimeUnit.SECONDS);
        }
        finally {
            executor.shutdownNow();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testMaxListenerConnectionLimits() {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        int maxConnections = 800;
        int listenerMaxConnections = 200;
        Properties props = this.brokerPropsWithDefaultConnectionLimits();
        props.put(KafkaConfig$.MODULE$.MaxConnectionsProp(), ((Object)BoxesRunTime.boxToInteger((int)maxConnections)).toString());
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        ConnectionQuotas connectionQuotas = new ConnectionQuotas(config, (Time)this.time());
        this.addListenersAndVerify(config, connectionQuotas);
        Tuple2[] tuple2Array = new Tuple2[1];
        String string = ((Object)BoxesRunTime.boxToInteger((int)listenerMaxConnections)).toString();
        Object object = Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.MaxConnectionsProp());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        java.util.Map listenerConfig = (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array))).asJava();
        this.listeners().values().foreach((Function1 & Serializable & scala.Serializable)listener -> {
            ConnectionQuotasTest.$anonfun$testMaxListenerConnectionLimits$1(connectionQuotas, listenerConfig, listener);
            return BoxedUnit.UNIT;
        });
        ExecutorService executor = Executors.newFixedThreadPool(this.listeners().size());
        try {
            ((Iterable)this.listeners().values().map((Function1 & Serializable & scala.Serializable)listener -> executor.submit(() -> this.acceptConnections(connectionQuotas, (ListenerDesc)listener, listenerMaxConnections, this.acceptConnections$default$4())), Iterable$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x$2 -> x$2.get(5L, TimeUnit.SECONDS));
            this.listeners().values().foreach((Function1 & Serializable & scala.Serializable)listener -> {
                ConnectionQuotasTest.$anonfun$testMaxListenerConnectionLimits$5(listenerMaxConnections, connectionQuotas, listener);
                return BoxedUnit.UNIT;
            });
            Iterable overLimitFutures = (Iterable)this.listeners().values().map((Function1 & Serializable & scala.Serializable)listener -> executor.submit(() -> this.acceptConnections(connectionQuotas, (ListenerDesc)listener, 1L, this.acceptConnections$default$4())), Iterable$.MODULE$.canBuildFrom());
            overLimitFutures.foreach((Function1 & Serializable & scala.Serializable)future -> (TimeoutException)Assertions$.MODULE$.intercept((Function0 & Serializable & scala.Serializable)() -> future.get(1L, TimeUnit.SECONDS), ClassTag$.MODULE$.apply(TimeoutException.class), new Position("ConnectionQuotasTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 297)));
            this.listeners().values().foreach((Function1 & Serializable & scala.Serializable)listener -> {
                connectionQuotas.dec(listener.listenerName(), listener.defaultIp());
                return BoxedUnit.UNIT;
            });
            overLimitFutures.foreach((Function1 & Serializable & scala.Serializable)x$3 -> x$3.get(5L, TimeUnit.SECONDS));
            this.listeners().values().foreach((Function1 & Serializable & scala.Serializable)listener -> {
                ConnectionQuotasTest.$anonfun$testMaxListenerConnectionLimits$12(listenerMaxConnections, connectionQuotas, listener);
                return BoxedUnit.UNIT;
            });
        }
        finally {
            executor.shutdownNow();
        }
    }

    private void addListenersAndVerify(KafkaConfig config, ConnectionQuotas connectionQuotas) {
        this.listeners().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            ConnectionQuotasTest.$anonfun$addListenersAndVerify$1(connectionQuotas, config, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    private void acceptConnections(ConnectionQuotas connectionQuotas, ListenerDesc listenerDesc, long numConnections, long timeIntervalMs) {
        this.acceptConnections(connectionQuotas, listenerDesc.listenerName(), listenerDesc.defaultIp(), numConnections, timeIntervalMs);
    }

    private void acceptConnections(ConnectionQuotas connectionQuotas, ListenerName listenerName, InetAddress address, long numConnections, long timeIntervalMs) {
        long l = 0L;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        new RichLong(l).until((Object)BoxesRunTime.boxToLong((long)numConnections)).foreach((Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)_ -> {
            connectionQuotas.inc(listenerName, address, (Meter)this.blockedPercentMeters().apply((Object)listenerName.value()));
            this.time().sleep(timeIntervalMs);
        });
    }

    private long acceptConnections$default$4() {
        return 0L;
    }

    private void acceptConnectionsAboveIpLimit(ConnectionQuotas connectionQuotas, ListenerDesc listenerDesc, long numConnections) {
        ListenerName listenerName = listenerDesc.listenerName();
        long l = 0L;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        new RichLong(l).until((Object)BoxesRunTime.boxToLong((long)numConnections)).foreach((Function1 & Serializable & scala.Serializable)i -> ConnectionQuotasTest.$anonfun$acceptConnectionsAboveIpLimit$1(this, connectionQuotas, listenerName, listenerDesc, BoxesRunTime.unboxToLong((Object)i)));
    }

    private final void ListenerDesc$lzycompute$1() {
        synchronized (this) {
            if (this.ListenerDesc$module == null) {
                this.ListenerDesc$module = new ConnectionQuotasTest$ListenerDesc$(this);
            }
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$testNoConnectionLimitsByDefault$4(int numConnections$1, ConnectionQuotas connectionQuotas$3, ListenerDesc listener) {
        Assert.assertEquals((String)new StringBuilder(26).append("Number of connections on ").append(listener).append(":").toString(), (long)numConnections$1, (long)connectionQuotas$3.get(listener.defaultIp()));
        connectionQuotas$3.dec(listener.listenerName(), listener.defaultIp());
        Assert.assertEquals((String)new StringBuilder(26).append("Number of connections on ").append(listener).append(":").toString(), (long)(numConnections$1 - 1), (long)connectionQuotas$3.get(listener.defaultIp()));
    }

    public static final /* synthetic */ void $anonfun$testMaxListenerConnectionLimits$1(ConnectionQuotas connectionQuotas$6, java.util.Map listenerConfig$1, ListenerDesc listener) {
        ((ConnectionQuotas.ListenerConnectionQuota)connectionQuotas$6.maxConnectionsPerListener().apply((Object)listener.listenerName())).configure(listenerConfig$1);
    }

    public static final /* synthetic */ void $anonfun$testMaxListenerConnectionLimits$5(int listenerMaxConnections$1, ConnectionQuotas connectionQuotas$6, ListenerDesc listener) {
        Assert.assertEquals((String)new StringBuilder(26).append("Number of connections on ").append(listener).append(":").toString(), (long)listenerMaxConnections$1, (long)connectionQuotas$6.get(listener.defaultIp()));
        Assert.assertFalse((String)new StringBuilder(62).append("Total number of connections on ").append(listener).append(" should be exactly the maximum.").toString(), (boolean)connectionQuotas$6.maxConnectionsExceeded(listener.listenerName()));
    }

    public static final /* synthetic */ void $anonfun$testMaxListenerConnectionLimits$12(int listenerMaxConnections$1, ConnectionQuotas connectionQuotas$6, ListenerDesc listener) {
        Assert.assertEquals((String)new StringBuilder(26).append("Number of connections on ").append(listener).append(":").toString(), (long)listenerMaxConnections$1, (long)connectionQuotas$6.get(listener.defaultIp()));
    }

    public static final /* synthetic */ void $anonfun$addListenersAndVerify$1(ConnectionQuotas connectionQuotas$7, KafkaConfig config$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            String name = (String)x0$1._1();
            ListenerDesc listener = (ListenerDesc)x0$1._2();
            connectionQuotas$7.addListener(config$1, listener.listenerName());
            Assert.assertFalse((String)new StringBuilder(72).append("Should not exceed max connection limit on ").append(name).append(" listener after initialization").toString(), (boolean)connectionQuotas$7.maxConnectionsExceeded(listener.listenerName()));
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ TooManyConnectionsException $anonfun$acceptConnectionsAboveIpLimit$1(ConnectionQuotasTest $this, ConnectionQuotas connectionQuotas$9, ListenerName listenerName$2, ListenerDesc listenerDesc$1, long i) {
        return (TooManyConnectionsException)Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> connectionQuotas$9.inc(listenerName$2, listenerDesc$1.defaultIp(), (Meter)$this.blockedPercentMeters().apply((Object)listenerName$2.value())), ClassTag$.MODULE$.apply(TooManyConnectionsException.class), new Position("ConnectionQuotasTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 351));
    }

    /*
     * WARNING - void declaration
     */
    public ConnectionQuotasTest() {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        void $minus$greater$extension_y2;
        void $minus$greater$extension_$this2;
        void $minus$greater$extension_y3;
        void $minus$greater$extension_$this3;
        Tuple2[] tuple2Array = new Tuple2[3];
        ListenerDesc listenerDesc = new ListenerDesc(this, new ListenerName("EXTERNAL"), InetAddress.getByName("192.168.1.1"));
        Object object = Predef$.MODULE$.ArrowAssoc((Object)"EXTERNAL");
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this3, (Object)$minus$greater$extension_y3);
        ListenerDesc listenerDesc2 = new ListenerDesc(this, new ListenerName("ADMIN"), InetAddress.getByName("192.168.1.2"));
        Object object2 = Predef$.MODULE$.ArrowAssoc((Object)"ADMIN");
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[1] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y2);
        ListenerDesc listenerDesc3 = new ListenerDesc(this, new ListenerName("REPLICATION"), InetAddress.getByName("192.168.1.3"));
        Object object3 = Predef$.MODULE$.ArrowAssoc((Object)"REPLICATION");
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[2] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        this.listeners = (Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array));
        this.blockedPercentMeters = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.knownHost = InetAddress.getByName("192.168.10.0");
        this.unknownHost = InetAddress.getByName("192.168.2.0");
    }

    public class ListenerDesc
    implements Product,
    scala.Serializable {
        private final ListenerName listenerName;
        private final InetAddress defaultIp;
        public final /* synthetic */ ConnectionQuotasTest $outer;

        public ListenerName listenerName() {
            return this.listenerName;
        }

        public InetAddress defaultIp() {
            return this.defaultIp;
        }

        public String toString() {
            return new StringBuilder(20).append("(listener=").append(this.listenerName().value()).append(", client=").append(this.defaultIp().getHostAddress()).append(")").toString();
        }

        public ListenerDesc copy(ListenerName listenerName, InetAddress defaultIp) {
            return new ListenerDesc(this.kafka$network$ConnectionQuotasTest$ListenerDesc$$$outer(), listenerName, defaultIp);
        }

        public ListenerName copy$default$1() {
            return this.listenerName();
        }

        public InetAddress copy$default$2() {
            return this.defaultIp();
        }

        public String productPrefix() {
            return "ListenerDesc";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            switch (x$1) {
                case 0: {
                    return this.listenerName();
                }
                case 1: {
                    return this.defaultIp();
                }
            }
            throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof ListenerDesc;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            if (!(x$1 instanceof ListenerDesc)) return false;
            if (((ListenerDesc)x$1).kafka$network$ConnectionQuotasTest$ListenerDesc$$$outer() != this.kafka$network$ConnectionQuotasTest$ListenerDesc$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            ListenerDesc listenerDesc = (ListenerDesc)x$1;
            ListenerName listenerName = this.listenerName();
            ListenerName listenerName2 = listenerDesc.listenerName();
            if (listenerName == null) {
                if (listenerName2 != null) {
                    return false;
                }
            } else if (!listenerName.equals(listenerName2)) return false;
            InetAddress inetAddress = this.defaultIp();
            InetAddress inetAddress2 = listenerDesc.defaultIp();
            if (inetAddress == null) {
                if (inetAddress2 != null) {
                    return false;
                }
            } else if (!((Object)inetAddress).equals(inetAddress2)) return false;
            if (!listenerDesc.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ ConnectionQuotasTest kafka$network$ConnectionQuotasTest$ListenerDesc$$$outer() {
            return this.$outer;
        }

        public ListenerDesc(ConnectionQuotasTest $outer, ListenerName listenerName, InetAddress defaultIp) {
            this.listenerName = listenerName;
            this.defaultIp = defaultIp;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }
}

