/*
 * Decompiled with CFR 0.152.
 */
package kafka.security.authorizer;

import java.io.File;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import kafka.Kafka$;
import kafka.api.ApiVersion;
import kafka.api.KAFKA_2_0_IV0$;
import kafka.api.KAFKA_2_0_IV1$;
import kafka.security.authorizer.AclAuthorizer;
import kafka.security.authorizer.AclAuthorizer$;
import kafka.security.authorizer.AclEntry$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.utils.TestUtils$;
import kafka.zk.ZkAclStore;
import kafka.zk.ZkAclStore$;
import kafka.zk.ZooKeeperTestHarness;
import kafka.zookeeper.AsyncRequest;
import kafka.zookeeper.GetChildrenRequest;
import kafka.zookeeper.GetChildrenRequest$;
import kafka.zookeeper.GetChildrenResponse;
import kafka.zookeeper.GetDataRequest;
import kafka.zookeeper.GetDataRequest$;
import kafka.zookeeper.GetDataResponse;
import kafka.zookeeper.ZooKeeperClient;
import org.apache.kafka.common.acl.AccessControlEntry;
import org.apache.kafka.common.acl.AccessControlEntryFilter;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.acl.AclPermissionType;
import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.network.ClientInformation;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.resource.ResourcePattern;
import org.apache.kafka.common.resource.ResourcePatternFilter;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.SecurityUtils;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.authorizer.AclCreateResult;
import org.apache.kafka.server.authorizer.AclDeleteResult;
import org.apache.kafka.server.authorizer.Action;
import org.apache.kafka.server.authorizer.AuthorizableRequestContext;
import org.apache.kafka.server.authorizer.AuthorizationResult;
import org.apache.kafka.server.authorizer.Authorizer;
import org.apache.zookeeper.client.ZKClientConfig;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversable;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.CanBuildFrom;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map$;
import scala.collection.mutable.MapLike;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\r5h\u0001\u00025j\u0001ADQa\u001e\u0001\u0005\u0002aDqa\u001f\u0001C\u0002\u0013%A\u0010C\u0004\u0002\u0016\u0001\u0001\u000b\u0011B?\t\u0011\u0005]\u0001A1A\u0005\nqDq!!\u0007\u0001A\u0003%Q\u0010\u0003\u0005\u0002\u001c\u0001\u0011\r\u0011\"\u0003}\u0011\u001d\ti\u0002\u0001Q\u0001\nuD\u0011\"a\b\u0001\u0005\u0004%I!!\t\t\u0011\u0005=\u0002\u0001)A\u0005\u0003GA\u0011\"!\r\u0001\u0005\u0004%I!!\t\t\u0011\u0005M\u0002\u0001)A\u0005\u0003GA\u0011\"!\u000e\u0001\u0005\u0004%I!!\t\t\u0011\u0005]\u0002\u0001)A\u0005\u0003GA\u0011\"!\u000f\u0001\u0005\u0004%I!a\u000f\t\u0011\u0005-\u0003\u0001)A\u0005\u0003{A\u0011\"!\u0014\u0001\u0005\u0004%I!a\u0014\t\u0011\u0005]\u0003\u0001)A\u0005\u0003#B\u0011\"!\u0017\u0001\u0005\u0004%I!a\u0014\t\u0011\u0005m\u0003\u0001)A\u0005\u0003#B1\"!\u000b\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002\"!Y\u0011Q\f\u0001A\u0002\u0003\u0007I\u0011BA0\u0011-\t\t\b\u0001a\u0001\u0002\u0003\u0006K!a\t\t\u0013\u0005M\u0004A1A\u0005\n\u0005U\u0004\u0002CAD\u0001\u0001\u0006I!a\u001e\t\u0013\u0005%\u0005A1A\u0005\n\u0005U\u0004\u0002CAF\u0001\u0001\u0006I!a\u001e\t\u0013\u00055\u0005A1A\u0005\n\u0005m\u0002\u0002CAH\u0001\u0001\u0006I!!\u0010\t\u0013\u0005E\u0005A1A\u0005\n\u0005M\u0005\u0002CAQ\u0001\u0001\u0006I!!&\t\u0017\u0005\r\u0006\u00011AA\u0002\u0013%\u0011Q\u0015\u0005\f\u0003g\u0003\u0001\u0019!a\u0001\n\u0013\t)\fC\u0006\u0002:\u0002\u0001\r\u0011!Q!\n\u0005\u001d\u0006bCA^\u0001\u0001\u0007\t\u0019!C\u0005\u0003{C1\"a3\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002N\"Y\u0011\u0011\u001b\u0001A\u0002\u0003\u0005\u000b\u0015BA`\r\u0019\t\u0019\u000e\u0001\u0001\u0002V\"Q\u0011q[\u0013\u0003\u0002\u0003\u0006I!!7\t\u0015\u00055XE!A!\u0002\u0013\tI\u000e\u0003\u0004xK\u0011\u0005\u0011q\u001e\u0005\b\u0003s,C\u0011IA~\u0011\u001d\u0011i\u0001\u0001C!\u0005\u001fAqAa\b\u0001\t\u0003\u0012y\u0001C\u0004\u0003*\u0001!\tAa\u0004\t\u000f\t%\u0003\u0001\"\u0001\u0003\u0010!9!Q\n\u0001\u0005\u0002\t=\u0001b\u0002B)\u0001\u0011\u0005!q\u0002\u0005\b\u0005+\u0002A\u0011\u0001B\b\u0011\u001d\u0011I\u0006\u0001C\u0001\u0005\u001fAqA!\u0018\u0001\t\u0003\u0011y\u0001C\u0004\u0003b\u0001!\tAa\u0004\t\u000f\t\u0015\u0004\u0001\"\u0001\u0003\u0010!9!\u0011\u000e\u0001\u0005\u0002\t=\u0001b\u0002B7\u0001\u0011\u0005!q\u0002\u0005\b\u0005c\u0002A\u0011\u0001B\b\u0011\u001d\u0011)\b\u0001C\u0001\u0005\u001fAqA!\u001f\u0001\t\u0003\u0011y\u0001C\u0004\u0003~\u0001!\tAa\u0004\t\u000f\t\u0005\u0005\u0001\"\u0001\u0003\u0010!9!Q\u0011\u0001\u0005\u0002\t=\u0001b\u0002BE\u0001\u0011\u0005!q\u0002\u0005\b\u0005\u001b\u0003A\u0011\u0001B\b\u0011\u001d\u0011\t\n\u0001C\u0005\u0005'CqA!+\u0001\t\u0013\u0011Y\u000bC\u0004\u00034\u0002!\tAa\u0004\t\u000f\t]\u0006\u0001\"\u0001\u0003\u0010!9!1\u0018\u0001\u0005\u0002\t=\u0001b\u0002B`\u0001\u0011\u0005!q\u0002\u0005\b\u0005\u0007\u0004A\u0011\u0001B\b\u0011\u001d\u00119\r\u0001C\u0001\u0005\u001fAqAa3\u0001\t\u0003\u0011y\u0001C\u0004\u0003P\u0002!\tAa\u0004\t\u000f\tM\u0007\u0001\"\u0001\u0003\u0010!9!q\u001b\u0001\u0005\u0002\t=\u0001b\u0002Bn\u0001\u0011\u0005!q\u0002\u0005\b\u0005?\u0004A\u0011\u0001B\b\u0011\u001d\u0011\u0019\u000f\u0001C\u0001\u0005\u001fAqAa:\u0001\t\u0003\u0011y\u0001C\u0004\u0003l\u0002!\tAa\u0004\t\u000f\t=\b\u0001\"\u0001\u0003\u0010!9!1\u001f\u0001\u0005\u0002\t=\u0001b\u0002B|\u0001\u0011\u0005!q\u0002\u0005\b\u0005w\u0004A\u0011\u0001B\b\u0011\u001d\u0011y\u0010\u0001C\u0001\u0005\u001fAqaa\u0001\u0001\t\u0003\u0011y\u0001C\u0004\u0004\b\u0001!\tAa\u0004\t\u000f\r-\u0001\u0001\"\u0001\u0003\u0010!91q\u0002\u0001\u0005\u0002\t=\u0001bBB\n\u0001\u0011%1Q\u0003\u0005\b\u0007[\u0001A\u0011BB\u0018\u0011\u001d\u0019Y\u0004\u0001C\u0005\u0007{A\u0011ba\u0014\u0001#\u0003%Ia!\u0015\t\u000f\r\u001d\u0004\u0001\"\u0003\u0004j!I1Q\u0012\u0001\u0012\u0002\u0013%1q\u0012\u0005\b\u0007'\u0003A\u0011BBK\u0011\u001d\u0019\t\u000b\u0001C\u0005\u0007GCqaa,\u0001\t\u0013\u0019\t\fC\u0004\u0004:\u0002!Iaa/\t\u000f\re\u0006\u0001\"\u0003\u0004B\"91\u0011\u0018\u0001\u0005\n\r=\u0007bBBj\u0001\u0011%1Q\u001b\u0005\b\u00077\u0004A\u0011BBo\u0011\u001d\u0019y\u000e\u0001C\u0005\u0007C\u0014\u0011#Q2m\u0003V$\bn\u001c:ju\u0016\u0014H+Z:u\u0015\tQ7.\u0001\u0006bkRDwN]5{KJT!\u0001\\7\u0002\u0011M,7-\u001e:jifT\u0011A\\\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001\u0011\u000f\u0005\u0002sk6\t1O\u0003\u0002u[\u0006\u0011!p[\u0005\u0003mN\u0014ACW8p\u0017\u0016,\u0007/\u001a:UKN$\b*\u0019:oKN\u001c\u0018A\u0002\u001fj]&$h\bF\u0001z!\tQ\b!D\u0001j\u00031\tG\u000e\\8x%\u0016\fG-Q2m+\u0005i\bc\u0001@\u0002\u00125\tqP\u0003\u0003\u0002\u0002\u0005\r\u0011aA1dY*!\u0011QAA\u0004\u0003\u0019\u0019w.\\7p]*\u0019a.!\u0003\u000b\t\u0005-\u0011QB\u0001\u0007CB\f7\r[3\u000b\u0005\u0005=\u0011aA8sO&\u0019\u00111C@\u0003%\u0005\u001b7-Z:t\u0007>tGO]8m\u000b:$(/_\u0001\u000eC2dwn\u001e*fC\u0012\f5\r\u001c\u0011\u0002\u001b\u0005dGn\\<Xe&$X-Q2m\u00039\tG\u000e\\8x/JLG/Z!dY\u0002\n1\u0002Z3osJ+\u0017\rZ!dY\u0006aA-\u001a8z%\u0016\fG-Q2mA\u0005\u0001r/\u001b7e\u0007\u0006\u0014HMU3t_V\u00148-Z\u000b\u0003\u0003G\u0001B!!\n\u0002,5\u0011\u0011q\u0005\u0006\u0005\u0003S\t\u0019!\u0001\u0005sKN|WO]2f\u0013\u0011\ti#a\n\u0003\u001fI+7o\\;sG\u0016\u0004\u0016\r\u001e;fe:\f\u0011c^5mI\u000e\u000b'\u000f\u001a*fg>,(oY3!\u0003A\u0001(/\u001a4jq\u0016$'+Z:pkJ\u001cW-A\tqe\u00164\u0017\u000e_3e%\u0016\u001cx.\u001e:dK\u0002\nqb\u00197vgR,'OU3t_V\u00148-Z\u0001\u0011G2,8\u000f^3s%\u0016\u001cx.\u001e:dK\u0002\n\u0011c^5mI\u000e\f'\u000f\u001a)sS:\u001c\u0017\u000e]1m+\t\ti\u0004\u0005\u0003\u0002@\u0005\u001dSBAA!\u0015\u0011\t\u0019%!\u0012\u0002\t\u0005,H\u000f\u001b\u0006\u0004Y\u0006\r\u0011\u0002BA%\u0003\u0003\u0012abS1gW\u0006\u0004&/\u001b8dSB\fG.\u0001\nxS2$7-\u0019:e!JLgnY5qC2\u0004\u0013!D1dY\u0006+H\u000f[8sSj,'/\u0006\u0002\u0002RA\u0019!0a\u0015\n\u0007\u0005U\u0013NA\u0007BG2\fU\u000f\u001e5pe&TXM]\u0001\u000fC\u000ed\u0017)\u001e;i_JL'0\u001a:!\u00039\t7\r\\!vi\"|'/\u001b>feJ\nq\"Y2m\u0003V$\bn\u001c:ju\u0016\u0014(\u0007I\u0001\re\u0016\u001cx.\u001e:dK~#S-\u001d\u000b\u0005\u0003C\ni\u0007\u0005\u0003\u0002d\u0005%TBAA3\u0015\t\t9'A\u0003tG\u0006d\u0017-\u0003\u0003\u0002l\u0005\u0015$\u0001B+oSRD\u0011\"a\u001c\u0016\u0003\u0003\u0005\r!a\t\u0002\u0007a$\u0013'A\u0005sKN|WO]2fA\u0005Q1/\u001e9feV\u001bXM]:\u0016\u0005\u0005]\u0004\u0003BA=\u0003\u0007k!!a\u001f\u000b\t\u0005u\u0014qP\u0001\u0005Y\u0006twM\u0003\u0002\u0002\u0002\u0006!!.\u0019<b\u0013\u0011\t))a\u001f\u0003\rM#(/\u001b8h\u0003-\u0019X\u000f]3s+N,'o\u001d\u0011\u0002\u0011U\u001cXM\u001d8b[\u0016\f\u0011\"^:fe:\fW.\u001a\u0011\u0002\u0013A\u0014\u0018N\\2ja\u0006d\u0017A\u00039sS:\u001c\u0017\u000e]1mA\u0005q!/Z9vKN$8i\u001c8uKb$XCAAK!\u0011\t9*!(\u000e\u0005\u0005e%\u0002BAN\u0003\u0007\t\u0001B]3rk\u0016\u001cHo]\u0005\u0005\u0003?\u000bIJ\u0001\bSKF,Xm\u001d;D_:$X\r\u001f;\u0002\u001fI,\u0017/^3ti\u000e{g\u000e^3yi\u0002\naaY8oM&<WCAAT!\u0011\tI+a,\u000e\u0005\u0005-&bAAW[\u000611/\u001a:wKJLA!!-\u0002,\nY1*\u00194lC\u000e{gNZ5h\u0003)\u0019wN\u001c4jO~#S-\u001d\u000b\u0005\u0003C\n9\fC\u0005\u0002p\u0001\n\t\u00111\u0001\u0002(\u000691m\u001c8gS\u001e\u0004\u0013a\u0004>p_.+W\r]3s\u00072LWM\u001c;\u0016\u0005\u0005}\u0006\u0003BAa\u0003\u000fl!!a1\u000b\u0007\u0005\u0015W.A\u0005{_>\\W-\u001a9fe&!\u0011\u0011ZAb\u0005=Qvn\\&fKB,'o\u00117jK:$\u0018a\u0005>p_.+W\r]3s\u00072LWM\u001c;`I\u0015\fH\u0003BA1\u0003\u001fD\u0011\"a\u001c$\u0003\u0003\u0005\r!a0\u0002!i|wnS3fa\u0016\u00148\t\\5f]R\u0004#aD\"vgR|W\u000e\u0015:j]\u000eL\u0007/\u00197\u0014\u0007\u0015\ni$A\u0007qe&t7-\u001b9bYRK\b/\u001a\t\u0005\u00037\fIO\u0004\u0003\u0002^\u0006\u0015\b\u0003BAp\u0003Kj!!!9\u000b\u0007\u0005\rx.\u0001\u0004=e>|GOP\u0005\u0005\u0003O\f)'\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003\u000b\u000bYO\u0003\u0003\u0002h\u0006\u0015\u0014\u0001\u00028b[\u0016$b!!=\u0002v\u0006]\bcAAzK5\t\u0001\u0001C\u0004\u0002X\"\u0002\r!!7\t\u000f\u00055\b\u00061\u0001\u0002Z\u00061Q-];bYN$B!!@\u0003\u0004A!\u00111MA\u0000\u0013\u0011\u0011\t!!\u001a\u0003\u000f\t{w\u000e\\3b]\"9!QA\u0015A\u0002\t\u001d\u0011!A8\u0011\t\u0005\r$\u0011B\u0005\u0005\u0005\u0017\t)GA\u0002B]f\fQa]3u+B$\"!!\u0019)\u0007)\u0012\u0019\u0002\u0005\u0003\u0003\u0016\tmQB\u0001B\f\u0015\u0011\u0011I\"!\u0004\u0002\u000b),h.\u001b;\n\t\tu!q\u0003\u0002\u0007\u0005\u00164wN]3\u0002\u0011Q,\u0017M\u001d#po:D3a\u000bB\u0012!\u0011\u0011)B!\n\n\t\t\u001d\"q\u0003\u0002\u0006\u0003\u001a$XM]\u0001(i\u0016\u001cH/Q;uQ>\u0014\u0018N_3UQJ|wo](o\u001d>tG*\u001b;fe\u0006d'+Z:pkJ\u001cW\rK\u0004-\u0005[\u0011\u0019D!\u000e\u0011\t\tU!qF\u0005\u0005\u0005c\u00119B\u0001\u0003UKN$\u0018\u0001C3ya\u0016\u001cG/\u001a3$\u0005\t]\u0002\u0003\u0002B\u001d\u0005\u0007rAAa\u000f\u0003@9!\u0011q\u001cB\u001f\u0013\t\t9'\u0003\u0003\u0003B\u0005\u0015\u0014a\u00029bG.\fw-Z\u0005\u0005\u0005\u000b\u00129E\u0001\rJY2,w-\u00197Be\u001e,X.\u001a8u\u000bb\u001cW\r\u001d;j_:TAA!\u0011\u0002f\u0005\u0011C/Z:u\u0003V$\bn\u001c:ju\u0016<\u0016\u000e\u001e5F[B$\u0018PU3t_V\u00148-\u001a(b[\u0016D3!\fB\u0017\u0003m!Xm\u001d;F[B$\u00180Q2m)\"\u0014xn^:Fq\u000e,\u0007\u000f^5p]\"\u001aaF!\f\u0002\u0019Q,7\u000f\u001e+pa&\u001c\u0017i\u00197)\u0007=\u0012i#\u0001\u0012uKN$\u0018\t\u001c7po\u0006\u001b7-Z:t/&$\bnQ;ti>l\u0007K]5oG&\u0004\u0018\r\u001c\u0015\u0004a\t5\u0012a\u0006;fgR$UM\\=UC.,7\u000f\u0015:fG\u0016$WM\\2fQ\r\t$QF\u0001\u0013i\u0016\u001cH/\u00117m_^\fE\u000e\\!dG\u0016\u001c8\u000fK\u00023\u0005[\ta\u0003^3tiN+\b/\u001a:Vg\u0016\u0014\b*Y:BG\u000e,7o\u001d\u0015\u0004g\t5\u0012!\u000b;fgR\u001cV\u000f]3s+N,'oV5uQ\u000e+8\u000f^8n!JLgnY5qC2D\u0015m]!dG\u0016\u001c8\u000fK\u00025\u0005[\t\u0001\u0003^3ti^KG\u000eZ\"be\u0012\f5\r\\:)\u0007U\u0012i#\u0001\buKN$hj\\!dY\u001a{WO\u001c3)\u0007Y\u0012i#\u0001\fuKN$hj\\!dY\u001a{WO\u001c3Pm\u0016\u0014(/\u001b3fQ\r9$QF\u0001\u0016i\u0016\u001cH/Q2m\u001b\u0006t\u0017mZ3nK:$\u0018\tU%tQ\rA$QF\u0001\u000ei\u0016\u001cH\u000fT8bI\u000e\u000b7\r[3)\u0007e\u0012i#\u0001\ruKN$8\t[1oO\u0016d\u0015n\u001d;f]\u0016\u0014H+[7j]\u001eD3A\u000fB\u0017\u00035\"Xm\u001d;M_\u000e\fGnQ8oGV\u0014(/\u001a8u\u001b>$\u0017NZ5dCRLwN\\(g%\u0016\u001cx.\u001e:dK\u0006\u001bGn\u001d\u0015\u0004w\t5\u0012a\r;fgR$\u0015n\u001d;sS\n,H/\u001a3D_:\u001cWO\u001d:f]Rlu\u000eZ5gS\u000e\fG/[8o\u001f\u001a\u0014Vm]8ve\u000e,\u0017i\u00197tQ\ra$QF\u0001.i\u0016\u001cH\u000fS5hQ\u000e{gnY;se\u0016t7-_'pI&4\u0017nY1uS>twJ\u001a*fg>,(oY3BG2\u001c\bfA\u001f\u0003.\u0005\u0011B/Z:u\u0003\u000ed\u0017J\u001c5fe&$\u0018M\\2fQ\rq$QF\u0001\u0018i\u0016\u001cH/S7qY&\u001c\u0017\r^5p]N|e-\u00117m_^$b!!\u0019\u0003\u0016\n}\u0005b\u0002BL\u007f\u0001\u0007!\u0011T\u0001\ta\u0006\u0014XM\u001c;PaB\u0019aPa'\n\u0007\tuuP\u0001\u0007BG2|\u0005/\u001a:bi&|g\u000eC\u0004\u0003\"~\u0002\rAa)\u0002\u0015\u0005dGn\\<fI>\u00038\u000f\u0005\u0004\u0002\\\n\u0015&\u0011T\u0005\u0005\u0005O\u000bYOA\u0002TKR\fa\u0003^3ti&k\u0007\u000f\\5dCRLwN\\:PM\u0012+g.\u001f\u000b\u0007\u0003C\u0012iKa,\t\u000f\t]\u0005\t1\u0001\u0003\u001a\"9!\u0011\u0017!A\u0002\t\r\u0016!\u00033f]&,Gm\u00149t\u0003%\"Xm\u001d;IS\u001eD7i\u001c8dkJ\u0014XM\\2z\t\u0016dW\r^5p]>3'+Z:pkJ\u001cW-Q2mg\"\u001a\u0011I!\f\u0002gQ,7\u000f^!dG\u0016\u001c8/\u00117m_^,G-\u00134BY2|w/Q2m\u000bbL7\u000f^:P]^KG\u000eZ2be\u0012\u0014Vm]8ve\u000e,\u0007f\u0001\"\u0003.\u0005yB/Z:u\t\u0016dW\r^3BG2|enV5mI\u000e\f'\u000f\u001a*fg>,(oY3)\u0007\r\u0013i#\u0001\u0012uKN$H)\u001a7fi\u0016\fE\u000e\\!dY>sw+\u001b7eG\u0006\u0014HMU3t_V\u00148-\u001a\u0015\u0004\t\n5\u0012a\r;fgR\f5mY3tg\u0006cGn\\<fI&3\u0017\t\u001c7po\u0006\u001bG.\u0012=jgR\u001cxJ\u001c)sK\u001aL\u00070\u001a3SKN|WO]2fQ\r)%QF\u0001 i\u0016\u001cH\u000fR3mKR,\u0017i\u00197P]B\u0013XMZ5yK\u0012\u0014Vm]8ve\u000e,\u0007f\u0001$\u0003.\u0005\u0011C/Z:u\t\u0016dW\r^3BY2\f5\r\\(o!J,g-\u001b=fIJ+7o\\;sG\u0016D3a\u0012B\u0017\u0003q!Xm\u001d;BI\u0012\f5\r\\:P]2KG/\u001a:bYJ+7o\\;sG\u0016D3\u0001\u0013B\u0017\u0003u!Xm\u001d;BI\u0012\f5\r\\:P]^KG\u000eZ2be\u0012\u0014Vm]8ve\u000e,\u0007fA%\u0003.\u0005iB/Z:u\u0003\u0012$\u0017i\u00197t\u001f:\u0004&/\u001a4jq\u0016$'+Z:pkJ\u001cW\rK\u0002K\u0005[\t\u0011\u0005^3ti\u0006+H\u000f[8sSj,w+\u001b;i!J,g-\u001b=fIJ+7o\\;sG\u0016D3a\u0013B\u0017\u0003}!Xm\u001d;TS:<G.Z\"iCJ\f7\r^3s%\u0016\u001cx.\u001e:dK\u0006\u001bGn\u001d\u0015\u0004\u0019\n5\u0012\u0001\u0006;fgR<U\r^!dYN\u0004&/\u001b8dSB\fG\u000eK\u0002N\u0005[\ta\u0002^3ti\u0006\u001bGn\u001d$jYR,'\u000fK\u0002O\u0005[\tA\b^3tiRC'o\\<t\u001f:\fE\r\u001a)sK\u001aL\u00070\u001a3BG2Le-\u00138uKJ\u0014%o\\6feB\u0013x\u000e^8d_24VM]:j_:$vn\u001c'po\"\u001aqJ!\f\u0002wQ,7\u000f^,sSR,7/\u0012=uK:$W\rZ!dY\u000eC\u0017M\\4f\u000bZ,g\u000e^%g\u0013:$XM\u001d\"s_.,'\u000f\u0015:pi>\u001cw\u000e\u001c(piN+G\u000fK\u0002Q\u0005[\tQ\t^3ti^\u0013\u0018\u000e^3t\u000bb$XM\u001c3fI\u0006\u001bGn\u00115b]\u001e,WI^3oi^CWM\\%oi\u0016\u0014(I]8lKJ\u0004&o\u001c;pG>d\u0017\t\u001e'fCN$8*\u00194lCZ\u0013\u0004fA)\u0003.\u0005AH/Z:u/JLG/Z:MSR,'/\u00197Xe&$Xm\u001d'ji\u0016\u0014\u0018\r\\!dY\u000eC\u0017M\\4f\u000bZ,g\u000e^,iK:Le\u000e^3s\u0005J|7.\u001a:Qe>$xnY8m\u0019\u0016\u001c8\u000f\u00165b].\u000bgm[1We\u0015\u0014\u0018\r\\!dY\u000eC\u0017M\\4fg\u001a{'o\u00147eKJ\u0004&o\u001c;pG>dg+\u001a:tS>t7\u000fK\u0002S\u0005[\tq\b^3ti^\u0013\u0018\u000e^3t\u0019&$XM]1m\u0003\u000ed7\t[1oO\u0016,e/\u001a8u/\",g.\u00138uKJ\u0014%o\\6feB\u0013x\u000e^8d_2L5oS1gW\u00064&\u0007K\u0002T\u0005[\t\u0001\u0004^3ti\u0006+H\u000f[8sSj,'OT8[W\u000e{gNZ5hQ\r!&QF\u00012i\u0016\u001cH/Q;uQ>\u0014\u0018N_3s5.\u001cuN\u001c4jO\u001a\u0013x.\\&bM.\f7i\u001c8gS\u001e<\u0016\u000e\u001e5EK\u001a\fW\u000f\u001c;tQ\r)&QF\u0001&i\u0016\u001cH/Q;uQ>\u0014\u0018N_3s5.\u001cuN\u001c4jO\u001a\u0013x.\\&bM.\f7i\u001c8gS\u001eD3A\u0016B\u0017\u0003%\"Xm\u001d;BkRDwN]5{KJT6nQ8oM&<gI]8n!J,g-\u001b=Pm\u0016\u0014(/\u001b3fg\"\u001aqK!\f\u0002-Q,7\u000f^\"sK\u0006$X\rR3mKR,G+[7j]\u001eD3\u0001\u0017B\u0017\u0003\t:\u0017N^3o\u0003V$\bn\u001c:ju\u0016\u0014x+\u001b;i!J|Go\\2pYZ+'o]5p]R!\u0011\u0011MB\f\u0011\u001d\u0019I\"\u0017a\u0001\u00077\tq\u0002\u001d:pi>\u001cw\u000e\u001c,feNLwN\u001c\t\u0007\u0003G\u001aib!\t\n\t\r}\u0011Q\r\u0002\u0007\u001fB$\u0018n\u001c8\u0011\t\r\r2\u0011F\u0007\u0003\u0007KQ1aa\nn\u0003\r\t\u0007/[\u0005\u0005\u0007W\u0019)C\u0001\u0006Ba&4VM]:j_:\f\u0011dZ3u\u0003\u000ed7\t[1oO\u0016,e/\u001a8u\u0003N\u001cFO]5oOR!\u0011qOB\u0019\u0011\u001d\u0019\u0019D\u0017a\u0001\u0007k\t1\u0002]1ui\u0016\u0014h\u000eV=qKB!\u0011QEB\u001c\u0013\u0011\u0019I$a\n\u0003\u0017A\u000bG\u000f^3s]RK\b/Z\u0001\u0013G\"\fgnZ3BG2\fe\u000e\u001a,fe&4\u0017\u0010\u0006\u0006\u0004@\r\u00053QIB%\u0007\u001b\u0002R!a7\u0003&vDqaa\u0011\\\u0001\u0004\u0019y$\u0001\u0007pe&<\u0017N\\1m\u0003\u000ed7\u000fC\u0004\u0004Hm\u0003\raa\u0010\u0002\u0013\u0005$G-\u001a3BG2\u001c\bbBB&7\u0002\u00071qH\u0001\fe\u0016lwN^3e\u0003\u000ed7\u000fC\u0005\u0002*m\u0003\n\u00111\u0001\u0002$\u0005a2\r[1oO\u0016\f5\r\\!oIZ+'/\u001b4zI\u0011,g-Y;mi\u0012\"TCAB*U\u0011\t\u0019c!\u0016,\u0005\r]\u0003\u0003BB-\u0007Gj!aa\u0017\u000b\t\ru3qL\u0001\nk:\u001c\u0007.Z2lK\u0012TAa!\u0019\u0002f\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\r\u001541\f\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017!\u00058foJ+\u0017/^3ti\u000e{g\u000e^3yiRA\u0011QSB6\u0007[\u001ai\bC\u0004\u0002\u000ev\u0003\r!!\u0010\t\u000f\r=T\f1\u0001\u0004r\u0005i1\r\\5f]R\fE\r\u001a:fgN\u0004Baa\u001d\u0004z5\u00111Q\u000f\u0006\u0005\u0007o\ny(A\u0002oKRLAaa\u001f\u0004v\tY\u0011J\\3u\u0003\u0012$'/Z:t\u0011%\u0019y(\u0018I\u0001\u0002\u0004\u0019\t)\u0001\u0004ba&\\U-\u001f\t\u0005\u0007\u0007\u001bI)\u0004\u0002\u0004\u0006*!1qQA\u0002\u0003!\u0001(o\u001c;pG>d\u0017\u0002BBF\u0007\u000b\u0013q!\u00119j\u0017\u0016L8/A\u000eoK^\u0014V-];fgR\u001cuN\u001c;fqR$C-\u001a4bk2$HeM\u000b\u0003\u0007#SCa!!\u0004V\u0005I\u0011-\u001e;i_JL'0\u001a\u000b\u000b\u0003{\u001c9j!'\u0004\u001c\u000e}\u0005B\u00026`\u0001\u0004\t\t\u0006C\u0004\u0002\u0012~\u0003\r!!&\t\u000f\ruu\f1\u0001\u0003\u001a\u0006Iq\u000e]3sCRLwN\u001c\u0005\b\u0003Sy\u0006\u0019AA\u0012\u0003\u001d\tG\rZ!dYN$\u0002\"!\u0019\u0004&\u000e\u001d61\u0016\u0005\u0007U\u0002\u0004\r!!\u0015\t\u000f\r%\u0006\r1\u0001\u0004@\u0005!\u0011mY3t\u0011\u001d\u0019i\u000b\u0019a\u0001\u0003G\tqB]3t_V\u00148-\u001a)biR,'O\\\u0001\u000be\u0016lwN^3BG2\u001cH\u0003CA\u007f\u0007g\u001b)la.\t\r)\f\u0007\u0019AA)\u0011\u001d\u0019I+\u0019a\u0001\u0007\u007fAqa!,b\u0001\u0004\t\u0019#A\u0004hKR\f5\r\\:\u0015\r\r}2QXB`\u0011\u0019Q'\r1\u0001\u0002R!91Q\u00162A\u0002\u0005\rBCBBb\u0007\u0017\u001ci\r\u0005\u0004\u0002\\\n\u00156Q\u0019\t\u0004}\u000e\u001d\u0017bABe\u007f\nQ\u0011i\u00197CS:$\u0017N\\4\t\r)\u001c\u0007\u0019AA)\u0011\u001d\tii\u0019a\u0001\u0003{!Baa1\u0004R\"1!\u000e\u001aa\u0001\u0003#\nqA^1mS\u0012|\u0005\u000f\u0006\u0003\u0002~\u000e]\u0007bBBmK\u0002\u0007!\u0011T\u0001\u0003_B\fA\u0003\u001d:fa\u0006\u0014X\rR3gCVdGoQ8oM&<GCAAm\u00035\u0001(/\u001a9be\u0016\u001cuN\u001c4jOR!\u0011\u0011\\Br\u0011\u001d\u0019)o\u001aa\u0001\u0007O\fQ\u0001\\5oKN\u0004b!a\u0019\u0004j\u0006e\u0017\u0002BBv\u0003K\u0012Q!\u0011:sCf\u0004")
public class AclAuthorizerTest
extends ZooKeeperTestHarness {
    private final AccessControlEntry allowReadAcl = new AccessControlEntry(AclEntry$.MODULE$.WildcardPrincipalString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.ALLOW);
    private final AccessControlEntry allowWriteAcl = new AccessControlEntry(AclEntry$.MODULE$.WildcardPrincipalString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.WRITE, AclPermissionType.ALLOW);
    private final AccessControlEntry denyReadAcl = new AccessControlEntry(AclEntry$.MODULE$.WildcardPrincipalString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.DENY);
    private final ResourcePattern wildCardResource = new ResourcePattern(ResourceType.TOPIC, "*", PatternType.LITERAL);
    private final ResourcePattern prefixedResource = new ResourcePattern(ResourceType.TOPIC, "foo", PatternType.PREFIXED);
    private final ResourcePattern clusterResource = new ResourcePattern(ResourceType.CLUSTER, "kafka-cluster", PatternType.LITERAL);
    private final KafkaPrincipal wildcardPrincipal = SecurityUtils.parseKafkaPrincipal((String)AclEntry$.MODULE$.WildcardPrincipalString());
    private final AclAuthorizer aclAuthorizer = new AclAuthorizer();
    private final AclAuthorizer aclAuthorizer2 = new AclAuthorizer();
    private ResourcePattern resource;
    private final String superUsers;
    private final String username;
    private final KafkaPrincipal principal = new KafkaPrincipal("User", this.username());
    private final RequestContext requestContext = this.newRequestContext(this.principal(), InetAddress.getByName("192.168.0.1"), this.newRequestContext$default$3());
    private KafkaConfig config;
    private ZooKeeperClient zooKeeperClient;

    private AccessControlEntry allowReadAcl() {
        return this.allowReadAcl;
    }

    private AccessControlEntry allowWriteAcl() {
        return this.allowWriteAcl;
    }

    private AccessControlEntry denyReadAcl() {
        return this.denyReadAcl;
    }

    private ResourcePattern wildCardResource() {
        return this.wildCardResource;
    }

    private ResourcePattern prefixedResource() {
        return this.prefixedResource;
    }

    private ResourcePattern clusterResource() {
        return this.clusterResource;
    }

    private KafkaPrincipal wildcardPrincipal() {
        return this.wildcardPrincipal;
    }

    private AclAuthorizer aclAuthorizer() {
        return this.aclAuthorizer;
    }

    private AclAuthorizer aclAuthorizer2() {
        return this.aclAuthorizer2;
    }

    private ResourcePattern resource() {
        return this.resource;
    }

    private void resource_$eq(ResourcePattern x$1) {
        this.resource = x$1;
    }

    private String superUsers() {
        return this.superUsers;
    }

    private String username() {
        return this.username;
    }

    private KafkaPrincipal principal() {
        return this.principal;
    }

    private RequestContext requestContext() {
        return this.requestContext;
    }

    private KafkaConfig config() {
        return this.config;
    }

    private void config_$eq(KafkaConfig x$1) {
        this.config = x$1;
    }

    private ZooKeeperClient zooKeeperClient() {
        return this.zooKeeperClient;
    }

    private void zooKeeperClient_$eq(ZooKeeperClient x$1) {
        this.zooKeeperClient = x$1;
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.aclAuthorizer().maxUpdateRetries_$eq(Integer.MAX_VALUE);
        this.aclAuthorizer2().maxUpdateRetries_$eq(Integer.MAX_VALUE);
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20());
        props.put(AclAuthorizer$.MODULE$.SuperUsersProp(), this.superUsers());
        this.config_$eq(KafkaConfig$.MODULE$.fromProps(props));
        this.aclAuthorizer().configure(this.config().originals());
        this.aclAuthorizer2().configure(this.config().originals());
        this.resource_$eq(new ResourcePattern(ResourceType.TOPIC, new StringBuilder(4).append("foo-").append(UUID.randomUUID()).toString(), PatternType.LITERAL));
        this.zooKeeperClient_$eq(new ZooKeeperClient(this.zkConnect(), this.zkSessionTimeout(), this.zkConnectionTimeout(), this.zkMaxInFlightRequests(), Time.SYSTEM, "kafka.test", "AclAuthorizerTest"));
    }

    @Override
    @After
    public void tearDown() {
        this.aclAuthorizer().close();
        this.aclAuthorizer2().close();
        this.zooKeeperClient().close();
        super.tearDown();
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAuthorizeThrowsOnNonLiteralResource() {
        this.authorize(this.aclAuthorizer(), this.requestContext(), AclOperation.READ, new ResourcePattern(ResourceType.TOPIC, "something", PatternType.PREFIXED));
    }

    @Test
    public void testAuthorizeWithEmptyResourceName() {
        Assert.assertFalse((boolean)this.authorize(this.aclAuthorizer(), this.requestContext(), AclOperation.READ, new ResourcePattern(ResourceType.GROUP, "", PatternType.LITERAL)));
        this.addAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowReadAcl()}))), new ResourcePattern(ResourceType.GROUP, "*", PatternType.LITERAL));
        Assert.assertTrue((boolean)this.authorize(this.aclAuthorizer(), this.requestContext(), AclOperation.READ, new ResourcePattern(ResourceType.GROUP, "", PatternType.LITERAL)));
    }

    @Test
    public void testEmptyAclThrowsException() {
        ApiException e = (ApiException)((Object)Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.addAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowReadAcl()}))), new ResourcePattern(ResourceType.GROUP, "", PatternType.LITERAL)), ClassTag$.MODULE$.apply(ApiException.class), new Position("AclAuthorizerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 124)));
        Assert.assertTrue((String)new StringBuilder(21).append("Unexpected exception ").append((Object)e).toString(), (boolean)(e.getCause() instanceof IllegalArgumentException));
    }

    @Test
    public void testTopicAcl() {
        KafkaPrincipal user1 = new KafkaPrincipal("User", this.username());
        KafkaPrincipal user2 = new KafkaPrincipal("User", "rob");
        KafkaPrincipal user3 = new KafkaPrincipal("User", "batman");
        InetAddress host1 = InetAddress.getByName("192.168.1.1");
        InetAddress host2 = InetAddress.getByName("192.168.1.2");
        AccessControlEntry acl1 = new AccessControlEntry(user1.toString(), host1.getHostAddress(), AclOperation.READ, AclPermissionType.ALLOW);
        AccessControlEntry acl2 = new AccessControlEntry(user1.toString(), host2.getHostAddress(), AclOperation.READ, AclPermissionType.ALLOW);
        AccessControlEntry acl3 = new AccessControlEntry(user1.toString(), host1.getHostAddress(), AclOperation.READ, AclPermissionType.DENY);
        AccessControlEntry acl4 = new AccessControlEntry(user1.toString(), host1.getHostAddress(), AclOperation.WRITE, AclPermissionType.ALLOW);
        AccessControlEntry acl5 = new AccessControlEntry(user1.toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.DESCRIBE, AclPermissionType.ALLOW);
        AccessControlEntry acl6 = new AccessControlEntry(user2.toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.ALLOW);
        AccessControlEntry acl7 = new AccessControlEntry(user3.toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.WRITE, AclPermissionType.ALLOW);
        Set acls = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl1, acl2, acl3, acl4, acl5, acl6, acl7}));
        this.changeAclAndVerify((Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), (Set<AccessControlEntry>)acls, (Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), this.changeAclAndVerify$default$4());
        RequestContext host1Context = this.newRequestContext(user1, host1, this.newRequestContext$default$3());
        RequestContext host2Context = this.newRequestContext(user1, host2, this.newRequestContext$default$3());
        Assert.assertTrue((String)"User1 should have READ access from host2", (boolean)this.authorize(this.aclAuthorizer(), host2Context, AclOperation.READ, this.resource()));
        Assert.assertFalse((String)"User1 should not have READ access from host1 due to denyAcl", (boolean)this.authorize(this.aclAuthorizer(), host1Context, AclOperation.READ, this.resource()));
        Assert.assertTrue((String)"User1 should have WRITE access from host1", (boolean)this.authorize(this.aclAuthorizer(), host1Context, AclOperation.WRITE, this.resource()));
        Assert.assertFalse((String)"User1 should not have WRITE access from host2 as no allow acl is defined", (boolean)this.authorize(this.aclAuthorizer(), host2Context, AclOperation.WRITE, this.resource()));
        Assert.assertTrue((String)"User1 should not have DESCRIBE access from host1", (boolean)this.authorize(this.aclAuthorizer(), host1Context, AclOperation.DESCRIBE, this.resource()));
        Assert.assertTrue((String)"User1 should have DESCRIBE access from host2", (boolean)this.authorize(this.aclAuthorizer(), host2Context, AclOperation.DESCRIBE, this.resource()));
        Assert.assertFalse((String)"User1 should not have edit access from host1", (boolean)this.authorize(this.aclAuthorizer(), host1Context, AclOperation.ALTER, this.resource()));
        Assert.assertFalse((String)"User1 should not have edit access from host2", (boolean)this.authorize(this.aclAuthorizer(), host2Context, AclOperation.ALTER, this.resource()));
        RequestContext user2Context = this.newRequestContext(user2, host1, this.newRequestContext$default$3());
        RequestContext user3Context = this.newRequestContext(user3, host1, this.newRequestContext$default$3());
        Assert.assertTrue((String)"User2 should have DESCRIBE access from host1", (boolean)this.authorize(this.aclAuthorizer(), user2Context, AclOperation.DESCRIBE, this.resource()));
        Assert.assertTrue((String)"User3 should have DESCRIBE access from host2", (boolean)this.authorize(this.aclAuthorizer(), user3Context, AclOperation.DESCRIBE, this.resource()));
        Assert.assertTrue((String)"User2 should have READ access from host1", (boolean)this.authorize(this.aclAuthorizer(), user2Context, AclOperation.READ, this.resource()));
        Assert.assertTrue((String)"User3 should have WRITE access from host2", (boolean)this.authorize(this.aclAuthorizer(), user3Context, AclOperation.WRITE, this.resource()));
    }

    @Test
    public void testAllowAccessWithCustomPrincipal() {
        KafkaPrincipal user = new KafkaPrincipal("User", this.username());
        CustomPrincipal customUserPrincipal = new CustomPrincipal("User", this.username());
        InetAddress host1 = InetAddress.getByName("192.168.1.1");
        InetAddress host2 = InetAddress.getByName("192.168.1.2");
        AccessControlEntry acl1 = new AccessControlEntry(user.toString(), host1.getHostAddress(), AclOperation.READ, AclPermissionType.DENY);
        AccessControlEntry acl2 = new AccessControlEntry(user.toString(), host2.getHostAddress(), AclOperation.READ, AclPermissionType.ALLOW);
        Set acls = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl1, acl2}));
        this.changeAclAndVerify((Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), (Set<AccessControlEntry>)acls, (Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), this.changeAclAndVerify$default$4());
        RequestContext host1Context = this.newRequestContext(customUserPrincipal, host1, this.newRequestContext$default$3());
        RequestContext host2Context = this.newRequestContext(customUserPrincipal, host2, this.newRequestContext$default$3());
        Assert.assertTrue((String)"User1 should have READ access from host2", (boolean)this.authorize(this.aclAuthorizer(), host2Context, AclOperation.READ, this.resource()));
        Assert.assertFalse((String)"User1 should not have READ access from host1 due to denyAcl", (boolean)this.authorize(this.aclAuthorizer(), host1Context, AclOperation.READ, this.resource()));
    }

    @Test
    public void testDenyTakesPrecedence() {
        KafkaPrincipal user = new KafkaPrincipal("User", this.username());
        InetAddress host = InetAddress.getByName("192.168.2.1");
        RequestContext session = this.newRequestContext(user, host, this.newRequestContext$default$3());
        AccessControlEntry allowAll = new AccessControlEntry(AclEntry$.MODULE$.WildcardPrincipalString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.ALL, AclPermissionType.ALLOW);
        AccessControlEntry denyAcl = new AccessControlEntry(user.toString(), host.getHostAddress(), AclOperation.ALL, AclPermissionType.DENY);
        Set acls = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{allowAll, denyAcl}));
        this.changeAclAndVerify((Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), (Set<AccessControlEntry>)acls, (Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), this.changeAclAndVerify$default$4());
        Assert.assertFalse((String)"deny should take precedence over allow.", (boolean)this.authorize(this.aclAuthorizer(), session, AclOperation.READ, this.resource()));
    }

    @Test
    public void testAllowAllAccess() {
        AccessControlEntry allowAllAcl = new AccessControlEntry(AclEntry$.MODULE$.WildcardPrincipalString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.ALL, AclPermissionType.ALLOW);
        this.changeAclAndVerify((Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{allowAllAcl}))), (Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), this.changeAclAndVerify$default$4());
        RequestContext context = this.newRequestContext(new KafkaPrincipal("User", "random"), InetAddress.getByName("192.0.4.4"), this.newRequestContext$default$3());
        Assert.assertTrue((String)"allow all acl should allow access to all.", (boolean)this.authorize(this.aclAuthorizer(), context, AclOperation.READ, this.resource()));
    }

    @Test
    public void testSuperUserHasAccess() {
        AccessControlEntry denyAllAcl = new AccessControlEntry(AclEntry$.MODULE$.WildcardPrincipalString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.ALL, AclPermissionType.DENY);
        this.changeAclAndVerify((Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{denyAllAcl}))), (Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), this.changeAclAndVerify$default$4());
        RequestContext session1 = this.newRequestContext(new KafkaPrincipal("User", "superuser1"), InetAddress.getByName("192.0.4.4"), this.newRequestContext$default$3());
        RequestContext session2 = this.newRequestContext(new KafkaPrincipal("User", "superuser2"), InetAddress.getByName("192.0.4.4"), this.newRequestContext$default$3());
        Assert.assertTrue((String)"superuser always has access, no matter what acls.", (boolean)this.authorize(this.aclAuthorizer(), session1, AclOperation.READ, this.resource()));
        Assert.assertTrue((String)"superuser always has access, no matter what acls.", (boolean)this.authorize(this.aclAuthorizer(), session2, AclOperation.READ, this.resource()));
    }

    @Test
    public void testSuperUserWithCustomPrincipalHasAccess() {
        AccessControlEntry denyAllAcl = new AccessControlEntry(AclEntry$.MODULE$.WildcardPrincipalString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.ALL, AclPermissionType.DENY);
        this.changeAclAndVerify((Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{denyAllAcl}))), (Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), this.changeAclAndVerify$default$4());
        RequestContext session = this.newRequestContext(new CustomPrincipal("User", "superuser1"), InetAddress.getByName("192.0.4.4"), this.newRequestContext$default$3());
        Assert.assertTrue((String)"superuser with custom principal always has access, no matter what acls.", (boolean)this.authorize(this.aclAuthorizer(), session, AclOperation.READ, this.resource()));
    }

    @Test
    public void testWildCardAcls() {
        Assert.assertFalse((String)"when acls = [], authorizer should fail close.", (boolean)this.authorize(this.aclAuthorizer(), this.requestContext(), AclOperation.READ, this.resource()));
        KafkaPrincipal user1 = new KafkaPrincipal("User", this.username());
        InetAddress host1 = InetAddress.getByName("192.168.3.1");
        AccessControlEntry readAcl = new AccessControlEntry(user1.toString(), host1.getHostAddress(), AclOperation.READ, AclPermissionType.ALLOW);
        Set<AccessControlEntry> acls = this.changeAclAndVerify((Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{readAcl}))), (Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), this.wildCardResource());
        RequestContext host1Context = this.newRequestContext(user1, host1, this.newRequestContext$default$3());
        Assert.assertTrue((String)"User1 should have READ access from host1", (boolean)this.authorize(this.aclAuthorizer(), host1Context, AclOperation.READ, this.resource()));
        AccessControlEntry writeAcl = new AccessControlEntry(user1.toString(), host1.getHostAddress(), AclOperation.WRITE, AclPermissionType.ALLOW);
        this.changeAclAndVerify((Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{writeAcl}))), (Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), this.changeAclAndVerify$default$4());
        AccessControlEntry denyWriteOnWildCardResourceAcl = new AccessControlEntry(user1.toString(), host1.getHostAddress(), AclOperation.WRITE, AclPermissionType.DENY);
        this.changeAclAndVerify(acls, (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{denyWriteOnWildCardResourceAcl}))), (Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), this.wildCardResource());
        Assert.assertFalse((String)"User1 should not have WRITE access from host1", (boolean)this.authorize(this.aclAuthorizer(), host1Context, AclOperation.WRITE, this.resource()));
    }

    @Test
    public void testNoAclFound() {
        Assert.assertFalse((String)"when acls = [], authorizer should deny op.", (boolean)this.authorize(this.aclAuthorizer(), this.requestContext(), AclOperation.READ, this.resource()));
    }

    @Test
    public void testNoAclFoundOverride() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(1, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20());
        props.put(AclAuthorizer$.MODULE$.AllowEveryoneIfNoAclIsFoundProp(), "true");
        KafkaConfig cfg = KafkaConfig$.MODULE$.fromProps(props);
        try (AclAuthorizer testAuthorizer = new AclAuthorizer();){
            testAuthorizer.configure(cfg.originals());
            Assert.assertTrue((String)"when acls = null or [],  authorizer should allow op with allow.everyone = true.", (boolean)this.authorize(testAuthorizer, this.requestContext(), AclOperation.READ, this.resource()));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testAclManagementAPIs() {
        void $minus$greater$extension_$this;
        void $minus$greater$extension_$this2;
        void $minus$greater$extension_$this3;
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this4;
        void $minus$greater$extension_y2;
        void $minus$greater$extension_$this5;
        KafkaPrincipal user1 = new KafkaPrincipal("User", this.username());
        KafkaPrincipal user2 = new KafkaPrincipal("User", "bob");
        String host1 = "host1";
        String host2 = "host2";
        AccessControlEntry acl1 = new AccessControlEntry(user1.toString(), host1, AclOperation.READ, AclPermissionType.ALLOW);
        AccessControlEntry acl2 = new AccessControlEntry(user1.toString(), host1, AclOperation.WRITE, AclPermissionType.ALLOW);
        AccessControlEntry acl3 = new AccessControlEntry(user2.toString(), host2, AclOperation.READ, AclPermissionType.ALLOW);
        AccessControlEntry acl4 = new AccessControlEntry(user2.toString(), host2, AclOperation.WRITE, AclPermissionType.ALLOW);
        Set<AccessControlEntry> acls = this.changeAclAndVerify((Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl1, acl2, acl3, acl4}))), (Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), this.changeAclAndVerify$default$4());
        AccessControlEntry acl5 = new AccessControlEntry(user2.toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.ALLOW);
        acls = this.changeAclAndVerify(acls, (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl5}))), (Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), this.changeAclAndVerify$default$4());
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!AclAuthorizerTest.$anonfun$testAclManagementAPIs$1(this, acl1, acl2, user1)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                throw Assertions$.MODULE$.fail(AclAuthorizerTest.$anonfun$testAclManagementAPIs$3(), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 842));
            }
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension((long)waitUntilTrue_waitTimeMs, (long)waitUntilTrue_pause));
        }
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!AclAuthorizerTest.$anonfun$testAclManagementAPIs$4(this, acl3, acl4, acl5, user2)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                throw Assertions$.MODULE$.fail(AclAuthorizerTest.$anonfun$testAclManagementAPIs$6(), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 842));
            }
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension((long)waitUntilTrue_waitTimeMs, (long)waitUntilTrue_pause));
        }
        Tuple2[] tuple2Array = new Tuple2[4];
        GenTraversable genTraversable = Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{new AccessControlEntry(user2.toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.ALLOW)}));
        Object object = Predef$.MODULE$.ArrowAssoc((Object)new ResourcePattern(ResourceType.TOPIC, "*", PatternType.LITERAL));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this5, (Object)$minus$greater$extension_y2);
        GenTraversable genTraversable2 = Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{new AccessControlEntry(user2.toString(), host1, AclOperation.READ, AclPermissionType.ALLOW)}));
        Object object2 = Predef$.MODULE$.ArrowAssoc((Object)new ResourcePattern(ResourceType.CLUSTER, "*", PatternType.LITERAL));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[1] = new Tuple2((Object)$minus$greater$extension_$this4, (Object)$minus$greater$extension_y);
        Object object3 = Predef$.MODULE$.ArrowAssoc((Object)new ResourcePattern(ResourceType.GROUP, "*", PatternType.LITERAL));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[2] = new Tuple2((Object)$minus$greater$extension_$this3, acls);
        Object object4 = Predef$.MODULE$.ArrowAssoc((Object)new ResourcePattern(ResourceType.GROUP, "test-ConsumerGroup", PatternType.LITERAL));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[3] = new Tuple2((Object)$minus$greater$extension_$this2, acls);
        scala.collection.immutable.Map resourceToAcls = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array));
        resourceToAcls.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            ResourcePattern key = (ResourcePattern)x0$1._1();
            Set value = (Set)x0$1._2();
            Set<AccessControlEntry> set = this.changeAclAndVerify((Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), (Set<AccessControlEntry>)value, (Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), key);
            return set;
        });
        Object object5 = Predef$.MODULE$.ArrowAssoc((Object)this.resource());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        Set expectedAcls = ((TraversableOnce)resourceToAcls.$plus(new Tuple2((Object)$minus$greater$extension_$this, acls)).flatMap((Function1 & Serializable & scala.Serializable)x0$2 -> {
            if (x0$2 == null) {
                throw new MatchError(null);
            }
            ResourcePattern res = (ResourcePattern)x0$2._1();
            Set set = (Set)((Set)x0$2._2()).map((Function1 & Serializable & scala.Serializable)acl -> new AclBinding(res, acl), Set$.MODULE$.canBuildFrom());
            return set;
        }, Iterable$.MODULE$.canBuildFrom())).toSet();
        long l5 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l6 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!AclAuthorizerTest.$anonfun$testAclManagementAPIs$10(this, expectedAcls)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs) {
                throw Assertions$.MODULE$.fail(AclAuthorizerTest.$anonfun$testAclManagementAPIs$11(), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 842));
            }
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension((long)waitUntilTrue_waitTimeMs, (long)waitUntilTrue_pause));
        }
        this.changeAclAndVerify(acls, (Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl1, acl5}))), this.changeAclAndVerify$default$4());
        acls = null;
        this.removeAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), this.resource());
        TestUtils$.MODULE$.waitAndVerifyAcls((Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), (Authorizer)this.aclAuthorizer(), this.resource(), TestUtils$.MODULE$.waitAndVerifyAcls$default$4());
        Assert.assertTrue((!this.zkClient().resourceExists(this.resource()) ? 1 : 0) != 0);
        acls = this.changeAclAndVerify((Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl1}))), (Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), this.changeAclAndVerify$default$4());
        this.changeAclAndVerify(acls, (Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), acls, this.changeAclAndVerify$default$4());
        Assert.assertTrue((!this.zkClient().resourceExists(this.resource()) ? 1 : 0) != 0);
    }

    @Test
    public void testLoadCache() {
        KafkaPrincipal user1 = new KafkaPrincipal("User", this.username());
        AccessControlEntry acl1 = new AccessControlEntry(user1.toString(), "host-1", AclOperation.READ, AclPermissionType.ALLOW);
        Set acls = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl1}));
        this.addAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)acls, this.resource());
        KafkaPrincipal user2 = new KafkaPrincipal("User", "bob");
        ResourcePattern resource1 = new ResourcePattern(ResourceType.TOPIC, "test-2", PatternType.LITERAL);
        AccessControlEntry acl2 = new AccessControlEntry(user2.toString(), "host3", AclOperation.READ, AclPermissionType.DENY);
        Set acls1 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl2}));
        this.addAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)acls1, resource1);
        this.zkClient().deleteAclChangeNotifications();
        try (AclAuthorizer authorizer = new AclAuthorizer();){
            authorizer.configure(this.config().originals());
            Assert.assertEquals((Object)acls, this.getAcls(authorizer, this.resource()));
            Assert.assertEquals((Object)acls1, this.getAcls(authorizer, resource1));
        }
    }

    @Test
    public void testChangeListenerTiming() {
        Semaphore configureSemaphore = new Semaphore(0);
        Semaphore listenerSemaphore = new Semaphore(0);
        ExecutorService executor = Executors.newSingleThreadExecutor();
        AclAuthorizer aclAuthorizer3 = new AclAuthorizer(null, configureSemaphore, listenerSemaphore){
            private final Semaphore configureSemaphore$1;
            private final Semaphore listenerSemaphore$1;

            public void startZkChangeListeners() {
                this.configureSemaphore$1.release();
                this.listenerSemaphore$1.acquireUninterruptibly();
                super.startZkChangeListeners();
            }
            {
                this.configureSemaphore$1 = configureSemaphore$1;
                this.listenerSemaphore$1 = listenerSemaphore$1;
            }
        };
        try {
            Future<?> future = executor.submit(() -> aclAuthorizer3.configure(this.config().originals()));
            configureSemaphore.acquire();
            KafkaPrincipal user1 = new KafkaPrincipal("User", this.username());
            Set acls = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{new AccessControlEntry(user1.toString(), "host-1", AclOperation.READ, AclPermissionType.DENY)}));
            this.addAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)acls, this.resource());
            listenerSemaphore.release();
            future.get(10L, TimeUnit.SECONDS);
            Assert.assertEquals((Object)acls, this.getAcls(aclAuthorizer3, this.resource()));
        }
        finally {
            aclAuthorizer3.close();
            executor.shutdownNow();
        }
    }

    @Test
    public void testLocalConcurrentModificationOfResourceAcls() {
        ResourcePattern commonResource = new ResourcePattern(ResourceType.TOPIC, "test", PatternType.LITERAL);
        KafkaPrincipal user1 = new KafkaPrincipal("User", this.username());
        AccessControlEntry acl1 = new AccessControlEntry(user1.toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.ALLOW);
        KafkaPrincipal user2 = new KafkaPrincipal("User", "bob");
        AccessControlEntry acl2 = new AccessControlEntry(user2.toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.DENY);
        this.addAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl1}))), commonResource);
        this.addAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl2}))), commonResource);
        TestUtils$.MODULE$.waitAndVerifyAcls((Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl1, acl2}))), (Authorizer)this.aclAuthorizer(), commonResource, TestUtils$.MODULE$.waitAndVerifyAcls$default$4());
    }

    @Test
    public void testDistributedConcurrentModificationOfResourceAcls() {
        ResourcePattern commonResource = new ResourcePattern(ResourceType.TOPIC, "test", PatternType.LITERAL);
        KafkaPrincipal user1 = new KafkaPrincipal("User", this.username());
        AccessControlEntry acl1 = new AccessControlEntry(user1.toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.ALLOW);
        KafkaPrincipal user2 = new KafkaPrincipal("User", "bob");
        AccessControlEntry acl2 = new AccessControlEntry(user2.toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.DENY);
        this.addAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl1}))), commonResource);
        this.addAcls(this.aclAuthorizer2(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl2}))), commonResource);
        TestUtils$.MODULE$.waitAndVerifyAcls((Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl1, acl2}))), (Authorizer)this.aclAuthorizer(), commonResource, TestUtils$.MODULE$.waitAndVerifyAcls$default$4());
        TestUtils$.MODULE$.waitAndVerifyAcls((Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl1, acl2}))), (Authorizer)this.aclAuthorizer2(), commonResource, TestUtils$.MODULE$.waitAndVerifyAcls$default$4());
        KafkaPrincipal user3 = new KafkaPrincipal("User", "joe");
        AccessControlEntry acl3 = new AccessControlEntry(user3.toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.DENY);
        this.addAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl3}))), commonResource);
        boolean deleted = this.removeAcls(this.aclAuthorizer2(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl3}))), commonResource);
        Assert.assertTrue((String)"The authorizer should see a value that needs to be deleted", (boolean)deleted);
        TestUtils$.MODULE$.waitAndVerifyAcls((Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl1, acl2}))), (Authorizer)this.aclAuthorizer(), commonResource, TestUtils$.MODULE$.waitAndVerifyAcls$default$4());
        TestUtils$.MODULE$.waitAndVerifyAcls((Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl1, acl2}))), (Authorizer)this.aclAuthorizer2(), commonResource, TestUtils$.MODULE$.waitAndVerifyAcls$default$4());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testHighConcurrencyModificationOfResourceAcls() {
        void map_bf;
        void map_f;
        ResourcePattern commonResource = new ResourcePattern(ResourceType.TOPIC, "test", PatternType.LITERAL);
        int n = 0;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        Range.Inclusive inclusive = RichInt$.MODULE$.to$extension0(n, 50);
        CanBuildFrom canBuildFrom = IndexedSeq$.MODULE$.canBuildFrom();
        Function1 & Serializable & scala.Serializable intersect = (Function1 & Serializable & scala.Serializable)i -> AclAuthorizerTest.$anonfun$testHighConcurrencyModificationOfResourceAcls$1(BoxesRunTime.unboxToInt((Object)i));
        if (inclusive == null) {
            throw null;
        }
        IndexedSeq acls = (IndexedSeq)TraversableLike.map$((TraversableLike)inclusive, (Function1)map_f, (CanBuildFrom)map_bf);
        IndexedSeq concurrentFuctions = (IndexedSeq)acls.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            AccessControlEntry acl = (AccessControlEntry)x0$1._1();
            int aclId = x0$1._2$mcI$sp();
            Function0 & Serializable & scala.Serializable intersect = (Function0 & Serializable & scala.Serializable)() -> {
                if (aclId % 2 == 0) {
                    this.addAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl}))), commonResource);
                } else {
                    this.addAcls(this.aclAuthorizer2(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl}))), commonResource);
                }
                if (aclId % 10 == 0) {
                    return BoxesRunTime.boxToBoolean((boolean)this.removeAcls(this.aclAuthorizer2(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl}))), commonResource));
                }
                return BoxedUnit.UNIT;
            };
            return intersect;
        }, IndexedSeq$.MODULE$.canBuildFrom());
        Set expectedAcls = ((TraversableOnce)((TraversableLike)acls.filter((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)AclAuthorizerTest.$anonfun$testHighConcurrencyModificationOfResourceAcls$4(x0$2)))).map((Function1 & Serializable & scala.Serializable)x$1 -> (AccessControlEntry)x$1._1(), IndexedSeq$.MODULE$.canBuildFrom())).toSet();
        TestUtils$.MODULE$.assertConcurrent("Should support many concurrent calls", (Seq<Function0<Object>>)concurrentFuctions, 30000);
        TestUtils$.MODULE$.waitAndVerifyAcls((Set<AccessControlEntry>)expectedAcls, (Authorizer)this.aclAuthorizer(), commonResource, TestUtils$.MODULE$.waitAndVerifyAcls$default$4());
        TestUtils$.MODULE$.waitAndVerifyAcls((Set<AccessControlEntry>)expectedAcls, (Authorizer)this.aclAuthorizer2(), commonResource, TestUtils$.MODULE$.waitAndVerifyAcls$default$4());
    }

    @Test
    public void testAclInheritance() {
        this.testImplicationsOfAllow(AclOperation.ALL, (Set<AclOperation>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AclOperation[]{AclOperation.READ, AclOperation.WRITE, AclOperation.CREATE, AclOperation.DELETE, AclOperation.ALTER, AclOperation.DESCRIBE, AclOperation.CLUSTER_ACTION, AclOperation.DESCRIBE_CONFIGS, AclOperation.ALTER_CONFIGS, AclOperation.IDEMPOTENT_WRITE}))));
        this.testImplicationsOfDeny(AclOperation.ALL, (Set<AclOperation>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AclOperation[]{AclOperation.READ, AclOperation.WRITE, AclOperation.CREATE, AclOperation.DELETE, AclOperation.ALTER, AclOperation.DESCRIBE, AclOperation.CLUSTER_ACTION, AclOperation.DESCRIBE_CONFIGS, AclOperation.ALTER_CONFIGS, AclOperation.IDEMPOTENT_WRITE}))));
        this.testImplicationsOfAllow(AclOperation.READ, (Set<AclOperation>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AclOperation[]{AclOperation.DESCRIBE}))));
        this.testImplicationsOfAllow(AclOperation.WRITE, (Set<AclOperation>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AclOperation[]{AclOperation.DESCRIBE}))));
        this.testImplicationsOfAllow(AclOperation.DELETE, (Set<AclOperation>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AclOperation[]{AclOperation.DESCRIBE}))));
        this.testImplicationsOfAllow(AclOperation.ALTER, (Set<AclOperation>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AclOperation[]{AclOperation.DESCRIBE}))));
        this.testImplicationsOfDeny(AclOperation.DESCRIBE, (Set<AclOperation>)((Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$)));
        this.testImplicationsOfAllow(AclOperation.ALTER_CONFIGS, (Set<AclOperation>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AclOperation[]{AclOperation.DESCRIBE_CONFIGS}))));
        this.testImplicationsOfDeny(AclOperation.DESCRIBE_CONFIGS, (Set<AclOperation>)((Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$)));
    }

    private void testImplicationsOfAllow(AclOperation parentOp, Set<AclOperation> allowedOps) {
        KafkaPrincipal user = new KafkaPrincipal("User", this.username());
        InetAddress host = InetAddress.getByName("192.168.3.1");
        RequestContext hostContext = this.newRequestContext(user, host, this.newRequestContext$default$3());
        AccessControlEntry acl = new AccessControlEntry(user.toString(), AclEntry$.MODULE$.WildcardHost(), parentOp, AclPermissionType.ALLOW);
        this.addAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl}))), this.clusterResource());
        ArrayOps.ofRef foreach_this = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])AclOperation.values())).filterImpl((Function1 & Serializable & scala.Serializable)op -> BoxesRunTime.boxToBoolean((boolean)this.validOp(op)), false)));
        int foreach_len = foreach_this.length();
        for (int foreach_i = 0; foreach_i < foreach_len; ++foreach_i) {
            AclOperation aclOperation = (AclOperation)foreach_this.apply(foreach_i);
            AclAuthorizerTest.$anonfun$testImplicationsOfAllow$2(this, hostContext, allowedOps, parentOp, aclOperation);
        }
        this.removeAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl}))), this.clusterResource());
    }

    private void testImplicationsOfDeny(AclOperation parentOp, Set<AclOperation> deniedOps) {
        KafkaPrincipal user1 = new KafkaPrincipal("User", this.username());
        InetAddress host1 = InetAddress.getByName("192.168.3.1");
        RequestContext host1Context = this.newRequestContext(user1, host1, this.newRequestContext$default$3());
        Set acls = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{new AccessControlEntry(user1.toString(), AclEntry$.MODULE$.WildcardHost(), parentOp, AclPermissionType.DENY), new AccessControlEntry(user1.toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.ALL, AclPermissionType.ALLOW)}));
        this.addAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)acls, this.clusterResource());
        ArrayOps.ofRef foreach_this = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])AclOperation.values())).filterImpl((Function1 & Serializable & scala.Serializable)op -> BoxesRunTime.boxToBoolean((boolean)this.validOp(op)), false)));
        int foreach_len = foreach_this.length();
        for (int foreach_i = 0; foreach_i < foreach_len; ++foreach_i) {
            AclOperation aclOperation = (AclOperation)foreach_this.apply(foreach_i);
            AclAuthorizerTest.$anonfun$testImplicationsOfDeny$2(this, host1Context, deniedOps, parentOp, aclOperation);
        }
        this.removeAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)acls, this.clusterResource());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testHighConcurrencyDeletionOfResourceAcls() {
        void map_bf;
        void map_f;
        AccessControlEntry acl = new AccessControlEntry(new KafkaPrincipal("User", this.username()).toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.ALL, AclPermissionType.ALLOW);
        int n = 0;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        Range.Inclusive inclusive = RichInt$.MODULE$.to$extension0(n, 50);
        CanBuildFrom canBuildFrom = IndexedSeq$.MODULE$.canBuildFrom();
        Function1 & Serializable & scala.Serializable intersect = (Function1 & Serializable & scala.Serializable)x$2 -> AclAuthorizerTest.$anonfun$testHighConcurrencyDeletionOfResourceAcls$1(this, acl, BoxesRunTime.unboxToInt((Object)x$2));
        if (inclusive == null) {
            throw null;
        }
        IndexedSeq concurrentFuctions = (IndexedSeq)TraversableLike.map$((TraversableLike)inclusive, (Function1)map_f, (CanBuildFrom)map_bf);
        TestUtils$.MODULE$.assertConcurrent("Should support many concurrent calls", (Seq<Function0<Object>>)concurrentFuctions, 30000);
        TestUtils$.MODULE$.waitAndVerifyAcls((Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), (Authorizer)this.aclAuthorizer(), this.resource(), TestUtils$.MODULE$.waitAndVerifyAcls$default$4());
        TestUtils$.MODULE$.waitAndVerifyAcls((Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), (Authorizer)this.aclAuthorizer2(), this.resource(), TestUtils$.MODULE$.waitAndVerifyAcls$default$4());
    }

    @Test
    public void testAccessAllowedIfAllowAclExistsOnWildcardResource() {
        this.addAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowReadAcl()}))), this.wildCardResource());
        Assert.assertTrue((boolean)this.authorize(this.aclAuthorizer(), this.requestContext(), AclOperation.READ, this.resource()));
    }

    @Test
    public void testDeleteAclOnWildcardResource() {
        this.addAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowReadAcl(), this.allowWriteAcl()}))), this.wildCardResource());
        this.removeAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowReadAcl()}))), this.wildCardResource());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowWriteAcl()})), this.getAcls(this.aclAuthorizer(), this.wildCardResource()));
    }

    @Test
    public void testDeleteAllAclOnWildcardResource() {
        this.addAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowReadAcl()}))), this.wildCardResource());
        this.removeAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), this.wildCardResource());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().empty(), this.getAcls(this.aclAuthorizer()));
    }

    @Test
    public void testAccessAllowedIfAllowAclExistsOnPrefixedResource() {
        this.addAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowReadAcl()}))), this.prefixedResource());
        Assert.assertTrue((boolean)this.authorize(this.aclAuthorizer(), this.requestContext(), AclOperation.READ, this.resource()));
    }

    @Test
    public void testDeleteAclOnPrefixedResource() {
        this.addAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowReadAcl(), this.allowWriteAcl()}))), this.prefixedResource());
        this.removeAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowReadAcl()}))), this.prefixedResource());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowWriteAcl()})), this.getAcls(this.aclAuthorizer(), this.prefixedResource()));
    }

    @Test
    public void testDeleteAllAclOnPrefixedResource() {
        this.addAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowReadAcl(), this.allowWriteAcl()}))), this.prefixedResource());
        this.removeAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), this.prefixedResource());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().empty(), this.getAcls(this.aclAuthorizer()));
    }

    @Test
    public void testAddAclsOnLiteralResource() {
        this.addAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowReadAcl(), this.allowWriteAcl()}))), this.resource());
        this.addAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowWriteAcl(), this.denyReadAcl()}))), this.resource());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowReadAcl(), this.allowWriteAcl(), this.denyReadAcl()})), this.getAcls(this.aclAuthorizer(), this.resource()));
        Assert.assertEquals((Object)Predef$.MODULE$.Set().empty(), this.getAcls(this.aclAuthorizer(), this.wildCardResource()));
        Assert.assertEquals((Object)Predef$.MODULE$.Set().empty(), this.getAcls(this.aclAuthorizer(), this.prefixedResource()));
    }

    @Test
    public void testAddAclsOnWildcardResource() {
        this.addAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowReadAcl(), this.allowWriteAcl()}))), this.wildCardResource());
        this.addAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowWriteAcl(), this.denyReadAcl()}))), this.wildCardResource());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowReadAcl(), this.allowWriteAcl(), this.denyReadAcl()})), this.getAcls(this.aclAuthorizer(), this.wildCardResource()));
        Assert.assertEquals((Object)Predef$.MODULE$.Set().empty(), this.getAcls(this.aclAuthorizer(), this.resource()));
        Assert.assertEquals((Object)Predef$.MODULE$.Set().empty(), this.getAcls(this.aclAuthorizer(), this.prefixedResource()));
    }

    @Test
    public void testAddAclsOnPrefixedResource() {
        this.addAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowReadAcl(), this.allowWriteAcl()}))), this.prefixedResource());
        this.addAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowWriteAcl(), this.denyReadAcl()}))), this.prefixedResource());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowReadAcl(), this.allowWriteAcl(), this.denyReadAcl()})), this.getAcls(this.aclAuthorizer(), this.prefixedResource()));
        Assert.assertEquals((Object)Predef$.MODULE$.Set().empty(), this.getAcls(this.aclAuthorizer(), this.wildCardResource()));
        Assert.assertEquals((Object)Predef$.MODULE$.Set().empty(), this.getAcls(this.aclAuthorizer(), this.resource()));
    }

    @Test
    public void testAuthorizeWithPrefixedResource() {
        this.addAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.denyReadAcl()}))), new ResourcePattern(ResourceType.TOPIC, "a_other", PatternType.LITERAL));
        this.addAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.denyReadAcl()}))), new ResourcePattern(ResourceType.TOPIC, "a_other", PatternType.PREFIXED));
        this.addAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.denyReadAcl()}))), new ResourcePattern(ResourceType.TOPIC, new StringBuilder(4).append("foo-").append(UUID.randomUUID()).toString(), PatternType.PREFIXED));
        this.addAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.denyReadAcl()}))), new ResourcePattern(ResourceType.TOPIC, new StringBuilder(4).append("foo-").append(UUID.randomUUID()).toString(), PatternType.PREFIXED));
        this.addAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.denyReadAcl()}))), new ResourcePattern(ResourceType.TOPIC, new StringBuilder(8).append("foo-").append(UUID.randomUUID()).append("-zzz").toString(), PatternType.PREFIXED));
        this.addAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.denyReadAcl()}))), new ResourcePattern(ResourceType.TOPIC, new StringBuilder(5).append("fooo-").append(UUID.randomUUID()).toString(), PatternType.PREFIXED));
        this.addAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.denyReadAcl()}))), new ResourcePattern(ResourceType.TOPIC, new StringBuilder(3).append("fo-").append(UUID.randomUUID()).toString(), PatternType.PREFIXED));
        this.addAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.denyReadAcl()}))), new ResourcePattern(ResourceType.TOPIC, new StringBuilder(4).append("fop-").append(UUID.randomUUID()).toString(), PatternType.PREFIXED));
        this.addAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.denyReadAcl()}))), new ResourcePattern(ResourceType.TOPIC, new StringBuilder(4).append("fon-").append(UUID.randomUUID()).toString(), PatternType.PREFIXED));
        this.addAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.denyReadAcl()}))), new ResourcePattern(ResourceType.TOPIC, "fon-", PatternType.PREFIXED));
        this.addAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.denyReadAcl()}))), new ResourcePattern(ResourceType.TOPIC, "z_other", PatternType.PREFIXED));
        this.addAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.denyReadAcl()}))), new ResourcePattern(ResourceType.TOPIC, "z_other", PatternType.LITERAL));
        this.addAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowReadAcl()}))), this.prefixedResource());
        Assert.assertTrue((boolean)this.authorize(this.aclAuthorizer(), this.requestContext(), AclOperation.READ, this.resource()));
    }

    @Test
    public void testSingleCharacterResourceAcls() {
        this.addAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowReadAcl()}))), new ResourcePattern(ResourceType.TOPIC, "f", PatternType.LITERAL));
        Assert.assertTrue((boolean)this.authorize(this.aclAuthorizer(), this.requestContext(), AclOperation.READ, new ResourcePattern(ResourceType.TOPIC, "f", PatternType.LITERAL)));
        Assert.assertFalse((boolean)this.authorize(this.aclAuthorizer(), this.requestContext(), AclOperation.READ, new ResourcePattern(ResourceType.TOPIC, "foo", PatternType.LITERAL)));
        this.addAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowReadAcl()}))), new ResourcePattern(ResourceType.TOPIC, "_", PatternType.PREFIXED));
        Assert.assertTrue((boolean)this.authorize(this.aclAuthorizer(), this.requestContext(), AclOperation.READ, new ResourcePattern(ResourceType.TOPIC, "_foo", PatternType.LITERAL)));
        Assert.assertTrue((boolean)this.authorize(this.aclAuthorizer(), this.requestContext(), AclOperation.READ, new ResourcePattern(ResourceType.TOPIC, "_", PatternType.LITERAL)));
        Assert.assertFalse((boolean)this.authorize(this.aclAuthorizer(), this.requestContext(), AclOperation.READ, new ResourcePattern(ResourceType.TOPIC, "foo_", PatternType.LITERAL)));
    }

    @Test
    public void testGetAclsPrincipal() {
        AccessControlEntry aclOnSpecificPrincipal = new AccessControlEntry(this.principal().toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.WRITE, AclPermissionType.ALLOW);
        this.addAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{aclOnSpecificPrincipal}))), this.resource());
        Assert.assertEquals((String)"acl on specific should not be returned for wildcard request", (long)0L, (long)this.getAcls(this.aclAuthorizer(), this.wildcardPrincipal()).size());
        Assert.assertEquals((String)"acl on specific should be returned for specific request", (long)1L, (long)this.getAcls(this.aclAuthorizer(), this.principal()).size());
        Assert.assertEquals((String)"acl on specific should be returned for different principal instance", (long)1L, (long)this.getAcls(this.aclAuthorizer(), new KafkaPrincipal(this.principal().getPrincipalType(), this.principal().getName())).size());
        this.removeAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), this.resource());
        AccessControlEntry aclOnWildcardPrincipal = new AccessControlEntry(AclEntry$.MODULE$.WildcardPrincipalString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.WRITE, AclPermissionType.ALLOW);
        this.addAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{aclOnWildcardPrincipal}))), this.resource());
        Assert.assertEquals((String)"acl on wildcard should be returned for wildcard request", (long)1L, (long)this.getAcls(this.aclAuthorizer(), this.wildcardPrincipal()).size());
        Assert.assertEquals((String)"acl on wildcard should not be returned for specific request", (long)0L, (long)this.getAcls(this.aclAuthorizer(), this.principal()).size());
    }

    @Test
    public void testAclsFilter() {
        ResourcePattern resource1 = new ResourcePattern(ResourceType.TOPIC, new StringBuilder(4).append("foo-").append(UUID.randomUUID()).toString(), PatternType.LITERAL);
        ResourcePattern resource2 = new ResourcePattern(ResourceType.TOPIC, new StringBuilder(4).append("bar-").append(UUID.randomUUID()).toString(), PatternType.LITERAL);
        ResourcePattern prefixedResource = new ResourcePattern(ResourceType.TOPIC, "bar-", PatternType.PREFIXED);
        AclBinding acl1 = new AclBinding(resource1, new AccessControlEntry(this.principal().toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.ALLOW));
        AclBinding acl2 = new AclBinding(resource1, new AccessControlEntry(this.principal().toString(), "192.168.0.1", AclOperation.WRITE, AclPermissionType.ALLOW));
        AclBinding acl3 = new AclBinding(resource2, new AccessControlEntry(this.principal().toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.DESCRIBE, AclPermissionType.ALLOW));
        AclBinding acl4 = new AclBinding(prefixedResource, new AccessControlEntry(this.wildcardPrincipal().toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.ALLOW));
        this.aclAuthorizer().createAcls((AuthorizableRequestContext)this.requestContext(), (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)acl1, (List)new .colon.colon((Object)acl2, (List)new .colon.colon((Object)acl3, (List)new .colon.colon((Object)acl4, (List)Nil$.MODULE$))))).asJava());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AclBinding[]{acl1, acl2, acl3, acl4})), (Object)((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(this.aclAuthorizer().acls(AclBindingFilter.ANY)).asScala()).toSet());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AclBinding[]{acl1, acl2})), (Object)((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(this.aclAuthorizer().acls(new AclBindingFilter(resource1.toFilter(), AccessControlEntryFilter.ANY))).asScala()).toSet());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AclBinding[]{acl4})), (Object)((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(this.aclAuthorizer().acls(new AclBindingFilter(prefixedResource.toFilter(), AccessControlEntryFilter.ANY))).asScala()).toSet());
        AclBindingFilter matchingFilter = new AclBindingFilter(new ResourcePatternFilter(ResourceType.ANY, resource2.name(), PatternType.MATCH), AccessControlEntryFilter.ANY);
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AclBinding[]{acl3, acl4})), (Object)((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(this.aclAuthorizer().acls(matchingFilter)).asScala()).toSet());
        .colon.colon filters = new .colon.colon((Object)matchingFilter, (List)new .colon.colon((Object)acl1.toFilter(), (List)new .colon.colon((Object)new AclBindingFilter(resource2.toFilter(), AccessControlEntryFilter.ANY), (List)new .colon.colon((Object)new AclBindingFilter(new ResourcePatternFilter(ResourceType.TOPIC, "baz", PatternType.ANY), AccessControlEntryFilter.ANY), (List)Nil$.MODULE$))));
        Buffer deleteResults = (Buffer)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(this.aclAuthorizer().deleteAcls((AuthorizableRequestContext)this.requestContext(), (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)filters).asJava())).asScala()).map((Function1 & Serializable & scala.Serializable)x$3 -> (AclDeleteResult)x$3.toCompletableFuture().get(), Buffer$.MODULE$.canBuildFrom());
        Assert.assertEquals((Object)List$.MODULE$.empty(), (Object)deleteResults.filter((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)AclAuthorizerTest.$anonfun$testAclsFilter$2(x$4))));
        Range range = filters.indices();
        if (range == null) {
            throw null;
        }
        Range foreach$mVc$sp_this = range;
        if (!foreach$mVc$sp_this.isEmpty()) {
            int foreach$mVc$sp_i = foreach$mVc$sp_this.start();
            while (true) {
                AclAuthorizerTest.$anonfun$testAclsFilter$3(deleteResults, foreach$mVc$sp_i);
                if (foreach$mVc$sp_i == foreach$mVc$sp_this.scala$collection$immutable$Range$$lastElement()) break;
                foreach$mVc$sp_i += foreach$mVc$sp_this.step();
            }
        }
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AclBinding[]{acl3, acl4})), (Object)((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(((AclDeleteResult)deleteResults.apply(0)).aclBindingDeleteResults()).asScala()).map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.aclBinding(), scala.collection.Iterable$.MODULE$.canBuildFrom())).toSet());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AclBinding[]{acl1})), (Object)((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(((AclDeleteResult)deleteResults.apply(1)).aclBindingDeleteResults()).asScala()).map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.aclBinding(), scala.collection.Iterable$.MODULE$.canBuildFrom())).toSet());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(((AclDeleteResult)deleteResults.apply(2)).aclBindingDeleteResults()).asScala()).map((Function1 & Serializable & scala.Serializable)x$8 -> x$8.aclBinding(), scala.collection.Iterable$.MODULE$.canBuildFrom())).toSet());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(((AclDeleteResult)deleteResults.apply(3)).aclBindingDeleteResults()).asScala()).map((Function1 & Serializable & scala.Serializable)x$9 -> x$9.aclBinding(), scala.collection.Iterable$.MODULE$.canBuildFrom())).toSet());
    }

    @Test
    public void testThrowsOnAddPrefixedAclIfInterBrokerProtocolVersionTooLow() {
        this.givenAuthorizerWithProtocolVersion((Option<ApiVersion>)Option$.MODULE$.apply((Object)KAFKA_2_0_IV0$.MODULE$));
        ApiException e = (ApiException)((Object)Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.addAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.denyReadAcl()}))), new ResourcePattern(ResourceType.TOPIC, "z_other", PatternType.PREFIXED)), ClassTag$.MODULE$.apply(ApiException.class), new Position("AclAuthorizerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 729)));
        Assert.assertTrue((String)new StringBuilder(21).append("Unexpected exception ").append((Object)e).toString(), (boolean)(e.getCause() instanceof UnsupportedVersionException));
    }

    @Test
    public void testWritesExtendedAclChangeEventIfInterBrokerProtocolNotSet() {
        this.givenAuthorizerWithProtocolVersion((Option<ApiVersion>)Option$.MODULE$.empty());
        ResourcePattern resource = new ResourcePattern(ResourceType.TOPIC, "z_other", PatternType.PREFIXED);
        String expected = new String(ZkAclStore$.MODULE$.apply(PatternType.PREFIXED).changeStore().createChangeNode(resource).bytes(), StandardCharsets.UTF_8);
        this.addAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.denyReadAcl()}))), resource);
        String actual = this.getAclChangeEventAsString(PatternType.PREFIXED);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testWritesExtendedAclChangeEventWhenInterBrokerProtocolAtLeastKafkaV2() {
        this.givenAuthorizerWithProtocolVersion((Option<ApiVersion>)Option$.MODULE$.apply((Object)KAFKA_2_0_IV1$.MODULE$));
        ResourcePattern resource = new ResourcePattern(ResourceType.TOPIC, "z_other", PatternType.PREFIXED);
        String expected = new String(ZkAclStore$.MODULE$.apply(PatternType.PREFIXED).changeStore().createChangeNode(resource).bytes(), StandardCharsets.UTF_8);
        this.addAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.denyReadAcl()}))), resource);
        String actual = this.getAclChangeEventAsString(PatternType.PREFIXED);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testWritesLiteralWritesLiteralAclChangeEventWhenInterBrokerProtocolLessThanKafkaV2eralAclChangesForOlderProtocolVersions() {
        this.givenAuthorizerWithProtocolVersion((Option<ApiVersion>)Option$.MODULE$.apply((Object)KAFKA_2_0_IV0$.MODULE$));
        ResourcePattern resource = new ResourcePattern(ResourceType.TOPIC, "z_other", PatternType.LITERAL);
        String expected = new String(ZkAclStore$.MODULE$.apply(PatternType.LITERAL).changeStore().createChangeNode(resource).bytes(), StandardCharsets.UTF_8);
        this.addAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.denyReadAcl()}))), resource);
        String actual = this.getAclChangeEventAsString(PatternType.LITERAL);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testWritesLiteralAclChangeEventWhenInterBrokerProtocolIsKafkaV2() {
        this.givenAuthorizerWithProtocolVersion((Option<ApiVersion>)Option$.MODULE$.apply((Object)KAFKA_2_0_IV1$.MODULE$));
        ResourcePattern resource = new ResourcePattern(ResourceType.TOPIC, "z_other", PatternType.LITERAL);
        String expected = new String(ZkAclStore$.MODULE$.apply(PatternType.LITERAL).changeStore().createChangeNode(resource).bytes(), StandardCharsets.UTF_8);
        this.addAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.denyReadAcl()}))), resource);
        String actual = this.getAclChangeEventAsString(PatternType.LITERAL);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testAuthorizerNoZkConfig() {
        Properties noTlsProps = Kafka$.MODULE$.getPropsFromArgs((String[])((Object[])new String[]{this.prepareDefaultConfig()}));
        Assert.assertEquals((Object)None$.MODULE$, (Object)AclAuthorizer$.MODULE$.zkClientConfigFromKafkaConfigAndMap(KafkaConfig$.MODULE$.fromProps(noTlsProps), (scala.collection.mutable.Map)Map$.MODULE$.apply(((MapLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter((Map)noTlsProps).asScala()).toSeq())));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testAuthorizerZkConfigFromKafkaConfigWithDefaults() {
        void $minus$greater$extension_$this;
        void $minus$greater$extension_$this2;
        void $minus$greater$extension_$this3;
        void $minus$greater$extension_$this4;
        void $minus$greater$extension_$this5;
        void $minus$greater$extension_$this6;
        void $minus$greater$extension_$this7;
        void $minus$greater$extension_$this8;
        void $minus$greater$extension_$this9;
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this10;
        void $minus$greater$extension_y2;
        void $minus$greater$extension_$this11;
        Properties props = new Properties();
        String kafkaValue = "kafkaValue";
        Tuple2[] tuple2Array = new Tuple2[11];
        String string = "somewhere";
        Object object = Predef$.MODULE$.ArrowAssoc((Object)"zookeeper.connect");
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this11, (Object)$minus$greater$extension_y2);
        String string2 = "true";
        Object object2 = Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ZkSslClientEnableProp());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[1] = new Tuple2((Object)$minus$greater$extension_$this10, (Object)$minus$greater$extension_y);
        Object object3 = Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ZkClientCnxnSocketProp());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[2] = new Tuple2((Object)$minus$greater$extension_$this9, (Object)kafkaValue);
        Object object4 = Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ZkSslKeyStoreLocationProp());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[3] = new Tuple2((Object)$minus$greater$extension_$this8, (Object)kafkaValue);
        Object object5 = Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ZkSslKeyStorePasswordProp());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[4] = new Tuple2((Object)$minus$greater$extension_$this7, (Object)kafkaValue);
        Object object6 = Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ZkSslKeyStoreTypeProp());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[5] = new Tuple2((Object)$minus$greater$extension_$this6, (Object)kafkaValue);
        Object object7 = Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ZkSslTrustStoreLocationProp());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[6] = new Tuple2((Object)$minus$greater$extension_$this5, (Object)kafkaValue);
        Object object8 = Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ZkSslTrustStorePasswordProp());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[7] = new Tuple2((Object)$minus$greater$extension_$this4, (Object)kafkaValue);
        Object object9 = Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ZkSslTrustStoreTypeProp());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[8] = new Tuple2((Object)$minus$greater$extension_$this3, (Object)kafkaValue);
        Object object10 = Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ZkSslEnabledProtocolsProp());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[9] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)kafkaValue);
        Object object11 = Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ZkSslCipherSuitesProp());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[10] = new Tuple2((Object)$minus$greater$extension_$this, (Object)kafkaValue);
        scala.collection.immutable.Map configs = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array));
        configs.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            String key = (String)x0$1._1();
            String value = (String)x0$1._2();
            Object object = props.put(key, value.toString());
            return object;
        });
        Option zkClientConfig = AclAuthorizer$.MODULE$.zkClientConfigFromKafkaConfigAndMap(KafkaConfig$.MODULE$.fromProps(props), (scala.collection.mutable.Map)Map$.MODULE$.apply(configs.toSeq()));
        Assert.assertTrue((boolean)zkClientConfig.isDefined());
        KafkaConfig$.MODULE$.ZkSslConfigToSystemPropertyMap().keys().foreach((Function1 & Serializable & scala.Serializable)prop -> {
            AclAuthorizerTest.$anonfun$testAuthorizerZkConfigFromKafkaConfigWithDefaults$2(zkClientConfig, kafkaValue, prop);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testAuthorizerZkConfigFromKafkaConfig() {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        void $minus$greater$extension_y2;
        void $minus$greater$extension_$this2;
        void $minus$greater$extension_y3;
        void $minus$greater$extension_$this3;
        void $minus$greater$extension_$this4;
        void $minus$greater$extension_$this5;
        void $minus$greater$extension_$this6;
        void $minus$greater$extension_$this7;
        void $minus$greater$extension_$this8;
        void $minus$greater$extension_$this9;
        void $minus$greater$extension_$this10;
        void $minus$greater$extension_$this11;
        void $minus$greater$extension_$this12;
        void $minus$greater$extension_$this13;
        void $minus$greater$extension_y4;
        void $minus$greater$extension_$this14;
        void $minus$greater$extension_y5;
        void $minus$greater$extension_$this15;
        Properties props = new Properties();
        String kafkaValue = "kafkaValue";
        Tuple2[] tuple2Array = new Tuple2[15];
        String string = "somewhere";
        Object object = Predef$.MODULE$.ArrowAssoc((Object)"zookeeper.connect");
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this15, (Object)$minus$greater$extension_y5);
        String string2 = "true";
        Object object2 = Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ZkSslClientEnableProp());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[1] = new Tuple2((Object)$minus$greater$extension_$this14, (Object)$minus$greater$extension_y4);
        Object object3 = Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ZkClientCnxnSocketProp());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[2] = new Tuple2((Object)$minus$greater$extension_$this13, (Object)kafkaValue);
        Object object4 = Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ZkSslKeyStoreLocationProp());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[3] = new Tuple2((Object)$minus$greater$extension_$this12, (Object)kafkaValue);
        Object object5 = Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ZkSslKeyStorePasswordProp());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[4] = new Tuple2((Object)$minus$greater$extension_$this11, (Object)kafkaValue);
        Object object6 = Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ZkSslKeyStoreTypeProp());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[5] = new Tuple2((Object)$minus$greater$extension_$this10, (Object)kafkaValue);
        Object object7 = Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ZkSslTrustStoreLocationProp());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[6] = new Tuple2((Object)$minus$greater$extension_$this9, (Object)kafkaValue);
        Object object8 = Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ZkSslTrustStorePasswordProp());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[7] = new Tuple2((Object)$minus$greater$extension_$this8, (Object)kafkaValue);
        Object object9 = Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ZkSslTrustStoreTypeProp());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[8] = new Tuple2((Object)$minus$greater$extension_$this7, (Object)kafkaValue);
        Object object10 = Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ZkSslProtocolProp());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[9] = new Tuple2((Object)$minus$greater$extension_$this6, (Object)kafkaValue);
        Object object11 = Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ZkSslEnabledProtocolsProp());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[10] = new Tuple2((Object)$minus$greater$extension_$this5, (Object)kafkaValue);
        Object object12 = Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ZkSslCipherSuitesProp());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[11] = new Tuple2((Object)$minus$greater$extension_$this4, (Object)kafkaValue);
        String string3 = "HTTPS";
        Object object13 = Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ZkSslEndpointIdentificationAlgorithmProp());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[12] = new Tuple2((Object)$minus$greater$extension_$this3, (Object)$minus$greater$extension_y3);
        String string4 = "false";
        Object object14 = Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ZkSslCrlEnableProp());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[13] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y2);
        String string5 = "false";
        Object object15 = Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ZkSslOcspEnableProp());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[14] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        scala.collection.immutable.Map configs = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array));
        configs.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            String key = (String)x0$1._1();
            String value = (String)x0$1._2();
            Object object = props.put(key, value.toString());
            return object;
        });
        Option zkClientConfig = AclAuthorizer$.MODULE$.zkClientConfigFromKafkaConfigAndMap(KafkaConfig$.MODULE$.fromProps(props), (scala.collection.mutable.Map)Map$.MODULE$.apply(configs.toSeq()));
        Assert.assertTrue((boolean)zkClientConfig.isDefined());
        KafkaConfig$.MODULE$.ZkSslConfigToSystemPropertyMap().keys().foreach((Function1 & Serializable & scala.Serializable)prop -> {
            AclAuthorizerTest.$anonfun$testAuthorizerZkConfigFromKafkaConfig$2(zkClientConfig, kafkaValue, prop);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testAuthorizerZkConfigFromPrefixOverrides() {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        void $minus$greater$extension_y2;
        void $minus$greater$extension_$this2;
        void $minus$greater$extension_y3;
        void $minus$greater$extension_$this3;
        void $minus$greater$extension_$this4;
        void $minus$greater$extension_$this5;
        void $minus$greater$extension_$this6;
        void $minus$greater$extension_$this7;
        void $minus$greater$extension_$this8;
        void $minus$greater$extension_$this9;
        void $minus$greater$extension_$this10;
        void $minus$greater$extension_$this11;
        void $minus$greater$extension_$this12;
        void $minus$greater$extension_$this13;
        void $minus$greater$extension_y4;
        void $minus$greater$extension_$this14;
        void $minus$greater$extension_y5;
        void $minus$greater$extension_$this15;
        void $minus$greater$extension_y6;
        void $minus$greater$extension_$this16;
        void $minus$greater$extension_y7;
        void $minus$greater$extension_$this17;
        void $minus$greater$extension_$this18;
        void $minus$greater$extension_$this19;
        void $minus$greater$extension_$this20;
        void $minus$greater$extension_$this21;
        void $minus$greater$extension_$this22;
        void $minus$greater$extension_$this23;
        void $minus$greater$extension_$this24;
        void $minus$greater$extension_$this25;
        void $minus$greater$extension_$this26;
        void $minus$greater$extension_$this27;
        void $minus$greater$extension_y8;
        void $minus$greater$extension_$this28;
        void $minus$greater$extension_y9;
        void $minus$greater$extension_$this29;
        Properties props = new Properties();
        String kafkaValue = "kafkaValue";
        String prefixedValue = "prefixedValue";
        String prefix = "authorizer.";
        Tuple2[] tuple2Array = new Tuple2[29];
        String string = "somewhere";
        Object object = Predef$.MODULE$.ArrowAssoc((Object)"zookeeper.connect");
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this29, (Object)$minus$greater$extension_y9);
        String string2 = "false";
        Object object2 = Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ZkSslClientEnableProp());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[1] = new Tuple2((Object)$minus$greater$extension_$this28, (Object)$minus$greater$extension_y8);
        Object object3 = Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ZkClientCnxnSocketProp());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[2] = new Tuple2((Object)$minus$greater$extension_$this27, (Object)kafkaValue);
        Object object4 = Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ZkSslKeyStoreLocationProp());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[3] = new Tuple2((Object)$minus$greater$extension_$this26, (Object)kafkaValue);
        Object object5 = Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ZkSslKeyStorePasswordProp());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[4] = new Tuple2((Object)$minus$greater$extension_$this25, (Object)kafkaValue);
        Object object6 = Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ZkSslKeyStoreTypeProp());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[5] = new Tuple2((Object)$minus$greater$extension_$this24, (Object)kafkaValue);
        Object object7 = Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ZkSslTrustStoreLocationProp());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[6] = new Tuple2((Object)$minus$greater$extension_$this23, (Object)kafkaValue);
        Object object8 = Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ZkSslTrustStorePasswordProp());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[7] = new Tuple2((Object)$minus$greater$extension_$this22, (Object)kafkaValue);
        Object object9 = Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ZkSslTrustStoreTypeProp());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[8] = new Tuple2((Object)$minus$greater$extension_$this21, (Object)kafkaValue);
        Object object10 = Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ZkSslProtocolProp());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[9] = new Tuple2((Object)$minus$greater$extension_$this20, (Object)kafkaValue);
        Object object11 = Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ZkSslEnabledProtocolsProp());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[10] = new Tuple2((Object)$minus$greater$extension_$this19, (Object)kafkaValue);
        Object object12 = Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ZkSslCipherSuitesProp());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[11] = new Tuple2((Object)$minus$greater$extension_$this18, (Object)kafkaValue);
        String string3 = "HTTPS";
        Object object13 = Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ZkSslEndpointIdentificationAlgorithmProp());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[12] = new Tuple2((Object)$minus$greater$extension_$this17, (Object)$minus$greater$extension_y7);
        String string4 = "false";
        Object object14 = Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ZkSslCrlEnableProp());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[13] = new Tuple2((Object)$minus$greater$extension_$this16, (Object)$minus$greater$extension_y6);
        String string5 = "false";
        Object object15 = Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ZkSslOcspEnableProp());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[14] = new Tuple2((Object)$minus$greater$extension_$this15, (Object)$minus$greater$extension_y5);
        String string6 = "true";
        Object object16 = Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(0).append(prefix).append(KafkaConfig$.MODULE$.ZkSslClientEnableProp()).toString());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[15] = new Tuple2((Object)$minus$greater$extension_$this14, (Object)$minus$greater$extension_y4);
        Object object17 = Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(0).append(prefix).append(KafkaConfig$.MODULE$.ZkClientCnxnSocketProp()).toString());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[16] = new Tuple2((Object)$minus$greater$extension_$this13, (Object)prefixedValue);
        Object object18 = Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(0).append(prefix).append(KafkaConfig$.MODULE$.ZkSslKeyStoreLocationProp()).toString());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[17] = new Tuple2((Object)$minus$greater$extension_$this12, (Object)prefixedValue);
        Object object19 = Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(0).append(prefix).append(KafkaConfig$.MODULE$.ZkSslKeyStorePasswordProp()).toString());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[18] = new Tuple2((Object)$minus$greater$extension_$this11, (Object)prefixedValue);
        Object object20 = Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(0).append(prefix).append(KafkaConfig$.MODULE$.ZkSslKeyStoreTypeProp()).toString());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[19] = new Tuple2((Object)$minus$greater$extension_$this10, (Object)prefixedValue);
        Object object21 = Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(0).append(prefix).append(KafkaConfig$.MODULE$.ZkSslTrustStoreLocationProp()).toString());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[20] = new Tuple2((Object)$minus$greater$extension_$this9, (Object)prefixedValue);
        Object object22 = Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(0).append(prefix).append(KafkaConfig$.MODULE$.ZkSslTrustStorePasswordProp()).toString());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[21] = new Tuple2((Object)$minus$greater$extension_$this8, (Object)prefixedValue);
        Object object23 = Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(0).append(prefix).append(KafkaConfig$.MODULE$.ZkSslTrustStoreTypeProp()).toString());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[22] = new Tuple2((Object)$minus$greater$extension_$this7, (Object)prefixedValue);
        Object object24 = Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(0).append(prefix).append(KafkaConfig$.MODULE$.ZkSslProtocolProp()).toString());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[23] = new Tuple2((Object)$minus$greater$extension_$this6, (Object)prefixedValue);
        Object object25 = Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(0).append(prefix).append(KafkaConfig$.MODULE$.ZkSslEnabledProtocolsProp()).toString());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[24] = new Tuple2((Object)$minus$greater$extension_$this5, (Object)prefixedValue);
        Object object26 = Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(0).append(prefix).append(KafkaConfig$.MODULE$.ZkSslCipherSuitesProp()).toString());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[25] = new Tuple2((Object)$minus$greater$extension_$this4, (Object)prefixedValue);
        String string7 = "";
        Object object27 = Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(0).append(prefix).append(KafkaConfig$.MODULE$.ZkSslEndpointIdentificationAlgorithmProp()).toString());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[26] = new Tuple2((Object)$minus$greater$extension_$this3, (Object)$minus$greater$extension_y3);
        String string8 = "true";
        Object object28 = Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(0).append(prefix).append(KafkaConfig$.MODULE$.ZkSslCrlEnableProp()).toString());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[27] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y2);
        String string9 = "true";
        Object object29 = Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(0).append(prefix).append(KafkaConfig$.MODULE$.ZkSslOcspEnableProp()).toString());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[28] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        scala.collection.immutable.Map configs = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array));
        configs.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            String key = (String)x0$1._1();
            String value = (String)x0$1._2();
            Object object = props.put(key, value.toString());
            return object;
        });
        Option zkClientConfig = AclAuthorizer$.MODULE$.zkClientConfigFromKafkaConfigAndMap(KafkaConfig$.MODULE$.fromProps(props), (scala.collection.mutable.Map)Map$.MODULE$.apply(configs.toSeq()));
        Assert.assertTrue((boolean)zkClientConfig.isDefined());
        KafkaConfig$.MODULE$.ZkSslConfigToSystemPropertyMap().keys().foreach((Function1 & Serializable & scala.Serializable)prop -> {
            AclAuthorizerTest.$anonfun$testAuthorizerZkConfigFromPrefixOverrides$2(zkClientConfig, prefixedValue, prop);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testCreateDeleteTiming() {
        ResourcePattern literalResource = new ResourcePattern(ResourceType.TOPIC, new StringBuilder(4).append("foo-").append(UUID.randomUUID()).toString(), PatternType.LITERAL);
        ResourcePattern prefixedResource = new ResourcePattern(ResourceType.TOPIC, "bar-", PatternType.PREFIXED);
        ResourcePattern wildcardResource = new ResourcePattern(ResourceType.TOPIC, "*", PatternType.LITERAL);
        AccessControlEntry ace = new AccessControlEntry(this.principal().toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.ALLOW);
        Semaphore updateSemaphore = new Semaphore(1);
        try (AclAuthorizer deleteAuthorizer = new AclAuthorizer(null, updateSemaphore){
            private final Semaphore updateSemaphore$1;

            public void processAclChangeNotification(ResourcePattern resource) {
                this.updateSemaphore$1.acquire();
                try {
                    super.processAclChangeNotification(resource);
                }
                finally {
                    this.updateSemaphore$1.release();
                }
            }
            {
                this.updateSemaphore$1 = updateSemaphore$1;
            }
        };){
            deleteAuthorizer.configure(this.config().originals());
            .colon.colon foreach_these = new .colon.colon((Object)literalResource, (List)new .colon.colon((Object)prefixedResource, (List)new .colon.colon((Object)wildcardResource, (List)Nil$.MODULE$)));
            while (!foreach_these.isEmpty()) {
                ResourcePattern resourcePattern = (ResourcePattern)foreach_these.head();
                AclAuthorizerTest.$anonfun$testCreateDeleteTiming$9(this, deleteAuthorizer, updateSemaphore, ace, resourcePattern);
                foreach_these = (List)foreach_these.tail();
            }
        }
    }

    private void givenAuthorizerWithProtocolVersion(Option<ApiVersion> protocolVersion) {
        this.aclAuthorizer().close();
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20());
        props.put(AclAuthorizer$.MODULE$.SuperUsersProp(), this.superUsers());
        if (protocolVersion == null) {
            throw null;
        }
        if (!protocolVersion.isEmpty()) {
            ApiVersion apiVersion = (ApiVersion)protocolVersion.get();
            props.put(KafkaConfig$.MODULE$.InterBrokerProtocolVersionProp(), apiVersion.toString());
        }
        this.config_$eq(KafkaConfig$.MODULE$.fromProps(props));
        this.aclAuthorizer().configure(this.config().originals());
    }

    private String getAclChangeEventAsString(PatternType patternType) {
        ZkAclStore store = ZkAclStore$.MODULE$.apply(patternType);
        GetChildrenResponse children = (GetChildrenResponse)this.zooKeeperClient().handleRequest((AsyncRequest)new GetChildrenRequest(store.changeStore().aclChangePath(), true, GetChildrenRequest$.MODULE$.apply$default$3()));
        children.maybeThrow();
        Assert.assertEquals((String)"Expecting 1 change event", (long)1L, (long)children.children().size());
        GetDataResponse data = (GetDataResponse)this.zooKeeperClient().handleRequest((AsyncRequest)new GetDataRequest(new StringBuilder(1).append(store.changeStore().aclChangePath()).append("/").append(children.children().head()).toString(), GetDataRequest$.MODULE$.apply$default$2()));
        data.maybeThrow();
        return new String(data.data(), StandardCharsets.UTF_8);
    }

    private Set<AccessControlEntry> changeAclAndVerify(Set<AccessControlEntry> originalAcls, Set<AccessControlEntry> addedAcls, Set<AccessControlEntry> removedAcls, ResourcePattern resource) {
        Set acls = originalAcls;
        if (addedAcls.nonEmpty()) {
            this.addAcls(this.aclAuthorizer(), addedAcls, resource);
            acls = (Set)originalAcls.$plus$plus(addedAcls);
        }
        if (removedAcls.nonEmpty()) {
            this.removeAcls(this.aclAuthorizer(), removedAcls, resource);
            acls = (Set)acls.$minus$minus(removedAcls);
        }
        TestUtils$.MODULE$.waitAndVerifyAcls((Set<AccessControlEntry>)acls, (Authorizer)this.aclAuthorizer(), resource, TestUtils$.MODULE$.waitAndVerifyAcls$default$4());
        return acls;
    }

    private ResourcePattern changeAclAndVerify$default$4() {
        return this.resource();
    }

    private RequestContext newRequestContext(KafkaPrincipal principal, InetAddress clientAddress, ApiKeys apiKey) {
        SecurityProtocol securityProtocol = SecurityProtocol.SASL_PLAINTEXT;
        RequestHeader header = new RequestHeader(apiKey, 2, "", 1);
        return new RequestContext(header, "", clientAddress, principal, ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol), securityProtocol, ClientInformation.EMPTY);
    }

    private ApiKeys newRequestContext$default$3() {
        return ApiKeys.PRODUCE;
    }

    private boolean authorize(AclAuthorizer authorizer, RequestContext requestContext, AclOperation operation, ResourcePattern resource) {
        Action action = new Action(operation, resource, 1, true, true);
        Object object = ((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(authorizer.authorize((AuthorizableRequestContext)requestContext, (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)action, (List)Nil$.MODULE$)).asJava())).asScala()).head();
        AuthorizationResult authorizationResult = AuthorizationResult.ALLOWED;
        return !(object != null ? !object.equals(authorizationResult) : authorizationResult != null);
    }

    private void addAcls(AclAuthorizer authorizer, Set<AccessControlEntry> aces, ResourcePattern resourcePattern) {
        Set bindings = (Set)aces.map((Function1 & Serializable & scala.Serializable)ace -> new AclBinding(resourcePattern, ace), Set$.MODULE$.canBuildFrom());
        ((IterableLike)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(authorizer.createAcls((AuthorizableRequestContext)this.requestContext(), (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)bindings.toList()).asJava())).asScala()).map((Function1 & Serializable & scala.Serializable)x$14 -> (AclCreateResult)x$14.toCompletableFuture().get(), Buffer$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)result -> {
            AclAuthorizerTest.$anonfun$addAcls$3(result);
            return BoxedUnit.UNIT;
        });
    }

    private boolean removeAcls(AclAuthorizer authorizer, Set<AccessControlEntry> aces, ResourcePattern resourcePattern) {
        Set bindings = aces.isEmpty() ? (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AclBindingFilter[]{new AclBindingFilter(resourcePattern.toFilter(), AccessControlEntryFilter.ANY)})) : (Set)aces.map((Function1 & Serializable & scala.Serializable)ace -> new AclBinding(resourcePattern, ace).toFilter(), Set$.MODULE$.canBuildFrom());
        return ((IterableLike)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(authorizer.deleteAcls((AuthorizableRequestContext)this.requestContext(), (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)bindings.toList()).asJava())).asScala()).map((Function1 & Serializable & scala.Serializable)x$15 -> (AclDeleteResult)x$15.toCompletableFuture().get(), Buffer$.MODULE$.canBuildFrom())).forall((Function1 & Serializable & scala.Serializable)result -> BoxesRunTime.boxToBoolean((boolean)AclAuthorizerTest.$anonfun$removeAcls$3(result)));
    }

    private Set<AccessControlEntry> getAcls(AclAuthorizer authorizer, ResourcePattern resourcePattern) {
        return (Set)((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(authorizer.acls(new AclBindingFilter(resourcePattern.toFilter(), AccessControlEntryFilter.ANY))).asScala()).toSet().map((Function1 & Serializable & scala.Serializable)x$16 -> x$16.entry(), Set$.MODULE$.canBuildFrom());
    }

    private Set<AclBinding> getAcls(AclAuthorizer authorizer, KafkaPrincipal principal) {
        AclBindingFilter filter = new AclBindingFilter(ResourcePatternFilter.ANY, new AccessControlEntryFilter(principal.toString(), null, AclOperation.ANY, AclPermissionType.ANY));
        return ((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(authorizer.acls(filter)).asScala()).toSet();
    }

    private Set<AclBinding> getAcls(AclAuthorizer authorizer) {
        return ((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(authorizer.acls(AclBindingFilter.ANY)).asScala()).toSet();
    }

    private boolean validOp(AclOperation op) {
        AclOperation aclOperation = op;
        AclOperation aclOperation2 = AclOperation.ANY;
        if (aclOperation == null ? aclOperation2 != null : !aclOperation.equals(aclOperation2)) {
            AclOperation aclOperation3 = op;
            AclOperation aclOperation4 = AclOperation.UNKNOWN;
            if (aclOperation3 == null ? aclOperation4 != null : !aclOperation3.equals(aclOperation4)) {
                return true;
            }
        }
        return false;
    }

    private String prepareDefaultConfig() {
        return this.prepareConfig((String[])((Object[])new String[]{"broker.id=1", "zookeeper.connect=somewhere"}));
    }

    private String prepareConfig(String[] lines) {
        String string;
        File file = File.createTempFile("kafkatest", ".properties");
        file.deleteOnExit();
        try (OutputStream writer = Files.newOutputStream(file.toPath(), new OpenOption[0]);){
            ArrayOps.ofRef foreach_this = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])lines));
            int foreach_len = foreach_this.length();
            for (int foreach_i = 0; foreach_i < foreach_len; ++foreach_i) {
                String string2 = (String)foreach_this.apply(foreach_i);
                AclAuthorizerTest.$anonfun$prepareConfig$1(writer, string2);
            }
            string = file.getAbsolutePath();
        }
        return string;
    }

    public static final /* synthetic */ boolean $anonfun$testAclManagementAPIs$1(AclAuthorizerTest $this, AccessControlEntry acl1$1, AccessControlEntry acl2$1, KafkaPrincipal user1$1) {
        Object object = ((SetLike)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl1$1, acl2$1}))).map((Function1 & Serializable & scala.Serializable)acl -> new AclBinding($this.resource(), acl), Set$.MODULE$.canBuildFrom());
        Set<AclBinding> set = $this.getAcls($this.aclAuthorizer(), user1$1);
        return !(object != null ? !object.equals(set) : set != null);
    }

    public static final /* synthetic */ String $anonfun$testAclManagementAPIs$3() {
        return "changes not propagated in timeout period";
    }

    public static final /* synthetic */ boolean $anonfun$testAclManagementAPIs$4(AclAuthorizerTest $this, AccessControlEntry acl3$1, AccessControlEntry acl4$1, AccessControlEntry acl5$1, KafkaPrincipal user2$1) {
        Object object = ((SetLike)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl3$1, acl4$1, acl5$1}))).map((Function1 & Serializable & scala.Serializable)acl -> new AclBinding($this.resource(), acl), Set$.MODULE$.canBuildFrom());
        Set<AclBinding> set = $this.getAcls($this.aclAuthorizer(), user2$1);
        return !(object != null ? !object.equals(set) : set != null);
    }

    public static final /* synthetic */ String $anonfun$testAclManagementAPIs$6() {
        return "changes not propagated in timeout period";
    }

    public static final /* synthetic */ boolean $anonfun$testAclManagementAPIs$10(AclAuthorizerTest $this, Set expectedAcls$1) {
        Set set = expectedAcls$1;
        Set<AclBinding> set2 = $this.getAcls($this.aclAuthorizer());
        return !(set != null ? !set.equals(set2) : set2 != null);
    }

    public static final /* synthetic */ String $anonfun$testAclManagementAPIs$11() {
        return "changes not propagated in timeout period.";
    }

    public static final /* synthetic */ Tuple2 $anonfun$testHighConcurrencyModificationOfResourceAcls$1(int i) {
        KafkaPrincipal useri = new KafkaPrincipal("User", ((Object)BoxesRunTime.boxToInteger((int)i)).toString());
        return new Tuple2((Object)new AccessControlEntry(useri.toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.ALLOW), (Object)BoxesRunTime.boxToInteger((int)i));
    }

    public static final /* synthetic */ boolean $anonfun$testHighConcurrencyModificationOfResourceAcls$4(Tuple2 x0$2) {
        if (x0$2 == null) {
            throw new MatchError(null);
        }
        boolean bl = x0$2._2$mcI$sp() % 10 != 0;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$testImplicationsOfAllow$2(AclAuthorizerTest $this, RequestContext hostContext$1, Set allowedOps$1, AclOperation parentOp$1, AclOperation op) {
        boolean authorized;
        block3: {
            block2: {
                authorized = $this.authorize($this.aclAuthorizer(), hostContext$1, op, $this.clusterResource());
                if (allowedOps$1.contains((Object)op)) break block2;
                AclOperation aclOperation = op;
                if (aclOperation != null ? !aclOperation.equals(parentOp$1) : parentOp$1 != null) break block3;
            }
            Assert.assertTrue((String)new StringBuilder(26).append("ALLOW ").append(parentOp$1).append(" should imply ALLOW ").append(op).toString(), (boolean)authorized);
            return;
        }
        Assert.assertFalse((String)new StringBuilder(30).append("ALLOW ").append(parentOp$1).append(" should not imply ALLOW ").append(op).toString(), (boolean)authorized);
    }

    public static final /* synthetic */ void $anonfun$testImplicationsOfDeny$2(AclAuthorizerTest $this, RequestContext host1Context$1, Set deniedOps$1, AclOperation parentOp$2, AclOperation op) {
        boolean authorized;
        block3: {
            block2: {
                authorized = $this.authorize($this.aclAuthorizer(), host1Context$1, op, $this.clusterResource());
                if (deniedOps$1.contains((Object)op)) break block2;
                AclOperation aclOperation = op;
                if (aclOperation != null ? !aclOperation.equals(parentOp$2) : parentOp$2 != null) break block3;
            }
            Assert.assertFalse((String)new StringBuilder(24).append("DENY ").append(parentOp$2).append(" should imply DENY ").append(op).toString(), (boolean)authorized);
            return;
        }
        Assert.assertTrue((String)new StringBuilder(28).append("DENY ").append(parentOp$2).append(" should not imply DENY ").append(op).toString(), (boolean)authorized);
    }

    public static final /* synthetic */ Function0 $anonfun$testHighConcurrencyDeletionOfResourceAcls$1(AclAuthorizerTest $this, AccessControlEntry acl$2, int x$2) {
        return (JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            $this.addAcls($this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl$2}))), $this.resource());
            return $this.removeAcls($this.aclAuthorizer2(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl$2}))), $this.resource());
        };
    }

    public static final /* synthetic */ boolean $anonfun$testAclsFilter$2(AclDeleteResult x$4) {
        return x$4.exception().isPresent();
    }

    public static final /* synthetic */ boolean $anonfun$testAclsFilter$4(AclDeleteResult.AclBindingDeleteResult x$5) {
        return x$5.exception().isPresent();
    }

    public static final /* synthetic */ void $anonfun$testAclsFilter$3(Buffer deleteResults$1, int i) {
        Assert.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)((TraversableOnce)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(((AclDeleteResult)deleteResults$1.apply(i)).aclBindingDeleteResults()).asScala()).toSet().filter((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)AclAuthorizerTest.$anonfun$testAclsFilter$4(x$5))));
    }

    public static final /* synthetic */ String $anonfun$testAuthorizerZkConfigFromKafkaConfigWithDefaults$3() {
        return "<None>";
    }

    public static final /* synthetic */ String $anonfun$testAuthorizerZkConfigFromKafkaConfigWithDefaults$4() {
        return "<None>";
    }

    public static final /* synthetic */ String $anonfun$testAuthorizerZkConfigFromKafkaConfigWithDefaults$5() {
        return "<None>";
    }

    public static final /* synthetic */ String $anonfun$testAuthorizerZkConfigFromKafkaConfigWithDefaults$6() {
        return "<None>";
    }

    public static final /* synthetic */ void $anonfun$testAuthorizerZkConfigFromKafkaConfigWithDefaults$2(Option zkClientConfig$1, String kafkaValue$1, String prop) {
        boolean bl;
        boolean bl2;
        String string = KafkaConfig$.MODULE$.ZkSslClientEnableProp();
        if (!(string != null ? !string.equals(prop) : prop != null)) {
            bl2 = true;
        } else {
            String string2 = KafkaConfig$.MODULE$.ZkSslEndpointIdentificationAlgorithmProp();
            bl2 = !(string2 != null ? !string2.equals(prop) : prop != null);
        }
        if (bl2) {
            Option option = KafkaConfig$.MODULE$.getZooKeeperClientProperty((ZKClientConfig)zkClientConfig$1.get(), prop);
            if (option == null) {
                throw null;
            }
            Option getOrElse_this = option;
            Object object = getOrElse_this.isEmpty() ? AclAuthorizerTest.$anonfun$testAuthorizerZkConfigFromKafkaConfigWithDefaults$3() : getOrElse_this.get();
            Assert.assertEquals((Object)"true", (Object)object);
            return;
        }
        String string3 = KafkaConfig$.MODULE$.ZkSslCrlEnableProp();
        if (!(string3 != null ? !string3.equals(prop) : prop != null)) {
            bl = true;
        } else {
            String string4 = KafkaConfig$.MODULE$.ZkSslOcspEnableProp();
            bl = !(string4 != null ? !string4.equals(prop) : prop != null);
        }
        if (bl) {
            Option option = KafkaConfig$.MODULE$.getZooKeeperClientProperty((ZKClientConfig)zkClientConfig$1.get(), prop);
            if (option == null) {
                throw null;
            }
            Option getOrElse_this = option;
            Object object = getOrElse_this.isEmpty() ? AclAuthorizerTest.$anonfun$testAuthorizerZkConfigFromKafkaConfigWithDefaults$4() : getOrElse_this.get();
            Assert.assertEquals((Object)"false", (Object)object);
            return;
        }
        String string5 = KafkaConfig$.MODULE$.ZkSslProtocolProp();
        if (!(string5 != null ? !string5.equals(prop) : prop != null)) {
            Option option = KafkaConfig$.MODULE$.getZooKeeperClientProperty((ZKClientConfig)zkClientConfig$1.get(), prop);
            if (option == null) {
                throw null;
            }
            Option getOrElse_this = option;
            Object object = getOrElse_this.isEmpty() ? AclAuthorizerTest.$anonfun$testAuthorizerZkConfigFromKafkaConfigWithDefaults$5() : getOrElse_this.get();
            Assert.assertEquals((Object)"TLSv1.2", (Object)object);
            return;
        }
        Option option = KafkaConfig$.MODULE$.getZooKeeperClientProperty((ZKClientConfig)zkClientConfig$1.get(), prop);
        if (option == null) {
            throw null;
        }
        Option getOrElse_this = option;
        Object object = getOrElse_this.isEmpty() ? AclAuthorizerTest.$anonfun$testAuthorizerZkConfigFromKafkaConfigWithDefaults$6() : getOrElse_this.get();
        Assert.assertEquals((Object)kafkaValue$1, (Object)object);
    }

    public static final /* synthetic */ String $anonfun$testAuthorizerZkConfigFromKafkaConfig$3() {
        return "<None>";
    }

    public static final /* synthetic */ String $anonfun$testAuthorizerZkConfigFromKafkaConfig$4() {
        return "<None>";
    }

    public static final /* synthetic */ String $anonfun$testAuthorizerZkConfigFromKafkaConfig$5() {
        return "<None>";
    }

    public static final /* synthetic */ void $anonfun$testAuthorizerZkConfigFromKafkaConfig$2(Option zkClientConfig$2, String kafkaValue$2, String prop) {
        boolean bl;
        boolean bl2;
        String string = KafkaConfig$.MODULE$.ZkSslClientEnableProp();
        if (!(string != null ? !string.equals(prop) : prop != null)) {
            bl2 = true;
        } else {
            String string2 = KafkaConfig$.MODULE$.ZkSslEndpointIdentificationAlgorithmProp();
            bl2 = !(string2 != null ? !string2.equals(prop) : prop != null);
        }
        if (bl2) {
            Option option = KafkaConfig$.MODULE$.getZooKeeperClientProperty((ZKClientConfig)zkClientConfig$2.get(), prop);
            if (option == null) {
                throw null;
            }
            Option getOrElse_this = option;
            Object object = getOrElse_this.isEmpty() ? AclAuthorizerTest.$anonfun$testAuthorizerZkConfigFromKafkaConfig$3() : getOrElse_this.get();
            Assert.assertEquals((Object)"true", (Object)object);
            return;
        }
        String string3 = KafkaConfig$.MODULE$.ZkSslCrlEnableProp();
        if (!(string3 != null ? !string3.equals(prop) : prop != null)) {
            bl = true;
        } else {
            String string4 = KafkaConfig$.MODULE$.ZkSslOcspEnableProp();
            bl = !(string4 != null ? !string4.equals(prop) : prop != null);
        }
        if (bl) {
            Option option = KafkaConfig$.MODULE$.getZooKeeperClientProperty((ZKClientConfig)zkClientConfig$2.get(), prop);
            if (option == null) {
                throw null;
            }
            Option getOrElse_this = option;
            Object object = getOrElse_this.isEmpty() ? AclAuthorizerTest.$anonfun$testAuthorizerZkConfigFromKafkaConfig$4() : getOrElse_this.get();
            Assert.assertEquals((Object)"false", (Object)object);
            return;
        }
        Option option = KafkaConfig$.MODULE$.getZooKeeperClientProperty((ZKClientConfig)zkClientConfig$2.get(), prop);
        if (option == null) {
            throw null;
        }
        Option getOrElse_this = option;
        Object object = getOrElse_this.isEmpty() ? AclAuthorizerTest.$anonfun$testAuthorizerZkConfigFromKafkaConfig$5() : getOrElse_this.get();
        Assert.assertEquals((Object)kafkaValue$2, (Object)object);
    }

    public static final /* synthetic */ String $anonfun$testAuthorizerZkConfigFromPrefixOverrides$3() {
        return "<None>";
    }

    public static final /* synthetic */ String $anonfun$testAuthorizerZkConfigFromPrefixOverrides$4() {
        return "<None>";
    }

    public static final /* synthetic */ String $anonfun$testAuthorizerZkConfigFromPrefixOverrides$5() {
        return "<None>";
    }

    public static final /* synthetic */ void $anonfun$testAuthorizerZkConfigFromPrefixOverrides$2(Option zkClientConfig$3, String prefixedValue$1, String prop) {
        boolean bl;
        String string = KafkaConfig$.MODULE$.ZkSslClientEnableProp();
        if (!(string != null ? !string.equals(prop) : prop != null)) {
            bl = true;
        } else {
            String string2 = KafkaConfig$.MODULE$.ZkSslCrlEnableProp();
            if (!(string2 != null ? !string2.equals(prop) : prop != null)) {
                bl = true;
            } else {
                String string3 = KafkaConfig$.MODULE$.ZkSslOcspEnableProp();
                bl = !(string3 != null ? !string3.equals(prop) : prop != null);
            }
        }
        if (bl) {
            Option option = KafkaConfig$.MODULE$.getZooKeeperClientProperty((ZKClientConfig)zkClientConfig$3.get(), prop);
            if (option == null) {
                throw null;
            }
            Option getOrElse_this = option;
            Object object = getOrElse_this.isEmpty() ? AclAuthorizerTest.$anonfun$testAuthorizerZkConfigFromPrefixOverrides$3() : getOrElse_this.get();
            Assert.assertEquals((Object)"true", (Object)object);
            return;
        }
        String string4 = KafkaConfig$.MODULE$.ZkSslEndpointIdentificationAlgorithmProp();
        if (!(string4 != null ? !string4.equals(prop) : prop != null)) {
            Option option = KafkaConfig$.MODULE$.getZooKeeperClientProperty((ZKClientConfig)zkClientConfig$3.get(), prop);
            if (option == null) {
                throw null;
            }
            Option getOrElse_this = option;
            Object object = getOrElse_this.isEmpty() ? AclAuthorizerTest.$anonfun$testAuthorizerZkConfigFromPrefixOverrides$4() : getOrElse_this.get();
            Assert.assertEquals((Object)"false", (Object)object);
            return;
        }
        Option option = KafkaConfig$.MODULE$.getZooKeeperClientProperty((ZKClientConfig)zkClientConfig$3.get(), prop);
        if (option == null) {
            throw null;
        }
        Option getOrElse_this = option;
        Object object = getOrElse_this.isEmpty() ? AclAuthorizerTest.$anonfun$testAuthorizerZkConfigFromPrefixOverrides$5() : getOrElse_this.get();
        Assert.assertEquals((Object)prefixedValue$1, (Object)object);
    }

    private final AclBinding createAcl$1(AclAuthorizer createAuthorizer, ResourcePattern resource, AccessControlEntry ace$1) {
        AclBinding acl = new AclBinding(resource, ace$1);
        ((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(createAuthorizer.createAcls((AuthorizableRequestContext)this.requestContext(), Collections.singletonList(acl))).asScala()).foreach((Function1 & Serializable & scala.Serializable)x$10 -> (AclCreateResult)x$10.toCompletableFuture().get(15L, TimeUnit.SECONDS));
        return acl;
    }

    private final List deleteAcl$1(AclAuthorizer deleteAuthorizer, ResourcePattern resource, PatternType deletePatternType) {
        AclBindingFilter filter = new AclBindingFilter(new ResourcePatternFilter(resource.resourceType(), resource.name(), deletePatternType), AccessControlEntryFilter.ANY);
        return ((TraversableOnce)((TraversableLike)((TraversableLike)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(deleteAuthorizer.deleteAcls((AuthorizableRequestContext)this.requestContext(), Collections.singletonList(filter))).asScala()).map((Function1 & Serializable & scala.Serializable)x$11 -> (AclDeleteResult)x$11.toCompletableFuture().get(15L, TimeUnit.SECONDS), Buffer$.MODULE$.canBuildFrom())).flatMap((Function1 & Serializable & scala.Serializable)x$12 -> (Iterable)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(x$12.aclBindingDeleteResults()).asScala(), Buffer$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$13 -> x$13.aclBinding(), Buffer$.MODULE$.canBuildFrom())).toList();
    }

    private static final List listAcls$1(AclAuthorizer authorizer) {
        return ((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(authorizer.acls(AclBindingFilter.ANY)).asScala()).toList();
    }

    public static final /* synthetic */ boolean $anonfun$testCreateDeleteTiming$5(AclAuthorizer deleteAuthorizer$1) {
        return AclAuthorizerTest.listAcls$1(deleteAuthorizer$1).nonEmpty();
    }

    public static final /* synthetic */ String $anonfun$testCreateDeleteTiming$6() {
        return "ACL not propagated";
    }

    public static final /* synthetic */ boolean $anonfun$testCreateDeleteTiming$7(AclAuthorizer deleteAuthorizer$1) {
        return AclAuthorizerTest.listAcls$1(deleteAuthorizer$1).isEmpty();
    }

    public static final /* synthetic */ String $anonfun$testCreateDeleteTiming$8() {
        return "ACL delete not propagated";
    }

    /*
     * WARNING - void declaration
     */
    private final void verifyCreateDeleteAcl$1(AclAuthorizer deleteAuthorizer, ResourcePattern resource, PatternType deletePatternType, Semaphore updateSemaphore$1, AccessControlEntry ace$1) {
        updateSemaphore$1.acquire();
        Assert.assertEquals((Object)List$.MODULE$.empty(), (Object)AclAuthorizerTest.listAcls$1(deleteAuthorizer));
        AclBinding acl = this.createAcl$1(this.aclAuthorizer(), resource, ace$1);
        List deleted = this.deleteAcl$1(deleteAuthorizer, resource, deletePatternType);
        PatternType patternType = deletePatternType;
        PatternType patternType2 = PatternType.MATCH;
        if (patternType == null ? patternType2 != null : !patternType.equals(patternType2)) {
            Assert.assertEquals((Object)new .colon.colon((Object)acl, (List)Nil$.MODULE$), (Object)deleted);
        } else {
            Assert.assertEquals((Object)List$.MODULE$.empty(), (Object)deleted);
        }
        updateSemaphore$1.release();
        PatternType patternType3 = deletePatternType;
        PatternType patternType4 = PatternType.MATCH;
        if (!(patternType3 != null ? !patternType3.equals(patternType4) : patternType4 != null)) {
            long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
            long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
            if (TestUtils$.MODULE$ == null) {
                throw null;
            }
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!AclAuthorizerTest.$anonfun$testCreateDeleteTiming$5(deleteAuthorizer)) {
                void waitUntilTrue_pause;
                void waitUntilTrue_waitTimeMs;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    throw Assertions$.MODULE$.fail(AclAuthorizerTest.$anonfun$testCreateDeleteTiming$6(), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 842));
                }
                if (Predef$.MODULE$ == null) {
                    throw null;
                }
                Thread.sleep(RichLong$.MODULE$.min$extension((long)waitUntilTrue_waitTimeMs, (long)waitUntilTrue_pause));
            }
            Assert.assertEquals((Object)new .colon.colon((Object)acl, (List)Nil$.MODULE$), (Object)this.deleteAcl$1(deleteAuthorizer, resource, deletePatternType));
        }
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!AclAuthorizerTest.$anonfun$testCreateDeleteTiming$7(deleteAuthorizer)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                throw Assertions$.MODULE$.fail(AclAuthorizerTest.$anonfun$testCreateDeleteTiming$8(), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 842));
            }
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension((long)waitUntilTrue_waitTimeMs, (long)waitUntilTrue_pause));
        }
    }

    public static final /* synthetic */ void $anonfun$testCreateDeleteTiming$9(AclAuthorizerTest $this, AclAuthorizer deleteAuthorizer$2, Semaphore updateSemaphore$1, AccessControlEntry ace$1, ResourcePattern resource) {
        $this.verifyCreateDeleteAcl$1(deleteAuthorizer$2, resource, resource.patternType(), updateSemaphore$1, ace$1);
        $this.verifyCreateDeleteAcl$1(deleteAuthorizer$2, resource, PatternType.ANY, updateSemaphore$1, ace$1);
        $this.verifyCreateDeleteAcl$1(deleteAuthorizer$2, resource, PatternType.MATCH, updateSemaphore$1, ace$1);
    }

    public static final /* synthetic */ void $anonfun$addAcls$3(AclCreateResult result) {
        result.exception().ifPresent(e -> {
            throw e;
        });
    }

    public static final /* synthetic */ boolean $anonfun$removeAcls$3(AclDeleteResult result) {
        result.exception().ifPresent(e -> {
            throw e;
        });
        result.aclBindingDeleteResults().forEach(r -> r.exception().ifPresent(e -> {
            throw e;
        }));
        return !result.aclBindingDeleteResults().isEmpty();
    }

    public static final /* synthetic */ void $anonfun$prepareConfig$1(OutputStream writer$1, String l) {
        writer$1.write(l.getBytes());
        writer$1.write("\n".getBytes());
    }

    public AclAuthorizerTest() {
        this.superUsers = "User:superuser1; User:superuser2";
        this.username = "alice";
    }

    public static final /* synthetic */ Object $anonfun$testImplicationsOfAllow$2$adapted(AclAuthorizerTest $this, RequestContext hostContext$1, Set allowedOps$1, AclOperation parentOp$1, AclOperation op) {
        AclAuthorizerTest.$anonfun$testImplicationsOfAllow$2($this, hostContext$1, allowedOps$1, parentOp$1, op);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testImplicationsOfDeny$2$adapted(AclAuthorizerTest $this, RequestContext host1Context$1, Set deniedOps$1, AclOperation parentOp$2, AclOperation op) {
        AclAuthorizerTest.$anonfun$testImplicationsOfDeny$2($this, host1Context$1, deniedOps$1, parentOp$2, op);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testCreateDeleteTiming$9$adapted(AclAuthorizerTest $this, AclAuthorizer deleteAuthorizer$2, Semaphore updateSemaphore$1, AccessControlEntry ace$1, ResourcePattern resource) {
        AclAuthorizerTest.$anonfun$testCreateDeleteTiming$9($this, deleteAuthorizer$2, updateSemaphore$1, ace$1, resource);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$prepareConfig$1$adapted(OutputStream writer$1, String l) {
        AclAuthorizerTest.$anonfun$prepareConfig$1(writer$1, l);
        return BoxedUnit.UNIT;
    }

    public class CustomPrincipal
    extends KafkaPrincipal {
        public boolean equals(Object o) {
            return false;
        }

        public /* synthetic */ AclAuthorizerTest kafka$security$authorizer$AclAuthorizerTest$CustomPrincipal$$$outer() {
            return AclAuthorizerTest.this;
        }

        public CustomPrincipal(String principalType, String name) {
            if (AclAuthorizerTest.this == null) {
                throw null;
            }
            super(principalType, name);
        }
    }
}

