/*
 * Decompiled with CFR 0.152.
 */
package kafka.network;

import com.yammer.metrics.core.Meter;
import java.io.File;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.Collections;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import kafka.metrics.KafkaMetricsGroup$;
import kafka.network.ConnectionQuotas;
import kafka.network.ConnectionQuotasTest$ListenerDesc$;
import kafka.network.Processor$;
import kafka.network.SocketServer$;
import kafka.network.TooManyConnectionsException;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\r\rd\u0001B'O\u0001MCQA\u0017\u0001\u0005\u0002mC\u0011B\u0018\u0001A\u0002\u0003\u0007I\u0011B0\t\u00131\u0004\u0001\u0019!a\u0001\n\u0013i\u0007\"C:\u0001\u0001\u0004\u0005\t\u0015)\u0003a\u0011%!\b\u00011AA\u0002\u0013%Q\u000fC\u0006\u0002\u0002\u0001\u0001\r\u00111A\u0005\n\u0005\r\u0001BCA\u0004\u0001\u0001\u0007\t\u0011)Q\u0005m\"Y\u0011\u0011\u0002\u0001A\u0002\u0003\u0007I\u0011BA\u0006\u0011-\t\u0019\u0002\u0001a\u0001\u0002\u0004%I!!\u0006\t\u0017\u0005e\u0001\u00011A\u0001B\u0003&\u0011Q\u0002\u0005\n\u00037\u0001!\u0019!C\u0005\u0003;A\u0001\"a;\u0001A\u0003%\u0011q\u0004\u0005\n\u0003[\u0004!\u0019!C\u0005\u0003_D\u0001B!\u0005\u0001A\u0003%\u0011\u0011\u001f\u0005\n\u0005'\u0001!\u0019!C\u0005\u0003;B\u0001B!\u0006\u0001A\u0003%\u0011q\f\u0005\n\u0005/\u0001!\u0019!C\u0005\u0003;B\u0001B!\u0007\u0001A\u0003%\u0011q\f\u0005\n\u00057\u0001!\u0019!C\u0005\u0003oC\u0001B!\b\u0001A\u0003%\u0011\u0011\u0018\u0005\n\u0005?\u0001!\u0019!C\u0005\u0003oC\u0001B!\t\u0001A\u0003%\u0011\u0011\u0018\u0004\u0007\u0003w\u0001\u0001)!\u0010\t\u0015\u0005-sC!f\u0001\n\u0003\ti\u0005\u0003\u0006\u0002Z]\u0011\t\u0012)A\u0005\u0003\u001fB!\"a\u0017\u0018\u0005+\u0007I\u0011AA/\u0011)\tYg\u0006B\tB\u0003%\u0011q\f\u0005\u00075^!\t!!\u001c\t\u000f\u0005Mt\u0003\"\u0011\u0002v!I\u00111R\f\u0002\u0002\u0013\u0005\u0011Q\u0012\u0005\n\u0003';\u0012\u0013!C\u0001\u0003+C\u0011\"a+\u0018#\u0003%\t!!,\t\u0013\u0005Ev#!A\u0005B\u0005M\u0006\"CA[/\u0005\u0005I\u0011AA\\\u0011%\tylFA\u0001\n\u0003\t\t\rC\u0005\u0002L^\t\t\u0011\"\u0011\u0002N\"I\u0011Q[\f\u0002\u0002\u0013\u0005\u0011q\u001b\u0005\n\u0003C<\u0012\u0011!C!\u0003GD\u0011\"!:\u0018\u0003\u0003%\t%a:\b\u0013\t\r\u0002!!A\t\u0002\t\u0015b!CA\u001e\u0001\u0005\u0005\t\u0012\u0001B\u0014\u0011\u0019Q\u0016\u0006\"\u0001\u00036!I\u00111O\u0015\u0002\u0002\u0013\u0015#q\u0007\u0005\n\u0005sI\u0013\u0011!CA\u0005wA\u0011B!\u0011*\u0003\u0003%\tIa\u0011\t\u000f\tU\u0003\u0001\"\u0001\u0003X!9!\u0011\r\u0001\u0005\u0002\t\r\u0004b\u0002B:\u0001\u0011\u0005!1\r\u0005\b\u0005{\u0002A\u0011\u0001B2\u0011\u001d\u00119\t\u0001C\u0001\u0005GBqAa#\u0001\t\u0003\u0011\u0019\u0007C\u0004\u0003\u0010\u0002!\tAa\u0019\t\u000f\tM\u0005\u0001\"\u0001\u0003d!9!q\u0013\u0001\u0005\u0002\t\r\u0004b\u0002BN\u0001\u0011\u0005!1\r\u0005\b\u0005?\u0003A\u0011\u0001B2\u0011\u001d\u0011\u0019\u000b\u0001C\u0001\u0005GBqAa*\u0001\t\u0003\u0011\u0019\u0007C\u0004\u0003,\u0002!\tAa\u0019\t\u000f\t=\u0006\u0001\"\u0001\u0003d!9!1\u0017\u0001\u0005\u0002\t\r\u0004b\u0002B\\\u0001\u0011\u0005!1\r\u0005\b\u0005w\u0003A\u0011\u0002B_\u0011\u001d\u0011Y\f\u0001C\u0005\u0005#DqA!=\u0001\t\u0013\u0011\u0019\u0007C\u0004\u0003t\u0002!IAa\u0019\t\u000f\tU\b\u0001\"\u0003\u0003d!9!q\u001f\u0001\u0005\n\te\bbBB\u0001\u0001\u0011%11\u0001\u0005\b\u0007\u001f\u0001A\u0011BB\t\u0011\u001d\u0019)\u0002\u0001C\u0005\u0007/Aqa!\u0007\u0001\t\u0013\u0019Y\u0002C\u0005\u00042\u0001\t\n\u0011\"\u0003\u00044!91q\u0007\u0001\u0005\n\re\u0002bBB\r\u0001\u0011%11\n\u0005\b\u00073\u0002A\u0011BB.\u0005Q\u0019uN\u001c8fGRLwN\\)v_R\f7\u000fV3ti*\u0011q\nU\u0001\b]\u0016$xo\u001c:l\u0015\u0005\t\u0016!B6bM.\f7\u0001A\n\u0003\u0001Q\u0003\"!\u0016-\u000e\u0003YS\u0011aV\u0001\u0006g\u000e\fG.Y\u0005\u00033Z\u0013a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001]!\ti\u0006!D\u0001O\u0003\u001diW\r\u001e:jGN,\u0012\u0001\u0019\t\u0003C*l\u0011A\u0019\u0006\u0003=\u000eT!\u0001Z3\u0002\r\r|W.\\8o\u0015\t\tfM\u0003\u0002hQ\u00061\u0011\r]1dQ\u0016T\u0011![\u0001\u0004_J<\u0017BA6c\u0005\u001diU\r\u001e:jGN\f1\"\\3ue&\u001c7o\u0018\u0013fcR\u0011a.\u001d\t\u0003+>L!\u0001\u001d,\u0003\tUs\u0017\u000e\u001e\u0005\be\u000e\t\t\u00111\u0001a\u0003\rAH%M\u0001\t[\u0016$(/[2tA\u0005AQ\r_3dkR|'/F\u0001w!\t9h0D\u0001y\u0015\tI(0\u0001\u0006d_:\u001cWO\u001d:f]RT!a\u001f?\u0002\tU$\u0018\u000e\u001c\u0006\u0002{\u0006!!.\u0019<b\u0013\ty\bPA\bFq\u0016\u001cW\u000f^8s'\u0016\u0014h/[2f\u00031)\u00070Z2vi>\u0014x\fJ3r)\rq\u0017Q\u0001\u0005\be\u001a\t\t\u00111\u0001w\u0003%)\u00070Z2vi>\u0014\b%\u0001\td_:tWm\u0019;j_:\fVo\u001c;bgV\u0011\u0011Q\u0002\t\u0004;\u0006=\u0011bAA\t\u001d\n\u00012i\u001c8oK\u000e$\u0018n\u001c8Rk>$\u0018m]\u0001\u0015G>tg.Z2uS>t\u0017+^8uCN|F%Z9\u0015\u00079\f9\u0002\u0003\u0005s\u0013\u0005\u0005\t\u0019AA\u0007\u0003E\u0019wN\u001c8fGRLwN\\)v_R\f7\u000fI\u0001\nY&\u001cH/\u001a8feN,\"!a\b\u0011\u0011\u0005\u0005\u0012qEA\u0016\u0003oi!!a\t\u000b\u0007\u0005\u0015b+\u0001\u0006d_2dWm\u0019;j_:LA!!\u000b\u0002$\t\u0019Q*\u00199\u0011\t\u00055\u00121G\u0007\u0003\u0003_Q1!!\r}\u0003\u0011a\u0017M\\4\n\t\u0005U\u0012q\u0006\u0002\u0007'R\u0014\u0018N\\4\u0011\u0007\u0005er#D\u0001\u0001\u00051a\u0015n\u001d;f]\u0016\u0014H)Z:d'\u00199B+a\u0010\u0002FA\u0019Q+!\u0011\n\u0007\u0005\rcKA\u0004Qe>$Wo\u0019;\u0011\u0007U\u000b9%C\u0002\u0002JY\u0013AbU3sS\u0006d\u0017N_1cY\u0016\fA\u0002\\5ti\u0016tWM\u001d(b[\u0016,\"!a\u0014\u0011\t\u0005E\u0013QK\u0007\u0003\u0003'R!aT2\n\t\u0005]\u00131\u000b\u0002\r\u0019&\u001cH/\u001a8fe:\u000bW.Z\u0001\u000eY&\u001cH/\u001a8fe:\u000bW.\u001a\u0011\u0002\u0013\u0011,g-Y;mi&\u0003XCAA0!\u0011\t\t'a\u001a\u000e\u0005\u0005\r$bAA3y\u0006\u0019a.\u001a;\n\t\u0005%\u00141\r\u0002\f\u0013:,G/\u00113ee\u0016\u001c8/\u0001\u0006eK\u001a\fW\u000f\u001c;Ja\u0002\"b!a\u000e\u0002p\u0005E\u0004bBA&9\u0001\u0007\u0011q\n\u0005\b\u00037b\u0002\u0019AA0\u0003!!xn\u0015;sS:<GCAA<!\u0011\tI(a\"\u000f\t\u0005m\u00141\u0011\t\u0004\u0003{2VBAA@\u0015\r\t\tIU\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005\u0015e+\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003k\tIIC\u0002\u0002\u0006Z\u000bAaY8qsR1\u0011qGAH\u0003#C\u0011\"a\u0013\u001f!\u0003\u0005\r!a\u0014\t\u0013\u0005mc\u0004%AA\u0002\u0005}\u0013AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0003/SC!a\u0014\u0002\u001a.\u0012\u00111\u0014\t\u0005\u0003;\u000b9+\u0004\u0002\u0002 *!\u0011\u0011UAR\u0003%)hn\u00195fG.,GMC\u0002\u0002&Z\u000b!\"\u00198o_R\fG/[8o\u0013\u0011\tI+a(\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u0005=&\u0006BA0\u00033\u000bQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAA\u0016\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\tI\fE\u0002V\u0003wK1!!0W\u0005\rIe\u000e^\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\t\u0019-!3\u0011\u0007U\u000b)-C\u0002\u0002HZ\u00131!\u00118z\u0011!\u00118%!AA\u0002\u0005e\u0016a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005=\u0007CBA\u0011\u0003#\f\u0019-\u0003\u0003\u0002T\u0006\r\"\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$B!!7\u0002`B\u0019Q+a7\n\u0007\u0005ugKA\u0004C_>dW-\u00198\t\u0011I,\u0013\u0011!a\u0001\u0003\u0007\f\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0003\u0003s\u000ba!Z9vC2\u001cH\u0003BAm\u0003SD\u0001B]\u0014\u0002\u0002\u0003\u0007\u00111Y\u0001\u000bY&\u001cH/\u001a8feN\u0004\u0013\u0001\u00062m_\u000e\\W\r\u001a)fe\u000e,g\u000e^'fi\u0016\u00148/\u0006\u0002\u0002rBA\u00111_A}\u0003o\nY0\u0004\u0002\u0002v*!\u0011q_A\u0012\u0003\u001diW\u000f^1cY\u0016LA!!\u000b\u0002vB!\u0011Q B\u0007\u001b\t\tyP\u0003\u0003\u0003\u0002\t\r\u0011\u0001B2pe\u0016T1A\u0018B\u0003\u0015\u0011\u00119A!\u0003\u0002\re\fW.\\3s\u0015\t\u0011Y!A\u0002d_6LAAa\u0004\u0002\u0000\n)Q*\u001a;fe\u0006)\"\r\\8dW\u0016$\u0007+\u001a:dK:$X*\u001a;feN\u0004\u0013!C6o_^t\u0007j\\:u\u0003)Ygn\\<o\u0011>\u001cH\u000fI\u0001\fk:\\gn\\<o\u0011>\u001cH/\u0001\u0007v].twn\u001e8I_N$\b%A\bok6\fVo\u001c;b'\u0006l\u0007\u000f\\3t\u0003AqW/\\)v_R\f7+Y7qY\u0016\u001c\b%\u0001\frk>$\u0018mV5oI><8+\u001b>f'\u0016\u001cwN\u001c3t\u0003]\tXo\u001c;b/&tGm\\<TSj,7+Z2p]\u0012\u001c\b%\u0001\u0007MSN$XM\\3s\t\u0016\u001c8\rE\u0002\u0002:%\u001aR!\u000bB\u0015\u0003\u000b\u0002\"Ba\u000b\u00032\u0005=\u0013qLA\u001c\u001b\t\u0011iCC\u0002\u00030Y\u000bqA];oi&lW-\u0003\u0003\u00034\t5\"!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8oeQ\u0011!Q\u0005\u000b\u0003\u0003W\tQ!\u00199qYf$b!a\u000e\u0003>\t}\u0002bBA&Y\u0001\u0007\u0011q\n\u0005\b\u00037b\u0003\u0019AA0\u0003\u001d)h.\u00199qYf$BA!\u0012\u0003RA)QKa\u0012\u0003L%\u0019!\u0011\n,\u0003\r=\u0003H/[8o!\u001d)&QJA(\u0003?J1Aa\u0014W\u0005\u0019!V\u000f\u001d7fe!I!1K\u0017\u0002\u0002\u0003\u0007\u0011qG\u0001\u0004q\u0012\u0002\u0014A\n2s_.,'\u000f\u0015:paN<\u0016\u000e\u001e5EK\u001a\fW\u000f\u001c;D_:tWm\u0019;j_:d\u0015.\\5ugV\u0011!\u0011\f\t\u0005\u00057\u0012i&D\u0001{\u0013\r\u0011yF\u001f\u0002\u000b!J|\u0007/\u001a:uS\u0016\u001c\u0018!B:fiV\u0003H#\u00018)\u0007=\u00129\u0007\u0005\u0003\u0003j\t=TB\u0001B6\u0015\r\u0011i\u0007[\u0001\u0006UVt\u0017\u000e^\u0005\u0005\u0005c\u0012YG\u0001\u0004CK\u001a|'/Z\u0001\ti\u0016\f'\u000fR8x]\"\u001a\u0001Ga\u001e\u0011\t\t%$\u0011P\u0005\u0005\u0005w\u0012YGA\u0003BMR,'/A\fuKN$h)Y5m/\",gNT8MSN$XM\\3sg\"\u001a\u0011G!!\u0011\t\t%$1Q\u0005\u0005\u0005\u000b\u0013YG\u0001\u0003UKN$\u0018!\b;fgR4\u0015-\u001b7EK\u000e\u0014X-\\3oi\u001a{'/\u00168l]><h.\u00139)\u0007I\u0012\t)A\u0010uKN$hj\\\"p]:,7\r^5p]2KW.\u001b;t\u0005f$UMZ1vYRD3a\rBA\u0003]!Xm\u001d;NCb\u001cuN\u001c8fGRLwN\\:QKJL\u0005\u000fK\u00025\u0005\u0003\u000b\u0001\u0005^3ti6\u000b\u0007P\u0011:pW\u0016\u0014x+\u001b3f\u0007>tg.Z2uS>tG*[7ji\"\u001aQG!!\u0002?Q,7\u000f^'bq2K7\u000f^3oKJ\u001cuN\u001c8fGRLwN\u001c'j[&$8\u000fK\u00027\u0005\u0003\u000bQ\u0007^3ti\n\u0013xn[3s\u0007>tg.Z2uS>t'+\u0019;f\u0019&l\u0017\u000e^,iK:\f5\r^;bYJ\u000bG/\u001a\"fY><H*[7ji\"\u001aqG!!\u0002kQ,7\u000f\u001e\"s_.,'oQ8o]\u0016\u001cG/[8o%\u0006$X\rT5nSR<\u0006.\u001a8BGR,\u0018\r\u001c*bi\u0016\f%m\u001c<f\u0019&l\u0017\u000e\u001e\u0015\u0004q\t\u0005\u0015a\u000e;fgRd\u0015n\u001d;f]\u0016\u00148i\u001c8oK\u000e$\u0018n\u001c8SCR,G*[7ji^CWM\\!diV\fGNU1uK\n+Gn\\<MS6LG\u000fK\u0002:\u0005\u0003\u000bq\u0007^3ti2K7\u000f^3oKJ\u001cuN\u001c8fGRLwN\u001c*bi\u0016d\u0015.\\5u/\",g.Q2uk\u0006d'+\u0019;f\u0003\n|g/\u001a'j[&$\bf\u0001\u001e\u0003\u0002\u0006\u0001D/Z:u\u001b\u0006DH*[:uK:,'oQ8o]\u0016\u001cG/[8o\u0019&\u001cH/\u001a8fe6+8\u000f\u001e\"f\u0003\n|g/\u001a.fe>D3a\u000fBA\u00031\"Xm\u001d;NCbd\u0015n\u001d;f]\u0016\u00148i\u001c8oK\u000e$\u0018n\u001c8SCR,'+Z2p]\u001aLw-\u001e:bi&|g\u000eK\u0002=\u0005\u0003\u000b!\u0006^3ti6\u000b\u0007P\u0011:pW\u0016\u00148i\u001c8oK\u000e$\u0018n\u001c8SCR,'+Z2p]\u001aLw-\u001e:bi&|g\u000eK\u0002>\u0005\u0003\u000ba\u0006^3ti:{g\u000eR3gCVdGoQ8o]\u0016\u001cG/[8o\u0007>,h\u000e\u001e'j[&$\u0018I\u001c3SCR,G*[7ji\"\u001aaH!!\u0002+\u0005$G\rT5ti\u0016tWM]:B]\u00124VM]5gsR)aNa0\u0003P\"9!\u0011Y A\u0002\t\r\u0017AB2p]\u001aLw\r\u0005\u0003\u0003F\n-WB\u0001Bd\u0015\r\u0011I\rU\u0001\u0007g\u0016\u0014h/\u001a:\n\t\t5'q\u0019\u0002\f\u0017\u000647.Y\"p]\u001aLw\rC\u0004\u0002\n}\u0002\r!!\u0004\u0015\u000f9\u0014\u0019N!6\u0003p\"9!\u0011\u0019!A\u0002\t\r\u0007b\u0002Bl\u0001\u0002\u0007!\u0011\\\u0001\u000fY&\u001cH/\u001a8fe\u000e{gNZ5ha\u0011\u0011YNa9\u0011\u0011\tm#Q\\A<\u0005?L1!!\u000b{!\u0011\u0011\tOa9\r\u0001\u0011a!Q\u001dBk\u0003\u0003\u0005\tQ!\u0001\u0003h\n\u0019q\fJ\u0019\u0012\t\t%\u00181\u0019\t\u0004+\n-\u0018b\u0001Bw-\n9aj\u001c;iS:<\u0007bBA\u0005\u0001\u0002\u0007\u0011QB\u0001-m\u0016\u0014\u0018NZ=O_\ncwnY6fIB+'oY3oiJ+7m\u001c:eK\u0012|e.\u00117m\u0019&\u001cH/\u001a8feN\f\u0001H^3sS\u001aLhj\u001c8[KJ|'\t\\8dW\u0016$\u0007+\u001a:dK:$\u0018I\u001c3UQJ|G\u000f\u001e7f)&lWm\u00148BY2d\u0015n\u001d;f]\u0016\u00148/A\u001cwKJLg-_(oYftuN\\%oi\u0016\u0014(I]8lKJd\u0015n\u001d;f]\u0016\u00148O\u00117pG.,G\rU3sG\u0016tGOU3d_J$W\rZ\u0001%m\u0016\u0014\u0018NZ=D_:tWm\u0019;j_:\u001cu.\u001e8u\u001f:,e/\u001a:z\u0019&\u001cH/\u001a8feR)aNa?\u0003~\"9\u0011\u0011\u0002#A\u0002\u00055\u0001b\u0002B\u0000\t\u0002\u0007\u0011\u0011X\u0001\u0018Kb\u0004Xm\u0019;fI\u000e{gN\\3di&|gnQ8v]R\f!\u0004\\5ti\u0016tWM]\"p]:$\u0006N]8ui2,W*\u001a;sS\u000e$Ba!\u0002\u0004\fA\u0019\u0011ma\u0002\n\u0007\r%!MA\u0006LC\u001a\\\u0017-T3ue&\u001c\u0007bBB\u0007\u000b\u0002\u0007\u0011qO\u0001\tY&\u001cH/\u001a8fe\u00061B.[:uK:,'oQ8o]J\u000bG/Z'fiJL7\r\u0006\u0003\u0004\u0006\rM\u0001bBB\u0007\r\u0002\u0007\u0011qO\u0001\u0015EJ|7.\u001a:D_:t'+\u0019;f\u001b\u0016$(/[2\u0015\u0005\r\u0015\u0011!E1dG\u0016\u0004HoQ8o]\u0016\u001cG/[8ogRIan!\b\u0004 \r\r2Q\u0006\u0005\b\u0003\u0013A\u0005\u0019AA\u0007\u0011\u001d\u0019\t\u0003\u0013a\u0001\u0003o\tA\u0002\\5ti\u0016tWM\u001d#fg\u000eDqa!\nI\u0001\u0004\u00199#\u0001\bok6\u001cuN\u001c8fGRLwN\\:\u0011\u0007U\u001bI#C\u0002\u0004,Y\u0013A\u0001T8oO\"I1q\u0006%\u0011\u0002\u0003\u00071qE\u0001\u000fi&lW-\u00138uKJ4\u0018\r\\'t\u0003m\t7mY3qi\u000e{gN\\3di&|gn\u001d\u0013eK\u001a\fW\u000f\u001c;%iU\u00111Q\u0007\u0016\u0005\u0007O\tI*\u0001\u0010bG\u000e,\u0007\u000f^\"p]:,7\r^5p]N\fe\u000e\u001a,fe&4\u0017PU1uKRiana\u000f\u0004>\r}2\u0011IB\"\u0007\u000fBq!!\u0003K\u0001\u0004\ti\u0001C\u0004\u0004\")\u0003\r!a\u000e\t\u000f\r\u0015\"\n1\u0001\u0004(!91q\u0006&A\u0002\r\u001d\u0002bBB#\u0015\u0002\u0007\u0011\u0011X\u0001\rKb\u0004Xm\u0019;fIJ\u000bG/\u001a\u0005\b\u0007\u0013R\u0005\u0019AA]\u0003\u001d)\u0007o]5m_:$2B\\B'\u0007\u001f\u001a\tf!\u0016\u0004X!9\u0011\u0011B&A\u0002\u00055\u0001bBA&\u0017\u0002\u0007\u0011q\n\u0005\b\u0007'Z\u0005\u0019AA0\u0003\u001d\tG\r\u001a:fgNDqa!\nL\u0001\u0004\u00199\u0003C\u0004\u00040-\u0003\raa\n\u0002;\u0005\u001c7-\u001a9u\u0007>tg.Z2uS>t7/\u00112pm\u0016L\u0005\u000fT5nSR$rA\\B/\u0007?\u001a\t\u0007C\u0004\u0002\n1\u0003\r!!\u0004\t\u000f\r\u0005B\n1\u0001\u00028!91Q\u0005'A\u0002\r\u001d\u0002")
public class ConnectionQuotasTest {
    private volatile ConnectionQuotasTest$ListenerDesc$ ListenerDesc$module;
    private Metrics metrics;
    private ExecutorService executor;
    private ConnectionQuotas connectionQuotas;
    private final Map<String, ListenerDesc> listeners;
    private final scala.collection.mutable.Map<String, Meter> blockedPercentMeters;
    private final InetAddress knownHost;
    private final InetAddress unknownHost;
    private final int numQuotaSamples;
    private final int quotaWindowSizeSeconds;

    public ConnectionQuotasTest$ListenerDesc$ ListenerDesc() {
        if (this.ListenerDesc$module == null) {
            this.ListenerDesc$lzycompute$1();
        }
        return this.ListenerDesc$module;
    }

    private Metrics metrics() {
        return this.metrics;
    }

    private void metrics_$eq(Metrics x$1) {
        this.metrics = x$1;
    }

    private ExecutorService executor() {
        return this.executor;
    }

    private void executor_$eq(ExecutorService x$1) {
        this.executor = x$1;
    }

    private ConnectionQuotas connectionQuotas() {
        return this.connectionQuotas;
    }

    private void connectionQuotas_$eq(ConnectionQuotas x$1) {
        this.connectionQuotas = x$1;
    }

    private Map<String, ListenerDesc> listeners() {
        return this.listeners;
    }

    private scala.collection.mutable.Map<String, Meter> blockedPercentMeters() {
        return this.blockedPercentMeters;
    }

    private InetAddress knownHost() {
        return this.knownHost;
    }

    private InetAddress unknownHost() {
        return this.unknownHost;
    }

    private int numQuotaSamples() {
        return this.numQuotaSamples;
    }

    private int quotaWindowSizeSeconds() {
        return this.quotaWindowSizeSeconds;
    }

    /*
     * WARNING - void declaration
     */
    public Properties brokerPropsWithDefaultConnectionLimits() {
        void var1_21;
        int x$1 = 0;
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        int x$3 = 0;
        boolean x$4 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$5 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$6 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$7 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$8 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$9 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$10 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$11 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$12 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$13 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$14 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$15 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$16 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        int x$17 = TestUtils$.MODULE$.createBrokerConfig$default$17();
        boolean x$18 = TestUtils$.MODULE$.createBrokerConfig$default$18();
        int x$19 = TestUtils$.MODULE$.createBrokerConfig$default$19();
        short x$20 = TestUtils$.MODULE$.createBrokerConfig$default$20();
        Properties props = TestUtils$.MODULE$.createBrokerConfig(x$1, x$2, x$4, x$5, x$3, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20);
        props.put(KafkaConfig$.MODULE$.ListenersProp(), "EXTERNAL://localhost:0,REPLICATION://localhost:1,ADMIN://localhost:2");
        props.put(KafkaConfig$.MODULE$.InterBrokerListenerNameProp(), "REPLICATION");
        props.put(KafkaConfig$.MODULE$.ListenerSecurityProtocolMapProp(), "EXTERNAL:PLAINTEXT,REPLICATION:PLAINTEXT,ADMIN:PLAINTEXT");
        props.put(KafkaConfig$.MODULE$.NumQuotaSamplesProp(), ((Object)BoxesRunTime.boxToInteger((int)this.numQuotaSamples())).toString());
        props.put(KafkaConfig$.MODULE$.QuotaWindowSizeSecondsProp(), ((Object)BoxesRunTime.boxToInteger((int)this.quotaWindowSizeSeconds())).toString());
        return var1_21;
    }

    @Before
    public void setUp() {
        TestUtils$.MODULE$.clearYammerMetrics();
        this.listeners().keys().foreach((Function1 & Serializable & scala.Serializable)name -> {
            void $minus$greater$extension_$this;
            Tuple2[] tuple2Array = new Tuple2[1];
            Object object = Predef$.MODULE$.ArrowAssoc((Object)Processor$.MODULE$.ListenerMetricTag());
            if (Predef.ArrowAssoc$.MODULE$ == null) {
                throw null;
            }
            tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this, name);
            return this.blockedPercentMeters().put(name, (Object)KafkaMetricsGroup$.MODULE$.newMeter(new StringBuilder(14).append((String)name).append("BlockedPercent").toString(), "blocked time", TimeUnit.NANOSECONDS, (Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array))));
        });
        this.metrics_$eq(new Metrics(new MetricConfig(), Collections.emptyList(), Time.SYSTEM));
        this.executor_$eq(Executors.newFixedThreadPool(this.listeners().size()));
    }

    @After
    public void tearDown() {
        this.executor().shutdownNow();
        if (this.connectionQuotas() != null) {
            this.connectionQuotas().close();
        }
        this.metrics().close();
        TestUtils$.MODULE$.clearYammerMetrics();
        this.blockedPercentMeters().clear();
    }

    @Test
    public void testFailWhenNoListeners() {
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(this.brokerPropsWithDefaultConnectionLimits());
        this.connectionQuotas_$eq(new ConnectionQuotas(config, Time.SYSTEM, this.metrics()));
        ListenerDesc listener = (ListenerDesc)this.listeners().apply((Object)"EXTERNAL");
        this.executor().submit(() -> Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.connectionQuotas().inc(listener.listenerName(), listener.defaultIp(), (Meter)this.blockedPercentMeters().apply((Object)"EXTERNAL")), ClassTag$.MODULE$.apply(RuntimeException.class), new Position("ConnectionQuotasTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 109))).get(5L, TimeUnit.SECONDS);
    }

    @Test
    public void testFailDecrementForUnknownIp() {
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(this.brokerPropsWithDefaultConnectionLimits());
        this.connectionQuotas_$eq(new ConnectionQuotas(config, Time.SYSTEM, this.metrics()));
        this.addListenersAndVerify(config, this.connectionQuotas());
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.connectionQuotas().dec(((ListenerDesc)this.listeners().apply((Object)"EXTERNAL")).listenerName(), this.unknownHost()), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("ConnectionQuotasTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 122));
    }

    @Test
    public void testNoConnectionLimitsByDefault() {
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(this.brokerPropsWithDefaultConnectionLimits());
        this.connectionQuotas_$eq(new ConnectionQuotas(config, Time.SYSTEM, this.metrics()));
        this.addListenersAndVerify(config, this.connectionQuotas());
        int numConnections = 10000;
        ((Iterable)this.listeners().values().map((Function1 & Serializable & scala.Serializable)listener -> this.executor().submit(() -> this.acceptConnections(this.connectionQuotas(), (ListenerDesc)listener, numConnections, this.acceptConnections$default$4())), Iterable$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x$1 -> x$1.get(10L, TimeUnit.SECONDS));
        Assert.assertTrue((String)"Expected broker-connection-accept-rate metric to get recorded", ((long)BoxesRunTime.unboxToDouble((Object)this.brokerConnRateMetric().metricValue()) > 0L ? 1 : 0) != 0);
        this.listeners().values().foreach((Function1 & Serializable & scala.Serializable)listener -> {
            ConnectionQuotasTest.$anonfun$testNoConnectionLimitsByDefault$4(this, numConnections, listener);
            return BoxedUnit.UNIT;
        });
        this.verifyNoBlockedPercentRecordedOnAllListeners();
    }

    @Test
    public void testMaxConnectionsPerIp() {
        int maxConnectionsPerIp = 17;
        Properties props = this.brokerPropsWithDefaultConnectionLimits();
        props.put(KafkaConfig$.MODULE$.MaxConnectionsPerIpProp(), ((Object)BoxesRunTime.boxToInteger((int)maxConnectionsPerIp)).toString());
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        this.connectionQuotas_$eq(new ConnectionQuotas(config, Time.SYSTEM, this.metrics()));
        this.addListenersAndVerify(config, this.connectionQuotas());
        ListenerDesc externalListener = (ListenerDesc)this.listeners().apply((Object)"EXTERNAL");
        this.executor().submit(() -> this.acceptConnections(this.connectionQuotas(), externalListener, maxConnectionsPerIp, this.acceptConnections$default$4())).get(5L, TimeUnit.SECONDS);
        Assert.assertEquals((String)new StringBuilder(26).append("Number of connections on ").append(externalListener).append(":").toString(), (long)maxConnectionsPerIp, (long)this.connectionQuotas().get(externalListener.defaultIp()));
        this.executor().submit(() -> this.acceptConnectionsAboveIpLimit(this.connectionQuotas(), externalListener, 2L)).get(5L, TimeUnit.SECONDS);
        Assert.assertEquals((String)new StringBuilder(26).append("Number of connections on ").append(externalListener).append(":").toString(), (long)(maxConnectionsPerIp + 2), (long)this.connectionQuotas().get(externalListener.defaultIp()));
        this.executor().submit(() -> this.acceptConnections(this.connectionQuotas(), externalListener.listenerName(), this.knownHost(), maxConnectionsPerIp, 0L)).get(5L, TimeUnit.SECONDS);
        int n = 0;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        Range range = RichInt$.MODULE$.until$extension0(n, 4);
        if (range == null) {
            throw null;
        }
        Range foreach$mVc$sp_this = range;
        if (!foreach$mVc$sp_this.isEmpty()) {
            int foreach$mVc$sp_i = foreach$mVc$sp_this.start();
            while (true) {
                ConnectionQuotasTest.$anonfun$testMaxConnectionsPerIp$4(this, externalListener, foreach$mVc$sp_i);
                if (foreach$mVc$sp_i == foreach$mVc$sp_this.scala$collection$immutable$Range$$lastElement()) break;
                foreach$mVc$sp_i += foreach$mVc$sp_this.step();
            }
        }
        Assert.assertEquals((String)new StringBuilder(26).append("Number of connections on ").append(externalListener).append(":").toString(), (long)(maxConnectionsPerIp - 2), (long)this.connectionQuotas().get(externalListener.defaultIp()));
        this.executor().submit(() -> this.acceptConnections(this.connectionQuotas(), externalListener, 2L, this.acceptConnections$default$4())).get(5L, TimeUnit.SECONDS);
        Assert.assertEquals((String)new StringBuilder(26).append("Number of connections on ").append(externalListener).append(":").toString(), (long)maxConnectionsPerIp, (long)this.connectionQuotas().get(externalListener.defaultIp()));
    }

    @Test
    public void testMaxBrokerWideConnectionLimit() {
        int maxConnections = 800;
        Properties props = this.brokerPropsWithDefaultConnectionLimits();
        props.put(KafkaConfig$.MODULE$.MaxConnectionsProp(), ((Object)BoxesRunTime.boxToInteger((int)maxConnections)).toString());
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        this.connectionQuotas_$eq(new ConnectionQuotas(config, Time.SYSTEM, this.metrics()));
        this.addListenersAndVerify(config, this.connectionQuotas());
        this.executor().submit(() -> this.acceptConnections(this.connectionQuotas(), (ListenerDesc)this.listeners().apply((Object)"EXTERNAL"), maxConnections, this.acceptConnections$default$4())).get(5L, TimeUnit.SECONDS);
        Assert.assertEquals((String)new StringBuilder(26).append("Number of connections on ").append(this.listeners().apply((Object)"EXTERNAL")).append(":").toString(), (long)maxConnections, (long)this.connectionQuotas().get(((ListenerDesc)this.listeners().apply((Object)"EXTERNAL")).defaultIp()));
        Assert.assertEquals((long)0L, (long)((Meter)this.blockedPercentMeters().apply((Object)"EXTERNAL")).count());
        Assert.assertFalse((String)"Total number of connections is exactly the maximum.", (boolean)this.connectionQuotas().maxConnectionsExceeded(((ListenerDesc)this.listeners().apply((Object)"EXTERNAL")).listenerName()));
        Future<?> future = this.executor().submit(() -> this.acceptConnections(this.connectionQuotas(), (ListenerDesc)this.listeners().apply((Object)"EXTERNAL"), 1L, this.acceptConnections$default$4()));
        Assertions$.MODULE$.intercept((Function0 & Serializable & scala.Serializable)() -> future.get(100L, TimeUnit.MILLISECONDS), ClassTag$.MODULE$.apply(TimeoutException.class), new Position("ConnectionQuotasTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 224));
        this.connectionQuotas().dec(((ListenerDesc)this.listeners().apply((Object)"EXTERNAL")).listenerName(), ((ListenerDesc)this.listeners().apply((Object)"EXTERNAL")).defaultIp());
        future.get(1L, TimeUnit.SECONDS);
        Assert.assertEquals((String)new StringBuilder(26).append("Number of connections on ").append(this.listeners().apply((Object)"EXTERNAL")).append(":").toString(), (long)maxConnections, (long)this.connectionQuotas().get(((ListenerDesc)this.listeners().apply((Object)"EXTERNAL")).defaultIp()));
        Assert.assertTrue((String)"Expected BlockedPercentMeter metric to be recorded", (((Meter)this.blockedPercentMeters().apply((Object)"EXTERNAL")).count() > 0L ? 1 : 0) != 0);
        this.executor().submit(() -> this.acceptConnections(this.connectionQuotas(), (ListenerDesc)this.listeners().apply((Object)"REPLICATION"), 1L, this.acceptConnections$default$4())).get(5L, TimeUnit.SECONDS);
        Assert.assertTrue((String)"Expected the number of connections to exceed the maximum.", (boolean)this.connectionQuotas().maxConnectionsExceeded(((ListenerDesc)this.listeners().apply((Object)"EXTERNAL")).listenerName()));
        Future<?> future1 = this.executor().submit(() -> this.acceptConnections(this.connectionQuotas(), (ListenerDesc)this.listeners().apply((Object)"ADMIN"), 1L, this.acceptConnections$default$4()));
        Assertions$.MODULE$.intercept((Function0 & Serializable & scala.Serializable)() -> future1.get(1L, TimeUnit.SECONDS), ClassTag$.MODULE$.apply(TimeoutException.class), new Position("ConnectionQuotasTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 246));
        this.executor().submit(() -> this.acceptConnections(this.connectionQuotas(), (ListenerDesc)this.listeners().apply((Object)"REPLICATION"), 1L, this.acceptConnections$default$4())).get(5L, TimeUnit.SECONDS);
        int n = 0;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        Range range = RichInt$.MODULE$.until$extension0(n, 2);
        if (range == null) {
            throw null;
        }
        Range foreach$mVc$sp_this = range;
        if (!foreach$mVc$sp_this.isEmpty()) {
            int foreach$mVc$sp_i = foreach$mVc$sp_this.start();
            while (true) {
                ConnectionQuotasTest.$anonfun$testMaxBrokerWideConnectionLimit$8(this, foreach$mVc$sp_i);
                if (foreach$mVc$sp_i == foreach$mVc$sp_this.scala$collection$immutable$Range$$lastElement()) break;
                foreach$mVc$sp_i += foreach$mVc$sp_this.step();
            }
        }
        Assertions$.MODULE$.intercept((Function0 & Serializable & scala.Serializable)() -> future1.get(100L, TimeUnit.MILLISECONDS), ClassTag$.MODULE$.apply(TimeoutException.class), new Position("ConnectionQuotasTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 256));
        this.connectionQuotas().dec(((ListenerDesc)this.listeners().apply((Object)"EXTERNAL")).listenerName(), ((ListenerDesc)this.listeners().apply((Object)"EXTERNAL")).defaultIp());
        future1.get(1L, TimeUnit.SECONDS);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testMaxListenerConnectionLimits() {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        int maxConnections = 800;
        int listenerMaxConnections = 200;
        Properties props = this.brokerPropsWithDefaultConnectionLimits();
        props.put(KafkaConfig$.MODULE$.MaxConnectionsProp(), ((Object)BoxesRunTime.boxToInteger((int)maxConnections)).toString());
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        this.connectionQuotas_$eq(new ConnectionQuotas(config, Time.SYSTEM, this.metrics()));
        this.addListenersAndVerify(config, this.connectionQuotas());
        Tuple2[] tuple2Array = new Tuple2[1];
        String string = ((Object)BoxesRunTime.boxToInteger((int)listenerMaxConnections)).toString();
        Object object = Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.MaxConnectionsProp());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        java.util.Map listenerConfig = (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array))).asJava();
        this.listeners().values().foreach((Function1 & Serializable & scala.Serializable)listener -> {
            ConnectionQuotasTest.$anonfun$testMaxListenerConnectionLimits$1(this, listenerConfig, listener);
            return BoxedUnit.UNIT;
        });
        ((Iterable)this.listeners().values().map((Function1 & Serializable & scala.Serializable)listener -> this.executor().submit(() -> this.acceptConnections(this.connectionQuotas(), (ListenerDesc)listener, listenerMaxConnections, this.acceptConnections$default$4())), Iterable$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x$2 -> x$2.get(5L, TimeUnit.SECONDS));
        this.listeners().values().foreach((Function1 & Serializable & scala.Serializable)listener -> {
            ConnectionQuotasTest.$anonfun$testMaxListenerConnectionLimits$5(this, listenerMaxConnections, listener);
            return BoxedUnit.UNIT;
        });
        Iterable overLimitFutures = (Iterable)this.listeners().values().map((Function1 & Serializable & scala.Serializable)listener -> this.executor().submit(() -> this.acceptConnections(this.connectionQuotas(), (ListenerDesc)listener, 1L, this.acceptConnections$default$4())), Iterable$.MODULE$.canBuildFrom());
        overLimitFutures.foreach((Function1 & Serializable & scala.Serializable)future -> (TimeoutException)Assertions$.MODULE$.intercept((Function0 & Serializable & scala.Serializable)() -> future.get(1L, TimeUnit.SECONDS), ClassTag$.MODULE$.apply(TimeoutException.class), new Position("ConnectionQuotasTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 296)));
        this.listeners().values().foreach((Function1 & Serializable & scala.Serializable)listener -> {
            ConnectionQuotasTest.$anonfun$testMaxListenerConnectionLimits$10(this, listener);
            return BoxedUnit.UNIT;
        });
        overLimitFutures.foreach((Function1 & Serializable & scala.Serializable)x$3 -> x$3.get(5L, TimeUnit.SECONDS));
        this.verifyConnectionCountOnEveryListener(this.connectionQuotas(), listenerMaxConnections);
    }

    @Test
    public void testBrokerConnectionRateLimitWhenActualRateBelowLimit() {
        int brokerRateLimit = 125;
        int connCreateIntervalMs = 25;
        int connectionsPerListener = 200;
        Properties props = this.brokerPropsWithDefaultConnectionLimits();
        props.put(KafkaConfig$.MODULE$.MaxConnectionCreationRateProp(), ((Object)BoxesRunTime.boxToInteger((int)brokerRateLimit)).toString());
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        this.connectionQuotas_$eq(new ConnectionQuotas(config, Time.SYSTEM, this.metrics()));
        this.addListenersAndVerify(config, this.connectionQuotas());
        ((Iterable)this.listeners().values().map((Function1 & Serializable & scala.Serializable)listener -> this.executor().submit(() -> this.acceptConnections(this.connectionQuotas(), (ListenerDesc)listener, connectionsPerListener, connCreateIntervalMs)), Iterable$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x$4 -> x$4.get(10L, TimeUnit.SECONDS));
        this.verifyNoBlockedPercentRecordedOnAllListeners();
        this.verifyConnectionCountOnEveryListener(this.connectionQuotas(), connectionsPerListener);
    }

    @Test
    public void testBrokerConnectionRateLimitWhenActualRateAboveLimit() {
        int brokerRateLimit = 90;
        Properties props = this.brokerPropsWithDefaultConnectionLimits();
        props.put(KafkaConfig$.MODULE$.MaxConnectionCreationRateProp(), ((Object)BoxesRunTime.boxToInteger((int)brokerRateLimit)).toString());
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        this.connectionQuotas_$eq(new ConnectionQuotas(config, Time.SYSTEM, this.metrics()));
        this.addListenersAndVerify(config, this.connectionQuotas());
        int connCreateIntervalMs = 10;
        int connectionsPerListener = 400;
        ((Iterable)this.listeners().values().map((Function1 & Serializable & scala.Serializable)listener -> this.executor().submit(() -> this.acceptConnections(this.connectionQuotas(), (ListenerDesc)listener, connectionsPerListener, connCreateIntervalMs)), Iterable$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x$5 -> x$5.get(20L, TimeUnit.SECONDS));
        this.verifyOnlyNonInterBrokerListenersBlockedPercentRecorded();
        this.verifyConnectionCountOnEveryListener(this.connectionQuotas(), connectionsPerListener);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testListenerConnectionRateLimitWhenActualRateBelowLimit() {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        int brokerRateLimit = 125;
        int listenerRateLimit = 50;
        int connCreateIntervalMs = 25;
        Properties props = this.brokerPropsWithDefaultConnectionLimits();
        props.put(KafkaConfig$.MODULE$.MaxConnectionCreationRateProp(), ((Object)BoxesRunTime.boxToInteger((int)brokerRateLimit)).toString());
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        this.connectionQuotas_$eq(new ConnectionQuotas(config, Time.SYSTEM, this.metrics()));
        Tuple2[] tuple2Array = new Tuple2[1];
        String string = ((Object)BoxesRunTime.boxToInteger((int)listenerRateLimit)).toString();
        Object object = Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.MaxConnectionCreationRateProp());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        java.util.Map listenerConfig = (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array))).asJava();
        this.addListenersAndVerify(config, listenerConfig, this.connectionQuotas());
        int connectionsPerListener = 200;
        ((Iterable)this.listeners().values().map((Function1 & Serializable & scala.Serializable)listener -> this.executor().submit(() -> this.acceptConnections(this.connectionQuotas(), (ListenerDesc)listener, connectionsPerListener, connCreateIntervalMs)), Iterable$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x$6 -> x$6.get(10L, TimeUnit.SECONDS));
        this.verifyNoBlockedPercentRecordedOnAllListeners();
        this.verifyConnectionCountOnEveryListener(this.connectionQuotas(), connectionsPerListener);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testListenerConnectionRateLimitWhenActualRateAboveLimit() {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        int brokerRateLimit = 125;
        int listenerRateLimit = 30;
        int connCreateIntervalMs = 25;
        Properties props = this.brokerPropsWithDefaultConnectionLimits();
        props.put(KafkaConfig$.MODULE$.MaxConnectionCreationRateProp(), ((Object)BoxesRunTime.boxToInteger((int)brokerRateLimit)).toString());
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        this.connectionQuotas_$eq(new ConnectionQuotas(config, Time.SYSTEM, this.metrics()));
        Tuple2[] tuple2Array = new Tuple2[1];
        String string = ((Object)BoxesRunTime.boxToInteger((int)listenerRateLimit)).toString();
        Object object = Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.MaxConnectionCreationRateProp());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        java.util.Map listenerConfig = (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array))).asJava();
        this.addListenersAndVerify(config, listenerConfig, this.connectionQuotas());
        int connectionsPerListener = 600;
        ((Iterable)this.listeners().values().map((Function1 & Serializable & scala.Serializable)listener -> this.executor().submit(() -> this.acceptConnectionsAndVerifyRate(this.connectionQuotas(), (ListenerDesc)listener, connectionsPerListener, connCreateIntervalMs, listenerRateLimit, 7)), Iterable$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x$7 -> x$7.get(30L, TimeUnit.SECONDS));
        this.verifyNonZeroBlockedPercentAndThrottleTimeOnAllListeners();
        this.verifyConnectionCountOnEveryListener(this.connectionQuotas(), connectionsPerListener);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testMaxListenerConnectionListenerMustBeAboveZero() {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(this.brokerPropsWithDefaultConnectionLimits());
        this.connectionQuotas_$eq(new ConnectionQuotas(config, Time.SYSTEM, this.metrics()));
        this.connectionQuotas().addListener(config, ((ListenerDesc)this.listeners().apply((Object)"EXTERNAL")).listenerName());
        int maxListenerConnectionRate = 0;
        Tuple2[] tuple2Array = new Tuple2[1];
        String string = ((Object)BoxesRunTime.boxToInteger((int)maxListenerConnectionRate)).toString();
        Object object = Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.MaxConnectionCreationRateProp());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        java.util.Map listenerConfig = (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array))).asJava();
        Assertions$.MODULE$.assertThrows((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((ConnectionQuotas.ListenerConnectionQuota)this.connectionQuotas().maxConnectionsPerListener().apply((Object)((ListenerDesc)this.listeners().apply((Object)"EXTERNAL")).listenerName())).validateReconfiguration(listenerConfig), ClassTag$.MODULE$.apply(ConfigException.class), new Position("ConnectionQuotasTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 421));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testMaxListenerConnectionRateReconfiguration() {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        void $minus$greater$extension_y2;
        void $minus$greater$extension_$this2;
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(this.brokerPropsWithDefaultConnectionLimits());
        this.connectionQuotas_$eq(new ConnectionQuotas(config, Time.SYSTEM, this.metrics()));
        this.connectionQuotas().addListener(config, ((ListenerDesc)this.listeners().apply((Object)"EXTERNAL")).listenerName());
        int listenerRateLimit = 20;
        Tuple2[] tuple2Array = new Tuple2[1];
        String string = ((Object)BoxesRunTime.boxToInteger((int)listenerRateLimit)).toString();
        Object object = Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.MaxConnectionCreationRateProp());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y2);
        java.util.Map listenerConfig = (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array))).asJava();
        ((ConnectionQuotas.ListenerConnectionQuota)this.connectionQuotas().maxConnectionsPerListener().apply((Object)((ListenerDesc)this.listeners().apply((Object)"EXTERNAL")).listenerName())).configure(listenerConfig);
        ((ConnectionQuotas.ListenerConnectionQuota)this.connectionQuotas().maxConnectionsPerListener().apply((Object)((ListenerDesc)this.listeners().apply((Object)"EXTERNAL")).listenerName())).reconfigure((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)scala.collection.Map$.MODULE$.empty()).asJava());
        this.executor().submit(() -> this.acceptConnections(this.connectionQuotas(), (ListenerDesc)this.listeners().apply((Object)"EXTERNAL"), 1000L, this.acceptConnections$default$4())).get(10L, TimeUnit.SECONDS);
        Assert.assertEquals((String)"BlockedPercentMeter metric for EXTERNAL listener", (long)0L, (long)((Meter)this.blockedPercentMeters().apply((Object)"EXTERNAL")).count());
        int newMaxListenerConnectionRate = 10;
        Tuple2[] tuple2Array2 = new Tuple2[1];
        String string2 = ((Object)BoxesRunTime.boxToInteger((int)newMaxListenerConnectionRate)).toString();
        Object object2 = Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.MaxConnectionCreationRateProp());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array2[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        java.util.Map newListenerConfig = (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array2))).asJava();
        ((ConnectionQuotas.ListenerConnectionQuota)this.connectionQuotas().maxConnectionsPerListener().apply((Object)((ListenerDesc)this.listeners().apply((Object)"EXTERNAL")).listenerName())).reconfigure(newListenerConfig);
        int connectionsPerListener = 200;
        this.executor().submit(() -> this.acceptConnectionsAndVerifyRate(this.connectionQuotas(), (ListenerDesc)this.listeners().apply((Object)"EXTERNAL"), connectionsPerListener, 5L, newMaxListenerConnectionRate, 3)).get(30L, TimeUnit.SECONDS);
        Assert.assertTrue((String)"Expected BlockedPercentMeter metric for EXTERNAL listener to be recorded", (((Meter)this.blockedPercentMeters().apply((Object)"EXTERNAL")).count() > 0L ? 1 : 0) != 0);
    }

    @Test
    public void testMaxBrokerConnectionRateReconfiguration() {
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(this.brokerPropsWithDefaultConnectionLimits());
        this.connectionQuotas_$eq(new ConnectionQuotas(config, Time.SYSTEM, this.metrics()));
        this.connectionQuotas().addListener(config, ((ListenerDesc)this.listeners().apply((Object)"EXTERNAL")).listenerName());
        this.addListenersAndVerify(config, this.connectionQuotas());
        int maxBrokerConnectionRate = 50;
        this.connectionQuotas().updateBrokerMaxConnectionRate(maxBrokerConnectionRate);
        int totalConnections = 400;
        this.executor().submit(() -> this.acceptConnectionsAndVerifyRate(this.connectionQuotas(), (ListenerDesc)this.listeners().apply((Object)"EXTERNAL"), totalConnections, 5L, maxBrokerConnectionRate, 20)).get(10L, TimeUnit.SECONDS);
        Assert.assertTrue((String)"Expected BlockedPercentMeter metric for EXTERNAL listener to be recorded", (((Meter)this.blockedPercentMeters().apply((Object)"EXTERNAL")).count() > 0L ? 1 : 0) != 0);
    }

    @Test
    public void testNonDefaultConnectionCountLimitAndRateLimit() {
        int brokerRateLimit = 25;
        int maxConnections = 350;
        Properties props = this.brokerPropsWithDefaultConnectionLimits();
        props.put(KafkaConfig$.MODULE$.MaxConnectionsProp(), ((Object)BoxesRunTime.boxToInteger((int)maxConnections)).toString());
        props.put(KafkaConfig$.MODULE$.MaxConnectionCreationRateProp(), ((Object)BoxesRunTime.boxToInteger((int)brokerRateLimit)).toString());
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        this.connectionQuotas_$eq(new ConnectionQuotas(config, Time.SYSTEM, this.metrics()));
        this.connectionQuotas().addListener(config, ((ListenerDesc)this.listeners().apply((Object)"EXTERNAL")).listenerName());
        this.addListenersAndVerify(config, this.connectionQuotas());
        ListenerDesc listener = (ListenerDesc)this.listeners().apply((Object)"EXTERNAL");
        this.executor().submit(() -> this.acceptConnectionsAndVerifyRate(this.connectionQuotas(), listener, maxConnections, 10L, brokerRateLimit, 8)).get(20L, TimeUnit.SECONDS);
        Assert.assertTrue((String)"Expected BlockedPercentMeter metric for EXTERNAL listener to be recorded", (((Meter)this.blockedPercentMeters().apply((Object)"EXTERNAL")).count() > 0L ? 1 : 0) != 0);
        Assert.assertEquals((String)"Number of connections on EXTERNAL listener:", (long)maxConnections, (long)this.connectionQuotas().get(listener.defaultIp()));
        Future<?> future = this.executor().submit(() -> this.acceptConnections(this.connectionQuotas(), (ListenerDesc)this.listeners().apply((Object)"EXTERNAL"), 1L, this.acceptConnections$default$4()));
        Assertions$.MODULE$.intercept((Function0 & Serializable & scala.Serializable)() -> future.get(100L, TimeUnit.MILLISECONDS), ClassTag$.MODULE$.apply(TimeoutException.class), new Position("ConnectionQuotasTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 505));
        this.connectionQuotas().dec(listener.listenerName(), listener.defaultIp());
        future.get(1L, TimeUnit.SECONDS);
        Assert.assertEquals((String)"Number of connections on EXTERNAL listener:", (long)maxConnections, (long)this.connectionQuotas().get(listener.defaultIp()));
    }

    private void addListenersAndVerify(KafkaConfig config, ConnectionQuotas connectionQuotas) {
        this.addListenersAndVerify(config, (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)scala.collection.Map$.MODULE$.empty()).asJava(), connectionQuotas);
    }

    private void addListenersAndVerify(KafkaConfig config, java.util.Map<String, ?> listenerConfig, ConnectionQuotas connectionQuotas) {
        Assert.assertNotNull((String)"Expected broker-connection-accept-rate metric to exist", (Object)this.brokerConnRateMetric());
        this.listeners().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            ConnectionQuotasTest.$anonfun$addListenersAndVerify$1(this, connectionQuotas, config, listenerConfig, x0$1);
            return BoxedUnit.UNIT;
        });
        this.verifyNoBlockedPercentRecordedOnAllListeners();
        Assert.assertEquals((String)"Broker-wide connection acceptance rate metric", (long)0L, (long)((long)BoxesRunTime.unboxToDouble((Object)this.brokerConnRateMetric().metricValue())));
    }

    private void verifyNoBlockedPercentRecordedOnAllListeners() {
        this.blockedPercentMeters().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            ConnectionQuotasTest.$anonfun$verifyNoBlockedPercentRecordedOnAllListeners$1(x0$1);
            return BoxedUnit.UNIT;
        });
    }

    private void verifyNonZeroBlockedPercentAndThrottleTimeOnAllListeners() {
        this.blockedPercentMeters().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            ConnectionQuotasTest.$anonfun$verifyNonZeroBlockedPercentAndThrottleTimeOnAllListeners$1(x0$1);
            return BoxedUnit.UNIT;
        });
        this.listeners().values().foreach((Function1 & Serializable & scala.Serializable)listener -> {
            ConnectionQuotasTest.$anonfun$verifyNonZeroBlockedPercentAndThrottleTimeOnAllListeners$2(this, listener);
            return BoxedUnit.UNIT;
        });
    }

    private void verifyOnlyNonInterBrokerListenersBlockedPercentRecorded() {
        this.blockedPercentMeters().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            ConnectionQuotasTest.$anonfun$verifyOnlyNonInterBrokerListenersBlockedPercentRecorded$1(x0$1);
            return BoxedUnit.UNIT;
        });
    }

    private void verifyConnectionCountOnEveryListener(ConnectionQuotas connectionQuotas, int expectedConnectionCount) {
        this.listeners().values().foreach((Function1 & Serializable & scala.Serializable)listener -> {
            ConnectionQuotasTest.$anonfun$verifyConnectionCountOnEveryListener$1(expectedConnectionCount, connectionQuotas, listener);
            return BoxedUnit.UNIT;
        });
    }

    private KafkaMetric listenerConnThrottleMetric(String listener) {
        MetricName metricName = this.metrics().metricName("connection-accept-throttle-time", SocketServer$.MODULE$.MetricsGroup(), Collections.singletonMap(Processor$.MODULE$.ListenerMetricTag(), listener));
        return this.metrics().metric(metricName);
    }

    private KafkaMetric listenerConnRateMetric(String listener) {
        MetricName metricName = this.metrics().metricName("connection-accept-rate", SocketServer$.MODULE$.MetricsGroup(), Collections.singletonMap(Processor$.MODULE$.ListenerMetricTag(), listener));
        return this.metrics().metric(metricName);
    }

    private KafkaMetric brokerConnRateMetric() {
        MetricName metricName = this.metrics().metricName("broker-connection-accept-rate", SocketServer$.MODULE$.MetricsGroup());
        return this.metrics().metric(metricName);
    }

    private void acceptConnections(ConnectionQuotas connectionQuotas, ListenerDesc listenerDesc, long numConnections, long timeIntervalMs) {
        this.acceptConnections(connectionQuotas, listenerDesc.listenerName(), listenerDesc.defaultIp(), numConnections, timeIntervalMs);
    }

    private void acceptConnectionsAndVerifyRate(ConnectionQuotas connectionQuotas, ListenerDesc listenerDesc, long numConnections, long timeIntervalMs, int expectedRate, int epsilon) {
        long startTimeMs = System.currentTimeMillis();
        this.acceptConnections(connectionQuotas, listenerDesc.listenerName(), listenerDesc.defaultIp(), numConnections, timeIntervalMs);
        long elapsedSeconds = TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis() - startTimeMs);
        int actualRate = (int)((double)numConnections / (double)elapsedSeconds);
        Assert.assertTrue((String)new StringBuilder(52).append("Expected rate (").append(expectedRate).append(" +- ").append(epsilon).append("), but got ").append(actualRate).append(" (").append(numConnections).append(" connections / ").append(elapsedSeconds).append(" sec)").toString(), (actualRate <= expectedRate + epsilon && actualRate >= expectedRate - epsilon ? 1 : 0) != 0);
    }

    private void acceptConnections(ConnectionQuotas connectionQuotas, ListenerName listenerName, InetAddress address, long numConnections, long timeIntervalMs) {
        LongRef nextSendTime = LongRef.create((long)(System.currentTimeMillis() + timeIntervalMs));
        long l = 0L;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        new RichLong(l).until((Object)BoxesRunTime.boxToLong((long)numConnections)).foreach((Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)_ -> {
            connectionQuotas.inc(listenerName, address, (Meter)this.blockedPercentMeters().apply((Object)listenerName.value()));
            long sleepMs = package$.MODULE$.max(nextSendTime$1.elem - System.currentTimeMillis(), 0L);
            if (sleepMs > 0L) {
                Utils.sleep((long)sleepMs);
            }
            nextSendTime$1.elem += timeIntervalMs;
        });
    }

    private long acceptConnections$default$4() {
        return 0L;
    }

    private void acceptConnectionsAboveIpLimit(ConnectionQuotas connectionQuotas, ListenerDesc listenerDesc, long numConnections) {
        ListenerName listenerName = listenerDesc.listenerName();
        long l = 0L;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        new RichLong(l).until((Object)BoxesRunTime.boxToLong((long)numConnections)).foreach((Function1 & Serializable & scala.Serializable)i -> ConnectionQuotasTest.$anonfun$acceptConnectionsAboveIpLimit$1(this, connectionQuotas, listenerName, listenerDesc, BoxesRunTime.unboxToLong((Object)i)));
    }

    private final void ListenerDesc$lzycompute$1() {
        synchronized (this) {
            if (this.ListenerDesc$module == null) {
                this.ListenerDesc$module = new ConnectionQuotasTest$ListenerDesc$(this);
            }
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$testNoConnectionLimitsByDefault$4(ConnectionQuotasTest $this, int numConnections$1, ListenerDesc listener) {
        Assert.assertEquals((String)new StringBuilder(26).append("Number of connections on ").append(listener).append(":").toString(), (long)numConnections$1, (long)$this.connectionQuotas().get(listener.defaultIp()));
        Assert.assertTrue((String)new StringBuilder(68).append("Expected connection-accept-rate metric to get recorded for listener ").append(listener).toString(), ((long)BoxesRunTime.unboxToDouble((Object)$this.listenerConnRateMetric(listener.listenerName().value()).metricValue()) > 0L ? 1 : 0) != 0);
        $this.connectionQuotas().dec(listener.listenerName(), listener.defaultIp());
        Assert.assertEquals((String)new StringBuilder(26).append("Number of connections on ").append(listener).append(":").toString(), (long)(numConnections$1 - 1), (long)$this.connectionQuotas().get(listener.defaultIp()));
    }

    public static final /* synthetic */ void $anonfun$testMaxConnectionsPerIp$4(ConnectionQuotasTest $this, ListenerDesc externalListener$1, int _) {
        $this.connectionQuotas().dec(externalListener$1.listenerName(), externalListener$1.defaultIp());
    }

    public static final /* synthetic */ void $anonfun$testMaxBrokerWideConnectionLimit$8(ConnectionQuotasTest $this, int _) {
        $this.connectionQuotas().dec(((ListenerDesc)$this.listeners().apply((Object)"EXTERNAL")).listenerName(), ((ListenerDesc)$this.listeners().apply((Object)"EXTERNAL")).defaultIp());
    }

    public static final /* synthetic */ void $anonfun$testMaxListenerConnectionLimits$1(ConnectionQuotasTest $this, java.util.Map listenerConfig$1, ListenerDesc listener) {
        ((ConnectionQuotas.ListenerConnectionQuota)$this.connectionQuotas().maxConnectionsPerListener().apply((Object)listener.listenerName())).configure(listenerConfig$1);
    }

    public static final /* synthetic */ void $anonfun$testMaxListenerConnectionLimits$5(ConnectionQuotasTest $this, int listenerMaxConnections$1, ListenerDesc listener) {
        Assert.assertEquals((String)new StringBuilder(26).append("Number of connections on ").append(listener).append(":").toString(), (long)listenerMaxConnections$1, (long)$this.connectionQuotas().get(listener.defaultIp()));
        Assert.assertFalse((String)new StringBuilder(62).append("Total number of connections on ").append(listener).append(" should be exactly the maximum.").toString(), (boolean)$this.connectionQuotas().maxConnectionsExceeded(listener.listenerName()));
    }

    public static final /* synthetic */ void $anonfun$testMaxListenerConnectionLimits$10(ConnectionQuotasTest $this, ListenerDesc listener) {
        $this.connectionQuotas().dec(listener.listenerName(), listener.defaultIp());
    }

    public static final /* synthetic */ void $anonfun$addListenersAndVerify$1(ConnectionQuotasTest $this, ConnectionQuotas connectionQuotas$1, KafkaConfig config$1, java.util.Map listenerConfig$3, Tuple2 x0$1) {
        if (x0$1 != null) {
            String name = (String)x0$1._1();
            ListenerDesc listener = (ListenerDesc)x0$1._2();
            ListenerName listenerName = listener.listenerName();
            connectionQuotas$1.addListener(config$1, listenerName);
            ((ConnectionQuotas.ListenerConnectionQuota)connectionQuotas$1.maxConnectionsPerListener().apply((Object)listenerName)).configure(listenerConfig$3);
            Assert.assertFalse((String)new StringBuilder(72).append("Should not exceed max connection limit on ").append(name).append(" listener after initialization").toString(), (boolean)connectionQuotas$1.maxConnectionsExceeded(listenerName));
            Assert.assertEquals((String)new StringBuilder(35).append("Number of connections on ").append(listener).append(" listener:").toString(), (long)0L, (long)connectionQuotas$1.get(listener.defaultIp()));
            Assert.assertNotNull((String)new StringBuilder(61).append("Expected connection-accept-rate metric to exist for listener ").append(listenerName.value()).toString(), (Object)$this.listenerConnRateMetric(listenerName.value()));
            Assert.assertEquals((String)new StringBuilder(47).append("Connection acceptance rate metric for listener ").append(listenerName.value()).toString(), (long)0L, (long)((long)BoxesRunTime.unboxToDouble((Object)$this.listenerConnRateMetric(listenerName.value()).metricValue())));
            Assert.assertNotNull((String)new StringBuilder(70).append("Expected connection-accept-throttle-time metric to exist for listener ").append(listenerName.value()).toString(), (Object)$this.listenerConnThrottleMetric(listenerName.value()));
            Assert.assertEquals((String)new StringBuilder(40).append("Connection throttle metric for listener ").append(listenerName.value()).toString(), (long)0L, (long)((long)BoxesRunTime.unboxToDouble((Object)$this.listenerConnThrottleMetric(listenerName.value()).metricValue())));
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$verifyNoBlockedPercentRecordedOnAllListeners$1(Tuple2 x0$1) {
        if (x0$1 != null) {
            String name = (String)x0$1._1();
            Meter meter = (Meter)x0$1._2();
            Assert.assertEquals((String)new StringBuilder(40).append("BlockedPercentMeter metric for ").append(name).append(" listener").toString(), (long)0L, (long)meter.count());
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$verifyNonZeroBlockedPercentAndThrottleTimeOnAllListeners$1(Tuple2 x0$1) {
        if (x0$1 != null) {
            String name = (String)x0$1._1();
            Meter meter = (Meter)x0$1._2();
            Assert.assertTrue((String)new StringBuilder(64).append("Expected BlockedPercentMeter metric for ").append(name).append(" listener to be recorded").toString(), (meter.count() > 0L ? 1 : 0) != 0);
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$verifyNonZeroBlockedPercentAndThrottleTimeOnAllListeners$2(ConnectionQuotasTest $this, ListenerDesc listener) {
        Assert.assertTrue((String)new StringBuilder(40).append("Connection throttle metric for listener ").append(listener.listenerName().value()).toString(), ((long)BoxesRunTime.unboxToDouble((Object)$this.listenerConnThrottleMetric(listener.listenerName().value()).metricValue()) > 0L ? 1 : 0) != 0);
    }

    public static final /* synthetic */ void $anonfun$verifyOnlyNonInterBrokerListenersBlockedPercentRecorded$1(Tuple2 x0$1) {
        if (x0$1 != null) {
            String name = (String)x0$1._1();
            Meter meter = (Meter)x0$1._2();
            if ("REPLICATION".equals(name)) {
                Assert.assertEquals((String)new StringBuilder(40).append("BlockedPercentMeter metric for ").append(name).append(" listener").toString(), (long)0L, (long)meter.count());
                return;
            }
            Assert.assertTrue((String)new StringBuilder(64).append("Expected BlockedPercentMeter metric for ").append(name).append(" listener to be recorded").toString(), (meter.count() > 0L ? 1 : 0) != 0);
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$verifyConnectionCountOnEveryListener$1(int expectedConnectionCount$1, ConnectionQuotas connectionQuotas$2, ListenerDesc listener) {
        Assert.assertEquals((String)new StringBuilder(26).append("Number of connections on ").append(listener).append(":").toString(), (long)expectedConnectionCount$1, (long)connectionQuotas$2.get(listener.defaultIp()));
    }

    public static final /* synthetic */ TooManyConnectionsException $anonfun$acceptConnectionsAboveIpLimit$1(ConnectionQuotasTest $this, ConnectionQuotas connectionQuotas$4, ListenerName listenerName$2, ListenerDesc listenerDesc$1, long i) {
        return (TooManyConnectionsException)Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> connectionQuotas$4.inc(listenerName$2, listenerDesc$1.defaultIp(), (Meter)$this.blockedPercentMeters().apply((Object)listenerName$2.value())), ClassTag$.MODULE$.apply(TooManyConnectionsException.class), new Position("ConnectionQuotasTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 657));
    }

    /*
     * WARNING - void declaration
     */
    public ConnectionQuotasTest() {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        void $minus$greater$extension_y2;
        void $minus$greater$extension_$this2;
        void $minus$greater$extension_y3;
        void $minus$greater$extension_$this3;
        Tuple2[] tuple2Array = new Tuple2[3];
        ListenerDesc listenerDesc = new ListenerDesc(this, new ListenerName("EXTERNAL"), InetAddress.getByName("192.168.1.1"));
        Object object = Predef$.MODULE$.ArrowAssoc((Object)"EXTERNAL");
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this3, (Object)$minus$greater$extension_y3);
        ListenerDesc listenerDesc2 = new ListenerDesc(this, new ListenerName("ADMIN"), InetAddress.getByName("192.168.1.2"));
        Object object2 = Predef$.MODULE$.ArrowAssoc((Object)"ADMIN");
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[1] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y2);
        ListenerDesc listenerDesc3 = new ListenerDesc(this, new ListenerName("REPLICATION"), InetAddress.getByName("192.168.1.3"));
        Object object3 = Predef$.MODULE$.ArrowAssoc((Object)"REPLICATION");
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[2] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        this.listeners = (Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array));
        this.blockedPercentMeters = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.knownHost = InetAddress.getByName("192.168.10.0");
        this.unknownHost = InetAddress.getByName("192.168.2.0");
        this.numQuotaSamples = 2;
        this.quotaWindowSizeSeconds = 1;
    }

    public class ListenerDesc
    implements Product,
    scala.Serializable {
        private final ListenerName listenerName;
        private final InetAddress defaultIp;
        public final /* synthetic */ ConnectionQuotasTest $outer;

        public ListenerName listenerName() {
            return this.listenerName;
        }

        public InetAddress defaultIp() {
            return this.defaultIp;
        }

        public String toString() {
            return new StringBuilder(20).append("(listener=").append(this.listenerName().value()).append(", client=").append(this.defaultIp().getHostAddress()).append(")").toString();
        }

        public ListenerDesc copy(ListenerName listenerName, InetAddress defaultIp) {
            return new ListenerDesc(this.kafka$network$ConnectionQuotasTest$ListenerDesc$$$outer(), listenerName, defaultIp);
        }

        public ListenerName copy$default$1() {
            return this.listenerName();
        }

        public InetAddress copy$default$2() {
            return this.defaultIp();
        }

        public String productPrefix() {
            return "ListenerDesc";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            switch (x$1) {
                case 0: {
                    return this.listenerName();
                }
                case 1: {
                    return this.defaultIp();
                }
            }
            throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof ListenerDesc;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            if (!(x$1 instanceof ListenerDesc)) return false;
            if (((ListenerDesc)x$1).kafka$network$ConnectionQuotasTest$ListenerDesc$$$outer() != this.kafka$network$ConnectionQuotasTest$ListenerDesc$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            ListenerDesc listenerDesc = (ListenerDesc)x$1;
            ListenerName listenerName = this.listenerName();
            ListenerName listenerName2 = listenerDesc.listenerName();
            if (listenerName == null) {
                if (listenerName2 != null) {
                    return false;
                }
            } else if (!listenerName.equals(listenerName2)) return false;
            InetAddress inetAddress = this.defaultIp();
            InetAddress inetAddress2 = listenerDesc.defaultIp();
            if (inetAddress == null) {
                if (inetAddress2 != null) {
                    return false;
                }
            } else if (!((Object)inetAddress).equals(inetAddress2)) return false;
            if (!listenerDesc.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ ConnectionQuotasTest kafka$network$ConnectionQuotasTest$ListenerDesc$$$outer() {
            return this.$outer;
        }

        public ListenerDesc(ConnectionQuotasTest $outer, ListenerName listenerName, InetAddress defaultIp) {
            this.listenerName = listenerName;
            this.defaultIp = defaultIp;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }
}

