/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kafka.server.DelayedFuture;
import kafka.server.DelayedFuturePurgatory;
import kafka.server.DelayedOperation;
import kafka.server.DelayedOperation$;
import kafka.server.DelayedOperationPurgatory;
import kafka.server.DelayedOperationPurgatory$;
import kafka.server.DelayedOperationTest;
import kafka.server.DelayedOperationTest$MockDelayedOperation$;
import kafka.utils.CoreUtils$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.utils.Time;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.CanBuildFrom;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range;
import scala.collection.immutable.Set;
import scala.collection.mutable.Set$;
import scala.jdk.CollectionConverters$;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005-f\u0001B\u0014)\u00015BQ\u0001\u000e\u0001\u0005\u0002UBq\u0001\u000f\u0001A\u0002\u0013\u0005\u0011\bC\u0004A\u0001\u0001\u0007I\u0011A!\t\r\u001d\u0003\u0001\u0015)\u0003;\u0011\u001dA\u0005\u00011A\u0005\u0002%Cq\u0001\u0016\u0001A\u0002\u0013\u0005Q\u000b\u0003\u0004X\u0001\u0001\u0006KA\u0013\u0005\u00061\u0002!\t!\u0017\u0005\u0006G\u0002!\t!\u0017\u0005\u0006Q\u0002!\t!\u0017\u0005\u0006[\u0002!\t!\u0017\u0005\u0006_\u0002!\t!\u0017\u0005\u0006c\u0002!\t!\u0017\u0005\u0006g\u0002!\t!\u0017\u0005\u0006k\u0002!\t!\u0017\u0005\u0006o\u0002!\t!\u0017\u0005\u0006s\u0002!\t!\u0017\u0005\u0006w\u0002!\t!\u0017\u0005\u0006{\u0002!\tA \u0005\b\u0003;\u0002A\u0011BA0\r\u0019\ti\u0001\u0001\u0001\u0002\u0010!a\u0011\u0011C\u000b\u0003\u0002\u0003\u0006I!a\u0005\u0002\u001a!Q\u00111D\u000b\u0003\u0002\u0003\u0006I!!\b\t\u0015\u0005=RC!b\u0001\n\u0003\t\t\u0004\u0003\u0006\u00024U\u0011\t\u0011)A\u0005\u0003;Aa\u0001N\u000b\u0005\u0002\u0005U\u0002\"CA\u001f+\u0001\u0007I\u0011AA \u0011%\t9%\u0006a\u0001\n\u0003\tI\u0005\u0003\u0005\u0002NU\u0001\u000b\u0015BA!\u0011\u0019\ty%\u0006C\u00013\"9\u0011\u0011K\u000b\u0005B\u0005M\u0003BBA++\u0011\u0005\u0013\f\u0003\u0004\u0002XU!\t%W\u0004\n\u0003\u0013\u0003\u0011\u0011!E\u0001\u0003\u00173\u0011\"!\u0004\u0001\u0003\u0003E\t!!$\t\rQ\u001aC\u0011AAH\u0011%\t\tjII\u0001\n\u0003\t\u0019\nC\u0005\u0002*\u000e\n\n\u0011\"\u0001\u0002\u0014\n!B)\u001a7bs\u0016$w\n]3sCRLwN\u001c+fgRT!!\u000b\u0016\u0002\rM,'O^3s\u0015\u0005Y\u0013!B6bM.\f7\u0001A\n\u0003\u00019\u0002\"a\f\u001a\u000e\u0003AR\u0011!M\u0001\u0006g\u000e\fG.Y\u0005\u0003gA\u0012a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u00017!\t9\u0004!D\u0001)\u0003%\u0001XO]4bi>\u0014\u00180F\u0001;!\r94(P\u0005\u0003y!\u0012\u0011\u0004R3mCf,Gm\u00149fe\u0006$\u0018n\u001c8QkJ<\u0017\r^8ssB\u0011qGP\u0005\u0003\u007f!\u0012\u0001\u0003R3mCf,Gm\u00149fe\u0006$\u0018n\u001c8\u0002\u001bA,(oZ1u_JLx\fJ3r)\t\u0011U\t\u0005\u00020\u0007&\u0011A\t\r\u0002\u0005+:LG\u000fC\u0004G\u0007\u0005\u0005\t\u0019\u0001\u001e\u0002\u0007a$\u0013'\u0001\u0006qkJ<\u0017\r^8ss\u0002\nq\"\u001a=fGV$xN]*feZL7-Z\u000b\u0002\u0015B\u00111JU\u0007\u0002\u0019*\u0011QJT\u0001\u000bG>t7-\u001e:sK:$(BA(Q\u0003\u0011)H/\u001b7\u000b\u0003E\u000bAA[1wC&\u00111\u000b\u0014\u0002\u0010\u000bb,7-\u001e;peN+'O^5dK\u0006\u0019R\r_3dkR|'oU3sm&\u001cWm\u0018\u0013fcR\u0011!I\u0016\u0005\b\r\u001a\t\t\u00111\u0001K\u0003A)\u00070Z2vi>\u00148+\u001a:wS\u000e,\u0007%A\u0003tKR,\u0006\u000fF\u0001CQ\tA1\f\u0005\u0002]C6\tQL\u0003\u0002_?\u0006)!.\u001e8ji*\t\u0001-A\u0002pe\u001eL!AY/\u0003\r\t+gm\u001c:f\u0003!!X-\u0019:E_^t\u0007FA\u0005f!\taf-\u0003\u0002h;\n)\u0011I\u001a;fe\u0006qB/Z:u\u0019>\u001c7.\u00138Uef\u001cu.\u001c9mKR,W\t\\:f/\u0006$8\r\u001b\u0015\u0003\u0015)\u0004\"\u0001X6\n\u00051l&\u0001\u0002+fgR\f\u0011\u0004^3tiN\u000bg-\u001a+ss\u000e{W\u000e\u001d7fi\u0016|%/\u00127tK\"\u00121B[\u0001\u0018i\u0016\u001cHOU3rk\u0016\u001cHoU1uSN4\u0017m\u0019;j_:D#\u0001\u00046\u0002#Q,7\u000f\u001e*fcV,7\u000f^#ya&\u0014\u0018\u0010\u000b\u0002\u000eU\u0006\tB/Z:u\t\u0016d\u0017-_3e\rV$XO]3)\u00059Q\u0017\u0001\u0005;fgR\u0014V-];fgR\u0004VO]4fQ\ty!.\u0001\u0018tQ>,H\u000eZ\"b]\u000e,GNR8s\u0017\u0016L(+\u001a;ve:LgnZ\"b]\u000e,G\u000e\\3e\u001fB,'/\u0019;j_:\u001c\bF\u0001\tk\u0003e\u001a\bn\\;mIJ+G/\u001e:o\u001d&dw\n]3sCRLwN\\:P]\u000e\u000bgnY3m\r>\u00148*Z=XQ\u0016t7*Z=E_\u0016\u001ch\u000e^#ySN$\bFA\tk\u0003\t\"Xm\u001d;Uef\u001cu.\u001c9mKR,w+\u001b;i\u001bVdG/\u001b9mKRC'/Z1eg\"\u0012!C[\u0001\u001bm\u0016\u0014\u0018NZ=EK2\f\u00170\u001a3Pa\u0016\u0014\u0018\r^5p]2{7m\u001b\u000b\u0005\u0005~\fI\u0006\u0003\u0005\u0002\u0002M!\t\u0019AA\u0002\u0003QiwnY6EK2\f\u00170\u001a3Pa\u0016\u0014\u0018\r^5p]B)q&!\u0002\u0002\n%\u0019\u0011q\u0001\u0019\u0003\u0011q\u0012\u0017P\\1nKz\u00022!a\u0003\u0016\u001b\u0005\u0001!\u0001F'pG.$U\r\\1zK\u0012|\u0005/\u001a:bi&|gn\u0005\u0002\u0016{\u00059A-\u001a7bs6\u001b\bcA\u0018\u0002\u0016%\u0019\u0011q\u0003\u0019\u0003\t1{gnZ\u0005\u0004\u0003#q\u0014a\u00027pG.|\u0005\u000f\u001e\t\u0006_\u0005}\u00111E\u0005\u0004\u0003C\u0001$AB(qi&|g\u000e\u0005\u0003\u0002&\u0005-RBAA\u0014\u0015\r\tI\u0003T\u0001\u0006Y>\u001c7n]\u0005\u0005\u0003[\t9CA\u0007SK\u0016tGO]1oi2{7m[\u0001\u0010e\u0016\u001c\bo\u001c8tK2{7m[(qiV\u0011\u0011QD\u0001\u0011e\u0016\u001c\bo\u001c8tK2{7m[(qi\u0002\"\u0002\"!\u0003\u00028\u0005e\u00121\b\u0005\b\u0003#Q\u0002\u0019AA\n\u0011%\tYB\u0007I\u0001\u0002\u0004\ti\u0002C\u0005\u00020i\u0001\n\u00111\u0001\u0002\u001e\u0005Y1m\\7qY\u0016$\u0018M\u00197f+\t\t\t\u0005E\u00020\u0003\u0007J1!!\u00121\u0005\u001d\u0011un\u001c7fC:\fqbY8na2,G/\u00192mK~#S-\u001d\u000b\u0004\u0005\u0006-\u0003\u0002\u0003$\u001d\u0003\u0003\u0005\r!!\u0011\u0002\u0019\r|W\u000e\u001d7fi\u0006\u0014G.\u001a\u0011\u0002\u001f\u0005<\u0018-\u001b;FqBL'/\u0019;j_:\f1\u0002\u001e:z\u0007>l\u0007\u000f\\3uKR\u0011\u0011\u0011I\u0001\r_:,\u0005\u0010]5sCRLwN\\\u0001\u000b_:\u001cu.\u001c9mKR,\u0007bBA.'\u0001\u0007\u0011\u0011I\u0001\u0010[&\u001cX.\u0019;dQ\u0016$Gj\\2lg\u0006\u0011\"/\u001e8P]\u0006sw\u000e\u001e5feRC'/Z1e)\u0019\t\t'a \u0002\u0006B\"\u00111MA7!\u0015Y\u0015QMA5\u0013\r\t9\u0007\u0014\u0002\u0007\rV$XO]3\u0011\t\u0005-\u0014Q\u000e\u0007\u0001\t-\ty\u0007FA\u0001\u0002\u0003\u0015\t!!\u001d\u0003\u0007}##'\u0005\u0003\u0002t\u0005e\u0004cA\u0018\u0002v%\u0019\u0011q\u000f\u0019\u0003\u000f9{G\u000f[5oOB\u0019q&a\u001f\n\u0007\u0005u\u0004GA\u0002B]fD\u0001\"!!\u0015\t\u0003\u0007\u00111Q\u0001\u0004MVt\u0007\u0003B\u0018\u0002\u0006\tCq!a\"\u0015\u0001\u0004\t\t%\u0001\btQ>,H\u000eZ\"p[BdW\r^3\u0002)5{7m\u001b#fY\u0006LX\rZ(qKJ\fG/[8o!\r\tYaI\n\u0003G9\"\"!a#\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00133+\t\t)J\u000b\u0003\u0002\u001e\u0005]5FAAM!\u0011\tY*!*\u000e\u0005\u0005u%\u0002BAP\u0003C\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005\r\u0006'\u0001\u0006b]:|G/\u0019;j_:LA!a*\u0002\u001e\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00134\u0001")
public class DelayedOperationTest {
    private volatile DelayedOperationTest$MockDelayedOperation$ MockDelayedOperation$module;
    private DelayedOperationPurgatory<DelayedOperation> purgatory = null;
    private ExecutorService executorService = null;

    public DelayedOperationTest$MockDelayedOperation$ MockDelayedOperation() {
        if (this.MockDelayedOperation$module == null) {
            this.MockDelayedOperation$lzycompute$1();
        }
        return this.MockDelayedOperation$module;
    }

    public DelayedOperationPurgatory<DelayedOperation> purgatory() {
        return this.purgatory;
    }

    public void purgatory_$eq(DelayedOperationPurgatory<DelayedOperation> x$1) {
        this.purgatory = x$1;
    }

    public ExecutorService executorService() {
        return this.executorService;
    }

    public void executorService_$eq(ExecutorService x$1) {
        this.executorService = x$1;
    }

    @Before
    public void setUp() {
        this.purgatory_$eq((DelayedOperationPurgatory<DelayedOperation>)DelayedOperationPurgatory$.MODULE$.apply("mock", DelayedOperationPurgatory$.MODULE$.apply$default$2(), DelayedOperationPurgatory$.MODULE$.apply$default$3(), DelayedOperationPurgatory$.MODULE$.apply$default$4(), DelayedOperationPurgatory$.MODULE$.apply$default$5()));
    }

    @After
    public void tearDown() {
        this.purgatory().shutdown();
        if (this.executorService() != null) {
            this.executorService().shutdown();
        }
    }

    @Test
    public void testLockInTryCompleteElseWatch() {
        DelayedOperation op = new DelayedOperation(null){

            public void onExpiration() {
            }

            public void onComplete() {
            }

            public boolean tryComplete() {
                Assert.assertTrue((boolean)((ReentrantLock)this.lock()).isHeldByCurrentThread());
                return false;
            }

            public boolean safeTryComplete() {
                Assert.fail((String)"tryCompleteElseWatch should not use safeTryComplete");
                return super.safeTryComplete();
            }
        };
        this.purgatory().tryCompleteElseWatch(op, (Seq)new .colon.colon((Object)"key", (List)Nil$.MODULE$));
    }

    @Test
    public void testSafeTryCompleteOrElse() {
        BooleanRef pass = BooleanRef.create((boolean)false);
        Assert.assertFalse((boolean)DelayedOperationTest.op$1(false).safeTryCompleteOrElse((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            pass$1.elem = true;
        }));
        Assert.assertTrue((boolean)pass.elem);
        Assert.assertTrue((boolean)DelayedOperationTest.op$1(true).safeTryCompleteOrElse((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> Assert.fail((String)"this method should NOT be executed")));
    }

    @Test
    public void testRequestSatisfaction() {
        MockDelayedOperation r1 = new MockDelayedOperation(this, 100000L, this.MockDelayedOperation().$lessinit$greater$default$2(), this.MockDelayedOperation().$lessinit$greater$default$3());
        MockDelayedOperation r2 = new MockDelayedOperation(this, 100000L, this.MockDelayedOperation().$lessinit$greater$default$2(), this.MockDelayedOperation().$lessinit$greater$default$3());
        Assert.assertEquals((String)"With no waiting requests, nothing should be satisfied", (long)0L, (long)this.purgatory().checkAndComplete((Object)"test1"));
        Assert.assertFalse((String)"r1 not satisfied and hence watched", (boolean)this.purgatory().tryCompleteElseWatch((DelayedOperation)r1, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"test1"})));
        Assert.assertEquals((String)"Still nothing satisfied", (long)0L, (long)this.purgatory().checkAndComplete((Object)"test1"));
        Assert.assertFalse((String)"r2 not satisfied and hence watched", (boolean)this.purgatory().tryCompleteElseWatch((DelayedOperation)r2, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"test2"})));
        Assert.assertEquals((String)"Still nothing satisfied", (long)0L, (long)this.purgatory().checkAndComplete((Object)"test2"));
        r1.completable_$eq(true);
        Assert.assertEquals((String)"r1 satisfied", (long)1L, (long)this.purgatory().checkAndComplete((Object)"test1"));
        Assert.assertEquals((String)"Nothing satisfied", (long)0L, (long)this.purgatory().checkAndComplete((Object)"test1"));
        r2.completable_$eq(true);
        Assert.assertEquals((String)"r2 satisfied", (long)1L, (long)this.purgatory().checkAndComplete((Object)"test2"));
        Assert.assertEquals((String)"Nothing satisfied", (long)0L, (long)this.purgatory().checkAndComplete((Object)"test2"));
    }

    @Test
    public void testRequestExpiry() {
        long expiration = 20L;
        long start = Time.SYSTEM.hiResClockMs();
        MockDelayedOperation r1 = new MockDelayedOperation(this, expiration, this.MockDelayedOperation().$lessinit$greater$default$2(), this.MockDelayedOperation().$lessinit$greater$default$3());
        MockDelayedOperation r2 = new MockDelayedOperation(this, 200000L, this.MockDelayedOperation().$lessinit$greater$default$2(), this.MockDelayedOperation().$lessinit$greater$default$3());
        Assert.assertFalse((String)"r1 not satisfied and hence watched", (boolean)this.purgatory().tryCompleteElseWatch((DelayedOperation)r1, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"test1"})));
        Assert.assertFalse((String)"r2 not satisfied and hence watched", (boolean)this.purgatory().tryCompleteElseWatch((DelayedOperation)r2, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"test2"})));
        r1.awaitExpiration();
        long elapsed = Time.SYSTEM.hiResClockMs() - start;
        Assert.assertTrue((String)"r1 completed due to expiration", (boolean)r1.isCompleted());
        Assert.assertFalse((String)"r2 hasn't completed", (boolean)r2.isCompleted());
        Assert.assertTrue((String)new StringBuilder(37).append("Time for expiration ").append(elapsed).append(" should at least ").append(expiration).toString(), (elapsed >= expiration ? 1 : 0) != 0);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDelayedFuture() {
        String purgatoryName = "testDelayedFuture";
        DelayedFuturePurgatory purgatory = new DelayedFuturePurgatory(purgatoryName, 0);
        AtomicInteger result = new AtomicInteger();
        Assert.assertFalse((String)"Unnecessary thread created", (boolean)DelayedOperationTest.hasExecutorThread$1(purgatoryName));
        .colon.colon futures1 = new .colon.colon(CompletableFuture.completedFuture(BoxesRunTime.boxToInteger((int)10)), (List)new .colon.colon(CompletableFuture.completedFuture(BoxesRunTime.boxToInteger((int)11)), (List)Nil$.MODULE$));
        DelayedFuture r1 = purgatory.tryCompleteElseWatch(100000L, (Seq)futures1, (Function0)((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> DelayedOperationTest.$anonfun$testDelayedFuture$5((List)futures1, result)));
        Assert.assertTrue((String)"r1 not completed", (boolean)r1.isCompleted());
        Assert.assertEquals((long)21L, (long)result.get());
        Assert.assertFalse((String)"Unnecessary thread created", (boolean)DelayedOperationTest.hasExecutorThread$1(purgatoryName));
        result.set(-1);
        .colon.colon futures2 = new .colon.colon(new CompletableFuture(), (List)new .colon.colon(new CompletableFuture(), (List)Nil$.MODULE$));
        DelayedFuture r2 = purgatory.tryCompleteElseWatch(100000L, (Seq)futures2, (Function0)((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> DelayedOperationTest.$anonfun$testDelayedFuture$6((List)futures2, result)));
        Assert.assertFalse((String)"r2 should be incomplete", (boolean)r2.isCompleted());
        ((CompletableFuture)futures2.head()).complete(Predef$.MODULE$.int2Integer(20));
        Assert.assertFalse((boolean)r2.isCompleted());
        Assert.assertEquals((long)-1L, (long)result.get());
        ((CompletableFuture)futures2.apply(1)).complete(Predef$.MODULE$.int2Integer(21));
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!r2.isCompleted()) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                throw Assertions$.MODULE$.fail(DelayedOperationTest.$anonfun$testDelayedFuture$8(), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 847));
            }
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension((long)waitUntilTrue_waitTimeMs, (long)waitUntilTrue_pause));
        }
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!DelayedOperationTest.$anonfun$testDelayedFuture$9(result)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                throw Assertions$.MODULE$.fail(DelayedOperationTest.$anonfun$testDelayedFuture$10(), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 847));
            }
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension((long)waitUntilTrue_waitTimeMs, (long)waitUntilTrue_pause));
        }
        Assert.assertTrue((String)"Thread not created for executing delayed task", (boolean)DelayedOperationTest.hasExecutorThread$1(purgatoryName));
        result.set(-1);
        .colon.colon futures3 = new .colon.colon(new CompletableFuture(), (List)new .colon.colon(CompletableFuture.completedFuture(BoxesRunTime.boxToInteger((int)31)), (List)Nil$.MODULE$));
        DelayedFuture r3 = purgatory.tryCompleteElseWatch(100000L, (Seq)futures3, (Function0)((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> DelayedOperationTest.$anonfun$testDelayedFuture$11((List)futures3, result)));
        Assert.assertFalse((String)"r3 should be incomplete", (boolean)r3.isCompleted());
        Assert.assertEquals((long)-1L, (long)result.get());
        ((CompletableFuture)futures3.head()).complete(Predef$.MODULE$.int2Integer(30));
        long l5 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l6 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!r3.isCompleted()) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs) {
                throw Assertions$.MODULE$.fail(DelayedOperationTest.$anonfun$testDelayedFuture$13(), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 847));
            }
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension((long)waitUntilTrue_waitTimeMs, (long)waitUntilTrue_pause));
        }
        long l7 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l8 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime4 = System.currentTimeMillis();
        while (!DelayedOperationTest.$anonfun$testDelayedFuture$14(result)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime4 + waitUntilTrue_waitTimeMs) {
                throw Assertions$.MODULE$.fail(DelayedOperationTest.$anonfun$testDelayedFuture$15(), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 847));
            }
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension((long)waitUntilTrue_waitTimeMs, (long)waitUntilTrue_pause));
        }
        result.set(-1);
        long start = Time.SYSTEM.hiResClockMs();
        long expirationMs = 2000L;
        .colon.colon futures4 = new .colon.colon(new CompletableFuture(), (List)new .colon.colon(new CompletableFuture(), (List)Nil$.MODULE$));
        DelayedFuture r4 = purgatory.tryCompleteElseWatch(expirationMs, (Seq)futures4, (Function0)((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> DelayedOperationTest.$anonfun$testDelayedFuture$16((List)futures4, result)));
        ((CompletableFuture)futures4.head()).complete(Predef$.MODULE$.int2Integer(40));
        long l9 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l10 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime5 = System.currentTimeMillis();
        while (!DelayedOperationTest.$anonfun$testDelayedFuture$17((List)futures4)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime5 + waitUntilTrue_waitTimeMs) {
                throw Assertions$.MODULE$.fail(DelayedOperationTest.$anonfun$testDelayedFuture$18(), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 847));
            }
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension((long)waitUntilTrue_waitTimeMs, (long)waitUntilTrue_pause));
        }
        Assert.assertTrue((String)"r4 not completed after timeout", (boolean)r4.isCompleted());
        long elapsed = Time.SYSTEM.hiResClockMs() - start;
        Assert.assertTrue((String)new StringBuilder(37).append("Time for expiration ").append(elapsed).append(" should at least ").append(expirationMs).toString(), (elapsed >= expirationMs ? 1 : 0) != 0);
        Assert.assertEquals((Object)BoxesRunTime.boxToInteger((int)40), ((CompletableFuture)futures4.head()).get());
        Assert.assertEquals(TimeoutException.class, ((Throwable)Assertions$.MODULE$.intercept(() -> DelayedOperationTest.$anonfun$testDelayedFuture$19((List)futures4), ClassTag$.MODULE$.apply(ExecutionException.class), new Position("DelayedOperationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 178))).getCause().getClass());
        Assert.assertEquals((long)40L, (long)result.get());
    }

    @Test
    public void testRequestPurge() {
        MockDelayedOperation r1 = new MockDelayedOperation(this, 100000L, this.MockDelayedOperation().$lessinit$greater$default$2(), this.MockDelayedOperation().$lessinit$greater$default$3());
        MockDelayedOperation r2 = new MockDelayedOperation(this, 100000L, this.MockDelayedOperation().$lessinit$greater$default$2(), this.MockDelayedOperation().$lessinit$greater$default$3());
        MockDelayedOperation r3 = new MockDelayedOperation(this, 100000L, this.MockDelayedOperation().$lessinit$greater$default$2(), this.MockDelayedOperation().$lessinit$greater$default$3());
        this.purgatory().tryCompleteElseWatch((DelayedOperation)r1, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"test1"}));
        this.purgatory().tryCompleteElseWatch((DelayedOperation)r2, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"test1", "test2"}));
        this.purgatory().tryCompleteElseWatch((DelayedOperation)r3, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"test1", "test2", "test3"}));
        Assert.assertEquals((String)"Purgatory should have 3 total delayed operations", (long)3L, (long)this.purgatory().numDelayed());
        Assert.assertEquals((String)"Purgatory should have 6 watched elements", (long)6L, (long)this.purgatory().watched());
        r2.completable_$eq(true);
        r2.tryComplete();
        Assert.assertEquals((String)new StringBuilder(60).append("Purgatory should have 2 total delayed operations instead of ").append(this.purgatory().numDelayed()).toString(), (long)2L, (long)this.purgatory().numDelayed());
        r3.completable_$eq(true);
        r3.tryComplete();
        Assert.assertEquals((String)new StringBuilder(60).append("Purgatory should have 1 total delayed operations instead of ").append(this.purgatory().numDelayed()).toString(), (long)1L, (long)this.purgatory().numDelayed());
        this.purgatory().checkAndComplete((Object)"test1");
        Assert.assertEquals((String)new StringBuilder(52).append("Purgatory should have 4 watched elements instead of ").append(this.purgatory().watched()).toString(), (long)4L, (long)this.purgatory().watched());
        this.purgatory().checkAndComplete((Object)"test2");
        Assert.assertEquals((String)new StringBuilder(52).append("Purgatory should have 2 watched elements instead of ").append(this.purgatory().watched()).toString(), (long)2L, (long)this.purgatory().watched());
        this.purgatory().checkAndComplete((Object)"test3");
        Assert.assertEquals((String)new StringBuilder(52).append("Purgatory should have 1 watched elements instead of ").append(this.purgatory().watched()).toString(), (long)1L, (long)this.purgatory().watched());
    }

    @Test
    public void shouldCancelForKeyReturningCancelledOperations() {
        this.purgatory().tryCompleteElseWatch((DelayedOperation)new MockDelayedOperation(this, 10000L, this.MockDelayedOperation().$lessinit$greater$default$2(), this.MockDelayedOperation().$lessinit$greater$default$3()), (Seq)new .colon.colon((Object)"key", (List)Nil$.MODULE$));
        this.purgatory().tryCompleteElseWatch((DelayedOperation)new MockDelayedOperation(this, 10000L, this.MockDelayedOperation().$lessinit$greater$default$2(), this.MockDelayedOperation().$lessinit$greater$default$3()), (Seq)new .colon.colon((Object)"key", (List)Nil$.MODULE$));
        this.purgatory().tryCompleteElseWatch((DelayedOperation)new MockDelayedOperation(this, 10000L, this.MockDelayedOperation().$lessinit$greater$default$2(), this.MockDelayedOperation().$lessinit$greater$default$3()), (Seq)new .colon.colon((Object)"key2", (List)Nil$.MODULE$));
        List cancelledOperations = this.purgatory().cancelForKey((Object)"key");
        Assert.assertEquals((long)2L, (long)cancelledOperations.size());
        Assert.assertEquals((long)1L, (long)this.purgatory().numDelayed());
        Assert.assertEquals((long)1L, (long)this.purgatory().watched());
    }

    @Test
    public void shouldReturnNilOperationsOnCancelForKeyWhenKeyDoesntExist() {
        List cancelledOperations = this.purgatory().cancelForKey((Object)"key");
        Assert.assertEquals((Object)Nil$.MODULE$, (Object)cancelledOperations);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testTryCompleteWithMultipleThreads() {
        void flatMap_bf;
        void flatMap_f;
        ScheduledExecutorService executor = Executors.newScheduledThreadPool(20);
        this.executorService_$eq(executor);
        Random random = new Random();
        int maxDelayMs = 10;
        int completionAttempts = 20;
        int n = 0;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        IndexedSeq ops = (IndexedSeq)RichInt$.MODULE$.until$extension0(n, 100).map((Function1 & Serializable & scala.Serializable)index -> {
            public class Kafka_server_DelayedOperationTest$TestDelayOperation$1
            extends MockDelayedOperation {
                private final String key;
                private final AtomicInteger completionAttemptsRemaining;
                private final Random random$1;
                private final int maxDelayMs$1;

                public String key() {
                    return this.key;
                }

                public AtomicInteger completionAttemptsRemaining() {
                    return this.completionAttemptsRemaining;
                }

                public boolean tryComplete() {
                    boolean shouldComplete = this.completable();
                    Thread.sleep(this.random$1.nextInt(this.maxDelayMs$1));
                    if (shouldComplete) {
                        return this.forceComplete();
                    }
                    return false;
                }

                public Kafka_server_DelayedOperationTest$TestDelayOperation$1(DelayedOperationTest $outer, int index, int completionAttempts$1, Random random$1, int maxDelayMs$1) {
                    this.random$1 = random$1;
                    this.maxDelayMs$1 = maxDelayMs$1;
                    super($outer, 10000L, $outer.MockDelayedOperation().$lessinit$greater$default$2(), $outer.MockDelayedOperation().$lessinit$greater$default$3());
                    this.key = new StringBuilder(3).append("key").append(index).toString();
                    this.completionAttemptsRemaining = new AtomicInteger(completionAttempts$1);
                }
            }
            return DelayedOperationTest.$anonfun$testTryCompleteWithMultipleThreads$1(this, completionAttempts, random, maxDelayMs, BoxesRunTime.unboxToInt((Object)index));
        }, IndexedSeq$.MODULE$.canBuildFrom());
        int n2 = 1;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        Range.Inclusive inclusive = RichInt$.MODULE$.to$extension0(n2, completionAttempts);
        CanBuildFrom canBuildFrom = IndexedSeq$.MODULE$.canBuildFrom();
        Function1 & Serializable & scala.Serializable intersect = (Function1 & Serializable & scala.Serializable)x$5 -> DelayedOperationTest.$anonfun$testTryCompleteWithMultipleThreads$2(this, ops, random, maxDelayMs, executor, BoxesRunTime.unboxToInt((Object)x$5));
        if (inclusive == null) {
            throw null;
        }
        ((IterableLike)TraversableLike.flatMap$((TraversableLike)inclusive, (Function1)flatMap_f, (CanBuildFrom)flatMap_bf)).foreach((Function1 & Serializable & scala.Serializable)future -> future.get());
        ops.foreach((Function1 & Serializable & scala.Serializable)op -> {
            DelayedOperationTest.$anonfun$testTryCompleteWithMultipleThreads$5(op);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    public void verifyDelayedOperationLock(Function0<MockDelayedOperation> mockDelayedOperation, boolean mismatchedLocks) {
        void createCompletableOperations$1_map_bf;
        void createCompletableOperations$1_map_f;
        void createDelayedOperations$1_map_bf;
        void createDelayedOperations$1_map_f;
        void runOnAnotherThread_shouldComplete;
        void runOnAnotherThread_shouldComplete2;
        void createDelayedOperations$1_map_bf2;
        void createDelayedOperations$1_map_f2;
        void inLock_lock;
        void createDelayedOperations$1_map_bf3;
        void createDelayedOperations$1_map_f3;
        void createDelayedOperations$1_map_bf4;
        void createDelayedOperations$1_map_f4;
        String key = "key";
        this.executorService_$eq(Executors.newSingleThreadExecutor());
        int createDelayedOperations$1_count = 2;
        int n = 1;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        Range.Inclusive inclusive = RichInt$.MODULE$.to$extension0(n, createDelayedOperations$1_count);
        CanBuildFrom canBuildFrom = IndexedSeq$.MODULE$.canBuildFrom();
        Function1 & Serializable & scala.Serializable intersect = (Function1 & Serializable & scala.Serializable)x$6 -> {
            void var4_4;
            MockDelayedOperation $anonfun$verifyDelayedOperationLock$1_op = (MockDelayedOperation)((Object)((Object)((Object)((Object)((Object)((Object)mockDelayedOperation.apply()))))));
            this.purgatory().tryCompleteElseWatch((DelayedOperation)$anonfun$verifyDelayedOperationLock$1_op, (Seq)new .colon.colon((Object)key, (List)Nil$.MODULE$));
            Assert.assertFalse((String)"Not completable", (boolean)$anonfun$verifyDelayedOperationLock$1_op.isCompleted());
            return var4_4;
        };
        if (inclusive == null) {
            throw null;
        }
        ObjectRef ops = ObjectRef.create((Object)((Seq)TraversableLike.map$((TraversableLike)inclusive, (Function1)createDelayedOperations$1_map_f4, (CanBuildFrom)createDelayedOperations$1_map_bf4)));
        this.checkAndComplete$1((Seq)ops.elem, (Seq)ops.elem, key);
        int createDelayedOperations$1_count2 = 2;
        int n2 = 1;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        Range.Inclusive inclusive2 = RichInt$.MODULE$.to$extension0(n2, createDelayedOperations$1_count2);
        CanBuildFrom canBuildFrom2 = IndexedSeq$.MODULE$.canBuildFrom();
        Function1 & Serializable & scala.Serializable intersect2 = (Function1 & Serializable & scala.Serializable)x$6 -> {
            void var4_4;
            MockDelayedOperation $anonfun$verifyDelayedOperationLock$1_op = (MockDelayedOperation)((Object)((Object)((Object)((Object)((Object)((Object)mockDelayedOperation.apply()))))));
            this.purgatory().tryCompleteElseWatch((DelayedOperation)$anonfun$verifyDelayedOperationLock$1_op, (Seq)new .colon.colon((Object)key, (List)Nil$.MODULE$));
            Assert.assertFalse((String)"Not completable", (boolean)$anonfun$verifyDelayedOperationLock$1_op.isCompleted());
            return var4_4;
        };
        if (inclusive2 == null) {
            throw null;
        }
        ops.elem = (Seq)TraversableLike.map$((TraversableLike)inclusive2, (Function1)createDelayedOperations$1_map_f3, (CanBuildFrom)createDelayedOperations$1_map_bf3);
        Lock lock = ((DelayedOperation)((Seq)ops.elem).apply(1)).lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        inLock_lock.lock();
        try {
            this.checkAndComplete$1((Seq)ops.elem, (Seq)ops.elem, key);
        }
        finally {
            inLock_lock.unlock();
        }
        int createDelayedOperations$1_count3 = 2;
        int n3 = 1;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        Range.Inclusive inclusive3 = RichInt$.MODULE$.to$extension0(n3, createDelayedOperations$1_count3);
        CanBuildFrom canBuildFrom3 = IndexedSeq$.MODULE$.canBuildFrom();
        Function1 & Serializable & scala.Serializable intersect3 = (Function1 & Serializable & scala.Serializable)x$6 -> {
            void var4_4;
            MockDelayedOperation $anonfun$verifyDelayedOperationLock$1_op = (MockDelayedOperation)((Object)((Object)((Object)((Object)((Object)((Object)mockDelayedOperation.apply()))))));
            this.purgatory().tryCompleteElseWatch((DelayedOperation)$anonfun$verifyDelayedOperationLock$1_op, (Seq)new .colon.colon((Object)key, (List)Nil$.MODULE$));
            Assert.assertFalse((String)"Not completable", (boolean)$anonfun$verifyDelayedOperationLock$1_op.isCompleted());
            return var4_4;
        };
        if (inclusive3 == null) {
            throw null;
        }
        ops.elem = (Seq)TraversableLike.map$((TraversableLike)inclusive3, (Function1)createDelayedOperations$1_map_f2, (CanBuildFrom)createDelayedOperations$1_map_bf2);
        boolean bl = true;
        JFunction0.mcV.sp & Serializable & scala.Serializable runOnAnotherThread_fun = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((DelayedOperation)((Seq)ops$2.elem).apply(0)).lock().lock();
        Future<?> runOnAnotherThread_future = this.executorService().submit(new Runnable(null, (Function0)runOnAnotherThread_fun){
            private final Function0 fun$1;

            public void run() {
                this.fun$1.apply$mcV$sp();
            }
            {
                this.fun$1 = fun$1;
            }
        });
        if (runOnAnotherThread_shouldComplete2 != false) {
            runOnAnotherThread_future.get();
        } else {
            Assert.assertFalse((String)"Should not have completed", (boolean)runOnAnotherThread_future.isDone());
        }
        try {
            this.checkAndComplete$1((Seq)ops.elem, (Seq)new .colon.colon((Object)((MockDelayedOperation)((Object)((Seq)ops.elem).apply(1))), (List)Nil$.MODULE$), key);
        }
        catch (Throwable throwable) {
            void runOnAnotherThread_shouldComplete3;
            boolean bl2 = true;
            JFunction0.mcV.sp & Serializable & scala.Serializable runOnAnotherThread_fun2 = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((DelayedOperation)((Seq)ops$2.elem).apply(0)).lock().unlock();
            Future<?> runOnAnotherThread_future2 = this.executorService().submit(new /* invalid duplicate definition of identical inner class */);
            if (runOnAnotherThread_shouldComplete3 != false) {
                runOnAnotherThread_future2.get();
            } else {
                Assert.assertFalse((String)"Should not have completed", (boolean)runOnAnotherThread_future2.isDone());
            }
            this.checkAndComplete$1((Seq)new .colon.colon((Object)((MockDelayedOperation)((Object)((Seq)ops.elem).apply(0))), (List)Nil$.MODULE$), (Seq)new .colon.colon((Object)((MockDelayedOperation)((Object)((Seq)ops.elem).apply(0))), (List)Nil$.MODULE$), key);
            throw throwable;
        }
        boolean bl3 = true;
        JFunction0.mcV.sp & Serializable & scala.Serializable runOnAnotherThread_fun3 = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((DelayedOperation)((Seq)ops$2.elem).apply(0)).lock().unlock();
        Future<?> runOnAnotherThread_future3 = this.executorService().submit(new /* invalid duplicate definition of identical inner class */);
        if (runOnAnotherThread_shouldComplete != false) {
            runOnAnotherThread_future3.get();
        } else {
            Assert.assertFalse((String)"Should not have completed", (boolean)runOnAnotherThread_future3.isDone());
        }
        this.checkAndComplete$1((Seq)new .colon.colon((Object)((MockDelayedOperation)((Object)((Seq)ops.elem).apply(0))), (List)Nil$.MODULE$), (Seq)new .colon.colon((Object)((MockDelayedOperation)((Object)((Seq)ops.elem).apply(0))), (List)Nil$.MODULE$), key);
        int createDelayedOperations$1_count4 = 2;
        int n4 = 1;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        Range.Inclusive inclusive4 = RichInt$.MODULE$.to$extension0(n4, createDelayedOperations$1_count4);
        CanBuildFrom canBuildFrom4 = IndexedSeq$.MODULE$.canBuildFrom();
        Function1 & Serializable & scala.Serializable intersect4 = (Function1 & Serializable & scala.Serializable)x$6 -> {
            void var4_4;
            MockDelayedOperation $anonfun$verifyDelayedOperationLock$1_op = (MockDelayedOperation)((Object)((Object)((Object)((Object)((Object)((Object)mockDelayedOperation.apply()))))));
            this.purgatory().tryCompleteElseWatch((DelayedOperation)$anonfun$verifyDelayedOperationLock$1_op, (Seq)new .colon.colon((Object)key, (List)Nil$.MODULE$));
            Assert.assertFalse((String)"Not completable", (boolean)$anonfun$verifyDelayedOperationLock$1_op.isCompleted());
            return var4_4;
        };
        if (inclusive4 == null) {
            throw null;
        }
        ops.elem = (Seq)TraversableLike.map$((TraversableLike)inclusive4, (Function1)createDelayedOperations$1_map_f, (CanBuildFrom)createDelayedOperations$1_map_bf);
        Option<ReentrantLock> option = ((MockDelayedOperation)((Object)((Seq)ops.elem).apply(0))).responseLockOpt();
        if (option == null) {
            throw null;
        }
        Option<ReentrantLock> foreach_this = option;
        if (!foreach_this.isEmpty()) {
            ReentrantLock reentrantLock = (ReentrantLock)foreach_this.get();
            DelayedOperationTest.$anonfun$verifyDelayedOperationLock$9(this, ops, mismatchedLocks, key, reentrantLock);
        }
        int createCompletableOperations$1_count = 2;
        int n5 = 1;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        Range.Inclusive inclusive5 = RichInt$.MODULE$.to$extension0(n5, createCompletableOperations$1_count);
        CanBuildFrom canBuildFrom5 = IndexedSeq$.MODULE$.canBuildFrom();
        Function1 & Serializable & scala.Serializable intersect5 = (Function1 & Serializable & scala.Serializable)x$7 -> {
            void var2_2;
            MockDelayedOperation $anonfun$verifyDelayedOperationLock$2_op = (MockDelayedOperation)((Object)((Object)((Object)mockDelayedOperation.apply())));
            $anonfun$verifyDelayedOperationLock$2_op.completable_$eq(true);
            return var2_2;
        };
        if (inclusive5 == null) {
            throw null;
        }
        ops.elem = (Seq)TraversableLike.map$((TraversableLike)inclusive5, (Function1)createCompletableOperations$1_map_f, (CanBuildFrom)createCompletableOperations$1_map_bf);
        ((Seq)ops.elem).foreach((Function1 & Serializable & scala.Serializable)op -> {
            DelayedOperationTest.$anonfun$verifyDelayedOperationLock$12(this, key, op);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    private Future<?> runOnAnotherThread(Function0<BoxedUnit> fun, boolean shouldComplete) {
        void var3_3;
        Future<?> future = this.executorService().submit(new /* invalid duplicate definition of identical inner class */);
        if (shouldComplete) {
            future.get();
        } else {
            Assert.assertFalse((String)"Should not have completed", (boolean)future.isDone());
        }
        return var3_3;
    }

    private final void MockDelayedOperation$lzycompute$1() {
        synchronized (this) {
            if (this.MockDelayedOperation$module == null) {
                this.MockDelayedOperation$module = new DelayedOperationTest$MockDelayedOperation$(this);
            }
            return;
        }
    }

    private static final DelayedOperation op$1(boolean shouldComplete) {
        return new DelayedOperation(null, shouldComplete){
            private final boolean shouldComplete$1;

            public void onExpiration() {
            }

            public void onComplete() {
            }

            public boolean tryComplete() {
                Assert.assertTrue((boolean)((ReentrantLock)this.lock()).isHeldByCurrentThread());
                return this.shouldComplete$1;
            }
            {
                this.shouldComplete$1 = shouldComplete$1;
                super(100000L, DelayedOperation$.MODULE$.$lessinit$greater$default$2());
            }
        };
    }

    private static final boolean hasExecutorThread$1(String purgatoryName$1) {
        return ((IterableLike)((SetLike)CollectionConverters$.MODULE$.asScalaSetConverter(Thread.getAllStackTraces().keySet()).asScala()).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getName(), Set$.MODULE$.canBuildFrom())).exists((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.contains(new StringBuilder(16).append("DelayedExecutor-").append(purgatoryName$1).toString())));
    }

    public static final /* synthetic */ int $anonfun$testDelayedFuture$4(CompletableFuture x$4) {
        return (Integer)x$4.get();
    }

    private static final void updateResult$1(List futures, AtomicInteger result$1) {
        result$1.set(BoxesRunTime.unboxToInt((Object)((TraversableOnce)((List)futures.filterNot((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.isCompletedExceptionally()))).map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToInteger((int)DelayedOperationTest.$anonfun$testDelayedFuture$4(x$4)), List$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)));
    }

    public static final /* synthetic */ void $anonfun$testDelayedFuture$5(List futures1$1, AtomicInteger result$1) {
        DelayedOperationTest.updateResult$1(futures1$1, result$1);
    }

    public static final /* synthetic */ void $anonfun$testDelayedFuture$6(List futures2$1, AtomicInteger result$1) {
        DelayedOperationTest.updateResult$1(futures2$1, result$1);
    }

    public static final /* synthetic */ String $anonfun$testDelayedFuture$8() {
        return "r2 not completed";
    }

    public static final /* synthetic */ boolean $anonfun$testDelayedFuture$9(AtomicInteger result$1) {
        return result$1.get() == 41;
    }

    public static final /* synthetic */ String $anonfun$testDelayedFuture$10() {
        return "callback not invoked";
    }

    public static final /* synthetic */ void $anonfun$testDelayedFuture$11(List futures3$1, AtomicInteger result$1) {
        DelayedOperationTest.updateResult$1(futures3$1, result$1);
    }

    public static final /* synthetic */ String $anonfun$testDelayedFuture$13() {
        return "r3 not completed";
    }

    public static final /* synthetic */ boolean $anonfun$testDelayedFuture$14(AtomicInteger result$1) {
        return result$1.get() == 61;
    }

    public static final /* synthetic */ String $anonfun$testDelayedFuture$15() {
        return "callback not invoked";
    }

    public static final /* synthetic */ void $anonfun$testDelayedFuture$16(List futures4$1, AtomicInteger result$1) {
        DelayedOperationTest.updateResult$1(futures4$1, result$1);
    }

    public static final /* synthetic */ boolean $anonfun$testDelayedFuture$17(List futures4$1) {
        return ((CompletableFuture)futures4$1.apply(1)).isDone();
    }

    public static final /* synthetic */ String $anonfun$testDelayedFuture$18() {
        return "r4 futures not expired";
    }

    public static final /* synthetic */ Integer $anonfun$testDelayedFuture$19(List futures4$1) {
        return (Integer)((CompletableFuture)futures4$1.apply(1)).get();
    }

    public static final /* synthetic */ TestDelayOperation.1 $anonfun$testTryCompleteWithMultipleThreads$1(DelayedOperationTest $this, int completionAttempts$1, Random random$1, int maxDelayMs$1, int index) {
        Kafka_server_DelayedOperationTest$TestDelayOperation$1 op = new Kafka_server_DelayedOperationTest$TestDelayOperation$1($this, index, completionAttempts$1, random$1, maxDelayMs$1);
        $this.purgatory().tryCompleteElseWatch((DelayedOperation)op, (Seq)new .colon.colon((Object)op.key(), (List)Nil$.MODULE$));
        return op;
    }

    private final Future scheduleTryComplete$1(TestDelayOperation.1 op, long delayMs, ScheduledExecutorService executor$1) {
        return executor$1.schedule(new Runnable(this, op){
            private final /* synthetic */ DelayedOperationTest $outer;
            private final Kafka_server_DelayedOperationTest$TestDelayOperation$1 op$2;

            public void run() {
                if (this.op$2.completionAttemptsRemaining().decrementAndGet() == 0) {
                    this.op$2.completable_$eq(true);
                }
                this.$outer.purgatory().checkAndComplete((Object)this.op$2.key());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.op$2 = op$2;
            }
        }, delayMs, TimeUnit.MILLISECONDS);
    }

    public static final /* synthetic */ IndexedSeq $anonfun$testTryCompleteWithMultipleThreads$2(DelayedOperationTest $this, IndexedSeq ops$1, Random random$1, int maxDelayMs$1, ScheduledExecutorService executor$1, int x$5) {
        return (IndexedSeq)ops$1.map((Function1 & Serializable & scala.Serializable)op -> {
            return $this.scheduleTryComplete$1((Kafka_server_DelayedOperationTest$TestDelayOperation$1)((Object)op), random$1.nextInt(maxDelayMs$1), executor$1);
        }, IndexedSeq$.MODULE$.canBuildFrom());
    }

    public static final /* synthetic */ void $anonfun$testTryCompleteWithMultipleThreads$5(TestDelayOperation.1 op) {
        Assert.assertTrue((String)"Operation should have completed", (boolean)op.isCompleted());
    }

    public static final /* synthetic */ MockDelayedOperation $anonfun$verifyDelayedOperationLock$1(DelayedOperationTest $this, Function0 mockDelayedOperation$1, String key$1, int x$6) {
        MockDelayedOperation op = (MockDelayedOperation)((Object)mockDelayedOperation$1.apply());
        $this.purgatory().tryCompleteElseWatch((DelayedOperation)op, (Seq)new .colon.colon((Object)key$1, (List)Nil$.MODULE$));
        Assert.assertFalse((String)"Not completable", (boolean)op.isCompleted());
        return op;
    }

    /*
     * WARNING - void declaration
     */
    private final Seq createDelayedOperations$1(int count, Function0 mockDelayedOperation$1, String key$1) {
        void map_bf;
        void map_f;
        int n = 1;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        Range.Inclusive inclusive = RichInt$.MODULE$.to$extension0(n, count);
        CanBuildFrom canBuildFrom = IndexedSeq$.MODULE$.canBuildFrom();
        Function1 & Serializable & scala.Serializable intersect = (Function1 & Serializable & scala.Serializable)x$6 -> {
            void var4_4;
            MockDelayedOperation $anonfun$verifyDelayedOperationLock$1_op = (MockDelayedOperation)((Object)((Object)((Object)((Object)((Object)((Object)mockDelayedOperation.apply()))))));
            this.purgatory().tryCompleteElseWatch((DelayedOperation)$anonfun$verifyDelayedOperationLock$1_op, (Seq)new .colon.colon((Object)key, (List)Nil$.MODULE$));
            Assert.assertFalse((String)"Not completable", (boolean)$anonfun$verifyDelayedOperationLock$1_op.isCompleted());
            return var4_4;
        };
        if (inclusive == null) {
            throw null;
        }
        return (Seq)TraversableLike.map$((TraversableLike)inclusive, (Function1)map_f, (CanBuildFrom)map_bf);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ MockDelayedOperation $anonfun$verifyDelayedOperationLock$2(Function0 mockDelayedOperation$1, int x$7) {
        void var2_2;
        MockDelayedOperation op = (MockDelayedOperation)((Object)mockDelayedOperation$1.apply());
        op.completable_$eq(true);
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private static final Seq createCompletableOperations$1(int count, Function0 mockDelayedOperation$1) {
        void map_bf;
        void map_f;
        int n = 1;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        Range.Inclusive inclusive = RichInt$.MODULE$.to$extension0(n, count);
        CanBuildFrom canBuildFrom = IndexedSeq$.MODULE$.canBuildFrom();
        Function1 & Serializable & scala.Serializable intersect = (Function1 & Serializable & scala.Serializable)x$7 -> {
            void var2_2;
            MockDelayedOperation $anonfun$verifyDelayedOperationLock$2_op = (MockDelayedOperation)((Object)((Object)((Object)mockDelayedOperation.apply())));
            $anonfun$verifyDelayedOperationLock$2_op.completable_$eq(true);
            return var2_2;
        };
        if (inclusive == null) {
            throw null;
        }
        return (Seq)TraversableLike.map$((TraversableLike)inclusive, (Function1)map_f, (CanBuildFrom)map_bf);
    }

    public static final /* synthetic */ void $anonfun$verifyDelayedOperationLock$4(MockDelayedOperation op) {
        Assert.assertTrue((String)"Should have completed", (boolean)op.isCompleted());
    }

    public static final /* synthetic */ void $anonfun$verifyDelayedOperationLock$5(MockDelayedOperation op) {
        Assert.assertFalse((String)"Should not have completed", (boolean)op.isCompleted());
    }

    private final void checkAndComplete$1(Seq completableOps, Seq expectedComplete, String key$1) {
        completableOps.foreach((Function1 & Serializable & scala.Serializable)op -> {
            op.completable_$eq(true);
            return BoxedUnit.UNIT;
        });
        int completed = this.purgatory().checkAndComplete((Object)key$1);
        Assert.assertEquals((long)expectedComplete.size(), (long)completed);
        expectedComplete.foreach((Function1 & Serializable & scala.Serializable)op -> {
            DelayedOperationTest.$anonfun$verifyDelayedOperationLock$4(op);
            return BoxedUnit.UNIT;
        });
        ((Set)completableOps.toSet().$minus$minus((GenTraversableOnce)expectedComplete)).foreach((Function1 & Serializable & scala.Serializable)op -> {
            DelayedOperationTest.$anonfun$verifyDelayedOperationLock$5(op);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$verifyDelayedOperationLock$9(DelayedOperationTest $this, ObjectRef ops$2, boolean mismatchedLocks$1, String key$1, ReentrantLock lock) {
        void runOnAnotherThread_shouldComplete;
        void runOnAnotherThread_shouldComplete2;
        boolean bl = true;
        JFunction0.mcV.sp & Serializable & scala.Serializable runOnAnotherThread_fun = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> lock.lock();
        Future<?> runOnAnotherThread_future = $this.executorService().submit(new /* invalid duplicate definition of identical inner class */);
        if (runOnAnotherThread_shouldComplete2 != false) {
            runOnAnotherThread_future.get();
        } else {
            Assert.assertFalse((String)"Should not have completed", (boolean)runOnAnotherThread_future.isDone());
        }
        try {
            try {
                $this.checkAndComplete$1((Seq)ops$2.elem, (Seq)new .colon.colon((Object)((MockDelayedOperation)((Object)((Seq)ops$2.elem).apply(1))), (List)Nil$.MODULE$), key$1);
                Assert.assertFalse((String)"Should have failed with mismatched locks", (boolean)mismatchedLocks$1);
            }
            catch (IllegalStateException illegalStateException) {
                Assert.assertTrue((String)"Should not have failed with valid locks", (boolean)mismatchedLocks$1);
            }
        }
        catch (Throwable throwable) {
            void runOnAnotherThread_shouldComplete3;
            boolean bl2 = true;
            JFunction0.mcV.sp & Serializable & scala.Serializable runOnAnotherThread_fun2 = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> lock.unlock();
            Future<?> runOnAnotherThread_future2 = $this.executorService().submit(new /* invalid duplicate definition of identical inner class */);
            if (runOnAnotherThread_shouldComplete3 != false) {
                runOnAnotherThread_future2.get();
            } else {
                Assert.assertFalse((String)"Should not have completed", (boolean)runOnAnotherThread_future2.isDone());
            }
            $this.checkAndComplete$1((Seq)new .colon.colon((Object)((MockDelayedOperation)((Object)((Seq)ops$2.elem).apply(0))), (List)Nil$.MODULE$), (Seq)new .colon.colon((Object)((MockDelayedOperation)((Object)((Seq)ops$2.elem).apply(0))), (List)Nil$.MODULE$), key$1);
            throw throwable;
        }
        boolean bl3 = true;
        JFunction0.mcV.sp & Serializable & scala.Serializable runOnAnotherThread_fun3 = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> lock.unlock();
        Future<?> runOnAnotherThread_future3 = $this.executorService().submit(new /* invalid duplicate definition of identical inner class */);
        if (runOnAnotherThread_shouldComplete != false) {
            runOnAnotherThread_future3.get();
        } else {
            Assert.assertFalse((String)"Should not have completed", (boolean)runOnAnotherThread_future3.isDone());
        }
        $this.checkAndComplete$1((Seq)new .colon.colon((Object)((MockDelayedOperation)((Object)((Seq)ops$2.elem).apply(0))), (List)Nil$.MODULE$), (Seq)new .colon.colon((Object)((MockDelayedOperation)((Object)((Seq)ops$2.elem).apply(0))), (List)Nil$.MODULE$), key$1);
    }

    public static final /* synthetic */ void $anonfun$verifyDelayedOperationLock$12(DelayedOperationTest $this, String key$1, MockDelayedOperation op) {
        Assert.assertTrue((String)"Should have completed", (boolean)$this.purgatory().tryCompleteElseWatch((DelayedOperation)op, (Seq)new .colon.colon((Object)key$1, (List)Nil$.MODULE$)));
        Assert.assertTrue((String)"Should have completed", (boolean)op.isCompleted());
    }

    public static final /* synthetic */ Object $anonfun$verifyDelayedOperationLock$9$adapted(DelayedOperationTest $this, ObjectRef ops$2, boolean mismatchedLocks$1, String key$1, ReentrantLock lock) {
        DelayedOperationTest.$anonfun$verifyDelayedOperationLock$9($this, ops$2, mismatchedLocks$1, key$1, lock);
        return BoxedUnit.UNIT;
    }

    public class MockDelayedOperation
    extends DelayedOperation {
        private final Option<ReentrantLock> responseLockOpt;
        private boolean completable;
        public final /* synthetic */ DelayedOperationTest $outer;

        public Option<ReentrantLock> responseLockOpt() {
            return this.responseLockOpt;
        }

        public boolean completable() {
            return this.completable;
        }

        public void completable_$eq(boolean x$1) {
            this.completable = x$1;
        }

        public synchronized void awaitExpiration() {
            this.wait();
        }

        public boolean tryComplete() {
            if (this.completable()) {
                return this.forceComplete();
            }
            return false;
        }

        public void onExpiration() {
        }

        public void onComplete() {
            Option<ReentrantLock> option = this.responseLockOpt();
            if (option == null) {
                throw null;
            }
            Option<ReentrantLock> foreach_this = option;
            if (!foreach_this.isEmpty()) {
                MockDelayedOperation.$anonfun$onComplete$1((ReentrantLock)foreach_this.get());
            }
            synchronized (this) {
                this.notify();
                return;
            }
        }

        public /* synthetic */ DelayedOperationTest kafka$server$DelayedOperationTest$MockDelayedOperation$$$outer() {
            return this.$outer;
        }

        public static final /* synthetic */ void $anonfun$onComplete$1(ReentrantLock lock) {
            if (!lock.tryLock()) {
                throw new IllegalStateException("Response callback lock could not be acquired in callback");
            }
        }

        public MockDelayedOperation(DelayedOperationTest $outer, long delayMs, Option<ReentrantLock> lockOpt, Option<ReentrantLock> responseLockOpt) {
            this.responseLockOpt = responseLockOpt;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            super(delayMs, lockOpt);
            this.completable = false;
        }

        public static final /* synthetic */ Object $anonfun$onComplete$1$adapted(ReentrantLock lock) {
            MockDelayedOperation.$anonfun$onComplete$1(lock);
            return BoxedUnit.UNIT;
        }
    }
}

