/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import kafka.server.BrokerFeatures;
import kafka.server.BrokerFeatures$;
import kafka.server.FeatureCacheUpdateException;
import kafka.server.FinalizedFeatureCache;
import kafka.server.FinalizedFeaturesAndEpoch;
import org.apache.kafka.common.feature.Features;
import org.apache.kafka.common.feature.FinalizedVersionRange;
import org.apache.kafka.common.feature.SupportedVersionRange;
import org.junit.Assert;
import org.junit.Test;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u000192Aa\u0002\u0005\u0001\u001b!)A\u0003\u0001C\u0001+!)\u0001\u0004\u0001C\u00013!)a\u0005\u0001C\u00013!)\u0001\u0006\u0001C\u00013!)!\u0006\u0001C\u00013!)A\u0006\u0001C\u00013\tIb)\u001b8bY&TX\r\u001a$fCR,(/Z\"bG\",G+Z:u\u0015\tI!\"\u0001\u0004tKJ4XM\u001d\u0006\u0002\u0017\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\u000f!\ty!#D\u0001\u0011\u0015\u0005\t\u0012!B:dC2\f\u0017BA\n\u0011\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012A\u0006\t\u0003/\u0001i\u0011\u0001C\u0001\ni\u0016\u001cH/R7qif$\u0012A\u0007\t\u0003\u001fmI!\u0001\b\t\u0003\tUs\u0017\u000e\u001e\u0015\u0003\u0005y\u0001\"a\b\u0013\u000e\u0003\u0001R!!\t\u0012\u0002\u000b),h.\u001b;\u000b\u0003\r\n1a\u001c:h\u0013\t)\u0003E\u0001\u0003UKN$\u0018\u0001\u000b;fgR,\u0006\u000fZ1uK>\u0013H\u000b\u001b:po\u001a\u000b\u0017\u000e\\3e\tV,Gk\\%om\u0006d\u0017\u000eZ#q_\u000eD\u0007FA\u0002\u001f\u0003-\"Xm\u001d;Va\u0012\fG/Z(s)\"\u0014xn\u001e$bS2,G\rR;f)>LeN^1mS\u00124U-\u0019;ve\u0016\u001c\bF\u0001\u0003\u001f\u0003a!Xm\u001d;Va\u0012\fG/Z(s)\"\u0014xn^*vG\u000e,7o\u001d\u0015\u0003\u000by\t\u0011\u0002^3ti\u000ecW-\u0019:)\u0005\u0019q\u0002")
public class FinalizedFeatureCacheTest {
    @Test
    public void testEmpty() {
        Assert.assertTrue((boolean)new FinalizedFeatureCache(BrokerFeatures$.MODULE$.createDefault()).get().isEmpty());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testUpdateOrThrowFailedDueToInvalidEpoch() {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        void $minus$greater$extension_y2;
        void $minus$greater$extension_$this2;
        Tuple2[] tuple2Array = new Tuple2[1];
        SupportedVersionRange supportedVersionRange = new SupportedVersionRange(1, 4);
        Object object = Predef$.MODULE$.ArrowAssoc((Object)"feature_1");
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y2);
        scala.collection.immutable.Map supportedFeatures = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array));
        BrokerFeatures brokerFeatures = BrokerFeatures$.MODULE$.createDefault();
        brokerFeatures.setSupportedFeatures(Features.supportedFeatures((java.util.Map)((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)supportedFeatures).asJava())));
        Tuple2[] tuple2Array2 = new Tuple2[1];
        FinalizedVersionRange finalizedVersionRange = new FinalizedVersionRange(1, 4);
        Object object2 = Predef$.MODULE$.ArrowAssoc((Object)"feature_1");
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array2[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        scala.collection.immutable.Map features = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array2));
        Features finalizedFeatures = Features.finalizedFeatures((java.util.Map)((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)features).asJava()));
        FinalizedFeatureCache cache = new FinalizedFeatureCache(brokerFeatures);
        cache.updateOrThrow(finalizedFeatures, 10L);
        Assert.assertTrue((boolean)cache.get().isDefined());
        Assert.assertEquals((Object)finalizedFeatures, (Object)((FinalizedFeaturesAndEpoch)cache.get().get()).features());
        Assert.assertEquals((long)10L, (long)((FinalizedFeaturesAndEpoch)cache.get().get()).epoch());
        Assert.assertThrows(FeatureCacheUpdateException.class, () -> cache.updateOrThrow(finalizedFeatures, 9L));
        Assert.assertTrue((boolean)cache.get().isDefined());
        Assert.assertEquals((Object)finalizedFeatures, (Object)((FinalizedFeaturesAndEpoch)cache.get().get()).features());
        Assert.assertEquals((long)10L, (long)((FinalizedFeaturesAndEpoch)cache.get().get()).epoch());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testUpdateOrThrowFailedDueToInvalidFeatures() {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        void $minus$greater$extension_y2;
        void $minus$greater$extension_$this2;
        Tuple2[] tuple2Array = new Tuple2[1];
        SupportedVersionRange supportedVersionRange = new SupportedVersionRange(1, 1);
        Object object = Predef$.MODULE$.ArrowAssoc((Object)"feature_1");
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y2);
        scala.collection.immutable.Map supportedFeatures = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array));
        BrokerFeatures brokerFeatures = BrokerFeatures$.MODULE$.createDefault();
        brokerFeatures.setSupportedFeatures(Features.supportedFeatures((java.util.Map)((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)supportedFeatures).asJava())));
        Tuple2[] tuple2Array2 = new Tuple2[1];
        FinalizedVersionRange finalizedVersionRange = new FinalizedVersionRange(1, 2);
        Object object2 = Predef$.MODULE$.ArrowAssoc((Object)"feature_1");
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array2[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        scala.collection.immutable.Map features = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array2));
        Features finalizedFeatures = Features.finalizedFeatures((java.util.Map)((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)features).asJava()));
        FinalizedFeatureCache cache = new FinalizedFeatureCache(brokerFeatures);
        Assert.assertThrows(FeatureCacheUpdateException.class, () -> cache.updateOrThrow(finalizedFeatures, 12L));
        Assert.assertTrue((boolean)cache.isEmpty());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testUpdateOrThrowSuccess() {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        void $minus$greater$extension_y2;
        void $minus$greater$extension_$this2;
        Tuple2[] tuple2Array = new Tuple2[1];
        SupportedVersionRange supportedVersionRange = new SupportedVersionRange(1, 4);
        Object object = Predef$.MODULE$.ArrowAssoc((Object)"feature_1");
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y2);
        scala.collection.immutable.Map supportedFeatures = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array));
        BrokerFeatures brokerFeatures = BrokerFeatures$.MODULE$.createDefault();
        brokerFeatures.setSupportedFeatures(Features.supportedFeatures((java.util.Map)((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)supportedFeatures).asJava())));
        Tuple2[] tuple2Array2 = new Tuple2[1];
        FinalizedVersionRange finalizedVersionRange = new FinalizedVersionRange(2, 3);
        Object object2 = Predef$.MODULE$.ArrowAssoc((Object)"feature_1");
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array2[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        scala.collection.immutable.Map features = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array2));
        Features finalizedFeatures = Features.finalizedFeatures((java.util.Map)((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)features).asJava()));
        FinalizedFeatureCache cache = new FinalizedFeatureCache(brokerFeatures);
        cache.updateOrThrow(finalizedFeatures, 12L);
        Assert.assertTrue((boolean)cache.get().isDefined());
        Assert.assertEquals((Object)finalizedFeatures, (Object)((FinalizedFeaturesAndEpoch)cache.get().get()).features());
        Assert.assertEquals((long)12L, (long)((FinalizedFeaturesAndEpoch)cache.get().get()).epoch());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testClear() {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        void $minus$greater$extension_y2;
        void $minus$greater$extension_$this2;
        Tuple2[] tuple2Array = new Tuple2[1];
        SupportedVersionRange supportedVersionRange = new SupportedVersionRange(1, 4);
        Object object = Predef$.MODULE$.ArrowAssoc((Object)"feature_1");
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y2);
        scala.collection.immutable.Map supportedFeatures = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array));
        BrokerFeatures brokerFeatures = BrokerFeatures$.MODULE$.createDefault();
        brokerFeatures.setSupportedFeatures(Features.supportedFeatures((java.util.Map)((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)supportedFeatures).asJava())));
        Tuple2[] tuple2Array2 = new Tuple2[1];
        FinalizedVersionRange finalizedVersionRange = new FinalizedVersionRange(2, 3);
        Object object2 = Predef$.MODULE$.ArrowAssoc((Object)"feature_1");
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array2[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        scala.collection.immutable.Map features = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array2));
        Features finalizedFeatures = Features.finalizedFeatures((java.util.Map)((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)features).asJava()));
        FinalizedFeatureCache cache = new FinalizedFeatureCache(brokerFeatures);
        cache.updateOrThrow(finalizedFeatures, 12L);
        Assert.assertTrue((boolean)cache.get().isDefined());
        Assert.assertEquals((Object)finalizedFeatures, (Object)((FinalizedFeaturesAndEpoch)cache.get().get()).features());
        Assert.assertEquals((long)12L, (long)((FinalizedFeaturesAndEpoch)cache.get().get()).epoch());
        cache.clear();
        Assert.assertTrue((boolean)cache.isEmpty());
    }
}

