/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeoutException;
import kafka.server.BrokerFeatures;
import kafka.server.BrokerFeatures$;
import kafka.server.FinalizedFeatureCache;
import kafka.server.FinalizedFeatureChangeListener;
import kafka.server.FinalizedFeaturesAndEpoch;
import kafka.utils.TestUtils$;
import kafka.zk.FeatureZNode;
import kafka.zk.FeatureZNode$;
import kafka.zk.FeatureZNodeStatus$;
import kafka.zk.ZkVersion$;
import kafka.zk.ZooKeeperTestHarness;
import org.apache.kafka.common.feature.Features;
import org.apache.kafka.common.feature.FinalizedVersionRange;
import org.apache.kafka.common.feature.SupportedVersionRange;
import org.apache.kafka.common.utils.Exit;
import org.junit.Assert;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.RichLong$;

@ScalaSignature(bytes="\u0006\u0001M3A\u0001D\u0007\u0001%!)\u0011\u0004\u0001C\u00015!)Q\u0004\u0001C\u0005=!)!\u0005\u0001C\u0005G!)q\u0005\u0001C\u0005Q!)\u0011\b\u0001C\u0001u!)q\t\u0001C\u0001u!)\u0011\n\u0001C\u0001u!)1\n\u0001C\u0001u!)Q\n\u0001C\u0001u!)q\n\u0001C\u0001u!)\u0011\u000b\u0001C\u0001u\t\u0011c)\u001b8bY&TX\r\u001a$fCR,(/Z\"iC:<W\rT5ti\u0016tWM\u001d+fgRT!AD\b\u0002\rM,'O^3s\u0015\u0005\u0001\u0012!B6bM.\f7\u0001A\n\u0003\u0001M\u0001\"\u0001F\f\u000e\u0003UQ!AF\b\u0002\u0005i\\\u0017B\u0001\r\u0016\u0005QQvn\\&fKB,'\u000fV3ti\"\u000b'O\\3tg\u00061A(\u001b8jiz\"\u0012a\u0007\t\u00039\u0001i\u0011!D\u0001\u0015GJ,\u0017\r^3Ce>\\WM\u001d$fCR,(/Z:\u0015\u0003}\u0001\"\u0001\b\u0011\n\u0005\u0005j!A\u0004\"s_.,'OR3biV\u0014Xm]\u0001\u0018GJ,\u0017\r^3GS:\fG.\u001b>fI\u001a+\u0017\r^;sKN$\u0012\u0001\n\t\u00039\u0015J!AJ\u0007\u00033\u0019Kg.\u00197ju\u0016$g)Z1ukJ,7/\u00118e\u000bB|7\r[\u0001\u000fGJ,\u0017\r^3MSN$XM\\3s)\rIC&\r\t\u00039)J!aK\u0007\u0003=\u0019Kg.\u00197ju\u0016$g)Z1ukJ,7\t[1oO\u0016d\u0015n\u001d;f]\u0016\u0014\b\"B\u0017\u0005\u0001\u0004q\u0013!B2bG\",\u0007C\u0001\u000f0\u0013\t\u0001TBA\u000bGS:\fG.\u001b>fI\u001a+\u0017\r^;sK\u000e\u000b7\r[3\t\u000bI\"\u0001\u0019A\u001a\u0002)\u0015D\b/Z2uK\u0012\u001c\u0015m\u00195f\u0007>tG/\u001a8u!\r!t\u0007J\u0007\u0002k)\ta'A\u0003tG\u0006d\u0017-\u0003\u00029k\t1q\n\u001d;j_:\fQ\u0005^3ti&s\u0017\u000e^*vG\u000e,7o]!oI:{G/\u001b4jG\u0006$\u0018n\u001c8Tk\u000e\u001cWm]:\u0015\u0003m\u0002\"\u0001\u000e\u001f\n\u0005u*$\u0001B+oSRD#!B \u0011\u0005\u0001+U\"A!\u000b\u0005\t\u001b\u0015!\u00026v]&$(\"\u0001#\u0002\u0007=\u0014x-\u0003\u0002G\u0003\n!A+Z:u\u00031\"Xm\u001d;GK\u0006$XO]3[\u001d>$W\rR3mKR,gj\u001c;jM&\u001c\u0017\r^5p]B\u0013xnY3tg&tw\r\u000b\u0002\u0007\u007f\u0005yC/Z:u\r\u0016\fG/\u001e:f5:{G-\u001a#jg\u0006\u0014G.\u001b8h\u001d>$\u0018NZ5dCRLwN\u001c)s_\u000e,7o]5oO\"\u0012qaP\u0001.i\u0016\u001cHoQ1dQ\u0016,\u0006\u000fZ1uK^\u000b\u0017\u000e\u001e$bS2\u001chi\u001c:V]J,\u0017m\u00195bE2,g+\u001a:tS>t\u0007F\u0001\u0005@\u0003)\"Xm\u001d;J]&$h)Y5mkJ,G)^3U_\u001a+\u0017\r^;sK&s7m\\7qCRL'-\u001b7jifD#!C \u0002GQ,7\u000f^%oSR4\u0015-\u001b7ve\u0016$U/\u001a+p\u0013:4\u0018\r\\5e/\u0006LG\u000fV5nK\"\u0012!bP\u00013i\u0016\u001cHOT8uS\u001aL7-\u0019;j_:4\u0015-\u001b7ve\u0016$U/\u001a+p\r\u0016\fG/\u001e:f\u0013:\u001cw.\u001c9bi&\u0014\u0017\u000e\\5us\"\u00121b\u0010")
public class FinalizedFeatureChangeListenerTest
extends ZooKeeperTestHarness {
    /*
     * WARNING - void declaration
     */
    private BrokerFeatures createBrokerFeatures() {
        void var2_6;
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        void $minus$greater$extension_y2;
        void $minus$greater$extension_$this2;
        Tuple2[] tuple2Array = new Tuple2[2];
        SupportedVersionRange supportedVersionRange = new SupportedVersionRange(1, 4);
        Object object = Predef$.MODULE$.ArrowAssoc((Object)"feature_1");
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y2);
        SupportedVersionRange supportedVersionRange2 = new SupportedVersionRange(1, 3);
        Object object2 = Predef$.MODULE$.ArrowAssoc((Object)"feature_2");
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[1] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        scala.collection.immutable.Map supportedFeaturesMap = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array));
        BrokerFeatures brokerFeatures = BrokerFeatures$.MODULE$.createDefault();
        brokerFeatures.setSupportedFeatures(Features.supportedFeatures((java.util.Map)((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)supportedFeaturesMap).asJava())));
        return var2_6;
    }

    /*
     * WARNING - void declaration
     */
    private FinalizedFeaturesAndEpoch createFinalizedFeatures() {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        Tuple2[] tuple2Array = new Tuple2[1];
        FinalizedVersionRange finalizedVersionRange = new FinalizedVersionRange(2, 3);
        Object object = Predef$.MODULE$.ArrowAssoc((Object)"feature_1");
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        scala.collection.immutable.Map finalizedFeaturesMap = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array));
        Features finalizedFeatures = Features.finalizedFeatures((java.util.Map)((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)finalizedFeaturesMap).asJava()));
        this.zkClient().createFeatureZNode(new FeatureZNode(FeatureZNodeStatus$.MODULE$.Enabled(), finalizedFeatures));
        Tuple2 tuple2 = this.zkClient().getDataAndVersion(FeatureZNode$.MODULE$.path());
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Option option = (Option)tuple2._1();
        int n = tuple2._2$mcI$sp();
        Assert.assertNotEquals((long)n, (long)ZkVersion$.MODULE$.UnknownVersion());
        Assert.assertFalse((boolean)option.isEmpty());
        return new FinalizedFeaturesAndEpoch(finalizedFeatures, (long)n);
    }

    /*
     * WARNING - void declaration
     */
    private FinalizedFeatureChangeListener createListener(FinalizedFeatureCache cache, Option<FinalizedFeaturesAndEpoch> expectedCacheContent) {
        void var3_3;
        FinalizedFeatureChangeListener listener = new FinalizedFeatureChangeListener(cache, this.zkClient());
        Assert.assertFalse((boolean)listener.isListenerInitiated());
        Assert.assertTrue((boolean)cache.isEmpty());
        listener.initOrThrow(15000L);
        Assert.assertTrue((boolean)listener.isListenerInitiated());
        if (expectedCacheContent.isDefined()) {
            Option mayBeNewCacheContent = cache.get();
            Assert.assertFalse((boolean)mayBeNewCacheContent.isEmpty());
            FinalizedFeaturesAndEpoch newCacheContent = (FinalizedFeaturesAndEpoch)mayBeNewCacheContent.get();
            Assert.assertEquals((Object)((FinalizedFeaturesAndEpoch)expectedCacheContent.get()).features(), (Object)newCacheContent.features());
            Assert.assertEquals((long)((FinalizedFeaturesAndEpoch)expectedCacheContent.get()).epoch(), (long)newCacheContent.epoch());
        } else {
            Assert.assertTrue((boolean)cache.get().isEmpty());
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testInitSuccessAndNotificationSuccess() {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        void $minus$greater$extension_y2;
        void $minus$greater$extension_$this2;
        void $minus$greater$extension_y3;
        void $minus$greater$extension_$this3;
        FinalizedFeaturesAndEpoch initialFinalizedFeatures = this.createFinalizedFeatures();
        BrokerFeatures brokerFeatures = this.createBrokerFeatures();
        FinalizedFeatureCache cache = new FinalizedFeatureCache(brokerFeatures);
        FinalizedFeatureChangeListener listener = this.createListener(cache, (Option<FinalizedFeaturesAndEpoch>)new Some((Object)initialFinalizedFeatures));
        Tuple2[] tuple2Array = new Tuple2[1];
        FinalizedVersionRange finalizedVersionRange = new FinalizedVersionRange(2, 4);
        Object object = Predef$.MODULE$.ArrowAssoc((Object)"feature_1");
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this3, (Object)$minus$greater$extension_y3);
        this.updateAndCheckCache$1(Features.finalizedFeatures((java.util.Map)((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array))).asJava())), initialFinalizedFeatures, cache, listener);
        Tuple2[] tuple2Array2 = new Tuple2[2];
        FinalizedVersionRange finalizedVersionRange2 = new FinalizedVersionRange(2, 4);
        Object object2 = Predef$.MODULE$.ArrowAssoc((Object)"feature_1");
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array2[0] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y2);
        FinalizedVersionRange finalizedVersionRange3 = new FinalizedVersionRange(1, 3);
        Object object3 = Predef$.MODULE$.ArrowAssoc((Object)"feature_2");
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array2[1] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        this.updateAndCheckCache$1(Features.finalizedFeatures((java.util.Map)((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array2))).asJava())), initialFinalizedFeatures, cache, listener);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testFeatureZNodeDeleteNotificationProcessing() {
        BrokerFeatures brokerFeatures = this.createBrokerFeatures();
        FinalizedFeatureCache cache = new FinalizedFeatureCache(brokerFeatures);
        FinalizedFeaturesAndEpoch initialFinalizedFeatures = this.createFinalizedFeatures();
        FinalizedFeatureChangeListener listener = this.createListener(cache, (Option<FinalizedFeaturesAndEpoch>)new Some((Object)initialFinalizedFeatures));
        this.zkClient().deleteFeatureZNode();
        Tuple2 tuple2 = this.zkClient().getDataAndVersion(FeatureZNode$.MODULE$.path());
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Option option = (Option)tuple2._1();
        int n = tuple2._2$mcI$sp();
        Assert.assertEquals((long)n, (long)ZkVersion$.MODULE$.UnknownVersion());
        Assert.assertTrue((boolean)option.isEmpty());
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!cache.isEmpty()) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                throw Assertions$.MODULE$.fail(FinalizedFeatureChangeListenerTest.$anonfun$testFeatureZNodeDeleteNotificationProcessing$2(), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 847));
            }
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension((long)waitUntilTrue_waitTimeMs, (long)waitUntilTrue_pause));
        }
        Assert.assertTrue((boolean)listener.isListenerInitiated());
    }

    @Test
    public void testFeatureZNodeDisablingNotificationProcessing() {
        BrokerFeatures brokerFeatures = this.createBrokerFeatures();
        FinalizedFeatureCache cache = new FinalizedFeatureCache(brokerFeatures);
        FinalizedFeaturesAndEpoch initialFinalizedFeatures = this.createFinalizedFeatures();
        scala.collection.immutable.Map updatedFinalizedFeaturesMap = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
        Features updatedFinalizedFeatures = Features.finalizedFeatures((java.util.Map)((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)updatedFinalizedFeaturesMap).asJava()));
        this.zkClient().updateFeatureZNode(new FeatureZNode(FeatureZNodeStatus$.MODULE$.Disabled(), updatedFinalizedFeatures));
        Tuple2 tuple2 = this.zkClient().getDataAndVersion(FeatureZNode$.MODULE$.path());
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Option option = (Option)tuple2._1();
        int n = tuple2._2$mcI$sp();
        Assert.assertNotEquals((long)n, (long)ZkVersion$.MODULE$.UnknownVersion());
        Assert.assertFalse((boolean)option.isEmpty());
        Assert.assertTrue(((long)n > initialFinalizedFeatures.epoch() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)cache.get().isEmpty());
    }

    @Test
    public void testCacheUpdateWaitFailsForUnreachableVersion() {
        FinalizedFeaturesAndEpoch initialFinalizedFeatures = this.createFinalizedFeatures();
        FinalizedFeatureCache cache = new FinalizedFeatureCache(this.createBrokerFeatures());
        FinalizedFeatureChangeListener listener = this.createListener(cache, (Option<FinalizedFeaturesAndEpoch>)new Some((Object)initialFinalizedFeatures));
        Assert.assertThrows(TimeoutException.class, () -> cache.waitUntilEpochOrThrow(initialFinalizedFeatures.epoch() + 1L, 15000L));
        scala.collection.immutable.Map updatedFinalizedFeaturesMap = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
        Features updatedFinalizedFeatures = Features.finalizedFeatures((java.util.Map)((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)updatedFinalizedFeaturesMap).asJava()));
        this.zkClient().updateFeatureZNode(new FeatureZNode(FeatureZNodeStatus$.MODULE$.Disabled(), updatedFinalizedFeatures));
        Tuple2 tuple2 = this.zkClient().getDataAndVersion(FeatureZNode$.MODULE$.path());
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Option option = (Option)tuple2._1();
        int n = tuple2._2$mcI$sp();
        Assert.assertNotEquals((long)n, (long)ZkVersion$.MODULE$.UnknownVersion());
        Assert.assertFalse((boolean)option.isEmpty());
        Assert.assertTrue(((long)n > initialFinalizedFeatures.epoch() ? 1 : 0) != 0);
        Assert.assertThrows(TimeoutException.class, () -> cache.waitUntilEpochOrThrow((long)n, 15000L));
        Assert.assertTrue((boolean)cache.get().isEmpty());
        Assert.assertTrue((boolean)listener.isListenerInitiated());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testInitFailureDueToFeatureIncompatibility() {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        BrokerFeatures brokerFeatures = this.createBrokerFeatures();
        FinalizedFeatureCache cache = new FinalizedFeatureCache(brokerFeatures);
        Tuple2[] tuple2Array = new Tuple2[1];
        FinalizedVersionRange finalizedVersionRange = new FinalizedVersionRange(2, 5);
        Object object = Predef$.MODULE$.ArrowAssoc((Object)"feature_1");
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        scala.collection.immutable.Map incompatibleFinalizedFeaturesMap = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array));
        Features incompatibleFinalizedFeatures = Features.finalizedFeatures((java.util.Map)((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)incompatibleFinalizedFeaturesMap).asJava()));
        this.zkClient().createFeatureZNode(new FeatureZNode(FeatureZNodeStatus$.MODULE$.Enabled(), incompatibleFinalizedFeatures));
        Tuple2 tuple2 = this.zkClient().getDataAndVersion(FeatureZNode$.MODULE$.path());
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Option option = (Option)tuple2._1();
        int n = tuple2._2$mcI$sp();
        Assert.assertNotEquals((long)n, (long)ZkVersion$.MODULE$.UnknownVersion());
        Assert.assertFalse((boolean)option.isEmpty());
        CountDownLatch exitLatch = new CountDownLatch(1);
        Exit.setExitProcedure((x$7, x$8) -> exitLatch.countDown());
        try {
            FinalizedFeatureChangeListener listener = new FinalizedFeatureChangeListener(cache, this.zkClient());
            Assert.assertFalse((boolean)listener.isListenerInitiated());
            Assert.assertTrue((boolean)cache.isEmpty());
            Assert.assertThrows(TimeoutException.class, () -> listener.initOrThrow(5000L));
            exitLatch.await();
            Assert.assertFalse((boolean)listener.isListenerInitiated());
            Assert.assertTrue((boolean)listener.isListenerDead());
            Assert.assertTrue((boolean)cache.isEmpty());
        }
        finally {
            Exit.resetExitProcedure();
        }
    }

    @Test
    public void testInitFailureDueToInvalidWaitTime() {
        BrokerFeatures brokerFeatures = this.createBrokerFeatures();
        FinalizedFeatureCache cache = new FinalizedFeatureCache(brokerFeatures);
        FinalizedFeatureChangeListener listener = new FinalizedFeatureChangeListener(cache, this.zkClient());
        Assert.assertThrows(IllegalArgumentException.class, () -> listener.initOrThrow(0L));
        Assert.assertThrows(IllegalArgumentException.class, () -> listener.initOrThrow(-1L));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testNotificationFailureDueToFeatureIncompatibility() {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        BrokerFeatures brokerFeatures = this.createBrokerFeatures();
        FinalizedFeatureCache cache = new FinalizedFeatureCache(brokerFeatures);
        FinalizedFeaturesAndEpoch initialFinalizedFeatures = this.createFinalizedFeatures();
        FinalizedFeatureChangeListener listener = this.createListener(cache, (Option<FinalizedFeaturesAndEpoch>)new Some((Object)initialFinalizedFeatures));
        CountDownLatch exitLatch = new CountDownLatch(1);
        Exit.setExitProcedure((x$9, x$10) -> exitLatch.countDown());
        Tuple2[] tuple2Array = new Tuple2[1];
        FinalizedVersionRange finalizedVersionRange = new FinalizedVersionRange(((SupportedVersionRange)brokerFeatures.supportedFeatures().get("feature_1")).min(), (short)(((SupportedVersionRange)brokerFeatures.supportedFeatures().get("feature_1")).max() + 1));
        Object object = Predef$.MODULE$.ArrowAssoc((Object)"feature_1");
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        scala.collection.immutable.Map incompatibleFinalizedFeaturesMap = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array));
        Features incompatibleFinalizedFeatures = Features.finalizedFeatures((java.util.Map)((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)incompatibleFinalizedFeaturesMap).asJava()));
        this.zkClient().updateFeatureZNode(new FeatureZNode(FeatureZNodeStatus$.MODULE$.Enabled(), incompatibleFinalizedFeatures));
        Tuple2 tuple2 = this.zkClient().getDataAndVersion(FeatureZNode$.MODULE$.path());
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Option option = (Option)tuple2._1();
        int n = tuple2._2$mcI$sp();
        Assert.assertNotEquals((long)n, (long)ZkVersion$.MODULE$.UnknownVersion());
        Assert.assertFalse((boolean)option.isEmpty());
        try {
            long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
            long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
            if (TestUtils$.MODULE$ == null) {
                throw null;
            }
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!FinalizedFeatureChangeListenerTest.$anonfun$testNotificationFailureDueToFeatureIncompatibility$2(exitLatch, listener, cache, initialFinalizedFeatures)) {
                void waitUntilTrue_pause;
                void waitUntilTrue_waitTimeMs;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    throw Assertions$.MODULE$.fail(FinalizedFeatureChangeListenerTest.$anonfun$testNotificationFailureDueToFeatureIncompatibility$3(), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 847));
                }
                if (Predef$.MODULE$ == null) {
                    throw null;
                }
                Thread.sleep(RichLong$.MODULE$.min$extension((long)waitUntilTrue_waitTimeMs, (long)waitUntilTrue_pause));
            }
        }
        finally {
            Exit.resetExitProcedure();
        }
    }

    private final void updateAndCheckCache$1(Features finalizedFeatures, FinalizedFeaturesAndEpoch initialFinalizedFeatures$1, FinalizedFeatureCache cache$1, FinalizedFeatureChangeListener listener$1) {
        this.zkClient().updateFeatureZNode(new FeatureZNode(FeatureZNodeStatus$.MODULE$.Enabled(), finalizedFeatures));
        Tuple2 tuple2 = this.zkClient().getDataAndVersion(FeatureZNode$.MODULE$.path());
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Option option = (Option)tuple2._1();
        int n = tuple2._2$mcI$sp();
        Assert.assertNotEquals((long)n, (long)ZkVersion$.MODULE$.UnknownVersion());
        Assert.assertFalse((boolean)option.isEmpty());
        Assert.assertTrue(((long)n > initialFinalizedFeatures$1.epoch() ? 1 : 0) != 0);
        cache$1.waitUntilEpochOrThrow((long)n, 15000L);
        Assert.assertEquals((Object)new FinalizedFeaturesAndEpoch(finalizedFeatures, (long)n), (Object)cache$1.get().get());
        Assert.assertTrue((boolean)listener$1.isListenerInitiated());
    }

    public static final /* synthetic */ String $anonfun$testFeatureZNodeDeleteNotificationProcessing$2() {
        return "Timed out waiting for FinalizedFeatureCache to become empty";
    }

    public static final /* synthetic */ boolean $anonfun$testNotificationFailureDueToFeatureIncompatibility$2(CountDownLatch exitLatch$2, FinalizedFeatureChangeListener listener$4, FinalizedFeatureCache cache$4, FinalizedFeaturesAndEpoch initialFinalizedFeatures$3) {
        return exitLatch$2.getCount() == 0L && !listener$4.isListenerInitiated() && listener$4.isListenerDead() && ((FinalizedFeaturesAndEpoch)cache$4.get().get()).equals((Object)initialFinalizedFeatures$3);
    }

    public static final /* synthetic */ String $anonfun$testNotificationFailureDueToFeatureIncompatibility$3() {
        return "Timed out waiting for listener death and FinalizedFeatureCache to be updated";
    }
}

