/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import kafka.api.KAFKA_2_7_IV0$;
import kafka.cluster.Broker;
import kafka.server.BaseRequestTest;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.NotNothing$;
import kafka.utils.TestUtils$;
import kafka.zk.FeatureZNode;
import kafka.zk.FeatureZNode$;
import kafka.zk.FeatureZNodeStatus$;
import kafka.zk.ZkVersion$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.DescribeFeaturesOptions;
import org.apache.kafka.clients.admin.FeatureMetadata;
import org.apache.kafka.clients.admin.FeatureUpdate;
import org.apache.kafka.clients.admin.FinalizedVersionRange;
import org.apache.kafka.clients.admin.UpdateFeaturesOptions;
import org.apache.kafka.clients.admin.UpdateFeaturesResult;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.feature.Features;
import org.apache.kafka.common.feature.SupportedVersionRange;
import org.apache.kafka.common.message.UpdateFeaturesRequestData;
import org.apache.kafka.common.message.UpdateFeaturesResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.UpdateFeaturesRequest;
import org.apache.kafka.common.requests.UpdateFeaturesResponse;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.common.utils.Utils;
import org.junit.Assert;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong$;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u0001\tUa\u0001\u0002\u000f\u001e\u0001\tBQa\n\u0001\u0005\u0002!BQA\u000b\u0001\u0005B-BQA\r\u0001\u0005BMBQ!\u0011\u0001\u0005\n\tCQa\u0015\u0001\u0005\nQCQ!\u0017\u0001\u0005\niCQ!\u001c\u0001\u0005\n9DQ\u0001\u001d\u0001\u0005\nEDQa\u001d\u0001\u0005\nQDQa\u001f\u0001\u0005\nqDq!a\u0006\u0001\t\u0013\tI\u0002C\u0004\u0002$\u0001!I!!\n\t\u000f\u0005\u001d\u0003\u0001\"\u0003\u0002J!9\u0011\u0011\u0015\u0001\u0005\n\u0005\r\u0006bBAa\u0001\u0011\u0005\u00111\u0019\u0005\b\u0003'\u0004A\u0011AAb\u0011\u001d\t9\u000e\u0001C\u0001\u0003\u0007Dq!a7\u0001\t\u0003\t\u0019\rC\u0004\u0002`\u0002!\t!a1\t\u000f\u0005\r\b\u0001\"\u0001\u0002D\"9\u0011q\u001d\u0001\u0005\n\u0005%\bbBA\u007f\u0001\u0011\u0005\u00111\u0019\u0005\b\u0005\u0003\u0001A\u0011AAb\u0011\u001d\u0011)\u0001\u0001C\u0001\u0003\u0007DqA!\u0003\u0001\t\u0003\t\u0019\rC\u0004\u0003\u000e\u0001!\t!a1\t\u000f\tE\u0001\u0001\"\u0001\u0002D\n\u0011R\u000b\u001d3bi\u00164U-\u0019;ve\u0016\u001cH+Z:u\u0015\tqr$\u0001\u0004tKJ4XM\u001d\u0006\u0002A\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001$!\t!S%D\u0001\u001e\u0013\t1SDA\bCCN,'+Z9vKN$H+Z:u\u0003\u0019a\u0014N\\5u}Q\t\u0011\u0006\u0005\u0002%\u0001\u0005Y!M]8lKJ\u001cu.\u001e8u+\u0005a\u0003CA\u00171\u001b\u0005q#\"A\u0018\u0002\u000bM\u001c\u0017\r\\1\n\u0005Er#aA%oi\u00069\"M]8lKJ\u0004&o\u001c9feRLxJ^3se&$Wm\u001d\u000b\u0003i]\u0002\"!L\u001b\n\u0005Yr#\u0001B+oSRDQ\u0001O\u0002A\u0002e\nQ\u0001\u001d:paN\u0004\"AO \u000e\u0003mR!\u0001P\u001f\u0002\tU$\u0018\u000e\u001c\u0006\u0002}\u0005!!.\u0019<b\u0013\t\u00015H\u0001\u0006Qe>\u0004XM\u001d;jKN\f\u0001\u0004Z3gCVdGoU;qa>\u0014H/\u001a3GK\u0006$XO]3t)\u0005\u0019\u0005c\u0001#O!6\tQI\u0003\u0002G\u000f\u00069a-Z1ukJ,'B\u0001%J\u0003\u0019\u0019w.\\7p]*\u0011\u0001E\u0013\u0006\u0003\u00172\u000ba!\u00199bG\",'\"A'\u0002\u0007=\u0014x-\u0003\u0002P\u000b\nAa)Z1ukJ,7\u000f\u0005\u0002E#&\u0011!+\u0012\u0002\u0016'V\u0004\bo\u001c:uK\u00124VM]:j_:\u0014\u0016M\\4f\u0003a!WMZ1vYR4\u0015N\\1mSj,GMR3biV\u0014Xm\u001d\u000b\u0002+B\u0019AI\u0014,\u0011\u0005\u0011;\u0016B\u0001-F\u0005U1\u0015N\\1mSj,GMV3sg&|gNU1oO\u0016\fq#\u001e9eCR,7+\u001e9q_J$X\r\u001a$fCR,(/Z:\u0015\u0007QZV\fC\u0003]\r\u0001\u00071)\u0001\u0005gK\u0006$XO]3t\u0011\u0015qf\u00011\u0001`\u00035!\u0018M]4fiN+'O^3sgB\u0019\u0001m\u001a6\u000f\u0005\u0005,\u0007C\u00012/\u001b\u0005\u0019'B\u00013\"\u0003\u0019a$o\\8u}%\u0011aML\u0001\u0007!J,G-\u001a4\n\u0005!L'aA*fi*\u0011aM\f\t\u0003I-L!\u0001\\\u000f\u0003\u0017-\u000bgm[1TKJ4XM]\u0001$kB$\u0017\r^3TkB\u0004xN\u001d;fI\u001a+\u0017\r^;sKNLe.\u00117m\u0005J|7.\u001a:t)\t!t\u000eC\u0003]\u000f\u0001\u00071)\u0001\nva\u0012\fG/\u001a$fCR,(/\u001a.O_\u0012,GC\u0001\u0017s\u0011\u0015a\u0006\u00021\u0001V\u0003=9W\r\u001e$fCR,(/\u001a.O_\u0012,G#A;\u0011\u0005YLX\"A<\u000b\u0005a|\u0012A\u0001>l\u0013\tQxO\u0001\u0007GK\u0006$XO]3[\u001d>$W-A\tgS:\fG.\u001b>fI\u001a+\u0017\r^;sKN$\"!V?\t\u000bqS\u0001\u0019\u0001@\u0011\riz\u00181AA\u0005\u0013\r\t\ta\u000f\u0002\u0004\u001b\u0006\u0004\bc\u00011\u0002\u0006%\u0019\u0011qA5\u0003\rM#(/\u001b8h!\u0011\tY!!\u0006\u000e\u0005\u00055!\u0002BA\b\u0003#\tQ!\u00193nS:T1!a\u0005J\u0003\u001d\u0019G.[3oiNL1\u0001WA\u0007\u0003E\u0019X\u000f\u001d9peR,GMR3biV\u0014Xm\u001d\u000b\u0004\u0007\u0006m\u0001B\u0002/\f\u0001\u0004\ti\u0002\u0005\u0004;\u007f\u0006\r\u0011q\u0004\t\u0005\u0003\u0017\t\t#C\u0002S\u0003\u001b\tQb\u00195fG.4U-\u0019;ve\u0016\u001cHc\u0003\u001b\u0002(\u0005E\u0012QGA\u001d\u0003\u0007Bq!!\u000b\r\u0001\u0004\tY#\u0001\u0004dY&,g\u000e\u001e\t\u0005\u0003\u0017\ti#\u0003\u0003\u00020\u00055!!B!e[&t\u0007BBA\u001a\u0019\u0001\u0007Q/\u0001\u0007fqB,7\r^3e\u001d>$W\r\u0003\u0004\u000281\u0001\r!V\u0001\u001aKb\u0004Xm\u0019;fI\u001aKg.\u00197ju\u0016$g)Z1ukJ,7\u000fC\u0004\u0002<1\u0001\r!!\u0010\u0002=\u0015D\b/Z2uK\u00124\u0015N\\1mSj,GMR3biV\u0014Xm]#q_\u000eD\u0007cA\u0017\u0002@%\u0019\u0011\u0011\t\u0018\u0003\t1{gn\u001a\u0005\u0007\u0003\u000bb\u0001\u0019A\"\u00023\u0015D\b/Z2uK\u0012\u001cV\u000f\u001d9peR,GMR3biV\u0014Xm]\u0001\u000fG\",7m[#yG\u0016\u0004H/[8o+\u0011\tY%a\u0019\u0015\r\u00055\u0013\u0011QAF)\r!\u0014q\n\u0005\b\u0003#j\u00019AA*\u0003\r!\u0018m\u001a\t\u0007\u0003+\nY&a\u0018\u000e\u0005\u0005]#bAA-]\u00059!/\u001a4mK\u000e$\u0018\u0002BA/\u0003/\u0012\u0001b\u00117bgN$\u0016m\u001a\t\u0005\u0003C\n\u0019\u0007\u0004\u0001\u0005\u000f\u0005\u0015TB1\u0001\u0002h\tiQ\t_2faRLwN\u001c+za\u0016\fB!!\u001b\u0002pA\u0019Q&a\u001b\n\u0007\u00055dFA\u0004O_RD\u0017N\\4\u0011\t\u0005E\u00141\u0010\b\u0005\u0003g\n9HD\u0002c\u0003kJ\u0011aL\u0005\u0004\u0003sr\u0013a\u00029bG.\fw-Z\u0005\u0005\u0003{\nyHA\u0005UQJ|w/\u00192mK*\u0019\u0011\u0011\u0010\u0018\t\u000f\u0005\rU\u00021\u0001\u0002\u0006\u00061!/Z:vYR\u0004B!a\u0003\u0002\b&!\u0011\u0011RA\u0007\u0005Q)\u0006\u000fZ1uK\u001a+\u0017\r^;sKN\u0014Vm];mi\"9\u0011QR\u0007A\u0002\u0005=\u0015a\u00074fCR,(/Z#yG\u0016\u0004H/[8o\u001bN<\u0007+\u0019;uKJt7\u000fE\u0004a\u0003#\u000b\u0019!a%\n\u0007\u0005\u0005\u0011\u000e\u0005\u0003\u0002\u0016\u0006uUBAAL\u0015\u0011\tI*a'\u0002\u00115\fGo\u00195j]\u001eT!\u0001\u0010\u0018\n\t\u0005}\u0015q\u0013\u0002\u0006%\u0016<W\r_\u0001\u001di\u0016\u001cHoV5uQ&sg/\u00197jI\u001a+\u0017\r^;sKV\u0003H-\u0019;f+\u0011\t)+a,\u0015\u0011\u0005\u001d\u0016\u0011WAZ\u0003{#2\u0001NAU\u0011\u001d\t\tF\u0004a\u0002\u0003W\u0003b!!\u0016\u0002\\\u00055\u0006\u0003BA1\u0003_#q!!\u001a\u000f\u0005\u0004\t9\u0007\u0003\u0004G\u001d\u0001\u0007\u00111\u0001\u0005\b\u0003ks\u0001\u0019AA\\\u00035IgN^1mS\u0012,\u0006\u000fZ1uKB!\u00111BA]\u0013\u0011\tY,!\u0004\u0003\u001b\u0019+\u0017\r^;sKV\u0003H-\u0019;f\u0011\u001d\tyL\u0004a\u0001\u0003'\u000b1#\u001a=dKB$\u0018n\u001c8Ng\u001e\u0004\u0016\r\u001e;fe:\fA\u0005^3tiNCw.\u001e7e\r\u0006LGNU3rk\u0016\u001cH/\u00134O_R\u001cuN\u001c;s_2dWM\u001d\u000b\u0002i!\u001aq\"a2\u0011\t\u0005%\u0017qZ\u0007\u0003\u0003\u0017T1!!4M\u0003\u0015QWO\\5u\u0013\u0011\t\t.a3\u0003\tQ+7\u000f^\u0001>i\u0016\u001cHo\u00155pk2$g)Y5m%\u0016\fX/Z:u/\",g\u000eR8x]\u001e\u0014\u0018\rZ3GY\u0006<\u0017j\u001d(piN+G\u000fR;sS:<Gi\\<oOJ\fG-\u001a\u0015\u0004!\u0005\u001d\u0017!\u0011;fgR\u001c\u0006n\\;mI\u001a\u000b\u0017\u000e\u001c*fcV,7\u000f^,iK:$un\u001e8he\u0006$W\rV8IS\u001eDWM\u001d,feNLwN\u001c'fm\u0016d\u0017j]!ui\u0016l\u0007\u000f^3eQ\r\t\u0012qY\u0001Ei\u0016\u001cHo\u00155pk2$g)Y5m%\u0016\fX/Z:u\u0013:\u001cVM\u001d<fe^CWM\u001c#po:<'/\u00193f\r2\fw-S:O_R\u001cV\r\u001e#ve&tw\rR3mKRLwN\u001c\u0015\u0004%\u0005\u001d\u0017a\u000e;fgR\u001c\u0006n\\;mI\u001a\u000b\u0017\u000e\u001c*fcV,7\u000f\u001e#ve&tw\rR3mKRLwN\\(g\u001d>tW\t_5ti&twMR3biV\u0014X\rK\u0002\u0014\u0003\u000f\fA\u0007^3tiNCw.\u001e7e\r\u0006LGNU3rk\u0016\u001cHo\u00165f]V\u0003xM]1eS:<Gk\\*b[\u00164VM]:j_:dUM^3mQ\r!\u0012qY\u0001@i\u0016\u001cHo\u00155pk2$g)Y5m%\u0016\fX/Z:u\tV\u0014\u0018N\\4Ce>\\WM]'bqZ+'o]5p]2+g/\u001a7J]\u000e|W\u000e]1uS\nLG.\u001b;z)\u001d!\u00141^Ax\u0003gDq!!<\u0016\u0001\u0004\t\u0019!A\u0006gK\u0006$XO]3OC6,\u0007BBAy+\u0001\u0007\u0001+A\u000btkB\u0004xN\u001d;fIZ+'o]5p]J\u000bgnZ3\t\u000f\u0005UX\u00031\u0001\u0002x\u0006a\u0012N\\5uS\u0006dg)\u001b8bY&TX\r\u001a,feNLwN\u001c*b]\u001e,\u0007\u0003B\u0017\u0002zZK1!a?/\u0005\u0019y\u0005\u000f^5p]\u0006QF/Z:u'\"|W\u000f\u001c3GC&d'+Z9vKN$H)\u001e:j]\u001e\u0014%o\\6fe6\u000b\u0007PV3sg&|g\u000eT3wK2LenY8na\u0006$\u0018NY5mSRLhi\u001c:Fq&\u001cH/\u001b8h\r&t\u0017\r\\5{K\u00124U-\u0019;ve\u0016D3AFAd\u0003u#Xm\u001d;TQ>,H\u000e\u001a$bS2\u0014V-];fgR$UO]5oO\n\u0013xn[3s\u001b\u0006Dh+\u001a:tS>tG*\u001a<fY&s7m\\7qCRL'-\u001b7jif<\u0016\u000e\u001e5O_\u0016C\u0018n\u001d;j]\u001e4\u0015N\\1mSj,GMR3biV\u0014X\rK\u0002\u0018\u0003\u000f\fa\b^3tiN+8mY3tg\u001a,HNR3biV\u0014X-\u00169he\u0006$W-\u00118e/&$\bNT8Fq&\u001cH/\u001b8h\r&t\u0017\r\\5{K\u00124U-\u0019;ve\u0016\u001c\bf\u0001\r\u0002H\u0006AC/Z:u'V\u001c7-Z:tMVdg)Z1ukJ,W\u000b]4sC\u0012,\u0017I\u001c3E_^twM]1eK\"\u001a\u0011$a2\u0002}Q,7\u000f\u001e)beRL\u0017\r\\*vG\u000e,7o\u001d#ve&twMV1mS\u00124U-\u0019;ve\u0016,\u0006o\u001a:bI\u0016\fe\u000eZ%om\u0006d\u0017\u000e\u001a#po:<'/\u00193fQ\rQ\u0012qY\u0001?i\u0016\u001cH\u000fU1si&\fGnU;dG\u0016\u001c8\u000fR;sS:<\u0017J\u001c<bY&$g)Z1ukJ,W\u000b]4sC\u0012,\u0017I\u001c3WC2LG\rR8x]\u001e\u0014\u0018\rZ3)\u0007m\t9\r")
public class UpdateFeaturesTest
extends BaseRequestTest {
    @Override
    public int brokerCount() {
        return 3;
    }

    @Override
    public void brokerPropertyOverrides(Properties props) {
        props.put(KafkaConfig$.MODULE$.InterBrokerProtocolVersionProp(), KAFKA_2_7_IV0$.MODULE$.toString());
    }

    private Features<SupportedVersionRange> defaultSupportedFeatures() {
        return Features.supportedFeatures((Map)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"feature_1", (Object)new SupportedVersionRange(1, 3))}));
    }

    private Features<org.apache.kafka.common.feature.FinalizedVersionRange> defaultFinalizedFeatures() {
        return Features.finalizedFeatures((Map)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"feature_1", (Object)new org.apache.kafka.common.feature.FinalizedVersionRange(1, 2))}));
    }

    /*
     * WARNING - void declaration
     */
    private void updateSupportedFeatures(Features<SupportedVersionRange> features, Set<KafkaServer> targetServers) {
        targetServers.foreach((Function1 & Serializable & scala.Serializable)s -> {
            UpdateFeaturesTest.$anonfun$updateSupportedFeatures$1(features, s);
            return BoxedUnit.UNIT;
        });
        Set brokerIds = (Set)targetServers.map((Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToInteger((int)UpdateFeaturesTest.$anonfun$updateSupportedFeatures$2(s)), Set$.MODULE$.canBuildFrom());
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!UpdateFeaturesTest.$anonfun$updateSupportedFeatures$3(this, brokerIds, features)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                throw Assertions$.MODULE$.fail(UpdateFeaturesTest.$anonfun$updateSupportedFeatures$7(), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 847));
            }
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension((long)waitUntilTrue_waitTimeMs, (long)waitUntilTrue_pause));
        }
    }

    private void updateSupportedFeaturesInAllBrokers(Features<SupportedVersionRange> features) {
        this.updateSupportedFeatures(features, (Set<KafkaServer>)((Set)((SetLike)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$)).$plus$plus(this.servers())));
    }

    private int updateFeatureZNode(Features<org.apache.kafka.common.feature.FinalizedVersionRange> features) {
        KafkaServer server = (KafkaServer)this.serverForId(0).get();
        FeatureZNode newNode = new FeatureZNode(FeatureZNodeStatus$.MODULE$.Enabled(), features);
        int newVersion = server.zkClient().updateFeatureZNode(newNode);
        this.servers().foreach((Function1 & Serializable & scala.Serializable)s -> {
            UpdateFeaturesTest.$anonfun$updateFeatureZNode$1(newVersion, s);
            return BoxedUnit.UNIT;
        });
        return newVersion;
    }

    private FeatureZNode getFeatureZNode() {
        Tuple2 tuple2 = ((KafkaServer)this.serverForId(0).get()).zkClient().getDataAndVersion(FeatureZNode$.MODULE$.path());
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Option option = (Option)tuple2._1();
        int n = tuple2._2$mcI$sp();
        Assert.assertNotEquals((long)n, (long)ZkVersion$.MODULE$.UnknownVersion());
        return FeatureZNode$.MODULE$.decode((byte[])option.get());
    }

    private Features<org.apache.kafka.common.feature.FinalizedVersionRange> finalizedFeatures(Map<String, FinalizedVersionRange> features) {
        return Features.finalizedFeatures((Map)((Map)CollectionConverters$.MODULE$.mutableMapAsJavaMapConverter((scala.collection.mutable.Map)((TraversableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(features).asScala()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            String name = (String)x0$1._1();
            FinalizedVersionRange versionRange = (FinalizedVersionRange)x0$1._2();
            Tuple2 tuple2 = new Tuple2((Object)name, (Object)new org.apache.kafka.common.feature.FinalizedVersionRange(versionRange.minVersionLevel(), versionRange.maxVersionLevel()));
            return tuple2;
        }, Map$.MODULE$.canBuildFrom())).asJava()));
    }

    private Features<SupportedVersionRange> supportedFeatures(Map<String, org.apache.kafka.clients.admin.SupportedVersionRange> features) {
        return Features.supportedFeatures((Map)((Map)CollectionConverters$.MODULE$.mutableMapAsJavaMapConverter((scala.collection.mutable.Map)((TraversableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(features).asScala()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            String name = (String)x0$1._1();
            org.apache.kafka.clients.admin.SupportedVersionRange versionRange = (org.apache.kafka.clients.admin.SupportedVersionRange)x0$1._2();
            Tuple2 tuple2 = new Tuple2((Object)name, (Object)new SupportedVersionRange(versionRange.minVersion(), versionRange.maxVersion()));
            return tuple2;
        }, Map$.MODULE$.canBuildFrom())).asJava()));
    }

    private void checkFeatures(Admin client, FeatureZNode expectedNode, Features<org.apache.kafka.common.feature.FinalizedVersionRange> expectedFinalizedFeatures, long expectedFinalizedFeaturesEpoch, Features<SupportedVersionRange> expectedSupportedFeatures) {
        Assert.assertEquals((Object)expectedNode, (Object)this.getFeatureZNode());
        FeatureMetadata featureMetadata = (FeatureMetadata)client.describeFeatures(new DescribeFeaturesOptions().sendRequestToController(true)).featureMetadata().get();
        Assert.assertEquals(expectedFinalizedFeatures, this.finalizedFeatures(featureMetadata.finalizedFeatures()));
        Assert.assertEquals(expectedSupportedFeatures, this.supportedFeatures(featureMetadata.supportedFeatures()));
        Assert.assertEquals(Optional.of(BoxesRunTime.boxToLong((long)expectedFinalizedFeaturesEpoch)), (Object)featureMetadata.finalizedFeaturesEpoch());
    }

    private <ExceptionType extends Throwable> void checkException(UpdateFeaturesResult result, scala.collection.immutable.Map<String, Regex> featureExceptionMsgPatterns, ClassTag<ExceptionType> tag) {
        featureExceptionMsgPatterns.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            UpdateFeaturesTest.$anonfun$checkException$1(result, tag, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    private <ExceptionType extends Throwable> void testWithInvalidFeatureUpdate(String feature, FeatureUpdate invalidUpdate, Regex exceptionMsgPattern, ClassTag<ExceptionType> tag) {
        void $minus$greater$extension_$this;
        TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), TestUtils$.MODULE$.waitUntilControllerElected$default$2());
        this.updateSupportedFeaturesInAllBrokers(this.defaultSupportedFeatures());
        int versionBefore = this.updateFeatureZNode(this.defaultFinalizedFeatures());
        Admin adminClient = this.createAdminClient(this.createAdminClient$default$1());
        FeatureZNode nodeBefore = this.getFeatureZNode();
        UpdateFeaturesResult result = adminClient.updateFeatures(Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)feature, (Object)invalidUpdate)}), new UpdateFeaturesOptions());
        Tuple2[] tuple2Array = new Tuple2[1];
        Object object = Predef$.MODULE$.ArrowAssoc((Object)feature);
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)exceptionMsgPattern);
        this.checkException(result, (scala.collection.immutable.Map<String, Regex>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array))), tag);
        this.checkFeatures(adminClient, nodeBefore, this.defaultFinalizedFeatures(), versionBefore, this.defaultSupportedFeatures());
    }

    @Test
    public void testShouldFailRequestIfNotController() {
        TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), TestUtils$.MODULE$.waitUntilControllerElected$default$2());
        this.updateSupportedFeaturesInAllBrokers(this.defaultSupportedFeatures());
        int versionBefore = this.updateFeatureZNode(this.defaultFinalizedFeatures());
        FeatureZNode nodeBefore = this.getFeatureZNode();
        UpdateFeaturesRequestData.FeatureUpdateKeyCollection validUpdates = new UpdateFeaturesRequestData.FeatureUpdateKeyCollection();
        UpdateFeaturesRequestData.FeatureUpdateKey validUpdate = new UpdateFeaturesRequestData.FeatureUpdateKey();
        validUpdate.setFeature("feature_1");
        validUpdate.setMaxVersionLevel(((SupportedVersionRange)this.defaultSupportedFeatures().get("feature_1")).max());
        validUpdate.setAllowDowngrade(false);
        validUpdates.add((ImplicitLinkedHashCollection.Element)validUpdate);
        UpdateFeaturesResponse response = (UpdateFeaturesResponse)this.connectAndReceive(new UpdateFeaturesRequest.Builder(new UpdateFeaturesRequestData().setFeatureUpdates(validUpdates)).build(), this.notControllerSocketServer(), this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(UpdateFeaturesResponse.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals()));
        Assert.assertEquals((Object)Errors.NOT_CONTROLLER, (Object)Errors.forCode((short)response.data().errorCode()));
        Assert.assertNotNull((Object)response.data().errorMessage());
        Assert.assertEquals((long)0L, (long)response.data().results().size());
        this.checkFeatures(this.createAdminClient(this.createAdminClient$default$1()), nodeBefore, this.defaultFinalizedFeatures(), versionBefore, this.defaultSupportedFeatures());
    }

    @Test
    public void testShouldFailRequestWhenDowngradeFlagIsNotSetDuringDowngrade() {
        short targetMaxVersionLevel = (short)(((org.apache.kafka.common.feature.FinalizedVersionRange)this.defaultFinalizedFeatures().get("feature_1")).max() - 1);
        String string = ".*Can not downgrade finalized feature.*allowDowngrade.*";
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        this.testWithInvalidFeatureUpdate("feature_1", new FeatureUpdate(targetMaxVersionLevel, false), new StringOps(string).r(), ClassTag$.MODULE$.apply(InvalidRequestException.class));
    }

    @Test
    public void testShouldFailRequestWhenDowngradeToHigherVersionLevelIsAttempted() {
        short targetMaxVersionLevel = (short)(((org.apache.kafka.common.feature.FinalizedVersionRange)this.defaultFinalizedFeatures().get("feature_1")).max() + 1);
        String string = ".*When the allowDowngrade flag set in the request, the provided maxVersionLevel:3.*existing maxVersionLevel:2.*";
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        this.testWithInvalidFeatureUpdate("feature_1", new FeatureUpdate(targetMaxVersionLevel, true), new StringOps(string).r(), ClassTag$.MODULE$.apply(InvalidRequestException.class));
    }

    @Test
    public void testShouldFailRequestInServerWhenDowngradeFlagIsNotSetDuringDeletion() {
        TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), TestUtils$.MODULE$.waitUntilControllerElected$default$2());
        this.updateSupportedFeaturesInAllBrokers(this.defaultSupportedFeatures());
        int versionBefore = this.updateFeatureZNode(this.defaultFinalizedFeatures());
        Admin adminClient = this.createAdminClient(this.createAdminClient$default$1());
        FeatureZNode nodeBefore = this.getFeatureZNode();
        UpdateFeaturesRequestData.FeatureUpdateKeyCollection invalidUpdates = new UpdateFeaturesRequestData.FeatureUpdateKeyCollection();
        UpdateFeaturesRequestData.FeatureUpdateKey invalidUpdate = new UpdateFeaturesRequestData.FeatureUpdateKey();
        invalidUpdate.setFeature("feature_1");
        invalidUpdate.setMaxVersionLevel((short)0);
        invalidUpdate.setAllowDowngrade(false);
        invalidUpdates.add((ImplicitLinkedHashCollection.Element)invalidUpdate);
        new UpdateFeaturesRequestData().setFeatureUpdates(invalidUpdates);
        UpdateFeaturesResponse response = (UpdateFeaturesResponse)this.connectAndReceive(new UpdateFeaturesRequest.Builder(new UpdateFeaturesRequestData().setFeatureUpdates(invalidUpdates)).build(), this.controllerSocketServer(), this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(UpdateFeaturesResponse.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals()));
        Assert.assertEquals((long)1L, (long)response.data().results().size());
        UpdateFeaturesResponseData.UpdatableFeatureResult result = (UpdateFeaturesResponseData.UpdatableFeatureResult)((IterableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter((Collection)response.data().results()).asScala()).head();
        Assert.assertEquals((Object)"feature_1", (Object)result.feature());
        Assert.assertEquals((Object)Errors.INVALID_REQUEST, (Object)Errors.forCode((short)result.errorCode()));
        Assert.assertNotNull((Object)result.errorMessage());
        Assert.assertFalse((boolean)result.errorMessage().isEmpty());
        String string = ".*Can not provide maxVersionLevel: 0 less than 1.*allowDowngrade.*";
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        Regex exceptionMsgPattern = new StringOps(string).r();
        Assert.assertTrue((String)result.errorMessage(), (boolean)exceptionMsgPattern.findFirstIn((CharSequence)result.errorMessage()).isDefined());
        this.checkFeatures(adminClient, nodeBefore, this.defaultFinalizedFeatures(), versionBefore, this.defaultSupportedFeatures());
    }

    @Test
    public void testShouldFailRequestDuringDeletionOfNonExistingFeature() {
        String string = ".*Could not apply finalized feature update because the provided feature is not supported.*";
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        this.testWithInvalidFeatureUpdate("feature_non_existing", new FeatureUpdate(3, true), new StringOps(string).r(), ClassTag$.MODULE$.apply(InvalidRequestException.class));
    }

    @Test
    public void testShouldFailRequestWhenUpgradingToSameVersionLevel() {
        short targetMaxVersionLevel = ((org.apache.kafka.common.feature.FinalizedVersionRange)this.defaultFinalizedFeatures().get("feature_1")).max();
        String string = ".*Can not upgrade a finalized feature.*to the same value.*";
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        this.testWithInvalidFeatureUpdate("feature_1", new FeatureUpdate(targetMaxVersionLevel, false), new StringOps(string).r(), ClassTag$.MODULE$.apply(InvalidRequestException.class));
    }

    /*
     * WARNING - void declaration
     */
    private void testShouldFailRequestDuringBrokerMaxVersionLevelIncompatibility(String featureName, SupportedVersionRange supportedVersionRange, Option<org.apache.kafka.common.feature.FinalizedVersionRange> initialFinalizedVersionRange) {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        None$ none$;
        TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), TestUtils$.MODULE$.waitUntilControllerElected$default$2());
        KafkaServer controller = (KafkaServer)((IterableLike)this.servers().filter((Function1 & Serializable & scala.Serializable)server -> BoxesRunTime.boxToBoolean((boolean)UpdateFeaturesTest.$anonfun$testShouldFailRequestDuringBrokerMaxVersionLevelIncompatibility$1(server)))).head();
        Buffer nonControllerServers = (Buffer)this.servers().filter((Function1 & Serializable & scala.Serializable)server -> BoxesRunTime.boxToBoolean((boolean)UpdateFeaturesTest.$anonfun$testShouldFailRequestDuringBrokerMaxVersionLevelIncompatibility$2(server)));
        Set brokersWithVersionIncompatibility = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaServer[]{(KafkaServer)nonControllerServers.head()}));
        Set versionCompatibleBrokers = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaServer[]{(KafkaServer)nonControllerServers.apply(1), controller}));
        Features supportedFeatures = Features.supportedFeatures((Map)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)featureName, (Object)supportedVersionRange)}));
        this.updateSupportedFeatures((Features<SupportedVersionRange>)supportedFeatures, (Set<KafkaServer>)versionCompatibleBrokers);
        short unsupportedMaxVersion = (short)(supportedVersionRange.max() - 1);
        Features supportedFeaturesWithVersionIncompatibility = Features.supportedFeatures((Map)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"feature_1", (Object)new SupportedVersionRange(supportedVersionRange.min(), unsupportedMaxVersion))}));
        this.updateSupportedFeatures((Features<SupportedVersionRange>)supportedFeaturesWithVersionIncompatibility, (Set<KafkaServer>)brokersWithVersionIncompatibility);
        if (initialFinalizedVersionRange == null) {
            throw null;
        }
        if (initialFinalizedVersionRange.isEmpty()) {
            none$ = None$.MODULE$;
        } else {
            org.apache.kafka.common.feature.FinalizedVersionRange finalizedVersionRange = (org.apache.kafka.common.feature.FinalizedVersionRange)initialFinalizedVersionRange.get();
            none$ = new Some((Object)UpdateFeaturesTest.$anonfun$testShouldFailRequestDuringBrokerMaxVersionLevelIncompatibility$3(featureName, finalizedVersionRange));
        }
        if (none$ == null) {
            throw null;
        }
        Object object = none$.isEmpty() ? UpdateFeaturesTest.$anonfun$testShouldFailRequestDuringBrokerMaxVersionLevelIncompatibility$4() : none$.get();
        Object initialFinalizedFeatures = object;
        int versionBefore = this.updateFeatureZNode((Features<org.apache.kafka.common.feature.FinalizedVersionRange>)initialFinalizedFeatures);
        FeatureUpdate invalidUpdate = new FeatureUpdate(supportedVersionRange.max(), false);
        FeatureZNode nodeBefore = this.getFeatureZNode();
        Admin adminClient = this.createAdminClient(this.createAdminClient$default$1());
        UpdateFeaturesResult result = adminClient.updateFeatures(Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"feature_1", (Object)invalidUpdate)}), new UpdateFeaturesOptions());
        Tuple2[] tuple2Array = new Tuple2[1];
        String string = ".*brokers.*incompatible.*";
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        Regex regex = new StringOps(string).r();
        Object object2 = Predef$.MODULE$.ArrowAssoc((Object)"feature_1");
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        this.checkException(result, (scala.collection.immutable.Map<String, Regex>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array))), ClassTag$.MODULE$.apply(InvalidRequestException.class));
        this.checkFeatures(adminClient, nodeBefore, (Features<org.apache.kafka.common.feature.FinalizedVersionRange>)initialFinalizedFeatures, versionBefore, (Features<SupportedVersionRange>)supportedFeatures);
    }

    @Test
    public void testShouldFailRequestDuringBrokerMaxVersionLevelIncompatibilityForExistingFinalizedFeature() {
        String feature = "feature_1";
        this.testShouldFailRequestDuringBrokerMaxVersionLevelIncompatibility(feature, (SupportedVersionRange)this.defaultSupportedFeatures().get(feature), (Option<org.apache.kafka.common.feature.FinalizedVersionRange>)new Some((Object)this.defaultFinalizedFeatures().get(feature)));
    }

    @Test
    public void testShouldFailRequestDuringBrokerMaxVersionLevelIncompatibilityWithNoExistingFinalizedFeature() {
        String feature = "feature_1";
        this.testShouldFailRequestDuringBrokerMaxVersionLevelIncompatibility(feature, (SupportedVersionRange)this.defaultSupportedFeatures().get(feature), (Option<org.apache.kafka.common.feature.FinalizedVersionRange>)Option$.MODULE$.empty());
    }

    @Test
    public void testSuccessfulFeatureUpgradeAndWithNoExistingFinalizedFeatures() {
        TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), TestUtils$.MODULE$.waitUntilControllerElected$default$2());
        Features supportedFeatures = Features.supportedFeatures((Map)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"feature_1", (Object)new SupportedVersionRange(1, 3)), Utils.mkEntry((Object)"feature_2", (Object)new SupportedVersionRange(2, 5))}));
        this.updateSupportedFeaturesInAllBrokers((Features<SupportedVersionRange>)supportedFeatures);
        int versionBefore = this.updateFeatureZNode((Features<org.apache.kafka.common.feature.FinalizedVersionRange>)Features.emptyFinalizedFeatures());
        Features targetFinalizedFeatures = Features.finalizedFeatures((Map)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"feature_1", (Object)new org.apache.kafka.common.feature.FinalizedVersionRange(1, 3)), Utils.mkEntry((Object)"feature_2", (Object)new org.apache.kafka.common.feature.FinalizedVersionRange(2, 3))}));
        FeatureUpdate update1 = new FeatureUpdate(((org.apache.kafka.common.feature.FinalizedVersionRange)targetFinalizedFeatures.get("feature_1")).max(), false);
        FeatureUpdate update2 = new FeatureUpdate(((org.apache.kafka.common.feature.FinalizedVersionRange)targetFinalizedFeatures.get("feature_2")).max(), false);
        Admin adminClient = this.createAdminClient(this.createAdminClient$default$1());
        adminClient.updateFeatures(Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"feature_1", (Object)update1), Utils.mkEntry((Object)"feature_2", (Object)update2)}), new UpdateFeaturesOptions()).all().get();
        this.checkFeatures(adminClient, new FeatureZNode(FeatureZNodeStatus$.MODULE$.Enabled(), targetFinalizedFeatures), (Features<org.apache.kafka.common.feature.FinalizedVersionRange>)targetFinalizedFeatures, versionBefore + 1, (Features<SupportedVersionRange>)supportedFeatures);
    }

    @Test
    public void testSuccessfulFeatureUpgradeAndDowngrade() {
        TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), TestUtils$.MODULE$.waitUntilControllerElected$default$2());
        Features supportedFeatures = Features.supportedFeatures((Map)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"feature_1", (Object)new SupportedVersionRange(1, 3)), Utils.mkEntry((Object)"feature_2", (Object)new SupportedVersionRange(2, 5))}));
        this.updateSupportedFeaturesInAllBrokers((Features<SupportedVersionRange>)supportedFeatures);
        Features initialFinalizedFeatures = Features.finalizedFeatures((Map)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"feature_1", (Object)new org.apache.kafka.common.feature.FinalizedVersionRange(1, 2)), Utils.mkEntry((Object)"feature_2", (Object)new org.apache.kafka.common.feature.FinalizedVersionRange(2, 4))}));
        int versionBefore = this.updateFeatureZNode((Features<org.apache.kafka.common.feature.FinalizedVersionRange>)initialFinalizedFeatures);
        Features targetFinalizedFeatures = Features.finalizedFeatures((Map)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"feature_1", (Object)new org.apache.kafka.common.feature.FinalizedVersionRange(1, 3)), Utils.mkEntry((Object)"feature_2", (Object)new org.apache.kafka.common.feature.FinalizedVersionRange(2, 3))}));
        FeatureUpdate update1 = new FeatureUpdate(((org.apache.kafka.common.feature.FinalizedVersionRange)targetFinalizedFeatures.get("feature_1")).max(), false);
        FeatureUpdate update2 = new FeatureUpdate(((org.apache.kafka.common.feature.FinalizedVersionRange)targetFinalizedFeatures.get("feature_2")).max(), true);
        Admin adminClient = this.createAdminClient(this.createAdminClient$default$1());
        adminClient.updateFeatures(Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"feature_1", (Object)update1), Utils.mkEntry((Object)"feature_2", (Object)update2)}), new UpdateFeaturesOptions()).all().get();
        this.checkFeatures(adminClient, new FeatureZNode(FeatureZNodeStatus$.MODULE$.Enabled(), targetFinalizedFeatures), (Features<org.apache.kafka.common.feature.FinalizedVersionRange>)targetFinalizedFeatures, versionBefore + 1, (Features<SupportedVersionRange>)supportedFeatures);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testPartialSuccessDuringValidFeatureUpgradeAndInvalidDowngrade() {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), TestUtils$.MODULE$.waitUntilControllerElected$default$2());
        Features supportedFeatures = Features.supportedFeatures((Map)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"feature_1", (Object)new SupportedVersionRange(1, 3)), Utils.mkEntry((Object)"feature_2", (Object)new SupportedVersionRange(2, 5))}));
        this.updateSupportedFeaturesInAllBrokers((Features<SupportedVersionRange>)supportedFeatures);
        Features initialFinalizedFeatures = Features.finalizedFeatures((Map)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"feature_1", (Object)new org.apache.kafka.common.feature.FinalizedVersionRange(1, 2)), Utils.mkEntry((Object)"feature_2", (Object)new org.apache.kafka.common.feature.FinalizedVersionRange(2, 4))}));
        int versionBefore = this.updateFeatureZNode((Features<org.apache.kafka.common.feature.FinalizedVersionRange>)initialFinalizedFeatures);
        Features targetFinalizedFeatures = Features.finalizedFeatures((Map)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"feature_1", (Object)new org.apache.kafka.common.feature.FinalizedVersionRange(1, 3)), Utils.mkEntry((Object)"feature_2", (Object)new org.apache.kafka.common.feature.FinalizedVersionRange(2, 3))}));
        FeatureUpdate validUpdate = new FeatureUpdate(((org.apache.kafka.common.feature.FinalizedVersionRange)targetFinalizedFeatures.get("feature_1")).max(), false);
        FeatureUpdate invalidUpdate = new FeatureUpdate(((org.apache.kafka.common.feature.FinalizedVersionRange)targetFinalizedFeatures.get("feature_2")).max(), false);
        Admin adminClient = this.createAdminClient(this.createAdminClient$default$1());
        UpdateFeaturesResult result = adminClient.updateFeatures(Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"feature_1", (Object)validUpdate), Utils.mkEntry((Object)"feature_2", (Object)invalidUpdate)}), new UpdateFeaturesOptions());
        ((KafkaFuture)result.values().get("feature_1")).get();
        Tuple2[] tuple2Array = new Tuple2[1];
        String string = ".*Can not downgrade finalized feature.*allowDowngrade.*";
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        Regex regex = new StringOps(string).r();
        Object object = Predef$.MODULE$.ArrowAssoc((Object)"feature_2");
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        this.checkException(result, (scala.collection.immutable.Map<String, Regex>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array))), ClassTag$.MODULE$.apply(InvalidRequestException.class));
        Features expectedFeatures = Features.finalizedFeatures((Map)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"feature_1", (Object)targetFinalizedFeatures.get("feature_1")), Utils.mkEntry((Object)"feature_2", (Object)initialFinalizedFeatures.get("feature_2"))}));
        this.checkFeatures(adminClient, new FeatureZNode(FeatureZNodeStatus$.MODULE$.Enabled(), expectedFeatures), (Features<org.apache.kafka.common.feature.FinalizedVersionRange>)expectedFeatures, versionBefore + 1, (Features<SupportedVersionRange>)supportedFeatures);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testPartialSuccessDuringInvalidFeatureUpgradeAndValidDowngrade() {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), TestUtils$.MODULE$.waitUntilControllerElected$default$2());
        KafkaServer controller = (KafkaServer)((IterableLike)this.servers().filter((Function1 & Serializable & scala.Serializable)server -> BoxesRunTime.boxToBoolean((boolean)UpdateFeaturesTest.$anonfun$testPartialSuccessDuringInvalidFeatureUpgradeAndValidDowngrade$1(server)))).head();
        Buffer nonControllerServers = (Buffer)this.servers().filter((Function1 & Serializable & scala.Serializable)server -> BoxesRunTime.boxToBoolean((boolean)UpdateFeaturesTest.$anonfun$testPartialSuccessDuringInvalidFeatureUpgradeAndValidDowngrade$2(server)));
        Set brokersWithVersionIncompatibility = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaServer[]{(KafkaServer)nonControllerServers.head()}));
        Set versionCompatibleBrokers = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaServer[]{(KafkaServer)nonControllerServers.apply(1), controller}));
        Features supportedFeatures = Features.supportedFeatures((Map)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"feature_1", (Object)new SupportedVersionRange(1, 3)), Utils.mkEntry((Object)"feature_2", (Object)new SupportedVersionRange(2, 5))}));
        this.updateSupportedFeatures((Features<SupportedVersionRange>)supportedFeatures, (Set<KafkaServer>)versionCompatibleBrokers);
        Features supportedFeaturesWithVersionIncompatibility = Features.supportedFeatures((Map)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"feature_1", (Object)new SupportedVersionRange(1, 2)), Utils.mkEntry((Object)"feature_2", (Object)supportedFeatures.get("feature_2"))}));
        this.updateSupportedFeatures((Features<SupportedVersionRange>)supportedFeaturesWithVersionIncompatibility, (Set<KafkaServer>)brokersWithVersionIncompatibility);
        Features initialFinalizedFeatures = Features.finalizedFeatures((Map)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"feature_1", (Object)new org.apache.kafka.common.feature.FinalizedVersionRange(1, 2)), Utils.mkEntry((Object)"feature_2", (Object)new org.apache.kafka.common.feature.FinalizedVersionRange(2, 4))}));
        int versionBefore = this.updateFeatureZNode((Features<org.apache.kafka.common.feature.FinalizedVersionRange>)initialFinalizedFeatures);
        Features targetFinalizedFeatures = Features.finalizedFeatures((Map)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"feature_1", (Object)new org.apache.kafka.common.feature.FinalizedVersionRange(1, 3)), Utils.mkEntry((Object)"feature_2", (Object)new org.apache.kafka.common.feature.FinalizedVersionRange(2, 3))}));
        FeatureUpdate invalidUpdate = new FeatureUpdate(((org.apache.kafka.common.feature.FinalizedVersionRange)targetFinalizedFeatures.get("feature_1")).max(), false);
        FeatureUpdate validUpdate = new FeatureUpdate(((org.apache.kafka.common.feature.FinalizedVersionRange)targetFinalizedFeatures.get("feature_2")).max(), true);
        Admin adminClient = this.createAdminClient(this.createAdminClient$default$1());
        UpdateFeaturesResult result = adminClient.updateFeatures(Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"feature_1", (Object)invalidUpdate), Utils.mkEntry((Object)"feature_2", (Object)validUpdate)}), new UpdateFeaturesOptions());
        ((KafkaFuture)result.values().get("feature_2")).get();
        Tuple2[] tuple2Array = new Tuple2[1];
        String string = ".*brokers.*incompatible.*";
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        Regex regex = new StringOps(string).r();
        Object object = Predef$.MODULE$.ArrowAssoc((Object)"feature_1");
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        this.checkException(result, (scala.collection.immutable.Map<String, Regex>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array))), ClassTag$.MODULE$.apply(InvalidRequestException.class));
        Features expectedFeatures = Features.finalizedFeatures((Map)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"feature_1", (Object)initialFinalizedFeatures.get("feature_1")), Utils.mkEntry((Object)"feature_2", (Object)targetFinalizedFeatures.get("feature_2"))}));
        this.checkFeatures(adminClient, new FeatureZNode(FeatureZNodeStatus$.MODULE$.Enabled(), expectedFeatures), (Features<org.apache.kafka.common.feature.FinalizedVersionRange>)expectedFeatures, versionBefore + 1, (Features<SupportedVersionRange>)supportedFeatures);
    }

    public static final /* synthetic */ void $anonfun$updateSupportedFeatures$1(Features features$1, KafkaServer s) {
        s.brokerFeatures().setSupportedFeatures(features$1);
        s.zkClient().updateBrokerInfo(s.createBrokerInfo());
    }

    public static final /* synthetic */ int $anonfun$updateSupportedFeatures$2(KafkaServer s) {
        return s.config().brokerId();
    }

    public static final /* synthetic */ boolean $anonfun$updateSupportedFeatures$6(Features features$1, Broker b) {
        return b.features().equals((Object)features$1);
    }

    public static final /* synthetic */ boolean $anonfun$updateSupportedFeatures$4(Set brokerIds$1, Features features$1, KafkaServer s) {
        if (s.kafkaController().isActive()) {
            return ((IterableLike)s.kafkaController().controllerContext().liveOrShuttingDownBrokers().filter((Function1 & Serializable & scala.Serializable)b -> BoxesRunTime.boxToBoolean((boolean)brokerIds$1.contains((Object)BoxesRunTime.boxToInteger((int)b.id()))))).forall((Function1 & Serializable & scala.Serializable)b -> BoxesRunTime.boxToBoolean((boolean)UpdateFeaturesTest.$anonfun$updateSupportedFeatures$6(features$1, b)));
        }
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$updateSupportedFeatures$3(UpdateFeaturesTest $this, Set brokerIds$1, Features features$1) {
        return $this.servers().exists((Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToBoolean((boolean)UpdateFeaturesTest.$anonfun$updateSupportedFeatures$4(brokerIds$1, features$1, s)));
    }

    public static final /* synthetic */ String $anonfun$updateSupportedFeatures$7() {
        return "Controller did not get broker updates";
    }

    public static final /* synthetic */ void $anonfun$updateFeatureZNode$1(int newVersion$1, KafkaServer s) {
        s.featureCache().waitUntilEpochOrThrow((long)newVersion$1, (long)s.config().zkConnectionTimeoutMs());
    }

    public static final /* synthetic */ void $anonfun$checkException$1(UpdateFeaturesResult result$1, ClassTag tag$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            String feature = (String)x0$1._1();
            Regex exceptionMsgPattern = (Regex)x0$1._2();
            Throwable cause = ((ExecutionException)Assertions$.MODULE$.intercept((Function0 & Serializable & scala.Serializable)() -> (Void)((KafkaFuture)result$1.values().get(feature)).get(), ClassTag$.MODULE$.apply(ExecutionException.class), new Position("UpdateFeaturesTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 136))).getCause();
            Assert.assertNotNull((Object)cause);
            Assert.assertEquals(cause.getClass(), (Object)tag$1.runtimeClass());
            Assert.assertTrue((String)new StringBuilder(35).append("Received unexpected error message: ").append(cause.getMessage()).toString(), (boolean)exceptionMsgPattern.findFirstIn((CharSequence)cause.getMessage()).isDefined());
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$testShouldFailRequestDuringBrokerMaxVersionLevelIncompatibility$1(KafkaServer server) {
        return server.kafkaController().isActive();
    }

    public static final /* synthetic */ boolean $anonfun$testShouldFailRequestDuringBrokerMaxVersionLevelIncompatibility$2(KafkaServer server) {
        return !server.kafkaController().isActive();
    }

    public static final /* synthetic */ Features $anonfun$testShouldFailRequestDuringBrokerMaxVersionLevelIncompatibility$3(String featureName$1, org.apache.kafka.common.feature.FinalizedVersionRange versionRange) {
        return Features.finalizedFeatures((Map)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)featureName$1, (Object)versionRange)}));
    }

    public static final /* synthetic */ Features $anonfun$testShouldFailRequestDuringBrokerMaxVersionLevelIncompatibility$4() {
        return Features.emptyFinalizedFeatures();
    }

    public static final /* synthetic */ boolean $anonfun$testPartialSuccessDuringInvalidFeatureUpgradeAndValidDowngrade$1(KafkaServer server) {
        return server.kafkaController().isActive();
    }

    public static final /* synthetic */ boolean $anonfun$testPartialSuccessDuringInvalidFeatureUpgradeAndValidDowngrade$2(KafkaServer server) {
        return !server.kafkaController().isActive();
    }
}

