/*
 * Decompiled with CFR 0.152.
 */
package kafka.utils;

import java.io.Serializable;
import kafka.api.LeaderAndIsr;
import kafka.controller.LeaderIsrAndControllerEpoch;
import kafka.log.Log;
import kafka.log.LogManager;
import kafka.server.KafkaConfig$;
import kafka.server.ReplicaFetcherManager;
import kafka.server.ReplicaManager;
import kafka.utils.ReplicationUtils$;
import kafka.utils.TestUtils$;
import kafka.zk.IsrChangeNotificationZNode$;
import kafka.zk.TopicZNode$;
import kafka.zk.ZkVersion$;
import kafka.zk.ZooKeeperTestHarness;
import org.apache.kafka.common.TopicPartition;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001u3AAE\n\u00011!)q\u0004\u0001C\u0001A!91\u0005\u0001b\u0001\n\u0013!\u0003BB\u0016\u0001A\u0003%Q\u0005C\u0004-\u0001\t\u0007I\u0011B\u0017\t\rY\u0002\u0001\u0015!\u0003/\u0011\u001d9\u0004A1A\u0005\n\u0011Ba\u0001\u000f\u0001!\u0002\u0013)\u0003bB\u001d\u0001\u0005\u0004%I\u0001\n\u0005\u0007u\u0001\u0001\u000b\u0011B\u0013\t\u000fm\u0002!\u0019!C\u0005I!1A\b\u0001Q\u0001\n\u0015Bq!\u0010\u0001C\u0002\u0013%A\u0005\u0003\u0004?\u0001\u0001\u0006I!\n\u0005\b\u007f\u0001\u0011\r\u0011\"\u0003A\u0011\u0019I\u0005\u0001)A\u0005\u0003\")!\n\u0001C!\u0017\")\u0001\f\u0001C\u0001\u0017\n!\"+\u001a9mS\u000e\fG/[8o+RLGn\u001d+fgRT!\u0001F\u000b\u0002\u000bU$\u0018\u000e\\:\u000b\u0003Y\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u00013A\u0011!$H\u0007\u00027)\u0011A$F\u0001\u0003u.L!AH\u000e\u0003)i{wnS3fa\u0016\u0014H+Z:u\u0011\u0006\u0014h.Z:t\u0003\u0019a\u0014N\\5u}Q\t\u0011\u0005\u0005\u0002#\u00015\t1#A\u0005{WZ+'o]5p]V\tQ\u0005\u0005\u0002'S5\tqEC\u0001)\u0003\u0015\u00198-\u00197b\u0013\tQsEA\u0002J]R\f!B_6WKJ\u001c\u0018n\u001c8!\u0003\u0015!x\u000e]5d+\u0005q\u0003CA\u00185\u001b\u0005\u0001$BA\u00193\u0003\u0011a\u0017M\\4\u000b\u0003M\nAA[1wC&\u0011Q\u0007\r\u0002\u0007'R\u0014\u0018N\\4\u0002\rQ|\u0007/[2!\u0003%\u0001\u0018M\u001d;ji&|g.\u0001\u0006qCJ$\u0018\u000e^5p]\u0002\na\u0001\\3bI\u0016\u0014\u0018a\u00027fC\u0012,'\u000fI\u0001\fY\u0016\fG-\u001a:Fa>\u001c\u0007.\u0001\u0007mK\u0006$WM]#q_\u000eD\u0007%A\bd_:$(o\u001c7mKJ,\u0005o\\2i\u0003A\u0019wN\u001c;s_2dWM]#q_\u000eD\u0007%A\u0002jgJ,\u0012!\u0011\t\u0004\u0005\u001e+S\"A\"\u000b\u0005\u0011+\u0015!C5n[V$\u0018M\u00197f\u0015\t1u%\u0001\u0006d_2dWm\u0019;j_:L!\u0001S\"\u0003\t1K7\u000f^\u0001\u0005SN\u0014\b%A\u0003tKR,\u0006\u000fF\u0001M!\t1S*\u0003\u0002OO\t!QK\\5uQ\t\u0001\u0002\u000b\u0005\u0002R-6\t!K\u0003\u0002T)\u0006)!.\u001e8ji*\tQ+A\u0002pe\u001eL!a\u0016*\u0003\r\t+gm\u001c:f\u0003Y!Xm\u001d;Va\u0012\fG/\u001a'fC\u0012,'/\u00118e\u0013N\u0014\bFA\t[!\t\t6,\u0003\u0002]%\n!A+Z:u\u0001")
public class ReplicationUtilsTest
extends ZooKeeperTestHarness {
    private final int zkVersion;
    private final String topic;
    private final int partition;
    private final int leader;
    private final int leaderEpoch;
    private final int controllerEpoch;
    private final List<Object> isr = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2}));

    private int zkVersion() {
        return this.zkVersion;
    }

    private String topic() {
        return this.topic;
    }

    private int partition() {
        return this.partition;
    }

    private int leader() {
        return this.leader;
    }

    private int leaderEpoch() {
        return this.leaderEpoch;
    }

    private int controllerEpoch() {
        return this.controllerEpoch;
    }

    private List<Object> isr() {
        return this.isr;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Before
    public void setUp() {
        void $minus$greater$extension_$this;
        super.setUp();
        this.zkClient().makeSurePersistentPathExists(TopicZNode$.MODULE$.path(this.topic()));
        TopicPartition topicPartition = new TopicPartition(this.topic(), this.partition());
        LeaderAndIsr leaderAndIsr = new LeaderAndIsr(this.leader(), this.leaderEpoch(), this.isr(), 1);
        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(leaderAndIsr, this.controllerEpoch());
        Tuple2[] tuple2Array = new Tuple2[1];
        Object object = Predef$.MODULE$.ArrowAssoc((Object)topicPartition);
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)leaderIsrAndControllerEpoch);
        this.zkClient().createTopicPartitionStatesRaw((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array)), ZkVersion$.MODULE$.MatchAnyVersion());
    }

    @Test
    public void testUpdateLeaderAndIsr() {
        Seq configs = (Seq)TestUtils$.MODULE$.createBrokerConfigs(1, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfigs$default$3(), TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13(), TestUtils$.MODULE$.createBrokerConfigs$default$14(), TestUtils$.MODULE$.createBrokerConfigs$default$15(), TestUtils$.MODULE$.createBrokerConfigs$default$16()).map((Function1 & Serializable & scala.Serializable)props -> KafkaConfig$.MODULE$.fromProps(props), Seq$.MODULE$.canBuildFrom());
        Log log = (Log)EasyMock.createMock(Log.class);
        EasyMock.expect((Object)BoxesRunTime.boxToLong((long)log.logEndOffset())).andReturn((Object)BoxesRunTime.boxToLong((long)20L)).anyTimes();
        EasyMock.expect((Object)log);
        EasyMock.replay((Object[])new Object[]{log});
        LogManager logManager = (LogManager)EasyMock.createMock(LogManager.class);
        EasyMock.expect((Object)logManager.getLog(new TopicPartition(this.topic(), this.partition()), false)).andReturn((Object)new Some((Object)log)).anyTimes();
        EasyMock.replay((Object[])new Object[]{logManager});
        ReplicaManager replicaManager = (ReplicaManager)EasyMock.createMock(ReplicaManager.class);
        EasyMock.expect((Object)replicaManager.config()).andReturn(configs.head());
        EasyMock.expect((Object)replicaManager.logManager()).andReturn((Object)logManager);
        EasyMock.expect((Object)replicaManager.replicaFetcherManager()).andReturn(EasyMock.createMock(ReplicaFetcherManager.class));
        EasyMock.expect((Object)replicaManager.zkClient()).andReturn((Object)this.zkClient());
        EasyMock.replay((Object[])new Object[]{replicaManager});
        this.zkClient().makeSurePersistentPathExists(IsrChangeNotificationZNode$.MODULE$.path());
        List replicas = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1}));
        LeaderAndIsr newLeaderAndIsr1 = new LeaderAndIsr(this.leader(), this.leaderEpoch(), replicas, 0);
        Tuple2 tuple2 = ReplicationUtils$.MODULE$.updateLeaderAndIsr(this.zkClient(), new TopicPartition(this.topic(), this.partition()), newLeaderAndIsr1, this.controllerEpoch());
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        boolean bl = tuple2._1$mcZ$sp();
        int n = tuple2._2$mcI$sp();
        Assert.assertTrue((boolean)bl);
        Assert.assertEquals((long)n, (long)1L);
        LeaderAndIsr newLeaderAndIsr2 = new LeaderAndIsr(this.leader(), this.leaderEpoch(), replicas, this.zkVersion() + 1);
        Tuple2 tuple22 = ReplicationUtils$.MODULE$.updateLeaderAndIsr(this.zkClient(), new TopicPartition(this.topic(), this.partition()), newLeaderAndIsr2, this.controllerEpoch());
        if (tuple22 == null) {
            throw new MatchError(null);
        }
        boolean bl2 = tuple22._1$mcZ$sp();
        int n2 = tuple22._2$mcI$sp();
        Assert.assertTrue((boolean)bl2);
        Assert.assertEquals((long)n2, (long)1L);
        LeaderAndIsr newLeaderAndIsr3 = new LeaderAndIsr(this.leader(), this.leaderEpoch() + 1, replicas, this.zkVersion() + 1);
        Tuple2 tuple23 = ReplicationUtils$.MODULE$.updateLeaderAndIsr(this.zkClient(), new TopicPartition(this.topic(), this.partition()), newLeaderAndIsr3, this.controllerEpoch());
        if (tuple23 == null) {
            throw new MatchError(null);
        }
        boolean bl3 = tuple23._1$mcZ$sp();
        int n3 = tuple23._2$mcI$sp();
        Assert.assertFalse((boolean)bl3);
        Assert.assertEquals((long)n3, (long)-1L);
    }

    public ReplicationUtilsTest() {
        this.zkVersion = 1;
        this.topic = "my-topic-test";
        this.partition = 0;
        this.leader = 1;
        this.leaderEpoch = 1;
        this.controllerEpoch = 1;
    }
}

