/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.File;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Collection;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import kafka.integration.KafkaServerTestHarness;
import kafka.log.Log;
import kafka.log.LogManager;
import kafka.log.ProducerStateEntry;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.consumer.OffsetAndTimestamp;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.InvalidProducerEpochException;
import org.apache.kafka.common.errors.ProducerFencedException;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.test.TestUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.Function3;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;

@ScalaSignature(bytes="\u0006\u0001\tUe\u0001\u0002\u001e<\u0001\u0001CQa\u0012\u0001\u0005\u0002!Cqa\u0013\u0001C\u0002\u0013\u0005A\n\u0003\u0004T\u0001\u0001\u0006I!\u0014\u0005\b)\u0002\u0011\r\u0011\"\u0001M\u0011\u0019)\u0006\u0001)A\u0005\u001b\"9a\u000b\u0001b\u0001\n\u0003a\u0005BB,\u0001A\u0003%Q\nC\u0004Y\u0001\t\u0007I\u0011\u0001'\t\re\u0003\u0001\u0015!\u0003N\u0011\u001dQ\u0006A1A\u0005\u0002mCa\u0001\u001a\u0001!\u0002\u0013a\u0006bB3\u0001\u0005\u0004%\ta\u0017\u0005\u0007M\u0002\u0001\u000b\u0011\u0002/\t\u000f\u001d\u0004!\u0019!C\u0001\u0019\"1\u0001\u000e\u0001Q\u0001\n5Cq!\u001b\u0001C\u0002\u0013\u0005!\u000eC\u0004\u0002\u000e\u0001\u0001\u000b\u0011B6\t\u0013\u0005=\u0001A1A\u0005\u0002\u0005E\u0001\u0002CA\u0011\u0001\u0001\u0006I!a\u0005\t\u0013\u0005\r\u0002A1A\u0005\u0002\u0005E\u0001\u0002CA\u0013\u0001\u0001\u0006I!a\u0005\t\u000f\u0005\u001d\u0002\u0001\"\u0011\u0002*!9\u0011q\b\u0001\u0005B\u0005\u0005\u0003bBA,\u0001\u0011\u0005\u0013\u0011\t\u0005\b\u0003C\u0002A\u0011AA!\u0011\u001d\tY\u0007\u0001C\u0001\u0003\u0003Bq!a\u001c\u0001\t\u0003\t\t\u0005C\u0004\u0002t\u0001!\t!!\u0011\t\u000f\u0005]\u0004\u0001\"\u0001\u0002B!9\u00111\u0010\u0001\u0005\n\u0005u\u0004bBAO\u0001\u0011\u0005\u0011\u0011\t\u0005\b\u0003C\u0003A\u0011AA!\u0011\u001d\t)\u000b\u0001C\u0001\u0003\u0003Bq!!+\u0001\t\u0003\t\t\u0005C\u0004\u0002B\u0002!\t!!\u0011\t\u000f\u0005\u0015\u0007\u0001\"\u0001\u0002B!9\u0011\u0011\u001a\u0001\u0005\u0002\u0005\u0005\u0003bBAg\u0001\u0011\u0005\u0011q\u001a\u0005\b\u0003K\u0004A\u0011AA!\u0011\u001d\tI\u000f\u0001C\u0001\u0003\u0003Bq!!<\u0001\t\u0003\t\t\u0005C\u0004\u0002r\u0002!\t!!\u0011\t\u000f\u0005U\b\u0001\"\u0001\u0002B!9!1\u0001\u0001\u0005\u0002\u0005\u0005\u0003b\u0002B\u0004\u0001\u0011\u0005\u0011\u0011\t\u0005\b\u0005\u0017\u0001A\u0011\u0002B\u0007\u0011\u001d\u0011\t\u0003\u0001C\u0005\u0005GAqA!\r\u0001\t\u0013\u0011\u0019\u0004C\u0005\u0003B\u0001\t\n\u0011\"\u0003\u0003D!I!\u0011\f\u0001\u0012\u0002\u0013%!1\f\u0005\n\u0005?\u0002\u0011\u0013!C\u0005\u0005CBqA!\u001a\u0001\t\u0013\u00119\u0007C\u0004\u0003l\u0001!IA!\u001c\t\u0013\t%\u0005!%A\u0005\n\t-\u0005\"\u0003BH\u0001E\u0005I\u0011\u0002BF\u0011%\u0011\t\nAI\u0001\n\u0013\u0011Y\u0006C\u0005\u0003\u0014\u0002\t\n\u0011\"\u0003\u0003\\\t\u0001BK]1og\u0006\u001cG/[8ogR+7\u000f\u001e\u0006\u0003yu\n1!\u00199j\u0015\u0005q\u0014!B6bM.\f7\u0001A\n\u0003\u0001\u0005\u0003\"AQ#\u000e\u0003\rS!\u0001R\u001f\u0002\u0017%tG/Z4sCRLwN\\\u0005\u0003\r\u000e\u0013acS1gW\u0006\u001cVM\u001d<feR+7\u000f\u001e%be:,7o]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003%\u0003\"A\u0013\u0001\u000e\u0003m\n!B\\;n'\u0016\u0014h/\u001a:t+\u0005i\u0005C\u0001(R\u001b\u0005y%\"\u0001)\u0002\u000bM\u001c\u0017\r\\1\n\u0005I{%aA%oi\u0006Ya.^7TKJ4XM]:!\u0003i!(/\u00198tC\u000e$\u0018n\u001c8bYB\u0013x\u000eZ;dKJ\u001cu.\u001e8u\u0003m!(/\u00198tC\u000e$\u0018n\u001c8bYB\u0013x\u000eZ;dKJ\u001cu.\u001e8uA\u0005QBO]1og\u0006\u001cG/[8oC2\u001cuN\\:v[\u0016\u00148i\\;oi\u0006YBO]1og\u0006\u001cG/[8oC2\u001cuN\\:v[\u0016\u00148i\\;oi\u0002\nQD\\8o)J\fgn]1di&|g.\u00197D_:\u001cX/\\3s\u0007>,h\u000e^\u0001\u001f]>tGK]1og\u0006\u001cG/[8oC2\u001cuN\\:v[\u0016\u00148i\\;oi\u0002\na\u0001^8qS\u000e\fT#\u0001/\u0011\u0005u\u0013W\"\u00010\u000b\u0005}\u0003\u0017\u0001\u00027b]\u001eT\u0011!Y\u0001\u0005U\u00064\u0018-\u0003\u0002d=\n11\u000b\u001e:j]\u001e\fq\u0001^8qS\u000e\f\u0004%\u0001\u0004u_BL7MM\u0001\bi>\u0004\u0018n\u0019\u001a!\u00035qW/\u001c)beRLG/[8og\u0006qa.^7QCJ$\u0018\u000e^5p]N\u0004\u0013A\u0006;sC:\u001c\u0018m\u0019;j_:\fG\u000e\u0015:pIV\u001cWM]:\u0016\u0003-\u00042\u0001\\9t\u001b\u0005i'B\u00018p\u0003\u001diW\u000f^1cY\u0016T!\u0001](\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002s[\n1!)\u001e4gKJ\u0004b\u0001\u001e@\u0002\u0002\u0005\u0005Q\"A;\u000b\u0005Y<\u0018\u0001\u00039s_\u0012,8-\u001a:\u000b\u0005aL\u0018aB2mS\u0016tGo\u001d\u0006\u0003}iT!a\u001f?\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005i\u0018aA8sO&\u0011q0\u001e\u0002\u000e\u0017\u000647.\u0019)s_\u0012,8-\u001a:\u0011\u000b9\u000b\u0019!a\u0002\n\u0007\u0005\u0015qJA\u0003BeJ\f\u0017\u0010E\u0002O\u0003\u0013I1!a\u0003P\u0005\u0011\u0011\u0015\u0010^3\u0002/Q\u0014\u0018M\\:bGRLwN\\1m!J|G-^2feN\u0004\u0013A\u0006;sC:\u001c\u0018m\u0019;j_:\fGnQ8ogVlWM]:\u0016\u0005\u0005M\u0001\u0003\u00027r\u0003+\u0001\u0002\"a\u0006\u0002\u001e\u0005\u0005\u0011\u0011A\u0007\u0003\u00033Q1!a\u0007x\u0003!\u0019wN\\:v[\u0016\u0014\u0018\u0002BA\u0010\u00033\u0011QbS1gW\u0006\u001cuN\\:v[\u0016\u0014\u0018a\u0006;sC:\u001c\u0018m\u0019;j_:\fGnQ8ogVlWM]:!\u0003eqwN\u001c+sC:\u001c\u0018m\u0019;j_:\fGnQ8ogVlWM]:\u000259|g\u000e\u0016:b]N\f7\r^5p]\u0006d7i\u001c8tk6,'o\u001d\u0011\u0002\u001f\u001d,g.\u001a:bi\u0016\u001cuN\u001c4jON,\"!a\u000b\u0011\r\u00055\u0012qFA\u001a\u001b\u0005y\u0017bAA\u0019_\n\u00191+Z9\u0011\t\u0005U\u00121H\u0007\u0003\u0003oQ1!!\u000f>\u0003\u0019\u0019XM\u001d<fe&!\u0011QHA\u001c\u0005-Y\u0015MZ6b\u0007>tg-[4\u0002\u000bM,G/\u00169\u0015\u0005\u0005\r\u0003c\u0001(\u0002F%\u0019\u0011qI(\u0003\tUs\u0017\u000e\u001e\u0015\u0004/\u0005-\u0003\u0003BA'\u0003'j!!a\u0014\u000b\u0007\u0005EC0A\u0003kk:LG/\u0003\u0003\u0002V\u0005=#A\u0002\"fM>\u0014X-\u0001\u0005uK\u0006\u0014Hi\\<oQ\rA\u00121\f\t\u0005\u0003\u001b\ni&\u0003\u0003\u0002`\u0005=#!B!gi\u0016\u0014\u0018!\u0006;fgR\u0014\u0015m]5d)J\fgn]1di&|gn\u001d\u0015\u00043\u0005\u0015\u0004\u0003BA'\u0003OJA!!\u001b\u0002P\t!A+Z:u\u0003I\"Xm\u001d;SK\u0006$7i\\7nSR$X\rZ\"p]N,X.\u001a:TQ>,H\u000e\u001a(piN+W-\u00168eK\u000eLG-\u001a3ECR\f\u0007f\u0001\u000e\u0002f\u0005QC/Z:u\t\u0016d\u0017-_3e\r\u0016$8\r[%oG2,H-Z:BE>\u0014H/\u001a3Ue\u0006t7/Y2uS>t\u0007fA\u000e\u0002f\u0005QB/Z:u'\u0016tGm\u00144gg\u0016$8oV5uQ\u001e\u0013x.\u001e9JI\"\u001aA$!\u001a\u0002AQ,7\u000f^*f]\u0012|eMZ:fiN<\u0016\u000e\u001e5He>,\b/T3uC\u0012\fG/\u0019\u0015\u0004;\u0005\u0015\u0014AC:f]\u0012|eMZ:fiR!\u00111IA@\u0011\u001d\t\tI\ba\u0001\u0003\u0007\u000baaY8n[&$\bC\u0003(\u0002\u0006N\fI)!\u0006\u0002D%\u0019\u0011qQ(\u0003\u0013\u0019+hn\u0019;j_:\u001c\u0004\u0003BAF\u00033sA!!$\u0002\u0016B\u0019\u0011qR(\u000e\u0005\u0005E%bAAJ\u007f\u00051AH]8pizJ1!a&P\u0003\u0019\u0001&/\u001a3fM&\u00191-a'\u000b\u0007\u0005]u*A\nuKN$h)\u001a8dS:<wJ\\\"p[6LG\u000fK\u0002 \u0003K\n\u0001\u0004^3ti\u001a+gnY5oO>s7+\u001a8e\u001f\u001a47/\u001a;tQ\r\u0001\u0013QM\u0001-i\u0016\u001cHo\u00144gg\u0016$X*\u001a;bI\u0006$\u0018-\u00138TK:$wJ\u001a4tKR\u001cHk\u001c+sC:\u001c\u0018m\u0019;j_:D3!IA3\u0003m!Xm\u001d;J]&$HK]1og\u0006\u001cG/[8ogRKW.Z8vi\":!%!\u001a\u0002.\u0006=\u0016\u0001C3ya\u0016\u001cG/\u001a3$\u0005\u0005E\u0006\u0003BAZ\u0003{k!!!.\u000b\t\u0005]\u0016\u0011X\u0001\u0007KJ\u0014xN]:\u000b\u0007\u0005m\u00160\u0001\u0004d_6lwN\\\u0005\u0005\u0003\u007f\u000b)L\u0001\tUS6,w.\u001e;Fq\u000e,\u0007\u000f^5p]\u0006\u0019C/Z:u'\u0016tGm\u00144gg\u0016$8\u000fV8Ue\u0006t7/Y2uS>tG+[7f_V$\bfB\u0012\u0002f\u00055\u0016qV\u0001\u001di\u0016\u001cHoQ8n[&$HK]1og\u0006\u001cG/[8o)&lWm\\;uQ\u001d!\u0013QMAW\u0003_\u000b1\u0004^3ti\u0006\u0013wN\u001d;Ue\u0006t7/Y2uS>tG+[7f_V$\bfB\u0013\u0002f\u00055\u0016qV\u0001\fi\u0016\u001cH\u000fV5nK>,H\u000f\u0006\u0004\u0002D\u0005E\u00171\u001c\u0005\b\u0003'4\u0003\u0019AAk\u0003IqW-\u001a3J]&$\u0018I\u001c3TK:$Wj]4\u0011\u00079\u000b9.C\u0002\u0002Z>\u0013qAQ8pY\u0016\fg\u000eC\u0004\u0002^\u001a\u0002\r!a8\u0002\u001dQLW.Z8viB\u0013xnY3tgB1a*!9t\u0003\u0007J1!a9P\u0005%1UO\\2uS>t\u0017'A\tuKN$h)\u001a8dS:<wJ\\*f]\u0012D3aJA3\u0003i!Xm\u001d;GK:\u001c\u0017N\\4P]\u0006#G\rU1si&$\u0018n\u001c8tQ\rA\u0013QM\u0001#i\u0016\u001cHOR3oG&twm\u00148Ue\u0006t7/Y2uS>tW\t\u001f9je\u0006$\u0018n\u001c8)\u0007%\n)'\u0001\u000fuKN$X*\u001e7uSBdW-T1sW\u0016\u00148o\u00148f\u0019\u0016\fG-\u001a:)\u0007)\n)'\u0001\u0013uKN$8i\u001c8tK\u000e,H/\u001b<fYf\u0014VO\\%oSR$&/\u00198tC\u000e$\u0018n\u001c8tQ\u001dY\u0013QMAW\u0003s\u001c#!a?\u0011\t\u0005u\u0018q`\u0007\u0003\u0003sKAA!\u0001\u0002:\nq1*\u00194lC\u0016C8-\u001a9uS>t\u0017A\u0007;fgR\u0014U/\u001c9Ue\u0006t7/Y2uS>t\u0017\r\\#q_\u000eD\u0007f\u0001\u0017\u0002f\u00059B/Z:u\r\u0006LG.\u001e:f)>4UM\\2f\u000bB|7\r\u001b\u0015\u0004[\u0005\u0015\u0014aJ:f]\u0012$&/\u00198tC\u000e$\u0018n\u001c8bY6+7o]1hKN<\u0016\u000e\u001e5WC2,XMU1oO\u0016$B\"a\u0011\u0003\u0010\tE!Q\u0003B\r\u0005;AQA\u001e\u0018A\u0002MDqAa\u0005/\u0001\u0004\tI)A\u0003u_BL7\r\u0003\u0004\u0003\u00189\u0002\r!T\u0001\u0006gR\f'\u000f\u001e\u0005\u0007\u00057q\u0003\u0019A'\u0002\u0007\u0015tG\rC\u0004\u0003 9\u0002\r!!6\u0002\u001f]LG\u000e\u001c\"f\u0007>lW.\u001b;uK\u0012\f1b]3sm\u0016\u0014\bK]8qgR\u0011!Q\u0005\t\u0005\u0005O\u0011i#\u0004\u0002\u0003*)\u0019!1\u00061\u0002\tU$\u0018\u000e\\\u0005\u0005\u0005_\u0011IC\u0001\u0006Qe>\u0004XM\u001d;jKN\f1d\u0019:fCR,'+Z1e\u0007>lW.\u001b;uK\u0012\u001cuN\\:v[\u0016\u0014H\u0003CA\u000b\u0005k\u0011ID!\u0010\t\u0013\t]\u0002\u0007%AA\u0002\u0005%\u0015!B4s_V\u0004\b\u0002\u0003B\u001eaA\u0005\t\u0019A'\u0002\u001d5\f\u0007\u0010U8mYJ+7m\u001c:eg\"I!q\b\u0019\u0011\u0002\u0003\u0007!QE\u0001\u0006aJ|\u0007o]\u0001&GJ,\u0017\r^3SK\u0006$7i\\7nSR$X\rZ\"p]N,X.\u001a:%I\u00164\u0017-\u001e7uIE*\"A!\u0012+\t\u0005%%qI\u0016\u0003\u0005\u0013\u0002BAa\u0013\u0003V5\u0011!Q\n\u0006\u0005\u0005\u001f\u0012\t&A\u0005v]\u000eDWmY6fI*\u0019!1K(\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0003X\t5#!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006)3M]3bi\u0016\u0014V-\u00193D_6l\u0017\u000e\u001e;fI\u000e{gn];nKJ$C-\u001a4bk2$HEM\u000b\u0003\u0005;R3!\u0014B$\u0003\u0015\u001a'/Z1uKJ+\u0017\rZ\"p[6LG\u000f^3e\u0007>t7/^7fe\u0012\"WMZ1vYR$3'\u0006\u0002\u0003d)\"!Q\u0005B$\u0003u\u0019'/Z1uKJ+\u0017\rZ+oG>lW.\u001b;uK\u0012\u001cuN\\:v[\u0016\u0014H\u0003BA\u000b\u0005SBqAa\u000e5\u0001\u0004\tI)A\u000ede\u0016\fG/\u001a+sC:\u001c\u0018m\u0019;j_:\fG\u000e\u0015:pIV\u001cWM\u001d\u000b\fg\n=$1\u000fB?\u0005\u0003\u0013)\tC\u0004\u0003rU\u0002\r!!#\u0002\u001fQ\u0014\u0018M\\:bGRLwN\\1m\u0013\u0012D\u0011B!\u001e6!\u0003\u0005\rAa\u001e\u0002)Q\u0014\u0018M\\:bGRLwN\u001c+j[\u0016|W\u000f^'t!\rq%\u0011P\u0005\u0004\u0005wz%\u0001\u0002'p]\u001eD\u0011Ba 6!\u0003\u0005\rAa\u001e\u0002\u00155\f\u0007P\u00117pG.l5\u000f\u0003\u0005\u0003\u0004V\u0002\n\u00111\u0001N\u0003E!W\r\\5wKJLH+[7f_V$Xj\u001d\u0005\t\u0005\u000f+\u0004\u0013!a\u0001\u001b\u0006\u0001\"/Z9vKN$H+[7f_V$Xj]\u0001&GJ,\u0017\r^3Ue\u0006t7/Y2uS>t\u0017\r\u001c)s_\u0012,8-\u001a:%I\u00164\u0017-\u001e7uII*\"A!$+\t\t]$qI\u0001&GJ,\u0017\r^3Ue\u0006t7/Y2uS>t\u0017\r\u001c)s_\u0012,8-\u001a:%I\u00164\u0017-\u001e7uIM\nQe\u0019:fCR,GK]1og\u0006\u001cG/[8oC2\u0004&o\u001c3vG\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001b\u0002K\r\u0014X-\u0019;f)J\fgn]1di&|g.\u00197Qe>$WoY3sI\u0011,g-Y;mi\u0012*\u0004")
public class TransactionsTest
extends KafkaServerTestHarness {
    private final int numServers;
    private final int transactionalProducerCount;
    private final int transactionalConsumerCount;
    private final int nonTransactionalConsumerCount;
    private final String topic1;
    private final String topic2;
    private final int numPartitions;
    private final Buffer<KafkaProducer<byte[], byte[]>> transactionalProducers = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
    private final Buffer<KafkaConsumer<byte[], byte[]>> transactionalConsumers = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
    private final Buffer<KafkaConsumer<byte[], byte[]>> nonTransactionalConsumers = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);

    public int numServers() {
        return this.numServers;
    }

    public int transactionalProducerCount() {
        return this.transactionalProducerCount;
    }

    public int transactionalConsumerCount() {
        return this.transactionalConsumerCount;
    }

    public int nonTransactionalConsumerCount() {
        return this.nonTransactionalConsumerCount;
    }

    public String topic1() {
        return this.topic1;
    }

    public String topic2() {
        return this.topic2;
    }

    public int numPartitions() {
        return this.numPartitions;
    }

    public Buffer<KafkaProducer<byte[], byte[]>> transactionalProducers() {
        return this.transactionalProducers;
    }

    public Buffer<KafkaConsumer<byte[], byte[]>> transactionalConsumers() {
        return this.transactionalConsumers;
    }

    public Buffer<KafkaConsumer<byte[], byte[]>> nonTransactionalConsumers() {
        return this.nonTransactionalConsumers;
    }

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        return (Seq)TestUtils$.MODULE$.createBrokerConfigs(this.numServers(), this.zkConnect(), TestUtils$.MODULE$.createBrokerConfigs$default$3(), TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13(), TestUtils$.MODULE$.createBrokerConfigs$default$14(), TestUtils$.MODULE$.createBrokerConfigs$default$15(), TestUtils$.MODULE$.createBrokerConfigs$default$16()).map((Function1 & Serializable & scala.Serializable)x$1 -> KafkaConfig$.MODULE$.fromProps(x$1, this.serverProps()), Seq$.MODULE$.canBuildFrom());
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        Properties topicConfig = new Properties();
        topicConfig.put(KafkaConfig$.MODULE$.MinInSyncReplicasProp(), ((Object)BoxesRunTime.boxToInteger((int)2)).toString());
        this.createTopic(this.topic1(), this.numPartitions(), this.numServers(), topicConfig);
        this.createTopic(this.topic2(), this.numPartitions(), this.numServers(), topicConfig);
        int n = 0;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        Range range = RichInt$.MODULE$.until$extension0(n, this.transactionalProducerCount());
        if (range == null) {
            throw null;
        }
        Range foreach_this = range;
        if (!foreach_this.isEmpty()) {
            int foreach_i = foreach_this.start();
            while (true) {
                this.createTransactionalProducer("transactional-producer", this.createTransactionalProducer$default$2(), this.createTransactionalProducer$default$3(), this.createTransactionalProducer$default$4(), this.createTransactionalProducer$default$5());
                if (foreach_i == foreach_this.scala$collection$immutable$Range$$lastElement()) break;
                foreach_i += foreach_this.step();
            }
        }
        int n2 = 0;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        Range range2 = RichInt$.MODULE$.until$extension0(n2, this.transactionalConsumerCount());
        if (range2 == null) {
            throw null;
        }
        Range foreach_this2 = range2;
        if (!foreach_this2.isEmpty()) {
            int foreach_i = foreach_this2.start();
            while (true) {
                this.createReadCommittedConsumer("transactional-group", this.createReadCommittedConsumer$default$2(), this.createReadCommittedConsumer$default$3());
                if (foreach_i == foreach_this2.scala$collection$immutable$Range$$lastElement()) break;
                foreach_i += foreach_this2.step();
            }
        }
        int n3 = 0;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        Range range3 = RichInt$.MODULE$.until$extension0(n3, this.nonTransactionalConsumerCount());
        if (range3 == null) {
            throw null;
        }
        Range foreach_this3 = range3;
        if (!foreach_this3.isEmpty()) {
            int foreach_i = foreach_this3.start();
            while (true) {
                this.createReadUncommittedConsumer("non-transactional-group");
                if (foreach_i == foreach_this3.scala$collection$immutable$Range$$lastElement()) break;
                foreach_i += foreach_this3.step();
            }
        }
    }

    @Override
    @After
    public void tearDown() {
        this.transactionalProducers().foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
            x$2.close();
            return BoxedUnit.UNIT;
        });
        this.transactionalConsumers().foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
            x$3.close();
            return BoxedUnit.UNIT;
        });
        this.nonTransactionalConsumers().foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
            x$4.close();
            return BoxedUnit.UNIT;
        });
        super.tearDown();
    }

    @Test
    public void testBasicTransactions() {
        KafkaProducer producer = (KafkaProducer)this.transactionalProducers().head();
        KafkaConsumer consumer = (KafkaConsumer)this.transactionalConsumers().head();
        KafkaConsumer unCommittedConsumer = (KafkaConsumer)this.nonTransactionalConsumers().head();
        producer.initTransactions();
        producer.beginTransaction();
        producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic2(), null, "2", "2", false));
        producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), null, "4", "4", false));
        producer.flush();
        producer.abortTransaction();
        producer.beginTransaction();
        producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), null, "1", "1", true));
        producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic2(), null, "3", "3", true));
        producer.commitTransaction();
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.topic1(), (List)new .colon.colon((Object)this.topic2(), (List)Nil$.MODULE$))).asJava());
        unCommittedConsumer.subscribe((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.topic1(), (List)new .colon.colon((Object)this.topic2(), (List)Nil$.MODULE$))).asJava());
        TestUtils$.MODULE$.consumeRecords(consumer, 2, TestUtils$.MODULE$.consumeRecords$default$3()).foreach((Function1 & Serializable & scala.Serializable)record -> TestUtils$.MODULE$.assertCommittedAndGetValue((ConsumerRecord<byte[], byte[]>)record));
        Seq allRecords = TestUtils$.MODULE$.consumeRecords(unCommittedConsumer, 4, TestUtils$.MODULE$.consumeRecords$default$3());
        scala.collection.immutable.Set expectedValues = new .colon.colon((Object)"1", (List)new .colon.colon((Object)"2", (List)new .colon.colon((Object)"3", (List)new .colon.colon((Object)"4", (List)Nil$.MODULE$)))).toSet();
        allRecords.foreach((Function1 & Serializable & scala.Serializable)record -> {
            TransactionsTest.$anonfun$testBasicTransactions$2(expectedValues, record);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testReadCommittedConsumerShouldNotSeeUndecidedData() {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        void $minus$greater$extension_y2;
        void $minus$greater$extension_$this2;
        void $minus$greater$extension_y3;
        void $minus$greater$extension_$this3;
        void $minus$greater$extension_y4;
        void $minus$greater$extension_$this4;
        KafkaProducer producer1 = (KafkaProducer)this.transactionalProducers().head();
        KafkaProducer<byte[], byte[]> producer2 = this.createTransactionalProducer("other", this.createTransactionalProducer$default$2(), this.createTransactionalProducer$default$3(), this.createTransactionalProducer$default$4(), this.createTransactionalProducer$default$5());
        KafkaConsumer readCommittedConsumer = (KafkaConsumer)this.transactionalConsumers().head();
        KafkaConsumer readUncommittedConsumer = (KafkaConsumer)this.nonTransactionalConsumers().head();
        producer1.initTransactions();
        producer2.initTransactions();
        producer1.beginTransaction();
        producer2.beginTransaction();
        long latestVisibleTimestamp = System.currentTimeMillis();
        producer2.send(new ProducerRecord(this.topic1(), Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.long2Long(latestVisibleTimestamp), (Object)"x".getBytes(), (Object)"1".getBytes()));
        producer2.send(new ProducerRecord(this.topic2(), Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.long2Long(latestVisibleTimestamp), (Object)"x".getBytes(), (Object)"1".getBytes()));
        producer2.flush();
        long latestWrittenTimestamp = latestVisibleTimestamp + 1L;
        producer1.send(new ProducerRecord(this.topic1(), Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.long2Long(latestWrittenTimestamp), (Object)"a".getBytes(), (Object)"1".getBytes()));
        producer1.send(new ProducerRecord(this.topic1(), Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.long2Long(latestWrittenTimestamp), (Object)"b".getBytes(), (Object)"2".getBytes()));
        producer1.send(new ProducerRecord(this.topic2(), Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.long2Long(latestWrittenTimestamp), (Object)"c".getBytes(), (Object)"3".getBytes()));
        producer1.send(new ProducerRecord(this.topic2(), Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.long2Long(latestWrittenTimestamp), (Object)"d".getBytes(), (Object)"4".getBytes()));
        producer1.flush();
        producer2.send(new ProducerRecord(this.topic1(), Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.long2Long(latestWrittenTimestamp), (Object)"x".getBytes(), (Object)"2".getBytes()));
        producer2.send(new ProducerRecord(this.topic2(), Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.long2Long(latestWrittenTimestamp), (Object)"x".getBytes(), (Object)"2".getBytes()));
        producer2.commitTransaction();
        TopicPartition tp1 = new TopicPartition(this.topic1(), 0);
        TopicPartition tp2 = new TopicPartition(this.topic2(), 0);
        readUncommittedConsumer.assign((Collection)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp1, tp2}))).asJava());
        TestUtils$.MODULE$.consumeRecords(readUncommittedConsumer, 8, TestUtils$.MODULE$.consumeRecords$default$3());
        Tuple2[] tuple2Array = new Tuple2[2];
        Long l = Predef$.MODULE$.long2Long(latestWrittenTimestamp);
        Object object = Predef$.MODULE$.ArrowAssoc((Object)tp1);
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this4, (Object)$minus$greater$extension_y4);
        Long l2 = Predef$.MODULE$.long2Long(latestWrittenTimestamp);
        Object object2 = Predef$.MODULE$.ArrowAssoc((Object)tp2);
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[1] = new Tuple2((Object)$minus$greater$extension_$this3, (Object)$minus$greater$extension_y3);
        java.util.Map readUncommittedOffsetsForTimes = readUncommittedConsumer.offsetsForTimes((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array))).asJava());
        Assert.assertEquals((long)2L, (long)readUncommittedOffsetsForTimes.size());
        Assert.assertEquals((long)latestWrittenTimestamp, (long)((OffsetAndTimestamp)readUncommittedOffsetsForTimes.get(tp1)).timestamp());
        Assert.assertEquals((long)latestWrittenTimestamp, (long)((OffsetAndTimestamp)readUncommittedOffsetsForTimes.get(tp2)).timestamp());
        readUncommittedConsumer.unsubscribe();
        readCommittedConsumer.assign((Collection)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp1, tp2}))).asJava());
        TestUtils$.MODULE$.consumeRecords(readCommittedConsumer, 2, TestUtils$.MODULE$.consumeRecords$default$3()).foreach((Function1 & Serializable & scala.Serializable)record -> {
            TransactionsTest.$anonfun$testReadCommittedConsumerShouldNotSeeUndecidedData$1(record);
            return BoxedUnit.UNIT;
        });
        Assert.assertEquals((long)2L, (long)readCommittedConsumer.assignment().size());
        readCommittedConsumer.seekToEnd((Collection)readCommittedConsumer.assignment());
        readCommittedConsumer.assignment().forEach(tp -> Assert.assertEquals((long)1L, (long)readCommittedConsumer.position(tp)));
        Tuple2[] tuple2Array2 = new Tuple2[2];
        Long l3 = Predef$.MODULE$.long2Long(latestWrittenTimestamp);
        Object object3 = Predef$.MODULE$.ArrowAssoc((Object)tp1);
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array2[0] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y2);
        Long l4 = Predef$.MODULE$.long2Long(latestWrittenTimestamp);
        Object object4 = Predef$.MODULE$.ArrowAssoc((Object)tp2);
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array2[1] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        java.util.Map readCommittedOffsetsForTimes = readCommittedConsumer.offsetsForTimes((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array2))).asJava());
        Assert.assertNull(readCommittedOffsetsForTimes.get(tp1));
        Assert.assertNull(readCommittedOffsetsForTimes.get(tp2));
    }

    @Test
    public void testDelayedFetchIncludesAbortedTransaction() {
        KafkaProducer producer1 = (KafkaProducer)this.transactionalProducers().head();
        KafkaProducer<byte[], byte[]> producer2 = this.createTransactionalProducer("other", this.createTransactionalProducer$default$2(), this.createTransactionalProducer$default$3(), this.createTransactionalProducer$default$4(), this.createTransactionalProducer$default$5());
        producer1.initTransactions();
        producer2.initTransactions();
        producer1.beginTransaction();
        producer2.beginTransaction();
        producer2.send(new ProducerRecord(this.topic1(), Predef$.MODULE$.int2Integer(0), (Object)"x".getBytes(), (Object)"1".getBytes()));
        producer2.flush();
        producer1.send(new ProducerRecord(this.topic1(), Predef$.MODULE$.int2Integer(0), (Object)"y".getBytes(), (Object)"1".getBytes()));
        producer1.send(new ProducerRecord(this.topic1(), Predef$.MODULE$.int2Integer(0), (Object)"y".getBytes(), (Object)"2".getBytes()));
        producer1.flush();
        producer2.send(new ProducerRecord(this.topic1(), Predef$.MODULE$.int2Integer(0), (Object)"x".getBytes(), (Object)"2".getBytes()));
        producer2.flush();
        producer1.abortTransaction();
        producer2.commitTransaction();
        Properties consumerProps = new Properties();
        consumerProps.put("fetch.min.bytes", "100000");
        consumerProps.put("fetch.max.wait.ms", "100");
        String x$2 = this.createReadCommittedConsumer$default$1();
        int x$3 = this.createReadCommittedConsumer$default$2();
        KafkaConsumer<byte[], byte[]> readCommittedConsumer = this.createReadCommittedConsumer(x$2, x$3, consumerProps);
        readCommittedConsumer.assign((Collection)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(this.topic1(), 0)}))).asJava());
        Seq<ConsumerRecord<byte[], byte[]>> records = TestUtils$.MODULE$.consumeRecords(readCommittedConsumer, 2, TestUtils$.MODULE$.consumeRecords$default$3());
        Assert.assertEquals((long)2L, (long)records.size());
        ConsumerRecord first = (ConsumerRecord)records.head();
        Assert.assertEquals((Object)"x", (Object)new String((byte[])first.key()));
        Assert.assertEquals((Object)"1", (Object)new String((byte[])first.value()));
        Assert.assertEquals((long)0L, (long)first.offset());
        ConsumerRecord second = (ConsumerRecord)records.last();
        Assert.assertEquals((Object)"x", (Object)new String((byte[])second.key()));
        Assert.assertEquals((Object)"2", (Object)new String((byte[])second.value()));
        Assert.assertEquals((long)3L, (long)second.offset());
    }

    @Test
    public void testSendOffsetsWithGroupId() {
        String sendOffset_consumerGroupId = "foobar-consumer-group";
        int sendOffset_numSeedMessages = 500;
        TestUtils$.MODULE$.seedTopicWithNumberedRecords(this.topic1(), sendOffset_numSeedMessages, (Seq<KafkaServer>)this.servers());
        KafkaProducer sendOffset_producer = (KafkaProducer)this.transactionalProducers().head();
        KafkaConsumer<byte[], byte[]> sendOffset_consumer = this.createReadCommittedConsumer(sendOffset_consumerGroupId, sendOffset_numSeedMessages / 4, this.createReadCommittedConsumer$default$3());
        sendOffset_consumer.subscribe((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.topic1(), (List)Nil$.MODULE$)).asJava());
        sendOffset_producer.initTransactions();
        BooleanRef sendOffset_shouldCommit = BooleanRef.create((boolean)false);
        IntRef sendOffset_recordsProcessed = IntRef.create((int)0);
        try {
            while (sendOffset_recordsProcessed.elem < sendOffset_numSeedMessages) {
                Seq<ConsumerRecord<byte[], byte[]>> sendOffset_records = TestUtils$.MODULE$.pollUntilAtLeastNumRecords(sendOffset_consumer, Math.min(10, sendOffset_numSeedMessages - sendOffset_recordsProcessed.elem), TestUtils$.MODULE$.pollUntilAtLeastNumRecords$default$3());
                sendOffset_producer.beginTransaction();
                sendOffset_shouldCommit.elem = !sendOffset_shouldCommit.elem;
                sendOffset_records.foreach((Function1 & Serializable & scala.Serializable)record -> {
                    String key = new String((byte[])record.key(), StandardCharsets.UTF_8);
                    String value = new String((byte[])record.value(), StandardCharsets.UTF_8);
                    return sendOffset_producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic2(), null, key, value, shouldCommit$1.elem));
                });
                sendOffset_producer.sendOffsetsToTransaction((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter(TestUtils$.MODULE$.consumerPositions((KafkaConsumer<byte[], byte[]>)sendOffset_consumer)).asJava(), sendOffset_consumerGroupId);
                if (sendOffset_shouldCommit.elem) {
                    sendOffset_producer.commitTransaction();
                    sendOffset_recordsProcessed.elem += sendOffset_records.size();
                    this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(74).append("committed transaction.. Last committed record: ").append(new String((byte[])((ConsumerRecord)sendOffset_records.last()).value(), StandardCharsets.UTF_8)).append(". Num ").append("records written to ").append(this.topic2()).append(": ").append(recordsProcessed$1.elem).toString());
                    continue;
                }
                sendOffset_producer.abortTransaction();
                this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(70).append("aborted transaction Last committed record: ").append(new String((byte[])((ConsumerRecord)sendOffset_records.last()).value(), StandardCharsets.UTF_8)).append(". Num ").append("records written to ").append(this.topic2()).append(": ").append(recordsProcessed$1.elem).toString());
                TestUtils$.MODULE$.resetToCommittedPositions(sendOffset_consumer);
            }
        }
        finally {
            sendOffset_consumer.close();
        }
        KafkaConsumer sendOffset_verifyingConsumer = (KafkaConsumer)this.transactionalConsumers().apply(0);
        sendOffset_verifyingConsumer.subscribe((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.topic2(), (List)Nil$.MODULE$)).asJava());
        Seq sendOffset_valueSeq = (Seq)TestUtils$.MODULE$.pollUntilAtLeastNumRecords(sendOffset_verifyingConsumer, sendOffset_numSeedMessages, TestUtils$.MODULE$.pollUntilAtLeastNumRecords$default$3()).map((Function1 & Serializable & scala.Serializable)record -> BoxesRunTime.boxToInteger((int)TransactionsTest.$anonfun$sendOffset$4(record)), Seq$.MODULE$.canBuildFrom());
        scala.collection.immutable.Set sendOffset_valueSet = sendOffset_valueSeq.toSet();
        Assert.assertEquals((String)new StringBuilder(21).append("Expected ").append(sendOffset_numSeedMessages).append(" values in ").append(this.topic2()).append(".").toString(), (long)sendOffset_numSeedMessages, (long)sendOffset_valueSeq.size());
        Assert.assertEquals((String)new StringBuilder(30).append("Expected ").append(sendOffset_valueSeq.size()).append(" unique messages in ").append(this.topic2()).append(".").toString(), (long)sendOffset_valueSeq.size(), (long)sendOffset_valueSet.size());
    }

    @Test
    public void testSendOffsetsWithGroupMetadata() {
        String sendOffset_consumerGroupId = "foobar-consumer-group";
        int sendOffset_numSeedMessages = 500;
        TestUtils$.MODULE$.seedTopicWithNumberedRecords(this.topic1(), sendOffset_numSeedMessages, (Seq<KafkaServer>)this.servers());
        KafkaProducer sendOffset_producer = (KafkaProducer)this.transactionalProducers().head();
        KafkaConsumer<byte[], byte[]> sendOffset_consumer = this.createReadCommittedConsumer(sendOffset_consumerGroupId, sendOffset_numSeedMessages / 4, this.createReadCommittedConsumer$default$3());
        sendOffset_consumer.subscribe((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.topic1(), (List)Nil$.MODULE$)).asJava());
        sendOffset_producer.initTransactions();
        BooleanRef sendOffset_shouldCommit = BooleanRef.create((boolean)false);
        IntRef sendOffset_recordsProcessed = IntRef.create((int)0);
        try {
            while (sendOffset_recordsProcessed.elem < sendOffset_numSeedMessages) {
                Seq<ConsumerRecord<byte[], byte[]>> sendOffset_records = TestUtils$.MODULE$.pollUntilAtLeastNumRecords(sendOffset_consumer, Math.min(10, sendOffset_numSeedMessages - sendOffset_recordsProcessed.elem), TestUtils$.MODULE$.pollUntilAtLeastNumRecords$default$3());
                sendOffset_producer.beginTransaction();
                sendOffset_shouldCommit.elem = !sendOffset_shouldCommit.elem;
                sendOffset_records.foreach((Function1 & Serializable & scala.Serializable)record -> {
                    String key = new String((byte[])record.key(), StandardCharsets.UTF_8);
                    String value = new String((byte[])record.value(), StandardCharsets.UTF_8);
                    return sendOffset_producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic2(), null, key, value, shouldCommit$1.elem));
                });
                sendOffset_producer.sendOffsetsToTransaction((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter(TestUtils$.MODULE$.consumerPositions((KafkaConsumer<byte[], byte[]>)sendOffset_consumer)).asJava(), sendOffset_consumer.groupMetadata());
                if (sendOffset_shouldCommit.elem) {
                    sendOffset_producer.commitTransaction();
                    sendOffset_recordsProcessed.elem += sendOffset_records.size();
                    this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(74).append("committed transaction.. Last committed record: ").append(new String((byte[])((ConsumerRecord)sendOffset_records.last()).value(), StandardCharsets.UTF_8)).append(". Num ").append("records written to ").append(this.topic2()).append(": ").append(recordsProcessed$1.elem).toString());
                    continue;
                }
                sendOffset_producer.abortTransaction();
                this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(70).append("aborted transaction Last committed record: ").append(new String((byte[])((ConsumerRecord)sendOffset_records.last()).value(), StandardCharsets.UTF_8)).append(". Num ").append("records written to ").append(this.topic2()).append(": ").append(recordsProcessed$1.elem).toString());
                TestUtils$.MODULE$.resetToCommittedPositions(sendOffset_consumer);
            }
        }
        finally {
            sendOffset_consumer.close();
        }
        KafkaConsumer sendOffset_verifyingConsumer = (KafkaConsumer)this.transactionalConsumers().apply(0);
        sendOffset_verifyingConsumer.subscribe((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.topic2(), (List)Nil$.MODULE$)).asJava());
        Seq sendOffset_valueSeq = (Seq)TestUtils$.MODULE$.pollUntilAtLeastNumRecords(sendOffset_verifyingConsumer, sendOffset_numSeedMessages, TestUtils$.MODULE$.pollUntilAtLeastNumRecords$default$3()).map((Function1 & Serializable & scala.Serializable)record -> BoxesRunTime.boxToInteger((int)TransactionsTest.$anonfun$sendOffset$4(record)), Seq$.MODULE$.canBuildFrom());
        scala.collection.immutable.Set sendOffset_valueSet = sendOffset_valueSeq.toSet();
        Assert.assertEquals((String)new StringBuilder(21).append("Expected ").append(sendOffset_numSeedMessages).append(" values in ").append(this.topic2()).append(".").toString(), (long)sendOffset_numSeedMessages, (long)sendOffset_valueSeq.size());
        Assert.assertEquals((String)new StringBuilder(30).append("Expected ").append(sendOffset_valueSeq.size()).append(" unique messages in ").append(this.topic2()).append(".").toString(), (long)sendOffset_valueSeq.size(), (long)sendOffset_valueSet.size());
    }

    private void sendOffset(Function3<KafkaProducer<byte[], byte[]>, String, KafkaConsumer<byte[], byte[]>, BoxedUnit> commit) {
        String consumerGroupId = "foobar-consumer-group";
        int numSeedMessages = 500;
        TestUtils$.MODULE$.seedTopicWithNumberedRecords(this.topic1(), numSeedMessages, (Seq<KafkaServer>)this.servers());
        KafkaProducer producer = (KafkaProducer)this.transactionalProducers().head();
        KafkaConsumer<byte[], byte[]> consumer = this.createReadCommittedConsumer(consumerGroupId, numSeedMessages / 4, this.createReadCommittedConsumer$default$3());
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.topic1(), (List)Nil$.MODULE$)).asJava());
        producer.initTransactions();
        BooleanRef shouldCommit = BooleanRef.create((boolean)false);
        IntRef recordsProcessed = IntRef.create((int)0);
        try {
            while (recordsProcessed.elem < numSeedMessages) {
                Seq<ConsumerRecord<byte[], byte[]>> records = TestUtils$.MODULE$.pollUntilAtLeastNumRecords(consumer, Math.min(10, numSeedMessages - recordsProcessed.elem), TestUtils$.MODULE$.pollUntilAtLeastNumRecords$default$3());
                producer.beginTransaction();
                shouldCommit.elem = !shouldCommit.elem;
                records.foreach((Function1 & Serializable & scala.Serializable)record -> {
                    String key = new String((byte[])record.key(), StandardCharsets.UTF_8);
                    String value = new String((byte[])record.value(), StandardCharsets.UTF_8);
                    return sendOffset_producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic2(), null, key, value, shouldCommit$1.elem));
                });
                commit.apply((Object)producer, (Object)consumerGroupId, consumer);
                if (shouldCommit.elem) {
                    producer.commitTransaction();
                    recordsProcessed.elem += records.size();
                    this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(74).append("committed transaction.. Last committed record: ").append(new String((byte[])((ConsumerRecord)sendOffset_records.last()).value(), StandardCharsets.UTF_8)).append(". Num ").append("records written to ").append(this.topic2()).append(": ").append(recordsProcessed$1.elem).toString());
                    continue;
                }
                producer.abortTransaction();
                this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(70).append("aborted transaction Last committed record: ").append(new String((byte[])((ConsumerRecord)sendOffset_records.last()).value(), StandardCharsets.UTF_8)).append(". Num ").append("records written to ").append(this.topic2()).append(": ").append(recordsProcessed$1.elem).toString());
                TestUtils$.MODULE$.resetToCommittedPositions(consumer);
            }
        }
        finally {
            consumer.close();
        }
        KafkaConsumer verifyingConsumer = (KafkaConsumer)this.transactionalConsumers().apply(0);
        verifyingConsumer.subscribe((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.topic2(), (List)Nil$.MODULE$)).asJava());
        Seq valueSeq = (Seq)TestUtils$.MODULE$.pollUntilAtLeastNumRecords(verifyingConsumer, numSeedMessages, TestUtils$.MODULE$.pollUntilAtLeastNumRecords$default$3()).map((Function1 & Serializable & scala.Serializable)record -> BoxesRunTime.boxToInteger((int)TransactionsTest.$anonfun$sendOffset$4(record)), Seq$.MODULE$.canBuildFrom());
        scala.collection.immutable.Set valueSet = valueSeq.toSet();
        Assert.assertEquals((String)new StringBuilder(21).append("Expected ").append(numSeedMessages).append(" values in ").append(this.topic2()).append(".").toString(), (long)numSeedMessages, (long)valueSeq.size());
        Assert.assertEquals((String)new StringBuilder(30).append("Expected ").append(valueSeq.size()).append(" unique messages in ").append(this.topic2()).append(".").toString(), (long)valueSeq.size(), (long)valueSet.size());
    }

    @Test
    public void testFencingOnCommit() {
        KafkaProducer producer1 = (KafkaProducer)this.transactionalProducers().apply(0);
        KafkaProducer producer2 = (KafkaProducer)this.transactionalProducers().apply(1);
        KafkaConsumer consumer = (KafkaConsumer)this.transactionalConsumers().apply(0);
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.topic1(), (List)new .colon.colon((Object)this.topic2(), (List)Nil$.MODULE$))).asJava());
        producer1.initTransactions();
        producer1.beginTransaction();
        producer1.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), null, "1", "1", false));
        producer1.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic2(), null, "3", "3", false));
        producer2.initTransactions();
        producer2.beginTransaction();
        producer2.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), null, "2", "4", true));
        producer2.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic2(), null, "2", "4", true));
        try {
            producer1.commitTransaction();
            throw Assertions$.MODULE$.fail("Should not be able to commit transactions from a fenced producer.", new Position("TransactionsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 330));
        }
        catch (ProducerFencedException producerFencedException) {
        }
        catch (Exception e) {
            throw Assertions$.MODULE$.fail("Got an unexpected exception from a fenced producer.", (Throwable)e, new Position("TransactionsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 335));
        }
        producer2.commitTransaction();
        TestUtils$.MODULE$.consumeRecords(consumer, 2, TestUtils$.MODULE$.consumeRecords$default$3()).foreach((Function1 & Serializable & scala.Serializable)record -> TestUtils$.MODULE$.assertCommittedAndGetValue((ConsumerRecord<byte[], byte[]>)record));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testFencingOnSendOffsets() {
        KafkaProducer producer1 = (KafkaProducer)this.transactionalProducers().apply(0);
        KafkaProducer producer2 = (KafkaProducer)this.transactionalProducers().apply(1);
        KafkaConsumer consumer = (KafkaConsumer)this.transactionalConsumers().apply(0);
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.topic1(), (List)new .colon.colon((Object)this.topic2(), (List)Nil$.MODULE$))).asJava());
        producer1.initTransactions();
        producer1.beginTransaction();
        producer1.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), null, "1", "1", false));
        producer1.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic2(), null, "3", "3", false));
        producer2.initTransactions();
        producer2.beginTransaction();
        producer2.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), null, "2", "4", true));
        producer2.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic2(), null, "2", "4", true));
        try {
            void $minus$greater$extension_y;
            void $minus$greater$extension_$this;
            Tuple2[] tuple2Array = new Tuple2[1];
            OffsetAndMetadata offsetAndMetadata = new OffsetAndMetadata(110L);
            Object object = Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foobartopic", 0));
            if (Predef.ArrowAssoc$.MODULE$ == null) {
                throw null;
            }
            tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
            producer1.sendOffsetsToTransaction((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array))).asJava(), "foobarGroup");
            throw Assertions$.MODULE$.fail("Should not be able to send offsets from a fenced producer.", new Position("TransactionsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 368));
        }
        catch (ProducerFencedException producerFencedException) {
        }
        catch (Exception e) {
            throw Assertions$.MODULE$.fail("Got an unexpected exception from a fenced producer.", (Throwable)e, new Position("TransactionsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 373));
        }
        producer2.commitTransaction();
        TestUtils$.MODULE$.consumeRecords(consumer, 2, TestUtils$.MODULE$.consumeRecords$default$3()).foreach((Function1 & Serializable & scala.Serializable)record -> TestUtils$.MODULE$.assertCommittedAndGetValue((ConsumerRecord<byte[], byte[]>)record));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testOffsetMetadataInSendOffsetsToTransaction() {
        void $minus$greater$extension_$this;
        TopicPartition tp = new TopicPartition(this.topic1(), 0);
        String groupId = "group";
        KafkaProducer producer = (KafkaProducer)this.transactionalProducers().head();
        KafkaConsumer<byte[], byte[]> consumer = this.createReadCommittedConsumer(groupId, this.createReadCommittedConsumer$default$2(), this.createReadCommittedConsumer$default$3());
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.topic1(), (List)Nil$.MODULE$)).asJava());
        producer.initTransactions();
        producer.beginTransaction();
        OffsetAndMetadata offsetAndMetadata = new OffsetAndMetadata(110L, Optional.of(Predef$.MODULE$.int2Integer(15)), "some metadata");
        Tuple2[] tuple2Array = new Tuple2[1];
        Object object = Predef$.MODULE$.ArrowAssoc((Object)tp);
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)offsetAndMetadata);
        producer.sendOffsetsToTransaction((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array))).asJava(), groupId);
        producer.commitTransaction();
        ((KafkaProducer)this.transactionalProducers().apply(1)).initTransactions();
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!offsetAndMetadata.equals(consumer.committed((java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp}))).asJava()).get(tp))) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                throw Assertions$.MODULE$.fail(TransactionsTest.$anonfun$testOffsetMetadataInSendOffsetsToTransaction$2(), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 847));
            }
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension((long)waitUntilTrue_waitTimeMs, (long)waitUntilTrue_pause));
        }
    }

    @Test(expected=TimeoutException.class)
    public void testInitTransactionsTimeout() {
        this.testTimeout(false, (Function1<KafkaProducer<byte[], byte[]>, BoxedUnit>)(Function1 & Serializable & scala.Serializable)producer -> {
            producer.initTransactions();
            return BoxedUnit.UNIT;
        });
    }

    @Test(expected=TimeoutException.class)
    public void testSendOffsetsToTransactionTimeout() {
        this.testTimeout(true, (Function1<KafkaProducer<byte[], byte[]>, BoxedUnit>)(Function1 & Serializable & scala.Serializable)producer -> {
            TransactionsTest.$anonfun$testSendOffsetsToTransactionTimeout$1(this, producer);
            return BoxedUnit.UNIT;
        });
    }

    @Test(expected=TimeoutException.class)
    public void testCommitTransactionTimeout() {
        this.testTimeout(true, (Function1<KafkaProducer<byte[], byte[]>, BoxedUnit>)(Function1 & Serializable & scala.Serializable)producer -> {
            producer.commitTransaction();
            return BoxedUnit.UNIT;
        });
    }

    @Test(expected=TimeoutException.class)
    public void testAbortTransactionTimeout() {
        this.testTimeout(true, (Function1<KafkaProducer<byte[], byte[]>, BoxedUnit>)(Function1 & Serializable & scala.Serializable)producer -> {
            producer.abortTransaction();
            return BoxedUnit.UNIT;
        });
    }

    public void testTimeout(boolean needInitAndSendMsg, Function1<KafkaProducer<byte[], byte[]>, BoxedUnit> timeoutProcess) {
        String x$1 = "transactionProducer";
        long x$2 = 1000L;
        long x$3 = this.createTransactionalProducer$default$2();
        int x$4 = this.createTransactionalProducer$default$4();
        int x$5 = this.createTransactionalProducer$default$5();
        KafkaProducer<byte[], byte[]> producer = this.createTransactionalProducer(x$1, x$3, x$2, x$4, x$5);
        if (needInitAndSendMsg) {
            producer.initTransactions();
            producer.beginTransaction();
            producer.send(new ProducerRecord(this.topic1(), (Object)"foo".getBytes(), (Object)"bar".getBytes()));
        }
        Range range = this.servers().indices();
        if (range == null) {
            throw null;
        }
        Range foreach$mVc$sp_this = range;
        if (!foreach$mVc$sp_this.isEmpty()) {
            int foreach$mVc$sp_i = foreach$mVc$sp_this.start();
            while (true) {
                this.killBroker(foreach$mVc$sp_i);
                if (foreach$mVc$sp_i == foreach$mVc$sp_this.scala$collection$immutable$Range$$lastElement()) break;
                foreach$mVc$sp_i += foreach$mVc$sp_this.step();
            }
        }
        try {
            timeoutProcess.apply(producer);
            throw Assertions$.MODULE$.fail("Should raise a TimeoutException", new Position("TransactionsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 445));
        }
        catch (Throwable throwable) {
            producer.close(Duration.ZERO);
            throw throwable;
        }
    }

    @Test
    public void testFencingOnSend() {
        KafkaProducer producer1 = (KafkaProducer)this.transactionalProducers().apply(0);
        KafkaProducer producer2 = (KafkaProducer)this.transactionalProducers().apply(1);
        KafkaConsumer consumer = (KafkaConsumer)this.transactionalConsumers().apply(0);
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.topic1(), (List)new .colon.colon((Object)this.topic2(), (List)Nil$.MODULE$))).asJava());
        producer1.initTransactions();
        producer1.beginTransaction();
        producer1.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), null, "1", "1", false));
        producer1.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic2(), null, "3", "3", false));
        producer2.initTransactions();
        producer2.beginTransaction();
        producer2.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), null, "2", "4", true)).get();
        producer2.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic2(), null, "2", "4", true)).get();
        try {
            RecordMetadata recordMetadata = (RecordMetadata)producer1.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), null, "1", "5", false)).get();
            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(69).append("Missed a producer fenced exception when writing to ").append(recordMetadata.topic()).append("-").append(recordMetadata.partition()).append(". Grab the logs!!").toString());
            this.servers().foreach((Function1 & Serializable & scala.Serializable)server -> {
                this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(10).append("log dirs: ").append(((IterableLike)server.logManager().liveLogDirs().map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.getAbsolutePath(), Seq$.MODULE$.canBuildFrom())).head()).toString());
                return BoxedUnit.UNIT;
            });
            throw Assertions$.MODULE$.fail("Should not be able to send messages from a fenced producer.", new Position("TransactionsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 477));
        }
        catch (ProducerFencedException producerFencedException) {
            producer1.close();
        }
        catch (ExecutionException executionException) {
            Assert.assertTrue((boolean)(executionException.getCause() instanceof InvalidProducerEpochException));
        }
        catch (Exception e) {
            throw Assertions$.MODULE$.fail("Got an unexpected exception from a fenced producer.", (Throwable)e, new Position("TransactionsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 484));
        }
        producer2.commitTransaction();
        TestUtils$.MODULE$.consumeRecords(consumer, 2, TestUtils$.MODULE$.consumeRecords$default$3()).foreach((Function1 & Serializable & scala.Serializable)record -> TestUtils$.MODULE$.assertCommittedAndGetValue((ConsumerRecord<byte[], byte[]>)record));
    }

    @Test
    public void testFencingOnAddPartitions() {
        KafkaProducer producer1 = (KafkaProducer)this.transactionalProducers().apply(0);
        KafkaProducer producer2 = (KafkaProducer)this.transactionalProducers().apply(1);
        KafkaConsumer consumer = (KafkaConsumer)this.transactionalConsumers().apply(0);
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.topic1(), (List)new .colon.colon((Object)this.topic2(), (List)Nil$.MODULE$))).asJava());
        producer1.initTransactions();
        producer1.beginTransaction();
        producer1.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), null, "1", "1", false));
        producer1.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic2(), null, "3", "3", false));
        producer1.abortTransaction();
        producer2.initTransactions();
        producer2.beginTransaction();
        producer2.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), null, "2", "4", true)).get(20L, TimeUnit.SECONDS);
        producer2.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic2(), null, "2", "4", true)).get(20L, TimeUnit.SECONDS);
        try {
            producer1.beginTransaction();
            RecordMetadata recordMetadata = (RecordMetadata)producer1.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), null, "1", "5", false)).get();
            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(69).append("Missed a producer fenced exception when writing to ").append(recordMetadata.topic()).append("-").append(recordMetadata.partition()).append(". Grab the logs!!").toString());
            this.servers().foreach((Function1 & Serializable & scala.Serializable)server -> {
                this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(10).append("log dirs: ").append(((IterableLike)server.logManager().liveLogDirs().map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.getAbsolutePath(), Seq$.MODULE$.canBuildFrom())).head()).toString());
                return BoxedUnit.UNIT;
            });
            throw Assertions$.MODULE$.fail("Should not be able to send messages from a fenced producer.", new Position("TransactionsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 524));
        }
        catch (ProducerFencedException producerFencedException) {
        }
        catch (ExecutionException executionException) {
            Assert.assertTrue((boolean)(executionException.getCause() instanceof ProducerFencedException));
        }
        catch (Exception e) {
            throw Assertions$.MODULE$.fail("Got an unexpected exception from a fenced producer.", (Throwable)e, new Position("TransactionsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 530));
        }
        producer2.commitTransaction();
        TestUtils$.MODULE$.consumeRecords(consumer, 2, TestUtils$.MODULE$.consumeRecords$default$3()).foreach((Function1 & Serializable & scala.Serializable)record -> TestUtils$.MODULE$.assertCommittedAndGetValue((ConsumerRecord<byte[], byte[]>)record));
    }

    @Test
    public void testFencingOnTransactionExpiration() {
        KafkaProducer<byte[], byte[]> producer = this.createTransactionalProducer("expiringProducer", 100L, this.createTransactionalProducer$default$3(), this.createTransactionalProducer$default$4(), this.createTransactionalProducer$default$5());
        producer.initTransactions();
        producer.beginTransaction();
        Assert.assertTrue((boolean)((RecordMetadata)producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), null, "1", "1", false)).get()).hasOffset());
        Thread.sleep(600L);
        try {
            producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), null, "2", "2", false)).get();
            throw Assertions$.MODULE$.fail("should have raised a ProducerFencedException since the transaction has expired", new Position("TransactionsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 558));
        }
        catch (ProducerFencedException producerFencedException) {
        }
        catch (ExecutionException executionException) {
            Assert.assertTrue((boolean)(executionException.getCause() instanceof ProducerFencedException));
        }
        KafkaConsumer nonTransactionalConsumer = (KafkaConsumer)this.nonTransactionalConsumers().head();
        nonTransactionalConsumer.subscribe((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.topic1(), (List)Nil$.MODULE$)).asJava());
        Seq records = TestUtils$.MODULE$.consumeRecords(nonTransactionalConsumer, 1, TestUtils$.MODULE$.consumeRecords$default$3());
        Assert.assertEquals((long)1L, (long)records.size());
        Assert.assertEquals((Object)"1", (Object)TestUtils$.MODULE$.recordValueAsString((ConsumerRecord<byte[], byte[]>)((ConsumerRecord)records.head())));
        KafkaConsumer transactionalConsumer = (KafkaConsumer)this.transactionalConsumers().head();
        transactionalConsumer.subscribe((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.topic1(), (List)Nil$.MODULE$)).asJava());
        Assert.assertTrue((boolean)TestUtils$.MODULE$.consumeRecordsFor(transactionalConsumer, 1000L).isEmpty());
    }

    @Test
    public void testMultipleMarkersOneLeader() {
        KafkaProducer firstProducer = (KafkaProducer)this.transactionalProducers().head();
        KafkaConsumer consumer = (KafkaConsumer)this.transactionalConsumers().head();
        KafkaConsumer unCommittedConsumer = (KafkaConsumer)this.nonTransactionalConsumers().head();
        String topicWith10Partitions = "largeTopic";
        String topicWith10PartitionsAndOneReplica = "largeTopicOneReplica";
        Properties topicConfig = new Properties();
        topicConfig.put(KafkaConfig$.MODULE$.MinInSyncReplicasProp(), ((Object)BoxesRunTime.boxToInteger((int)2)).toString());
        this.createTopic(topicWith10Partitions, 10, this.numServers(), topicConfig);
        this.createTopic(topicWith10PartitionsAndOneReplica, 10, 1, new Properties());
        firstProducer.initTransactions();
        firstProducer.beginTransaction();
        this.sendTransactionalMessagesWithValueRange((KafkaProducer<byte[], byte[]>)firstProducer, topicWith10Partitions, 0, 5000, false);
        this.sendTransactionalMessagesWithValueRange((KafkaProducer<byte[], byte[]>)firstProducer, topicWith10PartitionsAndOneReplica, 5000, 10000, false);
        firstProducer.abortTransaction();
        firstProducer.beginTransaction();
        this.sendTransactionalMessagesWithValueRange((KafkaProducer<byte[], byte[]>)firstProducer, topicWith10Partitions, 10000, 11000, true);
        firstProducer.commitTransaction();
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)topicWith10PartitionsAndOneReplica, (List)new .colon.colon((Object)topicWith10Partitions, (List)Nil$.MODULE$))).asJava());
        unCommittedConsumer.subscribe((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)topicWith10PartitionsAndOneReplica, (List)new .colon.colon((Object)topicWith10Partitions, (List)Nil$.MODULE$))).asJava());
        TestUtils$.MODULE$.consumeRecords(consumer, 1000, TestUtils$.MODULE$.consumeRecords$default$3()).foreach((Function1 & Serializable & scala.Serializable)record -> TestUtils$.MODULE$.assertCommittedAndGetValue((ConsumerRecord<byte[], byte[]>)record));
        Seq allRecords = TestUtils$.MODULE$.consumeRecords(unCommittedConsumer, 11000, TestUtils$.MODULE$.consumeRecords$default$3());
        scala.collection.immutable.Set expectedValues = ((TraversableOnce)package$.MODULE$.Range().apply(0, 11000).map((Function1 & Serializable & scala.Serializable)x$8 -> TransactionsTest.$anonfun$testMultipleMarkersOneLeader$2(BoxesRunTime.unboxToInt((Object)x$8)), IndexedSeq$.MODULE$.canBuildFrom())).toSet();
        allRecords.foreach((Function1 & Serializable & scala.Serializable)record -> {
            TransactionsTest.$anonfun$testMultipleMarkersOneLeader$3(expectedValues, record);
            return BoxedUnit.UNIT;
        });
    }

    @Test(expected=KafkaException.class)
    public void testConsecutivelyRunInitTransactions() {
        KafkaProducer<byte[], byte[]> producer = this.createTransactionalProducer("normalProducer", this.createTransactionalProducer$default$2(), this.createTransactionalProducer$default$3(), this.createTransactionalProducer$default$4(), this.createTransactionalProducer$default$5());
        producer.initTransactions();
        producer.initTransactions();
        throw Assertions$.MODULE$.fail("Should have raised a KafkaException", new Position("TransactionsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 628));
    }

    @Test
    public void testBumpTransactionalEpoch() {
        String x$1 = "transactionalProducer";
        int x$2 = 5000;
        int x$3 = 5000;
        long x$4 = this.createTransactionalProducer$default$2();
        long x$5 = this.createTransactionalProducer$default$3();
        KafkaProducer<byte[], byte[]> producer = this.createTransactionalProducer(x$1, x$4, x$5, x$2, x$3);
        KafkaConsumer consumer = (KafkaConsumer)this.transactionalConsumers().head();
        try {
            String testTopic = "test-topic";
            this.createTopic(testTopic, this.numPartitions(), 1, new Properties());
            int partitionLeader = TestUtils$.MODULE$.waitUntilLeaderIsKnown((Seq<KafkaServer>)this.servers(), new TopicPartition(testTopic, 0), TestUtils$.MODULE$.waitUntilLeaderIsKnown$default$3());
            producer.initTransactions();
            producer.beginTransaction();
            producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(testTopic, Predef$.MODULE$.int2Integer(0), "4", "4", true));
            producer.commitTransaction();
            LogManager qual$1 = ((KafkaServer)this.servers().apply(partitionLeader)).logManager();
            TopicPartition x$6 = new TopicPartition(testTopic, 0);
            boolean x$7 = qual$1.getLog$default$2();
            ProducerStateEntry producerStateEntry = (ProducerStateEntry)((Tuple2)((Log)qual$1.getLog(x$6, x$7).get()).producerStateManager().activeProducers().head())._2();
            long producerId = producerStateEntry.producerId();
            short initialProducerEpoch = producerStateEntry.producerEpoch();
            producer.beginTransaction();
            producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), null, "2", "2", false));
            producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(testTopic, Predef$.MODULE$.int2Integer(0), "4", "4", false));
            this.killBroker(partitionLeader);
            Future failedFuture = producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(testTopic, Predef$.MODULE$.int2Integer(0), "3", "3", false));
            Thread.sleep(6000L);
            this.restartDeadBrokers();
            TestUtils.assertFutureThrows((Future)failedFuture, TimeoutException.class);
            producer.abortTransaction();
            producer.beginTransaction();
            producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic2(), null, "2", "2", true));
            producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), null, "4", "4", true));
            producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(testTopic, Predef$.MODULE$.int2Integer(0), "1", "1", true));
            producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(testTopic, Predef$.MODULE$.int2Integer(0), "3", "3", true));
            producer.commitTransaction();
            consumer.subscribe((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.topic1(), (List)new .colon.colon((Object)this.topic2(), (List)new .colon.colon((Object)testTopic, (List)Nil$.MODULE$)))).asJava());
            TestUtils$.MODULE$.consumeRecords(consumer, 5, TestUtils$.MODULE$.consumeRecords$default$3()).foreach((Function1 & Serializable & scala.Serializable)record -> TestUtils$.MODULE$.assertCommittedAndGetValue((ConsumerRecord<byte[], byte[]>)record));
            LogManager qual$2 = ((KafkaServer)this.servers().apply(partitionLeader)).logManager();
            TopicPartition x$8 = new TopicPartition(testTopic, 0);
            boolean x$9 = qual$2.getLog$default$2();
            producerStateEntry = (ProducerStateEntry)((Log)qual$2.getLog(x$8, x$9).get()).producerStateManager().activeProducers().apply((Object)BoxesRunTime.boxToLong((long)producerId));
            Assert.assertTrue((producerStateEntry.producerEpoch() > initialProducerEpoch ? 1 : 0) != 0);
        }
        finally {
            producer.close(Duration.ZERO);
        }
    }

    @Test
    public void testFailureToFenceEpoch() {
        KafkaProducer producer1 = (KafkaProducer)this.transactionalProducers().head();
        String x$1 = "transactional-producer";
        long x$2 = 1000L;
        long x$3 = this.createTransactionalProducer$default$2();
        int x$4 = this.createTransactionalProducer$default$4();
        int x$5 = this.createTransactionalProducer$default$5();
        KafkaProducer<byte[], byte[]> producer2 = this.createTransactionalProducer(x$1, x$3, x$2, x$4, x$5);
        producer1.initTransactions();
        producer1.beginTransaction();
        producer1.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), Predef$.MODULE$.int2Integer(0), "4", "4", true));
        producer1.commitTransaction();
        int partitionLeader = TestUtils$.MODULE$.waitUntilLeaderIsKnown((Seq<KafkaServer>)this.servers(), new TopicPartition(this.topic1(), 0), TestUtils$.MODULE$.waitUntilLeaderIsKnown$default$3());
        LogManager qual$1 = ((KafkaServer)this.servers().apply(partitionLeader)).logManager();
        TopicPartition x$6 = new TopicPartition(this.topic1(), 0);
        boolean x$7 = qual$1.getLog$default$2();
        ProducerStateEntry producerStateEntry = (ProducerStateEntry)((Tuple2)((Log)qual$1.getLog(x$6, x$7).get()).producerStateManager().activeProducers().head())._2();
        long producerId = producerStateEntry.producerId();
        short initialProducerEpoch = producerStateEntry.producerEpoch();
        this.killBroker(0);
        this.killBroker(1);
        try {
            try {
                producer2.initTransactions();
            }
            catch (TimeoutException timeoutException) {
            }
            catch (Exception e) {
                throw Assertions$.MODULE$.fail("Got an unexpected exception from initTransactions", (Throwable)e, new Position("TransactionsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 717));
            }
        }
        finally {
            producer2.close();
        }
        this.restartDeadBrokers();
        try {
            try {
                producer1.beginTransaction();
            }
            catch (ProducerFencedException producerFencedException) {
            }
            catch (Exception e) {
                throw Assertions$.MODULE$.fail("Got an unexpected exception from commitTransaction", (Throwable)e, new Position("TransactionsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 731));
            }
        }
        finally {
            producer1.close();
        }
        String x$8 = "transactional-producer";
        long x$9 = 5000L;
        long x$10 = this.createTransactionalProducer$default$2();
        int x$11 = this.createTransactionalProducer$default$4();
        int x$12 = this.createTransactionalProducer$default$5();
        KafkaProducer<byte[], byte[]> producer3 = this.createTransactionalProducer(x$8, x$10, x$9, x$11, x$12);
        producer3.initTransactions();
        producer3.beginTransaction();
        producer3.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), Predef$.MODULE$.int2Integer(0), "4", "4", true));
        producer3.commitTransaction();
        LogManager qual$2 = ((KafkaServer)this.servers().apply(partitionLeader)).logManager();
        TopicPartition x$13 = new TopicPartition(this.topic1(), 0);
        boolean x$14 = qual$2.getLog$default$2();
        producerStateEntry = (ProducerStateEntry)((Log)qual$2.getLog(x$13, x$14).get()).producerStateManager().activeProducers().apply((Object)BoxesRunTime.boxToLong((long)producerId));
        Assert.assertEquals((long)((short)(initialProducerEpoch + 1)), (long)producerStateEntry.producerEpoch());
    }

    private void sendTransactionalMessagesWithValueRange(KafkaProducer<byte[], byte[]> producer, String topic, int start, int end, boolean willBeCommitted) {
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        Range range = RichInt$.MODULE$.until$extension0(start, end);
        if (range == null) {
            throw null;
        }
        Range foreach_this = range;
        if (!foreach_this.isEmpty()) {
            int foreach_i = foreach_this.start();
            while (true) {
                TransactionsTest.$anonfun$sendTransactionalMessagesWithValueRange$1(producer, topic, willBeCommitted, foreach_i);
                if (foreach_i == foreach_this.scala$collection$immutable$Range$$lastElement()) break;
                foreach_i += foreach_this.step();
            }
        }
        producer.flush();
    }

    /*
     * WARNING - void declaration
     */
    private Properties serverProps() {
        void var1_1;
        Properties serverProps = new Properties();
        serverProps.put(KafkaConfig$.MODULE$.AutoCreateTopicsEnableProp(), ((Object)BoxesRunTime.boxToBoolean((boolean)false)).toString());
        serverProps.put(KafkaConfig$.MODULE$.OffsetsTopicPartitionsProp(), ((Object)BoxesRunTime.boxToInteger((int)1)).toString());
        serverProps.put(KafkaConfig$.MODULE$.TransactionsTopicPartitionsProp(), ((Object)BoxesRunTime.boxToInteger((int)3)).toString());
        serverProps.put(KafkaConfig$.MODULE$.TransactionsTopicReplicationFactorProp(), ((Object)BoxesRunTime.boxToInteger((int)2)).toString());
        serverProps.put(KafkaConfig$.MODULE$.TransactionsTopicMinISRProp(), ((Object)BoxesRunTime.boxToInteger((int)2)).toString());
        serverProps.put(KafkaConfig$.MODULE$.ControlledShutdownEnableProp(), ((Object)BoxesRunTime.boxToBoolean((boolean)true)).toString());
        serverProps.put(KafkaConfig$.MODULE$.UncleanLeaderElectionEnableProp(), ((Object)BoxesRunTime.boxToBoolean((boolean)false)).toString());
        serverProps.put(KafkaConfig$.MODULE$.AutoLeaderRebalanceEnableProp(), ((Object)BoxesRunTime.boxToBoolean((boolean)false)).toString());
        serverProps.put(KafkaConfig$.MODULE$.GroupInitialRebalanceDelayMsProp(), "0");
        serverProps.put(KafkaConfig$.MODULE$.TransactionsAbortTimedOutTransactionCleanupIntervalMsProp(), "200");
        return var1_1;
    }

    private KafkaConsumer<byte[], byte[]> createReadCommittedConsumer(String group, int maxPollRecords, Properties props) {
        String x$1 = TestUtils$.MODULE$.getBrokerListStrFromServers((Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.getBrokerListStrFromServers$default$2());
        boolean x$3 = false;
        boolean x$4 = true;
        String x$6 = TestUtils$.MODULE$.createConsumer$default$3();
        SecurityProtocol x$7 = TestUtils$.MODULE$.createConsumer$default$7();
        Option<File> x$8 = TestUtils$.MODULE$.createConsumer$default$8();
        Option<Properties> x$9 = TestUtils$.MODULE$.createConsumer$default$9();
        ByteArrayDeserializer x$10 = TestUtils$.MODULE$.createConsumer$default$10();
        ByteArrayDeserializer x$11 = TestUtils$.MODULE$.createConsumer$default$11();
        KafkaConsumer consumer = TestUtils$.MODULE$.createConsumer(x$1, group, x$6, x$3, x$4, maxPollRecords, x$7, x$8, x$9, x$10, x$11);
        this.transactionalConsumers().$plus$eq(consumer);
        return consumer;
    }

    private String createReadCommittedConsumer$default$1() {
        return "group";
    }

    private int createReadCommittedConsumer$default$2() {
        return 500;
    }

    private Properties createReadCommittedConsumer$default$3() {
        return new Properties();
    }

    /*
     * WARNING - void declaration
     */
    private KafkaConsumer<byte[], byte[]> createReadUncommittedConsumer(String group) {
        void var2_12;
        String x$1 = TestUtils$.MODULE$.getBrokerListStrFromServers((Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.getBrokerListStrFromServers$default$2());
        boolean x$3 = false;
        String x$4 = TestUtils$.MODULE$.createConsumer$default$3();
        boolean x$5 = TestUtils$.MODULE$.createConsumer$default$5();
        int x$6 = TestUtils$.MODULE$.createConsumer$default$6();
        SecurityProtocol x$7 = TestUtils$.MODULE$.createConsumer$default$7();
        Option<File> x$8 = TestUtils$.MODULE$.createConsumer$default$8();
        Option<Properties> x$9 = TestUtils$.MODULE$.createConsumer$default$9();
        ByteArrayDeserializer x$10 = TestUtils$.MODULE$.createConsumer$default$10();
        ByteArrayDeserializer x$11 = TestUtils$.MODULE$.createConsumer$default$11();
        KafkaConsumer consumer = TestUtils$.MODULE$.createConsumer(x$1, group, x$4, x$3, x$5, x$6, x$7, x$8, x$9, x$10, x$11);
        this.nonTransactionalConsumers().$plus$eq(consumer);
        return var2_12;
    }

    private KafkaProducer<byte[], byte[]> createTransactionalProducer(String transactionalId, long transactionTimeoutMs, long maxBlockMs, int deliveryTimeoutMs, int requestTimeoutMs) {
        Buffer<KafkaServer> x$2 = this.servers();
        int x$7 = TestUtils$.MODULE$.createTransactionalProducer$default$3();
        int x$8 = TestUtils$.MODULE$.createTransactionalProducer$default$8();
        KafkaProducer<byte[], byte[]> producer = TestUtils$.MODULE$.createTransactionalProducer(transactionalId, (Seq<KafkaServer>)x$2, x$7, transactionTimeoutMs, maxBlockMs, deliveryTimeoutMs, requestTimeoutMs, x$8);
        this.transactionalProducers().$plus$eq(producer);
        return producer;
    }

    private long createTransactionalProducer$default$2() {
        return 60000L;
    }

    private long createTransactionalProducer$default$3() {
        return 60000L;
    }

    private int createTransactionalProducer$default$4() {
        return 120000;
    }

    private int createTransactionalProducer$default$5() {
        return 30000;
    }

    public static final /* synthetic */ void $anonfun$testBasicTransactions$2(scala.collection.immutable.Set expectedValues$1, ConsumerRecord record) {
        Assert.assertTrue((boolean)expectedValues$1.contains((Object)TestUtils$.MODULE$.recordValueAsString((ConsumerRecord<byte[], byte[]>)record)));
    }

    public static final /* synthetic */ void $anonfun$testReadCommittedConsumerShouldNotSeeUndecidedData$1(ConsumerRecord record) {
        Assert.assertEquals((Object)"x", (Object)new String((byte[])record.key()));
        Assert.assertEquals((Object)"1", (Object)new String((byte[])record.value()));
    }

    public static final /* synthetic */ int $anonfun$sendOffset$4(ConsumerRecord record) {
        String string = TestUtils$.MODULE$.assertCommittedAndGetValue((ConsumerRecord<byte[], byte[]>)record);
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        return new StringOps(string).toInt();
    }

    public static final /* synthetic */ String $anonfun$testOffsetMetadataInSendOffsetsToTransaction$2() {
        return "cannot read committed offset";
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$testSendOffsetsToTransactionTimeout$1(TransactionsTest $this, KafkaProducer producer) {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        Tuple2[] tuple2Array = new Tuple2[1];
        OffsetAndMetadata offsetAndMetadata = new OffsetAndMetadata(0L);
        Object object = Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition($this.topic1(), 0));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        producer.sendOffsetsToTransaction((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array))).asJava(), "test-group");
    }

    public static final /* synthetic */ String $anonfun$testMultipleMarkersOneLeader$2(int x$8) {
        return ((Object)BoxesRunTime.boxToInteger((int)x$8)).toString();
    }

    public static final /* synthetic */ void $anonfun$testMultipleMarkersOneLeader$3(scala.collection.immutable.Set expectedValues$2, ConsumerRecord record) {
        Assert.assertTrue((boolean)expectedValues$2.contains((Object)TestUtils$.MODULE$.recordValueAsString((ConsumerRecord<byte[], byte[]>)record)));
    }

    public static final /* synthetic */ Future $anonfun$sendTransactionalMessagesWithValueRange$1(KafkaProducer producer$2, String topic$1, boolean willBeCommitted$1, int i) {
        String x$3 = ((Object)BoxesRunTime.boxToInteger((int)i)).toString();
        String x$5 = ((Object)BoxesRunTime.boxToInteger((int)i)).toString();
        return producer$2.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(topic$1, null, x$5, x$3, willBeCommitted$1));
    }

    public TransactionsTest() {
        this.numServers = 3;
        this.transactionalProducerCount = 2;
        this.transactionalConsumerCount = 1;
        this.nonTransactionalConsumerCount = 1;
        this.topic1 = "topic1";
        this.topic2 = "topic2";
        this.numPartitions = 4;
    }

    public static final /* synthetic */ KafkaProducer $anonfun$setUp$1$adapted(TransactionsTest $this, Object _) {
        return $this.createTransactionalProducer("transactional-producer", $this.createTransactionalProducer$default$2(), $this.createTransactionalProducer$default$3(), $this.createTransactionalProducer$default$4(), $this.createTransactionalProducer$default$5());
    }

    public static final /* synthetic */ KafkaConsumer $anonfun$setUp$2$adapted(TransactionsTest $this, Object _) {
        return $this.createReadCommittedConsumer("transactional-group", $this.createReadCommittedConsumer$default$2(), $this.createReadCommittedConsumer$default$3());
    }

    public static final /* synthetic */ KafkaConsumer $anonfun$setUp$3$adapted(TransactionsTest $this, Object _) {
        return $this.createReadUncommittedConsumer("non-transactional-group");
    }

    public static final /* synthetic */ Object $anonfun$testSendOffsetsWithGroupId$1$adapted(KafkaProducer producer, String groupId, KafkaConsumer consumer) {
        producer.sendOffsetsToTransaction((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter(TestUtils$.MODULE$.consumerPositions((KafkaConsumer<byte[], byte[]>)consumer)).asJava(), groupId);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testSendOffsetsWithGroupMetadata$1$adapted(KafkaProducer producer, String x$5, KafkaConsumer consumer) {
        producer.sendOffsetsToTransaction((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter(TestUtils$.MODULE$.consumerPositions((KafkaConsumer<byte[], byte[]>)consumer)).asJava(), consumer.groupMetadata());
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Future $anonfun$sendTransactionalMessagesWithValueRange$1$adapted(KafkaProducer producer$2, String topic$1, boolean willBeCommitted$1, Object i) {
        return TransactionsTest.$anonfun$sendTransactionalMessagesWithValueRange$1(producer$2, topic$1, willBeCommitted$1, BoxesRunTime.unboxToInt((Object)i));
    }
}

