/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer$;
import kafka.server.ThrottledReplicaListValidator$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;
import org.junit.Assert;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001u3Aa\u0004\t\u0001+!)A\u0004\u0001C\u0001;!)\u0001\u0005\u0001C\u0001C!)a\u0006\u0001C\u0001C!)\u0001\u0007\u0001C\u0001C!)!\u0007\u0001C\u0001C!)A\u0007\u0001C\u0001C!)a\u0007\u0001C\u0001C!)\u0001\b\u0001C\u0001C!)!\b\u0001C\u0001C!)A\b\u0001C\u0001C!)a\b\u0001C\u0001C!)\u0001\t\u0001C\u0001C!)!\t\u0001C\u0005\u0007\")A\u000b\u0001C\u0005+\niAj\\4D_:4\u0017n\u001a+fgRT!!\u0005\n\u0002\u00071|wMC\u0001\u0014\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u0001\f\u0011\u0005]QR\"\u0001\r\u000b\u0003e\tQa]2bY\u0006L!a\u0007\r\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\ta\u0004\u0005\u0002 \u00015\t\u0001#A\u0016f]N,(/\u001a(p'R\fG/[2J]&$\u0018.\u00197ju\u0006$\u0018n\u001c8Pe\u0012,'\u000fR3qK:$WM\\2z)\u0005\u0011\u0003CA\f$\u0013\t!\u0003D\u0001\u0003V]&$\bF\u0001\u0002'!\t9C&D\u0001)\u0015\tI#&A\u0003kk:LGOC\u0001,\u0003\ry'oZ\u0005\u0003[!\u0012A\u0001V3ti\u00061B/Z:u\u0017\u000647.Y\"p]\u001aLw\rV8Qe>\u00048\u000f\u000b\u0002\u0004M\u0005\u0011B/Z:u\rJ|W\u000e\u0015:paN,U\u000e\u001d;zQ\t!a%\u0001\u000buKN$hI]8n!J|\u0007o]%om\u0006d\u0017\u000e\u001a\u0015\u0003\u000b\u0019\na\u0004^3ti&sg/\u00197jI\u000e{W\u000e]1di&|g\u000eT1h\u0007>tg-[4)\u0005\u00191\u0013!J:i_VdGMV1mS\u0012\fG/\u001a+ie>$H\u000f\\3e%\u0016\u0004H.[2bg\u000e{gNZ5hQ\t9a%A\buKN$Hk\u001c%u[2$\u0016M\u00197fQ\tAa%\u0001\u0006uKN$Hk\u001c%u[2D#!\u0003\u0014\u0002#Q,7\u000f\u001e+p\u000b:\u0014\u0018n\u00195fIJ\u001bH\u000f\u000b\u0002\u000bM\u0005IA/Z:u)>\u00146\u000f\u001e\u0015\u0003\u0017\u0019\n!\u0003^3ti\u001e+GoQ8oM&<g+\u00197vK\"\u0012ABJ\u0001\bSN4\u0016\r\\5e)\t!u\t\u0005\u0002\u0018\u000b&\u0011a\t\u0007\u0002\b\u0005>|G.Z1o\u0011\u0015AU\u00021\u0001J\u0003-\u0019wN\u001c4jOZ\u000bG.^3\u0011\u0005)\u000bfBA&P!\ta\u0005$D\u0001N\u0015\tqE#\u0001\u0004=e>|GOP\u0005\u0003!b\ta\u0001\u0015:fI\u00164\u0017B\u0001*T\u0005\u0019\u0019FO]5oO*\u0011\u0001\u000bG\u0001\u0016CN\u001cXM\u001d;Qe>\u0004XM\u001d;z\u0013:4\u0018\r\\5e)\r\u0011c\u000b\u0017\u0005\u0006/:\u0001\r!S\u0001\u0005]\u0006lW\rC\u0003Z\u001d\u0001\u0007!,\u0001\u0004wC2,Xm\u001d\t\u0004/m3\u0012B\u0001/\u0019\u0005)a$/\u001a9fCR,GM\u0010")
public class LogConfigTest {
    @Test
    public void ensureNoStaticInitializationOrderDependency() {
        Assert.assertTrue((KafkaConfig$.MODULE$.LogRetentionTimeMillisProp() != null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)LogConfig$.MODULE$.configNames().forall((Function1 & Serializable & scala.Serializable)config -> BoxesRunTime.boxToBoolean((boolean)LogConfigTest.$anonfun$ensureNoStaticInitializationOrderDependency$1(config))));
    }

    @Test
    public void testKafkaConfigToProps() {
        long millisInHour = 3600000L;
        Properties kafkaProps = TestUtils$.MODULE$.createBrokerConfig(0, "", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20());
        kafkaProps.put(KafkaConfig$.MODULE$.LogRollTimeHoursProp(), "2");
        kafkaProps.put(KafkaConfig$.MODULE$.LogRollTimeJitterHoursProp(), "2");
        kafkaProps.put(KafkaConfig$.MODULE$.LogRetentionTimeHoursProp(), "2");
        KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(kafkaProps);
        Map logProps = KafkaServer$.MODULE$.copyKafkaConfigToLog(kafkaConfig);
        Assert.assertEquals((Object)BoxesRunTime.boxToLong((long)(2L * millisInHour)), logProps.get(LogConfig$.MODULE$.SegmentMsProp()));
        Assert.assertEquals((Object)BoxesRunTime.boxToLong((long)(2L * millisInHour)), logProps.get(LogConfig$.MODULE$.SegmentJitterMsProp()));
        Assert.assertEquals((Object)BoxesRunTime.boxToLong((long)(2L * millisInHour)), logProps.get(LogConfig$.MODULE$.RetentionMsProp()));
    }

    @Test
    public void testFromPropsEmpty() {
        Properties p = new Properties();
        LogConfig config = new LogConfig((Map)p, LogConfig$.MODULE$.apply$default$2());
        Assert.assertEquals((Object)LogConfig$.MODULE$.apply(), (Object)config);
    }

    @Test
    public void testFromPropsInvalid() {
        LogConfig$.MODULE$.configNames().foreach((Function1 & Serializable & scala.Serializable)name -> {
            LogConfigTest.$anonfun$testFromPropsInvalid$1(this, name);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testInvalidCompactionLagConfig() {
        Properties props = new Properties();
        props.setProperty(LogConfig$.MODULE$.MaxCompactionLagMsProp(), "100");
        props.setProperty(LogConfig$.MODULE$.MinCompactionLagMsProp(), "200");
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> LogConfig$.MODULE$.validate(props), ClassTag$.MODULE$.apply(Exception.class), new Position("LogConfigTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 91));
    }

    @Test
    public void shouldValidateThrottledReplicasConfig() {
        Assert.assertTrue((boolean)this.isValid("*"));
        Assert.assertTrue((boolean)this.isValid("* "));
        Assert.assertTrue((boolean)this.isValid(""));
        Assert.assertTrue((boolean)this.isValid(" "));
        Assert.assertTrue((boolean)this.isValid("100:10"));
        Assert.assertTrue((boolean)this.isValid("100:10,12:10"));
        Assert.assertTrue((boolean)this.isValid("100:10,12:10,15:1"));
        Assert.assertTrue((boolean)this.isValid("100:10,12:10,15:1  "));
        Assert.assertTrue((boolean)this.isValid("100:0,"));
        Assert.assertFalse((boolean)this.isValid("100"));
        Assert.assertFalse((boolean)this.isValid("100:"));
        Assert.assertFalse((boolean)this.isValid("100:0,10"));
        Assert.assertFalse((boolean)this.isValid("100:0,10:"));
        Assert.assertFalse((boolean)this.isValid("100:0,10:   "));
        Assert.assertFalse((boolean)this.isValid("100 :0,10:   "));
        Assert.assertFalse((boolean)this.isValid("100: 0,10:   "));
        Assert.assertFalse((boolean)this.isValid("100:0,10 :   "));
    }

    @Test
    public void testToHtmlTable() {
        String html = LogConfig$.MODULE$.configDefCopy().toHtmlTable();
        String expectedConfig = "<td>file.delete.delay.ms</td>";
        Assert.assertTrue((String)new StringBuilder(23).append("Could not find `").append(expectedConfig).append("` in:\n ").append(html).toString(), (boolean)html.contains(expectedConfig));
    }

    @Test
    public void testToHtml() {
        String html = LogConfig$.MODULE$.configDefCopy().toHtml(4, key -> new StringBuilder(7).append("prefix_").append((String)key).toString(), Collections.emptyMap());
        String expectedConfig = "<h4><a id=\"file.delete.delay.ms\"></a><a id=\"prefix_file.delete.delay.ms\" href=\"#prefix_file.delete.delay.ms\">file.delete.delay.ms</a></h4>";
        Assert.assertTrue((String)new StringBuilder(23).append("Could not find `").append(expectedConfig).append("` in:\n ").append(html).toString(), (boolean)html.contains(expectedConfig));
    }

    @Test
    public void testToEnrichedRst() {
        String rst = LogConfig$.MODULE$.configDefCopy().toEnrichedRst();
        String expectedConfig = "``file.delete.delay.ms``";
        Assert.assertTrue((String)new StringBuilder(23).append("Could not find `").append(expectedConfig).append("` in:\n ").append(rst).toString(), (boolean)rst.contains(expectedConfig));
    }

    @Test
    public void testToRst() {
        String rst = LogConfig$.MODULE$.configDefCopy().toRst();
        String expectedConfig = "``file.delete.delay.ms``";
        Assert.assertTrue((String)new StringBuilder(23).append("Could not find `").append(expectedConfig).append("` in:\n ").append(rst).toString(), (boolean)rst.contains(expectedConfig));
    }

    @Test
    public void testGetConfigValue() {
        LogConfig.LogConfigDef configDef = LogConfig$.MODULE$.configDefCopy();
        String configNameWithNoServerMapping = "log.foo";
        configDef.define(configNameWithNoServerMapping, ConfigDef.Type.INT, (Object)BoxesRunTime.boxToInteger((int)1), ConfigDef.Importance.MEDIUM, new StringBuilder(4).append(configNameWithNoServerMapping).append(" doc").toString());
        ConfigDef.ConfigKey deleteDelayKey = (ConfigDef.ConfigKey)configDef.configKeys().get("file.delete.delay.ms");
        String deleteDelayServerDefault = configDef.getConfigValue(deleteDelayKey, LogConfig$.MODULE$.ServerDefaultHeaderName());
        Assert.assertEquals((Object)KafkaConfig$.MODULE$.LogDeleteDelayMsProp(), (Object)deleteDelayServerDefault);
        ConfigDef.ConfigKey keyWithNoServerMapping = (ConfigDef.ConfigKey)configDef.configKeys().get(configNameWithNoServerMapping);
        Assert.assertNull((Object)configDef.getConfigValue(keyWithNoServerMapping, LogConfig$.MODULE$.ServerDefaultHeaderName()));
    }

    private boolean isValid(String configValue) {
        try {
            ThrottledReplicaListValidator$.MODULE$.ensureValidString("", configValue);
            return true;
        }
        catch (ConfigException configException) {
            return false;
        }
    }

    private void assertPropertyInvalid(String name, Seq<Object> values) {
        values.foreach((Function1 & Serializable & scala.Serializable)value -> {
            Properties props = new Properties();
            props.setProperty(name, value.toString());
            return (Exception)Assertions$.MODULE$.intercept((Function0 & Serializable & scala.Serializable)() -> new LogConfig((Map)props, LogConfig$.MODULE$.apply$default$2()), ClassTag$.MODULE$.apply(Exception.class), new Position("LogConfigTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 179));
        });
    }

    public static final /* synthetic */ boolean $anonfun$ensureNoStaticInitializationOrderDependency$1(String config) {
        Option serverConfigOpt = LogConfig$.MODULE$.serverConfigName(config);
        return serverConfigOpt.isDefined() && serverConfigOpt.get() != null;
    }

    public static final /* synthetic */ void $anonfun$testFromPropsInvalid$1(LogConfigTest $this, String name) {
        String string = LogConfig$.MODULE$.UncleanLeaderElectionEnableProp();
        if (!(string != null ? !string.equals(name) : name != null)) {
            $this.assertPropertyInvalid(name, (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"not a boolean"}));
            return;
        }
        String string2 = LogConfig$.MODULE$.RetentionBytesProp();
        if (!(string2 != null ? !string2.equals(name) : name != null)) {
            $this.assertPropertyInvalid(name, (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"not_a_number"}));
            return;
        }
        String string3 = LogConfig$.MODULE$.RetentionMsProp();
        if (!(string3 != null ? !string3.equals(name) : name != null)) {
            $this.assertPropertyInvalid(name, (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"not_a_number"}));
            return;
        }
        String string4 = LogConfig$.MODULE$.CleanupPolicyProp();
        if (!(string4 != null ? !string4.equals(name) : name != null)) {
            $this.assertPropertyInvalid(name, (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"true", "foobar"}));
            return;
        }
        String string5 = LogConfig$.MODULE$.MinCleanableDirtyRatioProp();
        if (!(string5 != null ? !string5.equals(name) : name != null)) {
            $this.assertPropertyInvalid(name, (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"not_a_number", "-0.1", "1.2"}));
            return;
        }
        String string6 = LogConfig$.MODULE$.MinInSyncReplicasProp();
        if (!(string6 != null ? !string6.equals(name) : name != null)) {
            $this.assertPropertyInvalid(name, (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"not_a_number", "0", "-1"}));
            return;
        }
        String string7 = LogConfig$.MODULE$.MessageFormatVersionProp();
        if (!(string7 != null ? !string7.equals(name) : name != null)) {
            $this.assertPropertyInvalid(name, (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{""}));
            return;
        }
        $this.assertPropertyInvalid(name, (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"not_a_number", "-1"}));
    }
}

