/*
 * Decompiled with CFR 0.152.
 */
package kafka.network;

import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import kafka.server.BaseRequestTest;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.NotNothing$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.ProduceRequest;
import org.apache.kafka.common.requests.ProduceResponse;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005}h\u0001B\u0012%\u0001%BQ\u0001\r\u0001\u0005\u0002EBQ\u0001\u000e\u0001\u0005BUBq\u0001\u0010\u0001C\u0002\u0013\u0005Q\b\u0003\u0004G\u0001\u0001\u0006IA\u0010\u0005\b\u000f\u0002\u0011\r\u0011\"\u0001I\u0011\u0019)\u0006\u0001)A\u0005\u0013\"9a\u000b\u0001b\u0001\n\u00039\u0006B\u00020\u0001A\u0003%\u0001\fC\u0004`\u0001\t\u0007I\u0011A\u001b\t\r\u0001\u0004\u0001\u0015!\u00037\u0011%\t\u0007\u00011AA\u0002\u0013\u0005!\rC\u0005l\u0001\u0001\u0007\t\u0019!C\u0001Y\"I!\u000f\u0001a\u0001\u0002\u0003\u0006Ka\u0019\u0005\u0006g\u0002!\t\u0005\u001e\u0005\u0006w\u0002!\t\u0005 \u0005\u0007\u0003\u0013\u0001A\u0011\t?\t\r\u0005M\u0001\u0001\"\u0001}\u0011\u0019\ti\u0002\u0001C\u0001y\"1\u0011\u0011\u0005\u0001\u0005\u0002qDq!!\n\u0001\t\u0013\t9\u0003C\u0004\u0002V\u0001!I!a\u0016\t\u000f\u0005u\u0003\u0001\"\u0003\u0002`!9\u0011\u0011\u000f\u0001\u0005\n\u0005M\u0004\"CAD\u0001E\u0005I\u0011BAE\u0011\u001d\ty\n\u0001C\u0005\u0003CCa!a,\u0001\t\u0003)\u0004bBAY\u0001\u0011\u0005\u00111\u0017\u0005\b\u0003{\u0003A\u0011BA`\u0011%\t\u0019\rAI\u0001\n\u0013\t)\rC\u0004\u0002J\u0002!I!a3\t\u000f\u0005E\u0007\u0001\"\u0003\u0002T\"9\u00111\u001d\u0001\u0005\n\u0005\u0015\bbBAu\u0001\u0011%\u00111\u001e\u0005\b\u0003c\u0004A\u0011BAz\u0005i!\u0015P\\1nS\u000e\u001cuN\u001c8fGRLwN\\)v_R\fG+Z:u\u0015\t)c%A\u0004oKR<xN]6\u000b\u0003\u001d\nQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001UA\u00111FL\u0007\u0002Y)\u0011QFJ\u0001\u0007g\u0016\u0014h/\u001a:\n\u0005=b#a\u0004\"bg\u0016\u0014V-];fgR$Vm\u001d;\u0002\rqJg.\u001b;?)\u0005\u0011\u0004CA\u001a\u0001\u001b\u0005!\u0013a\u00032s_.,'oQ8v]R,\u0012A\u000e\t\u0003oij\u0011\u0001\u000f\u0006\u0002s\u0005)1oY1mC&\u00111\b\u000f\u0002\u0004\u0013:$\u0018!\u0002;pa&\u001cW#\u0001 \u0011\u0005}\"U\"\u0001!\u000b\u0005\u0005\u0013\u0015\u0001\u00027b]\u001eT\u0011aQ\u0001\u0005U\u00064\u0018-\u0003\u0002F\u0001\n11\u000b\u001e:j]\u001e\fa\u0001^8qS\u000e\u0004\u0013\u0001\u00037jgR,g.\u001a:\u0016\u0003%\u0003\"AS*\u000e\u0003-S!!\n'\u000b\u00055s\u0015AB2p[6|gN\u0003\u0002(\u001f*\u0011\u0001+U\u0001\u0007CB\f7\r[3\u000b\u0003I\u000b1a\u001c:h\u0013\t!6J\u0001\u0007MSN$XM\\3s\u001d\u0006lW-A\u0005mSN$XM\\3sA\u0005aAn\\2bY\u0006#GM]3tgV\t\u0001\f\u0005\u0002Z96\t!L\u0003\u0002\\\u0005\u0006\u0019a.\u001a;\n\u0005uS&aC%oKR\fE\r\u001a:fgN\fQ\u0002\\8dC2\fE\r\u001a:fgN\u0004\u0013!\b9mC&tG/\u001a=u\u0019&\u001cH/\u001a8fe\u0012+g-Y;miF+x\u000e^1\u0002=Ad\u0017-\u001b8uKb$H*[:uK:,'\u000fR3gCVdG/U;pi\u0006\u0004\u0013\u0001C3yK\u000e,Ho\u001c:\u0016\u0003\r\u0004\"\u0001Z5\u000e\u0003\u0015T!AZ4\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0002i\u0005\u0006!Q\u000f^5m\u0013\tQWMA\bFq\u0016\u001cW\u000f^8s'\u0016\u0014h/[2f\u00031)\u00070Z2vi>\u0014x\fJ3r)\ti\u0007\u000f\u0005\u00028]&\u0011q\u000e\u000f\u0002\u0005+:LG\u000fC\u0004r\u0019\u0005\u0005\t\u0019A2\u0002\u0007a$\u0013'A\u0005fq\u0016\u001cW\u000f^8sA\u00059\"M]8lKJ\u0004&o\u001c9feRLxJ^3se&$Wm\u001d\u000b\u0003[VDQA\u001e\bA\u0002]\f!\u0002\u001d:pa\u0016\u0014H/[3t!\tA\u00180D\u0001h\u0013\tQxM\u0001\u0006Qe>\u0004XM\u001d;jKN\fQa]3u+B$\u0012!\u001c\u0015\u0003\u001fy\u00042a`A\u0003\u001b\t\t\tAC\u0002\u0002\u0004E\u000bQA[;oSRLA!a\u0002\u0002\u0002\t1!)\u001a4pe\u0016\f\u0001\u0002^3be\u0012{wO\u001c\u0015\u0004!\u00055\u0001cA@\u0002\u0010%!\u0011\u0011CA\u0001\u0005\u0015\te\r^3s\u0003i!Xm\u001d;Es:\fW.[2D_:tWm\u0019;j_:\fVo\u001c;bQ\r\t\u0012q\u0003\t\u0004\u007f\u0006e\u0011\u0002BA\u000e\u0003\u0003\u0011A\u0001V3ti\u0006\u0011C/Z:u\tft\u0017-\\5d\u0019&\u001cH/\u001a8fe\u000e{gN\\3di&|g.U;pi\u0006D3AEA\f\u00039\"Xm\u001d;Es:\fW.[2MSN$XM\\3s\u0007>tg.Z2uS>t7I]3bi&|gNU1uKF+x\u000e^1)\u0007M\t9\"\u0001\nsK\u000e|gNZ5hkJ,7+\u001a:wKJ\u001cHcB7\u0002*\u00055\u0012q\u0007\u0005\u0007\u0003W!\u0002\u0019A<\u0002\u00119,w\u000f\u0015:paNDq!a\f\u0015\u0001\u0004\t\t$A\bqKJ\u0014%o\\6fe\u000e{gNZ5h!\r9\u00141G\u0005\u0004\u0003kA$a\u0002\"p_2,\u0017M\u001c\u0005\b\u0003s!\u0002\u0019AA\u001e\u00035\t\u0007K]8q)>4VM]5gsB9q'!\u0010\u0002B\u0005\u0005\u0013bAA q\t1A+\u001e9mKJ\u0002B!a\u0011\u0002R9!\u0011QIA'!\r\t9\u0005O\u0007\u0003\u0003\u0013R1!a\u0013)\u0003\u0019a$o\\8u}%\u0019\u0011q\n\u001d\u0002\rA\u0013X\rZ3g\u0013\r)\u00151\u000b\u0006\u0004\u0003\u001fB\u0014aD<bSR4uN\u001d'jgR,g.\u001a:\u0015\u00075\fI\u0006C\u0004\u0002\\U\u0001\r!!\u0011\u0002\u00191L7\u000f^3oKJt\u0015-\\3\u0002#\r\u0014X-\u0019;f\u0003\u0012l\u0017N\\\"mS\u0016tG\u000f\u0006\u0002\u0002bA!\u00111MA7\u001b\t\t)G\u0003\u0003\u0002h\u0005%\u0014!B1e[&t'bAA6\u001d\u000691\r\\5f]R\u001c\u0018\u0002BA8\u0003K\u0012Q!\u00113nS:\fQc^1ji\u001a{'oQ8oM&<wJ\\*feZ,'\u000fF\u0004n\u0003k\nI(! \t\u000f\u0005]t\u00031\u0001\u0002B\u0005A\u0001O]8q\u001d\u0006lW\rC\u0004\u0002|]\u0001\r!!\u0011\u0002\u0013A\u0014x\u000e\u001d,bYV,\u0007\"CA@/A\u0005\t\u0019AAA\u0003%i\u0017\r_,bSRl5\u000fE\u00028\u0003\u0007K1!!\"9\u0005\u0011auN\\4\u0002?]\f\u0017\u000e\u001e$pe\u000e{gNZ5h\u001f:\u001cVM\u001d<fe\u0012\"WMZ1vYR$3'\u0006\u0002\u0002\f*\"\u0011\u0011QAGW\t\ty\t\u0005\u0003\u0002\u0012\u0006mUBAAJ\u0015\u0011\t)*a&\u0002\u0013Ut7\r[3dW\u0016$'bAAMq\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005u\u00151\u0013\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017A\u00049s_\u0012,8-\u001a*fcV,7\u000f^\u000b\u0003\u0003G\u0003B!!*\u0002,6\u0011\u0011q\u0015\u0006\u0004\u0003Sc\u0015\u0001\u0003:fcV,7\u000f^:\n\t\u00055\u0016q\u0015\u0002\u000f!J|G-^2f%\u0016\fX/Z:u\u0003=\u0019wN\u001c8fGRLwN\\\"pk:$\u0018aB2p]:,7\r\u001e\u000b\u0005\u0003k\u000bY\fE\u0002Z\u0003oK1!!/[\u0005\u0019\u0019vnY6fi\"1qi\u0007a\u0001\u0003\u0003\n\u0011d\u0019:fCR,\u0017I\u001c3WKJLg-_\"p]:,7\r^5p]R\u0019Q.!1\t\u0011\u001dc\u0002\u0013!a\u0001\u0003\u0003\n1e\u0019:fCR,\u0017I\u001c3WKJLg-_\"p]:,7\r^5p]\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002H*\"\u0011\u0011IAG\u0003A1XM]5gs\u000e{gN\\3di&|g\u000eF\u0002n\u0003\u001bDq!a4\u001f\u0001\u0004\t),\u0001\u0004t_\u000e\\W\r^\u0001\u0015m\u0016\u0014\u0018NZ=NCb\u001cuN\u001c8fGRLwN\\:\u0015\u000b5\f).!7\t\r\u0005]w\u00041\u00017\u00039i\u0017\r_\"p]:,7\r^5p]NDq!a7 \u0001\u0004\ti.\u0001\nd_:tWm\u0019;XSRDg)Y5mkJ,\u0007\u0003B\u001c\u0002`6L1!!99\u0005%1UO\\2uS>t\u0007'\u0001\td_:tWm\u0019;B]\u00124VM]5gsR\u0019Q.a:\t\r\u001d\u0003\u0003\u0019AA!\u0003Y9\u0018-\u001b;G_J\u001cuN\u001c8fGRLwN\\\"pk:$HcA7\u0002n\"1\u0011q^\u0011A\u0002Y\nq#\u001a=qK\u000e$X\rZ\"p]:,7\r^5p]\u000e{WO\u001c;\u0002)Y,'/\u001b4z\u0007>tg.Z2uS>t'+\u0019;f)\u001di\u0017Q_A}\u0003{Da!a>#\u0001\u00041\u0014!E7j]\u000e{gN\\3di&|gNU1uK\"1\u00111 \u0012A\u0002Y\n\u0011#\\1y\u0007>tg.Z2uS>t'+\u0019;f\u0011\u00199%\u00051\u0001\u0002B\u0001")
public class DynamicConnectionQuotaTest
extends BaseRequestTest {
    private final String topic;
    private final ListenerName listener = ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT);
    private final InetAddress localAddress = InetAddress.getByName("127.0.0.1");
    private final int plaintextListenerDefaultQuota;
    private ExecutorService executor;

    @Override
    public int brokerCount() {
        return 1;
    }

    public String topic() {
        return this.topic;
    }

    public ListenerName listener() {
        return this.listener;
    }

    public InetAddress localAddress() {
        return this.localAddress;
    }

    public int plaintextListenerDefaultQuota() {
        return this.plaintextListenerDefaultQuota;
    }

    public ExecutorService executor() {
        return this.executor;
    }

    public void executor_$eq(ExecutorService x$1) {
        this.executor = x$1;
    }

    @Override
    public void brokerPropertyOverrides(Properties properties) {
        properties.put(KafkaConfig$.MODULE$.NumQuotaSamplesProp(), "2".toString());
        properties.put("listener.name.plaintext.max.connection.creation.rate", ((Object)BoxesRunTime.boxToInteger((int)this.plaintextListenerDefaultQuota())).toString());
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        TestUtils$.MODULE$.createTopic(this.zkClient(), this.topic(), this.brokerCount(), this.brokerCount(), (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
    }

    @Override
    @After
    public void tearDown() {
        try {
            if (this.executor() != null) {
                this.executor().shutdownNow();
                Assert.assertTrue((boolean)this.executor().awaitTermination(10L, TimeUnit.SECONDS));
            }
        }
        finally {
            super.tearDown();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDynamicConnectionQuota() {
        int maxConnectionsPerIP = 5;
        Properties props = new Properties();
        props.put(KafkaConfig$.MODULE$.MaxConnectionsPerIpProp(), ((Object)BoxesRunTime.boxToInteger((int)maxConnectionsPerIP)).toString());
        this.reconfigureServers(props, false, (Tuple2<String, String>)new Tuple2((Object)KafkaConfig$.MODULE$.MaxConnectionsPerIpProp(), (Object)((Object)BoxesRunTime.boxToInteger((int)maxConnectionsPerIP)).toString()));
        JFunction0.mcV.sp & Serializable & scala.Serializable verifyMaxConnections_connectWithFailure = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.connectAndVerify$1();
        int verifyMaxConnections_initialConnectionCount = this.connectionCount();
        int n = this.connectionCount();
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        IndexedSeq verifyMaxConnections_conns = (IndexedSeq)RichInt$.MODULE$.until$extension0(n, maxConnectionsPerIP - 1).map((Function1 & Serializable & scala.Serializable)x$12 -> this.connect("PLAINTEXT"), IndexedSeq$.MODULE$.canBuildFrom());
        this.createAndVerifyConnection(this.createAndVerifyConnection$default$1());
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long verifyMaxConnections_waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DynamicConnectionQuotaTest.$anonfun$verifyMaxConnections$2(this, maxConnectionsPerIP)) {
            void verifyMaxConnections_waitUntilTrue_pause;
            void verifyMaxConnections_waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > verifyMaxConnections_waitUntilTrue_startTime + verifyMaxConnections_waitUntilTrue_waitTimeMs) {
                throw Assertions$.MODULE$.fail(DynamicConnectionQuotaTest.$anonfun$verifyMaxConnections$3(), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 847));
            }
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension((long)verifyMaxConnections_waitUntilTrue_waitTimeMs, (long)verifyMaxConnections_waitUntilTrue_pause));
        }
        verifyMaxConnections_conns = (IndexedSeq)verifyMaxConnections_conns.$colon$plus((Object)this.connect("PLAINTEXT"), IndexedSeq$.MODULE$.canBuildFrom());
        Assertions$.MODULE$.intercept((Function0)verifyMaxConnections_connectWithFailure, ClassTag$.MODULE$.apply(IOException.class), new Position("DynamicConnectionQuotaTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 311));
        ((Socket)verifyMaxConnections_conns.head()).close();
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long verifyMaxConnections_waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!DynamicConnectionQuotaTest.$anonfun$verifyMaxConnections$4(this, maxConnectionsPerIP)) {
            void verifyMaxConnections_waitUntilTrue_pause;
            void verifyMaxConnections_waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > verifyMaxConnections_waitUntilTrue_startTime2 + verifyMaxConnections_waitUntilTrue_waitTimeMs) {
                throw Assertions$.MODULE$.fail(DynamicConnectionQuotaTest.$anonfun$verifyMaxConnections$5(), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 847));
            }
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension((long)verifyMaxConnections_waitUntilTrue_waitTimeMs, (long)verifyMaxConnections_waitUntilTrue_pause));
        }
        this.createAndVerifyConnection(this.createAndVerifyConnection$default$1());
        verifyMaxConnections_conns.foreach((Function1 & Serializable & scala.Serializable)x$13 -> {
            x$13.close();
            return BoxedUnit.UNIT;
        });
        long l5 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l6 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long verifyMaxConnections_waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!DynamicConnectionQuotaTest.$anonfun$verifyMaxConnections$7(this, verifyMaxConnections_initialConnectionCount)) {
            void verifyMaxConnections_waitUntilTrue_pause;
            void verifyMaxConnections_waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > verifyMaxConnections_waitUntilTrue_startTime3 + verifyMaxConnections_waitUntilTrue_waitTimeMs) {
                throw Assertions$.MODULE$.fail(DynamicConnectionQuotaTest.$anonfun$verifyMaxConnections$8(), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 847));
            }
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension((long)verifyMaxConnections_waitUntilTrue_waitTimeMs, (long)verifyMaxConnections_waitUntilTrue_pause));
        }
        int maxConnectionsPerIPOverride = 7;
        props.put(KafkaConfig$.MODULE$.MaxConnectionsPerIpOverridesProp(), new StringBuilder(10).append("localhost:").append(maxConnectionsPerIPOverride).toString());
        this.reconfigureServers(props, false, (Tuple2<String, String>)new Tuple2((Object)KafkaConfig$.MODULE$.MaxConnectionsPerIpOverridesProp(), (Object)new StringBuilder(10).append("localhost:").append(maxConnectionsPerIPOverride).toString()));
        JFunction0.mcV.sp & Serializable & scala.Serializable verifyMaxConnections_connectWithFailure2 = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.connectAndVerify$1();
        int verifyMaxConnections_initialConnectionCount2 = this.connectionCount();
        int n2 = this.connectionCount();
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        IndexedSeq verifyMaxConnections_conns2 = (IndexedSeq)RichInt$.MODULE$.until$extension0(n2, maxConnectionsPerIPOverride - 1).map((Function1 & Serializable & scala.Serializable)x$12 -> this.connect("PLAINTEXT"), IndexedSeq$.MODULE$.canBuildFrom());
        this.createAndVerifyConnection(this.createAndVerifyConnection$default$1());
        long l7 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l8 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long verifyMaxConnections_waitUntilTrue_startTime4 = System.currentTimeMillis();
        while (!DynamicConnectionQuotaTest.$anonfun$verifyMaxConnections$2(this, maxConnectionsPerIPOverride)) {
            void verifyMaxConnections_waitUntilTrue_pause;
            void verifyMaxConnections_waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > verifyMaxConnections_waitUntilTrue_startTime4 + verifyMaxConnections_waitUntilTrue_waitTimeMs) {
                throw Assertions$.MODULE$.fail(DynamicConnectionQuotaTest.$anonfun$verifyMaxConnections$3(), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 847));
            }
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension((long)verifyMaxConnections_waitUntilTrue_waitTimeMs, (long)verifyMaxConnections_waitUntilTrue_pause));
        }
        verifyMaxConnections_conns2 = (IndexedSeq)verifyMaxConnections_conns2.$colon$plus((Object)this.connect("PLAINTEXT"), IndexedSeq$.MODULE$.canBuildFrom());
        Assertions$.MODULE$.intercept((Function0)verifyMaxConnections_connectWithFailure2, ClassTag$.MODULE$.apply(IOException.class), new Position("DynamicConnectionQuotaTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 311));
        ((Socket)verifyMaxConnections_conns2.head()).close();
        long l9 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l10 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long verifyMaxConnections_waitUntilTrue_startTime5 = System.currentTimeMillis();
        while (!DynamicConnectionQuotaTest.$anonfun$verifyMaxConnections$4(this, maxConnectionsPerIPOverride)) {
            void verifyMaxConnections_waitUntilTrue_pause;
            void verifyMaxConnections_waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > verifyMaxConnections_waitUntilTrue_startTime5 + verifyMaxConnections_waitUntilTrue_waitTimeMs) {
                throw Assertions$.MODULE$.fail(DynamicConnectionQuotaTest.$anonfun$verifyMaxConnections$5(), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 847));
            }
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension((long)verifyMaxConnections_waitUntilTrue_waitTimeMs, (long)verifyMaxConnections_waitUntilTrue_pause));
        }
        this.createAndVerifyConnection(this.createAndVerifyConnection$default$1());
        verifyMaxConnections_conns2.foreach((Function1 & Serializable & scala.Serializable)x$13 -> {
            x$13.close();
            return BoxedUnit.UNIT;
        });
        long l11 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l12 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long verifyMaxConnections_waitUntilTrue_startTime6 = System.currentTimeMillis();
        while (!DynamicConnectionQuotaTest.$anonfun$verifyMaxConnections$7(this, verifyMaxConnections_initialConnectionCount2)) {
            void verifyMaxConnections_waitUntilTrue_pause;
            void verifyMaxConnections_waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > verifyMaxConnections_waitUntilTrue_startTime6 + verifyMaxConnections_waitUntilTrue_waitTimeMs) {
                throw Assertions$.MODULE$.fail(DynamicConnectionQuotaTest.$anonfun$verifyMaxConnections$8(), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 847));
            }
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension((long)verifyMaxConnections_waitUntilTrue_waitTimeMs, (long)verifyMaxConnections_waitUntilTrue_pause));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDynamicListenerConnectionQuota() {
        void verifyMaxConnections_connectWithFailure;
        int initialConnectionCount = this.connectionCount();
        Properties props = new Properties();
        props.put(KafkaConfig$.MODULE$.MaxConnectionsProp(), "5");
        this.reconfigureServers(props, false, (Tuple2<String, String>)new Tuple2((Object)KafkaConfig$.MODULE$.MaxConnectionsProp(), (Object)"5"));
        JFunction0.mcV.sp & Serializable & scala.Serializable intersect = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.connectAndVerify$2();
        int verifyMaxConnections_maxConnections = 5;
        int verifyMaxConnections_initialConnectionCount = this.connectionCount();
        int n = this.connectionCount();
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        IndexedSeq verifyMaxConnections_conns = (IndexedSeq)RichInt$.MODULE$.until$extension0(n, verifyMaxConnections_maxConnections - 1).map((Function1 & Serializable & scala.Serializable)x$12 -> this.connect("PLAINTEXT"), IndexedSeq$.MODULE$.canBuildFrom());
        this.createAndVerifyConnection(this.createAndVerifyConnection$default$1());
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long verifyMaxConnections_waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DynamicConnectionQuotaTest.$anonfun$verifyMaxConnections$2(this, verifyMaxConnections_maxConnections)) {
            void verifyMaxConnections_waitUntilTrue_pause;
            void verifyMaxConnections_waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > verifyMaxConnections_waitUntilTrue_startTime + verifyMaxConnections_waitUntilTrue_waitTimeMs) {
                throw Assertions$.MODULE$.fail(DynamicConnectionQuotaTest.$anonfun$verifyMaxConnections$3(), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 847));
            }
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension((long)verifyMaxConnections_waitUntilTrue_waitTimeMs, (long)verifyMaxConnections_waitUntilTrue_pause));
        }
        verifyMaxConnections_conns = (IndexedSeq)verifyMaxConnections_conns.$colon$plus((Object)this.connect("PLAINTEXT"), IndexedSeq$.MODULE$.canBuildFrom());
        Assertions$.MODULE$.intercept((Function0)verifyMaxConnections_connectWithFailure, ClassTag$.MODULE$.apply(IOException.class), new Position("DynamicConnectionQuotaTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 311));
        ((Socket)verifyMaxConnections_conns.head()).close();
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long verifyMaxConnections_waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!DynamicConnectionQuotaTest.$anonfun$verifyMaxConnections$4(this, verifyMaxConnections_maxConnections)) {
            void verifyMaxConnections_waitUntilTrue_pause;
            void verifyMaxConnections_waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > verifyMaxConnections_waitUntilTrue_startTime2 + verifyMaxConnections_waitUntilTrue_waitTimeMs) {
                throw Assertions$.MODULE$.fail(DynamicConnectionQuotaTest.$anonfun$verifyMaxConnections$5(), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 847));
            }
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension((long)verifyMaxConnections_waitUntilTrue_waitTimeMs, (long)verifyMaxConnections_waitUntilTrue_pause));
        }
        this.createAndVerifyConnection(this.createAndVerifyConnection$default$1());
        verifyMaxConnections_conns.foreach((Function1 & Serializable & scala.Serializable)x$13 -> {
            x$13.close();
            return BoxedUnit.UNIT;
        });
        long l5 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l6 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long verifyMaxConnections_waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!DynamicConnectionQuotaTest.$anonfun$verifyMaxConnections$7(this, verifyMaxConnections_initialConnectionCount)) {
            void verifyMaxConnections_waitUntilTrue_pause;
            void verifyMaxConnections_waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > verifyMaxConnections_waitUntilTrue_startTime3 + verifyMaxConnections_waitUntilTrue_waitTimeMs) {
                throw Assertions$.MODULE$.fail(DynamicConnectionQuotaTest.$anonfun$verifyMaxConnections$8(), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 847));
            }
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension((long)verifyMaxConnections_waitUntilTrue_waitTimeMs, (long)verifyMaxConnections_waitUntilTrue_pause));
        }
        String newListeners = "PLAINTEXT://localhost:0,INTERNAL://localhost:0";
        props.put(KafkaConfig$.MODULE$.ListenersProp(), newListeners);
        props.put(KafkaConfig$.MODULE$.ListenerSecurityProtocolMapProp(), "PLAINTEXT:PLAINTEXT,INTERNAL:PLAINTEXT");
        props.put(KafkaConfig$.MODULE$.MaxConnectionsProp(), "10");
        props.put("listener.name.internal.max.connections", "5");
        props.put("listener.name.plaintext.max.connections", "5");
        this.reconfigureServers(props, true, (Tuple2<String, String>)new Tuple2((Object)KafkaConfig$.MODULE$.ListenersProp(), (Object)newListeners));
        this.waitForListener("INTERNAL");
        int n2 = this.connectionCount();
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        IndexedSeq conns = (IndexedSeq)RichInt$.MODULE$.until$extension0(n2, 5).map((Function1 & Serializable & scala.Serializable)x$1 -> this.connect("PLAINTEXT"), IndexedSeq$.MODULE$.canBuildFrom());
        int n3 = 5;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        conns = (IndexedSeq)conns.$plus$plus((GenTraversableOnce)RichInt$.MODULE$.until$extension0(n3, 10).map((Function1 & Serializable & scala.Serializable)x$2 -> this.connect("INTERNAL"), IndexedSeq$.MODULE$.canBuildFrom()), IndexedSeq$.MODULE$.canBuildFrom());
        conns.foreach((Function1 & Serializable & scala.Serializable)socket -> {
            this.verifyConnection(socket);
            return BoxedUnit.UNIT;
        });
        conns.foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
            x$3.close();
            return BoxedUnit.UNIT;
        });
        long l7 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l8 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DynamicConnectionQuotaTest.$anonfun$testDynamicListenerConnectionQuota$6(this, initialConnectionCount)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                throw Assertions$.MODULE$.fail(DynamicConnectionQuotaTest.$anonfun$testDynamicListenerConnectionQuota$7(), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 847));
            }
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension((long)waitUntilTrue_waitTimeMs, (long)waitUntilTrue_pause));
        }
        int maxConnectionsPlaintext = 7;
        String listenerProp = new StringBuilder(0).append(this.listener().configPrefix()).append(KafkaConfig$.MODULE$.MaxConnectionsProp()).toString();
        props.put(listenerProp, ((Object)BoxesRunTime.boxToInteger((int)maxConnectionsPlaintext)).toString());
        this.reconfigureServers(props, true, (Tuple2<String, String>)new Tuple2((Object)listenerProp, (Object)((Object)BoxesRunTime.boxToInteger((int)maxConnectionsPlaintext)).toString()));
        JFunction0.mcV.sp & Serializable & scala.Serializable verifyMaxConnections_connectWithFailure2 = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.connectAndVerify$2();
        int verifyMaxConnections_initialConnectionCount2 = this.connectionCount();
        int n4 = this.connectionCount();
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        IndexedSeq verifyMaxConnections_conns2 = (IndexedSeq)RichInt$.MODULE$.until$extension0(n4, maxConnectionsPlaintext - 1).map((Function1 & Serializable & scala.Serializable)x$12 -> this.connect("PLAINTEXT"), IndexedSeq$.MODULE$.canBuildFrom());
        this.createAndVerifyConnection(this.createAndVerifyConnection$default$1());
        long l9 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l10 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long verifyMaxConnections_waitUntilTrue_startTime4 = System.currentTimeMillis();
        while (!DynamicConnectionQuotaTest.$anonfun$verifyMaxConnections$2(this, maxConnectionsPlaintext)) {
            void verifyMaxConnections_waitUntilTrue_pause;
            void verifyMaxConnections_waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > verifyMaxConnections_waitUntilTrue_startTime4 + verifyMaxConnections_waitUntilTrue_waitTimeMs) {
                throw Assertions$.MODULE$.fail(DynamicConnectionQuotaTest.$anonfun$verifyMaxConnections$3(), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 847));
            }
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension((long)verifyMaxConnections_waitUntilTrue_waitTimeMs, (long)verifyMaxConnections_waitUntilTrue_pause));
        }
        verifyMaxConnections_conns2 = (IndexedSeq)verifyMaxConnections_conns2.$colon$plus((Object)this.connect("PLAINTEXT"), IndexedSeq$.MODULE$.canBuildFrom());
        Assertions$.MODULE$.intercept((Function0)verifyMaxConnections_connectWithFailure2, ClassTag$.MODULE$.apply(IOException.class), new Position("DynamicConnectionQuotaTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 311));
        ((Socket)verifyMaxConnections_conns2.head()).close();
        long l11 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l12 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long verifyMaxConnections_waitUntilTrue_startTime5 = System.currentTimeMillis();
        while (!DynamicConnectionQuotaTest.$anonfun$verifyMaxConnections$4(this, maxConnectionsPlaintext)) {
            void verifyMaxConnections_waitUntilTrue_pause;
            void verifyMaxConnections_waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > verifyMaxConnections_waitUntilTrue_startTime5 + verifyMaxConnections_waitUntilTrue_waitTimeMs) {
                throw Assertions$.MODULE$.fail(DynamicConnectionQuotaTest.$anonfun$verifyMaxConnections$5(), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 847));
            }
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension((long)verifyMaxConnections_waitUntilTrue_waitTimeMs, (long)verifyMaxConnections_waitUntilTrue_pause));
        }
        this.createAndVerifyConnection(this.createAndVerifyConnection$default$1());
        verifyMaxConnections_conns2.foreach((Function1 & Serializable & scala.Serializable)x$13 -> {
            x$13.close();
            return BoxedUnit.UNIT;
        });
        long l13 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l14 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long verifyMaxConnections_waitUntilTrue_startTime6 = System.currentTimeMillis();
        while (!DynamicConnectionQuotaTest.$anonfun$verifyMaxConnections$7(this, verifyMaxConnections_initialConnectionCount2)) {
            void verifyMaxConnections_waitUntilTrue_pause;
            void verifyMaxConnections_waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > verifyMaxConnections_waitUntilTrue_startTime6 + verifyMaxConnections_waitUntilTrue_waitTimeMs) {
                throw Assertions$.MODULE$.fail(DynamicConnectionQuotaTest.$anonfun$verifyMaxConnections$8(), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 847));
            }
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension((long)verifyMaxConnections_waitUntilTrue_waitTimeMs, (long)verifyMaxConnections_waitUntilTrue_pause));
        }
        int n5 = this.connectionCount();
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        IndexedSeq plaintextConnections = (IndexedSeq)RichInt$.MODULE$.until$extension0(n5, maxConnectionsPlaintext).map((Function1 & Serializable & scala.Serializable)x$4 -> this.connect("PLAINTEXT"), IndexedSeq$.MODULE$.canBuildFrom());
        this.executor_$eq(Executors.newSingleThreadExecutor());
        Future<?> future = this.executor().submit(() -> this.createAndVerifyConnection(this.createAndVerifyConnection$default$1()));
        Thread.sleep(100L);
        Assert.assertFalse((boolean)future.isDone());
        ((Socket)plaintextConnections.head()).close();
        future.get(30L, TimeUnit.SECONDS);
        plaintextConnections.foreach((Function1 & Serializable & scala.Serializable)x$5 -> {
            x$5.close();
            return BoxedUnit.UNIT;
        });
        long l15 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l16 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!DynamicConnectionQuotaTest.$anonfun$testDynamicListenerConnectionQuota$12(this, initialConnectionCount)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                throw Assertions$.MODULE$.fail(DynamicConnectionQuotaTest.$anonfun$testDynamicListenerConnectionQuota$13(), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 847));
            }
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension((long)waitUntilTrue_waitTimeMs, (long)waitUntilTrue_pause));
        }
        int n6 = this.connectionCount();
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        IndexedSeq plaintextConns = (IndexedSeq)RichInt$.MODULE$.until$extension0(n6, 5).map((Function1 & Serializable & scala.Serializable)x$6 -> this.connect("PLAINTEXT"), IndexedSeq$.MODULE$.canBuildFrom());
        int n7 = 5;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        IndexedSeq internalConns = (IndexedSeq)RichInt$.MODULE$.until$extension0(n7, 10).map((Function1 & Serializable & scala.Serializable)x$7 -> this.connect("INTERNAL"), IndexedSeq$.MODULE$.canBuildFrom());
        plaintextConns.foreach((Function1 & Serializable & scala.Serializable)socket -> {
            this.verifyConnection(socket);
            return BoxedUnit.UNIT;
        });
        internalConns.foreach((Function1 & Serializable & scala.Serializable)socket -> {
            this.verifyConnection(socket);
            return BoxedUnit.UNIT;
        });
        int n8 = 0;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        plaintextConns = (IndexedSeq)plaintextConns.$plus$plus((GenTraversableOnce)RichInt$.MODULE$.until$extension0(n8, 2).map((Function1 & Serializable & scala.Serializable)x$8 -> this.connect("PLAINTEXT"), IndexedSeq$.MODULE$.canBuildFrom()), IndexedSeq$.MODULE$.canBuildFrom());
        long l17 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l18 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!DynamicConnectionQuotaTest.$anonfun$testDynamicListenerConnectionQuota$19(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs) {
                throw Assertions$.MODULE$.fail(DynamicConnectionQuotaTest.$anonfun$testDynamicListenerConnectionQuota$20(), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 847));
            }
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension((long)waitUntilTrue_waitTimeMs, (long)waitUntilTrue_pause));
        }
        plaintextConns.foreach((Function1 & Serializable & scala.Serializable)socket -> {
            this.verifyConnection(socket);
            return BoxedUnit.UNIT;
        });
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> internalConns.foreach((Function1 & Serializable & scala.Serializable)socket -> (ProduceResponse)this.sendAndReceive((AbstractRequest)this.produceRequest(), (Socket)socket, this.sendAndReceive$default$3(), this.sendAndReceive$default$4(), ClassTag$.MODULE$.apply(ProduceResponse.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals()))), ClassTag$.MODULE$.apply(IOException.class), new Position("DynamicConnectionQuotaTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 164));
        plaintextConns.foreach((Function1 & Serializable & scala.Serializable)x$9 -> {
            x$9.close();
            return BoxedUnit.UNIT;
        });
        internalConns.foreach((Function1 & Serializable & scala.Serializable)x$10 -> {
            x$10.close();
            return BoxedUnit.UNIT;
        });
        long l19 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l20 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime4 = System.currentTimeMillis();
        while (!DynamicConnectionQuotaTest.$anonfun$testDynamicListenerConnectionQuota$26(this, initialConnectionCount)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime4 + waitUntilTrue_waitTimeMs) {
                throw Assertions$.MODULE$.fail(DynamicConnectionQuotaTest.$anonfun$testDynamicListenerConnectionQuota$27(), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 847));
            }
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension((long)waitUntilTrue_waitTimeMs, (long)waitUntilTrue_pause));
        }
    }

    @Test
    public void testDynamicListenerConnectionCreationRateQuota() {
        .colon.colon newListenerNames = new .colon.colon((Object)"PLAINTEXT", (List)new .colon.colon((Object)"EXTERNAL", (List)Nil$.MODULE$));
        String newListeners = "PLAINTEXT://localhost:0,EXTERNAL://localhost:0";
        Properties props = new Properties();
        props.put(KafkaConfig$.MODULE$.ListenersProp(), newListeners);
        props.put(KafkaConfig$.MODULE$.ListenerSecurityProtocolMapProp(), "PLAINTEXT:PLAINTEXT,EXTERNAL:PLAINTEXT");
        this.reconfigureServers(props, true, (Tuple2<String, String>)new Tuple2((Object)KafkaConfig$.MODULE$.ListenersProp(), (Object)newListeners));
        this.waitForListener("EXTERNAL");
        int initialConnectionCount = this.connectionCount();
        int connRateLimit = 9;
        this.verifyConnectionRate(2 * connRateLimit, this.plaintextListenerDefaultQuota(), "PLAINTEXT");
        this.waitForConnectionCount(initialConnectionCount);
        props.clear();
        props.put(KafkaConfig$.MODULE$.MaxConnectionCreationRateProp(), ((Object)BoxesRunTime.boxToInteger((int)connRateLimit)).toString());
        this.reconfigureServers(props, false, (Tuple2<String, String>)new Tuple2((Object)KafkaConfig$.MODULE$.MaxConnectionCreationRateProp(), (Object)((Object)BoxesRunTime.boxToInteger((int)connRateLimit)).toString()));
        this.verifyConnectionRate(8, connRateLimit, "EXTERNAL");
        this.waitForConnectionCount(initialConnectionCount);
        int listenerConnRateLimit = 4;
        String plaintextListenerProp = new StringBuilder(0).append(this.listener().configPrefix()).append(KafkaConfig$.MODULE$.MaxConnectionCreationRateProp()).toString();
        props.put(new StringBuilder(23).append("listener.name.external.").append(KafkaConfig$.MODULE$.MaxConnectionCreationRateProp()).toString(), ((Object)BoxesRunTime.boxToInteger((int)listenerConnRateLimit)).toString());
        props.put(plaintextListenerProp, ((Object)BoxesRunTime.boxToInteger((int)listenerConnRateLimit)).toString());
        this.reconfigureServers(props, true, (Tuple2<String, String>)new Tuple2((Object)plaintextListenerProp, (Object)((Object)BoxesRunTime.boxToInteger((int)listenerConnRateLimit)).toString()));
        this.executor_$eq(Executors.newFixedThreadPool(newListenerNames.size()));
        ((Seq)newListenerNames.map((Function1 & Serializable & scala.Serializable)listener -> this.executor().submit(() -> this.verifyConnectionRate(3, listenerConnRateLimit, (String)listener)), Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x$11 -> x$11.get(40L, TimeUnit.SECONDS));
        this.waitForConnectionCount(initialConnectionCount);
        int newPlaintextRateLimit = 12;
        props.put(plaintextListenerProp, ((Object)BoxesRunTime.boxToInteger((int)newPlaintextRateLimit)).toString());
        this.reconfigureServers(props, true, (Tuple2<String, String>)new Tuple2((Object)plaintextListenerProp, (Object)((Object)BoxesRunTime.boxToInteger((int)newPlaintextRateLimit)).toString()));
        Future<?> plaintextFuture = this.executor().submit(() -> this.verifyConnectionRate(10, newPlaintextRateLimit, "PLAINTEXT"));
        Future<?> externalFuture = this.executor().submit(() -> this.verifyConnectionRate(3, listenerConnRateLimit, "EXTERNAL"));
        plaintextFuture.get(40L, TimeUnit.SECONDS);
        externalFuture.get(40L, TimeUnit.SECONDS);
        this.waitForConnectionCount(initialConnectionCount);
    }

    /*
     * WARNING - void declaration
     */
    private void reconfigureServers(Properties newProps, boolean perBrokerConfig, Tuple2<String, String> aPropToVerify) {
        int initialConnectionCount = this.connectionCount();
        Admin adminClient = this.createAdminClient();
        TestUtils$.MODULE$.incrementalAlterConfigs((Seq<KafkaServer>)this.servers(), adminClient, newProps, perBrokerConfig, TestUtils$.MODULE$.incrementalAlterConfigs$default$5()).all().get();
        this.waitForConfigOnServer((String)aPropToVerify._1(), (String)aPropToVerify._2(), this.waitForConfigOnServer$default$3());
        adminClient.close();
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DynamicConnectionQuotaTest.$anonfun$reconfigureServers$1(this, initialConnectionCount)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                throw Assertions$.MODULE$.fail(DynamicConnectionQuotaTest.$anonfun$reconfigureServers$2(this, initialConnectionCount), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 847));
            }
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension((long)waitUntilTrue_waitTimeMs, (long)waitUntilTrue_pause));
        }
    }

    /*
     * WARNING - void declaration
     */
    private void waitForListener(String listenerName) {
        TestUtils$ testUtils$ = TestUtils$.MODULE$;
        long l = 10000L;
        if (testUtils$ == null) {
            throw null;
        }
        TestUtils$ retry_this = testUtils$;
        LongRef retry_wait = LongRef.create((long)1L);
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                DynamicConnectionQuotaTest.$anonfun$waitForListener$1(this, listenerName);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    retry_this.logger().underlying().info(retry_this.msgWithLogIdent(TestUtils$.$anonfun$retry$1(retry_wait)));
                }
                Thread.sleep(retry_wait.elem);
                retry_wait.elem += package$.MODULE$.min(retry_wait.elem, 1000L);
                continue;
            }
            break;
        }
    }

    private Admin createAdminClient() {
        String bootstrapServers = TestUtils$.MODULE$.bootstrapServers((Seq<KafkaServer>)this.servers(), new ListenerName(this.securityProtocol().name));
        Properties config = new Properties();
        config.put("bootstrap.servers", bootstrapServers);
        config.put("metadata.max.age.ms", "10");
        return Admin.create((Properties)config);
    }

    private void waitForConfigOnServer(String propName, String propValue, long maxWaitMs) {
        TestUtils$ testUtils$ = TestUtils$.MODULE$;
        if (testUtils$ == null) {
            throw null;
        }
        TestUtils$ retry_this = testUtils$;
        LongRef retry_wait = LongRef.create((long)1L);
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                DynamicConnectionQuotaTest.$anonfun$waitForConfigOnServer$1(this, propValue, propName);
            }
            catch (AssertionError retry_e) {
                if (System.currentTimeMillis() - retry_startTime > maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    retry_this.logger().underlying().info(retry_this.msgWithLogIdent(TestUtils$.$anonfun$retry$1(retry_wait)));
                }
                Thread.sleep(retry_wait.elem);
                retry_wait.elem += package$.MODULE$.min(retry_wait.elem, 1000L);
                continue;
            }
            break;
        }
    }

    private long waitForConfigOnServer$default$3() {
        return 10000L;
    }

    /*
     * WARNING - void declaration
     */
    private ProduceRequest produceRequest() {
        void $minus$greater$extension_$this;
        TopicPartition topicPartition = new TopicPartition(this.topic(), 0);
        MemoryRecords memoryRecords = MemoryRecords.withRecords((CompressionType)CompressionType.NONE, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(System.currentTimeMillis(), "key".getBytes(), "value".getBytes())});
        Tuple2[] tuple2Array = new Tuple2[1];
        Object object = Predef$.MODULE$.ArrowAssoc((Object)topicPartition);
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)memoryRecords);
        scala.collection.immutable.Map partitionRecords = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array));
        return (ProduceRequest)ProduceRequest.Builder.forCurrentMagic((short)-1, (int)3000, (java.util.Map)((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)partitionRecords).asJava())).build();
    }

    public int connectionCount() {
        return ((KafkaServer)this.servers().head()).socketServer().connectionCount(this.localAddress());
    }

    public Socket connect(String listener) {
        ListenerName listenerName = ListenerName.normalised((String)listener);
        return new Socket("localhost", ((KafkaServer)this.servers().head()).socketServer().boundPort(listenerName));
    }

    private void createAndVerifyConnection(String listener) {
        try (Socket socket = this.connect(listener);){
            this.verifyConnection(socket);
        }
    }

    private String createAndVerifyConnection$default$1() {
        return "PLAINTEXT";
    }

    private void verifyConnection(Socket socket) {
        ProduceResponse produceResponse = (ProduceResponse)this.sendAndReceive((AbstractRequest)this.produceRequest(), socket, this.sendAndReceive$default$3(), this.sendAndReceive$default$4(), ClassTag$.MODULE$.apply(ProduceResponse.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals()));
        Assert.assertEquals((long)1L, (long)produceResponse.responses().size());
        Tuple2 tuple2 = (Tuple2)((IterableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(produceResponse.responses()).asScala()).head();
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        ProduceResponse.PartitionResponse partitionResponse = (ProduceResponse.PartitionResponse)tuple2._2();
        Assert.assertEquals((Object)Errors.NONE, (Object)partitionResponse.error);
    }

    /*
     * WARNING - void declaration
     */
    private void verifyMaxConnections(int maxConnections, Function0<BoxedUnit> connectWithFailure) {
        int initialConnectionCount = this.connectionCount();
        int n = this.connectionCount();
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        IndexedSeq conns = (IndexedSeq)RichInt$.MODULE$.until$extension0(n, maxConnections - 1).map((Function1 & Serializable & scala.Serializable)x$12 -> this.connect("PLAINTEXT"), IndexedSeq$.MODULE$.canBuildFrom());
        this.createAndVerifyConnection(this.createAndVerifyConnection$default$1());
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DynamicConnectionQuotaTest.$anonfun$verifyMaxConnections$2(this, maxConnections)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                throw Assertions$.MODULE$.fail(DynamicConnectionQuotaTest.$anonfun$verifyMaxConnections$3(), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 847));
            }
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension((long)waitUntilTrue_waitTimeMs, (long)waitUntilTrue_pause));
        }
        conns = (IndexedSeq)conns.$colon$plus((Object)this.connect("PLAINTEXT"), IndexedSeq$.MODULE$.canBuildFrom());
        Assertions$.MODULE$.intercept(connectWithFailure, ClassTag$.MODULE$.apply(IOException.class), new Position("DynamicConnectionQuotaTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 311));
        ((Socket)conns.head()).close();
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!DynamicConnectionQuotaTest.$anonfun$verifyMaxConnections$4(this, maxConnections)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                throw Assertions$.MODULE$.fail(DynamicConnectionQuotaTest.$anonfun$verifyMaxConnections$5(), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 847));
            }
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension((long)waitUntilTrue_waitTimeMs, (long)waitUntilTrue_pause));
        }
        this.createAndVerifyConnection(this.createAndVerifyConnection$default$1());
        conns.foreach((Function1 & Serializable & scala.Serializable)x$13 -> {
            x$13.close();
            return BoxedUnit.UNIT;
        });
        long l5 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l6 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!DynamicConnectionQuotaTest.$anonfun$verifyMaxConnections$7(this, initialConnectionCount)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs) {
                throw Assertions$.MODULE$.fail(DynamicConnectionQuotaTest.$anonfun$verifyMaxConnections$8(), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 847));
            }
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension((long)waitUntilTrue_waitTimeMs, (long)waitUntilTrue_pause));
        }
    }

    private void connectAndVerify(String listener) {
        try (Socket socket = this.connect(listener);){
            this.sendAndReceive((AbstractRequest)this.produceRequest(), socket, this.sendAndReceive$default$3(), this.sendAndReceive$default$4(), ClassTag$.MODULE$.apply(ProduceResponse.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals()));
        }
    }

    /*
     * WARNING - void declaration
     */
    private void waitForConnectionCount(int expectedConnectionCount) {
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DynamicConnectionQuotaTest.$anonfun$waitForConnectionCount$1(this, expectedConnectionCount)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                throw Assertions$.MODULE$.fail(DynamicConnectionQuotaTest.$anonfun$waitForConnectionCount$2(this, expectedConnectionCount), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 847));
            }
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension((long)waitUntilTrue_waitTimeMs, (long)waitUntilTrue_pause));
        }
    }

    private void verifyConnectionRate(int minConnectionRate, int maxConnectionRate, String listener) {
        long runTimeMs = TimeUnit.SECONDS.toMillis(13L);
        long startTimeMs = System.currentTimeMillis();
        long endTimeMs = startTimeMs + runTimeMs;
        int connCount = 0;
        while (System.currentTimeMillis() < endTimeMs) {
            this.connectAndVerify(listener);
            ++connCount;
        }
        long elapsedMs = System.currentTimeMillis() - startTimeMs;
        double actualRate = (double)connCount / (double)elapsedMs * (double)1000;
        double rateCap = maxConnectionRate < Integer.MAX_VALUE ? 1.2 * (double)maxConnectionRate : (double)Integer.MAX_VALUE;
        Assert.assertTrue((String)new StringBuilder(41).append("Listener ").append(listener).append(" connection rate ").append(actualRate).append(" must be below ").append(rateCap).toString(), (actualRate <= rateCap ? 1 : 0) != 0);
        Assert.assertTrue((String)new StringBuilder(41).append("Listener ").append(listener).append(" connection rate ").append(actualRate).append(" must be above ").append(minConnectionRate).toString(), (actualRate >= (double)minConnectionRate ? 1 : 0) != 0);
    }

    private final void connectAndVerify$1() {
        try (Socket socket = this.connect(this.connect$default$1(), this.connect$default$2());){
            this.sendAndReceive((AbstractRequest)this.produceRequest(), socket, this.sendAndReceive$default$3(), this.sendAndReceive$default$4(), ClassTag$.MODULE$.apply(ProduceResponse.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals()));
        }
    }

    private final void connectAndVerify$2() {
        socket.setSoTimeout(1000);
        try (Socket socket = this.connect("PLAINTEXT");){
            this.sendAndReceive((AbstractRequest)this.produceRequest(), socket, this.sendAndReceive$default$3(), this.sendAndReceive$default$4(), ClassTag$.MODULE$.apply(ProduceResponse.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals()));
        }
    }

    public static final /* synthetic */ boolean $anonfun$testDynamicListenerConnectionQuota$6(DynamicConnectionQuotaTest $this, int initialConnectionCount$1) {
        return initialConnectionCount$1 == $this.connectionCount();
    }

    public static final /* synthetic */ String $anonfun$testDynamicListenerConnectionQuota$7() {
        return "Connections not closed";
    }

    public static final /* synthetic */ boolean $anonfun$testDynamicListenerConnectionQuota$12(DynamicConnectionQuotaTest $this, int initialConnectionCount$1) {
        return initialConnectionCount$1 == $this.connectionCount();
    }

    public static final /* synthetic */ String $anonfun$testDynamicListenerConnectionQuota$13() {
        return "Connections not closed";
    }

    public static final /* synthetic */ boolean $anonfun$testDynamicListenerConnectionQuota$19(DynamicConnectionQuotaTest $this) {
        return $this.connectionCount() <= 10;
    }

    public static final /* synthetic */ String $anonfun$testDynamicListenerConnectionQuota$20() {
        return "Internal connections not closed";
    }

    public static final /* synthetic */ boolean $anonfun$testDynamicListenerConnectionQuota$26(DynamicConnectionQuotaTest $this, int initialConnectionCount$1) {
        return initialConnectionCount$1 == $this.connectionCount();
    }

    public static final /* synthetic */ String $anonfun$testDynamicListenerConnectionQuota$27() {
        return "Connections not closed";
    }

    public static final /* synthetic */ boolean $anonfun$reconfigureServers$1(DynamicConnectionQuotaTest $this, int initialConnectionCount$2) {
        return initialConnectionCount$2 == $this.connectionCount();
    }

    public static final /* synthetic */ String $anonfun$reconfigureServers$2(DynamicConnectionQuotaTest $this, int initialConnectionCount$2) {
        return new StringBuilder(59).append("Admin client connection not closed (initial = ").append(initialConnectionCount$2).append(", current = ").append($this.connectionCount()).append(")").toString();
    }

    public static final /* synthetic */ void $anonfun$waitForListener$1(DynamicConnectionQuotaTest $this, String listenerName$1) {
        try {
            Assert.assertTrue((((KafkaServer)$this.servers().head()).socketServer().boundPort(ListenerName.normalised((String)listenerName$1)) > 0 ? 1 : 0) != 0);
            return;
        }
        catch (KafkaException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static final /* synthetic */ void $anonfun$waitForConfigOnServer$1(DynamicConnectionQuotaTest $this, String propValue$1, String propName$1) {
        Assert.assertEquals((Object)propValue$1, ((KafkaServer)$this.servers().head()).config().originals().get(propName$1));
    }

    public static final /* synthetic */ boolean $anonfun$verifyMaxConnections$2(DynamicConnectionQuotaTest $this, int maxConnections$1) {
        return $this.connectionCount() == maxConnections$1 - 1;
    }

    public static final /* synthetic */ String $anonfun$verifyMaxConnections$3() {
        return "produce request connection is not closed";
    }

    public static final /* synthetic */ boolean $anonfun$verifyMaxConnections$4(DynamicConnectionQuotaTest $this, int maxConnections$1) {
        return $this.connectionCount() == maxConnections$1 - 1;
    }

    public static final /* synthetic */ String $anonfun$verifyMaxConnections$5() {
        return "connection is not closed";
    }

    public static final /* synthetic */ boolean $anonfun$verifyMaxConnections$7(DynamicConnectionQuotaTest $this, int initialConnectionCount$3) {
        return initialConnectionCount$3 == $this.connectionCount();
    }

    public static final /* synthetic */ String $anonfun$verifyMaxConnections$8() {
        return "Connections not closed";
    }

    public static final /* synthetic */ boolean $anonfun$waitForConnectionCount$1(DynamicConnectionQuotaTest $this, int expectedConnectionCount$1) {
        return expectedConnectionCount$1 == $this.connectionCount();
    }

    public static final /* synthetic */ String $anonfun$waitForConnectionCount$2(DynamicConnectionQuotaTest $this, int expectedConnectionCount$1) {
        return new StringBuilder(47).append("Connections not closed (expected = ").append(expectedConnectionCount$1).append(" current = ").append($this.connectionCount()).append(")").toString();
    }

    public DynamicConnectionQuotaTest() {
        this.topic = "test";
        this.plaintextListenerDefaultQuota = 30;
    }
}

