/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import kafka.network.RequestChannel;
import kafka.server.BaseClientQuotaManagerTest;
import kafka.server.ClientQuotaManager;
import kafka.server.ClientQuotaManagerConfig;
import kafka.server.ClientQuotaManagerConfig$;
import kafka.server.ClientRequestQuotaManager;
import kafka.server.ClientRequestQuotaManager$;
import kafka.server.QuotaType;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.Quota;
import org.apache.kafka.common.utils.Time;
import org.junit.Assert;
import org.junit.Test;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.immutable.Range;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001)2A!\u0002\u0004\u0001\u0017!)\u0001\u0003\u0001C\u0001#!91\u0003\u0001b\u0001\n\u0013!\u0002B\u0002\r\u0001A\u0003%Q\u0003C\u0003\u001a\u0001\u0011\u0005!DA\u000fDY&,g\u000e\u001e*fcV,7\u000f^)v_R\fW*\u00198bO\u0016\u0014H+Z:u\u0015\t9\u0001\"\u0001\u0004tKJ4XM\u001d\u0006\u0002\u0013\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\r!\tia\"D\u0001\u0007\u0013\tyaA\u0001\u000eCCN,7\t\\5f]R\fVo\u001c;b\u001b\u0006t\u0017mZ3s)\u0016\u001cH/\u0001\u0004=S:LGO\u0010\u000b\u0002%A\u0011Q\u0002A\u0001\u0007G>tg-[4\u0016\u0003U\u0001\"!\u0004\f\n\u0005]1!\u0001G\"mS\u0016tG/U;pi\u0006l\u0015M\\1hKJ\u001cuN\u001c4jO\u000691m\u001c8gS\u001e\u0004\u0013a\t;fgR\u0014V-];fgR\u0004VM]2f]R\fw-Z)v_R\fg+[8mCRLwN\u001c\u000b\u00027A\u0011AdH\u0007\u0002;)\ta$A\u0003tG\u0006d\u0017-\u0003\u0002!;\t!QK\\5uQ\t!!\u0005\u0005\u0002$Q5\tAE\u0003\u0002&M\u0005)!.\u001e8ji*\tq%A\u0002pe\u001eL!!\u000b\u0013\u0003\tQ+7\u000f\u001e")
public class ClientRequestQuotaManagerTest
extends BaseClientQuotaManagerTest {
    private final ClientQuotaManagerConfig config = new ClientQuotaManagerConfig(ClientQuotaManagerConfig$.MODULE$.apply$default$1(), ClientQuotaManagerConfig$.MODULE$.apply$default$2(), ClientQuotaManagerConfig$.MODULE$.apply$default$3());

    private ClientQuotaManagerConfig config() {
        return this.config;
    }

    @Test
    public void testRequestPercentageQuotaViolation() {
        ClientRequestQuotaManager clientRequestQuotaManager = new ClientRequestQuotaManager(this.config(), this.metrics(), (Time)this.time(), "", (Option)None$.MODULE$);
        clientRequestQuotaManager.updateQuota((Option)new Some((Object)"ANONYMOUS"), (Option)new Some((Object)"test-client"), (Option)new Some((Object)"test-client"), (Option)new Some((Object)Quota.upperBound((double)1.0)));
        KafkaMetric queueSizeMetric = (KafkaMetric)this.metrics().metrics().get(this.metrics().metricName("queue-size", QuotaType.Request$.MODULE$.toString(), ""));
        try {
            int n = 0;
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Range range = RichInt$.MODULE$.until$extension0(n, 10);
            if (range == null) {
                throw null;
            }
            Range foreach$mVc$sp_this = range;
            if (!foreach$mVc$sp_this.isEmpty()) {
                int foreach$mVc$sp_i = foreach$mVc$sp_this.start();
                while (true) {
                    ClientRequestQuotaManagerTest.$anonfun$testRequestPercentageQuotaViolation$1(this, clientRequestQuotaManager, foreach$mVc$sp_i);
                    if (foreach$mVc$sp_i == foreach$mVc$sp_this.scala$collection$immutable$Range$$lastElement()) break;
                    foreach$mVc$sp_i += foreach$mVc$sp_this.step();
                }
            }
            Assert.assertEquals((long)0L, (long)((int)BoxesRunTime.unboxToDouble((Object)queueSizeMetric.metricValue())));
            this.time().sleep(500L);
            int throttleTime = this.maybeRecord((ClientQuotaManager)clientRequestQuotaManager, "ANONYMOUS", "test-client", ClientRequestQuotaManagerTest.millisToPercent$1(67.1));
            Assert.assertEquals((String)"Should be throttled", (long)210L, (long)throttleTime);
            this.throttle((ClientQuotaManager)clientRequestQuotaManager, "ANONYMOUS", "test-client", throttleTime, (Function1<RequestChannel.Response, BoxedUnit>)(Function1 & Serializable & scala.Serializable)response -> {
                this.callback(response);
                return BoxedUnit.UNIT;
            });
            Assert.assertEquals((long)1L, (long)((int)BoxesRunTime.unboxToDouble((Object)queueSizeMetric.metricValue())));
            clientRequestQuotaManager.throttledChannelReaper().doWork();
            Assert.assertEquals((long)0L, (long)this.numCallbacks());
            this.time().sleep((long)throttleTime);
            clientRequestQuotaManager.throttledChannelReaper().doWork();
            Assert.assertEquals((long)0L, (long)((int)BoxesRunTime.unboxToDouble((Object)queueSizeMetric.metricValue())));
            Assert.assertEquals((long)1L, (long)this.numCallbacks());
            int n2 = 0;
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Range range2 = RichInt$.MODULE$.until$extension0(n2, 11);
            if (range2 == null) {
                throw null;
            }
            Range foreach$mVc$sp_this2 = range2;
            if (!foreach$mVc$sp_this2.isEmpty()) {
                int foreach$mVc$sp_i = foreach$mVc$sp_this2.start();
                while (true) {
                    ClientRequestQuotaManagerTest.$anonfun$testRequestPercentageQuotaViolation$3(this, clientRequestQuotaManager, foreach$mVc$sp_i);
                    if (foreach$mVc$sp_i == foreach$mVc$sp_this2.scala$collection$immutable$Range$$lastElement()) break;
                    foreach$mVc$sp_i += foreach$mVc$sp_this2.step();
                }
            }
            Assert.assertEquals((String)"Should be unthrottled since bursty sample has rolled over", (long)0L, (long)this.maybeRecord((ClientQuotaManager)clientRequestQuotaManager, "ANONYMOUS", "test-client", 0.0));
            Assert.assertEquals((long)1000L, (long)this.maybeRecord((ClientQuotaManager)clientRequestQuotaManager, "ANONYMOUS", "test-client", ClientRequestQuotaManagerTest.millisToPercent$1(500.0)));
            int n3 = 0;
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Range range3 = RichInt$.MODULE$.until$extension0(n3, 10);
            if (range3 == null) {
                throw null;
            }
            Range foreach$mVc$sp_this3 = range3;
            if (!foreach$mVc$sp_this3.isEmpty()) {
                int foreach$mVc$sp_i = foreach$mVc$sp_this3.start();
                while (true) {
                    ClientRequestQuotaManagerTest.$anonfun$testRequestPercentageQuotaViolation$4(this, clientRequestQuotaManager, foreach$mVc$sp_i);
                    if (foreach$mVc$sp_i == foreach$mVc$sp_this3.scala$collection$immutable$Range$$lastElement()) break;
                    foreach$mVc$sp_i += foreach$mVc$sp_this3.step();
                }
            }
            this.time().sleep(1000L);
            Assert.assertEquals((String)"Should be unthrottled since bursty sample has rolled over", (long)0L, (long)this.maybeRecord((ClientQuotaManager)clientRequestQuotaManager, "ANONYMOUS", "test-client", 0.0));
        }
        finally {
            clientRequestQuotaManager.shutdown();
        }
    }

    private static final double millisToPercent$1(double millis) {
        return millis * (double)1000 * (double)1000 * ClientRequestQuotaManager$.MODULE$.NanosToPercentagePerSecond();
    }

    public static final /* synthetic */ void $anonfun$testRequestPercentageQuotaViolation$1(ClientRequestQuotaManagerTest $this, ClientRequestQuotaManager clientRequestQuotaManager$1, int _) {
        Assert.assertEquals((long)0L, (long)$this.maybeRecord((ClientQuotaManager)clientRequestQuotaManager$1, "ANONYMOUS", "test-client", ClientRequestQuotaManagerTest.millisToPercent$1(4.0)));
        $this.time().sleep(1000L);
    }

    public static final /* synthetic */ void $anonfun$testRequestPercentageQuotaViolation$3(ClientRequestQuotaManagerTest $this, ClientRequestQuotaManager clientRequestQuotaManager$1, int _) {
        $this.maybeRecord((ClientQuotaManager)clientRequestQuotaManager$1, "ANONYMOUS", "test-client", ClientRequestQuotaManagerTest.millisToPercent$1(4.0));
        $this.time().sleep(1000L);
    }

    public static final /* synthetic */ void $anonfun$testRequestPercentageQuotaViolation$4(ClientRequestQuotaManagerTest $this, ClientRequestQuotaManager clientRequestQuotaManager$1, int _) {
        $this.time().sleep(1000L);
        Assert.assertEquals((long)1000L, (long)$this.maybeRecord((ClientQuotaManager)clientRequestQuotaManager$1, "ANONYMOUS", "test-client", 0.0));
    }
}

