/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.util.Optional;
import kafka.api.Request$;
import kafka.cluster.BrokerEndPoint;
import kafka.cluster.Partition;
import kafka.log.Log;
import kafka.log.LogManager;
import kafka.server.AbstractFetcherThread;
import kafka.server.BrokerTopicStats;
import kafka.server.FailedPartitions;
import kafka.server.FetchPartitionData;
import kafka.server.Fetching$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.OffsetAndEpoch;
import kafka.server.PartitionFetchState;
import kafka.server.PartitionFetchState$;
import kafka.server.QuotaFactory;
import kafka.server.ReplicaAlterLogDirsThread;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaQuota;
import kafka.server.ReplicaState;
import kafka.server.ReplicationQuotaManager;
import kafka.server.Truncating$;
import kafka.utils.DelayedItem;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.IsolationLevel;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.requests.EpochEndOffset;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.OffsetsForLeaderEpochRequest;
import org.easymock.Capture;
import org.easymock.CaptureType;
import org.easymock.EasyMock;
import org.easymock.IExpectationSetters;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.Set;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range;
import scala.collection.mutable.MapLike;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\u0005-f\u0001B\r\u001b\u0001}AQA\n\u0001\u0005\u0002\u001dBqA\u000b\u0001C\u0002\u0013%1\u0006\u0003\u00048\u0001\u0001\u0006I\u0001\f\u0005\bq\u0001\u0011\r\u0011\"\u0003,\u0011\u0019I\u0004\u0001)A\u0005Y!9!\b\u0001b\u0001\n\u0013Y\u0004BB \u0001A\u0003%A\bC\u0003A\u0001\u0011%\u0011\tC\u0004P\u0001E\u0005I\u0011\u0002)\t\u000bm\u0003A\u0011\u0001/\t\u000b\u001d\u0004A\u0011\u0001/\t\u000b%\u0004A\u0011\u0001/\t\u000b-\u0004A\u0011\u00027\t\r\u0005U\u0001\u0001\"\u0001]\u0011\u0019\tI\u0002\u0001C\u00019\"1\u0011Q\u0004\u0001\u0005\u0002qCa!!\t\u0001\t\u0003a\u0006BBA\u0013\u0001\u0011\u0005A\f\u0003\u0004\u0002*\u0001!\t\u0001\u0018\u0005\u0007\u0003[\u0001A\u0011\u0001/\t\r\u0005E\u0002\u0001\"\u0001]\u0011\u0019\t)\u0004\u0001C\u00019\"9\u0011\u0011\b\u0001\u0005\u0002\u0005m\u0002bBA=\u0001\u0011\u0005\u00111\u0010\u0002\u001e%\u0016\u0004H.[2b\u00032$XM\u001d'pO\u0012K'o\u001d+ie\u0016\fG\rV3ti*\u00111\u0004H\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003u\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001AA\u0011\u0011\u0005J\u0007\u0002E)\t1%A\u0003tG\u0006d\u0017-\u0003\u0002&E\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#\u0001\u0015\u0011\u0005%\u0002Q\"\u0001\u000e\u0002\tQ\f\u0004\u000fM\u000b\u0002YA\u0011Q&N\u0007\u0002])\u0011q\u0006M\u0001\u0007G>lWn\u001c8\u000b\u0005u\t$B\u0001\u001a4\u0003\u0019\t\u0007/Y2iK*\tA'A\u0002pe\u001eL!A\u000e\u0018\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]\u0006)A/\r91A\u0005!A/\r92\u0003\u0015!\u0018\u0007]\u0019!\u0003A1\u0017-\u001b7fIB\u000b'\u000f^5uS>t7/F\u0001=!\tIS(\u0003\u0002?5\t\u0001b)Y5mK\u0012\u0004\u0016M\u001d;ji&|gn]\u0001\u0012M\u0006LG.\u001a3QCJ$\u0018\u000e^5p]N\u0004\u0013AD8gMN,G/\u00118e\u000bB|7\r\u001b\u000b\u0004\u0005\u0016S\u0005CA\u0015D\u0013\t!%D\u0001\bPM\u001a\u001cX\r^!oI\u0016\u0003xn\u00195\t\u000b\u0019C\u0001\u0019A$\u0002\u0017\u0019,Go\u00195PM\u001a\u001cX\r\u001e\t\u0003C!K!!\u0013\u0012\u0003\t1{gn\u001a\u0005\b\u0017\"\u0001\n\u00111\u0001M\u0003-aW-\u00193fe\u0016\u0003xn\u00195\u0011\u0005\u0005j\u0015B\u0001(#\u0005\rIe\u000e^\u0001\u0019_\u001a47/\u001a;B]\u0012,\u0005o\\2iI\u0011,g-Y;mi\u0012\u0012T#A)+\u00051\u00136&A*\u0011\u0005QKV\"A+\u000b\u0005Y;\u0016!C;oG\",7m[3e\u0015\tA&%\u0001\u0006b]:|G/\u0019;j_:L!AW+\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\u0017tQ>,H\u000e\u001a(pi\u0006#G\rU1si&$\u0018n\u001c8JM\u001a+H/\u001e:f\u0019><\u0017j\u001d(pi\u0012+g-\u001b8fIR\tQ\f\u0005\u0002\"=&\u0011qL\t\u0002\u0005+:LG\u000f\u000b\u0002\u000bCB\u0011!-Z\u0007\u0002G*\u0011AmM\u0001\u0006UVt\u0017\u000e^\u0005\u0003M\u000e\u0014A\u0001V3ti\u0006a3\u000f[8vY\u0012,\u0006\u000fZ1uK2+\u0017\rZ3s\u000bB|7\r[!gi\u0016\u0014h)\u001a8dK\u0012,\u0005o\\2i\u000bJ\u0014xN\u001d\u0015\u0003\u0017\u0005\fae\u001d5pk2$'+\u001a9mC\u000e,7)\u001e:sK:$Hj\\4ESJ<\u0006.\u001a8DCV<\u0007\u000e^+qQ\ta\u0011-A\fn_\u000e\\g)\u001a;dQ\u001a\u0013x.\\\"veJ,g\u000e\u001e'pORAQ,\\8|\u0003\u0003\tY\u0001C\u0003o\u001b\u0001\u0007A&\u0001\bu_BL7\rU1si&$\u0018n\u001c8\t\u000bAl\u0001\u0019A9\u0002\u0017I,\u0017/^3ti\u0012\u000bG/\u0019\t\u0003ebt!a\u001d<\u000e\u0003QT!!\u001e\u0018\u0002\u0011I,\u0017/^3tiNL!a\u001e;\u0002\u0019\u0019+Go\u00195SKF,Xm\u001d;\n\u0005eT(!\u0004)beRLG/[8o\t\u0006$\u0018M\u0003\u0002xi\")A0\u0004a\u0001{\u000611m\u001c8gS\u001e\u0004\"!\u000b@\n\u0005}T\"aC&bM.\f7i\u001c8gS\u001eDq!a\u0001\u000e\u0001\u0004\t)!\u0001\bsKBd\u0017nY1NC:\fw-\u001a:\u0011\u0007%\n9!C\u0002\u0002\ni\u0011aBU3qY&\u001c\u0017-T1oC\u001e,'\u000fC\u0004\u0002\u000e5\u0001\r!a\u0004\u0002\u0019I,7\u000f]8og\u0016$\u0015\r^1\u0011\u0007%\n\t\"C\u0002\u0002\u0014i\u0011!CR3uG\"\u0004\u0016M\u001d;ji&|g\u000eR1uC\u0006\u0011\u0013n]:vKN,\u0005o\\2i%\u0016\fX/Z:u\rJ|W\u000eT8dC2\u0014V\r\u001d7jG\u0006D#AD1\u0002{\u0019,Go\u00195Fa>\u001c\u0007n\u001d$s_6dU-\u00193feNCw.\u001e7e\u0011\u0006tG\r\\3Fq\u000e,\u0007\u000f^5p]\u001a\u0013x.\\$fi2{7-\u00197SKBd\u0017nY1)\u0005=\t\u0017!H:i_VdG\r\u0016:v]\u000e\fG/\u001a+p%\u0016\u0004H.[2b\u001f\u001a47/\u001a;)\u0005A\t\u0017!L:i_VdG\r\u0016:v]\u000e\fG/\u001a+p\u000b:$wJ\u001a4tKR|e\rT1sO\u0016\u001cHoQ8n[>tW\t]8dQ\"\u0012\u0011#Y\u0001Bg\"|W\u000f\u001c3UeVt7-\u0019;f)>Le.\u001b;jC24U\r^2i\u001f\u001a47/\u001a;JMJ+\u0007\u000f\\5dCJ+G/\u001e:ogVsG-\u001a4j]\u0016$wJ\u001a4tKRD#AE1\u0002WMDw.\u001e7e!>dG.\u00138eK\u001aLg.\u001b;fYfLeMU3qY&\u001c\u0017MT8u\u0003Z\f\u0017\u000e\\1cY\u0016D#aE1\u0002MMDw.\u001e7e\r\u0016$8\r\u001b'fC\u0012,'/\u00129pG\"|eNR5sgR4U\r^2i\u001f:d\u0017\u0010\u000b\u0002\u0015C\u0006a2\u000f[8vY\u00124U\r^2i\u001f:,'+\u001a9mS\u000e\f\u0017\t^!US6,\u0007FA\u000bb\u00035\u001a\bn\\;mI\u001a+Go\u00195O_:$U\r\\1zK\u0012\fe\u000e\u001a(p]R\u0013XO\\2bi&twMU3qY&\u001c\u0017m\u001d\u0015\u0003-\u0005\fAa\u001d;vERa\u0011QHA.\u0003W\ny'a\u001d\u0002xA1\u0011qHA#\u0003\u0013j!!!\u0011\u000b\u0007\u0005\r3'\u0001\u0005fCNLXn\\2l\u0013\u0011\t9%!\u0011\u0003'%+\u0005\u0010]3di\u0006$\u0018n\u001c8TKR$XM]:\u0011\u000b\u0005\nY%a\u0014\n\u0007\u00055#E\u0001\u0004PaRLwN\u001c\t\u0005\u0003#\n9&\u0004\u0002\u0002T)\u0019\u0011Q\u000b\u000f\u0002\u000f\rdWo\u001d;fe&!\u0011\u0011LA*\u0005%\u0001\u0016M\u001d;ji&|g\u000eC\u0004\u0002^]\u0001\r!a\u0018\u0002\u000f1|w\rV\u0019qaA!\u0011\u0011MA4\u001b\t\t\u0019GC\u0002\u0002fq\t1\u0001\\8h\u0013\u0011\tI'a\u0019\u0003\u00071{w\rC\u0004\u0002n]\u0001\r!a\u0018\u0002\u000f1|w\rV\u0019qc!9\u0011\u0011O\fA\u0002\u0005}\u0013!\u00034viV\u0014X\rT8h\u0011\u001d\t)h\u0006a\u0001\u0003\u001f\n\u0011\u0002]1si&$\u0018n\u001c8\t\u000f\u0005\rq\u00031\u0001\u0002\u0006\u0005)2\u000f^;c/&$\bNR3uG\"lUm]:bO\u0016\u001cHCDA?\u0003\u007f\n\t)a!\u0002\u0006\u0006\u001d\u0015\u0011\u0012\t\u0006\u0003\u007f\t)%\u0018\u0005\b\u0003;B\u0002\u0019AA0\u0011\u001d\ti\u0007\u0007a\u0001\u0003?Bq!!\u001d\u0019\u0001\u0004\ty\u0006C\u0004\u0002va\u0001\r!a\u0014\t\u000f\u0005\r\u0001\u00041\u0001\u0002\u0006!9\u00111\u0012\rA\u0002\u00055\u0015\u0001\u0005:fgB|gn]3DC2d'-Y2l!\u0019\ty$a$\u0002\u0014&!\u0011\u0011SA!\u0005\u001d\u0019\u0015\r\u001d;ve\u0016\u0004b!IAK\u00033k\u0016bAALE\tIa)\u001e8di&|g.\r\t\u0007\u00037\u000b\t+!*\u000e\u0005\u0005u%bAAPE\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005\r\u0016Q\u0014\u0002\u0004'\u0016\f\bCB\u0011\u0002(2\ny!C\u0002\u0002*\n\u0012a\u0001V;qY\u0016\u0014\u0004")
public class ReplicaAlterLogDirsThreadTest {
    private final TopicPartition t1p0 = new TopicPartition("topic1", 0);
    private final TopicPartition t1p1 = new TopicPartition("topic1", 1);
    private final FailedPartitions failedPartitions = new FailedPartitions();

    private TopicPartition t1p0() {
        return this.t1p0;
    }

    private TopicPartition t1p1() {
        return this.t1p1;
    }

    private FailedPartitions failedPartitions() {
        return this.failedPartitions;
    }

    private OffsetAndEpoch offsetAndEpoch(long fetchOffset, int leaderEpoch) {
        return new OffsetAndEpoch(fetchOffset, leaderEpoch);
    }

    private int offsetAndEpoch$default$2() {
        return 1;
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void shouldNotAddPartitionIfFutureLogIsNotDefined() {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        int brokerId = 1;
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(brokerId, "localhost:1234", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20()));
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        ReplicationQuotaManager quotaManager = (ReplicationQuotaManager)Mockito.mock(ReplicationQuotaManager.class);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)replicaManager.futureLogExists(this.t1p0()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        BrokerEndPoint endPoint = new BrokerEndPoint(0, "localhost", 1000);
        ReplicaAlterLogDirsThread thread = new ReplicaAlterLogDirsThread("alter-logs-dirs-thread", endPoint, config, this.failedPartitions(), replicaManager, quotaManager, new BrokerTopicStats());
        Tuple2[] tuple2Array = new Tuple2[1];
        OffsetAndEpoch offsetAndEpoch = this.offsetAndEpoch(0L, this.offsetAndEpoch$default$2());
        Object object = Predef$.MODULE$.ArrowAssoc((Object)this.t1p0());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        Set addedPartitions = thread.addPartitions((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array)));
        Assert.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)addedPartitions);
        Assert.assertEquals((long)0L, (long)thread.partitionCount());
        Assert.assertEquals((Object)None$.MODULE$, (Object)thread.fetchState(this.t1p0()));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void shouldUpdateLeaderEpochAfterFencedEpochError() {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        void $minus$greater$extension_y2;
        void $minus$greater$extension_$this2;
        int brokerId = 1;
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(brokerId, "localhost:1234", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20()));
        Partition partition = (Partition)Mockito.mock(Partition.class);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        ReplicationQuotaManager quotaManager = (ReplicationQuotaManager)Mockito.mock(ReplicationQuotaManager.class);
        Log futureLog = (Log)Mockito.mock(Log.class);
        int leaderEpoch = 5;
        int logEndOffset = 0;
        Mockito.when((Object)replicaManager.futureLocalLogOrException(this.t1p0())).thenReturn((Object)futureLog);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)replicaManager.futureLogExists(this.t1p0()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Mockito.when((Object)replicaManager.nonOfflinePartition(this.t1p0())).thenReturn((Object)new Some((Object)partition));
        Mockito.when((Object)replicaManager.getPartitionOrException(this.t1p0())).thenReturn((Object)partition);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)quotaManager.isQuotaExceeded())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Mockito.when((Object)partition.lastOffsetForLeaderEpoch(Optional.empty(), leaderEpoch, false)).thenReturn((Object)new EpochEndOffset(leaderEpoch, (long)logEndOffset));
        Mockito.when((Object)partition.futureLocalLogOrException()).thenReturn((Object)futureLog);
        ((Partition)Mockito.doNothing().when((Object)partition)).truncateTo(0L, true);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)partition.maybeReplaceCurrentWithFutureReplica())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)futureLog.logStartOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)0L));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)futureLog.logEndOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)0L));
        Mockito.when((Object)futureLog.latestEpoch()).thenReturn((Object)None$.MODULE$);
        FetchRequest.PartitionData fencedRequestData = new FetchRequest.PartitionData(0L, 0L, Predef$.MODULE$.Integer2int(config.replicaFetchMaxBytes()), Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch - 1)));
        FetchPartitionData fencedResponseData = new FetchPartitionData(Errors.FENCED_LEADER_EPOCH, -1L, -1L, (Records)MemoryRecords.EMPTY, (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$, false);
        this.mockFetchFromCurrentLog(this.t1p0(), fencedRequestData, config, replicaManager, fencedResponseData);
        BrokerEndPoint endPoint = new BrokerEndPoint(0, "localhost", 1000);
        ReplicaAlterLogDirsThread thread = new ReplicaAlterLogDirsThread("alter-logs-dirs-thread", endPoint, config, this.failedPartitions(), replicaManager, quotaManager, new BrokerTopicStats());
        Tuple2[] tuple2Array = new Tuple2[1];
        OffsetAndEpoch offsetAndEpoch = this.offsetAndEpoch(0L, leaderEpoch - 1);
        Object object = Predef$.MODULE$.ArrowAssoc((Object)this.t1p0());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y2);
        thread.addPartitions((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array)));
        Assert.assertTrue((boolean)thread.fetchState(this.t1p0()).isDefined());
        Assert.assertEquals((long)1L, (long)thread.partitionCount());
        thread.doWork();
        Assert.assertTrue((boolean)this.failedPartitions().contains(this.t1p0()));
        Assert.assertEquals((Object)None$.MODULE$, (Object)thread.fetchState(this.t1p0()));
        Assert.assertEquals((long)0L, (long)thread.partitionCount());
        Tuple2[] tuple2Array2 = new Tuple2[1];
        OffsetAndEpoch offsetAndEpoch2 = this.offsetAndEpoch(0L, leaderEpoch);
        Object object2 = Predef$.MODULE$.ArrowAssoc((Object)this.t1p0());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array2[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        thread.addPartitions((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array2)));
        Option option = thread.fetchState(this.t1p0());
        if (option == null) {
            throw null;
        }
        Option map_this = option;
        Object object3 = map_this.isEmpty() ? None$.MODULE$ : new Some((Object)BoxesRunTime.boxToInteger((int)((PartitionFetchState)map_this.get()).currentLeaderEpoch()));
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)leaderEpoch)), (Object)object3);
        Assert.assertEquals((long)1L, (long)thread.partitionCount());
        FetchRequest.PartitionData requestData = new FetchRequest.PartitionData(0L, 0L, Predef$.MODULE$.Integer2int(config.replicaFetchMaxBytes()), Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)));
        FetchPartitionData responseData = new FetchPartitionData(Errors.NONE, 0L, 0L, (Records)MemoryRecords.EMPTY, (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$, false);
        this.mockFetchFromCurrentLog(this.t1p0(), requestData, config, replicaManager, responseData);
        thread.doWork();
        Assert.assertFalse((boolean)this.failedPartitions().contains(this.t1p0()));
        Assert.assertEquals((Object)None$.MODULE$, (Object)thread.fetchState(this.t1p0()));
        Assert.assertEquals((long)0L, (long)thread.partitionCount());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void shouldReplaceCurrentLogDirWhenCaughtUp() {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        int brokerId = 1;
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(brokerId, "localhost:1234", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20()));
        Partition partition = (Partition)Mockito.mock(Partition.class);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        ReplicationQuotaManager quotaManager = (ReplicationQuotaManager)Mockito.mock(ReplicationQuotaManager.class);
        Log futureLog = (Log)Mockito.mock(Log.class);
        int leaderEpoch = 5;
        int logEndOffset = 0;
        Mockito.when((Object)replicaManager.futureLocalLogOrException(this.t1p0())).thenReturn((Object)futureLog);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)replicaManager.futureLogExists(this.t1p0()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Mockito.when((Object)replicaManager.nonOfflinePartition(this.t1p0())).thenReturn((Object)new Some((Object)partition));
        Mockito.when((Object)replicaManager.getPartitionOrException(this.t1p0())).thenReturn((Object)partition);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)quotaManager.isQuotaExceeded())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Mockito.when((Object)partition.lastOffsetForLeaderEpoch(Optional.empty(), leaderEpoch, false)).thenReturn((Object)new EpochEndOffset(leaderEpoch, (long)logEndOffset));
        Mockito.when((Object)partition.futureLocalLogOrException()).thenReturn((Object)futureLog);
        ((Partition)Mockito.doNothing().when((Object)partition)).truncateTo(0L, true);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)partition.maybeReplaceCurrentWithFutureReplica())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)futureLog.logStartOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)0L));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)futureLog.logEndOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)0L));
        Mockito.when((Object)futureLog.latestEpoch()).thenReturn((Object)None$.MODULE$);
        FetchRequest.PartitionData requestData = new FetchRequest.PartitionData(0L, 0L, Predef$.MODULE$.Integer2int(config.replicaFetchMaxBytes()), Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)));
        FetchPartitionData responseData = new FetchPartitionData(Errors.NONE, 0L, 0L, (Records)MemoryRecords.EMPTY, (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$, false);
        this.mockFetchFromCurrentLog(this.t1p0(), requestData, config, replicaManager, responseData);
        BrokerEndPoint endPoint = new BrokerEndPoint(0, "localhost", 1000);
        ReplicaAlterLogDirsThread thread = new ReplicaAlterLogDirsThread("alter-logs-dirs-thread", endPoint, config, this.failedPartitions(), replicaManager, quotaManager, new BrokerTopicStats());
        Tuple2[] tuple2Array = new Tuple2[1];
        OffsetAndEpoch offsetAndEpoch = this.offsetAndEpoch(0L, leaderEpoch);
        Object object = Predef$.MODULE$.ArrowAssoc((Object)this.t1p0());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        thread.addPartitions((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array)));
        Assert.assertTrue((boolean)thread.fetchState(this.t1p0()).isDefined());
        Assert.assertEquals((long)1L, (long)thread.partitionCount());
        thread.doWork();
        Assert.assertEquals((Object)None$.MODULE$, (Object)thread.fetchState(this.t1p0()));
        Assert.assertEquals((long)0L, (long)thread.partitionCount());
    }

    /*
     * WARNING - void declaration
     */
    private void mockFetchFromCurrentLog(TopicPartition topicPartition, FetchRequest.PartitionData requestData, KafkaConfig config, ReplicaManager replicaManager, FetchPartitionData responseData) {
        void $minus$greater$extension_$this;
        ArgumentCaptor callbackCaptor = ArgumentCaptor.forClass(Function1.class);
        Object object = Predef$.MODULE$.ArrowAssoc((Object)topicPartition);
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        replicaManager.fetchMessages(ArgumentMatchers.eq((long)0L), ArgumentMatchers.eq((int)Request$.MODULE$.FutureLocalReplicaId()), ArgumentMatchers.eq((int)0), BoxesRunTime.unboxToInt((Object)ArgumentMatchers.eq((Object)BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(config.replicaFetchResponseMaxBytes())))), ArgumentMatchers.eq((boolean)false), (Seq)ArgumentMatchers.eq((Object)new .colon.colon((Object)new Tuple2((Object)$minus$greater$extension_$this, (Object)requestData), (List)Nil$.MODULE$)), (ReplicaQuota)ArgumentMatchers.eq((Object)QuotaFactory.UnboundedQuota$.MODULE$), (Function1)callbackCaptor.capture(), (IsolationLevel)ArgumentMatchers.eq((Object)IsolationLevel.READ_UNCOMMITTED), (Option)ArgumentMatchers.eq((Object)None$.MODULE$));
        Mockito.when((Object)BoxedUnit.UNIT).thenAnswer(x$2 -> {
            ReplicaAlterLogDirsThreadTest.$anonfun$mockFetchFromCurrentLog$1(callbackCaptor, topicPartition, responseData, x$2);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void issuesEpochRequestFromLocalReplica() {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        void $minus$greater$extension_y2;
        void $minus$greater$extension_$this2;
        void $minus$greater$extension_y3;
        void $minus$greater$extension_$this3;
        void $minus$greater$extension_y4;
        void $minus$greater$extension_$this4;
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20()));
        Partition partitionT1p0 = (Partition)EasyMock.createMock(Partition.class);
        Partition partitionT1p1 = (Partition)EasyMock.createMock(Partition.class);
        ReplicaManager replicaManager = (ReplicaManager)EasyMock.createMock(ReplicaManager.class);
        int leaderEpochT1p0 = 2;
        int leaderEpochT1p1 = 5;
        int leoT1p0 = 13;
        int leoT1p1 = 232;
        EasyMock.expect((Object)replicaManager.getPartitionOrException(this.t1p0())).andStubReturn((Object)partitionT1p0);
        EasyMock.expect((Object)partitionT1p0.lastOffsetForLeaderEpoch(Optional.empty(), leaderEpochT1p0, false)).andReturn((Object)new EpochEndOffset(leaderEpochT1p0, (long)leoT1p0)).anyTimes();
        EasyMock.expect((Object)replicaManager.getPartitionOrException(this.t1p1())).andStubReturn((Object)partitionT1p1);
        EasyMock.expect((Object)partitionT1p1.lastOffsetForLeaderEpoch(Optional.empty(), leaderEpochT1p1, false)).andReturn((Object)new EpochEndOffset(leaderEpochT1p1, (long)leoT1p1)).anyTimes();
        EasyMock.replay((Object[])new Object[]{partitionT1p0, partitionT1p1, replicaManager});
        BrokerEndPoint endPoint = new BrokerEndPoint(0, "localhost", 1000);
        Tuple2[] tuple2Array = new Tuple2[2];
        OffsetsForLeaderEpochRequest.PartitionData partitionData = new OffsetsForLeaderEpochRequest.PartitionData(Optional.empty(), leaderEpochT1p0);
        Object object = Predef$.MODULE$.ArrowAssoc((Object)this.t1p0());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this4, (Object)$minus$greater$extension_y4);
        OffsetsForLeaderEpochRequest.PartitionData partitionData2 = new OffsetsForLeaderEpochRequest.PartitionData(Optional.empty(), leaderEpochT1p1);
        Object object2 = Predef$.MODULE$.ArrowAssoc((Object)this.t1p1());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[1] = new Tuple2((Object)$minus$greater$extension_$this3, (Object)$minus$greater$extension_y3);
        Map result = new ReplicaAlterLogDirsThread("alter-logs-dirs-thread-test1", endPoint, config, this.failedPartitions(), replicaManager, null, null).fetchEpochEndOffsets((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array)));
        Tuple2[] tuple2Array2 = new Tuple2[2];
        EpochEndOffset epochEndOffset = new EpochEndOffset(Errors.NONE, leaderEpochT1p0, (long)leoT1p0);
        Object object3 = Predef$.MODULE$.ArrowAssoc((Object)this.t1p0());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array2[0] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y2);
        EpochEndOffset epochEndOffset2 = new EpochEndOffset(Errors.NONE, leaderEpochT1p1, (long)leoT1p1);
        Object object4 = Predef$.MODULE$.ArrowAssoc((Object)this.t1p1());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array2[1] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        Map expected = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array2));
        Assert.assertEquals((String)"results from leader epoch request should have offset from local replica", (Object)expected, (Object)result);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void fetchEpochsFromLeaderShouldHandleExceptionFromGetLocalReplica() {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        void $minus$greater$extension_y2;
        void $minus$greater$extension_$this2;
        void $minus$greater$extension_y3;
        void $minus$greater$extension_$this3;
        void $minus$greater$extension_y4;
        void $minus$greater$extension_$this4;
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20()));
        Partition partitionT1p0 = (Partition)EasyMock.createMock(Partition.class);
        ReplicaManager replicaManager = (ReplicaManager)EasyMock.createMock(ReplicaManager.class);
        int leaderEpoch = 2;
        int leo = 13;
        EasyMock.expect((Object)replicaManager.getPartitionOrException(this.t1p0())).andStubReturn((Object)partitionT1p0);
        EasyMock.expect((Object)partitionT1p0.lastOffsetForLeaderEpoch(Optional.empty(), leaderEpoch, false)).andReturn((Object)new EpochEndOffset(leaderEpoch, (long)leo)).anyTimes();
        EasyMock.expect((Object)replicaManager.getPartitionOrException(this.t1p1())).andThrow((Throwable)new KafkaStorageException()).once();
        EasyMock.replay((Object[])new Object[]{partitionT1p0, replicaManager});
        BrokerEndPoint endPoint = new BrokerEndPoint(0, "localhost", 1000);
        Tuple2[] tuple2Array = new Tuple2[2];
        OffsetsForLeaderEpochRequest.PartitionData partitionData = new OffsetsForLeaderEpochRequest.PartitionData(Optional.empty(), leaderEpoch);
        Object object = Predef$.MODULE$.ArrowAssoc((Object)this.t1p0());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this4, (Object)$minus$greater$extension_y4);
        OffsetsForLeaderEpochRequest.PartitionData partitionData2 = new OffsetsForLeaderEpochRequest.PartitionData(Optional.empty(), leaderEpoch);
        Object object2 = Predef$.MODULE$.ArrowAssoc((Object)this.t1p1());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[1] = new Tuple2((Object)$minus$greater$extension_$this3, (Object)$minus$greater$extension_y3);
        Map result = new ReplicaAlterLogDirsThread("alter-logs-dirs-thread-test1", endPoint, config, this.failedPartitions(), replicaManager, null, null).fetchEpochEndOffsets((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array)));
        Tuple2[] tuple2Array2 = new Tuple2[2];
        EpochEndOffset epochEndOffset = new EpochEndOffset(Errors.NONE, leaderEpoch, (long)leo);
        Object object3 = Predef$.MODULE$.ArrowAssoc((Object)this.t1p0());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array2[0] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y2);
        EpochEndOffset epochEndOffset2 = new EpochEndOffset(Errors.KAFKA_STORAGE_ERROR, -1, -1L);
        Object object4 = Predef$.MODULE$.ArrowAssoc((Object)this.t1p1());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array2[1] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        Assert.assertEquals((Object)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array2))), (Object)result);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void shouldTruncateToReplicaOffset() {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        void $minus$greater$extension_y2;
        void $minus$greater$extension_$this2;
        Capture truncateCaptureT1p0 = EasyMock.newCapture((CaptureType)CaptureType.ALL);
        Capture truncateCaptureT1p1 = EasyMock.newCapture((CaptureType)CaptureType.ALL);
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20()));
        ReplicationQuotaManager quotaManager = (ReplicationQuotaManager)EasyMock.createNiceMock(ReplicationQuotaManager.class);
        LogManager logManager = (LogManager)EasyMock.createMock(LogManager.class);
        Log logT1p0 = (Log)EasyMock.createNiceMock(Log.class);
        Log logT1p1 = (Log)EasyMock.createNiceMock(Log.class);
        Log futureLogT1p0 = (Log)EasyMock.createNiceMock(Log.class);
        Log futureLogT1p1 = (Log)EasyMock.createNiceMock(Log.class);
        Partition partitionT1p0 = (Partition)EasyMock.createMock(Partition.class);
        Partition partitionT1p1 = (Partition)EasyMock.createMock(Partition.class);
        ReplicaManager replicaManager = (ReplicaManager)EasyMock.createMock(ReplicaManager.class);
        Capture responseCallback = EasyMock.newCapture();
        int leaderEpoch = 2;
        int futureReplicaLEO = 191;
        int replicaT1p0LEO = 190;
        int replicaT1p1LEO = 192;
        EasyMock.expect((Object)replicaManager.getPartitionOrException(this.t1p0())).andStubReturn((Object)partitionT1p0);
        EasyMock.expect((Object)replicaManager.getPartitionOrException(this.t1p1())).andStubReturn((Object)partitionT1p1);
        EasyMock.expect((Object)replicaManager.futureLocalLogOrException(this.t1p0())).andStubReturn((Object)futureLogT1p0);
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)replicaManager.futureLogExists(this.t1p0()))).andStubReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        EasyMock.expect((Object)replicaManager.futureLocalLogOrException(this.t1p1())).andStubReturn((Object)futureLogT1p1);
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)replicaManager.futureLogExists(this.t1p1()))).andStubReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        partitionT1p0.truncateTo(BoxesRunTime.unboxToLong((Object)EasyMock.capture((Capture)truncateCaptureT1p0)), EasyMock.anyBoolean());
        EasyMock.expect((Object)BoxedUnit.UNIT).anyTimes();
        partitionT1p1.truncateTo(BoxesRunTime.unboxToLong((Object)EasyMock.capture((Capture)truncateCaptureT1p1)), EasyMock.anyBoolean());
        EasyMock.expect((Object)BoxedUnit.UNIT).anyTimes();
        EasyMock.expect((Object)BoxesRunTime.boxToLong((long)futureLogT1p0.logEndOffset())).andReturn((Object)BoxesRunTime.boxToLong((long)futureReplicaLEO)).anyTimes();
        EasyMock.expect((Object)BoxesRunTime.boxToLong((long)futureLogT1p1.logEndOffset())).andReturn((Object)BoxesRunTime.boxToLong((long)futureReplicaLEO)).anyTimes();
        EasyMock.expect((Object)futureLogT1p0.latestEpoch()).andReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)leaderEpoch))).anyTimes();
        EasyMock.expect((Object)futureLogT1p0.endOffsetForEpoch(leaderEpoch)).andReturn((Object)new Some((Object)new OffsetAndEpoch((long)futureReplicaLEO, leaderEpoch))).anyTimes();
        EasyMock.expect((Object)partitionT1p0.lastOffsetForLeaderEpoch(Optional.of(Predef$.MODULE$.int2Integer(1)), leaderEpoch, false)).andReturn((Object)new EpochEndOffset(leaderEpoch, (long)replicaT1p0LEO)).anyTimes();
        EasyMock.expect((Object)futureLogT1p1.latestEpoch()).andReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)leaderEpoch))).anyTimes();
        EasyMock.expect((Object)futureLogT1p1.endOffsetForEpoch(leaderEpoch)).andReturn((Object)new Some((Object)new OffsetAndEpoch((long)futureReplicaLEO, leaderEpoch))).anyTimes();
        EasyMock.expect((Object)partitionT1p1.lastOffsetForLeaderEpoch(Optional.of(Predef$.MODULE$.int2Integer(1)), leaderEpoch, false)).andReturn((Object)new EpochEndOffset(leaderEpoch, (long)replicaT1p1LEO)).anyTimes();
        EasyMock.expect((Object)replicaManager.logManager()).andReturn((Object)logManager).anyTimes();
        this.stubWithFetchMessages(logT1p0, logT1p1, futureLogT1p0, partitionT1p0, replicaManager, (Capture<Function1<Seq<Tuple2<TopicPartition, FetchPartitionData>>, BoxedUnit>>)responseCallback);
        EasyMock.replay((Object[])new Object[]{replicaManager, logManager, quotaManager, partitionT1p0, partitionT1p1, logT1p0, logT1p1, futureLogT1p0, futureLogT1p1});
        BrokerEndPoint endPoint = new BrokerEndPoint(0, "localhost", 1000);
        ReplicaAlterLogDirsThread thread = new ReplicaAlterLogDirsThread("alter-logs-dirs-thread-test1", endPoint, config, this.failedPartitions(), replicaManager, quotaManager, null);
        Tuple2[] tuple2Array = new Tuple2[2];
        OffsetAndEpoch offsetAndEpoch = this.offsetAndEpoch(0L, this.offsetAndEpoch$default$2());
        Object object = Predef$.MODULE$.ArrowAssoc((Object)this.t1p0());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y2);
        OffsetAndEpoch offsetAndEpoch2 = this.offsetAndEpoch(0L, this.offsetAndEpoch$default$2());
        Object object2 = Predef$.MODULE$.ArrowAssoc((Object)this.t1p1());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[1] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        thread.addPartitions((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array)));
        thread.doWork();
        Assert.assertEquals((long)replicaT1p0LEO, (long)BoxesRunTime.unboxToLong((Object)truncateCaptureT1p0.getValue()));
        Assert.assertEquals((long)futureReplicaLEO, (long)BoxesRunTime.unboxToLong((Object)truncateCaptureT1p1.getValue()));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void shouldTruncateToEndOffsetOfLargestCommonEpoch() {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        Capture truncateToCapture = EasyMock.newCapture((CaptureType)CaptureType.ALL);
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20()));
        ReplicationQuotaManager quotaManager = (ReplicationQuotaManager)EasyMock.createNiceMock(ReplicationQuotaManager.class);
        LogManager logManager = (LogManager)EasyMock.createMock(LogManager.class);
        Log log = (Log)EasyMock.createNiceMock(Log.class);
        Log futureLog = (Log)EasyMock.createNiceMock(Log.class);
        Partition partition = (Partition)EasyMock.createMock(Partition.class);
        ReplicaManager replicaManager = (ReplicaManager)EasyMock.createMock(ReplicaManager.class);
        Capture responseCallback = EasyMock.newCapture();
        int leaderEpoch = 5;
        int futureReplicaLEO = 195;
        int replicaLEO = 200;
        int replicaEpochEndOffset = 190;
        int futureReplicaEpochEndOffset = 191;
        EasyMock.expect((Object)replicaManager.getPartitionOrException(this.t1p0())).andStubReturn((Object)partition);
        EasyMock.expect((Object)replicaManager.futureLocalLogOrException(this.t1p0())).andStubReturn((Object)futureLog);
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)replicaManager.futureLogExists(this.t1p0()))).andStubReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        partition.truncateTo(BoxesRunTime.unboxToLong((Object)EasyMock.capture((Capture)truncateToCapture)), EasyMock.eq((boolean)true));
        EasyMock.expect((Object)BoxedUnit.UNIT).anyTimes();
        EasyMock.expect((Object)BoxesRunTime.boxToLong((long)futureLog.logEndOffset())).andReturn((Object)BoxesRunTime.boxToLong((long)futureReplicaLEO)).anyTimes();
        EasyMock.expect((Object)futureLog.latestEpoch()).andReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)leaderEpoch))).once();
        EasyMock.expect((Object)futureLog.latestEpoch()).andReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)(leaderEpoch - 2)))).once();
        EasyMock.expect((Object)partition.lastOffsetForLeaderEpoch(Optional.of(Predef$.MODULE$.int2Integer(1)), leaderEpoch, false)).andReturn((Object)new EpochEndOffset(leaderEpoch - 1, (long)replicaLEO)).anyTimes();
        EasyMock.expect((Object)futureLog.endOffsetForEpoch(leaderEpoch - 1)).andReturn((Object)new Some((Object)new OffsetAndEpoch((long)futureReplicaLEO, leaderEpoch - 2))).anyTimes();
        EasyMock.expect((Object)partition.lastOffsetForLeaderEpoch(Optional.of(Predef$.MODULE$.int2Integer(1)), leaderEpoch - 2, false)).andReturn((Object)new EpochEndOffset(leaderEpoch - 2, (long)replicaEpochEndOffset)).anyTimes();
        EasyMock.expect((Object)futureLog.endOffsetForEpoch(leaderEpoch - 2)).andReturn((Object)new Some((Object)new OffsetAndEpoch((long)futureReplicaEpochEndOffset, leaderEpoch - 2))).anyTimes();
        EasyMock.expect((Object)replicaManager.logManager()).andReturn((Object)logManager).anyTimes();
        this.stubWithFetchMessages(log, null, futureLog, partition, replicaManager, (Capture<Function1<Seq<Tuple2<TopicPartition, FetchPartitionData>>, BoxedUnit>>)responseCallback);
        EasyMock.replay((Object[])new Object[]{replicaManager, logManager, quotaManager, partition, log, futureLog});
        BrokerEndPoint endPoint = new BrokerEndPoint(0, "localhost", 1000);
        ReplicaAlterLogDirsThread thread = new ReplicaAlterLogDirsThread("alter-logs-dirs-thread-test1", endPoint, config, this.failedPartitions(), replicaManager, quotaManager, null);
        Tuple2[] tuple2Array = new Tuple2[1];
        OffsetAndEpoch offsetAndEpoch = this.offsetAndEpoch(0L, this.offsetAndEpoch$default$2());
        Object object = Predef$.MODULE$.ArrowAssoc((Object)this.t1p0());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        thread.addPartitions((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array)));
        thread.doWork();
        thread.doWork();
        Assert.assertTrue((String)new StringBuilder(48).append("Expected offset ").append(replicaEpochEndOffset).append(" in captured truncation offsets ").append(truncateToCapture.getValues()).toString(), (boolean)((SeqLike)CollectionConverters$.MODULE$.asScalaBufferConverter(truncateToCapture.getValues()).asScala()).contains((Object)BoxesRunTime.boxToInteger((int)replicaEpochEndOffset)));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void shouldTruncateToInitialFetchOffsetIfReplicaReturnsUndefinedOffset() {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        Capture truncated = EasyMock.newCapture((CaptureType)CaptureType.ALL);
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20()));
        ReplicationQuotaManager quotaManager = (ReplicationQuotaManager)EasyMock.createNiceMock(ReplicationQuotaManager.class);
        LogManager logManager = (LogManager)EasyMock.createMock(LogManager.class);
        Log log = (Log)EasyMock.createNiceMock(Log.class);
        Log futureLog = (Log)EasyMock.createNiceMock(Log.class);
        Partition partition = (Partition)EasyMock.createMock(Partition.class);
        ReplicaManager replicaManager = (ReplicaManager)EasyMock.createMock(ReplicaManager.class);
        Capture responseCallback = EasyMock.newCapture();
        int initialFetchOffset = 100;
        EasyMock.expect((Object)replicaManager.getPartitionOrException(this.t1p0())).andStubReturn((Object)partition);
        partition.truncateTo(BoxesRunTime.unboxToLong((Object)EasyMock.capture((Capture)truncated)), EasyMock.eq((boolean)true));
        EasyMock.expect((Object)BoxedUnit.UNIT).anyTimes();
        EasyMock.expect((Object)replicaManager.futureLocalLogOrException(this.t1p0())).andStubReturn((Object)futureLog);
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)replicaManager.futureLogExists(this.t1p0()))).andStubReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        EasyMock.expect((Object)replicaManager.logManager()).andReturn((Object)logManager).anyTimes();
        EasyMock.expect((Object)futureLog.latestEpoch()).andReturn((Object)None$.MODULE$).anyTimes();
        this.stubWithFetchMessages(log, null, futureLog, partition, replicaManager, (Capture<Function1<Seq<Tuple2<TopicPartition, FetchPartitionData>>, BoxedUnit>>)responseCallback);
        EasyMock.replay((Object[])new Object[]{replicaManager, logManager, quotaManager, partition, log, futureLog});
        BrokerEndPoint endPoint = new BrokerEndPoint(0, "localhost", 1000);
        ReplicaAlterLogDirsThread thread = new ReplicaAlterLogDirsThread("alter-logs-dirs-thread-test1", endPoint, config, this.failedPartitions(), replicaManager, quotaManager, null);
        Tuple2[] tuple2Array = new Tuple2[1];
        OffsetAndEpoch offsetAndEpoch = this.offsetAndEpoch(initialFetchOffset, this.offsetAndEpoch$default$2());
        Object object = Predef$.MODULE$.ArrowAssoc((Object)this.t1p0());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        thread.addPartitions((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array)));
        thread.doWork();
        Assert.assertEquals((String)"Expected future replica to truncate to initial fetch offset if replica returns UNDEFINED_EPOCH_OFFSET", (long)initialFetchOffset, (long)BoxesRunTime.unboxToLong((Object)truncated.getValue()));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void shouldPollIndefinitelyIfReplicaNotAvailable() {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        Capture truncated = EasyMock.newCapture((CaptureType)CaptureType.ALL);
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20()));
        ReplicationQuotaManager quotaManager = (ReplicationQuotaManager)EasyMock.createNiceMock(ReplicationQuotaManager.class);
        LogManager logManager = (LogManager)EasyMock.createMock(LogManager.class);
        Log log = (Log)EasyMock.createNiceMock(Log.class);
        Log futureLog = (Log)EasyMock.createNiceMock(Log.class);
        Partition partition = (Partition)EasyMock.createMock(Partition.class);
        ReplicaManager replicaManager = (ReplicaManager)EasyMock.createMock(ReplicaManager.class);
        Capture responseCallback = EasyMock.newCapture();
        int futureReplicaLeaderEpoch = 1;
        int futureReplicaLEO = 290;
        int replicaLEO = 300;
        EasyMock.expect((Object)replicaManager.getPartitionOrException(this.t1p0())).andStubReturn((Object)partition);
        partition.truncateTo(BoxesRunTime.unboxToLong((Object)EasyMock.capture((Capture)truncated)), EasyMock.eq((boolean)true));
        EasyMock.expect((Object)BoxedUnit.UNIT).once();
        EasyMock.expect((Object)replicaManager.futureLocalLogOrException(this.t1p0())).andStubReturn((Object)futureLog);
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)replicaManager.futureLogExists(this.t1p0()))).andStubReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        EasyMock.expect((Object)BoxesRunTime.boxToLong((long)futureLog.logEndOffset())).andReturn((Object)BoxesRunTime.boxToLong((long)futureReplicaLEO)).anyTimes();
        EasyMock.expect((Object)futureLog.latestEpoch()).andStubReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)futureReplicaLeaderEpoch)));
        EasyMock.expect((Object)futureLog.endOffsetForEpoch(futureReplicaLeaderEpoch)).andReturn((Object)new Some((Object)new OffsetAndEpoch((long)futureReplicaLEO, futureReplicaLeaderEpoch)));
        EasyMock.expect((Object)replicaManager.localLog(this.t1p0())).andReturn((Object)new Some((Object)log)).anyTimes();
        EasyMock.expect((Object)partition.lastOffsetForLeaderEpoch(Optional.of(Predef$.MODULE$.int2Integer(1)), futureReplicaLeaderEpoch, false)).andReturn((Object)new EpochEndOffset(Errors.REPLICA_NOT_AVAILABLE, -1, -1L)).times(3).andReturn((Object)new EpochEndOffset(futureReplicaLeaderEpoch, (long)replicaLEO));
        EasyMock.expect((Object)replicaManager.logManager()).andReturn((Object)logManager).anyTimes();
        replicaManager.fetchMessages(EasyMock.anyLong(), EasyMock.anyInt(), EasyMock.anyInt(), EasyMock.anyInt(), BoxesRunTime.unboxToBoolean((Object)EasyMock.anyObject()), (Seq)EasyMock.anyObject(), (ReplicaQuota)EasyMock.anyObject(), (Function1)EasyMock.capture((Capture)responseCallback), (IsolationLevel)EasyMock.anyObject(), (Option)EasyMock.anyObject());
        EasyMock.expect((Object)BoxedUnit.UNIT).andAnswer(() -> {
            ReplicaAlterLogDirsThreadTest.$anonfun$shouldPollIndefinitelyIfReplicaNotAvailable$1(responseCallback);
            return BoxedUnit.UNIT;
        }).anyTimes();
        EasyMock.replay((Object[])new Object[]{replicaManager, logManager, quotaManager, partition, log, futureLog});
        BrokerEndPoint endPoint = new BrokerEndPoint(0, "localhost", 1000);
        ReplicaAlterLogDirsThread thread = new ReplicaAlterLogDirsThread("alter-logs-dirs-thread-test1", endPoint, config, this.failedPartitions(), replicaManager, quotaManager, null);
        Tuple2[] tuple2Array = new Tuple2[1];
        OffsetAndEpoch offsetAndEpoch = this.offsetAndEpoch(0L, this.offsetAndEpoch$default$2());
        Object object = Predef$.MODULE$.ArrowAssoc((Object)this.t1p0());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        thread.addPartitions((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array)));
        int n = 0;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        Range.Inclusive inclusive = RichInt$.MODULE$.to$extension0(n, 2);
        if (inclusive == null) {
            throw null;
        }
        Range.Inclusive foreach$mVc$sp_this = inclusive;
        if (!foreach$mVc$sp_this.isEmpty()) {
            int foreach$mVc$sp_i = foreach$mVc$sp_this.start();
            while (true) {
                thread.doWork();
                if (foreach$mVc$sp_i == foreach$mVc$sp_this.scala$collection$immutable$Range$$lastElement()) break;
                foreach$mVc$sp_i += foreach$mVc$sp_this.step();
            }
        }
        Assert.assertEquals((long)0L, (long)truncated.getValues().size());
        thread.doWork();
        Assert.assertEquals((long)futureReplicaLEO, (long)BoxesRunTime.unboxToLong((Object)truncated.getValue()));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void shouldFetchLeaderEpochOnFirstFetchOnly() {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20()));
        ReplicationQuotaManager quotaManager = (ReplicationQuotaManager)EasyMock.createNiceMock(ReplicationQuotaManager.class);
        LogManager logManager = (LogManager)EasyMock.createMock(LogManager.class);
        Log log = (Log)EasyMock.createNiceMock(Log.class);
        Log futureLog = (Log)EasyMock.createNiceMock(Log.class);
        Partition partition = (Partition)EasyMock.createMock(Partition.class);
        ReplicaManager replicaManager = (ReplicaManager)EasyMock.createMock(ReplicaManager.class);
        Capture responseCallback = EasyMock.newCapture();
        int leaderEpoch = 5;
        int futureReplicaLEO = 190;
        int replicaLEO = 213;
        EasyMock.expect((Object)replicaManager.getPartitionOrException(this.t1p0())).andStubReturn((Object)partition);
        EasyMock.expect((Object)partition.lastOffsetForLeaderEpoch(Optional.of(Predef$.MODULE$.int2Integer(1)), leaderEpoch, false)).andReturn((Object)new EpochEndOffset(leaderEpoch, (long)replicaLEO));
        partition.truncateTo((long)futureReplicaLEO, true);
        EasyMock.expect((Object)BoxedUnit.UNIT).once();
        EasyMock.expect((Object)replicaManager.futureLocalLogOrException(this.t1p0())).andStubReturn((Object)futureLog);
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)replicaManager.futureLogExists(this.t1p0()))).andStubReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        EasyMock.expect((Object)futureLog.latestEpoch()).andStubReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)leaderEpoch)));
        EasyMock.expect((Object)BoxesRunTime.boxToLong((long)futureLog.logEndOffset())).andStubReturn((Object)BoxesRunTime.boxToLong((long)futureReplicaLEO));
        EasyMock.expect((Object)futureLog.endOffsetForEpoch(leaderEpoch)).andReturn((Object)new Some((Object)new OffsetAndEpoch((long)futureReplicaLEO, leaderEpoch)));
        EasyMock.expect((Object)replicaManager.logManager()).andReturn((Object)logManager).anyTimes();
        this.stubWithFetchMessages(log, null, futureLog, partition, replicaManager, (Capture<Function1<Seq<Tuple2<TopicPartition, FetchPartitionData>>, BoxedUnit>>)responseCallback);
        EasyMock.replay((Object[])new Object[]{replicaManager, logManager, quotaManager, partition, log, futureLog});
        BrokerEndPoint endPoint = new BrokerEndPoint(0, "localhost", 1000);
        ReplicaAlterLogDirsThread thread = new ReplicaAlterLogDirsThread("alter-logs-dirs-thread-test1", endPoint, config, this.failedPartitions(), replicaManager, quotaManager, null);
        Tuple2[] tuple2Array = new Tuple2[1];
        OffsetAndEpoch offsetAndEpoch = this.offsetAndEpoch(0L, this.offsetAndEpoch$default$2());
        Object object = Predef$.MODULE$.ArrowAssoc((Object)this.t1p0());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        thread.addPartitions((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array)));
        int n = 0;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        Range.Inclusive inclusive = RichInt$.MODULE$.to$extension0(n, 3);
        if (inclusive == null) {
            throw null;
        }
        Range.Inclusive foreach$mVc$sp_this = inclusive;
        if (!foreach$mVc$sp_this.isEmpty()) {
            int foreach$mVc$sp_i = foreach$mVc$sp_this.start();
            while (true) {
                thread.doWork();
                if (foreach$mVc$sp_i == foreach$mVc$sp_this.scala$collection$immutable$Range$$lastElement()) break;
                foreach$mVc$sp_i += foreach$mVc$sp_this.step();
            }
        }
        EasyMock.verify((Object[])new Object[]{partition});
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void shouldFetchOneReplicaAtATime() {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        void $minus$greater$extension_y2;
        void $minus$greater$extension_$this2;
        void $minus$greater$extension_y3;
        void $minus$greater$extension_$this3;
        void $minus$greater$extension_y4;
        void $minus$greater$extension_$this4;
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20()));
        ReplicationQuotaManager quotaManager = (ReplicationQuotaManager)EasyMock.createNiceMock(ReplicationQuotaManager.class);
        LogManager logManager = (LogManager)EasyMock.createMock(LogManager.class);
        Log log = (Log)EasyMock.createNiceMock(Log.class);
        Log futureLog = (Log)EasyMock.createNiceMock(Log.class);
        Partition partition = (Partition)EasyMock.createMock(Partition.class);
        ReplicaManager replicaManager = (ReplicaManager)EasyMock.createMock(ReplicaManager.class);
        EasyMock.expect((Object)replicaManager.logManager()).andReturn((Object)logManager).anyTimes();
        this.stub(log, null, futureLog, partition, replicaManager);
        EasyMock.replay((Object[])new Object[]{replicaManager, logManager, quotaManager, partition, log});
        BrokerEndPoint endPoint = new BrokerEndPoint(0, "localhost", 1000);
        int leaderEpoch = 1;
        ReplicaAlterLogDirsThread thread = new ReplicaAlterLogDirsThread("alter-logs-dirs-thread-test1", endPoint, config, this.failedPartitions(), replicaManager, quotaManager, null);
        Tuple2[] tuple2Array = new Tuple2[2];
        OffsetAndEpoch offsetAndEpoch = this.offsetAndEpoch(0L, leaderEpoch);
        Object object = Predef$.MODULE$.ArrowAssoc((Object)this.t1p0());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this4, (Object)$minus$greater$extension_y4);
        OffsetAndEpoch offsetAndEpoch2 = this.offsetAndEpoch(0L, leaderEpoch);
        Object object2 = Predef$.MODULE$.ArrowAssoc((Object)this.t1p1());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[1] = new Tuple2((Object)$minus$greater$extension_$this3, (Object)$minus$greater$extension_y3);
        thread.addPartitions((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array)));
        Tuple2[] tuple2Array2 = new Tuple2[2];
        PartitionFetchState partitionFetchState = new PartitionFetchState(150L, (Option)None$.MODULE$, leaderEpoch, (Option)None$.MODULE$, (ReplicaState)Fetching$.MODULE$);
        Object object3 = Predef$.MODULE$.ArrowAssoc((Object)this.t1p0());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array2[0] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y2);
        PartitionFetchState partitionFetchState2 = new PartitionFetchState(160L, (Option)None$.MODULE$, leaderEpoch, (Option)None$.MODULE$, (ReplicaState)Fetching$.MODULE$);
        Object object4 = Predef$.MODULE$.ArrowAssoc((Object)this.t1p1());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array2[1] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        AbstractFetcherThread.ResultWithPartitions resultWithPartitions = thread.buildFetch((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array2)));
        if (resultWithPartitions == null) {
            throw new MatchError(null);
        }
        Option option = (Option)resultWithPartitions.result();
        Set set = resultWithPartitions.partitionsWithError();
        Option fetchRequestOpt = option;
        Set partitionsWithError = set;
        Assert.assertTrue((boolean)fetchRequestOpt.isDefined());
        FetchRequest.Builder fetchRequest = ((AbstractFetcherThread.ReplicaFetch)fetchRequestOpt.get()).fetchRequest();
        Assert.assertFalse((boolean)fetchRequest.fetchData().isEmpty());
        Assert.assertFalse((boolean)partitionsWithError.nonEmpty());
        FetchRequest request = (FetchRequest)fetchRequest.build();
        Assert.assertEquals((long)0L, (long)request.minBytes());
        Seq fetchInfos = ((MapLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(request.fetchData()).asScala()).toSeq();
        Assert.assertEquals((long)1L, (long)fetchInfos.length());
        Assert.assertEquals((String)"Expected fetch request for first partition", (Object)this.t1p0(), (Object)((Tuple2)fetchInfos.head())._1());
        Assert.assertEquals((long)150L, (long)((FetchRequest.PartitionData)((Tuple2)fetchInfos.head())._2()).fetchOffset);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void shouldFetchNonDelayedAndNonTruncatingReplicas() {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        void $minus$greater$extension_y2;
        void $minus$greater$extension_$this2;
        void $minus$greater$extension_y3;
        void $minus$greater$extension_$this3;
        void $minus$greater$extension_y4;
        void $minus$greater$extension_$this4;
        void $minus$greater$extension_y5;
        void $minus$greater$extension_$this5;
        void $minus$greater$extension_y6;
        void $minus$greater$extension_$this6;
        void $minus$greater$extension_y7;
        void $minus$greater$extension_$this7;
        void $minus$greater$extension_y8;
        void $minus$greater$extension_$this8;
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20()));
        ReplicationQuotaManager quotaManager = (ReplicationQuotaManager)EasyMock.createNiceMock(ReplicationQuotaManager.class);
        LogManager logManager = (LogManager)EasyMock.createMock(LogManager.class);
        Log log = (Log)EasyMock.createNiceMock(Log.class);
        Log futureLog = (Log)EasyMock.createNiceMock(Log.class);
        Partition partition = (Partition)EasyMock.createMock(Partition.class);
        ReplicaManager replicaManager = (ReplicaManager)EasyMock.createMock(ReplicaManager.class);
        int startOffset = 123;
        EasyMock.expect((Object)BoxesRunTime.boxToLong((long)futureLog.logStartOffset())).andReturn((Object)BoxesRunTime.boxToLong((long)startOffset)).anyTimes();
        EasyMock.expect((Object)replicaManager.logManager()).andReturn((Object)logManager).anyTimes();
        this.stub(log, null, futureLog, partition, replicaManager);
        EasyMock.replay((Object[])new Object[]{replicaManager, logManager, quotaManager, partition, log, futureLog});
        BrokerEndPoint endPoint = new BrokerEndPoint(0, "localhost", 1000);
        int leaderEpoch = 1;
        ReplicaAlterLogDirsThread thread = new ReplicaAlterLogDirsThread("alter-logs-dirs-thread-test1", endPoint, config, this.failedPartitions(), replicaManager, quotaManager, null);
        Tuple2[] tuple2Array = new Tuple2[2];
        OffsetAndEpoch offsetAndEpoch = this.offsetAndEpoch(0L, leaderEpoch);
        Object object = Predef$.MODULE$.ArrowAssoc((Object)this.t1p0());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this8, (Object)$minus$greater$extension_y8);
        OffsetAndEpoch offsetAndEpoch2 = this.offsetAndEpoch(0L, leaderEpoch);
        Object object2 = Predef$.MODULE$.ArrowAssoc((Object)this.t1p1());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[1] = new Tuple2((Object)$minus$greater$extension_$this7, (Object)$minus$greater$extension_y7);
        thread.addPartitions((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array)));
        Tuple2[] tuple2Array2 = new Tuple2[2];
        PartitionFetchState partitionFetchState = PartitionFetchState$.MODULE$.apply(150L, (Option)None$.MODULE$, leaderEpoch, (ReplicaState)Fetching$.MODULE$);
        Object object3 = Predef$.MODULE$.ArrowAssoc((Object)this.t1p0());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array2[0] = new Tuple2((Object)$minus$greater$extension_$this6, (Object)$minus$greater$extension_y6);
        PartitionFetchState partitionFetchState2 = PartitionFetchState$.MODULE$.apply(160L, (Option)None$.MODULE$, leaderEpoch, (ReplicaState)Truncating$.MODULE$);
        Object object4 = Predef$.MODULE$.ArrowAssoc((Object)this.t1p1());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array2[1] = new Tuple2((Object)$minus$greater$extension_$this5, (Object)$minus$greater$extension_y5);
        AbstractFetcherThread.ResultWithPartitions resultWithPartitions = thread.buildFetch((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array2)));
        if (resultWithPartitions == null) {
            throw new MatchError(null);
        }
        Option option = (Option)resultWithPartitions.result();
        Set set = resultWithPartitions.partitionsWithError();
        Option fetchRequestOpt = option;
        Set partitionsWithError = set;
        Assert.assertTrue((boolean)fetchRequestOpt.isDefined());
        AbstractFetcherThread.ReplicaFetch fetchRequest = (AbstractFetcherThread.ReplicaFetch)fetchRequestOpt.get();
        Assert.assertFalse((boolean)fetchRequest.partitionData().isEmpty());
        Assert.assertFalse((boolean)partitionsWithError.nonEmpty());
        Seq fetchInfos = ((MapLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(((FetchRequest)fetchRequest.fetchRequest().build()).fetchData()).asScala()).toSeq();
        Assert.assertEquals((long)1L, (long)fetchInfos.length());
        Assert.assertEquals((String)"Expected fetch request for non-truncating partition", (Object)this.t1p0(), (Object)((Tuple2)fetchInfos.head())._1());
        Assert.assertEquals((long)150L, (long)((FetchRequest.PartitionData)((Tuple2)fetchInfos.head())._2()).fetchOffset);
        Tuple2[] tuple2Array3 = new Tuple2[2];
        PartitionFetchState partitionFetchState3 = PartitionFetchState$.MODULE$.apply(140L, (Option)None$.MODULE$, leaderEpoch, (ReplicaState)Fetching$.MODULE$);
        Object object5 = Predef$.MODULE$.ArrowAssoc((Object)this.t1p0());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array3[0] = new Tuple2((Object)$minus$greater$extension_$this4, (Object)$minus$greater$extension_y4);
        PartitionFetchState partitionFetchState4 = new PartitionFetchState(160L, (Option)None$.MODULE$, leaderEpoch, (Option)new Some((Object)new DelayedItem(5000L)), (ReplicaState)Fetching$.MODULE$);
        Object object6 = Predef$.MODULE$.ArrowAssoc((Object)this.t1p1());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array3[1] = new Tuple2((Object)$minus$greater$extension_$this3, (Object)$minus$greater$extension_y3);
        AbstractFetcherThread.ResultWithPartitions resultWithPartitions2 = thread.buildFetch((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array3)));
        if (resultWithPartitions2 == null) {
            throw new MatchError(null);
        }
        Option option2 = (Option)resultWithPartitions2.result();
        Set set2 = resultWithPartitions2.partitionsWithError();
        Option fetchRequest2Opt = option2;
        Set partitionsWithError2 = set2;
        Assert.assertTrue((boolean)fetchRequest2Opt.isDefined());
        AbstractFetcherThread.ReplicaFetch fetchRequest2 = (AbstractFetcherThread.ReplicaFetch)fetchRequest2Opt.get();
        Assert.assertFalse((boolean)fetchRequest2.partitionData().isEmpty());
        Assert.assertFalse((boolean)partitionsWithError2.nonEmpty());
        Seq fetchInfos2 = ((MapLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(((FetchRequest)fetchRequest2.fetchRequest().build()).fetchData()).asScala()).toSeq();
        Assert.assertEquals((long)1L, (long)fetchInfos2.length());
        Assert.assertEquals((String)"Expected fetch request for non-delayed partition", (Object)this.t1p0(), (Object)((Tuple2)fetchInfos2.head())._1());
        Assert.assertEquals((long)140L, (long)((FetchRequest.PartitionData)((Tuple2)fetchInfos2.head())._2()).fetchOffset);
        Tuple2[] tuple2Array4 = new Tuple2[2];
        PartitionFetchState partitionFetchState5 = new PartitionFetchState(140L, (Option)None$.MODULE$, leaderEpoch, (Option)new Some((Object)new DelayedItem(5000L)), (ReplicaState)Fetching$.MODULE$);
        Object object7 = Predef$.MODULE$.ArrowAssoc((Object)this.t1p0());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array4[0] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y2);
        PartitionFetchState partitionFetchState6 = new PartitionFetchState(160L, (Option)None$.MODULE$, leaderEpoch, (Option)new Some((Object)new DelayedItem(5000L)), (ReplicaState)Fetching$.MODULE$);
        Object object8 = Predef$.MODULE$.ArrowAssoc((Object)this.t1p1());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array4[1] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        AbstractFetcherThread.ResultWithPartitions resultWithPartitions3 = thread.buildFetch((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array4)));
        if (resultWithPartitions3 == null) {
            throw new MatchError(null);
        }
        Option option3 = (Option)resultWithPartitions3.result();
        Set set3 = resultWithPartitions3.partitionsWithError();
        Option fetchRequest3Opt = option3;
        Set partitionsWithError3 = set3;
        Assert.assertTrue((String)"Expected no fetch requests since all partitions are delayed", (boolean)fetchRequest3Opt.isEmpty());
        Assert.assertFalse((boolean)partitionsWithError3.nonEmpty());
    }

    public IExpectationSetters<Option<Partition>> stub(Log logT1p0, Log logT1p1, Log futureLog, Partition partition, ReplicaManager replicaManager) {
        EasyMock.expect((Object)replicaManager.localLog(this.t1p0())).andReturn((Object)new Some((Object)logT1p0)).anyTimes();
        EasyMock.expect((Object)replicaManager.localLogOrException(this.t1p0())).andReturn((Object)logT1p0).anyTimes();
        EasyMock.expect((Object)replicaManager.futureLocalLogOrException(this.t1p0())).andReturn((Object)futureLog).anyTimes();
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)replicaManager.futureLogExists(this.t1p0()))).andStubReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        EasyMock.expect((Object)replicaManager.nonOfflinePartition(this.t1p0())).andReturn((Object)new Some((Object)partition)).anyTimes();
        EasyMock.expect((Object)replicaManager.localLog(this.t1p1())).andReturn((Object)new Some((Object)logT1p1)).anyTimes();
        EasyMock.expect((Object)replicaManager.localLogOrException(this.t1p1())).andReturn((Object)logT1p1).anyTimes();
        EasyMock.expect((Object)replicaManager.futureLocalLogOrException(this.t1p1())).andReturn((Object)futureLog).anyTimes();
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)replicaManager.futureLogExists(this.t1p1()))).andStubReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        return EasyMock.expect((Object)replicaManager.nonOfflinePartition(this.t1p1())).andReturn((Object)new Some((Object)partition)).anyTimes();
    }

    public IExpectationSetters<BoxedUnit> stubWithFetchMessages(Log logT1p0, Log logT1p1, Log futureLog, Partition partition, ReplicaManager replicaManager, Capture<Function1<Seq<Tuple2<TopicPartition, FetchPartitionData>>, BoxedUnit>> responseCallback) {
        this.stub(logT1p0, logT1p1, futureLog, partition, replicaManager);
        replicaManager.fetchMessages(EasyMock.anyLong(), EasyMock.anyInt(), EasyMock.anyInt(), EasyMock.anyInt(), BoxesRunTime.unboxToBoolean((Object)EasyMock.anyObject()), (Seq)EasyMock.anyObject(), (ReplicaQuota)EasyMock.anyObject(), (Function1)EasyMock.capture(responseCallback), (IsolationLevel)EasyMock.anyObject(), (Option)EasyMock.anyObject());
        return EasyMock.expect((Object)BoxedUnit.UNIT).andAnswer(() -> {
            ReplicaAlterLogDirsThreadTest.$anonfun$stubWithFetchMessages$1(responseCallback);
            return BoxedUnit.UNIT;
        }).anyTimes();
    }

    public static final /* synthetic */ void $anonfun$mockFetchFromCurrentLog$1(ArgumentCaptor callbackCaptor$1, TopicPartition topicPartition$1, FetchPartitionData responseData$1, InvocationOnMock x$2) {
        ((Function1)callbackCaptor$1.getValue()).apply((Object)new .colon.colon((Object)new Tuple2((Object)topicPartition$1, (Object)responseData$1), (List)Nil$.MODULE$));
    }

    public static final /* synthetic */ void $anonfun$shouldPollIndefinitelyIfReplicaNotAvailable$1(Capture responseCallback$1) {
        ((Function1)responseCallback$1.getValue()).apply((Object)Nil$.MODULE$);
    }

    public static final /* synthetic */ void $anonfun$stubWithFetchMessages$1(Capture responseCallback$2) {
        ((Function1)responseCallback$2.getValue()).apply((Object)Nil$.MODULE$);
    }

    public static final /* synthetic */ Object $anonfun$shouldUpdateLeaderEpochAfterFencedEpochError$1$adapted(PartitionFetchState x$1) {
        return BoxesRunTime.boxToInteger((int)x$1.currentLeaderEpoch());
    }
}

