/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Properties;
import joptsimple.OptionException;
import kafka.admin.ConsumerGroupCommand;
import kafka.admin.ConsumerGroupCommandTest;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.TopicPartition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer$;
import scala.jdk.CollectionConverters$;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\t\u001dd\u0001B\u00193\u0001]BQ\u0001\u0010\u0001\u0005\u0002uBqa\u0010\u0001C\u0002\u0013\u0005\u0001\t\u0003\u0004J\u0001\u0001\u0006I!\u0011\u0005\b\u0015\u0002\u0011\r\u0011\"\u0001L\u0011\u0019\u0011\u0006\u0001)A\u0005\u0019\"91\u000b\u0001b\u0001\n\u0003Y\u0005B\u0002+\u0001A\u0003%A\nC\u0003V\u0001\u0011\u0005c\u000bC\u0003f\u0001\u0011%a\rC\u0003v\u0001\u0011%a\u000f\u0003\u0004\u0000\u0001\u0011%\u0011\u0011\u0001\u0005\b\u0003\u0013\u0001A\u0011BA\u0006\u0011\u001d\ty\u0001\u0001C\u0001\u0003#Aq!a\r\u0001\t\u0003\t\t\u0002C\u0004\u00028\u0001!\t!!\u0005\t\u000f\u0005m\u0002\u0001\"\u0001\u0002\u0012!9\u0011q\b\u0001\u0005\u0002\u0005E\u0001bBA\"\u0001\u0011\u0005\u0011\u0011\u0003\u0005\b\u0003\u000f\u0002A\u0011AA\t\u0011\u001d\tY\u0005\u0001C\u0001\u0003#Aq!a\u0014\u0001\t\u0003\t\t\u0002C\u0004\u0002T\u0001!\t!!\u0005\t\u000f\u0005]\u0003\u0001\"\u0001\u0002\u0012!9\u00111\f\u0001\u0005\u0002\u0005E\u0001bBA0\u0001\u0011\u0005\u0011\u0011\u0003\u0005\b\u0003G\u0002A\u0011AA\t\u0011\u001d\t9\u0007\u0001C\u0001\u0003#Aq!a\u001b\u0001\t\u0003\t\t\u0002C\u0004\u0002p\u0001!\t!!\u0005\t\u000f\u0005M\u0004\u0001\"\u0001\u0002\u0012!9\u0011q\u000f\u0001\u0005\u0002\u0005E\u0001bBA>\u0001\u0011\u0005\u0011\u0011\u0003\u0005\b\u0003\u007f\u0002A\u0011AA\t\u0011\u001d\t\u0019\t\u0001C\u0001\u0003#Aq!a\"\u0001\t\u0003\t\t\u0002C\u0004\u0002\f\u0002!\t!!\u0005\t\u000f\u0005=\u0005\u0001\"\u0003\u0002\u0012\"9\u0011\u0011\u0015\u0001\u0005\n\u0005\r\u0006\"CAY\u0001E\u0005I\u0011BAZ\u0011\u001d\tI\r\u0001C\u0005\u0003\u0017D\u0011\"a7\u0001#\u0003%I!!8\t\u0013\u0005\u0005\b!%A\u0005\n\u0005u\u0007bBAr\u0001\u0011%\u0011Q\u001d\u0005\b\u0005\u0007\u0001A\u0011\u0002B\u0003\u0011%\u0011Y\u0002AI\u0001\n\u0013\u0011i\u0002C\u0005\u0003\"\u0001\t\n\u0011\"\u0003\u0003$!9!q\u0005\u0001\u0005\n\t%\u0002b\u0002B&\u0001\u0011%!Q\n\u0002\u001d%\u0016\u001cX\r^\"p]N,X.\u001a:He>,\bo\u00144gg\u0016$H+Z:u\u0015\t\u0019D'A\u0003bI6LgNC\u00016\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u0001\u001d\u0011\u0005eRT\"\u0001\u001a\n\u0005m\u0012$\u0001G\"p]N,X.\u001a:He>,\boQ8n[\u0006tG\rV3ti\u00061A(\u001b8jiz\"\u0012A\u0010\t\u0003s\u0001\tqb\u001c<feJLG-\u001b8h!J|\u0007o]\u000b\u0002\u0003B\u0011!iR\u0007\u0002\u0007*\u0011A)R\u0001\u0005kRLGNC\u0001G\u0003\u0011Q\u0017M^1\n\u0005!\u001b%A\u0003)s_B,'\u000f^5fg\u0006\u0001rN^3se&$\u0017N\\4Qe>\u00048\u000fI\u0001\u0007i>\u0004\u0018nY\u0019\u0016\u00031\u0003\"!\u0014)\u000e\u00039S!aT#\u0002\t1\fgnZ\u0005\u0003#:\u0013aa\u0015;sS:<\u0017a\u0002;pa&\u001c\u0017\u0007I\u0001\u0007i>\u0004\u0018n\u0019\u001a\u0002\u000fQ|\u0007/[23A\u0005yq-\u001a8fe\u0006$XmQ8oM&<7/F\u0001X!\rAVlX\u0007\u00023*\u0011!lW\u0001\u000bG>dG.Z2uS>t'\"\u0001/\u0002\u000bM\u001c\u0017\r\\1\n\u0005yK&aA*fcB\u0011\u0001mY\u0007\u0002C*\u0011!\rN\u0001\u0007g\u0016\u0014h/\u001a:\n\u0005\u0011\f'aC&bM.\f7i\u001c8gS\u001e\f\u0011BY1tS\u000e\f%oZ:\u0016\u0003\u001d\u00042\u0001[5l\u001b\u0005Y\u0016B\u00016\\\u0005\u0015\t%O]1z!\ta7O\u0004\u0002ncB\u0011anW\u0007\u0002_*\u0011\u0001ON\u0001\u0007yI|w\u000e\u001e \n\u0005I\\\u0016A\u0002)sK\u0012,g-\u0003\u0002Ri*\u0011!oW\u0001\u0013EVLG\u000eZ!sON4uN]$s_V\u00048\u000fF\u0002hojDQ\u0001\u001f\u0006A\u0002e\faa\u001a:pkB\u001c\bc\u0001-^W\")1P\u0003a\u0001y\u0006!\u0011M]4t!\rAWp[\u0005\u0003}n\u0013!\u0002\u0010:fa\u0016\fG/\u001a3?\u0003E\u0011W/\u001b7e\u0003J<7OR8s\u000fJ|W\u000f\u001d\u000b\u0006O\u0006\r\u0011q\u0001\u0005\u0007\u0003\u000bY\u0001\u0019A6\u0002\u000b\u001d\u0014x.\u001e9\t\u000bm\\\u0001\u0019\u0001?\u0002+\t,\u0018\u000e\u001c3Be\u001e\u001chi\u001c:BY2<%o\\;qgR\u0019q-!\u0004\t\u000bmd\u0001\u0019\u0001?\u0002AQ,7\u000f\u001e*fg\u0016$xJ\u001a4tKR\u001chj\u001c;Fq&\u001cH/\u001b8h\u000fJ|W\u000f\u001d\u000b\u0003\u0003'\u00012\u0001[A\u000b\u0013\r\t9b\u0017\u0002\u0005+:LG\u000fK\u0002\u000e\u00037\u0001B!!\b\u000205\u0011\u0011q\u0004\u0006\u0005\u0003C\t\u0019#A\u0002ba&TA!!\n\u0002(\u00059!.\u001e9ji\u0016\u0014(\u0002BA\u0015\u0003W\tQA[;oSRT!!!\f\u0002\u0007=\u0014x-\u0003\u0003\u00022\u0005}!\u0001\u0002+fgR\fQ\u0004^3tiJ+7/\u001a;PM\u001a\u001cX\r^:Fq&\u001cH/\u001b8h)>\u0004\u0018n\u0019\u0015\u0004\u001d\u0005m\u0011a\u000b;fgR\u0014Vm]3u\u001f\u001a47/\u001a;t\u000bbL7\u000f^5oOR{\u0007/[2TK2,7\r^3e\u000fJ|W\u000f]:)\u0007=\tY\"\u0001\u0014uKN$(+Z:fi>3gm]3ug\u0016C\u0018n\u001d;j]\u001e$v\u000e]5d\u00032dwI]8vaND3\u0001EA\u000e\u0003\t\"Xm\u001d;SKN,Go\u00144gg\u0016$8/\u00117m)>\u0004\u0018nY:BY2<%o\\;qg\"\u001a\u0011#a\u0007\u0002?Q,7\u000f\u001e*fg\u0016$xJ\u001a4tKR\u001cHk\u001c'pG\u0006dG)\u0019;f)&lW\rK\u0002\u0013\u00037\tq\u0004^3tiJ+7/\u001a;PM\u001a\u001cX\r^:U_j{g.\u001a3ECR,G+[7fQ\r\u0019\u00121D\u0001\u001bi\u0016\u001cHOU3tKR|eMZ:fiN\u0014\u0015\u0010R;sCRLwN\u001c\u0015\u0004)\u0005m\u0011\u0001\n;fgR\u0014Vm]3u\u001f\u001a47/\u001a;t\u0005f$UO]1uS>tGk\\#be2LWm\u001d;)\u0007U\tY\"\u0001\u000euKN$(+Z:fi>3gm]3ugR{W)\u0019:mS\u0016\u001cH\u000fK\u0002\u0017\u00037\t\u0001\u0004^3tiJ+7/\u001a;PM\u001a\u001cX\r^:U_2\u000bG/Z:uQ\r9\u00121D\u0001 i\u0016\u001cHOU3tKR|eMZ:fiN$vnQ;se\u0016tGo\u00144gg\u0016$\bf\u0001\r\u0002\u001c\u0005\u0001C/Z:u%\u0016\u001cX\r^(gMN,Go\u001d+p'B,7-\u001b4jG>3gm]3uQ\rI\u00121D\u0001\u001ai\u0016\u001cHOU3tKR|eMZ:fiN\u001c\u0006.\u001b4u!2,8\u000fK\u0002\u001b\u00037\t!\u0004^3tiJ+7/\u001a;PM\u001a\u001cX\r^:TQ&4G/T5okND3aGA\u000e\u0003!\"Xm\u001d;SKN,Go\u00144gg\u0016$8o\u00155jMR\u0014\u0015\u0010T8xKJ$\u0006.\u00198FCJd\u0017.Z:uQ\ra\u00121D\u0001(i\u0016\u001cHOU3tKR|eMZ:fiN\u001c\u0006.\u001b4u\u0005fD\u0015n\u001a5feRC\u0017M\u001c'bi\u0016\u001cH\u000fK\u0002\u001e\u00037\tA\u0005^3tiJ+7/\u001a;PM\u001a\u001cX\r^:U_\u0016\u000b'\u000f\\5fgR|en\u00148f)>\u0004\u0018n\u0019\u0015\u0004=\u0005m\u0011\u0001\r;fgR\u0014Vm]3u\u001f\u001a47/\u001a;t)>,\u0015M\u001d7jKN$xJ\\(oKR{\u0007/[2B]\u0012\u0004\u0016M\u001d;ji&|g\u000eK\u0002 \u00037\t!\u0005^3tiJ+7/\u001a;PM\u001a\u001cX\r^:U_\u0016\u000b'\u000f\\5fgR|e\u000eV8qS\u000e\u001c\bf\u0001\u0011\u0002\u001c\u0005yC/Z:u%\u0016\u001cX\r^(gMN,Go\u001d+p\u000b\u0006\u0014H.[3ti>sGk\u001c9jGN\fe\u000e\u001a)beRLG/[8og\"\u001a\u0011%a\u0007\u0002]Q,7\u000f\u001e*fg\u0016$xJ\u001a4tKR\u001cX\t\u001f9peRLU\u000e]8siBc\u0017M\\*j]\u001edWm\u0012:pkB\f%o\u001a\u0015\u0004E\u0005m\u0011\u0001\t;fgR\u0014Vm]3u\u001f\u001a47/\u001a;t\u000bb\u0004xN\u001d;J[B|'\u000f\u001e)mC:D3aIA\u000e\u0003)\"Xm\u001d;SKN,GoV5uQVs'/Z2pO:L'0\u001a3OK^\u001cuN\\:v[\u0016\u0014x\n\u001d;j_:D3\u0001JA\u000e\u0003=\u0001(o\u001c3vG\u0016lUm]:bO\u0016\u001cHCBA\n\u0003'\u000b9\n\u0003\u0004\u0002\u0016\u0016\u0002\ra[\u0001\u0006i>\u0004\u0018n\u0019\u0005\b\u00033+\u0003\u0019AAN\u0003-qW/\\'fgN\fw-Z:\u0011\u0007!\fi*C\u0002\u0002 n\u00131!\u00138u\u0003e\u0001(o\u001c3vG\u0016\u001cuN\\:v[\u0016\fe\u000eZ*ikR$wn\u001e8\u0015\u0015\u0005M\u0011QUAT\u0003S\u000bi\u000b\u0003\u0004\u0002\u0016\u001a\u0002\ra\u001b\u0005\u0007\u0003\u000b1\u0003\u0019A6\t\u000f\u0005-f\u00051\u0001\u0002\u001c\u0006iAo\u001c;bY6+7o]1hKND\u0011\"a,'!\u0003\u0005\r!a'\u0002\u00199,XnQ8ogVlWM]:\u0002GA\u0014x\u000eZ;dK\u000e{gn];nK\u0006sGm\u00155vi\u0012|wO\u001c\u0013eK\u001a\fW\u000f\u001c;%iU\u0011\u0011Q\u0017\u0016\u0005\u00037\u000b9l\u000b\u0002\u0002:B!\u00111XAc\u001b\t\tiL\u0003\u0003\u0002@\u0006\u0005\u0017!C;oG\",7m[3e\u0015\r\t\u0019mW\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BAd\u0003{\u0013\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003U\tw/Y5u\u0007>t7/^7feB\u0013xn\u001a:fgN$\u0002\"a\u0005\u0002N\u0006=\u0017\u0011\u001b\u0005\t\u0003+C\u0003\u0013!a\u0001W\"A\u0011Q\u0001\u0015\u0011\u0002\u0003\u00071\u000eC\u0004\u0002T\"\u0002\r!!6\u0002\u000b\r|WO\u001c;\u0011\u0007!\f9.C\u0002\u0002Zn\u0013A\u0001T8oO\u0006y\u0012m^1ji\u000e{gn];nKJ\u0004&o\\4sKN\u001cH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005}'fA6\u00028\u0006y\u0012m^1ji\u000e{gn];nKJ\u0004&o\\4sKN\u001cH\u0005Z3gCVdG\u000f\n\u001a\u00025\u0005<\u0018-\u001b;D_:\u001cX/\\3s\u000fJ|W\u000f]%oC\u000e$\u0018N^3\u0015\r\u0005M\u0011q\u001dB\u0001\u0011\u001d\tIo\u000ba\u0001\u0003W\fAcY8ogVlWM]$s_V\u00048+\u001a:wS\u000e,\u0007\u0003BAw\u0003wtA!a<\u0002x:!\u0011\u0011_A{\u001d\rq\u00171_\u0005\u0002k%\u00111\u0007N\u0005\u0004\u0003s\u0014\u0014\u0001F\"p]N,X.\u001a:He>,\boQ8n[\u0006tG-\u0003\u0003\u0002~\u0006}(\u0001F\"p]N,X.\u001a:He>,\boU3sm&\u001cWMC\u0002\u0002zJBa!!\u0002,\u0001\u0004Y\u0017!\u0006:fg\u0016$\u0018I\u001c3BgN,'\u000f^(gMN,Go\u001d\u000b\u000b\u0003'\u00119A!\u0003\u0003\u000e\t]\u0001\"B>-\u0001\u00049\u0007b\u0002B\u0006Y\u0001\u0007\u0011Q[\u0001\u000fKb\u0004Xm\u0019;fI>3gm]3u\u0011%\u0011y\u0001\fI\u0001\u0002\u0004\u0011\t\"\u0001\u0004eef\u0014VO\u001c\t\u0004Q\nM\u0011b\u0001B\u000b7\n9!i\\8mK\u0006t\u0007\u0002\u0003B\rYA\u0005\t\u0019A=\u0002\rQ|\u0007/[2t\u0003}\u0011Xm]3u\u0003:$\u0017i]:feR|eMZ:fiN$C-\u001a4bk2$HeM\u000b\u0003\u0005?QCA!\u0005\u00028\u0006y\"/Z:fi\u0006sG-Q:tKJ$xJ\u001a4tKR\u001cH\u0005Z3gCVdG\u000f\n\u001b\u0016\u0005\t\u0015\"fA=\u00028\u0006q\"/Z:fi\u0006sG-Q:tKJ$xJ\u001a4tKR\u001c8i\\7nSR$X\r\u001a\u000b\t\u0003'\u0011YC!\f\u0003J!9\u0011\u0011^\u0018A\u0002\u0005-\bb\u0002B\u0018_\u0001\u0007!\u0011G\u0001\u0010Kb\u0004Xm\u0019;fI>3gm]3ugB9ANa\r\u00038\u0005U\u0017b\u0001B\u001bi\n\u0019Q*\u00199\u0011\t\te\"QI\u0007\u0003\u0005wQAA!\u0010\u0003@\u000511m\\7n_:T1!\u000eB!\u0015\u0011\u0011\u0019%a\u000b\u0002\r\u0005\u0004\u0018m\u00195f\u0013\u0011\u00119Ea\u000f\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]\"1\u0011QS\u0018A\u0002-\fAB]3tKR|eMZ:fiN$BAa\u0014\u0003fA1\u0001L!\u0015l\u0005'J1A!\u000eZ!\u001dA&\u0011\u000bB\u001c\u0005+\u0002BAa\u0016\u0003b5\u0011!\u0011\f\u0006\u0005\u00057\u0012i&\u0001\u0005d_:\u001cX/\\3s\u0015\u0011\u0011yFa\u0010\u0002\u000f\rd\u0017.\u001a8ug&!!1\rB-\u0005EyeMZ:fi\u0006sG-T3uC\u0012\fG/\u0019\u0005\b\u0003S\u0004\u0004\u0019AAv\u0001")
public class ResetConsumerGroupOffsetTest
extends ConsumerGroupCommandTest {
    private final Properties overridingProps = new Properties();
    private final String topic1;
    private final String topic2;

    public Properties overridingProps() {
        return this.overridingProps;
    }

    public String topic1() {
        return this.topic1;
    }

    public String topic2() {
        return this.topic2;
    }

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        return (Seq)TestUtils$.MODULE$.createBrokerConfigs(1, this.zkConnect(), false, TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13(), TestUtils$.MODULE$.createBrokerConfigs$default$14(), TestUtils$.MODULE$.createBrokerConfigs$default$15(), TestUtils$.MODULE$.createBrokerConfigs$default$16()).map((Function1 & Serializable & scala.Serializable)x$1 -> KafkaConfig$.MODULE$.fromProps(x$1, this.overridingProps()), Seq$.MODULE$.canBuildFrom());
    }

    private String[] basicArgs() {
        return (String[])((Object[])new String[]{"--reset-offsets", "--bootstrap-server", this.brokerList(), "--timeout", Long.toString(15000L)});
    }

    private String[] buildArgsForGroups(Seq<String> groups, Seq<String> args) {
        String[] groupArgs = (String[])((TraversableOnce)groups.flatMap((Function1 & Serializable & scala.Serializable)group -> new .colon.colon((Object)"--group", (List)new .colon.colon(group, (List)Nil$.MODULE$)), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(String.class));
        return (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.basicArgs())).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])groupArgs)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).$plus$plus(args, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
    }

    private String[] buildArgsForGroup(String group, Seq<String> args) {
        return this.buildArgsForGroups((Seq<String>)new .colon.colon((Object)group, (List)Nil$.MODULE$), args);
    }

    private String[] buildArgsForAllGroups(Seq<String> args) {
        return (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.basicArgs())).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new String[]{"--all-groups"})), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).$plus$plus(args, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testResetOffsetsNotExistingGroup() {
        String group = "missing.group";
        String[] args = this.buildArgsForGroup(group, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--all-topics", "--to-current", "--execute"}));
        ConsumerGroupCommand.ConsumerGroupService consumerGroupCommand = this.getConsumerGroupService(args);
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ResetConsumerGroupOffsetTest.$anonfun$testResetOffsetsNotExistingGroup$1(consumerGroupCommand, group)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ResetConsumerGroupOffsetTest.$anonfun$testResetOffsetsNotExistingGroup$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Map resetOffsets = (Map)consumerGroupCommand.resetOffsets().apply((Object)group);
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().empty(), (Object)resetOffsets);
        String x$2 = this.committedOffsets$default$1();
        Assertions.assertEquals((Object)resetOffsets, this.committedOffsets(x$2, group));
    }

    @Test
    public void testResetOffsetsExistingTopic() {
        String group = "new.group";
        String[] args = this.buildArgsForGroup(group, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--topic", this.topic(), "--to-offset", "50"}));
        this.produceMessages(this.topic(), 100);
        this.resetAndAssertOffsets(args, 50L, true, this.resetAndAssertOffsets$default$4());
        this.resetAndAssertOffsets((String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])args)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new String[]{"--dry-run"})), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))), 50L, true, this.resetAndAssertOffsets$default$4());
        this.resetAndAssertOffsets((String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])args)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new String[]{"--execute"})), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))), 50L, this.resetAndAssertOffsets$default$3(), this.resetAndAssertOffsets$default$4());
    }

    @Test
    public void testResetOffsetsExistingTopicSelectedGroups() {
        this.produceMessages(this.topic(), 100);
        IndexedSeq groups = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 3).map((Function1 & Serializable & scala.Serializable)id -> ResetConsumerGroupOffsetTest.$anonfun$testResetOffsetsExistingTopicSelectedGroups$1(this, BoxesRunTime.unboxToInt((Object)id)), IndexedSeq$.MODULE$.canBuildFrom());
        String[] args = this.buildArgsForGroups((Seq<String>)groups, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--topic", this.topic(), "--to-offset", "50"}));
        this.resetAndAssertOffsets(args, 50L, true, this.resetAndAssertOffsets$default$4());
        this.resetAndAssertOffsets((String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])args)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new String[]{"--dry-run"})), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))), 50L, true, this.resetAndAssertOffsets$default$4());
        this.resetAndAssertOffsets((String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])args)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new String[]{"--execute"})), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))), 50L, this.resetAndAssertOffsets$default$3(), this.resetAndAssertOffsets$default$4());
    }

    @Test
    public void testResetOffsetsExistingTopicAllGroups() {
        String[] args = this.buildArgsForAllGroups((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--topic", this.topic(), "--to-offset", "50"}));
        this.produceMessages(this.topic(), 100);
        ((IterableLike)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 3).map((Function1 & Serializable & scala.Serializable)x$2 -> ResetConsumerGroupOffsetTest.$anonfun$testResetOffsetsExistingTopicAllGroups$1(this, BoxesRunTime.unboxToInt((Object)x$2)), IndexedSeq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)group -> {
            ResetConsumerGroupOffsetTest.$anonfun$testResetOffsetsExistingTopicAllGroups$2(this, group);
            return BoxedUnit.UNIT;
        });
        this.resetAndAssertOffsets(args, 50L, true, this.resetAndAssertOffsets$default$4());
        this.resetAndAssertOffsets((String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])args)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new String[]{"--dry-run"})), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))), 50L, true, this.resetAndAssertOffsets$default$4());
        this.resetAndAssertOffsets((String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])args)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new String[]{"--execute"})), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))), 50L, this.resetAndAssertOffsets$default$3(), this.resetAndAssertOffsets$default$4());
    }

    @Test
    public void testResetOffsetsAllTopicsAllGroups() {
        String[] args = this.buildArgsForAllGroups((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--all-topics", "--to-offset", "50"}));
        IndexedSeq topics = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 3).map((Function1 & Serializable & scala.Serializable)x$3 -> ResetConsumerGroupOffsetTest.$anonfun$testResetOffsetsAllTopicsAllGroups$1(this, BoxesRunTime.unboxToInt((Object)x$3)), IndexedSeq$.MODULE$.canBuildFrom());
        IndexedSeq groups = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 3).map((Function1 & Serializable & scala.Serializable)x$4 -> ResetConsumerGroupOffsetTest.$anonfun$testResetOffsetsAllTopicsAllGroups$2(this, BoxesRunTime.unboxToInt((Object)x$4)), IndexedSeq$.MODULE$.canBuildFrom());
        topics.foreach((Function1 & Serializable & scala.Serializable)topic -> {
            this.produceMessages(topic, 100);
            return BoxedUnit.UNIT;
        });
        topics.foreach((Function1 & Serializable & scala.Serializable)topic -> {
            groups.foreach((Function1 & Serializable & scala.Serializable)group -> {
                ResetConsumerGroupOffsetTest.$anonfun$testResetOffsetsAllTopicsAllGroups$5($this, topic, group);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        });
        this.resetAndAssertOffsets(args, 50L, true, (Seq<String>)topics);
        this.resetAndAssertOffsets((String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])args)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new String[]{"--dry-run"})), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))), 50L, true, (Seq<String>)topics);
        String[] x$42 = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])args)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new String[]{"--execute"})), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        long x$5 = 50L;
        boolean x$7 = this.resetAndAssertOffsets$default$3();
        this.resetAndAssertOffsets(x$42, x$5, x$7, (Seq<String>)topics);
    }

    @Test
    public void testResetOffsetsToLocalDateTime() {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, -1);
        this.produceMessages(this.topic(), 100);
        ConsumerGroupCommandTest.ConsumerGroupExecutor executor = this.addConsumerGroupExecutor(1, this.topic(), this.addConsumerGroupExecutor$default$3(), this.addConsumerGroupExecutor$default$4(), this.addConsumerGroupExecutor$default$5(), this.addConsumerGroupExecutor$default$6());
        long x$1 = 100L;
        String x$2 = this.awaitConsumerProgress$default$1();
        String x$3 = this.awaitConsumerProgress$default$2();
        this.awaitConsumerProgress(x$2, x$3, x$1);
        executor.shutdown();
        String[] args = this.buildArgsForGroup(this.group(), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--all-topics", "--to-datetime", format.format(calendar.getTime()), "--execute"}));
        this.resetAndAssertOffsets(args, 0L, this.resetAndAssertOffsets$default$3(), this.resetAndAssertOffsets$default$4());
    }

    @Test
    public void testResetOffsetsToZonedDateTime() {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSXXX");
        this.produceMessages(this.topic(), 50);
        Date checkpoint = new Date();
        this.produceMessages(this.topic(), 50);
        ConsumerGroupCommandTest.ConsumerGroupExecutor executor = this.addConsumerGroupExecutor(1, this.topic(), this.addConsumerGroupExecutor$default$3(), this.addConsumerGroupExecutor$default$4(), this.addConsumerGroupExecutor$default$5(), this.addConsumerGroupExecutor$default$6());
        long x$1 = 100L;
        String x$2 = this.awaitConsumerProgress$default$1();
        String x$3 = this.awaitConsumerProgress$default$2();
        this.awaitConsumerProgress(x$2, x$3, x$1);
        executor.shutdown();
        String[] args = this.buildArgsForGroup(this.group(), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--all-topics", "--to-datetime", format.format(checkpoint), "--execute"}));
        this.resetAndAssertOffsets(args, 50L, this.resetAndAssertOffsets$default$3(), this.resetAndAssertOffsets$default$4());
    }

    @Test
    public void testResetOffsetsByDuration() {
        String[] args = this.buildArgsForGroup(this.group(), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--all-topics", "--by-duration", "PT1M", "--execute"}));
        this.produceConsumeAndShutdown(this.topic(), this.group(), 100, this.produceConsumeAndShutdown$default$4());
        this.resetAndAssertOffsets(args, 0L, this.resetAndAssertOffsets$default$3(), this.resetAndAssertOffsets$default$4());
    }

    @Test
    public void testResetOffsetsByDurationToEarliest() {
        String[] args = this.buildArgsForGroup(this.group(), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--all-topics", "--by-duration", "PT0.1S", "--execute"}));
        this.produceConsumeAndShutdown(this.topic(), this.group(), 100, this.produceConsumeAndShutdown$default$4());
        this.resetAndAssertOffsets(args, 100L, this.resetAndAssertOffsets$default$3(), this.resetAndAssertOffsets$default$4());
    }

    @Test
    public void testResetOffsetsToEarliest() {
        String[] args = this.buildArgsForGroup(this.group(), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--all-topics", "--to-earliest", "--execute"}));
        this.produceConsumeAndShutdown(this.topic(), this.group(), 100, this.produceConsumeAndShutdown$default$4());
        this.resetAndAssertOffsets(args, 0L, this.resetAndAssertOffsets$default$3(), this.resetAndAssertOffsets$default$4());
    }

    @Test
    public void testResetOffsetsToLatest() {
        String[] args = this.buildArgsForGroup(this.group(), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--all-topics", "--to-latest", "--execute"}));
        this.produceConsumeAndShutdown(this.topic(), this.group(), 100, this.produceConsumeAndShutdown$default$4());
        this.produceMessages(this.topic(), 100);
        this.resetAndAssertOffsets(args, 200L, this.resetAndAssertOffsets$default$3(), this.resetAndAssertOffsets$default$4());
    }

    @Test
    public void testResetOffsetsToCurrentOffset() {
        String[] args = this.buildArgsForGroup(this.group(), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--all-topics", "--to-current", "--execute"}));
        this.produceConsumeAndShutdown(this.topic(), this.group(), 100, this.produceConsumeAndShutdown$default$4());
        this.produceMessages(this.topic(), 100);
        this.resetAndAssertOffsets(args, 100L, this.resetAndAssertOffsets$default$3(), this.resetAndAssertOffsets$default$4());
    }

    @Test
    public void testResetOffsetsToSpecificOffset() {
        String[] args = this.buildArgsForGroup(this.group(), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--all-topics", "--to-offset", "1", "--execute"}));
        this.produceConsumeAndShutdown(this.topic(), this.group(), 100, this.produceConsumeAndShutdown$default$4());
        this.resetAndAssertOffsets(args, 1L, this.resetAndAssertOffsets$default$3(), this.resetAndAssertOffsets$default$4());
    }

    @Test
    public void testResetOffsetsShiftPlus() {
        String[] args = this.buildArgsForGroup(this.group(), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--all-topics", "--shift-by", "50", "--execute"}));
        this.produceConsumeAndShutdown(this.topic(), this.group(), 100, this.produceConsumeAndShutdown$default$4());
        this.produceMessages(this.topic(), 100);
        this.resetAndAssertOffsets(args, 150L, this.resetAndAssertOffsets$default$3(), this.resetAndAssertOffsets$default$4());
    }

    @Test
    public void testResetOffsetsShiftMinus() {
        String[] args = this.buildArgsForGroup(this.group(), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--all-topics", "--shift-by", "-50", "--execute"}));
        this.produceConsumeAndShutdown(this.topic(), this.group(), 100, this.produceConsumeAndShutdown$default$4());
        this.produceMessages(this.topic(), 100);
        this.resetAndAssertOffsets(args, 50L, this.resetAndAssertOffsets$default$3(), this.resetAndAssertOffsets$default$4());
    }

    @Test
    public void testResetOffsetsShiftByLowerThanEarliest() {
        String[] args = this.buildArgsForGroup(this.group(), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--all-topics", "--shift-by", "-150", "--execute"}));
        this.produceConsumeAndShutdown(this.topic(), this.group(), 100, this.produceConsumeAndShutdown$default$4());
        this.produceMessages(this.topic(), 100);
        this.resetAndAssertOffsets(args, 0L, this.resetAndAssertOffsets$default$3(), this.resetAndAssertOffsets$default$4());
    }

    @Test
    public void testResetOffsetsShiftByHigherThanLatest() {
        String[] args = this.buildArgsForGroup(this.group(), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--all-topics", "--shift-by", "150", "--execute"}));
        this.produceConsumeAndShutdown(this.topic(), this.group(), 100, this.produceConsumeAndShutdown$default$4());
        this.produceMessages(this.topic(), 100);
        this.resetAndAssertOffsets(args, 200L, this.resetAndAssertOffsets$default$3(), this.resetAndAssertOffsets$default$4());
    }

    @Test
    public void testResetOffsetsToEarliestOnOneTopic() {
        String[] args = this.buildArgsForGroup(this.group(), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--topic", this.topic(), "--to-earliest", "--execute"}));
        this.produceConsumeAndShutdown(this.topic(), this.group(), 100, this.produceConsumeAndShutdown$default$4());
        this.resetAndAssertOffsets(args, 0L, this.resetAndAssertOffsets$default$3(), this.resetAndAssertOffsets$default$4());
    }

    @Test
    public void testResetOffsetsToEarliestOnOneTopicAndPartition() {
        String topic = "bar";
        this.createTopic(topic, 2, 1, this.createTopic$default$4());
        String[] args = this.buildArgsForGroup(this.group(), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--topic", new StringBuilder(2).append(topic).append(":1").toString(), "--to-earliest", "--execute"}));
        ConsumerGroupCommand.ConsumerGroupService consumerGroupCommand = this.getConsumerGroupService(args);
        this.produceConsumeAndShutdown(topic, this.group(), 100, 2);
        Map<TopicPartition, Object> priorCommittedOffsets = this.committedOffsets(topic, this.committedOffsets$default$2());
        TopicPartition tp0 = new TopicPartition(topic, 0);
        TopicPartition tp1 = new TopicPartition(topic, 1);
        scala.collection.immutable.Map expectedOffsets = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp0), priorCommittedOffsets.apply((Object)tp0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), (Object)BoxesRunTime.boxToLong((long)0L))}));
        this.resetAndAssertOffsetsCommitted(consumerGroupCommand, (scala.collection.immutable.Map<TopicPartition, Object>)expectedOffsets, topic);
        this.adminZkClient().deleteTopic(topic);
    }

    @Test
    public void testResetOffsetsToEarliestOnTopics() {
        String topic1 = "topic1";
        String topic2 = "topic2";
        this.createTopic(topic1, 1, 1, this.createTopic$default$4());
        this.createTopic(topic2, 1, 1, this.createTopic$default$4());
        String[] args = this.buildArgsForGroup(this.group(), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--topic", topic1, "--topic", topic2, "--to-earliest", "--execute"}));
        ConsumerGroupCommand.ConsumerGroupService consumerGroupCommand = this.getConsumerGroupService(args);
        this.produceConsumeAndShutdown(topic1, this.group(), 100, 1);
        this.produceConsumeAndShutdown(topic2, this.group(), 100, 1);
        TopicPartition tp1 = new TopicPartition(topic1, 0);
        TopicPartition tp2 = new TopicPartition(topic2, 0);
        Map allResetOffsets = (Map)((TraversableLike)this.resetOffsets(consumerGroupCommand).apply((Object)this.group())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            TopicPartition k = (TopicPartition)x0$1._1();
            OffsetAndMetadata v = (OffsetAndMetadata)x0$1._2();
            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), (Object)BoxesRunTime.boxToLong((long)v.offset()));
            return tuple2;
        }, Map$.MODULE$.canBuildFrom());
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), (Object)BoxesRunTime.boxToLong((long)0L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp2), (Object)BoxesRunTime.boxToLong((long)0L))})), (Object)allResetOffsets);
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), (Object)BoxesRunTime.boxToLong((long)0L))})), this.committedOffsets(topic1, this.committedOffsets$default$2()));
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp2), (Object)BoxesRunTime.boxToLong((long)0L))})), this.committedOffsets(topic2, this.committedOffsets$default$2()));
        this.adminZkClient().deleteTopic(topic1);
        this.adminZkClient().deleteTopic(topic2);
    }

    @Test
    public void testResetOffsetsToEarliestOnTopicsAndPartitions() {
        String topic1 = "topic1";
        String topic2 = "topic2";
        this.createTopic(topic1, 2, 1, this.createTopic$default$4());
        this.createTopic(topic2, 2, 1, this.createTopic$default$4());
        String[] args = this.buildArgsForGroup(this.group(), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--topic", new StringBuilder(2).append(topic1).append(":1").toString(), "--topic", new StringBuilder(2).append(topic2).append(":1").toString(), "--to-earliest", "--execute"}));
        ConsumerGroupCommand.ConsumerGroupService consumerGroupCommand = this.getConsumerGroupService(args);
        this.produceConsumeAndShutdown(topic1, this.group(), 100, 2);
        this.produceConsumeAndShutdown(topic2, this.group(), 100, 2);
        Map<TopicPartition, Object> priorCommittedOffsets1 = this.committedOffsets(topic1, this.committedOffsets$default$2());
        Map<TopicPartition, Object> priorCommittedOffsets2 = this.committedOffsets(topic2, this.committedOffsets$default$2());
        TopicPartition tp1 = new TopicPartition(topic1, 1);
        TopicPartition tp2 = new TopicPartition(topic2, 1);
        Map allResetOffsets = (Map)((TraversableLike)this.resetOffsets(consumerGroupCommand).apply((Object)this.group())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            TopicPartition k = (TopicPartition)x0$1._1();
            OffsetAndMetadata v = (OffsetAndMetadata)x0$1._2();
            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), (Object)BoxesRunTime.boxToLong((long)v.offset()));
            return tuple2;
        }, Map$.MODULE$.canBuildFrom());
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), (Object)BoxesRunTime.boxToInteger((int)0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp2), (Object)BoxesRunTime.boxToInteger((int)0))})), (Object)allResetOffsets);
        Assertions.assertEquals((Object)priorCommittedOffsets1.toMap(Predef$.MODULE$.$conforms()).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), (Object)BoxesRunTime.boxToLong((long)0L))), this.committedOffsets(topic1, this.committedOffsets$default$2()));
        Assertions.assertEquals((Object)priorCommittedOffsets2.toMap(Predef$.MODULE$.$conforms()).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp2), (Object)BoxesRunTime.boxToLong((long)0L))), this.committedOffsets(topic2, this.committedOffsets$default$2()));
        this.adminZkClient().deleteTopic(topic1);
        this.adminZkClient().deleteTopic(topic2);
    }

    @Test
    public void testResetOffsetsExportImportPlanSingleGroupArg() {
        String topic = "bar";
        TopicPartition tp0 = new TopicPartition(topic, 0);
        TopicPartition tp1 = new TopicPartition(topic, 1);
        this.createTopic(topic, 2, 1, this.createTopic$default$4());
        String[] cgcArgs = this.buildArgsForGroup(this.group(), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--all-topics", "--to-offset", "2", "--export"}));
        ConsumerGroupCommand.ConsumerGroupService consumerGroupCommand = this.getConsumerGroupService(cgcArgs);
        this.produceConsumeAndShutdown(topic, this.group(), 100, 2);
        File file = File.createTempFile("reset", ".csv");
        file.deleteOnExit();
        Map exportedOffsets = consumerGroupCommand.resetOffsets();
        BufferedWriter bw = new BufferedWriter(new FileWriter(file));
        bw.write(consumerGroupCommand.exportOffsetsToCsv(exportedOffsets));
        bw.close();
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp0), (Object)BoxesRunTime.boxToLong((long)2L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), (Object)BoxesRunTime.boxToLong((long)2L))})), (Object)((TraversableLike)exportedOffsets.apply((Object)this.group())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            TopicPartition k = (TopicPartition)x0$1._1();
            OffsetAndMetadata v = (OffsetAndMetadata)x0$1._2();
            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), (Object)BoxesRunTime.boxToLong((long)v.offset()));
            return tuple2;
        }, Map$.MODULE$.canBuildFrom()));
        String[] cgcArgsExec = this.buildArgsForGroup(this.group(), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--all-topics", "--from-file", file.getCanonicalPath(), "--dry-run"}));
        Map importedOffsets = this.getConsumerGroupService(cgcArgsExec).resetOffsets();
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp0), (Object)BoxesRunTime.boxToLong((long)2L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), (Object)BoxesRunTime.boxToLong((long)2L))})), (Object)((TraversableLike)importedOffsets.apply((Object)this.group())).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            if (x0$2 == null) {
                throw new MatchError(null);
            }
            TopicPartition k = (TopicPartition)x0$2._1();
            OffsetAndMetadata v = (OffsetAndMetadata)x0$2._2();
            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), (Object)BoxesRunTime.boxToLong((long)v.offset()));
            return tuple2;
        }, Map$.MODULE$.canBuildFrom()));
        this.adminZkClient().deleteTopic(topic);
    }

    @Test
    public void testResetOffsetsExportImportPlan() {
        String group1 = new StringBuilder(1).append(this.group()).append("1").toString();
        String group2 = new StringBuilder(1).append(this.group()).append("2").toString();
        String topic1 = "bar1";
        String topic2 = "bar2";
        TopicPartition t1p0 = new TopicPartition(topic1, 0);
        TopicPartition t1p1 = new TopicPartition(topic1, 1);
        TopicPartition t2p0 = new TopicPartition(topic2, 0);
        TopicPartition t2p1 = new TopicPartition(topic2, 1);
        this.createTopic(topic1, 2, 1, this.createTopic$default$4());
        this.createTopic(topic2, 2, 1, this.createTopic$default$4());
        String[] cgcArgs = this.buildArgsForGroups((Seq<String>)new .colon.colon((Object)group1, (List)new .colon.colon((Object)group2, (List)Nil$.MODULE$)), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--all-topics", "--to-offset", "2", "--export"}));
        ConsumerGroupCommand.ConsumerGroupService consumerGroupCommand = this.getConsumerGroupService(cgcArgs);
        this.produceConsumeAndShutdown(topic1, group1, 100, this.produceConsumeAndShutdown$default$4());
        this.produceConsumeAndShutdown(topic2, group2, 100, this.produceConsumeAndShutdown$default$4());
        this.awaitConsumerGroupInactive(consumerGroupCommand, group1);
        this.awaitConsumerGroupInactive(consumerGroupCommand, group2);
        File file = File.createTempFile("reset", ".csv");
        file.deleteOnExit();
        Map exportedOffsets = consumerGroupCommand.resetOffsets();
        BufferedWriter bw = new BufferedWriter(new FileWriter(file));
        bw.write(consumerGroupCommand.exportOffsetsToCsv(exportedOffsets));
        bw.close();
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)t1p0), (Object)BoxesRunTime.boxToLong((long)2L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)t1p1), (Object)BoxesRunTime.boxToLong((long)2L))})), (Object)((TraversableLike)exportedOffsets.apply((Object)group1)).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            TopicPartition k = (TopicPartition)x0$1._1();
            OffsetAndMetadata v = (OffsetAndMetadata)x0$1._2();
            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), (Object)BoxesRunTime.boxToLong((long)v.offset()));
            return tuple2;
        }, Map$.MODULE$.canBuildFrom()));
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)t2p0), (Object)BoxesRunTime.boxToLong((long)2L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)t2p1), (Object)BoxesRunTime.boxToLong((long)2L))})), (Object)((TraversableLike)exportedOffsets.apply((Object)group2)).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            if (x0$2 == null) {
                throw new MatchError(null);
            }
            TopicPartition k = (TopicPartition)x0$2._1();
            OffsetAndMetadata v = (OffsetAndMetadata)x0$2._2();
            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), (Object)BoxesRunTime.boxToLong((long)v.offset()));
            return tuple2;
        }, Map$.MODULE$.canBuildFrom()));
        String[] cgcArgsExec = this.buildArgsForGroups((Seq<String>)new .colon.colon((Object)group1, (List)new .colon.colon((Object)group2, (List)Nil$.MODULE$)), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--all-topics", "--from-file", file.getCanonicalPath(), "--dry-run"}));
        Map importedOffsets = this.getConsumerGroupService(cgcArgsExec).resetOffsets();
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)t1p0), (Object)BoxesRunTime.boxToLong((long)2L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)t1p1), (Object)BoxesRunTime.boxToLong((long)2L))})), (Object)((TraversableLike)importedOffsets.apply((Object)group1)).map((Function1 & Serializable & scala.Serializable)x0$3 -> {
            if (x0$3 == null) {
                throw new MatchError(null);
            }
            TopicPartition k = (TopicPartition)x0$3._1();
            OffsetAndMetadata v = (OffsetAndMetadata)x0$3._2();
            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), (Object)BoxesRunTime.boxToLong((long)v.offset()));
            return tuple2;
        }, Map$.MODULE$.canBuildFrom()));
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)t2p0), (Object)BoxesRunTime.boxToLong((long)2L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)t2p1), (Object)BoxesRunTime.boxToLong((long)2L))})), (Object)((TraversableLike)importedOffsets.apply((Object)group2)).map((Function1 & Serializable & scala.Serializable)x0$4 -> {
            if (x0$4 == null) {
                throw new MatchError(null);
            }
            TopicPartition k = (TopicPartition)x0$4._1();
            OffsetAndMetadata v = (OffsetAndMetadata)x0$4._2();
            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), (Object)BoxesRunTime.boxToLong((long)v.offset()));
            return tuple2;
        }, Map$.MODULE$.canBuildFrom()));
        String[] cgcArgsExec2 = this.buildArgsForGroup(group1, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--all-topics", "--from-file", file.getCanonicalPath(), "--dry-run"}));
        Map importedOffsets2 = this.getConsumerGroupService(cgcArgsExec2).resetOffsets();
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)t1p0), (Object)BoxesRunTime.boxToLong((long)2L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)t1p1), (Object)BoxesRunTime.boxToLong((long)2L))})), (Object)((TraversableLike)importedOffsets2.apply((Object)group1)).map((Function1 & Serializable & scala.Serializable)x0$5 -> {
            if (x0$5 == null) {
                throw new MatchError(null);
            }
            TopicPartition k = (TopicPartition)x0$5._1();
            OffsetAndMetadata v = (OffsetAndMetadata)x0$5._2();
            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), (Object)BoxesRunTime.boxToLong((long)v.offset()));
            return tuple2;
        }, Map$.MODULE$.canBuildFrom()));
        this.adminZkClient().deleteTopic(this.topic());
    }

    @Test
    public void testResetWithUnrecognizedNewConsumerOption() {
        String[] cgcArgs = (String[])((Object[])new String[]{"--new-consumer", "--bootstrap-server", this.brokerList(), "--reset-offsets", "--group", this.group(), "--all-topics", "--to-offset", "2", "--export"});
        Assertions.assertThrows(OptionException.class, () -> this.getConsumerGroupService(cgcArgs));
    }

    private void produceMessages(String topic, int numMessages) {
        IndexedSeq records = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numMessages).map((Function1 & Serializable & scala.Serializable)x$5 -> ResetConsumerGroupOffsetTest.$anonfun$produceMessages$1(topic, BoxesRunTime.unboxToInt((Object)x$5)), IndexedSeq$.MODULE$.canBuildFrom());
        TestUtils$.MODULE$.produceMessages((Seq<KafkaServer>)this.servers(), (Seq<ProducerRecord<byte[], byte[]>>)records, 1);
    }

    private void produceConsumeAndShutdown(String topic, String group, int totalMessages, int numConsumers) {
        this.produceMessages(topic, totalMessages);
        ConsumerGroupCommandTest.ConsumerGroupExecutor executor = this.addConsumerGroupExecutor(numConsumers, topic, group, this.addConsumerGroupExecutor$default$4(), this.addConsumerGroupExecutor$default$5(), this.addConsumerGroupExecutor$default$6());
        this.awaitConsumerProgress(topic, group, totalMessages);
        executor.shutdown();
    }

    private int produceConsumeAndShutdown$default$4() {
        return 1;
    }

    /*
     * WARNING - void declaration
     */
    private void awaitConsumerProgress(String topic, String group, long count) {
        try (KafkaConsumer<String, String> consumer = this.createNoAutoCommitConsumer(group);){
            scala.collection.immutable.Set partitions = ((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(consumer.partitionsFor(topic)).asScala()).map((Function1 & Serializable & scala.Serializable)partitionInfo -> new TopicPartition(partitionInfo.topic(), partitionInfo.partition()), Buffer$.MODULE$.canBuildFrom())).toSet();
            long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
            long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
            if (TestUtils$.MODULE$ == null) {
                throw null;
            }
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!ResetConsumerGroupOffsetTest.$anonfun$awaitConsumerProgress$2(consumer, partitions, count)) {
                void waitUntilTrue_pause;
                void waitUntilTrue_waitTimeMs;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)ResetConsumerGroupOffsetTest.$anonfun$awaitConsumerProgress$6(this, count, topic, group));
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
        }
    }

    private String awaitConsumerProgress$default$1() {
        return this.topic();
    }

    private String awaitConsumerProgress$default$2() {
        return this.group();
    }

    /*
     * WARNING - void declaration
     */
    private void awaitConsumerGroupInactive(ConsumerGroupCommand.ConsumerGroupService consumerGroupService, String group) {
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ResetConsumerGroupOffsetTest.$anonfun$awaitConsumerGroupInactive$1(consumerGroupService, group)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ResetConsumerGroupOffsetTest.$anonfun$awaitConsumerGroupInactive$2(consumerGroupService, group));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    private void resetAndAssertOffsets(String[] args, long expectedOffset, boolean dryRun, Seq<String> topics) {
        ConsumerGroupCommand.ConsumerGroupService consumerGroupCommand = this.getConsumerGroupService(args);
        scala.collection.immutable.Map expectedOffsets = ((TraversableOnce)topics.map((Function1 & Serializable & scala.Serializable)topic -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(topic), (Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(topic, 0)), (Object)BoxesRunTime.boxToLong((long)expectedOffset))}))), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        Map<String, Map<TopicPartition, OffsetAndMetadata>> resetOffsetsResultByGroup = this.resetOffsets(consumerGroupCommand);
        try {
            topics.foreach((Function1 & Serializable & scala.Serializable)topic -> {
                ResetConsumerGroupOffsetTest.$anonfun$resetAndAssertOffsets$2(this, resetOffsetsResultByGroup, expectedOffsets, dryRun, topic);
                return BoxedUnit.UNIT;
            });
        }
        finally {
            consumerGroupCommand.close();
        }
    }

    private boolean resetAndAssertOffsets$default$3() {
        return false;
    }

    private Seq<String> resetAndAssertOffsets$default$4() {
        return new .colon.colon((Object)this.topic(), (List)Nil$.MODULE$);
    }

    private void resetAndAssertOffsetsCommitted(ConsumerGroupCommand.ConsumerGroupService consumerGroupService, scala.collection.immutable.Map<TopicPartition, Object> expectedOffsets, String topic) {
        this.resetOffsets(consumerGroupService).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$2 != null))).foreach((Function1 & Serializable & scala.Serializable)x$9 -> {
            ResetConsumerGroupOffsetTest.$anonfun$resetAndAssertOffsetsCommitted$2(this, expectedOffsets, topic, x$9);
            return BoxedUnit.UNIT;
        });
    }

    private Map<String, Map<TopicPartition, OffsetAndMetadata>> resetOffsets(ConsumerGroupCommand.ConsumerGroupService consumerGroupService) {
        return consumerGroupService.resetOffsets();
    }

    public static final /* synthetic */ boolean $anonfun$testResetOffsetsNotExistingGroup$1(ConsumerGroupCommand.ConsumerGroupService consumerGroupCommand$1, String group$1) {
        String string = consumerGroupCommand$1.collectGroupState(group$1).coordinator().host();
        String string2 = "localhost";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ String $anonfun$testResetOffsetsNotExistingGroup$2() {
        return "Can't find a coordinator";
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ String $anonfun$testResetOffsetsExistingTopicSelectedGroups$1(ResetConsumerGroupOffsetTest $this, int id) {
        void var2_2;
        String group = new StringBuilder(0).append($this.group()).append(id).toString();
        ConsumerGroupCommandTest.ConsumerGroupExecutor executor = $this.addConsumerGroupExecutor(1, $this.topic(), group, $this.addConsumerGroupExecutor$default$4(), $this.addConsumerGroupExecutor$default$5(), $this.addConsumerGroupExecutor$default$6());
        long x$1 = 100L;
        String x$3 = $this.awaitConsumerProgress$default$1();
        $this.awaitConsumerProgress(x$3, group, x$1);
        executor.shutdown();
        return var2_2;
    }

    public static final /* synthetic */ String $anonfun$testResetOffsetsExistingTopicAllGroups$1(ResetConsumerGroupOffsetTest $this, int x$2) {
        return new StringBuilder(0).append($this.group()).append(x$2).toString();
    }

    public static final /* synthetic */ void $anonfun$testResetOffsetsExistingTopicAllGroups$2(ResetConsumerGroupOffsetTest $this, String group) {
        ConsumerGroupCommandTest.ConsumerGroupExecutor executor = $this.addConsumerGroupExecutor(1, $this.topic(), group, $this.addConsumerGroupExecutor$default$4(), $this.addConsumerGroupExecutor$default$5(), $this.addConsumerGroupExecutor$default$6());
        long x$1 = 100L;
        String x$3 = $this.awaitConsumerProgress$default$1();
        $this.awaitConsumerProgress(x$3, group, x$1);
        executor.shutdown();
    }

    public static final /* synthetic */ String $anonfun$testResetOffsetsAllTopicsAllGroups$1(ResetConsumerGroupOffsetTest $this, int x$3) {
        return new StringBuilder(0).append($this.topic()).append(x$3).toString();
    }

    public static final /* synthetic */ String $anonfun$testResetOffsetsAllTopicsAllGroups$2(ResetConsumerGroupOffsetTest $this, int x$4) {
        return new StringBuilder(0).append($this.group()).append(x$4).toString();
    }

    public static final /* synthetic */ void $anonfun$testResetOffsetsAllTopicsAllGroups$5(ResetConsumerGroupOffsetTest $this, String topic$1, String group) {
        ConsumerGroupCommandTest.ConsumerGroupExecutor executor = $this.addConsumerGroupExecutor(3, topic$1, group, $this.addConsumerGroupExecutor$default$4(), $this.addConsumerGroupExecutor$default$5(), $this.addConsumerGroupExecutor$default$6());
        long x$2 = 100L;
        $this.awaitConsumerProgress(topic$1, group, x$2);
        executor.shutdown();
    }

    public static final /* synthetic */ ProducerRecord $anonfun$produceMessages$1(String topic$2, int x$5) {
        return new ProducerRecord(topic$2, (Object)new byte[100000]);
    }

    public static final /* synthetic */ long $anonfun$awaitConsumerProgress$3(long x0$1, OffsetAndMetadata x1$1) {
        return x0$1 + BoxesRunTime.unboxToLong((Object)Option$.MODULE$.apply((Object)x1$1).map((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToLong((long)x$6.offset())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L));
    }

    public static final /* synthetic */ boolean $anonfun$awaitConsumerProgress$2(KafkaConsumer consumer$1, scala.collection.immutable.Set partitions$1, long count$1) {
        return BoxesRunTime.unboxToLong((Object)((Iterable)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(consumer$1.committed((java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)partitions$1).asJava()).values()).asScala()).foldLeft((Object)BoxesRunTime.boxToLong((long)0L), (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> BoxesRunTime.boxToLong((long)ResetConsumerGroupOffsetTest.$anonfun$awaitConsumerProgress$3(BoxesRunTime.unboxToLong((Object)x0$1), x1$1)))) == count$1;
    }

    public static final /* synthetic */ String $anonfun$awaitConsumerProgress$6(ResetConsumerGroupOffsetTest $this, long count$1, String topic$3, String group$2) {
        return new StringBuilder(111).append("Expected that consumer group has consumed all messages from topic/partition. ").append("Expected offset: ").append(count$1).append(". Actual offset: ").append($this.committedOffsets(topic$3, group$2).values().sum((Numeric)Numeric.LongIsIntegral$.MODULE$)).toString();
    }

    public static final /* synthetic */ boolean $anonfun$awaitConsumerGroupInactive$1(ConsumerGroupCommand.ConsumerGroupService consumerGroupService$1, String group$3) {
        block3: {
            block2: {
                String state;
                String string = state = consumerGroupService$1.collectGroupState(group$3).state();
                String string2 = "Empty";
                if (string != null && string.equals(string2)) break block2;
                String string3 = state;
                String string4 = "Dead";
                if (string3 == null || !string3.equals(string4)) break block3;
            }
            return true;
        }
        return false;
    }

    public static final /* synthetic */ String $anonfun$awaitConsumerGroupInactive$2(ConsumerGroupCommand.ConsumerGroupService consumerGroupService$1, String group$3) {
        return new StringBuilder(56).append("Expected that consumer group is inactive. Actual state: ").append(consumerGroupService$1.collectGroupState(group$3).state()).toString();
    }

    public static final /* synthetic */ boolean $anonfun$resetAndAssertOffsets$5(String topic$4, Tuple2 partitionInfo) {
        String string = ((TopicPartition)partitionInfo._1()).topic();
        return !(string != null ? !string.equals(topic$4) : topic$4 != null);
    }

    public static final /* synthetic */ void $anonfun$resetAndAssertOffsets$4(ResetConsumerGroupOffsetTest $this, String topic$4, scala.collection.immutable.Map expectedOffsets$1, boolean dryRun$1, Tuple2 x$7) {
        if (x$7 != null) {
            String group = (String)x$7._1();
            Map partitionInfo2 = (Map)x$7._2();
            Map<TopicPartition, Object> priorOffsets = $this.committedOffsets(topic$4, group);
            Assertions.assertEquals((Object)expectedOffsets$1.apply((Object)topic$4), (Object)((TraversableLike)partitionInfo2.filter((Function1 & Serializable & scala.Serializable)partitionInfo -> BoxesRunTime.boxToBoolean((boolean)ResetConsumerGroupOffsetTest.$anonfun$resetAndAssertOffsets$5(topic$4, partitionInfo)))).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                if (x0$1 == null) {
                    throw new MatchError(null);
                }
                TopicPartition k = (TopicPartition)x0$1._1();
                OffsetAndMetadata v = (OffsetAndMetadata)x0$1._2();
                Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), (Object)BoxesRunTime.boxToLong((long)v.offset()));
                return tuple2;
            }, Map$.MODULE$.canBuildFrom()));
            Assertions.assertEquals(dryRun$1 ? priorOffsets : expectedOffsets$1.apply((Object)topic$4), $this.committedOffsets(topic$4, group));
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$resetAndAssertOffsets$2(ResetConsumerGroupOffsetTest $this, Map resetOffsetsResultByGroup$1, scala.collection.immutable.Map expectedOffsets$1, boolean dryRun$1, String topic) {
        resetOffsetsResultByGroup$1.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$1 != null))).foreach((Function1 & Serializable & scala.Serializable)x$7 -> {
            ResetConsumerGroupOffsetTest.$anonfun$resetAndAssertOffsets$4($this, topic, expectedOffsets$1, dryRun$1, x$7);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$resetAndAssertOffsetsCommitted$4(ResetConsumerGroupOffsetTest $this, scala.collection.immutable.Map expectedOffsets$2, String topic$5, String group$4, Tuple2 x$8) {
        if (x$8 != null) {
            TopicPartition tp = (TopicPartition)x$8._1();
            Assertions.assertEquals((long)((OffsetAndMetadata)x$8._2()).offset(), (long)BoxesRunTime.unboxToLong((Object)expectedOffsets$2.apply((Object)tp)));
            Assertions.assertEquals((Object)expectedOffsets$2, $this.committedOffsets(topic$5, group$4));
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$resetAndAssertOffsetsCommitted$2(ResetConsumerGroupOffsetTest $this, scala.collection.immutable.Map expectedOffsets$2, String topic$5, Tuple2 x$9) {
        if (x$9 != null) {
            String group = (String)x$9._1();
            ((Map)x$9._2()).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$3 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$3 != null))).foreach((Function1 & Serializable & scala.Serializable)x$8 -> {
                ResetConsumerGroupOffsetTest.$anonfun$resetAndAssertOffsetsCommitted$4($this, expectedOffsets$2, topic$5, group, x$8);
                return BoxedUnit.UNIT;
            });
            return;
        }
        throw new MatchError(null);
    }

    public ResetConsumerGroupOffsetTest() {
        this.topic1 = "foo1";
        this.topic2 = "foo2";
    }
}

