/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.Serializable;
import java.time.Duration;
import java.util.Collection;
import java.util.Properties;
import kafka.api.AbstractConsumerTest;
import kafka.server.BaseRequestTest;
import kafka.server.KafkaConfig$;
import kafka.utils.ShutdownableThread;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.consumer.OffsetCommitCallback;
import org.apache.kafka.clients.consumer.RetriableCommitFailedException;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.WakeupException;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0011}e!\u00023f\u0003\u0003Q\u0007\"B9\u0001\t\u0003\u0011\bbB;\u0001\u0005\u0004%\tA\u001e\u0005\u0007{\u0002\u0001\u000b\u0011B<\t\u000by\u0004A\u0011I@\t\u0013\u0005\u001d\u0001A1A\u0005\u0002\u0005%\u0001\u0002CA\u000e\u0001\u0001\u0006I!a\u0003\t\u0011\u0005u\u0001A1A\u0005\u0002}D\u0001\"a\b\u0001A\u0003%\u0011\u0011\u0001\u0005\n\u0003C\u0001!\u0019!C\u0001\u0003GA\u0001\"a\u000f\u0001A\u0003%\u0011Q\u0005\u0005\t\u0003{\u0001!\u0019!C\u0001\u007f\"A\u0011q\b\u0001!\u0002\u0013\t\t\u0001C\u0005\u0002B\u0001\u0011\r\u0011\"\u0001\u0002$!A\u00111\t\u0001!\u0002\u0013\t)\u0003C\u0005\u0002F\u0001\u0011\r\u0011\"\u0001\u0002\n!A\u0011q\t\u0001!\u0002\u0013\tY\u0001C\u0005\u0002J\u0001\u0011\r\u0011\"\u0001\u0002\n!A\u00111\n\u0001!\u0002\u0013\tY\u0001C\u0005\u0002N\u0001\u0011\r\u0011\"\u0001\u0002\n!A\u0011q\n\u0001!\u0002\u0013\tY\u0001C\u0005\u0002R\u0001\u0011\r\u0011\"\u0001\u0002T!A\u00111\f\u0001!\u0002\u0013\t)\u0006C\u0004\u0002^\u0001!\t&a\u0018\t\u000f\u0005]\u0004\u0001\"\u0011\u0002z\u00191\u0011q\u0012\u0001\t\u0003#Ca!]\r\u0005\u0002\u0005%\u0006\u0002CAX3\u0001\u0007I\u0011A@\t\u0013\u0005E\u0016\u00041A\u0005\u0002\u0005M\u0006\u0002CA]3\u0001\u0006K!!\u0001\t\u0011\u0005m\u0016\u00041A\u0005\u0002}D\u0011\"!0\u001a\u0001\u0004%\t!a0\t\u0011\u0005\r\u0017\u0004)Q\u0005\u0003\u0003Aq!!2\u001a\t\u0003\t9\rC\u0004\u0002Tf!\t!!6\t\u000f\u0005e\u0007\u0001\"\u0005\u0002\\\"9!q\u0001\u0001\u0005\u0012\t%\u0001\"\u0003B\u001e\u0001E\u0005I\u0011\u0003B\u001f\u0011\u001d\u0011\u0019\u0006\u0001C\t\u0005+B\u0011B!!\u0001#\u0003%\tBa!\t\u0013\t\u001d\u0005!%A\u0005\u0012\tu\u0002\"\u0003BE\u0001E\u0005I\u0011\u0003BF\u0011%\u0011y\tAI\u0001\n#\u0011\t\nC\u0005\u0003\u0016\u0002\t\n\u0011\"\u0005\u0003\u0004\"9!q\u0013\u0001\u0005\u0012\te\u0005\"\u0003Bl\u0001E\u0005I\u0011\u0003Bm\u0011\u001d\u0011y\u000e\u0001C\t\u0005CD\u0011ba\u0002\u0001#\u0003%\tb!\u0003\t\u000f\rM\u0001\u0001\"\u0001\u0004\u0016!I11\u001c\u0001\u0012\u0002\u0013\u00051Q\u001c\u0005\b\u0007C\u0004A\u0011ABr\u0011%\u0019\t\u0010AI\u0001\n\u0003\u0019i\u000eC\u0004\u0004t\u0002!\ta!>\t\u0013\u0011\u0015\u0001!%A\u0005\u0002\u0011\u001d\u0001\"\u0003C\u0006\u0001E\u0005I\u0011\u0001B\u001f\u0011\u001d!i\u0001\u0001C\u0001\t\u001fA\u0011\u0002b\u0006\u0001#\u0003%\t\u0001\"\u0007\t\u000f\u0011u\u0001\u0001\"\u0005\u0005 !9AQ\u0007\u0001\u0005\u0012\u0011]bA\u0002C'\u0001!!y\u0005\u0003\u0004rw\u0011\u0005Aq\u000b\u0005\t\t7Z\u0004\u0019!C\u0001\u007f\"IAQL\u001eA\u0002\u0013\u0005Aq\f\u0005\t\tGZ\u0004\u0015)\u0003\u0002\u0002!AAQM\u001eA\u0002\u0013\u0005q\u0010C\u0005\u0005hm\u0002\r\u0011\"\u0001\u0005j!AAQN\u001e!B\u0013\t\t\u0001C\u0005\u0005pm\u0002\r\u0011\"\u0001\u0005r!IA1P\u001eA\u0002\u0013\u0005AQ\u0010\u0005\t\t\u0003[\u0004\u0015)\u0003\u0005t!9A1Q\u001e\u0005B\u0011\u0015eABB\u0014\u0001!\u0019I\u0003\u0003\u0006\u0002 \u001e\u0013\t\u0011)A\u0005\u00053B!ba\u000eH\u0005\u0003\u0005\u000b\u0011BB\u001d\u0011)\u0019yd\u0012B\u0001B\u0003%1\u0011\t\u0005\u0007c\u001e#\taa\u0012\t\rE<E\u0011AB(\u0011\u0019\tx\t\"\u0001\u0004V!I11L$A\u0002\u0013\u00051Q\f\u0005\n\u0007O:\u0005\u0019!C\u0001\u0007SB\u0001b!\u001cHA\u0003&1q\f\u0005\t\u0007o:\u0005\u0019!C\u0001\u007f\"I1\u0011P$A\u0002\u0013\u000511\u0010\u0005\t\u0007\u007f:\u0005\u0015)\u0003\u0002\u0002!I11Q$C\u0002\u0013%1Q\u0011\u0005\t\u0007\u0017;\u0005\u0015!\u0003\u0004\b\"I1QR$A\u0002\u0013%1q\u0012\u0005\n\u0007/;\u0005\u0019!C\u0005\u00073C\u0001b!(HA\u0003&1\u0011\u0013\u0005\n\u0007C;\u0005\u0019!C\u0005\u0007GC\u0011b!*H\u0001\u0004%Iaa*\t\u0011\r-v\t)Q\u0005\u0007sA\u0011b!,H\u0005\u0004%\taa,\t\u0011\rEv\t)A\u0005\u00033Cqaa-H\t\u0003\u0019)\fC\u0004\u00048\u001e#\ta!/\t\u000f\r}v\t\"\u0001\u0004\u0010\"91\u0011Y$\u0005B\r\r\u0007bBBc\u000f\u0012\u0005\u0013\u0011\u0010\u0005\b\t'\u0003A\u0011\u0001CK\u0005Q\t%m\u001d;sC\u000e$8i\u001c8tk6,'\u000fV3ti*\u0011amZ\u0001\u0004CBL'\"\u00015\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001a\u001b\t\u0003Y>l\u0011!\u001c\u0006\u0003]\u001e\faa]3sm\u0016\u0014\u0018B\u00019n\u0005=\u0011\u0015m]3SKF,Xm\u001d;UKN$\u0018A\u0002\u001fj]&$h\bF\u0001t!\t!\b!D\u0001f\u0003\u001d)\u0007o]5m_:,\u0012a\u001e\t\u0003qnl\u0011!\u001f\u0006\u0002u\u0006)1oY1mC&\u0011A0\u001f\u0002\u0007\t>,(\r\\3\u0002\u0011\u0015\u00048/\u001b7p]\u0002\n1B\u0019:pW\u0016\u00148i\\;oiV\u0011\u0011\u0011\u0001\t\u0004q\u0006\r\u0011bAA\u0003s\n\u0019\u0011J\u001c;\u0002\u000bQ|\u0007/[2\u0016\u0005\u0005-\u0001\u0003BA\u0007\u0003/i!!a\u0004\u000b\t\u0005E\u00111C\u0001\u0005Y\u0006twM\u0003\u0002\u0002\u0016\u0005!!.\u0019<b\u0013\u0011\tI\"a\u0004\u0003\rM#(/\u001b8h\u0003\u0019!x\u000e]5dA\u0005!\u0001/\u0019:u\u0003\u0015\u0001\u0018M\u001d;!\u0003\t!\b/\u0006\u0002\u0002&A!\u0011qEA\u001c\u001b\t\tIC\u0003\u0003\u0002,\u00055\u0012AB2p[6|gNC\u0002i\u0003_QA!!\r\u00024\u00051\u0011\r]1dQ\u0016T!!!\u000e\u0002\u0007=\u0014x-\u0003\u0003\u0002:\u0005%\"A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\\\u0001\u0004iB\u0004\u0013!\u00029beR\u0014\u0014A\u00029beR\u0014\u0004%A\u0002uaJ\nA\u0001\u001e93A\u0005)qM]8va\u00061qM]8va\u0002\n\u0001\u0003\u001d:pIV\u001cWM]\"mS\u0016tG/\u00133\u0002#A\u0014x\u000eZ;dKJ\u001cE.[3oi&#\u0007%\u0001\td_:\u001cX/\\3s\u00072LWM\u001c;JI\u0006\t2m\u001c8tk6,'o\u00117jK:$\u0018\n\u001a\u0011\u00021\u001d\u0014x.\u001e9NCb\u001cVm]:j_:$\u0016.\\3pkRl5/\u0006\u0002\u0002VA\u0019\u00010a\u0016\n\u0007\u0005e\u0013P\u0001\u0003M_:<\u0017!G4s_V\u0004X*\u0019=TKN\u001c\u0018n\u001c8US6,w.\u001e;Ng\u0002\nqC\u0019:pW\u0016\u0014\bK]8qKJ$\u0018p\u0014<feJLG-Z:\u0015\t\u0005\u0005\u0014q\r\t\u0004q\u0006\r\u0014bAA3s\n!QK\\5u\u0011\u001d\tIg\u0006a\u0001\u0003W\n!\u0002\u001d:pa\u0016\u0014H/[3t!\u0011\ti'a\u001d\u000e\u0005\u0005=$\u0002BA9\u0003'\tA!\u001e;jY&!\u0011QOA8\u0005)\u0001&o\u001c9feRLWm]\u0001\u0006g\u0016$X\u000b\u001d\u000b\u0003\u0003CB3\u0001GA?!\u0011\ty(a#\u000e\u0005\u0005\u0005%b\u00014\u0002\u0004*!\u0011QQAD\u0003\u001dQW\u000f]5uKJTA!!#\u00024\u0005)!.\u001e8ji&!\u0011QRAA\u0005)\u0011UMZ8sK\u0016\u000b7\r\u001b\u0002!)\u0016\u001cHoQ8ogVlWM\u001d*fCN\u001c\u0018n\u001a8nK:$H*[:uK:,'oE\u0003\u001a\u0003'\u000bI\n\u0005\u0003\u0002\u000e\u0005U\u0015\u0002BAL\u0003\u001f\u0011aa\u00142kK\u000e$\b\u0003BAN\u0003Kk!!!(\u000b\t\u0005}\u0015\u0011U\u0001\tG>t7/^7fe*!\u00111UA\u0017\u0003\u001d\u0019G.[3oiNLA!a*\u0002\u001e\nI2i\u001c8tk6,'OU3cC2\fgnY3MSN$XM\\3s)\t\tY\u000bE\u0002\u0002.fi\u0011\u0001A\u0001\u0010G\u0006dGn\u001d+p\u0003N\u001c\u0018n\u001a8fI\u0006\u00192-\u00197mgR{\u0017i]:jO:,Gm\u0018\u0013fcR!\u0011\u0011MA[\u0011%\t9\fHA\u0001\u0002\u0004\t\t!A\u0002yIE\n\u0001cY1mYN$v.Q:tS\u001etW\r\u001a\u0011\u0002\u001d\r\fG\u000e\\:U_J+go\\6fI\u0006\u00112-\u00197mgR{'+\u001a<pW\u0016$w\fJ3r)\u0011\t\t'!1\t\u0013\u0005]v$!AA\u0002\u0005\u0005\u0011aD2bY2\u001cHk\u001c*fm>\\W\r\u001a\u0011\u0002)=t\u0007+\u0019:uSRLwN\\:BgNLwM\\3e)\u0011\t\t'!3\t\u000f\u0005-\u0017\u00051\u0001\u0002N\u0006Q\u0001/\u0019:uSRLwN\\:\u0011\r\u00055\u0014qZA\u0013\u0013\u0011\t\t.a\u001c\u0003\u0015\r{G\u000e\\3di&|g.A\np]B\u000b'\u000f^5uS>t7OU3w_.,G\r\u0006\u0003\u0002b\u0005]\u0007bBAfE\u0001\u0007\u0011QZ\u0001\u001aGJ,\u0017\r^3D_:\u001cX/\\3s/&$\bn\u0012:pkBLE\r\u0006\u0003\u0002^\u0006=\b\u0003CAN\u0003?\f\u0019/a9\n\t\u0005\u0005\u0018Q\u0014\u0002\u000e\u0017\u000647.Y\"p]N,X.\u001a:\u0011\u000ba\f)/!;\n\u0007\u0005\u001d\u0018PA\u0003BeJ\f\u0017\u0010E\u0002y\u0003WL1!!<z\u0005\u0011\u0011\u0015\u0010^3\t\u000f\u0005E8\u00051\u0001\u0002t\u00069qM]8va&#\u0007\u0003BA{\u0005\u0007qA!a>\u0002\u0000B\u0019\u0011\u0011`=\u000e\u0005\u0005m(bAA\u007fS\u00061AH]8pizJ1A!\u0001z\u0003\u0019\u0001&/\u001a3fM&!\u0011\u0011\u0004B\u0003\u0015\r\u0011\t!_\u0001\fg\u0016tGMU3d_J$7\u000f\u0006\u0006\u0003\f\t%\"\u0011\u0007B\u001b\u0005o\u0001bA!\u0004\u0003\u0018\tua\u0002\u0002B\b\u0005'qA!!?\u0003\u0012%\t!0C\u0002\u0003\u0016e\fq\u0001]1dW\u0006<W-\u0003\u0003\u0003\u001a\tm!aA*fc*\u0019!QC=\u0011\u0011\t}!QEAr\u0003Gl!A!\t\u000b\t\t\r\u0012\u0011U\u0001\taJ|G-^2fe&!!q\u0005B\u0011\u00059\u0001&o\u001c3vG\u0016\u0014(+Z2pe\u0012DqAa\t%\u0001\u0004\u0011Y\u0003\u0005\u0005\u0003 \t5\u00121]Ar\u0013\u0011\u0011yC!\t\u0003\u001b-\u000bgm[1Qe>$WoY3s\u0011\u001d\u0011\u0019\u0004\na\u0001\u0003\u0003\t!B\\;n%\u0016\u001cwN\u001d3t\u0011\u001d\t\t\u0003\na\u0001\u0003KA\u0011B!\u000f%!\u0003\u0005\r!!\u0016\u0002#M$\u0018M\u001d;j]\u001e$\u0016.\\3ti\u0006l\u0007/A\u000btK:$'+Z2pe\u0012\u001cH\u0005Z3gCVdG\u000f\n\u001b\u0016\u0005\t}\"\u0006BA+\u0005\u0003Z#Aa\u0011\u0011\t\t\u0015#qJ\u0007\u0003\u0005\u000fRAA!\u0013\u0003L\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0005\u001bJ\u0018AC1o]>$\u0018\r^5p]&!!\u0011\u000bB$\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u0018G>t7/^7f\u0003:$g+\u001a:jMf\u0014VmY8sIN$\"#!\u0019\u0003X\t}#\u0011\rB3\u0005S\u0012YGa\u001f\u0003~!9\u0011q\u0014\u0014A\u0002\te\u0003\u0003CAN\u00057\n\u0019/a9\n\t\tu\u0013Q\u0014\u0002\t\u0007>t7/^7fe\"9!1\u0007\u0014A\u0002\u0005\u0005\u0001b\u0002B2M\u0001\u0007\u0011\u0011A\u0001\u000fgR\f'\u000f^5oO>3gm]3u\u0011%\u00119G\nI\u0001\u0002\u0004\t\t!\u0001\rti\u0006\u0014H/\u001b8h\u0017\u0016L\u0018I\u001c3WC2,X-\u00138eKbD\u0011B!\u000f'!\u0003\u0005\r!!\u0016\t\u0013\t5d\u0005%AA\u0002\t=\u0014!\u0004;j[\u0016\u001cH/Y7q)f\u0004X\r\u0005\u0003\u0003r\t]TB\u0001B:\u0015\u0011\u0011)(!\u000b\u0002\rI,7m\u001c:e\u0013\u0011\u0011IHa\u001d\u0003\u001bQKW.Z:uC6\u0004H+\u001f9f\u0011%\t\tC\nI\u0001\u0002\u0004\t)\u0003C\u0005\u0003\u0000\u0019\u0002\n\u00111\u0001\u0002\u0002\u0005qQ.\u0019=Q_2d'+Z2pe\u0012\u001c\u0018!I2p]N,X.Z!oIZ+'/\u001b4z%\u0016\u001cwN\u001d3tI\u0011,g-Y;mi\u0012\"TC\u0001BCU\u0011\t\tA!\u0011\u0002C\r|gn];nK\u0006sGMV3sS\u001aL(+Z2pe\u0012\u001cH\u0005Z3gCVdG\u000fJ\u001b\u0002C\r|gn];nK\u0006sGMV3sS\u001aL(+Z2pe\u0012\u001cH\u0005Z3gCVdG\u000f\n\u001c\u0016\u0005\t5%\u0006\u0002B8\u0005\u0003\n\u0011eY8ogVlW-\u00118e-\u0016\u0014\u0018NZ=SK\u000e|'\u000fZ:%I\u00164\u0017-\u001e7uI]*\"Aa%+\t\u0005\u0015\"\u0011I\u0001\"G>t7/^7f\u0003:$g+\u001a:jMf\u0014VmY8sIN$C-\u001a4bk2$H\u0005O\u0001\u000fG>t7/^7f%\u0016\u001cwN\u001d3t+\u0019\u0011YJa.\u0003LRA!Q\u0014Bh\u0005'\u0014)\u000e\u0005\u0004\u0003 \n%&QV\u0007\u0003\u0005CSAAa)\u0003&\u00069Q.\u001e;bE2,'b\u0001BTs\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\t-&\u0011\u0015\u0002\f\u0003J\u0014\u0018-\u001f\"vM\u001a,'\u000f\u0005\u0005\u0002\u001c\n=&1\u0017Be\u0013\u0011\u0011\t,!(\u0003\u001d\r{gn];nKJ\u0014VmY8sIB!!Q\u0017B\\\u0019\u0001!qA!/-\u0005\u0004\u0011YLA\u0001L#\u0011\u0011iLa1\u0011\u0007a\u0014y,C\u0002\u0003Bf\u0014qAT8uQ&tw\rE\u0002y\u0005\u000bL1Aa2z\u0005\r\te.\u001f\t\u0005\u0005k\u0013Y\rB\u0004\u0003N2\u0012\rAa/\u0003\u0003YCq!a(-\u0001\u0004\u0011\t\u000e\u0005\u0005\u0002\u001c\nm#1\u0017Be\u0011\u001d\u0011\u0019\u0004\fa\u0001\u0003\u0003A\u0011Ba -!\u0003\u0005\r!!\u0001\u00021\r|gn];nKJ+7m\u001c:eg\u0012\"WMZ1vYR$3'\u0006\u0004\u0003\u0004\nm'Q\u001c\u0003\b\u0005sk#\u0019\u0001B^\t\u001d\u0011i-\fb\u0001\u0005w\u000bqc]3oI\u0006sG-Q<bSR\f5/\u001f8d\u0007>lW.\u001b;\u0016\r\t\r(1\u001eBx)\u0019\t\tG!:\u0003r\"9\u0011q\u0014\u0018A\u0002\t\u001d\b\u0003CAN\u00057\u0012IO!<\u0011\t\tU&1\u001e\u0003\b\u0005ss#\u0019\u0001B^!\u0011\u0011)La<\u0005\u000f\t5gF1\u0001\u0003<\"I!1\u001f\u0018\u0011\u0002\u0003\u0007!Q_\u0001\u000b_\u001a47/\u001a;t\u001fB$\b#\u0002=\u0003x\nm\u0018b\u0001B}s\n1q\n\u001d;j_:\u0004\u0002\"!>\u0003~\u0006\u00152\u0011A\u0005\u0005\u0005\u007f\u0014)AA\u0002NCB\u0004B!a'\u0004\u0004%!1QAAO\u0005EyeMZ:fi\u0006sG-T3uC\u0012\fG/Y\u0001\"g\u0016tG-\u00118e\u0003^\f\u0017\u000e^!ts:\u001c7i\\7nSR$C-\u001a4bk2$HEM\u000b\u0007\u0007\u0017\u0019ya!\u0005\u0016\u0005\r5!\u0006\u0002B{\u0005\u0003\"qA!/0\u0005\u0004\u0011Y\fB\u0004\u0003N>\u0012\rAa/\u0002Y\u0005$GmQ8ogVlWM]:U_\u001e\u0013x.\u001e9B]\u0012<\u0016-\u001b;G_J<%o\\;q\u0003N\u001c\u0018n\u001a8nK:$HCDB\f\u0007\u000f\u001cYma4\u0004T\u000eU7\u0011\u001c\t\bq\u000ee1QDB\u0012\u0013\r\u0019Y\"\u001f\u0002\u0007)V\u0004H.\u001a\u001a\u0011\r\t}5qDAo\u0013\u0011\u0019\tC!)\u0003\r\t+hMZ3s!\u0019\u0011yja\b\u0004&A\u0019\u0011QV$\u00031\r{gn];nKJ\f5o]5h]6,g\u000e\u001e)pY2,'oE\u0002H\u0007W\u0001Ba!\f\u000445\u00111q\u0006\u0006\u0004\u0007c9\u0017!B;uS2\u001c\u0018\u0002BB\u001b\u0007_\u0011!c\u00155vi\u0012|wO\\1cY\u0016$\u0006N]3bI\u0006\tBo\u001c9jGN$vnU;cg\u000e\u0014\u0018NY3\u0011\r\t511HAz\u0013\u0011\u0019iDa\u0007\u0003\t1K7\u000f^\u0001\u0013a\u0006\u0014H/\u001b;j_:\u001cHk\\!tg&<g\u000e\u0005\u0004\u0002v\u000e\r\u0013QE\u0005\u0005\u0007\u000b\u0012)AA\u0002TKR$\u0002b!\n\u0004J\r-3Q\n\u0005\b\u0003?[\u0005\u0019\u0001B-\u0011\u001d\u00199d\u0013a\u0001\u0007sAqaa\u0010L\u0001\u0004\u0019\t\u0005\u0006\u0004\u0004&\rE31\u000b\u0005\b\u0003?c\u0005\u0019\u0001B-\u0011\u001d\u00199\u0004\u0014a\u0001\u0007s!ba!\n\u0004X\re\u0003bBAP\u001b\u0002\u0007!\u0011\f\u0005\b\u0007\u007fi\u0005\u0019AB!\u0003=!\bN]8x]\u0016C8-\u001a9uS>tWCAB0!\u0015A(q_B1!\u0011\u0011iaa\u0019\n\t\r\u0015$1\u0004\u0002\n)\"\u0014xn^1cY\u0016\f1\u0003\u001e5s_^tW\t_2faRLwN\\0%KF$B!!\u0019\u0004l!I\u0011qW(\u0002\u0002\u0003\u00071qL\u0001\u0011i\"\u0014xn\u001e8Fq\u000e,\u0007\u000f^5p]\u0002B3\u0001UB9!\rA81O\u0005\u0004\u0007kJ(\u0001\u0003<pY\u0006$\u0018\u000e\\3\u0002!I,7-Z5wK\u0012lUm]:bO\u0016\u001c\u0018\u0001\u0006:fG\u0016Lg/\u001a3NKN\u001c\u0018mZ3t?\u0012*\u0017\u000f\u0006\u0003\u0002b\ru\u0004\"CA\\%\u0006\u0005\t\u0019AA\u0001\u0003E\u0011XmY3jm\u0016$W*Z:tC\u001e,7\u000f\t\u0015\u0004'\u000eE\u0014a\u00059beRLG/[8o\u0003N\u001c\u0018n\u001a8nK:$XCABD!\u0019\u0011yj!#\u0002&%!1Q\tBQ\u0003Q\u0001\u0018M\u001d;ji&|g.Q:tS\u001etW.\u001a8uA\u0005\u00192/\u001e2tGJL\u0007\u000f^5p]\u000eC\u0017M\\4fIV\u00111\u0011\u0013\t\u0004q\u000eM\u0015bABKs\n9!i\\8mK\u0006t\u0017aF:vEN\u001c'/\u001b9uS>t7\t[1oO\u0016$w\fJ3r)\u0011\t\tga'\t\u0013\u0005]v+!AA\u0002\rE\u0015\u0001F:vEN\u001c'/\u001b9uS>t7\t[1oO\u0016$\u0007\u0005K\u0002Y\u0007c\n!\u0003^8qS\u000e\u001c8+\u001e2tGJL\u0007\u000f^5p]V\u00111\u0011H\u0001\u0017i>\u0004\u0018nY:Tk\n\u001c8M]5qi&|gn\u0018\u0013fcR!\u0011\u0011MBU\u0011%\t9LWA\u0001\u0002\u0004\u0019I$A\nu_BL7m]*vEN\u001c'/\u001b9uS>t\u0007%A\tsK\n\fG.\u00198dK2K7\u000f^3oKJ,\"!!'\u0002%I,'-\u00197b]\u000e,G*[:uK:,'\u000fI\u0001\u0013G>t7/^7fe\u0006\u001b8/[4o[\u0016tG\u000f\u0006\u0002\u0004B\u0005I1/\u001e2tGJL'-\u001a\u000b\u0005\u0003C\u001aY\fC\u0004\u0004>~\u0003\ra!\u000f\u0002)9,w\u000fV8qS\u000e\u001cHk\\*vEN\u001c'/\u001b2f\u0003mI7oU;cg\u000e\u0014\u0018NY3SKF,Xm\u001d;Qe>\u001cWm]:fI\u0006\u0001\u0012N\\5uS\u0006$Xm\u00155vi\u0012|wO\u001c\u000b\u0003\u0007#\u000ba\u0001Z8X_J\\\u0007bBBea\u0001\u0007\u0011\u0011A\u0001\u0014]VlwJZ\"p]N,X.\u001a:t)>\fE\r\u001a\u0005\b\u0007\u001b\u0004\u0004\u0019AB\u000f\u00035\u0019wN\\:v[\u0016\u0014xI]8va\"91\u0011\u001b\u0019A\u0002\r\r\u0012aD2p]N,X.\u001a:Q_2dWM]:\t\u000f\r]\u0002\u00071\u0001\u0004:!91q\u001b\u0019A\u0002\r\u0005\u0013!D:vEN\u001c'/\u001b9uS>t7\u000fC\u0005\u0002FA\u0002\n\u00111\u0001\u0002t\u00061\u0014\r\u001a3D_:\u001cX/\\3sgR{wI]8va\u0006sGmV1ji\u001a{'o\u0012:pkB\f5o]5h]6,g\u000e\u001e\u0013eK\u001a\fW\u000f\u001c;%mU\u00111q\u001c\u0016\u0005\u0003g\u0014\t%A\nbI\u0012\u001cuN\\:v[\u0016\u00148\u000fV8He>,\b\u000f\u0006\b\u0004\u0018\r\u00158q]Bu\u0007W\u001cioa<\t\u000f\r%'\u00071\u0001\u0002\u0002!91Q\u001a\u001aA\u0002\ru\u0001bBBie\u0001\u000711\u0005\u0005\b\u0007o\u0011\u0004\u0019AB\u001d\u0011\u001d\u00199N\ra\u0001\u0007\u0003B\u0011\"!\u00123!\u0003\u0005\r!a=\u0002;\u0005$GmQ8ogVlWM]:U_\u001e\u0013x.\u001e9%I\u00164\u0017-\u001e7uIY\nqC^1mS\u0012\fG/Z$s_V\u0004\u0018i]:jO:lWM\u001c;\u0015\u0015\u0005\u00054q_B}\u0007w$\t\u0001C\u0004\u0004RR\u0002\raa\t\t\u000f\r]G\u00071\u0001\u0004B!I1Q \u001b\u0011\u0002\u0003\u00071q`\u0001\u0004[N<\u0007#\u0002=\u0003x\u0006M\b\"\u0003C\u0002iA\u0005\t\u0019AA+\u0003!9\u0018-\u001b;US6,\u0017!\t<bY&$\u0017\r^3He>,\b/Q:tS\u001etW.\u001a8uI\u0011,g-Y;mi\u0012\u001aTC\u0001C\u0005U\u0011\u0019yP!\u0011\u0002CY\fG.\u001b3bi\u0016<%o\\;q\u0003N\u001c\u0018n\u001a8nK:$H\u0005Z3gCVdG\u000f\n\u001b\u0002AM,(m]2sS\n,7i\u001c8tk6,'/\u00118e'R\f'\u000f\u001e)pY2Lgn\u001a\u000b\t\u0007K!\t\u0002b\u0005\u0005\u0016!9\u0011qT\u001cA\u0002\te\u0003bBB\u001co\u0001\u00071\u0011\b\u0005\n\u0007\u007f9\u0004\u0013!a\u0001\u0007\u0003\n!f];cg\u000e\u0014\u0018NY3D_:\u001cX/\\3s\u0003:$7\u000b^1siB{G\u000e\\5oO\u0012\"WMZ1vYR$3'\u0006\u0002\u0005\u001c)\"1\u0011\tB!\u00039\tw/Y5u%\u0016\u0014\u0017\r\\1oG\u0016$b!!\u0019\u0005\"\u0011M\u0002bBAPs\u0001\u0007A1\u0005\u0019\u0007\tK!I\u0003b\f\u0011\u0011\u0005m%1\fC\u0014\t[\u0001BA!.\u0005*\u0011aA1\u0006C\u0011\u0003\u0003\u0005\tQ!\u0001\u0003<\n\u0019q\fJ\u0019\u0011\t\tUFq\u0006\u0003\r\tc!\t#!A\u0001\u0002\u000b\u0005!1\u0018\u0002\u0004?\u0012\u0012\u0004bBBWs\u0001\u0007\u00111V\u0001\u0012K:\u001cXO]3O_J+'-\u00197b]\u000e,GCBA1\ts!Y\u0005C\u0004\u0002 j\u0002\r\u0001b\u000f1\r\u0011uB\u0011\tC$!!\tYJa\u0017\u0005@\u0011\u0015\u0003\u0003\u0002B[\t\u0003\"A\u0002b\u0011\u0005:\u0005\u0005\t\u0011!B\u0001\u0005w\u00131a\u0018\u00134!\u0011\u0011)\fb\u0012\u0005\u0019\u0011%C\u0011HA\u0001\u0002\u0003\u0015\tAa/\u0003\u0007}#C\u0007C\u0004\u0004.j\u0002\r!a+\u00037\r{WO\u001c;D_:\u001cX/\\3s\u0007>lW.\u001b;DC2d'-Y2l'\u0015Y\u00141\u0013C)!\u0011\tY\nb\u0015\n\t\u0011U\u0013Q\u0014\u0002\u0015\u001f\u001a47/\u001a;D_6l\u0017\u000e^\"bY2\u0014\u0017mY6\u0015\u0005\u0011e\u0003cAAWw\u0005a1/^2dKN\u001c8i\\;oi\u0006\u00012/^2dKN\u001c8i\\;oi~#S-\u001d\u000b\u0005\u0003C\"\t\u0007C\u0005\u00028z\n\t\u00111\u0001\u0002\u0002\u0005i1/^2dKN\u001c8i\\;oi\u0002\n\u0011BZ1jY\u000e{WO\u001c;\u0002\u001b\u0019\f\u0017\u000e\\\"pk:$x\fJ3r)\u0011\t\t\u0007b\u001b\t\u0013\u0005]\u0016)!AA\u0002\u0005\u0005\u0011A\u00034bS2\u001cu.\u001e8uA\u0005IA.Y:u\u000bJ\u0014xN]\u000b\u0003\tg\u0002R\u0001\u001fB|\tk\u0002BA!\u0004\u0005x%!A\u0011\u0010B\u000e\u0005%)\u0005pY3qi&|g.A\u0007mCN$XI\u001d:pe~#S-\u001d\u000b\u0005\u0003C\"y\bC\u0005\u00028\u0012\u000b\t\u00111\u0001\u0005t\u0005QA.Y:u\u000bJ\u0014xN\u001d\u0011\u0002\u0015=t7i\\7qY\u0016$X\r\u0006\u0004\u0002b\u0011\u001dEq\u0012\u0005\b\t\u00133\u0005\u0019\u0001CF\u0003\u001dygMZ:fiN\u0004\u0002\"!\u001c\u0005\u000e\u0006\u00152\u0011A\u0005\u0005\u0005\u007f\fy\u0007C\u0004\u0005\u0012\u001a\u0003\r\u0001\"\u001e\u0002\u0013\u0015D8-\u001a9uS>t\u0017AG5t!\u0006\u0014H/\u001b;j_:\f5o]5h]6,g\u000e\u001e,bY&$GCBBI\t/#i\nC\u0004\u0005\u001a\u000e\u0004\r\u0001b'\u0002\u0017\u0005\u001c8/[4o[\u0016tGo\u001d\t\u0007\u0005?\u001byb!\u0011\t\u000f\u0005-7\r1\u0001\u0004B\u0001")
public abstract class AbstractConsumerTest
extends BaseRequestTest {
    private final double epsilon;
    private final String topic;
    private final int part;
    private final TopicPartition tp = new TopicPartition(this.topic(), this.part());
    private final int part2;
    private final TopicPartition tp2 = new TopicPartition(this.topic(), this.part2());
    private final String group;
    private final String producerClientId;
    private final String consumerClientId;
    private final long groupMaxSessionTimeoutMs;

    public double epsilon() {
        return this.epsilon;
    }

    @Override
    public int brokerCount() {
        return 3;
    }

    public String topic() {
        return this.topic;
    }

    public int part() {
        return this.part;
    }

    public TopicPartition tp() {
        return this.tp;
    }

    public int part2() {
        return this.part2;
    }

    public TopicPartition tp2() {
        return this.tp2;
    }

    public String group() {
        return this.group;
    }

    public String producerClientId() {
        return this.producerClientId;
    }

    public String consumerClientId() {
        return this.consumerClientId;
    }

    public long groupMaxSessionTimeoutMs() {
        return this.groupMaxSessionTimeoutMs;
    }

    @Override
    public void brokerPropertyOverrides(Properties properties) {
        properties.setProperty(KafkaConfig$.MODULE$.ControlledShutdownEnableProp(), "false");
        properties.setProperty(KafkaConfig$.MODULE$.OffsetsTopicReplicationFactorProp(), "3");
        properties.setProperty(KafkaConfig$.MODULE$.OffsetsTopicPartitionsProp(), "1");
        properties.setProperty(KafkaConfig$.MODULE$.GroupMinSessionTimeoutMsProp(), "100");
        properties.setProperty(KafkaConfig$.MODULE$.GroupMaxSessionTimeoutMsProp(), Long.toString(this.groupMaxSessionTimeoutMs()));
        properties.setProperty(KafkaConfig$.MODULE$.GroupInitialRebalanceDelayMsProp(), "10");
    }

    @Override
    @BeforeEach
    public void setUp() {
        super.setUp();
        this.createTopic(this.topic(), 2, this.brokerCount(), this.createTopic$default$4());
    }

    public KafkaConsumer<byte[], byte[]> createConsumerWithGroupId(String groupId) {
        Properties groupOverrideConfig = new Properties();
        groupOverrideConfig.setProperty("group.id", groupId);
        ByteArrayDeserializer x$2 = this.createConsumer$default$1();
        ByteArrayDeserializer x$3 = this.createConsumer$default$2();
        List<String> x$4 = this.createConsumer$default$4();
        return this.createConsumer(x$2, x$3, groupOverrideConfig, x$4);
    }

    public Seq<ProducerRecord<byte[], byte[]>> sendRecords(KafkaProducer<byte[], byte[]> producer, int numRecords, TopicPartition tp, long startingTimestamp) {
        IndexedSeq records = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numRecords).map((Function1 & Serializable & scala.Serializable)i -> AbstractConsumerTest.$anonfun$sendRecords$1(startingTimestamp, tp, producer, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
        producer.flush();
        return records;
    }

    public long sendRecords$default$4() {
        return System.currentTimeMillis();
    }

    public void consumeAndVerifyRecords(Consumer<byte[], byte[]> consumer, int numRecords, int startingOffset, int startingKeyAndValueIndex, long startingTimestamp, TimestampType timestampType, TopicPartition tp, int maxPollRecords) {
        ArrayBuffer<ConsumerRecord<byte[], byte[]>> records = this.consumeRecords(consumer, numRecords, maxPollRecords);
        long now = System.currentTimeMillis();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numRecords).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            ConsumerRecord record = (ConsumerRecord)records.apply(i);
            int offset = startingOffset + i;
            Assertions.assertEquals((Object)tp.topic(), (Object)record.topic());
            Assertions.assertEquals((int)tp.partition(), (int)record.partition());
            TimestampType timestampType = timestampType;
            TimestampType timestampType2 = TimestampType.CREATE_TIME;
            if (!(timestampType != null ? !timestampType.equals(timestampType2) : timestampType2 != null)) {
                Assertions.assertEquals((Object)timestampType, (Object)record.timestampType());
                Assertions.assertEquals((long)(startingTimestamp + (long)i), (long)record.timestamp());
            } else {
                Assertions.assertTrue((record.timestamp() >= startingTimestamp && record.timestamp() <= now ? 1 : 0) != 0, (String)new StringBuilder(60).append("Got unexpected timestamp ").append(record.timestamp()).append(". Timestamp should be between [").append(startingTimestamp).append(", ").append(now).append("}]").toString());
            }
            Assertions.assertEquals((long)offset, (long)record.offset());
            int keyAndValueIndex = startingKeyAndValueIndex + i;
            Assertions.assertEquals((Object)new StringBuilder(4).append("key ").append(keyAndValueIndex).toString(), (Object)new String((byte[])record.key()));
            Assertions.assertEquals((Object)new StringBuilder(6).append("value ").append(keyAndValueIndex).toString(), (Object)new String((byte[])record.value()));
            Assertions.assertEquals((int)new StringBuilder(4).append("key ").append(keyAndValueIndex).toString().length(), (int)record.serializedKeySize());
            Assertions.assertEquals((int)new StringBuilder(6).append("value ").append(keyAndValueIndex).toString().length(), (int)record.serializedValueSize());
        });
    }

    public int consumeAndVerifyRecords$default$4() {
        return 0;
    }

    public long consumeAndVerifyRecords$default$5() {
        return 0L;
    }

    public TimestampType consumeAndVerifyRecords$default$6() {
        return TimestampType.CREATE_TIME;
    }

    public TopicPartition consumeAndVerifyRecords$default$7() {
        return this.tp();
    }

    public int consumeAndVerifyRecords$default$8() {
        return Integer.MAX_VALUE;
    }

    public <K, V> ArrayBuffer<ConsumerRecord<K, V>> consumeRecords(Consumer<K, V> consumer, int numRecords, int maxPollRecords) {
        ArrayBuffer records = new ArrayBuffer();
        Function1 & Serializable & scala.Serializable x$2 = (Function1 & Serializable & scala.Serializable)polledRecords -> BoxesRunTime.boxToBoolean((boolean)AbstractConsumerTest.pollAction$1(polledRecords, maxPollRecords, records, numRecords));
        long x$3 = 60000L;
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long pollRecordsUntilTrue_x$3 = 0L;
        long pollRecordsUntilTrue_waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TestUtils$.$anonfun$pollRecordsUntilTrue$1(consumer, x$2)) {
            if (System.currentTimeMillis() > pollRecordsUntilTrue_waitUntilTrue_startTime + x$3) {
                Assertions.fail((String)AbstractConsumerTest.$anonfun$consumeRecords$2(numRecords, records));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(x$3), pollRecordsUntilTrue_x$3));
        }
        return records;
    }

    public <K, V> int consumeRecords$default$3() {
        return Integer.MAX_VALUE;
    }

    /*
     * WARNING - void declaration
     */
    public <K, V> void sendAndAwaitAsyncCommit(Consumer<K, V> consumer, Option<scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata>> offsetsOpt) {
        void pollUntilTrue_action;
        public class Kafka_api_AbstractConsumerTest$RetryCommitCallback$1
        implements OffsetCommitCallback {
            private boolean isComplete;
            private Option<Exception> error;
            private final /* synthetic */ AbstractConsumerTest $outer;
            private final Option offsetsOpt$1;
            private final Consumer consumer$1;

            public boolean isComplete() {
                return this.isComplete;
            }

            public void isComplete_$eq(boolean x$1) {
                this.isComplete = x$1;
            }

            public Option<Exception> error() {
                return this.error;
            }

            public void error_$eq(Option<Exception> x$1) {
                this.error = x$1;
            }

            public void onComplete(java.util.Map<TopicPartition, OffsetAndMetadata> offsets, Exception exception) {
                if (exception instanceof RetriableCommitFailedException) {
                    AbstractConsumerTest.kafka$api$AbstractConsumerTest$$sendAsyncCommit$1(this, this.offsetsOpt$1, this.consumer$1);
                    return;
                }
                this.isComplete_$eq(true);
                this.error_$eq((Option<Exception>)Option$.MODULE$.apply((Object)exception));
            }

            public Kafka_api_AbstractConsumerTest$RetryCommitCallback$1(AbstractConsumerTest $outer, Option offsetsOpt$1, Consumer consumer$1) {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.offsetsOpt$1 = offsetsOpt$1;
                this.consumer$1 = consumer$1;
                this.isComplete = false;
                this.error = None$.MODULE$;
            }
        }
        Kafka_api_AbstractConsumerTest$RetryCommitCallback$1 commitCallback = new Kafka_api_AbstractConsumerTest$RetryCommitCallback$1(this, offsetsOpt, consumer);
        AbstractConsumerTest.kafka$api$AbstractConsumerTest$$sendAsyncCommit$1(commitCallback, offsetsOpt, consumer);
        long l = 10000L;
        JFunction0.mcZ.sp & Serializable & scala.Serializable intersect = (JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> commitCallback.isComplete();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long pollUntilTrue_x$3 = 0L;
        long pollUntilTrue_waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TestUtils$.$anonfun$pollUntilTrue$1(consumer, (Function0)pollUntilTrue_action)) {
            void pollUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > pollUntilTrue_waitUntilTrue_startTime + pollUntilTrue_waitTimeMs) {
                Assertions.fail((String)AbstractConsumerTest.$anonfun$sendAndAwaitAsyncCommit$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)pollUntilTrue_waitTimeMs), pollUntilTrue_x$3));
        }
        Assertions.assertEquals((Object)None$.MODULE$, commitCallback.error());
    }

    public <K, V> Option<scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata>> sendAndAwaitAsyncCommit$default$2() {
        return None$.MODULE$;
    }

    public Tuple2<Buffer<KafkaConsumer<byte[], byte[]>>, Buffer<ConsumerAssignmentPoller>> addConsumersToGroupAndWaitForGroupAssignment(int numOfConsumersToAdd, Buffer<KafkaConsumer<byte[], byte[]>> consumerGroup, Buffer<ConsumerAssignmentPoller> consumerPollers, List<String> topicsToSubscribe, scala.collection.immutable.Set<TopicPartition> subscriptions, String group) {
        Assertions.assertTrue((consumerGroup.size() + numOfConsumersToAdd <= subscriptions.size() ? 1 : 0) != 0);
        this.addConsumersToGroup(numOfConsumersToAdd, consumerGroup, consumerPollers, topicsToSubscribe, subscriptions, group);
        this.validateGroupAssignment(consumerPollers, subscriptions, this.validateGroupAssignment$default$3(), this.validateGroupAssignment$default$4());
        return new Tuple2(consumerGroup, consumerPollers);
    }

    public Tuple2<Buffer<KafkaConsumer<byte[], byte[]>>, Buffer<ConsumerAssignmentPoller>> addConsumersToGroup(int numOfConsumersToAdd, Buffer<KafkaConsumer<byte[], byte[]>> consumerGroup, Buffer<ConsumerAssignmentPoller> consumerPollers, List<String> topicsToSubscribe, scala.collection.immutable.Set<TopicPartition> subscriptions, String group) {
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numOfConsumersToAdd).foreach((Function1 & Serializable & scala.Serializable)_ -> AbstractConsumerTest.$anonfun$addConsumersToGroup$1(this, group, consumerGroup, consumerPollers, topicsToSubscribe, BoxesRunTime.unboxToInt((Object)_)));
        return new Tuple2(consumerGroup, consumerPollers);
    }

    public String addConsumersToGroupAndWaitForGroupAssignment$default$6() {
        return this.group();
    }

    public String addConsumersToGroup$default$6() {
        return this.group();
    }

    /*
     * WARNING - void declaration
     */
    public void validateGroupAssignment(Buffer<ConsumerAssignmentPoller> consumerPollers, scala.collection.immutable.Set<TopicPartition> subscriptions, Option<String> msg, long waitTime) {
        Buffer assignments = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!AbstractConsumerTest.$anonfun$validateGroupAssignment$1(this, assignments, consumerPollers, subscriptions)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitTime) {
                Assertions.fail((String)AbstractConsumerTest.$anonfun$validateGroupAssignment$3(msg, subscriptions, assignments));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitTime), (long)waitUntilTrue_pause));
        }
    }

    public Option<String> validateGroupAssignment$default$3() {
        return None$.MODULE$;
    }

    public long validateGroupAssignment$default$4() {
        return 10000L;
    }

    public ConsumerAssignmentPoller subscribeConsumerAndStartPolling(Consumer<byte[], byte[]> consumer, List<String> topicsToSubscribe, scala.collection.immutable.Set<TopicPartition> partitionsToAssign) {
        Assertions.assertEquals((int)0, (int)consumer.assignment().size());
        ConsumerAssignmentPoller consumerPoller = topicsToSubscribe.nonEmpty() ? new ConsumerAssignmentPoller(this, consumer, topicsToSubscribe) : new ConsumerAssignmentPoller(this, consumer, partitionsToAssign);
        consumerPoller.start();
        return consumerPoller;
    }

    public scala.collection.immutable.Set<TopicPartition> subscribeConsumerAndStartPolling$default$3() {
        return Predef$.MODULE$.Set().empty();
    }

    /*
     * WARNING - void declaration
     */
    public void awaitRebalance(Consumer<?, ?> consumer, TestConsumerReassignmentListener rebalanceListener) {
        void pollUntilTrue_action;
        int numReassignments = rebalanceListener.callsToAssigned();
        long l = TestUtils$.MODULE$.pollUntilTrue$default$4();
        JFunction0.mcZ.sp & Serializable & scala.Serializable intersect = (JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> rebalanceListener.callsToAssigned() > numReassignments;
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long pollUntilTrue_x$3 = 0L;
        long pollUntilTrue_waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TestUtils$.$anonfun$pollUntilTrue$1(consumer, (Function0)pollUntilTrue_action)) {
            void pollUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > pollUntilTrue_waitUntilTrue_startTime + pollUntilTrue_waitTimeMs) {
                Assertions.fail((String)AbstractConsumerTest.$anonfun$awaitRebalance$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)pollUntilTrue_waitTimeMs), pollUntilTrue_x$3));
        }
    }

    public void ensureNoRebalance(Consumer<?, ?> consumer, TestConsumerReassignmentListener rebalanceListener) {
        int initialRevokeCalls = rebalanceListener.callsToRevoked();
        this.sendAndAwaitAsyncCommit(consumer, this.sendAndAwaitAsyncCommit$default$2());
        Assertions.assertEquals((int)initialRevokeCalls, (int)rebalanceListener.callsToRevoked());
    }

    public boolean isPartitionAssignmentValid(Buffer<scala.collection.immutable.Set<TopicPartition>> assignments, scala.collection.immutable.Set<TopicPartition> partitions) {
        if (!assignments.forall((Function1 & Serializable & scala.Serializable)assignment -> BoxesRunTime.boxToBoolean((boolean)assignment.nonEmpty()))) {
            return false;
        }
        if (BoxesRunTime.unboxToInt((Object)assignments.foldLeft((Object)BoxesRunTime.boxToInteger((int)0), (Function2 & Serializable & scala.Serializable)(x$2, x$3) -> BoxesRunTime.boxToInteger((int)AbstractConsumerTest.$anonfun$isPartitionAssignmentValid$2(BoxesRunTime.unboxToInt((Object)x$2), x$3)))) != partitions.size()) {
            return false;
        }
        scala.collection.immutable.Set set = (scala.collection.immutable.Set)assignments.foldLeft((Object)Predef$.MODULE$.Set().empty(), (Function2 & Serializable & scala.Serializable)(x$4, x$5) -> (scala.collection.immutable.Set)x$4.$plus$plus((GenTraversableOnce)x$5));
        return set != null && set.equals(partitions);
    }

    public static final /* synthetic */ ProducerRecord $anonfun$sendRecords$1(long startingTimestamp$1, TopicPartition tp$1, KafkaProducer producer$1, int i) {
        long timestamp = startingTimestamp$1 + (long)i;
        ProducerRecord record = new ProducerRecord(tp$1.topic(), Predef$.MODULE$.int2Integer(tp$1.partition()), Predef$.MODULE$.long2Long(timestamp), (Object)new StringBuilder(4).append("key ").append(i).toString().getBytes(), (Object)new StringBuilder(6).append("value ").append(i).toString().getBytes());
        producer$1.send(record);
        return record;
    }

    private static final boolean pollAction$1(ConsumerRecords polledRecords, int maxPollRecords$1, ArrayBuffer records$2, int numRecords$1) {
        Assertions.assertTrue((((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter((Iterable)polledRecords).asScala()).size() <= maxPollRecords$1 ? 1 : 0) != 0);
        records$2.$plus$plus$eq((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter((Iterable)polledRecords).asScala());
        return records$2.size() >= numRecords$1;
    }

    public static final /* synthetic */ String $anonfun$consumeRecords$2(int numRecords$1, ArrayBuffer records$2) {
        return new StringBuilder(71).append("Timed out before consuming expected ").append(numRecords$1).append(" records. ").append("The number consumed was ").append(records$2.size()).append(".").toString();
    }

    public static final void kafka$api$AbstractConsumerTest$$sendAsyncCommit$1(OffsetCommitCallback callback, Option offsetsOpt$1, Consumer consumer$1) {
        if (offsetsOpt$1 instanceof Some) {
            scala.collection.immutable.Map offsets = (scala.collection.immutable.Map)((Some)offsetsOpt$1).value();
            consumer$1.commitAsync((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)offsets).asJava(), callback);
            return;
        }
        if (None$.MODULE$.equals(offsetsOpt$1)) {
            consumer$1.commitAsync(callback);
            return;
        }
        throw new MatchError((Object)offsetsOpt$1);
    }

    public static final /* synthetic */ String $anonfun$sendAndAwaitAsyncCommit$2() {
        return "Failed to observe commit callback before timeout";
    }

    public static final /* synthetic */ Buffer $anonfun$addConsumersToGroup$1(AbstractConsumerTest $this, String group$1, Buffer consumerGroup$1, Buffer consumerPollers$1, List topicsToSubscribe$1, int _) {
        KafkaConsumer<byte[], byte[]> consumer = $this.createConsumerWithGroupId(group$1);
        consumerGroup$1.$plus$eq(consumer);
        return consumerPollers$1.$plus$eq((Object)$this.subscribeConsumerAndStartPolling((Consumer<byte[], byte[]>)consumer, (List<String>)topicsToSubscribe$1, $this.subscribeConsumerAndStartPolling$default$3()));
    }

    public static final /* synthetic */ boolean $anonfun$validateGroupAssignment$1(AbstractConsumerTest $this, Buffer assignments$1, Buffer consumerPollers$2, scala.collection.immutable.Set subscriptions$1) {
        assignments$1.clear();
        consumerPollers$2.foreach((Function1 & Serializable & scala.Serializable)x$1 -> assignments$1.$plus$eq(x$1.consumerAssignment()));
        return $this.isPartitionAssignmentValid((Buffer<scala.collection.immutable.Set<TopicPartition>>)assignments$1, (scala.collection.immutable.Set<TopicPartition>)subscriptions$1);
    }

    public static final /* synthetic */ String $anonfun$validateGroupAssignment$3(Option msg$1, scala.collection.immutable.Set subscriptions$1, Buffer assignments$1) {
        return (String)msg$1.getOrElse((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(59).append("Did not get valid assignment for partitions ").append(subscriptions$1).append(". Instead, got ").append(assignments$1).toString());
    }

    public static final /* synthetic */ String $anonfun$awaitRebalance$2() {
        return "Timed out before expected rebalance completed";
    }

    public static final /* synthetic */ int $anonfun$isPartitionAssignmentValid$2(int x$2, scala.collection.immutable.Set x$3) {
        return x$2 + x$3.size();
    }

    public AbstractConsumerTest() {
        this.epsilon = 0.1;
        this.topic = "topic";
        this.part = 0;
        this.part2 = 1;
        this.group = "my-test";
        this.producerClientId = "ConsumerTestProducer";
        this.consumerClientId = "ConsumerTestConsumer";
        this.groupMaxSessionTimeoutMs = 30000L;
        this.producerConfig().setProperty("acks", "all");
        this.producerConfig().setProperty("client.id", this.producerClientId());
        this.consumerConfig().setProperty("client.id", this.consumerClientId());
        this.consumerConfig().setProperty("group.id", this.group());
        this.consumerConfig().setProperty("auto.offset.reset", "earliest");
        this.consumerConfig().setProperty("enable.auto.commit", "false");
        this.consumerConfig().setProperty("metadata.max.age.ms", "100");
        this.consumerConfig().setProperty("max.poll.interval.ms", "6000");
    }

    public class ConsumerAssignmentPoller
    extends ShutdownableThread {
        private final Consumer<byte[], byte[]> consumer;
        private final scala.collection.immutable.Set<TopicPartition> partitionsToAssign;
        private volatile Option<Throwable> thrownException;
        private volatile int receivedMessages;
        private final Set<TopicPartition> kafka$api$AbstractConsumerTest$ConsumerAssignmentPoller$$partitionAssignment;
        private volatile boolean subscriptionChanged;
        private List<String> topicsSubscription;
        private final ConsumerRebalanceListener rebalanceListener;
        public final /* synthetic */ AbstractConsumerTest $outer;

        public Option<Throwable> thrownException() {
            return this.thrownException;
        }

        public void thrownException_$eq(Option<Throwable> x$1) {
            this.thrownException = x$1;
        }

        public int receivedMessages() {
            return this.receivedMessages;
        }

        public void receivedMessages_$eq(int x$1) {
            this.receivedMessages = x$1;
        }

        public Set<TopicPartition> kafka$api$AbstractConsumerTest$ConsumerAssignmentPoller$$partitionAssignment() {
            return this.kafka$api$AbstractConsumerTest$ConsumerAssignmentPoller$$partitionAssignment;
        }

        private boolean subscriptionChanged() {
            return this.subscriptionChanged;
        }

        private void subscriptionChanged_$eq(boolean x$1) {
            this.subscriptionChanged = x$1;
        }

        private List<String> topicsSubscription() {
            return this.topicsSubscription;
        }

        private void topicsSubscription_$eq(List<String> x$1) {
            this.topicsSubscription = x$1;
        }

        public ConsumerRebalanceListener rebalanceListener() {
            return this.rebalanceListener;
        }

        public scala.collection.immutable.Set<TopicPartition> consumerAssignment() {
            return this.kafka$api$AbstractConsumerTest$ConsumerAssignmentPoller$$partitionAssignment().toSet();
        }

        public void subscribe(List<String> newTopicsToSubscribe) {
            if (this.subscriptionChanged()) {
                throw new IllegalStateException("Do not call subscribe until the previous subscribe request is processed.");
            }
            if (this.partitionsToAssign.nonEmpty()) {
                throw new IllegalStateException("Cannot call subscribe when configured to use manual partition assignment");
            }
            this.topicsSubscription_$eq(newTopicsToSubscribe);
            this.subscriptionChanged_$eq(true);
        }

        public boolean isSubscribeRequestProcessed() {
            return !this.subscriptionChanged();
        }

        /*
         * WARNING - void declaration
         */
        public boolean initiateShutdown() {
            void var1_1;
            boolean res = super.initiateShutdown();
            this.consumer.wakeup();
            return (boolean)var1_1;
        }

        public void doWork() {
            if (this.subscriptionChanged()) {
                this.consumer.subscribe((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter(this.topicsSubscription()).asJava(), this.rebalanceListener());
                this.subscriptionChanged_$eq(false);
            }
            try {
                this.receivedMessages_$eq(this.receivedMessages() + this.consumer.poll(Duration.ofMillis(50L)).count());
                return;
            }
            catch (WakeupException wakeupException) {
                return;
            }
            catch (Throwable e) {
                this.thrownException_$eq((Option<Throwable>)new Some((Object)e));
                throw e;
            }
        }

        public /* synthetic */ AbstractConsumerTest kafka$api$AbstractConsumerTest$ConsumerAssignmentPoller$$$outer() {
            return this.$outer;
        }

        public ConsumerAssignmentPoller(AbstractConsumerTest $outer, Consumer<byte[], byte[]> consumer, List<String> topicsToSubscribe, scala.collection.immutable.Set<TopicPartition> partitionsToAssign) {
            this.consumer = consumer;
            this.partitionsToAssign = partitionsToAssign;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            super("daemon-consumer-assignment", false);
            this.thrownException = None$.MODULE$;
            this.receivedMessages = 0;
            this.kafka$api$AbstractConsumerTest$ConsumerAssignmentPoller$$partitionAssignment = (Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
            this.subscriptionChanged = false;
            this.topicsSubscription = topicsToSubscribe;
            this.rebalanceListener = new ConsumerRebalanceListener(this){
                private final /* synthetic */ ConsumerAssignmentPoller $outer;

                public void onPartitionsLost(Collection<TopicPartition> x$1) {
                    super.onPartitionsLost(x$1);
                }

                public void onPartitionsAssigned(Collection<TopicPartition> partitions) {
                    this.$outer.kafka$api$AbstractConsumerTest$ConsumerAssignmentPoller$$partitionAssignment().$plus$plus$eq((TraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps(partitions.toArray((Object[])new TopicPartition[0]))));
                }

                public void onPartitionsRevoked(Collection<TopicPartition> partitions) {
                    this.$outer.kafka$api$AbstractConsumerTest$ConsumerAssignmentPoller$$partitionAssignment().$minus$minus$eq((TraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps(partitions.toArray((Object[])new TopicPartition[0]))));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            };
            if (partitionsToAssign.isEmpty()) {
                consumer.subscribe((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter(topicsToSubscribe).asJava(), this.rebalanceListener());
                return;
            }
            consumer.assign((Collection)CollectionConverters$.MODULE$.setAsJavaSetConverter(partitionsToAssign).asJava());
        }

        public ConsumerAssignmentPoller(AbstractConsumerTest $outer, Consumer<byte[], byte[]> consumer, List<String> topicsToSubscribe) {
            this($outer, consumer, topicsToSubscribe, (scala.collection.immutable.Set<TopicPartition>)Predef$.MODULE$.Set().empty());
        }

        public ConsumerAssignmentPoller(AbstractConsumerTest $outer, Consumer<byte[], byte[]> consumer, scala.collection.immutable.Set<TopicPartition> partitionsToAssign) {
            this($outer, consumer, (List<String>)List$.MODULE$.empty(), partitionsToAssign);
        }
    }

    public class CountConsumerCommitCallback
    implements OffsetCommitCallback {
        private int successCount;
        private int failCount;
        private Option<Exception> lastError;

        public int successCount() {
            return this.successCount;
        }

        public void successCount_$eq(int x$1) {
            this.successCount = x$1;
        }

        public int failCount() {
            return this.failCount;
        }

        public void failCount_$eq(int x$1) {
            this.failCount = x$1;
        }

        public Option<Exception> lastError() {
            return this.lastError;
        }

        public void lastError_$eq(Option<Exception> x$1) {
            this.lastError = x$1;
        }

        public void onComplete(java.util.Map<TopicPartition, OffsetAndMetadata> offsets, Exception exception) {
            if (exception == null) {
                this.successCount_$eq(this.successCount() + 1);
                return;
            }
            this.failCount_$eq(this.failCount() + 1);
            this.lastError_$eq((Option<Exception>)new Some((Object)exception));
        }

        public /* synthetic */ AbstractConsumerTest kafka$api$AbstractConsumerTest$CountConsumerCommitCallback$$$outer() {
            return AbstractConsumerTest.this;
        }

        public CountConsumerCommitCallback() {
            if (AbstractConsumerTest.this == null) {
                throw null;
            }
            this.successCount = 0;
            this.failCount = 0;
            this.lastError = None$.MODULE$;
        }
    }

    public class TestConsumerReassignmentListener
    implements ConsumerRebalanceListener {
        private int callsToAssigned;
        private int callsToRevoked;

        public void onPartitionsLost(Collection<TopicPartition> x$1) {
            super.onPartitionsLost(x$1);
        }

        public int callsToAssigned() {
            return this.callsToAssigned;
        }

        public void callsToAssigned_$eq(int x$1) {
            this.callsToAssigned = x$1;
        }

        public int callsToRevoked() {
            return this.callsToRevoked;
        }

        public void callsToRevoked_$eq(int x$1) {
            this.callsToRevoked = x$1;
        }

        public void onPartitionsAssigned(Collection<TopicPartition> partitions) {
            this.kafka$api$AbstractConsumerTest$TestConsumerReassignmentListener$$$outer().info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "onPartitionsAssigned called.");
            this.callsToAssigned_$eq(this.callsToAssigned() + 1);
        }

        public void onPartitionsRevoked(Collection<TopicPartition> partitions) {
            this.kafka$api$AbstractConsumerTest$TestConsumerReassignmentListener$$$outer().info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "onPartitionsRevoked called.");
            this.callsToRevoked_$eq(this.callsToRevoked() + 1);
        }

        public /* synthetic */ AbstractConsumerTest kafka$api$AbstractConsumerTest$TestConsumerReassignmentListener$$$outer() {
            return AbstractConsumerTest.this;
        }

        public TestConsumerReassignmentListener() {
            if (AbstractConsumerTest.this == null) {
                throw null;
            }
            this.callsToAssigned = 0;
            this.callsToRevoked = 0;
        }
    }
}

