/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.Serializable;
import java.util.Collection;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import kafka.api.PlaintextAdminIntegrationTest$;
import kafka.integration.KafkaServerTestHarness;
import kafka.log.LogConfig$;
import kafka.server.Defaults$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AlterConfigsOptions;
import org.apache.kafka.clients.admin.AlterConfigsResult;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.errors.PolicyViolationException;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.policy.AlterConfigPolicy;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.ObjectRef;

@Timeout(value=120L)
@ScalaSignature(bytes="\u0006\u0001\u0005mg\u0001\u0002\u000f\u001e\u0001\tBQa\f\u0001\u0005\u0002ABqa\r\u0001A\u0002\u0013\u0005A\u0007C\u0004C\u0001\u0001\u0007I\u0011A\"\t\r1\u0003\u0001\u0015)\u00036\u0011\u001di\u0005A1A\u0005\u00029CaA\u0015\u0001!\u0002\u0013y\u0005\"B*\u0001\t\u0003\"\u0006\"B0\u0001\t\u0003\"\u0006\"\u00023\u0001\t\u0003)\u0007BB@\u0001\t\u0003\n\t\u0001\u0003\u0004\u0002\u001c\u0001!\t\u0001\u0016\u0005\u0007\u0003K\u0001A\u0011\u0001+\t\r\u0005%\u0002\u0001\"\u0001U\u000f\u001d\tY%\bE\u0001\u0003\u001b2a\u0001H\u000f\t\u0002\u0005=\u0003BB\u0018\u0010\t\u0003\t9F\u0002\u0004\u0002Z=\u0001\u00111\f\u0005\u0007_E!\t!a\u001b\t\u0017\u0005E\u0014\u00031AA\u0002\u0013\u0005\u00111\u000f\u0005\f\u0003'\u000b\u0002\u0019!a\u0001\n\u0003\t)\nC\u0006\u0002\u0004F\u0001\r\u0011!Q!\n\u0005U\u0004\"CAQ#\u0001\u0007I\u0011AAR\u0011%\tY+\u0005a\u0001\n\u0003\ti\u000b\u0003\u0005\u00022F\u0001\u000b\u0015BAS\u0011\u001d\t\u0019,\u0005C\u0001\u0003kCq!a1\u0012\t\u0003\t)\r\u0003\u0004\u0002ZF!\t\u0001\u0016\u0002'\u0003\u0012l\u0017N\\\"mS\u0016tGoV5uQB{G.[2jKNLe\u000e^3he\u0006$\u0018n\u001c8UKN$(B\u0001\u0010 \u0003\r\t\u0007/\u001b\u0006\u0002A\u0005)1.\u00194lC\u000e\u00011c\u0001\u0001$SA\u0011AeJ\u0007\u0002K)\u0011aeH\u0001\fS:$Xm\u001a:bi&|g.\u0003\u0002)K\t12*\u00194lCN+'O^3s)\u0016\u001cH\u000fS1s]\u0016\u001c8\u000f\u0005\u0002+[5\t1F\u0003\u0002-?\u0005)Q\u000f^5mg&\u0011af\u000b\u0002\b\u0019><w-\u001b8h\u0003\u0019a\u0014N\\5u}Q\t\u0011\u0007\u0005\u00023\u00015\tQ$\u0001\u0004dY&,g\u000e^\u000b\u0002kA\u0011a\u0007Q\u0007\u0002o)\u0011\u0001(O\u0001\u0006C\u0012l\u0017N\u001c\u0006\u0003um\nqa\u00197jK:$8O\u0003\u0002!y)\u0011QHP\u0001\u0007CB\f7\r[3\u000b\u0003}\n1a\u001c:h\u0013\t\tuGA\u0003BI6Lg.\u0001\u0006dY&,g\u000e^0%KF$\"\u0001\u0012&\u0011\u0005\u0015CU\"\u0001$\u000b\u0003\u001d\u000bQa]2bY\u0006L!!\u0013$\u0003\tUs\u0017\u000e\u001e\u0005\b\u0017\u000e\t\t\u00111\u00016\u0003\rAH%M\u0001\bG2LWM\u001c;!\u0003-\u0011'o\\6fe\u000e{WO\u001c;\u0016\u0003=\u0003\"!\u0012)\n\u0005E3%aA%oi\u0006a!M]8lKJ\u001cu.\u001e8uA\u0005)1/\u001a;VaR\tA\t\u000b\u0002\b-B\u0011q+X\u0007\u00021*\u0011a$\u0017\u0006\u00035n\u000bqA[;qSR,'O\u0003\u0002]}\u0005)!.\u001e8ji&\u0011a\f\u0017\u0002\u000b\u0005\u00164wN]3FC\u000eD\u0017\u0001\u0003;fCJ$un\u001e8)\u0005!\t\u0007CA,c\u0013\t\u0019\u0007LA\u0005BMR,'/R1dQ\u0006a1M]3bi\u0016\u001cuN\u001c4jOV\ta\r\u0005\u0003hY:LX\"\u00015\u000b\u0005%T\u0017\u0001B;uS2T\u0011a[\u0001\u0005U\u00064\u0018-\u0003\u0002nQ\n\u0019Q*\u00199\u0011\u0005=4hB\u00019u!\t\th)D\u0001s\u0015\t\u0019\u0018%\u0001\u0004=e>|GOP\u0005\u0003k\u001a\u000ba\u0001\u0015:fI\u00164\u0017BA<y\u0005\u0019\u0019FO]5oO*\u0011QO\u0012\t\u0003uvl\u0011a\u001f\u0006\u0003y*\fA\u0001\\1oO&\u0011ap\u001f\u0002\u0007\u001f\nTWm\u0019;\u0002\u001f\u001d,g.\u001a:bi\u0016\u001cuN\u001c4jON,\"!a\u0001\u0011\r\u0005\u0015\u00111BA\b\u001b\t\t9AC\u0002\u0002\n\u0019\u000b!bY8mY\u0016\u001cG/[8o\u0013\u0011\ti!a\u0002\u0003\u0007M+\u0017\u000f\u0005\u0003\u0002\u0012\u0005]QBAA\n\u0015\r\t)bH\u0001\u0007g\u0016\u0014h/\u001a:\n\t\u0005e\u00111\u0003\u0002\f\u0017\u000647.Y\"p]\u001aLw-A\u000buKN$h+\u00197jI\u0006cG/\u001a:D_:4\u0017nZ:)\u0007-\ty\u0002E\u0002X\u0003CI1!a\tY\u0005\u0011!Vm\u001d;\u0002/Q,7\u000f^%om\u0006d\u0017\u000eZ!mi\u0016\u00148i\u001c8gS\u001e\u001c\bf\u0001\u0007\u0002 \u0005\u0011C/Z:u\u0013:4\u0018\r\\5e\u00032$XM]\"p]\u001aLwm\u001d#vKR{\u0007k\u001c7jGfD3!DA\u0010Q\u001di\u0011qFA\u001e\u0003{\u0001B!!\r\u000285\u0011\u00111\u0007\u0006\u0004\u0003k1\u0015AC1o]>$\u0018\r^5p]&!\u0011\u0011HA\u001a\u0005\u0019qwn^1s]\u0006)a/\u00197vK\u0006\u0012\u0011qH\u0001\u0010G\u0006$X\bZ3qe\u0016\u001c\u0017\r^5p]\":\u0001!a\u0011\u0002<\u0005%\u0003cA,\u0002F%\u0019\u0011q\t-\u0003\u000fQKW.Z8viz\t\u00010\u0001\u0014BI6Lgn\u00117jK:$x+\u001b;i!>d\u0017nY5fg&sG/Z4sCRLwN\u001c+fgR\u0004\"AM\b\u0014\u0007=\t\t\u0006E\u0002F\u0003'J1!!\u0016G\u0005\u0019\te.\u001f*fMR\u0011\u0011Q\n\u0002\u0007!>d\u0017nY=\u0014\tEI\u0018Q\f\t\u0005\u0003?\n9'\u0004\u0002\u0002b)!\u00111MA3\u0003\u0019\u0001x\u000e\\5ds*\u0019\u0011QC\u001e\n\t\u0005%\u0014\u0011\r\u0002\u0012\u00032$XM]\"p]\u001aLw\rU8mS\u000eLHCAA7!\r\ty'E\u0007\u0002\u001f\u000591m\u001c8gS\u001e\u001cXCAA;a\u0011\t9(a \u0011\r=\fIH\\A>\u0013\ti\u0007\u0010\u0005\u0003\u0002~\u0005}D\u0002\u0001\u0003\f\u0003\u0003+\u0012\u0011!A\u0001\u0006\u0003\t)IA\u0002`IE\n\u0001bY8oM&<7\u000fI\t\u0005\u0003\u000f\u000bi\tE\u0002F\u0003\u0013K1!a#G\u0005\u001dqu\u000e\u001e5j]\u001e\u00042!RAH\u0013\r\t\tJ\u0012\u0002\u0004\u0003:L\u0018aC2p]\u001aLwm]0%KF$2\u0001RAL\u0011!YE#!AA\u0002\u0005e\u0005\u0007BAN\u0003?\u0003ba\\A=]\u0006u\u0005\u0003BA?\u0003?#A\"!!\u0002\u0018\u0006\u0005\t\u0011!B\u0001\u0003\u000b\u000baa\u00197pg\u0016$WCAAS!\r)\u0015qU\u0005\u0004\u0003S3%a\u0002\"p_2,\u0017M\\\u0001\u000bG2|7/\u001a3`I\u0015\fHc\u0001#\u00020\"A1jFA\u0001\u0002\u0004\t)+A\u0004dY>\u001cX\r\u001a\u0011\u0002\u0013\r|gNZ5hkJ,Gc\u0001#\u00028\"9\u0011\u0011O\rA\u0002\u0005e\u0006\u0007BA^\u0003\u007f\u0003Ra\u001a7o\u0003{\u0003B!! \u0002@\u0012a\u0011\u0011YA\\\u0003\u0003\u0005\tQ!\u0001\u0002\u0006\n\u0019q\f\n\u001a\u0002\u0011Y\fG.\u001b3bi\u0016$2\u0001RAd\u0011\u001d\tIM\u0007a\u0001\u0003\u0017\fqB]3rk\u0016\u001cH/T3uC\u0012\fG/\u0019\t\u0005\u0003\u001b\f\u0019N\u0004\u0003\u0002`\u0005=\u0017\u0002BAi\u0003C\n\u0011#\u00117uKJ\u001cuN\u001c4jOB{G.[2z\u0013\u0011\t).a6\u0003\u001fI+\u0017/^3ti6+G/\u00193bi\u0006TA!!5\u0002b\u0005)1\r\\8tK\u0002")
public class AdminClientWithPoliciesIntegrationTest
extends KafkaServerTestHarness {
    private Admin client = null;
    private final int brokerCount;

    public Admin client() {
        return this.client;
    }

    public void client_$eq(Admin x$1) {
        this.client = x$1;
    }

    public int brokerCount() {
        return this.brokerCount;
    }

    @Override
    @BeforeEach
    public void setUp() {
        super.setUp();
        TestUtils$.MODULE$.waitUntilBrokerMetadataIsPropagated((Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.waitUntilBrokerMetadataIsPropagated$default$2());
    }

    @Override
    @AfterEach
    public void tearDown() {
        if (this.client() != null) {
            Utils.closeQuietly((AutoCloseable)this.client(), (String)"AdminClient");
        }
        super.tearDown();
    }

    public java.util.Map<String, Object> createConfig() {
        return (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bootstrap.servers"), (Object)this.brokerList())}))).asJava();
    }

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        Seq<Properties> configs = TestUtils$.MODULE$.createBrokerConfigs(this.brokerCount(), this.zkConnect(), TestUtils$.MODULE$.createBrokerConfigs$default$3(), TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13(), TestUtils$.MODULE$.createBrokerConfigs$default$14(), TestUtils$.MODULE$.createBrokerConfigs$default$15(), TestUtils$.MODULE$.createBrokerConfigs$default$16());
        configs.foreach((Function1 & Serializable & scala.Serializable)props -> props.put(KafkaConfig$.MODULE$.AlterConfigPolicyClassNameProp(), Policy.class));
        return (Seq)configs.map((Function1 & Serializable & scala.Serializable)props -> KafkaConfig$.MODULE$.fromProps(props), Seq$.MODULE$.canBuildFrom());
    }

    @Test
    public void testValidAlterConfigs() {
        this.client_$eq(Admin.create(this.createConfig()));
        String topic1 = "describe-alter-configs-topic-1";
        ConfigResource topicResource1 = new ConfigResource(ConfigResource.Type.TOPIC, topic1);
        Properties topicConfig1 = new Properties();
        topicConfig1.setProperty(LogConfig$.MODULE$.MaxMessageBytesProp(), "500000");
        topicConfig1.setProperty(LogConfig$.MODULE$.RetentionMsProp(), "60000000");
        this.createTopic(topic1, 1, 1, topicConfig1);
        String topic2 = "describe-alter-configs-topic-2";
        ConfigResource topicResource2 = new ConfigResource(ConfigResource.Type.TOPIC, topic2);
        this.createTopic(topic2, 1, 1, this.createTopic$default$4());
        PlaintextAdminIntegrationTest$.MODULE$.checkValidAlterConfigs(this.client(), topicResource1, topicResource2);
    }

    @Test
    public void testInvalidAlterConfigs() {
        this.client_$eq(Admin.create(this.createConfig()));
        PlaintextAdminIntegrationTest$.MODULE$.checkInvalidAlterConfigs(this.zkClient(), (Seq<KafkaServer>)this.servers(), this.client());
    }

    @Test
    public void testInvalidAlterConfigsDueToPolicy() {
        this.client_$eq(Admin.create(this.createConfig()));
        String topic1 = "invalid-alter-configs-due-to-policy-topic-1";
        ConfigResource topicResource1 = new ConfigResource(ConfigResource.Type.TOPIC, topic1);
        this.createTopic(topic1, 1, 1, this.createTopic$default$4());
        String topic2 = "invalid-alter-configs-due-to-policy-topic-2";
        ConfigResource topicResource2 = new ConfigResource(ConfigResource.Type.TOPIC, topic2);
        this.createTopic(topic2, 1, 1, this.createTopic$default$4());
        String topic3 = "invalid-alter-configs-due-to-policy-topic-3";
        ConfigResource topicResource3 = new ConfigResource(ConfigResource.Type.TOPIC, topic3);
        this.createTopic(topic3, 1, 1, this.createTopic$default$4());
        java.util.List topicConfigEntries1 = (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)new ConfigEntry(LogConfig$.MODULE$.MinCleanableDirtyRatioProp(), "0.9"), (List)new .colon.colon((Object)new ConfigEntry(LogConfig$.MODULE$.MinInSyncReplicasProp(), "2"), (List)Nil$.MODULE$))).asJava();
        java.util.List topicConfigEntries2 = (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)new ConfigEntry(LogConfig$.MODULE$.MinCleanableDirtyRatioProp(), "0.8"), (List)Nil$.MODULE$)).asJava();
        java.util.List topicConfigEntries3 = (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)new ConfigEntry(LogConfig$.MODULE$.MinInSyncReplicasProp(), "-1"), (List)Nil$.MODULE$)).asJava();
        ConfigResource brokerResource = new ConfigResource(ConfigResource.Type.BROKER, Integer.toString(((KafkaServer)this.servers().head()).config().brokerId()));
        java.util.List brokerConfigEntries = (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)new ConfigEntry(KafkaConfig$.MODULE$.SslTruststorePasswordProp(), "12313"), (List)Nil$.MODULE$)).asJava();
        ObjectRef alterResult = ObjectRef.create((Object)this.client().alterConfigs((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicResource1), (Object)new Config((Collection)topicConfigEntries1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicResource2), (Object)new Config((Collection)topicConfigEntries2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicResource3), (Object)new Config((Collection)topicConfigEntries3)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)brokerResource), (Object)new Config((Collection)brokerConfigEntries))}))).asJava()));
        Assertions.assertEquals((Object)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ConfigResource[]{topicResource1, topicResource2, topicResource3, brokerResource}))).asJava(), ((AlterConfigsResult)alterResult.elem).values().keySet());
        Assertions.assertTrue((boolean)(Assertions.assertThrows(ExecutionException.class, () -> ((KafkaFuture)((AlterConfigsResult)alterResult$1.elem).values().get(topicResource1)).get()).getCause() instanceof PolicyViolationException));
        ((KafkaFuture)((AlterConfigsResult)alterResult.elem).values().get(topicResource2)).get();
        Assertions.assertTrue((boolean)(Assertions.assertThrows(ExecutionException.class, () -> ((KafkaFuture)((AlterConfigsResult)alterResult$1.elem).values().get(topicResource3)).get()).getCause() instanceof InvalidRequestException));
        Assertions.assertTrue((boolean)(Assertions.assertThrows(ExecutionException.class, () -> ((KafkaFuture)((AlterConfigsResult)alterResult$1.elem).values().get(brokerResource)).get()).getCause() instanceof InvalidRequestException));
        java.util.Map configs = (java.util.Map)this.client().describeConfigs((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)topicResource1, (List)new .colon.colon((Object)topicResource2, (List)new .colon.colon((Object)topicResource3, (List)new .colon.colon((Object)brokerResource, (List)Nil$.MODULE$))))).asJava()).all().get();
        Assertions.assertEquals((int)4, (int)configs.size());
        Assertions.assertEquals((Object)Double.toString(Defaults$.MODULE$.LogCleanerMinCleanRatio()), (Object)((Config)configs.get(topicResource1)).get(LogConfig$.MODULE$.MinCleanableDirtyRatioProp()).value());
        Assertions.assertEquals((Object)Integer.toString(Defaults$.MODULE$.MinInSyncReplicas()), (Object)((Config)configs.get(topicResource1)).get(LogConfig$.MODULE$.MinInSyncReplicasProp()).value());
        Assertions.assertEquals((Object)"0.8", (Object)((Config)configs.get(topicResource2)).get(LogConfig$.MODULE$.MinCleanableDirtyRatioProp()).value());
        Assertions.assertNull((Object)((Config)configs.get(brokerResource)).get(KafkaConfig$.MODULE$.SslTruststorePasswordProp()).value());
        topicConfigEntries2 = (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)new ConfigEntry(LogConfig$.MODULE$.MinCleanableDirtyRatioProp(), "0.7"), (List)Nil$.MODULE$)).asJava();
        alterResult.elem = this.client().alterConfigs((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicResource1), (Object)new Config((Collection)topicConfigEntries1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicResource2), (Object)new Config((Collection)topicConfigEntries2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)brokerResource), (Object)new Config((Collection)brokerConfigEntries)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicResource3), (Object)new Config((Collection)topicConfigEntries3))}))).asJava(), new AlterConfigsOptions().validateOnly(true));
        Assertions.assertEquals((Object)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ConfigResource[]{topicResource1, topicResource2, topicResource3, brokerResource}))).asJava(), ((AlterConfigsResult)alterResult.elem).values().keySet());
        Assertions.assertTrue((boolean)(Assertions.assertThrows(ExecutionException.class, () -> ((KafkaFuture)((AlterConfigsResult)alterResult$1.elem).values().get(topicResource1)).get()).getCause() instanceof PolicyViolationException));
        ((KafkaFuture)((AlterConfigsResult)alterResult.elem).values().get(topicResource2)).get();
        Assertions.assertTrue((boolean)(Assertions.assertThrows(ExecutionException.class, () -> ((KafkaFuture)((AlterConfigsResult)alterResult$1.elem).values().get(topicResource3)).get()).getCause() instanceof InvalidRequestException));
        Assertions.assertTrue((boolean)(Assertions.assertThrows(ExecutionException.class, () -> ((KafkaFuture)((AlterConfigsResult)alterResult$1.elem).values().get(brokerResource)).get()).getCause() instanceof InvalidRequestException));
        configs = (java.util.Map)this.client().describeConfigs((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)topicResource1, (List)new .colon.colon((Object)topicResource2, (List)new .colon.colon((Object)topicResource3, (List)new .colon.colon((Object)brokerResource, (List)Nil$.MODULE$))))).asJava()).all().get();
        Assertions.assertEquals((int)4, (int)configs.size());
        Assertions.assertEquals((Object)Double.toString(Defaults$.MODULE$.LogCleanerMinCleanRatio()), (Object)((Config)configs.get(topicResource1)).get(LogConfig$.MODULE$.MinCleanableDirtyRatioProp()).value());
        Assertions.assertEquals((Object)Integer.toString(Defaults$.MODULE$.MinInSyncReplicas()), (Object)((Config)configs.get(topicResource1)).get(LogConfig$.MODULE$.MinInSyncReplicasProp()).value());
        Assertions.assertEquals((Object)"0.8", (Object)((Config)configs.get(topicResource2)).get(LogConfig$.MODULE$.MinCleanableDirtyRatioProp()).value());
        Assertions.assertNull((Object)((Config)configs.get(brokerResource)).get(KafkaConfig$.MODULE$.SslTruststorePasswordProp()).value());
    }

    public AdminClientWithPoliciesIntegrationTest() {
        this.brokerCount = 3;
    }

    public static class Policy
    implements AlterConfigPolicy {
        private scala.collection.immutable.Map<String, ?> configs;
        private boolean closed = false;

        public scala.collection.immutable.Map<String, ?> configs() {
            return this.configs;
        }

        public void configs_$eq(scala.collection.immutable.Map<String, ?> x$1) {
            this.configs = x$1;
        }

        public boolean closed() {
            return this.closed;
        }

        public void closed_$eq(boolean x$1) {
            this.closed = x$1;
        }

        public void configure(java.util.Map<String, ?> configs) {
            this.configs_$eq(((TraversableOnce)CollectionConverters$.MODULE$.mapAsScalaMapConverter(configs).asScala()).toMap(Predef$.MODULE$.$conforms()));
        }

        public void validate(AlterConfigPolicy.RequestMetadata requestMetadata) {
            Predef$.MODULE$.require(!this.closed(), (Function0 & Serializable & scala.Serializable)() -> "Policy should not be closed");
            Predef$.MODULE$.require(!this.configs().isEmpty(), (Function0 & Serializable & scala.Serializable)() -> "configure should have been called with non empty configs");
            Predef$.MODULE$.require(!requestMetadata.configs().isEmpty(), (Function0 & Serializable & scala.Serializable)() -> "request configs should not be empty");
            Predef$.MODULE$.require(new StringOps(Predef$.MODULE$.augmentString(requestMetadata.resource().name())).nonEmpty(), (Function0 & Serializable & scala.Serializable)() -> "resource name should not be empty");
            Predef$.MODULE$.require(requestMetadata.resource().name().contains("topic"));
            if (requestMetadata.configs().containsKey("min.insync.replicas")) {
                throw new PolicyViolationException("Min in sync replicas cannot be updated");
            }
        }

        public void close() {
            this.closed_$eq(true);
        }
    }
}

