/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.time.Duration;
import java.util.Collections;
import java.util.Properties;
import kafka.api.IntegrationTestHarness;
import kafka.api.QuotaTestClients;
import kafka.api.QuotaTestClients$;
import kafka.server.ClientQuotaManagerConfig$;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.server.QuotaType;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.Metric;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Option;
import scala.Some;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005Eb!\u0002\u0010 \u0003\u0003!\u0003\"B\u0015\u0001\t\u0003Q\u0003b\u0002\u0017\u0001\u0005\u0004%\t%\f\u0005\u0007i\u0001\u0001\u000b\u0011\u0002\u0018\t\u000bU\u0002A\u0011\u0003\u001c\t\u000b}\u0002A\u0011\u0003\u001c\t\u000b\u0001\u0003a\u0011C!\t\u000fe\u0003!\u0019!C\u00015\"1a\f\u0001Q\u0001\nmCqa\u0018\u0001C\u0002\u0013\u0005!\f\u0003\u0004a\u0001\u0001\u0006Ia\u0017\u0005\bC\u0002\u0011\r\u0011\"\u0001c\u0011\u00191\u0007\u0001)A\u0005G\"9q\r\u0001b\u0001\n\u00031\u0004B\u00025\u0001A\u0003%q\u0007C\u0005S\u0001\u0001\u0007\t\u0019!C\u0001S\"I!\u000e\u0001a\u0001\u0002\u0004%\ta\u001b\u0005\nc\u0002\u0001\r\u0011!Q!\nMC\u0011B\u001d\u0001A\u0002\u0003\u0007I\u0011A5\t\u0013M\u0004\u0001\u0019!a\u0001\n\u0003!\b\"\u0003<\u0001\u0001\u0004\u0005\t\u0015)\u0003T\u0011%9\b\u00011AA\u0002\u0013\u0005\u0001\u0010C\u0005z\u0001\u0001\u0007\t\u0019!C\u0001u\"IA\u0010\u0001a\u0001\u0002\u0003\u0006KA\u0011\u0005\u0006{\u0002!\tE \u0005\u0007\u0003/\u0001A\u0011\u0001@\t\r\u0005\u0005\u0002\u0001\"\u0001\u007f\u0011\u0019\t)\u0003\u0001C\u0001}\"1\u0011\u0011\u0006\u0001\u0005\u0002yDa!!\f\u0001\t\u0003q(!\u0004\"bg\u0016\fVo\u001c;b)\u0016\u001cHO\u0003\u0002!C\u0005\u0019\u0011\r]5\u000b\u0003\t\nQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001KA\u0011aeJ\u0007\u0002?%\u0011\u0001f\b\u0002\u0017\u0013:$Xm\u001a:bi&|g\u000eV3ti\"\u000b'O\\3tg\u00061A(\u001b8jiz\"\u0012a\u000b\t\u0003M\u0001\t1B\u0019:pW\u0016\u00148i\\;oiV\ta\u0006\u0005\u00020e5\t\u0001GC\u00012\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0004GA\u0002J]R\fAB\u0019:pW\u0016\u00148i\\;oi\u0002\n\u0001\u0003\u001d:pIV\u001cWM]\"mS\u0016tG/\u00133\u0016\u0003]\u0002\"\u0001O\u001f\u000e\u0003eR!AO\u001e\u0002\t1\fgn\u001a\u0006\u0002y\u0005!!.\u0019<b\u0013\tq\u0014H\u0001\u0004TiJLgnZ\u0001\u0011G>t7/^7fe\u000ec\u0017.\u001a8u\u0013\u0012\fac\u0019:fCR,\u0017+^8uCR+7\u000f^\"mS\u0016tGo\u001d\u000b\u0004\u0005\u0016\u000b\u0006C\u0001\u0014D\u0013\t!uD\u0001\tRk>$\u0018\rV3ti\u000ec\u0017.\u001a8ug\")aI\u0002a\u0001\u000f\u0006)Ao\u001c9jGB\u0011\u0001j\u0014\b\u0003\u00136\u0003\"A\u0013\u0019\u000e\u0003-S!\u0001T\u0012\u0002\rq\u0012xn\u001c;?\u0013\tq\u0005'\u0001\u0004Qe\u0016$WMZ\u0005\u0003}AS!A\u0014\u0019\t\u000bI3\u0001\u0019A*\u0002\u00151,\u0017\rZ3s\u001d>$W\r\u0005\u0002U/6\tQK\u0003\u0002WC\u000511/\u001a:wKJL!\u0001W+\u0003\u0017-\u000bgm[1TKJ4XM]\u0001\u0015I\u00164\u0017-\u001e7u!J|G-^2feF+x\u000e^1\u0016\u0003m\u0003\"a\f/\n\u0005u\u0003$\u0001\u0002'p]\u001e\fQ\u0003Z3gCVdG\u000f\u0015:pIV\u001cWM])v_R\f\u0007%\u0001\u000beK\u001a\fW\u000f\u001c;D_:\u001cX/\\3s#V|G/Y\u0001\u0016I\u00164\u0017-\u001e7u\u0007>t7/^7feF+x\u000e^1!\u0003M!WMZ1vYR\u0014V-];fgR\fVo\u001c;b+\u0005\u0019\u0007CA\u0018e\u0013\t)\u0007G\u0001\u0004E_V\u0014G.Z\u0001\u0015I\u00164\u0017-\u001e7u%\u0016\fX/Z:u#V|G/\u0019\u0011\u0002\rQ|\u0007/[22\u0003\u001d!x\u000e]5dc\u0001*\u0012aU\u0001\u000fY\u0016\fG-\u001a:O_\u0012,w\fJ3r)\taw\u000e\u0005\u00020[&\u0011a\u000e\r\u0002\u0005+:LG\u000fC\u0004q!\u0005\u0005\t\u0019A*\u0002\u0007a$\u0013'A\u0006mK\u0006$WM\u001d(pI\u0016\u0004\u0013\u0001\u00044pY2|w/\u001a:O_\u0012,\u0017\u0001\u00054pY2|w/\u001a:O_\u0012,w\fJ3r)\taW\u000fC\u0004q'\u0005\u0005\t\u0019A*\u0002\u001b\u0019|G\u000e\\8xKJtu\u000eZ3!\u0003A\tXo\u001c;b)\u0016\u001cHo\u00117jK:$8/F\u0001C\u0003Q\tXo\u001c;b)\u0016\u001cHo\u00117jK:$8o\u0018\u0013fcR\u0011An\u001f\u0005\baZ\t\t\u00111\u0001C\u0003E\tXo\u001c;b)\u0016\u001cHo\u00117jK:$8\u000fI\u0001\u0006g\u0016$X\u000b\u001d\u000b\u0002Y\"\u001a\u0001$!\u0001\u0011\t\u0005\r\u00111C\u0007\u0003\u0003\u000bQ1\u0001IA\u0004\u0015\u0011\tI!a\u0003\u0002\u000f),\b/\u001b;fe*!\u0011QBA\b\u0003\u0015QWO\\5u\u0015\t\t\t\"A\u0002pe\u001eLA!!\u0006\u0002\u0006\tQ!)\u001a4pe\u0016,\u0015m\u00195\u0002;Q,7\u000f\u001e+ie>$H\u000f\\3e!J|G-^2fe\u000e{gn];nKJD3!GA\u000e!\u0011\t\u0019!!\b\n\t\u0005}\u0011Q\u0001\u0002\u0005)\u0016\u001cH/A\u0014uKN$\bK]8ek\u000e,'oQ8ogVlWM](wKJ\u0014\u0018\u000eZ3V]RD'o\u001c;uY\u0016$\u0007f\u0001\u000e\u0002\u001c\u00051C/Z:u!J|G-^2fe\u000e{gn];nKJ|e/\u001a:sS\u0012,Gj\\<feF+x\u000e^1)\u0007m\tY\"A\fuKN$\u0018+^8uC>3XM\u001d:jI\u0016$U\r\\3uK\"\u001aA$a\u0007\u0002)Q,7\u000f\u001e+ie>$H\u000f\\3e%\u0016\fX/Z:uQ\ri\u00121\u0004")
public abstract class BaseQuotaTest
extends IntegrationTestHarness {
    private final int brokerCount;
    private final long defaultProducerQuota;
    private final long defaultConsumerQuota;
    private final double defaultRequestQuota;
    private final String topic1;
    private KafkaServer leaderNode;
    private KafkaServer followerNode;
    private QuotaTestClients quotaTestClients;

    @Override
    public int brokerCount() {
        return this.brokerCount;
    }

    public String producerClientId() {
        return "QuotasTestProducer-1";
    }

    public String consumerClientId() {
        return "QuotasTestConsumer-1";
    }

    public abstract QuotaTestClients createQuotaTestClients(String var1, KafkaServer var2);

    public long defaultProducerQuota() {
        return this.defaultProducerQuota;
    }

    public long defaultConsumerQuota() {
        return this.defaultConsumerQuota;
    }

    public double defaultRequestQuota() {
        return this.defaultRequestQuota;
    }

    public String topic1() {
        return this.topic1;
    }

    public KafkaServer leaderNode() {
        return this.leaderNode;
    }

    public void leaderNode_$eq(KafkaServer x$1) {
        this.leaderNode = x$1;
    }

    public KafkaServer followerNode() {
        return this.followerNode;
    }

    public void followerNode_$eq(KafkaServer x$1) {
        this.followerNode = x$1;
    }

    public QuotaTestClients quotaTestClients() {
        return this.quotaTestClients;
    }

    public void quotaTestClients_$eq(QuotaTestClients x$1) {
        this.quotaTestClients = x$1;
    }

    @Override
    @BeforeEach
    public void setUp() {
        super.setUp();
        int numPartitions = 1;
        Map<Object, Object> leaders = this.createTopic(this.topic1(), numPartitions, this.brokerCount(), this.createTopic$default$4());
        this.leaderNode_$eq(BoxesRunTime.unboxToInt((Object)leaders.apply((Object)BoxesRunTime.boxToInteger((int)0))) == ((KafkaServer)this.servers().head()).config().brokerId() ? (KafkaServer)this.servers().head() : (KafkaServer)this.servers().apply(1));
        this.followerNode_$eq(BoxesRunTime.unboxToInt((Object)leaders.apply((Object)BoxesRunTime.boxToInteger((int)0))) != ((KafkaServer)this.servers().head()).config().brokerId() ? (KafkaServer)this.servers().head() : (KafkaServer)this.servers().apply(1));
        this.quotaTestClients_$eq(this.createQuotaTestClients(this.topic1(), this.leaderNode()));
    }

    @Test
    public void testThrottledProducerConsumer() {
        int numRecords = 1000;
        QuotaTestClients qual$1 = this.quotaTestClients();
        boolean x$2 = qual$1.produceUntilThrottled$default$2();
        int produced = qual$1.produceUntilThrottled(numRecords, x$2);
        QuotaTestClients qual$2 = this.quotaTestClients();
        boolean x$3 = true;
        boolean x$4 = qual$2.verifyProduceThrottle$default$2();
        boolean x$5 = qual$2.verifyProduceThrottle$default$3();
        qual$2.verifyProduceThrottle(x$3, x$4, x$5);
        QuotaTestClients qual$3 = this.quotaTestClients();
        boolean x$7 = qual$3.consumeUntilThrottled$default$2();
        Assertions.assertTrue((qual$3.consumeUntilThrottled(produced, x$7) > 0 ? 1 : 0) != 0, (String)"Should have consumed at least one record");
        QuotaTestClients qual$4 = this.quotaTestClients();
        boolean x$8 = true;
        boolean x$9 = qual$4.verifyConsumeThrottle$default$2();
        boolean x$10 = qual$4.verifyConsumeThrottle$default$3();
        qual$4.verifyConsumeThrottle(x$8, x$9, x$10);
    }

    @Test
    public void testProducerConsumerOverrideUnthrottled() {
        Properties props = new Properties();
        props.put("producer_byte_rate", Long.toString(Long.MAX_VALUE));
        props.put("consumer_byte_rate", Long.toString(Long.MAX_VALUE));
        this.quotaTestClients().overrideQuotas(Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE);
        QuotaTestClients qual$1 = this.quotaTestClients();
        long x$1 = Long.MAX_VALUE;
        long x$2 = Long.MAX_VALUE;
        double x$3 = Long.MAX_VALUE;
        KafkaServer x$4 = qual$1.waitForQuotaUpdate$default$4();
        qual$1.waitForQuotaUpdate(x$1, x$2, x$3, x$4);
        int numRecords = 1000;
        QuotaTestClients qual$2 = this.quotaTestClients();
        boolean x$6 = qual$2.produceUntilThrottled$default$2();
        Assertions.assertEquals((int)numRecords, (int)qual$2.produceUntilThrottled(numRecords, x$6));
        QuotaTestClients qual$3 = this.quotaTestClients();
        boolean x$7 = false;
        boolean x$8 = qual$3.verifyProduceThrottle$default$2();
        boolean x$9 = qual$3.verifyProduceThrottle$default$3();
        qual$3.verifyProduceThrottle(x$7, x$8, x$9);
        QuotaTestClients qual$4 = this.quotaTestClients();
        boolean x$11 = qual$4.consumeUntilThrottled$default$2();
        Assertions.assertEquals((int)numRecords, (int)qual$4.consumeUntilThrottled(numRecords, x$11));
        QuotaTestClients qual$5 = this.quotaTestClients();
        boolean x$12 = false;
        boolean x$13 = qual$5.verifyConsumeThrottle$default$2();
        boolean x$14 = qual$5.verifyConsumeThrottle$default$3();
        qual$5.verifyConsumeThrottle(x$12, x$13, x$14);
    }

    @Test
    public void testProducerConsumerOverrideLowerQuota() {
        this.quotaTestClients().overrideQuotas(2000L, 250L, Long.MAX_VALUE);
        QuotaTestClients qual$1 = this.quotaTestClients();
        long x$1 = 2000L;
        long x$2 = 250L;
        double x$3 = Long.MAX_VALUE;
        KafkaServer x$4 = qual$1.waitForQuotaUpdate$default$4();
        qual$1.waitForQuotaUpdate(x$1, x$2, x$3, x$4);
        int numRecords = 1000;
        QuotaTestClients qual$2 = this.quotaTestClients();
        boolean x$6 = qual$2.produceUntilThrottled$default$2();
        int produced = qual$2.produceUntilThrottled(numRecords, x$6);
        QuotaTestClients qual$3 = this.quotaTestClients();
        boolean x$7 = true;
        boolean x$8 = qual$3.verifyProduceThrottle$default$2();
        boolean x$9 = qual$3.verifyProduceThrottle$default$3();
        qual$3.verifyProduceThrottle(x$7, x$8, x$9);
        QuotaTestClients qual$4 = this.quotaTestClients();
        boolean x$11 = qual$4.consumeUntilThrottled$default$2();
        Assertions.assertTrue((qual$4.consumeUntilThrottled(produced, x$11) > 0 ? 1 : 0) != 0, (String)"Should have consumed at least one record");
        QuotaTestClients qual$5 = this.quotaTestClients();
        boolean x$12 = true;
        boolean x$13 = qual$5.verifyConsumeThrottle$default$2();
        boolean x$14 = qual$5.verifyConsumeThrottle$default$3();
        qual$5.verifyConsumeThrottle(x$12, x$13, x$14);
    }

    @Test
    public void testQuotaOverrideDelete() {
        this.quotaTestClients().overrideQuotas(Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE);
        QuotaTestClients qual$1 = this.quotaTestClients();
        long x$1 = Long.MAX_VALUE;
        long x$2 = Long.MAX_VALUE;
        double x$3 = Long.MAX_VALUE;
        KafkaServer x$4 = qual$1.waitForQuotaUpdate$default$4();
        qual$1.waitForQuotaUpdate(x$1, x$2, x$3, x$4);
        int numRecords = 1000;
        QuotaTestClients qual$2 = this.quotaTestClients();
        boolean x$6 = qual$2.produceUntilThrottled$default$2();
        Assertions.assertEquals((int)numRecords, (int)qual$2.produceUntilThrottled(numRecords, x$6));
        QuotaTestClients qual$3 = this.quotaTestClients();
        boolean x$7 = false;
        boolean x$8 = qual$3.verifyProduceThrottle$default$2();
        boolean x$9 = qual$3.verifyProduceThrottle$default$3();
        qual$3.verifyProduceThrottle(x$7, x$8, x$9);
        QuotaTestClients qual$4 = this.quotaTestClients();
        boolean x$11 = qual$4.consumeUntilThrottled$default$2();
        Assertions.assertEquals((int)numRecords, (int)qual$4.consumeUntilThrottled(numRecords, x$11));
        QuotaTestClients qual$5 = this.quotaTestClients();
        boolean x$12 = false;
        boolean x$13 = qual$5.verifyConsumeThrottle$default$2();
        boolean x$14 = qual$5.verifyConsumeThrottle$default$3();
        qual$5.verifyConsumeThrottle(x$12, x$13, x$14);
        this.quotaTestClients().removeQuotaOverrides();
        QuotaTestClients qual$6 = this.quotaTestClients();
        long x$15 = this.defaultProducerQuota();
        long x$16 = this.defaultConsumerQuota();
        double x$17 = this.defaultRequestQuota();
        KafkaServer x$18 = qual$6.waitForQuotaUpdate$default$4();
        qual$6.waitForQuotaUpdate(x$15, x$16, x$17, x$18);
        QuotaTestClients qual$7 = this.quotaTestClients();
        boolean x$20 = qual$7.produceUntilThrottled$default$2();
        int produced = qual$7.produceUntilThrottled(numRecords, x$20);
        QuotaTestClients qual$8 = this.quotaTestClients();
        boolean x$21 = true;
        boolean x$22 = qual$8.verifyProduceThrottle$default$2();
        boolean x$23 = qual$8.verifyProduceThrottle$default$3();
        qual$8.verifyProduceThrottle(x$21, x$22, x$23);
        this.quotaTestClients().consumer().seekToBeginning(Collections.singleton(new TopicPartition(this.topic1(), 0)));
        QuotaTestClients qual$9 = this.quotaTestClients();
        int x$24 = numRecords + produced;
        boolean x$25 = qual$9.consumeUntilThrottled$default$2();
        qual$9.consumeUntilThrottled(x$24, x$25);
        QuotaTestClients qual$10 = this.quotaTestClients();
        boolean x$26 = true;
        boolean x$27 = qual$10.verifyConsumeThrottle$default$2();
        boolean x$28 = qual$10.verifyConsumeThrottle$default$3();
        qual$10.verifyConsumeThrottle(x$26, x$27, x$28);
    }

    @Test
    public void testThrottledRequest() {
        this.quotaTestClients().overrideQuotas(Long.MAX_VALUE, Long.MAX_VALUE, 0.1);
        QuotaTestClients qual$1 = this.quotaTestClients();
        long x$1 = Long.MAX_VALUE;
        long x$2 = Long.MAX_VALUE;
        double x$3 = 0.1;
        KafkaServer x$4 = qual$1.waitForQuotaUpdate$default$4();
        qual$1.waitForQuotaUpdate(x$1, x$2, x$3, x$4);
        KafkaConsumer<byte[], byte[]> consumer = this.quotaTestClients().consumer();
        consumer.subscribe(Collections.singleton(this.topic1()));
        long endTimeMs = System.currentTimeMillis() + 10000L;
        boolean throttled = false;
        while (!(throttled && this.quotaTestClients().exemptRequestMetric() != null || System.currentTimeMillis() >= endTimeMs)) {
            consumer.poll(Duration.ofMillis(100L));
            KafkaMetric throttleMetric = this.quotaTestClients().throttleMetric((QuotaType)QuotaType.Request$.MODULE$, this.consumerClientId());
            throttled = throttleMetric != null && QuotaTestClients$.MODULE$.metricValue((Metric)throttleMetric) > 0.0;
        }
        Assertions.assertTrue((boolean)throttled, (String)"Should have been throttled");
        this.quotaTestClients().verifyConsumerClientThrottleTimeMetric(true, (Option<Object>)new Some((Object)BoxesRunTime.boxToDouble((double)((double)ClientQuotaManagerConfig$.MODULE$.DefaultQuotaWindowSizeSeconds() * 1000.0))));
        KafkaMetric exemptMetric = this.quotaTestClients().exemptRequestMetric();
        Assertions.assertNotNull((Object)exemptMetric, (String)"Exempt requests not recorded");
        Assertions.assertTrue((QuotaTestClients$.MODULE$.metricValue((Metric)exemptMetric) > 0.0 ? 1 : 0) != 0, (String)"Exempt requests not recorded");
    }

    public BaseQuotaTest() {
        this.brokerCount = 2;
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.ControlledShutdownEnableProp(), "false");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.OffsetsTopicReplicationFactorProp(), "2");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.OffsetsTopicPartitionsProp(), "1");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.GroupMinSessionTimeoutMsProp(), "100");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.GroupMaxSessionTimeoutMsProp(), "30000");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.GroupInitialRebalanceDelayMsProp(), "0");
        this.producerConfig().setProperty("acks", "-1");
        this.producerConfig().setProperty("buffer.memory", "300000");
        this.producerConfig().setProperty("client.id", this.producerClientId());
        this.consumerConfig().setProperty("group.id", "QuotasTest");
        this.consumerConfig().setProperty("max.partition.fetch.bytes", Integer.toString(4096));
        this.consumerConfig().setProperty("auto.offset.reset", "earliest");
        this.consumerConfig().setProperty("client.id", this.consumerClientId());
        this.consumerConfig().setProperty("fetch.min.bytes", "0");
        this.consumerConfig().setProperty("fetch.max.wait.ms", "0");
        this.defaultProducerQuota = 8000L;
        this.defaultConsumerQuota = 2500L;
        this.defaultRequestQuota = Long.MAX_VALUE;
        this.topic1 = "topic-1";
    }
}

