/*
 * Decompiled with CFR 0.152.
 */
package kafka.cluster;

import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.io.Serializable;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.api.ApiVersion;
import kafka.api.ApiVersion$;
import kafka.cluster.DelayedOperations;
import kafka.cluster.IsrChangeListener;
import kafka.cluster.Partition;
import kafka.log.AppendOrigin;
import kafka.log.CleanerConfig;
import kafka.log.CleanerConfig$;
import kafka.log.Log;
import kafka.log.Log$;
import kafka.log.LogAppendInfo;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogManager;
import kafka.server.AlterIsrItem;
import kafka.server.AlterIsrManager;
import kafka.server.BrokerTopicStats;
import kafka.server.Defaults$;
import kafka.server.LogDirFailureChannel;
import kafka.server.LogOffsetMetadata;
import kafka.server.LogOffsetMetadata$;
import kafka.server.MetadataCache;
import kafka.server.checkpoints.OffsetCheckpoints;
import kafka.server.metadata.CachedConfigRepository;
import kafka.server.metadata.ConfigRepository;
import kafka.utils.Logging;
import kafka.utils.MockTime;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.LeaderAndIsrRequestData;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MutableRecordBatch;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Predef$;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.concurrent.duration.Deadline;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\t\u001df\u0001B\u001a5\u0001eBQA\u0012\u0001\u0005\u0002\u001dCqA\u0013\u0001C\u0002\u0013\u00051\n\u0003\u0004P\u0001\u0001\u0006I\u0001\u0014\u0005\b!\u0002\u0011\r\u0011\"\u0001L\u0011\u0019\t\u0006\u0001)A\u0005\u0019\"9!\u000b\u0001b\u0001\n\u0003Y\u0005BB*\u0001A\u0003%A\nC\u0004U\u0001\t\u0007I\u0011A+\t\re\u0003\u0001\u0015!\u0003W\u0011\u001dQ\u0006A1A\u0005\u0002mCa\u0001\u001a\u0001!\u0002\u0013a\u0006bB3\u0001\u0005\u0004%\ta\u0017\u0005\u0007M\u0002\u0001\u000b\u0011\u0002/\t\u000f\u001d\u0004!\u0019!C\u0001Q\"1\u0011\u000f\u0001Q\u0001\n%DqA\u001d\u0001C\u0002\u0013\u00051\u000f\u0003\u0004x\u0001\u0001\u0006I\u0001\u001e\u0005\bq\u0002\u0011\r\u0011\"\u0001t\u0011\u0019I\b\u0001)A\u0005i\"9!\u0010\u0001b\u0001\n\u0003Y\bbBA\u0015\u0001\u0001\u0006I\u0001 \u0005\f\u0003W\u0001\u0001\u0019!a\u0001\n\u0003\ti\u0003C\u0006\u0002<\u0001\u0001\r\u00111A\u0005\u0002\u0005u\u0002bCA%\u0001\u0001\u0007\t\u0011)Q\u0005\u0003_A1\"a\u0013\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0002N!Y\u0011Q\u000b\u0001A\u0002\u0003\u0007I\u0011AA,\u0011-\tY\u0006\u0001a\u0001\u0002\u0003\u0006K!a\u0014\t\u0013\u0005u\u0003A1A\u0005\n\u0005}\u0003\u0002CA5\u0001\u0001\u0006I!!\u0019\t\u000f\u0005-\u0004\u0001\"\u0001\u0002n!9\u0011Q\u0011\u0001\u0005\u0002\u00055\u0004bBAH\u0001\u0011\u0005\u0011Q\u000e\u0005\b\u00033\u0003A\u0011AA7\u0011\u001d\ti\n\u0001C\u0001\u0003[Bq!!)\u0001\t\u0003\ti\u0007C\u0004\u0002&\u0002!I!!\u001c\t\u000f\u0005\u001d\u0006\u0001\"\u0003\u0002n!9\u0011\u0011\u0016\u0001\u0005\n\u0005-\u0006bBAr\u0001\u0011%\u0011Q\u001d\u0005\b\u0003o\u0004A\u0011BA}\u0011\u001d\u0011y\u0002\u0001C\u0005\u0005CAqA!\n\u0001\t\u0013\u00119\u0003C\u0004\u0003L\u0001!IA!\u0014\t\u000f\t]\u0003\u0001\"\u0003\u0003Z\u00191!q\r\u0001\u0005\u0005SB!\"!\u000e.\u0005\u0003\u0005\u000b\u0011\u0002B6\u0011!!VF!A!\u0002\u00131\u0006\u0002\u0003:.\u0005\u0003\u0005\u000b\u0011\u0002;\t\r\u0019kC\u0011\u0001B9\u0011\u001d\u0011i(\fC!\u0005\u007f\u0012\u0011\u0003U1si&$\u0018n\u001c8M_\u000e\\G+Z:u\u0015\t)d'A\u0004dYV\u001cH/\u001a:\u000b\u0003]\nQa[1gW\u0006\u001c\u0001aE\u0002\u0001u\u0001\u0003\"a\u000f \u000e\u0003qR\u0011!P\u0001\u0006g\u000e\fG.Y\u0005\u0003\u007fq\u0012a!\u00118z%\u00164\u0007CA!E\u001b\u0005\u0011%BA\"7\u0003\u0015)H/\u001b7t\u0013\t)%IA\u0004M_\u001e<\u0017N\\4\u0002\rqJg.\u001b;?)\u0005A\u0005CA%\u0001\u001b\u0005!\u0014A\u00058v[J+\u0007\u000f\\5dC\u001a+Go\u00195feN,\u0012\u0001\u0014\t\u0003w5K!A\u0014\u001f\u0003\u0007%sG/A\nok6\u0014V\r\u001d7jG\u00064U\r^2iKJ\u001c\b%\u0001\u0007ok6\u0004&o\u001c3vG\u0016\u00148/A\u0007ok6\u0004&o\u001c3vG\u0016\u00148\u000fI\u0001\u0016]Vl'+Z2pe\u0012\u001c\b+\u001a:Qe>$WoY3s\u0003YqW/\u001c*fG>\u0014Hm\u001d)feB\u0013x\u000eZ;dKJ\u0004\u0013\u0001C7pG.$\u0016.\\3\u0016\u0003Y\u0003\"!Q,\n\u0005a\u0013%\u0001C'pG.$\u0016.\\3\u0002\u00135|7m\u001b+j[\u0016\u0004\u0013A\u0002;na\u0012K'/F\u0001]!\ti&-D\u0001_\u0015\ty\u0006-\u0001\u0002j_*\t\u0011-\u0001\u0003kCZ\f\u0017BA2_\u0005\u00111\u0015\u000e\\3\u0002\u000fQl\u0007\u000fR5sA\u00051An\\4ESJ\fq\u0001\\8h\t&\u0014\b%A\bfq\u0016\u001cW\u000f^8s'\u0016\u0014h/[2f+\u0005I\u0007C\u00016p\u001b\u0005Y'B\u00017n\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0003]\u0002\fA!\u001e;jY&\u0011\u0001o\u001b\u0002\u0010\u000bb,7-\u001e;peN+'O^5dK\u0006\u0001R\r_3dkR|'oU3sm&\u001cW\rI\u0001\u0010CB\u0004XM\u001c3TK6\f\u0007\u000f[8sKV\tA\u000f\u0005\u0002kk&\u0011ao\u001b\u0002\n'\u0016l\u0017\r\u001d5pe\u0016\f\u0001#\u00199qK:$7+Z7ba\"|'/\u001a\u0011\u0002%MD'/\u001b8l\u0013N\u00148+Z7ba\"|'/Z\u0001\u0014g\"\u0014\u0018N\\6JgJ\u001cV-\\1qQ>\u0014X\rI\u0001\u000fM>dGn\\<feF+X-^3t+\u0005a\b#B?\u0002\u0006\u0005%Q\"\u0001@\u000b\u0007}\f\t!A\u0005j[6,H/\u00192mK*\u0019\u00111\u0001\u001f\u0002\u0015\r|G\u000e\\3di&|g.C\u0002\u0002\by\u0014!\"\u00138eKb,GmU3r!\u0015Q\u00171BA\b\u0013\r\tia\u001b\u0002\u0013\u0003J\u0014\u0018-\u001f\"m_\u000e\\\u0017N\\4Rk\u0016,X\r\u0005\u0003\u0002\u0012\u0005\u0015RBAA\n\u0015\u0011\t)\"a\u0006\u0002\rI,7m\u001c:e\u0015\u0011\tI\"a\u0007\u0002\r\r|W.\\8o\u0015\r9\u0014Q\u0004\u0006\u0005\u0003?\t\t#\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0003\u0003G\t1a\u001c:h\u0013\u0011\t9#a\u0005\u0003\u001b5+Wn\u001c:z%\u0016\u001cwN\u001d3t\u0003=1w\u000e\u001c7po\u0016\u0014\u0018+^3vKN\u0004\u0013A\u00037pO6\u000bg.Y4feV\u0011\u0011q\u0006\t\u0005\u0003c\t9$\u0004\u0002\u00024)\u0019\u0011Q\u0007\u001c\u0002\u00071|w-\u0003\u0003\u0002:\u0005M\"A\u0003'pO6\u000bg.Y4fe\u0006qAn\\4NC:\fw-\u001a:`I\u0015\fH\u0003BA \u0003\u000b\u00022aOA!\u0013\r\t\u0019\u0005\u0010\u0002\u0005+:LG\u000fC\u0005\u0002H]\t\t\u00111\u0001\u00020\u0005\u0019\u0001\u0010J\u0019\u0002\u00171|w-T1oC\u001e,'\u000fI\u0001\na\u0006\u0014H/\u001b;j_:,\"!a\u0014\u0011\u0007%\u000b\t&C\u0002\u0002TQ\u0012\u0011\u0002U1si&$\u0018n\u001c8\u0002\u001bA\f'\u000f^5uS>tw\fJ3r)\u0011\ty$!\u0017\t\u0013\u0005\u001d#$!AA\u0002\u0005=\u0013A\u00039beRLG/[8oA\u0005qAo\u001c9jGB\u000b'\u000f^5uS>tWCAA1!\u0011\t\u0019'!\u001a\u000e\u0005\u0005]\u0011\u0002BA4\u0003/\u0011a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g.A\bu_BL7\rU1si&$\u0018n\u001c8!\u0003\u0015\u0019X\r^+q)\t\ty\u0004K\u0002\u001f\u0003c\u0002B!a\u001d\u0002\u00026\u0011\u0011Q\u000f\u0006\u0005\u0003o\nI(A\u0002ba&TA!a\u001f\u0002~\u00059!.\u001e9ji\u0016\u0014(\u0002BA@\u0003C\tQA[;oSRLA!a!\u0002v\tQ!)\u001a4pe\u0016,\u0015m\u00195\u0002\u0011Q,\u0017M\u001d#po:D3aHAE!\u0011\t\u0019(a#\n\t\u00055\u0015Q\u000f\u0002\n\u0003\u001a$XM]#bG\"\fA\u0005^3ti:{Gj\\2l\u0007>tG/\u001a8uS>tw+\u001b;i_V$\u0018j\u001d:Va\u0012\fG/\u001a\u0015\u0004A\u0005M\u0005\u0003BA:\u0003+KA!a&\u0002v\t!A+Z:u\u0003Q\"Xm\u001d;BaB,g\u000e\u001a*fa2L7-\u0019$fi\u000eDw+\u001b;i'\u000eDW\rZ;mKJ\u001c\u0005.Z2l\r>\u00148\u000b\u001b:j].L5O\u001d\u0015\u0004C\u0005M\u0015a\t;fgR\f\u0005\u000f]3oIJ+\u0007\u000f\\5dC\u001a+Go\u00195XSRDW\u000b\u001d3bi\u0016L5O\u001d\u0015\u0004E\u0005M\u0015\u0001\u000b;fgR<U\r\u001e*fa2L7-Y,ji\",\u0006\u000fZ1uK\u0006\u001b8/[4o[\u0016tG/\u00118e\u0013N\u0014\bfA\u0012\u0002\u0014\u000613m\u001c8dkJ\u0014XM\u001c;Qe>$WoY3GKR\u001c\u0007nV5uQJ+\u0017\r\u001a'pG.|e\u000e\\=\u0002G\r|gnY;se\u0016tG\u000f\u0015:pIV\u001cWMR3uG\"<\u0016\u000e\u001e5Xe&$X\rT8dW\u0006y1o\u00195fIVdW-\u00119qK:$7\u000f\u0006\u0002\u0002.B1\u0011qVA`\u0003\u000btA!!-\u0002<:!\u00111WA]\u001b\t\t)LC\u0002\u00028b\na\u0001\u0010:p_Rt\u0014\"A\u001f\n\u0007\u0005uF(A\u0004qC\u000e\\\u0017mZ3\n\t\u0005\u0005\u00171\u0019\u0002\u0004'\u0016\f(bAA_yA\"\u0011qYAi!\u0015Q\u0017\u0011ZAg\u0013\r\tYm\u001b\u0002\u0007\rV$XO]3\u0011\t\u0005=\u0017\u0011\u001b\u0007\u0001\t-\t\u0019NJA\u0001\u0002\u0003\u0015\t!!6\u0003\u0007}#\u0013'\u0005\u0003\u0002X\u0006u\u0007cA\u001e\u0002Z&\u0019\u00111\u001c\u001f\u0003\u000f9{G\u000f[5oOB\u00191(a8\n\u0007\u0005\u0005HHA\u0002B]f\fqc]2iK\u0012,H.Z+qI\u0006$XMR8mY><XM]:\u0015\t\u0005\u001d\u00181\u001f\t\u0007\u0003_\u000by,!;1\t\u0005-\u0018q\u001e\t\u0006U\u0006%\u0017Q\u001e\t\u0005\u0003\u001f\fy\u000fB\u0006\u0002r\u001e\n\t\u0011!A\u0003\u0002\u0005U'aA0%e!1\u0011Q_\u0014A\u00021\u000b!B\\;n%\u0016\u001cwN\u001d3t\u0003E\u00198\r[3ek2,7\u000b\u001b:j].L5O\u001d\u000b\u0007\u0003w\u0014)A!\u00061\t\u0005u(\u0011\u0001\t\u0006U\u0006%\u0017q \t\u0005\u0003\u001f\u0014\t\u0001B\u0006\u0003\u0004!\n\t\u0011!A\u0003\u0002\u0005U'aA0%g!9!q\u0001\u0015A\u0002\t%\u0011AC1di&4XM\u00127bOB!!1\u0002B\t\u001b\t\u0011iAC\u0002\u0003\u0010-\fa!\u0019;p[&\u001c\u0017\u0002\u0002B\n\u0005\u001b\u0011Q\"\u0011;p[&\u001c'i\\8mK\u0006t\u0007b\u0002B\fQ\u0001\u0007!\u0011D\u0001\u0010[>\u001c7\u000eV5nKNcW-\u001a9NgB\u00191Ha\u0007\n\u0007\tuAH\u0001\u0003M_:<\u0017aF:fiV\u0004\b+\u0019:uSRLwN\\,ji\"lunY6t)\u0011\tyEa\t\t\u000f\u0005-\u0012\u00061\u0001\u00020\u0005\u00192M]3bi\u0016dun\u001a)s_B,'\u000f^5fgR!!\u0011\u0006B\u0019!\u0011\u0011YC!\f\u000e\u00035L1Aa\fn\u0005)\u0001&o\u001c9feRLWm\u001d\u0005\b\u0005gQ\u0003\u0019\u0001B\u001b\u0003%yg/\u001a:sS\u0012,7\u000f\u0005\u0005\u00038\t}\"Q\tB#\u001d\u0011\u0011IDa\u000f\u0011\u0007\u0005MF(C\u0002\u0003>q\na\u0001\u0015:fI\u00164\u0017\u0002\u0002B!\u0005\u0007\u00121!T1q\u0015\r\u0011i\u0004\u0010\t\u0005\u0005o\u00119%\u0003\u0003\u0003J\t\r#AB*ue&tw-\u0001\u0004baB,g\u000e\u001a\u000b\t\u0003\u007f\u0011yE!\u0015\u0003T!9\u00111J\u0016A\u0002\u0005=\u0003BBA{W\u0001\u0007A\n\u0003\u0004{W\u0001\u0007!Q\u000b\t\u0007\u0003_\u000by,!\u0003\u00021U\u0004H-\u0019;f\r>dGn\\<fe\u001a+Go\u00195Ti\u0006$X\r\u0006\u0006\u0002@\tm#Q\fB1\u0005GBq!a\u0013-\u0001\u0004\ty\u0005\u0003\u0004\u0003`1\u0002\r\u0001T\u0001\u000bM>dGn\\<fe&#\u0007BBA{Y\u0001\u0007A\nC\u0004\u0003f1\u0002\r!!\u0003\u0002\u001b\u0019|G\u000e\\8xKJ\fV/Z;f\u0005\u001d\u0019Fn\\<M_\u001e\u001c2!\fB6!\u0011\t\tD!\u001c\n\t\t=\u00141\u0007\u0002\u0004\u0019><G\u0003\u0003B:\u0005o\u0012IHa\u001f\u0011\u0007\tUT&D\u0001\u0001\u0011\u001d\t)$\ra\u0001\u0005WBQ\u0001V\u0019A\u0002YCQA]\u0019A\u0002Q\fa\"\u00199qK:$\u0017i\u001d'fC\u0012,'\u000f\u0006\u0006\u0003\u0002\n\u001d%1\u0012BH\u00053\u0003B!!\r\u0003\u0004&!!QQA\u001a\u00055aunZ!qa\u0016tG-\u00138g_\"9!\u0011\u0012\u001aA\u0002\u0005=\u0011a\u0002:fG>\u0014Hm\u001d\u0005\u0007\u0005\u001b\u0013\u0004\u0019\u0001'\u0002\u00171,\u0017\rZ3s\u000bB|7\r\u001b\u0005\n\u0005#\u0013\u0004\u0013!a\u0001\u0005'\u000baa\u001c:jO&t\u0007\u0003BA\u0019\u0005+KAAa&\u00024\ta\u0011\t\u001d9f]\u0012|%/[4j]\"I!1\u0014\u001a\u0011\u0002\u0003\u0007!QT\u0001\u001bS:$XM\u001d\"s_.,'\u000f\u0015:pi>\u001cw\u000e\u001c,feNLwN\u001c\t\u0005\u0005?\u0013\u0019+\u0004\u0002\u0003\"*\u0019\u0011q\u000f\u001c\n\t\t\u0015&\u0011\u0015\u0002\u000b\u0003BLg+\u001a:tS>t\u0007")
public class PartitionLockTest
implements Logging {
    private final int numReplicaFetchers;
    private final int numProducers;
    private final int numRecordsPerProducer;
    private final MockTime mockTime;
    private final File tmpDir;
    private final File logDir;
    private final ExecutorService executorService;
    private final Semaphore appendSemaphore;
    private final Semaphore shrinkIsrSemaphore;
    private final IndexedSeq<ArrayBlockingQueue<MemoryRecords>> followerQueues;
    private LogManager logManager;
    private Partition partition;
    private final TopicPartition kafka$cluster$PartitionLockTest$$topicPartition;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$((Logging)this, (String)msg);
    }

    public void trace(Function0<String> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$((Logging)this, msg, e);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void debug(Function0<String> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$((Logging)this, msg, e);
    }

    public void info(Function0<String> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$((Logging)this, msg, e);
    }

    public void warn(Function0<String> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$((Logging)this, msg, e);
    }

    public void error(Function0<String> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$((Logging)this, msg, e);
    }

    public void fatal(Function0<String> msg) {
        Logging.fatal$((Logging)this, msg);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$((Logging)this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public int numReplicaFetchers() {
        return this.numReplicaFetchers;
    }

    public int numProducers() {
        return this.numProducers;
    }

    public int numRecordsPerProducer() {
        return this.numRecordsPerProducer;
    }

    public MockTime mockTime() {
        return this.mockTime;
    }

    public File tmpDir() {
        return this.tmpDir;
    }

    public File logDir() {
        return this.logDir;
    }

    public ExecutorService executorService() {
        return this.executorService;
    }

    public Semaphore appendSemaphore() {
        return this.appendSemaphore;
    }

    public Semaphore shrinkIsrSemaphore() {
        return this.shrinkIsrSemaphore;
    }

    public IndexedSeq<ArrayBlockingQueue<MemoryRecords>> followerQueues() {
        return this.followerQueues;
    }

    public LogManager logManager() {
        return this.logManager;
    }

    public void logManager_$eq(LogManager x$1) {
        this.logManager = x$1;
    }

    public Partition partition() {
        return this.partition;
    }

    public void partition_$eq(Partition x$1) {
        this.partition = x$1;
    }

    public TopicPartition kafka$cluster$PartitionLockTest$$topicPartition() {
        return this.kafka$cluster$PartitionLockTest$$topicPartition;
    }

    @BeforeEach
    public void setUp() {
        LogConfig logConfig = new LogConfig((Map)new Properties(), LogConfig$.MODULE$.$lessinit$greater$default$2());
        CachedConfigRepository configRepository = TestUtils$.MODULE$.createConfigRepository(this.kafka$cluster$PartitionLockTest$$topicPartition().topic(), this.createLogProperties((scala.collection.immutable.Map<String, String>)Predef$.MODULE$.Map().empty()));
        boolean x$1 = false;
        int x$2 = CleanerConfig$.MODULE$.apply$default$1();
        long x$3 = CleanerConfig$.MODULE$.apply$default$2();
        double x$4 = CleanerConfig$.MODULE$.apply$default$3();
        int x$5 = CleanerConfig$.MODULE$.apply$default$4();
        int x$6 = CleanerConfig$.MODULE$.apply$default$5();
        double x$7 = CleanerConfig$.MODULE$.apply$default$6();
        long x$8 = CleanerConfig$.MODULE$.apply$default$7();
        String x$9 = CleanerConfig$.MODULE$.apply$default$9();
        this.logManager_$eq(TestUtils$.MODULE$.createLogManager((Seq<File>)new .colon.colon((Object)this.logDir(), (List)Nil$.MODULE$), logConfig, (ConfigRepository)configRepository, new CleanerConfig(x$2, x$3, x$4, x$5, x$6, x$7, x$8, x$1, x$9), this.mockTime()));
        this.partition_$eq(this.setupPartitionWithMocks(this.logManager()));
    }

    @AfterEach
    public void tearDown() {
        this.executorService().shutdownNow();
        this.logManager().liveLogDirs().foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            PartitionLockTest.$anonfun$tearDown$1(x$1);
            return BoxedUnit.UNIT;
        });
        Utils.delete((File)this.tmpDir());
    }

    @Test
    public void testNoLockContentionWithoutIsrUpdate() {
        this.concurrentProduceFetchWithReadLockOnly();
    }

    @Test
    public void testAppendReplicaFetchWithSchedulerCheckForShrinkIsr() {
        AtomicBoolean active = new AtomicBoolean(true);
        Future<?> future = this.scheduleShrinkIsr(active, 0L);
        this.concurrentProduceFetchWithReadLockOnly();
        active.set(false);
        future.get(15L, TimeUnit.SECONDS);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testAppendReplicaFetchWithUpdateIsr() {
        AtomicBoolean active = new AtomicBoolean(true);
        Future<?> future = this.scheduleShrinkIsr(active, 10000L);
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!PartitionLockTest.$anonfun$testAppendReplicaFetchWithUpdateIsr$1(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)PartitionLockTest.$anonfun$testAppendReplicaFetchWithUpdateIsr$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.concurrentProduceFetchWithWriteLock();
        active.set(false);
        future.get(15L, TimeUnit.SECONDS);
    }

    @Test
    public void testGetReplicaWithUpdateAssignmentAndIsr() {
        AtomicBoolean active = new AtomicBoolean(true);
        int replicaToCheck = 3;
        java.util.List firstReplicaSet = (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(3), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(4), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(5), (List)Nil$.MODULE$)))).asJava();
        java.util.List secondReplicaSet = (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(1), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(2), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(3), (List)Nil$.MODULE$)))).asJava();
        OffsetCheckpoints offsetCheckpoints = (OffsetCheckpoints)Mockito.mock(OffsetCheckpoints.class);
        this.partition().makeLeader(PartitionLockTest.partitionState$1(secondReplicaSet), offsetCheckpoints);
        Assertions.assertTrue((boolean)this.partition().getReplica(replicaToCheck).isDefined(), (String)new StringBuilder(31).append("Expected replica ").append(replicaToCheck).append(" to be defined").toString());
        Future<?> future = this.executorService().submit(() -> {
            int i = 0;
            while (active.get()) {
                java.util.List replicas = i % 2 == 0 ? firstReplicaSet : secondReplicaSet;
                this.partition().makeLeader(PartitionLockTest.partitionState$1(replicas), offsetCheckpoints);
                ++i;
                Thread.sleep(1L);
            }
        });
        Deadline deadline = new package.DurationInt(package$.MODULE$.DurationInt(1)).seconds().fromNow();
        while (deadline.hasTimeLeft()) {
            Assertions.assertTrue((boolean)this.partition().getReplica(replicaToCheck).isDefined(), (String)new StringBuilder(31).append("Expected replica ").append(replicaToCheck).append(" to be defined").toString());
        }
        active.set(false);
        future.get(5L, TimeUnit.SECONDS);
        Assertions.assertTrue((boolean)this.partition().getReplica(replicaToCheck).isDefined(), (String)new StringBuilder(31).append("Expected replica ").append(replicaToCheck).append(" to be defined").toString());
    }

    private void concurrentProduceFetchWithReadLockOnly() {
        Seq<Future<?>> appendFutures = this.scheduleAppends();
        Seq<Future<?>> stateUpdateFutures = this.scheduleUpdateFollowers(this.numProducers() * this.numRecordsPerProducer() - 1);
        this.appendSemaphore().release(this.numProducers() * this.numRecordsPerProducer() - 1);
        stateUpdateFutures.foreach((Function1 & Serializable & scala.Serializable)x$2 -> x$2.get(15L, TimeUnit.SECONDS));
        this.appendSemaphore().release(1);
        this.scheduleUpdateFollowers(1).foreach((Function1 & Serializable & scala.Serializable)x$3 -> x$3.get(15L, TimeUnit.SECONDS));
        appendFutures.foreach((Function1 & Serializable & scala.Serializable)x$4 -> x$4.get(15L, TimeUnit.SECONDS));
    }

    private void concurrentProduceFetchWithWriteLock() {
        Seq<Future<?>> appendFutures = this.scheduleAppends();
        Seq<Future<?>> stateUpdateFutures = this.scheduleUpdateFollowers(this.numProducers() * this.numRecordsPerProducer());
        Assertions.assertFalse((boolean)stateUpdateFutures.exists((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)x$5.isDone())));
        this.appendSemaphore().release(this.numProducers() * this.numRecordsPerProducer());
        Assertions.assertFalse((boolean)appendFutures.exists((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)x$6.isDone())));
        this.shrinkIsrSemaphore().release();
        stateUpdateFutures.foreach((Function1 & Serializable & scala.Serializable)x$7 -> x$7.get(15L, TimeUnit.SECONDS));
        appendFutures.foreach((Function1 & Serializable & scala.Serializable)x$8 -> x$8.get(15L, TimeUnit.SECONDS));
    }

    private Seq<Future<?>> scheduleAppends() {
        return (Seq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.numProducers()).map((Function1 & Serializable & scala.Serializable)x$9 -> PartitionLockTest.$anonfun$scheduleAppends$1(this, BoxesRunTime.unboxToInt((Object)x$9)), IndexedSeq$.MODULE$.canBuildFrom());
    }

    private Seq<Future<?>> scheduleUpdateFollowers(int numRecords) {
        return (Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), this.numReplicaFetchers()).map((Function1 & Serializable & scala.Serializable)index -> PartitionLockTest.$anonfun$scheduleUpdateFollowers$1(this, numRecords, BoxesRunTime.unboxToInt((Object)index)), IndexedSeq$.MODULE$.canBuildFrom());
    }

    private Future<?> scheduleShrinkIsr(AtomicBoolean activeFlag, long mockTimeSleepMs) {
        return this.executorService().submit(() -> {
            while (activeFlag.get()) {
                if (mockTimeSleepMs > 0L) {
                    this.mockTime().sleep(mockTimeSleepMs);
                }
                this.partition().maybeShrinkIsr();
                Thread.sleep(1L);
            }
        });
    }

    private Partition setupPartitionWithMocks(LogManager logManager) {
        int leaderEpoch = 1;
        int brokerId = 0;
        IsrChangeListener isrChangeListener = (IsrChangeListener)Mockito.mock(IsrChangeListener.class);
        DelayedOperations delayedOperations = (DelayedOperations)Mockito.mock(DelayedOperations.class);
        MetadataCache metadataCache = (MetadataCache)Mockito.mock(MetadataCache.class);
        OffsetCheckpoints offsetCheckpoints = (OffsetCheckpoints)Mockito.mock(OffsetCheckpoints.class);
        AlterIsrManager alterIsrManager = (AlterIsrManager)Mockito.mock(AlterIsrManager.class);
        logManager.startup((Set)Predef$.MODULE$.Set().empty());
        Partition partition = new Partition(this, brokerId, isrChangeListener, delayedOperations, metadataCache, logManager, alterIsrManager){
            private final /* synthetic */ PartitionLockTest $outer;

            public void shrinkIsr(scala.collection.immutable.Set<Object> newIsr) {
                this.$outer.shrinkIsrSemaphore().acquire();
                try {
                    super.shrinkIsr(newIsr);
                }
                finally {
                    this.$outer.shrinkIsrSemaphore().release();
                }
            }

            public Log createLog(boolean isNew, boolean isFutureReplica, OffsetCheckpoints offsetCheckpoints) {
                Log log = super.createLog(isNew, isFutureReplica, offsetCheckpoints);
                return new SlowLog(this.$outer, log, this.$outer.mockTime(), this.$outer.appendSemaphore());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                super($outer.kafka$cluster$PartitionLockTest$$topicPartition(), Defaults$.MODULE$.ReplicaLagTimeMaxMs(), ApiVersion$.MODULE$.latestVersion(), brokerId$1, (Time)$outer.mockTime(), isrChangeListener$1, delayedOperations$1, metadataCache$1, logManager$1, alterIsrManager$1);
            }
        };
        Mockito.when((Object)offsetCheckpoints.fetch(ArgumentMatchers.anyString(), (TopicPartition)ArgumentMatchers.eq((Object)this.kafka$cluster$PartitionLockTest$$topicPartition()))).thenReturn((Object)None$.MODULE$);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)alterIsrManager.submit((AlterIsrItem)ArgumentMatchers.any()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        partition.createLogIfNotExists(false, false, offsetCheckpoints);
        int controllerEpoch = 0;
        java.util.List replicas = (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableOnce)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), this.numReplicaFetchers()).map((Function1 & Serializable & scala.Serializable)i -> PartitionLockTest.$anonfun$setupPartitionWithMocks$1(brokerId, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom())).toList()).asJava();
        Assertions.assertTrue((boolean)partition.makeLeader(new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(controllerEpoch).setLeader(brokerId).setLeaderEpoch(leaderEpoch).setIsr(replicas).setZkVersion(1).setReplicas(replicas).setIsNew(true), offsetCheckpoints), (String)"Expected become leader transition to succeed");
        return partition;
    }

    /*
     * WARNING - void declaration
     */
    private Properties createLogProperties(scala.collection.immutable.Map<String, String> overrides) {
        void var2_2;
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(512));
        logProps.put(LogConfig$.MODULE$.SegmentIndexBytesProp(), Predef$.MODULE$.int2Integer(1000));
        logProps.put(LogConfig$.MODULE$.RetentionMsProp(), Predef$.MODULE$.int2Integer(999));
        overrides.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            String k = (String)x0$1._1();
            String v = (String)x0$1._2();
            Object object = logProps.put(k, v);
            return object;
        });
        return var2_2;
    }

    private void append(Partition partition, int numRecords, Seq<ArrayBlockingQueue<MemoryRecords>> followerQueues) {
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numRecords).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$10 -> {
            MemoryRecords batch = TestUtils$.MODULE$.records((Iterable<SimpleRecord>)new .colon.colon((Object)new SimpleRecord("k1".getBytes(), "v1".getBytes()), (List)new .colon.colon((Object)new SimpleRecord("k2".getBytes(), "v2".getBytes()), (List)Nil$.MODULE$)), TestUtils$.MODULE$.records$default$2(), TestUtils$.MODULE$.records$default$3(), TestUtils$.MODULE$.records$default$4(), TestUtils$.MODULE$.records$default$5(), TestUtils$.MODULE$.records$default$6(), TestUtils$.MODULE$.records$default$7(), TestUtils$.MODULE$.records$default$8());
            partition.appendRecordsToLeader(batch, (AppendOrigin)AppendOrigin.Client$.MODULE$, 0);
            followerQueues.foreach((Function1 & Serializable & scala.Serializable)x$11 -> {
                x$11.put(batch);
                return BoxedUnit.UNIT;
            });
        });
    }

    private void updateFollowerFetchState(Partition partition, int followerId, int numRecords, ArrayBlockingQueue<MemoryRecords> followerQueue) {
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), numRecords).foreach((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)i -> {
            MemoryRecords batch = (MemoryRecords)followerQueue.poll(15L, TimeUnit.SECONDS);
            if (batch == null) {
                throw new RuntimeException(new StringBuilder(33).append("Timed out waiting for next batch ").append(i).toString());
            }
            List batches = ((TraversableOnce)CollectionConverters$.MODULE$.asScalaIteratorConverter(batch.batches().iterator()).asScala()).toList();
            Assertions.assertEquals((int)1, (int)batches.size());
            MutableRecordBatch recordBatch = (MutableRecordBatch)batches.head();
            return partition.updateFollowerFetchState(followerId, new LogOffsetMetadata(recordBatch.lastOffset() + 1L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), 0L, this.mockTime().milliseconds(), partition.localLogOrException().logEndOffset());
        });
    }

    public static final /* synthetic */ ArrayBlockingQueue $anonfun$followerQueues$1(int x$1) {
        return new ArrayBlockingQueue(2);
    }

    public static final /* synthetic */ void $anonfun$tearDown$1(File x$1) {
        Utils.delete((File)x$1);
    }

    public static final /* synthetic */ boolean $anonfun$testAppendReplicaFetchWithUpdateIsr$1(PartitionLockTest $this) {
        return $this.shrinkIsrSemaphore().hasQueuedThreads();
    }

    public static final /* synthetic */ String $anonfun$testAppendReplicaFetchWithUpdateIsr$2() {
        return "shrinkIsr not invoked";
    }

    private static final LeaderAndIsrRequestData.LeaderAndIsrPartitionState partitionState$1(java.util.List replicas) {
        return new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(1).setLeader(Predef$.MODULE$.Integer2int((Integer)replicas.get(0))).setLeaderEpoch(1).setIsr(replicas).setZkVersion(1).setReplicas(replicas).setIsNew(true);
    }

    public static final /* synthetic */ Future $anonfun$scheduleAppends$1(PartitionLockTest $this, int x$9) {
        return $this.executorService().submit(() -> {
            try {
                $this.append($this.partition(), $this.numRecordsPerProducer(), (Seq<ArrayBlockingQueue<MemoryRecords>>)$this.followerQueues());
                return;
            }
            catch (Throwable e) {
                $this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Exception during append", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                throw e;
            }
        });
    }

    public static final /* synthetic */ Future $anonfun$scheduleUpdateFollowers$1(PartitionLockTest $this, int numRecords$1, int index) {
        return $this.executorService().submit(() -> {
            try {
                $this.updateFollowerFetchState($this.partition(), index, numRecords$1, (ArrayBlockingQueue)$this.followerQueues().apply(index - 1));
                return;
            }
            catch (Throwable e) {
                $this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Exception during updateFollowerFetchState", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                throw e;
            }
        });
    }

    public static final /* synthetic */ Integer $anonfun$setupPartitionWithMocks$1(int brokerId$1, int i) {
        return brokerId$1 + i;
    }

    public PartitionLockTest() {
        Logging.$init$((Logging)this);
        this.numReplicaFetchers = 2;
        this.numProducers = 3;
        this.numRecordsPerProducer = 5;
        this.mockTime = new MockTime();
        this.tmpDir = TestUtils$.MODULE$.tempDir();
        this.logDir = TestUtils$.MODULE$.randomPartitionLogDir(this.tmpDir());
        this.executorService = Executors.newFixedThreadPool(this.numReplicaFetchers() + this.numProducers() + 1);
        this.appendSemaphore = new Semaphore(0);
        this.shrinkIsrSemaphore = new Semaphore(0);
        this.followerQueues = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.numReplicaFetchers()).map((Function1 & Serializable & scala.Serializable)x$1 -> PartitionLockTest.$anonfun$followerQueues$1(BoxesRunTime.unboxToInt((Object)x$1)), IndexedSeq$.MODULE$.canBuildFrom());
        this.kafka$cluster$PartitionLockTest$$topicPartition = new TopicPartition("test-topic", 0);
    }

    private class SlowLog
    extends Log {
        private final Semaphore appendSemaphore;
        public final /* synthetic */ PartitionLockTest $outer;

        public LogAppendInfo appendAsLeader(MemoryRecords records, int leaderEpoch, AppendOrigin origin, ApiVersion interBrokerProtocolVersion) {
            LogAppendInfo appendInfo = super.appendAsLeader(records, leaderEpoch, origin, interBrokerProtocolVersion);
            this.appendSemaphore.acquire();
            return appendInfo;
        }

        public /* synthetic */ PartitionLockTest kafka$cluster$PartitionLockTest$SlowLog$$$outer() {
            return this.$outer;
        }

        public SlowLog(PartitionLockTest $outer, Log log, MockTime mockTime, Semaphore appendSemaphore) {
            this.appendSemaphore = appendSemaphore;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            super(log.dir(), log.config(), log.logStartOffset(), log.recoveryPoint(), (Scheduler)mockTime.scheduler(), new BrokerTopicStats(), log.time(), log.maxProducerIdExpirationMs(), log.producerIdExpirationCheckIntervalMs(), log.topicPartition(), log.producerStateManager(), new LogDirFailureChannel(1), Log$.MODULE$.$lessinit$greater$default$13(), Log$.MODULE$.$lessinit$greater$default$14());
        }
    }
}

