/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.transaction;

import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.nio.ByteBuffer;
import java.util.concurrent.CountDownLatch;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import kafka.coordinator.transaction.CompleteAbort$;
import kafka.coordinator.transaction.CompleteCommit$;
import kafka.coordinator.transaction.CoordinatorEpochAndTxnMetadata;
import kafka.coordinator.transaction.Empty$;
import kafka.coordinator.transaction.Ongoing$;
import kafka.coordinator.transaction.PrepareAbort$;
import kafka.coordinator.transaction.PrepareCommit$;
import kafka.coordinator.transaction.TransactionConfig;
import kafka.coordinator.transaction.TransactionConfig$;
import kafka.coordinator.transaction.TransactionLog$;
import kafka.coordinator.transaction.TransactionMetadata;
import kafka.coordinator.transaction.TransactionMetadata$;
import kafka.coordinator.transaction.TransactionPartitionAndLeaderEpoch;
import kafka.coordinator.transaction.TransactionState;
import kafka.coordinator.transaction.TransactionStateManager;
import kafka.coordinator.transaction.TransactionalIdAndProducerIdEpoch;
import kafka.coordinator.transaction.TxnMetadataCacheEntry;
import kafka.coordinator.transaction.TxnTransitMetadata;
import kafka.log.AppendOrigin;
import kafka.log.Log;
import kafka.server.FetchDataInfo;
import kafka.server.FetchDataInfo$;
import kafka.server.FetchIsolation;
import kafka.server.FetchLogEnd$;
import kafka.server.LogOffsetMetadata;
import kafka.server.LogOffsetMetadata$;
import kafka.server.ReplicaManager;
import kafka.utils.MockScheduler;
import kafka.utils.Pool;
import kafka.utils.Pool$;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.JmxReporter;
import org.apache.kafka.common.metrics.KafkaMetricsContext;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.MetricsContext;
import org.apache.kafka.common.metrics.MetricsReporter;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.requests.ProduceResponse;
import org.apache.kafka.common.requests.TransactionResult;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.easymock.Capture;
import org.easymock.EasyMock;
import org.easymock.IAnswer;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Function0;
import scala.Function1;
import scala.Function4;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0001\r%b\u0001\u0002,X\u0001yCQ!\u001a\u0001\u0005\u0002\u0019Dq!\u001b\u0001C\u0002\u0013\u0005!\u000e\u0003\u0004o\u0001\u0001\u0006Ia\u001b\u0005\b_\u0002\u0011\r\u0011\"\u0001k\u0011\u0019\u0001\b\u0001)A\u0005W\"9\u0011\u000f\u0001b\u0001\n\u0003Q\u0007B\u0002:\u0001A\u0003%1\u000eC\u0004t\u0001\t\u0007I\u0011\u0001;\t\u000f\u0005\u0005\u0001\u0001)A\u0005k\"A\u00111\u0001\u0001C\u0002\u0013\u0005!\u000eC\u0004\u0002\u0006\u0001\u0001\u000b\u0011B6\t\u0013\u0005\u001d\u0001A1A\u0005\u0002\u0005%\u0001\u0002CA\u0014\u0001\u0001\u0006I!a\u0003\t\u0013\u0005%\u0002A1A\u0005\u0002\u0005-\u0002\u0002CA\u001d\u0001\u0001\u0006I!!\f\t\u0013\u0005m\u0002A1A\u0005\u0002\u0005u\u0002\u0002CA%\u0001\u0001\u0006I!a\u0010\t\u0013\u0005-\u0003A1A\u0005\u0002\u00055\u0003\u0002CA.\u0001\u0001\u0006I!a\u0014\t\u0013\u0005u\u0003A1A\u0005\u0002\u0005}\u0003\u0002CA7\u0001\u0001\u0006I!!\u0019\t\u0013\u0005=\u0004A1A\u0005\u0002\u0005E\u0004\u0002CA?\u0001\u0001\u0006I!a\u001d\t\u0013\u0005}\u0004A1A\u0005\u0002\u0005\u0005\u0005\u0002CAE\u0001\u0001\u0006I!a!\t\u0013\u0005-\u0005A1A\u0005\u0002\u00055\u0005\u0002CAK\u0001\u0001\u0006I!a$\t\u0013\u0005]\u0005A1A\u0005\u0002\u0005e\u0005\u0002CAY\u0001\u0001\u0006I!a'\t\u0013\u0005M\u0006A1A\u0005\u0002\u0005e\u0005\u0002CA[\u0001\u0001\u0006I!a'\t\u0013\u0005]\u0006A1A\u0005\u0002\u0005e\u0006\u0002CAd\u0001\u0001\u0006I!a/\t\u0013\u0005%\u0007A1A\u0005\u0002\u0005e\u0006\u0002CAf\u0001\u0001\u0006I!a/\t\u0013\u00055\u0007A1A\u0005\u0002\u0005=\u0007\u0002CAp\u0001\u0001\u0006I!!5\t\u0013\u0005\u0005\b\u00011A\u0005\u0002\u0005\r\b\"CAv\u0001\u0001\u0007I\u0011AAw\u0011!\tI\u0010\u0001Q!\n\u0005\u0015\b\"CA~\u0001\u0001\u0007I\u0011AAr\u0011%\ti\u0010\u0001a\u0001\n\u0003\ty\u0010\u0003\u0005\u0003\u0004\u0001\u0001\u000b\u0015BAs\u0011%\u0011)\u0001\u0001a\u0001\n\u0003\u00119\u0001C\u0005\u0003\u0016\u0001\u0001\r\u0011\"\u0001\u0003\u0018!A!1\u0004\u0001!B\u0013\u0011I\u0001C\u0004\u0003\u001e\u0001!\tAa\b\t\u000f\t]\u0002\u0001\"\u0001\u0003 !9!\u0011\t\u0001\u0005\u0002\t}\u0001b\u0002B&\u0001\u0011\u0005!q\u0004\u0005\b\u0005\u001f\u0002A\u0011\u0001B\u0010\u0011\u001d\u0011\u0019\u0006\u0001C\u0001\u0005?AqAa\u0016\u0001\t\u0003\u0011y\u0002C\u0004\u0003\\\u0001!\tAa\b\t\u000f\t}\u0003\u0001\"\u0001\u0003 !9!1\r\u0001\u0005\u0002\t}\u0001b\u0002B4\u0001\u0011\u0005!q\u0004\u0005\b\u0005W\u0002A\u0011\u0001B\u0010\u0011\u001d\u0011y\u0007\u0001C\u0001\u0005?AqAa\u001d\u0001\t\u0003\u0011y\u0002C\u0004\u0003x\u0001!\tAa\b\t\u000f\tm\u0004\u0001\"\u0001\u0003 !9!q\u0010\u0001\u0005\u0002\t}\u0001b\u0002BB\u0001\u0011\u0005!q\u0004\u0005\b\u0005\u000f\u0003A\u0011\u0001B\u0010\u0011\u001d\u0011Y\t\u0001C\u0001\u0005?AqAa$\u0001\t\u0003\u0011y\u0002C\u0004\u0003\u0014\u0002!\tAa\b\t\u000f\t]\u0005\u0001\"\u0001\u0003 !9!1\u0014\u0001\u0005\u0002\t}\u0001b\u0002BP\u0001\u0011\u0005!q\u0004\u0005\b\u0005G\u0003A\u0011\u0001B\u0010\u0011\u001d\u00119\u000b\u0001C\u0001\u0005?AqAa+\u0001\t\u0003\u0011y\u0002C\u0004\u00030\u0002!IA!-\t\u000f\t]\u0006\u0001\"\u0003\u0003:\"9!Q\u0018\u0001\u0005\n\t}\u0006b\u0002Bh\u0001\u0011%!\u0011\u001b\u0005\b\u0005/\u0004A\u0011\u0002Bm\u0011\u001d\u0011i\u000e\u0001C\u0005\u0005?D\u0011B!<\u0001#\u0003%IAa<\t\u0013\r\u0015\u0001!%A\u0005\n\r\u001d\u0001bBB\u0006\u0001\u0011%1Q\u0002\u0005\b\u0007?\u0001A\u0011BB\u0011\u0011\u001d\u0019)\u0003\u0001C\u0001\u0005?\u00111\u0004\u0016:b]N\f7\r^5p]N#\u0018\r^3NC:\fw-\u001a:UKN$(B\u0001-Z\u0003-!(/\u00198tC\u000e$\u0018n\u001c8\u000b\u0005i[\u0016aC2p_J$\u0017N\\1u_JT\u0011\u0001X\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001q\f\u0005\u0002aG6\t\u0011MC\u0001c\u0003\u0015\u00198-\u00197b\u0013\t!\u0017M\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\u001d\u0004\"\u0001\u001b\u0001\u000e\u0003]\u000b1\u0002]1si&$\u0018n\u001c8JIV\t1\u000e\u0005\u0002aY&\u0011Q.\u0019\u0002\u0004\u0013:$\u0018\u0001\u00049beRLG/[8o\u0013\u0012\u0004\u0013!\u00048v[B\u000b'\u000f^5uS>t7/\u0001\bok6\u0004\u0016M\u001d;ji&|gn\u001d\u0011\u0002)Q\u0014\u0018M\\:bGRLwN\u001c+j[\u0016|W\u000f^'t\u0003U!(/\u00198tC\u000e$\u0018n\u001c8US6,w.\u001e;Ng\u0002\na\u0002^8qS\u000e\u0004\u0016M\u001d;ji&|g.F\u0001v!\t1h0D\u0001x\u0015\tA\u00180\u0001\u0004d_6lwN\u001c\u0006\u00039jT!a\u001f?\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005i\u0018aA8sO&\u0011qp\u001e\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0003=!x\u000e]5d!\u0006\u0014H/\u001b;j_:\u0004\u0013\u0001E2p_J$\u0017N\\1u_J,\u0005o\\2i\u0003E\u0019wn\u001c:eS:\fGo\u001c:Fa>\u001c\u0007\u000eI\u0001\u000bibt'+Z2pe\u0012\u001cXCAA\u0006!\u0019\ti!a\u0006\u0002\u001c5\u0011\u0011q\u0002\u0006\u0005\u0003#\t\u0019\"A\u0004nkR\f'\r\\3\u000b\u0007\u0005U\u0011-\u0001\u0006d_2dWm\u0019;j_:LA!!\u0007\u0002\u0010\tY\u0011I\u001d:bs\n+hMZ3s!\u0011\ti\"a\t\u000e\u0005\u0005}!bAA\u0011o\u00061!/Z2pe\u0012LA!!\n\u0002 \ta1+[7qY\u0016\u0014VmY8sI\u0006YA\u000f\u001f8SK\u000e|'\u000fZ:!\u0003\u0011!\u0018.\\3\u0016\u0005\u00055\u0002\u0003BA\u0018\u0003ki!!!\r\u000b\u0007\u0005Mr/A\u0003vi&d7/\u0003\u0003\u00028\u0005E\"\u0001C'pG.$\u0016.\\3\u0002\u000bQLW.\u001a\u0011\u0002\u0013M\u001c\u0007.\u001a3vY\u0016\u0014XCAA !\u0011\t\t%!\u0012\u000e\u0005\u0005\r#bAA\u001a7&!\u0011qIA\"\u00055iunY6TG\",G-\u001e7fe\u0006Q1o\u00195fIVdWM\u001d\u0011\u0002\u0011i\\7\t\\5f]R,\"!a\u0014\u0011\t\u0005E\u0013qK\u0007\u0003\u0003'R1!!\u0016\\\u0003\tQ8.\u0003\u0003\u0002Z\u0005M#!D&bM.\f'l[\"mS\u0016tG/A\u0005{W\u000ec\u0017.\u001a8uA\u0005q!/\u001a9mS\u000e\fW*\u00198bO\u0016\u0014XCAA1!\u0011\t\u0019'!\u001b\u000e\u0005\u0005\u0015$bAA47\u000611/\u001a:wKJLA!a\u001b\u0002f\tq!+\u001a9mS\u000e\fW*\u00198bO\u0016\u0014\u0018a\u0004:fa2L7-Y'b]\u0006<WM\u001d\u0011\u0002\u000f5,GO]5dgV\u0011\u00111\u000f\t\u0005\u0003k\nI(\u0004\u0002\u0002x)\u0019\u0011qN<\n\t\u0005m\u0014q\u000f\u0002\b\u001b\u0016$(/[2t\u0003!iW\r\u001e:jGN\u0004\u0013!\u0003;y]\u000e{gNZ5h+\t\t\u0019\tE\u0002i\u0003\u000bK1!a\"X\u0005E!&/\u00198tC\u000e$\u0018n\u001c8D_:4\u0017nZ\u0001\u000bibt7i\u001c8gS\u001e\u0004\u0013A\u0005;sC:\u001c\u0018m\u0019;j_:l\u0015M\\1hKJ,\"!a$\u0011\u0007!\f\t*C\u0002\u0002\u0014^\u0013q\u0003\u0016:b]N\f7\r^5p]N#\u0018\r^3NC:\fw-\u001a:\u0002'Q\u0014\u0018M\\:bGRLwN\\'b]\u0006<WM\u001d\u0011\u0002!Q\u0014\u0018M\\:bGRLwN\\1m\u0013\u0012\fTCAAN!\u0011\ti*a+\u000f\t\u0005}\u0015q\u0015\t\u0004\u0003C\u000bWBAAR\u0015\r\t)+X\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005%\u0016-\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003[\u000byK\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003S\u000b\u0017!\u0005;sC:\u001c\u0018m\u0019;j_:\fG.\u001332A\u0005\u0001BO]1og\u0006\u001cG/[8oC2LEMM\u0001\u0012iJ\fgn]1di&|g.\u00197JIJ\u0002\u0013a\u0005;y]6+7o]1hK.+\u0017PQ=uKN\fTCAA^!\u0015\u0001\u0017QXAa\u0013\r\ty,\u0019\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0004A\u0006\r\u0017bAAcC\n!!)\u001f;f\u0003Q!\bP\\'fgN\fw-Z&fs\nKH/Z:2A\u0005\u0019B\u000f\u001f8NKN\u001c\u0018mZ3LKf\u0014\u0015\u0010^3te\u0005!B\u000f\u001f8NKN\u001c\u0018mZ3LKf\u0014\u0015\u0010^3te\u0001\n1\u0002\u001d:pIV\u001cWM]%egV\u0011\u0011\u0011\u001b\t\t\u0003'\f).a'\u0002Z6\u0011\u00111C\u0005\u0005\u0003/\f\u0019BA\u0002NCB\u00042\u0001YAn\u0013\r\ti.\u0019\u0002\u0005\u0019>tw-\u0001\u0007qe>$WoY3s\u0013\u0012\u001c\b%\u0001\u0007uq:lU\r^1eCR\f\u0017'\u0006\u0002\u0002fB\u0019\u0001.a:\n\u0007\u0005%xKA\nUe\u0006t7/Y2uS>tW*\u001a;bI\u0006$\u0018-\u0001\tuq:lU\r^1eCR\f\u0017g\u0018\u0013fcR!\u0011q^A{!\r\u0001\u0017\u0011_\u0005\u0004\u0003g\f'\u0001B+oSRD\u0011\"a>(\u0003\u0003\u0005\r!!:\u0002\u0007a$\u0013'A\u0007uq:lU\r^1eCR\f\u0017\u0007I\u0001\ribtW*\u001a;bI\u0006$\u0018MM\u0001\u0011ibtW*\u001a;bI\u0006$\u0018MM0%KF$B!a<\u0003\u0002!I\u0011q\u001f\u0016\u0002\u0002\u0003\u0007\u0011Q]\u0001\u000eibtW*\u001a;bI\u0006$\u0018M\r\u0011\u0002\u001b\u0015D\b/Z2uK\u0012,%O]8s+\t\u0011I\u0001\u0005\u0003\u0003\f\tEQB\u0001B\u0007\u0015\r\u0011ya^\u0001\taJ|Go\\2pY&!!1\u0003B\u0007\u0005\u0019)%O]8sg\u0006\tR\r\u001f9fGR,G-\u0012:s_J|F%Z9\u0015\t\u0005=(\u0011\u0004\u0005\n\u0003ol\u0013\u0011!a\u0001\u0005\u0013\ta\"\u001a=qK\u000e$X\rZ#se>\u0014\b%A\u0003tKR,\u0006\u000f\u0006\u0002\u0002p\"\u001aqFa\t\u0011\t\t\u0015\"1G\u0007\u0003\u0005OQAA!\u000b\u0003,\u0005\u0019\u0011\r]5\u000b\t\t5\"qF\u0001\bUV\u0004\u0018\u000e^3s\u0015\r\u0011\t\u0004`\u0001\u0006UVt\u0017\u000e^\u0005\u0005\u0005k\u00119C\u0001\u0006CK\u001a|'/Z#bG\"\f\u0001\u0002^3be\u0012{wO\u001c\u0015\u0004a\tm\u0002\u0003\u0002B\u0013\u0005{IAAa\u0010\u0003(\tI\u0011I\u001a;fe\u0016\u000b7\r[\u0001\u001fi\u0016\u001cHOV1mS\u0012\fG/\u001a+sC:\u001c\u0018m\u0019;j_:$\u0016.\\3pkRD3!\rB#!\u0011\u0011)Ca\u0012\n\t\t%#q\u0005\u0002\u0005)\u0016\u001cH/\u0001\buKN$\u0018\t\u001a3HKR\u0004\u0016\u000eZ:)\u0007I\u0012)%A\nuKN$H)\u001a7fi\u0016\u0004\u0016M\u001d;ji&|g\u000eK\u00024\u0005\u000b\n!\u0004^3ti\u0012+G.\u001a;f\u0019>\fG-\u001b8h!\u0006\u0014H/\u001b;j_:D3\u0001\u000eB#\u0003%\"Xm\u001d;M_\u0006$\u0017I\u001c3SK6|g/\u001a+sC:\u001c\u0018m\u0019;j_:\u001chi\u001c:QCJ$\u0018\u000e^5p]\"\u001aQG!\u0012\u0002SQ,7\u000f^\"p[BdW\r^3Ue\u0006t7/\u001b;j_:<\u0006.\u001a8BaB,g\u000eZ*vG\u000e,W\rZ3eQ\r1$QI\u0001-i\u0016\u001cH/\u00119qK:$g)Y5m)>\u001cun\u001c:eS:\fGo\u001c:O_R\fe/Y5mC\ndW-\u0012:s_JD3a\u000eB#\u0003\r\"Xm\u001d;BaB,g\u000e\u001a$bS2$vNT8u\u0007>|'\u000fZ5oCR|'/\u0012:s_JD3\u0001\u000fB#\u0003\u001d\"Xm\u001d;BaB,g\u000e\u001a$bS2$vnQ8pe\u0012Lg.\u0019;pe2{\u0017\rZ5oO\u0016\u0013(o\u001c:)\u0007e\u0012)%\u0001\u000fuKN$\u0018\t\u001d9f]\u00124\u0015-\u001b7U_Vs7N\\8x]\u0016\u0013(o\u001c:)\u0007i\u0012)%A\u0013uKN$\b+\u001a8eS:<7\u000b^1uK:{GOU3tKR|eNU3uef\f\u0005\u000f]3oI\"\u001a1H!\u0012\u0002[Q,7\u000f^!qa\u0016tG\r\u0016:b]N\f7\r^5p]R{Gj\\4XQ&dW\r\u0015:pIV\u001cWM\u001d$f]\u000e,G\rK\u0002=\u0005\u000b\n!\u0007^3ti\u0006\u0003\b/\u001a8e)J\fgn]1di&|g\u000eV8M_\u001e<\u0006.\u001b7f!\u0016tG-\u001b8h'R\fG/Z\"iC:<W\r\u001a\u0015\u0004{\t\u0015\u0013aP:i_VdGMU3ukJtgj\u001c;D_>\u0014\u0018\u000e\u001a8bi>\u0014XI\u001d:pe&3GK]1og\u0006\u001cG/[8o\u0013\u0012\u0004\u0016M\u001d;ji&|gNT8u\u001f^tW\r\u001a\u0015\u0004}\t\u0015\u0013AN:i_VdGm\u00148ms\u000e{gn]5eKJ$&/\u00198tC\u000e$\u0018n\u001c8t\u0013:$\u0006.Z(oO>LgnZ*uCR,Gk\\!c_J$\bfA \u0003F\u0005A4\u000f[8vY\u0012<&/\u001b;f)btW*\u0019:lKJ\u001chi\u001c:Ue\u0006t7/Y2uS>t\u0017J\u001c)sKB\f'/\u001a3D_6l\u0017\u000e^*uCR,\u0007f\u0001!\u0003F\u000594\u000f[8vY\u0012<&/\u001b;f)btW*\u0019:lKJ\u001chi\u001c:Ue\u0006t7/Y2uS>t\u0017J\u001c)sKB\f'/\u001a3BE>\u0014Ho\u0015;bi\u0016D3!\u0011B#\u0003I\u001a\bn\\;mIJ+Wn\u001c<f\u0007>l\u0007\u000f\\3uK\u000e{W.\\7ji\u0016C\b/\u001b:fIR\u0013\u0018M\\:bGRLwN\\1m\u0013\u0012\u001c\bf\u0001\"\u0003F\u0005\u00014\u000f[8vY\u0012\u0014V-\\8wK\u000e{W\u000e\u001d7fi\u0016\f%m\u001c:u\u000bb\u0004\u0018N]3e)J\fgn]1di&|g.\u00197JIND3a\u0011B#\u0003!\u001a\bn\\;mIJ+Wn\u001c<f\u000b6\u0004H/_#ya&\u0014X\r\u001a+sC:\u001c\u0018m\u0019;j_:\fG.\u00133tQ\r!%QI\u00017g\"|W\u000f\u001c3O_R\u0014V-\\8wK\u0016C\b/\u001b:fIR\u0013\u0018M\\:bGRLwN\\1m\u0013\u0012\u001c\u0018J\u001a'pO\u0006\u0003\b/\u001a8e\r\u0006LGn\u001d\u0015\u0004\u000b\n\u0015\u0013AJ:i_VdGMT8u%\u0016lwN^3P]\u001e|\u0017N\\4Ue\u0006t7/Y2uS>t\u0017\r\\%eg\"\u001aaI!\u0012\u0002WMDw.\u001e7e\u001d>$(+Z7pm\u0016\u0004&/\u001a9be\u0016\f%m\u001c:u)J\fgn]1di&|g.\u00197JIND3a\u0012B#\u00031\u001a\bn\\;mI:{GOU3n_Z,\u0007K]3qCJ,7i\\7nSR$&/\u00198tC\u000e$\u0018n\u001c8bY&#7\u000fK\u0002I\u0005\u000b\n1\u0004^3tiN+8mY3tg\u001a,HNU3j[6LwM]1uS>t\u0007fA%\u0003F\u0005YC/Z:u\u0019>\fG\r\u0016:b]N\f7\r^5p]6+G/\u00193bi\u0006<\u0016\u000e\u001e5D_J\u0014X\u000f\u001d;fI2{w\rK\u0002K\u0005\u000b\n!E^3sS\u001aLX*\u001a;bI\u0006$\u0018\rR8fg\u0016C\u0018n\u001d;B]\u0012L5/V:bE2,G\u0003BAx\u0005gCqA!.L\u0001\u0004\tY*A\bue\u0006t7/Y2uS>t\u0017\r\\%e\u0003e1XM]5gs6+G/\u00193bi\u0006$u.Z:oi\u0016C\u0018n\u001d;\u0015\t\u0005=(1\u0018\u0005\b\u0005kc\u0005\u0019AAN\u0003\u0011\u001aX\r^;q\u0003:$'+\u001e8Ue\u0006t7/Y2uS>t\u0017\r\\%e\u000bb\u0004\u0018N]1uS>tGCBAx\u0005\u0003\u0014)\rC\u0004\u0003D6\u0003\rA!\u0003\u0002\u000b\u0015\u0014(o\u001c:\t\u000f\t\u001dW\n1\u0001\u0003J\u0006AA\u000f\u001f8Ti\u0006$X\rE\u0002i\u0005\u0017L1A!4X\u0005A!&/\u00198tC\u000e$\u0018n\u001c8Ti\u0006$X-\u0001\u0013wKJLg-_,sSR,7\u000f\u0016=o\u001b\u0006\u00148.\u001a:t\u0013:\u0004&/\u001a9be\u0016\u001cF/\u0019;f)\u0011\tyOa5\t\u000f\tUg\n1\u0001\u0003J\u0006)1\u000f^1uK\u0006q\u0011m]:feR\u001c\u0015\r\u001c7cC\u000e\\G\u0003BAx\u00057DqAa1P\u0001\u0004\u0011I!A\nue\u0006t7/Y2uS>tW*\u001a;bI\u0006$\u0018\r\u0006\u0006\u0002f\n\u0005(1\u001dBt\u0005SDqA!.Q\u0001\u0004\tY\nC\u0004\u0003fB\u0003\r!!7\u0002\u0015A\u0014x\u000eZ;dKJLE\rC\u0005\u0003VB\u0003\n\u00111\u0001\u0003J\"A!1\u001e)\u0011\u0002\u0003\u00071.\u0001\u0006uq:$\u0016.\\3pkR\fQ\u0004\u001e:b]N\f7\r^5p]6+G/\u00193bi\u0006$C-\u001a4bk2$HeM\u000b\u0003\u0005cTCA!3\u0003t.\u0012!Q\u001f\t\u0005\u0005o\u001c\t!\u0004\u0002\u0003z*!!1 B\u007f\u0003%)hn\u00195fG.,GMC\u0002\u0003\u0000\u0006\f!\"\u00198o_R\fG/[8o\u0013\u0011\u0019\u0019A!?\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-A\u000fue\u0006t7/Y2uS>tW*\u001a;bI\u0006$\u0018\r\n3fM\u0006,H\u000e\u001e\u00135+\t\u0019IAK\u0002l\u0005g\fQ\u0002\u001d:fa\u0006\u0014X\r\u0016=o\u0019><G\u0003CAx\u0007\u001f\u0019\tb!\u0006\t\u000bM\u001c\u0006\u0019A;\t\u000f\rM1\u000b1\u0001\u0002Z\u0006Y1\u000f^1si>3gm]3u\u0011\u001d\u00199b\u0015a\u0001\u00073\tqA]3d_J$7\u000f\u0005\u0003\u0002\u001e\rm\u0011\u0002BB\u000f\u0003?\u0011Q\"T3n_JL(+Z2pe\u0012\u001c\u0018A\u00079sKB\f'/\u001a$peRCh.T3tg\u0006<W-\u00119qK:$G\u0003BAx\u0007GAqAa1U\u0001\u0004\u0011I!A\fuKN$\b+\u0019:uSRLwN\u001c'pC\u0012lU\r\u001e:jG\"\u001aQK!\u0012")
public class TransactionStateManagerTest {
    private final int partitionId;
    private final int numPartitions;
    private final int transactionTimeoutMs;
    private final TopicPartition topicPartition = new TopicPartition("__transaction_state", this.partitionId());
    private final int coordinatorEpoch;
    private final ArrayBuffer<SimpleRecord> txnRecords = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
    private final MockTime time = new MockTime();
    private final MockScheduler scheduler = new MockScheduler((Time)this.time());
    private final KafkaZkClient zkClient = (KafkaZkClient)EasyMock.createNiceMock(KafkaZkClient.class);
    private final ReplicaManager replicaManager = (ReplicaManager)EasyMock.createNiceMock(ReplicaManager.class);
    private final Metrics metrics;
    private final TransactionConfig txnConfig;
    private final TransactionStateManager transactionManager;
    private final String transactionalId1;
    private final String transactionalId2;
    private final byte[] txnMessageKeyBytes1;
    private final byte[] txnMessageKeyBytes2;
    private final Map<String, Object> producerIds;
    private TransactionMetadata txnMetadata1;
    private TransactionMetadata txnMetadata2;
    private Errors expectedError;

    public int partitionId() {
        return this.partitionId;
    }

    public int numPartitions() {
        return this.numPartitions;
    }

    public int transactionTimeoutMs() {
        return this.transactionTimeoutMs;
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public int coordinatorEpoch() {
        return this.coordinatorEpoch;
    }

    public ArrayBuffer<SimpleRecord> txnRecords() {
        return this.txnRecords;
    }

    public MockTime time() {
        return this.time;
    }

    public MockScheduler scheduler() {
        return this.scheduler;
    }

    public KafkaZkClient zkClient() {
        return this.zkClient;
    }

    public ReplicaManager replicaManager() {
        return this.replicaManager;
    }

    public Metrics metrics() {
        return this.metrics;
    }

    public TransactionConfig txnConfig() {
        return this.txnConfig;
    }

    public TransactionStateManager transactionManager() {
        return this.transactionManager;
    }

    public String transactionalId1() {
        return this.transactionalId1;
    }

    public String transactionalId2() {
        return this.transactionalId2;
    }

    public byte[] txnMessageKeyBytes1() {
        return this.txnMessageKeyBytes1;
    }

    public byte[] txnMessageKeyBytes2() {
        return this.txnMessageKeyBytes2;
    }

    public Map<String, Object> producerIds() {
        return this.producerIds;
    }

    public TransactionMetadata txnMetadata1() {
        return this.txnMetadata1;
    }

    public void txnMetadata1_$eq(TransactionMetadata x$1) {
        this.txnMetadata1 = x$1;
    }

    public TransactionMetadata txnMetadata2() {
        return this.txnMetadata2;
    }

    public void txnMetadata2_$eq(TransactionMetadata x$1) {
        this.txnMetadata2 = x$1;
    }

    public Errors expectedError() {
        return this.expectedError;
    }

    public void expectedError_$eq(Errors x$1) {
        this.expectedError = x$1;
    }

    @BeforeEach
    public void setUp() {
        this.transactionManager().startup((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> this.numPartitions(), false);
        Assertions.assertEquals((int)this.partitionId(), (int)this.transactionManager().partitionFor(this.transactionalId1()));
        Assertions.assertEquals((int)this.partitionId(), (int)this.transactionManager().partitionFor(this.transactionalId2()));
    }

    @AfterEach
    public void tearDown() {
        EasyMock.reset((Object[])new Object[]{this.zkClient(), this.replicaManager()});
        this.transactionManager().shutdown();
    }

    @Test
    public void testValidateTransactionTimeout() {
        Assertions.assertTrue((boolean)this.transactionManager().validateTransactionTimeoutMs(1));
        Assertions.assertFalse((boolean)this.transactionManager().validateTransactionTimeoutMs(-1));
        Assertions.assertFalse((boolean)this.transactionManager().validateTransactionTimeoutMs(0));
        Assertions.assertTrue((boolean)this.transactionManager().validateTransactionTimeoutMs(this.txnConfig().transactionMaxTimeoutMs()));
        Assertions.assertFalse((boolean)this.transactionManager().validateTransactionTimeoutMs(this.txnConfig().transactionMaxTimeoutMs() + 1));
    }

    @Test
    public void testAddGetPids() {
        this.transactionManager().addLoadedTransactionsToCache(this.partitionId(), this.coordinatorEpoch(), new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1()));
        Assertions.assertEquals((Object)package$.MODULE$.Right().apply((Object)None$.MODULE$), (Object)this.transactionManager().getTransactionState(this.transactionalId1()));
        Assertions.assertEquals((Object)package$.MODULE$.Right().apply((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), this.txnMetadata1())), (Object)this.transactionManager().putTransactionStateIfNotExists(this.txnMetadata1()));
        Assertions.assertEquals((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), this.txnMetadata1()))), (Object)this.transactionManager().getTransactionState(this.transactionalId1()));
        Assertions.assertEquals((Object)package$.MODULE$.Right().apply((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), this.txnMetadata2())), (Object)this.transactionManager().putTransactionStateIfNotExists(this.txnMetadata2()));
    }

    @Test
    public void testDeletePartition() {
        TransactionMetadata metadata1 = this.transactionMetadata("b", 5L, this.transactionMetadata$default$3(), this.transactionMetadata$default$4());
        TransactionMetadata metadata2 = this.transactionMetadata("a", 10L, this.transactionMetadata$default$3(), this.transactionMetadata$default$4());
        Assertions.assertEquals((int)0, (int)this.transactionManager().partitionFor(metadata1.transactionalId()));
        Assertions.assertEquals((int)1, (int)this.transactionManager().partitionFor(metadata2.transactionalId()));
        this.transactionManager().addLoadedTransactionsToCache(0, this.coordinatorEpoch(), new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1()));
        this.transactionManager().putTransactionStateIfNotExists(metadata1);
        this.transactionManager().addLoadedTransactionsToCache(1, this.coordinatorEpoch(), new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1()));
        this.transactionManager().putTransactionStateIfNotExists(metadata2);
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToShort((short)metadata1.producerEpoch())), (Object)this.cachedProducerEpoch$1(metadata1.transactionalId()));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToShort((short)metadata2.producerEpoch())), (Object)this.cachedProducerEpoch$1(metadata2.transactionalId()));
        this.transactionManager().removeTransactionsForTxnTopicPartition(0);
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.cachedProducerEpoch$1(metadata1.transactionalId()));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToShort((short)metadata2.producerEpoch())), (Object)this.cachedProducerEpoch$1(metadata2.transactionalId()));
    }

    @Test
    public void testDeleteLoadingPartition() {
        long startOffset = 0L;
        long endOffset = 1L;
        FileRecords fileRecordsMock = (FileRecords)EasyMock.mock(FileRecords.class);
        Log logMock = (Log)EasyMock.mock(Log.class);
        EasyMock.expect((Object)this.replicaManager().getLog(this.topicPartition())).andStubReturn((Object)new Some((Object)logMock));
        EasyMock.expect((Object)BoxesRunTime.boxToLong((long)logMock.logStartOffset())).andStubReturn((Object)BoxesRunTime.boxToLong((long)startOffset));
        EasyMock.expect((Object)logMock.read(EasyMock.eq((long)startOffset), EasyMock.anyInt(), (FetchIsolation)EasyMock.eq((Object)FetchLogEnd$.MODULE$), EasyMock.eq((boolean)true))).andReturn((Object)new FetchDataInfo(new LogOffsetMetadata(startOffset, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), (Records)fileRecordsMock, FetchDataInfo$.MODULE$.apply$default$3(), FetchDataInfo$.MODULE$.apply$default$4()));
        EasyMock.expect((Object)this.replicaManager().getLogEndOffset(this.topicPartition())).andStubReturn((Object)new Some((Object)BoxesRunTime.boxToLong((long)endOffset)));
        this.txnMetadata1().state_$eq((TransactionState)PrepareCommit$.MODULE$);
        this.txnMetadata1().addPartitions((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic1", 0), new TopicPartition("topic1", 1)})));
        MemoryRecords records = MemoryRecords.withRecords((long)startOffset, (CompressionType)CompressionType.NONE, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(this.txnMessageKeyBytes1(), TransactionLog$.MODULE$.valueToBytes(this.txnMetadata1().prepareNoTransit()))});
        CountDownLatch latch = new CountDownLatch(1);
        EasyMock.expect((Object)BoxesRunTime.boxToInteger((int)fileRecordsMock.sizeInBytes())).andStubReturn((Object)BoxesRunTime.boxToInteger((int)records.sizeInBytes()));
        Capture bufferCapture = EasyMock.newCapture();
        fileRecordsMock.readInto((ByteBuffer)EasyMock.capture((Capture)bufferCapture), EasyMock.anyInt());
        EasyMock.expectLastCall().andAnswer((IAnswer)new IAnswer<BoxedUnit>(null, latch, bufferCapture, records){
            private final CountDownLatch latch$1;
            private final Capture bufferCapture$1;
            private final MemoryRecords records$1;

            public void answer() {
                this.latch$1.await();
                ByteBuffer buffer = (ByteBuffer)this.bufferCapture$1.getValue();
                buffer.put(this.records$1.buffer().duplicate());
                buffer.flip();
            }
            {
                this.latch$1 = latch$1;
                this.bufferCapture$1 = bufferCapture$1;
                this.records$1 = records$1;
            }
        });
        EasyMock.replay((Object[])new Object[]{logMock, fileRecordsMock, this.replicaManager()});
        int coordinatorEpoch = 0;
        TransactionPartitionAndLeaderEpoch partitionAndLeaderEpoch = new TransactionPartitionAndLeaderEpoch(this.partitionId(), coordinatorEpoch);
        Thread loadingThread = new Thread(() -> this.transactionManager().loadTransactionsForTxnTopicPartition(this.partitionId(), coordinatorEpoch, (Function4 & Serializable & scala.Serializable)(x$2, x$3, x$4, x$5) -> {
            TransactionStateManagerTest.$anonfun$testDeleteLoadingPartition$2(BoxesRunTime.unboxToInt((Object)x$2), x$3, x$4, x$5);
            return BoxedUnit.UNIT;
        }));
        loadingThread.start();
        long x$3 = 10L;
        long x$4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TransactionStateManagerTest.$anonfun$testDeleteLoadingPartition$3(this, partitionAndLeaderEpoch)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + x$4) {
                Assertions.fail((String)TransactionStateManagerTest.$anonfun$testDeleteLoadingPartition$4());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(x$4), x$3));
        }
        this.transactionManager().removeTransactionsForTxnTopicPartition(this.partitionId());
        Assertions.assertFalse((boolean)this.transactionManager().loadingPartitions().contains((Object)partitionAndLeaderEpoch));
        latch.countDown();
        loadingThread.join();
        Assertions.assertEquals((Object)package$.MODULE$.Left().apply((Object)Errors.NOT_COORDINATOR), (Object)this.transactionManager().getTransactionState(this.txnMetadata1().transactionalId()));
    }

    @Test
    public void testLoadAndRemoveTransactionsForPartition() {
        this.txnMetadata1().state_$eq((TransactionState)Ongoing$.MODULE$);
        this.txnMetadata1().addPartitions((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic1", 0), new TopicPartition("topic1", 1)})));
        this.txnRecords().$plus$eq((Object)new SimpleRecord(this.txnMessageKeyBytes1(), TransactionLog$.MODULE$.valueToBytes(this.txnMetadata1().prepareNoTransit())));
        this.txnMetadata1().addPartitions((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic2", 0), new TopicPartition("topic2", 1), new TopicPartition("topic2", 2)})));
        this.txnRecords().$plus$eq((Object)new SimpleRecord(this.txnMessageKeyBytes1(), TransactionLog$.MODULE$.valueToBytes(this.txnMetadata1().prepareNoTransit())));
        this.txnMetadata1().state_$eq((TransactionState)PrepareCommit$.MODULE$);
        this.txnRecords().$plus$eq((Object)new SimpleRecord(this.txnMessageKeyBytes1(), TransactionLog$.MODULE$.valueToBytes(this.txnMetadata1().prepareNoTransit())));
        this.txnMetadata2().state_$eq((TransactionState)Ongoing$.MODULE$);
        this.txnMetadata2().addPartitions((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic3", 0), new TopicPartition("topic3", 1), new TopicPartition("topic3", 2)})));
        this.txnRecords().$plus$eq((Object)new SimpleRecord(this.txnMessageKeyBytes2(), TransactionLog$.MODULE$.valueToBytes(this.txnMetadata2().prepareNoTransit())));
        this.txnMetadata2().state_$eq((TransactionState)PrepareAbort$.MODULE$);
        this.txnRecords().$plus$eq((Object)new SimpleRecord(this.txnMessageKeyBytes2(), TransactionLog$.MODULE$.valueToBytes(this.txnMetadata2().prepareNoTransit())));
        this.txnMetadata2().state_$eq((TransactionState)CompleteAbort$.MODULE$);
        this.txnRecords().$plus$eq((Object)new SimpleRecord(this.txnMessageKeyBytes2(), TransactionLog$.MODULE$.valueToBytes(this.txnMetadata2().prepareNoTransit())));
        this.txnMetadata2().state_$eq((TransactionState)Empty$.MODULE$);
        this.txnMetadata2().topicPartitions().clear();
        this.txnRecords().$plus$eq((Object)new SimpleRecord(this.txnMessageKeyBytes2(), TransactionLog$.MODULE$.valueToBytes(this.txnMetadata2().prepareNoTransit())));
        long startOffset = 15L;
        MemoryRecords records = MemoryRecords.withRecords((long)startOffset, (CompressionType)CompressionType.NONE, (SimpleRecord[])((SimpleRecord[])this.txnRecords().toArray(ClassTag$.MODULE$.apply(SimpleRecord.class))));
        this.prepareTxnLog(this.topicPartition(), startOffset, records);
        this.transactionManager().getTransactionState(this.transactionalId1()).fold((Function1 & Serializable & scala.Serializable)err -> {
            TransactionStateManagerTest.$anonfun$testLoadAndRemoveTransactionsForPartition$1(err);
            return BoxedUnit.UNIT;
        }, (Function1 & Serializable & scala.Serializable)x$6 -> (Nothing$)Assertions.fail((String)new StringBuilder(44).append(this.transactionalId1()).append("'s transaction state is already in the cache").toString()));
        this.transactionManager().getTransactionState(this.transactionalId2()).fold((Function1 & Serializable & scala.Serializable)err -> {
            TransactionStateManagerTest.$anonfun$testLoadAndRemoveTransactionsForPartition$3(err);
            return BoxedUnit.UNIT;
        }, (Function1 & Serializable & scala.Serializable)x$7 -> (Nothing$)Assertions.fail((String)new StringBuilder(44).append(this.transactionalId2()).append("'s transaction state is already in the cache").toString()));
        this.transactionManager().loadTransactionsForTxnTopicPartition(this.partitionId(), 0, (Function4 & Serializable & scala.Serializable)(x$8, x$9, x$10, x$11) -> {
            TransactionStateManagerTest.$anonfun$testLoadAndRemoveTransactionsForPartition$5(BoxesRunTime.unboxToInt((Object)x$8), x$9, x$10, x$11);
            return BoxedUnit.UNIT;
        });
        this.scheduler().tick();
        this.transactionManager().getTransactionState(this.transactionalId1()).fold((Function1 & Serializable & scala.Serializable)err -> (Nothing$)Assertions.fail((String)new StringBuilder(42).append(this.transactionalId1()).append("'s transaction state access returns error ").append(err).toString()), (Function1 & Serializable & scala.Serializable)entry -> (CoordinatorEpochAndTxnMetadata)entry.getOrElse((Function0 & Serializable & scala.Serializable)() -> (Nothing$)Assertions.fail((String)new StringBuilder(50).append(this.transactionalId1()).append("'s transaction state was not loaded into the cache").toString())));
        CoordinatorEpochAndTxnMetadata cachedPidMetadata1 = (CoordinatorEpochAndTxnMetadata)this.transactionManager().getTransactionState(this.transactionalId1()).fold((Function1 & Serializable & scala.Serializable)err -> {
            throw new AssertionError((Object)new StringBuilder(42).append(this.transactionalId1()).append("'s transaction state access returns error ").append(err).toString());
        }, (Function1 & Serializable & scala.Serializable)entry -> (CoordinatorEpochAndTxnMetadata)entry.getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new AssertionError((Object)new StringBuilder(50).append(this.transactionalId1()).append("'s transaction state was not loaded into the cache").toString());
        }));
        CoordinatorEpochAndTxnMetadata cachedPidMetadata2 = (CoordinatorEpochAndTxnMetadata)this.transactionManager().getTransactionState(this.transactionalId2()).fold((Function1 & Serializable & scala.Serializable)err -> {
            throw new AssertionError((Object)new StringBuilder(42).append(this.transactionalId2()).append("'s transaction state access returns error ").append(err).toString());
        }, (Function1 & Serializable & scala.Serializable)entry -> (CoordinatorEpochAndTxnMetadata)entry.getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new AssertionError((Object)new StringBuilder(50).append(this.transactionalId2()).append("'s transaction state was not loaded into the cache").toString());
        }));
        Assertions.assertEquals((Object)this.txnMetadata1(), (Object)cachedPidMetadata1.transactionMetadata());
        Assertions.assertEquals((Object)this.txnMetadata2(), (Object)cachedPidMetadata2.transactionMetadata());
        this.transactionManager().removeTransactionsForTxnTopicPartition(this.partitionId(), this.coordinatorEpoch());
        this.scheduler().tick();
        this.transactionManager().getTransactionState(this.transactionalId1()).fold((Function1 & Serializable & scala.Serializable)err -> {
            TransactionStateManagerTest.$anonfun$testLoadAndRemoveTransactionsForPartition$15(err);
            return BoxedUnit.UNIT;
        }, (Function1 & Serializable & scala.Serializable)x$12 -> (Nothing$)Assertions.fail((String)new StringBuilder(42).append(this.transactionalId1()).append("'s transaction state is still in the cache").toString()));
        this.transactionManager().getTransactionState(this.transactionalId2()).fold((Function1 & Serializable & scala.Serializable)err -> {
            TransactionStateManagerTest.$anonfun$testLoadAndRemoveTransactionsForPartition$17(err);
            return BoxedUnit.UNIT;
        }, (Function1 & Serializable & scala.Serializable)x$13 -> (Nothing$)Assertions.fail((String)new StringBuilder(42).append(this.transactionalId2()).append("'s transaction state is still in the cache").toString()));
    }

    @Test
    public void testCompleteTransitionWhenAppendSucceeded() {
        this.transactionManager().addLoadedTransactionsToCache(this.partitionId(), this.coordinatorEpoch(), new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1()));
        this.transactionManager().putTransactionStateIfNotExists(this.txnMetadata1());
        this.prepareForTxnMessageAppend(Errors.NONE);
        this.expectedError_$eq(Errors.NONE);
        TxnTransitMetadata newMetadata = this.txnMetadata1().prepareAddPartitions((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic1", 0), new TopicPartition("topic1", 1)})), this.time().milliseconds());
        this.transactionManager().appendTransactionToLog(this.transactionalId1(), this.coordinatorEpoch(), newMetadata, (Function1 & Serializable & scala.Serializable)error -> {
            this.assertCallback(error);
            return BoxedUnit.UNIT;
        }, this.transactionManager().appendTransactionToLog$default$5());
        Assertions.assertEquals((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), this.txnMetadata1()))), (Object)this.transactionManager().getTransactionState(this.transactionalId1()));
        Assertions.assertTrue((boolean)this.txnMetadata1().pendingState().isEmpty());
    }

    @Test
    public void testAppendFailToCoordinatorNotAvailableError() {
        this.transactionManager().addLoadedTransactionsToCache(this.partitionId(), this.coordinatorEpoch(), new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1()));
        this.transactionManager().putTransactionStateIfNotExists(this.txnMetadata1());
        this.expectedError_$eq(Errors.COORDINATOR_NOT_AVAILABLE);
        TxnTransitMetadata failedMetadata = this.txnMetadata1().prepareAddPartitions((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic2", 0)})), this.time().milliseconds());
        this.prepareForTxnMessageAppend(Errors.UNKNOWN_TOPIC_OR_PARTITION);
        this.transactionManager().appendTransactionToLog(this.transactionalId1(), 10, failedMetadata, (Function1 & Serializable & scala.Serializable)error -> {
            this.assertCallback(error);
            return BoxedUnit.UNIT;
        }, this.transactionManager().appendTransactionToLog$default$5());
        Assertions.assertEquals((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), this.txnMetadata1()))), (Object)this.transactionManager().getTransactionState(this.transactionalId1()));
        Assertions.assertTrue((boolean)this.txnMetadata1().pendingState().isEmpty());
        failedMetadata = this.txnMetadata1().prepareAddPartitions((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic2", 0)})), this.time().milliseconds());
        this.prepareForTxnMessageAppend(Errors.NOT_ENOUGH_REPLICAS);
        this.transactionManager().appendTransactionToLog(this.transactionalId1(), 10, failedMetadata, (Function1 & Serializable & scala.Serializable)error -> {
            this.assertCallback(error);
            return BoxedUnit.UNIT;
        }, this.transactionManager().appendTransactionToLog$default$5());
        Assertions.assertEquals((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), this.txnMetadata1()))), (Object)this.transactionManager().getTransactionState(this.transactionalId1()));
        Assertions.assertTrue((boolean)this.txnMetadata1().pendingState().isEmpty());
        failedMetadata = this.txnMetadata1().prepareAddPartitions((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic2", 0)})), this.time().milliseconds());
        this.prepareForTxnMessageAppend(Errors.NOT_ENOUGH_REPLICAS_AFTER_APPEND);
        this.transactionManager().appendTransactionToLog(this.transactionalId1(), 10, failedMetadata, (Function1 & Serializable & scala.Serializable)error -> {
            this.assertCallback(error);
            return BoxedUnit.UNIT;
        }, this.transactionManager().appendTransactionToLog$default$5());
        Assertions.assertEquals((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), this.txnMetadata1()))), (Object)this.transactionManager().getTransactionState(this.transactionalId1()));
        Assertions.assertTrue((boolean)this.txnMetadata1().pendingState().isEmpty());
        failedMetadata = this.txnMetadata1().prepareAddPartitions((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic2", 0)})), this.time().milliseconds());
        this.prepareForTxnMessageAppend(Errors.REQUEST_TIMED_OUT);
        this.transactionManager().appendTransactionToLog(this.transactionalId1(), 10, failedMetadata, (Function1 & Serializable & scala.Serializable)error -> {
            this.assertCallback(error);
            return BoxedUnit.UNIT;
        }, this.transactionManager().appendTransactionToLog$default$5());
        Assertions.assertEquals((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), this.txnMetadata1()))), (Object)this.transactionManager().getTransactionState(this.transactionalId1()));
        Assertions.assertTrue((boolean)this.txnMetadata1().pendingState().isEmpty());
    }

    @Test
    public void testAppendFailToNotCoordinatorError() {
        this.transactionManager().addLoadedTransactionsToCache(this.partitionId(), this.coordinatorEpoch(), new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1()));
        this.transactionManager().putTransactionStateIfNotExists(this.txnMetadata1());
        this.expectedError_$eq(Errors.NOT_COORDINATOR);
        TxnTransitMetadata failedMetadata = this.txnMetadata1().prepareAddPartitions((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic2", 0)})), this.time().milliseconds());
        this.prepareForTxnMessageAppend(Errors.NOT_LEADER_OR_FOLLOWER);
        this.transactionManager().appendTransactionToLog(this.transactionalId1(), 10, failedMetadata, (Function1 & Serializable & scala.Serializable)error -> {
            this.assertCallback(error);
            return BoxedUnit.UNIT;
        }, this.transactionManager().appendTransactionToLog$default$5());
        Assertions.assertEquals((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), this.txnMetadata1()))), (Object)this.transactionManager().getTransactionState(this.transactionalId1()));
        Assertions.assertTrue((boolean)this.txnMetadata1().pendingState().isEmpty());
        failedMetadata = this.txnMetadata1().prepareAddPartitions((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic2", 0)})), this.time().milliseconds());
        this.prepareForTxnMessageAppend(Errors.NONE);
        this.transactionManager().removeTransactionsForTxnTopicPartition(this.partitionId(), this.coordinatorEpoch());
        this.transactionManager().appendTransactionToLog(this.transactionalId1(), 10, failedMetadata, (Function1 & Serializable & scala.Serializable)error -> {
            this.assertCallback(error);
            return BoxedUnit.UNIT;
        }, this.transactionManager().appendTransactionToLog$default$5());
        this.prepareForTxnMessageAppend(Errors.NONE);
        this.transactionManager().removeTransactionsForTxnTopicPartition(this.partitionId(), this.coordinatorEpoch());
        this.transactionManager().addLoadedTransactionsToCache(this.partitionId(), this.coordinatorEpoch() + 1, new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1()));
        this.transactionManager().putTransactionStateIfNotExists(this.txnMetadata1());
        this.transactionManager().appendTransactionToLog(this.transactionalId1(), 10, failedMetadata, (Function1 & Serializable & scala.Serializable)error -> {
            this.assertCallback(error);
            return BoxedUnit.UNIT;
        }, this.transactionManager().appendTransactionToLog$default$5());
        this.prepareForTxnMessageAppend(Errors.NONE);
        this.transactionManager().removeTransactionsForTxnTopicPartition(this.partitionId(), this.coordinatorEpoch());
        this.transactionManager().addLoadedTransactionsToCache(this.partitionId(), this.coordinatorEpoch(), new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1()));
        this.transactionManager().appendTransactionToLog(this.transactionalId1(), 10, failedMetadata, (Function1 & Serializable & scala.Serializable)error -> {
            this.assertCallback(error);
            return BoxedUnit.UNIT;
        }, this.transactionManager().appendTransactionToLog$default$5());
    }

    @Test
    public void testAppendFailToCoordinatorLoadingError() {
        this.transactionManager().addLoadedTransactionsToCache(this.partitionId(), this.coordinatorEpoch(), new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1()));
        this.transactionManager().putTransactionStateIfNotExists(this.txnMetadata1());
        this.expectedError_$eq(Errors.COORDINATOR_LOAD_IN_PROGRESS);
        TxnTransitMetadata failedMetadata = this.txnMetadata1().prepareAddPartitions((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic2", 0)})), this.time().milliseconds());
        this.prepareForTxnMessageAppend(Errors.NONE);
        this.transactionManager().removeTransactionsForTxnTopicPartition(this.partitionId(), this.coordinatorEpoch());
        this.transactionManager().addLoadingPartition(this.partitionId(), this.coordinatorEpoch() + 1);
        this.transactionManager().appendTransactionToLog(this.transactionalId1(), 10, failedMetadata, (Function1 & Serializable & scala.Serializable)error -> {
            this.assertCallback(error);
            return BoxedUnit.UNIT;
        }, this.transactionManager().appendTransactionToLog$default$5());
    }

    @Test
    public void testAppendFailToUnknownError() {
        this.transactionManager().addLoadedTransactionsToCache(this.partitionId(), this.coordinatorEpoch(), new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1()));
        this.transactionManager().putTransactionStateIfNotExists(this.txnMetadata1());
        this.expectedError_$eq(Errors.UNKNOWN_SERVER_ERROR);
        TxnTransitMetadata failedMetadata = this.txnMetadata1().prepareAddPartitions((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic2", 0)})), this.time().milliseconds());
        this.prepareForTxnMessageAppend(Errors.MESSAGE_TOO_LARGE);
        this.transactionManager().appendTransactionToLog(this.transactionalId1(), 10, failedMetadata, (Function1 & Serializable & scala.Serializable)error -> {
            this.assertCallback(error);
            return BoxedUnit.UNIT;
        }, this.transactionManager().appendTransactionToLog$default$5());
        Assertions.assertEquals((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), this.txnMetadata1()))), (Object)this.transactionManager().getTransactionState(this.transactionalId1()));
        Assertions.assertTrue((boolean)this.txnMetadata1().pendingState().isEmpty());
        failedMetadata = this.txnMetadata1().prepareAddPartitions((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic2", 0)})), this.time().milliseconds());
        this.prepareForTxnMessageAppend(Errors.RECORD_LIST_TOO_LARGE);
        this.transactionManager().appendTransactionToLog(this.transactionalId1(), 10, failedMetadata, (Function1 & Serializable & scala.Serializable)error -> {
            this.assertCallback(error);
            return BoxedUnit.UNIT;
        }, this.transactionManager().appendTransactionToLog$default$5());
        Assertions.assertEquals((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), this.txnMetadata1()))), (Object)this.transactionManager().getTransactionState(this.transactionalId1()));
        Assertions.assertTrue((boolean)this.txnMetadata1().pendingState().isEmpty());
    }

    @Test
    public void testPendingStateNotResetOnRetryAppend() {
        this.transactionManager().addLoadedTransactionsToCache(this.partitionId(), this.coordinatorEpoch(), new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1()));
        this.transactionManager().putTransactionStateIfNotExists(this.txnMetadata1());
        this.expectedError_$eq(Errors.COORDINATOR_NOT_AVAILABLE);
        TxnTransitMetadata failedMetadata = this.txnMetadata1().prepareAddPartitions((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic2", 0)})), this.time().milliseconds());
        this.prepareForTxnMessageAppend(Errors.UNKNOWN_TOPIC_OR_PARTITION);
        this.transactionManager().appendTransactionToLog(this.transactionalId1(), 10, failedMetadata, (Function1 & Serializable & scala.Serializable)error -> {
            this.assertCallback(error);
            return BoxedUnit.UNIT;
        }, (Function1 & Serializable & scala.Serializable)x$14 -> BoxesRunTime.boxToBoolean((boolean)TransactionStateManagerTest.$anonfun$testPendingStateNotResetOnRetryAppend$2(x$14)));
        Assertions.assertEquals((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), this.txnMetadata1()))), (Object)this.transactionManager().getTransactionState(this.transactionalId1()));
        Assertions.assertEquals((Object)new Some((Object)Ongoing$.MODULE$), (Object)this.txnMetadata1().pendingState());
    }

    @Test
    public void testAppendTransactionToLogWhileProducerFenced() {
        this.transactionManager().addLoadedTransactionsToCache(this.partitionId(), 0, new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1()));
        this.transactionManager().putTransactionStateIfNotExists(this.txnMetadata1());
        this.prepareForTxnMessageAppend(Errors.NONE);
        this.expectedError_$eq(Errors.NOT_COORDINATOR);
        TxnTransitMetadata newMetadata = this.txnMetadata1().prepareAddPartitions((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic1", 0), new TopicPartition("topic1", 1)})), this.time().milliseconds());
        this.txnMetadata1().producerEpoch_$eq((short)(this.txnMetadata1().producerEpoch() + 1));
        this.transactionManager().appendTransactionToLog(this.transactionalId1(), 10, newMetadata, (Function1 & Serializable & scala.Serializable)error -> {
            this.assertCallback(error);
            return BoxedUnit.UNIT;
        }, this.transactionManager().appendTransactionToLog$default$5());
    }

    @Test
    public void testAppendTransactionToLogWhilePendingStateChanged() {
        this.transactionManager().addLoadedTransactionsToCache(this.partitionId(), this.coordinatorEpoch(), new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1()));
        this.transactionManager().putTransactionStateIfNotExists(this.txnMetadata1());
        this.prepareForTxnMessageAppend(Errors.NONE);
        this.expectedError_$eq(Errors.INVALID_PRODUCER_EPOCH);
        TxnTransitMetadata newMetadata = this.txnMetadata1().prepareAddPartitions((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic1", 0), new TopicPartition("topic1", 1)})), this.time().milliseconds());
        this.txnMetadata1().pendingState_$eq((Option)None$.MODULE$);
        Assertions.assertThrows(IllegalStateException.class, () -> this.transactionManager().appendTransactionToLog(this.transactionalId1(), 10, newMetadata, (Function1 & Serializable & scala.Serializable)error -> {
            this.assertCallback(error);
            return BoxedUnit.UNIT;
        }, this.transactionManager().appendTransactionToLog$default$5()));
    }

    @Test
    public void shouldReturnNotCooridnatorErrorIfTransactionIdPartitionNotOwned() {
        this.transactionManager().getTransactionState(this.transactionalId1()).fold((Function1 & Serializable & scala.Serializable)err -> {
            TransactionStateManagerTest.$anonfun$shouldReturnNotCooridnatorErrorIfTransactionIdPartitionNotOwned$1(err);
            return BoxedUnit.UNIT;
        }, (Function1 & Serializable & scala.Serializable)x$15 -> (Nothing$)Assertions.fail((String)new StringBuilder(44).append(this.transactionalId1()).append("'s transaction state is already in the cache").toString()));
    }

    @Test
    public void shouldOnlyConsiderTransactionsInTheOngoingStateToAbort() {
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.numPartitions()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)partitionId -> this.transactionManager().addLoadedTransactionsToCache(partitionId, 0, new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1())));
        this.transactionManager().putTransactionStateIfNotExists(this.transactionMetadata("ongoing", 0L, (TransactionState)Ongoing$.MODULE$, this.transactionMetadata$default$4()));
        this.transactionManager().putTransactionStateIfNotExists(this.transactionMetadata("not-expiring", 1L, (TransactionState)Ongoing$.MODULE$, 10000));
        this.transactionManager().putTransactionStateIfNotExists(this.transactionMetadata("prepare-commit", 2L, (TransactionState)PrepareCommit$.MODULE$, this.transactionMetadata$default$4()));
        this.transactionManager().putTransactionStateIfNotExists(this.transactionMetadata("prepare-abort", 3L, (TransactionState)PrepareAbort$.MODULE$, this.transactionMetadata$default$4()));
        this.transactionManager().putTransactionStateIfNotExists(this.transactionMetadata("complete-commit", 4L, (TransactionState)CompleteCommit$.MODULE$, this.transactionMetadata$default$4()));
        this.transactionManager().putTransactionStateIfNotExists(this.transactionMetadata("complete-abort", 5L, (TransactionState)CompleteAbort$.MODULE$, this.transactionMetadata$default$4()));
        this.time().sleep(2000L);
        Iterable expiring = this.transactionManager().timedOutTransactions();
        Assertions.assertEquals((Object)new .colon.colon((Object)new TransactionalIdAndProducerIdEpoch("ongoing", 0L, 0), (List)Nil$.MODULE$), (Object)expiring);
    }

    @Test
    public void shouldWriteTxnMarkersForTransactionInPreparedCommitState() {
        this.verifyWritesTxnMarkersInPrepareState((TransactionState)PrepareCommit$.MODULE$);
    }

    @Test
    public void shouldWriteTxnMarkersForTransactionInPreparedAbortState() {
        this.verifyWritesTxnMarkersInPrepareState((TransactionState)PrepareAbort$.MODULE$);
    }

    @Test
    public void shouldRemoveCompleteCommmitExpiredTransactionalIds() {
        this.setupAndRunTransactionalIdExpiration(Errors.NONE, (TransactionState)CompleteCommit$.MODULE$);
        this.verifyMetadataDoesntExist(this.transactionalId1());
        this.verifyMetadataDoesExistAndIsUsable(this.transactionalId2());
    }

    @Test
    public void shouldRemoveCompleteAbortExpiredTransactionalIds() {
        this.setupAndRunTransactionalIdExpiration(Errors.NONE, (TransactionState)CompleteAbort$.MODULE$);
        this.verifyMetadataDoesntExist(this.transactionalId1());
        this.verifyMetadataDoesExistAndIsUsable(this.transactionalId2());
    }

    @Test
    public void shouldRemoveEmptyExpiredTransactionalIds() {
        this.setupAndRunTransactionalIdExpiration(Errors.NONE, (TransactionState)Empty$.MODULE$);
        this.verifyMetadataDoesntExist(this.transactionalId1());
        this.verifyMetadataDoesExistAndIsUsable(this.transactionalId2());
    }

    @Test
    public void shouldNotRemoveExpiredTransactionalIdsIfLogAppendFails() {
        this.setupAndRunTransactionalIdExpiration(Errors.NOT_ENOUGH_REPLICAS, (TransactionState)CompleteAbort$.MODULE$);
        this.verifyMetadataDoesExistAndIsUsable(this.transactionalId1());
        this.verifyMetadataDoesExistAndIsUsable(this.transactionalId2());
    }

    @Test
    public void shouldNotRemoveOngoingTransactionalIds() {
        this.setupAndRunTransactionalIdExpiration(Errors.NONE, (TransactionState)Ongoing$.MODULE$);
        this.verifyMetadataDoesExistAndIsUsable(this.transactionalId1());
        this.verifyMetadataDoesExistAndIsUsable(this.transactionalId2());
    }

    @Test
    public void shouldNotRemovePrepareAbortTransactionalIds() {
        this.setupAndRunTransactionalIdExpiration(Errors.NONE, (TransactionState)PrepareAbort$.MODULE$);
        this.verifyMetadataDoesExistAndIsUsable(this.transactionalId1());
        this.verifyMetadataDoesExistAndIsUsable(this.transactionalId2());
    }

    @Test
    public void shouldNotRemovePrepareCommitTransactionalIds() {
        this.setupAndRunTransactionalIdExpiration(Errors.NONE, (TransactionState)PrepareCommit$.MODULE$);
        this.verifyMetadataDoesExistAndIsUsable(this.transactionalId1());
        this.verifyMetadataDoesExistAndIsUsable(this.transactionalId2());
    }

    @Test
    public void testSuccessfulReimmigration() {
        this.txnMetadata1().state_$eq((TransactionState)PrepareCommit$.MODULE$);
        this.txnMetadata1().addPartitions((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic1", 0), new TopicPartition("topic1", 1)})));
        this.txnRecords().$plus$eq((Object)new SimpleRecord(this.txnMessageKeyBytes1(), TransactionLog$.MODULE$.valueToBytes(this.txnMetadata1().prepareNoTransit())));
        MemoryRecords records = MemoryRecords.withRecords((long)0L, (CompressionType)CompressionType.NONE, (SimpleRecord[])((SimpleRecord[])this.txnRecords().toArray(ClassTag$.MODULE$.apply(SimpleRecord.class))));
        this.prepareTxnLog(this.topicPartition(), 0L, records);
        this.transactionManager().loadTransactionsForTxnTopicPartition(this.partitionId(), 0, (Function4 & Serializable & scala.Serializable)(x$16, x$17, x$18, x$19) -> {
            TransactionStateManagerTest.$anonfun$testSuccessfulReimmigration$1(BoxesRunTime.unboxToInt((Object)x$16), x$17, x$18, x$19);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((int)0, (int)this.transactionManager().loadingPartitions().size());
        this.prepareTxnLog(this.topicPartition(), 0L, records);
        this.transactionManager().loadTransactionsForTxnTopicPartition(this.partitionId(), 1, (Function4 & Serializable & scala.Serializable)(x$20, x$21, x$22, x$23) -> {
            TransactionStateManagerTest.$anonfun$testSuccessfulReimmigration$2(BoxesRunTime.unboxToInt((Object)x$20), x$21, x$22, x$23);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((int)0, (int)this.transactionManager().loadingPartitions().size());
        Assertions.assertTrue((boolean)this.transactionManager().transactionMetadataCache().get((Object)BoxesRunTime.boxToInteger((int)this.partitionId())).isDefined());
        Assertions.assertEquals((int)1, (int)((TxnMetadataCacheEntry)this.transactionManager().transactionMetadataCache().get((Object)BoxesRunTime.boxToInteger((int)this.partitionId())).get()).coordinatorEpoch());
    }

    @Test
    public void testLoadTransactionMetadataWithCorruptedLog() {
        long startOffset = 0L;
        long endOffset = 10L;
        Log logMock = (Log)EasyMock.mock(Log.class);
        EasyMock.expect((Object)this.replicaManager().getLog(this.topicPartition())).andStubReturn((Object)new Some((Object)logMock));
        EasyMock.expect((Object)BoxesRunTime.boxToLong((long)logMock.logStartOffset())).andStubReturn((Object)BoxesRunTime.boxToLong((long)startOffset));
        EasyMock.expect((Object)logMock.read(EasyMock.eq((long)startOffset), EasyMock.anyInt(), (FetchIsolation)EasyMock.eq((Object)FetchLogEnd$.MODULE$), EasyMock.eq((boolean)true))).andReturn((Object)new FetchDataInfo(new LogOffsetMetadata(startOffset, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), (Records)MemoryRecords.EMPTY, FetchDataInfo$.MODULE$.apply$default$3(), FetchDataInfo$.MODULE$.apply$default$4()));
        EasyMock.expect((Object)this.replicaManager().getLogEndOffset(this.topicPartition())).andStubReturn((Object)new Some((Object)BoxesRunTime.boxToLong((long)endOffset)));
        EasyMock.replay((Object[])new Object[]{logMock});
        EasyMock.replay((Object[])new Object[]{this.replicaManager()});
        this.transactionManager().loadTransactionsForTxnTopicPartition(this.partitionId(), 0, (Function4 & Serializable & scala.Serializable)(x$24, x$25, x$26, x$27) -> {
            TransactionStateManagerTest.$anonfun$testLoadTransactionMetadataWithCorruptedLog$1(BoxesRunTime.unboxToInt((Object)x$24), x$25, x$26, x$27);
            return BoxedUnit.UNIT;
        });
        this.scheduler().tick();
        EasyMock.verify((Object[])new Object[]{logMock});
        EasyMock.verify((Object[])new Object[]{this.replicaManager()});
        Assertions.assertEquals((int)0, (int)this.transactionManager().loadingPartitions().size());
    }

    private void verifyMetadataDoesExistAndIsUsable(String transactionalId) {
        Option option;
        boolean bl = false;
        Right right = null;
        Either either = this.transactionManager().getTransactionState(transactionalId);
        if (either instanceof Left) {
            BoxedUnit cfr_ignored_0 = (BoxedUnit)Assertions.fail((String)"shouldn't have been any errors");
            return;
        }
        if (either instanceof Right) {
            bl = true;
            right = (Right)either;
            Option option2 = (Option)right.value();
            if (None$.MODULE$.equals(option2)) {
                BoxedUnit cfr_ignored_1 = (BoxedUnit)Assertions.fail((String)"metadata should have been removed");
                return;
            }
        }
        if (bl && (option = (Option)right.value()) instanceof Some) {
            Assertions.assertTrue((boolean)((CoordinatorEpochAndTxnMetadata)((Some)option).value()).transactionMetadata().pendingState().isEmpty(), (String)"metadata shouldn't be in a pending state");
            return;
        }
        throw new MatchError((Object)either);
    }

    private void verifyMetadataDoesntExist(String transactionalId) {
        Option option;
        boolean bl = false;
        Right right = null;
        Either either = this.transactionManager().getTransactionState(transactionalId);
        if (either instanceof Left) {
            BoxedUnit cfr_ignored_0 = (BoxedUnit)Assertions.fail((String)"shouldn't have been any errors");
            return;
        }
        if (either instanceof Right) {
            bl = true;
            right = (Right)either;
            if ((Option)right.value() instanceof Some) {
                BoxedUnit cfr_ignored_1 = (BoxedUnit)Assertions.fail((String)"metadata should have been removed");
                return;
            }
        }
        if (bl && None$.MODULE$.equals(option = (Option)right.value())) {
            return;
        }
        throw new MatchError((Object)either);
    }

    private void setupAndRunTransactionalIdExpiration(Errors error, TransactionState txnState) {
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.numPartitions()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)partitionId -> this.transactionManager().addLoadedTransactionsToCache(partitionId, 0, new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1())));
        Capture capturedArgument = EasyMock.newCapture();
        TopicPartition partition = new TopicPartition("__transaction_state", this.transactionManager().partitionFor(this.transactionalId1()));
        Map recordsByPartition = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)MemoryRecords.withRecords((CompressionType)TransactionLog$.MODULE$.EnforcedCompressionType(), (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(this.time().milliseconds() + (long)this.txnConfig().removeExpiredTransactionalIdsIntervalMs(), TransactionLog$.MODULE$.keyToBytes(this.transactionalId1()), null)}))}));
        boolean bl = Empty$.MODULE$.equals(txnState) ? true : (CompleteCommit$.MODULE$.equals(txnState) ? true : CompleteAbort$.MODULE$.equals(txnState));
        if (bl) {
            this.replicaManager().appendRecords(EasyMock.anyLong(), EasyMock.eq((short)((short)-1)), EasyMock.eq((boolean)true), (AppendOrigin)EasyMock.eq((Object)AppendOrigin.Coordinator$.MODULE$), (Map)EasyMock.eq((Object)recordsByPartition), (Function1)EasyMock.capture((Capture)capturedArgument), (Option)EasyMock.anyObject(), (Function1)EasyMock.anyObject());
            EasyMock.expect((Object)BoxedUnit.UNIT).andAnswer(() -> {
                TransactionStateManagerTest.$anonfun$setupAndRunTransactionalIdExpiration$2(capturedArgument, partition, error);
                return BoxedUnit.UNIT;
            });
        }
        EasyMock.replay((Object[])new Object[]{this.replicaManager()});
        this.txnMetadata1().txnLastUpdateTimestamp_$eq(this.time().milliseconds() - (long)this.txnConfig().transactionalIdExpirationMs());
        this.txnMetadata1().state_$eq(txnState);
        this.transactionManager().putTransactionStateIfNotExists(this.txnMetadata1());
        this.txnMetadata2().txnLastUpdateTimestamp_$eq(this.time().milliseconds());
        this.transactionManager().putTransactionStateIfNotExists(this.txnMetadata2());
        this.transactionManager().enableTransactionalIdExpiration();
        this.time().sleep((long)this.txnConfig().removeExpiredTransactionalIdsIntervalMs());
        this.scheduler().tick();
        EasyMock.verify((Object[])new Object[]{this.replicaManager()});
    }

    private void verifyWritesTxnMarkersInPrepareState(TransactionState state) {
        this.txnMetadata1().state_$eq(state);
        this.txnMetadata1().addPartitions((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic1", 0), new TopicPartition("topic1", 1)})));
        this.txnRecords().$plus$eq((Object)new SimpleRecord(this.txnMessageKeyBytes1(), TransactionLog$.MODULE$.valueToBytes(this.txnMetadata1().prepareNoTransit())));
        MemoryRecords records = MemoryRecords.withRecords((long)0L, (CompressionType)CompressionType.NONE, (SimpleRecord[])((SimpleRecord[])this.txnRecords().toArray(ClassTag$.MODULE$.apply(SimpleRecord.class))));
        this.prepareTxnLog(this.topicPartition(), 0L, records);
        ObjectRef txnId = ObjectRef.create(null);
        this.transactionManager().loadTransactionsForTxnTopicPartition(this.partitionId(), 0, (Function4 & Serializable & scala.Serializable)(coordinatorEpoch, command, metadata, newMetadata) -> {
            TransactionStateManagerTest.rememberTxnMarkers$1(BoxesRunTime.unboxToInt((Object)coordinatorEpoch), command, metadata, newMetadata, txnId);
            return BoxedUnit.UNIT;
        });
        this.scheduler().tick();
        Assertions.assertEquals((Object)this.transactionalId1(), (Object)((String)txnId.elem));
    }

    private void assertCallback(Errors error) {
        Assertions.assertEquals((Object)this.expectedError(), (Object)error);
    }

    private TransactionMetadata transactionMetadata(String transactionalId, long producerId, TransactionState state, int txnTimeout) {
        return TransactionMetadata$.MODULE$.apply(transactionalId, producerId, (short)0, txnTimeout, state, this.time().milliseconds());
    }

    private TransactionState transactionMetadata$default$3() {
        return Empty$.MODULE$;
    }

    private int transactionMetadata$default$4() {
        return this.transactionTimeoutMs();
    }

    private void prepareTxnLog(TopicPartition topicPartition, long startOffset, MemoryRecords records) {
        EasyMock.reset((Object[])new Object[]{this.replicaManager()});
        Log logMock = (Log)EasyMock.mock(Log.class);
        FileRecords fileRecordsMock = (FileRecords)EasyMock.mock(FileRecords.class);
        long endOffset = startOffset + (long)((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(records.records()).asScala()).size();
        EasyMock.expect((Object)this.replicaManager().getLog(topicPartition)).andStubReturn((Object)new Some((Object)logMock));
        EasyMock.expect((Object)this.replicaManager().getLogEndOffset(topicPartition)).andStubReturn((Object)new Some((Object)BoxesRunTime.boxToLong((long)endOffset)));
        EasyMock.expect((Object)BoxesRunTime.boxToLong((long)logMock.logStartOffset())).andStubReturn((Object)BoxesRunTime.boxToLong((long)startOffset));
        EasyMock.expect((Object)logMock.read(EasyMock.eq((long)startOffset), EasyMock.anyInt(), (FetchIsolation)EasyMock.eq((Object)FetchLogEnd$.MODULE$), EasyMock.eq((boolean)true))).andReturn((Object)new FetchDataInfo(new LogOffsetMetadata(startOffset, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), (Records)fileRecordsMock, FetchDataInfo$.MODULE$.apply$default$3(), FetchDataInfo$.MODULE$.apply$default$4()));
        EasyMock.expect((Object)BoxesRunTime.boxToInteger((int)fileRecordsMock.sizeInBytes())).andStubReturn((Object)BoxesRunTime.boxToInteger((int)records.sizeInBytes()));
        Capture bufferCapture = EasyMock.newCapture();
        fileRecordsMock.readInto((ByteBuffer)EasyMock.capture((Capture)bufferCapture), EasyMock.anyInt());
        EasyMock.expectLastCall().andAnswer((IAnswer)new IAnswer<BoxedUnit>(null, bufferCapture, records){
            private final Capture bufferCapture$2;
            private final MemoryRecords records$2;

            public void answer() {
                ByteBuffer buffer = (ByteBuffer)this.bufferCapture$2.getValue();
                buffer.put(this.records$2.buffer().duplicate());
                buffer.flip();
            }
            {
                this.bufferCapture$2 = bufferCapture$2;
                this.records$2 = records$2;
            }
        });
        EasyMock.replay((Object[])new Object[]{logMock, fileRecordsMock, this.replicaManager()});
    }

    private void prepareForTxnMessageAppend(Errors error) {
        EasyMock.reset((Object[])new Object[]{this.replicaManager()});
        Capture capturedArgument = EasyMock.newCapture();
        this.replicaManager().appendRecords(EasyMock.anyLong(), EasyMock.anyShort(), EasyMock.eq((boolean)true), (AppendOrigin)EasyMock.eq((Object)AppendOrigin.Coordinator$.MODULE$), (Map)EasyMock.anyObject(), (Function1)EasyMock.capture((Capture)capturedArgument), (Option)EasyMock.anyObject(), (Function1)EasyMock.anyObject());
        EasyMock.expect((Object)BoxedUnit.UNIT).andAnswer(() -> {
            TransactionStateManagerTest.$anonfun$prepareForTxnMessageAppend$1(this, capturedArgument, error);
            return BoxedUnit.UNIT;
        });
        EasyMock.expect((Object)this.replicaManager().getMagic((TopicPartition)EasyMock.anyObject())).andStubReturn((Object)new Some((Object)BoxesRunTime.boxToByte((byte)1)));
        EasyMock.replay((Object[])new Object[]{this.replicaManager()});
    }

    @Test
    public void testPartitionLoadMetric() {
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        String mBeanName = "kafka.server:type=transaction-coordinator-metrics";
        JmxReporter reporter = new JmxReporter();
        KafkaMetricsContext metricsContext = new KafkaMetricsContext("kafka.server");
        reporter.contextChange((MetricsContext)metricsContext);
        this.metrics().addReporter((MetricsReporter)reporter);
        Assertions.assertTrue((boolean)server.isRegistered(new ObjectName(mBeanName)));
        Assertions.assertEquals((double)Double.NaN, (double)TransactionStateManagerTest.partitionLoadTime$1("partition-load-time-max", server, mBeanName), (double)0.0);
        Assertions.assertEquals((double)Double.NaN, (double)TransactionStateManagerTest.partitionLoadTime$1("partition-load-time-avg", server, mBeanName), (double)0.0);
        Assertions.assertTrue((boolean)reporter.containsMbean(mBeanName));
        this.txnMetadata1().state_$eq((TransactionState)Ongoing$.MODULE$);
        this.txnMetadata1().addPartitions((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic1", 1), new TopicPartition("topic1", 1)})));
        this.txnRecords().$plus$eq((Object)new SimpleRecord(this.txnMessageKeyBytes1(), TransactionLog$.MODULE$.valueToBytes(this.txnMetadata1().prepareNoTransit())));
        long startOffset = 15L;
        MemoryRecords records = MemoryRecords.withRecords((long)startOffset, (CompressionType)CompressionType.NONE, (SimpleRecord[])((SimpleRecord[])this.txnRecords().toArray(ClassTag$.MODULE$.apply(SimpleRecord.class))));
        this.prepareTxnLog(this.topicPartition(), startOffset, records);
        this.transactionManager().loadTransactionsForTxnTopicPartition(this.partitionId(), 0, (Function4 & Serializable & scala.Serializable)(x$28, x$29, x$30, x$31) -> {
            TransactionStateManagerTest.$anonfun$testPartitionLoadMetric$1(BoxesRunTime.unboxToInt((Object)x$28), x$29, x$30, x$31);
            return BoxedUnit.UNIT;
        });
        this.scheduler().tick();
        Assertions.assertTrue((TransactionStateManagerTest.partitionLoadTime$1("partition-load-time-max", server, mBeanName) >= 0.0 ? 1 : 0) != 0);
        Assertions.assertTrue((TransactionStateManagerTest.partitionLoadTime$1("partition-load-time-avg", server, mBeanName) >= 0.0 ? 1 : 0) != 0);
    }

    public static final /* synthetic */ short $anonfun$testDeletePartition$1(CoordinatorEpochAndTxnMetadata x$1) {
        return x$1.transactionMetadata().producerEpoch();
    }

    private final Option cachedProducerEpoch$1(String transactionalId) {
        return this.transactionManager().getTransactionState(transactionalId).toOption().flatten(Predef$.MODULE$.$conforms()).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToShort((short)TransactionStateManagerTest.$anonfun$testDeletePartition$1(x$1)));
    }

    public static final /* synthetic */ void $anonfun$testDeleteLoadingPartition$2(int x$2, TransactionResult x$3, TransactionMetadata x$4, TxnTransitMetadata x$5) {
    }

    public static final /* synthetic */ boolean $anonfun$testDeleteLoadingPartition$3(TransactionStateManagerTest $this, TransactionPartitionAndLeaderEpoch partitionAndLeaderEpoch$1) {
        return $this.transactionManager().loadingPartitions().contains((Object)partitionAndLeaderEpoch$1);
    }

    public static final /* synthetic */ String $anonfun$testDeleteLoadingPartition$4() {
        return "Timed out waiting for loading partition";
    }

    public static final /* synthetic */ void $anonfun$testLoadAndRemoveTransactionsForPartition$1(Errors err) {
        Assertions.assertEquals((Object)Errors.NOT_COORDINATOR, (Object)err);
    }

    public static final /* synthetic */ void $anonfun$testLoadAndRemoveTransactionsForPartition$3(Errors err) {
        Assertions.assertEquals((Object)Errors.NOT_COORDINATOR, (Object)err);
    }

    public static final /* synthetic */ void $anonfun$testLoadAndRemoveTransactionsForPartition$5(int x$8, TransactionResult x$9, TransactionMetadata x$10, TxnTransitMetadata x$11) {
    }

    public static final /* synthetic */ void $anonfun$testLoadAndRemoveTransactionsForPartition$15(Errors err) {
        Assertions.assertEquals((Object)Errors.NOT_COORDINATOR, (Object)err);
    }

    public static final /* synthetic */ void $anonfun$testLoadAndRemoveTransactionsForPartition$17(Errors err) {
        Assertions.assertEquals((Object)Errors.NOT_COORDINATOR, (Object)err);
    }

    public static final /* synthetic */ boolean $anonfun$testPendingStateNotResetOnRetryAppend$2(Errors x$14) {
        return true;
    }

    public static final /* synthetic */ void $anonfun$shouldReturnNotCooridnatorErrorIfTransactionIdPartitionNotOwned$1(Errors err) {
        Assertions.assertEquals((Object)Errors.NOT_COORDINATOR, (Object)err);
    }

    public static final /* synthetic */ void $anonfun$testSuccessfulReimmigration$1(int x$16, TransactionResult x$17, TransactionMetadata x$18, TxnTransitMetadata x$19) {
    }

    public static final /* synthetic */ void $anonfun$testSuccessfulReimmigration$2(int x$20, TransactionResult x$21, TransactionMetadata x$22, TxnTransitMetadata x$23) {
    }

    public static final /* synthetic */ void $anonfun$testLoadTransactionMetadataWithCorruptedLog$1(int x$24, TransactionResult x$25, TransactionMetadata x$26, TxnTransitMetadata x$27) {
    }

    public static final /* synthetic */ void $anonfun$setupAndRunTransactionalIdExpiration$2(Capture capturedArgument$1, TopicPartition partition$1, Errors error$1) {
        ((Function1)capturedArgument$1.getValue()).apply((Object)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition$1), (Object)new ProduceResponse.PartitionResponse(error$1, 0L, -1L, 0L))})));
    }

    private static final void rememberTxnMarkers$1(int coordinatorEpoch, TransactionResult command, TransactionMetadata metadata, TxnTransitMetadata newMetadata, ObjectRef txnId$1) {
        txnId$1.elem = metadata.transactionalId();
    }

    public static final /* synthetic */ void $anonfun$prepareForTxnMessageAppend$1(TransactionStateManagerTest $this, Capture capturedArgument$2, Errors error$2) {
        ((Function1)capturedArgument$2.getValue()).apply((Object)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("__transaction_state", $this.partitionId())), (Object)new ProduceResponse.PartitionResponse(error$2, 0L, -1L, 0L))})));
    }

    private static final double partitionLoadTime$1(String attribute, MBeanServer server$1, String mBeanName$1) {
        return BoxesRunTime.unboxToDouble((Object)server$1.getAttribute(new ObjectName(mBeanName$1), attribute));
    }

    public static final /* synthetic */ void $anonfun$testPartitionLoadMetric$1(int x$28, TransactionResult x$29, TransactionMetadata x$30, TxnTransitMetadata x$31) {
    }

    public TransactionStateManagerTest() {
        this.partitionId = 0;
        this.numPartitions = 2;
        this.transactionTimeoutMs = 1000;
        this.coordinatorEpoch = 10;
        EasyMock.expect((Object)this.zkClient().getTopicPartitionCount("__transaction_state")).andReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)this.numPartitions()))).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.zkClient()});
        this.metrics = new Metrics();
        this.txnConfig = new TransactionConfig(TransactionConfig$.MODULE$.apply$default$1(), TransactionConfig$.MODULE$.apply$default$2(), TransactionConfig$.MODULE$.apply$default$3(), TransactionConfig$.MODULE$.apply$default$4(), TransactionConfig$.MODULE$.apply$default$5(), TransactionConfig$.MODULE$.apply$default$6(), TransactionConfig$.MODULE$.apply$default$7(), TransactionConfig$.MODULE$.apply$default$8(), TransactionConfig$.MODULE$.apply$default$9(), TransactionConfig$.MODULE$.apply$default$10());
        this.transactionManager = new TransactionStateManager(0, (Scheduler)this.scheduler(), this.replicaManager(), this.txnConfig(), (Time)this.time(), this.metrics());
        this.transactionalId1 = "one";
        this.transactionalId2 = "two";
        this.txnMessageKeyBytes1 = TransactionLog$.MODULE$.keyToBytes(this.transactionalId1());
        this.txnMessageKeyBytes2 = TransactionLog$.MODULE$.keyToBytes(this.transactionalId2());
        this.producerIds = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.transactionalId1()), (Object)BoxesRunTime.boxToLong((long)1L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.transactionalId2()), (Object)BoxesRunTime.boxToLong((long)2L))}));
        this.txnMetadata1 = this.transactionMetadata(this.transactionalId1(), BoxesRunTime.unboxToLong((Object)this.producerIds().apply((Object)this.transactionalId1())), this.transactionMetadata$default$3(), this.transactionMetadata$default$4());
        this.txnMetadata2 = this.transactionMetadata(this.transactionalId2(), BoxesRunTime.unboxToLong((Object)this.producerIds().apply((Object)this.transactionalId2())), this.transactionMetadata$default$3(), this.transactionMetadata$default$4());
        this.expectedError = Errors.NONE;
    }
}

