/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.ThrottledReplicaListValidator$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u00054Aa\u0004\t\u0001+!)A\u0004\u0001C\u0001;!)\u0001\u0005\u0001C\u0001C!)!\u0007\u0001C\u0001C!)A\u0007\u0001C\u0001C!)a\u0007\u0001C\u0001C!)\u0001\b\u0001C\u0001C!)!\b\u0001C\u0001C!)A\b\u0001C\u0001C!)a\b\u0001C\u0001C!)\u0001\t\u0001C\u0001C!)!\t\u0001C\u0001C!)A\t\u0001C\u0001C!)a\t\u0001C\u0005\u000f\")\u0001\f\u0001C\u00053\niAj\\4D_:4\u0017n\u001a+fgRT!!\u0005\n\u0002\u00071|wMC\u0001\u0014\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u0001\f\u0011\u0005]QR\"\u0001\r\u000b\u0003e\tQa]2bY\u0006L!a\u0007\r\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\ta\u0004\u0005\u0002 \u00015\t\u0001#A\u0016f]N,(/\u001a(p'R\fG/[2J]&$\u0018.\u00197ju\u0006$\u0018n\u001c8Pe\u0012,'\u000fR3qK:$WM\\2z)\u0005\u0011\u0003CA\f$\u0013\t!\u0003D\u0001\u0003V]&$\bF\u0001\u0002'!\t9\u0003'D\u0001)\u0015\tI#&A\u0002ba&T!a\u000b\u0017\u0002\u000f),\b/\u001b;fe*\u0011QFL\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0002_\u0005\u0019qN]4\n\u0005EB#\u0001\u0002+fgR\fa\u0003^3ti.\u000bgm[1D_:4\u0017n\u001a+p!J|\u0007o\u001d\u0015\u0003\u0007\u0019\n!\u0003^3ti\u001a\u0013x.\u001c)s_B\u001cX)\u001c9us\"\u0012AAJ\u0001\u0015i\u0016\u001cHO\u0012:p[B\u0013x\u000e]:J]Z\fG.\u001b3)\u0005\u00151\u0013A\b;fgRLeN^1mS\u0012\u001cu.\u001c9bGRLwN\u001c'bO\u000e{gNZ5hQ\t1a%A\u0013tQ>,H\u000e\u001a,bY&$\u0017\r^3UQJ|G\u000f\u001e7fIJ+\u0007\u000f\\5dCN\u001cuN\u001c4jO\"\u0012qAJ\u0001\u0010i\u0016\u001cH\u000fV8Ii6dG+\u00192mK\"\u0012\u0001BJ\u0001\u000bi\u0016\u001cH\u000fV8Ii6d\u0007FA\u0005'\u0003E!Xm\u001d;U_\u0016s'/[2iK\u0012\u00146\u000f\u001e\u0015\u0003\u0015\u0019\n\u0011\u0002^3tiR{'k\u001d;)\u0005-1\u0013A\u0005;fgR<U\r^\"p]\u001aLwMV1mk\u0016D#\u0001\u0004\u0014\u0002\u000f%\u001ch+\u00197jIR\u0011\u0001j\u0013\t\u0003/%K!A\u0013\r\u0003\u000f\t{w\u000e\\3b]\")A*\u0004a\u0001\u001b\u0006Y1m\u001c8gS\u001e4\u0016\r\\;f!\tqUK\u0004\u0002P'B\u0011\u0001\u000bG\u0007\u0002#*\u0011!\u000bF\u0001\u0007yI|w\u000e\u001e \n\u0005QC\u0012A\u0002)sK\u0012,g-\u0003\u0002W/\n11\u000b\u001e:j]\u001eT!\u0001\u0016\r\u0002+\u0005\u001c8/\u001a:u!J|\u0007/\u001a:us&sg/\u00197jIR\u0019!E\u0017/\t\u000bms\u0001\u0019A'\u0002\t9\fW.\u001a\u0005\u0006;:\u0001\rAX\u0001\u0007m\u0006dW/Z:\u0011\u0007]yf#\u0003\u0002a1\tQAH]3qK\u0006$X\r\u001a ")
public class LogConfigTest {
    @Test
    public void ensureNoStaticInitializationOrderDependency() {
        Assertions.assertNotNull((Object)KafkaConfig$.MODULE$.LogRetentionTimeMillisProp());
        Assertions.assertTrue((boolean)LogConfig$.MODULE$.configNames().forall((Function1 & Serializable & scala.Serializable)config -> BoxesRunTime.boxToBoolean((boolean)LogConfigTest.$anonfun$ensureNoStaticInitializationOrderDependency$1(config))));
    }

    @Test
    public void testKafkaConfigToProps() {
        long millisInHour = 3600000L;
        Properties kafkaProps = TestUtils$.MODULE$.createBrokerConfig(0, "", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20());
        kafkaProps.put(KafkaConfig$.MODULE$.LogRollTimeHoursProp(), "2");
        kafkaProps.put(KafkaConfig$.MODULE$.LogRollTimeJitterHoursProp(), "2");
        kafkaProps.put(KafkaConfig$.MODULE$.LogRetentionTimeHoursProp(), "2");
        KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(kafkaProps);
        Map logProps = LogConfig$.MODULE$.extractLogConfigMap(kafkaConfig);
        Assertions.assertEquals((Object)BoxesRunTime.boxToLong((long)(2L * millisInHour)), logProps.get(LogConfig$.MODULE$.SegmentMsProp()));
        Assertions.assertEquals((Object)BoxesRunTime.boxToLong((long)(2L * millisInHour)), logProps.get(LogConfig$.MODULE$.SegmentJitterMsProp()));
        Assertions.assertEquals((Object)BoxesRunTime.boxToLong((long)(2L * millisInHour)), logProps.get(LogConfig$.MODULE$.RetentionMsProp()));
    }

    @Test
    public void testFromPropsEmpty() {
        Properties p = new Properties();
        LogConfig config = new LogConfig((Map)p, LogConfig$.MODULE$.apply$default$2());
        Assertions.assertEquals((Object)LogConfig$.MODULE$.apply(), (Object)config);
    }

    @Test
    public void testFromPropsInvalid() {
        LogConfig$.MODULE$.configNames().foreach((Function1 & Serializable & scala.Serializable)name -> {
            LogConfigTest.$anonfun$testFromPropsInvalid$1(this, name);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testInvalidCompactionLagConfig() {
        Properties props = new Properties();
        props.setProperty(LogConfig$.MODULE$.MaxCompactionLagMsProp(), "100");
        props.setProperty(LogConfig$.MODULE$.MinCompactionLagMsProp(), "200");
        Assertions.assertThrows(Exception.class, () -> LogConfig$.MODULE$.validate(props));
    }

    @Test
    public void shouldValidateThrottledReplicasConfig() {
        Assertions.assertTrue((boolean)this.isValid("*"));
        Assertions.assertTrue((boolean)this.isValid("* "));
        Assertions.assertTrue((boolean)this.isValid(""));
        Assertions.assertTrue((boolean)this.isValid(" "));
        Assertions.assertTrue((boolean)this.isValid("100:10"));
        Assertions.assertTrue((boolean)this.isValid("100:10,12:10"));
        Assertions.assertTrue((boolean)this.isValid("100:10,12:10,15:1"));
        Assertions.assertTrue((boolean)this.isValid("100:10,12:10,15:1  "));
        Assertions.assertTrue((boolean)this.isValid("100:0,"));
        Assertions.assertFalse((boolean)this.isValid("100"));
        Assertions.assertFalse((boolean)this.isValid("100:"));
        Assertions.assertFalse((boolean)this.isValid("100:0,10"));
        Assertions.assertFalse((boolean)this.isValid("100:0,10:"));
        Assertions.assertFalse((boolean)this.isValid("100:0,10:   "));
        Assertions.assertFalse((boolean)this.isValid("100 :0,10:   "));
        Assertions.assertFalse((boolean)this.isValid("100: 0,10:   "));
        Assertions.assertFalse((boolean)this.isValid("100:0,10 :   "));
        Assertions.assertFalse((boolean)this.isValid("*,100:10"));
        Assertions.assertFalse((boolean)this.isValid("* ,100:10"));
    }

    @Test
    public void testToHtmlTable() {
        String html = LogConfig$.MODULE$.configDefCopy().toHtmlTable();
        String expectedConfig = "<td>file.delete.delay.ms</td>";
        Assertions.assertTrue((boolean)html.contains(expectedConfig), (String)new StringBuilder(23).append("Could not find `").append(expectedConfig).append("` in:\n ").append(html).toString());
    }

    @Test
    public void testToHtml() {
        String html = LogConfig$.MODULE$.configDefCopy().toHtml(4, key -> new StringBuilder(7).append("prefix_").append((String)key).toString(), Collections.emptyMap());
        String expectedConfig = "<h4><a id=\"file.delete.delay.ms\"></a><a id=\"prefix_file.delete.delay.ms\" href=\"#prefix_file.delete.delay.ms\">file.delete.delay.ms</a></h4>";
        Assertions.assertTrue((boolean)html.contains(expectedConfig), (String)new StringBuilder(23).append("Could not find `").append(expectedConfig).append("` in:\n ").append(html).toString());
    }

    @Test
    public void testToEnrichedRst() {
        String rst = LogConfig$.MODULE$.configDefCopy().toEnrichedRst();
        String expectedConfig = "``file.delete.delay.ms``";
        Assertions.assertTrue((boolean)rst.contains(expectedConfig), (String)new StringBuilder(23).append("Could not find `").append(expectedConfig).append("` in:\n ").append(rst).toString());
    }

    @Test
    public void testToRst() {
        String rst = LogConfig$.MODULE$.configDefCopy().toRst();
        String expectedConfig = "``file.delete.delay.ms``";
        Assertions.assertTrue((boolean)rst.contains(expectedConfig), (String)new StringBuilder(23).append("Could not find `").append(expectedConfig).append("` in:\n ").append(rst).toString());
    }

    @Test
    public void testGetConfigValue() {
        LogConfig.LogConfigDef configDef = LogConfig$.MODULE$.configDefCopy();
        String configNameWithNoServerMapping = "log.foo";
        configDef.define(configNameWithNoServerMapping, ConfigDef.Type.INT, (Object)BoxesRunTime.boxToInteger((int)1), ConfigDef.Importance.MEDIUM, new StringBuilder(4).append(configNameWithNoServerMapping).append(" doc").toString());
        ConfigDef.ConfigKey deleteDelayKey = (ConfigDef.ConfigKey)configDef.configKeys().get("file.delete.delay.ms");
        String deleteDelayServerDefault = configDef.getConfigValue(deleteDelayKey, LogConfig$.MODULE$.ServerDefaultHeaderName());
        Assertions.assertEquals((Object)KafkaConfig$.MODULE$.LogDeleteDelayMsProp(), (Object)deleteDelayServerDefault);
        ConfigDef.ConfigKey keyWithNoServerMapping = (ConfigDef.ConfigKey)configDef.configKeys().get(configNameWithNoServerMapping);
        Assertions.assertNull((Object)configDef.getConfigValue(keyWithNoServerMapping, LogConfig$.MODULE$.ServerDefaultHeaderName()));
    }

    private boolean isValid(String configValue) {
        try {
            ThrottledReplicaListValidator$.MODULE$.ensureValidString("", configValue);
            return true;
        }
        catch (ConfigException configException) {
            return false;
        }
    }

    private void assertPropertyInvalid(String name, Seq<Object> values) {
        values.foreach((Function1 & Serializable & scala.Serializable)value -> {
            Properties props = new Properties();
            props.setProperty(name, value.toString());
            return (Exception)Assertions.assertThrows(Exception.class, () -> new LogConfig((Map)props, LogConfig$.MODULE$.apply$default$2()));
        });
    }

    public static final /* synthetic */ boolean $anonfun$ensureNoStaticInitializationOrderDependency$1(String config) {
        Option serverConfigOpt = LogConfig$.MODULE$.serverConfigName(config);
        return serverConfigOpt.isDefined() && serverConfigOpt.get() != null;
    }

    public static final /* synthetic */ void $anonfun$testFromPropsInvalid$1(LogConfigTest $this, String name) {
        String string = LogConfig$.MODULE$.UncleanLeaderElectionEnableProp();
        if (!(string != null ? !string.equals(name) : name != null)) {
            $this.assertPropertyInvalid(name, (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"not a boolean"}));
            return;
        }
        String string2 = LogConfig$.MODULE$.RetentionBytesProp();
        if (!(string2 != null ? !string2.equals(name) : name != null)) {
            $this.assertPropertyInvalid(name, (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"not_a_number"}));
            return;
        }
        String string3 = LogConfig$.MODULE$.RetentionMsProp();
        if (!(string3 != null ? !string3.equals(name) : name != null)) {
            $this.assertPropertyInvalid(name, (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"not_a_number"}));
            return;
        }
        String string4 = LogConfig$.MODULE$.CleanupPolicyProp();
        if (!(string4 != null ? !string4.equals(name) : name != null)) {
            $this.assertPropertyInvalid(name, (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"true", "foobar"}));
            return;
        }
        String string5 = LogConfig$.MODULE$.MinCleanableDirtyRatioProp();
        if (!(string5 != null ? !string5.equals(name) : name != null)) {
            $this.assertPropertyInvalid(name, (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"not_a_number", "-0.1", "1.2"}));
            return;
        }
        String string6 = LogConfig$.MODULE$.MinInSyncReplicasProp();
        if (!(string6 != null ? !string6.equals(name) : name != null)) {
            $this.assertPropertyInvalid(name, (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"not_a_number", "0", "-1"}));
            return;
        }
        String string7 = LogConfig$.MODULE$.MessageFormatVersionProp();
        if (!(string7 != null ? !string7.equals(name) : name != null)) {
            $this.assertPropertyInvalid(name, (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{""}));
            return;
        }
        $this.assertPropertyInvalid(name, (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"not_a_number", "-1"}));
    }
}

