/*
 * Decompiled with CFR 0.152.
 */
package kafka.security.authorizer;

import java.io.File;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import kafka.Kafka$;
import kafka.api.ApiVersion;
import kafka.api.KAFKA_2_0_IV0$;
import kafka.api.KAFKA_2_0_IV1$;
import kafka.security.authorizer.AclAuthorizer;
import kafka.security.authorizer.AclAuthorizer$;
import kafka.security.authorizer.AclEntry$;
import kafka.security.authorizer.BaseAuthorizerTest;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.utils.TestUtils$;
import kafka.zk.ZkAclStore;
import kafka.zk.ZkAclStore$;
import kafka.zk.ZooKeeperTestHarness;
import kafka.zookeeper.AsyncRequest;
import kafka.zookeeper.GetChildrenRequest;
import kafka.zookeeper.GetChildrenRequest$;
import kafka.zookeeper.GetChildrenResponse;
import kafka.zookeeper.GetDataRequest;
import kafka.zookeeper.GetDataRequest$;
import kafka.zookeeper.GetDataResponse;
import kafka.zookeeper.ZooKeeperClient;
import org.apache.kafka.common.acl.AccessControlEntry;
import org.apache.kafka.common.acl.AccessControlEntryFilter;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.acl.AclPermissionType;
import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.resource.ResourcePattern;
import org.apache.kafka.common.resource.ResourcePatternFilter;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.utils.SecurityUtils;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.authorizer.AclCreateResult;
import org.apache.kafka.server.authorizer.AclDeleteResult;
import org.apache.kafka.server.authorizer.Action;
import org.apache.kafka.server.authorizer.AuthorizableRequestContext;
import org.apache.kafka.server.authorizer.AuthorizationResult;
import org.apache.kafka.server.authorizer.Authorizer;
import org.apache.zookeeper.client.ZKClientConfig;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map$;
import scala.collection.mutable.MapLike;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\r\u0015c\u0001B+W\u0001uCQ\u0001\u001b\u0001\u0005\u0002%Dqa\u001b\u0001C\u0002\u0013%A\u000e\u0003\u0004{\u0001\u0001\u0006I!\u001c\u0005\bw\u0002\u0011\r\u0011\"\u0003m\u0011\u0019a\b\u0001)A\u0005[\"9Q\u0010\u0001b\u0001\n\u0013a\u0007B\u0002@\u0001A\u0003%Q\u000e\u0003\u0005\u0000\u0001\t\u0007I\u0011BA\u0001\u0011!\ty\u0001\u0001Q\u0001\n\u0005\r\u0001\"CA\t\u0001\t\u0007I\u0011BA\u0001\u0011!\t\u0019\u0002\u0001Q\u0001\n\u0005\r\u0001\"CA\u000b\u0001\t\u0007I\u0011BA\u0001\u0011!\t9\u0002\u0001Q\u0001\n\u0005\r\u0001\"CA\r\u0001\t\u0007I\u0011BA\u000e\u0011!\tY\u0003\u0001Q\u0001\n\u0005u\u0001\"CA\u0017\u0001\t\u0007I\u0011BA\u0018\u0011!\t9\u0004\u0001Q\u0001\n\u0005E\u0002\"CA\u001d\u0001\t\u0007I\u0011BA\u0018\u0011!\tY\u0004\u0001Q\u0001\n\u0005EbABA\u001f\u0001\u0001\ty\u0004\u0003\u0006\u0002BQ\u0011\t\u0011)A\u0005\u0003\u0007B!\"!\u0018\u0015\u0005\u0003\u0005\u000b\u0011BA\"\u0011\u0019AG\u0003\"\u0001\u0002`!9\u0011\u0011\u000e\u000b\u0005B\u0005-\u0004BB,\u0001\t\u0003\ny\bC\u0004\u0002\u0010\u0002!\t%!%\t\u000f\u0005=\u0006\u0001\"\u0011\u0002\u0012\"9\u0011\u0011\u0018\u0001\u0005\u0002\u0005E\u0005bBAb\u0001\u0011\u0005\u0011\u0011\u0013\u0005\b\u0003\u000f\u0004A\u0011AAI\u0011\u001d\tY\r\u0001C\u0001\u0003#Cq!a4\u0001\t\u0003\t\t\nC\u0004\u0002T\u0002!\t!!%\t\u000f\u0005]\u0007\u0001\"\u0001\u0002\u0012\"9\u00111\u001c\u0001\u0005\u0002\u0005E\u0005bBAp\u0001\u0011\u0005\u0011\u0011\u0013\u0005\b\u0003G\u0004A\u0011AAI\u0011\u001d\t9\u000f\u0001C\u0001\u0003#Cq!a;\u0001\t\u0003\t\t\nC\u0004\u0002p\u0002!\t!!%\t\u000f\u0005M\b\u0001\"\u0001\u0002\u0012\"9\u0011q\u001f\u0001\u0005\u0002\u0005E\u0005bBA~\u0001\u0011\u0005\u0011\u0011\u0013\u0005\b\u0003\u007f\u0004A\u0011AAI\u0011\u001d\u0011\u0019\u0001\u0001C\u0001\u0003#CqAa\u0002\u0001\t\u0003\t\t\nC\u0004\u0003\f\u0001!IA!\u0004\t\u000f\t\r\u0002\u0001\"\u0003\u0003&!9!Q\u0006\u0001\u0005\u0002\u0005E\u0005b\u0002B\u0019\u0001\u0011\u0005\u0011\u0011\u0013\u0005\b\u0005k\u0001A\u0011AAI\u0011\u001d\u0011I\u0004\u0001C\u0001\u0003#CqA!\u0010\u0001\t\u0003\t\t\nC\u0004\u0003B\u0001!\t!!%\t\u000f\t\u0015\u0003\u0001\"\u0001\u0002\u0012\"9!\u0011\n\u0001\u0005\u0002\u0005E\u0005b\u0002B'\u0001\u0011\u0005\u0011\u0011\u0013\u0005\b\u0005#\u0002A\u0011AAI\u0011\u001d\u0011)\u0006\u0001C\u0001\u0003#CqA!\u0017\u0001\t\u0003\t\t\nC\u0004\u0003^\u0001!\t!!%\t\u000f\t\u0005\u0004\u0001\"\u0001\u0002\u0012\"9!Q\r\u0001\u0005\u0002\u0005E\u0005b\u0002B5\u0001\u0011\u0005\u0011\u0011\u0013\u0005\b\u0005[\u0002A\u0011AAI\u0011\u001d\u0011\t\b\u0001C\u0001\u0003#CqA!\u001e\u0001\t\u0003\t\t\nC\u0004\u0003z\u0001!\t!!%\t\u000f\tu\u0004\u0001\"\u0001\u0002\u0012\"9!\u0011\u0011\u0001\u0005\u0002\u0005E\u0005b\u0002BC\u0001\u0011\u0005\u0011\u0011\u0013\u0005\b\u0005\u0013\u0003A\u0011AAI\u0011\u001d\u0011i\t\u0001C\u0001\u0003#CqA!%\u0001\t\u0013\u0011\u0019\nC\u0004\u0003*\u0002!IAa+\t\u000f\t\u0015\u0007\u0001\"\u0003\u0003H\"I!\u0011\u001c\u0001\u0012\u0002\u0013%!1\u001c\u0005\b\u0005c\u0004A\u0011\u0002Bz\u0011\u001d\u0019i\u0001\u0001C\u0005\u0007\u001fAqa!\u0004\u0001\t\u0013\u00199\u0002C\u0004\u0004\u000e\u0001!Iaa\n\t\u000f\r-\u0002\u0001\"\u0003\u0004.!911\u0007\u0001\u0005\n\rU\u0002bBB\u001c\u0001\u0011%1\u0011\b\u0002\u0012\u0003\u000ed\u0017)\u001e;i_JL'0\u001a:UKN$(BA,Y\u0003)\tW\u000f\u001e5pe&TXM\u001d\u0006\u00033j\u000b\u0001b]3dkJLG/\u001f\u0006\u00027\u0006)1.\u00194lC\u000e\u00011c\u0001\u0001_IB\u0011qLY\u0007\u0002A*\u0011\u0011MW\u0001\u0003u.L!a\u00191\u0003)i{wnS3fa\u0016\u0014H+Z:u\u0011\u0006\u0014h.Z:t!\t)g-D\u0001W\u0013\t9gK\u0001\nCCN,\u0017)\u001e;i_JL'0\u001a:UKN$\u0018A\u0002\u001fj]&$h\bF\u0001k!\t)\u0007!\u0001\u0007bY2|wOU3bI\u0006\u001bG.F\u0001n!\tq\u00070D\u0001p\u0015\t\u0001\u0018/A\u0002bG2T!A]:\u0002\r\r|W.\\8o\u0015\tYFO\u0003\u0002vm\u00061\u0011\r]1dQ\u0016T\u0011a^\u0001\u0004_J<\u0017BA=p\u0005I\t5mY3tg\u000e{g\u000e\u001e:pY\u0016sGO]=\u0002\u001b\u0005dGn\\<SK\u0006$\u0017i\u00197!\u00035\tG\u000e\\8x/JLG/Z!dY\u0006q\u0011\r\u001c7po^\u0013\u0018\u000e^3BG2\u0004\u0013a\u00033f]f\u0014V-\u00193BG2\fA\u0002Z3osJ+\u0017\rZ!dY\u0002\n\u0001c^5mI\u000e\u000b'\u000f\u001a*fg>,(oY3\u0016\u0005\u0005\r\u0001\u0003BA\u0003\u0003\u0017i!!a\u0002\u000b\u0007\u0005%\u0011/\u0001\u0005sKN|WO]2f\u0013\u0011\ti!a\u0002\u0003\u001fI+7o\\;sG\u0016\u0004\u0016\r\u001e;fe:\f\u0011c^5mI\u000e\u000b'\u000f\u001a*fg>,(oY3!\u0003A\u0001(/\u001a4jq\u0016$'+Z:pkJ\u001cW-A\tqe\u00164\u0017\u000e_3e%\u0016\u001cx.\u001e:dK\u0002\nqb\u00197vgR,'OU3t_V\u00148-Z\u0001\u0011G2,8\u000f^3s%\u0016\u001cx.\u001e:dK\u0002\n\u0011c^5mI\u000e\f'\u000f\u001a)sS:\u001c\u0017\u000e]1m+\t\ti\u0002\u0005\u0003\u0002 \u0005\u001dRBAA\u0011\u0015\u0011\t\u0019#!\n\u0002\t\u0005,H\u000f\u001b\u0006\u00033FLA!!\u000b\u0002\"\tq1*\u00194lCB\u0013\u0018N\\2ja\u0006d\u0017AE<jY\u0012\u001c\u0017M\u001d3Qe&t7-\u001b9bY\u0002\nQ\"Y2m\u0003V$\bn\u001c:ju\u0016\u0014XCAA\u0019!\r)\u00171G\u0005\u0004\u0003k1&!D!dY\u0006+H\u000f[8sSj,'/\u0001\bbG2\fU\u000f\u001e5pe&TXM\u001d\u0011\u0002\u001d\u0005\u001cG.Q;uQ>\u0014\u0018N_3se\u0005y\u0011m\u00197BkRDwN]5{KJ\u0014\u0004EA\bDkN$x.\u001c)sS:\u001c\u0017\u000e]1m'\r!\u0012QD\u0001\u000eaJLgnY5qC2$\u0016\u0010]3\u0011\t\u0005\u0015\u0013q\u000b\b\u0005\u0003\u000f\n\u0019\u0006\u0005\u0003\u0002J\u0005=SBAA&\u0015\r\ti\u0005X\u0001\u0007yI|w\u000e\u001e \u000b\u0005\u0005E\u0013!B:dC2\f\u0017\u0002BA+\u0003\u001f\na\u0001\u0015:fI\u00164\u0017\u0002BA-\u00037\u0012aa\u0015;sS:<'\u0002BA+\u0003\u001f\nAA\\1nKR1\u0011\u0011MA3\u0003O\u00022!a\u0019\u0015\u001b\u0005\u0001\u0001bBA!/\u0001\u0007\u00111\t\u0005\b\u0003;:\u0002\u0019AA\"\u0003\u0019)\u0017/^1mgR!\u0011QNA;!\u0011\ty'!\u001d\u000e\u0005\u0005=\u0013\u0002BA:\u0003\u001f\u0012qAQ8pY\u0016\fg\u000eC\u0004\u0002xa\u0001\r!!\u001f\u0002\u0003=\u0004B!a\u001c\u0002|%!\u0011QPA(\u0005\r\te._\u000b\u0003\u0003\u0003\u0003B!a!\u0002\f6\u0011\u0011Q\u0011\u0006\u0004/\u0006\u001d%bAAEg\u000611/\u001a:wKJLA!!$\u0002\u0006\nQ\u0011)\u001e;i_JL'0\u001a:\u0002\u000bM,G/\u00169\u0015\u0005\u0005M\u0005\u0003BA8\u0003+KA!a&\u0002P\t!QK\\5uQ\rQ\u00121\u0014\t\u0005\u0003;\u000bY+\u0004\u0002\u0002 *!\u0011\u0011UAR\u0003\r\t\u0007/\u001b\u0006\u0005\u0003K\u000b9+A\u0004kkBLG/\u001a:\u000b\u0007\u0005%f/A\u0003kk:LG/\u0003\u0003\u0002.\u0006}%A\u0003\"fM>\u0014X-R1dQ\u0006AA/Z1s\t><h\u000eK\u0002\u001c\u0003g\u0003B!!(\u00026&!\u0011qWAP\u0005%\te\r^3s\u000b\u0006\u001c\u0007.A\u0014uKN$\u0018)\u001e;i_JL'0\u001a+ie><8o\u00148O_:d\u0015\u000e^3sC2\u0014Vm]8ve\u000e,\u0007f\u0001\u000f\u0002>B!\u0011QTA`\u0013\u0011\t\t-a(\u0003\tQ+7\u000f^\u0001#i\u0016\u001cH/Q;uQ>\u0014\u0018N_3XSRDW)\u001c9usJ+7o\\;sG\u0016t\u0015-\\3)\u0007u\ti,A\u000euKN$X)\u001c9us\u0006\u001bG\u000e\u00165s_^\u001cX\t_2faRLwN\u001c\u0015\u0004=\u0005u\u0016\u0001\u0004;fgR$v\u000e]5d\u0003\u000ed\u0007fA\u0010\u0002>\u0006\u0011C/Z:u\u00032dwn^!dG\u0016\u001c8oV5uQ\u000e+8\u000f^8n!JLgnY5qC2D3\u0001IA_\u0003]!Xm\u001d;EK:LH+Y6fgB\u0013XmY3eK:\u001cW\rK\u0002\"\u0003{\u000b!\u0003^3ti\u0006cGn\\<BY2\f5mY3tg\"\u001a!%!0\u0002-Q,7\u000f^*va\u0016\u0014Xk]3s\u0011\u0006\u001c\u0018iY2fgND3aIA_\u0003%\"Xm\u001d;TkB,'/V:fe^KG\u000f[\"vgR|W\u000e\u0015:j]\u000eL\u0007/\u00197ICN\f5mY3tg\"\u001aA%!0\u0002!Q,7\u000f^,jY\u0012\u001c\u0015M\u001d3BG2\u001c\bfA\u0013\u0002>\u0006qA/Z:u\u001d>\f5\r\u001c$pk:$\u0007f\u0001\u0014\u0002>\u00061B/Z:u\u001d>\f5\r\u001c$pk:$wJ^3se&$W\rK\u0002(\u0003{\u000bQ\u0003^3ti\u0006\u001bG.T1oC\u001e,W.\u001a8u\u0003BK5\u000fK\u0002)\u0003{\u000bQ\u0002^3ti2{\u0017\rZ\"bG\",\u0007fA\u0015\u0002>\u0006AB/Z:u\u0007\"\fgnZ3MSN$XM\\3s)&l\u0017N\\4)\u0007)\ni,A\u0017uKN$Hj\\2bY\u000e{gnY;se\u0016tG/T8eS\u001aL7-\u0019;j_:|eMU3t_V\u00148-Z!dYND3aKA_\u0003M\"Xm\u001d;ESN$(/\u001b2vi\u0016$7i\u001c8dkJ\u0014XM\u001c;N_\u0012Lg-[2bi&|gn\u00144SKN|WO]2f\u0003\u000ed7\u000fK\u0002-\u0003{\u000bQ\u0006^3ti\"Kw\r[\"p]\u000e,(O]3oGflu\u000eZ5gS\u000e\fG/[8o\u001f\u001a\u0014Vm]8ve\u000e,\u0017i\u00197tQ\ri\u0013QX\u0001\u0013i\u0016\u001cH/Q2m\u0013:DWM]5uC:\u001cW\rK\u0002/\u0003{\u000bq\u0003^3ti&k\u0007\u000f\\5dCRLwN\\:PM\u0006cGn\\<\u0015\r\u0005M%q\u0002B\r\u0011\u001d\u0011\tb\fa\u0001\u0005'\t\u0001\u0002]1sK:$x\n\u001d\t\u0004]\nU\u0011b\u0001B\f_\na\u0011i\u00197Pa\u0016\u0014\u0018\r^5p]\"9!1D\u0018A\u0002\tu\u0011AC1mY><X\rZ(qgB1\u0011Q\tB\u0010\u0005'IAA!\t\u0002\\\t\u00191+\u001a;\u0002-Q,7\u000f^%na2L7-\u0019;j_:\u001cxJ\u001a#f]f$b!a%\u0003(\t%\u0002b\u0002B\ta\u0001\u0007!1\u0003\u0005\b\u0005W\u0001\u0004\u0019\u0001B\u000f\u0003%!WM\\5fI>\u00038/A\u0015uKN$\b*[4i\u0007>t7-\u001e:sK:\u001c\u0017\u0010R3mKRLwN\\(g%\u0016\u001cx.\u001e:dK\u0006\u001bGn\u001d\u0015\u0004c\u0005u\u0016a\r;fgR\f5mY3tg\u0006cGn\\<fI&3\u0017\t\u001c7po\u0006\u001bG.\u0012=jgR\u001cxJ\\,jY\u0012\u001c\u0017M\u001d3SKN|WO]2fQ\r\u0011\u0014QX\u0001 i\u0016\u001cH\u000fR3mKR,\u0017i\u00197P]^KG\u000eZ2be\u0012\u0014Vm]8ve\u000e,\u0007fA\u001a\u0002>\u0006\u0011C/Z:u\t\u0016dW\r^3BY2\f5\r\\(o/&dGmY1sIJ+7o\\;sG\u0016D3\u0001NA_\u0003M\"Xm\u001d;BG\u000e,7o]!mY><X\rZ%g\u00032dwn^!dY\u0016C\u0018n\u001d;t\u001f:\u0004&/\u001a4jq\u0016$'+Z:pkJ\u001cW\rK\u00026\u0003{\u000bq\u0004^3ti\u0012+G.\u001a;f\u0003\u000edwJ\u001c)sK\u001aL\u00070\u001a3SKN|WO]2fQ\r1\u0014QX\u0001#i\u0016\u001cH\u000fR3mKR,\u0017\t\u001c7BG2|e\u000e\u0015:fM&DX\r\u001a*fg>,(oY3)\u0007]\ni,\u0001\u000fuKN$\u0018\t\u001a3BG2\u001cxJ\u001c'ji\u0016\u0014\u0018\r\u001c*fg>,(oY3)\u0007a\ni,A\u000fuKN$\u0018\t\u001a3BG2\u001cxJ\\,jY\u0012\u001c\u0017M\u001d3SKN|WO]2fQ\rI\u0014QX\u0001\u001ei\u0016\u001cH/\u00113e\u0003\u000ed7o\u00148Qe\u00164\u0017\u000e_3e%\u0016\u001cx.\u001e:dK\"\u001a!(!0\u0002CQ,7\u000f^!vi\"|'/\u001b>f/&$\b\u000e\u0015:fM&DX\r\u001a*fg>,(oY3)\u0007m\ni,A\u0010uKN$8+\u001b8hY\u0016\u001c\u0005.\u0019:bGR,'OU3t_V\u00148-Z!dYND3\u0001PA_\u0003Q!Xm\u001d;HKR\f5\r\\:Qe&t7-\u001b9bY\"\u001aQ(!0\u0002\u001dQ,7\u000f^!dYN4\u0015\u000e\u001c;fe\"\u001aa(!0\u0002yQ,7\u000f\u001e+ie><8o\u00148BI\u0012\u0004&/\u001a4jq\u0016$\u0017i\u00197JM&sG/\u001a:Ce>\\WM\u001d)s_R|7m\u001c7WKJ\u001c\u0018n\u001c8U_>dun\u001e\u0015\u0004\u007f\u0005u\u0016a\u000f;fgR<&/\u001b;fg\u0016CH/\u001a8eK\u0012\f5\r\\\"iC:<W-\u0012<f]RLe-\u00138uKJ\u0014%o\\6feB\u0013x\u000e^8d_2tu\u000e^*fi\"\u001a\u0001)!0\u0002\u000bR,7\u000f^,sSR,7/\u0012=uK:$W\rZ!dY\u000eC\u0017M\\4f\u000bZ,g\u000e^,iK:Le\u000e^3s\u0005J|7.\u001a:Qe>$xnY8m\u0003RdU-Y:u\u0017\u000647.\u0019,3Q\r\t\u0015QX\u0001yi\u0016\u001cHo\u0016:ji\u0016\u001cH*\u001b;fe\u0006dwK]5uKNd\u0015\u000e^3sC2\f5\r\\\"iC:<W-\u0012<f]R<\u0006.\u001a8J]R,'O\u0011:pW\u0016\u0014\bK]8u_\u000e|G\u000eT3tgRC\u0017M\\&bM.\fgKM3sC2\f5\r\\\"iC:<Wm\u001d$pe>cG-\u001a:Qe>$xnY8m-\u0016\u00148/[8og\"\u001a!)!0\u0002\u007fQ,7\u000f^,sSR,7\u000fT5uKJ\fG.Q2m\u0007\"\fgnZ3Fm\u0016tGo\u00165f]&sG/\u001a:Ce>\\WM\u001d)s_R|7m\u001c7Jg.\u000bgm[1We!\u001a1)!0\u00021Q,7\u000f^!vi\"|'/\u001b>fe:{'l[\"p]\u001aLw\rK\u0002E\u0003{\u000b\u0011\u0007^3ti\u0006+H\u000f[8sSj,'OW6D_:4\u0017n\u001a$s_6\\\u0015MZ6b\u0007>tg-[4XSRDG)\u001a4bk2$8\u000fK\u0002F\u0003{\u000bQ\u0005^3ti\u0006+H\u000f[8sSj,'OW6D_:4\u0017n\u001a$s_6\\\u0015MZ6b\u0007>tg-[4)\u0007\u0019\u000bi,A\u0015uKN$\u0018)\u001e;i_JL'0\u001a:[W\u000e{gNZ5h\rJ|W\u000e\u0015:fM&DxJ^3se&$Wm\u001d\u0015\u0004\u000f\u0006u\u0016A\u0006;fgR\u001c%/Z1uK\u0012+G.\u001a;f)&l\u0017N\\4)\u0007!\u000bi,A\u0017uKN$\u0018)\u001e;i_JL'0\u001a\"z%\u0016\u001cx.\u001e:dKRK\b/\u001a(p\u0003\u000edgi\\;oI>3XM\u001d:jI\u0016D3!SA_\u0003\t:\u0017N^3o\u0003V$\bn\u001c:ju\u0016\u0014x+\u001b;i!J|Go\\2pYZ+'o]5p]R!\u00111\u0013BK\u0011\u001d\u00119J\u0013a\u0001\u00053\u000bq\u0002\u001d:pi>\u001cw\u000e\u001c,feNLwN\u001c\t\u0007\u0003_\u0012YJa(\n\t\tu\u0015q\n\u0002\u0007\u001fB$\u0018n\u001c8\u0011\t\t\u0005&QU\u0007\u0003\u0005GS1!!)[\u0013\u0011\u00119Ka)\u0003\u0015\u0005\u0003\u0018NV3sg&|g.A\rhKR\f5\r\\\"iC:<W-\u0012<f]R\f5o\u0015;sS:<G\u0003\u0002BW\u0005w\u0003BAa,\u0003:6\u0011!\u0011\u0017\u0006\u0005\u0005g\u0013),\u0001\u0003mC:<'B\u0001B\\\u0003\u0011Q\u0017M^1\n\t\u0005e#\u0011\u0017\u0005\b\u0005{[\u0005\u0019\u0001B`\u0003-\u0001\u0018\r\u001e;fe:$\u0016\u0010]3\u0011\t\u0005\u0015!\u0011Y\u0005\u0005\u0005\u0007\f9AA\u0006QCR$XM\u001d8UsB,\u0017AE2iC:<W-Q2m\u0003:$g+\u001a:jMf$\"B!3\u0003L\n='1\u001bBl!\u0015\t)Ea\bn\u0011\u001d\u0011i\r\u0014a\u0001\u0005\u0013\fAb\u001c:jO&t\u0017\r\\!dYNDqA!5M\u0001\u0004\u0011I-A\u0005bI\u0012,G-Q2mg\"9!Q\u001b'A\u0002\t%\u0017a\u0003:f[>4X\rZ!dYND\u0011\"!\u0003M!\u0003\u0005\r!a\u0001\u00029\rD\u0017M\\4f\u0003\u000ed\u0017I\u001c3WKJLg-\u001f\u0013eK\u001a\fW\u000f\u001c;%iU\u0011!Q\u001c\u0016\u0005\u0003\u0007\u0011yn\u000b\u0002\u0003bB!!1\u001dBw\u001b\t\u0011)O\u0003\u0003\u0003h\n%\u0018!C;oG\",7m[3e\u0015\u0011\u0011Y/a\u0014\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0003p\n\u0015(!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006I\u0011-\u001e;i_JL'0\u001a\u000b\u000b\u0003[\u0012)Pa>\u0004\b\r-\u0001BB,O\u0001\u0004\t\t\u0004C\u0004\u0003z:\u0003\rAa?\u0002\u001dI,\u0017/^3ti\u000e{g\u000e^3yiB!!Q`B\u0002\u001b\t\u0011yPC\u0002\u0004\u0002E\f\u0001B]3rk\u0016\u001cHo]\u0005\u0005\u0007\u000b\u0011yP\u0001\bSKF,Xm\u001d;D_:$X\r\u001f;\t\u000f\r%a\n1\u0001\u0003\u0014\u0005Iq\u000e]3sCRLwN\u001c\u0005\b\u0003\u0013q\u0005\u0019AA\u0002\u0003\u001d9W\r^!dYN$bA!3\u0004\u0012\rM\u0001BB,P\u0001\u0004\t\t\u0004C\u0004\u0004\u0016=\u0003\r!a\u0001\u0002\u001fI,7o\\;sG\u0016\u0004\u0016\r\u001e;fe:$ba!\u0007\u0004\"\r\r\u0002CBA#\u0005?\u0019Y\u0002E\u0002o\u0007;I1aa\bp\u0005)\t5\r\u001c\"j]\u0012Lgn\u001a\u0005\u0007/B\u0003\r!!\r\t\u000f\r\u0015\u0002\u000b1\u0001\u0002\u001e\u0005I\u0001O]5oG&\u0004\u0018\r\u001c\u000b\u0005\u00073\u0019I\u0003\u0003\u0004X#\u0002\u0007\u0011\u0011G\u0001\bm\u0006d\u0017\u000eZ(q)\u0011\tiga\f\t\u000f\rE\"\u000b1\u0001\u0003\u0014\u0005\u0011q\u000e]\u0001\u0015aJ,\u0007/\u0019:f\t\u00164\u0017-\u001e7u\u0007>tg-[4\u0016\u0005\u0005\r\u0013!\u00049sKB\f'/Z\"p]\u001aLw\r\u0006\u0003\u0002D\rm\u0002bBB\u001f)\u0002\u00071qH\u0001\u0006Y&tWm\u001d\t\u0007\u0003_\u001a\t%a\u0011\n\t\r\r\u0013q\n\u0002\u0006\u0003J\u0014\u0018-\u001f")
public class AclAuthorizerTest
extends ZooKeeperTestHarness
implements BaseAuthorizerTest {
    private final AccessControlEntry allowReadAcl;
    private final AccessControlEntry allowWriteAcl;
    private final AccessControlEntry denyReadAcl;
    private final ResourcePattern wildCardResource;
    private final ResourcePattern prefixedResource;
    private final ResourcePattern clusterResource;
    private final KafkaPrincipal wildcardPrincipal;
    private final AclAuthorizer aclAuthorizer;
    private final AclAuthorizer aclAuthorizer2;
    private final String superUsers;
    private final String username;
    private final KafkaPrincipal principal;
    private final RequestContext requestContext;
    private final String superUserName;
    private KafkaConfig config;
    private ZooKeeperClient zooKeeperClient;
    private ResourcePattern resource;

    @Override
    @Test
    public void testAuthorizeByResourceTypeMultipleAddAndRemove() {
        BaseAuthorizerTest.testAuthorizeByResourceTypeMultipleAddAndRemove$(this);
    }

    @Override
    @Test
    public void testAuthorizeByResourceTypeIsolationUnrelatedDenyWontDominateAllow() {
        BaseAuthorizerTest.testAuthorizeByResourceTypeIsolationUnrelatedDenyWontDominateAllow$(this);
    }

    @Override
    @Test
    public void testAuthorizeByResourceTypeDenyTakesPrecedence() {
        BaseAuthorizerTest.testAuthorizeByResourceTypeDenyTakesPrecedence$(this);
    }

    @Override
    @Test
    public void testAuthorizeByResourceTypePrefixedResourceDenyDominate() {
        BaseAuthorizerTest.testAuthorizeByResourceTypePrefixedResourceDenyDominate$(this);
    }

    @Override
    @Test
    public void testAuthorizeByResourceTypeWildcardResourceDenyDominate() {
        BaseAuthorizerTest.testAuthorizeByResourceTypeWildcardResourceDenyDominate$(this);
    }

    @Override
    @Test
    public void testAuthorizeByResourceTypeWithAllOperationAce() {
        BaseAuthorizerTest.testAuthorizeByResourceTypeWithAllOperationAce$(this);
    }

    @Override
    @Test
    public void testAuthorizeByResourceTypeWithAllHostAce() {
        BaseAuthorizerTest.testAuthorizeByResourceTypeWithAllHostAce$(this);
    }

    @Override
    @Test
    public void testAuthorizeByResourceTypeWithAllPrincipalAce() {
        BaseAuthorizerTest.testAuthorizeByResourceTypeWithAllPrincipalAce$(this);
    }

    @Override
    @Test
    public void testAuthorzeByResourceTypeSuperUserHasAccess() {
        BaseAuthorizerTest.testAuthorzeByResourceTypeSuperUserHasAccess$(this);
    }

    @Override
    public RequestContext newRequestContext(KafkaPrincipal principal, InetAddress clientAddress, ApiKeys apiKey) {
        return BaseAuthorizerTest.newRequestContext$(this, principal, clientAddress, apiKey);
    }

    @Override
    public ApiKeys newRequestContext$default$3() {
        return BaseAuthorizerTest.newRequestContext$default$3$(this);
    }

    @Override
    public boolean authorizeByResourceType(Authorizer authorizer, RequestContext requestContext, AclOperation operation, ResourceType resourceType) {
        return BaseAuthorizerTest.authorizeByResourceType$(this, authorizer, requestContext, operation, resourceType);
    }

    @Override
    public void addAcls(Authorizer authorizer, Set<AccessControlEntry> aces, ResourcePattern resourcePattern) {
        BaseAuthorizerTest.addAcls$(this, authorizer, aces, resourcePattern);
    }

    @Override
    public boolean removeAcls(Authorizer authorizer, Set<AccessControlEntry> aces, ResourcePattern resourcePattern) {
        return BaseAuthorizerTest.removeAcls$(this, authorizer, aces, resourcePattern);
    }

    @Override
    public String superUsers() {
        return this.superUsers;
    }

    @Override
    public String username() {
        return this.username;
    }

    @Override
    public KafkaPrincipal principal() {
        return this.principal;
    }

    @Override
    public RequestContext requestContext() {
        return this.requestContext;
    }

    @Override
    public String superUserName() {
        return this.superUserName;
    }

    @Override
    public KafkaConfig config() {
        return this.config;
    }

    @Override
    public void config_$eq(KafkaConfig x$1) {
        this.config = x$1;
    }

    @Override
    public ZooKeeperClient zooKeeperClient() {
        return this.zooKeeperClient;
    }

    @Override
    public void zooKeeperClient_$eq(ZooKeeperClient x$1) {
        this.zooKeeperClient = x$1;
    }

    @Override
    public ResourcePattern resource() {
        return this.resource;
    }

    @Override
    public void resource_$eq(ResourcePattern x$1) {
        this.resource = x$1;
    }

    @Override
    public void kafka$security$authorizer$BaseAuthorizerTest$_setter_$superUsers_$eq(String x$1) {
        this.superUsers = x$1;
    }

    @Override
    public void kafka$security$authorizer$BaseAuthorizerTest$_setter_$username_$eq(String x$1) {
        this.username = x$1;
    }

    @Override
    public void kafka$security$authorizer$BaseAuthorizerTest$_setter_$principal_$eq(KafkaPrincipal x$1) {
        this.principal = x$1;
    }

    @Override
    public void kafka$security$authorizer$BaseAuthorizerTest$_setter_$requestContext_$eq(RequestContext x$1) {
        this.requestContext = x$1;
    }

    @Override
    public void kafka$security$authorizer$BaseAuthorizerTest$_setter_$superUserName_$eq(String x$1) {
        this.superUserName = x$1;
    }

    private AccessControlEntry allowReadAcl() {
        return this.allowReadAcl;
    }

    private AccessControlEntry allowWriteAcl() {
        return this.allowWriteAcl;
    }

    private AccessControlEntry denyReadAcl() {
        return this.denyReadAcl;
    }

    private ResourcePattern wildCardResource() {
        return this.wildCardResource;
    }

    private ResourcePattern prefixedResource() {
        return this.prefixedResource;
    }

    private ResourcePattern clusterResource() {
        return this.clusterResource;
    }

    private KafkaPrincipal wildcardPrincipal() {
        return this.wildcardPrincipal;
    }

    private AclAuthorizer aclAuthorizer() {
        return this.aclAuthorizer;
    }

    private AclAuthorizer aclAuthorizer2() {
        return this.aclAuthorizer2;
    }

    @Override
    public Authorizer authorizer() {
        return this.aclAuthorizer();
    }

    @Override
    @BeforeEach
    public void setUp() {
        super.setUp();
        this.aclAuthorizer().maxUpdateRetries_$eq(Integer.MAX_VALUE);
        this.aclAuthorizer2().maxUpdateRetries_$eq(Integer.MAX_VALUE);
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20());
        props.put(AclAuthorizer$.MODULE$.SuperUsersProp(), this.superUsers());
        this.config_$eq(KafkaConfig$.MODULE$.fromProps(props));
        this.aclAuthorizer().configure(this.config().originals());
        this.aclAuthorizer2().configure(this.config().originals());
        this.resource_$eq(new ResourcePattern(ResourceType.TOPIC, new StringBuilder(4).append("foo-").append(UUID.randomUUID()).toString(), PatternType.LITERAL));
        this.zooKeeperClient_$eq(new ZooKeeperClient(this.zkConnect(), this.zkSessionTimeout(), this.zkConnectionTimeout(), this.zkMaxInFlightRequests(), Time.SYSTEM, "kafka.test", "AclAuthorizerTest"));
    }

    @Override
    @AfterEach
    public void tearDown() {
        this.aclAuthorizer().close();
        this.aclAuthorizer2().close();
        this.zooKeeperClient().close();
        super.tearDown();
    }

    @Test
    public void testAuthorizeThrowsOnNonLiteralResource() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.authorize(this.aclAuthorizer(), this.requestContext(), AclOperation.READ, new ResourcePattern(ResourceType.TOPIC, "something", PatternType.PREFIXED)));
    }

    @Test
    public void testAuthorizeWithEmptyResourceName() {
        Assertions.assertFalse((boolean)this.authorize(this.aclAuthorizer(), this.requestContext(), AclOperation.READ, new ResourcePattern(ResourceType.GROUP, "", PatternType.LITERAL)));
        this.addAcls((Authorizer)this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowReadAcl()}))), new ResourcePattern(ResourceType.GROUP, "*", PatternType.LITERAL));
        Assertions.assertTrue((boolean)this.authorize(this.aclAuthorizer(), this.requestContext(), AclOperation.READ, new ResourcePattern(ResourceType.GROUP, "", PatternType.LITERAL)));
    }

    @Test
    public void testEmptyAclThrowsException() {
        ApiException e = (ApiException)Assertions.assertThrows(ApiException.class, () -> this.addAcls((Authorizer)this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowReadAcl()}))), new ResourcePattern(ResourceType.GROUP, "", PatternType.LITERAL)));
        Assertions.assertTrue((boolean)(e.getCause() instanceof IllegalArgumentException), (String)new StringBuilder(21).append("Unexpected exception ").append(e).toString());
    }

    @Test
    public void testTopicAcl() {
        KafkaPrincipal user1 = new KafkaPrincipal("User", this.username());
        KafkaPrincipal user2 = new KafkaPrincipal("User", "rob");
        KafkaPrincipal user3 = new KafkaPrincipal("User", "batman");
        InetAddress host1 = InetAddress.getByName("192.168.1.1");
        InetAddress host2 = InetAddress.getByName("192.168.1.2");
        AccessControlEntry acl1 = new AccessControlEntry(user1.toString(), host1.getHostAddress(), AclOperation.READ, AclPermissionType.ALLOW);
        AccessControlEntry acl2 = new AccessControlEntry(user1.toString(), host2.getHostAddress(), AclOperation.READ, AclPermissionType.ALLOW);
        AccessControlEntry acl3 = new AccessControlEntry(user1.toString(), host1.getHostAddress(), AclOperation.READ, AclPermissionType.DENY);
        AccessControlEntry acl4 = new AccessControlEntry(user1.toString(), host1.getHostAddress(), AclOperation.WRITE, AclPermissionType.ALLOW);
        AccessControlEntry acl5 = new AccessControlEntry(user1.toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.DESCRIBE, AclPermissionType.ALLOW);
        AccessControlEntry acl6 = new AccessControlEntry(user2.toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.ALLOW);
        AccessControlEntry acl7 = new AccessControlEntry(user3.toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.WRITE, AclPermissionType.ALLOW);
        Set acls = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl1, acl2, acl3, acl4, acl5, acl6, acl7}));
        this.changeAclAndVerify((Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), (Set<AccessControlEntry>)acls, (Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), this.changeAclAndVerify$default$4());
        RequestContext host1Context = this.newRequestContext(user1, host1, this.newRequestContext$default$3());
        RequestContext host2Context = this.newRequestContext(user1, host2, this.newRequestContext$default$3());
        Assertions.assertTrue((boolean)this.authorize(this.aclAuthorizer(), host2Context, AclOperation.READ, this.resource()), (String)"User1 should have READ access from host2");
        Assertions.assertFalse((boolean)this.authorize(this.aclAuthorizer(), host1Context, AclOperation.READ, this.resource()), (String)"User1 should not have READ access from host1 due to denyAcl");
        Assertions.assertTrue((boolean)this.authorize(this.aclAuthorizer(), host1Context, AclOperation.WRITE, this.resource()), (String)"User1 should have WRITE access from host1");
        Assertions.assertFalse((boolean)this.authorize(this.aclAuthorizer(), host2Context, AclOperation.WRITE, this.resource()), (String)"User1 should not have WRITE access from host2 as no allow acl is defined");
        Assertions.assertTrue((boolean)this.authorize(this.aclAuthorizer(), host1Context, AclOperation.DESCRIBE, this.resource()), (String)"User1 should not have DESCRIBE access from host1");
        Assertions.assertTrue((boolean)this.authorize(this.aclAuthorizer(), host2Context, AclOperation.DESCRIBE, this.resource()), (String)"User1 should have DESCRIBE access from host2");
        Assertions.assertFalse((boolean)this.authorize(this.aclAuthorizer(), host1Context, AclOperation.ALTER, this.resource()), (String)"User1 should not have edit access from host1");
        Assertions.assertFalse((boolean)this.authorize(this.aclAuthorizer(), host2Context, AclOperation.ALTER, this.resource()), (String)"User1 should not have edit access from host2");
        RequestContext user2Context = this.newRequestContext(user2, host1, this.newRequestContext$default$3());
        RequestContext user3Context = this.newRequestContext(user3, host1, this.newRequestContext$default$3());
        Assertions.assertTrue((boolean)this.authorize(this.aclAuthorizer(), user2Context, AclOperation.DESCRIBE, this.resource()), (String)"User2 should have DESCRIBE access from host1");
        Assertions.assertTrue((boolean)this.authorize(this.aclAuthorizer(), user3Context, AclOperation.DESCRIBE, this.resource()), (String)"User3 should have DESCRIBE access from host2");
        Assertions.assertTrue((boolean)this.authorize(this.aclAuthorizer(), user2Context, AclOperation.READ, this.resource()), (String)"User2 should have READ access from host1");
        Assertions.assertTrue((boolean)this.authorize(this.aclAuthorizer(), user3Context, AclOperation.WRITE, this.resource()), (String)"User3 should have WRITE access from host2");
    }

    @Test
    public void testAllowAccessWithCustomPrincipal() {
        KafkaPrincipal user = new KafkaPrincipal("User", this.username());
        CustomPrincipal customUserPrincipal = new CustomPrincipal("User", this.username());
        InetAddress host1 = InetAddress.getByName("192.168.1.1");
        InetAddress host2 = InetAddress.getByName("192.168.1.2");
        AccessControlEntry acl1 = new AccessControlEntry(user.toString(), host1.getHostAddress(), AclOperation.READ, AclPermissionType.DENY);
        AccessControlEntry acl2 = new AccessControlEntry(user.toString(), host2.getHostAddress(), AclOperation.READ, AclPermissionType.ALLOW);
        Set acls = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl1, acl2}));
        this.changeAclAndVerify((Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), (Set<AccessControlEntry>)acls, (Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), this.changeAclAndVerify$default$4());
        RequestContext host1Context = this.newRequestContext(customUserPrincipal, host1, this.newRequestContext$default$3());
        RequestContext host2Context = this.newRequestContext(customUserPrincipal, host2, this.newRequestContext$default$3());
        Assertions.assertTrue((boolean)this.authorize(this.aclAuthorizer(), host2Context, AclOperation.READ, this.resource()), (String)"User1 should have READ access from host2");
        Assertions.assertFalse((boolean)this.authorize(this.aclAuthorizer(), host1Context, AclOperation.READ, this.resource()), (String)"User1 should not have READ access from host1 due to denyAcl");
    }

    @Test
    public void testDenyTakesPrecedence() {
        KafkaPrincipal user = new KafkaPrincipal("User", this.username());
        InetAddress host = InetAddress.getByName("192.168.2.1");
        RequestContext session = this.newRequestContext(user, host, this.newRequestContext$default$3());
        AccessControlEntry allowAll = new AccessControlEntry(AclEntry$.MODULE$.WildcardPrincipalString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.ALL, AclPermissionType.ALLOW);
        AccessControlEntry denyAcl = new AccessControlEntry(user.toString(), host.getHostAddress(), AclOperation.ALL, AclPermissionType.DENY);
        Set acls = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{allowAll, denyAcl}));
        this.changeAclAndVerify((Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), (Set<AccessControlEntry>)acls, (Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), this.changeAclAndVerify$default$4());
        Assertions.assertFalse((boolean)this.authorize(this.aclAuthorizer(), session, AclOperation.READ, this.resource()), (String)"deny should take precedence over allow.");
    }

    @Test
    public void testAllowAllAccess() {
        AccessControlEntry allowAllAcl = new AccessControlEntry(AclEntry$.MODULE$.WildcardPrincipalString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.ALL, AclPermissionType.ALLOW);
        this.changeAclAndVerify((Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{allowAllAcl}))), (Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), this.changeAclAndVerify$default$4());
        RequestContext context = this.newRequestContext(new KafkaPrincipal("User", "random"), InetAddress.getByName("192.0.4.4"), this.newRequestContext$default$3());
        Assertions.assertTrue((boolean)this.authorize(this.aclAuthorizer(), context, AclOperation.READ, this.resource()), (String)"allow all acl should allow access to all.");
    }

    @Test
    public void testSuperUserHasAccess() {
        AccessControlEntry denyAllAcl = new AccessControlEntry(AclEntry$.MODULE$.WildcardPrincipalString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.ALL, AclPermissionType.DENY);
        this.changeAclAndVerify((Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{denyAllAcl}))), (Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), this.changeAclAndVerify$default$4());
        RequestContext session1 = this.newRequestContext(new KafkaPrincipal("User", "superuser1"), InetAddress.getByName("192.0.4.4"), this.newRequestContext$default$3());
        RequestContext session2 = this.newRequestContext(new KafkaPrincipal("User", "superuser2"), InetAddress.getByName("192.0.4.4"), this.newRequestContext$default$3());
        Assertions.assertTrue((boolean)this.authorize(this.aclAuthorizer(), session1, AclOperation.READ, this.resource()), (String)"superuser always has access, no matter what acls.");
        Assertions.assertTrue((boolean)this.authorize(this.aclAuthorizer(), session2, AclOperation.READ, this.resource()), (String)"superuser always has access, no matter what acls.");
    }

    @Test
    public void testSuperUserWithCustomPrincipalHasAccess() {
        AccessControlEntry denyAllAcl = new AccessControlEntry(AclEntry$.MODULE$.WildcardPrincipalString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.ALL, AclPermissionType.DENY);
        this.changeAclAndVerify((Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{denyAllAcl}))), (Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), this.changeAclAndVerify$default$4());
        RequestContext session = this.newRequestContext(new CustomPrincipal("User", "superuser1"), InetAddress.getByName("192.0.4.4"), this.newRequestContext$default$3());
        Assertions.assertTrue((boolean)this.authorize(this.aclAuthorizer(), session, AclOperation.READ, this.resource()), (String)"superuser with custom principal always has access, no matter what acls.");
    }

    @Test
    public void testWildCardAcls() {
        Assertions.assertFalse((boolean)this.authorize(this.aclAuthorizer(), this.requestContext(), AclOperation.READ, this.resource()), (String)"when acls = [], authorizer should fail close.");
        KafkaPrincipal user1 = new KafkaPrincipal("User", this.username());
        InetAddress host1 = InetAddress.getByName("192.168.3.1");
        AccessControlEntry readAcl = new AccessControlEntry(user1.toString(), host1.getHostAddress(), AclOperation.READ, AclPermissionType.ALLOW);
        Set<AccessControlEntry> acls = this.changeAclAndVerify((Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{readAcl}))), (Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), this.wildCardResource());
        RequestContext host1Context = this.newRequestContext(user1, host1, this.newRequestContext$default$3());
        Assertions.assertTrue((boolean)this.authorize(this.aclAuthorizer(), host1Context, AclOperation.READ, this.resource()), (String)"User1 should have READ access from host1");
        AccessControlEntry writeAcl = new AccessControlEntry(user1.toString(), host1.getHostAddress(), AclOperation.WRITE, AclPermissionType.ALLOW);
        this.changeAclAndVerify((Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{writeAcl}))), (Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), this.changeAclAndVerify$default$4());
        AccessControlEntry denyWriteOnWildCardResourceAcl = new AccessControlEntry(user1.toString(), host1.getHostAddress(), AclOperation.WRITE, AclPermissionType.DENY);
        this.changeAclAndVerify(acls, (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{denyWriteOnWildCardResourceAcl}))), (Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), this.wildCardResource());
        Assertions.assertFalse((boolean)this.authorize(this.aclAuthorizer(), host1Context, AclOperation.WRITE, this.resource()), (String)"User1 should not have WRITE access from host1");
    }

    @Test
    public void testNoAclFound() {
        Assertions.assertFalse((boolean)this.authorize(this.aclAuthorizer(), this.requestContext(), AclOperation.READ, this.resource()), (String)"when acls = [], authorizer should deny op.");
    }

    @Test
    public void testNoAclFoundOverride() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(1, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20());
        props.put(AclAuthorizer$.MODULE$.AllowEveryoneIfNoAclIsFoundProp(), "true");
        KafkaConfig cfg = KafkaConfig$.MODULE$.fromProps(props);
        try (AclAuthorizer testAuthorizer = new AclAuthorizer();){
            testAuthorizer.configure(cfg.originals());
            Assertions.assertTrue((boolean)this.authorize(testAuthorizer, this.requestContext(), AclOperation.READ, this.resource()), (String)"when acls = null or [],  authorizer should allow op with allow.everyone = true.");
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testAclManagementAPIs() {
        KafkaPrincipal user1 = new KafkaPrincipal("User", this.username());
        KafkaPrincipal user2 = new KafkaPrincipal("User", "bob");
        String host1 = "host1";
        String host2 = "host2";
        AccessControlEntry acl1 = new AccessControlEntry(user1.toString(), host1, AclOperation.READ, AclPermissionType.ALLOW);
        AccessControlEntry acl2 = new AccessControlEntry(user1.toString(), host1, AclOperation.WRITE, AclPermissionType.ALLOW);
        AccessControlEntry acl3 = new AccessControlEntry(user2.toString(), host2, AclOperation.READ, AclPermissionType.ALLOW);
        AccessControlEntry acl4 = new AccessControlEntry(user2.toString(), host2, AclOperation.WRITE, AclPermissionType.ALLOW);
        Set<AccessControlEntry> acls = this.changeAclAndVerify((Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl1, acl2, acl3, acl4}))), (Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), this.changeAclAndVerify$default$4());
        AccessControlEntry acl5 = new AccessControlEntry(user2.toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.ALLOW);
        acls = this.changeAclAndVerify(acls, (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl5}))), (Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), this.changeAclAndVerify$default$4());
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!AclAuthorizerTest.$anonfun$testAclManagementAPIs$1(this, acl1, acl2, user1)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)AclAuthorizerTest.$anonfun$testAclManagementAPIs$3());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!AclAuthorizerTest.$anonfun$testAclManagementAPIs$4(this, acl3, acl4, acl5, user2)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)AclAuthorizerTest.$anonfun$testAclManagementAPIs$6());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        scala.collection.immutable.Map resourceToAcls = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new ResourcePattern(ResourceType.TOPIC, "*", PatternType.LITERAL)), (Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{new AccessControlEntry(user2.toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.ALLOW)}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new ResourcePattern(ResourceType.CLUSTER, "*", PatternType.LITERAL)), (Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{new AccessControlEntry(user2.toString(), host1, AclOperation.READ, AclPermissionType.ALLOW)}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new ResourcePattern(ResourceType.GROUP, "*", PatternType.LITERAL)), acls), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new ResourcePattern(ResourceType.GROUP, "test-ConsumerGroup", PatternType.LITERAL)), acls)}));
        resourceToAcls.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            ResourcePattern key = (ResourcePattern)x0$1._1();
            Set value = (Set)x0$1._2();
            Set<AccessControlEntry> set = this.changeAclAndVerify((Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), (Set<AccessControlEntry>)value, (Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), key);
            return set;
        });
        Set expectedAcls = ((TraversableOnce)resourceToAcls.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.resource()), acls)).flatMap((Function1 & Serializable & scala.Serializable)x0$2 -> {
            if (x0$2 == null) {
                throw new MatchError(null);
            }
            ResourcePattern res = (ResourcePattern)x0$2._1();
            Set set = (Set)((Set)x0$2._2()).map((Function1 & Serializable & scala.Serializable)acl -> new AclBinding(res, acl), Set$.MODULE$.canBuildFrom());
            return set;
        }, Iterable$.MODULE$.canBuildFrom())).toSet();
        long l5 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l6 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!AclAuthorizerTest.$anonfun$testAclManagementAPIs$10(this, expectedAcls)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)AclAuthorizerTest.$anonfun$testAclManagementAPIs$11());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.changeAclAndVerify(acls, (Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl1, acl5}))), this.changeAclAndVerify$default$4());
        acls = null;
        this.removeAcls((Authorizer)this.aclAuthorizer(), (Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), this.resource());
        TestUtils$.MODULE$.waitAndVerifyAcls((Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), (Authorizer)this.aclAuthorizer(), this.resource(), TestUtils$.MODULE$.waitAndVerifyAcls$default$4());
        Assertions.assertFalse((boolean)this.zkClient().resourceExists(this.resource()));
        acls = this.changeAclAndVerify((Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl1}))), (Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), this.changeAclAndVerify$default$4());
        this.changeAclAndVerify(acls, (Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), acls, this.changeAclAndVerify$default$4());
        Assertions.assertFalse((boolean)this.zkClient().resourceExists(this.resource()));
    }

    @Test
    public void testLoadCache() {
        KafkaPrincipal user1 = new KafkaPrincipal("User", this.username());
        AccessControlEntry acl1 = new AccessControlEntry(user1.toString(), "host-1", AclOperation.READ, AclPermissionType.ALLOW);
        Set acls = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl1}));
        this.addAcls((Authorizer)this.aclAuthorizer(), (Set<AccessControlEntry>)acls, this.resource());
        KafkaPrincipal user2 = new KafkaPrincipal("User", "bob");
        ResourcePattern resource1 = new ResourcePattern(ResourceType.TOPIC, "test-2", PatternType.LITERAL);
        AccessControlEntry acl2 = new AccessControlEntry(user2.toString(), "host3", AclOperation.READ, AclPermissionType.DENY);
        Set acls1 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl2}));
        this.addAcls((Authorizer)this.aclAuthorizer(), (Set<AccessControlEntry>)acls1, resource1);
        this.zkClient().deleteAclChangeNotifications();
        try (AclAuthorizer authorizer = new AclAuthorizer();){
            authorizer.configure(this.config().originals());
            Assertions.assertEquals((Object)acls, this.getAcls(authorizer, this.resource()));
            Assertions.assertEquals((Object)acls1, this.getAcls(authorizer, resource1));
        }
    }

    @Test
    public void testChangeListenerTiming() {
        Semaphore configureSemaphore = new Semaphore(0);
        Semaphore listenerSemaphore = new Semaphore(0);
        ExecutorService executor = Executors.newSingleThreadExecutor();
        AclAuthorizer aclAuthorizer3 = new AclAuthorizer(null, configureSemaphore, listenerSemaphore){
            private final Semaphore configureSemaphore$1;
            private final Semaphore listenerSemaphore$1;

            public void startZkChangeListeners() {
                this.configureSemaphore$1.release();
                this.listenerSemaphore$1.acquireUninterruptibly();
                super.startZkChangeListeners();
            }
            {
                this.configureSemaphore$1 = configureSemaphore$1;
                this.listenerSemaphore$1 = listenerSemaphore$1;
            }
        };
        try {
            Future<?> future = executor.submit(() -> aclAuthorizer3.configure(this.config().originals()));
            configureSemaphore.acquire();
            KafkaPrincipal user1 = new KafkaPrincipal("User", this.username());
            Set acls = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{new AccessControlEntry(user1.toString(), "host-1", AclOperation.READ, AclPermissionType.DENY)}));
            this.addAcls((Authorizer)this.aclAuthorizer(), (Set<AccessControlEntry>)acls, this.resource());
            listenerSemaphore.release();
            future.get(10L, TimeUnit.SECONDS);
            Assertions.assertEquals((Object)acls, this.getAcls(aclAuthorizer3, this.resource()));
        }
        finally {
            aclAuthorizer3.close();
            executor.shutdownNow();
        }
    }

    @Test
    public void testLocalConcurrentModificationOfResourceAcls() {
        ResourcePattern commonResource = new ResourcePattern(ResourceType.TOPIC, "test", PatternType.LITERAL);
        KafkaPrincipal user1 = new KafkaPrincipal("User", this.username());
        AccessControlEntry acl1 = new AccessControlEntry(user1.toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.ALLOW);
        KafkaPrincipal user2 = new KafkaPrincipal("User", "bob");
        AccessControlEntry acl2 = new AccessControlEntry(user2.toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.DENY);
        this.addAcls((Authorizer)this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl1}))), commonResource);
        this.addAcls((Authorizer)this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl2}))), commonResource);
        TestUtils$.MODULE$.waitAndVerifyAcls((Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl1, acl2}))), (Authorizer)this.aclAuthorizer(), commonResource, TestUtils$.MODULE$.waitAndVerifyAcls$default$4());
    }

    @Test
    public void testDistributedConcurrentModificationOfResourceAcls() {
        ResourcePattern commonResource = new ResourcePattern(ResourceType.TOPIC, "test", PatternType.LITERAL);
        KafkaPrincipal user1 = new KafkaPrincipal("User", this.username());
        AccessControlEntry acl1 = new AccessControlEntry(user1.toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.ALLOW);
        KafkaPrincipal user2 = new KafkaPrincipal("User", "bob");
        AccessControlEntry acl2 = new AccessControlEntry(user2.toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.DENY);
        this.addAcls((Authorizer)this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl1}))), commonResource);
        this.addAcls((Authorizer)this.aclAuthorizer2(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl2}))), commonResource);
        TestUtils$.MODULE$.waitAndVerifyAcls((Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl1, acl2}))), (Authorizer)this.aclAuthorizer(), commonResource, TestUtils$.MODULE$.waitAndVerifyAcls$default$4());
        TestUtils$.MODULE$.waitAndVerifyAcls((Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl1, acl2}))), (Authorizer)this.aclAuthorizer2(), commonResource, TestUtils$.MODULE$.waitAndVerifyAcls$default$4());
        KafkaPrincipal user3 = new KafkaPrincipal("User", "joe");
        AccessControlEntry acl3 = new AccessControlEntry(user3.toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.DENY);
        this.addAcls((Authorizer)this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl3}))), commonResource);
        Assertions.assertTrue((boolean)this.removeAcls((Authorizer)this.aclAuthorizer2(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl3}))), commonResource), (String)"The authorizer should see a value that needs to be deleted");
        TestUtils$.MODULE$.waitAndVerifyAcls((Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl1, acl2}))), (Authorizer)this.aclAuthorizer(), commonResource, TestUtils$.MODULE$.waitAndVerifyAcls$default$4());
        TestUtils$.MODULE$.waitAndVerifyAcls((Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl1, acl2}))), (Authorizer)this.aclAuthorizer2(), commonResource, TestUtils$.MODULE$.waitAndVerifyAcls$default$4());
    }

    @Test
    public void testHighConcurrencyModificationOfResourceAcls() {
        ResourcePattern commonResource = new ResourcePattern(ResourceType.TOPIC, "test", PatternType.LITERAL);
        IndexedSeq acls = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 50).map((Function1 & Serializable & scala.Serializable)i -> AclAuthorizerTest.$anonfun$testHighConcurrencyModificationOfResourceAcls$1(BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
        IndexedSeq concurrentFuctions = (IndexedSeq)acls.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            AccessControlEntry acl = (AccessControlEntry)x0$1._1();
            int aclId = x0$1._2$mcI$sp();
            Function0 & Serializable & scala.Serializable intersect = (Function0 & Serializable & scala.Serializable)() -> {
                if (aclId % 2 == 0) {
                    this.addAcls((Authorizer)this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl}))), commonResource);
                } else {
                    this.addAcls((Authorizer)this.aclAuthorizer2(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl}))), commonResource);
                }
                if (aclId % 10 == 0) {
                    return BoxesRunTime.boxToBoolean((boolean)this.removeAcls((Authorizer)this.aclAuthorizer2(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl}))), commonResource));
                }
                return BoxedUnit.UNIT;
            };
            return intersect;
        }, IndexedSeq$.MODULE$.canBuildFrom());
        Set expectedAcls = ((TraversableOnce)((TraversableLike)acls.filter((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)AclAuthorizerTest.$anonfun$testHighConcurrencyModificationOfResourceAcls$4(x0$2)))).map((Function1 & Serializable & scala.Serializable)x$1 -> (AccessControlEntry)x$1._1(), IndexedSeq$.MODULE$.canBuildFrom())).toSet();
        TestUtils$.MODULE$.assertConcurrent("Should support many concurrent calls", (Seq<Function0<Object>>)concurrentFuctions, 30000);
        TestUtils$.MODULE$.waitAndVerifyAcls((Set<AccessControlEntry>)expectedAcls, (Authorizer)this.aclAuthorizer(), commonResource, TestUtils$.MODULE$.waitAndVerifyAcls$default$4());
        TestUtils$.MODULE$.waitAndVerifyAcls((Set<AccessControlEntry>)expectedAcls, (Authorizer)this.aclAuthorizer2(), commonResource, TestUtils$.MODULE$.waitAndVerifyAcls$default$4());
    }

    @Test
    public void testAclInheritance() {
        this.testImplicationsOfAllow(AclOperation.ALL, (Set<AclOperation>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AclOperation[]{AclOperation.READ, AclOperation.WRITE, AclOperation.CREATE, AclOperation.DELETE, AclOperation.ALTER, AclOperation.DESCRIBE, AclOperation.CLUSTER_ACTION, AclOperation.DESCRIBE_CONFIGS, AclOperation.ALTER_CONFIGS, AclOperation.IDEMPOTENT_WRITE}))));
        this.testImplicationsOfDeny(AclOperation.ALL, (Set<AclOperation>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AclOperation[]{AclOperation.READ, AclOperation.WRITE, AclOperation.CREATE, AclOperation.DELETE, AclOperation.ALTER, AclOperation.DESCRIBE, AclOperation.CLUSTER_ACTION, AclOperation.DESCRIBE_CONFIGS, AclOperation.ALTER_CONFIGS, AclOperation.IDEMPOTENT_WRITE}))));
        this.testImplicationsOfAllow(AclOperation.READ, (Set<AclOperation>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AclOperation[]{AclOperation.DESCRIBE}))));
        this.testImplicationsOfAllow(AclOperation.WRITE, (Set<AclOperation>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AclOperation[]{AclOperation.DESCRIBE}))));
        this.testImplicationsOfAllow(AclOperation.DELETE, (Set<AclOperation>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AclOperation[]{AclOperation.DESCRIBE}))));
        this.testImplicationsOfAllow(AclOperation.ALTER, (Set<AclOperation>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AclOperation[]{AclOperation.DESCRIBE}))));
        this.testImplicationsOfDeny(AclOperation.DESCRIBE, (Set<AclOperation>)((Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$)));
        this.testImplicationsOfAllow(AclOperation.ALTER_CONFIGS, (Set<AclOperation>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AclOperation[]{AclOperation.DESCRIBE_CONFIGS}))));
        this.testImplicationsOfDeny(AclOperation.DESCRIBE_CONFIGS, (Set<AclOperation>)((Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$)));
    }

    private void testImplicationsOfAllow(AclOperation parentOp, Set<AclOperation> allowedOps) {
        KafkaPrincipal user = new KafkaPrincipal("User", this.username());
        InetAddress host = InetAddress.getByName("192.168.3.1");
        RequestContext hostContext = this.newRequestContext(user, host, this.newRequestContext$default$3());
        AccessControlEntry acl = new AccessControlEntry(user.toString(), AclEntry$.MODULE$.WildcardHost(), parentOp, AclPermissionType.ALLOW);
        this.addAcls((Authorizer)this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl}))), this.clusterResource());
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])AclOperation.values())).filter((Function1 & Serializable & scala.Serializable)op -> BoxesRunTime.boxToBoolean((boolean)this.validOp(op))))).foreach((Function1 & Serializable & scala.Serializable)op -> {
            AclAuthorizerTest.$anonfun$testImplicationsOfAllow$2(this, hostContext, allowedOps, parentOp, op);
            return BoxedUnit.UNIT;
        });
        this.removeAcls((Authorizer)this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl}))), this.clusterResource());
    }

    private void testImplicationsOfDeny(AclOperation parentOp, Set<AclOperation> deniedOps) {
        KafkaPrincipal user1 = new KafkaPrincipal("User", this.username());
        InetAddress host1 = InetAddress.getByName("192.168.3.1");
        RequestContext host1Context = this.newRequestContext(user1, host1, this.newRequestContext$default$3());
        Set acls = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{new AccessControlEntry(user1.toString(), AclEntry$.MODULE$.WildcardHost(), parentOp, AclPermissionType.DENY), new AccessControlEntry(user1.toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.ALL, AclPermissionType.ALLOW)}));
        this.addAcls((Authorizer)this.aclAuthorizer(), (Set<AccessControlEntry>)acls, this.clusterResource());
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])AclOperation.values())).filter((Function1 & Serializable & scala.Serializable)op -> BoxesRunTime.boxToBoolean((boolean)this.validOp(op))))).foreach((Function1 & Serializable & scala.Serializable)op -> {
            AclAuthorizerTest.$anonfun$testImplicationsOfDeny$2(this, host1Context, deniedOps, parentOp, op);
            return BoxedUnit.UNIT;
        });
        this.removeAcls((Authorizer)this.aclAuthorizer(), (Set<AccessControlEntry>)acls, this.clusterResource());
    }

    @Test
    public void testHighConcurrencyDeletionOfResourceAcls() {
        AccessControlEntry acl = new AccessControlEntry(new KafkaPrincipal("User", this.username()).toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.ALL, AclPermissionType.ALLOW);
        IndexedSeq concurrentFuctions = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 50).map((Function1 & Serializable & scala.Serializable)x$2 -> AclAuthorizerTest.$anonfun$testHighConcurrencyDeletionOfResourceAcls$1(this, acl, BoxesRunTime.unboxToInt((Object)x$2)), IndexedSeq$.MODULE$.canBuildFrom());
        TestUtils$.MODULE$.assertConcurrent("Should support many concurrent calls", (Seq<Function0<Object>>)concurrentFuctions, 30000);
        TestUtils$.MODULE$.waitAndVerifyAcls((Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), (Authorizer)this.aclAuthorizer(), this.resource(), TestUtils$.MODULE$.waitAndVerifyAcls$default$4());
        TestUtils$.MODULE$.waitAndVerifyAcls((Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), (Authorizer)this.aclAuthorizer2(), this.resource(), TestUtils$.MODULE$.waitAndVerifyAcls$default$4());
    }

    @Test
    public void testAccessAllowedIfAllowAclExistsOnWildcardResource() {
        this.addAcls((Authorizer)this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowReadAcl()}))), this.wildCardResource());
        Assertions.assertTrue((boolean)this.authorize(this.aclAuthorizer(), this.requestContext(), AclOperation.READ, this.resource()));
    }

    @Test
    public void testDeleteAclOnWildcardResource() {
        this.addAcls((Authorizer)this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowReadAcl(), this.allowWriteAcl()}))), this.wildCardResource());
        this.removeAcls((Authorizer)this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowReadAcl()}))), this.wildCardResource());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowWriteAcl()})), this.getAcls(this.aclAuthorizer(), this.wildCardResource()));
    }

    @Test
    public void testDeleteAllAclOnWildcardResource() {
        this.addAcls((Authorizer)this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowReadAcl()}))), this.wildCardResource());
        this.removeAcls((Authorizer)this.aclAuthorizer(), (Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), this.wildCardResource());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), this.getAcls(this.aclAuthorizer()));
    }

    @Test
    public void testAccessAllowedIfAllowAclExistsOnPrefixedResource() {
        this.addAcls((Authorizer)this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowReadAcl()}))), this.prefixedResource());
        Assertions.assertTrue((boolean)this.authorize(this.aclAuthorizer(), this.requestContext(), AclOperation.READ, this.resource()));
    }

    @Test
    public void testDeleteAclOnPrefixedResource() {
        this.addAcls((Authorizer)this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowReadAcl(), this.allowWriteAcl()}))), this.prefixedResource());
        this.removeAcls((Authorizer)this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowReadAcl()}))), this.prefixedResource());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowWriteAcl()})), this.getAcls(this.aclAuthorizer(), this.prefixedResource()));
    }

    @Test
    public void testDeleteAllAclOnPrefixedResource() {
        this.addAcls((Authorizer)this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowReadAcl(), this.allowWriteAcl()}))), this.prefixedResource());
        this.removeAcls((Authorizer)this.aclAuthorizer(), (Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), this.prefixedResource());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), this.getAcls(this.aclAuthorizer()));
    }

    @Test
    public void testAddAclsOnLiteralResource() {
        this.addAcls((Authorizer)this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowReadAcl(), this.allowWriteAcl()}))), this.resource());
        this.addAcls((Authorizer)this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowWriteAcl(), this.denyReadAcl()}))), this.resource());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowReadAcl(), this.allowWriteAcl(), this.denyReadAcl()})), this.getAcls(this.aclAuthorizer(), this.resource()));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), this.getAcls(this.aclAuthorizer(), this.wildCardResource()));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), this.getAcls(this.aclAuthorizer(), this.prefixedResource()));
    }

    @Test
    public void testAddAclsOnWildcardResource() {
        this.addAcls((Authorizer)this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowReadAcl(), this.allowWriteAcl()}))), this.wildCardResource());
        this.addAcls((Authorizer)this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowWriteAcl(), this.denyReadAcl()}))), this.wildCardResource());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowReadAcl(), this.allowWriteAcl(), this.denyReadAcl()})), this.getAcls(this.aclAuthorizer(), this.wildCardResource()));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), this.getAcls(this.aclAuthorizer(), this.resource()));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), this.getAcls(this.aclAuthorizer(), this.prefixedResource()));
    }

    @Test
    public void testAddAclsOnPrefixedResource() {
        this.addAcls((Authorizer)this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowReadAcl(), this.allowWriteAcl()}))), this.prefixedResource());
        this.addAcls((Authorizer)this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowWriteAcl(), this.denyReadAcl()}))), this.prefixedResource());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowReadAcl(), this.allowWriteAcl(), this.denyReadAcl()})), this.getAcls(this.aclAuthorizer(), this.prefixedResource()));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), this.getAcls(this.aclAuthorizer(), this.wildCardResource()));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), this.getAcls(this.aclAuthorizer(), this.resource()));
    }

    @Test
    public void testAuthorizeWithPrefixedResource() {
        this.addAcls((Authorizer)this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.denyReadAcl()}))), new ResourcePattern(ResourceType.TOPIC, "a_other", PatternType.LITERAL));
        this.addAcls((Authorizer)this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.denyReadAcl()}))), new ResourcePattern(ResourceType.TOPIC, "a_other", PatternType.PREFIXED));
        this.addAcls((Authorizer)this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.denyReadAcl()}))), new ResourcePattern(ResourceType.TOPIC, new StringBuilder(4).append("foo-").append(UUID.randomUUID()).toString(), PatternType.PREFIXED));
        this.addAcls((Authorizer)this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.denyReadAcl()}))), new ResourcePattern(ResourceType.TOPIC, new StringBuilder(4).append("foo-").append(UUID.randomUUID()).toString(), PatternType.PREFIXED));
        this.addAcls((Authorizer)this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.denyReadAcl()}))), new ResourcePattern(ResourceType.TOPIC, new StringBuilder(8).append("foo-").append(UUID.randomUUID()).append("-zzz").toString(), PatternType.PREFIXED));
        this.addAcls((Authorizer)this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.denyReadAcl()}))), new ResourcePattern(ResourceType.TOPIC, new StringBuilder(5).append("fooo-").append(UUID.randomUUID()).toString(), PatternType.PREFIXED));
        this.addAcls((Authorizer)this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.denyReadAcl()}))), new ResourcePattern(ResourceType.TOPIC, new StringBuilder(3).append("fo-").append(UUID.randomUUID()).toString(), PatternType.PREFIXED));
        this.addAcls((Authorizer)this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.denyReadAcl()}))), new ResourcePattern(ResourceType.TOPIC, new StringBuilder(4).append("fop-").append(UUID.randomUUID()).toString(), PatternType.PREFIXED));
        this.addAcls((Authorizer)this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.denyReadAcl()}))), new ResourcePattern(ResourceType.TOPIC, new StringBuilder(4).append("fon-").append(UUID.randomUUID()).toString(), PatternType.PREFIXED));
        this.addAcls((Authorizer)this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.denyReadAcl()}))), new ResourcePattern(ResourceType.TOPIC, "fon-", PatternType.PREFIXED));
        this.addAcls((Authorizer)this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.denyReadAcl()}))), new ResourcePattern(ResourceType.TOPIC, "z_other", PatternType.PREFIXED));
        this.addAcls((Authorizer)this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.denyReadAcl()}))), new ResourcePattern(ResourceType.TOPIC, "z_other", PatternType.LITERAL));
        this.addAcls((Authorizer)this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowReadAcl()}))), this.prefixedResource());
        Assertions.assertTrue((boolean)this.authorize(this.aclAuthorizer(), this.requestContext(), AclOperation.READ, this.resource()));
    }

    @Test
    public void testSingleCharacterResourceAcls() {
        this.addAcls((Authorizer)this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowReadAcl()}))), new ResourcePattern(ResourceType.TOPIC, "f", PatternType.LITERAL));
        Assertions.assertTrue((boolean)this.authorize(this.aclAuthorizer(), this.requestContext(), AclOperation.READ, new ResourcePattern(ResourceType.TOPIC, "f", PatternType.LITERAL)));
        Assertions.assertFalse((boolean)this.authorize(this.aclAuthorizer(), this.requestContext(), AclOperation.READ, new ResourcePattern(ResourceType.TOPIC, "foo", PatternType.LITERAL)));
        this.addAcls((Authorizer)this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowReadAcl()}))), new ResourcePattern(ResourceType.TOPIC, "_", PatternType.PREFIXED));
        Assertions.assertTrue((boolean)this.authorize(this.aclAuthorizer(), this.requestContext(), AclOperation.READ, new ResourcePattern(ResourceType.TOPIC, "_foo", PatternType.LITERAL)));
        Assertions.assertTrue((boolean)this.authorize(this.aclAuthorizer(), this.requestContext(), AclOperation.READ, new ResourcePattern(ResourceType.TOPIC, "_", PatternType.LITERAL)));
        Assertions.assertFalse((boolean)this.authorize(this.aclAuthorizer(), this.requestContext(), AclOperation.READ, new ResourcePattern(ResourceType.TOPIC, "foo_", PatternType.LITERAL)));
    }

    @Test
    public void testGetAclsPrincipal() {
        AccessControlEntry aclOnSpecificPrincipal = new AccessControlEntry(this.principal().toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.WRITE, AclPermissionType.ALLOW);
        this.addAcls((Authorizer)this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{aclOnSpecificPrincipal}))), this.resource());
        Assertions.assertEquals((int)0, (int)this.getAcls(this.aclAuthorizer(), this.wildcardPrincipal()).size(), (String)"acl on specific should not be returned for wildcard request");
        Assertions.assertEquals((int)1, (int)this.getAcls(this.aclAuthorizer(), this.principal()).size(), (String)"acl on specific should be returned for specific request");
        Assertions.assertEquals((int)1, (int)this.getAcls(this.aclAuthorizer(), new KafkaPrincipal(this.principal().getPrincipalType(), this.principal().getName())).size(), (String)"acl on specific should be returned for different principal instance");
        this.removeAcls((Authorizer)this.aclAuthorizer(), (Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), this.resource());
        AccessControlEntry aclOnWildcardPrincipal = new AccessControlEntry(AclEntry$.MODULE$.WildcardPrincipalString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.WRITE, AclPermissionType.ALLOW);
        this.addAcls((Authorizer)this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{aclOnWildcardPrincipal}))), this.resource());
        Assertions.assertEquals((int)1, (int)this.getAcls(this.aclAuthorizer(), this.wildcardPrincipal()).size(), (String)"acl on wildcard should be returned for wildcard request");
        Assertions.assertEquals((int)0, (int)this.getAcls(this.aclAuthorizer(), this.principal()).size(), (String)"acl on wildcard should not be returned for specific request");
    }

    @Test
    public void testAclsFilter() {
        ResourcePattern resource1 = new ResourcePattern(ResourceType.TOPIC, new StringBuilder(4).append("foo-").append(UUID.randomUUID()).toString(), PatternType.LITERAL);
        ResourcePattern resource2 = new ResourcePattern(ResourceType.TOPIC, new StringBuilder(4).append("bar-").append(UUID.randomUUID()).toString(), PatternType.LITERAL);
        ResourcePattern prefixedResource = new ResourcePattern(ResourceType.TOPIC, "bar-", PatternType.PREFIXED);
        AclBinding acl1 = new AclBinding(resource1, new AccessControlEntry(this.principal().toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.ALLOW));
        AclBinding acl2 = new AclBinding(resource1, new AccessControlEntry(this.principal().toString(), "192.168.0.1", AclOperation.WRITE, AclPermissionType.ALLOW));
        AclBinding acl3 = new AclBinding(resource2, new AccessControlEntry(this.principal().toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.DESCRIBE, AclPermissionType.ALLOW));
        AclBinding acl4 = new AclBinding(prefixedResource, new AccessControlEntry(this.wildcardPrincipal().toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.ALLOW));
        this.aclAuthorizer().createAcls((AuthorizableRequestContext)this.requestContext(), (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)acl1, (List)new .colon.colon((Object)acl2, (List)new .colon.colon((Object)acl3, (List)new .colon.colon((Object)acl4, (List)Nil$.MODULE$))))).asJava());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AclBinding[]{acl1, acl2, acl3, acl4})), (Object)((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(this.aclAuthorizer().acls(AclBindingFilter.ANY)).asScala()).toSet());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AclBinding[]{acl1, acl2})), (Object)((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(this.aclAuthorizer().acls(new AclBindingFilter(resource1.toFilter(), AccessControlEntryFilter.ANY))).asScala()).toSet());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AclBinding[]{acl4})), (Object)((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(this.aclAuthorizer().acls(new AclBindingFilter(prefixedResource.toFilter(), AccessControlEntryFilter.ANY))).asScala()).toSet());
        AclBindingFilter matchingFilter = new AclBindingFilter(new ResourcePatternFilter(ResourceType.ANY, resource2.name(), PatternType.MATCH), AccessControlEntryFilter.ANY);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AclBinding[]{acl3, acl4})), (Object)((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(this.aclAuthorizer().acls(matchingFilter)).asScala()).toSet());
        .colon.colon filters = new .colon.colon((Object)matchingFilter, (List)new .colon.colon((Object)acl1.toFilter(), (List)new .colon.colon((Object)new AclBindingFilter(resource2.toFilter(), AccessControlEntryFilter.ANY), (List)new .colon.colon((Object)new AclBindingFilter(new ResourcePatternFilter(ResourceType.TOPIC, "baz", PatternType.ANY), AccessControlEntryFilter.ANY), (List)Nil$.MODULE$))));
        Buffer deleteResults = (Buffer)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(this.aclAuthorizer().deleteAcls((AuthorizableRequestContext)this.requestContext(), (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)filters).asJava())).asScala()).map((Function1 & Serializable & scala.Serializable)x$3 -> (AclDeleteResult)x$3.toCompletableFuture().get(), Buffer$.MODULE$.canBuildFrom());
        Assertions.assertEquals((Object)List$.MODULE$.empty(), (Object)deleteResults.filter((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)AclAuthorizerTest.$anonfun$testAclsFilter$2(x$4))));
        filters.indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)((TraversableOnce)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(((AclDeleteResult)deleteResults.apply(i)).aclBindingDeleteResults()).asScala()).toSet().filter((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)AclAuthorizerTest.$anonfun$testAclsFilter$4(x$5)))));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AclBinding[]{acl3, acl4})), (Object)((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(((AclDeleteResult)deleteResults.apply(0)).aclBindingDeleteResults()).asScala()).map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.aclBinding(), scala.collection.Iterable$.MODULE$.canBuildFrom())).toSet());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AclBinding[]{acl1})), (Object)((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(((AclDeleteResult)deleteResults.apply(1)).aclBindingDeleteResults()).asScala()).map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.aclBinding(), scala.collection.Iterable$.MODULE$.canBuildFrom())).toSet());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(((AclDeleteResult)deleteResults.apply(2)).aclBindingDeleteResults()).asScala()).map((Function1 & Serializable & scala.Serializable)x$8 -> x$8.aclBinding(), scala.collection.Iterable$.MODULE$.canBuildFrom())).toSet());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(((AclDeleteResult)deleteResults.apply(3)).aclBindingDeleteResults()).asScala()).map((Function1 & Serializable & scala.Serializable)x$9 -> x$9.aclBinding(), scala.collection.Iterable$.MODULE$.canBuildFrom())).toSet());
    }

    @Test
    public void testThrowsOnAddPrefixedAclIfInterBrokerProtocolVersionTooLow() {
        this.givenAuthorizerWithProtocolVersion((Option<ApiVersion>)Option$.MODULE$.apply((Object)KAFKA_2_0_IV0$.MODULE$));
        ApiException e = (ApiException)Assertions.assertThrows(ApiException.class, () -> this.addAcls((Authorizer)this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.denyReadAcl()}))), new ResourcePattern(ResourceType.TOPIC, "z_other", PatternType.PREFIXED)));
        Assertions.assertTrue((boolean)(e.getCause() instanceof UnsupportedVersionException), (String)new StringBuilder(21).append("Unexpected exception ").append(e).toString());
    }

    @Test
    public void testWritesExtendedAclChangeEventIfInterBrokerProtocolNotSet() {
        this.givenAuthorizerWithProtocolVersion((Option<ApiVersion>)Option$.MODULE$.empty());
        ResourcePattern resource = new ResourcePattern(ResourceType.TOPIC, "z_other", PatternType.PREFIXED);
        String expected = new String(ZkAclStore$.MODULE$.apply(PatternType.PREFIXED).changeStore().createChangeNode(resource).bytes(), StandardCharsets.UTF_8);
        this.addAcls((Authorizer)this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.denyReadAcl()}))), resource);
        String actual = this.getAclChangeEventAsString(PatternType.PREFIXED);
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testWritesExtendedAclChangeEventWhenInterBrokerProtocolAtLeastKafkaV2() {
        this.givenAuthorizerWithProtocolVersion((Option<ApiVersion>)Option$.MODULE$.apply((Object)KAFKA_2_0_IV1$.MODULE$));
        ResourcePattern resource = new ResourcePattern(ResourceType.TOPIC, "z_other", PatternType.PREFIXED);
        String expected = new String(ZkAclStore$.MODULE$.apply(PatternType.PREFIXED).changeStore().createChangeNode(resource).bytes(), StandardCharsets.UTF_8);
        this.addAcls((Authorizer)this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.denyReadAcl()}))), resource);
        String actual = this.getAclChangeEventAsString(PatternType.PREFIXED);
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testWritesLiteralWritesLiteralAclChangeEventWhenInterBrokerProtocolLessThanKafkaV2eralAclChangesForOlderProtocolVersions() {
        this.givenAuthorizerWithProtocolVersion((Option<ApiVersion>)Option$.MODULE$.apply((Object)KAFKA_2_0_IV0$.MODULE$));
        ResourcePattern resource = new ResourcePattern(ResourceType.TOPIC, "z_other", PatternType.LITERAL);
        String expected = new String(ZkAclStore$.MODULE$.apply(PatternType.LITERAL).changeStore().createChangeNode(resource).bytes(), StandardCharsets.UTF_8);
        this.addAcls((Authorizer)this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.denyReadAcl()}))), resource);
        String actual = this.getAclChangeEventAsString(PatternType.LITERAL);
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testWritesLiteralAclChangeEventWhenInterBrokerProtocolIsKafkaV2() {
        this.givenAuthorizerWithProtocolVersion((Option<ApiVersion>)Option$.MODULE$.apply((Object)KAFKA_2_0_IV1$.MODULE$));
        ResourcePattern resource = new ResourcePattern(ResourceType.TOPIC, "z_other", PatternType.LITERAL);
        String expected = new String(ZkAclStore$.MODULE$.apply(PatternType.LITERAL).changeStore().createChangeNode(resource).bytes(), StandardCharsets.UTF_8);
        this.addAcls((Authorizer)this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.denyReadAcl()}))), resource);
        String actual = this.getAclChangeEventAsString(PatternType.LITERAL);
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testAuthorizerNoZkConfig() {
        Properties noTlsProps = Kafka$.MODULE$.getPropsFromArgs((String[])((Object[])new String[]{this.prepareDefaultConfig()}));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)AclAuthorizer$.MODULE$.zkClientConfigFromKafkaConfigAndMap(KafkaConfig$.MODULE$.fromProps(noTlsProps), (scala.collection.mutable.Map)Map$.MODULE$.apply(((MapLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter((Map)noTlsProps).asScala()).toSeq())));
    }

    @Test
    public void testAuthorizerZkConfigFromKafkaConfigWithDefaults() {
        Properties props = new Properties();
        String kafkaValue = "kafkaValue";
        scala.collection.immutable.Map configs = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"zookeeper.connect"), (Object)"somewhere"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ZkSslClientEnableProp()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ZkClientCnxnSocketProp()), (Object)kafkaValue), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ZkSslKeyStoreLocationProp()), (Object)kafkaValue), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ZkSslKeyStorePasswordProp()), (Object)kafkaValue), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ZkSslKeyStoreTypeProp()), (Object)kafkaValue), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ZkSslTrustStoreLocationProp()), (Object)kafkaValue), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ZkSslTrustStorePasswordProp()), (Object)kafkaValue), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ZkSslTrustStoreTypeProp()), (Object)kafkaValue), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ZkSslEnabledProtocolsProp()), (Object)kafkaValue), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ZkSslCipherSuitesProp()), (Object)kafkaValue)}));
        configs.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            String key = (String)x0$1._1();
            String value = (String)x0$1._2();
            Object object = props.put(key, value.toString());
            return object;
        });
        Option zkClientConfig = AclAuthorizer$.MODULE$.zkClientConfigFromKafkaConfigAndMap(KafkaConfig$.MODULE$.fromProps(props), (scala.collection.mutable.Map)Map$.MODULE$.apply(configs.toSeq()));
        Assertions.assertTrue((boolean)zkClientConfig.isDefined());
        KafkaConfig$.MODULE$.ZkSslConfigToSystemPropertyMap().keys().foreach((Function1 & Serializable & scala.Serializable)prop -> {
            AclAuthorizerTest.$anonfun$testAuthorizerZkConfigFromKafkaConfigWithDefaults$2(zkClientConfig, kafkaValue, prop);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testAuthorizerZkConfigFromKafkaConfig() {
        Properties props = new Properties();
        String kafkaValue = "kafkaValue";
        scala.collection.immutable.Map configs = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"zookeeper.connect"), (Object)"somewhere"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ZkSslClientEnableProp()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ZkClientCnxnSocketProp()), (Object)kafkaValue), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ZkSslKeyStoreLocationProp()), (Object)kafkaValue), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ZkSslKeyStorePasswordProp()), (Object)kafkaValue), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ZkSslKeyStoreTypeProp()), (Object)kafkaValue), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ZkSslTrustStoreLocationProp()), (Object)kafkaValue), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ZkSslTrustStorePasswordProp()), (Object)kafkaValue), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ZkSslTrustStoreTypeProp()), (Object)kafkaValue), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ZkSslProtocolProp()), (Object)kafkaValue), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ZkSslEnabledProtocolsProp()), (Object)kafkaValue), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ZkSslCipherSuitesProp()), (Object)kafkaValue), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ZkSslEndpointIdentificationAlgorithmProp()), (Object)"HTTPS"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ZkSslCrlEnableProp()), (Object)"false"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ZkSslOcspEnableProp()), (Object)"false")}));
        configs.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            String key = (String)x0$1._1();
            String value = (String)x0$1._2();
            Object object = props.put(key, value.toString());
            return object;
        });
        Option zkClientConfig = AclAuthorizer$.MODULE$.zkClientConfigFromKafkaConfigAndMap(KafkaConfig$.MODULE$.fromProps(props), (scala.collection.mutable.Map)Map$.MODULE$.apply(configs.toSeq()));
        Assertions.assertTrue((boolean)zkClientConfig.isDefined());
        KafkaConfig$.MODULE$.ZkSslConfigToSystemPropertyMap().keys().foreach((Function1 & Serializable & scala.Serializable)prop -> {
            AclAuthorizerTest.$anonfun$testAuthorizerZkConfigFromKafkaConfig$2(zkClientConfig, kafkaValue, prop);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testAuthorizerZkConfigFromPrefixOverrides() {
        Properties props = new Properties();
        String kafkaValue = "kafkaValue";
        String prefixedValue = "prefixedValue";
        String prefix = "authorizer.";
        scala.collection.immutable.Map configs = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"zookeeper.connect"), (Object)"somewhere"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ZkSslClientEnableProp()), (Object)"false"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ZkClientCnxnSocketProp()), (Object)kafkaValue), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ZkSslKeyStoreLocationProp()), (Object)kafkaValue), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ZkSslKeyStorePasswordProp()), (Object)kafkaValue), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ZkSslKeyStoreTypeProp()), (Object)kafkaValue), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ZkSslTrustStoreLocationProp()), (Object)kafkaValue), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ZkSslTrustStorePasswordProp()), (Object)kafkaValue), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ZkSslTrustStoreTypeProp()), (Object)kafkaValue), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ZkSslProtocolProp()), (Object)kafkaValue), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ZkSslEnabledProtocolsProp()), (Object)kafkaValue), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ZkSslCipherSuitesProp()), (Object)kafkaValue), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ZkSslEndpointIdentificationAlgorithmProp()), (Object)"HTTPS"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ZkSslCrlEnableProp()), (Object)"false"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ZkSslOcspEnableProp()), (Object)"false"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(0).append(prefix).append(KafkaConfig$.MODULE$.ZkSslClientEnableProp()).toString()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(0).append(prefix).append(KafkaConfig$.MODULE$.ZkClientCnxnSocketProp()).toString()), (Object)prefixedValue), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(0).append(prefix).append(KafkaConfig$.MODULE$.ZkSslKeyStoreLocationProp()).toString()), (Object)prefixedValue), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(0).append(prefix).append(KafkaConfig$.MODULE$.ZkSslKeyStorePasswordProp()).toString()), (Object)prefixedValue), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(0).append(prefix).append(KafkaConfig$.MODULE$.ZkSslKeyStoreTypeProp()).toString()), (Object)prefixedValue), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(0).append(prefix).append(KafkaConfig$.MODULE$.ZkSslTrustStoreLocationProp()).toString()), (Object)prefixedValue), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(0).append(prefix).append(KafkaConfig$.MODULE$.ZkSslTrustStorePasswordProp()).toString()), (Object)prefixedValue), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(0).append(prefix).append(KafkaConfig$.MODULE$.ZkSslTrustStoreTypeProp()).toString()), (Object)prefixedValue), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(0).append(prefix).append(KafkaConfig$.MODULE$.ZkSslProtocolProp()).toString()), (Object)prefixedValue), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(0).append(prefix).append(KafkaConfig$.MODULE$.ZkSslEnabledProtocolsProp()).toString()), (Object)prefixedValue), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(0).append(prefix).append(KafkaConfig$.MODULE$.ZkSslCipherSuitesProp()).toString()), (Object)prefixedValue), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(0).append(prefix).append(KafkaConfig$.MODULE$.ZkSslEndpointIdentificationAlgorithmProp()).toString()), (Object)""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(0).append(prefix).append(KafkaConfig$.MODULE$.ZkSslCrlEnableProp()).toString()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(0).append(prefix).append(KafkaConfig$.MODULE$.ZkSslOcspEnableProp()).toString()), (Object)"true")}));
        configs.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            String key = (String)x0$1._1();
            String value = (String)x0$1._2();
            Object object = props.put(key, value.toString());
            return object;
        });
        Option zkClientConfig = AclAuthorizer$.MODULE$.zkClientConfigFromKafkaConfigAndMap(KafkaConfig$.MODULE$.fromProps(props), (scala.collection.mutable.Map)Map$.MODULE$.apply(configs.toSeq()));
        Assertions.assertTrue((boolean)zkClientConfig.isDefined());
        KafkaConfig$.MODULE$.ZkSslConfigToSystemPropertyMap().keys().foreach((Function1 & Serializable & scala.Serializable)prop -> {
            AclAuthorizerTest.$anonfun$testAuthorizerZkConfigFromPrefixOverrides$2(zkClientConfig, prefixedValue, prop);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testCreateDeleteTiming() {
        ResourcePattern literalResource = new ResourcePattern(ResourceType.TOPIC, new StringBuilder(4).append("foo-").append(UUID.randomUUID()).toString(), PatternType.LITERAL);
        ResourcePattern prefixedResource = new ResourcePattern(ResourceType.TOPIC, "bar-", PatternType.PREFIXED);
        ResourcePattern wildcardResource = new ResourcePattern(ResourceType.TOPIC, "*", PatternType.LITERAL);
        AccessControlEntry ace = new AccessControlEntry(this.principal().toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.ALLOW);
        Semaphore updateSemaphore = new Semaphore(1);
        try (AclAuthorizer deleteAuthorizer = new AclAuthorizer(null, updateSemaphore){
            private final Semaphore updateSemaphore$1;

            public void processAclChangeNotification(ResourcePattern resource) {
                this.updateSemaphore$1.acquire();
                try {
                    super.processAclChangeNotification(resource);
                }
                finally {
                    this.updateSemaphore$1.release();
                }
            }
            {
                this.updateSemaphore$1 = updateSemaphore$1;
            }
        };){
            deleteAuthorizer.configure(this.config().originals());
            new .colon.colon((Object)literalResource, (List)new .colon.colon((Object)prefixedResource, (List)new .colon.colon((Object)wildcardResource, (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)resource -> {
                AclAuthorizerTest.$anonfun$testCreateDeleteTiming$9(this, deleteAuthorizer, updateSemaphore, ace, resource);
                return BoxedUnit.UNIT;
            });
        }
    }

    @Test
    public void testAuthorizeByResourceTypeNoAclFoundOverride() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(1, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20());
        props.put(AclAuthorizer$.MODULE$.AllowEveryoneIfNoAclIsFoundProp(), "true");
        KafkaConfig cfg = KafkaConfig$.MODULE$.fromProps(props);
        try (AclAuthorizer aclAuthorizer = new AclAuthorizer();){
            aclAuthorizer.configure(cfg.originals());
            Assertions.assertTrue((boolean)this.authorizeByResourceType((Authorizer)aclAuthorizer, this.requestContext(), AclOperation.READ, this.resource().resourceType()), (String)"If allow.everyone.if.no.acl.found = true, caller should have read access to at least one topic");
            Assertions.assertTrue((boolean)this.authorizeByResourceType((Authorizer)aclAuthorizer, this.requestContext(), AclOperation.WRITE, this.resource().resourceType()), (String)"If allow.everyone.if.no.acl.found = true, caller should have write access to at least one topic");
        }
    }

    private void givenAuthorizerWithProtocolVersion(Option<ApiVersion> protocolVersion) {
        this.aclAuthorizer().close();
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20());
        props.put(AclAuthorizer$.MODULE$.SuperUsersProp(), this.superUsers());
        protocolVersion.foreach((Function1 & Serializable & scala.Serializable)version -> props.put(KafkaConfig$.MODULE$.InterBrokerProtocolVersionProp(), version.toString()));
        this.config_$eq(KafkaConfig$.MODULE$.fromProps(props));
        this.aclAuthorizer().configure(this.config().originals());
    }

    private String getAclChangeEventAsString(PatternType patternType) {
        ZkAclStore store = ZkAclStore$.MODULE$.apply(patternType);
        GetChildrenResponse children = (GetChildrenResponse)this.zooKeeperClient().handleRequest((AsyncRequest)new GetChildrenRequest(store.changeStore().aclChangePath(), true, GetChildrenRequest$.MODULE$.apply$default$3()));
        children.maybeThrow();
        Assertions.assertEquals((int)1, (int)children.children().size(), (String)"Expecting 1 change event");
        GetDataResponse data = (GetDataResponse)this.zooKeeperClient().handleRequest((AsyncRequest)new GetDataRequest(new StringBuilder(1).append(store.changeStore().aclChangePath()).append("/").append(children.children().head()).toString(), GetDataRequest$.MODULE$.apply$default$2()));
        data.maybeThrow();
        return new String(data.data(), StandardCharsets.UTF_8);
    }

    private Set<AccessControlEntry> changeAclAndVerify(Set<AccessControlEntry> originalAcls, Set<AccessControlEntry> addedAcls, Set<AccessControlEntry> removedAcls, ResourcePattern resource) {
        Set acls = originalAcls;
        if (addedAcls.nonEmpty()) {
            this.addAcls((Authorizer)this.aclAuthorizer(), addedAcls, resource);
            acls = (Set)originalAcls.$plus$plus(addedAcls);
        }
        if (removedAcls.nonEmpty()) {
            this.removeAcls((Authorizer)this.aclAuthorizer(), removedAcls, resource);
            acls = (Set)acls.$minus$minus(removedAcls);
        }
        TestUtils$.MODULE$.waitAndVerifyAcls((Set<AccessControlEntry>)acls, (Authorizer)this.aclAuthorizer(), resource, TestUtils$.MODULE$.waitAndVerifyAcls$default$4());
        return acls;
    }

    private ResourcePattern changeAclAndVerify$default$4() {
        return this.resource();
    }

    private boolean authorize(AclAuthorizer authorizer, RequestContext requestContext, AclOperation operation, ResourcePattern resource) {
        Action action = new Action(operation, resource, 1, true, true);
        Object object = ((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(authorizer.authorize((AuthorizableRequestContext)requestContext, (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)action, (List)Nil$.MODULE$)).asJava())).asScala()).head();
        AuthorizationResult authorizationResult = AuthorizationResult.ALLOWED;
        return !(object != null ? !object.equals(authorizationResult) : authorizationResult != null);
    }

    private Set<AccessControlEntry> getAcls(AclAuthorizer authorizer, ResourcePattern resourcePattern) {
        return (Set)((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(authorizer.acls(new AclBindingFilter(resourcePattern.toFilter(), AccessControlEntryFilter.ANY))).asScala()).toSet().map((Function1 & Serializable & scala.Serializable)x$14 -> x$14.entry(), Set$.MODULE$.canBuildFrom());
    }

    private Set<AclBinding> getAcls(AclAuthorizer authorizer, KafkaPrincipal principal) {
        AclBindingFilter filter = new AclBindingFilter(ResourcePatternFilter.ANY, new AccessControlEntryFilter(principal.toString(), null, AclOperation.ANY, AclPermissionType.ANY));
        return ((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(authorizer.acls(filter)).asScala()).toSet();
    }

    private Set<AclBinding> getAcls(AclAuthorizer authorizer) {
        return ((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(authorizer.acls(AclBindingFilter.ANY)).asScala()).toSet();
    }

    private boolean validOp(AclOperation op) {
        AclOperation aclOperation = op;
        AclOperation aclOperation2 = AclOperation.ANY;
        if (aclOperation == null ? aclOperation2 != null : !aclOperation.equals(aclOperation2)) {
            AclOperation aclOperation3 = op;
            AclOperation aclOperation4 = AclOperation.UNKNOWN;
            if (aclOperation3 == null ? aclOperation4 != null : !aclOperation3.equals(aclOperation4)) {
                return true;
            }
        }
        return false;
    }

    private String prepareDefaultConfig() {
        return this.prepareConfig((String[])((Object[])new String[]{"broker.id=1", "zookeeper.connect=somewhere"}));
    }

    private String prepareConfig(String[] lines) {
        String string;
        File file = File.createTempFile("kafkatest", ".properties");
        file.deleteOnExit();
        try (OutputStream writer = Files.newOutputStream(file.toPath(), new OpenOption[0]);){
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])lines)).foreach((Function1 & Serializable & scala.Serializable)l -> {
                AclAuthorizerTest.$anonfun$prepareConfig$1(writer, l);
                return BoxedUnit.UNIT;
            });
            string = file.getAbsolutePath();
        }
        return string;
    }

    public static final /* synthetic */ boolean $anonfun$testAclManagementAPIs$1(AclAuthorizerTest $this, AccessControlEntry acl1$1, AccessControlEntry acl2$1, KafkaPrincipal user1$1) {
        Object object = ((SetLike)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl1$1, acl2$1}))).map((Function1 & Serializable & scala.Serializable)acl -> new AclBinding($this.resource(), acl), Set$.MODULE$.canBuildFrom());
        Set<AclBinding> set = $this.getAcls($this.aclAuthorizer(), user1$1);
        return !(object != null ? !object.equals(set) : set != null);
    }

    public static final /* synthetic */ String $anonfun$testAclManagementAPIs$3() {
        return "changes not propagated in timeout period";
    }

    public static final /* synthetic */ boolean $anonfun$testAclManagementAPIs$4(AclAuthorizerTest $this, AccessControlEntry acl3$1, AccessControlEntry acl4$1, AccessControlEntry acl5$1, KafkaPrincipal user2$1) {
        Object object = ((SetLike)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl3$1, acl4$1, acl5$1}))).map((Function1 & Serializable & scala.Serializable)acl -> new AclBinding($this.resource(), acl), Set$.MODULE$.canBuildFrom());
        Set<AclBinding> set = $this.getAcls($this.aclAuthorizer(), user2$1);
        return !(object != null ? !object.equals(set) : set != null);
    }

    public static final /* synthetic */ String $anonfun$testAclManagementAPIs$6() {
        return "changes not propagated in timeout period";
    }

    public static final /* synthetic */ boolean $anonfun$testAclManagementAPIs$10(AclAuthorizerTest $this, Set expectedAcls$1) {
        Set set = expectedAcls$1;
        Set<AclBinding> set2 = $this.getAcls($this.aclAuthorizer());
        return !(set != null ? !set.equals(set2) : set2 != null);
    }

    public static final /* synthetic */ String $anonfun$testAclManagementAPIs$11() {
        return "changes not propagated in timeout period.";
    }

    public static final /* synthetic */ Tuple2 $anonfun$testHighConcurrencyModificationOfResourceAcls$1(int i) {
        KafkaPrincipal useri = new KafkaPrincipal("User", Integer.toString(i));
        return new Tuple2((Object)new AccessControlEntry(useri.toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.ALLOW), (Object)BoxesRunTime.boxToInteger((int)i));
    }

    public static final /* synthetic */ boolean $anonfun$testHighConcurrencyModificationOfResourceAcls$4(Tuple2 x0$2) {
        if (x0$2 == null) {
            throw new MatchError(null);
        }
        boolean bl = x0$2._2$mcI$sp() % 10 != 0;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$testImplicationsOfAllow$2(AclAuthorizerTest $this, RequestContext hostContext$1, Set allowedOps$1, AclOperation parentOp$1, AclOperation op) {
        boolean authorized;
        block3: {
            block2: {
                authorized = $this.authorize($this.aclAuthorizer(), hostContext$1, op, $this.clusterResource());
                if (allowedOps$1.contains((Object)op)) break block2;
                AclOperation aclOperation = op;
                if (aclOperation != null ? !aclOperation.equals(parentOp$1) : parentOp$1 != null) break block3;
            }
            Assertions.assertTrue((boolean)authorized, (String)new StringBuilder(26).append("ALLOW ").append(parentOp$1).append(" should imply ALLOW ").append(op).toString());
            return;
        }
        Assertions.assertFalse((boolean)authorized, (String)new StringBuilder(30).append("ALLOW ").append(parentOp$1).append(" should not imply ALLOW ").append(op).toString());
    }

    public static final /* synthetic */ void $anonfun$testImplicationsOfDeny$2(AclAuthorizerTest $this, RequestContext host1Context$1, Set deniedOps$1, AclOperation parentOp$2, AclOperation op) {
        boolean authorized;
        block3: {
            block2: {
                authorized = $this.authorize($this.aclAuthorizer(), host1Context$1, op, $this.clusterResource());
                if (deniedOps$1.contains((Object)op)) break block2;
                AclOperation aclOperation = op;
                if (aclOperation != null ? !aclOperation.equals(parentOp$2) : parentOp$2 != null) break block3;
            }
            Assertions.assertFalse((boolean)authorized, (String)new StringBuilder(24).append("DENY ").append(parentOp$2).append(" should imply DENY ").append(op).toString());
            return;
        }
        Assertions.assertTrue((boolean)authorized, (String)new StringBuilder(28).append("DENY ").append(parentOp$2).append(" should not imply DENY ").append(op).toString());
    }

    public static final /* synthetic */ Function0 $anonfun$testHighConcurrencyDeletionOfResourceAcls$1(AclAuthorizerTest $this, AccessControlEntry acl$2, int x$2) {
        return (JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            $this.addAcls((Authorizer)$this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl$2}))), $this.resource());
            return $this.removeAcls((Authorizer)$this.aclAuthorizer2(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl$2}))), $this.resource());
        };
    }

    public static final /* synthetic */ boolean $anonfun$testAclsFilter$2(AclDeleteResult x$4) {
        return x$4.exception().isPresent();
    }

    public static final /* synthetic */ boolean $anonfun$testAclsFilter$4(AclDeleteResult.AclBindingDeleteResult x$5) {
        return x$5.exception().isPresent();
    }

    public static final /* synthetic */ void $anonfun$testAuthorizerZkConfigFromKafkaConfigWithDefaults$2(Option zkClientConfig$1, String kafkaValue$1, String prop) {
        boolean bl;
        boolean bl2;
        String string = KafkaConfig$.MODULE$.ZkSslClientEnableProp();
        if (!(string != null ? !string.equals(prop) : prop != null)) {
            bl2 = true;
        } else {
            String string2 = KafkaConfig$.MODULE$.ZkSslEndpointIdentificationAlgorithmProp();
            bl2 = !(string2 != null ? !string2.equals(prop) : prop != null);
        }
        if (bl2) {
            Assertions.assertEquals((Object)"true", (Object)KafkaConfig$.MODULE$.getZooKeeperClientProperty((ZKClientConfig)zkClientConfig$1.get(), prop).getOrElse((Function0 & Serializable & scala.Serializable)() -> "<None>"));
            return;
        }
        String string3 = KafkaConfig$.MODULE$.ZkSslCrlEnableProp();
        if (!(string3 != null ? !string3.equals(prop) : prop != null)) {
            bl = true;
        } else {
            String string4 = KafkaConfig$.MODULE$.ZkSslOcspEnableProp();
            bl = !(string4 != null ? !string4.equals(prop) : prop != null);
        }
        if (bl) {
            Assertions.assertEquals((Object)"false", (Object)KafkaConfig$.MODULE$.getZooKeeperClientProperty((ZKClientConfig)zkClientConfig$1.get(), prop).getOrElse((Function0 & Serializable & scala.Serializable)() -> "<None>"));
            return;
        }
        String string5 = KafkaConfig$.MODULE$.ZkSslProtocolProp();
        if (!(string5 != null ? !string5.equals(prop) : prop != null)) {
            Assertions.assertEquals((Object)"TLSv1.2", (Object)KafkaConfig$.MODULE$.getZooKeeperClientProperty((ZKClientConfig)zkClientConfig$1.get(), prop).getOrElse((Function0 & Serializable & scala.Serializable)() -> "<None>"));
            return;
        }
        Assertions.assertEquals((Object)kafkaValue$1, (Object)KafkaConfig$.MODULE$.getZooKeeperClientProperty((ZKClientConfig)zkClientConfig$1.get(), prop).getOrElse((Function0 & Serializable & scala.Serializable)() -> "<None>"));
    }

    public static final /* synthetic */ void $anonfun$testAuthorizerZkConfigFromKafkaConfig$2(Option zkClientConfig$2, String kafkaValue$2, String prop) {
        boolean bl;
        boolean bl2;
        String string = KafkaConfig$.MODULE$.ZkSslClientEnableProp();
        if (!(string != null ? !string.equals(prop) : prop != null)) {
            bl2 = true;
        } else {
            String string2 = KafkaConfig$.MODULE$.ZkSslEndpointIdentificationAlgorithmProp();
            bl2 = !(string2 != null ? !string2.equals(prop) : prop != null);
        }
        if (bl2) {
            Assertions.assertEquals((Object)"true", (Object)KafkaConfig$.MODULE$.getZooKeeperClientProperty((ZKClientConfig)zkClientConfig$2.get(), prop).getOrElse((Function0 & Serializable & scala.Serializable)() -> "<None>"));
            return;
        }
        String string3 = KafkaConfig$.MODULE$.ZkSslCrlEnableProp();
        if (!(string3 != null ? !string3.equals(prop) : prop != null)) {
            bl = true;
        } else {
            String string4 = KafkaConfig$.MODULE$.ZkSslOcspEnableProp();
            bl = !(string4 != null ? !string4.equals(prop) : prop != null);
        }
        if (bl) {
            Assertions.assertEquals((Object)"false", (Object)KafkaConfig$.MODULE$.getZooKeeperClientProperty((ZKClientConfig)zkClientConfig$2.get(), prop).getOrElse((Function0 & Serializable & scala.Serializable)() -> "<None>"));
            return;
        }
        Assertions.assertEquals((Object)kafkaValue$2, (Object)KafkaConfig$.MODULE$.getZooKeeperClientProperty((ZKClientConfig)zkClientConfig$2.get(), prop).getOrElse((Function0 & Serializable & scala.Serializable)() -> "<None>"));
    }

    public static final /* synthetic */ void $anonfun$testAuthorizerZkConfigFromPrefixOverrides$2(Option zkClientConfig$3, String prefixedValue$1, String prop) {
        boolean bl;
        String string = KafkaConfig$.MODULE$.ZkSslClientEnableProp();
        if (!(string != null ? !string.equals(prop) : prop != null)) {
            bl = true;
        } else {
            String string2 = KafkaConfig$.MODULE$.ZkSslCrlEnableProp();
            if (!(string2 != null ? !string2.equals(prop) : prop != null)) {
                bl = true;
            } else {
                String string3 = KafkaConfig$.MODULE$.ZkSslOcspEnableProp();
                bl = !(string3 != null ? !string3.equals(prop) : prop != null);
            }
        }
        if (bl) {
            Assertions.assertEquals((Object)"true", (Object)KafkaConfig$.MODULE$.getZooKeeperClientProperty((ZKClientConfig)zkClientConfig$3.get(), prop).getOrElse((Function0 & Serializable & scala.Serializable)() -> "<None>"));
            return;
        }
        String string4 = KafkaConfig$.MODULE$.ZkSslEndpointIdentificationAlgorithmProp();
        if (!(string4 != null ? !string4.equals(prop) : prop != null)) {
            Assertions.assertEquals((Object)"false", (Object)KafkaConfig$.MODULE$.getZooKeeperClientProperty((ZKClientConfig)zkClientConfig$3.get(), prop).getOrElse((Function0 & Serializable & scala.Serializable)() -> "<None>"));
            return;
        }
        Assertions.assertEquals((Object)prefixedValue$1, (Object)KafkaConfig$.MODULE$.getZooKeeperClientProperty((ZKClientConfig)zkClientConfig$3.get(), prop).getOrElse((Function0 & Serializable & scala.Serializable)() -> "<None>"));
    }

    private final AclBinding createAcl$1(AclAuthorizer createAuthorizer, ResourcePattern resource, AccessControlEntry ace$1) {
        AclBinding acl = new AclBinding(resource, ace$1);
        ((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(createAuthorizer.createAcls((AuthorizableRequestContext)this.requestContext(), Collections.singletonList(acl))).asScala()).foreach((Function1 & Serializable & scala.Serializable)x$10 -> (AclCreateResult)x$10.toCompletableFuture().get(15L, TimeUnit.SECONDS));
        return acl;
    }

    private final List deleteAcl$1(AclAuthorizer deleteAuthorizer, ResourcePattern resource, PatternType deletePatternType) {
        AclBindingFilter filter = new AclBindingFilter(new ResourcePatternFilter(resource.resourceType(), resource.name(), deletePatternType), AccessControlEntryFilter.ANY);
        return ((TraversableOnce)((TraversableLike)((TraversableLike)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(deleteAuthorizer.deleteAcls((AuthorizableRequestContext)this.requestContext(), Collections.singletonList(filter))).asScala()).map((Function1 & Serializable & scala.Serializable)x$11 -> (AclDeleteResult)x$11.toCompletableFuture().get(15L, TimeUnit.SECONDS), Buffer$.MODULE$.canBuildFrom())).flatMap((Function1 & Serializable & scala.Serializable)x$12 -> (Iterable)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(x$12.aclBindingDeleteResults()).asScala(), Buffer$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$13 -> x$13.aclBinding(), Buffer$.MODULE$.canBuildFrom())).toList();
    }

    private static final List listAcls$1(AclAuthorizer authorizer) {
        return ((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(authorizer.acls(AclBindingFilter.ANY)).asScala()).toList();
    }

    public static final /* synthetic */ boolean $anonfun$testCreateDeleteTiming$5(AclAuthorizer deleteAuthorizer$1) {
        return AclAuthorizerTest.listAcls$1(deleteAuthorizer$1).nonEmpty();
    }

    public static final /* synthetic */ String $anonfun$testCreateDeleteTiming$6() {
        return "ACL not propagated";
    }

    public static final /* synthetic */ boolean $anonfun$testCreateDeleteTiming$7(AclAuthorizer deleteAuthorizer$1) {
        return AclAuthorizerTest.listAcls$1(deleteAuthorizer$1).isEmpty();
    }

    public static final /* synthetic */ String $anonfun$testCreateDeleteTiming$8() {
        return "ACL delete not propagated";
    }

    /*
     * WARNING - void declaration
     */
    private final void verifyCreateDeleteAcl$1(AclAuthorizer deleteAuthorizer, ResourcePattern resource, PatternType deletePatternType, Semaphore updateSemaphore$1, AccessControlEntry ace$1) {
        updateSemaphore$1.acquire();
        Assertions.assertEquals((Object)List$.MODULE$.empty(), (Object)AclAuthorizerTest.listAcls$1(deleteAuthorizer));
        AclBinding acl = this.createAcl$1(this.aclAuthorizer(), resource, ace$1);
        List deleted = this.deleteAcl$1(deleteAuthorizer, resource, deletePatternType);
        PatternType patternType = deletePatternType;
        PatternType patternType2 = PatternType.MATCH;
        if (patternType == null ? patternType2 != null : !patternType.equals(patternType2)) {
            Assertions.assertEquals((Object)new .colon.colon((Object)acl, (List)Nil$.MODULE$), (Object)deleted);
        } else {
            Assertions.assertEquals((Object)List$.MODULE$.empty(), (Object)deleted);
        }
        updateSemaphore$1.release();
        PatternType patternType3 = deletePatternType;
        PatternType patternType4 = PatternType.MATCH;
        if (!(patternType3 != null ? !patternType3.equals(patternType4) : patternType4 != null)) {
            long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
            long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
            if (TestUtils$.MODULE$ == null) {
                throw null;
            }
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!AclAuthorizerTest.$anonfun$testCreateDeleteTiming$5(deleteAuthorizer)) {
                void waitUntilTrue_pause;
                void waitUntilTrue_waitTimeMs;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)AclAuthorizerTest.$anonfun$testCreateDeleteTiming$6());
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            Assertions.assertEquals((Object)new .colon.colon((Object)acl, (List)Nil$.MODULE$), (Object)this.deleteAcl$1(deleteAuthorizer, resource, deletePatternType));
        }
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!AclAuthorizerTest.$anonfun$testCreateDeleteTiming$7(deleteAuthorizer)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)AclAuthorizerTest.$anonfun$testCreateDeleteTiming$8());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    public static final /* synthetic */ void $anonfun$testCreateDeleteTiming$9(AclAuthorizerTest $this, AclAuthorizer deleteAuthorizer$2, Semaphore updateSemaphore$1, AccessControlEntry ace$1, ResourcePattern resource) {
        $this.verifyCreateDeleteAcl$1(deleteAuthorizer$2, resource, resource.patternType(), updateSemaphore$1, ace$1);
        $this.verifyCreateDeleteAcl$1(deleteAuthorizer$2, resource, PatternType.ANY, updateSemaphore$1, ace$1);
        $this.verifyCreateDeleteAcl$1(deleteAuthorizer$2, resource, PatternType.MATCH, updateSemaphore$1, ace$1);
    }

    public static final /* synthetic */ void $anonfun$prepareConfig$1(OutputStream writer$1, String l) {
        writer$1.write(l.getBytes());
        writer$1.write("\n".getBytes());
    }

    public AclAuthorizerTest() {
        BaseAuthorizerTest.$init$(this);
        this.allowReadAcl = new AccessControlEntry(AclEntry$.MODULE$.WildcardPrincipalString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.ALLOW);
        this.allowWriteAcl = new AccessControlEntry(AclEntry$.MODULE$.WildcardPrincipalString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.WRITE, AclPermissionType.ALLOW);
        this.denyReadAcl = new AccessControlEntry(AclEntry$.MODULE$.WildcardPrincipalString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.DENY);
        this.wildCardResource = new ResourcePattern(ResourceType.TOPIC, "*", PatternType.LITERAL);
        this.prefixedResource = new ResourcePattern(ResourceType.TOPIC, "foo", PatternType.PREFIXED);
        this.clusterResource = new ResourcePattern(ResourceType.CLUSTER, "kafka-cluster", PatternType.LITERAL);
        this.wildcardPrincipal = SecurityUtils.parseKafkaPrincipal((String)AclEntry$.MODULE$.WildcardPrincipalString());
        this.aclAuthorizer = new AclAuthorizer();
        this.aclAuthorizer2 = new AclAuthorizer();
    }

    public class CustomPrincipal
    extends KafkaPrincipal {
        public boolean equals(Object o) {
            return false;
        }

        public /* synthetic */ AclAuthorizerTest kafka$security$authorizer$AclAuthorizerTest$CustomPrincipal$$$outer() {
            return AclAuthorizerTest.this;
        }

        public CustomPrincipal(String principalType, String name) {
            if (AclAuthorizerTest.this == null) {
                throw null;
            }
            super(principalType, name);
        }
    }
}

