/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import kafka.server.BrokerToControllerQueueItem;
import kafka.server.BrokerToControllerRequestThread;
import kafka.server.BrokerToControllerRequestThreadTest$TestRequestCompletionHandler$;
import kafka.server.ControllerNodeProvider;
import kafka.server.ControllerRequestCompletionHandler;
import kafka.server.KafkaConfig;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.clients.KafkaClient;
import org.apache.kafka.clients.ManualMetadataUpdater;
import org.apache.kafka.clients.Metadata;
import org.apache.kafka.clients.MockClient;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.message.MetadataRequestData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.MetadataRequest;
import org.apache.kafka.common.requests.MetadataResponse;
import org.apache.kafka.common.requests.RequestTestUtils;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015c\u0001\u0002\r\u001a\u0001yAQ!\n\u0001\u0005\u0002\u0019BQ!\u000b\u0001\u0005\u0002)BQa\u000f\u0001\u0005\u0002)BQ!\u0010\u0001\u0005\u0002)BQa\u0010\u0001\u0005\u0002)BQ!\u0011\u0001\u0005\u0002)BQa\u0011\u0001\u0005\u0002)BQ!\u0012\u0001\u0005\u0002)BQa\u0012\u0001\u0005\n!Cqa\u0017\u0001\u0012\u0002\u0013%AL\u0002\u0003h\u0001\u0001A\u0007\u0002\u00037\f\u0005\u0003\u0005\u000b\u0011B7\t\u000b\u0015ZA\u0011A>\t\u0011}\\!\u0019!C\u0001\u0003\u0003A\u0001\"a\u0007\fA\u0003%\u00111\u0001\u0005\n\u0003;Y!\u0019!C\u0001\u0003\u0003A\u0001\"a\b\fA\u0003%\u00111\u0001\u0005\b\u0003CYA\u0011IA\u0012\u0011\u0019\t)d\u0003C!U\u001dI\u0011q\u0007\u0001\u0002\u0002#\u0005\u0011\u0011\b\u0004\tO\u0002\t\t\u0011#\u0001\u0002<!1Q%\u0006C\u0001\u0003{A\u0011\"a\u0010\u0016#\u0003%\t!!\u0011\u0003G\t\u0013xn[3s)>\u001cuN\u001c;s_2dWM\u001d*fcV,7\u000f\u001e+ie\u0016\fG\rV3ti*\u0011!dG\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003q\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001?A\u0011\u0001eI\u0007\u0002C)\t!%A\u0003tG\u0006d\u0017-\u0003\u0002%C\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#A\u0014\u0011\u0005!\u0002Q\"A\r\u0002WQ,7\u000f\u001e*fiJLH+[7f_V$x\u000b[5mK\u000e{g\u000e\u001e:pY2,'OT8u\u0003Z\f\u0017\u000e\\1cY\u0016$\u0012a\u000b\t\u0003A1J!!L\u0011\u0003\tUs\u0017\u000e\u001e\u0015\u0003\u0005=\u0002\"\u0001M\u001d\u000e\u0003ER!AM\u001a\u0002\u0007\u0005\u0004\u0018N\u0003\u00025k\u00059!.\u001e9ji\u0016\u0014(B\u0001\u001c8\u0003\u0015QWO\\5u\u0015\u0005A\u0014aA8sO&\u0011!(\r\u0002\u0005)\u0016\u001cH/\u0001\tuKN$(+Z9vKN$8oU3oi\"\u00121aL\u0001\u0016i\u0016\u001cHoQ8oiJ|G\u000e\\3s\u0007\"\fgnZ3eQ\t!q&A\tuKN$hj\u001c;D_:$(o\u001c7mKJD#!B\u0018\u0002!Q,7\u000f\u001e*fiJLH+[7f_V$\bF\u0001\u00040\u0003y!Xm\u001d;V]N,\b\u000f]8si\u0016$g+\u001a:tS>t\u0007*\u00198eY&tw\r\u000b\u0002\b_\u0005\u0019C/Z:u\u0003V$\b.\u001a8uS\u000e\fG/[8o\u000bb\u001cW\r\u001d;j_:D\u0015M\u001c3mS:<\u0007F\u0001\u00050\u0003%\u0001x\u000e\u001c7V]RLG\u000e\u0006\u0003,\u0013:3\u0006\"\u0002&\n\u0001\u0004Y\u0015!\u0004:fcV,7\u000f\u001e+ie\u0016\fG\r\u0005\u0002)\u0019&\u0011Q*\u0007\u0002 \u0005J|7.\u001a:U_\u000e{g\u000e\u001e:pY2,'OU3rk\u0016\u001cH\u000f\u00165sK\u0006$\u0007\"B(\n\u0001\u0004\u0001\u0016!C2p]\u0012LG/[8o!\r\u0001\u0013kU\u0005\u0003%\u0006\u0012\u0011BR;oGRLwN\u001c\u0019\u0011\u0005\u0001\"\u0016BA+\"\u0005\u001d\u0011un\u001c7fC:DqaV\u0005\u0011\u0002\u0003\u0007\u0001,\u0001\u0006nCb\u0014V\r\u001e:jKN\u0004\"\u0001I-\n\u0005i\u000b#aA%oi\u0006\u0019\u0002o\u001c7m+:$\u0018\u000e\u001c\u0013eK\u001a\fW\u000f\u001c;%gU\tQL\u000b\u0002Y=.\nq\f\u0005\u0002aK6\t\u0011M\u0003\u0002cG\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0003I\u0006\n!\"\u00198o_R\fG/[8o\u0013\t1\u0017MA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\u0014A\u0004V3tiJ+\u0017/^3ti\u000e{W\u000e\u001d7fi&|g\u000eS1oI2,'o\u0005\u0002\fSB\u0011\u0001F[\u0005\u0003Wf\u0011!eQ8oiJ|G\u000e\\3s%\u0016\fX/Z:u\u0007>l\u0007\u000f\\3uS>t\u0007*\u00198eY\u0016\u0014\u0018\u0001E3ya\u0016\u001cG/\u001a3SKN\u0004xN\\:f!\r\u0001c\u000e]\u0005\u0003_\u0006\u0012aa\u00149uS>t\u0007CA9z\u001b\u0005\u0011(BA:u\u0003!\u0011X-];fgR\u001c(BA;w\u0003\u0019\u0019w.\\7p]*\u0011Ad\u001e\u0006\u0003q^\na!\u00199bG\",\u0017B\u0001>s\u0005AiU\r^1eCR\f'+Z:q_:\u001cX\r\u0006\u0002}}B\u0011QpC\u0007\u0002\u0001!9A.\u0004I\u0001\u0002\u0004i\u0017!C2p[BdW\r^3e+\t\t\u0019\u0001\u0005\u0003\u0002\u0006\u0005]QBAA\u0004\u0015\u0011\tI!a\u0003\u0002\r\u0005$x.\\5d\u0015\u0011\ti!a\u0004\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0003\u0002\u0012\u0005M\u0011\u0001B;uS2T!!!\u0006\u0002\t)\fg/Y\u0005\u0005\u00033\t9AA\u0007Bi>l\u0017n\u0019\"p_2,\u0017M\\\u0001\u000bG>l\u0007\u000f\\3uK\u0012\u0004\u0013\u0001\u0003;j[\u0016$w*\u001e;\u0002\u0013QLW.\u001a3PkR\u0004\u0013AC8o\u0007>l\u0007\u000f\\3uKR\u00191&!\n\t\u000f\u0005\u001d\"\u00031\u0001\u0002*\u0005A!/Z:q_:\u001cX\r\u0005\u0003\u0002,\u0005ERBAA\u0017\u0015\r\tyC^\u0001\bG2LWM\u001c;t\u0013\u0011\t\u0019$!\f\u0003\u001d\rc\u0017.\u001a8u%\u0016\u001c\bo\u001c8tK\u0006IqN\u001c+j[\u0016|W\u000f^\u0001\u001d)\u0016\u001cHOU3rk\u0016\u001cHoQ8na2,G/[8o\u0011\u0006tG\r\\3s!\tiXc\u0005\u0002\u0016?Q\u0011\u0011\u0011H\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005\r#FA7_\u0001")
public class BrokerToControllerRequestThreadTest {
    private volatile BrokerToControllerRequestThreadTest$TestRequestCompletionHandler$ TestRequestCompletionHandler$module;

    public BrokerToControllerRequestThreadTest$TestRequestCompletionHandler$ TestRequestCompletionHandler() {
        if (this.TestRequestCompletionHandler$module == null) {
            this.TestRequestCompletionHandler$lzycompute$1();
        }
        return this.TestRequestCompletionHandler$module;
    }

    @Test
    public void testRetryTimeoutWhileControllerNotAvailable() {
        MockTime time = new MockTime();
        KafkaConfig config = new KafkaConfig((Map)TestUtils$.MODULE$.createBrokerConfig(1, "localhost:2181", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20()));
        Metadata metadata = (Metadata)Mockito.mock(Metadata.class);
        MockClient mockClient = new MockClient((Time)time, metadata);
        ControllerNodeProvider controllerNodeProvider = (ControllerNodeProvider)Mockito.mock(ControllerNodeProvider.class);
        Mockito.when((Object)controllerNodeProvider.get()).thenReturn((Object)None$.MODULE$);
        int retryTimeoutMs = 30000;
        BrokerToControllerRequestThread testRequestThread = new BrokerToControllerRequestThread((KafkaClient)mockClient, new ManualMetadataUpdater(), controllerNodeProvider, config, (Time)time, "", (long)retryTimeoutMs);
        TestRequestCompletionHandler completionHandler = new TestRequestCompletionHandler(this, (Option<MetadataResponse>)None$.MODULE$);
        BrokerToControllerQueueItem queueItem = new BrokerToControllerQueueItem(time.milliseconds(), (AbstractRequest.Builder)new MetadataRequest.Builder(new MetadataRequestData()), (ControllerRequestCompletionHandler)completionHandler);
        testRequestThread.enqueue(queueItem);
        testRequestThread.doWork();
        Assertions.assertEquals((int)1, (int)testRequestThread.queueSize());
        time.sleep((long)retryTimeoutMs);
        testRequestThread.doWork();
        Assertions.assertEquals((int)0, (int)testRequestThread.queueSize());
        Assertions.assertTrue((boolean)completionHandler.timedOut().get());
    }

    @Test
    public void testRequestsSent() {
        MockTime time = new MockTime();
        KafkaConfig config = new KafkaConfig((Map)TestUtils$.MODULE$.createBrokerConfig(1, "localhost:2181", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20()));
        int controllerId = 2;
        Metadata metadata = (Metadata)Mockito.mock(Metadata.class);
        MockClient mockClient = new MockClient((Time)time, metadata);
        ControllerNodeProvider controllerNodeProvider = (ControllerNodeProvider)Mockito.mock(ControllerNodeProvider.class);
        Node activeController = new Node(controllerId, "host", 1234);
        Mockito.when((Object)controllerNodeProvider.get()).thenReturn((Object)new Some((Object)activeController));
        MetadataResponse expectedResponse = RequestTestUtils.metadataUpdateWith((int)2, Collections.singletonMap("a", Predef$.MODULE$.int2Integer(2)));
        BrokerToControllerRequestThread testRequestThread = new BrokerToControllerRequestThread((KafkaClient)mockClient, new ManualMetadataUpdater(), controllerNodeProvider, config, (Time)time, "", Long.MAX_VALUE);
        mockClient.prepareResponse((AbstractResponse)expectedResponse);
        TestRequestCompletionHandler completionHandler = new TestRequestCompletionHandler(this, (Option<MetadataResponse>)new Some((Object)expectedResponse));
        BrokerToControllerQueueItem queueItem = new BrokerToControllerQueueItem(time.milliseconds(), (AbstractRequest.Builder)new MetadataRequest.Builder(new MetadataRequestData()), (ControllerRequestCompletionHandler)completionHandler);
        testRequestThread.enqueue(queueItem);
        Assertions.assertEquals((int)1, (int)testRequestThread.queueSize());
        testRequestThread.doWork();
        testRequestThread.doWork();
        Assertions.assertEquals((int)0, (int)testRequestThread.queueSize());
        Assertions.assertTrue((boolean)completionHandler.completed().get());
    }

    @Test
    public void testControllerChanged() {
        MockTime time = new MockTime();
        KafkaConfig config = new KafkaConfig((Map)TestUtils$.MODULE$.createBrokerConfig(1, "localhost:2181", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20()));
        int oldControllerId = 1;
        int newControllerId = 2;
        Metadata metadata = (Metadata)Mockito.mock(Metadata.class);
        MockClient mockClient = new MockClient((Time)time, metadata);
        ControllerNodeProvider controllerNodeProvider = (ControllerNodeProvider)Mockito.mock(ControllerNodeProvider.class);
        Node oldController = new Node(oldControllerId, "host1", 1234);
        Node newController = new Node(newControllerId, "host2", 1234);
        Mockito.when((Object)controllerNodeProvider.get()).thenReturn((Object)new Some((Object)oldController), (Object[])new Option[]{new Some((Object)newController)});
        MetadataResponse expectedResponse = RequestTestUtils.metadataUpdateWith((int)3, Collections.singletonMap("a", Predef$.MODULE$.int2Integer(2)));
        BrokerToControllerRequestThread testRequestThread = new BrokerToControllerRequestThread((KafkaClient)mockClient, new ManualMetadataUpdater(), controllerNodeProvider, config, (Time)time, "", Long.MAX_VALUE);
        TestRequestCompletionHandler completionHandler = new TestRequestCompletionHandler(this, (Option<MetadataResponse>)new Some((Object)expectedResponse));
        BrokerToControllerQueueItem queueItem = new BrokerToControllerQueueItem(time.milliseconds(), (AbstractRequest.Builder)new MetadataRequest.Builder(new MetadataRequestData()), (ControllerRequestCompletionHandler)completionHandler);
        testRequestThread.enqueue(queueItem);
        mockClient.prepareResponse((AbstractResponse)expectedResponse);
        testRequestThread.doWork();
        Assertions.assertFalse((boolean)completionHandler.completed().get());
        mockClient.setUnreachable(oldController, time.milliseconds() + 5000L);
        testRequestThread.doWork();
        testRequestThread.doWork();
        testRequestThread.doWork();
        Assertions.assertTrue((boolean)completionHandler.completed().get());
    }

    @Test
    public void testNotController() {
        MockTime time = new MockTime();
        KafkaConfig config = new KafkaConfig((Map)TestUtils$.MODULE$.createBrokerConfig(1, "localhost:2181", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20()));
        int oldControllerId = 1;
        int newControllerId = 2;
        Metadata metadata = (Metadata)Mockito.mock(Metadata.class);
        MockClient mockClient = new MockClient((Time)time, metadata);
        ControllerNodeProvider controllerNodeProvider = (ControllerNodeProvider)Mockito.mock(ControllerNodeProvider.class);
        int port = 1234;
        Node oldController = new Node(oldControllerId, "host1", port);
        Node newController = new Node(newControllerId, "host2", port);
        Mockito.when((Object)controllerNodeProvider.get()).thenReturn((Object)new Some((Object)oldController), (Object[])new Option[]{new Some((Object)newController)});
        MetadataResponse responseWithNotControllerError = RequestTestUtils.metadataUpdateWith((String)"cluster1", (int)2, Collections.singletonMap("a", Errors.NOT_CONTROLLER), Collections.singletonMap("a", Predef$.MODULE$.int2Integer(2)));
        MetadataResponse expectedResponse = RequestTestUtils.metadataUpdateWith((int)3, Collections.singletonMap("a", Predef$.MODULE$.int2Integer(2)));
        BrokerToControllerRequestThread testRequestThread = new BrokerToControllerRequestThread((KafkaClient)mockClient, new ManualMetadataUpdater(), controllerNodeProvider, config, (Time)time, "", Long.MAX_VALUE);
        TestRequestCompletionHandler completionHandler = new TestRequestCompletionHandler(this, (Option<MetadataResponse>)new Some((Object)expectedResponse));
        BrokerToControllerQueueItem queueItem = new BrokerToControllerQueueItem(time.milliseconds(), (AbstractRequest.Builder)new MetadataRequest.Builder(new MetadataRequestData().setAllowAutoTopicCreation(true)), (ControllerRequestCompletionHandler)completionHandler);
        testRequestThread.enqueue(queueItem);
        testRequestThread.doWork();
        Node oldBrokerNode = new Node(oldControllerId, "host1", port);
        Assertions.assertEquals((Object)new Some((Object)oldBrokerNode), (Object)testRequestThread.activeControllerAddress());
        mockClient.prepareResponse(body -> body instanceof MetadataRequest && ((MetadataRequest)body).allowAutoTopicCreation(), (AbstractResponse)responseWithNotControllerError);
        testRequestThread.doWork();
        Assertions.assertEquals((Object)None$.MODULE$, (Object)testRequestThread.activeControllerAddress());
        testRequestThread.doWork();
        mockClient.prepareResponse((AbstractResponse)expectedResponse);
        testRequestThread.doWork();
        Node newControllerNode = new Node(newControllerId, "host2", port);
        Assertions.assertEquals((Object)new Some((Object)newControllerNode), (Object)testRequestThread.activeControllerAddress());
        Assertions.assertTrue((boolean)completionHandler.completed().get());
    }

    @Test
    public void testRetryTimeout() {
        MockTime time = new MockTime();
        KafkaConfig config = new KafkaConfig((Map)TestUtils$.MODULE$.createBrokerConfig(1, "localhost:2181", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20()));
        int controllerId = 1;
        Metadata metadata = (Metadata)Mockito.mock(Metadata.class);
        MockClient mockClient = new MockClient((Time)time, metadata);
        ControllerNodeProvider controllerNodeProvider = (ControllerNodeProvider)Mockito.mock(ControllerNodeProvider.class);
        Node controller = new Node(controllerId, "host1", 1234);
        Mockito.when((Object)controllerNodeProvider.get()).thenReturn((Object)new Some((Object)controller));
        int retryTimeoutMs = 30000;
        MetadataResponse responseWithNotControllerError = RequestTestUtils.metadataUpdateWith((String)"cluster1", (int)2, Collections.singletonMap("a", Errors.NOT_CONTROLLER), Collections.singletonMap("a", Predef$.MODULE$.int2Integer(2)));
        BrokerToControllerRequestThread testRequestThread = new BrokerToControllerRequestThread((KafkaClient)mockClient, new ManualMetadataUpdater(), controllerNodeProvider, config, (Time)time, "", (long)retryTimeoutMs);
        TestRequestCompletionHandler completionHandler = new TestRequestCompletionHandler(this, this.TestRequestCompletionHandler().$lessinit$greater$default$1());
        BrokerToControllerQueueItem queueItem = new BrokerToControllerQueueItem(time.milliseconds(), (AbstractRequest.Builder)new MetadataRequest.Builder(new MetadataRequestData().setAllowAutoTopicCreation(true)), (ControllerRequestCompletionHandler)completionHandler);
        testRequestThread.enqueue(queueItem);
        testRequestThread.doWork();
        time.sleep((long)retryTimeoutMs);
        mockClient.prepareResponse(body -> body instanceof MetadataRequest && ((MetadataRequest)body).allowAutoTopicCreation(), (AbstractResponse)responseWithNotControllerError);
        testRequestThread.doWork();
        Assertions.assertTrue((boolean)completionHandler.timedOut().get());
    }

    @Test
    public void testUnsupportedVersionHandling() {
        MockTime time = new MockTime();
        KafkaConfig config = new KafkaConfig((Map)TestUtils$.MODULE$.createBrokerConfig(1, "localhost:2181", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20()));
        int controllerId = 2;
        Metadata metadata = (Metadata)Mockito.mock(Metadata.class);
        MockClient mockClient = new MockClient((Time)time, metadata);
        ControllerNodeProvider controllerNodeProvider = (ControllerNodeProvider)Mockito.mock(ControllerNodeProvider.class);
        Node activeController = new Node(controllerId, "host", 1234);
        Mockito.when((Object)controllerNodeProvider.get()).thenReturn((Object)new Some((Object)activeController));
        AtomicReference callbackResponse = new AtomicReference();
        ControllerRequestCompletionHandler completionHandler = new ControllerRequestCompletionHandler(null, callbackResponse){
            private final AtomicReference callbackResponse$1;

            public void onTimeout() {
                Assertions.fail((String)"Unexpected timeout exception");
            }

            public void onComplete(ClientResponse response) {
                this.callbackResponse$1.set(response);
            }
            {
                this.callbackResponse$1 = callbackResponse$1;
            }
        };
        BrokerToControllerQueueItem queueItem = new BrokerToControllerQueueItem(time.milliseconds(), (AbstractRequest.Builder)new MetadataRequest.Builder(new MetadataRequestData()), completionHandler);
        mockClient.prepareUnsupportedVersionResponse(request -> {
            ApiKeys apiKeys = request.apiKey();
            ApiKeys apiKeys2 = ApiKeys.METADATA;
            return !(apiKeys != null ? !apiKeys.equals(apiKeys2) : apiKeys2 != null);
        });
        BrokerToControllerRequestThread testRequestThread = new BrokerToControllerRequestThread((KafkaClient)mockClient, new ManualMetadataUpdater(), controllerNodeProvider, config, (Time)time, "", Long.MAX_VALUE);
        testRequestThread.enqueue(queueItem);
        int pollUntil_maxRetries = this.pollUntil$default$3();
        int pollUntil_tries = 0;
        do {
            testRequestThread.doWork();
        } while (!BrokerToControllerRequestThreadTest.$anonfun$testUnsupportedVersionHandling$2(callbackResponse) && ++pollUntil_tries < pollUntil_maxRetries);
        if (!BrokerToControllerRequestThreadTest.$anonfun$testUnsupportedVersionHandling$2(callbackResponse)) {
            Assertions.fail((String)new StringBuilder(47).append("Condition failed to be met after polling ").append(pollUntil_tries).append(" times").toString());
        }
        Assertions.assertNotNull((Object)((ClientResponse)callbackResponse.get()).versionMismatch());
    }

    @Test
    public void testAuthenticationExceptionHandling() {
        MockTime time = new MockTime();
        KafkaConfig config = new KafkaConfig((Map)TestUtils$.MODULE$.createBrokerConfig(1, "localhost:2181", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20()));
        int controllerId = 2;
        Metadata metadata = (Metadata)Mockito.mock(Metadata.class);
        MockClient mockClient = new MockClient((Time)time, metadata);
        ControllerNodeProvider controllerNodeProvider = (ControllerNodeProvider)Mockito.mock(ControllerNodeProvider.class);
        Node activeController = new Node(controllerId, "host", 1234);
        Mockito.when((Object)controllerNodeProvider.get()).thenReturn((Object)new Some((Object)activeController));
        AtomicReference callbackResponse = new AtomicReference();
        ControllerRequestCompletionHandler completionHandler = new ControllerRequestCompletionHandler(null, callbackResponse){
            private final AtomicReference callbackResponse$2;

            public void onTimeout() {
                Assertions.fail((String)"Unexpected timeout exception");
            }

            public void onComplete(ClientResponse response) {
                this.callbackResponse$2.set(response);
            }
            {
                this.callbackResponse$2 = callbackResponse$2;
            }
        };
        BrokerToControllerQueueItem queueItem = new BrokerToControllerQueueItem(time.milliseconds(), (AbstractRequest.Builder)new MetadataRequest.Builder(new MetadataRequestData()), completionHandler);
        mockClient.createPendingAuthenticationError(activeController, 50L);
        BrokerToControllerRequestThread testRequestThread = new BrokerToControllerRequestThread((KafkaClient)mockClient, new ManualMetadataUpdater(), controllerNodeProvider, config, (Time)time, "", Long.MAX_VALUE);
        testRequestThread.enqueue(queueItem);
        int pollUntil_maxRetries = this.pollUntil$default$3();
        int pollUntil_tries = 0;
        do {
            testRequestThread.doWork();
        } while (!BrokerToControllerRequestThreadTest.$anonfun$testAuthenticationExceptionHandling$1(callbackResponse) && ++pollUntil_tries < pollUntil_maxRetries);
        if (!BrokerToControllerRequestThreadTest.$anonfun$testAuthenticationExceptionHandling$1(callbackResponse)) {
            Assertions.fail((String)new StringBuilder(47).append("Condition failed to be met after polling ").append(pollUntil_tries).append(" times").toString());
        }
        Assertions.assertNotNull((Object)((ClientResponse)callbackResponse.get()).authenticationException());
    }

    private void pollUntil(BrokerToControllerRequestThread requestThread, Function0<Object> condition, int maxRetries) {
        int tries = 0;
        do {
            requestThread.doWork();
        } while (!condition.apply$mcZ$sp() && ++tries < maxRetries);
        if (!condition.apply$mcZ$sp()) {
            Assertions.fail((String)new StringBuilder(47).append("Condition failed to be met after polling ").append(tries).append(" times").toString());
        }
    }

    private int pollUntil$default$3() {
        return 10;
    }

    private final void TestRequestCompletionHandler$lzycompute$1() {
        synchronized (this) {
            if (this.TestRequestCompletionHandler$module == null) {
                this.TestRequestCompletionHandler$module = new BrokerToControllerRequestThreadTest$TestRequestCompletionHandler$(this);
            }
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$testUnsupportedVersionHandling$2(AtomicReference callbackResponse$1) {
        return callbackResponse$1.get() != null;
    }

    public static final /* synthetic */ boolean $anonfun$testAuthenticationExceptionHandling$1(AtomicReference callbackResponse$2) {
        return callbackResponse$2.get() != null;
    }

    public class TestRequestCompletionHandler
    extends ControllerRequestCompletionHandler {
        private final Option<MetadataResponse> expectedResponse;
        private final AtomicBoolean completed;
        private final AtomicBoolean timedOut;
        public final /* synthetic */ BrokerToControllerRequestThreadTest $outer;

        public AtomicBoolean completed() {
            return this.completed;
        }

        public AtomicBoolean timedOut() {
            return this.timedOut;
        }

        public void onComplete(ClientResponse response) {
            this.expectedResponse.foreach((Function1 & Serializable & scala.Serializable)expected -> {
                TestRequestCompletionHandler.$anonfun$onComplete$1(response, expected);
                return BoxedUnit.UNIT;
            });
            this.completed().set(true);
        }

        public void onTimeout() {
            this.timedOut().set(true);
        }

        public /* synthetic */ BrokerToControllerRequestThreadTest kafka$server$BrokerToControllerRequestThreadTest$TestRequestCompletionHandler$$$outer() {
            return this.$outer;
        }

        public static final /* synthetic */ void $anonfun$onComplete$1(ClientResponse response$1, MetadataResponse expected) {
            Assertions.assertEquals((Object)expected, (Object)response$1.responseBody());
        }

        public TestRequestCompletionHandler(BrokerToControllerRequestThreadTest $outer, Option<MetadataResponse> expectedResponse) {
            this.expectedResponse = expectedResponse;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            this.completed = new AtomicBoolean(false);
            this.timedOut = new AtomicBoolean(false);
        }
    }
}

