/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import kafka.api.Both$;
import kafka.api.IntegrationTestHarness;
import kafka.api.SaslSetup;
import kafka.api.SaslSetupMode;
import kafka.security.minikdc.MiniKdc;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.server.TestableKerberosLogin;
import kafka.server.TestableKerberosLogin$;
import kafka.utils.JaasTestUtils;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.errors.SaslAuthenticationException;
import org.apache.kafka.common.network.ChannelBuilder;
import org.apache.kafka.common.network.ChannelBuilders;
import org.apache.kafka.common.network.ChannelState;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.NetworkTestUtils;
import org.apache.kafka.common.network.SaslChannelBuilder;
import org.apache.kafka.common.network.Selector;
import org.apache.kafka.common.security.JaasContext;
import org.apache.kafka.common.security.TestSecurityConfig;
import org.apache.kafka.common.security.auth.Login;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015g\u0001B\u0014)\u00015BQa\u000e\u0001\u0005\u0002aBqa\u000f\u0001C\u0002\u0013\u0005C\b\u0003\u0004D\u0001\u0001\u0006I!\u0010\u0005\u0006\t\u0002!\t&\u0012\u0005\b+\u0002\u0011\r\u0011\"\u0003W\u0011\u0019y\u0006\u0001)A\u0005/\"9\u0001\r\u0001b\u0001\n\u0013\t\u0007B\u00026\u0001A\u0003%!\rC\u0004l\u0001\t\u0007I\u0011\u0002\u001f\t\r1\u0004\u0001\u0015!\u0003>\u0011\u001di\u0007A1A\u0005\n9Daa\u001e\u0001!\u0002\u0013y\u0007b\u0002=\u0001\u0005\u0004%I!\u001f\u0005\u0007}\u0002\u0001\u000b\u0011\u0002>\t\u0015}\u0004\u0001\u0019!a\u0001\n\u0013\t\t\u0001C\u0006\u0002\u0010\u0001\u0001\r\u00111A\u0005\n\u0005E\u0001bCA\u000f\u0001\u0001\u0007\t\u0011)Q\u0005\u0003\u0007A\u0011\"a\b\u0001\u0005\u0004%I!!\t\t\u0011\u0005=\u0002\u0001)A\u0005\u0003GA\u0001\"!\r\u0001\u0005\u0004%\tA\u0016\u0005\b\u0003g\u0001\u0001\u0015!\u0003X\u0011!\t)\u0004\u0001b\u0001\n\u0003a\u0004bBA\u001c\u0001\u0001\u0006I!\u0010\u0005\n\u0003s\u0001!\u0019!C\u0001\u0003wA\u0001\"!\u0012\u0001A\u0003%\u0011Q\b\u0005\t\u0003\u000f\u0002!\u0019!C\u0005y!9\u0011\u0011\n\u0001!\u0002\u0013i\u0004bBA&\u0001\u0011\u0005\u0013Q\n\u0005\b\u0003G\u0002A\u0011IA'\u0011\u001d\ti\u0007\u0001C\u0001\u0003\u001bBq!a\u001e\u0001\t\u0003\ti\u0005C\u0004\u0002|\u0001!\t!!\u0014\t\u000f\u0005}\u0004\u0001\"\u0001\u0002N!9\u00111\u0011\u0001\u0005\n\u0005\u0015\u0005bBAF\u0001\u0011%\u0011Q\u0012\u0005\b\u0003{\u0003A\u0011BA'\u0011\u001d\ty\f\u0001C\u0005\u0003\u0003Dq!a1\u0001\t\u0013\t\tM\u0001\rHgN\f\u0007/[!vi\",g\u000e^5dCRLwN\u001c+fgRT!!\u000b\u0016\u0002\rM,'O^3s\u0015\u0005Y\u0013!B6bM.\f7\u0001A\n\u0004\u00019\"\u0004CA\u00183\u001b\u0005\u0001$BA\u0019+\u0003\r\t\u0007/[\u0005\u0003gA\u0012a#\u00138uK\u001e\u0014\u0018\r^5p]R+7\u000f\u001e%be:,7o\u001d\t\u0003_UJ!A\u000e\u0019\u0003\u0013M\u000b7\u000f\\*fiV\u0004\u0018A\u0002\u001fj]&$h\bF\u0001:!\tQ\u0004!D\u0001)\u0003-\u0011'o\\6fe\u000e{WO\u001c;\u0016\u0003u\u0002\"AP!\u000e\u0003}R\u0011\u0001Q\u0001\u0006g\u000e\fG.Y\u0005\u0003\u0005~\u00121!\u00138u\u00031\u0011'o\\6fe\u000e{WO\u001c;!\u0003A\u0019XmY;sSRL\bK]8u_\u000e|G.F\u0001G!\t95+D\u0001I\u0015\tI%*\u0001\u0003bkRD'BA&M\u0003!\u0019XmY;sSRL(BA'O\u0003\u0019\u0019w.\\7p]*\u00111f\u0014\u0006\u0003!F\u000ba!\u00199bG\",'\"\u0001*\u0002\u0007=\u0014x-\u0003\u0002U\u0011\n\u00012+Z2ve&$\u0018\u0010\u0015:pi>\u001cw\u000e\\\u0001\u0019W\u000647.Y\"mS\u0016tGoU1tY6+7\r[1oSNlW#A,\u0011\u0005akV\"A-\u000b\u0005i[\u0016\u0001\u00027b]\u001eT\u0011\u0001X\u0001\u0005U\u00064\u0018-\u0003\u0002_3\n11\u000b\u001e:j]\u001e\f\u0011d[1gW\u0006\u001cE.[3oiN\u000b7\u000f\\'fG\"\fg.[:nA\u0005I2.\u00194lCN+'O^3s'\u0006\u001cH.T3dQ\u0006t\u0017n]7t+\u0005\u0011\u0007cA2i/6\tAM\u0003\u0002fM\u0006I\u0011.\\7vi\u0006\u0014G.\u001a\u0006\u0003O~\n!bY8mY\u0016\u001cG/[8o\u0013\tIGM\u0001\u0003MSN$\u0018AG6bM.\f7+\u001a:wKJ\u001c\u0016m\u001d7NK\u000eD\u0017M\\5t[N\u0004\u0013A\u00038v[RC'/Z1eg\u0006Ya.^7UQJ,\u0017\rZ:!\u0003!)\u00070Z2vi>\u0014X#A8\u0011\u0005A,X\"A9\u000b\u0005I\u001c\u0018AC2p]\u000e,(O]3oi*\u0011AoW\u0001\u0005kRLG.\u0003\u0002wc\nyQ\t_3dkR|'oU3sm&\u001cW-A\u0005fq\u0016\u001cW\u000f^8sA\u0005a1\r\\5f]R\u001cuN\u001c4jOV\t!\u0010\u0005\u0002|y6\t1/\u0003\u0002~g\nQ\u0001K]8qKJ$\u0018.Z:\u0002\u001b\rd\u0017.\u001a8u\u0007>tg-[4!\u0003)\u0019XM\u001d<fe\u0006#GM]\u000b\u0003\u0003\u0007\u0001B!!\u0002\u0002\f5\u0011\u0011q\u0001\u0006\u0004\u0003\u0013Y\u0016a\u00018fi&!\u0011QBA\u0004\u0005EIe.\u001a;T_\u000e\\W\r^!eIJ,7o]\u0001\u000fg\u0016\u0014h/\u001a:BI\u0012\u0014x\fJ3r)\u0011\t\u0019\"!\u0007\u0011\u0007y\n)\"C\u0002\u0002\u0018}\u0012A!\u00168ji\"I\u00111\u0004\t\u0002\u0002\u0003\u0007\u00111A\u0001\u0004q\u0012\n\u0014aC:feZ,'/\u00113ee\u0002\nA\u0001^5nKV\u0011\u00111\u0005\t\u0005\u0003K\tY#\u0004\u0002\u0002()\u0019\u0011\u0011\u0006'\u0002\u000bU$\u0018\u000e\\:\n\t\u00055\u0012q\u0005\u0002\t\u001b>\u001c7\u000eV5nK\u0006)A/[7fA\u0005)Ao\u001c9jG\u00061Ao\u001c9jG\u0002\nA\u0001]1si\u0006)\u0001/\u0019:uA\u0005\u0011A\u000f]\u000b\u0003\u0003{\u0001B!a\u0010\u0002B5\tA*C\u0002\u0002D1\u0013a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g.A\u0002ua\u0002\n1DZ1jY\u0016$\u0017)\u001e;iK:$\u0018nY1uS>tG)\u001a7bs6\u001b\u0018\u0001\b4bS2,G-Q;uQ\u0016tG/[2bi&|g\u000eR3mCfl5\u000fI\u0001\u0006g\u0016$X\u000b\u001d\u000b\u0003\u0003'A3\u0001HA)!\u0011\t\u0019&a\u0018\u000e\u0005\u0005U#bA\u0019\u0002X)!\u0011\u0011LA.\u0003\u001dQW\u000f]5uKJT1!!\u0018R\u0003\u0015QWO\\5u\u0013\u0011\t\t'!\u0016\u0003\u0015\t+gm\u001c:f\u000b\u0006\u001c\u0007.\u0001\u0005uK\u0006\u0014Hi\\<oQ\ri\u0012q\r\t\u0005\u0003'\nI'\u0003\u0003\u0002l\u0005U#!C!gi\u0016\u0014X)Y2i\u0003Q!Xm\u001d;SKF,Xm\u001d;Jg\u0006\u0013V\r\u001d7bs\"\u001aa$!\u001d\u0011\t\u0005M\u00131O\u0005\u0005\u0003k\n)F\u0001\u0003UKN$\u0018a\u0003;fgR\u0014V\rT8hS:D3aHA9\u0003\u0011\"Xm\u001d;TKJ4XM\u001d(pi\u001a{WO\u001c3J].+'OY3s_N$\u0015\r^1cCN,\u0007f\u0001\u0011\u0002r\u0005yB/Z:u'\u0016\u0014h/\u001a:BkRDWM\u001c;jG\u0006$\u0018n\u001c8GC&dWO]3)\u0007\u0005\n\t(A\u0016wKJLg-\u001f*fiJL\u0017M\u00197f\r\u0006LG.\u001e:fg\u0012+(/\u001b8h\u0003V$\b.\u001a8uS\u000e\fG/[8o)\u0011\t\u0019\"a\"\t\r\u0005%%\u00051\u0001>\u0003IqW/\\*vG\u000e,7o\u001d4vY\u0006+H\u000f[:\u00029A|G\u000e\\+oi&d'+Z1es>\u0013H)[:d_:tWm\u0019;fIR1\u0011qRAK\u0003K\u00032APAI\u0013\r\t\u0019j\u0010\u0002\b\u0005>|G.Z1o\u0011\u001d\t9j\ta\u0001\u00033\u000b\u0001b]3mK\u000e$xN\u001d\t\u0005\u00037\u000b\t+\u0004\u0002\u0002\u001e*\u0019\u0011q\u0014'\u0002\u000f9,Go^8sW&!\u00111UAO\u0005!\u0019V\r\\3di>\u0014\bbBATG\u0001\u0007\u0011\u0011V\u0001\u0007]>$W-\u00133\u0011\t\u0005-\u0016\u0011\u0018\b\u0005\u0003[\u000b)\fE\u0002\u00020~j!!!-\u000b\u0007\u0005MF&\u0001\u0004=e>|GOP\u0005\u0004\u0003o{\u0014A\u0002)sK\u0012,g-C\u0002_\u0003wS1!a.@\u0003\u001d2XM]5gs:{gNU3ue&\f'\r\\3BkRDWM\u001c;jG\u0006$\u0018n\u001c8GC&dWO]3\u0002\u001d\r\u0014X-\u0019;f'\u0016dWm\u0019;peR\u0011\u0011\u0011T\u0001\u001aGJ,\u0017\r^3TK2,7\r^8s/&$\bNU3m_\u001eLg\u000e")
public class GssapiAuthenticationTest
extends IntegrationTestHarness
implements SaslSetup {
    private final int brokerCount;
    private final String kafka$server$GssapiAuthenticationTest$$kafkaClientSaslMechanism;
    private final List<String> kafkaServerSaslMechanisms;
    private final int numThreads;
    private final ExecutorService executor;
    private final Properties clientConfig;
    private InetSocketAddress serverAddr;
    private final MockTime kafka$server$GssapiAuthenticationTest$$time;
    private final String topic;
    private final int part;
    private final TopicPartition tp;
    private final int failedAuthenticationDelayMs;
    private final File kafka$api$SaslSetup$$workDir;
    private final Properties kafka$api$SaslSetup$$kdcConf;
    private MiniKdc kafka$api$SaslSetup$$kdc;
    private Option<File> kafka$api$SaslSetup$$serverKeytabFile;
    private Option<File> kafka$api$SaslSetup$$clientKeytabFile;

    @Override
    public void startSasl(Seq<JaasTestUtils.JaasSection> jaasSections) {
        SaslSetup.startSasl$(this, jaasSections);
    }

    @Override
    public void initializeKerberos() {
        SaslSetup.initializeKerberos$(this);
    }

    @Override
    public Tuple2<File, File> maybeCreateEmptyKeytabFiles() {
        return SaslSetup.maybeCreateEmptyKeytabFiles$(this);
    }

    @Override
    public Seq<JaasTestUtils.JaasSection> jaasSections(Seq<String> kafkaServerSaslMechanisms, Option<String> kafkaClientSaslMechanism, SaslSetupMode mode, String kafkaServerEntryName) {
        return SaslSetup.jaasSections$(this, kafkaServerSaslMechanisms, kafkaClientSaslMechanism, mode, kafkaServerEntryName);
    }

    @Override
    public SaslSetupMode jaasSections$default$3() {
        return SaslSetup.jaasSections$default$3$(this);
    }

    @Override
    public String jaasSections$default$4() {
        return SaslSetup.jaasSections$default$4$(this);
    }

    @Override
    public void closeSasl() {
        SaslSetup.closeSasl$(this);
    }

    @Override
    public Properties kafkaServerSaslProperties(Seq<String> serverSaslMechanisms, String interBrokerSaslMechanism) {
        return SaslSetup.kafkaServerSaslProperties$(this, serverSaslMechanisms, interBrokerSaslMechanism);
    }

    @Override
    public Properties kafkaClientSaslProperties(String clientSaslMechanism, boolean dynamicJaasConfig) {
        return SaslSetup.kafkaClientSaslProperties$(this, clientSaslMechanism, dynamicJaasConfig);
    }

    @Override
    public boolean kafkaClientSaslProperties$default$2() {
        return SaslSetup.kafkaClientSaslProperties$default$2$(this);
    }

    @Override
    public String jaasClientLoginModule(String clientSaslMechanism, Option<String> serviceName) {
        return SaslSetup.jaasClientLoginModule$(this, clientSaslMechanism, serviceName);
    }

    @Override
    public Option<String> jaasClientLoginModule$default$2() {
        return SaslSetup.jaasClientLoginModule$default$2$(this);
    }

    @Override
    public String jaasScramClientLoginModule(String clientSaslScramMechanism, String scramUser, String scramPassword) {
        return SaslSetup.jaasScramClientLoginModule$(this, clientSaslScramMechanism, scramUser, scramPassword);
    }

    @Override
    public Admin createPrivilegedAdminClient() {
        return SaslSetup.createPrivilegedAdminClient$(this);
    }

    @Override
    public Admin createAdminClient(String brokerList, SecurityProtocol securityProtocol, Option<File> trustStoreFile, Option<Properties> clientSaslProperties, String scramMechanism, String user, String password) {
        return SaslSetup.createAdminClient$(this, brokerList, securityProtocol, trustStoreFile, clientSaslProperties, scramMechanism, user, password);
    }

    @Override
    public void createScramCredentialsViaPrivilegedAdminClient(String userName, String password) {
        SaslSetup.createScramCredentialsViaPrivilegedAdminClient$(this, userName, password);
    }

    @Override
    public void createScramCredentials(Admin adminClient, String userName, String password) {
        SaslSetup.createScramCredentials$((SaslSetup)this, adminClient, userName, password);
    }

    @Override
    public void createScramCredentials(String zkConnect, String userName, String password) {
        SaslSetup.createScramCredentials$((SaslSetup)this, zkConnect, userName, password);
    }

    @Override
    public File kafka$api$SaslSetup$$workDir() {
        return this.kafka$api$SaslSetup$$workDir;
    }

    @Override
    public Properties kafka$api$SaslSetup$$kdcConf() {
        return this.kafka$api$SaslSetup$$kdcConf;
    }

    @Override
    public MiniKdc kafka$api$SaslSetup$$kdc() {
        return this.kafka$api$SaslSetup$$kdc;
    }

    @Override
    public void kafka$api$SaslSetup$$kdc_$eq(MiniKdc x$1) {
        this.kafka$api$SaslSetup$$kdc = x$1;
    }

    @Override
    public Option<File> kafka$api$SaslSetup$$serverKeytabFile() {
        return this.kafka$api$SaslSetup$$serverKeytabFile;
    }

    @Override
    public void kafka$api$SaslSetup$$serverKeytabFile_$eq(Option<File> x$1) {
        this.kafka$api$SaslSetup$$serverKeytabFile = x$1;
    }

    @Override
    public Option<File> kafka$api$SaslSetup$$clientKeytabFile() {
        return this.kafka$api$SaslSetup$$clientKeytabFile;
    }

    @Override
    public void kafka$api$SaslSetup$$clientKeytabFile_$eq(Option<File> x$1) {
        this.kafka$api$SaslSetup$$clientKeytabFile = x$1;
    }

    @Override
    public final void kafka$api$SaslSetup$_setter_$kafka$api$SaslSetup$$workDir_$eq(File x$1) {
        this.kafka$api$SaslSetup$$workDir = x$1;
    }

    @Override
    public final void kafka$api$SaslSetup$_setter_$kafka$api$SaslSetup$$kdcConf_$eq(Properties x$1) {
        this.kafka$api$SaslSetup$$kdcConf = x$1;
    }

    @Override
    public int brokerCount() {
        return this.brokerCount;
    }

    @Override
    public SecurityProtocol securityProtocol() {
        return SecurityProtocol.SASL_PLAINTEXT;
    }

    public String kafka$server$GssapiAuthenticationTest$$kafkaClientSaslMechanism() {
        return this.kafka$server$GssapiAuthenticationTest$$kafkaClientSaslMechanism;
    }

    private List<String> kafkaServerSaslMechanisms() {
        return this.kafkaServerSaslMechanisms;
    }

    private int numThreads() {
        return this.numThreads;
    }

    private ExecutorService executor() {
        return this.executor;
    }

    private Properties clientConfig() {
        return this.clientConfig;
    }

    private InetSocketAddress serverAddr() {
        return this.serverAddr;
    }

    private void serverAddr_$eq(InetSocketAddress x$1) {
        this.serverAddr = x$1;
    }

    public MockTime kafka$server$GssapiAuthenticationTest$$time() {
        return this.kafka$server$GssapiAuthenticationTest$$time;
    }

    public String topic() {
        return this.topic;
    }

    public int part() {
        return this.part;
    }

    public TopicPartition tp() {
        return this.tp;
    }

    private int failedAuthenticationDelayMs() {
        return this.failedAuthenticationDelayMs;
    }

    @Override
    @BeforeEach
    public void setUp() {
        TestableKerberosLogin$.MODULE$.reset();
        this.startSasl(this.jaasSections((Seq<String>)this.kafkaServerSaslMechanisms(), (Option<String>)Option$.MODULE$.apply((Object)this.kafka$server$GssapiAuthenticationTest$$kafkaClientSaslMechanism()), Both$.MODULE$, this.jaasSections$default$4()));
        this.serverConfig().put(KafkaConfig$.MODULE$.SslClientAuthProp(), "required");
        this.serverConfig().put(KafkaConfig$.MODULE$.FailedAuthenticationDelayMsProp(), Integer.toString(this.failedAuthenticationDelayMs()));
        super.setUp();
        this.serverAddr_$eq(new InetSocketAddress("localhost", ((KafkaServer)this.servers().head()).boundPort(ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.SASL_PLAINTEXT))));
        this.clientConfig().put("security.protocol", SecurityProtocol.SASL_PLAINTEXT.name);
        this.clientConfig().put("sasl.mechanism", this.kafka$server$GssapiAuthenticationTest$$kafkaClientSaslMechanism());
        this.clientConfig().put("sasl.jaas.config", this.jaasClientLoginModule(this.kafka$server$GssapiAuthenticationTest$$kafkaClientSaslMechanism(), this.jaasClientLoginModule$default$2()));
        this.clientConfig().put("connections.max.idle.ms", "5000");
        this.createTopic(this.topic(), 2, this.brokerCount(), this.createTopic$default$4());
    }

    @Override
    @AfterEach
    public void tearDown() {
        this.executor().shutdownNow();
        super.tearDown();
        this.closeSasl();
        TestableKerberosLogin$.MODULE$.reset();
    }

    @Test
    public void testRequestIsAReplay() {
        int successfulAuthsPerThread = 10;
        ((IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.numThreads()).map((Function1 & Serializable & scala.Serializable)x$1 -> GssapiAuthenticationTest.$anonfun$testRequestIsAReplay$1(this, successfulAuthsPerThread, BoxesRunTime.unboxToInt((Object)x$1)), IndexedSeq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x$2 -> x$2.get(60L, TimeUnit.SECONDS));
        Assertions.assertEquals((long)0L, (long)TestUtils$.MODULE$.totalMetricValue((KafkaServer)this.servers().head(), "failed-authentication-total"));
        long successfulAuths = TestUtils$.MODULE$.totalMetricValue((KafkaServer)this.servers().head(), "successful-authentication-total");
        Assertions.assertTrue((successfulAuths > (long)(successfulAuthsPerThread * this.numThreads()) ? 1 : 0) != 0, (String)new StringBuilder(25).append("Too few authentications: ").append(successfulAuths).toString());
    }

    @Test
    public void testReLogin() {
        try (Selector selector = this.createSelectorWithRelogin();){
            TestableKerberosLogin login = TestableKerberosLogin$.MODULE$.instance();
            Assertions.assertNotNull((Object)((Object)login));
            this.executor().submit(() -> login.reLogin(), BoxesRunTime.boxToInteger((int)0));
            String node1 = "1";
            selector.connect(node1, this.serverAddr(), 1024, 1024);
            login.logoutResumeLatch().countDown();
            login.logoutCompleteLatch().await(15L, TimeUnit.SECONDS);
            Assertions.assertFalse((boolean)this.pollUntilReadyOrDisconnected(selector, node1), (String)"Authenticated during re-login");
            login.reLoginResumeLatch().countDown();
            login.reLoginCompleteLatch().await(15L, TimeUnit.SECONDS);
            String node2 = "2";
            selector.connect(node2, this.serverAddr(), 1024, 1024);
            Assertions.assertTrue((boolean)this.pollUntilReadyOrDisconnected(selector, node2), (String)"Authenticated failed after re-login");
        }
    }

    @Test
    public void testServerNotFoundInKerberosDatabase() {
        String invalidServiceConfig = this.clientConfig().getProperty("sasl.jaas.config").replace("serviceName=\"kafka\"", "serviceName=\"invalid-service\"");
        this.clientConfig().put("sasl.jaas.config", invalidServiceConfig);
        this.clientConfig().put("sasl.kerberos.service.name", "invalid-service");
        this.verifyNonRetriableAuthenticationFailure();
    }

    @Test
    public void testServerAuthenticationFailure() {
        String clientLoginContext = this.jaasClientLoginModule(this.kafka$server$GssapiAuthenticationTest$$kafkaClientSaslMechanism(), (Option<String>)new Some((Object)"another-kafka-service"));
        Properties configOverrides = new Properties();
        configOverrides.setProperty("sasl.jaas.config", clientLoginContext);
        ByteArrayDeserializer x$2 = this.createConsumer$default$1();
        ByteArrayDeserializer x$3 = this.createConsumer$default$2();
        List<String> x$4 = this.createConsumer$default$4();
        KafkaConsumer consumer = this.createConsumer(x$2, x$3, configOverrides, x$4);
        consumer.assign((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        long startMs = System.currentTimeMillis();
        Assertions.assertThrows(SaslAuthenticationException.class, () -> consumer.poll(Duration.ofMillis(50L)));
        long endMs = System.currentTimeMillis();
        Predef$.MODULE$.require(endMs - startMs < (long)this.failedAuthenticationDelayMs(), (Function0 & Serializable & scala.Serializable)() -> "Failed authentication must not be delayed on the client");
        consumer.close();
    }

    public void kafka$server$GssapiAuthenticationTest$$verifyRetriableFailuresDuringAuthentication(int numSuccessfulAuths) {
        try (Selector selector = this.createSelector();){
            int actualSuccessfulAuths = 0;
            while (actualSuccessfulAuths < numSuccessfulAuths) {
                String nodeId = Integer.toString(actualSuccessfulAuths);
                selector.connect(nodeId, this.serverAddr(), 1024, 1024);
                if (this.pollUntilReadyOrDisconnected(selector, nodeId)) {
                    ++actualSuccessfulAuths;
                }
                selector.close(nodeId);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean pollUntilReadyOrDisconnected(Selector selector, String nodeId) {
        void var3_6;
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!GssapiAuthenticationTest.$anonfun$pollUntilReadyOrDisconnected$1(selector, nodeId)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)GssapiAuthenticationTest.$anonfun$pollUntilReadyOrDisconnected$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        boolean isReady = selector.isChannelReady(nodeId);
        selector.close(nodeId);
        return (boolean)var3_6;
    }

    /*
     * WARNING - void declaration
     */
    private void verifyNonRetriableAuthenticationFailure() {
        Selector selector = this.createSelector();
        String nodeId = "1";
        selector.connect(nodeId, this.serverAddr(), 1024, 1024);
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!GssapiAuthenticationTest.$anonfun$verifyNonRetriableAuthenticationFailure$1(selector, nodeId)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)GssapiAuthenticationTest.$anonfun$verifyNonRetriableAuthenticationFailure$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    private Selector createSelector() {
        return NetworkTestUtils.createSelector((ChannelBuilder)ChannelBuilders.clientChannelBuilder((SecurityProtocol)this.securityProtocol(), (JaasContext.Type)JaasContext.Type.CLIENT, (AbstractConfig)new TestSecurityConfig((Map)this.clientConfig()), null, (String)this.kafka$server$GssapiAuthenticationTest$$kafkaClientSaslMechanism(), (Time)this.kafka$server$GssapiAuthenticationTest$$time(), (boolean)true, (LogContext)new LogContext()), (Time)this.kafka$server$GssapiAuthenticationTest$$time());
    }

    private Selector createSelectorWithRelogin() {
        this.clientConfig().setProperty("sasl.kerberos.min.time.before.relogin", "0");
        TestSecurityConfig config = new TestSecurityConfig((Map)this.clientConfig());
        Map<String, JaasContext> jaasContexts = Collections.singletonMap("GSSAPI", JaasContext.loadClientContext((Map)config.values()));
        SaslChannelBuilder channelBuilder = new SaslChannelBuilder(this, jaasContexts){

            public Class<? extends Login> defaultLoginClass() {
                return TestableKerberosLogin.class;
            }
        };
        channelBuilder.configure(config.values());
        return NetworkTestUtils.createSelector((ChannelBuilder)channelBuilder, (Time)this.kafka$server$GssapiAuthenticationTest$$time());
    }

    public static final /* synthetic */ Future $anonfun$testRequestIsAReplay$1(GssapiAuthenticationTest $this, int successfulAuthsPerThread$1, int x$1) {
        return $this.executor().submit(new Runnable($this, successfulAuthsPerThread$1){
            private final /* synthetic */ GssapiAuthenticationTest $outer;
            private final int successfulAuthsPerThread$1;

            public void run() {
                this.$outer.kafka$server$GssapiAuthenticationTest$$verifyRetriableFailuresDuringAuthentication(this.successfulAuthsPerThread$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.successfulAuthsPerThread$1 = successfulAuthsPerThread$1;
            }
        });
    }

    public static final /* synthetic */ boolean $anonfun$pollUntilReadyOrDisconnected$1(Selector selector$1, String nodeId$1) {
        selector$1.poll(100L);
        ChannelState disconnectState = (ChannelState)selector$1.disconnected().get(nodeId$1);
        if (disconnectState != null) {
            Assertions.assertEquals((Object)ChannelState.State.AUTHENTICATE, (Object)disconnectState.state(), (String)new StringBuilder(37).append("Authentication failed with exception ").append(disconnectState.exception()).toString());
        }
        return selector$1.isChannelReady(nodeId$1) || disconnectState != null;
    }

    public static final /* synthetic */ String $anonfun$pollUntilReadyOrDisconnected$2() {
        return "Client not ready or disconnected within timeout";
    }

    public static final /* synthetic */ boolean $anonfun$verifyNonRetriableAuthenticationFailure$1(Selector selector$2, String nodeId$2) {
        selector$2.poll(100L);
        ChannelState disconnectState = (ChannelState)selector$2.disconnected().get(nodeId$2);
        if (disconnectState != null) {
            Assertions.assertEquals((Object)ChannelState.State.AUTHENTICATION_FAILED, (Object)disconnectState.state());
        }
        return disconnectState != null;
    }

    public static final /* synthetic */ String $anonfun$verifyNonRetriableAuthenticationFailure$2() {
        return "Client not disconnected within timeout";
    }

    public GssapiAuthenticationTest() {
        SaslSetup.$init$(this);
        this.brokerCount = 1;
        this.kafka$server$GssapiAuthenticationTest$$kafkaClientSaslMechanism = "GSSAPI";
        this.kafkaServerSaslMechanisms = new .colon.colon((Object)"GSSAPI", (List)Nil$.MODULE$);
        this.numThreads = 10;
        this.executor = Executors.newFixedThreadPool(this.numThreads());
        this.clientConfig = new Properties();
        this.kafka$server$GssapiAuthenticationTest$$time = new MockTime(10L);
        this.topic = "topic";
        this.part = 0;
        this.tp = new TopicPartition(this.topic(), this.part());
        this.failedAuthenticationDelayMs = 2000;
    }
}

