/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.metadata;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Properties;
import kafka.coordinator.group.GroupCoordinator;
import kafka.coordinator.transaction.TransactionCoordinator;
import kafka.log.LogConfig$;
import kafka.server.RaftReplicaManager;
import kafka.server.metadata.BrokerMetadataListener;
import kafka.server.metadata.CachedConfigRepository;
import kafka.server.metadata.ClientQuotaMetadataManager;
import kafka.server.metadata.MetadataImageBuilder;
import kafka.server.metadata.RaftMetadataCache;
import kafka.utils.Implicits;
import kafka.utils.Implicits$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.metadata.ConfigRecord;
import org.apache.kafka.common.metadata.PartitionRecord;
import org.apache.kafka.common.metadata.RemoveTopicRecord;
import org.apache.kafka.common.metadata.TopicRecord;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.TraversableOnce;
import scala.collection.compat.MapExtensionMethods$;
import scala.collection.compat.package$;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005ef\u0001\u0002\u000f\u001e\u0001\u0011BQa\u000b\u0001\u0005\u00021Bqa\f\u0001C\u0002\u0013%\u0001\u0007\u0003\u00045\u0001\u0001\u0006I!\r\u0005\bk\u0001\u0011\r\u0011\"\u00037\u0011\u0019!\u0005\u0001)A\u0005o!9Q\t\u0001b\u0001\n\u00131\u0005B\u0002&\u0001A\u0003%q\tC\u0004L\u0001\t\u0007I\u0011\u0002'\t\rA\u0003\u0001\u0015!\u0003N\u0011\u001d\t\u0006A1A\u0005\nICaa\u0017\u0001!\u0002\u0013\u0019\u0006b\u0002/\u0001\u0005\u0004%I!\u0018\u0005\u0007E\u0002\u0001\u000b\u0011\u00020\t\u000f\r\u0004!\u0019!C\u0005I\"11\u000e\u0001Q\u0001\n\u0015Dq\u0001\u001c\u0001C\u0002\u0013%Q\u000e\u0003\u0004r\u0001\u0001\u0006IA\u001c\u0005\be\u0002\u0001\r\u0011\"\u0003t\u0011\u001d9\b\u00011A\u0005\naDaA \u0001!B\u0013!\b\u0002C@\u0001\u0005\u0004%I!!\u0001\t\u0011\u0005%\u0001\u0001)A\u0005\u0003\u0007Aq!a\u0003\u0001\t\u0003\ti\u0001C\u0004\u0002&\u0001!I!a\n\t\u000f\u0005\r\u0004\u0001\"\u0003\u0002f!9\u00111\u0010\u0001\u0005\n\u0005u\u0004bBAB\u0001\u0011%\u0011Q\u0011\u0002\u001b\u0005J|7.\u001a:NKR\fG-\u0019;b\u0019&\u001cH/\u001a8feR+7\u000f\u001e\u0006\u0003=}\t\u0001\"\\3uC\u0012\fG/\u0019\u0006\u0003A\u0005\naa]3sm\u0016\u0014(\"\u0001\u0012\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001!\n\t\u0003M%j\u0011a\n\u0006\u0002Q\u0005)1oY1mC&\u0011!f\n\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005i\u0003C\u0001\u0018\u0001\u001b\u0005i\u0012\u0001\u00032s_.,'/\u00133\u0016\u0003E\u0002\"A\n\u001a\n\u0005M:#aA%oi\u0006I!M]8lKJLE\rI\u0001\u0005i&lW-F\u00018!\tA$)D\u0001:\u0015\tQ4(A\u0003vi&d7O\u0003\u0002={\u000511m\\7n_:T!A\t \u000b\u0005}\u0002\u0015AB1qC\u000eDWMC\u0001B\u0003\ry'oZ\u0005\u0003\u0007f\u0012\u0001\"T8dWRKW.Z\u0001\u0006i&lW\rI\u0001\u0011G>tg-[4SKB|7/\u001b;pef,\u0012a\u0012\t\u0003]!K!!S\u000f\u0003-\r\u000b7\r[3e\u0007>tg-[4SKB|7/\u001b;pef\f\u0011cY8oM&<'+\u001a9pg&$xN]=!\u00035iW\r^1eCR\f7)Y2iKV\tQ\n\u0005\u0002/\u001d&\u0011q*\b\u0002\u0012%\u00064G/T3uC\u0012\fG/Y\"bG\",\u0017AD7fi\u0006$\u0017\r^1DC\u000eDW\rI\u0001\u0011OJ|W\u000f]\"p_J$\u0017N\\1u_J,\u0012a\u0015\t\u0003)fk\u0011!\u0016\u0006\u0003-^\u000bQa\u001a:pkBT!\u0001W\u0011\u0002\u0017\r|wN\u001d3j]\u0006$xN]\u0005\u00035V\u0013\u0001c\u0012:pkB\u001cun\u001c:eS:\fGo\u001c:\u0002#\u001d\u0014x.\u001e9D_>\u0014H-\u001b8bi>\u0014\b%\u0001\bsKBd\u0017nY1NC:\fw-\u001a:\u0016\u0003y\u0003\"a\u00181\u000e\u0003}I!!Y\u0010\u0003%I\u000bg\r\u001e*fa2L7-Y'b]\u0006<WM]\u0001\u0010e\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3sA\u0005qA\u000f\u001f8D_>\u0014H-\u001b8bi>\u0014X#A3\u0011\u0005\u0019LW\"A4\u000b\u0005!<\u0016a\u0003;sC:\u001c\u0018m\u0019;j_:L!A[4\u0003-Q\u0013\u0018M\\:bGRLwN\\\"p_J$\u0017N\\1u_J\fq\u0002\u001e=o\u0007>|'\u000fZ5oCR|'\u000fI\u0001\u0013G2LWM\u001c;Rk>$\u0018-T1oC\u001e,'/F\u0001o!\tqs.\u0003\u0002q;\tQ2\t\\5f]R\fVo\u001c;b\u001b\u0016$\u0018\rZ1uC6\u000bg.Y4fe\u0006\u00192\r\\5f]R\fVo\u001c;b\u001b\u0006t\u0017mZ3sA\u0005\u0011B.Y:u\u001b\u0016$\u0018\rZ1uC>3gm]3u+\u0005!\bC\u0001\u0014v\u0013\t1xE\u0001\u0003M_:<\u0017A\u00067bgRlU\r^1eCR\fwJ\u001a4tKR|F%Z9\u0015\u0005ed\bC\u0001\u0014{\u0013\tYxE\u0001\u0003V]&$\bbB?\u0014\u0003\u0003\u0005\r\u0001^\u0001\u0004q\u0012\n\u0014a\u00057bgRlU\r^1eCR\fwJ\u001a4tKR\u0004\u0013\u0001\u00037jgR,g.\u001a:\u0016\u0005\u0005\r\u0001c\u0001\u0018\u0002\u0006%\u0019\u0011qA\u000f\u0003-\t\u0013xn[3s\u001b\u0016$\u0018\rZ1uC2K7\u000f^3oKJ\f\u0011\u0002\\5ti\u0016tWM\u001d\u0011\u00029Q,7\u000f\u001e+pa&\u001c7I]3bi&|g.\u00118e\t\u0016dW\r^5p]R\t\u0011\u0010K\u0002\u0018\u0003#\u0001B!a\u0005\u0002\"5\u0011\u0011Q\u0003\u0006\u0005\u0003/\tI\"A\u0002ba&TA!a\u0007\u0002\u001e\u00059!.\u001e9ji\u0016\u0014(bAA\u0010\u0001\u0006)!.\u001e8ji&!\u00111EA\u000b\u0005\u0011!Vm\u001d;\u0002\u0017\u0011,G.\u001a;f)>\u0004\u0018n\u0019\u000b\ns\u0006%\u0012QGA(\u0003'Bq!a\u000b\u0019\u0001\u0004\ti#A\u0004u_BL7-\u00133\u0011\t\u0005=\u0012\u0011G\u0007\u0002w%\u0019\u00111G\u001e\u0003\tU+\u0018\u000e\u001a\u0005\b\u0003oA\u0002\u0019AA\u001d\u0003\u0015!x\u000e]5d!\u0011\tY$!\u0013\u000f\t\u0005u\u0012Q\t\t\u0004\u0003\u007f9SBAA!\u0015\r\t\u0019eI\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005\u001ds%\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003\u0017\niE\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003\u000f:\u0003BBA)1\u0001\u0007\u0011'A\u0007ok6\u0004\u0016M\u001d;ji&|gn\u001d\u0005\b\u0003+B\u0002\u0019AA,\u0003=awnY1m!\u0006\u0014H/\u001b;j_:\u001c\bCBA\u001e\u00033\ni&\u0003\u0003\u0002\\\u00055#aA*fiB!\u0011qFA0\u0013\r\t\tg\u000f\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0003=\u0019'/Z1uK\u0006sG-Q:tKJ$H\u0003DA,\u0003O\nI'a\u001b\u0002v\u0005]\u0004bBA\u00163\u0001\u0007\u0011Q\u0006\u0005\b\u0003oI\u0002\u0019AA\u001d\u0011\u001d\ti'\u0007a\u0001\u0003_\n1\u0002^8qS\u000e\u001cuN\u001c4jOBA\u00111HA9\u0003s\tI$\u0003\u0003\u0002t\u00055#aA'ba\"1\u0011\u0011K\rA\u0002EBa!!\u001f\u001a\u0001\u0004\t\u0014A\u00038v[\n\u0013xn[3sg\u0006a\u0001/\u0019:uSRLwN\\*fiR1\u0011qKA@\u0003\u0003Cq!a\u000e\u001b\u0001\u0004\tI\u0004\u0003\u0004\u0002Ri\u0001\r!M\u0001\u000bCNT\u0015M^1MSN$H\u0003BAD\u0003G\u0003b!!#\u0002\u0014\u0006]UBAAF\u0015\u0011\ti)a$\u0002\tU$\u0018\u000e\u001c\u0006\u0003\u0003#\u000bAA[1wC&!\u0011QSAF\u0005\u0011a\u0015n\u001d;\u0011\t\u0005e\u0015qT\u0007\u0003\u00037SA!!(\u0002\u0010\u0006!A.\u00198h\u0013\u0011\t\t+a'\u0003\u000f%sG/Z4fe\"9\u0011QU\u000eA\u0002\u0005\u001d\u0016\u0001\u0003:fa2L7-Y:\u0011\u000b\u0005%\u00161W\u0019\u000f\t\u0005-\u0016q\u0016\b\u0005\u0003\u007f\ti+C\u0001)\u0013\r\t\tlJ\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t),a.\u0003\u0011%#XM]1cY\u0016T1!!-(\u0001")
public class BrokerMetadataListenerTest {
    private final int brokerId;
    private final MockTime time = new MockTime();
    private final CachedConfigRepository configRepository = new CachedConfigRepository();
    private final RaftMetadataCache metadataCache = new RaftMetadataCache(this.brokerId());
    private final GroupCoordinator groupCoordinator = (GroupCoordinator)Mockito.mock(GroupCoordinator.class);
    private final RaftReplicaManager replicaManager = (RaftReplicaManager)Mockito.mock(RaftReplicaManager.class);
    private final TransactionCoordinator txnCoordinator = (TransactionCoordinator)Mockito.mock(TransactionCoordinator.class);
    private final ClientQuotaMetadataManager clientQuotaManager = (ClientQuotaMetadataManager)Mockito.mock(ClientQuotaMetadataManager.class);
    private long lastMetadataOffset = 0L;
    private final BrokerMetadataListener listener = new BrokerMetadataListener(this.brokerId(), (Time)this.time(), this.metadataCache(), this.configRepository(), this.groupCoordinator(), this.replicaManager(), this.txnCoordinator(), (Option)None$.MODULE$, this.clientQuotaManager());

    private int brokerId() {
        return this.brokerId;
    }

    private MockTime time() {
        return this.time;
    }

    private CachedConfigRepository configRepository() {
        return this.configRepository;
    }

    private RaftMetadataCache metadataCache() {
        return this.metadataCache;
    }

    private GroupCoordinator groupCoordinator() {
        return this.groupCoordinator;
    }

    private RaftReplicaManager replicaManager() {
        return this.replicaManager;
    }

    private TransactionCoordinator txnCoordinator() {
        return this.txnCoordinator;
    }

    private ClientQuotaMetadataManager clientQuotaManager() {
        return this.clientQuotaManager;
    }

    private long lastMetadataOffset() {
        return this.lastMetadataOffset;
    }

    private void lastMetadataOffset_$eq(long x$1) {
        this.lastMetadataOffset = x$1;
    }

    private BrokerMetadataListener listener() {
        return this.listener;
    }

    @Test
    public void testTopicCreationAndDeletion() {
        Uuid topicId = Uuid.randomUuid();
        String topic = "foo";
        int numPartitions = 10;
        scala.collection.immutable.Map config = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.CleanupPolicyProp()), (Object)LogConfig$.MODULE$.Compact()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.MaxCompactionLagMsProp()), (Object)"5000")}));
        scala.collection.immutable.Set<TopicPartition> localPartitions = this.createAndAssert(topicId, topic, (scala.collection.immutable.Map<String, String>)config, numPartitions, 4);
        this.deleteTopic(topicId, topic, numPartitions, localPartitions);
    }

    private void deleteTopic(Uuid topicId, String topic, int numPartitions, scala.collection.immutable.Set<TopicPartition> localPartitions) {
        RemoveTopicRecord deleteRecord = new RemoveTopicRecord().setTopicId(topicId);
        this.lastMetadataOffset_$eq(this.lastMetadataOffset() + 1L);
        this.listener().execCommits(this.lastMetadataOffset(), (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)deleteRecord, (List)Nil$.MODULE$)).asJava());
        Assertions.assertFalse((boolean)this.metadataCache().contains(topic));
        Assertions.assertEquals((Object)new Properties(), (Object)this.configRepository().topicConfig(topic));
        ((GroupCoordinator)Mockito.verify((Object)this.groupCoordinator())).handleDeletedPartitions((Seq)ArgumentMatchers.argThat(partitions -> {
            scala.collection.immutable.Set set = partitions.toSet();
            scala.collection.immutable.Set<TopicPartition> set2 = this.partitionSet(topic, numPartitions);
            return !(set != null ? !set.equals(set2) : set2 != null);
        }));
        ArgumentCaptor deleteImageCapture = ArgumentCaptor.forClass(MetadataImageBuilder.class);
        ((RaftReplicaManager)Mockito.verify((Object)this.replicaManager())).handleMetadataRecords((MetadataImageBuilder)deleteImageCapture.capture(), ArgumentMatchers.eq((long)this.lastMetadataOffset()), (Function2)ArgumentMatchers.any());
        MetadataImageBuilder deleteImage = (MetadataImageBuilder)deleteImageCapture.getValue();
        Assertions.assertTrue((boolean)deleteImage.hasPartitionChanges());
        Set localRemoved = deleteImage.partitionsBuilder().localRemoved();
        Assertions.assertEquals(localPartitions, (Object)((TraversableOnce)localRemoved.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.toTopicPartition(), Set$.MODULE$.canBuildFrom())).toSet());
    }

    /*
     * WARNING - void declaration
     */
    private scala.collection.immutable.Set<TopicPartition> createAndAssert(Uuid topicId, String topic, scala.collection.immutable.Map<String, String> topicConfig, int numPartitions, int numBrokers) {
        void forKeyValue$extension_f;
        void forKeyValue$extension_$this;
        ArrayList<TopicRecord> records = new ArrayList<TopicRecord>();
        records.add(new TopicRecord().setName(topic).setTopicId(topicId));
        scala.collection.mutable.Set localTopicPartitions = scala.collection.mutable.Set$.MODULE$.empty();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numPartitions).map((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)partitionId -> {
            int preferredLeaderId = partitionId % numBrokers;
            java.util.List<Integer> replicas = this.asJavaList((Iterable<Object>)((Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{preferredLeaderId, preferredLeaderId + 1, preferredLeaderId + 2}))));
            if (replicas.contains(BoxesRunTime.boxToInteger((int)this.brokerId()))) {
                localTopicPartitions.add((Object)new TopicPartition(topic, partitionId));
            }
            return records.add((TopicRecord)new PartitionRecord().setTopicId(topicId).setPartitionId(partitionId).setLeader(preferredLeaderId).setLeaderEpoch(0).setPartitionEpoch(0).setReplicas(replicas).setIsr(replicas));
        }, IndexedSeq$.MODULE$.canBuildFrom());
        Function2 & Serializable & scala.Serializable intersect = (Function2 & Serializable & scala.Serializable)(key, value) -> BoxesRunTime.boxToBoolean((boolean)records.add(new ConfigRecord().setResourceName(topic).setResourceType(ConfigResource.Type.TOPIC.id()).setName(key).setValue(value)));
        Map map = Implicits$.MODULE$.MapExtensionMethods(topicConfig);
        if (Implicits.MapExtensionMethods$.MODULE$ == null) {
            throw null;
        }
        MapExtensionMethods$.MODULE$.foreachEntry$extension(package$.MODULE$.toMapExtensionMethods((Map)forKeyValue$extension_$this), (arg_0, arg_1) -> Implicits.MapExtensionMethods$.$anonfun$forKeyValue$1((Function2)forKeyValue$extension_f, arg_0, arg_1));
        this.lastMetadataOffset_$eq(this.lastMetadataOffset() + (long)records.size());
        this.listener().execCommits(this.lastMetadataOffset(), records);
        Assertions.assertTrue((boolean)this.metadataCache().contains(topic));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)numPartitions)), (Object)this.metadataCache().numPartitions(topic));
        Assertions.assertEquals(topicConfig, (Object)CollectionConverters$.MODULE$.propertiesAsScalaMapConverter(this.configRepository().topicConfig(topic)).asScala());
        ArgumentCaptor imageCapture = ArgumentCaptor.forClass(MetadataImageBuilder.class);
        ((RaftReplicaManager)Mockito.verify((Object)this.replicaManager())).handleMetadataRecords((MetadataImageBuilder)imageCapture.capture(), ArgumentMatchers.eq((long)this.lastMetadataOffset()), (Function2)ArgumentMatchers.any());
        MetadataImageBuilder createImage = (MetadataImageBuilder)imageCapture.getValue();
        Assertions.assertTrue((boolean)createImage.hasPartitionChanges());
        Set localChanged = createImage.partitionsBuilder().localChanged();
        Assertions.assertEquals((Object)localTopicPartitions, (Object)((TraversableOnce)localChanged.map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.toTopicPartition(), Set$.MODULE$.canBuildFrom())).toSet());
        return localTopicPartitions.toSet();
    }

    private scala.collection.immutable.Set<TopicPartition> partitionSet(String topic, int numPartitions) {
        return ((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numPartitions).map((Function1 & Serializable & scala.Serializable)x$3 -> BrokerMetadataListenerTest.$anonfun$partitionSet$1(topic, BoxesRunTime.unboxToInt((Object)x$3)), IndexedSeq$.MODULE$.canBuildFrom())).toSet();
    }

    private java.util.List<Integer> asJavaList(Iterable<Object> replicas) {
        return (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableOnce)replicas.map((Function1 & Serializable & scala.Serializable)x -> BrokerMetadataListenerTest.$anonfun$asJavaList$1(BoxesRunTime.unboxToInt((Object)x)), Iterable$.MODULE$.canBuildFrom())).toList()).asJava();
    }

    public static final /* synthetic */ TopicPartition $anonfun$partitionSet$1(String topic$3, int x$3) {
        return new TopicPartition(topic$3, x$3);
    }

    public static final /* synthetic */ Integer $anonfun$asJavaList$1(int x) {
        return BoxesRunTime.boxToInteger((int)x);
    }

    public BrokerMetadataListenerTest() {
        this.brokerId = 1;
    }
}

