/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kafka.server.KafkaConfig;
import org.apache.kafka.common.metrics.JmxReporter;
import org.apache.kafka.common.metrics.KafkaMetricsContext;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.MetricsContext;
import org.apache.kafka.common.metrics.MetricsReporter;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.metadata.VersionRange;
import scala.Predef$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;

public final class Server$ {
    public static Server$ MODULE$;
    private final String MetricsPrefix;
    private final String ClusterIdLabel;
    private final String BrokerIdLabel;
    private final String NodeIdLabel;
    private final java.util.Map<String, VersionRange> SUPPORTED_FEATURES;

    static {
        new Server$();
    }

    public String MetricsPrefix() {
        return this.MetricsPrefix;
    }

    public String ClusterIdLabel() {
        return this.ClusterIdLabel;
    }

    public String BrokerIdLabel() {
        return this.BrokerIdLabel;
    }

    public String NodeIdLabel() {
        return this.NodeIdLabel;
    }

    public Metrics initializeMetrics(KafkaConfig config, Time time, String clusterId) {
        KafkaMetricsContext metricsContext = this.createKafkaMetricsContext(config, clusterId);
        return this.buildMetrics(config, time, metricsContext);
    }

    private Metrics buildMetrics(KafkaConfig config, Time time, KafkaMetricsContext metricsContext) {
        List<MetricsReporter> defaultReporters = this.initializeDefaultReporters(config);
        MetricConfig metricConfig = this.buildMetricsConfig(config);
        return new Metrics(metricConfig, defaultReporters, time, true, (MetricsContext)metricsContext);
    }

    public MetricConfig buildMetricsConfig(KafkaConfig kafkaConfig) {
        return new MetricConfig().samples(Predef$.MODULE$.Integer2int(kafkaConfig.metricNumSamples())).recordLevel(Sensor.RecordingLevel.forName((String)kafkaConfig.metricRecordingLevel())).timeWindow(Predef$.MODULE$.Long2long(kafkaConfig.metricSampleWindowMs()), TimeUnit.MILLISECONDS);
    }

    public KafkaMetricsContext createKafkaMetricsContext(KafkaConfig config, String clusterId) {
        HashMap<String, Object> contextLabels = new HashMap<String, Object>();
        contextLabels.put(this.ClusterIdLabel(), clusterId);
        if (config.usesSelfManagedQuorum()) {
            contextLabels.put(this.NodeIdLabel(), Integer.toString(config.nodeId()));
        } else {
            contextLabels.put(this.BrokerIdLabel(), Integer.toString(config.brokerId()));
        }
        contextLabels.putAll(config.originalsWithPrefix("metrics.context."));
        return new KafkaMetricsContext(this.MetricsPrefix(), contextLabels);
    }

    /*
     * WARNING - void declaration
     */
    private List<MetricsReporter> initializeDefaultReporters(KafkaConfig config) {
        void var3_3;
        JmxReporter jmxReporter = new JmxReporter();
        jmxReporter.configure(config.originals());
        ArrayList<JmxReporter> reporters = new ArrayList<JmxReporter>();
        reporters.add(jmxReporter);
        return var3_3;
    }

    public java.util.Map<String, VersionRange> SUPPORTED_FEATURES() {
        return this.SUPPORTED_FEATURES;
    }

    private Server$() {
        MODULE$ = this;
        this.MetricsPrefix = "kafka.server";
        this.ClusterIdLabel = "kafka.cluster.id";
        this.BrokerIdLabel = "kafka.broker.id";
        this.NodeIdLabel = "kafka.node.id";
        this.SUPPORTED_FEATURES = Collections.unmodifiableMap((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$)).asJava());
    }
}

