/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.Serializable;
import java.util.Optional;
import kafka.admin.AdminOperationException;
import kafka.admin.RackAwareMode;
import kafka.controller.ReplicaAssignment;
import kafka.controller.ReplicaAssignment$;
import kafka.server.BaseRequestTest;
import kafka.utils.NotNothing$;
import kafka.utils.TestUtils$;
import kafka.zk.AdminZkClient;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.InvalidReplicaAssignmentException;
import org.apache.kafka.common.requests.MetadataRequest;
import org.apache.kafka.common.requests.MetadataResponse;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005]d\u0001B\u0011#\u0001\u001dBQA\f\u0001\u0005\u0002=BQA\r\u0001\u0005BMBqA\u000f\u0001C\u0002\u0013\u00051\u0007\u0003\u0004<\u0001\u0001\u0006I\u0001\u000e\u0005\by\u0001\u0011\r\u0011\"\u0001>\u0011\u00191\u0005\u0001)A\u0005}!9q\t\u0001b\u0001\n\u0003A\u0005BB,\u0001A\u0003%\u0011\nC\u0004Y\u0001\t\u0007I\u0011A\u001f\t\re\u0003\u0001\u0015!\u0003?\u0011\u001dQ\u0006A1A\u0005\u0002!Caa\u0017\u0001!\u0002\u0013I\u0005b\u0002/\u0001\u0005\u0004%\t!\u0010\u0005\u0007;\u0002\u0001\u000b\u0011\u0002 \t\u000fy\u0003!\u0019!C\u0001\u0011\"1q\f\u0001Q\u0001\n%Cq\u0001\u0019\u0001C\u0002\u0013\u0005Q\b\u0003\u0004b\u0001\u0001\u0006IA\u0010\u0005\bE\u0002\u0011\r\u0011\"\u0001I\u0011\u0019\u0019\u0007\u0001)A\u0005\u0013\"9A\r\u0001b\u0001\n\u0003i\u0004BB3\u0001A\u0003%a\bC\u0004g\u0001\t\u0007I\u0011\u0001%\t\r\u001d\u0004\u0001\u0015!\u0003J\u0011\u0015A\u0007\u0001\"\u0011j\u0011\u0019y\b\u0001\"\u0001\u0002\u0002!9\u00111\u0002\u0001\u0005\u0002\u0005\u0005\u0001bBA\b\u0001\u0011\u0005\u0011\u0011\u0001\u0005\b\u0003'\u0001A\u0011AA\u0001\u0011\u001d\t9\u0002\u0001C\u0001\u0003\u0003Aq!a\u0007\u0001\t\u0003\t\t\u0001C\u0004\u0002 \u0001!\t!!\t\u0003#\u0005#G\rU1si&$\u0018n\u001c8t)\u0016\u001cHO\u0003\u0002$I\u0005)\u0011\rZ7j]*\tQ%A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001A\u0003CA\u0015-\u001b\u0005Q#BA\u0016%\u0003\u0019\u0019XM\u001d<fe&\u0011QF\u000b\u0002\u0010\u0005\u0006\u001cXMU3rk\u0016\u001cH\u000fV3ti\u00061A(\u001b8jiz\"\u0012\u0001\r\t\u0003c\u0001i\u0011AI\u0001\fEJ|7.\u001a:D_VtG/F\u00015!\t)\u0004(D\u00017\u0015\u00059\u0014!B:dC2\f\u0017BA\u001d7\u0005\rIe\u000e^\u0001\fa\u0006\u0014H/\u001b;j_:LE-\u0001\u0007qCJ$\u0018\u000e^5p]&#\u0007%\u0001\u0004u_BL7-M\u000b\u0002}A\u0011q\bR\u0007\u0002\u0001*\u0011\u0011IQ\u0001\u0005Y\u0006twMC\u0001D\u0003\u0011Q\u0017M^1\n\u0005\u0015\u0003%AB*ue&tw-A\u0004u_BL7-\r\u0011\u0002!Q|\u0007/[22\u0003N\u001c\u0018n\u001a8nK:$X#A%\u0011\t){E'U\u0007\u0002\u0017*\u0011A*T\u0001\nS6lW\u000f^1cY\u0016T!A\u0014\u001c\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002Q\u0017\n\u0019Q*\u00199\u0011\u0005I+V\"A*\u000b\u0005Q#\u0013AC2p]R\u0014x\u000e\u001c7fe&\u0011ak\u0015\u0002\u0012%\u0016\u0004H.[2b\u0003N\u001c\u0018n\u001a8nK:$\u0018!\u0005;pa&\u001c\u0017'Q:tS\u001etW.\u001a8uA\u00051Ao\u001c9jGJ\nq\u0001^8qS\u000e\u0014\u0004%\u0001\tu_BL7MM!tg&<g.\\3oi\u0006\tBo\u001c9jGJ\n5o]5h]6,g\u000e\u001e\u0011\u0002\rQ|\u0007/[24\u0003\u001d!x\u000e]5dg\u0001\n\u0001\u0003^8qS\u000e\u001c\u0014i]:jO:lWM\u001c;\u0002#Q|\u0007/[24\u0003N\u001c\u0018n\u001a8nK:$\b%\u0001\u0004u_BL7\rN\u0001\bi>\u0004\u0018n\u0019\u001b!\u0003A!x\u000e]5di\u0005\u001b8/[4o[\u0016tG/A\tu_BL7\rN!tg&<g.\\3oi\u0002\na\u0001^8qS\u000e,\u0014a\u0002;pa&\u001cW\u0007I\u0001\u0011i>\u0004\u0018nY\u001bBgNLwM\\7f]R\f\u0011\u0003^8qS\u000e,\u0014i]:jO:lWM\u001c;!\u0003\u0015\u0019X\r^+q)\tQW\u000e\u0005\u00026W&\u0011AN\u000e\u0002\u0005+:LG\u000fC\u0003o3\u0001\u0007q.\u0001\u0005uKN$\u0018J\u001c4p!\t\u0001\u00180D\u0001r\u0015\t\u00118/A\u0002ba&T!\u0001^;\u0002\u000f),\b/\u001b;fe*\u0011ao^\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0002q\u0006\u0019qN]4\n\u0005i\f(\u0001\u0003+fgRLeNZ8)\u0005ea\bC\u00019~\u0013\tq\u0018O\u0001\u0006CK\u001a|'/Z#bG\"\fQ\u0003^3ti^\u0013xN\\4SKBd\u0017nY1D_VtG\u000fF\u0001kQ\rQ\u0012Q\u0001\t\u0004a\u0006\u001d\u0011bAA\u0005c\n!A+Z:u\u0003U!Xm\u001d;NSN\u001c\u0018N\\4QCJ$\u0018\u000e^5p]BB3aGA\u0003\u0003]!Xm\u001d;J]\u000e\u0014X-\\3oiB\u000b'\u000f^5uS>t7\u000fK\u0002\u001d\u0003\u000b\ta\u0004^3ti6\u000bg.^1m\u0003N\u001c\u0018n\u001a8nK:$xJ\u001a*fa2L7-Y:)\u0007u\t)!\u0001\u0010uKN$(+\u001a9mS\u000e\f\u0007\u000b\\1dK6,g\u000e^!mYN+'O^3sg\"\u001aa$!\u0002\u0002EQ,7\u000f\u001e*fa2L7-\u0019)mC\u000e,W.\u001a8u!\u0006\u0014H/[1m'\u0016\u0014h/\u001a:tQ\ry\u0012QA\u0001\u001am\u0006d\u0017\u000eZ1uK2+\u0017\rZ3s\u0003:$'+\u001a9mS\u000e\f7\u000fF\u0005k\u0003G\ti&a\u0018\u0002d!9\u0011Q\u0005\u0011A\u0002\u0005\u001d\u0012\u0001C7fi\u0006$\u0017\r^1\u0011\t\u0005%\u0012q\u000b\b\u0005\u0003W\t\tF\u0004\u0003\u0002.\u0005-c\u0002BA\u0018\u0003\u000brA!!\r\u0002B9!\u00111GA\u001f\u001d\u0011\t)$a\u000f\u000e\u0005\u0005]\"bAA\u001dM\u00051AH]8pizJ\u0011\u0001_\u0005\u0004\u0003\u007f9\u0018AB1qC\u000eDW-C\u0002&\u0003\u0007R1!a\u0010x\u0013\u0011\t9%!\u0013\u0002\r\r|W.\\8o\u0015\r)\u00131I\u0005\u0005\u0003\u001b\ny%\u0001\u0005sKF,Xm\u001d;t\u0015\u0011\t9%!\u0013\n\t\u0005M\u0013QK\u0001\u0011\u001b\u0016$\u0018\rZ1uCJ+7\u000f]8og\u0016TA!!\u0014\u0002P%!\u0011\u0011LA.\u00055!v\u000e]5d\u001b\u0016$\u0018\rZ1uC*!\u00111KA+\u0011\u0015Q\u0004\u00051\u00015\u0011\u0019\t\t\u0007\ta\u0001i\u0005\u0001R\r\u001f9fGR,G\rT3bI\u0016\u0014\u0018\n\u001a\u0005\b\u0003K\u0002\u0003\u0019AA4\u0003A)\u0007\u0010]3di\u0016$'+\u001a9mS\u000e\f7\u000fE\u0003\u0002j\u0005EDG\u0004\u0003\u0002l\u00055\u0004cAA\u001bm%\u0019\u0011q\u000e\u001c\u0002\rA\u0013X\rZ3g\u0013\u0011\t\u0019(!\u001e\u0003\u0007M+GOC\u0002\u0002pY\u0002")
public class AddPartitionsTest
extends BaseRequestTest {
    private final int partitionId;
    private final String topic1;
    private final scala.collection.immutable.Map<Object, ReplicaAssignment> topic1Assignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)ReplicaAssignment$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1})), (Seq)Nil$.MODULE$, (Seq)Nil$.MODULE$))}));
    private final String topic2;
    private final scala.collection.immutable.Map<Object, ReplicaAssignment> topic2Assignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)ReplicaAssignment$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})), (Seq)Nil$.MODULE$, (Seq)Nil$.MODULE$))}));
    private final String topic3;
    private final scala.collection.immutable.Map<Object, ReplicaAssignment> topic3Assignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)ReplicaAssignment$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3, 0, 1})), (Seq)Nil$.MODULE$, (Seq)Nil$.MODULE$))}));
    private final String topic4;
    private final scala.collection.immutable.Map<Object, ReplicaAssignment> topic4Assignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)ReplicaAssignment$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 3})), (Seq)Nil$.MODULE$, (Seq)Nil$.MODULE$))}));
    private final String topic5;
    private final scala.collection.immutable.Map<Object, ReplicaAssignment> topic5Assignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)ReplicaAssignment$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1})), (Seq)Nil$.MODULE$, (Seq)Nil$.MODULE$))}));

    @Override
    public int brokerCount() {
        return 4;
    }

    public int partitionId() {
        return this.partitionId;
    }

    public String topic1() {
        return this.topic1;
    }

    public scala.collection.immutable.Map<Object, ReplicaAssignment> topic1Assignment() {
        return this.topic1Assignment;
    }

    public String topic2() {
        return this.topic2;
    }

    public scala.collection.immutable.Map<Object, ReplicaAssignment> topic2Assignment() {
        return this.topic2Assignment;
    }

    public String topic3() {
        return this.topic3;
    }

    public scala.collection.immutable.Map<Object, ReplicaAssignment> topic3Assignment() {
        return this.topic3Assignment;
    }

    public String topic4() {
        return this.topic4;
    }

    public scala.collection.immutable.Map<Object, ReplicaAssignment> topic4Assignment() {
        return this.topic4Assignment;
    }

    public String topic5() {
        return this.topic5;
    }

    public scala.collection.immutable.Map<Object, ReplicaAssignment> topic5Assignment() {
        return this.topic5Assignment;
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        super.setUp(testInfo);
        this.createTopic(this.topic1(), (Map<Object, Seq<Object>>)((Map)this.topic1Assignment().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            int k = x0$1._1$mcI$sp();
            ReplicaAssignment v = (ReplicaAssignment)x0$1._2();
            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)k)), (Object)v.replicas());
            return tuple2;
        }, Map$.MODULE$.canBuildFrom())));
        this.createTopic(this.topic2(), (Map<Object, Seq<Object>>)((Map)this.topic2Assignment().map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            if (x0$2 == null) {
                throw new MatchError(null);
            }
            int k = x0$2._1$mcI$sp();
            ReplicaAssignment v = (ReplicaAssignment)x0$2._2();
            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)k)), (Object)v.replicas());
            return tuple2;
        }, Map$.MODULE$.canBuildFrom())));
        this.createTopic(this.topic3(), (Map<Object, Seq<Object>>)((Map)this.topic3Assignment().map((Function1 & Serializable & scala.Serializable)x0$3 -> {
            if (x0$3 == null) {
                throw new MatchError(null);
            }
            int k = x0$3._1$mcI$sp();
            ReplicaAssignment v = (ReplicaAssignment)x0$3._2();
            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)k)), (Object)v.replicas());
            return tuple2;
        }, Map$.MODULE$.canBuildFrom())));
        this.createTopic(this.topic4(), (Map<Object, Seq<Object>>)((Map)this.topic4Assignment().map((Function1 & Serializable & scala.Serializable)x0$4 -> {
            if (x0$4 == null) {
                throw new MatchError(null);
            }
            int k = x0$4._1$mcI$sp();
            ReplicaAssignment v = (ReplicaAssignment)x0$4._2();
            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)k)), (Object)v.replicas());
            return tuple2;
        }, Map$.MODULE$.canBuildFrom())));
    }

    @Test
    public void testWrongReplicaCount() {
        Assertions.assertThrows(InvalidReplicaAssignmentException.class, () -> {
            AdminZkClient qual$1 = this.adminZkClient();
            String x$3 = this.topic1();
            scala.collection.immutable.Map<Object, ReplicaAssignment> x$4 = this.topic1Assignment();
            AdminZkClient qual$2 = this.adminZkClient();
            RackAwareMode x$1 = qual$2.getBrokerMetadatas$default$1();
            Option x$2 = qual$2.getBrokerMetadatas$default$2();
            Seq x$5 = qual$2.getBrokerMetadatas(x$1, x$2);
            int x$6 = 2;
            Some x$7 = new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2})))})));
            boolean x$8 = qual$1.addPartitions$default$6();
            qual$1.addPartitions(x$3, x$4, x$5, x$6, (Option)x$7, x$8);
        });
    }

    @Test
    public void testMissingPartition0() {
        Assertions.assertTrue((boolean)((AdminOperationException)Assertions.assertThrows(AdminOperationException.class, () -> {
            AdminZkClient qual$1 = this.adminZkClient();
            String x$3 = this.topic5();
            scala.collection.immutable.Map<Object, ReplicaAssignment> x$4 = this.topic5Assignment();
            AdminZkClient qual$2 = this.adminZkClient();
            RackAwareMode x$1 = qual$2.getBrokerMetadatas$default$1();
            Option x$2 = qual$2.getBrokerMetadatas$default$2();
            Seq x$5 = qual$2.getBrokerMetadatas(x$1, x$2);
            int x$6 = 2;
            Some x$7 = new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2})))})));
            boolean x$8 = qual$1.addPartitions$default$6();
            qual$1.addPartitions(x$3, x$4, x$5, x$6, (Option)x$7, x$8);
        })).getMessage().contains("Unexpected existing replica assignment for topic 'new-topic5', partition id 0 is missing"));
    }

    @Test
    public void testIncrementPartitions() {
        AdminZkClient qual$1 = this.adminZkClient();
        String x$3 = this.topic1();
        scala.collection.immutable.Map<Object, ReplicaAssignment> x$4 = this.topic1Assignment();
        AdminZkClient qual$2 = this.adminZkClient();
        RackAwareMode x$12 = qual$2.getBrokerMetadatas$default$1();
        Option x$2 = qual$2.getBrokerMetadatas$default$2();
        Seq x$5 = qual$2.getBrokerMetadatas(x$12, x$2);
        int x$6 = 3;
        Option x$7 = qual$1.addPartitions$default$5();
        boolean x$8 = qual$1.addPartitions$default$6();
        qual$1.addPartitions(x$3, x$4, x$5, x$6, x$7, x$8);
        int leader1 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkClient(), this.topic1(), 1, TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6());
        int leader2 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkClient(), this.topic1(), 2, TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6());
        int leader1FromZk = BoxesRunTime.unboxToInt((Object)this.zkClient().getLeaderForPartition(new TopicPartition(this.topic1(), 1)).get());
        int leader2FromZk = BoxesRunTime.unboxToInt((Object)this.zkClient().getLeaderForPartition(new TopicPartition(this.topic1(), 2)).get());
        Assertions.assertEquals((int)leader1, (int)leader1FromZk);
        Assertions.assertEquals((int)leader2, (int)leader2FromZk);
        TestUtils$.MODULE$.waitForPartitionMetadata(this.servers(), this.topic1(), 1, TestUtils$.MODULE$.waitForPartitionMetadata$default$4());
        TestUtils$.MODULE$.waitForPartitionMetadata(this.servers(), this.topic1(), 2, TestUtils$.MODULE$.waitForPartitionMetadata$default$4());
        MetadataResponse response = (MetadataResponse)this.connectAndReceive(new MetadataRequest.Builder((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.topic1(), (List)Nil$.MODULE$)).asJava(), false).build(), this.connectAndReceive$default$2(), this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(MetadataResponse.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals()));
        Assertions.assertEquals((int)1, (int)response.topicMetadata().size());
        Buffer partitions = (Buffer)((SeqLike)CollectionConverters$.MODULE$.asScalaBufferConverter(((MetadataResponse.TopicMetadata)((IterableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(response.topicMetadata()).asScala()).head()).partitionMetadata()).asScala()).sortBy((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.partition()), (Ordering)Ordering.Int$.MODULE$);
        Assertions.assertEquals((int)partitions.size(), (int)3);
        Assertions.assertEquals((int)1, (int)((MetadataResponse.PartitionMetadata)partitions.apply(1)).partition());
        Assertions.assertEquals((int)2, (int)((MetadataResponse.PartitionMetadata)partitions.apply(2)).partition());
        partitions.foreach((Function1 & Serializable & scala.Serializable)partition -> {
            AddPartitionsTest.$anonfun$testIncrementPartitions$2(partition);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testManualAssignmentOfReplicas() {
        AdminZkClient qual$1 = this.adminZkClient();
        String x$3 = this.topic2();
        scala.collection.immutable.Map<Object, ReplicaAssignment> x$4 = this.topic2Assignment();
        AdminZkClient qual$2 = this.adminZkClient();
        RackAwareMode x$1 = qual$2.getBrokerMetadatas$default$1();
        Option x$22 = qual$2.getBrokerMetadatas$default$2();
        Seq x$5 = qual$2.getBrokerMetadatas(x$1, x$22);
        int x$6 = 3;
        Some x$7 = new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})))})));
        boolean x$8 = qual$1.addPartitions$default$6();
        qual$1.addPartitions(x$3, x$4, x$5, x$6, (Option)x$7, x$8);
        int leader1 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkClient(), this.topic2(), 1, TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6());
        int leader2 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkClient(), this.topic2(), 2, TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6());
        int leader1FromZk = BoxesRunTime.unboxToInt((Object)this.zkClient().getLeaderForPartition(new TopicPartition(this.topic2(), 1)).get());
        int leader2FromZk = BoxesRunTime.unboxToInt((Object)this.zkClient().getLeaderForPartition(new TopicPartition(this.topic2(), 2)).get());
        Assertions.assertEquals((int)leader1, (int)leader1FromZk);
        Assertions.assertEquals((int)leader2, (int)leader2FromZk);
        TestUtils$.MODULE$.waitForPartitionMetadata(this.servers(), this.topic2(), 1, TestUtils$.MODULE$.waitForPartitionMetadata$default$4());
        TestUtils$.MODULE$.waitForPartitionMetadata(this.servers(), this.topic2(), 2, TestUtils$.MODULE$.waitForPartitionMetadata$default$4());
        MetadataResponse response = (MetadataResponse)this.connectAndReceive(new MetadataRequest.Builder((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.topic2(), (List)Nil$.MODULE$)).asJava(), false).build(), this.connectAndReceive$default$2(), this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(MetadataResponse.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals()));
        Assertions.assertEquals((int)1, (int)response.topicMetadata().size());
        MetadataResponse.TopicMetadata topicMetadata = (MetadataResponse.TopicMetadata)((IterableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(response.topicMetadata()).asScala()).head();
        Buffer partitionMetadata = (Buffer)((SeqLike)CollectionConverters$.MODULE$.asScalaBufferConverter(topicMetadata.partitionMetadata()).asScala()).sortBy((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.partition()), (Ordering)Ordering.Int$.MODULE$);
        Assertions.assertEquals((int)3, (int)topicMetadata.partitionMetadata().size());
        Assertions.assertEquals((int)0, (int)((MetadataResponse.PartitionMetadata)partitionMetadata.apply(0)).partition());
        Assertions.assertEquals((int)1, (int)((MetadataResponse.PartitionMetadata)partitionMetadata.apply(1)).partition());
        Assertions.assertEquals((int)2, (int)((MetadataResponse.PartitionMetadata)partitionMetadata.apply(2)).partition());
        java.util.List replicas = ((MetadataResponse.PartitionMetadata)partitionMetadata.apply((int)1)).replicaIds;
        Assertions.assertEquals((int)2, (int)replicas.size());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1})), (Object)((TraversableOnce)CollectionConverters$.MODULE$.asScalaBufferConverter(replicas).asScala()).toSet());
    }

    @Test
    public void testReplicaPlacementAllServers() {
        AdminZkClient qual$1 = this.adminZkClient();
        String x$3 = this.topic3();
        scala.collection.immutable.Map<Object, ReplicaAssignment> x$4 = this.topic3Assignment();
        AdminZkClient qual$2 = this.adminZkClient();
        RackAwareMode x$1 = qual$2.getBrokerMetadatas$default$1();
        Option x$2 = qual$2.getBrokerMetadatas$default$2();
        Seq x$5 = qual$2.getBrokerMetadatas(x$1, x$2);
        int x$6 = 7;
        Option x$7 = qual$1.addPartitions$default$5();
        boolean x$8 = qual$1.addPartitions$default$6();
        qual$1.addPartitions(x$3, x$4, x$5, x$6, x$7, x$8);
        TestUtils$.MODULE$.waitForPartitionMetadata(this.servers(), this.topic3(), 1, TestUtils$.MODULE$.waitForPartitionMetadata$default$4());
        TestUtils$.MODULE$.waitForPartitionMetadata(this.servers(), this.topic3(), 2, TestUtils$.MODULE$.waitForPartitionMetadata$default$4());
        TestUtils$.MODULE$.waitForPartitionMetadata(this.servers(), this.topic3(), 3, TestUtils$.MODULE$.waitForPartitionMetadata$default$4());
        TestUtils$.MODULE$.waitForPartitionMetadata(this.servers(), this.topic3(), 4, TestUtils$.MODULE$.waitForPartitionMetadata$default$4());
        TestUtils$.MODULE$.waitForPartitionMetadata(this.servers(), this.topic3(), 5, TestUtils$.MODULE$.waitForPartitionMetadata$default$4());
        TestUtils$.MODULE$.waitForPartitionMetadata(this.servers(), this.topic3(), 6, TestUtils$.MODULE$.waitForPartitionMetadata$default$4());
        MetadataResponse response = (MetadataResponse)this.connectAndReceive(new MetadataRequest.Builder((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.topic3(), (List)Nil$.MODULE$)).asJava(), false).build(), this.connectAndReceive$default$2(), this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(MetadataResponse.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals()));
        Assertions.assertEquals((int)1, (int)response.topicMetadata().size());
        MetadataResponse.TopicMetadata topicMetadata = (MetadataResponse.TopicMetadata)((IterableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(response.topicMetadata()).asScala()).head();
        this.validateLeaderAndReplicas(topicMetadata, 0, 2, (Set<Object>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3, 0, 1}))));
        this.validateLeaderAndReplicas(topicMetadata, 1, 3, (Set<Object>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 2, 0, 1}))));
        this.validateLeaderAndReplicas(topicMetadata, 2, 0, (Set<Object>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 3, 1, 2}))));
        this.validateLeaderAndReplicas(topicMetadata, 3, 1, (Set<Object>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 0, 2, 3}))));
        this.validateLeaderAndReplicas(topicMetadata, 4, 2, (Set<Object>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3, 0, 1}))));
        this.validateLeaderAndReplicas(topicMetadata, 5, 3, (Set<Object>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 0, 1, 2}))));
        this.validateLeaderAndReplicas(topicMetadata, 6, 0, (Set<Object>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3}))));
    }

    @Test
    public void testReplicaPlacementPartialServers() {
        AdminZkClient qual$1 = this.adminZkClient();
        String x$3 = this.topic2();
        scala.collection.immutable.Map<Object, ReplicaAssignment> x$4 = this.topic2Assignment();
        AdminZkClient qual$2 = this.adminZkClient();
        RackAwareMode x$1 = qual$2.getBrokerMetadatas$default$1();
        Option x$2 = qual$2.getBrokerMetadatas$default$2();
        Seq x$5 = qual$2.getBrokerMetadatas(x$1, x$2);
        int x$6 = 3;
        Option x$7 = qual$1.addPartitions$default$5();
        boolean x$8 = qual$1.addPartitions$default$6();
        qual$1.addPartitions(x$3, x$4, x$5, x$6, x$7, x$8);
        TestUtils$.MODULE$.waitForPartitionMetadata(this.servers(), this.topic2(), 1, TestUtils$.MODULE$.waitForPartitionMetadata$default$4());
        TestUtils$.MODULE$.waitForPartitionMetadata(this.servers(), this.topic2(), 2, TestUtils$.MODULE$.waitForPartitionMetadata$default$4());
        MetadataResponse response = (MetadataResponse)this.connectAndReceive(new MetadataRequest.Builder((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.topic2(), (List)Nil$.MODULE$)).asJava(), false).build(), this.connectAndReceive$default$2(), this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(MetadataResponse.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals()));
        Assertions.assertEquals((int)1, (int)response.topicMetadata().size());
        MetadataResponse.TopicMetadata topicMetadata = (MetadataResponse.TopicMetadata)((IterableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(response.topicMetadata()).asScala()).head();
        this.validateLeaderAndReplicas(topicMetadata, 0, 1, (Set<Object>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2}))));
        this.validateLeaderAndReplicas(topicMetadata, 1, 2, (Set<Object>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 2}))));
        this.validateLeaderAndReplicas(topicMetadata, 2, 3, (Set<Object>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 3}))));
    }

    public void validateLeaderAndReplicas(MetadataResponse.TopicMetadata metadata, int partitionId, int expectedLeaderId, Set<Object> expectedReplicas) {
        Option partitionOpt = ((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(metadata.partitionMetadata()).asScala()).find((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)AddPartitionsTest.$anonfun$validateLeaderAndReplicas$1(partitionId, x$3)));
        Assertions.assertTrue((boolean)partitionOpt.isDefined(), (String)new StringBuilder(23).append("Partition ").append(partitionId).append(" should exist").toString());
        MetadataResponse.PartitionMetadata partition = (MetadataResponse.PartitionMetadata)partitionOpt.get();
        Assertions.assertEquals(Optional.of(BoxesRunTime.boxToInteger((int)expectedLeaderId)), (Object)partition.leaderId, (String)"Partition leader id should match");
        Assertions.assertEquals(expectedReplicas, (Object)((TraversableOnce)CollectionConverters$.MODULE$.asScalaBufferConverter(partition.replicaIds).asScala()).toSet(), (String)"Replica set should match");
    }

    public static final /* synthetic */ void $anonfun$testIncrementPartitions$2(MetadataResponse.PartitionMetadata partition) {
        java.util.List replicas = partition.replicaIds;
        Assertions.assertEquals((int)2, (int)replicas.size());
        Assertions.assertTrue((boolean)partition.leaderId.isPresent());
        Integer leaderId = (Integer)partition.leaderId.get();
        Assertions.assertTrue((boolean)replicas.contains(leaderId));
    }

    public static final /* synthetic */ boolean $anonfun$validateLeaderAndReplicas$1(int partitionId$1, MetadataResponse.PartitionMetadata x$3) {
        return x$3.partition() == partitionId$1;
    }

    public AddPartitionsTest() {
        this.partitionId = 0;
        this.topic1 = "new-topic1";
        this.topic2 = "new-topic2";
        this.topic3 = "new-topic3";
        this.topic4 = "new-topic4";
        this.topic5 = "new-topic5";
    }
}

