/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.Serializable;
import java.time.Duration;
import java.util.Collection;
import java.util.Properties;
import kafka.api.AbstractConsumerTest;
import kafka.server.BaseRequestTest;
import kafka.server.KafkaConfig$;
import kafka.utils.ShutdownableThread;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.consumer.OffsetCommitCallback;
import org.apache.kafka.clients.consumer.RetriableCommitFailedException;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.WakeupException;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInfo;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u00115g!\u00024h\u0003\u0003a\u0007\"B:\u0001\t\u0003!\bbB<\u0001\u0005\u0004%\t\u0001\u001f\u0005\u0007\u007f\u0002\u0001\u000b\u0011B=\t\u000f\u0005\u0005\u0001\u0001\"\u0011\u0002\u0004!I\u00111\u0002\u0001C\u0002\u0013\u0005\u0011Q\u0002\u0005\t\u0003?\u0001\u0001\u0015!\u0003\u0002\u0010!I\u0011\u0011\u0005\u0001C\u0002\u0013\u0005\u00111\u0001\u0005\t\u0003G\u0001\u0001\u0015!\u0003\u0002\u0006!I\u0011Q\u0005\u0001C\u0002\u0013\u0005\u0011q\u0005\u0005\t\u0003\u007f\u0001\u0001\u0015!\u0003\u0002*!I\u0011\u0011\t\u0001C\u0002\u0013\u0005\u00111\u0001\u0005\t\u0003\u0007\u0002\u0001\u0015!\u0003\u0002\u0006!I\u0011Q\t\u0001C\u0002\u0013\u0005\u0011q\u0005\u0005\t\u0003\u000f\u0002\u0001\u0015!\u0003\u0002*!I\u0011\u0011\n\u0001C\u0002\u0013\u0005\u0011Q\u0002\u0005\t\u0003\u0017\u0002\u0001\u0015!\u0003\u0002\u0010!I\u0011Q\n\u0001C\u0002\u0013\u0005\u0011Q\u0002\u0005\t\u0003\u001f\u0002\u0001\u0015!\u0003\u0002\u0010!I\u0011\u0011\u000b\u0001C\u0002\u0013\u0005\u0011Q\u0002\u0005\t\u0003'\u0002\u0001\u0015!\u0003\u0002\u0010!I\u0011Q\u000b\u0001C\u0002\u0013\u0005\u0011q\u000b\u0005\t\u0003?\u0002\u0001\u0015!\u0003\u0002Z!9\u0011\u0011\r\u0001\u0005R\u0005\r\u0004bBA>\u0001\u0011\u0005\u0013Q\u0010\u0004\u0007\u0003;\u0003\u0001\"a(\t\rMLB\u0011AA\\\u0011%\ti,\u0007a\u0001\n\u0003\t\u0019\u0001C\u0005\u0002@f\u0001\r\u0011\"\u0001\u0002B\"A\u0011qY\r!B\u0013\t)\u0001C\u0005\u0002Jf\u0001\r\u0011\"\u0001\u0002\u0004!I\u00111Z\rA\u0002\u0013\u0005\u0011Q\u001a\u0005\t\u0003#L\u0002\u0015)\u0003\u0002\u0006!9\u00111[\r\u0005\u0002\u0005U\u0007bBAq3\u0011\u0005\u00111\u001d\u0005\b\u0003O\u0004A\u0011CAu\u0011\u001d\u0011)\u0002\u0001C\t\u0005/A\u0011B!\u0013\u0001#\u0003%\tBa\u0013\t\u000f\t\u0005\u0004\u0001\"\u0005\u0003d!I!q\u0012\u0001\u0012\u0002\u0013E!\u0011\u0013\u0005\n\u0005+\u0003\u0011\u0013!C\t\u0005\u0017B\u0011Ba&\u0001#\u0003%\tB!'\t\u0013\tu\u0005!%A\u0005\u0012\t}\u0005\"\u0003BR\u0001E\u0005I\u0011\u0003BI\u0011\u001d\u0011)\u000b\u0001C\t\u0005OC\u0011B!:\u0001#\u0003%\tBa:\t\u000f\t5\b\u0001\"\u0005\u0003p\"91Q\u0001\u0001\u0005\u0012\r\u001d\u0001\"CB\u0017\u0001E\u0005I\u0011CB\u0018\u0011\u001d\u0019I\u0004\u0001C\u0001\u0007wA\u0011b!@\u0001#\u0003%\taa@\t\u000f\u0011\r\u0001\u0001\"\u0001\u0005\u0006!IA1\u0003\u0001\u0012\u0002\u0013\u00051q \u0005\b\t+\u0001A\u0011\u0001C\f\u0011%!i\u0003AI\u0001\n\u0003!y\u0003C\u0005\u00054\u0001\t\n\u0011\"\u0001\u0003L!IAQ\u0007\u0001\u0012\u0002\u0013\u0005Aq\u0007\u0005\b\tw\u0001A\u0011\u0001C\u001f\u0011%!)\u0005AI\u0001\n\u0003!9\u0005C\u0004\u0005L\u0001!\t\u0002\"\u0014\t\u000f\u0011\r\u0004\u0001\"\u0005\u0005f\u00191A1\u0010\u0001\t\t{Baa]\u001f\u0005\u0002\u0011\u0015\u0005\"\u0003CE{\u0001\u0007I\u0011AA\u0002\u0011%!Y)\u0010a\u0001\n\u0003!i\t\u0003\u0005\u0005\u0012v\u0002\u000b\u0015BA\u0003\u0011%!\u0019*\u0010a\u0001\n\u0003\t\u0019\u0001C\u0005\u0005\u0016v\u0002\r\u0011\"\u0001\u0005\u0018\"AA1T\u001f!B\u0013\t)\u0001C\u0005\u0005\u001ev\u0002\r\u0011\"\u0001\u0005 \"IA\u0011V\u001fA\u0002\u0013\u0005A1\u0016\u0005\t\t_k\u0004\u0015)\u0003\u0005\"\"9A\u0011W\u001f\u0005B\u0011MfABB'\u0001!\u0019y\u0005\u0003\u0006\u0002.&\u0013\t\u0011)A\u0005\u0005OB!b!\u0018J\u0005\u0003\u0005\u000b\u0011BB0\u0011)\u0019)'\u0013B\u0001B\u0003%!\u0011\u001f\u0005\u0007g&#\taa\u001a\t\rMLE\u0011AB8\u0011\u0019\u0019\u0018\n\"\u0001\u0004v!I11P%A\u0002\u0013\u00051Q\u0010\u0005\n\u0007\u000fK\u0005\u0019!C\u0001\u0007\u0013C\u0001b!$JA\u0003&1q\u0010\u0005\n\u0007/K\u0005\u0019!C\u0001\u0003\u0007A\u0011b!'J\u0001\u0004%\taa'\t\u0011\r}\u0015\n)Q\u0005\u0003\u000bA\u0011ba)J\u0005\u0004%Ia!*\t\u0011\r-\u0016\n)A\u0005\u0007OC\u0011b!,J\u0001\u0004%Iaa,\t\u0013\r]\u0016\n1A\u0005\n\re\u0006\u0002CB_\u0013\u0002\u0006Ka!-\t\u0013\r\u0005\u0017\n1A\u0005\n\r\r\u0007\"CBc\u0013\u0002\u0007I\u0011BBd\u0011!\u0019Y-\u0013Q!\n\r}\u0003\"CBg\u0013\n\u0007I\u0011ABh\u0011!\u0019\t.\u0013Q\u0001\n\u0005\u001d\u0006bBBj\u0013\u0012\u00051Q\u001b\u0005\b\u0007/LE\u0011ABm\u0011\u001d\u0019y.\u0013C\u0001\u0007_Cqa!9J\t\u0003\u001a\u0019\u000fC\u0004\u0004f&#\tea:\t\u000f\u0011\u0005\u0007\u0001\"\u0001\u0005D\n!\u0012IY:ue\u0006\u001cGoQ8ogVlWM\u001d+fgRT!\u0001[5\u0002\u0007\u0005\u0004\u0018NC\u0001k\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001A7\u0011\u00059\fX\"A8\u000b\u0005AL\u0017AB:feZ,'/\u0003\u0002s_\ny!)Y:f%\u0016\fX/Z:u)\u0016\u001cH/\u0001\u0004=S:LGO\u0010\u000b\u0002kB\u0011a\u000fA\u0007\u0002O\u00069Q\r]:jY>tW#A=\u0011\u0005ilX\"A>\u000b\u0003q\fQa]2bY\u0006L!A`>\u0003\r\u0011{WO\u00197f\u0003!)\u0007o]5m_:\u0004\u0013a\u00032s_.,'oQ8v]R,\"!!\u0002\u0011\u0007i\f9!C\u0002\u0002\nm\u00141!\u00138u\u0003\u0015!x\u000e]5d+\t\ty\u0001\u0005\u0003\u0002\u0012\u0005mQBAA\n\u0015\u0011\t)\"a\u0006\u0002\t1\fgn\u001a\u0006\u0003\u00033\tAA[1wC&!\u0011QDA\n\u0005\u0019\u0019FO]5oO\u00061Ao\u001c9jG\u0002\nA\u0001]1si\u0006)\u0001/\u0019:uA\u0005\u0011A\u000f]\u000b\u0003\u0003S\u0001B!a\u000b\u0002<5\u0011\u0011Q\u0006\u0006\u0005\u0003_\t\t$\u0001\u0004d_6lwN\u001c\u0006\u0004U\u0006M\"\u0002BA\u001b\u0003o\ta!\u00199bG\",'BAA\u001d\u0003\ry'oZ\u0005\u0005\u0003{\tiC\u0001\bU_BL7\rU1si&$\u0018n\u001c8\u0002\u0007Q\u0004\b%A\u0003qCJ$('\u0001\u0004qCJ$(\u0007I\u0001\u0004iB\u0014\u0014\u0001\u0002;qe\u0001\nQa\u001a:pkB\faa\u001a:pkB\u0004\u0013\u0001\u00059s_\u0012,8-\u001a:DY&,g\u000e^%e\u0003E\u0001(o\u001c3vG\u0016\u00148\t\\5f]RLE\rI\u0001\u0011G>t7/^7fe\u000ec\u0017.\u001a8u\u0013\u0012\f\u0011cY8ogVlWM]\"mS\u0016tG/\u00133!\u0003a9'o\\;q\u001b\u0006D8+Z:tS>tG+[7f_V$Xj]\u000b\u0003\u00033\u00022A_A.\u0013\r\tif\u001f\u0002\u0005\u0019>tw-A\rhe>,\b/T1y'\u0016\u001c8/[8o)&lWm\\;u\u001bN\u0004\u0013a\u00062s_.,'\u000f\u0015:pa\u0016\u0014H/_(wKJ\u0014\u0018\u000eZ3t)\u0011\t)'a\u001b\u0011\u0007i\f9'C\u0002\u0002jm\u0014A!\u00168ji\"9\u0011QN\fA\u0002\u0005=\u0014A\u00039s_B,'\u000f^5fgB!\u0011\u0011OA<\u001b\t\t\u0019H\u0003\u0003\u0002v\u0005]\u0011\u0001B;uS2LA!!\u001f\u0002t\tQ\u0001K]8qKJ$\u0018.Z:\u0002\u000bM,G/\u00169\u0015\t\u0005\u0015\u0014q\u0010\u0005\b\u0003\u0003C\u0002\u0019AAB\u0003!!Xm\u001d;J]\u001a|\u0007\u0003BAC\u0003#k!!a\"\u000b\u0007!\fII\u0003\u0003\u0002\f\u00065\u0015a\u00026va&$XM\u001d\u0006\u0005\u0003\u001f\u000b9$A\u0003kk:LG/\u0003\u0003\u0002\u0014\u0006\u001d%\u0001\u0003+fgRLeNZ8)\u0007a\t9\n\u0005\u0003\u0002\u0006\u0006e\u0015\u0002BAN\u0003\u000f\u0013!BQ3g_J,W)Y2i\u0005\u0001\"Vm\u001d;D_:\u001cX/\\3s%\u0016\f7o]5h]6,g\u000e\u001e'jgR,g.\u001a:\u0014\u000be\t\t+a*\u0011\t\u0005E\u00111U\u0005\u0005\u0003K\u000b\u0019B\u0001\u0004PE*,7\r\u001e\t\u0005\u0003S\u000b\u0019,\u0004\u0002\u0002,*!\u0011QVAX\u0003!\u0019wN\\:v[\u0016\u0014(\u0002BAY\u0003c\tqa\u00197jK:$8/\u0003\u0003\u00026\u0006-&!G\"p]N,X.\u001a:SK\n\fG.\u00198dK2K7\u000f^3oKJ$\"!!/\u0011\u0007\u0005m\u0016$D\u0001\u0001\u0003=\u0019\u0017\r\u001c7t)>\f5o]5h]\u0016$\u0017aE2bY2\u001cHk\\!tg&<g.\u001a3`I\u0015\fH\u0003BA3\u0003\u0007D\u0011\"!2\u001d\u0003\u0003\u0005\r!!\u0002\u0002\u0007a$\u0013'\u0001\tdC2d7\u000fV8BgNLwM\\3eA\u0005q1-\u00197mgR{'+\u001a<pW\u0016$\u0017AE2bY2\u001cHk\u001c*fm>\\W\rZ0%KF$B!!\u001a\u0002P\"I\u0011QY\u0010\u0002\u0002\u0003\u0007\u0011QA\u0001\u0010G\u0006dGn\u001d+p%\u00164xn[3eA\u0005!rN\u001c)beRLG/[8og\u0006\u001b8/[4oK\u0012$B!!\u001a\u0002X\"9\u0011\u0011\\\u0011A\u0002\u0005m\u0017A\u00039beRLG/[8ogB1\u0011\u0011OAo\u0003SIA!a8\u0002t\tQ1i\u001c7mK\u000e$\u0018n\u001c8\u0002'=t\u0007+\u0019:uSRLwN\\:SKZ|7.\u001a3\u0015\t\u0005\u0015\u0014Q\u001d\u0005\b\u00033\u0014\u0003\u0019AAn\u0003e\u0019'/Z1uK\u000e{gn];nKJ<\u0016\u000e\u001e5He>,\b/\u00133\u0015\t\u0005-\u0018Q \t\t\u0003S\u000bi/!=\u0002r&!\u0011q^AV\u00055Y\u0015MZ6b\u0007>t7/^7feB)!0a=\u0002x&\u0019\u0011Q_>\u0003\u000b\u0005\u0013(/Y=\u0011\u0007i\fI0C\u0002\u0002|n\u0014AAQ=uK\"9\u0011q`\u0012A\u0002\t\u0005\u0011aB4s_V\u0004\u0018\n\u001a\t\u0005\u0005\u0007\u0011\tB\u0004\u0003\u0003\u0006\t5\u0001c\u0001B\u0004w6\u0011!\u0011\u0002\u0006\u0004\u0005\u0017Y\u0017A\u0002\u001fs_>$h(C\u0002\u0003\u0010m\fa\u0001\u0015:fI\u00164\u0017\u0002BA\u000f\u0005'Q1Aa\u0004|\u0003-\u0019XM\u001c3SK\u000e|'\u000fZ:\u0015\u0015\te!q\u0007B \u0005\u0007\u0012)\u0005\u0005\u0004\u0003\u001c\t\u0015\"1\u0006\b\u0005\u0005;\u0011\tC\u0004\u0003\u0003\b\t}\u0011\"\u0001?\n\u0007\t\r20A\u0004qC\u000e\\\u0017mZ3\n\t\t\u001d\"\u0011\u0006\u0002\u0004'\u0016\f(b\u0001B\u0012wBA!Q\u0006B\u001a\u0003c\f\t0\u0004\u0002\u00030)!!\u0011GAX\u0003!\u0001(o\u001c3vG\u0016\u0014\u0018\u0002\u0002B\u001b\u0005_\u0011a\u0002\u0015:pIV\u001cWM\u001d*fG>\u0014H\rC\u0004\u00032\u0011\u0002\rA!\u000f\u0011\u0011\t5\"1HAy\u0003cLAA!\u0010\u00030\ti1*\u00194lCB\u0013x\u000eZ;dKJDqA!\u0011%\u0001\u0004\t)!\u0001\u0006ok6\u0014VmY8sINDq!!\n%\u0001\u0004\tI\u0003C\u0005\u0003H\u0011\u0002\n\u00111\u0001\u0002Z\u0005\t2\u000f^1si&tw\rV5nKN$\u0018-\u001c9\u0002+M,g\u000e\u001a*fG>\u0014Hm\u001d\u0013eK\u001a\fW\u000f\u001c;%iU\u0011!Q\n\u0016\u0005\u00033\u0012ye\u000b\u0002\u0003RA!!1\u000bB/\u001b\t\u0011)F\u0003\u0003\u0003X\te\u0013!C;oG\",7m[3e\u0015\r\u0011Yf_\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002B0\u0005+\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003]\u0019wN\\:v[\u0016\fe\u000e\u001a,fe&4\u0017PU3d_J$7\u000f\u0006\n\u0002f\t\u0015$Q\u000eB8\u0005g\u00129H!\u001f\u0003\n\n-\u0005bBAWM\u0001\u0007!q\r\t\t\u0003S\u0013I'!=\u0002r&!!1NAV\u0005!\u0019uN\\:v[\u0016\u0014\bb\u0002B!M\u0001\u0007\u0011Q\u0001\u0005\b\u0005c2\u0003\u0019AA\u0003\u00039\u0019H/\u0019:uS:<wJ\u001a4tKRD\u0011B!\u001e'!\u0003\u0005\r!!\u0002\u00021M$\u0018M\u001d;j]\u001e\\U-_!oIZ\u000bG.^3J]\u0012,\u0007\u0010C\u0005\u0003H\u0019\u0002\n\u00111\u0001\u0002Z!I!1\u0010\u0014\u0011\u0002\u0003\u0007!QP\u0001\u000ei&lWm\u001d;b[B$\u0016\u0010]3\u0011\t\t}$QQ\u0007\u0003\u0005\u0003SAAa!\u0002.\u00051!/Z2pe\u0012LAAa\"\u0003\u0002\niA+[7fgR\fW\u000e\u001d+za\u0016D\u0011\"!\n'!\u0003\u0005\r!!\u000b\t\u0013\t5e\u0005%AA\u0002\u0005\u0015\u0011AD7bqB{G\u000e\u001c*fG>\u0014Hm]\u0001\"G>t7/^7f\u0003:$g+\u001a:jMf\u0014VmY8sIN$C-\u001a4bk2$H\u0005N\u000b\u0003\u0005'SC!!\u0002\u0003P\u0005\t3m\u001c8tk6,\u0017I\u001c3WKJLg-\u001f*fG>\u0014Hm\u001d\u0013eK\u001a\fW\u000f\u001c;%k\u0005\t3m\u001c8tk6,\u0017I\u001c3WKJLg-\u001f*fG>\u0014Hm\u001d\u0013eK\u001a\fW\u000f\u001c;%mU\u0011!1\u0014\u0016\u0005\u0005{\u0012y%A\u0011d_:\u001cX/\\3B]\u00124VM]5gsJ+7m\u001c:eg\u0012\"WMZ1vYR$s'\u0006\u0002\u0003\"*\"\u0011\u0011\u0006B(\u0003\u0005\u001awN\\:v[\u0016\fe\u000e\u001a,fe&4\u0017PU3d_J$7\u000f\n3fM\u0006,H\u000e\u001e\u00139\u00039\u0019wN\\:v[\u0016\u0014VmY8sIN,bA!+\u0003F\neG\u0003\u0003BV\u0005;\u0014\tOa9\u0011\r\t5&q\u0017B^\u001b\t\u0011yK\u0003\u0003\u00032\nM\u0016aB7vi\u0006\u0014G.\u001a\u0006\u0004\u0005k[\u0018AC2pY2,7\r^5p]&!!\u0011\u0018BX\u0005-\t%O]1z\u0005V4g-\u001a:\u0011\u0011\u0005%&Q\u0018Ba\u0005/LAAa0\u0002,\nq1i\u001c8tk6,'OU3d_J$\u0007\u0003\u0002Bb\u0005\u000bd\u0001\u0001B\u0004\u0003H2\u0012\rA!3\u0003\u0003-\u000bBAa3\u0003RB\u0019!P!4\n\u0007\t=7PA\u0004O_RD\u0017N\\4\u0011\u0007i\u0014\u0019.C\u0002\u0003Vn\u00141!\u00118z!\u0011\u0011\u0019M!7\u0005\u000f\tmGF1\u0001\u0003J\n\ta\u000bC\u0004\u0002.2\u0002\rAa8\u0011\u0011\u0005%&\u0011\u000eBa\u0005/DqA!\u0011-\u0001\u0004\t)\u0001C\u0005\u0003\u000e2\u0002\n\u00111\u0001\u0002\u0006\u0005A2m\u001c8tk6,'+Z2pe\u0012\u001cH\u0005Z3gCVdG\u000fJ\u001a\u0016\r\tE%\u0011\u001eBv\t\u001d\u00119-\fb\u0001\u0005\u0013$qAa7.\u0005\u0004\u0011I-A\rde\u0016\fG/\u001a+pa&\u001c\u0017I\u001c3TK:$'+Z2pe\u0012\u001cHC\u0003By\u0005o\u0014IP!@\u0004\u0002A1!1\u0001Bz\u0003SIAA!>\u0003\u0014\t\u00191+\u001a;\t\u000f\tEb\u00061\u0001\u0003:!9!1 \u0018A\u0002\t\u0005\u0011!\u0003;pa&\u001cg*Y7f\u0011\u001d\u0011yP\fa\u0001\u0003\u000b\tQB\\;n!\u0006\u0014H/\u001b;j_:\u001c\bbBB\u0002]\u0001\u0007\u0011QA\u0001\u0014e\u0016\u001cwN\u001d3t!\u0016\u0014\b+\u0019:uSRLwN\\\u0001\u0018g\u0016tG-\u00118e\u0003^\f\u0017\u000e^!ts:\u001c7i\\7nSR,ba!\u0003\u0004\u0012\rUACBA3\u0007\u0017\u00199\u0002C\u0004\u0002.>\u0002\ra!\u0004\u0011\u0011\u0005%&\u0011NB\b\u0007'\u0001BAa1\u0004\u0012\u00119!qY\u0018C\u0002\t%\u0007\u0003\u0002Bb\u0007+!qAa70\u0005\u0004\u0011I\rC\u0005\u0004\u001a=\u0002\n\u00111\u0001\u0004\u001c\u0005QqN\u001a4tKR\u001cx\n\u001d;\u0011\u000bi\u001cib!\t\n\u0007\r}1P\u0001\u0004PaRLwN\u001c\t\t\u0005\u0007\u0019\u0019#!\u000b\u0004(%!1Q\u0005B\n\u0005\ri\u0015\r\u001d\t\u0005\u0003S\u001bI#\u0003\u0003\u0004,\u0005-&!E(gMN,G/\u00118e\u001b\u0016$\u0018\rZ1uC\u0006\t3/\u001a8e\u0003:$\u0017i^1ji\u0006\u001b\u0018P\\2D_6l\u0017\u000e\u001e\u0013eK\u001a\fW\u000f\u001c;%eU11\u0011GB\u001b\u0007o)\"aa\r+\t\rm!q\n\u0003\b\u0005\u000f\u0004$\u0019\u0001Be\t\u001d\u0011Y\u000e\rb\u0001\u0005\u0013\fA&\u00193e\u0007>t7/^7feN$vn\u0012:pkB\fe\u000eZ,bSR4uN]$s_V\u0004\u0018i]:jO:lWM\u001c;\u0015\u001d\ru2\u0011^Bw\u0007c\u001c)pa>\u0004|B9!pa\u0010\u0004D\r%\u0013bAB!w\n1A+\u001e9mKJ\u0002bA!,\u0004F\u0005-\u0018\u0002BB$\u0005_\u0013aAQ;gM\u0016\u0014\bC\u0002BW\u0007\u000b\u001aY\u0005E\u0002\u0002<&\u0013\u0001dQ8ogVlWM]!tg&<g.\\3oiB{G\u000e\\3s'\rI5\u0011\u000b\t\u0005\u0007'\u001aI&\u0004\u0002\u0004V)\u00191qK5\u0002\u000bU$\u0018\u000e\\:\n\t\rm3Q\u000b\u0002\u0013'\",H\u000fZ8x]\u0006\u0014G.\u001a+ie\u0016\fG-A\tu_BL7m\u001d+p'V\u00147o\u0019:jE\u0016\u0004bAa\u0007\u0004b\t\u0005\u0011\u0002BB2\u0005S\u0011A\u0001T5ti\u0006\u0011\u0002/\u0019:uSRLwN\\:U_\u0006\u001b8/[4o)!\u0019Ye!\u001b\u0004l\r5\u0004bBAW\u001b\u0002\u0007!q\r\u0005\b\u0007;j\u0005\u0019AB0\u0011\u001d\u0019)'\u0014a\u0001\u0005c$baa\u0013\u0004r\rM\u0004bBAW\u001d\u0002\u0007!q\r\u0005\b\u0007;r\u0005\u0019AB0)\u0019\u0019Yea\u001e\u0004z!9\u0011QV(A\u0002\t\u001d\u0004bBB3\u001f\u0002\u0007!\u0011_\u0001\u0010i\"\u0014xn\u001e8Fq\u000e,\u0007\u000f^5p]V\u00111q\u0010\t\u0006u\u000eu1\u0011\u0011\t\u0005\u00057\u0019\u0019)\u0003\u0003\u0004\u0006\n%\"!\u0003+ie><\u0018M\u00197f\u0003M!\bN]8x]\u0016C8-\u001a9uS>tw\fJ3r)\u0011\t)ga#\t\u0013\u0005\u0015\u0017+!AA\u0002\r}\u0014\u0001\u0005;ie><h.\u0012=dKB$\u0018n\u001c8!Q\r\u00116\u0011\u0013\t\u0004u\u000eM\u0015bABKw\nAao\u001c7bi&dW-\u0001\tsK\u000e,\u0017N^3e\u001b\u0016\u001c8/Y4fg\u0006!\"/Z2fSZ,G-T3tg\u0006<Wm]0%KF$B!!\u001a\u0004\u001e\"I\u0011Q\u0019+\u0002\u0002\u0003\u0007\u0011QA\u0001\u0012e\u0016\u001cW-\u001b<fI6+7o]1hKN\u0004\u0003fA+\u0004\u0012\u0006\u0019\u0002/\u0019:uSRLwN\\!tg&<g.\\3oiV\u00111q\u0015\t\u0007\u0005[\u001bI+!\u000b\n\t\tU(qV\u0001\u0015a\u0006\u0014H/\u001b;j_:\f5o]5h]6,g\u000e\u001e\u0011\u0002'M,(m]2sSB$\u0018n\u001c8DQ\u0006tw-\u001a3\u0016\u0005\rE\u0006c\u0001>\u00044&\u00191QW>\u0003\u000f\t{w\u000e\\3b]\u000692/\u001e2tGJL\u0007\u000f^5p]\u000eC\u0017M\\4fI~#S-\u001d\u000b\u0005\u0003K\u001aY\fC\u0005\u0002Ff\u000b\t\u00111\u0001\u00042\u0006!2/\u001e2tGJL\u0007\u000f^5p]\u000eC\u0017M\\4fI\u0002B3AWBI\u0003I!x\u000e]5dgN+(m]2sSB$\u0018n\u001c8\u0016\u0005\r}\u0013A\u0006;pa&\u001c7oU;cg\u000e\u0014\u0018\u000e\u001d;j_:|F%Z9\u0015\t\u0005\u00154\u0011\u001a\u0005\n\u0003\u000bd\u0016\u0011!a\u0001\u0007?\n1\u0003^8qS\u000e\u001c8+\u001e2tGJL\u0007\u000f^5p]\u0002\n\u0011C]3cC2\fgnY3MSN$XM\\3s+\t\t9+\u0001\nsK\n\fG.\u00198dK2K7\u000f^3oKJ\u0004\u0013AE2p]N,X.\u001a:BgNLwM\\7f]R$\"A!=\u0002\u0013M,(m]2sS\n,G\u0003BA3\u00077Dqa!8b\u0001\u0004\u0019y&\u0001\u000boK^$v\u000e]5dgR{7+\u001e2tGJL'-Z\u0001\u001cSN\u001cVOY:de&\u0014WMU3rk\u0016\u001cH\u000f\u0015:pG\u0016\u001c8/\u001a3\u0002!%t\u0017\u000e^5bi\u0016\u001c\u0006.\u001e;e_^tGCABY\u0003\u0019!wnV8sWR\u0011\u0011Q\r\u0005\b\u0007W\f\u0004\u0019AA\u0003\u0003MqW/\\(g\u0007>t7/^7feN$v.\u00113e\u0011\u001d\u0019y/\ra\u0001\u0007\u0007\nQbY8ogVlWM]$s_V\u0004\bbBBzc\u0001\u00071\u0011J\u0001\u0010G>t7/^7feB{G\u000e\\3sg\"91QL\u0019A\u0002\r}\u0003bBB}c\u0001\u0007!\u0011_\u0001\u000egV\u00147o\u0019:jaRLwN\\:\t\u0013\u0005%\u0013\u0007%AA\u0002\t\u0005\u0011AN1eI\u000e{gn];nKJ\u001cHk\\$s_V\u0004\u0018I\u001c3XC&$hi\u001c:He>,\b/Q:tS\u001etW.\u001a8uI\u0011,g-Y;mi\u00122TC\u0001C\u0001U\u0011\u0011\tAa\u0014\u0002'\u0005$GmQ8ogVlWM]:U_\u001e\u0013x.\u001e9\u0015\u001d\ruBq\u0001C\u0005\t\u0017!i\u0001b\u0004\u0005\u0012!911^\u001aA\u0002\u0005\u0015\u0001bBBxg\u0001\u000711\t\u0005\b\u0007g\u001c\u0004\u0019AB%\u0011\u001d\u0019if\ra\u0001\u0007?Bqa!?4\u0001\u0004\u0011\t\u0010C\u0005\u0002JM\u0002\n\u00111\u0001\u0003\u0002\u0005i\u0012\r\u001a3D_:\u001cX/\\3sgR{wI]8va\u0012\"WMZ1vYR$c'A\fwC2LG-\u0019;f\u000fJ|W\u000f]!tg&<g.\\3oiRa\u0011Q\rC\r\t7!i\u0002b\t\u0005(!911_\u001bA\u0002\r%\u0003bBB}k\u0001\u0007!\u0011\u001f\u0005\n\t?)\u0004\u0013!a\u0001\tC\t1!\\:h!\u0015Q8Q\u0004B\u0001\u0011%!)#\u000eI\u0001\u0002\u0004\tI&\u0001\u0005xC&$H+[7f\u0011%!I#\u000eI\u0001\u0002\u0004!Y#\u0001\nfqB,7\r^3e\u0003N\u001c\u0018n\u001a8nK:$\bC\u0002BW\u0007\u000b\u0012\t0A\u0011wC2LG-\u0019;f\u000fJ|W\u000f]!tg&<g.\\3oi\u0012\"WMZ1vYR$3'\u0006\u0002\u00052)\"A\u0011\u0005B(\u0003\u00052\u0018\r\\5eCR,wI]8va\u0006\u001b8/[4o[\u0016tG\u000f\n3fM\u0006,H\u000e\u001e\u00135\u0003\u00052\u0018\r\\5eCR,wI]8va\u0006\u001b8/[4o[\u0016tG\u000f\n3fM\u0006,H\u000e\u001e\u00136+\t!ID\u000b\u0003\u0005,\t=\u0013\u0001I:vEN\u001c'/\u001b2f\u0007>t7/^7fe\u0006sGm\u0015;beR\u0004v\u000e\u001c7j]\u001e$\u0002ba\u0013\u0005@\u0011\u0005C1\t\u0005\b\u0003[K\u0004\u0019\u0001B4\u0011\u001d\u0019i&\u000fa\u0001\u0007?B\u0011b!\u001a:!\u0003\u0005\rA!=\u0002UM,(m]2sS\n,7i\u001c8tk6,'/\u00118e'R\f'\u000f\u001e)pY2Lgn\u001a\u0013eK\u001a\fW\u000f\u001c;%gU\u0011A\u0011\n\u0016\u0005\u0005c\u0014y%\u0001\bbo\u0006LGOU3cC2\fgnY3\u0015\r\u0005\u0015Dq\nC1\u0011\u001d\tik\u000fa\u0001\t#\u0002d\u0001b\u0015\u0005X\u0011u\u0003\u0003CAU\u0005S\")\u0006b\u0017\u0011\t\t\rGq\u000b\u0003\r\t3\"y%!A\u0001\u0002\u000b\u0005!\u0011\u001a\u0002\u0004?\u0012\n\u0004\u0003\u0002Bb\t;\"A\u0002b\u0018\u0005P\u0005\u0005\t\u0011!B\u0001\u0005\u0013\u00141a\u0018\u00133\u0011\u001d\u0019im\u000fa\u0001\u0003s\u000b\u0011#\u001a8tkJ,gj\u001c*fE\u0006d\u0017M\\2f)\u0019\t)\u0007b\u001a\u0005z!9\u0011Q\u0016\u001fA\u0002\u0011%\u0004G\u0002C6\t_\")\b\u0005\u0005\u0002*\n%DQ\u000eC:!\u0011\u0011\u0019\rb\u001c\u0005\u0019\u0011EDqMA\u0001\u0002\u0003\u0015\tA!3\u0003\u0007}#3\u0007\u0005\u0003\u0003D\u0012UD\u0001\u0004C<\tO\n\t\u0011!A\u0003\u0002\t%'aA0%i!91Q\u001a\u001fA\u0002\u0005e&aG\"pk:$8i\u001c8tk6,'oQ8n[&$8)\u00197mE\u0006\u001c7nE\u0003>\u0003C#y\b\u0005\u0003\u0002*\u0012\u0005\u0015\u0002\u0002CB\u0003W\u0013Ac\u00144gg\u0016$8i\\7nSR\u001c\u0015\r\u001c7cC\u000e\\GC\u0001CD!\r\tY,P\u0001\rgV\u001c7-Z:t\u0007>,h\u000e^\u0001\u0011gV\u001c7-Z:t\u0007>,h\u000e^0%KF$B!!\u001a\u0005\u0010\"I\u0011Q\u0019!\u0002\u0002\u0003\u0007\u0011QA\u0001\u000egV\u001c7-Z:t\u0007>,h\u000e\u001e\u0011\u0002\u0013\u0019\f\u0017\u000e\\\"pk:$\u0018!\u00044bS2\u001cu.\u001e8u?\u0012*\u0017\u000f\u0006\u0003\u0002f\u0011e\u0005\"CAc\u0007\u0006\u0005\t\u0019AA\u0003\u0003)1\u0017-\u001b7D_VtG\u000fI\u0001\nY\u0006\u001cH/\u0012:s_J,\"\u0001\")\u0011\u000bi\u001ci\u0002b)\u0011\t\tmAQU\u0005\u0005\tO\u0013ICA\u0005Fq\u000e,\u0007\u000f^5p]\u0006iA.Y:u\u000bJ\u0014xN]0%KF$B!!\u001a\u0005.\"I\u0011Q\u0019$\u0002\u0002\u0003\u0007A\u0011U\u0001\u000bY\u0006\u001cH/\u0012:s_J\u0004\u0013AC8o\u0007>l\u0007\u000f\\3uKR1\u0011Q\rC[\t{Cq\u0001b.I\u0001\u0004!I,A\u0004pM\u001a\u001cX\r^:\u0011\u0011\u0005ED1XA\u0015\u0007OIAa!\n\u0002t!9Aq\u0018%A\u0002\u0011\r\u0016!C3yG\u0016\u0004H/[8o\u0003iI7\u000fU1si&$\u0018n\u001c8BgNLwM\\7f]R4\u0016\r\\5e)!\u0019\t\f\"2\u0005J\u0012-\u0007b\u0002CdK\u0002\u0007A1F\u0001\fCN\u001c\u0018n\u001a8nK:$8\u000fC\u0004\u0002Z\u0016\u0004\rA!=\t\u000f\u0011%R\r1\u0001\u0005,\u0001")
public abstract class AbstractConsumerTest
extends BaseRequestTest {
    private final double epsilon;
    private final String topic;
    private final int part;
    private final TopicPartition tp = new TopicPartition(this.topic(), this.part());
    private final int part2;
    private final TopicPartition tp2 = new TopicPartition(this.topic(), this.part2());
    private final String group;
    private final String producerClientId;
    private final String consumerClientId;
    private final long groupMaxSessionTimeoutMs;

    public double epsilon() {
        return this.epsilon;
    }

    @Override
    public int brokerCount() {
        return 3;
    }

    public String topic() {
        return this.topic;
    }

    public int part() {
        return this.part;
    }

    public TopicPartition tp() {
        return this.tp;
    }

    public int part2() {
        return this.part2;
    }

    public TopicPartition tp2() {
        return this.tp2;
    }

    public String group() {
        return this.group;
    }

    public String producerClientId() {
        return this.producerClientId;
    }

    public String consumerClientId() {
        return this.consumerClientId;
    }

    public long groupMaxSessionTimeoutMs() {
        return this.groupMaxSessionTimeoutMs;
    }

    @Override
    public void brokerPropertyOverrides(Properties properties) {
        properties.setProperty(KafkaConfig$.MODULE$.ControlledShutdownEnableProp(), "false");
        properties.setProperty(KafkaConfig$.MODULE$.OffsetsTopicReplicationFactorProp(), "3");
        properties.setProperty(KafkaConfig$.MODULE$.OffsetsTopicPartitionsProp(), "1");
        properties.setProperty(KafkaConfig$.MODULE$.GroupMinSessionTimeoutMsProp(), "100");
        properties.setProperty(KafkaConfig$.MODULE$.GroupMaxSessionTimeoutMsProp(), Long.toString(this.groupMaxSessionTimeoutMs()));
        properties.setProperty(KafkaConfig$.MODULE$.GroupInitialRebalanceDelayMsProp(), "10");
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        super.setUp(testInfo);
        this.createTopic(this.topic(), 2, this.brokerCount(), this.createTopic$default$4(), this.createTopic$default$5());
    }

    public KafkaConsumer<byte[], byte[]> createConsumerWithGroupId(String groupId) {
        Properties groupOverrideConfig = new Properties();
        groupOverrideConfig.setProperty("group.id", groupId);
        ByteArrayDeserializer x$2 = this.createConsumer$default$1();
        ByteArrayDeserializer x$3 = this.createConsumer$default$2();
        List<String> x$4 = this.createConsumer$default$4();
        return this.createConsumer(x$2, x$3, groupOverrideConfig, x$4);
    }

    public Seq<ProducerRecord<byte[], byte[]>> sendRecords(KafkaProducer<byte[], byte[]> producer, int numRecords, TopicPartition tp, long startingTimestamp) {
        IndexedSeq records = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numRecords).map((Function1 & Serializable & scala.Serializable)i -> AbstractConsumerTest.$anonfun$sendRecords$1(startingTimestamp, tp, producer, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
        producer.flush();
        return records;
    }

    public long sendRecords$default$4() {
        return System.currentTimeMillis();
    }

    public void consumeAndVerifyRecords(Consumer<byte[], byte[]> consumer, int numRecords, int startingOffset, int startingKeyAndValueIndex, long startingTimestamp, TimestampType timestampType, TopicPartition tp, int maxPollRecords) {
        ArrayBuffer<ConsumerRecord<byte[], byte[]>> records = this.consumeRecords(consumer, numRecords, maxPollRecords);
        long now = System.currentTimeMillis();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numRecords).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            ConsumerRecord record = (ConsumerRecord)records.apply(i);
            int offset = startingOffset + i;
            Assertions.assertEquals((Object)tp.topic(), (Object)record.topic());
            Assertions.assertEquals((int)tp.partition(), (int)record.partition());
            TimestampType timestampType = timestampType;
            TimestampType timestampType2 = TimestampType.CREATE_TIME;
            if (!(timestampType != null ? !timestampType.equals(timestampType2) : timestampType2 != null)) {
                Assertions.assertEquals((Object)timestampType, (Object)record.timestampType());
                Assertions.assertEquals((long)(startingTimestamp + (long)i), (long)record.timestamp());
            } else {
                Assertions.assertTrue((record.timestamp() >= startingTimestamp && record.timestamp() <= now ? 1 : 0) != 0, (String)new StringBuilder(60).append("Got unexpected timestamp ").append(record.timestamp()).append(". Timestamp should be between [").append(startingTimestamp).append(", ").append(now).append("}]").toString());
            }
            Assertions.assertEquals((long)offset, (long)record.offset());
            int keyAndValueIndex = startingKeyAndValueIndex + i;
            Assertions.assertEquals((Object)new StringBuilder(4).append("key ").append(keyAndValueIndex).toString(), (Object)new String((byte[])record.key()));
            Assertions.assertEquals((Object)new StringBuilder(6).append("value ").append(keyAndValueIndex).toString(), (Object)new String((byte[])record.value()));
            Assertions.assertEquals((int)new StringBuilder(4).append("key ").append(keyAndValueIndex).toString().length(), (int)record.serializedKeySize());
            Assertions.assertEquals((int)new StringBuilder(6).append("value ").append(keyAndValueIndex).toString().length(), (int)record.serializedValueSize());
        });
    }

    public int consumeAndVerifyRecords$default$4() {
        return 0;
    }

    public long consumeAndVerifyRecords$default$5() {
        return 0L;
    }

    public TimestampType consumeAndVerifyRecords$default$6() {
        return TimestampType.CREATE_TIME;
    }

    public TopicPartition consumeAndVerifyRecords$default$7() {
        return this.tp();
    }

    public int consumeAndVerifyRecords$default$8() {
        return Integer.MAX_VALUE;
    }

    public <K, V> ArrayBuffer<ConsumerRecord<K, V>> consumeRecords(Consumer<K, V> consumer, int numRecords, int maxPollRecords) {
        ArrayBuffer records = new ArrayBuffer();
        Function1 & Serializable & scala.Serializable x$2 = (Function1 & Serializable & scala.Serializable)polledRecords -> BoxesRunTime.boxToBoolean((boolean)AbstractConsumerTest.pollAction$1(polledRecords, maxPollRecords, records, numRecords));
        long x$3 = 60000L;
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long pollRecordsUntilTrue_x$3 = 0L;
        long pollRecordsUntilTrue_waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TestUtils$.$anonfun$pollRecordsUntilTrue$1(consumer, x$2)) {
            if (System.currentTimeMillis() > pollRecordsUntilTrue_waitUntilTrue_startTime + x$3) {
                Assertions.fail((String)AbstractConsumerTest.$anonfun$consumeRecords$2(numRecords, records));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(x$3), pollRecordsUntilTrue_x$3));
        }
        return records;
    }

    public <K, V> int consumeRecords$default$3() {
        return Integer.MAX_VALUE;
    }

    public scala.collection.immutable.Set<TopicPartition> createTopicAndSendRecords(KafkaProducer<byte[], byte[]> producer, String topicName, int numPartitions, int recordsPerPartition) {
        this.createTopic(topicName, numPartitions, this.brokerCount(), this.createTopic$default$4(), this.createTopic$default$5());
        ObjectRef parts = ObjectRef.create((Object)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$)));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numPartitions).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)partition -> {
            TopicPartition tp = new TopicPartition(topicName, partition);
            this.sendRecords(producer, recordsPerPartition, tp, this.sendRecords$default$4());
            parts$1.elem = (scala.collection.immutable.Set)((scala.collection.immutable.Set)parts$1.elem).$plus((Object)tp);
        });
        return (scala.collection.immutable.Set)parts.elem;
    }

    /*
     * WARNING - void declaration
     */
    public <K, V> void sendAndAwaitAsyncCommit(Consumer<K, V> consumer, Option<scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata>> offsetsOpt) {
        void pollUntilTrue_action;
        public class Kafka_api_AbstractConsumerTest$RetryCommitCallback$1
        implements OffsetCommitCallback {
            private boolean isComplete;
            private Option<Exception> error;
            private final /* synthetic */ AbstractConsumerTest $outer;
            private final Option offsetsOpt$1;
            private final Consumer consumer$1;

            public boolean isComplete() {
                return this.isComplete;
            }

            public void isComplete_$eq(boolean x$1) {
                this.isComplete = x$1;
            }

            public Option<Exception> error() {
                return this.error;
            }

            public void error_$eq(Option<Exception> x$1) {
                this.error = x$1;
            }

            public void onComplete(java.util.Map<TopicPartition, OffsetAndMetadata> offsets, Exception exception) {
                if (exception instanceof RetriableCommitFailedException) {
                    AbstractConsumerTest.kafka$api$AbstractConsumerTest$$sendAsyncCommit$1(this, this.offsetsOpt$1, this.consumer$1);
                    return;
                }
                this.isComplete_$eq(true);
                this.error_$eq((Option<Exception>)Option$.MODULE$.apply((Object)exception));
            }

            public Kafka_api_AbstractConsumerTest$RetryCommitCallback$1(AbstractConsumerTest $outer, Option offsetsOpt$1, Consumer consumer$1) {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.offsetsOpt$1 = offsetsOpt$1;
                this.consumer$1 = consumer$1;
                this.isComplete = false;
                this.error = None$.MODULE$;
            }
        }
        Kafka_api_AbstractConsumerTest$RetryCommitCallback$1 commitCallback = new Kafka_api_AbstractConsumerTest$RetryCommitCallback$1(this, offsetsOpt, consumer);
        AbstractConsumerTest.kafka$api$AbstractConsumerTest$$sendAsyncCommit$1(commitCallback, offsetsOpt, consumer);
        long l = 10000L;
        JFunction0.mcZ.sp & Serializable & scala.Serializable intersect = (JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> commitCallback.isComplete();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long pollUntilTrue_x$3 = 0L;
        long pollUntilTrue_waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TestUtils$.$anonfun$pollUntilTrue$1(consumer, (Function0)pollUntilTrue_action)) {
            void pollUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > pollUntilTrue_waitUntilTrue_startTime + pollUntilTrue_waitTimeMs) {
                Assertions.fail((String)AbstractConsumerTest.$anonfun$sendAndAwaitAsyncCommit$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)pollUntilTrue_waitTimeMs), pollUntilTrue_x$3));
        }
        Assertions.assertEquals((Object)None$.MODULE$, commitCallback.error());
    }

    public <K, V> Option<scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata>> sendAndAwaitAsyncCommit$default$2() {
        return None$.MODULE$;
    }

    public Tuple2<Buffer<KafkaConsumer<byte[], byte[]>>, Buffer<ConsumerAssignmentPoller>> addConsumersToGroupAndWaitForGroupAssignment(int numOfConsumersToAdd, Buffer<KafkaConsumer<byte[], byte[]>> consumerGroup, Buffer<ConsumerAssignmentPoller> consumerPollers, List<String> topicsToSubscribe, scala.collection.immutable.Set<TopicPartition> subscriptions, String group) {
        Assertions.assertTrue((consumerGroup.size() + numOfConsumersToAdd <= subscriptions.size() ? 1 : 0) != 0);
        this.addConsumersToGroup(numOfConsumersToAdd, consumerGroup, consumerPollers, topicsToSubscribe, subscriptions, group);
        this.validateGroupAssignment(consumerPollers, subscriptions, this.validateGroupAssignment$default$3(), this.validateGroupAssignment$default$4(), this.validateGroupAssignment$default$5());
        return new Tuple2(consumerGroup, consumerPollers);
    }

    public Tuple2<Buffer<KafkaConsumer<byte[], byte[]>>, Buffer<ConsumerAssignmentPoller>> addConsumersToGroup(int numOfConsumersToAdd, Buffer<KafkaConsumer<byte[], byte[]>> consumerGroup, Buffer<ConsumerAssignmentPoller> consumerPollers, List<String> topicsToSubscribe, scala.collection.immutable.Set<TopicPartition> subscriptions, String group) {
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numOfConsumersToAdd).foreach((Function1 & Serializable & scala.Serializable)_ -> AbstractConsumerTest.$anonfun$addConsumersToGroup$1(this, group, consumerGroup, consumerPollers, topicsToSubscribe, BoxesRunTime.unboxToInt((Object)_)));
        return new Tuple2(consumerGroup, consumerPollers);
    }

    public String addConsumersToGroupAndWaitForGroupAssignment$default$6() {
        return this.group();
    }

    public String addConsumersToGroup$default$6() {
        return this.group();
    }

    /*
     * WARNING - void declaration
     */
    public void validateGroupAssignment(Buffer<ConsumerAssignmentPoller> consumerPollers, scala.collection.immutable.Set<TopicPartition> subscriptions, Option<String> msg, long waitTime, Buffer<scala.collection.immutable.Set<TopicPartition>> expectedAssignment) {
        Buffer assignments = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!AbstractConsumerTest.$anonfun$validateGroupAssignment$1(this, assignments, consumerPollers, subscriptions, expectedAssignment)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitTime) {
                Assertions.fail((String)AbstractConsumerTest.$anonfun$validateGroupAssignment$3(msg, subscriptions, assignments));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitTime), (long)waitUntilTrue_pause));
        }
    }

    public Option<String> validateGroupAssignment$default$3() {
        return None$.MODULE$;
    }

    public long validateGroupAssignment$default$4() {
        return 10000L;
    }

    public Buffer<scala.collection.immutable.Set<TopicPartition>> validateGroupAssignment$default$5() {
        return (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
    }

    public ConsumerAssignmentPoller subscribeConsumerAndStartPolling(Consumer<byte[], byte[]> consumer, List<String> topicsToSubscribe, scala.collection.immutable.Set<TopicPartition> partitionsToAssign) {
        Assertions.assertEquals((int)0, (int)consumer.assignment().size());
        ConsumerAssignmentPoller consumerPoller = topicsToSubscribe.nonEmpty() ? new ConsumerAssignmentPoller(this, consumer, topicsToSubscribe) : new ConsumerAssignmentPoller(this, consumer, partitionsToAssign);
        consumerPoller.start();
        return consumerPoller;
    }

    public scala.collection.immutable.Set<TopicPartition> subscribeConsumerAndStartPolling$default$3() {
        return Predef$.MODULE$.Set().empty();
    }

    /*
     * WARNING - void declaration
     */
    public void awaitRebalance(Consumer<?, ?> consumer, TestConsumerReassignmentListener rebalanceListener) {
        void pollUntilTrue_action;
        int numReassignments = rebalanceListener.callsToAssigned();
        long l = TestUtils$.MODULE$.pollUntilTrue$default$4();
        JFunction0.mcZ.sp & Serializable & scala.Serializable intersect = (JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> rebalanceListener.callsToAssigned() > numReassignments;
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long pollUntilTrue_x$3 = 0L;
        long pollUntilTrue_waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TestUtils$.$anonfun$pollUntilTrue$1(consumer, (Function0)pollUntilTrue_action)) {
            void pollUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > pollUntilTrue_waitUntilTrue_startTime + pollUntilTrue_waitTimeMs) {
                Assertions.fail((String)AbstractConsumerTest.$anonfun$awaitRebalance$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)pollUntilTrue_waitTimeMs), pollUntilTrue_x$3));
        }
    }

    public void ensureNoRebalance(Consumer<?, ?> consumer, TestConsumerReassignmentListener rebalanceListener) {
        int initialRevokeCalls = rebalanceListener.callsToRevoked();
        this.sendAndAwaitAsyncCommit(consumer, this.sendAndAwaitAsyncCommit$default$2());
        Assertions.assertEquals((int)initialRevokeCalls, (int)rebalanceListener.callsToRevoked());
    }

    public boolean isPartitionAssignmentValid(Buffer<scala.collection.immutable.Set<TopicPartition>> assignments, scala.collection.immutable.Set<TopicPartition> partitions, Buffer<scala.collection.immutable.Set<TopicPartition>> expectedAssignment) {
        Object object = new Object();
        try {
            if (!assignments.forall((Function1 & Serializable & scala.Serializable)assignment -> BoxesRunTime.boxToBoolean((boolean)assignment.nonEmpty()))) {
                return false;
            }
            if (BoxesRunTime.unboxToInt((Object)assignments.foldLeft((Object)BoxesRunTime.boxToInteger((int)0), (Function2 & Serializable & scala.Serializable)(x$2, x$3) -> BoxesRunTime.boxToInteger((int)AbstractConsumerTest.$anonfun$isPartitionAssignmentValid$2(BoxesRunTime.unboxToInt((Object)x$2), x$3)))) != partitions.size()) {
                return false;
            }
            scala.collection.immutable.Set set = (scala.collection.immutable.Set)assignments.foldLeft((Object)Predef$.MODULE$.Set().empty(), (Function2 & Serializable & scala.Serializable)(x$4, x$5) -> (scala.collection.immutable.Set)x$4.$plus$plus((GenTraversableOnce)x$5));
            if (set == null || !set.equals(partitions)) {
                return false;
            }
            if (expectedAssignment.nonEmpty()) {
                assignments.foreach((Function1 & Serializable & scala.Serializable)assignment -> {
                    AbstractConsumerTest.$anonfun$isPartitionAssignmentValid$4(expectedAssignment, object, assignment);
                    return BoxedUnit.UNIT;
                });
            }
            return true;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                return ex.value$mcZ$sp();
            }
            throw ex;
        }
    }

    public static final /* synthetic */ ProducerRecord $anonfun$sendRecords$1(long startingTimestamp$1, TopicPartition tp$1, KafkaProducer producer$1, int i) {
        long timestamp = startingTimestamp$1 + (long)i;
        ProducerRecord record = new ProducerRecord(tp$1.topic(), Predef$.MODULE$.int2Integer(tp$1.partition()), Predef$.MODULE$.long2Long(timestamp), (Object)new StringBuilder(4).append("key ").append(i).toString().getBytes(), (Object)new StringBuilder(6).append("value ").append(i).toString().getBytes());
        producer$1.send(record);
        return record;
    }

    private static final boolean pollAction$1(ConsumerRecords polledRecords, int maxPollRecords$1, ArrayBuffer records$2, int numRecords$1) {
        Assertions.assertTrue((((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter((Iterable)polledRecords).asScala()).size() <= maxPollRecords$1 ? 1 : 0) != 0);
        records$2.$plus$plus$eq((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter((Iterable)polledRecords).asScala());
        return records$2.size() >= numRecords$1;
    }

    public static final /* synthetic */ String $anonfun$consumeRecords$2(int numRecords$1, ArrayBuffer records$2) {
        return new StringBuilder(71).append("Timed out before consuming expected ").append(numRecords$1).append(" records. ").append("The number consumed was ").append(records$2.size()).append(".").toString();
    }

    public static final void kafka$api$AbstractConsumerTest$$sendAsyncCommit$1(OffsetCommitCallback callback, Option offsetsOpt$1, Consumer consumer$1) {
        if (offsetsOpt$1 instanceof Some) {
            scala.collection.immutable.Map offsets = (scala.collection.immutable.Map)((Some)offsetsOpt$1).value();
            consumer$1.commitAsync((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)offsets).asJava(), callback);
            return;
        }
        if (None$.MODULE$.equals(offsetsOpt$1)) {
            consumer$1.commitAsync(callback);
            return;
        }
        throw new MatchError((Object)offsetsOpt$1);
    }

    public static final /* synthetic */ String $anonfun$sendAndAwaitAsyncCommit$2() {
        return "Failed to observe commit callback before timeout";
    }

    public static final /* synthetic */ Buffer $anonfun$addConsumersToGroup$1(AbstractConsumerTest $this, String group$1, Buffer consumerGroup$1, Buffer consumerPollers$1, List topicsToSubscribe$1, int _) {
        KafkaConsumer<byte[], byte[]> consumer = $this.createConsumerWithGroupId(group$1);
        consumerGroup$1.$plus$eq(consumer);
        return consumerPollers$1.$plus$eq((Object)$this.subscribeConsumerAndStartPolling((Consumer<byte[], byte[]>)consumer, (List<String>)topicsToSubscribe$1, $this.subscribeConsumerAndStartPolling$default$3()));
    }

    public static final /* synthetic */ boolean $anonfun$validateGroupAssignment$1(AbstractConsumerTest $this, Buffer assignments$1, Buffer consumerPollers$2, scala.collection.immutable.Set subscriptions$1, Buffer expectedAssignment$1) {
        assignments$1.clear();
        consumerPollers$2.foreach((Function1 & Serializable & scala.Serializable)x$1 -> assignments$1.$plus$eq(x$1.consumerAssignment()));
        return $this.isPartitionAssignmentValid((Buffer<scala.collection.immutable.Set<TopicPartition>>)assignments$1, (scala.collection.immutable.Set<TopicPartition>)subscriptions$1, (Buffer<scala.collection.immutable.Set<TopicPartition>>)expectedAssignment$1);
    }

    public static final /* synthetic */ String $anonfun$validateGroupAssignment$3(Option msg$1, scala.collection.immutable.Set subscriptions$1, Buffer assignments$1) {
        return (String)msg$1.getOrElse((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(59).append("Did not get valid assignment for partitions ").append(subscriptions$1).append(". Instead, got ").append(assignments$1).toString());
    }

    public static final /* synthetic */ String $anonfun$awaitRebalance$2() {
        return "Timed out before expected rebalance completed";
    }

    public static final /* synthetic */ int $anonfun$isPartitionAssignmentValid$2(int x$2, scala.collection.immutable.Set x$3) {
        return x$2 + x$3.size();
    }

    public static final /* synthetic */ void $anonfun$isPartitionAssignmentValid$4(Buffer expectedAssignment$2, Object nonLocalReturnKey1$1, scala.collection.immutable.Set assignment) {
        if (!expectedAssignment$2.contains((Object)assignment)) {
            throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey1$1, false);
        }
    }

    public AbstractConsumerTest() {
        this.epsilon = 0.1;
        this.topic = "topic";
        this.part = 0;
        this.part2 = 1;
        this.group = "my-test";
        this.producerClientId = "ConsumerTestProducer";
        this.consumerClientId = "ConsumerTestConsumer";
        this.groupMaxSessionTimeoutMs = 60000L;
        this.producerConfig().setProperty("acks", "all");
        this.producerConfig().setProperty("client.id", this.producerClientId());
        this.consumerConfig().setProperty("client.id", this.consumerClientId());
        this.consumerConfig().setProperty("group.id", this.group());
        this.consumerConfig().setProperty("auto.offset.reset", "earliest");
        this.consumerConfig().setProperty("enable.auto.commit", "false");
        this.consumerConfig().setProperty("metadata.max.age.ms", "100");
        this.consumerConfig().setProperty("max.poll.interval.ms", "6000");
    }

    public class ConsumerAssignmentPoller
    extends ShutdownableThread {
        private final Consumer<byte[], byte[]> consumer;
        private final scala.collection.immutable.Set<TopicPartition> partitionsToAssign;
        private volatile Option<Throwable> thrownException;
        private volatile int receivedMessages;
        private final Set<TopicPartition> kafka$api$AbstractConsumerTest$ConsumerAssignmentPoller$$partitionAssignment;
        private volatile boolean subscriptionChanged;
        private List<String> topicsSubscription;
        private final ConsumerRebalanceListener rebalanceListener;
        public final /* synthetic */ AbstractConsumerTest $outer;

        public Option<Throwable> thrownException() {
            return this.thrownException;
        }

        public void thrownException_$eq(Option<Throwable> x$1) {
            this.thrownException = x$1;
        }

        public int receivedMessages() {
            return this.receivedMessages;
        }

        public void receivedMessages_$eq(int x$1) {
            this.receivedMessages = x$1;
        }

        public Set<TopicPartition> kafka$api$AbstractConsumerTest$ConsumerAssignmentPoller$$partitionAssignment() {
            return this.kafka$api$AbstractConsumerTest$ConsumerAssignmentPoller$$partitionAssignment;
        }

        private boolean subscriptionChanged() {
            return this.subscriptionChanged;
        }

        private void subscriptionChanged_$eq(boolean x$1) {
            this.subscriptionChanged = x$1;
        }

        private List<String> topicsSubscription() {
            return this.topicsSubscription;
        }

        private void topicsSubscription_$eq(List<String> x$1) {
            this.topicsSubscription = x$1;
        }

        public ConsumerRebalanceListener rebalanceListener() {
            return this.rebalanceListener;
        }

        public scala.collection.immutable.Set<TopicPartition> consumerAssignment() {
            return this.kafka$api$AbstractConsumerTest$ConsumerAssignmentPoller$$partitionAssignment().toSet();
        }

        public void subscribe(List<String> newTopicsToSubscribe) {
            if (this.subscriptionChanged()) {
                throw new IllegalStateException("Do not call subscribe until the previous subscribe request is processed.");
            }
            if (this.partitionsToAssign.nonEmpty()) {
                throw new IllegalStateException("Cannot call subscribe when configured to use manual partition assignment");
            }
            this.topicsSubscription_$eq(newTopicsToSubscribe);
            this.subscriptionChanged_$eq(true);
        }

        public boolean isSubscribeRequestProcessed() {
            return !this.subscriptionChanged();
        }

        /*
         * WARNING - void declaration
         */
        public boolean initiateShutdown() {
            void var1_1;
            boolean res = super.initiateShutdown();
            this.consumer.wakeup();
            return (boolean)var1_1;
        }

        public void doWork() {
            if (this.subscriptionChanged()) {
                this.consumer.subscribe((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter(this.topicsSubscription()).asJava(), this.rebalanceListener());
                this.subscriptionChanged_$eq(false);
            }
            try {
                this.receivedMessages_$eq(this.receivedMessages() + this.consumer.poll(Duration.ofMillis(50L)).count());
                return;
            }
            catch (WakeupException wakeupException) {
                return;
            }
            catch (Throwable e) {
                this.thrownException_$eq((Option<Throwable>)new Some((Object)e));
                throw e;
            }
        }

        public /* synthetic */ AbstractConsumerTest kafka$api$AbstractConsumerTest$ConsumerAssignmentPoller$$$outer() {
            return this.$outer;
        }

        public ConsumerAssignmentPoller(AbstractConsumerTest $outer, Consumer<byte[], byte[]> consumer, List<String> topicsToSubscribe, scala.collection.immutable.Set<TopicPartition> partitionsToAssign) {
            this.consumer = consumer;
            this.partitionsToAssign = partitionsToAssign;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            super("daemon-consumer-assignment", false);
            this.thrownException = None$.MODULE$;
            this.receivedMessages = 0;
            this.kafka$api$AbstractConsumerTest$ConsumerAssignmentPoller$$partitionAssignment = (Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
            this.subscriptionChanged = false;
            this.topicsSubscription = topicsToSubscribe;
            this.rebalanceListener = new ConsumerRebalanceListener(this){
                private final /* synthetic */ ConsumerAssignmentPoller $outer;

                public void onPartitionsLost(Collection<TopicPartition> x$1) {
                    super.onPartitionsLost(x$1);
                }

                public void onPartitionsAssigned(Collection<TopicPartition> partitions) {
                    this.$outer.kafka$api$AbstractConsumerTest$ConsumerAssignmentPoller$$partitionAssignment().$plus$plus$eq((TraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps(partitions.toArray((Object[])new TopicPartition[0]))));
                }

                public void onPartitionsRevoked(Collection<TopicPartition> partitions) {
                    this.$outer.kafka$api$AbstractConsumerTest$ConsumerAssignmentPoller$$partitionAssignment().$minus$minus$eq((TraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps(partitions.toArray((Object[])new TopicPartition[0]))));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            };
            if (partitionsToAssign.isEmpty()) {
                consumer.subscribe((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter(topicsToSubscribe).asJava(), this.rebalanceListener());
                return;
            }
            consumer.assign((Collection)CollectionConverters$.MODULE$.setAsJavaSetConverter(partitionsToAssign).asJava());
        }

        public ConsumerAssignmentPoller(AbstractConsumerTest $outer, Consumer<byte[], byte[]> consumer, List<String> topicsToSubscribe) {
            this($outer, consumer, topicsToSubscribe, (scala.collection.immutable.Set<TopicPartition>)Predef$.MODULE$.Set().empty());
        }

        public ConsumerAssignmentPoller(AbstractConsumerTest $outer, Consumer<byte[], byte[]> consumer, scala.collection.immutable.Set<TopicPartition> partitionsToAssign) {
            this($outer, consumer, (List<String>)List$.MODULE$.empty(), partitionsToAssign);
        }
    }

    public class CountConsumerCommitCallback
    implements OffsetCommitCallback {
        private int successCount;
        private int failCount;
        private Option<Exception> lastError;

        public int successCount() {
            return this.successCount;
        }

        public void successCount_$eq(int x$1) {
            this.successCount = x$1;
        }

        public int failCount() {
            return this.failCount;
        }

        public void failCount_$eq(int x$1) {
            this.failCount = x$1;
        }

        public Option<Exception> lastError() {
            return this.lastError;
        }

        public void lastError_$eq(Option<Exception> x$1) {
            this.lastError = x$1;
        }

        public void onComplete(java.util.Map<TopicPartition, OffsetAndMetadata> offsets, Exception exception) {
            if (exception == null) {
                this.successCount_$eq(this.successCount() + 1);
                return;
            }
            this.failCount_$eq(this.failCount() + 1);
            this.lastError_$eq((Option<Exception>)new Some((Object)exception));
        }

        public /* synthetic */ AbstractConsumerTest kafka$api$AbstractConsumerTest$CountConsumerCommitCallback$$$outer() {
            return AbstractConsumerTest.this;
        }

        public CountConsumerCommitCallback() {
            if (AbstractConsumerTest.this == null) {
                throw null;
            }
            this.successCount = 0;
            this.failCount = 0;
            this.lastError = None$.MODULE$;
        }
    }

    public class TestConsumerReassignmentListener
    implements ConsumerRebalanceListener {
        private int callsToAssigned;
        private int callsToRevoked;

        public void onPartitionsLost(Collection<TopicPartition> x$1) {
            super.onPartitionsLost(x$1);
        }

        public int callsToAssigned() {
            return this.callsToAssigned;
        }

        public void callsToAssigned_$eq(int x$1) {
            this.callsToAssigned = x$1;
        }

        public int callsToRevoked() {
            return this.callsToRevoked;
        }

        public void callsToRevoked_$eq(int x$1) {
            this.callsToRevoked = x$1;
        }

        public void onPartitionsAssigned(Collection<TopicPartition> partitions) {
            this.kafka$api$AbstractConsumerTest$TestConsumerReassignmentListener$$$outer().info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "onPartitionsAssigned called.");
            this.callsToAssigned_$eq(this.callsToAssigned() + 1);
        }

        public void onPartitionsRevoked(Collection<TopicPartition> partitions) {
            this.kafka$api$AbstractConsumerTest$TestConsumerReassignmentListener$$$outer().info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "onPartitionsRevoked called.");
            this.callsToRevoked_$eq(this.callsToRevoked() + 1);
        }

        public /* synthetic */ AbstractConsumerTest kafka$api$AbstractConsumerTest$TestConsumerReassignmentListener$$$outer() {
            return AbstractConsumerTest.this;
        }

        public TestConsumerReassignmentListener() {
            if (AbstractConsumerTest.this == null) {
                throw null;
            }
            this.callsToAssigned = 0;
            this.callsToRevoked = 0;
        }
    }
}

