/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.Timer;
import java.io.File;
import java.io.Serializable;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import kafka.api.ApiVersion;
import kafka.api.KAFKA_2_6_IV0$;
import kafka.api.KAFKA_2_7_IV0$;
import kafka.api.LeaderAndIsr;
import kafka.api.LeaderAndIsr$;
import kafka.controller.AlterIsrReceived;
import kafka.controller.ApiPartitionReassignment;
import kafka.controller.ControlledShutdown;
import kafka.controller.ControllerEvent;
import kafka.controller.ControllerEventManager;
import kafka.controller.ControllerState;
import kafka.controller.ElectionTrigger;
import kafka.controller.KafkaController;
import kafka.controller.KafkaController$;
import kafka.controller.LeaderIsrAndControllerEpoch;
import kafka.controller.ListPartitionReassignments;
import kafka.controller.MockEvent;
import kafka.controller.ReplicaAssignment;
import kafka.controller.ReplicaAssignment$;
import kafka.controller.ReplicaLeaderElection;
import kafka.controller.ZkTriggered$;
import kafka.log.LogManager;
import kafka.log.UnifiedLog;
import kafka.metrics.KafkaYammerMetrics;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.server.QuorumTestHarness;
import kafka.utils.LogCaptureAppender;
import kafka.utils.LogCaptureAppender$;
import kafka.utils.ShutdownableThread;
import kafka.utils.TestUtils$;
import kafka.utils.TestUtils$Checkpoint$;
import kafka.zk.AdminZkClient;
import kafka.zk.FeatureZNode;
import kafka.zk.FeatureZNode$;
import kafka.zk.FeatureZNodeStatus;
import kafka.zk.PreferredReplicaElectionZNode$;
import org.apache.kafka.common.ElectionType;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.ControllerMovedException;
import org.apache.kafka.common.errors.StaleBrokerEpochException;
import org.apache.kafka.common.feature.Features;
import org.apache.kafka.common.message.UpdateMetadataRequestData;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.log4j.Level;
import org.apache.log4j.spi.LoggingEvent;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.mockito.Mockito;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenSeqLike;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichLong$;
import scala.runtime.VolatileBooleanRef;
import scala.runtime.java8.JFunction1;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Left;
import scala.util.Right;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0001\r}d\u0001B(Q\u0001UCQ\u0001\u0018\u0001\u0005\u0002uCq\u0001\u0019\u0001A\u0002\u0013\u0005\u0011\rC\u0004n\u0001\u0001\u0007I\u0011\u00018\t\rU\u0004\u0001\u0015)\u0003c\u0011\u001d1\bA1A\u0005\u0002]Daa\u001f\u0001!\u0002\u0013A\bb\u0002?\u0001\u0005\u0004%\ta\u001e\u0005\u0007{\u0002\u0001\u000b\u0011\u0002=\t\u000by\u0004A\u0011I@\t\u000f\u0005\u0015\u0002\u0001\"\u0011\u0002(!9\u0011\u0011\u0007\u0001\u0005\u0002\u0005\u001d\u0002bBA\u001e\u0001\u0011\u0005\u0011q\u0005\u0005\b\u0003\u007f\u0001A\u0011AA\u0014\u0011\u001d\t\u0019\u0005\u0001C\u0001\u0003OAq!a\u0012\u0001\t\u0003\t9\u0003C\u0004\u0002L\u0001!\t!a\n\t\u000f\u0005=\u0003\u0001\"\u0001\u0002(!9\u00111\u000b\u0001\u0005\u0002\u0005\u001d\u0002bBA,\u0001\u0011\u0005\u0011q\u0005\u0005\b\u00037\u0002A\u0011AA\u0014\u0011\u001d\ty\u0006\u0001C\u0001\u0003OAq!a\u0019\u0001\t\u0003\t9\u0003C\u0004\u0002h\u0001!\t!a\n\t\u000f\u0005-\u0004\u0001\"\u0001\u0002(!9\u0011q\u000e\u0001\u0005\u0002\u0005\u001d\u0002bBA:\u0001\u0011\u0005\u0011q\u0005\u0005\b\u0003o\u0002A\u0011AA\u0014\u0011\u001d\tY\b\u0001C\u0001\u0003OAq!a \u0001\t\u0003\t9\u0003C\u0004\u0002\u0004\u0002!\t!a\n\t\u000f\u0005\u001d\u0005\u0001\"\u0001\u0002(!9\u00111\u0012\u0001\u0005\u0002\u0005\u001d\u0002bBAH\u0001\u0011\u0005\u0011q\u0005\u0005\b\u0003'\u0003A\u0011AA\u0014\u0011\u001d\t9\n\u0001C\u0001\u0003OAq!a'\u0001\t\u0003\t9\u0003C\u0004\u0002 \u0002!\t!a\n\t\u000f\u0005\r\u0006\u0001\"\u0001\u0002(!9\u0011q\u0015\u0001\u0005\u0002\u0005\u001d\u0002bBAV\u0001\u0011\u0005\u0011q\u0005\u0005\b\u0003_\u0003A\u0011AA\u0014\u0011\u001d\t\u0019\f\u0001C\u0001\u0003OAq!a.\u0001\t\u0003\t9\u0003C\u0004\u0002<\u0002!\t!a\n\t\u000f\u0005}\u0006\u0001\"\u0001\u0002(!9\u00111\u0019\u0001\u0005\u0002\u0005\u001d\u0002bBAd\u0001\u0011%\u0011\u0011\u001a\u0005\b\u0003_\u0004A\u0011AA\u0014\u0011\u001d\t\u0019\u0010\u0001C\u0001\u0003OAq!a>\u0001\t\u0003\tI\u0010C\u0004\u0003L\u0001!\tA!\u0014\t\u000f\te\u0003\u0001\"\u0001\u0002(!9!Q\f\u0001\u0005\u0002\u0005\u001d\u0002b\u0002B1\u0001\u0011\u0005\u0011q\u0005\u0005\b\u0005K\u0002A\u0011AA\u0014\u0011\u001d\u0011I\u0007\u0001C\u0001\u0003OAqA!\u001c\u0001\t\u0003\t9\u0003C\u0004\u0003r\u0001!\t!a\n\t\u000f\tU\u0004\u0001\"\u0001\u0002(!9!\u0011\u0010\u0001\u0005\u0002\u0005\u001d\u0002b\u0002B?\u0001\u0011\u0005\u0011q\u0005\u0005\b\u0005\u0003\u0003A\u0011\u0002BB\u0011\u001d\u0011y\t\u0001C\u0005\u0005#CqAa/\u0001\t\u0013\u0011i\fC\u0004\u0003N\u0002!IAa4\t\u000f\t}\u0007\u0001\"\u0003\u0003b\"9!\u0011 \u0001\u0005\n\tm\b\"CB\u0014\u0001E\u0005I\u0011BB\u0015\u0011%\u0019y\u0004AI\u0001\n\u0013\u0019I\u0003C\u0005\u0004B\u0001\t\n\u0011\"\u0003\u0004*!I11\t\u0001\u0012\u0002\u0013%1Q\t\u0005\n\u0007\u0013\u0002\u0011\u0013!C\u0005\u0007\u000bB\u0011ba\u0013\u0001#\u0003%Ia!\u0012\t\u0013\r5\u0003!%A\u0005\n\r=\u0003\"CB*\u0001E\u0005I\u0011BB+\u0011%\u0019I\u0006AI\u0001\n\u0013\u0019)\u0006C\u0004\u0004\\\u0001!Ia!\u0018\t\u000f\rm\u0004\u0001\"\u0003\u0004~\tI2i\u001c8ue>dG.\u001a:J]R,wM]1uS>tG+Z:u\u0015\t\t&+\u0001\u0006d_:$(o\u001c7mKJT\u0011aU\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001a\u000b\u0005\u0002X56\t\u0001L\u0003\u0002Z%\u000611/\u001a:wKJL!a\u0017-\u0003#E+xN];n)\u0016\u001cH\u000fS1s]\u0016\u001c8/\u0001\u0004=S:LGO\u0010\u000b\u0002=B\u0011q\fA\u0007\u0002!\u000691/\u001a:wKJ\u001cX#\u00012\u0011\u0007\rD'.D\u0001e\u0015\t)g-\u0001\u0006d_2dWm\u0019;j_:T\u0011aZ\u0001\u0006g\u000e\fG.Y\u0005\u0003S\u0012\u00141aU3r!\t96.\u0003\u0002m1\nY1*\u00194lCN+'O^3s\u0003-\u0019XM\u001d<feN|F%Z9\u0015\u0005=\u001c\bC\u00019r\u001b\u00051\u0017B\u0001:g\u0005\u0011)f.\u001b;\t\u000fQ\u001c\u0011\u0011!a\u0001E\u0006\u0019\u0001\u0010J\u0019\u0002\u0011M,'O^3sg\u0002\nACZ5sgR\u001cuN\u001c;s_2dWM]#q_\u000eDW#\u0001=\u0011\u0005AL\u0018B\u0001>g\u0005\rIe\u000e^\u0001\u0016M&\u00148\u000f^\"p]R\u0014x\u000e\u001c7fe\u0016\u0003xn\u00195!\u0003u1\u0017N]:u\u0007>tGO]8mY\u0016\u0014X\t]8dQj[g+\u001a:tS>t\u0017A\b4jeN$8i\u001c8ue>dG.\u001a:Fa>\u001c\u0007NW6WKJ\u001c\u0018n\u001c8!\u0003\u0015\u0019X\r^+q)\ry\u0017\u0011\u0001\u0005\b\u0003\u0007I\u0001\u0019AA\u0003\u0003!!Xm\u001d;J]\u001a|\u0007\u0003BA\u0004\u00033i!!!\u0003\u000b\t\u0005-\u0011QB\u0001\u0004CBL'\u0002BA\b\u0003#\tqA[;qSR,'O\u0003\u0003\u0002\u0014\u0005U\u0011!\u00026v]&$(BAA\f\u0003\ry'oZ\u0005\u0005\u00037\tIA\u0001\u0005UKN$\u0018J\u001c4pQ\rI\u0011q\u0004\t\u0005\u0003\u000f\t\t#\u0003\u0003\u0002$\u0005%!A\u0003\"fM>\u0014X-R1dQ\u0006AA/Z1s\t><h\u000eF\u0001pQ\rQ\u00111\u0006\t\u0005\u0003\u000f\ti#\u0003\u0003\u00020\u0005%!!C!gi\u0016\u0014X)Y2i\u0003A!Xm\u001d;F[B$\u0018p\u00117vgR,'\u000fK\u0002\f\u0003k\u0001B!a\u0002\u00028%!\u0011\u0011HA\u0005\u0005\u0011!Vm\u001d;\u0002[Q,7\u000f^\"p]R\u0014x\u000e\u001c7fe\u0016\u0003xn\u00195QKJ\u001c\u0018n\u001d;t/\",g.\u00117m\u0005J|7.\u001a:t\t><h\u000eK\u0002\r\u0003k\t1\u0006^3ti\u000e{g\u000e\u001e:pY2,'/T8wK&s7M]3nK:$8oQ8oiJ|G\u000e\\3s\u000bB|7\r\u001b\u0015\u0004\u001b\u0005U\u0012!\n;fgRlU\r^1eCR\f\u0007K]8qC\u001e\fG/[8o\u001f:\u001cuN\u001c;s_2\u0004F.\u00198fQ\rq\u0011QG\u0001&i\u0016\u001cH/T3uC\u0012\fG/\u0019)s_B\fw-\u0019;j_:|eN\u0011:pW\u0016\u00148\t[1oO\u0016D3aDA\u001b\u0003%\"Xm\u001d;NKR\fG-\u0019;b!J|\u0007/Y4bi&|gNR8s\u001f\u001a4G.\u001b8f%\u0016\u0004H.[2bg\"\u001a\u0001#!\u000e\u0002kQ,7\u000f^'fi\u0006$\u0017\r^1Qe>\u0004\u0018mZ1uS>twJ\u001c\"s_.,'o\u00155vi\u0012|wO\\,ji\"tuNU3qY&\u001c\u0017m\u001d\u0015\u0004#\u0005U\u0012!\u0005;fgR$v\u000e]5d\u0007J,\u0017\r^5p]\"\u001a!#!\u000e\u0002GQ,7\u000f\u001e+pa&\u001c7I]3bi&|gnV5uQ>3g\r\\5oKJ+\u0007\u000f\\5dC\"\u001a1#!\u000e\u00027Q,7\u000f\u001e+pa&\u001c\u0007+\u0019:uSRLwN\\#ya\u0006t7/[8oQ\r!\u0012QG\u0001.i\u0016\u001cH\u000fV8qS\u000e\u0004\u0016M\u001d;ji&|g.\u0012=qC:\u001c\u0018n\u001c8XSRDwJ\u001a4mS:,'+\u001a9mS\u000e\f\u0007fA\u000b\u00026\u0005IB/Z:u!\u0006\u0014H/\u001b;j_:\u0014V-Y:tS\u001etW.\u001a8uQ\r1\u0012QG\u00013i\u0016\u001cH\u000fU1si&$\u0018n\u001c8SK\u0006\u001c8/[4o[\u0016tG\u000fV8Ce>\\WM],ji\"|eM\u001a7j]\u0016dun\u001a#je\"\u001aq#!\u000e\u0002uQ,7\u000f\u001e)beRLG/[8o%\u0016\f7o]5h]6,g\u000e^,ji\"|eM\u001a7j]\u0016\u0014V\r\u001d7jG\u0006D\u0015\r\u001c;j]\u001e\u0004&o\\4sKN\u001c\bf\u0001\r\u00026\u00059D/Z:u!\u0006\u0014H/\u001b;j_:\u0014V-Y:tS\u001etW.\u001a8u%\u0016\u001cX/\\3t\u0003\u001a$XM\u001d*fa2L7-Y\"p[\u0016\u001cxJ\u001c7j]\u0016D3!GA\u001b\u0003\t\"Xm\u001d;Qe\u00164WM\u001d:fIJ+\u0007\u000f\\5dC2+\u0017\rZ3s\u000b2,7\r^5p]\"\u001a!$!\u000e\u0002[Q,7\u000f\u001e\"bG.$vNQ1dWB\u0013XMZ3se\u0016$'+\u001a9mS\u000e\fG*Z1eKJ,E.Z2uS>t7\u000fK\u0002\u001c\u0003k\tQ\b^3tiB\u0013XMZ3se\u0016$'+\u001a9mS\u000e\fG*Z1eKJ,E.Z2uS>tw+\u001b;i\u001f\u001a4G.\u001b8f!J,g-\u001a:sK\u0012\u0014V\r\u001d7jG\u0006D3\u0001HA\u001b\u0003\u0019\"Xm\u001d;BkR|\u0007K]3gKJ\u0014X\r\u001a*fa2L7-\u0019'fC\u0012,'/\u00127fGRLwN\u001c\u0015\u0004;\u0005U\u0012\u0001\u0012;fgRdU-\u00193fe\u0006sG-S:s/\",g.\u00128uSJ,\u0017j\u001d:PM\u001ad\u0017N\\3B]\u0012,fn\u00197fC:dU-\u00193fe\u0016cWm\u0019;j_:$\u0015n]1cY\u0016$\u0007f\u0001\u0010\u00026\u0005\u0019E/Z:u\u0019\u0016\fG-\u001a:B]\u0012L5O],iK:,e\u000e^5sK&\u001b(o\u00144gY&tW-\u00118e+:\u001cG.Z1o\u0019\u0016\fG-\u001a:FY\u0016\u001cG/[8o\u000b:\f'\r\\3eQ\ry\u0012QG\u0001\u0017i\u0016\u001cHoQ8oiJ|G\u000e\\3e'\",H\u000fZ8x]\"\u001a\u0001%!\u000e\u0002\u0003R,7\u000f^\"p]R\u0014x\u000e\u001c7feJ+'.Z2u\u0007>tGO]8mY\u0016$7\u000b[;uI><hNU3rk\u0016\u001cHoV5uQN#\u0018\r\\3Ce>\\WM]#q_\u000eD\u0007fA\u0011\u00026\u0005\tC/Z:u\u0007>tGO]8mY\u0016\u0014Xj\u001c<f\u001f:$v\u000e]5d\u0007J,\u0017\r^5p]\"\u001a!%!\u000e\u0002CQ,7\u000f^\"p]R\u0014x\u000e\u001c7fe6{g/Z(o)>\u0004\u0018n\u0019#fY\u0016$\u0018n\u001c8)\u0007\r\n)$\u0001\u0017uKN$8i\u001c8ue>dG.\u001a:N_Z,wJ\u001c)sK\u001a,'O]3e%\u0016\u0004H.[2b\u000b2,7\r^5p]\"\u001aA%!\u000e\u0002SQ,7\u000f^\"p]R\u0014x\u000e\u001c7fe6{g/Z(o!\u0006\u0014H/\u001b;j_:\u0014V-Y:tS\u001etW.\u001a8uQ\r)\u0013QG\u0001Yi\u0016\u001cHoQ8oiJ|G\u000e\\3s\r\u0016\fG/\u001e:f5:{G-Z*fiV\u0004x\u000b[3o\r\u0016\fG/\u001e:f-\u0016\u00148/[8oS:<\u0017j]#oC\ndW\rZ,ji\"tuN\\#ySN$\u0018N\\4GK\u0006$XO]3[\u001d>$W\rK\u0002'\u0003k\tQ\f^3ti\u000e{g\u000e\u001e:pY2,'OR3biV\u0014XM\u0017(pI\u0016\u001cV\r^;q/\",gNR3biV\u0014XMV3sg&|g.\u001b8h\u0013N,e.\u00192mK\u0012<\u0016\u000e\u001e5ESN\f'\r\\3e\u000bbL7\u000f^5oO\u001a+\u0017\r^;sKjsu\u000eZ3)\u0007\u001d\n)$\u0001/uKN$8i\u001c8ue>dG.\u001a:GK\u0006$XO]3[\u001d>$WmU3ukB<\u0006.\u001a8GK\u0006$XO]3WKJ\u001c\u0018n\u001c8j]\u001eL5/\u00128bE2,GmV5uQ\u0016s\u0017M\u00197fI\u0016C\u0018n\u001d;j]\u001e4U-\u0019;ve\u0016Tfj\u001c3fQ\rA\u0013QG\u0001Zi\u0016\u001cHoQ8oiJ|G\u000e\\3s\r\u0016\fG/\u001e:f5:{G-Z*fiV\u0004x\u000b[3o\r\u0016\fG/\u001e:f-\u0016\u00148/[8oS:<\u0017j\u001d#jg\u0006\u0014G.\u001a3XSRDgj\u001c8Fq&\u001cH/\u001b8h\r\u0016\fG/\u001e:f5:{G-\u001a\u0015\u0004S\u0005U\u0012A\u0018;fgR\u001cuN\u001c;s_2dWM\u001d$fCR,(/\u001a.O_\u0012,7+\u001a;va^CWM\u001c$fCR,(/\u001a,feNLwN\\5oO&\u001bH)[:bE2,GmV5uQ\u0012K7/\u00192mK\u0012,\u00050[:uS:<g)Z1ukJ,'LT8eK\"\u001a!&!\u000e\u0002;R,7\u000f^\"p]R\u0014x\u000e\u001c7fe\u001a+\u0017\r^;sKjsu\u000eZ3TKR,\bo\u00165f]\u001a+\u0017\r^;sKZ+'o]5p]&tw-S:ESN\f'\r\\3e/&$\b.\u00128bE2,G-\u0012=jgRLgn\u001a$fCR,(/\u001a.O_\u0012,\u0007fA\u0016\u00026\u0005\u0019C/Z:u\u0007>tGO]8mY\u0016\u0014H)\u001a;fGR\u001c(i\\;oG\u0016$'I]8lKJ\u001c\bf\u0001\u0017\u00026\u0005\u0011C/Z:u!J,W-\u001c9uS>twJ\\\"p]R\u0014x\u000e\u001c7feNCW\u000f\u001e3po:D3!LA\u001b\u0003m!Xm\u001d;Qe\u0016,W\u000e\u001d;j_:<\u0016\u000e\u001e5DC2d'-Y2lg\"\u001aa&!\u000e\u0002?Q,7\u000f^\"p]R\u0014x\u000e\u001c7fe\u001a+\u0017\r^;sKjsu\u000eZ3TKR,\b\u000fF\u0003p\u0003\u0017\f\t\u000fC\u0004\u0002N>\u0002\r!a4\u0002\u0019%t\u0017\u000e^5bYjsu\u000eZ3\u0011\u000bA\f\t.!6\n\u0007\u0005MgM\u0001\u0004PaRLwN\u001c\t\u0005\u0003/\fi.\u0004\u0002\u0002Z*\u0019\u00111\u001c*\u0002\u0005i\\\u0017\u0002BAp\u00033\u0014ABR3biV\u0014XM\u0017(pI\u0016Dq!a90\u0001\u0004\t)/\u0001\u000ej]R,'O\u0011:pW\u0016\u0014\bK]8u_\u000e|GNV3sg&|g\u000e\u0005\u0003\u0002h\u0006-XBAAu\u0015\r\tYAU\u0005\u0005\u0003[\fIO\u0001\u0006Ba&4VM]:j_:\fa\u0003^3ti&#W-\u001c9pi\u0016tG/\u00117uKJL5O\u001d\u0015\u0004a\u0005U\u0012A\u0005;fgR\fE\u000e^3s\u0013N\u0014XI\u001d:peND3!MA\u001b\u0003Q\u0019\u0017\r\u001d;ve\u0016\fE\u000e^3s\u0013N\u0014XI\u001d:peRA\u00111 B\u0013\u0005S\u0011\u0019\u0004\u0005\u0004\u0002~\n-!qB\u0007\u0003\u0003\u007fTAA!\u0001\u0003\u0004\u0005Q1m\u001c8dkJ\u0014XM\u001c;\u000b\t\t\u0015!qA\u0001\u0005kRLGN\u0003\u0002\u0003\n\u0005!!.\u0019<b\u0013\u0011\u0011i!a@\u0003#\r{W\u000e\u001d7fi\u0006\u0014G.\u001a$viV\u0014X\r\u0005\u0003\u0003\u0012\t\u0005RB\u0001B\n\u0015\u0011\u0011)Ba\u0006\u0002\u0011A\u0014x\u000e^8d_2TAA!\u0007\u0003\u001c\u000511m\\7n_:T1a\u0015B\u000f\u0015\u0011\u0011y\"!\u0006\u0002\r\u0005\u0004\u0018m\u00195f\u0013\u0011\u0011\u0019Ca\u0005\u0003\r\u0015\u0013(o\u001c:t\u0011\u0019\u00119C\ra\u0001q\u0006A!M]8lKJLE\rC\u0004\u0003,I\u0002\rA!\f\u0002\u0017\t\u0014xn[3s\u000bB|7\r\u001b\t\u0004a\n=\u0012b\u0001B\u0019M\n!Aj\u001c8h\u0011\u001d\u0011)D\ra\u0001\u0005o\t1\"[:sgR{\u0017\t\u001c;feB91M!\u000f\u0003>\t\u0015\u0013b\u0001B\u001eI\n\u0019Q*\u00199\u0011\t\t}\"\u0011I\u0007\u0003\u0005/IAAa\u0011\u0003\u0018\tqAk\u001c9jGB\u000b'\u000f^5uS>t\u0007\u0003BAt\u0005\u000fJAA!\u0013\u0002j\naA*Z1eKJ\fe\u000eZ%te\u0006i2-\u00199ukJ,\u0017\t\u001c;fe&\u001b(\u000fU1si&$\u0018n\u001c8FeJ|'\u000f\u0006\u0006\u0002|\n=#\u0011\u000bB*\u0005+BaAa\n4\u0001\u0004A\bb\u0002B\u0016g\u0001\u0007!Q\u0006\u0005\b\u0005k\u0019\u0004\u0019\u0001B\u001c\u0011\u001d\u00119f\ra\u0001\u0005{\t!\u0001\u001e9\u0002)Q,7\u000f\u001e+pa&\u001c\u0017\nZ:Be\u0016\fE\rZ3eQ\r!\u0014QG\u0001\u0018i\u0016\u001cH\u000fV8qS\u000eLEm]!sK:{G/\u00113eK\u0012D3!NA\u001b\u0003}!Xm\u001d;U_BL7-\u00133NS\u001e\u0014\u0018\r^5p]\u0006sG\rS1oI2Lgn\u001a\u0015\u0004m\u0005U\u0012a\f;fgR$v\u000e]5d\u0013\u0012l\u0015n\u001a:bi&|g.\u00118e\u0011\u0006tG\r\\5oO^KG\u000f[(mI\u0016\u0014h+\u001a:tS>t\u0007fA\u001c\u00026\u0005qC/Z:u)>\u0004\u0018nY%e!\u0016\u00148/[:ugRC'o\\;hQ\u000e{g\u000e\u001e:pY2,'OU3fY\u0016\u001cG/[8oQ\rA\u0014QG\u00011i\u0016\u001cHOT8U_BL7-\u00133QKJ\u001c\u0018n\u001d;t)\"\u0014x.^4i\u0007>tGO]8mY\u0016\u0014(+Z3mK\u000e$\u0018n\u001c8)\u0007e\n)$A\u0016uKN$Hk\u001c9jG&#\u0007+\u001a:tSN$8\u000f\u00165s_V<\u0007nQ8oiJ|G\u000e\\3s%\u0016\u001cH/\u0019:uQ\rQ\u0014QG\u0001\u001ci\u0016\u001cH\u000fV8qS\u000eLEm\u0011:fCR,Gm\u00148Va\u001e\u0014\u0018\rZ3)\u0007m\n)$\u0001\u0018uKN$Hk\u001c9jG&#7I]3bi\u0016$wJ\\+qOJ\fG-Z'vYRL'I]8lKJ\u001c6-\u001a8be&|\u0007f\u0001\u001f\u00026\u0005aC/Z:u)>\u0004\u0018nY%e+B<'/\u00193f\u0003\u001a$XM\u001d*fCN\u001c\u0018n\u001a8j]\u001e\u0004\u0016M\u001d;ji&|gn\u001d\u0015\u0004{\u0005U\u0012A\u0005;fgR\u001cuN\u001c;s_2dWM]'pm\u0016$2a\u001cBC\u0011\u001d\u00119I\u0010a\u0001\u0005\u0013\u000b1AZ;o!\u0011\u0001(1R8\n\u0007\t5eMA\u0005Gk:\u001cG/[8oa\u0005q\u0002O]3gKJ\u0014X\r\u001a*fa2L7-\u0019'fC\u0012,'/\u00127fGRLwN\u001c\u000b\f_\nM%q\u0013BN\u0005;\u00139\f\u0003\u0004\u0003\u0016~\u0002\r\u0001_\u0001\rG>tGO]8mY\u0016\u0014\u0018\n\u001a\u0005\u0007\u00053{\u0004\u0019\u00016\u0002\u0017=$\b.\u001a:Ce>\\WM\u001d\u0005\b\u0005/z\u0004\u0019\u0001B\u001f\u0011\u001d\u0011yj\u0010a\u0001\u0005C\u000b\u0001B]3qY&\u001c\u0017m\u001d\t\u0006\u0005G\u0013\t\f\u001f\b\u0005\u0005K\u0013i\u000bE\u0002\u0003(\u001al!A!+\u000b\u0007\t-F+\u0001\u0004=e>|GOP\u0005\u0004\u0005_3\u0017A\u0002)sK\u0012,g-\u0003\u0003\u00034\nU&aA*fi*\u0019!q\u00164\t\r\tev\b1\u0001y\u0003-aW-\u00193fe\u0016\u0003xn\u00195\u00021]\f\u0017\u000e^+oi&d7i\u001c8ue>dG.\u001a:Fa>\u001c\u0007\u000eF\u0003p\u0005\u007f\u0013\u0019\r\u0003\u0004\u0003B\u0002\u0003\r\u0001_\u0001\u0006KB|7\r\u001b\u0005\b\u0005\u000b\u0004\u0005\u0019\u0001Bd\u0003\u001diWm]:bO\u0016\u0004BAa)\u0003J&!!1\u001aB[\u0005\u0019\u0019FO]5oO\u0006)r/Y5u\r>\u0014\b+\u0019:uSRLwN\\*uCR,GcC8\u0003R\nM'q\u001bBn\u0005;DqAa\u0016B\u0001\u0004\u0011i\u0004\u0003\u0004\u0003V\u0006\u0003\r\u0001_\u0001\u0010G>tGO]8mY\u0016\u0014X\t]8dQ\"1!\u0011\\!A\u0002a\fa\u0001\\3bI\u0016\u0014\bB\u0002B]\u0003\u0002\u0007\u0001\u0010C\u0004\u0003F\u0006\u0003\rAa2\u00021%\u001cX\t\u001f9fGR,G\rU1si&$\u0018n\u001c8Ti\u0006$X\r\u0006\u0006\u0003d\n%(1\u001fB{\u0005o\u00042\u0001\u001dBs\u0013\r\u00119O\u001a\u0002\b\u0005>|G.Z1o\u0011\u001d\u0011YO\u0011a\u0001\u0005[\f1\u0004\\3bI\u0016\u0014\u0018j\u001d:B]\u0012\u001cuN\u001c;s_2dWM]#q_\u000eD\u0007cA0\u0003p&\u0019!\u0011\u001f)\u000371+\u0017\rZ3s\u0013N\u0014\u0018I\u001c3D_:$(o\u001c7mKJ,\u0005o\\2i\u0011\u0019\u0011)N\u0011a\u0001q\"1!\u0011\u001c\"A\u0002aDaA!/C\u0001\u0004A\u0018aC7bW\u0016\u001cVM\u001d<feN$RC\u0019B\u007f\u0007\u0003\u0019)a!\u0003\u0004\u000e\rM1qCB\u000e\u0007?\u0019\u0019\u0003\u0003\u0004\u0003\u0000\u000e\u0003\r\u0001_\u0001\u000b]Vl7i\u001c8gS\u001e\u001c\b\"CB\u0002\u0007B\u0005\t\u0019\u0001Br\u0003e\tW\u000f^8MK\u0006$WM\u001d*fE\u0006d\u0017M\\2f\u000b:\f'\r\\3\t\u0013\r\u001d1\t%AA\u0002\t\r\u0018aG;oG2,\u0017M\u001c'fC\u0012,'/\u00127fGRLwN\\#oC\ndW\rC\u0005\u0004\f\r\u0003\n\u00111\u0001\u0003d\u0006ARM\\1cY\u0016\u001cuN\u001c;s_2dW\rZ*ikR$wn\u001e8\t\u0013\r=1\t%AA\u0002\rE\u0011!\u00037jgR,g.\u001a:t!\u0015\u0001\u0018\u0011\u001bBd\u0011%\u0019)b\u0011I\u0001\u0002\u0004\u0019\t\"A\u000emSN$XM\\3s'\u0016\u001cWO]5usB\u0013x\u000e^8d_2l\u0015\r\u001d\u0005\n\u00073\u0019\u0005\u0013!a\u0001\u0007#\t\u0001dY8oiJ|G\u000e\u00157b]\u0016d\u0015n\u001d;f]\u0016\u0014h*Y7f\u0011%\t\u0019o\u0011I\u0001\u0002\u0004\u0019i\u0002E\u0003q\u0003#\f)\u000f\u0003\u0005\u0004\"\r\u0003\n\u00111\u0001y\u0003-awn\u001a#je\u000e{WO\u001c;\t\u0011\r\u00152\t%AA\u0002a\f\u0001c\u001d;beRLgnZ%e\u001dVl'-\u001a:\u0002+5\f7.Z*feZ,'o\u001d\u0013eK\u001a\fW\u000f\u001c;%eU\u001111\u0006\u0016\u0005\u0005G\u001cic\u000b\u0002\u00040A!1\u0011GB\u001e\u001b\t\u0019\u0019D\u0003\u0003\u00046\r]\u0012!C;oG\",7m[3e\u0015\r\u0019IDZ\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BB\u001f\u0007g\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003Ui\u0017m[3TKJ4XM]:%I\u00164\u0017-\u001e7uIM\nQ#\\1lKN+'O^3sg\u0012\"WMZ1vYR$C'A\u000bnC.,7+\u001a:wKJ\u001cH\u0005Z3gCVdG\u000fJ\u001b\u0016\u0005\r\u001d#\u0006BB\t\u0007[\tQ#\\1lKN+'O^3sg\u0012\"WMZ1vYR$c'A\u000bnC.,7+\u001a:wKJ\u001cH\u0005Z3gCVdG\u000fJ\u001c\u0002+5\f7.Z*feZ,'o\u001d\u0013eK\u001a\fW\u000f\u001c;%qU\u00111\u0011\u000b\u0016\u0005\u0007;\u0019i#A\u000bnC.,7+\u001a:wKJ\u001cH\u0005Z3gCVdG\u000fJ\u001d\u0016\u0005\r]#f\u0001=\u0004.\u00051R.Y6f'\u0016\u0014h/\u001a:tI\u0011,g-Y;mi\u0012\n\u0004'A\u0003uS6,'\u000f\u0006\u0003\u0004`\r]\u0004\u0003BB1\u0007gj!aa\u0019\u000b\t\r\u00154qM\u0001\u0005G>\u0014XM\u0003\u0003\u0004j\r-\u0014aB7fiJL7m\u001d\u0006\u0005\u0007[\u001ay'\u0001\u0004zC6lWM\u001d\u0006\u0003\u0007c\n1aY8n\u0013\u0011\u0019)ha\u0019\u0003\u000bQKW.\u001a:\t\u000f\reT\n1\u0001\u0003H\u0006QQ.\u001a;sS\u000et\u0015-\\3\u0002\u001b\u001d,GoQ8oiJ|G\u000e\\3s)\u0005Q\u0007")
public class ControllerIntegrationTest
extends QuorumTestHarness {
    private Seq<KafkaServer> servers = Nil$.MODULE$;
    private final int firstControllerEpoch = KafkaController$.MODULE$.InitialControllerEpoch() + 1;
    private final int firstControllerEpochZkVersion = KafkaController$.MODULE$.InitialControllerEpochZkVersion() + 1;

    public Seq<KafkaServer> servers() {
        return this.servers;
    }

    public void servers_$eq(Seq<KafkaServer> x$1) {
        this.servers = x$1;
    }

    public int firstControllerEpoch() {
        return this.firstControllerEpoch;
    }

    public int firstControllerEpochZkVersion() {
        return this.firstControllerEpochZkVersion;
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        super.setUp(testInfo);
        this.servers_$eq((Seq<KafkaServer>)Nil$.MODULE$);
    }

    @Override
    @AfterEach
    public void tearDown() {
        TestUtils$.MODULE$.shutdownServers(this.servers());
        super.tearDown();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testEmptyCluster() {
        this.servers_$eq(this.makeServers(1, this.makeServers$default$2(), this.makeServers$default$3(), this.makeServers$default$4(), this.makeServers$default$5(), this.makeServers$default$6(), this.makeServers$default$7(), this.makeServers$default$8(), this.makeServers$default$9(), this.makeServers$default$10()));
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ControllerIntegrationTest.$anonfun$testEmptyCluster$1(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ControllerIntegrationTest.$anonfun$testEmptyCluster$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.waitUntilControllerEpoch(this.firstControllerEpoch(), "broker failed to set controller epoch");
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testControllerEpochPersistsWhenAllBrokersDown() {
        this.servers_$eq(this.makeServers(1, this.makeServers$default$2(), this.makeServers$default$3(), this.makeServers$default$4(), this.makeServers$default$5(), this.makeServers$default$6(), this.makeServers$default$7(), this.makeServers$default$8(), this.makeServers$default$9(), this.makeServers$default$10()));
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ControllerIntegrationTest.$anonfun$testControllerEpochPersistsWhenAllBrokersDown$1(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ControllerIntegrationTest.$anonfun$testControllerEpochPersistsWhenAllBrokersDown$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.waitUntilControllerEpoch(this.firstControllerEpoch(), "broker failed to set controller epoch");
        ((KafkaServer)this.servers().head()).shutdown();
        ((KafkaServer)this.servers().head()).awaitShutdown();
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!ControllerIntegrationTest.$anonfun$testControllerEpochPersistsWhenAllBrokersDown$3(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ControllerIntegrationTest.$anonfun$testControllerEpochPersistsWhenAllBrokersDown$4());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.waitUntilControllerEpoch(this.firstControllerEpoch(), "controller epoch was not persisted after broker failure");
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testControllerMoveIncrementsControllerEpoch() {
        this.servers_$eq(this.makeServers(1, this.makeServers$default$2(), this.makeServers$default$3(), this.makeServers$default$4(), this.makeServers$default$5(), this.makeServers$default$6(), this.makeServers$default$7(), this.makeServers$default$8(), this.makeServers$default$9(), this.makeServers$default$10()));
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ControllerIntegrationTest.$anonfun$testControllerMoveIncrementsControllerEpoch$1(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ControllerIntegrationTest.$anonfun$testControllerMoveIncrementsControllerEpoch$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.waitUntilControllerEpoch(this.firstControllerEpoch(), "broker failed to set controller epoch");
        ((KafkaServer)this.servers().head()).shutdown();
        ((KafkaServer)this.servers().head()).awaitShutdown();
        ((KafkaServer)this.servers().head()).startup();
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!ControllerIntegrationTest.$anonfun$testControllerMoveIncrementsControllerEpoch$3(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ControllerIntegrationTest.$anonfun$testControllerMoveIncrementsControllerEpoch$4());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.waitUntilControllerEpoch(this.firstControllerEpoch() + 1, "controller epoch was not incremented after controller move");
    }

    @Test
    public void testMetadataPropagationOnControlPlane() {
        int x$1 = 1;
        Some x$2 = new Some((Object)"PLAINTEXT://localhost:0,CONTROLLER://localhost:0");
        Some x$3 = new Some((Object)"PLAINTEXT:PLAINTEXT,CONTROLLER:PLAINTEXT");
        Some x$4 = new Some((Object)"CONTROLLER");
        boolean x$5 = this.makeServers$default$2();
        boolean x$6 = this.makeServers$default$3();
        boolean x$7 = this.makeServers$default$4();
        Option<ApiVersion> x$8 = this.makeServers$default$8();
        int x$9 = this.makeServers$default$9();
        int x$10 = this.makeServers$default$10();
        this.servers_$eq(this.makeServers(x$1, x$5, x$6, x$7, (Option<String>)x$2, (Option<String>)x$3, (Option<String>)x$4, x$8, x$9, x$10));
        TestUtils$.MODULE$.waitUntilBrokerMetadataIsPropagated(this.servers(), TestUtils$.MODULE$.waitUntilBrokerMetadataIsPropagated$default$2());
        scala.collection.mutable.Map controlPlaneMetricMap = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        scala.collection.mutable.Map dataPlaneMetricMap = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        ((KafkaServer)this.servers().head()).metrics().metrics().values().forEach(kafkaMetric -> {
            if (kafkaMetric.metricName().tags().values().contains("CONTROLLER")) {
                controlPlaneMetricMap.put((Object)kafkaMetric.metricName().name(), kafkaMetric);
            }
            if (kafkaMetric.metricName().tags().values().contains("PLAINTEXT")) {
                dataPlaneMetricMap.put((Object)kafkaMetric.metricName().name(), kafkaMetric);
            }
        });
        Assertions.assertEquals((double)1.0, (double)BoxesRunTime.unboxToDouble((Object)((KafkaMetric)controlPlaneMetricMap.apply((Object)"response-total")).metricValue()), (double)0.0);
        Assertions.assertEquals((double)0.0, (double)BoxesRunTime.unboxToDouble((Object)((KafkaMetric)dataPlaneMetricMap.apply((Object)"response-total")).metricValue()), (double)0.0);
        Assertions.assertEquals((double)1.0, (double)BoxesRunTime.unboxToDouble((Object)((KafkaMetric)controlPlaneMetricMap.apply((Object)"request-total")).metricValue()), (double)0.0);
        Assertions.assertEquals((double)0.0, (double)BoxesRunTime.unboxToDouble((Object)((KafkaMetric)dataPlaneMetricMap.apply((Object)"request-total")).metricValue()), (double)0.0);
        Assertions.assertTrue((BoxesRunTime.unboxToDouble((Object)((KafkaMetric)controlPlaneMetricMap.apply((Object)"incoming-byte-total")).metricValue()) > 1.0 ? 1 : 0) != 0);
        Assertions.assertTrue((BoxesRunTime.unboxToDouble((Object)((KafkaMetric)dataPlaneMetricMap.apply((Object)"incoming-byte-total")).metricValue()) == 0.0 ? 1 : 0) != 0);
        Assertions.assertTrue((BoxesRunTime.unboxToDouble((Object)((KafkaMetric)controlPlaneMetricMap.apply((Object)"network-io-total")).metricValue()) == 2.0 ? 1 : 0) != 0);
        Assertions.assertTrue((BoxesRunTime.unboxToDouble((Object)((KafkaMetric)dataPlaneMetricMap.apply((Object)"network-io-total")).metricValue()) == 0.0 ? 1 : 0) != 0);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testMetadataPropagationOnBrokerChange() {
        this.servers_$eq(this.makeServers(3, this.makeServers$default$2(), this.makeServers$default$3(), this.makeServers$default$4(), this.makeServers$default$5(), this.makeServers$default$6(), this.makeServers$default$7(), this.makeServers$default$8(), this.makeServers$default$9(), this.makeServers$default$10()));
        TestUtils$.MODULE$.waitUntilBrokerMetadataIsPropagated(this.servers(), TestUtils$.MODULE$.waitUntilBrokerMetadataIsPropagated$default$2());
        int controllerId = TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), TestUtils$.MODULE$.waitUntilControllerElected$default$2());
        KafkaServer testBroker = (KafkaServer)((IterableLike)this.servers().filter((Function1 & Serializable & scala.Serializable)e -> BoxesRunTime.boxToBoolean((boolean)ControllerIntegrationTest.$anonfun$testMetadataPropagationOnBrokerChange$1(controllerId, e)))).head();
        Seq remainingBrokers = (Seq)this.servers().filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ControllerIntegrationTest.$anonfun$testMetadataPropagationOnBrokerChange$2(testBroker, x$1)));
        String topic = "topic1";
        Map assignment = (Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{((KafkaServer)remainingBrokers.apply(0)).config().brokerId(), testBroker.config().brokerId()}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), remainingBrokers.map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)ControllerIntegrationTest.$anonfun$testMetadataPropagationOnBrokerChange$3(x$2)), Seq$.MODULE$.canBuildFrom()))}));
        TestUtils$.MODULE$.createTopic(this.zkClient(), topic, (Map<Object, Seq<Object>>)assignment, this.servers());
        testBroker.shutdown();
        testBroker.awaitShutdown();
        TestUtils$.MODULE$.waitUntilBrokerMetadataIsPropagated(remainingBrokers, TestUtils$.MODULE$.waitUntilBrokerMetadataIsPropagated$default$2());
        remainingBrokers.foreach((Function1 & Serializable & scala.Serializable)server -> {
            ControllerIntegrationTest.$anonfun$testMetadataPropagationOnBrokerChange$4(topic, testBroker, assignment, remainingBrokers, server);
            return BoxedUnit.UNIT;
        });
        testBroker.startup();
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ControllerIntegrationTest.$anonfun$testMetadataPropagationOnBrokerChange$5(this, assignment, topic)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ControllerIntegrationTest.$anonfun$testMetadataPropagationOnBrokerChange$8());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    @Test
    public void testMetadataPropagationForOfflineReplicas() {
        this.servers_$eq(this.makeServers(3, this.makeServers$default$2(), this.makeServers$default$3(), this.makeServers$default$4(), this.makeServers$default$5(), this.makeServers$default$6(), this.makeServers$default$7(), this.makeServers$default$8(), this.makeServers$default$9(), this.makeServers$default$10()));
        TestUtils$.MODULE$.waitUntilBrokerMetadataIsPropagated(this.servers(), TestUtils$.MODULE$.waitUntilBrokerMetadataIsPropagated$default$2());
        int controllerId = TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), TestUtils$.MODULE$.waitUntilControllerElected$default$2());
        KafkaServer replicaBroker = (KafkaServer)((IterableLike)this.servers().filter((Function1 & Serializable & scala.Serializable)e -> BoxesRunTime.boxToBoolean((boolean)ControllerIntegrationTest.$anonfun$testMetadataPropagationForOfflineReplicas$1(controllerId, e)))).head();
        KafkaServer controllerBroker = (KafkaServer)((IterableLike)this.servers().filter((Function1 & Serializable & scala.Serializable)e -> BoxesRunTime.boxToBoolean((boolean)ControllerIntegrationTest.$anonfun$testMetadataPropagationForOfflineReplicas$2(controllerId, e)))).head();
        KafkaServer otherBroker = (KafkaServer)((IterableLike)this.servers().filter((Function1 & Serializable & scala.Serializable)e -> BoxesRunTime.boxToBoolean((boolean)ControllerIntegrationTest.$anonfun$testMetadataPropagationForOfflineReplicas$3(controllerId, replicaBroker, e)))).head();
        String topic = "topic1";
        Map assignment = (Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{replicaBroker.config().brokerId()})))}));
        TestUtils$.MODULE$.createTopic(this.zkClient(), topic, (Map<Object, Seq<Object>>)assignment, this.servers());
        otherBroker.shutdown();
        otherBroker.awaitShutdown();
        replicaBroker.shutdown();
        replicaBroker.awaitShutdown();
        controllerBroker.shutdown();
        controllerBroker.awaitShutdown();
        ControllerIntegrationTest.verifyMetadata$1(controllerBroker, topic);
        ControllerIntegrationTest.verifyMetadata$1(otherBroker, topic);
    }

    @Test
    public void testMetadataPropagationOnBrokerShutdownWithNoReplicas() {
        this.servers_$eq(this.makeServers(3, this.makeServers$default$2(), this.makeServers$default$3(), this.makeServers$default$4(), this.makeServers$default$5(), this.makeServers$default$6(), this.makeServers$default$7(), this.makeServers$default$8(), this.makeServers$default$9(), this.makeServers$default$10()));
        TestUtils$.MODULE$.waitUntilBrokerMetadataIsPropagated(this.servers(), TestUtils$.MODULE$.waitUntilBrokerMetadataIsPropagated$default$2());
        int controllerId = TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), TestUtils$.MODULE$.waitUntilControllerElected$default$2());
        KafkaServer replicaBroker = (KafkaServer)((IterableLike)this.servers().filter((Function1 & Serializable & scala.Serializable)e -> BoxesRunTime.boxToBoolean((boolean)ControllerIntegrationTest.$anonfun$testMetadataPropagationOnBrokerShutdownWithNoReplicas$1(controllerId, e)))).head();
        KafkaServer controllerBroker = (KafkaServer)((IterableLike)this.servers().filter((Function1 & Serializable & scala.Serializable)e -> BoxesRunTime.boxToBoolean((boolean)ControllerIntegrationTest.$anonfun$testMetadataPropagationOnBrokerShutdownWithNoReplicas$2(controllerId, e)))).head();
        KafkaServer otherBroker = (KafkaServer)((IterableLike)this.servers().filter((Function1 & Serializable & scala.Serializable)e -> BoxesRunTime.boxToBoolean((boolean)ControllerIntegrationTest.$anonfun$testMetadataPropagationOnBrokerShutdownWithNoReplicas$3(controllerId, replicaBroker, e)))).head();
        String topic = "topic1";
        Map assignment = (Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{replicaBroker.config().brokerId()})))}));
        TestUtils$.MODULE$.createTopic(this.zkClient(), topic, (Map<Object, Seq<Object>>)assignment, this.servers());
        replicaBroker.shutdown();
        replicaBroker.awaitShutdown();
        otherBroker.shutdown();
        otherBroker.awaitShutdown();
        TestUtils$.MODULE$.waitUntilBrokerMetadataIsPropagated(new .colon.colon((Object)controllerBroker, (List)Nil$.MODULE$), TestUtils$.MODULE$.waitUntilBrokerMetadataIsPropagated$default$2());
    }

    @Test
    public void testTopicCreation() {
        this.servers_$eq(this.makeServers(1, this.makeServers$default$2(), this.makeServers$default$3(), this.makeServers$default$4(), this.makeServers$default$5(), this.makeServers$default$6(), this.makeServers$default$7(), this.makeServers$default$8(), this.makeServers$default$9(), this.makeServers$default$10()));
        TopicPartition tp = new TopicPartition("t", 0);
        Map assignment = (Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp.partition())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})))}));
        TestUtils$.MODULE$.createTopic(this.zkClient(), tp.topic(), (Map<Object, Seq<Object>>)assignment, this.servers());
        this.waitForPartitionState(tp, this.firstControllerEpoch(), 0, LeaderAndIsr$.MODULE$.initialLeaderEpoch(), "failed to get expected partition state upon topic creation");
    }

    @Test
    public void testTopicCreationWithOfflineReplica() {
        this.servers_$eq(this.makeServers(2, this.makeServers$default$2(), this.makeServers$default$3(), this.makeServers$default$4(), this.makeServers$default$5(), this.makeServers$default$6(), this.makeServers$default$7(), this.makeServers$default$8(), this.makeServers$default$9(), this.makeServers$default$10()));
        int controllerId = TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), TestUtils$.MODULE$.waitUntilControllerElected$default$2());
        int otherBrokerId = BoxesRunTime.unboxToInt((Object)((IterableLike)((TraversableLike)this.servers().map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToInteger((int)ControllerIntegrationTest.$anonfun$testTopicCreationWithOfflineReplica$1(x$3)), Seq$.MODULE$.canBuildFrom())).filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$4 -> x$4 != controllerId)).head());
        ((KafkaServer)this.servers().apply(otherBrokerId)).shutdown();
        ((KafkaServer)this.servers().apply(otherBrokerId)).awaitShutdown();
        TopicPartition tp = new TopicPartition("t", 0);
        Map assignment = (Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp.partition())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{otherBrokerId, controllerId})))}));
        TestUtils$.MODULE$.createTopic(this.zkClient(), tp.topic(), (Map<Object, Seq<Object>>)assignment, (Seq<KafkaServer>)((Seq)this.servers().take(1)));
        this.waitForPartitionState(tp, this.firstControllerEpoch(), controllerId, LeaderAndIsr$.MODULE$.initialLeaderEpoch(), "failed to get expected partition state upon topic creation");
    }

    @Test
    public void testTopicPartitionExpansion() {
        this.servers_$eq(this.makeServers(1, this.makeServers$default$2(), this.makeServers$default$3(), this.makeServers$default$4(), this.makeServers$default$5(), this.makeServers$default$6(), this.makeServers$default$7(), this.makeServers$default$8(), this.makeServers$default$9(), this.makeServers$default$10()));
        TopicPartition tp0 = new TopicPartition("t", 0);
        TopicPartition tp1 = new TopicPartition("t", 1);
        Map assignment = (Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp0.partition())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})))}));
        Map expandedAssignment = (Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp0), (Object)ReplicaAssignment$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})), (Seq)Nil$.MODULE$, (Seq)Nil$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), (Object)ReplicaAssignment$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})), (Seq)Nil$.MODULE$, (Seq)Nil$.MODULE$))}));
        TestUtils$.MODULE$.createTopic(this.zkClient(), tp0.topic(), (Map<Object, Seq<Object>>)assignment, this.servers());
        this.zkClient().setTopicAssignment(tp0.topic(), (Option)new Some((Object)Uuid.randomUuid()), expandedAssignment, this.firstControllerEpochZkVersion());
        this.waitForPartitionState(tp1, this.firstControllerEpoch(), 0, LeaderAndIsr$.MODULE$.initialLeaderEpoch(), "failed to get expected partition state upon topic partition expansion");
        TestUtils$.MODULE$.waitForPartitionMetadata(this.servers(), tp1.topic(), tp1.partition(), TestUtils$.MODULE$.waitForPartitionMetadata$default$4());
    }

    @Test
    public void testTopicPartitionExpansionWithOfflineReplica() {
        this.servers_$eq(this.makeServers(2, this.makeServers$default$2(), this.makeServers$default$3(), this.makeServers$default$4(), this.makeServers$default$5(), this.makeServers$default$6(), this.makeServers$default$7(), this.makeServers$default$8(), this.makeServers$default$9(), this.makeServers$default$10()));
        int controllerId = TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), TestUtils$.MODULE$.waitUntilControllerElected$default$2());
        int otherBrokerId = BoxesRunTime.unboxToInt((Object)((IterableLike)((TraversableLike)this.servers().map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToInteger((int)ControllerIntegrationTest.$anonfun$testTopicPartitionExpansionWithOfflineReplica$1(x$5)), Seq$.MODULE$.canBuildFrom())).filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$6 -> x$6 != controllerId)).head());
        TopicPartition tp0 = new TopicPartition("t", 0);
        TopicPartition tp1 = new TopicPartition("t", 1);
        Map assignment = (Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp0.partition())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{otherBrokerId, controllerId})))}));
        Map expandedAssignment = (Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp0), (Object)ReplicaAssignment$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{otherBrokerId, controllerId})), (Seq)Nil$.MODULE$, (Seq)Nil$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), (Object)ReplicaAssignment$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{otherBrokerId, controllerId})), (Seq)Nil$.MODULE$, (Seq)Nil$.MODULE$))}));
        TestUtils$.MODULE$.createTopic(this.zkClient(), tp0.topic(), (Map<Object, Seq<Object>>)assignment, this.servers());
        ((KafkaServer)this.servers().apply(otherBrokerId)).shutdown();
        ((KafkaServer)this.servers().apply(otherBrokerId)).awaitShutdown();
        this.zkClient().setTopicAssignment(tp0.topic(), (Option)new Some((Object)Uuid.randomUuid()), expandedAssignment, this.firstControllerEpochZkVersion());
        this.waitForPartitionState(tp1, this.firstControllerEpoch(), controllerId, LeaderAndIsr$.MODULE$.initialLeaderEpoch(), "failed to get expected partition state upon topic partition expansion");
        TestUtils$.MODULE$.waitForPartitionMetadata(new .colon.colon((Object)((KafkaServer)this.servers().apply(controllerId)), (List)Nil$.MODULE$), tp1.topic(), tp1.partition(), TestUtils$.MODULE$.waitForPartitionMetadata$default$4());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testPartitionReassignment() {
        this.servers_$eq(this.makeServers(2, this.makeServers$default$2(), this.makeServers$default$3(), this.makeServers$default$4(), this.makeServers$default$5(), this.makeServers$default$6(), this.makeServers$default$7(), this.makeServers$default$8(), this.makeServers$default$9(), this.makeServers$default$10()));
        int controllerId = TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), TestUtils$.MODULE$.waitUntilControllerElected$default$2());
        String metricName = new StringBuilder(43).append("kafka.controller:type=ControllerStats,name=").append(ControllerState.AlterPartitionReassignment$.MODULE$.rateAndTimeMetricName().get()).toString();
        long timerCount = this.timer(metricName).count();
        int otherBrokerId = BoxesRunTime.unboxToInt((Object)((IterableLike)((TraversableLike)this.servers().map((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToInteger((int)ControllerIntegrationTest.$anonfun$testPartitionReassignment$1(x$7)), Seq$.MODULE$.canBuildFrom())).filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$8 -> x$8 != controllerId)).head());
        TopicPartition tp = new TopicPartition("t", 0);
        Map assignment = (Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp.partition())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{controllerId})))}));
        Map reassignment = (Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)ReplicaAssignment$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{otherBrokerId})), (Seq)Nil$.MODULE$, (Seq)Nil$.MODULE$))}));
        TestUtils$.MODULE$.createTopic(this.zkClient(), tp.topic(), (Map<Object, Seq<Object>>)assignment, this.servers());
        this.zkClient().createPartitionReassignment((Map)reassignment.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            TopicPartition k = (TopicPartition)x0$1._1();
            ReplicaAssignment v = (ReplicaAssignment)x0$1._2();
            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), (Object)v.replicas());
            return tuple2;
        }, scala.collection.Map$.MODULE$.canBuildFrom()));
        this.waitForPartitionState(tp, this.firstControllerEpoch(), otherBrokerId, LeaderAndIsr$.MODULE$.initialLeaderEpoch() + 3, "failed to get expected partition state after partition reassignment");
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ControllerIntegrationTest.$anonfun$testPartitionReassignment$4(this, tp, reassignment)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ControllerIntegrationTest.$anonfun$testPartitionReassignment$5());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!ControllerIntegrationTest.$anonfun$testPartitionReassignment$6(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ControllerIntegrationTest.$anonfun$testPartitionReassignment$7());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        long updatedTimerCount = this.timer(metricName).count();
        Assertions.assertTrue((updatedTimerCount > timerCount ? 1 : 0) != 0, (String)new StringBuilder(36).append("Timer count ").append(updatedTimerCount).append(" should be greater than ").append(timerCount).toString());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testPartitionReassignmentToBrokerWithOfflineLogDir() {
        int x$1 = 2;
        int x$2 = 2;
        boolean x$3 = this.makeServers$default$2();
        boolean x$4 = this.makeServers$default$3();
        boolean x$5 = this.makeServers$default$4();
        Option<String> x$6 = this.makeServers$default$5();
        Option<String> x$7 = this.makeServers$default$6();
        Option<String> x$8 = this.makeServers$default$7();
        Option<ApiVersion> x$92 = this.makeServers$default$8();
        int x$10 = this.makeServers$default$10();
        this.servers_$eq(this.makeServers(x$1, x$3, x$4, x$5, x$6, x$7, x$8, x$92, x$2, x$10));
        int controllerId = TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), TestUtils$.MODULE$.waitUntilControllerElected$default$2());
        String metricName = new StringBuilder(43).append("kafka.controller:type=ControllerStats,name=").append(ControllerState.AlterPartitionReassignment$.MODULE$.rateAndTimeMetricName().get()).toString();
        long timerCount = this.timer(metricName).count();
        KafkaServer otherBroker = (KafkaServer)((IterableLike)this.servers().filter((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)ControllerIntegrationTest.$anonfun$testPartitionReassignmentToBrokerWithOfflineLogDir$1(controllerId, x$9)))).head();
        int otherBrokerId = otherBroker.config().brokerId();
        TopicPartition topicPartitionToPutOffline = new TopicPartition("filler", 0);
        TestUtils$.MODULE$.createTopic(this.zkClient(), topicPartitionToPutOffline.topic(), (Map<Object, Seq<Object>>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)topicPartitionToPutOffline.partition())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{otherBrokerId})))}))), this.servers());
        TestUtils$.MODULE$.causeLogDirFailure(TestUtils$Checkpoint$.MODULE$, (KafkaBroker)otherBroker, topicPartitionToPutOffline);
        TopicPartition tp = new TopicPartition("t", 0);
        Map assignment = (Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp.partition())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{controllerId})))}));
        Map reassignment = (Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)ReplicaAssignment$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{otherBrokerId})), (Seq)Nil$.MODULE$, (Seq)Nil$.MODULE$))}));
        TestUtils$.MODULE$.createTopic(this.zkClient(), tp.topic(), (Map<Object, Seq<Object>>)assignment, this.servers());
        this.zkClient().createPartitionReassignment((Map)reassignment.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            TopicPartition k = (TopicPartition)x0$1._1();
            ReplicaAssignment v = (ReplicaAssignment)x0$1._2();
            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), (Object)v.replicas());
            return tuple2;
        }, scala.collection.Map$.MODULE$.canBuildFrom()));
        this.waitForPartitionState(tp, this.firstControllerEpoch(), otherBrokerId, LeaderAndIsr$.MODULE$.initialLeaderEpoch() + 3, "with an offline log directory on the target broker, the partition reassignment stalls");
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ControllerIntegrationTest.$anonfun$testPartitionReassignmentToBrokerWithOfflineLogDir$3(this, tp, reassignment)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ControllerIntegrationTest.$anonfun$testPartitionReassignmentToBrokerWithOfflineLogDir$4());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!ControllerIntegrationTest.$anonfun$testPartitionReassignmentToBrokerWithOfflineLogDir$5(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ControllerIntegrationTest.$anonfun$testPartitionReassignmentToBrokerWithOfflineLogDir$6());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        long updatedTimerCount = this.timer(metricName).count();
        Assertions.assertTrue((updatedTimerCount > timerCount ? 1 : 0) != 0, (String)new StringBuilder(36).append("Timer count ").append(updatedTimerCount).append(" should be greater than ").append(timerCount).toString());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testPartitionReassignmentWithOfflineReplicaHaltingProgress() {
        this.servers_$eq(this.makeServers(2, this.makeServers$default$2(), this.makeServers$default$3(), this.makeServers$default$4(), this.makeServers$default$5(), this.makeServers$default$6(), this.makeServers$default$7(), this.makeServers$default$8(), this.makeServers$default$9(), this.makeServers$default$10()));
        int controllerId = TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), TestUtils$.MODULE$.waitUntilControllerElected$default$2());
        int otherBrokerId = BoxesRunTime.unboxToInt((Object)((IterableLike)((TraversableLike)this.servers().map((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToInteger((int)ControllerIntegrationTest.$anonfun$testPartitionReassignmentWithOfflineReplicaHaltingProgress$1(x$10)), Seq$.MODULE$.canBuildFrom())).filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$11 -> x$11 != controllerId)).head());
        TopicPartition tp = new TopicPartition("t", 0);
        Map assignment = (Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp.partition())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{controllerId})))}));
        Map reassignment = (Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{otherBrokerId})))}));
        TestUtils$.MODULE$.createTopic(this.zkClient(), tp.topic(), (Map<Object, Seq<Object>>)assignment, this.servers());
        ((KafkaServer)this.servers().apply(otherBrokerId)).shutdown();
        ((KafkaServer)this.servers().apply(otherBrokerId)).awaitShutdown();
        KafkaServer controller = this.getController();
        this.zkClient().setOrCreatePartitionReassignment(reassignment, controller.kafkaController().controllerContext().epochZkVersion());
        this.waitForPartitionState(tp, this.firstControllerEpoch(), controllerId, LeaderAndIsr$.MODULE$.initialLeaderEpoch() + 1, "failed to get expected partition state during partition reassignment with offline replica");
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ControllerIntegrationTest.$anonfun$testPartitionReassignmentWithOfflineReplicaHaltingProgress$3(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ControllerIntegrationTest.$anonfun$testPartitionReassignmentWithOfflineReplicaHaltingProgress$4());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testPartitionReassignmentResumesAfterReplicaComesOnline() {
        this.servers_$eq(this.makeServers(2, this.makeServers$default$2(), this.makeServers$default$3(), this.makeServers$default$4(), this.makeServers$default$5(), this.makeServers$default$6(), this.makeServers$default$7(), this.makeServers$default$8(), this.makeServers$default$9(), this.makeServers$default$10()));
        int controllerId = TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), TestUtils$.MODULE$.waitUntilControllerElected$default$2());
        int otherBrokerId = BoxesRunTime.unboxToInt((Object)((IterableLike)((TraversableLike)this.servers().map((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToInteger((int)ControllerIntegrationTest.$anonfun$testPartitionReassignmentResumesAfterReplicaComesOnline$1(x$12)), Seq$.MODULE$.canBuildFrom())).filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$13 -> x$13 != controllerId)).head());
        TopicPartition tp = new TopicPartition("t", 0);
        Map assignment = (Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp.partition())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{controllerId})))}));
        Map reassignment = (Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)ReplicaAssignment$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{otherBrokerId})), (Seq)Nil$.MODULE$, (Seq)Nil$.MODULE$))}));
        TestUtils$.MODULE$.createTopic(this.zkClient(), tp.topic(), (Map<Object, Seq<Object>>)assignment, this.servers());
        ((KafkaServer)this.servers().apply(otherBrokerId)).shutdown();
        ((KafkaServer)this.servers().apply(otherBrokerId)).awaitShutdown();
        this.zkClient().createPartitionReassignment((Map)reassignment.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            TopicPartition k = (TopicPartition)x0$1._1();
            ReplicaAssignment v = (ReplicaAssignment)x0$1._2();
            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), (Object)v.replicas());
            return tuple2;
        }, scala.collection.Map$.MODULE$.canBuildFrom()));
        this.waitForPartitionState(tp, this.firstControllerEpoch(), controllerId, LeaderAndIsr$.MODULE$.initialLeaderEpoch() + 1, "failed to get expected partition state during partition reassignment with offline replica");
        ((KafkaServer)this.servers().apply(otherBrokerId)).startup();
        this.waitForPartitionState(tp, this.firstControllerEpoch(), otherBrokerId, LeaderAndIsr$.MODULE$.initialLeaderEpoch() + 4, "failed to get expected partition state after partition reassignment");
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ControllerIntegrationTest.$anonfun$testPartitionReassignmentResumesAfterReplicaComesOnline$4(this, tp, reassignment)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ControllerIntegrationTest.$anonfun$testPartitionReassignmentResumesAfterReplicaComesOnline$5());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!ControllerIntegrationTest.$anonfun$testPartitionReassignmentResumesAfterReplicaComesOnline$6(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ControllerIntegrationTest.$anonfun$testPartitionReassignmentResumesAfterReplicaComesOnline$7());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    @Test
    public void testPreferredReplicaLeaderElection() {
        this.servers_$eq(this.makeServers(2, this.makeServers$default$2(), this.makeServers$default$3(), this.makeServers$default$4(), this.makeServers$default$5(), this.makeServers$default$6(), this.makeServers$default$7(), this.makeServers$default$8(), this.makeServers$default$9(), this.makeServers$default$10()));
        int controllerId = TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), TestUtils$.MODULE$.waitUntilControllerElected$default$2());
        KafkaServer otherBroker = (KafkaServer)this.servers().find((Function1 & Serializable & scala.Serializable)x$14 -> BoxesRunTime.boxToBoolean((boolean)ControllerIntegrationTest.$anonfun$testPreferredReplicaLeaderElection$1(controllerId, x$14))).get();
        TopicPartition tp = new TopicPartition("t", 0);
        Map assignment = (Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp.partition())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{otherBroker.config().brokerId(), controllerId})))}));
        TestUtils$.MODULE$.createTopic(this.zkClient(), tp.topic(), (Map<Object, Seq<Object>>)assignment, this.servers());
        this.preferredReplicaLeaderElection(controllerId, otherBroker, tp, (scala.collection.immutable.Set<Object>)((TraversableOnce)assignment.apply((Object)BoxesRunTime.boxToInteger((int)tp.partition()))).toSet(), LeaderAndIsr$.MODULE$.initialLeaderEpoch());
    }

    @Test
    public void testBackToBackPreferredReplicaLeaderElections() {
        this.servers_$eq(this.makeServers(2, this.makeServers$default$2(), this.makeServers$default$3(), this.makeServers$default$4(), this.makeServers$default$5(), this.makeServers$default$6(), this.makeServers$default$7(), this.makeServers$default$8(), this.makeServers$default$9(), this.makeServers$default$10()));
        int controllerId = TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), TestUtils$.MODULE$.waitUntilControllerElected$default$2());
        KafkaServer otherBroker = (KafkaServer)this.servers().find((Function1 & Serializable & scala.Serializable)x$15 -> BoxesRunTime.boxToBoolean((boolean)ControllerIntegrationTest.$anonfun$testBackToBackPreferredReplicaLeaderElections$1(controllerId, x$15))).get();
        TopicPartition tp = new TopicPartition("t", 0);
        Map assignment = (Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp.partition())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{otherBroker.config().brokerId(), controllerId})))}));
        TestUtils$.MODULE$.createTopic(this.zkClient(), tp.topic(), (Map<Object, Seq<Object>>)assignment, this.servers());
        this.preferredReplicaLeaderElection(controllerId, otherBroker, tp, (scala.collection.immutable.Set<Object>)((TraversableOnce)assignment.apply((Object)BoxesRunTime.boxToInteger((int)tp.partition()))).toSet(), LeaderAndIsr$.MODULE$.initialLeaderEpoch());
        this.preferredReplicaLeaderElection(controllerId, otherBroker, tp, (scala.collection.immutable.Set<Object>)((TraversableOnce)assignment.apply((Object)BoxesRunTime.boxToInteger((int)tp.partition()))).toSet(), LeaderAndIsr$.MODULE$.initialLeaderEpoch() + 2);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testPreferredReplicaLeaderElectionWithOfflinePreferredReplica() {
        this.servers_$eq(this.makeServers(2, this.makeServers$default$2(), this.makeServers$default$3(), this.makeServers$default$4(), this.makeServers$default$5(), this.makeServers$default$6(), this.makeServers$default$7(), this.makeServers$default$8(), this.makeServers$default$9(), this.makeServers$default$10()));
        int controllerId = TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), TestUtils$.MODULE$.waitUntilControllerElected$default$2());
        int otherBrokerId = BoxesRunTime.unboxToInt((Object)((IterableLike)((TraversableLike)this.servers().map((Function1 & Serializable & scala.Serializable)x$16 -> BoxesRunTime.boxToInteger((int)ControllerIntegrationTest.$anonfun$testPreferredReplicaLeaderElectionWithOfflinePreferredReplica$1(x$16)), Seq$.MODULE$.canBuildFrom())).filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$17 -> x$17 != controllerId)).head());
        TopicPartition tp = new TopicPartition("t", 0);
        Map assignment = (Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp.partition())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{otherBrokerId, controllerId})))}));
        TestUtils$.MODULE$.createTopic(this.zkClient(), tp.topic(), (Map<Object, Seq<Object>>)assignment, this.servers());
        ((KafkaServer)this.servers().apply(otherBrokerId)).shutdown();
        ((KafkaServer)this.servers().apply(otherBrokerId)).awaitShutdown();
        this.zkClient().createPreferredReplicaElection((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp})));
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ControllerIntegrationTest.$anonfun$testPreferredReplicaLeaderElectionWithOfflinePreferredReplica$3(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ControllerIntegrationTest.$anonfun$testPreferredReplicaLeaderElectionWithOfflinePreferredReplica$4());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.waitForPartitionState(tp, this.firstControllerEpoch(), controllerId, LeaderAndIsr$.MODULE$.initialLeaderEpoch() + 1, "failed to get expected partition state upon broker shutdown");
    }

    @Test
    public void testAutoPreferredReplicaLeaderElection() {
        this.servers_$eq(this.makeServers(2, true, this.makeServers$default$3(), this.makeServers$default$4(), this.makeServers$default$5(), this.makeServers$default$6(), this.makeServers$default$7(), this.makeServers$default$8(), this.makeServers$default$9(), this.makeServers$default$10()));
        int controllerId = TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), TestUtils$.MODULE$.waitUntilControllerElected$default$2());
        int otherBrokerId = BoxesRunTime.unboxToInt((Object)((IterableLike)((TraversableLike)this.servers().map((Function1 & Serializable & scala.Serializable)x$18 -> BoxesRunTime.boxToInteger((int)ControllerIntegrationTest.$anonfun$testAutoPreferredReplicaLeaderElection$1(x$18)), Seq$.MODULE$.canBuildFrom())).filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$19 -> x$19 != controllerId)).head());
        TopicPartition tp = new TopicPartition("t", 0);
        Map assignment = (Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp.partition())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 0})))}));
        TestUtils$.MODULE$.createTopic(this.zkClient(), tp.topic(), (Map<Object, Seq<Object>>)assignment, this.servers());
        ((KafkaServer)this.servers().apply(otherBrokerId)).shutdown();
        ((KafkaServer)this.servers().apply(otherBrokerId)).awaitShutdown();
        this.waitForPartitionState(tp, this.firstControllerEpoch(), controllerId, LeaderAndIsr$.MODULE$.initialLeaderEpoch() + 1, "failed to get expected partition state upon broker shutdown");
        ((KafkaServer)this.servers().apply(otherBrokerId)).startup();
        this.waitForPartitionState(tp, this.firstControllerEpoch(), otherBrokerId, LeaderAndIsr$.MODULE$.initialLeaderEpoch() + 2, "failed to get expected partition state upon broker startup");
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testLeaderAndIsrWhenEntireIsrOfflineAndUncleanLeaderElectionDisabled() {
        this.servers_$eq(this.makeServers(2, this.makeServers$default$2(), this.makeServers$default$3(), this.makeServers$default$4(), this.makeServers$default$5(), this.makeServers$default$6(), this.makeServers$default$7(), this.makeServers$default$8(), this.makeServers$default$9(), this.makeServers$default$10()));
        int controllerId = TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), TestUtils$.MODULE$.waitUntilControllerElected$default$2());
        int otherBrokerId = BoxesRunTime.unboxToInt((Object)((IterableLike)((TraversableLike)this.servers().map((Function1 & Serializable & scala.Serializable)x$20 -> BoxesRunTime.boxToInteger((int)ControllerIntegrationTest.$anonfun$testLeaderAndIsrWhenEntireIsrOfflineAndUncleanLeaderElectionDisabled$1(x$20)), Seq$.MODULE$.canBuildFrom())).filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$21 -> x$21 != controllerId)).head());
        TopicPartition tp = new TopicPartition("t", 0);
        Map assignment = (Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp.partition())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{otherBrokerId})))}));
        TestUtils$.MODULE$.createTopic(this.zkClient(), tp.topic(), (Map<Object, Seq<Object>>)assignment, this.servers());
        this.waitForPartitionState(tp, this.firstControllerEpoch(), otherBrokerId, LeaderAndIsr$.MODULE$.initialLeaderEpoch(), "failed to get expected partition state upon topic creation");
        ((KafkaServer)this.servers().apply(otherBrokerId)).shutdown();
        ((KafkaServer)this.servers().apply(otherBrokerId)).awaitShutdown();
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ControllerIntegrationTest.$anonfun$testLeaderAndIsrWhenEntireIsrOfflineAndUncleanLeaderElectionDisabled$3(this, tp, otherBrokerId)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ControllerIntegrationTest.$anonfun$testLeaderAndIsrWhenEntireIsrOfflineAndUncleanLeaderElectionDisabled$4());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testLeaderAndIsrWhenEntireIsrOfflineAndUncleanLeaderElectionEnabled() {
        int x$1 = 2;
        boolean x$2 = true;
        boolean x$3 = this.makeServers$default$2();
        boolean x$4 = this.makeServers$default$4();
        Option<String> x$5 = this.makeServers$default$5();
        Option<String> x$6 = this.makeServers$default$6();
        Option<String> x$7 = this.makeServers$default$7();
        Option<ApiVersion> x$8 = this.makeServers$default$8();
        int x$9 = this.makeServers$default$9();
        int x$10 = this.makeServers$default$10();
        this.servers_$eq(this.makeServers(x$1, x$3, x$2, x$4, x$5, x$6, x$7, x$8, x$9, x$10));
        int controllerId = TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), TestUtils$.MODULE$.waitUntilControllerElected$default$2());
        int otherBrokerId = BoxesRunTime.unboxToInt((Object)((IterableLike)((TraversableLike)this.servers().map((Function1 & Serializable & scala.Serializable)x$22 -> BoxesRunTime.boxToInteger((int)ControllerIntegrationTest.$anonfun$testLeaderAndIsrWhenEntireIsrOfflineAndUncleanLeaderElectionEnabled$1(x$22)), Seq$.MODULE$.canBuildFrom())).filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$23 -> x$23 != controllerId)).head());
        TopicPartition tp = new TopicPartition("t", 0);
        Map assignment = (Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp.partition())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{otherBrokerId})))}));
        TestUtils$.MODULE$.createTopic(this.zkClient(), tp.topic(), (Map<Object, Seq<Object>>)assignment, this.servers());
        this.waitForPartitionState(tp, this.firstControllerEpoch(), otherBrokerId, LeaderAndIsr$.MODULE$.initialLeaderEpoch(), "failed to get expected partition state upon topic creation");
        ((KafkaServer)this.servers().apply(otherBrokerId)).shutdown();
        ((KafkaServer)this.servers().apply(otherBrokerId)).awaitShutdown();
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ControllerIntegrationTest.$anonfun$testLeaderAndIsrWhenEntireIsrOfflineAndUncleanLeaderElectionEnabled$3(this, tp, otherBrokerId)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ControllerIntegrationTest.$anonfun$testLeaderAndIsrWhenEntireIsrOfflineAndUncleanLeaderElectionEnabled$4());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testControlledShutdown() {
        void var14_17;
        Map expectedReplicaAssignment = (Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2})))}));
        String topic = "test";
        int partition = 0;
        Seq serverConfigs = (Seq)TestUtils$.MODULE$.createBrokerConfigs(3, this.zkConnect(), false, TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13(), TestUtils$.MODULE$.createBrokerConfigs$default$14(), TestUtils$.MODULE$.createBrokerConfigs$default$15(), TestUtils$.MODULE$.createBrokerConfigs$default$16(), TestUtils$.MODULE$.createBrokerConfigs$default$17()).map((Function1 & Serializable & scala.Serializable)props -> KafkaConfig$.MODULE$.fromProps(props), Seq$.MODULE$.canBuildFrom());
        this.servers_$eq((Seq<KafkaServer>)((Seq)((TraversableLike)serverConfigs.reverse()).map((Function1 & Serializable & scala.Serializable)s -> TestUtils$.MODULE$.createServer((KafkaConfig)s, TestUtils$.MODULE$.createServer$default$2()), Seq$.MODULE$.canBuildFrom())));
        TestUtils$.MODULE$.createTopic(this.zkClient(), topic, (Map<Object, Seq<Object>>)expectedReplicaAssignment, this.servers());
        int controllerId = BoxesRunTime.unboxToInt((Object)this.zkClient().getControllerId().get());
        KafkaController controller = ((KafkaServer)this.servers().find((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)ControllerIntegrationTest.$anonfun$testControlledShutdown$3(controllerId, p))).get()).kafkaController();
        LinkedBlockingQueue resultQueue = new LinkedBlockingQueue();
        Function1 & Serializable & scala.Serializable controlledShutdownCallback = (Function1 & Serializable & scala.Serializable)controlledShutdownResult -> {
            resultQueue.put(controlledShutdownResult);
            return BoxedUnit.UNIT;
        };
        controller.controlledShutdown(2, ((KafkaServer)this.servers().find((Function1 & Serializable & scala.Serializable)x$24 -> BoxesRunTime.boxToBoolean((boolean)ControllerIntegrationTest.$anonfun$testControlledShutdown$5(x$24))).get()).kafkaController().brokerEpoch(), (Function1)controlledShutdownCallback);
        Set partitionsRemaining = (Set)((Try)resultQueue.take()).get();
        ObjectRef activeServers = ObjectRef.create((Object)((Seq)this.servers().filter((Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToBoolean((boolean)ControllerIntegrationTest.$anonfun$testControlledShutdown$6(s)))));
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ControllerIntegrationTest.$anonfun$testControlledShutdown$7(activeServers, topic, partition)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ControllerIntegrationTest.$anonfun$testControlledShutdown$9());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Assertions.assertEquals((int)0, (int)partitionsRemaining.size());
        UpdateMetadataRequestData.UpdateMetadataPartitionState partitionStateInfo = (UpdateMetadataRequestData.UpdateMetadataPartitionState)((KafkaServer)((Seq)activeServers.elem).head()).dataPlaneRequestProcessor().metadataCache().getPartitionInfo(topic, partition).get();
        int leaderAfterShutdown = partitionStateInfo.leader();
        Assertions.assertEquals((int)0, (int)leaderAfterShutdown);
        Assertions.assertEquals((int)2, (int)partitionStateInfo.isr().size());
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1})), (Object)CollectionConverters$.MODULE$.asScalaBufferConverter(partitionStateInfo.isr()).asScala());
        controller.controlledShutdown(1, ((KafkaServer)this.servers().find((Function1 & Serializable & scala.Serializable)x$26 -> BoxesRunTime.boxToBoolean((boolean)ControllerIntegrationTest.$anonfun$testControlledShutdown$10(x$26))).get()).kafkaController().brokerEpoch(), (Function1)controlledShutdownCallback);
        Try try_ = (Try)resultQueue.take();
        if (!(try_ instanceof Success)) {
            if (try_ instanceof Failure) {
                Throwable exception = ((Failure)try_).exception();
                throw new AssertionError("Controlled shutdown failed due to error", exception);
            }
            throw new MatchError((Object)try_);
        }
        Set partitions = (Set)((Success)try_).value();
        partitionsRemaining = var14_17;
        Assertions.assertEquals((int)0, (int)partitionsRemaining.size());
        activeServers.elem = (Seq)this.servers().filter((Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToBoolean((boolean)ControllerIntegrationTest.$anonfun$testControlledShutdown$11(s)));
        partitionStateInfo = (UpdateMetadataRequestData.UpdateMetadataPartitionState)((KafkaServer)((Seq)activeServers.elem).head()).dataPlaneRequestProcessor().metadataCache().getPartitionInfo(topic, partition).get();
        leaderAfterShutdown = partitionStateInfo.leader();
        Assertions.assertEquals((int)0, (int)leaderAfterShutdown);
        Assertions.assertTrue((boolean)this.servers().forall((Function1 & Serializable & scala.Serializable)x$27 -> BoxesRunTime.boxToBoolean((boolean)ControllerIntegrationTest.$anonfun$testControlledShutdown$12(topic, partition, x$27))));
        controller.controlledShutdown(0, ((KafkaServer)this.servers().find((Function1 & Serializable & scala.Serializable)x$28 -> BoxesRunTime.boxToBoolean((boolean)ControllerIntegrationTest.$anonfun$testControlledShutdown$13(x$28))).get()).kafkaController().brokerEpoch(), (Function1)controlledShutdownCallback);
        partitionsRemaining = (Set)((Try)resultQueue.take()).get();
        Assertions.assertEquals((int)1, (int)partitionsRemaining.size());
        Assertions.assertTrue((boolean)this.servers().forall((Function1 & Serializable & scala.Serializable)x$29 -> BoxesRunTime.boxToBoolean((boolean)ControllerIntegrationTest.$anonfun$testControlledShutdown$14(topic, partition, x$29))));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testControllerRejectControlledShutdownRequestWithStaleBrokerEpoch() {
        Seq serverConfigs = (Seq)TestUtils$.MODULE$.createBrokerConfigs(2, this.zkConnect(), false, TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13(), TestUtils$.MODULE$.createBrokerConfigs$default$14(), TestUtils$.MODULE$.createBrokerConfigs$default$15(), TestUtils$.MODULE$.createBrokerConfigs$default$16(), TestUtils$.MODULE$.createBrokerConfigs$default$17()).map((Function1 & Serializable & scala.Serializable)props -> KafkaConfig$.MODULE$.fromProps(props), Seq$.MODULE$.canBuildFrom());
        this.servers_$eq((Seq<KafkaServer>)((Seq)((TraversableLike)serverConfigs.reverse()).map((Function1 & Serializable & scala.Serializable)s -> TestUtils$.MODULE$.createServer((KafkaConfig)s, TestUtils$.MODULE$.createServer$default$2()), Seq$.MODULE$.canBuildFrom())));
        KafkaController controller = this.getController().kafkaController();
        KafkaServer otherBroker = (KafkaServer)this.servers().find((Function1 & Serializable & scala.Serializable)e -> BoxesRunTime.boxToBoolean((boolean)ControllerIntegrationTest.$anonfun$testControllerRejectControlledShutdownRequestWithStaleBrokerEpoch$3(controller, e))).get();
        VolatileBooleanRef staleBrokerEpochDetected = VolatileBooleanRef.create((boolean)false);
        controller.controlledShutdown(otherBroker.config().brokerId(), otherBroker.kafkaController().brokerEpoch() - 1L, (Function1 & Serializable & scala.Serializable)x0$1 -> {
            ControllerIntegrationTest.$anonfun$testControllerRejectControlledShutdownRequestWithStaleBrokerEpoch$4(staleBrokerEpochDetected, x0$1);
            return BoxedUnit.UNIT;
        });
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!staleBrokerEpochDetected.elem) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ControllerIntegrationTest.$anonfun$testControllerRejectControlledShutdownRequestWithStaleBrokerEpoch$6());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testControllerMoveOnTopicCreation() {
        this.servers_$eq(this.makeServers(1, this.makeServers$default$2(), this.makeServers$default$3(), this.makeServers$default$4(), this.makeServers$default$5(), this.makeServers$default$6(), this.makeServers$default$7(), this.makeServers$default$8(), this.makeServers$default$9(), this.makeServers$default$10()));
        TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), TestUtils$.MODULE$.waitUntilControllerElected$default$2());
        TopicPartition tp = new TopicPartition("t", 0);
        Map assignment = (Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp.partition())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})))}));
        KafkaController testControllerMove_controller = this.getController().kafkaController();
        LogCaptureAppender testControllerMove_appender = LogCaptureAppender$.MODULE$.createAndRegister();
        Level testControllerMove_previousLevel = LogCaptureAppender$.MODULE$.setClassLoggerLevel(testControllerMove_controller.getClass(), Level.INFO);
        try {
            long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
            long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
            if (TestUtils$.MODULE$ == null) {
                throw null;
            }
            long testControllerMove_waitUntilTrue_startTime = System.currentTimeMillis();
            while (!ControllerIntegrationTest.$anonfun$testControllerMove$1(testControllerMove_controller)) {
                void testControllerMove_waitUntilTrue_pause;
                void testControllerMove_waitUntilTrue_waitTimeMs;
                if (System.currentTimeMillis() > testControllerMove_waitUntilTrue_startTime + testControllerMove_waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)ControllerIntegrationTest.$anonfun$testControllerMove$2());
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)testControllerMove_waitUntilTrue_waitTimeMs), (long)testControllerMove_waitUntilTrue_pause));
            }
            CountDownLatch testControllerMove_latch = new CountDownLatch(1);
            testControllerMove_controller.eventManager().put((ControllerEvent)new MockEvent(null, testControllerMove_latch){
                private final CountDownLatch latch$6;

                public void process() {
                    this.latch$6.await();
                }

                public void preempt() {
                }
                {
                    this.latch$6 = latch$6;
                    super((ControllerState)ControllerState.TopicChange$.MODULE$);
                }
            });
            ControllerIntegrationTest.$anonfun$testControllerMoveOnTopicCreation$1(this, tp, assignment);
            this.zkClient().deleteController(testControllerMove_controller.controllerContext().epochZkVersion());
            this.zkClient().registerControllerAndIncrementControllerEpoch(this.servers().size());
            testControllerMove_latch.countDown();
            long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
            long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
            if (TestUtils$.MODULE$ == null) {
                throw null;
            }
            long testControllerMove_waitUntilTrue_startTime2 = System.currentTimeMillis();
            while (!ControllerIntegrationTest.$anonfun$testControllerMove$3(testControllerMove_controller)) {
                void testControllerMove_waitUntilTrue_pause;
                void testControllerMove_waitUntilTrue_waitTimeMs;
                if (System.currentTimeMillis() > testControllerMove_waitUntilTrue_startTime2 + testControllerMove_waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)ControllerIntegrationTest.$anonfun$testControllerMove$4());
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)testControllerMove_waitUntilTrue_waitTimeMs), (long)testControllerMove_waitUntilTrue_pause));
            }
            Assertions.assertTrue((boolean)testControllerMove_appender.getMessages().find((Function1 & Serializable & scala.Serializable)e -> BoxesRunTime.boxToBoolean((boolean)ControllerIntegrationTest.$anonfun$testControllerMove$5(e))).isDefined());
        }
        finally {
            LogCaptureAppender$.MODULE$.unregister(testControllerMove_appender);
            LogCaptureAppender$.MODULE$.setClassLoggerLevel(testControllerMove_controller.eventManager().thread().getClass(), testControllerMove_previousLevel);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testControllerMoveOnTopicDeletion() {
        this.servers_$eq(this.makeServers(1, this.makeServers$default$2(), this.makeServers$default$3(), this.makeServers$default$4(), this.makeServers$default$5(), this.makeServers$default$6(), this.makeServers$default$7(), this.makeServers$default$8(), this.makeServers$default$9(), this.makeServers$default$10()));
        TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), TestUtils$.MODULE$.waitUntilControllerElected$default$2());
        TopicPartition tp = new TopicPartition("t", 0);
        Map assignment = (Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp.partition())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})))}));
        TestUtils$.MODULE$.createTopic(this.zkClient(), tp.topic(), (Map<Object, Seq<Object>>)assignment, this.servers());
        KafkaController testControllerMove_controller = this.getController().kafkaController();
        LogCaptureAppender testControllerMove_appender = LogCaptureAppender$.MODULE$.createAndRegister();
        Level testControllerMove_previousLevel = LogCaptureAppender$.MODULE$.setClassLoggerLevel(testControllerMove_controller.getClass(), Level.INFO);
        try {
            long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
            long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
            if (TestUtils$.MODULE$ == null) {
                throw null;
            }
            long testControllerMove_waitUntilTrue_startTime = System.currentTimeMillis();
            while (!ControllerIntegrationTest.$anonfun$testControllerMove$1(testControllerMove_controller)) {
                void testControllerMove_waitUntilTrue_pause;
                void testControllerMove_waitUntilTrue_waitTimeMs;
                if (System.currentTimeMillis() > testControllerMove_waitUntilTrue_startTime + testControllerMove_waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)ControllerIntegrationTest.$anonfun$testControllerMove$2());
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)testControllerMove_waitUntilTrue_waitTimeMs), (long)testControllerMove_waitUntilTrue_pause));
            }
            CountDownLatch testControllerMove_latch = new CountDownLatch(1);
            testControllerMove_controller.eventManager().put((ControllerEvent)new /* invalid duplicate definition of identical inner class */);
            ControllerIntegrationTest.$anonfun$testControllerMoveOnTopicDeletion$1(this, tp);
            this.zkClient().deleteController(testControllerMove_controller.controllerContext().epochZkVersion());
            this.zkClient().registerControllerAndIncrementControllerEpoch(this.servers().size());
            testControllerMove_latch.countDown();
            long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
            long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
            if (TestUtils$.MODULE$ == null) {
                throw null;
            }
            long testControllerMove_waitUntilTrue_startTime2 = System.currentTimeMillis();
            while (!ControllerIntegrationTest.$anonfun$testControllerMove$3(testControllerMove_controller)) {
                void testControllerMove_waitUntilTrue_pause;
                void testControllerMove_waitUntilTrue_waitTimeMs;
                if (System.currentTimeMillis() > testControllerMove_waitUntilTrue_startTime2 + testControllerMove_waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)ControllerIntegrationTest.$anonfun$testControllerMove$4());
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)testControllerMove_waitUntilTrue_waitTimeMs), (long)testControllerMove_waitUntilTrue_pause));
            }
            Assertions.assertTrue((boolean)testControllerMove_appender.getMessages().find((Function1 & Serializable & scala.Serializable)e -> BoxesRunTime.boxToBoolean((boolean)ControllerIntegrationTest.$anonfun$testControllerMove$5(e))).isDefined());
        }
        finally {
            LogCaptureAppender$.MODULE$.unregister(testControllerMove_appender);
            LogCaptureAppender$.MODULE$.setClassLoggerLevel(testControllerMove_controller.eventManager().thread().getClass(), testControllerMove_previousLevel);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testControllerMoveOnPreferredReplicaElection() {
        this.servers_$eq(this.makeServers(1, this.makeServers$default$2(), this.makeServers$default$3(), this.makeServers$default$4(), this.makeServers$default$5(), this.makeServers$default$6(), this.makeServers$default$7(), this.makeServers$default$8(), this.makeServers$default$9(), this.makeServers$default$10()));
        TopicPartition tp = new TopicPartition("t", 0);
        Map assignment = (Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp.partition())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})))}));
        TestUtils$.MODULE$.createTopic(this.zkClient(), tp.topic(), (Map<Object, Seq<Object>>)assignment, this.servers());
        KafkaController testControllerMove_controller = this.getController().kafkaController();
        LogCaptureAppender testControllerMove_appender = LogCaptureAppender$.MODULE$.createAndRegister();
        Level testControllerMove_previousLevel = LogCaptureAppender$.MODULE$.setClassLoggerLevel(testControllerMove_controller.getClass(), Level.INFO);
        try {
            long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
            long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
            if (TestUtils$.MODULE$ == null) {
                throw null;
            }
            long testControllerMove_waitUntilTrue_startTime = System.currentTimeMillis();
            while (!ControllerIntegrationTest.$anonfun$testControllerMove$1(testControllerMove_controller)) {
                void testControllerMove_waitUntilTrue_pause;
                void testControllerMove_waitUntilTrue_waitTimeMs;
                if (System.currentTimeMillis() > testControllerMove_waitUntilTrue_startTime + testControllerMove_waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)ControllerIntegrationTest.$anonfun$testControllerMove$2());
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)testControllerMove_waitUntilTrue_waitTimeMs), (long)testControllerMove_waitUntilTrue_pause));
            }
            CountDownLatch testControllerMove_latch = new CountDownLatch(1);
            testControllerMove_controller.eventManager().put((ControllerEvent)new /* invalid duplicate definition of identical inner class */);
            ControllerIntegrationTest.$anonfun$testControllerMoveOnPreferredReplicaElection$1(this, tp);
            this.zkClient().deleteController(testControllerMove_controller.controllerContext().epochZkVersion());
            this.zkClient().registerControllerAndIncrementControllerEpoch(this.servers().size());
            testControllerMove_latch.countDown();
            long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
            long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
            if (TestUtils$.MODULE$ == null) {
                throw null;
            }
            long testControllerMove_waitUntilTrue_startTime2 = System.currentTimeMillis();
            while (!ControllerIntegrationTest.$anonfun$testControllerMove$3(testControllerMove_controller)) {
                void testControllerMove_waitUntilTrue_pause;
                void testControllerMove_waitUntilTrue_waitTimeMs;
                if (System.currentTimeMillis() > testControllerMove_waitUntilTrue_startTime2 + testControllerMove_waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)ControllerIntegrationTest.$anonfun$testControllerMove$4());
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)testControllerMove_waitUntilTrue_waitTimeMs), (long)testControllerMove_waitUntilTrue_pause));
            }
            Assertions.assertTrue((boolean)testControllerMove_appender.getMessages().find((Function1 & Serializable & scala.Serializable)e -> BoxesRunTime.boxToBoolean((boolean)ControllerIntegrationTest.$anonfun$testControllerMove$5(e))).isDefined());
        }
        finally {
            LogCaptureAppender$.MODULE$.unregister(testControllerMove_appender);
            LogCaptureAppender$.MODULE$.setClassLoggerLevel(testControllerMove_controller.eventManager().thread().getClass(), testControllerMove_previousLevel);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testControllerMoveOnPartitionReassignment() {
        this.servers_$eq(this.makeServers(1, this.makeServers$default$2(), this.makeServers$default$3(), this.makeServers$default$4(), this.makeServers$default$5(), this.makeServers$default$6(), this.makeServers$default$7(), this.makeServers$default$8(), this.makeServers$default$9(), this.makeServers$default$10()));
        TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), TestUtils$.MODULE$.waitUntilControllerElected$default$2());
        TopicPartition tp = new TopicPartition("t", 0);
        Map assignment = (Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp.partition())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})))}));
        TestUtils$.MODULE$.createTopic(this.zkClient(), tp.topic(), (Map<Object, Seq<Object>>)assignment, this.servers());
        Map reassignment = (Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})))}));
        KafkaController testControllerMove_controller = this.getController().kafkaController();
        LogCaptureAppender testControllerMove_appender = LogCaptureAppender$.MODULE$.createAndRegister();
        Level testControllerMove_previousLevel = LogCaptureAppender$.MODULE$.setClassLoggerLevel(testControllerMove_controller.getClass(), Level.INFO);
        try {
            long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
            long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
            if (TestUtils$.MODULE$ == null) {
                throw null;
            }
            long testControllerMove_waitUntilTrue_startTime = System.currentTimeMillis();
            while (!ControllerIntegrationTest.$anonfun$testControllerMove$1(testControllerMove_controller)) {
                void testControllerMove_waitUntilTrue_pause;
                void testControllerMove_waitUntilTrue_waitTimeMs;
                if (System.currentTimeMillis() > testControllerMove_waitUntilTrue_startTime + testControllerMove_waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)ControllerIntegrationTest.$anonfun$testControllerMove$2());
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)testControllerMove_waitUntilTrue_waitTimeMs), (long)testControllerMove_waitUntilTrue_pause));
            }
            CountDownLatch testControllerMove_latch = new CountDownLatch(1);
            testControllerMove_controller.eventManager().put((ControllerEvent)new /* invalid duplicate definition of identical inner class */);
            ControllerIntegrationTest.$anonfun$testControllerMoveOnPartitionReassignment$1(this, reassignment);
            this.zkClient().deleteController(testControllerMove_controller.controllerContext().epochZkVersion());
            this.zkClient().registerControllerAndIncrementControllerEpoch(this.servers().size());
            testControllerMove_latch.countDown();
            long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
            long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
            if (TestUtils$.MODULE$ == null) {
                throw null;
            }
            long testControllerMove_waitUntilTrue_startTime2 = System.currentTimeMillis();
            while (!ControllerIntegrationTest.$anonfun$testControllerMove$3(testControllerMove_controller)) {
                void testControllerMove_waitUntilTrue_pause;
                void testControllerMove_waitUntilTrue_waitTimeMs;
                if (System.currentTimeMillis() > testControllerMove_waitUntilTrue_startTime2 + testControllerMove_waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)ControllerIntegrationTest.$anonfun$testControllerMove$4());
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)testControllerMove_waitUntilTrue_waitTimeMs), (long)testControllerMove_waitUntilTrue_pause));
            }
            Assertions.assertTrue((boolean)testControllerMove_appender.getMessages().find((Function1 & Serializable & scala.Serializable)e -> BoxesRunTime.boxToBoolean((boolean)ControllerIntegrationTest.$anonfun$testControllerMove$5(e))).isDefined());
        }
        finally {
            LogCaptureAppender$.MODULE$.unregister(testControllerMove_appender);
            LogCaptureAppender$.MODULE$.setClassLoggerLevel(testControllerMove_controller.eventManager().thread().getClass(), testControllerMove_previousLevel);
        }
    }

    @Test
    public void testControllerFeatureZNodeSetupWhenFeatureVersioningIsEnabledWithNonExistingFeatureZNode() {
        this.testControllerFeatureZNodeSetup((Option<FeatureZNode>)Option$.MODULE$.empty(), (ApiVersion)KAFKA_2_7_IV0$.MODULE$);
    }

    @Test
    public void testControllerFeatureZNodeSetupWhenFeatureVersioningIsEnabledWithDisabledExistingFeatureZNode() {
        this.testControllerFeatureZNodeSetup((Option<FeatureZNode>)new Some((Object)new FeatureZNode((FeatureZNodeStatus)FeatureZNodeStatus.Disabled$.MODULE$, Features.emptyFinalizedFeatures())), (ApiVersion)KAFKA_2_7_IV0$.MODULE$);
    }

    @Test
    public void testControllerFeatureZNodeSetupWhenFeatureVersioningIsEnabledWithEnabledExistingFeatureZNode() {
        this.testControllerFeatureZNodeSetup((Option<FeatureZNode>)new Some((Object)new FeatureZNode((FeatureZNodeStatus)FeatureZNodeStatus.Enabled$.MODULE$, Features.emptyFinalizedFeatures())), (ApiVersion)KAFKA_2_7_IV0$.MODULE$);
    }

    @Test
    public void testControllerFeatureZNodeSetupWhenFeatureVersioningIsDisabledWithNonExistingFeatureZNode() {
        this.testControllerFeatureZNodeSetup((Option<FeatureZNode>)Option$.MODULE$.empty(), (ApiVersion)KAFKA_2_6_IV0$.MODULE$);
    }

    @Test
    public void testControllerFeatureZNodeSetupWhenFeatureVersioningIsDisabledWithDisabledExistingFeatureZNode() {
        this.testControllerFeatureZNodeSetup((Option<FeatureZNode>)new Some((Object)new FeatureZNode((FeatureZNodeStatus)FeatureZNodeStatus.Disabled$.MODULE$, Features.emptyFinalizedFeatures())), (ApiVersion)KAFKA_2_6_IV0$.MODULE$);
    }

    @Test
    public void testControllerFeatureZNodeSetupWhenFeatureVersioningIsDisabledWithEnabledExistingFeatureZNode() {
        this.testControllerFeatureZNodeSetup((Option<FeatureZNode>)new Some((Object)new FeatureZNode((FeatureZNodeStatus)FeatureZNodeStatus.Enabled$.MODULE$, Features.emptyFinalizedFeatures())), (ApiVersion)KAFKA_2_6_IV0$.MODULE$);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testControllerDetectsBouncedBrokers() {
        int x$1 = 2;
        boolean x$2 = false;
        boolean x$3 = this.makeServers$default$2();
        boolean x$4 = this.makeServers$default$3();
        Option<String> x$5 = this.makeServers$default$5();
        Option<String> x$6 = this.makeServers$default$6();
        Option<String> x$7 = this.makeServers$default$7();
        Option<ApiVersion> x$8 = this.makeServers$default$8();
        int x$9 = this.makeServers$default$9();
        int x$10 = this.makeServers$default$10();
        this.servers_$eq(this.makeServers(x$1, x$3, x$4, x$2, x$5, x$6, x$7, x$8, x$9, x$10));
        KafkaController controller = this.getController().kafkaController();
        KafkaServer otherBroker = (KafkaServer)this.servers().find((Function1 & Serializable & scala.Serializable)e -> BoxesRunTime.boxToBoolean((boolean)ControllerIntegrationTest.$anonfun$testControllerDetectsBouncedBrokers$1(controller, e))).get();
        TopicPartition tp = new TopicPartition("t", 0);
        Map assignment = (Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp.partition())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1})))}));
        TestUtils$.MODULE$.createTopic(this.zkClient(), tp.topic(), (Map<Object, Seq<Object>>)assignment, this.servers());
        this.waitForPartitionState(tp, this.firstControllerEpoch(), 0, LeaderAndIsr$.MODULE$.initialLeaderEpoch(), "failed to get expected partition state upon topic creation");
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ControllerIntegrationTest.$anonfun$testControllerDetectsBouncedBrokers$2(controller)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ControllerIntegrationTest.$anonfun$testControllerDetectsBouncedBrokers$3());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        CountDownLatch latch = new CountDownLatch(1);
        controller.eventManager().put((ControllerEvent)new MockEvent(null, latch){
            private final CountDownLatch latch$1;

            public void process() {
                this.latch$1.await();
            }

            public void preempt() {
            }
            {
                this.latch$1 = latch$1;
                super((ControllerState)ControllerState.TopicChange$.MODULE$);
            }
        });
        otherBroker.shutdown();
        otherBroker.startup();
        Assertions.assertEquals((int)0, (int)BoxesRunTime.unboxToInt((Object)otherBroker.replicaManager().partitionCount().value()));
        latch.countDown();
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!ControllerIntegrationTest.$anonfun$testControllerDetectsBouncedBrokers$4(otherBroker)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ControllerIntegrationTest.$anonfun$testControllerDetectsBouncedBrokers$5());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testPreemptionOnControllerShutdown() {
        int x$1 = 1;
        boolean x$2 = false;
        boolean x$3 = this.makeServers$default$2();
        boolean x$4 = this.makeServers$default$3();
        Option<String> x$5 = this.makeServers$default$5();
        Option<String> x$6 = this.makeServers$default$6();
        Option<String> x$7 = this.makeServers$default$7();
        Option<ApiVersion> x$8 = this.makeServers$default$8();
        int x$9 = this.makeServers$default$9();
        int x$10 = this.makeServers$default$10();
        this.servers_$eq(this.makeServers(x$1, x$3, x$4, x$2, x$5, x$6, x$7, x$8, x$9, x$10));
        KafkaController controller = this.getController().kafkaController();
        IntRef count = IntRef.create((int)2);
        CountDownLatch latch = new CountDownLatch(1);
        ControllerEventManager.ControllerEventThread spyThread = (ControllerEventManager.ControllerEventThread)Mockito.spy((Object)controller.eventManager().thread());
        controller.eventManager().thread_$eq(spyThread);
        MockEvent processedEvent = new MockEvent(null, latch){
            private final CountDownLatch latch$2;

            public void process() {
                this.latch$2.await();
            }

            public void preempt() {
            }
            {
                this.latch$2 = latch$2;
                super((ControllerState)ControllerState.TopicChange$.MODULE$);
            }
        };
        MockEvent preemptedEvent = new MockEvent(null, count){
            private final IntRef count$1;

            public void process() {
            }

            public void preempt() {
                --this.count$1.elem;
            }
            {
                this.count$1 = count$1;
                super((ControllerState)ControllerState.TopicChange$.MODULE$);
            }
        };
        controller.eventManager().put((ControllerEvent)processedEvent);
        controller.eventManager().put((ControllerEvent)preemptedEvent);
        controller.eventManager().put((ControllerEvent)preemptedEvent);
        ((ShutdownableThread)Mockito.doAnswer(x$30 -> {
            latch.countDown();
            return BoxedUnit.UNIT;
        }).doCallRealMethod().when((Object)spyThread)).awaitShutdown();
        controller.shutdown();
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ControllerIntegrationTest.$anonfun$testPreemptionOnControllerShutdown$2(count)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ControllerIntegrationTest.$anonfun$testPreemptionOnControllerShutdown$3());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        ((ShutdownableThread)Mockito.verify((Object)spyThread)).awaitShutdown();
    }

    @Test
    public void testPreemptionWithCallbacks() {
        int x$1 = 1;
        boolean x$2 = false;
        boolean x$3 = this.makeServers$default$2();
        boolean x$4 = this.makeServers$default$3();
        Option<String> x$5 = this.makeServers$default$5();
        Option<String> x$6 = this.makeServers$default$6();
        Option<String> x$7 = this.makeServers$default$7();
        Option<ApiVersion> x$8 = this.makeServers$default$8();
        int x$9 = this.makeServers$default$9();
        int x$10 = this.makeServers$default$10();
        this.servers_$eq(this.makeServers(x$1, x$3, x$4, x$2, x$5, x$6, x$7, x$8, x$9, x$10));
        KafkaController controller = this.getController().kafkaController();
        CountDownLatch latch = new CountDownLatch(1);
        ControllerEventManager.ControllerEventThread spyThread = (ControllerEventManager.ControllerEventThread)Mockito.spy((Object)controller.eventManager().thread());
        controller.eventManager().thread_$eq(spyThread);
        MockEvent processedEvent = new MockEvent(null, latch){
            private final CountDownLatch latch$3;

            public void process() {
                this.latch$3.await();
            }

            public void preempt() {
            }
            {
                this.latch$3 = latch$3;
                super((ControllerState)ControllerState.TopicChange$.MODULE$);
            }
        };
        TopicPartition tp0 = new TopicPartition("t", 0);
        TopicPartition tp1 = new TopicPartition("t", 1);
        scala.collection.immutable.Set partitions = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp0, tp1}));
        ReplicaLeaderElection event1 = new ReplicaLeaderElection((Option)new Some((Object)partitions), ElectionType.PREFERRED, (ElectionTrigger)ZkTriggered$.MODULE$, (Function1 & Serializable & scala.Serializable)partitionsMap -> {
            partitionsMap.foreach((Function1 & Serializable & scala.Serializable)partition -> {
                ControllerIntegrationTest.$anonfun$testPreemptionWithCallbacks$2(partition);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        });
        ControlledShutdown event2 = new ControlledShutdown(0, 0L, (Function1 & Serializable & scala.Serializable)x0$1 -> {
            ControllerIntegrationTest.$anonfun$testPreemptionWithCallbacks$3(x0$1);
            return BoxedUnit.UNIT;
        });
        ApiPartitionReassignment event3 = new ApiPartitionReassignment((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp0), (Object)None$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), (Object)None$.MODULE$)})), (Function1 & Serializable & scala.Serializable)x0$2 -> {
            ControllerIntegrationTest.$anonfun$testPreemptionWithCallbacks$4(x0$2);
            return BoxedUnit.UNIT;
        });
        ListPartitionReassignments event4 = new ListPartitionReassignments((Option)new Some((Object)partitions), (Function1 & Serializable & scala.Serializable)x0$3 -> {
            ControllerIntegrationTest.$anonfun$testPreemptionWithCallbacks$5(x0$3);
            return BoxedUnit.UNIT;
        });
        controller.eventManager().put((ControllerEvent)processedEvent);
        controller.eventManager().put((ControllerEvent)event1);
        controller.eventManager().put((ControllerEvent)event2);
        controller.eventManager().put((ControllerEvent)event3);
        controller.eventManager().put((ControllerEvent)event4);
        ((ShutdownableThread)Mockito.doAnswer(x$31 -> {
            latch.countDown();
            return BoxedUnit.UNIT;
        }).doCallRealMethod().when((Object)spyThread)).awaitShutdown();
        controller.shutdown();
    }

    /*
     * WARNING - void declaration
     */
    private void testControllerFeatureZNodeSetup(Option<FeatureZNode> initialZNode, ApiVersion interBrokerProtocolVersion) {
        void var18_18;
        Option option;
        if (initialZNode instanceof Some) {
            FeatureZNode node = (FeatureZNode)((Some)initialZNode).value();
            this.zkClient().createFeatureZNode(node);
            option = new Some((Object)BoxesRunTime.boxToInteger((int)this.zkClient().getDataAndVersion(FeatureZNode$.MODULE$.path())._2$mcI$sp()));
        } else if (None$.MODULE$.equals(initialZNode)) {
            option = Option$.MODULE$.empty();
        } else {
            throw new MatchError(initialZNode);
        }
        int x$1 = 1;
        Some x$2 = new Some((Object)interBrokerProtocolVersion);
        boolean x$3 = this.makeServers$default$2();
        boolean x$4 = this.makeServers$default$3();
        boolean x$5 = this.makeServers$default$4();
        Option<String> x$6 = this.makeServers$default$5();
        Option<String> x$7 = this.makeServers$default$6();
        Option<String> x$8 = this.makeServers$default$7();
        int x$9 = this.makeServers$default$9();
        int x$10 = this.makeServers$default$10();
        this.servers_$eq(this.makeServers(x$1, x$3, x$4, x$5, x$6, x$7, x$8, (Option<ApiVersion>)x$2, x$9, x$10));
        TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), TestUtils$.MODULE$.waitUntilControllerElected$default$2());
        KafkaController controller = this.getController().kafkaController();
        CountDownLatch latch = new CountDownLatch(1);
        controller.eventManager().put((ControllerEvent)new MockEvent(null, latch){
            private final CountDownLatch latch$4;

            public void process() {
                this.latch$4.countDown();
            }

            public void preempt() {
            }
            {
                this.latch$4 = latch$4;
                super((ControllerState)ControllerState.TopicChange$.MODULE$);
            }
        });
        latch.await();
        Tuple2 tuple2 = this.zkClient().getDataAndVersion(FeatureZNode$.MODULE$.path());
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Option mayBeFeatureZNodeBytes = (Option)tuple2._1();
        int n = tuple2._2$mcI$sp();
        FeatureZNode newZNode = FeatureZNode$.MODULE$.decode((byte[])var18_18.get());
        if (interBrokerProtocolVersion.$greater$eq((Object)KAFKA_2_7_IV0$.MODULE$)) {
            FeatureZNode emptyZNode = new FeatureZNode((FeatureZNodeStatus)FeatureZNodeStatus.Enabled$.MODULE$, Features.emptyFinalizedFeatures());
            if (initialZNode instanceof Some) {
                FeatureZNode node = (FeatureZNode)((Some)initialZNode).value();
                FeatureZNodeStatus featureZNodeStatus = node.status();
                if (FeatureZNodeStatus.Enabled$.MODULE$.equals(featureZNodeStatus)) {
                    Assertions.assertEquals((int)BoxesRunTime.unboxToInt((Object)option.get()), (int)n);
                    Assertions.assertEquals((Object)node, (Object)newZNode);
                    return;
                }
                if (FeatureZNodeStatus.Disabled$.MODULE$.equals(featureZNodeStatus)) {
                    Assertions.assertEquals((int)(BoxesRunTime.unboxToInt((Object)option.get()) + 1), (int)n);
                    Assertions.assertEquals((Object)emptyZNode, (Object)newZNode);
                    return;
                }
                throw new MatchError((Object)featureZNodeStatus);
            }
            if (None$.MODULE$.equals(initialZNode)) {
                Assertions.assertEquals((int)0, (int)n);
                Assertions.assertEquals((Object)new FeatureZNode((FeatureZNodeStatus)FeatureZNodeStatus.Enabled$.MODULE$, Features.emptyFinalizedFeatures()), (Object)newZNode);
                return;
            }
            throw new MatchError(initialZNode);
        }
        FeatureZNode emptyZNode = new FeatureZNode((FeatureZNodeStatus)FeatureZNodeStatus.Disabled$.MODULE$, Features.emptyFinalizedFeatures());
        if (initialZNode instanceof Some) {
            FeatureZNodeStatus featureZNodeStatus = ((FeatureZNode)((Some)initialZNode).value()).status();
            if (FeatureZNodeStatus.Enabled$.MODULE$.equals(featureZNodeStatus)) {
                Assertions.assertEquals((int)(BoxesRunTime.unboxToInt((Object)option.get()) + 1), (int)n);
                Assertions.assertEquals((Object)emptyZNode, (Object)newZNode);
                return;
            }
            if (FeatureZNodeStatus.Disabled$.MODULE$.equals(featureZNodeStatus)) {
                Assertions.assertEquals((int)BoxesRunTime.unboxToInt((Object)option.get()), (int)n);
                Assertions.assertEquals((Object)emptyZNode, (Object)newZNode);
                return;
            }
            throw new MatchError((Object)featureZNodeStatus);
        }
        if (None$.MODULE$.equals(initialZNode)) {
            Assertions.assertEquals((int)0, (int)n);
            Assertions.assertEquals((Object)new FeatureZNode((FeatureZNodeStatus)FeatureZNodeStatus.Disabled$.MODULE$, Features.emptyFinalizedFeatures()), (Object)newZNode);
            return;
        }
        throw new MatchError(initialZNode);
    }

    @Test
    public void testIdempotentAlterIsr() {
        this.servers_$eq(this.makeServers(2, this.makeServers$default$2(), this.makeServers$default$3(), this.makeServers$default$4(), this.makeServers$default$5(), this.makeServers$default$6(), this.makeServers$default$7(), this.makeServers$default$8(), this.makeServers$default$9(), this.makeServers$default$10()));
        int controllerId = TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), TestUtils$.MODULE$.waitUntilControllerElected$default$2());
        KafkaServer otherBroker = (KafkaServer)this.servers().find((Function1 & Serializable & scala.Serializable)x$33 -> BoxesRunTime.boxToBoolean((boolean)ControllerIntegrationTest.$anonfun$testIdempotentAlterIsr$1(controllerId, x$33))).get();
        TopicPartition tp = new TopicPartition("t", 0);
        Map assignment = (Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp.partition())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{otherBroker.config().brokerId(), controllerId})))}));
        TestUtils$.MODULE$.createTopic(this.zkClient(), tp.topic(), (Map<Object, Seq<Object>>)assignment, this.servers());
        CountDownLatch latch = new CountDownLatch(1);
        KafkaController controller = this.getController().kafkaController();
        LeaderAndIsr newLeaderAndIsr = ((LeaderIsrAndControllerEpoch)this.zkClient().getTopicPartitionStates((Seq)new .colon.colon((Object)tp, (List)Nil$.MODULE$)).apply((Object)tp)).leaderAndIsr();
        Function1 & Serializable & scala.Serializable callback = (Function1 & Serializable & scala.Serializable)result -> {
            ControllerIntegrationTest.$anonfun$testIdempotentAlterIsr$2(tp, newLeaderAndIsr, latch, result);
            return BoxedUnit.UNIT;
        };
        long brokerEpoch = BoxesRunTime.unboxToLong((Object)controller.controllerContext().liveBrokerIdAndEpochs().get((Object)BoxesRunTime.boxToInteger((int)otherBroker.config().brokerId())).get());
        controller.eventManager().put((ControllerEvent)new AlterIsrReceived(otherBroker.config().brokerId(), brokerEpoch, (Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)newLeaderAndIsr)})), (Function1)callback));
        latch.await();
    }

    @Test
    public void testAlterIsrErrors() {
        this.servers_$eq(this.makeServers(1, this.makeServers$default$2(), this.makeServers$default$3(), this.makeServers$default$4(), this.makeServers$default$5(), this.makeServers$default$6(), this.makeServers$default$7(), this.makeServers$default$8(), this.makeServers$default$9(), this.makeServers$default$10()));
        int controllerId = TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), TestUtils$.MODULE$.waitUntilControllerElected$default$2());
        TopicPartition tp = new TopicPartition("t", 0);
        Map assignment = (Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp.partition())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{controllerId})))}));
        TestUtils$.MODULE$.createTopic(this.zkClient(), tp.topic(), (Map<Object, Seq<Object>>)assignment, this.servers());
        KafkaController controller = this.getController().kafkaController();
        Errors capturedError = this.captureAlterIsrError(controllerId, controller.brokerEpoch() - 1L, (Map<TopicPartition, LeaderAndIsr>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)LeaderAndIsr$.MODULE$.apply(controllerId, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{controllerId}))))})))).get(5L, TimeUnit.SECONDS);
        Assertions.assertEquals((Object)Errors.STALE_BROKER_EPOCH, (Object)capturedError);
        capturedError = this.captureAlterIsrError(99, controller.brokerEpoch(), (Map<TopicPartition, LeaderAndIsr>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)LeaderAndIsr$.MODULE$.apply(controllerId, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{controllerId}))))})))).get(5L, TimeUnit.SECONDS);
        Assertions.assertEquals((Object)Errors.STALE_BROKER_EPOCH, (Object)capturedError);
        TopicPartition unknownTopicPartition = new TopicPartition("unknown", 99);
        capturedError = this.captureAlterIsrPartitionError(controllerId, controller.brokerEpoch(), (Map<TopicPartition, LeaderAndIsr>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)unknownTopicPartition), (Object)LeaderAndIsr$.MODULE$.apply(controllerId, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{controllerId}))))}))), unknownTopicPartition).get(5L, TimeUnit.SECONDS);
        Assertions.assertEquals((Object)Errors.UNKNOWN_TOPIC_OR_PARTITION, (Object)capturedError);
        capturedError = this.captureAlterIsrPartitionError(controllerId, controller.brokerEpoch(), (Map<TopicPartition, LeaderAndIsr>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)new LeaderAndIsr(controllerId, 1, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{controllerId})), 99))}))), tp).get(5L, TimeUnit.SECONDS);
        Assertions.assertEquals((Object)Errors.INVALID_UPDATE_VERSION, (Object)capturedError);
    }

    public CompletableFuture<Errors> captureAlterIsrError(int brokerId, long brokerEpoch, Map<TopicPartition, LeaderAndIsr> isrsToAlter) {
        CompletableFuture<Errors> future = new CompletableFuture<Errors>();
        KafkaController controller = this.getController().kafkaController();
        Function1 & Serializable & scala.Serializable callback = (Function1 & Serializable & scala.Serializable)x0$1 -> {
            ControllerIntegrationTest.$anonfun$captureAlterIsrError$1(future, x0$1);
            return BoxedUnit.UNIT;
        };
        controller.eventManager().put((ControllerEvent)new AlterIsrReceived(brokerId, brokerEpoch, isrsToAlter, (Function1)callback));
        return future;
    }

    public CompletableFuture<Errors> captureAlterIsrPartitionError(int brokerId, long brokerEpoch, Map<TopicPartition, LeaderAndIsr> isrsToAlter, TopicPartition tp) {
        CompletableFuture<Errors> future = new CompletableFuture<Errors>();
        KafkaController controller = this.getController().kafkaController();
        Function1 & Serializable & scala.Serializable callback = (Function1 & Serializable & scala.Serializable)x0$1 -> {
            ControllerIntegrationTest.$anonfun$captureAlterIsrPartitionError$1(tp, future, x0$1);
            return BoxedUnit.UNIT;
        };
        controller.eventManager().put((ControllerEvent)new AlterIsrReceived(brokerId, brokerEpoch, isrsToAlter, (Function1)callback));
        return future;
    }

    @Test
    public void testTopicIdsAreAdded() {
        this.servers_$eq(this.makeServers(1, this.makeServers$default$2(), this.makeServers$default$3(), this.makeServers$default$4(), this.makeServers$default$5(), this.makeServers$default$6(), this.makeServers$default$7(), this.makeServers$default$8(), this.makeServers$default$9(), this.makeServers$default$10()));
        TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), TestUtils$.MODULE$.waitUntilControllerElected$default$2());
        KafkaController controller = this.getController().kafkaController();
        TopicPartition tp1 = new TopicPartition("t1", 0);
        Map assignment1 = (Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp1.partition())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})))}));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)controller.controllerContext().topicIds().get((Object)"t1"));
        TestUtils$.MODULE$.createTopic(this.zkClient(), tp1.topic(), (Map<Object, Seq<Object>>)assignment1, this.servers());
        this.waitForPartitionState(tp1, this.firstControllerEpoch(), 0, LeaderAndIsr$.MODULE$.initialLeaderEpoch(), "failed to get expected partition state upon topic creation");
        Assertions.assertNotEquals((Object)None$.MODULE$, (Object)controller.controllerContext().topicIds().get((Object)"t1"));
        Uuid topicId1 = (Uuid)controller.controllerContext().topicIds().apply((Object)"t1");
        Assertions.assertEquals((Object)"t1", (Object)controller.controllerContext().topicNames().apply((Object)topicId1));
        TopicPartition tp2 = new TopicPartition("t2", 0);
        Map assignment2 = (Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp2.partition())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})))}));
        TestUtils$.MODULE$.createTopic(this.zkClient(), tp2.topic(), (Map<Object, Seq<Object>>)assignment2, this.servers());
        this.waitForPartitionState(tp2, this.firstControllerEpoch(), 0, LeaderAndIsr$.MODULE$.initialLeaderEpoch(), "failed to get expected partition state upon topic creation");
        Assertions.assertNotEquals((Object)None$.MODULE$, (Object)controller.controllerContext().topicIds().get((Object)"t2"));
        Uuid topicId2 = (Uuid)controller.controllerContext().topicIds().apply((Object)"t2");
        Assertions.assertEquals((Object)"t2", (Object)controller.controllerContext().topicNames().apply((Object)topicId2));
        Assertions.assertEquals((Object)topicId1, (Object)controller.controllerContext().topicIds().get((Object)"t1").get());
        Assertions.assertNotEquals((Object)topicId1, (Object)topicId2);
    }

    @Test
    public void testTopicIdsAreNotAdded() {
        int x$1 = 1;
        Some x$2 = new Some((Object)KAFKA_2_7_IV0$.MODULE$);
        boolean x$3 = this.makeServers$default$2();
        boolean x$4 = this.makeServers$default$3();
        boolean x$5 = this.makeServers$default$4();
        Option<String> x$6 = this.makeServers$default$5();
        Option<String> x$7 = this.makeServers$default$6();
        Option<String> x$8 = this.makeServers$default$7();
        int x$9 = this.makeServers$default$9();
        int x$10 = this.makeServers$default$10();
        this.servers_$eq(this.makeServers(x$1, x$3, x$4, x$5, x$6, x$7, x$8, (Option<ApiVersion>)x$2, x$9, x$10));
        TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), TestUtils$.MODULE$.waitUntilControllerElected$default$2());
        KafkaController controller = this.getController().kafkaController();
        TopicPartition tp1 = new TopicPartition("t1", 0);
        Map assignment1 = (Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp1.partition())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})))}));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)controller.controllerContext().topicIds().get((Object)"t1"));
        TestUtils$.MODULE$.createTopic(this.zkClient(), tp1.topic(), (Map<Object, Seq<Object>>)assignment1, this.servers());
        this.waitForPartitionState(tp1, this.firstControllerEpoch(), 0, LeaderAndIsr$.MODULE$.initialLeaderEpoch(), "failed to get expected partition state upon topic creation");
        Assertions.assertEquals((Object)None$.MODULE$, (Object)controller.controllerContext().topicIds().get((Object)"t1"));
        TopicPartition tp2 = new TopicPartition("t2", 0);
        Map assignment2 = (Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp2.partition())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})))}));
        TestUtils$.MODULE$.createTopic(this.zkClient(), tp2.topic(), (Map<Object, Seq<Object>>)assignment2, this.servers());
        this.waitForPartitionState(tp2, this.firstControllerEpoch(), 0, LeaderAndIsr$.MODULE$.initialLeaderEpoch(), "failed to get expected partition state upon topic creation");
        Assertions.assertEquals((Object)None$.MODULE$, (Object)controller.controllerContext().topicIds().get((Object)"t2"));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)controller.controllerContext().topicIds().get((Object)"t1"));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testTopicIdMigrationAndHandling() {
        TopicPartition tp = new TopicPartition("t", 0);
        Map assignment = (Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp.partition())), (Object)ReplicaAssignment$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})), (Seq)Nil$.MODULE$, (Seq)Nil$.MODULE$))}));
        AdminZkClient adminZkClient = new AdminZkClient(this.zkClient());
        this.servers_$eq(this.makeServers(1, this.makeServers$default$2(), this.makeServers$default$3(), this.makeServers$default$4(), this.makeServers$default$5(), this.makeServers$default$6(), this.makeServers$default$7(), this.makeServers$default$8(), this.makeServers$default$9(), this.makeServers$default$10()));
        adminZkClient.createTopic(tp.topic(), 1, 1, adminZkClient.createTopic$default$4(), adminZkClient.createTopic$default$5(), adminZkClient.createTopic$default$6());
        this.waitForPartitionState(tp, this.firstControllerEpoch(), 0, LeaderAndIsr$.MODULE$.initialLeaderEpoch(), "failed to get expected partition state upon topic creation");
        Option topicIdAfterCreate = this.zkClient().getTopicIdsForTopics((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{tp.topic()}))).get((Object)tp.topic());
        Assertions.assertTrue((boolean)topicIdAfterCreate.isDefined());
        Assertions.assertEquals((Object)topicIdAfterCreate, (Object)((KafkaServer)this.servers().head()).kafkaController().controllerContext().topicIds().get((Object)tp.topic()), (String)"correct topic ID cannot be found in the controller context");
        adminZkClient.addPartitions(tp.topic(), assignment, adminZkClient.getBrokerMetadatas(adminZkClient.getBrokerMetadatas$default$1(), adminZkClient.getBrokerMetadatas$default$2()), 2, adminZkClient.addPartitions$default$5(), adminZkClient.addPartitions$default$6());
        Option topicIdAfterAddition = this.zkClient().getTopicIdsForTopics((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{tp.topic()}))).get((Object)tp.topic());
        Assertions.assertEquals((Object)topicIdAfterCreate, (Object)topicIdAfterAddition);
        Assertions.assertEquals((Object)topicIdAfterCreate, (Object)((KafkaServer)this.servers().head()).kafkaController().controllerContext().topicIds().get((Object)tp.topic()), (String)"topic ID changed after partition additions");
        adminZkClient.deleteTopic(tp.topic());
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ControllerIntegrationTest.$anonfun$testTopicIdMigrationAndHandling$1(this, tp)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ControllerIntegrationTest.$anonfun$testTopicIdMigrationAndHandling$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testTopicIdMigrationAndHandlingWithOlderVersion() {
        TopicPartition tp = new TopicPartition("t", 0);
        Map assignment = (Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp.partition())), (Object)ReplicaAssignment$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})), (Seq)Nil$.MODULE$, (Seq)Nil$.MODULE$))}));
        AdminZkClient adminZkClient = new AdminZkClient(this.zkClient());
        int x$1 = 1;
        Some x$2 = new Some((Object)KAFKA_2_7_IV0$.MODULE$);
        boolean x$3 = this.makeServers$default$2();
        boolean x$4 = this.makeServers$default$3();
        boolean x$5 = this.makeServers$default$4();
        Option<String> x$6 = this.makeServers$default$5();
        Option<String> x$7 = this.makeServers$default$6();
        Option<String> x$8 = this.makeServers$default$7();
        int x$9 = this.makeServers$default$9();
        int x$10 = this.makeServers$default$10();
        this.servers_$eq(this.makeServers(x$1, x$3, x$4, x$5, x$6, x$7, x$8, (Option<ApiVersion>)x$2, x$9, x$10));
        adminZkClient.createTopic(tp.topic(), 1, 1, adminZkClient.createTopic$default$4(), adminZkClient.createTopic$default$5(), adminZkClient.createTopic$default$6());
        this.waitForPartitionState(tp, this.firstControllerEpoch(), 0, LeaderAndIsr$.MODULE$.initialLeaderEpoch(), "failed to get expected partition state upon topic creation");
        Option topicIdAfterCreate = this.zkClient().getTopicIdsForTopics((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{tp.topic()}))).get((Object)tp.topic());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)topicIdAfterCreate);
        Assertions.assertEquals((Object)topicIdAfterCreate, (Object)((KafkaServer)this.servers().head()).kafkaController().controllerContext().topicIds().get((Object)tp.topic()), (String)"incorrect topic ID can be found in the controller context");
        adminZkClient.addPartitions(tp.topic(), assignment, adminZkClient.getBrokerMetadatas(adminZkClient.getBrokerMetadatas$default$1(), adminZkClient.getBrokerMetadatas$default$2()), 2, adminZkClient.addPartitions$default$5(), adminZkClient.addPartitions$default$6());
        Option topicIdAfterAddition = this.zkClient().getTopicIdsForTopics((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{tp.topic()}))).get((Object)tp.topic());
        Assertions.assertEquals((Object)topicIdAfterCreate, (Object)topicIdAfterAddition);
        Assertions.assertEquals((Object)topicIdAfterCreate, (Object)((KafkaServer)this.servers().head()).kafkaController().controllerContext().topicIds().get((Object)tp.topic()), (String)"topic ID changed after partition additions");
        adminZkClient.deleteTopic(tp.topic());
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ControllerIntegrationTest.$anonfun$testTopicIdMigrationAndHandlingWithOlderVersion$1(this, tp)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ControllerIntegrationTest.$anonfun$testTopicIdMigrationAndHandlingWithOlderVersion$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testTopicIdPersistsThroughControllerReelection() {
        this.servers_$eq(this.makeServers(2, this.makeServers$default$2(), this.makeServers$default$3(), this.makeServers$default$4(), this.makeServers$default$5(), this.makeServers$default$6(), this.makeServers$default$7(), this.makeServers$default$8(), this.makeServers$default$9(), this.makeServers$default$10()));
        int controllerId = TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), TestUtils$.MODULE$.waitUntilControllerElected$default$2());
        KafkaController controller = this.getController().kafkaController();
        TopicPartition tp = new TopicPartition("t", 0);
        Map assignment = (Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp.partition())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{controllerId})))}));
        TestUtils$.MODULE$.createTopic(this.zkClient(), tp.topic(), (Map<Object, Seq<Object>>)assignment, this.servers());
        this.waitForPartitionState(tp, this.firstControllerEpoch(), controllerId, LeaderAndIsr$.MODULE$.initialLeaderEpoch(), "failed to get expected partition state upon topic creation");
        Uuid topicId = (Uuid)controller.controllerContext().topicIds().get((Object)"t").get();
        ((KafkaServer)this.servers().apply(controllerId)).shutdown();
        ((KafkaServer)this.servers().apply(controllerId)).awaitShutdown();
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ControllerIntegrationTest.$anonfun$testTopicIdPersistsThroughControllerReelection$1(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ControllerIntegrationTest.$anonfun$testTopicIdPersistsThroughControllerReelection$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        KafkaController controller2 = this.getController().kafkaController();
        Assertions.assertEquals((Object)topicId, (Object)controller2.controllerContext().topicIds().get((Object)"t").get());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testNoTopicIdPersistsThroughControllerReelection() {
        int x$1 = 2;
        Some x$2 = new Some((Object)KAFKA_2_7_IV0$.MODULE$);
        boolean x$3 = this.makeServers$default$2();
        boolean x$4 = this.makeServers$default$3();
        boolean x$5 = this.makeServers$default$4();
        Option<String> x$6 = this.makeServers$default$5();
        Option<String> x$7 = this.makeServers$default$6();
        Option<String> x$8 = this.makeServers$default$7();
        int x$9 = this.makeServers$default$9();
        int x$10 = this.makeServers$default$10();
        this.servers_$eq(this.makeServers(x$1, x$3, x$4, x$5, x$6, x$7, x$8, (Option<ApiVersion>)x$2, x$9, x$10));
        int controllerId = TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), TestUtils$.MODULE$.waitUntilControllerElected$default$2());
        KafkaController controller = this.getController().kafkaController();
        TopicPartition tp = new TopicPartition("t", 0);
        Map assignment = (Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp.partition())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{controllerId})))}));
        TestUtils$.MODULE$.createTopic(this.zkClient(), tp.topic(), (Map<Object, Seq<Object>>)assignment, this.servers());
        this.waitForPartitionState(tp, this.firstControllerEpoch(), controllerId, LeaderAndIsr$.MODULE$.initialLeaderEpoch(), "failed to get expected partition state upon topic creation");
        Option emptyTopicId = controller.controllerContext().topicIds().get((Object)"t");
        Assertions.assertEquals((Object)None$.MODULE$, (Object)emptyTopicId);
        ((KafkaServer)this.servers().apply(controllerId)).shutdown();
        ((KafkaServer)this.servers().apply(controllerId)).awaitShutdown();
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ControllerIntegrationTest.$anonfun$testNoTopicIdPersistsThroughControllerReelection$1(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ControllerIntegrationTest.$anonfun$testNoTopicIdPersistsThroughControllerReelection$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        KafkaController controller2 = this.getController().kafkaController();
        Assertions.assertEquals((Object)emptyTopicId, (Object)controller2.controllerContext().topicIds().get((Object)"t"));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testTopicIdPersistsThroughControllerRestart() {
        this.servers_$eq(this.makeServers(1, this.makeServers$default$2(), this.makeServers$default$3(), this.makeServers$default$4(), this.makeServers$default$5(), this.makeServers$default$6(), this.makeServers$default$7(), this.makeServers$default$8(), this.makeServers$default$9(), this.makeServers$default$10()));
        int controllerId = TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), TestUtils$.MODULE$.waitUntilControllerElected$default$2());
        KafkaController controller = this.getController().kafkaController();
        TopicPartition tp = new TopicPartition("t", 0);
        Map assignment = (Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp.partition())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{controllerId})))}));
        TestUtils$.MODULE$.createTopic(this.zkClient(), tp.topic(), (Map<Object, Seq<Object>>)assignment, this.servers());
        this.waitForPartitionState(tp, this.firstControllerEpoch(), controllerId, LeaderAndIsr$.MODULE$.initialLeaderEpoch(), "failed to get expected partition state upon topic creation");
        Uuid topicId = (Uuid)controller.controllerContext().topicIds().get((Object)"t").get();
        ((KafkaServer)this.servers().apply(controllerId)).shutdown();
        ((KafkaServer)this.servers().apply(controllerId)).awaitShutdown();
        ((KafkaServer)this.servers().apply(controllerId)).startup();
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ControllerIntegrationTest.$anonfun$testTopicIdPersistsThroughControllerRestart$1(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ControllerIntegrationTest.$anonfun$testTopicIdPersistsThroughControllerRestart$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        KafkaController controller2 = this.getController().kafkaController();
        Assertions.assertEquals((Object)topicId, (Object)controller2.controllerContext().topicIds().get((Object)"t").get());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testTopicIdCreatedOnUpgrade() {
        void var15_23;
        Tuple2 tuple2;
        int x$1 = 1;
        Some x$2 = new Some((Object)KAFKA_2_7_IV0$.MODULE$);
        boolean x$3 = this.makeServers$default$2();
        boolean x$4 = this.makeServers$default$3();
        boolean x$5 = this.makeServers$default$4();
        Option<String> x$6 = this.makeServers$default$5();
        Option<String> x$7 = this.makeServers$default$6();
        Option<String> x$8 = this.makeServers$default$7();
        int x$9 = this.makeServers$default$9();
        int x$10 = this.makeServers$default$10();
        this.servers_$eq(this.makeServers(x$1, x$3, x$4, x$5, x$6, x$7, x$8, (Option<ApiVersion>)x$2, x$9, x$10));
        int controllerId = TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), TestUtils$.MODULE$.waitUntilControllerElected$default$2());
        KafkaController controller = this.getController().kafkaController();
        TopicPartition tp = new TopicPartition("t", 0);
        Map assignment = (Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp.partition())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{controllerId})))}));
        TestUtils$.MODULE$.createTopic(this.zkClient(), tp.topic(), (Map<Object, Seq<Object>>)assignment, this.servers());
        this.waitForPartitionState(tp, this.firstControllerEpoch(), controllerId, LeaderAndIsr$.MODULE$.initialLeaderEpoch(), "failed to get expected partition state upon topic creation");
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.zkClient().getTopicIdsForTopics((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{tp.topic()}))).get((Object)tp.topic()));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)controller.controllerContext().topicIds().get((Object)tp.topic()));
        ((KafkaServer)this.servers().apply(controllerId)).shutdown();
        ((KafkaServer)this.servers().apply(controllerId)).awaitShutdown();
        this.servers_$eq(this.makeServers(1, this.makeServers$default$2(), this.makeServers$default$3(), this.makeServers$default$4(), this.makeServers$default$5(), this.makeServers$default$6(), this.makeServers$default$7(), this.makeServers$default$8(), this.makeServers$default$9(), this.makeServers$default$10()));
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ControllerIntegrationTest.$anonfun$testTopicIdCreatedOnUpgrade$1(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ControllerIntegrationTest.$anonfun$testTopicIdCreatedOnUpgrade$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        long l3 = TestUtils$.MODULE$.computeUntilTrue$default$3();
        long l4 = TestUtils$.MODULE$.computeUntilTrue$default$2();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long computeUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            void computeUntilTrue_pause;
            void computeUntilTrue_waitTime;
            Option computeUntilTrue_result;
            if ((computeUntilTrue_result = ControllerIntegrationTest.$anonfun$testTopicIdCreatedOnUpgrade$3(this, tp)).nonEmpty()) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > computeUntilTrue_startTime + computeUntilTrue_waitTime) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)computeUntilTrue_waitTime), (long)computeUntilTrue_pause));
        }
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Option topicIdAfterUpgrade = (Option)tuple2._1();
        Assertions.assertNotEquals((Object)None$.MODULE$, (Object)var15_23, (String)new StringBuilder(29).append("topic id for ").append(tp.topic()).append(" not found in ZK").toString());
        KafkaController controller2 = this.getController().kafkaController();
        Option topicId = controller2.controllerContext().topicIds().get((Object)tp.topic());
        Assertions.assertEquals((Object)var15_23, (Object)topicId);
        Assertions.assertEquals((Object)tp.topic(), (Object)controller2.controllerContext().topicNames().apply(topicId.get()));
        long l5 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l6 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!ControllerIntegrationTest.$anonfun$testTopicIdCreatedOnUpgrade$5(this, tp)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ControllerIntegrationTest.$anonfun$testTopicIdCreatedOnUpgrade$6());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        LogManager qual$2 = ((KafkaServer)this.servers().apply(0)).logManager();
        boolean x$14 = qual$2.getLog$default$2();
        Option topicIdInLog = ((UnifiedLog)qual$2.getLog(tp, x$14).get()).topicId();
        Assertions.assertEquals((Object)topicId, (Object)topicIdInLog);
        this.adminZkClient().deleteTopic(tp.topic());
        long l7 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l8 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!ControllerIntegrationTest.$anonfun$testTopicIdCreatedOnUpgrade$7(this, tp)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ControllerIntegrationTest.$anonfun$testTopicIdCreatedOnUpgrade$8());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testTopicIdCreatedOnUpgradeMultiBrokerScenario() {
        int x$1 = 1;
        Some x$2 = new Some((Object)KAFKA_2_7_IV0$.MODULE$);
        boolean x$3 = this.makeServers$default$2();
        boolean x$4 = this.makeServers$default$3();
        boolean x$5 = this.makeServers$default$4();
        Option<String> x$6 = this.makeServers$default$5();
        Option<String> x$7 = this.makeServers$default$6();
        Option<String> x$8 = this.makeServers$default$7();
        int x$9 = this.makeServers$default$9();
        int x$10 = this.makeServers$default$10();
        this.servers_$eq(this.makeServers(x$1, x$3, x$4, x$5, x$6, x$7, x$8, (Option<ApiVersion>)x$2, x$9, x$10));
        int x$11 = 3;
        int x$12 = 1;
        boolean x$13 = this.makeServers$default$2();
        boolean x$14 = this.makeServers$default$3();
        boolean x$15 = this.makeServers$default$4();
        Option<String> x$16 = this.makeServers$default$5();
        Option<String> x$17 = this.makeServers$default$6();
        Option<String> x$18 = this.makeServers$default$7();
        Option<ApiVersion> x$19 = this.makeServers$default$8();
        int x$20 = this.makeServers$default$9();
        this.servers_$eq((Seq<KafkaServer>)((Seq)this.servers().$plus$plus(this.makeServers(x$11, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20, x$12), Seq$.MODULE$.canBuildFrom())));
        int originalControllerId = TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), TestUtils$.MODULE$.waitUntilControllerElected$default$2());
        Assertions.assertEquals((int)0, (int)originalControllerId);
        KafkaController controller = this.getController().kafkaController();
        Assertions.assertEquals((Object)KAFKA_2_7_IV0$.MODULE$, (Object)((KafkaServer)this.servers().apply(originalControllerId)).config().interBrokerProtocolVersion());
        Seq remainingBrokers = (Seq)this.servers().filter((Function1 & Serializable & scala.Serializable)x$35 -> BoxesRunTime.boxToBoolean((boolean)ControllerIntegrationTest.$anonfun$testTopicIdCreatedOnUpgradeMultiBrokerScenario$1(originalControllerId, x$35)));
        TopicPartition tp = new TopicPartition("t", 0);
        Map assignment = (Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp.partition())), remainingBrokers.map((Function1 & Serializable & scala.Serializable)x$36 -> BoxesRunTime.boxToInteger((int)ControllerIntegrationTest.$anonfun$testTopicIdCreatedOnUpgradeMultiBrokerScenario$2(x$36)), Seq$.MODULE$.canBuildFrom()))}));
        TestUtils$.MODULE$.createTopic(this.zkClient(), tp.topic(), (Map<Object, Seq<Object>>)assignment, this.servers());
        this.waitForPartitionState(tp, this.firstControllerEpoch(), ((KafkaServer)remainingBrokers.apply(0)).config().brokerId(), LeaderAndIsr$.MODULE$.initialLeaderEpoch(), "failed to get expected partition state upon topic creation");
        Option topicIdAfterCreate = this.zkClient().getTopicIdsForTopics((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{tp.topic()}))).get((Object)tp.topic());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)topicIdAfterCreate);
        Option emptyTopicId = controller.controllerContext().topicIds().get((Object)"t");
        Assertions.assertEquals((Object)None$.MODULE$, (Object)emptyTopicId);
        remainingBrokers.foreach((Function1 & Serializable & scala.Serializable)server -> {
            ControllerIntegrationTest.$anonfun$testTopicIdCreatedOnUpgradeMultiBrokerScenario$3(tp, server);
            return BoxedUnit.UNIT;
        });
        ((KafkaServer)this.servers().apply(originalControllerId)).shutdown();
        ((KafkaServer)this.servers().apply(originalControllerId)).awaitShutdown();
        ((KafkaServer)this.servers().apply(originalControllerId)).startup();
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ControllerIntegrationTest.$anonfun$testTopicIdCreatedOnUpgradeMultiBrokerScenario$6(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ControllerIntegrationTest.$anonfun$testTopicIdCreatedOnUpgradeMultiBrokerScenario$7());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Option topicIdAfterUpgrade = this.zkClient().getTopicIdsForTopics((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{tp.topic()}))).get((Object)tp.topic());
        Assertions.assertNotEquals((Object)emptyTopicId, (Object)topicIdAfterUpgrade);
        KafkaController controller2 = this.getController().kafkaController();
        Assertions.assertNotEquals((Object)emptyTopicId, (Object)controller2.controllerContext().topicIds().get((Object)"t"));
        Uuid topicId = (Uuid)controller2.controllerContext().topicIds().get((Object)"t").get();
        Assertions.assertEquals((Object)topicIdAfterUpgrade.get(), (Object)topicId);
        Assertions.assertEquals((Object)"t", (Object)controller2.controllerContext().topicNames().apply((Object)topicId));
        remainingBrokers.foreach((Function1 & Serializable & scala.Serializable)server -> {
            ControllerIntegrationTest.$anonfun$testTopicIdCreatedOnUpgradeMultiBrokerScenario$8(tp, topicId, server);
            return BoxedUnit.UNIT;
        });
        this.adminZkClient().deleteTopic(tp.topic());
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!ControllerIntegrationTest.$anonfun$testTopicIdCreatedOnUpgradeMultiBrokerScenario$11(this, tp)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ControllerIntegrationTest.$anonfun$testTopicIdCreatedOnUpgradeMultiBrokerScenario$12());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testTopicIdUpgradeAfterReassigningPartitions() {
        TopicPartition tp = new TopicPartition("t", 0);
        Map reassignment = (Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)new Some((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0}))))}));
        AdminZkClient adminZkClient = new AdminZkClient(this.zkClient());
        int x$1 = 1;
        Some x$2 = new Some((Object)KAFKA_2_7_IV0$.MODULE$);
        boolean x$3 = this.makeServers$default$2();
        boolean x$4 = this.makeServers$default$3();
        boolean x$5 = this.makeServers$default$4();
        Option<String> x$6 = this.makeServers$default$5();
        Option<String> x$7 = this.makeServers$default$6();
        Option<String> x$8 = this.makeServers$default$7();
        int x$9 = this.makeServers$default$9();
        int x$10 = this.makeServers$default$10();
        this.servers_$eq(this.makeServers(x$1, x$3, x$4, x$5, x$6, x$7, x$8, (Option<ApiVersion>)x$2, x$9, x$10));
        adminZkClient.createTopic(tp.topic(), 1, 1, adminZkClient.createTopic$default$4(), adminZkClient.createTopic$default$5(), adminZkClient.createTopic$default$6());
        this.waitForPartitionState(tp, this.firstControllerEpoch(), 0, LeaderAndIsr$.MODULE$.initialLeaderEpoch(), "failed to get expected partition state upon topic creation");
        Option topicIdAfterCreate = this.zkClient().getTopicIdsForTopics((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{tp.topic()}))).get((Object)tp.topic());
        Option id = ((KafkaServer)this.servers().head()).kafkaController().controllerContext().topicIds().get((Object)tp.topic());
        Assertions.assertTrue((boolean)topicIdAfterCreate.isEmpty());
        Assertions.assertEquals((Object)topicIdAfterCreate, (Object)id, (String)"expected no topic ID, but one existed");
        ((KafkaServer)this.servers().apply(0)).shutdown();
        ((KafkaServer)this.servers().apply(0)).awaitShutdown();
        this.servers_$eq(this.makeServers(1, this.makeServers$default$2(), this.makeServers$default$3(), this.makeServers$default$4(), this.makeServers$default$5(), this.makeServers$default$6(), this.makeServers$default$7(), this.makeServers$default$8(), this.makeServers$default$9(), this.makeServers$default$10()));
        this.waitForPartitionState(tp, this.firstControllerEpoch(), 0, LeaderAndIsr$.MODULE$.initialLeaderEpoch(), "failed to get expected partition state upon controller restart");
        Option topicIdAfterUpgrade = this.zkClient().getTopicIdsForTopics((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{tp.topic()}))).get((Object)tp.topic());
        Assertions.assertEquals((Object)topicIdAfterUpgrade, (Object)((KafkaServer)this.servers().head()).kafkaController().controllerContext().topicIds().get((Object)tp.topic()), (String)"expected same topic ID but it can not be found");
        Assertions.assertEquals((Object)tp.topic(), (Object)((KafkaServer)this.servers().head()).kafkaController().controllerContext().topicNames().apply(topicIdAfterUpgrade.get()), (String)"correct topic name expected but cannot be found in the controller context");
        ((KafkaServer)this.servers().apply(0)).shutdown();
        ((KafkaServer)this.servers().apply(0)).awaitShutdown();
        int x$11 = 1;
        Some x$12 = new Some((Object)KAFKA_2_7_IV0$.MODULE$);
        boolean x$13 = this.makeServers$default$2();
        boolean x$14 = this.makeServers$default$3();
        boolean x$15 = this.makeServers$default$4();
        Option<String> x$16 = this.makeServers$default$5();
        Option<String> x$17 = this.makeServers$default$6();
        Option<String> x$18 = this.makeServers$default$7();
        int x$19 = this.makeServers$default$9();
        int x$20 = this.makeServers$default$10();
        this.servers_$eq(this.makeServers(x$11, x$13, x$14, x$15, x$16, x$17, x$18, (Option<ApiVersion>)x$12, x$19, x$20));
        this.waitForPartitionState(tp, this.firstControllerEpoch(), 0, LeaderAndIsr$.MODULE$.initialLeaderEpoch(), "failed to get expected partition state upon topic creation");
        Option topicIdAfterDowngrade = this.zkClient().getTopicIdsForTopics((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{tp.topic()}))).get((Object)tp.topic());
        Assertions.assertTrue((boolean)topicIdAfterDowngrade.isDefined());
        Assertions.assertEquals((Object)topicIdAfterUpgrade, (Object)topicIdAfterDowngrade, (String)"expected same topic ID but it can not be found after downgrade");
        Assertions.assertEquals((Object)topicIdAfterDowngrade, (Object)((KafkaServer)this.servers().head()).kafkaController().controllerContext().topicIds().get((Object)tp.topic()), (String)"expected same topic ID in controller context but it is no longer found after downgrade");
        Assertions.assertEquals((Object)tp.topic(), (Object)((KafkaServer)this.servers().head()).kafkaController().controllerContext().topicNames().apply(topicIdAfterUpgrade.get()), (String)"correct topic name expected but cannot be found in the controller context");
        ((KafkaServer)this.servers().apply(0)).kafkaController().eventManager().put((ControllerEvent)new ApiPartitionReassignment(reassignment, (Function1 & Serializable & scala.Serializable)x$37 -> {
            ControllerIntegrationTest.$anonfun$testTopicIdUpgradeAfterReassigningPartitions$1(x$37);
            return BoxedUnit.UNIT;
        }));
        this.waitForPartitionState(tp, 3, 0, 1, "failed to get expected partition state upon controller restart");
        Option topicIdAfterReassignment = this.zkClient().getTopicIdsForTopics((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{tp.topic()}))).get((Object)tp.topic());
        Assertions.assertTrue((boolean)topicIdAfterReassignment.isDefined());
        Assertions.assertEquals((Object)topicIdAfterUpgrade, (Object)topicIdAfterReassignment, (String)"expected same topic ID but it can not be found after reassignment");
        Assertions.assertEquals((Object)topicIdAfterUpgrade, (Object)((KafkaServer)this.servers().head()).kafkaController().controllerContext().topicIds().get((Object)tp.topic()), (String)"expected same topic ID in controller context but is no longer found after reassignment");
        Assertions.assertEquals((Object)tp.topic(), (Object)((KafkaServer)this.servers().head()).kafkaController().controllerContext().topicNames().apply(topicIdAfterUpgrade.get()), (String)"correct topic name expected but cannot be found in the controller context");
        ((KafkaServer)this.servers().apply(0)).shutdown();
        ((KafkaServer)this.servers().apply(0)).awaitShutdown();
        this.servers_$eq(this.makeServers(1, this.makeServers$default$2(), this.makeServers$default$3(), this.makeServers$default$4(), this.makeServers$default$5(), this.makeServers$default$6(), this.makeServers$default$7(), this.makeServers$default$8(), this.makeServers$default$9(), this.makeServers$default$10()));
        this.waitForPartitionState(tp, 3, 0, 1, "failed to get expected partition state upon controller restart");
        Option topicIdAfterReUpgrade = this.zkClient().getTopicIdsForTopics((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{tp.topic()}))).get((Object)tp.topic());
        Assertions.assertEquals((Object)topicIdAfterUpgrade, (Object)topicIdAfterReUpgrade, (String)"expected same topic ID but it can not be found after re-upgrade");
        Assertions.assertEquals((Object)topicIdAfterReUpgrade, (Object)((KafkaServer)this.servers().head()).kafkaController().controllerContext().topicIds().get((Object)tp.topic()), (String)"topic ID can not be found in controller context after re-upgrading IBP");
        Assertions.assertEquals((Object)tp.topic(), (Object)((KafkaServer)this.servers().head()).kafkaController().controllerContext().topicNames().apply(topicIdAfterReUpgrade.get()), (String)"correct topic name expected but cannot be found in the controller context");
        adminZkClient.deleteTopic(tp.topic());
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ControllerIntegrationTest.$anonfun$testTopicIdUpgradeAfterReassigningPartitions$2(this, tp)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ControllerIntegrationTest.$anonfun$testTopicIdUpgradeAfterReassigningPartitions$3());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Assertions.assertTrue((boolean)((KafkaServer)this.servers().head()).kafkaController().controllerContext().topicNames().get(topicIdAfterUpgrade.get()).isEmpty());
    }

    /*
     * WARNING - void declaration
     */
    private void testControllerMove(Function0<BoxedUnit> fun) {
        KafkaController controller = this.getController().kafkaController();
        LogCaptureAppender appender = LogCaptureAppender$.MODULE$.createAndRegister();
        Level previousLevel = LogCaptureAppender$.MODULE$.setClassLoggerLevel(controller.getClass(), Level.INFO);
        try {
            long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
            long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
            if (TestUtils$.MODULE$ == null) {
                throw null;
            }
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!ControllerIntegrationTest.$anonfun$testControllerMove$1(controller)) {
                void waitUntilTrue_pause;
                void waitUntilTrue_waitTimeMs;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)ControllerIntegrationTest.$anonfun$testControllerMove$2());
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            CountDownLatch latch = new CountDownLatch(1);
            controller.eventManager().put((ControllerEvent)new /* invalid duplicate definition of identical inner class */);
            fun.apply$mcV$sp();
            this.zkClient().deleteController(controller.controllerContext().epochZkVersion());
            this.zkClient().registerControllerAndIncrementControllerEpoch(this.servers().size());
            latch.countDown();
            long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
            long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
            if (TestUtils$.MODULE$ == null) {
                throw null;
            }
            long waitUntilTrue_startTime2 = System.currentTimeMillis();
            while (!ControllerIntegrationTest.$anonfun$testControllerMove$3(controller)) {
                void waitUntilTrue_pause;
                void waitUntilTrue_waitTimeMs;
                if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)ControllerIntegrationTest.$anonfun$testControllerMove$4());
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            Assertions.assertTrue((boolean)appender.getMessages().find((Function1 & Serializable & scala.Serializable)e -> BoxesRunTime.boxToBoolean((boolean)ControllerIntegrationTest.$anonfun$testControllerMove$5(e))).isDefined());
        }
        finally {
            LogCaptureAppender$.MODULE$.unregister(appender);
            LogCaptureAppender$.MODULE$.setClassLoggerLevel(controller.eventManager().thread().getClass(), previousLevel);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void preferredReplicaLeaderElection(int controllerId, KafkaServer otherBroker, TopicPartition tp, scala.collection.immutable.Set<Object> replicas, int leaderEpoch) {
        otherBroker.shutdown();
        otherBroker.awaitShutdown();
        this.waitForPartitionState(tp, this.firstControllerEpoch(), controllerId, leaderEpoch + 1, "failed to get expected partition state upon broker shutdown");
        otherBroker.startup();
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ControllerIntegrationTest.$anonfun$preferredReplicaLeaderElection$1(this, tp, replicas)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ControllerIntegrationTest.$anonfun$preferredReplicaLeaderElection$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.zkClient().createPreferredReplicaElection((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp})));
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!ControllerIntegrationTest.$anonfun$preferredReplicaLeaderElection$3(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ControllerIntegrationTest.$anonfun$preferredReplicaLeaderElection$4());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.waitForPartitionState(tp, this.firstControllerEpoch(), otherBroker.config().brokerId(), leaderEpoch + 2, "failed to get expected partition state upon broker startup");
    }

    /*
     * WARNING - void declaration
     */
    private void waitUntilControllerEpoch(int epoch, String message) {
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ControllerIntegrationTest.$anonfun$waitUntilControllerEpoch$1(this, epoch)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)message);
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    /*
     * WARNING - void declaration
     */
    private void waitForPartitionState(TopicPartition tp, int controllerEpoch, int leader, int leaderEpoch, String message) {
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ControllerIntegrationTest.$anonfun$waitForPartitionState$1(this, tp, controllerEpoch, leader, leaderEpoch)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)message);
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    private boolean isExpectedPartitionState(LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch, int controllerEpoch, int leader, int leaderEpoch) {
        return leaderIsrAndControllerEpoch.controllerEpoch() == controllerEpoch && leaderIsrAndControllerEpoch.leaderAndIsr().leader() == leader && leaderIsrAndControllerEpoch.leaderAndIsr().leaderEpoch() == leaderEpoch;
    }

    private Seq<KafkaServer> makeServers(int numConfigs, boolean autoLeaderRebalanceEnable, boolean uncleanLeaderElectionEnable, boolean enableControlledShutdown, Option<String> listeners, Option<String> listenerSecurityProtocolMap, Option<String> controlPlaneListenerName, Option<ApiVersion> interBrokerProtocolVersion, int logDirCount, int startingIdNumber) {
        String x$2 = this.zkConnect();
        boolean x$6 = TestUtils$.MODULE$.createBrokerConfigs$default$4();
        Option<SecurityProtocol> x$7 = TestUtils$.MODULE$.createBrokerConfigs$default$5();
        Option<File> x$8 = TestUtils$.MODULE$.createBrokerConfigs$default$6();
        Option<Properties> x$9 = TestUtils$.MODULE$.createBrokerConfigs$default$7();
        boolean x$10 = TestUtils$.MODULE$.createBrokerConfigs$default$8();
        boolean x$11 = TestUtils$.MODULE$.createBrokerConfigs$default$9();
        boolean x$12 = TestUtils$.MODULE$.createBrokerConfigs$default$10();
        boolean x$13 = TestUtils$.MODULE$.createBrokerConfigs$default$11();
        Map<Object, String> x$14 = TestUtils$.MODULE$.createBrokerConfigs$default$12();
        boolean x$15 = TestUtils$.MODULE$.createBrokerConfigs$default$14();
        int x$16 = TestUtils$.MODULE$.createBrokerConfigs$default$15();
        short x$17 = TestUtils$.MODULE$.createBrokerConfigs$default$16();
        Seq<Properties> configs = TestUtils$.MODULE$.createBrokerConfigs(numConfigs, x$2, enableControlledShutdown, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, logDirCount, x$15, x$16, x$17, startingIdNumber);
        configs.foreach((Function1 & Serializable & scala.Serializable)config -> {
            ControllerIntegrationTest.$anonfun$makeServers$1(autoLeaderRebalanceEnable, uncleanLeaderElectionEnable, listeners, listenerSecurityProtocolMap, controlPlaneListenerName, interBrokerProtocolVersion, config);
            return BoxedUnit.UNIT;
        });
        return (Seq)configs.map((Function1 & Serializable & scala.Serializable)config -> TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(config), TestUtils$.MODULE$.createServer$default$2()), Seq$.MODULE$.canBuildFrom());
    }

    private boolean makeServers$default$2() {
        return false;
    }

    private boolean makeServers$default$3() {
        return false;
    }

    private boolean makeServers$default$4() {
        return true;
    }

    private Option<String> makeServers$default$5() {
        return None$.MODULE$;
    }

    private Option<String> makeServers$default$6() {
        return None$.MODULE$;
    }

    private Option<String> makeServers$default$7() {
        return None$.MODULE$;
    }

    private Option<ApiVersion> makeServers$default$8() {
        return None$.MODULE$;
    }

    private int makeServers$default$9() {
        return 1;
    }

    private int makeServers$default$10() {
        return 0;
    }

    private Timer timer(String metricName) {
        return (Timer)((MapLike)((TraversableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala()).filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ControllerIntegrationTest.$anonfun$timer$1(metricName, x0$1)))).values().headOption().getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new AssertionError((Object)new StringBuilder(22).append("Unable to find metric ").append(metricName).toString());
        });
    }

    private KafkaServer getController() {
        int controllerId = TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), TestUtils$.MODULE$.waitUntilControllerElected$default$2());
        return (KafkaServer)((IterableLike)this.servers().filter((Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToBoolean((boolean)ControllerIntegrationTest.$anonfun$getController$1(controllerId, s)))).head();
    }

    public static final /* synthetic */ boolean $anonfun$testEmptyCluster$1(ControllerIntegrationTest $this) {
        return $this.zkClient().getControllerId().isDefined();
    }

    public static final /* synthetic */ String $anonfun$testEmptyCluster$2() {
        return "failed to elect a controller";
    }

    public static final /* synthetic */ boolean $anonfun$testControllerEpochPersistsWhenAllBrokersDown$1(ControllerIntegrationTest $this) {
        return $this.zkClient().getControllerId().isDefined();
    }

    public static final /* synthetic */ String $anonfun$testControllerEpochPersistsWhenAllBrokersDown$2() {
        return "failed to elect a controller";
    }

    public static final /* synthetic */ boolean $anonfun$testControllerEpochPersistsWhenAllBrokersDown$3(ControllerIntegrationTest $this) {
        return !$this.zkClient().getControllerId().isDefined();
    }

    public static final /* synthetic */ String $anonfun$testControllerEpochPersistsWhenAllBrokersDown$4() {
        return "failed to kill controller";
    }

    public static final /* synthetic */ boolean $anonfun$testControllerMoveIncrementsControllerEpoch$1(ControllerIntegrationTest $this) {
        return $this.zkClient().getControllerId().isDefined();
    }

    public static final /* synthetic */ String $anonfun$testControllerMoveIncrementsControllerEpoch$2() {
        return "failed to elect a controller";
    }

    public static final /* synthetic */ boolean $anonfun$testControllerMoveIncrementsControllerEpoch$3(ControllerIntegrationTest $this) {
        return $this.zkClient().getControllerId().isDefined();
    }

    public static final /* synthetic */ String $anonfun$testControllerMoveIncrementsControllerEpoch$4() {
        return "failed to elect a controller";
    }

    public static final /* synthetic */ boolean $anonfun$testMetadataPropagationOnBrokerChange$1(int controllerId$1, KafkaServer e) {
        return e.config().brokerId() != controllerId$1;
    }

    public static final /* synthetic */ boolean $anonfun$testMetadataPropagationOnBrokerChange$2(KafkaServer testBroker$1, KafkaServer x$1) {
        return x$1.config().brokerId() != testBroker$1.config().brokerId();
    }

    public static final /* synthetic */ int $anonfun$testMetadataPropagationOnBrokerChange$3(KafkaServer x$2) {
        return x$2.config().brokerId();
    }

    public static final /* synthetic */ void $anonfun$testMetadataPropagationOnBrokerChange$4(String topic$1, KafkaServer testBroker$1, Map assignment$1, Seq remainingBrokers$1, KafkaServer server) {
        UpdateMetadataRequestData.UpdateMetadataPartitionState offlineReplicaPartitionInfo = (UpdateMetadataRequestData.UpdateMetadataPartitionState)server.metadataCache().getPartitionInfo(topic$1, 0).get();
        Assertions.assertEquals((int)1, (int)offlineReplicaPartitionInfo.offlineReplicas().size());
        Assertions.assertEquals((int)testBroker$1.config().brokerId(), (Integer)((Integer)offlineReplicaPartitionInfo.offlineReplicas().get(0)));
        Assertions.assertEquals((Object)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)assignment$1.apply((Object)BoxesRunTime.boxToInteger((int)0))).asJava(), (Object)offlineReplicaPartitionInfo.replicas());
        Assertions.assertEquals((Object)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{((KafkaServer)remainingBrokers$1.head()).config().brokerId()}))).asJava(), (Object)offlineReplicaPartitionInfo.isr());
        UpdateMetadataRequestData.UpdateMetadataPartitionState onlinePartitionInfo = (UpdateMetadataRequestData.UpdateMetadataPartitionState)server.metadataCache().getPartitionInfo(topic$1, 1).get();
        Assertions.assertEquals((Object)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)assignment$1.apply((Object)BoxesRunTime.boxToInteger((int)1))).asJava(), (Object)onlinePartitionInfo.replicas());
        Assertions.assertTrue((boolean)onlinePartitionInfo.offlineReplicas().isEmpty());
    }

    public static final /* synthetic */ boolean $anonfun$testMetadataPropagationOnBrokerChange$7(KafkaServer server$1, String topic$1, Tuple2 x0$1) {
        UpdateMetadataRequestData.UpdateMetadataPartitionState partitionInfo;
        Seq replicas;
        int partitionId;
        if (x0$1 != null) {
            partitionId = x0$1._1$mcI$sp();
            replicas = (Seq)x0$1._2();
        } else {
            throw new MatchError(null);
        }
        Option partitionInfoOpt = server$1.metadataCache().getPartitionInfo(topic$1, partitionId);
        boolean bl = partitionInfoOpt.isDefined() ? !(partitionInfo = (UpdateMetadataRequestData.UpdateMetadataPartitionState)partitionInfoOpt.get()).offlineReplicas().isEmpty() || !((GenSeqLike)CollectionConverters$.MODULE$.asScalaBufferConverter(partitionInfo.replicas()).asScala()).equals((Object)replicas) : true;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$testMetadataPropagationOnBrokerChange$5(ControllerIntegrationTest $this, Map assignment$1, String topic$1) {
        return !$this.servers().exists((Function1 & Serializable & scala.Serializable)server -> BoxesRunTime.boxToBoolean((boolean)assignment$1.exists((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ControllerIntegrationTest.$anonfun$testMetadataPropagationOnBrokerChange$7(server, topic$1, x0$1)))));
    }

    public static final /* synthetic */ String $anonfun$testMetadataPropagationOnBrokerChange$8() {
        return "Inconsistent metadata after broker startup";
    }

    public static final /* synthetic */ boolean $anonfun$testMetadataPropagationForOfflineReplicas$1(int controllerId$2, KafkaServer e) {
        return e.config().brokerId() != controllerId$2;
    }

    public static final /* synthetic */ boolean $anonfun$testMetadataPropagationForOfflineReplicas$2(int controllerId$2, KafkaServer e) {
        return e.config().brokerId() == controllerId$2;
    }

    public static final /* synthetic */ boolean $anonfun$testMetadataPropagationForOfflineReplicas$3(int controllerId$2, KafkaServer replicaBroker$1, KafkaServer e) {
        return e.config().brokerId() != controllerId$2 && e.config().brokerId() != replicaBroker$1.config().brokerId();
    }

    public static final /* synthetic */ boolean $anonfun$testMetadataPropagationForOfflineReplicas$4(KafkaServer broker$1, String topic$2) {
        Option partitionInfoOpt = broker$1.metadataCache().getPartitionInfo(topic$2, 0);
        if (partitionInfoOpt.isDefined()) {
            UpdateMetadataRequestData.UpdateMetadataPartitionState partitionInfo = (UpdateMetadataRequestData.UpdateMetadataPartitionState)partitionInfoOpt.get();
            return !partitionInfo.offlineReplicas().isEmpty() && partitionInfo.leader() == -1 && !partitionInfo.replicas().isEmpty() && !partitionInfo.isr().isEmpty();
        }
        return false;
    }

    public static final /* synthetic */ String $anonfun$testMetadataPropagationForOfflineReplicas$5() {
        return "Inconsistent metadata after broker startup";
    }

    /*
     * WARNING - void declaration
     */
    private static final void verifyMetadata$1(KafkaServer broker, String topic$2) {
        broker.startup();
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ControllerIntegrationTest.$anonfun$testMetadataPropagationForOfflineReplicas$4(broker, topic$2)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ControllerIntegrationTest.$anonfun$testMetadataPropagationForOfflineReplicas$5());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    public static final /* synthetic */ boolean $anonfun$testMetadataPropagationOnBrokerShutdownWithNoReplicas$1(int controllerId$3, KafkaServer e) {
        return e.config().brokerId() != controllerId$3;
    }

    public static final /* synthetic */ boolean $anonfun$testMetadataPropagationOnBrokerShutdownWithNoReplicas$2(int controllerId$3, KafkaServer e) {
        return e.config().brokerId() == controllerId$3;
    }

    public static final /* synthetic */ boolean $anonfun$testMetadataPropagationOnBrokerShutdownWithNoReplicas$3(int controllerId$3, KafkaServer replicaBroker$2, KafkaServer e) {
        return e.config().brokerId() != controllerId$3 && e.config().brokerId() != replicaBroker$2.config().brokerId();
    }

    public static final /* synthetic */ int $anonfun$testTopicCreationWithOfflineReplica$1(KafkaServer x$3) {
        return x$3.config().brokerId();
    }

    public static final /* synthetic */ int $anonfun$testTopicPartitionExpansionWithOfflineReplica$1(KafkaServer x$5) {
        return x$5.config().brokerId();
    }

    public static final /* synthetic */ int $anonfun$testPartitionReassignment$1(KafkaServer x$7) {
        return x$7.config().brokerId();
    }

    public static final /* synthetic */ boolean $anonfun$testPartitionReassignment$4(ControllerIntegrationTest $this, TopicPartition tp$1, Map reassignment$1) {
        Map map = $this.zkClient().getFullReplicaAssignmentForTopics((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{tp$1.topic()})));
        return !(map != null ? !map.equals(reassignment$1) : reassignment$1 != null);
    }

    public static final /* synthetic */ String $anonfun$testPartitionReassignment$5() {
        return "failed to get updated partition assignment on topic znode after partition reassignment";
    }

    public static final /* synthetic */ boolean $anonfun$testPartitionReassignment$6(ControllerIntegrationTest $this) {
        return !$this.zkClient().reassignPartitionsInProgress();
    }

    public static final /* synthetic */ String $anonfun$testPartitionReassignment$7() {
        return "failed to remove reassign partitions path after completion";
    }

    public static final /* synthetic */ boolean $anonfun$testPartitionReassignmentToBrokerWithOfflineLogDir$1(int controllerId$7, KafkaServer x$9) {
        return x$9.config().brokerId() != controllerId$7;
    }

    public static final /* synthetic */ boolean $anonfun$testPartitionReassignmentToBrokerWithOfflineLogDir$3(ControllerIntegrationTest $this, TopicPartition tp$2, Map reassignment$2) {
        Map map = $this.zkClient().getFullReplicaAssignmentForTopics((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{tp$2.topic()})));
        return !(map != null ? !map.equals(reassignment$2) : reassignment$2 != null);
    }

    public static final /* synthetic */ String $anonfun$testPartitionReassignmentToBrokerWithOfflineLogDir$4() {
        return "failed to get updated partition assignment on topic znode after partition reassignment";
    }

    public static final /* synthetic */ boolean $anonfun$testPartitionReassignmentToBrokerWithOfflineLogDir$5(ControllerIntegrationTest $this) {
        return !$this.zkClient().reassignPartitionsInProgress();
    }

    public static final /* synthetic */ String $anonfun$testPartitionReassignmentToBrokerWithOfflineLogDir$6() {
        return "failed to remove reassign partitions path after completion";
    }

    public static final /* synthetic */ int $anonfun$testPartitionReassignmentWithOfflineReplicaHaltingProgress$1(KafkaServer x$10) {
        return x$10.config().brokerId();
    }

    public static final /* synthetic */ boolean $anonfun$testPartitionReassignmentWithOfflineReplicaHaltingProgress$3(ControllerIntegrationTest $this) {
        return $this.zkClient().reassignPartitionsInProgress();
    }

    public static final /* synthetic */ String $anonfun$testPartitionReassignmentWithOfflineReplicaHaltingProgress$4() {
        return "partition reassignment path should remain while reassignment in progress";
    }

    public static final /* synthetic */ int $anonfun$testPartitionReassignmentResumesAfterReplicaComesOnline$1(KafkaServer x$12) {
        return x$12.config().brokerId();
    }

    public static final /* synthetic */ boolean $anonfun$testPartitionReassignmentResumesAfterReplicaComesOnline$4(ControllerIntegrationTest $this, TopicPartition tp$3, Map reassignment$3) {
        Map map = $this.zkClient().getFullReplicaAssignmentForTopics((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{tp$3.topic()})));
        return !(map != null ? !map.equals(reassignment$3) : reassignment$3 != null);
    }

    public static final /* synthetic */ String $anonfun$testPartitionReassignmentResumesAfterReplicaComesOnline$5() {
        return "failed to get updated partition assignment on topic znode after partition reassignment";
    }

    public static final /* synthetic */ boolean $anonfun$testPartitionReassignmentResumesAfterReplicaComesOnline$6(ControllerIntegrationTest $this) {
        return !$this.zkClient().reassignPartitionsInProgress();
    }

    public static final /* synthetic */ String $anonfun$testPartitionReassignmentResumesAfterReplicaComesOnline$7() {
        return "failed to remove reassign partitions path after completion";
    }

    public static final /* synthetic */ boolean $anonfun$testPreferredReplicaLeaderElection$1(int controllerId$10, KafkaServer x$14) {
        return x$14.config().brokerId() != controllerId$10;
    }

    public static final /* synthetic */ boolean $anonfun$testBackToBackPreferredReplicaLeaderElections$1(int controllerId$11, KafkaServer x$15) {
        return x$15.config().brokerId() != controllerId$11;
    }

    public static final /* synthetic */ int $anonfun$testPreferredReplicaLeaderElectionWithOfflinePreferredReplica$1(KafkaServer x$16) {
        return x$16.config().brokerId();
    }

    public static final /* synthetic */ boolean $anonfun$testPreferredReplicaLeaderElectionWithOfflinePreferredReplica$3(ControllerIntegrationTest $this) {
        return !$this.zkClient().pathExists(PreferredReplicaElectionZNode$.MODULE$.path());
    }

    public static final /* synthetic */ String $anonfun$testPreferredReplicaLeaderElectionWithOfflinePreferredReplica$4() {
        return "failed to remove preferred replica leader election path after giving up";
    }

    public static final /* synthetic */ int $anonfun$testAutoPreferredReplicaLeaderElection$1(KafkaServer x$18) {
        return x$18.config().brokerId();
    }

    public static final /* synthetic */ int $anonfun$testLeaderAndIsrWhenEntireIsrOfflineAndUncleanLeaderElectionDisabled$1(KafkaServer x$20) {
        return x$20.config().brokerId();
    }

    public static final /* synthetic */ boolean $anonfun$testLeaderAndIsrWhenEntireIsrOfflineAndUncleanLeaderElectionDisabled$3(ControllerIntegrationTest $this, TopicPartition tp$4, int otherBrokerId$1) {
        Map leaderIsrAndControllerEpochMap = $this.zkClient().getTopicPartitionStates((Seq)new .colon.colon((Object)tp$4, (List)Nil$.MODULE$));
        if (leaderIsrAndControllerEpochMap.contains((Object)tp$4) && $this.isExpectedPartitionState((LeaderIsrAndControllerEpoch)leaderIsrAndControllerEpochMap.apply((Object)tp$4), $this.firstControllerEpoch(), LeaderAndIsr$.MODULE$.NoLeader(), LeaderAndIsr$.MODULE$.initialLeaderEpoch() + 1)) {
            List list = ((LeaderIsrAndControllerEpoch)leaderIsrAndControllerEpochMap.apply((Object)tp$4)).leaderAndIsr().isr();
            List list2 = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{otherBrokerId$1}));
            if (!(list != null ? !list.equals(list2) : list2 != null)) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ String $anonfun$testLeaderAndIsrWhenEntireIsrOfflineAndUncleanLeaderElectionDisabled$4() {
        return "failed to get expected partition state after entire isr went offline";
    }

    public static final /* synthetic */ int $anonfun$testLeaderAndIsrWhenEntireIsrOfflineAndUncleanLeaderElectionEnabled$1(KafkaServer x$22) {
        return x$22.config().brokerId();
    }

    public static final /* synthetic */ boolean $anonfun$testLeaderAndIsrWhenEntireIsrOfflineAndUncleanLeaderElectionEnabled$3(ControllerIntegrationTest $this, TopicPartition tp$5, int otherBrokerId$2) {
        Map leaderIsrAndControllerEpochMap = $this.zkClient().getTopicPartitionStates((Seq)new .colon.colon((Object)tp$5, (List)Nil$.MODULE$));
        if (leaderIsrAndControllerEpochMap.contains((Object)tp$5) && $this.isExpectedPartitionState((LeaderIsrAndControllerEpoch)leaderIsrAndControllerEpochMap.apply((Object)tp$5), $this.firstControllerEpoch(), LeaderAndIsr$.MODULE$.NoLeader(), LeaderAndIsr$.MODULE$.initialLeaderEpoch() + 1)) {
            List list = ((LeaderIsrAndControllerEpoch)leaderIsrAndControllerEpochMap.apply((Object)tp$5)).leaderAndIsr().isr();
            List list2 = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{otherBrokerId$2}));
            if (!(list != null ? !list.equals(list2) : list2 != null)) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ String $anonfun$testLeaderAndIsrWhenEntireIsrOfflineAndUncleanLeaderElectionEnabled$4() {
        return "failed to get expected partition state after entire isr went offline";
    }

    public static final /* synthetic */ boolean $anonfun$testControlledShutdown$3(int controllerId$16, KafkaServer p) {
        return p.config().brokerId() == controllerId$16;
    }

    public static final /* synthetic */ boolean $anonfun$testControlledShutdown$5(KafkaServer x$24) {
        return x$24.config().brokerId() == 2;
    }

    public static final /* synthetic */ boolean $anonfun$testControlledShutdown$6(KafkaServer s) {
        return s.config().brokerId() != 2;
    }

    public static final /* synthetic */ boolean $anonfun$testControlledShutdown$8(String topic$3, int partition$1, KafkaServer x$25) {
        return ((UpdateMetadataRequestData.UpdateMetadataPartitionState)x$25.dataPlaneRequestProcessor().metadataCache().getPartitionInfo(topic$3, partition$1).get()).isr().size() != 3;
    }

    public static final /* synthetic */ boolean $anonfun$testControlledShutdown$7(ObjectRef activeServers$1, String topic$3, int partition$1) {
        return ((Seq)activeServers$1.elem).forall((Function1 & Serializable & scala.Serializable)x$25 -> BoxesRunTime.boxToBoolean((boolean)ControllerIntegrationTest.$anonfun$testControlledShutdown$8(topic$3, partition$1, x$25)));
    }

    public static final /* synthetic */ String $anonfun$testControlledShutdown$9() {
        return "Topic test not created after timeout";
    }

    public static final /* synthetic */ boolean $anonfun$testControlledShutdown$10(KafkaServer x$26) {
        return x$26.config().brokerId() == 1;
    }

    public static final /* synthetic */ boolean $anonfun$testControlledShutdown$11(KafkaServer s) {
        return s.config().brokerId() == 0;
    }

    public static final /* synthetic */ boolean $anonfun$testControlledShutdown$12(String topic$3, int partition$1, KafkaServer x$27) {
        return ((UpdateMetadataRequestData.UpdateMetadataPartitionState)x$27.dataPlaneRequestProcessor().metadataCache().getPartitionInfo(topic$3, partition$1).get()).leader() == 0;
    }

    public static final /* synthetic */ boolean $anonfun$testControlledShutdown$13(KafkaServer x$28) {
        return x$28.config().brokerId() == 0;
    }

    public static final /* synthetic */ boolean $anonfun$testControlledShutdown$14(String topic$3, int partition$1, KafkaServer x$29) {
        return ((UpdateMetadataRequestData.UpdateMetadataPartitionState)x$29.dataPlaneRequestProcessor().metadataCache().getPartitionInfo(topic$3, partition$1).get()).leader() == 0;
    }

    public static final /* synthetic */ boolean $anonfun$testControllerRejectControlledShutdownRequestWithStaleBrokerEpoch$3(KafkaController controller$1, KafkaServer e) {
        return e.config().brokerId() != controller$1.config().brokerId();
    }

    public static final /* synthetic */ void $anonfun$testControllerRejectControlledShutdownRequestWithStaleBrokerEpoch$4(VolatileBooleanRef staleBrokerEpochDetected$1, Try x0$1) {
        if (x0$1 instanceof Failure && ((Failure)x0$1).exception() instanceof StaleBrokerEpochException) {
            staleBrokerEpochDetected$1.elem = true;
            return;
        }
    }

    public static final /* synthetic */ String $anonfun$testControllerRejectControlledShutdownRequestWithStaleBrokerEpoch$6() {
        return "Fail to detect stale broker epoch";
    }

    public static final /* synthetic */ void $anonfun$testControllerMoveOnTopicCreation$1(ControllerIntegrationTest $this, TopicPartition tp$6, Map assignment$2) {
        AdminZkClient adminZkClient = new AdminZkClient($this.zkClient());
        adminZkClient.createTopicWithAssignment(tp$6.topic(), new Properties(), assignment$2, adminZkClient.createTopicWithAssignment$default$4(), adminZkClient.createTopicWithAssignment$default$5());
    }

    public static final /* synthetic */ void $anonfun$testControllerMoveOnTopicDeletion$1(ControllerIntegrationTest $this, TopicPartition tp$7) {
        new AdminZkClient($this.zkClient()).deleteTopic(tp$7.topic());
    }

    public static final /* synthetic */ void $anonfun$testControllerMoveOnPreferredReplicaElection$1(ControllerIntegrationTest $this, TopicPartition tp$8) {
        $this.zkClient().createPreferredReplicaElection((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp$8})));
    }

    public static final /* synthetic */ void $anonfun$testControllerMoveOnPartitionReassignment$1(ControllerIntegrationTest $this, Map reassignment$4) {
        $this.zkClient().createPartitionReassignment(reassignment$4);
    }

    public static final /* synthetic */ boolean $anonfun$testControllerDetectsBouncedBrokers$1(KafkaController controller$2, KafkaServer e) {
        return e.config().brokerId() != controller$2.config().brokerId();
    }

    public static final /* synthetic */ boolean $anonfun$testControllerDetectsBouncedBrokers$2(KafkaController controller$2) {
        ControllerState controllerState = controller$2.eventManager().state();
        ControllerState.Idle$ idle$ = ControllerState.Idle$.MODULE$;
        return !(controllerState != null ? !controllerState.equals(idle$) : idle$ != null);
    }

    public static final /* synthetic */ String $anonfun$testControllerDetectsBouncedBrokers$3() {
        return "Controller event thread is still busy";
    }

    public static final /* synthetic */ boolean $anonfun$testControllerDetectsBouncedBrokers$4(KafkaServer otherBroker$1) {
        return BoxesRunTime.unboxToInt((Object)otherBroker$1.replicaManager().partitionCount().value()) == 1 && otherBroker$1.replicaManager().metadataCache().getAllTopics().size() == 1 && otherBroker$1.replicaManager().metadataCache().getAliveBrokers().size() == 2;
    }

    public static final /* synthetic */ String $anonfun$testControllerDetectsBouncedBrokers$5() {
        return "Broker fail to initialize after restart";
    }

    public static final /* synthetic */ boolean $anonfun$testPreemptionOnControllerShutdown$2(IntRef count$1) {
        return count$1.elem == 0;
    }

    public static final /* synthetic */ String $anonfun$testPreemptionOnControllerShutdown$3() {
        return "preemption was not fully completed before shutdown";
    }

    public static final /* synthetic */ void $anonfun$testPreemptionWithCallbacks$2(Tuple2 partition) {
        Either either = (Either)partition._2();
        if (either instanceof Left) {
            ApiError e = (ApiError)((Left)either).value();
            Assertions.assertEquals((Object)Errors.NOT_CONTROLLER, (Object)e.error());
            return;
        }
        if (either instanceof Right) {
            throw new AssertionError((Object)"replica leader election should error");
        }
        throw new MatchError((Object)either);
    }

    public static final /* synthetic */ void $anonfun$testPreemptionWithCallbacks$3(Try x0$1) {
        if (x0$1 instanceof Success) {
            throw new AssertionError((Object)"controlled shutdown should error");
        }
        if (x0$1 instanceof Failure) {
            Throwable e = ((Failure)x0$1).exception();
            Assertions.assertEquals(ControllerMovedException.class, e.getClass());
            return;
        }
        throw new MatchError((Object)x0$1);
    }

    public static final /* synthetic */ void $anonfun$testPreemptionWithCallbacks$4(Either x0$2) {
        if (x0$2 instanceof Left) {
            throw new AssertionError((Object)"api partition reassignment should error");
        }
        if (x0$2 instanceof Right) {
            ApiError e = (ApiError)((Right)x0$2).value();
            Assertions.assertEquals((Object)Errors.NOT_CONTROLLER, (Object)e.error());
            return;
        }
        throw new MatchError((Object)x0$2);
    }

    public static final /* synthetic */ void $anonfun$testPreemptionWithCallbacks$5(Either x0$3) {
        if (x0$3 instanceof Left) {
            throw new AssertionError((Object)"api partition reassignment should error");
        }
        if (x0$3 instanceof Right) {
            ApiError e = (ApiError)((Right)x0$3).value();
            Assertions.assertEquals((Object)Errors.NOT_CONTROLLER, (Object)e.error());
            return;
        }
        throw new MatchError((Object)x0$3);
    }

    public static final /* synthetic */ boolean $anonfun$testIdempotentAlterIsr$1(int controllerId$17, KafkaServer x$33) {
        return x$33.config().brokerId() != controllerId$17;
    }

    public static final /* synthetic */ void $anonfun$testIdempotentAlterIsr$2(TopicPartition tp$9, LeaderAndIsr newLeaderAndIsr$1, CountDownLatch latch$5, Either result) {
        LeaderAndIsr leaderAndIsr;
        Map partitionResults;
        if (result instanceof Left && (partitionResults = (Map)((Left)result).value()) != null) {
            Either either;
            boolean bl = false;
            Some some = null;
            Option option = partitionResults.get((Object)tp$9);
            if (option instanceof Some) {
                bl = true;
                some = (Some)option;
                Either either2 = (Either)some.value();
                if (either2 instanceof Left && (Errors)((Left)either2).value() != null) {
                    throw new AssertionError((Object)new StringBuilder(31).append("Should not have seen error for ").append(tp$9).toString());
                }
            }
            if (!bl || !((either = (Either)some.value()) instanceof Right) || (leaderAndIsr = (LeaderAndIsr)((Right)either).value()) == null) {
                if (None$.MODULE$.equals(option)) {
                    throw new AssertionError((Object)new StringBuilder(27).append("Should have seen ").append(tp$9).append(" in result").toString());
                }
                throw new MatchError((Object)option);
            }
        } else {
            if (result instanceof Right && ((Right)result).value() != null) {
                throw new AssertionError((Object)"Should not have had top-level error here");
            }
            throw new MatchError((Object)result);
        }
        Assertions.assertEquals((Object)leaderAndIsr, (Object)newLeaderAndIsr$1, (String)"ISR should remain unchanged");
        latch$5.countDown();
    }

    public static final /* synthetic */ void $anonfun$captureAlterIsrError$1(CompletableFuture future$1, Either x0$1) {
        Errors error;
        if (x0$1 instanceof Left && ((Left)x0$1).value() != null) {
            future$1.completeExceptionally((Throwable)((Object)new AssertionError((Object)"Should have seen top-level error")));
            return;
        }
        if (x0$1 instanceof Right && (error = (Errors)((Right)x0$1).value()) != null) {
            future$1.complete(error);
            return;
        }
        throw new MatchError((Object)x0$1);
    }

    public static final /* synthetic */ void $anonfun$captureAlterIsrPartitionError$1(TopicPartition tp$10, CompletableFuture future$2, Either x0$1) {
        Map partitionResults;
        if (x0$1 instanceof Left && (partitionResults = (Map)((Left)x0$1).value()) != null) {
            Either either;
            boolean bl = false;
            Some some = null;
            Option option = partitionResults.get((Object)tp$10);
            if (option instanceof Some) {
                Errors error;
                bl = true;
                some = (Some)option;
                Either either2 = (Either)some.value();
                if (either2 instanceof Left && (error = (Errors)((Left)either2).value()) != null) {
                    future$2.complete(error);
                    return;
                }
            }
            if (bl && (either = (Either)some.value()) instanceof Right && ((Right)either).value() != null) {
                future$2.completeExceptionally((Throwable)((Object)new AssertionError((Object)new StringBuilder(40).append("Should have seen an error for ").append(tp$10).append(" in result").toString())));
                return;
            }
            if (None$.MODULE$.equals(option)) {
                future$2.completeExceptionally((Throwable)((Object)new AssertionError((Object)new StringBuilder(27).append("Should have seen ").append(tp$10).append(" in result").toString())));
                return;
            }
            throw new MatchError((Object)option);
        }
        if (x0$1 instanceof Right && ((Right)x0$1).value() != null) {
            future$2.completeExceptionally((Throwable)((Object)new AssertionError((Object)"Should not seen top-level error")));
            return;
        }
        throw new MatchError((Object)x0$1);
    }

    public static final /* synthetic */ boolean $anonfun$testTopicIdMigrationAndHandling$1(ControllerIntegrationTest $this, TopicPartition tp$11) {
        return ((KafkaServer)$this.servers().head()).kafkaController().controllerContext().topicIds().get((Object)tp$11.topic()).isEmpty();
    }

    public static final /* synthetic */ String $anonfun$testTopicIdMigrationAndHandling$2() {
        return "topic ID for topic should have been removed from controller context after deletion";
    }

    public static final /* synthetic */ boolean $anonfun$testTopicIdMigrationAndHandlingWithOlderVersion$1(ControllerIntegrationTest $this, TopicPartition tp$12) {
        return !((KafkaServer)$this.servers().head()).kafkaController().controllerContext().allTopics().contains((Object)tp$12.topic());
    }

    public static final /* synthetic */ String $anonfun$testTopicIdMigrationAndHandlingWithOlderVersion$2() {
        return "topic should have been removed from controller context after deletion";
    }

    public static final /* synthetic */ boolean $anonfun$testTopicIdPersistsThroughControllerReelection$1(ControllerIntegrationTest $this) {
        return $this.zkClient().getControllerId().isDefined();
    }

    public static final /* synthetic */ String $anonfun$testTopicIdPersistsThroughControllerReelection$2() {
        return "failed to elect a controller";
    }

    public static final /* synthetic */ boolean $anonfun$testNoTopicIdPersistsThroughControllerReelection$1(ControllerIntegrationTest $this) {
        return $this.zkClient().getControllerId().isDefined();
    }

    public static final /* synthetic */ String $anonfun$testNoTopicIdPersistsThroughControllerReelection$2() {
        return "failed to elect a controller";
    }

    public static final /* synthetic */ boolean $anonfun$testTopicIdPersistsThroughControllerRestart$1(ControllerIntegrationTest $this) {
        return $this.zkClient().getControllerId().isDefined();
    }

    public static final /* synthetic */ String $anonfun$testTopicIdPersistsThroughControllerRestart$2() {
        return "failed to elect a controller";
    }

    public static final /* synthetic */ boolean $anonfun$testTopicIdCreatedOnUpgrade$1(ControllerIntegrationTest $this) {
        return $this.zkClient().getControllerId().isDefined();
    }

    public static final /* synthetic */ String $anonfun$testTopicIdCreatedOnUpgrade$2() {
        return "failed to elect a controller";
    }

    public static final /* synthetic */ Option $anonfun$testTopicIdCreatedOnUpgrade$3(ControllerIntegrationTest $this, TopicPartition tp$13) {
        return $this.zkClient().getTopicIdsForTopics((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{tp$13.topic()}))).get((Object)tp$13.topic());
    }

    public static final /* synthetic */ boolean $anonfun$testTopicIdCreatedOnUpgrade$5(ControllerIntegrationTest $this, TopicPartition tp$13) {
        LogManager qual$1 = ((KafkaServer)$this.servers().apply(0)).logManager();
        boolean x$12 = qual$1.getLog$default$2();
        return qual$1.getLog(tp$13, x$12).isDefined();
    }

    public static final /* synthetic */ String $anonfun$testTopicIdCreatedOnUpgrade$6() {
        return "log was not created";
    }

    public static final /* synthetic */ boolean $anonfun$testTopicIdCreatedOnUpgrade$7(ControllerIntegrationTest $this, TopicPartition tp$13) {
        return !((KafkaServer)$this.servers().head()).kafkaController().controllerContext().allTopics().contains((Object)tp$13.topic());
    }

    public static final /* synthetic */ String $anonfun$testTopicIdCreatedOnUpgrade$8() {
        return "topic should have been removed from controller context after deletion";
    }

    public static final /* synthetic */ boolean $anonfun$testTopicIdCreatedOnUpgradeMultiBrokerScenario$1(int originalControllerId$1, KafkaServer x$35) {
        return x$35.config().brokerId() != originalControllerId$1;
    }

    public static final /* synthetic */ int $anonfun$testTopicIdCreatedOnUpgradeMultiBrokerScenario$2(KafkaServer x$36) {
        return x$36.config().brokerId();
    }

    public static final /* synthetic */ boolean $anonfun$testTopicIdCreatedOnUpgradeMultiBrokerScenario$4(KafkaServer server$2, TopicPartition tp$14) {
        LogManager qual$1 = server$2.logManager();
        boolean x$22 = qual$1.getLog$default$2();
        return qual$1.getLog(tp$14, x$22).isDefined();
    }

    public static final /* synthetic */ String $anonfun$testTopicIdCreatedOnUpgradeMultiBrokerScenario$5(KafkaServer server$2) {
        return new StringBuilder(30).append("log was not created for server").append(server$2.config().brokerId()).toString();
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$testTopicIdCreatedOnUpgradeMultiBrokerScenario$3(TopicPartition tp$14, KafkaServer server) {
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ControllerIntegrationTest.$anonfun$testTopicIdCreatedOnUpgradeMultiBrokerScenario$4(server, tp$14)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ControllerIntegrationTest.$anonfun$testTopicIdCreatedOnUpgradeMultiBrokerScenario$5(server));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        LogManager qual$2 = server.logManager();
        boolean x$24 = qual$2.getLog$default$2();
        Option topicIdInLog = ((UnifiedLog)qual$2.getLog(tp$14, x$24).get()).topicId();
        Assertions.assertEquals((Object)None$.MODULE$, (Object)topicIdInLog);
    }

    public static final /* synthetic */ boolean $anonfun$testTopicIdCreatedOnUpgradeMultiBrokerScenario$6(ControllerIntegrationTest $this) {
        return $this.zkClient().getControllerId().isDefined();
    }

    public static final /* synthetic */ String $anonfun$testTopicIdCreatedOnUpgradeMultiBrokerScenario$7() {
        return "failed to elect a controller";
    }

    public static final /* synthetic */ boolean $anonfun$testTopicIdCreatedOnUpgradeMultiBrokerScenario$9(KafkaServer server$3, TopicPartition tp$14) {
        LogManager qual$3 = server$3.logManager();
        boolean x$26 = qual$3.getLog$default$2();
        return qual$3.getLog(tp$14, x$26).isDefined();
    }

    public static final /* synthetic */ String $anonfun$testTopicIdCreatedOnUpgradeMultiBrokerScenario$10(KafkaServer server$3) {
        return new StringBuilder(30).append("log was not created for server").append(server$3.config().brokerId()).toString();
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$testTopicIdCreatedOnUpgradeMultiBrokerScenario$8(TopicPartition tp$14, Uuid topicId$1, KafkaServer server) {
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ControllerIntegrationTest.$anonfun$testTopicIdCreatedOnUpgradeMultiBrokerScenario$9(server, tp$14)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ControllerIntegrationTest.$anonfun$testTopicIdCreatedOnUpgradeMultiBrokerScenario$10(server));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        LogManager qual$4 = server.logManager();
        boolean x$28 = qual$4.getLog$default$2();
        Option topicIdInLog = ((UnifiedLog)qual$4.getLog(tp$14, x$28).get()).topicId();
        Assertions.assertEquals((Object)new Some((Object)topicId$1), (Object)topicIdInLog, (String)new StringBuilder(46).append("Server ").append(server.config().brokerId()).append(" had topic ID ").append(topicIdInLog).append(" instead of ").append(new Some((Object)topicId$1)).append(" as expected.").toString());
    }

    public static final /* synthetic */ boolean $anonfun$testTopicIdCreatedOnUpgradeMultiBrokerScenario$11(ControllerIntegrationTest $this, TopicPartition tp$14) {
        return !((KafkaServer)$this.servers().head()).kafkaController().controllerContext().allTopics().contains((Object)tp$14.topic());
    }

    public static final /* synthetic */ String $anonfun$testTopicIdCreatedOnUpgradeMultiBrokerScenario$12() {
        return "topic should have been removed from controller context after deletion";
    }

    public static final /* synthetic */ void $anonfun$testTopicIdUpgradeAfterReassigningPartitions$1(Either x$37) {
    }

    public static final /* synthetic */ boolean $anonfun$testTopicIdUpgradeAfterReassigningPartitions$2(ControllerIntegrationTest $this, TopicPartition tp$15) {
        return ((KafkaServer)$this.servers().head()).kafkaController().controllerContext().topicIds().get((Object)tp$15.topic()).isEmpty();
    }

    public static final /* synthetic */ String $anonfun$testTopicIdUpgradeAfterReassigningPartitions$3() {
        return "topic ID for topic should have been removed from controller context after deletion";
    }

    public static final /* synthetic */ boolean $anonfun$testControllerMove$1(KafkaController controller$3) {
        ControllerState controllerState = controller$3.eventManager().state();
        ControllerState.Idle$ idle$ = ControllerState.Idle$.MODULE$;
        return !(controllerState != null ? !controllerState.equals(idle$) : idle$ != null);
    }

    public static final /* synthetic */ String $anonfun$testControllerMove$2() {
        return "Controller event thread is still busy";
    }

    public static final /* synthetic */ boolean $anonfun$testControllerMove$3(KafkaController controller$3) {
        return !controller$3.isActive();
    }

    public static final /* synthetic */ String $anonfun$testControllerMove$4() {
        return "Controller fails to resign";
    }

    public static final /* synthetic */ boolean $anonfun$testControllerMove$5(LoggingEvent e) {
        Level level = e.getLevel();
        Level level2 = Level.INFO;
        if (!(level != null ? !level.equals(level2) : level2 != null)) {
            if (e.getThrowableInformation() != null && e.getThrowableInformation().getThrowable().getClass().getName().equals(ControllerMovedException.class.getName())) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$preferredReplicaLeaderElection$1(ControllerIntegrationTest $this, TopicPartition tp$16, scala.collection.immutable.Set replicas$1) {
        scala.collection.immutable.Set set = ((TraversableOnce)$this.zkClient().getInSyncReplicasForPartition(new TopicPartition(tp$16.topic(), tp$16.partition())).get()).toSet();
        return !(set != null ? !set.equals(replicas$1) : replicas$1 != null);
    }

    public static final /* synthetic */ String $anonfun$preferredReplicaLeaderElection$2() {
        return "restarted broker failed to join in-sync replicas";
    }

    public static final /* synthetic */ boolean $anonfun$preferredReplicaLeaderElection$3(ControllerIntegrationTest $this) {
        return !$this.zkClient().pathExists(PreferredReplicaElectionZNode$.MODULE$.path());
    }

    public static final /* synthetic */ String $anonfun$preferredReplicaLeaderElection$4() {
        return "failed to remove preferred replica leader election path after completion";
    }

    public static final /* synthetic */ boolean $anonfun$waitUntilControllerEpoch$1(ControllerIntegrationTest $this, int epoch$1) {
        return $this.zkClient().getControllerEpoch().map((Function1 & Serializable & scala.Serializable)x$38 -> BoxesRunTime.boxToInteger((int)x$38._1$mcI$sp())).contains((Object)BoxesRunTime.boxToInteger((int)epoch$1));
    }

    public static final /* synthetic */ boolean $anonfun$waitForPartitionState$1(ControllerIntegrationTest $this, TopicPartition tp$17, int controllerEpoch$1, int leader$1, int leaderEpoch$1) {
        Map leaderIsrAndControllerEpochMap = $this.zkClient().getTopicPartitionStates((Seq)new .colon.colon((Object)tp$17, (List)Nil$.MODULE$));
        return leaderIsrAndControllerEpochMap.contains((Object)tp$17) && $this.isExpectedPartitionState((LeaderIsrAndControllerEpoch)leaderIsrAndControllerEpochMap.apply((Object)tp$17), controllerEpoch$1, leader$1, leaderEpoch$1);
    }

    public static final /* synthetic */ void $anonfun$makeServers$1(boolean autoLeaderRebalanceEnable$1, boolean uncleanLeaderElectionEnable$1, Option listeners$1, Option listenerSecurityProtocolMap$1, Option controlPlaneListenerName$1, Option interBrokerProtocolVersion$1, Properties config) {
        config.setProperty(KafkaConfig$.MODULE$.AutoLeaderRebalanceEnableProp(), Boolean.toString(autoLeaderRebalanceEnable$1));
        config.setProperty(KafkaConfig$.MODULE$.UncleanLeaderElectionEnableProp(), Boolean.toString(uncleanLeaderElectionEnable$1));
        config.setProperty(KafkaConfig$.MODULE$.LeaderImbalanceCheckIntervalSecondsProp(), "1");
        listeners$1.foreach((Function1 & Serializable & scala.Serializable)listener -> config.setProperty(KafkaConfig$.MODULE$.ListenersProp(), (String)listener));
        listenerSecurityProtocolMap$1.foreach((Function1 & Serializable & scala.Serializable)listenerMap -> config.setProperty(KafkaConfig$.MODULE$.ListenerSecurityProtocolMapProp(), (String)listenerMap));
        controlPlaneListenerName$1.foreach((Function1 & Serializable & scala.Serializable)controlPlaneListener -> config.setProperty(KafkaConfig$.MODULE$.ControlPlaneListenerNameProp(), (String)controlPlaneListener));
        interBrokerProtocolVersion$1.foreach((Function1 & Serializable & scala.Serializable)ibp -> config.setProperty(KafkaConfig$.MODULE$.InterBrokerProtocolVersionProp(), ibp.toString()));
    }

    public static final /* synthetic */ boolean $anonfun$timer$1(String metricName$1, Tuple2 x0$1) {
        if (x0$1 == null) {
            throw new MatchError(null);
        }
        String string = ((MetricName)x0$1._1()).getMBeanName();
        boolean bl = !(string != null ? !string.equals(metricName$1) : metricName$1 != null);
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$getController$1(int controllerId$18, KafkaServer s) {
        return s.config().brokerId() == controllerId$18;
    }

    public static final /* synthetic */ Object $anonfun$testTopicIdCreatedOnUpgrade$4$adapted(Option x$34) {
        return BoxesRunTime.boxToBoolean((boolean)x$34.nonEmpty());
    }
}

