/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.io.Serializable;
import java.nio.channels.ClosedChannelException;
import java.util.Collections;
import java.util.Properties;
import java.util.regex.Pattern;
import kafka.log.LocalLog;
import kafka.log.LocalLog$;
import kafka.log.LocalLogTest;
import kafka.log.LocalLogTest$KeyValue$;
import kafka.log.LogConfig;
import kafka.log.LogSegment;
import kafka.log.LogSegment$;
import kafka.log.LogSegments;
import kafka.log.LogTestUtils$;
import kafka.log.SegmentDeletionReason;
import kafka.server.FetchDataInfo;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.LogDirFailureChannel;
import kafka.server.LogOffsetMetadata;
import kafka.utils.MockTime;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0011\u0005b\u0001B4i\u00015DQ\u0001\u001e\u0001\u0005\u0002UDq\u0001\u001f\u0001A\u0002\u0013\u0005\u0011\u0010C\u0005\u0002\u0002\u0001\u0001\r\u0011\"\u0001\u0002\u0004!9\u0011q\u0002\u0001!B\u0013Q\b\"CA\t\u0001\t\u0007I\u0011AA\n\u0011!\t)\u0003\u0001Q\u0001\n\u0005U\u0001\"CA\u0014\u0001\t\u0007I\u0011AA\n\u0011!\tI\u0003\u0001Q\u0001\n\u0005U\u0001\"CA\u0016\u0001\t\u0007I\u0011AA\u0017\u0011!\t)\u0005\u0001Q\u0001\n\u0005=\u0002\"CA$\u0001\t\u0007I\u0011AA%\u0011!\t\t\u0006\u0001Q\u0001\n\u0005-\u0003\"CA*\u0001\t\u0007I\u0011AA+\u0011!\t\u0019\u0007\u0001Q\u0001\n\u0005]\u0003\u0002C5\u0001\u0005\u0004%\t!!\u001a\t\u0011\u00055\u0004\u0001)A\u0005\u0003OBq!a\u001c\u0001\t\u0003\t\t\bC\u0004\u0002\n\u0002!\t!!\u001d\u0007\r\u0005M\u0005\u0001QAK\u0011)\t\u0019k\u0005BK\u0002\u0013\u0005\u0011Q\u0015\u0005\u000b\u0003{\u001b\"\u0011#Q\u0001\n\u0005\u001d\u0006BCA`'\tU\r\u0011\"\u0001\u0002&\"Q\u0011\u0011Y\n\u0003\u0012\u0003\u0006I!a*\t\rQ\u001cB\u0011AAb\u0011\u001d\tim\u0005C\u0001\u0003\u001fD\u0011\"!<\u0014#\u0003%\t!a<\t\u0013\t\u00151#!A\u0005\u0002\t\u001d\u0001\"\u0003B\u0007'E\u0005I\u0011\u0001B\b\u0011%\u0011\u0019bEI\u0001\n\u0003\u0011y\u0001C\u0005\u0003\u0016M\t\t\u0011\"\u0011\u0003\u0018!I!1E\n\u0002\u0002\u0013\u0005!Q\u0005\u0005\n\u0005[\u0019\u0012\u0011!C\u0001\u0005_A\u0011B!\u000f\u0014\u0003\u0003%\tEa\u000f\t\u0013\t%3#!A\u0005\u0002\t-\u0003\"\u0003B+'\u0005\u0005I\u0011\tB,\u0011%\u0011IfEA\u0001\n\u0003\u0012Y\u0006C\u0005\u0003^M\t\t\u0011\"\u0011\u0003`\u001d9!1\r\u0001\t\u0002\t\u0015daBAJ\u0001!\u0005!q\r\u0005\u0007i\u001e\"\tA!\u001b\t\u000f\t-t\u0005\"\u0001\u0003n!I!qO\u0014\u0002\u0002\u0013\u0005%\u0011\u0010\u0005\n\u0005\u007f:\u0013\u0011!CA\u0005\u0003CqAa%\u0001\t\u0013\u0011)\nC\u0004\u00030\u0002!IA!-\t\u000f\te\u0006\u0001\"\u0003\u0003<\"I!Q\u0019\u0001\u0012\u0002\u0013%!q\u0019\u0005\n\u0005\u0017\u0004\u0011\u0013!C\u0005\u0003_DqA!4\u0001\t\u0013\u0011y\rC\u0005\u0003x\u0002\t\n\u0011\"\u0003\u0003H\"I!\u0011 \u0001\u0012\u0002\u0013%\u0011q\u001e\u0005\n\u0005w\u0004\u0011\u0013!C\u0005\u0005{D\u0011b!\u0001\u0001#\u0003%Iaa\u0001\t\u0013\r\u001d\u0001!%A\u0005\n\r%\u0001\"CB\u0007\u0001E\u0005I\u0011BB\u0002\u0011\u001d\u0019y\u0001\u0001C\u0001\u0003cBqa!\u0007\u0001\t\u0003\t\t\bC\u0004\u0004\u001e\u0001!\t!!\u001d\t\u000f\r\u0005\u0002\u0001\"\u0001\u0002r!91Q\u0005\u0001\u0005\u0002\u0005E\u0004bBB\u0015\u0001\u0011\u0005\u0011\u0011\u000f\u0005\b\u0007[\u0001A\u0011AA9\u0011\u001d\u0019\t\u0004\u0001C\u0001\u0003cBqa!\u000e\u0001\t\u0003\t\t\bC\u0004\u0004:\u0001!\t!!\u001d\t\u000f\ru\u0002\u0001\"\u0001\u0002r!91\u0011\t\u0001\u0005\u0002\u0005E\u0004bBB#\u0001\u0011%1q\t\u0005\b\u0007\u001b\u0002A\u0011AA9\u0011\u001d\u0019\t\u0006\u0001C\u0001\u0003cBqa!\u0016\u0001\t\u0013\u00199\u0006C\u0004\u0004\\\u0001!\t!!\u001d\t\u000f\r}\u0003\u0001\"\u0001\u0002r!911\r\u0001\u0005\u0002\u0005E\u0004bBB4\u0001\u0011\u0005\u0011\u0011\u000f\u0005\b\u0007W\u0002A\u0011AA9\u0011\u001d\u0019y\u0007\u0001C\u0001\u0003cBqaa\u001d\u0001\t\u0003\t\t\bC\u0004\u0004x\u0001!Ia!\u001f\t\u000f\r\r\u0005\u0001\"\u0001\u0002r!91q\u0011\u0001\u0005\u0002\u0005E\u0004bBBF\u0001\u0011\u0005\u0011\u0011\u000f\u0005\b\u0007\u001f\u0003A\u0011AA9\u0011\u001d\u0019\u0019\n\u0001C\u0001\u0003cBqaa&\u0001\t\u0003\t\t\bC\u0004\u0004\u001c\u0002!\t!!\u001d\t\u000f\r}\u0005\u0001\"\u0001\u0002r!911\u0015\u0001\u0005\u0002\u0005E\u0004bBBT\u0001\u0011\u0005\u0011\u0011\u000f\u0005\b\u0007W\u0003A\u0011AA9\u0011\u001d\u0019y\u000b\u0001C\u0001\u0003cBqaa-\u0001\t\u0003\t\t\bC\u0004\u00048\u0002!\t!!\u001d\t\u000f\rm\u0006\u0001\"\u0003\u0004>\"I1\u0011 \u0001\u0012\u0002\u0013%11 \u0005\n\u0007\u007f\u0004\u0011\u0013!C\u0005\t\u0003A\u0011\u0002\"\u0002\u0001#\u0003%I!a<\t\u0013\u0011\u001d\u0001!%A\u0005\n\r%\u0001\"\u0003C\u0005\u0001E\u0005I\u0011\u0002C\u0006\u0011%!y\u0001AI\u0001\n\u0013!\t\u0002C\u0005\u0005\u0016\u0001\t\n\u0011\"\u0003\u0005\u0018!IA1\u0004\u0001\u0012\u0002\u0013%AQ\u0004\u0002\r\u0019>\u001c\u0017\r\u001c'pOR+7\u000f\u001e\u0006\u0003S*\f1\u0001\\8h\u0015\u0005Y\u0017!B6bM.\f7\u0001A\n\u0003\u00019\u0004\"a\u001c:\u000e\u0003AT\u0011!]\u0001\u0006g\u000e\fG.Y\u0005\u0003gB\u0014a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001w!\t9\b!D\u0001i\u0003\u0019\u0019wN\u001c4jOV\t!\u0010\u0005\u0002|}6\tAP\u0003\u0002~U\u000611/\u001a:wKJL!a ?\u0003\u0017-\u000bgm[1D_:4\u0017nZ\u0001\u000bG>tg-[4`I\u0015\fH\u0003BA\u0003\u0003\u0017\u00012a\\A\u0004\u0013\r\tI\u0001\u001d\u0002\u0005+:LG\u000f\u0003\u0005\u0002\u000e\r\t\t\u00111\u0001{\u0003\rAH%M\u0001\bG>tg-[4!\u0003\u0019!X\u000e\u001d#jeV\u0011\u0011Q\u0003\t\u0005\u0003/\t\t#\u0004\u0002\u0002\u001a)!\u00111DA\u000f\u0003\tIwN\u0003\u0002\u0002 \u0005!!.\u0019<b\u0013\u0011\t\u0019#!\u0007\u0003\t\u0019KG.Z\u0001\bi6\u0004H)\u001b:!\u0003\u0019awn\u001a#je\u00069An\\4ESJ\u0004\u0013A\u0004;pa&\u001c\u0007+\u0019:uSRLwN\\\u000b\u0003\u0003_\u0001B!!\r\u0002B5\u0011\u00111\u0007\u0006\u0005\u0003k\t9$\u0001\u0004d_6lwN\u001c\u0006\u0004W\u0006e\"\u0002BA\u001e\u0003{\ta!\u00199bG\",'BAA \u0003\ry'oZ\u0005\u0005\u0003\u0007\n\u0019D\u0001\bU_BL7\rU1si&$\u0018n\u001c8\u0002\u001fQ|\u0007/[2QCJ$\u0018\u000e^5p]\u0002\nA\u0003\\8h\t&\u0014h)Y5mkJ,7\t[1o]\u0016dWCAA&!\rY\u0018QJ\u0005\u0004\u0003\u001fb(\u0001\u0006'pO\u0012K'OR1jYV\u0014Xm\u00115b]:,G.A\u000bm_\u001e$\u0015N\u001d$bS2,(/Z\"iC:tW\r\u001c\u0011\u0002\u00115|7m\u001b+j[\u0016,\"!a\u0016\u0011\t\u0005e\u0013qL\u0007\u0003\u00037R1!!\u0018k\u0003\u0015)H/\u001b7t\u0013\u0011\t\t'a\u0017\u0003\u00115{7m\u001b+j[\u0016\f\u0011\"\\8dWRKW.\u001a\u0011\u0016\u0005\u0005\u001d\u0004cA<\u0002j%\u0019\u00111\u000e5\u0003\u00111{7-\u00197M_\u001e\fA\u0001\\8hA\u0005)1/\u001a;VaR\u0011\u0011Q\u0001\u0015\u0004#\u0005U\u0004\u0003BA<\u0003\u000bk!!!\u001f\u000b\t\u0005m\u0014QP\u0001\u0004CBL'\u0002BA@\u0003\u0003\u000bqA[;qSR,'O\u0003\u0003\u0002\u0004\u0006u\u0012!\u00026v]&$\u0018\u0002BAD\u0003s\u0012!BQ3g_J,W)Y2i\u0003!!X-\u0019:E_^t\u0007f\u0001\n\u0002\u000eB!\u0011qOAH\u0013\u0011\t\t*!\u001f\u0003\u0013\u00053G/\u001a:FC\u000eD'\u0001C&fsZ\u000bG.^3\u0014\rMq\u0017qSAO!\ry\u0017\u0011T\u0005\u0004\u00037\u0003(a\u0002)s_\u0012,8\r\u001e\t\u0004_\u0006}\u0015bAAQa\na1+\u001a:jC2L'0\u00192mK\u0006\u00191.Z=\u0016\u0005\u0005\u001d\u0006\u0003BAU\u0003osA!a+\u00024B\u0019\u0011Q\u00169\u000e\u0005\u0005=&bAAYY\u00061AH]8pizJ1!!.q\u0003\u0019\u0001&/\u001a3fM&!\u0011\u0011XA^\u0005\u0019\u0019FO]5oO*\u0019\u0011Q\u00179\u0002\t-,\u0017\u0010I\u0001\u0006m\u0006dW/Z\u0001\u0007m\u0006dW/\u001a\u0011\u0015\r\u0005\u0015\u0017\u0011ZAf!\r\t9mE\u0007\u0002\u0001!9\u00111\u0015\rA\u0002\u0005\u001d\u0006bBA`1\u0001\u0007\u0011qU\u0001\ti>\u0014VmY8sIR!\u0011\u0011[Ao!\u0011\t\u0019.!7\u000e\u0005\u0005U'\u0002BAl\u0003g\taA]3d_J$\u0017\u0002BAn\u0003+\u0014AbU5na2,'+Z2pe\u0012D\u0011\"a8\u001a!\u0013\u0005\r!!9\u0002\u0013QLW.Z:uC6\u0004\b#B8\u0002d\u0006\u001d\u0018bAAsa\nAAHY=oC6,g\bE\u0002p\u0003SL1!a;q\u0005\u0011auN\\4\u0002%Q|'+Z2pe\u0012$C-\u001a4bk2$H%M\u000b\u0003\u0003cTC!a:\u0002t.\u0012\u0011Q\u001f\t\u0005\u0003o\u0014\t!\u0004\u0002\u0002z*!\u00111`A\u007f\u0003%)hn\u00195fG.,GMC\u0002\u0002\u0000B\f!\"\u00198o_R\fG/[8o\u0013\u0011\u0011\u0019!!?\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\u0003d_BLHCBAc\u0005\u0013\u0011Y\u0001C\u0005\u0002$n\u0001\n\u00111\u0001\u0002(\"I\u0011qX\u000e\u0011\u0002\u0003\u0007\u0011qU\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\u0011\tB\u000b\u0003\u0002(\u0006M\u0018AD2paf$C-\u001a4bk2$HEM\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\te\u0001\u0003\u0002B\u000e\u0005Ci!A!\b\u000b\t\t}\u0011QD\u0001\u0005Y\u0006tw-\u0003\u0003\u0002:\nu\u0011\u0001\u00049s_\u0012,8\r^!sSRLXC\u0001B\u0014!\ry'\u0011F\u0005\u0004\u0005W\u0001(aA%oi\u0006q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003\u0002B\u0019\u0005o\u00012a\u001cB\u001a\u0013\r\u0011)\u0004\u001d\u0002\u0004\u0003:L\b\"CA\u0007A\u0005\u0005\t\u0019\u0001B\u0014\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XC\u0001B\u001f!\u0019\u0011yD!\u0012\u000325\u0011!\u0011\t\u0006\u0004\u0005\u0007\u0002\u0018AC2pY2,7\r^5p]&!!q\tB!\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\t\t5#1\u000b\t\u0004_\n=\u0013b\u0001B)a\n9!i\\8mK\u0006t\u0007\"CA\u0007E\u0005\u0005\t\u0019\u0001B\u0019\u0003!A\u0017m\u001d5D_\u0012,GC\u0001B\u0014\u0003!!xn\u0015;sS:<GC\u0001B\r\u0003\u0019)\u0017/^1mgR!!Q\nB1\u0011%\ti!JA\u0001\u0002\u0004\u0011\t$\u0001\u0005LKf4\u0016\r\\;f!\r\t9mJ\n\u0005O9\fi\n\u0006\u0002\u0003f\u0005QaM]8n%\u0016\u001cwN\u001d3\u0015\t\u0005\u0015'q\u000e\u0005\b\u0003/L\u0003\u0019\u0001B9!\u0011\t\u0019Na\u001d\n\t\tU\u0014Q\u001b\u0002\u0007%\u0016\u001cwN\u001d3\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\r\u0005\u0015'1\u0010B?\u0011\u001d\t\u0019K\u000ba\u0001\u0003OCq!a0+\u0001\u0004\t9+A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\t\r%q\u0012\t\u0006_\n\u0015%\u0011R\u0005\u0004\u0005\u000f\u0003(AB(qi&|g\u000eE\u0004p\u0005\u0017\u000b9+a*\n\u0007\t5\u0005O\u0001\u0004UkBdWM\r\u0005\n\u0005#[\u0013\u0011!a\u0001\u0003\u000b\f1\u0001\u001f\u00131\u00031Ygo\u001d+p%\u0016\u001cwN\u001d3t)\u0011\u00119J!+\u0011\r\te%1UAi\u001d\u0011\u0011YJa(\u000f\t\u00055&QT\u0005\u0002c&\u0019!\u0011\u00159\u0002\u000fA\f7m[1hK&!!Q\u0015BT\u0005!IE/\u001a:bE2,'b\u0001BQa\"9!1\u0016\u0017A\u0002\t5\u0016!C6fsZ\u000bG.^3t!\u0019\u0011IJa)\u0002F\u0006a!/Z2pe\u0012\u001cHk\\&wgR!!Q\u0016BZ\u0011\u001d\u0011),\fa\u0001\u0005o\u000bqA]3d_J$7\u000f\u0005\u0004\u0003\u001a\n\r&\u0011O\u0001\u000eCB\u0004XM\u001c3SK\u000e|'\u000fZ:\u0015\u0011\u0005\u0015!Q\u0018B`\u0005\u0003DqA!./\u0001\u0004\u00119\n\u0003\u0005j]A\u0005\t\u0019AA4\u0011%\u0011\u0019M\fI\u0001\u0002\u0004\t9/A\u0007j]&$\u0018.\u00197PM\u001a\u001cX\r^\u0001\u0018CB\u0004XM\u001c3SK\u000e|'\u000fZ:%I\u00164\u0017-\u001e7uII*\"A!3+\t\u0005\u001d\u00141_\u0001\u0018CB\u0004XM\u001c3SK\u000e|'\u000fZ:%I\u00164\u0017-\u001e7uIM\n1B]3bIJ+7m\u001c:egRq!\u0011\u001bBl\u00053\u0014iNa9\u0003h\nM\bcA>\u0003T&\u0019!Q\u001b?\u0003\u001b\u0019+Go\u00195ECR\f\u0017J\u001c4p\u0011!I\u0017\u0007%AA\u0002\u0005\u001d\u0004\"\u0003BncA\u0005\t\u0019AAt\u0003-\u0019H/\u0019:u\u001f\u001a47/\u001a;\t\u0013\t}\u0017\u0007%CA\u0002\t\u0005\u0018!C7bq2+gn\u001a;i!\u0015y\u00171\u001dB\u0014\u0011%\u0011)/\rI\u0001\u0002\u0004\u0011i%A\u0007nS:|e.Z'fgN\fw-\u001a\u0005\n\u0005S\f\u0004\u0013\"a\u0001\u0005W\f\u0011#\\1y\u001f\u001a47/\u001a;NKR\fG-\u0019;b!\u0015y\u00171\u001dBw!\rY(q^\u0005\u0004\u0005cd(!\u0005'pO>3gm]3u\u001b\u0016$\u0018\rZ1uC\"I!Q_\u0019\u0011\u0002\u0003\u0007!QJ\u0001\u0013S:\u001cG.\u001e3f\u0003\n|'\u000f^3e)bt7/A\u000bsK\u0006$'+Z2pe\u0012\u001cH\u0005Z3gCVdG\u000fJ\u0019\u0002+I,\u0017\r\u001a*fG>\u0014Hm\u001d\u0013eK\u001a\fW\u000f\u001c;%e\u0005)\"/Z1e%\u0016\u001cwN\u001d3tI\u0011,g-Y;mi\u0012\u001aTC\u0001B\u0000U\u0011\u00119#a=\u0002+I,\u0017\r\u001a*fG>\u0014Hm\u001d\u0013eK\u001a\fW\u000f\u001c;%iU\u00111Q\u0001\u0016\u0005\u0005\u001b\n\u00190A\u000bsK\u0006$'+Z2pe\u0012\u001cH\u0005Z3gCVdG\u000fJ\u001b\u0016\u0005\r-!\u0006\u0002Bw\u0003g\fQC]3bIJ+7m\u001c:eg\u0012\"WMZ1vYR$c'\u0001\u000fuKN$Hj\\4EK2,G/Z*fO6,g\u000e^:Tk\u000e\u001cWm]:)\u0007a\u001a\u0019\u0002\u0005\u0003\u0002x\rU\u0011\u0002BB\f\u0003s\u0012A\u0001V3ti\u00061D/Z:u\u0019><G)\u001a7fi\u0016$\u0015N]*vG\u000e,7o],iK:,U\u000e\u001d;z\u0003:$g)Y5mkJ,w\u000b[3o\u001d>tW)\u001c9us\"\u001a\u0011ha\u0005\u0002!Q,7\u000f^+qI\u0006$XmQ8oM&<\u0007f\u0001\u001e\u0004\u0014\u0005AB/Z:u\u0019><G)\u001b:SK:\fW.\u001a+p\u001d\u0016<H)\u001b:)\u0007m\u001a\u0019\"A\u000fuKN$Hj\\4ESJ\u0014VM\\1nKR{W\t_5ti&tw\rR5sQ\ra41C\u0001\ri\u0016\u001cH\u000fT8h\r2,8\u000f\u001b\u0015\u0004{\rM\u0011!\u0004;fgRdunZ!qa\u0016tG\rK\u0002?\u0007'\t1\u0003^3ti2{wm\u00117pg\u0016\u001cVoY2fgND3aPB\n\u0003Y!Xm\u001d;M_\u001e\u001cEn\\:f\u0013\u0012,W\u000e]8uK:$\bf\u0001!\u0004\u0014\u0005YC/Z:u\u0019><7\t\\8tK\u001a\u000b\u0017\u000e\\;sK^CWM\\%o\u001b\u0016lwN]=Ck\u001a4WM]\"m_N,G\rK\u0002B\u0007'\tA\u0003^3ti2{wm\u00117pg\u0016D\u0015M\u001c3mKJ\u001c\bf\u0001\"\u0004\u0014\u0005qB/Z:u\u0019><7\t\\8tK\"\u000bg\u000e\u001a7feNLE-Z7q_R,g\u000e\u001e\u0015\u0004\u0007\u000eM\u0011a\u0007;fgR\u0014V-\\8wK\u0006sG\rR3mKR,7+Z4nK:$8\u000f\u0006\u0003\u0002\u0006\r%\u0003bBB&\t\u0002\u0007!QJ\u0001\fCNLhn\u0019#fY\u0016$X-A\u0010uKN$(+Z7pm\u0016\fe\u000e\u001a#fY\u0016$XmU3h[\u0016tGo]*z]\u000eD3!RB\n\u0003\u0001\"Xm\u001d;SK6|g/Z!oI\u0012+G.\u001a;f'\u0016<W.\u001a8ug\u0006\u001b\u0018P\\2)\u0007\u0019\u001b\u0019\"\u0001\fuKN$H)\u001a7fi\u0016\u001cVmZ7f]R4\u0015\u000e\\3t)\u0011\t)a!\u0017\t\u000f\r-s\t1\u0001\u0003N\u0005QB/Z:u\t\u0016dW\r^3TK\u001elWM\u001c;GS2,7oU=oG\"\u001a\u0001ja\u0005\u00027Q,7\u000f\u001e#fY\u0016$XmU3h[\u0016tGOR5mKN\f5/\u001f8dQ\rI51C\u0001\u001ci\u0016\u001cH\u000fR3mKR\f'\r\\3TK\u001elWM\u001c;t\r&dG/\u001a:)\u0007)\u001b\u0019\"\u0001\u0010uKN$H)\u001a7fi\u0006\u0014G.Z*fO6,g\u000e^:Ji\u0016\u0014\u0018\r^5p]\"\u001a1ja\u0005\u00027Q,7\u000f\u001e+sk:\u001c\u0017\r^3Gk2d\u00170\u00118e'R\f'\u000f^!uQ\ra51C\u0001\u000fi\u0016\u001cH\u000f\u0016:v]\u000e\fG/\u001a+pQ\ri51C\u0001\u001ai\u0016\u001cHOT8o\u0003\u000e$\u0018N^3TK\u001elWM\u001c;t\rJ|W\u000eK\u0002O\u0007'\t!\u0003^8qS\u000e\u0004\u0016M\u001d;ji&|gNT1nKR1\u0011qUB>\u0007\u007fBqa! P\u0001\u0004\t9+A\u0003u_BL7\rC\u0004\u0004\u0002>\u0003\r!a*\u0002\u0013A\f'\u000f^5uS>t\u0017a\u0007;fgR\u0004\u0016M]:f)>\u0004\u0018n\u0019)beRLG/[8o\u001d\u0006lW\rK\u0002Q\u0007'\tA\u0007^3tiB\u000b'o]3U_BL7\rU1si&$\u0018n\u001c8OC6,w+\u001b;i!\u0016\u0014\u0018n\u001c3G_J$U\r\\3uK\u0012$v\u000e]5dQ\r\t61C\u0001(i\u0016\u001cH\u000fU1sg\u0016$v\u000e]5d!\u0006\u0014H/\u001b;j_:t\u0015-\\3G_J,U\u000e\u001d;z\u001d\u0006lW\rK\u0002S\u0007'\t!\u0005^3tiB\u000b'o]3U_BL7\rU1si&$\u0018n\u001c8OC6,gi\u001c:Ok2d\u0007fA*\u0004\u0014\u0005qC/Z:u!\u0006\u00148/\u001a+pa&\u001c\u0007+\u0019:uSRLwN\u001c(b[\u00164uN]'jgNLgnZ*fa\u0006\u0014\u0018\r^8sQ\r!61C\u0001+i\u0016\u001cH\u000fU1sg\u0016$v\u000e]5d!\u0006\u0014H/\u001b;j_:t\u0015-\\3G_Jl\u0015n]:j]\u001e$v\u000e]5dQ\r)61C\u0001/i\u0016\u001cH\u000fU1sg\u0016$v\u000e]5d!\u0006\u0014H/\u001b;j_:t\u0015-\\3G_Jl\u0015n]:j]\u001e\u0004\u0016M\u001d;ji&|g\u000eK\u0002W\u0007'\ta\u0006^3tiB\u000b'o]3U_BL7\rU1si&$\u0018n\u001c8OC6,gi\u001c:J]Z\fG.\u001b3QCJ$\u0018\u000e^5p]\"\u001aqka\u0005\u0002aQ,7\u000f\u001e)beN,Gk\u001c9jGB\u000b'\u000f^5uS>tg*Y7f\r>\u0014X\t_5ti&tw-\u00138wC2LG\rR5sQ\rA61C\u0001\u0015i\u0016\u001cH\u000fT8h\t\u0016dW\r^3ESJt\u0015-\\3)\u0007e\u001b\u0019\"\u0001\nuKN$xJ\u001a4tKR4%o\\7GS2,\u0007f\u0001.\u0004\u0014\u0005\u0001C/Z:u%>dGnU3h[\u0016tG\u000f\u00165bi\u0006c'/Z1es\u0016C\u0018n\u001d;tQ\rY61C\u0001\u0019i\u0016\u001cHOT3x'\u0016<W.\u001a8ug\u00063G/\u001a:S_2d\u0007f\u0001/\u0004\u0014\u0005YC/Z:u%>dGnU3h[\u0016tG/\u0012:s_J<\u0006.\u001a8OKb$xJ\u001a4tKRL5/\u00137mK\u001e\fG\u000eK\u0002^\u0007'\tqd\u0019:fCR,Gj\\2bY2{wmV5uQ\u0006\u001bG/\u001b<f'\u0016<W.\u001a8u)Q\t9ga0\u0004D\u000e-7Q[Bm\u0007;\u001c9o!>\u0004x\"I1\u0011\u00190\u0011\u0002\u0003\u0007\u0011QC\u0001\u0004I&\u0014\bB\u0002=_\u0001\u0004\u0019)\rE\u0002x\u0007\u000fL1a!3i\u0005%aunZ\"p]\u001aLw\rC\u0005\u0004Nz\u0003\n\u00111\u0001\u0004P\u0006A1/Z4nK:$8\u000fE\u0002x\u0007#L1aa5i\u0005-aunZ*fO6,g\u000e^:\t\u0013\r]g\f%AA\u0002\u0005\u001d\u0018!\u0004:fG>4XM]=Q_&tG\u000fC\u0005\u0004\\z\u0003\n\u00111\u0001\u0003n\u0006\u0011b.\u001a=u\u001f\u001a47/\u001a;NKR\fG-\u0019;b\u0011%\u0019yN\u0018I\u0001\u0002\u0004\u0019\t/A\u0005tG\",G-\u001e7feB!\u0011\u0011LBr\u0013\u0011\u0019)/a\u0017\u0003\u0013M\u001b\u0007.\u001a3vY\u0016\u0014\b\"CBu=B\u0005\t\u0019ABv\u0003\u0011!\u0018.\\3\u0011\t\r58\u0011_\u0007\u0003\u0007_TA!!\u0018\u00024%!11_Bx\u0005\u0011!\u0016.\\3\t\u0013\u0005-b\f%AA\u0002\u0005=\u0002\"CA$=B\u0005\t\u0019AA&\u0003%\u001a'/Z1uK2{7-\u00197M_\u001e<\u0016\u000e\u001e5BGRLg/Z*fO6,g\u000e\u001e\u0013eK\u001a\fW\u000f\u001c;%cU\u00111Q \u0016\u0005\u0003+\t\u00190A\u0015de\u0016\fG/\u001a'pG\u0006dGj\\4XSRD\u0017i\u0019;jm\u0016\u001cVmZ7f]R$C-\u001a4bk2$HeM\u000b\u0003\t\u0007QCaa4\u0002t\u0006I3M]3bi\u0016dunY1m\u0019><w+\u001b;i\u0003\u000e$\u0018N^3TK\u001elWM\u001c;%I\u00164\u0017-\u001e7uIQ\n\u0011f\u0019:fCR,Gj\\2bY2{wmV5uQ\u0006\u001bG/\u001b<f'\u0016<W.\u001a8uI\u0011,g-Y;mi\u0012*\u0014!K2sK\u0006$X\rT8dC2dunZ,ji\"\f5\r^5wKN+w-\\3oi\u0012\"WMZ1vYR$c'\u0006\u0002\u0005\u000e)\"1\u0011]Az\u0003%\u001a'/Z1uK2{7-\u00197M_\u001e<\u0016\u000e\u001e5BGRLg/Z*fO6,g\u000e\u001e\u0013eK\u001a\fW\u000f\u001c;%oU\u0011A1\u0003\u0016\u0005\u0007W\f\u00190A\u0015de\u0016\fG/\u001a'pG\u0006dGj\\4XSRD\u0017i\u0019;jm\u0016\u001cVmZ7f]R$C-\u001a4bk2$H\u0005O\u000b\u0003\t3QC!a\f\u0002t\u0006I3M]3bi\u0016dunY1m\u0019><w+\u001b;i\u0003\u000e$\u0018N^3TK\u001elWM\u001c;%I\u00164\u0017-\u001e7uIe*\"\u0001b\b+\t\u0005-\u00131\u001f")
public class LocalLogTest {
    private volatile LocalLogTest$KeyValue$ KeyValue$module;
    private KafkaConfig config = null;
    private final File tmpDir = TestUtils$.MODULE$.tempDir();
    private final File logDir = TestUtils$.MODULE$.randomPartitionLogDir(this.tmpDir());
    private final TopicPartition topicPartition = new TopicPartition("test_topic", 1);
    private final LogDirFailureChannel logDirFailureChannel = new LogDirFailureChannel(10);
    private final MockTime mockTime = new MockTime();
    private final LocalLog log;

    public LocalLogTest$KeyValue$ KeyValue() {
        if (this.KeyValue$module == null) {
            this.KeyValue$lzycompute$1();
        }
        return this.KeyValue$module;
    }

    public KafkaConfig config() {
        return this.config;
    }

    public void config_$eq(KafkaConfig x$1) {
        this.config = x$1;
    }

    public File tmpDir() {
        return this.tmpDir;
    }

    public File logDir() {
        return this.logDir;
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public LogDirFailureChannel logDirFailureChannel() {
        return this.logDirFailureChannel;
    }

    public MockTime mockTime() {
        return this.mockTime;
    }

    public LocalLog log() {
        return this.log;
    }

    @BeforeEach
    public void setUp() {
        int x$1 = 0;
        String x$2 = "127.0.0.1:1";
        int x$3 = -1;
        boolean x$4 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$5 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$6 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$7 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$8 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$9 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$10 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$11 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$12 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$13 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$14 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$15 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$16 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        int x$17 = TestUtils$.MODULE$.createBrokerConfig$default$17();
        boolean x$18 = TestUtils$.MODULE$.createBrokerConfig$default$18();
        int x$19 = TestUtils$.MODULE$.createBrokerConfig$default$19();
        short x$20 = TestUtils$.MODULE$.createBrokerConfig$default$20();
        Properties props = TestUtils$.MODULE$.createBrokerConfig(x$1, x$2, x$4, x$5, x$3, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20);
        this.config_$eq(KafkaConfig$.MODULE$.fromProps(props));
    }

    @AfterEach
    public void tearDown() {
        try {
            this.log().close();
        }
        catch (KafkaStorageException kafkaStorageException) {}
        Utils.delete((File)this.tmpDir());
    }

    private Iterable<SimpleRecord> kvsToRecords(Iterable<KeyValue> keyValues) {
        return (Iterable)keyValues.map((Function1 & Serializable & scala.Serializable)kv -> kv.toRecord((Function0<Object>)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> kv.toRecord$default$1()), Iterable$.MODULE$.canBuildFrom());
    }

    private Iterable<KeyValue> recordsToKvs(Iterable<Record> records) {
        return (Iterable)records.map((Function1 & Serializable & scala.Serializable)r -> this.KeyValue().fromRecord((Record)r), Iterable$.MODULE$.canBuildFrom());
    }

    private void appendRecords(Iterable<SimpleRecord> records, LocalLog log, long initialOffset) {
        log.append(initialOffset + (long)records.size() - 1L, ((SimpleRecord)records.head()).timestamp(), initialOffset, MemoryRecords.withRecords((long)initialOffset, (CompressionType)CompressionType.NONE, (Integer)Predef$.MODULE$.int2Integer(0), (SimpleRecord[])((SimpleRecord[])records.toList().toArray(ClassTag$.MODULE$.apply(SimpleRecord.class)))));
    }

    private LocalLog appendRecords$default$2() {
        return this.log();
    }

    private long appendRecords$default$3() {
        return 0L;
    }

    private FetchDataInfo readRecords(LocalLog log, long startOffset, Function0<Object> maxLength, boolean minOneMessage, Function0<LogOffsetMetadata> maxOffsetMetadata, boolean includeAbortedTxns) {
        return log.read(startOffset, maxLength.apply$mcI$sp(), minOneMessage, (LogOffsetMetadata)maxOffsetMetadata.apply(), includeAbortedTxns);
    }

    private LocalLog readRecords$default$1() {
        return this.log();
    }

    private long readRecords$default$2() {
        return 0L;
    }

    private int readRecords$default$3() {
        return this.log().segments().activeSegment().size();
    }

    private boolean readRecords$default$4() {
        return false;
    }

    private LogOffsetMetadata readRecords$default$5() {
        return this.log().logEndOffsetMetadata();
    }

    private boolean readRecords$default$6() {
        return false;
    }

    @Test
    public void testLogDeleteSegmentsSuccess() {
        SimpleRecord record = new SimpleRecord(this.mockTime().milliseconds(), "a".getBytes());
        this.appendRecords((Iterable<SimpleRecord>)new .colon.colon((Object)record, (List)Nil$.MODULE$), this.appendRecords$default$2(), this.appendRecords$default$3());
        this.log().roll(this.log().roll$default$1());
        Assertions.assertEquals((int)2, (int)this.log().segments().numberOfSegments());
        Assertions.assertFalse((boolean)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.logDir().listFiles())).isEmpty());
        List segmentsBeforeDelete = (List)Nil$.MODULE$.$plus$plus((GenTraversableOnce)this.log().segments().values(), List$.MODULE$.canBuildFrom());
        Iterable deletedSegments = this.log().deleteAllSegments();
        Assertions.assertTrue((boolean)this.log().segments().isEmpty());
        Assertions.assertEquals((Object)segmentsBeforeDelete, (Object)deletedSegments);
        Assertions.assertThrows(KafkaStorageException.class, () -> this.log().checkIfMemoryMappedBufferClosed());
        Assertions.assertTrue((boolean)this.logDir().exists());
    }

    @Test
    public void testLogDeleteDirSuccessWhenEmptyAndFailureWhenNonEmpty() {
        SimpleRecord record = new SimpleRecord(this.mockTime().milliseconds(), "a".getBytes());
        this.appendRecords((Iterable<SimpleRecord>)new .colon.colon((Object)record, (List)Nil$.MODULE$), this.appendRecords$default$2(), this.appendRecords$default$3());
        this.log().roll(this.log().roll$default$1());
        Assertions.assertEquals((int)2, (int)this.log().segments().numberOfSegments());
        Assertions.assertFalse((boolean)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.logDir().listFiles())).isEmpty());
        Assertions.assertThrows(IllegalStateException.class, () -> this.log().deleteEmptyDir());
        Assertions.assertTrue((boolean)this.logDir().exists());
        this.log().deleteAllSegments();
        this.log().deleteEmptyDir();
        Assertions.assertFalse((boolean)this.logDir().exists());
    }

    @Test
    public void testUpdateConfig() {
        LogConfig oldConfig = this.log().config();
        Assertions.assertEquals((Object)oldConfig, (Object)this.log().config());
        int x$1 = Predef$.MODULE$.Integer2int(oldConfig.segmentSize()) + 1;
        long x$2 = LogTestUtils$.MODULE$.createLogConfig$default$1();
        long x$3 = LogTestUtils$.MODULE$.createLogConfig$default$3();
        long x$4 = LogTestUtils$.MODULE$.createLogConfig$default$4();
        long x$5 = LogTestUtils$.MODULE$.createLogConfig$default$5();
        String x$6 = LogTestUtils$.MODULE$.createLogConfig$default$6();
        int x$7 = LogTestUtils$.MODULE$.createLogConfig$default$7();
        int x$8 = LogTestUtils$.MODULE$.createLogConfig$default$8();
        int x$9 = LogTestUtils$.MODULE$.createLogConfig$default$9();
        long x$10 = LogTestUtils$.MODULE$.createLogConfig$default$10();
        LogConfig newConfig = LogTestUtils$.MODULE$.createLogConfig(x$2, x$1, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10);
        this.log().updateConfig(newConfig);
        Assertions.assertEquals((Object)newConfig, (Object)this.log().config());
    }

    @Test
    public void testLogDirRenameToNewDir() {
        SimpleRecord record = new SimpleRecord(this.mockTime().milliseconds(), "a".getBytes());
        this.appendRecords((Iterable<SimpleRecord>)new .colon.colon((Object)record, (List)Nil$.MODULE$), this.appendRecords$default$2(), this.appendRecords$default$3());
        this.log().roll(this.log().roll$default$1());
        Assertions.assertEquals((int)2, (int)this.log().segments().numberOfSegments());
        File newLogDir = TestUtils$.MODULE$.randomPartitionLogDir(this.tmpDir());
        Assertions.assertTrue((boolean)this.log().renameDir(newLogDir.getName()));
        Assertions.assertFalse((boolean)this.logDir().exists());
        Assertions.assertTrue((boolean)newLogDir.exists());
        Assertions.assertEquals((Object)newLogDir, (Object)this.log().dir());
        Assertions.assertEquals((Object)newLogDir.getParent(), (Object)this.log().parentDir());
        Assertions.assertEquals((Object)newLogDir.getParent(), (Object)this.log().dir().getParent());
        this.log().segments().values().foreach((Function1 & Serializable & scala.Serializable)segment -> {
            LocalLogTest.$anonfun$testLogDirRenameToNewDir$1(newLogDir, segment);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((int)2, (int)this.log().segments().numberOfSegments());
    }

    @Test
    public void testLogDirRenameToExistingDir() {
        Assertions.assertFalse((boolean)this.log().renameDir(this.log().dir().getName()));
    }

    @Test
    public void testLogFlush() {
        Assertions.assertEquals((long)0L, (long)this.log().recoveryPoint());
        Assertions.assertEquals((long)this.mockTime().milliseconds(), (long)this.log().lastFlushTime());
        SimpleRecord record = new SimpleRecord(this.mockTime().milliseconds(), "a".getBytes());
        this.appendRecords((Iterable<SimpleRecord>)new .colon.colon((Object)record, (List)Nil$.MODULE$), this.appendRecords$default$2(), this.appendRecords$default$3());
        this.mockTime().sleep(1L);
        LogSegment newSegment = this.log().roll(this.log().roll$default$1());
        this.log().flush(newSegment.baseOffset());
        this.log().markFlushed(newSegment.baseOffset());
        Assertions.assertEquals((long)1L, (long)this.log().recoveryPoint());
        Assertions.assertEquals((long)this.mockTime().milliseconds(), (long)this.log().lastFlushTime());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testLogAppend() {
        void readRecords_includeAbortedTxns;
        LocalLog x$2 = this.readRecords$default$1();
        long x$3 = this.readRecords$default$2();
        boolean x$4 = this.readRecords$default$4();
        boolean x$6 = this.readRecords$default$6();
        FetchDataInfo fetchDataInfo = x$2.read(x$3, LocalLogTest.$anonfun$testLogAppend$1(), x$4, this.readRecords$default$5(), x$6);
        Assertions.assertTrue((boolean)((IterableLike)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(fetchDataInfo.records().records()).asScala()).isEmpty());
        this.mockTime().sleep(1L);
        .colon.colon keyValues = new .colon.colon((Object)new KeyValue(this, "abc", "ABC"), (List)new .colon.colon((Object)new KeyValue(this, "de", "DE"), (List)Nil$.MODULE$));
        this.appendRecords(this.kvsToRecords((Iterable<KeyValue>)keyValues), this.appendRecords$default$2(), this.appendRecords$default$3());
        Assertions.assertEquals((long)2L, (long)this.log().logEndOffset());
        Assertions.assertEquals((long)0L, (long)this.log().recoveryPoint());
        boolean bl = this.readRecords$default$6();
        boolean readRecords_minOneMessage = this.readRecords$default$4();
        FetchDataInfo fetchDataInfo2 = this.readRecords$default$1().read(this.readRecords$default$2(), this.readRecords$default$3(), readRecords_minOneMessage, this.readRecords$default$5(), (boolean)readRecords_includeAbortedTxns);
        Assertions.assertEquals((long)2L, (long)((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(fetchDataInfo2.records().records()).asScala()).size());
        Assertions.assertEquals((Object)keyValues, this.recordsToKvs((Iterable<Record>)((Iterable)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(fetchDataInfo2.records().records()).asScala())));
    }

    @Test
    public void testLogCloseSuccess() {
        .colon.colon keyValues = new .colon.colon((Object)new KeyValue(this, "abc", "ABC"), (List)new .colon.colon((Object)new KeyValue(this, "de", "DE"), (List)Nil$.MODULE$));
        this.appendRecords(this.kvsToRecords((Iterable<KeyValue>)keyValues), this.appendRecords$default$2(), this.appendRecords$default$3());
        this.log().close();
        Assertions.assertThrows(ClosedChannelException.class, () -> LocalLogTest.$anonfun$testLogCloseSuccess$1(this, (Seq)keyValues));
    }

    @Test
    public void testLogCloseIdempotent() {
        this.log().close();
        this.log().close();
    }

    @Test
    public void testLogCloseFailureWhenInMemoryBufferClosed() {
        .colon.colon keyValues = new .colon.colon((Object)new KeyValue(this, "abc", "ABC"), (List)new .colon.colon((Object)new KeyValue(this, "de", "DE"), (List)Nil$.MODULE$));
        this.appendRecords(this.kvsToRecords((Iterable<KeyValue>)keyValues), this.appendRecords$default$2(), this.appendRecords$default$3());
        this.log().closeHandlers();
        Assertions.assertThrows(KafkaStorageException.class, () -> this.log().close());
    }

    @Test
    public void testLogCloseHandlers() {
        .colon.colon keyValues = new .colon.colon((Object)new KeyValue(this, "abc", "ABC"), (List)new .colon.colon((Object)new KeyValue(this, "de", "DE"), (List)Nil$.MODULE$));
        this.appendRecords(this.kvsToRecords((Iterable<KeyValue>)keyValues), this.appendRecords$default$2(), this.appendRecords$default$3());
        this.log().closeHandlers();
        Assertions.assertThrows(ClosedChannelException.class, () -> LocalLogTest.$anonfun$testLogCloseHandlers$1(this, (Seq)keyValues));
    }

    @Test
    public void testLogCloseHandlersIdempotent() {
        this.log().closeHandlers();
        this.log().closeHandlers();
    }

    private void testRemoveAndDeleteSegments(boolean asyncDelete) {
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 8).foreach((Function1 & Serializable & scala.Serializable)offset -> LocalLogTest.$anonfun$testRemoveAndDeleteSegments$1(this, BoxesRunTime.unboxToInt((Object)offset)));
        Assertions.assertEquals((long)10L, (long)this.log().segments().numberOfSegments());
        public class Kafka_log_LocalLogTest$TestDeletionReason$1
        implements SegmentDeletionReason {
            private Iterable<LogSegment> _deletedSegments;

            private Iterable<LogSegment> _deletedSegments() {
                return this._deletedSegments;
            }

            private void _deletedSegments_$eq(Iterable<LogSegment> x$1) {
                this._deletedSegments = x$1;
            }

            public void logReason(List<LogSegment> toDelete) {
                this._deletedSegments_$eq((Iterable<LogSegment>)((Iterable)Nil$.MODULE$.$plus$plus(toDelete, List$.MODULE$.canBuildFrom())));
            }

            public Iterable<LogSegment> deletedSegments() {
                return this._deletedSegments();
            }

            public Kafka_log_LocalLogTest$TestDeletionReason$1(LocalLogTest $outer) {
                this._deletedSegments = Nil$.MODULE$;
            }
        }
        Kafka_log_LocalLogTest$TestDeletionReason$1 reason = new Kafka_log_LocalLogTest$TestDeletionReason$1(null);
        List toDelete = (List)Nil$.MODULE$.$plus$plus((GenTraversableOnce)this.log().segments().values(), List$.MODULE$.canBuildFrom());
        this.log().removeAndDeleteSegments((Iterable)toDelete, asyncDelete, (SegmentDeletionReason)reason);
        if (asyncDelete) {
            this.mockTime().sleep(Predef$.MODULE$.Long2long(this.log().config().fileDeleteDelayMs()) + 1L);
        }
        Assertions.assertTrue((boolean)this.log().segments().isEmpty());
        Assertions.assertEquals((Object)toDelete, reason.deletedSegments());
        toDelete.foreach((Function1 & Serializable & scala.Serializable)segment -> {
            LocalLogTest.$anonfun$testRemoveAndDeleteSegments$2(segment);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testRemoveAndDeleteSegmentsSync() {
        this.testRemoveAndDeleteSegments(false);
    }

    @Test
    public void testRemoveAndDeleteSegmentsAsync() {
        this.testRemoveAndDeleteSegments(true);
    }

    private void testDeleteSegmentFiles(boolean asyncDelete) {
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 8).foreach((Function1 & Serializable & scala.Serializable)offset -> LocalLogTest.$anonfun$testDeleteSegmentFiles$1(this, BoxesRunTime.unboxToInt((Object)offset)));
        Assertions.assertEquals((long)10L, (long)this.log().segments().numberOfSegments());
        List toDelete = (List)Nil$.MODULE$.$plus$plus((GenTraversableOnce)this.log().segments().values(), List$.MODULE$.canBuildFrom());
        LocalLog$.MODULE$.deleteSegmentFiles((scala.collection.immutable.Iterable)toDelete, asyncDelete, this.log().dir(), this.log().topicPartition(), this.log().config(), this.log().scheduler(), this.log().logDirFailureChannel(), "");
        if (asyncDelete) {
            toDelete.foreach((Function1 & Serializable & scala.Serializable)segment -> {
                LocalLogTest.$anonfun$testDeleteSegmentFiles$2(segment);
                return BoxedUnit.UNIT;
            });
            this.mockTime().sleep(Predef$.MODULE$.Long2long(this.log().config().fileDeleteDelayMs()) + 1L);
        }
        toDelete.foreach((Function1 & Serializable & scala.Serializable)segment -> {
            LocalLogTest.$anonfun$testDeleteSegmentFiles$3(segment);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testDeleteSegmentFilesSync() {
        this.testDeleteSegmentFiles(false);
    }

    @Test
    public void testDeleteSegmentFilesAsync() {
        this.testDeleteSegmentFiles(true);
    }

    @Test
    public void testDeletableSegmentsFilter() {
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 8).foreach((Function1 & Serializable & scala.Serializable)offset -> LocalLogTest.$anonfun$testDeletableSegmentsFilter$1(this, BoxesRunTime.unboxToInt((Object)offset)));
        Assertions.assertEquals((int)10, (int)this.log().segments().numberOfSegments());
        Iterable deletable = this.log().deletableSegments((Function2 & Serializable & scala.Serializable)(segment, x$1) -> BoxesRunTime.boxToBoolean((boolean)LocalLogTest.$anonfun$testDeletableSegmentsFilter$2(segment, x$1)));
        List expected = ((TraversableOnce)this.log().segments().nonActiveLogSegmentsFrom(0L).filter((Function1 & Serializable & scala.Serializable)segment -> BoxesRunTime.boxToBoolean((boolean)LocalLogTest.$anonfun$testDeletableSegmentsFilter$3(segment)))).toList();
        Assertions.assertEquals((int)6, (int)expected.length());
        Assertions.assertEquals((Object)expected, (Object)deletable.toList());
        Iterable deletable2 = this.log().deletableSegments((Function2 & Serializable & scala.Serializable)(x$2, x$3) -> BoxesRunTime.boxToBoolean((boolean)LocalLogTest.$anonfun$testDeletableSegmentsFilter$4(x$2, x$3)));
        List expected2 = this.log().segments().nonActiveLogSegmentsFrom(0L).toList();
        Assertions.assertEquals((int)9, (int)expected2.length());
        Assertions.assertEquals((Object)expected2, (Object)deletable2.toList());
        SimpleRecord record = new SimpleRecord(this.mockTime().milliseconds(), "a".getBytes());
        .colon.colon x$42 = new .colon.colon((Object)record, (List)Nil$.MODULE$);
        long x$52 = 9L;
        LocalLog x$6 = this.appendRecords$default$2();
        this.appendRecords((Iterable<SimpleRecord>)x$42, x$6, x$52);
        Iterable deletable3 = this.log().deletableSegments((Function2 & Serializable & scala.Serializable)(x$4, x$5) -> BoxesRunTime.boxToBoolean((boolean)LocalLogTest.$anonfun$testDeletableSegmentsFilter$5(x$4, x$5)));
        List expected3 = this.log().segments().values().toList();
        Assertions.assertEquals((int)10, (int)expected3.length());
        Assertions.assertEquals((Object)expected3, (Object)deletable3.toList());
    }

    @Test
    public void testDeletableSegmentsIteration() {
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 8).foreach((Function1 & Serializable & scala.Serializable)offset -> LocalLogTest.$anonfun$testDeletableSegmentsIteration$1(this, BoxesRunTime.unboxToInt((Object)offset)));
        Assertions.assertEquals((long)10L, (long)this.log().segments().numberOfSegments());
        IntRef offset2 = IntRef.create((int)0);
        Iterable deletableSegments = this.log().deletableSegments((Function2 & Serializable & scala.Serializable)(segment, nextSegmentOpt) -> BoxesRunTime.boxToBoolean((boolean)LocalLogTest.$anonfun$testDeletableSegmentsIteration$2(this, offset2, segment, nextSegmentOpt)));
        Assertions.assertEquals((long)10L, (long)this.log().segments().numberOfSegments());
        Assertions.assertEquals((Object)this.log().segments().nonActiveLogSegmentsFrom(0L).toSeq(), (Object)deletableSegments.toSeq());
    }

    @Test
    public void testTruncateFullyAndStartAt() {
        SimpleRecord record = new SimpleRecord(this.mockTime().milliseconds(), "a".getBytes());
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 7).foreach((Function1 & Serializable & scala.Serializable)offset -> LocalLogTest.$anonfun$testTruncateFullyAndStartAt$1(this, record, BoxesRunTime.unboxToInt((Object)offset)));
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(8), 12).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)offset -> {
            SimpleRecord record = new SimpleRecord(this.mockTime().milliseconds(), "a".getBytes());
            .colon.colon x$4 = new .colon.colon((Object)record, (List)Nil$.MODULE$);
            long x$5 = offset;
            LocalLog x$6 = this.appendRecords$default$2();
            this.appendRecords((Iterable<SimpleRecord>)x$4, x$6, x$5);
        });
        Assertions.assertEquals((int)5, (int)this.log().segments().numberOfSegments());
        List expected = (List)Nil$.MODULE$.$plus$plus((GenTraversableOnce)this.log().segments().values(), List$.MODULE$.canBuildFrom());
        Iterable deleted = this.log().truncateFullyAndStartAt(10L);
        Assertions.assertEquals((Object)expected, (Object)deleted);
        Assertions.assertEquals((int)1, (int)this.log().segments().numberOfSegments());
        Assertions.assertEquals((long)10L, (long)this.log().segments().activeSegment().baseOffset());
        Assertions.assertEquals((long)0L, (long)this.log().recoveryPoint());
        Assertions.assertEquals((long)10L, (long)this.log().logEndOffset());
        long x$7 = 10L;
        LocalLog x$8 = this.readRecords$default$1();
        boolean x$10 = this.readRecords$default$4();
        boolean x$12 = this.readRecords$default$6();
        FetchDataInfo fetchDataInfo = x$8.read(x$7, this.readRecords$default$3(), x$10, this.readRecords$default$5(), x$12);
        Assertions.assertTrue((boolean)((IterableLike)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(fetchDataInfo.records().records()).asScala()).isEmpty());
    }

    @Test
    public void testTruncateTo() {
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 11).foreach((Function1 & Serializable & scala.Serializable)offset -> LocalLogTest.$anonfun$testTruncateTo$1(this, BoxesRunTime.unboxToInt((Object)offset)));
        Assertions.assertEquals((int)5, (int)this.log().segments().numberOfSegments());
        Assertions.assertEquals((long)12L, (long)this.log().logEndOffset());
        List expected = (List)Nil$.MODULE$.$plus$plus((GenTraversableOnce)this.log().segments().values(9L, this.log().logEndOffset() + 1L), List$.MODULE$.canBuildFrom());
        Iterable deleted = this.log().truncateTo(7L);
        Assertions.assertEquals((Object)expected, (Object)deleted);
        Assertions.assertEquals((int)3, (int)this.log().segments().numberOfSegments());
        Assertions.assertEquals((long)6L, (long)this.log().segments().activeSegment().baseOffset());
        Assertions.assertEquals((long)0L, (long)this.log().recoveryPoint());
        Assertions.assertEquals((long)7L, (long)this.log().logEndOffset());
        long x$4 = 6L;
        LocalLog x$5 = this.readRecords$default$1();
        boolean x$7 = this.readRecords$default$4();
        boolean x$9 = this.readRecords$default$6();
        FetchDataInfo fetchDataInfo = x$5.read(x$4, this.readRecords$default$3(), x$7, this.readRecords$default$5(), x$9);
        Assertions.assertEquals((int)1, (int)((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(fetchDataInfo.records().records()).asScala()).size());
        Assertions.assertEquals((Object)new .colon.colon((Object)new KeyValue(this, "", "a"), (List)Nil$.MODULE$), this.recordsToKvs((Iterable<Record>)((Iterable)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(fetchDataInfo.records().records()).asScala())));
        SimpleRecord record = new SimpleRecord(this.mockTime().milliseconds(), "a".getBytes());
        .colon.colon x$10 = new .colon.colon((Object)record, (List)Nil$.MODULE$);
        long x$11 = 7L;
        LocalLog x$12 = this.appendRecords$default$2();
        this.appendRecords((Iterable<SimpleRecord>)x$10, x$12, x$11);
        Assertions.assertEquals((long)8L, (long)this.log().logEndOffset());
    }

    @Test
    public void testNonActiveSegmentsFrom() {
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 5).foreach((Function1 & Serializable & scala.Serializable)i -> LocalLogTest.$anonfun$testNonActiveSegmentsFrom$1(this, BoxesRunTime.unboxToInt((Object)i)));
        Assertions.assertEquals((long)5L, (long)this.log().segments().activeSegment().baseOffset());
        Assertions.assertEquals((Object)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 5), (Object)this.nonActiveBaseOffsetsFrom$1(0L));
        Assertions.assertEquals((Object)Nil$.MODULE$, (Object)this.nonActiveBaseOffsetsFrom$1(5L));
        Assertions.assertEquals((Object)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(2), 5), (Object)this.nonActiveBaseOffsetsFrom$1(2L));
        Assertions.assertEquals((Object)Nil$.MODULE$, (Object)this.nonActiveBaseOffsetsFrom$1(6L));
    }

    private String topicPartitionName(String topic, String partition) {
        return new StringBuilder(1).append(topic).append("-").append(partition).toString();
    }

    @Test
    public void testParseTopicPartitionName() {
        String topic = "test_topic";
        String partition = "143";
        File dir = new File(this.logDir(), this.topicPartitionName(topic, partition));
        TopicPartition topicPartition = LocalLog$.MODULE$.parseTopicPartitionName(dir);
        Assertions.assertEquals((Object)topic, (Object)topicPartition.topic());
        Assertions.assertEquals((int)new StringOps(Predef$.MODULE$.augmentString(partition)).toInt(), (int)topicPartition.partition());
    }

    @Test
    public void testParseTopicPartitionNameWithPeriodForDeletedTopic() {
        String topic = "foo.bar-testtopic";
        String partition = "42";
        File dir = new File(this.logDir(), LocalLog$.MODULE$.logDeleteDirName(new TopicPartition(topic, new StringOps(Predef$.MODULE$.augmentString(partition)).toInt())));
        TopicPartition topicPartition = LocalLog$.MODULE$.parseTopicPartitionName(dir);
        Assertions.assertEquals((Object)topic, (Object)topicPartition.topic(), (String)"Unexpected topic name parsed");
        Assertions.assertEquals((int)new StringOps(Predef$.MODULE$.augmentString(partition)).toInt(), (int)topicPartition.partition(), (String)"Unexpected partition number parsed");
    }

    @Test
    public void testParseTopicPartitionNameForEmptyName() {
        File dir = new File("");
        Assertions.assertThrows(KafkaException.class, () -> LocalLog$.MODULE$.parseTopicPartitionName(dir), () -> new StringBuilder(48).append("KafkaException should have been thrown for dir: ").append(dir.getCanonicalPath()).toString());
    }

    @Test
    public void testParseTopicPartitionNameForNull() {
        Assertions.assertThrows(KafkaException.class, () -> LocalLogTest.$anonfun$testParseTopicPartitionNameForNull$1(null), () -> LocalLogTest.$anonfun$testParseTopicPartitionNameForNull$2(null));
    }

    @Test
    public void testParseTopicPartitionNameForMissingSeparator() {
        String topic = "test_topic";
        String partition = "1999";
        File dir = new File(this.logDir(), new StringBuilder(0).append(topic).append(partition).toString());
        Assertions.assertThrows(KafkaException.class, () -> LocalLog$.MODULE$.parseTopicPartitionName(dir), () -> new StringBuilder(48).append("KafkaException should have been thrown for dir: ").append(dir.getCanonicalPath()).toString());
        File deleteMarkerDir = new File(this.logDir(), new StringBuilder(1).append(topic).append(partition).append(".").append(LocalLog$.MODULE$.DeleteDirSuffix()).toString());
        Assertions.assertThrows(KafkaException.class, () -> LocalLog$.MODULE$.parseTopicPartitionName(deleteMarkerDir), () -> new StringBuilder(48).append("KafkaException should have been thrown for dir: ").append(deleteMarkerDir.getCanonicalPath()).toString());
    }

    @Test
    public void testParseTopicPartitionNameForMissingTopic() {
        String topic = "";
        String partition = "1999";
        File dir = new File(this.logDir(), this.topicPartitionName(topic, partition));
        Assertions.assertThrows(KafkaException.class, () -> LocalLog$.MODULE$.parseTopicPartitionName(dir), () -> new StringBuilder(48).append("KafkaException should have been thrown for dir: ").append(dir.getCanonicalPath()).toString());
        File deleteMarkerDir = new File(this.logDir(), LocalLog$.MODULE$.logDeleteDirName(new TopicPartition(topic, new StringOps(Predef$.MODULE$.augmentString(partition)).toInt())));
        Assertions.assertThrows(KafkaException.class, () -> LocalLog$.MODULE$.parseTopicPartitionName(deleteMarkerDir), () -> new StringBuilder(48).append("KafkaException should have been thrown for dir: ").append(deleteMarkerDir.getCanonicalPath()).toString());
    }

    @Test
    public void testParseTopicPartitionNameForMissingPartition() {
        String topic = "test_topic";
        String partition = "";
        File dir = new File(new StringBuilder(0).append(this.logDir().getPath()).append(this.topicPartitionName(topic, partition)).toString());
        Assertions.assertThrows(KafkaException.class, () -> LocalLog$.MODULE$.parseTopicPartitionName(dir), () -> new StringBuilder(48).append("KafkaException should have been thrown for dir: ").append(dir.getCanonicalPath()).toString());
        File deleteMarkerDir = new File(this.logDir(), new StringBuilder(1).append(this.topicPartitionName(topic, partition)).append(".").append(LocalLog$.MODULE$.DeleteDirSuffix()).toString());
        Assertions.assertThrows(KafkaException.class, () -> LocalLog$.MODULE$.parseTopicPartitionName(deleteMarkerDir), () -> new StringBuilder(48).append("KafkaException should have been thrown for dir: ").append(deleteMarkerDir.getCanonicalPath()).toString());
    }

    @Test
    public void testParseTopicPartitionNameForInvalidPartition() {
        String topic = "test_topic";
        String partition = "1999a";
        File dir = new File(this.logDir(), this.topicPartitionName(topic, partition));
        Assertions.assertThrows(KafkaException.class, () -> LocalLog$.MODULE$.parseTopicPartitionName(dir), () -> new StringBuilder(48).append("KafkaException should have been thrown for dir: ").append(dir.getCanonicalPath()).toString());
        File deleteMarkerDir = new File(this.logDir(), new StringBuilder(1).append(topic).append(partition).append(".").append(LocalLog$.MODULE$.DeleteDirSuffix()).toString());
        Assertions.assertThrows(KafkaException.class, () -> LocalLog$.MODULE$.parseTopicPartitionName(deleteMarkerDir), () -> new StringBuilder(48).append("KafkaException should have been thrown for dir: ").append(deleteMarkerDir.getCanonicalPath()).toString());
    }

    @Test
    public void testParseTopicPartitionNameForExistingInvalidDir() {
        File dir1 = new File(new StringBuilder(14).append(this.logDir().getPath()).append("/non_kafka_dir").toString());
        Assertions.assertThrows(KafkaException.class, () -> LocalLog$.MODULE$.parseTopicPartitionName(dir1), () -> new StringBuilder(48).append("KafkaException should have been thrown for dir: ").append(dir1.getCanonicalPath()).toString());
        File dir2 = new File(new StringBuilder(21).append(this.logDir().getPath()).append("/non_kafka_dir-delete").toString());
        Assertions.assertThrows(KafkaException.class, () -> LocalLog$.MODULE$.parseTopicPartitionName(dir2), () -> new StringBuilder(48).append("KafkaException should have been thrown for dir: ").append(dir2.getCanonicalPath()).toString());
    }

    @Test
    public void testLogDeleteDirName() {
        String name1 = LocalLog$.MODULE$.logDeleteDirName(new TopicPartition("foo", 3));
        Assertions.assertTrue((name1.length() <= 255 ? 1 : 0) != 0);
        Assertions.assertTrue((boolean)Pattern.compile("foo-3\\.[0-9a-z]{32}-delete").matcher(name1).matches());
        Assertions.assertTrue((boolean)LocalLog$.MODULE$.DeleteDirPattern().matcher(name1).matches());
        Assertions.assertFalse((boolean)LocalLog$.MODULE$.FutureDirPattern().matcher(name1).matches());
        String name2 = LocalLog$.MODULE$.logDeleteDirName(new TopicPartition(new StringBuilder(1).append("n").append(String.join((CharSequence)"", Collections.nCopies(248, "o"))).toString(), 5));
        Assertions.assertEquals((int)255, (int)name2.length());
        Assertions.assertTrue((boolean)Pattern.compile("n[o]{212}-5\\.[0-9a-z]{32}-delete").matcher(name2).matches());
        Assertions.assertTrue((boolean)LocalLog$.MODULE$.DeleteDirPattern().matcher(name2).matches());
        Assertions.assertFalse((boolean)LocalLog$.MODULE$.FutureDirPattern().matcher(name2).matches());
    }

    @Test
    public void testOffsetFromFile() {
        long offset = 23423423L;
        File logFile = LocalLog$.MODULE$.logFile(this.tmpDir(), offset, LocalLog$.MODULE$.logFile$default$3());
        Assertions.assertEquals((long)offset, (long)LocalLog$.MODULE$.offsetFromFile(logFile));
        File offsetIndexFile = LocalLog$.MODULE$.offsetIndexFile(this.tmpDir(), offset, LocalLog$.MODULE$.offsetIndexFile$default$3());
        Assertions.assertEquals((long)offset, (long)LocalLog$.MODULE$.offsetFromFile(offsetIndexFile));
        File timeIndexFile = LocalLog$.MODULE$.timeIndexFile(this.tmpDir(), offset, LocalLog$.MODULE$.timeIndexFile$default$3());
        Assertions.assertEquals((long)offset, (long)LocalLog$.MODULE$.offsetFromFile(timeIndexFile));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testRollSegmentThatAlreadyExists() {
        void readRecords_includeAbortedTxns;
        Assertions.assertEquals((int)1, (int)this.log().segments().numberOfSegments(), (String)"Log begins with a single empty segment.");
        this.log().roll((Option)new Some((Object)BoxesRunTime.boxToLong((long)0L)));
        Assertions.assertEquals((int)1, (int)this.log().segments().numberOfSegments(), (String)"Expect 1 segment after roll() empty segment with base offset.");
        .colon.colon keyValues1 = new .colon.colon((Object)new KeyValue(this, "k1", "v1"), (List)Nil$.MODULE$);
        this.appendRecords(this.kvsToRecords((Iterable<KeyValue>)keyValues1), this.appendRecords$default$2(), this.appendRecords$default$3());
        Assertions.assertEquals((long)0L, (long)this.log().segments().activeSegment().baseOffset());
        .colon.colon keyValues2 = new .colon.colon((Object)new KeyValue(this, "k2", "v2"), (List)Nil$.MODULE$);
        Iterable x$1 = (Iterable)keyValues2.map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.toRecord((Function0<Object>)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> this.mockTime().milliseconds() + 10L), List$.MODULE$.canBuildFrom());
        long x$2 = 1L;
        LocalLog x$3 = this.appendRecords$default$2();
        this.appendRecords((Iterable<SimpleRecord>)x$1, x$3, x$2);
        Assertions.assertEquals((long)2L, (long)this.log().logEndOffset(), (String)"Expect two records in the log");
        boolean bl = this.readRecords$default$6();
        boolean readRecords_minOneMessage = this.readRecords$default$4();
        FetchDataInfo fetchDataInfo = this.readRecords$default$1().read(this.readRecords$default$2(), this.readRecords$default$3(), readRecords_minOneMessage, this.readRecords$default$5(), (boolean)readRecords_includeAbortedTxns);
        Assertions.assertEquals((long)2L, (long)((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(fetchDataInfo.records().records()).asScala()).size());
        Assertions.assertEquals((Object)keyValues1.$plus$plus((GenTraversableOnce)keyValues2, List$.MODULE$.canBuildFrom()), this.recordsToKvs((Iterable<Record>)((Iterable)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(fetchDataInfo.records().records()).asScala())));
        this.log().roll(this.log().roll$default$1());
        Assertions.assertEquals((long)2L, (long)this.log().segments().activeSegment().baseOffset(), (String)"Expect base offset of active segment to be LEO");
        Assertions.assertEquals((int)2, (int)this.log().segments().numberOfSegments(), (String)"Expect two segments.");
        Assertions.assertEquals((long)2L, (long)this.log().logEndOffset());
    }

    @Test
    public void testNewSegmentsAfterRoll() {
        Assertions.assertEquals((int)1, (int)this.log().segments().numberOfSegments(), (String)"Log begins with a single empty segment.");
        LogSegment newSegment = this.log().roll(this.log().roll$default$1());
        Assertions.assertEquals((long)0L, (long)newSegment.baseOffset());
        Assertions.assertEquals((int)1, (int)this.log().segments().numberOfSegments());
        Assertions.assertEquals((long)0L, (long)this.log().logEndOffset());
        KeyValue qual$1 = new KeyValue(this, "k1", "v1");
        JFunction0.mcJ.sp & Serializable & scala.Serializable x$1 = (JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> qual$1.toRecord$default$1();
        this.appendRecords((Iterable<SimpleRecord>)new .colon.colon((Object)qual$1.toRecord((Function0<Object>)x$1), (List)Nil$.MODULE$), this.appendRecords$default$2(), this.appendRecords$default$3());
        LogSegment newSegment2 = this.log().roll(this.log().roll$default$1());
        Assertions.assertEquals((long)1L, (long)newSegment2.baseOffset());
        Assertions.assertEquals((int)2, (int)this.log().segments().numberOfSegments());
        Assertions.assertEquals((long)1L, (long)this.log().logEndOffset());
        KeyValue qual$2 = new KeyValue(this, "k2", "v2");
        JFunction0.mcJ.sp & Serializable & scala.Serializable x$2 = (JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> qual$2.toRecord$default$1();
        .colon.colon x$3 = new .colon.colon((Object)qual$2.toRecord((Function0<Object>)x$2), (List)Nil$.MODULE$);
        long x$4 = 1L;
        LocalLog x$5 = this.appendRecords$default$2();
        this.appendRecords((Iterable<SimpleRecord>)x$3, x$5, x$4);
        LogSegment newSegment3 = this.log().roll((Option)new Some((Object)BoxesRunTime.boxToLong((long)1L)));
        Assertions.assertEquals((long)2L, (long)newSegment3.baseOffset());
        Assertions.assertEquals((int)3, (int)this.log().segments().numberOfSegments());
        Assertions.assertEquals((long)2L, (long)this.log().logEndOffset());
    }

    @Test
    public void testRollSegmentErrorWhenNextOffsetIsIllegal() {
        Assertions.assertEquals((int)1, (int)this.log().segments().numberOfSegments(), (String)"Log begins with a single empty segment.");
        .colon.colon keyValues = new .colon.colon((Object)new KeyValue(this, "k1", "v1"), (List)new .colon.colon((Object)new KeyValue(this, "k2", "v2"), (List)new .colon.colon((Object)new KeyValue(this, "k3", "v3"), (List)Nil$.MODULE$)));
        this.appendRecords(this.kvsToRecords((Iterable<KeyValue>)keyValues), this.appendRecords$default$2(), this.appendRecords$default$3());
        Assertions.assertEquals((long)0L, (long)this.log().segments().activeSegment().baseOffset());
        Assertions.assertEquals((long)3L, (long)this.log().logEndOffset(), (String)"Expect two records in the log");
        this.log().roll(this.log().roll$default$1());
        Assertions.assertEquals((long)3L, (long)this.log().segments().activeSegment().baseOffset());
        this.log().updateLogEndOffset(1L);
        Assertions.assertThrows(KafkaException.class, () -> this.log().roll(this.log().roll$default$1()));
    }

    private LocalLog createLocalLogWithActiveSegment(File dir, LogConfig config, LogSegments segments, long recoveryPoint, LogOffsetMetadata nextOffsetMetadata, Scheduler scheduler, Time time, TopicPartition topicPartition, LogDirFailureChannel logDirFailureChannel) {
        long x$2 = 0L;
        int x$5 = config.initFileSize();
        boolean x$6 = Predef$.MODULE$.Boolean2boolean(config.preallocate());
        boolean x$7 = LogSegment$.MODULE$.open$default$5();
        String x$8 = LogSegment$.MODULE$.open$default$8();
        segments.add(LogSegment$.MODULE$.open(dir, x$2, config, time, x$7, x$5, x$6, x$8));
        return new LocalLog(dir, config, segments, recoveryPoint, nextOffsetMetadata, scheduler, time, topicPartition, logDirFailureChannel);
    }

    private File createLocalLogWithActiveSegment$default$1() {
        return this.logDir();
    }

    private LogSegments createLocalLogWithActiveSegment$default$3() {
        return new LogSegments(this.topicPartition());
    }

    private long createLocalLogWithActiveSegment$default$4() {
        return 0L;
    }

    private LogOffsetMetadata createLocalLogWithActiveSegment$default$5() {
        return new LogOffsetMetadata(0L, 0L, 0);
    }

    private Scheduler createLocalLogWithActiveSegment$default$6() {
        return this.mockTime().scheduler();
    }

    private Time createLocalLogWithActiveSegment$default$7() {
        return this.mockTime();
    }

    private TopicPartition createLocalLogWithActiveSegment$default$8() {
        return this.topicPartition();
    }

    private LogDirFailureChannel createLocalLogWithActiveSegment$default$9() {
        return this.logDirFailureChannel();
    }

    private final void KeyValue$lzycompute$1() {
        synchronized (this) {
            if (this.KeyValue$module == null) {
                this.KeyValue$module = new LocalLogTest$KeyValue$(this);
            }
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$testLogDirRenameToNewDir$1(File newLogDir$1, LogSegment segment) {
        Assertions.assertEquals((Object)newLogDir$1.getPath(), (Object)segment.log().file().getParentFile().getPath());
    }

    public static final /* synthetic */ int $anonfun$testLogAppend$1() {
        return 1;
    }

    public static final /* synthetic */ void $anonfun$testLogCloseSuccess$1(LocalLogTest $this, Seq keyValues$1) {
        Iterable<SimpleRecord> x$1 = $this.kvsToRecords((Iterable<KeyValue>)keyValues$1);
        long x$2 = 2L;
        LocalLog x$3 = $this.appendRecords$default$2();
        $this.appendRecords(x$1, x$3, x$2);
    }

    public static final /* synthetic */ void $anonfun$testLogCloseHandlers$1(LocalLogTest $this, Seq keyValues$2) {
        Iterable<SimpleRecord> x$1 = $this.kvsToRecords((Iterable<KeyValue>)keyValues$2);
        long x$2 = 2L;
        LocalLog x$3 = $this.appendRecords$default$2();
        $this.appendRecords(x$1, x$3, x$2);
    }

    public static final /* synthetic */ LogSegment $anonfun$testRemoveAndDeleteSegments$1(LocalLogTest $this, int offset) {
        SimpleRecord record = new SimpleRecord($this.mockTime().milliseconds(), "a".getBytes());
        .colon.colon x$1 = new .colon.colon((Object)record, (List)Nil$.MODULE$);
        long x$2 = offset;
        LocalLog x$3 = $this.appendRecords$default$2();
        $this.appendRecords((Iterable<SimpleRecord>)x$1, x$3, x$2);
        return $this.log().roll($this.log().roll$default$1());
    }

    public static final /* synthetic */ void $anonfun$testRemoveAndDeleteSegments$2(LogSegment segment) {
        Assertions.assertTrue((boolean)segment.deleted());
    }

    public static final /* synthetic */ LogSegment $anonfun$testDeleteSegmentFiles$1(LocalLogTest $this, int offset) {
        SimpleRecord record = new SimpleRecord($this.mockTime().milliseconds(), "a".getBytes());
        .colon.colon x$1 = new .colon.colon((Object)record, (List)Nil$.MODULE$);
        long x$2 = offset;
        LocalLog x$3 = $this.appendRecords$default$2();
        $this.appendRecords((Iterable<SimpleRecord>)x$1, x$3, x$2);
        return $this.log().roll($this.log().roll$default$1());
    }

    public static final /* synthetic */ void $anonfun$testDeleteSegmentFiles$2(LogSegment segment) {
        Assertions.assertFalse((boolean)segment.deleted());
        Assertions.assertTrue((boolean)segment.hasSuffix(LocalLog$.MODULE$.DeletedFileSuffix()));
    }

    public static final /* synthetic */ void $anonfun$testDeleteSegmentFiles$3(LogSegment segment) {
        Assertions.assertTrue((boolean)segment.deleted());
    }

    public static final /* synthetic */ LogSegment $anonfun$testDeletableSegmentsFilter$1(LocalLogTest $this, int offset) {
        SimpleRecord record = new SimpleRecord($this.mockTime().milliseconds(), "a".getBytes());
        .colon.colon x$1 = new .colon.colon((Object)record, (List)Nil$.MODULE$);
        long x$2 = offset;
        LocalLog x$3 = $this.appendRecords$default$2();
        $this.appendRecords((Iterable<SimpleRecord>)x$1, x$3, x$2);
        return $this.log().roll($this.log().roll$default$1());
    }

    public static final /* synthetic */ boolean $anonfun$testDeletableSegmentsFilter$2(LogSegment segment, Option x$1) {
        return segment.baseOffset() <= 5L;
    }

    public static final /* synthetic */ boolean $anonfun$testDeletableSegmentsFilter$3(LogSegment segment) {
        return segment.baseOffset() <= 5L;
    }

    public static final /* synthetic */ boolean $anonfun$testDeletableSegmentsFilter$4(LogSegment x$2, Option x$3) {
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$testDeletableSegmentsFilter$5(LogSegment x$4, Option x$5) {
        return true;
    }

    public static final /* synthetic */ LogSegment $anonfun$testDeletableSegmentsIteration$1(LocalLogTest $this, int offset) {
        SimpleRecord record = new SimpleRecord($this.mockTime().milliseconds(), "a".getBytes());
        .colon.colon x$1 = new .colon.colon((Object)record, (List)Nil$.MODULE$);
        long x$2 = offset;
        LocalLog x$3 = $this.appendRecords$default$2();
        $this.appendRecords((Iterable<SimpleRecord>)x$1, x$3, x$2);
        return $this.log().roll($this.log().roll$default$1());
    }

    public static final /* synthetic */ boolean $anonfun$testDeletableSegmentsIteration$2(LocalLogTest $this, IntRef offset$1, LogSegment segment, Option nextSegmentOpt) {
        Assertions.assertEquals((long)offset$1.elem, (long)segment.baseOffset());
        Option floorSegmentOpt = $this.log().segments().floorSegment((long)offset$1.elem);
        Assertions.assertTrue((boolean)floorSegmentOpt.isDefined());
        Assertions.assertEquals((Object)floorSegmentOpt.get(), (Object)segment);
        if ((long)offset$1.elem == $this.log().logEndOffset()) {
            Assertions.assertFalse((boolean)nextSegmentOpt.isDefined());
        } else {
            Assertions.assertTrue((boolean)nextSegmentOpt.isDefined());
            Option higherSegmentOpt = $this.log().segments().higherSegment(segment.baseOffset());
            Assertions.assertTrue((boolean)higherSegmentOpt.isDefined());
            Assertions.assertEquals((long)(segment.baseOffset() + 1L), (long)((LogSegment)higherSegmentOpt.get()).baseOffset());
            Assertions.assertEquals((Object)higherSegmentOpt.get(), (Object)nextSegmentOpt.get());
        }
        ++offset$1.elem;
        return true;
    }

    public static final /* synthetic */ Object $anonfun$testTruncateFullyAndStartAt$1(LocalLogTest $this, SimpleRecord record$1, int offset) {
        .colon.colon x$1 = new .colon.colon((Object)record$1, (List)Nil$.MODULE$);
        long x$2 = offset;
        LocalLog x$3 = $this.appendRecords$default$2();
        $this.appendRecords((Iterable<SimpleRecord>)x$1, x$3, x$2);
        if (offset % 2 != 0) {
            return $this.log().roll($this.log().roll$default$1());
        }
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testTruncateTo$1(LocalLogTest $this, int offset) {
        SimpleRecord record = new SimpleRecord($this.mockTime().milliseconds(), "a".getBytes());
        .colon.colon x$1 = new .colon.colon((Object)record, (List)Nil$.MODULE$);
        long x$2 = offset;
        LocalLog x$3 = $this.appendRecords$default$2();
        $this.appendRecords((Iterable<SimpleRecord>)x$1, x$3, x$2);
        if (offset % 3 == 2) {
            return $this.log().roll($this.log().roll$default$1());
        }
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ LogSegment $anonfun$testNonActiveSegmentsFrom$1(LocalLogTest $this, int i) {
        .colon.colon keyValues = new .colon.colon((Object)new KeyValue($this, Integer.toString(i), Integer.toString(i)), (List)Nil$.MODULE$);
        Iterable<SimpleRecord> x$1 = $this.kvsToRecords((Iterable<KeyValue>)keyValues);
        long x$2 = i;
        LocalLog x$3 = $this.appendRecords$default$2();
        $this.appendRecords(x$1, x$3, x$2);
        return $this.log().roll($this.log().roll$default$1());
    }

    private final Seq nonActiveBaseOffsetsFrom$1(long startOffset) {
        return ((TraversableOnce)this.log().segments().nonActiveLogSegmentsFrom(startOffset).map((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToLong((long)x$6.baseOffset()), Iterable$.MODULE$.canBuildFrom())).toSeq();
    }

    public static final /* synthetic */ void $anonfun$testParseTopicPartitionNameForNull$1(File dir$2) {
        LocalLog$.MODULE$.parseTopicPartitionName(dir$2);
    }

    public static final /* synthetic */ String $anonfun$testParseTopicPartitionNameForNull$2(File dir$2) {
        return new StringBuilder(48).append("KafkaException should have been thrown for dir: ").append(dir$2).toString();
    }

    public LocalLogTest() {
        LogConfig x$1 = LogTestUtils$.MODULE$.createLogConfig(LogTestUtils$.MODULE$.createLogConfig$default$1(), LogTestUtils$.MODULE$.createLogConfig$default$2(), LogTestUtils$.MODULE$.createLogConfig$default$3(), LogTestUtils$.MODULE$.createLogConfig$default$4(), LogTestUtils$.MODULE$.createLogConfig$default$5(), LogTestUtils$.MODULE$.createLogConfig$default$6(), LogTestUtils$.MODULE$.createLogConfig$default$7(), LogTestUtils$.MODULE$.createLogConfig$default$8(), LogTestUtils$.MODULE$.createLogConfig$default$9(), LogTestUtils$.MODULE$.createLogConfig$default$10());
        File x$2 = this.createLocalLogWithActiveSegment$default$1();
        LogSegments x$3 = this.createLocalLogWithActiveSegment$default$3();
        long x$4 = this.createLocalLogWithActiveSegment$default$4();
        LogOffsetMetadata x$5 = this.createLocalLogWithActiveSegment$default$5();
        Scheduler x$6 = this.createLocalLogWithActiveSegment$default$6();
        Time x$7 = this.createLocalLogWithActiveSegment$default$7();
        TopicPartition x$8 = this.createLocalLogWithActiveSegment$default$8();
        LogDirFailureChannel x$9 = this.createLocalLogWithActiveSegment$default$9();
        this.log = this.createLocalLogWithActiveSegment(x$2, x$1, x$3, x$4, x$5, x$6, x$7, x$8, x$9);
    }

    public class KeyValue
    implements Product,
    scala.Serializable {
        private final String key;
        private final String value;
        public final /* synthetic */ LocalLogTest $outer;

        public String key() {
            return this.key;
        }

        public String value() {
            return this.value;
        }

        public SimpleRecord toRecord(Function0<Object> timestamp) {
            return new SimpleRecord(timestamp.apply$mcJ$sp(), this.key().getBytes(), this.value().getBytes());
        }

        public long toRecord$default$1() {
            return this.kafka$log$LocalLogTest$KeyValue$$$outer().mockTime().milliseconds();
        }

        public KeyValue copy(String key, String value) {
            return new KeyValue(this.kafka$log$LocalLogTest$KeyValue$$$outer(), key, value);
        }

        public String copy$default$1() {
            return this.key();
        }

        public String copy$default$2() {
            return this.value();
        }

        public String productPrefix() {
            return "KeyValue";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            switch (x$1) {
                case 0: {
                    return this.key();
                }
                case 1: {
                    return this.value();
                }
            }
            throw new IndexOutOfBoundsException(Integer.toString(x$1));
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof KeyValue;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            if (!(x$1 instanceof KeyValue)) return false;
            if (((KeyValue)x$1).kafka$log$LocalLogTest$KeyValue$$$outer() != this.kafka$log$LocalLogTest$KeyValue$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            KeyValue keyValue = (KeyValue)x$1;
            String string = this.key();
            String string2 = keyValue.key();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            String string3 = this.value();
            String string4 = keyValue.value();
            if (string3 == null) {
                if (string4 != null) {
                    return false;
                }
            } else if (!string3.equals(string4)) return false;
            if (!keyValue.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ LocalLogTest kafka$log$LocalLogTest$KeyValue$$$outer() {
            return this.$outer;
        }

        public KeyValue(LocalLogTest $outer, String key, String value) {
            this.key = key;
            this.value = value;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }
}

