/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Properties;
import kafka.api.ApiVersion;
import kafka.api.ApiVersion$;
import kafka.api.KAFKA_0_11_0_IV0$;
import kafka.log.AbortedTxn;
import kafka.log.AppendOrigin;
import kafka.log.CleanerConfig;
import kafka.log.CleanerConfig$;
import kafka.log.ClientRecordDeletion$;
import kafka.log.LoadLogParams;
import kafka.log.LoadedLogOffsets;
import kafka.log.LocalLog;
import kafka.log.LogAppendInfo;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogLoader$;
import kafka.log.LogLoaderTest;
import kafka.log.LogLoaderTest$;
import kafka.log.LogLoaderTest$SimulateError$2$;
import kafka.log.LogManager;
import kafka.log.LogManager$;
import kafka.log.LogSegment;
import kafka.log.LogSegments;
import kafka.log.LogStartOffsetIncrementReason;
import kafka.log.LogTestUtils$;
import kafka.log.OffsetIndex;
import kafka.log.OffsetIndex$;
import kafka.log.ProducerStateEntry;
import kafka.log.ProducerStateManager;
import kafka.log.ProducerStateManager$;
import kafka.log.SnapshotFile;
import kafka.log.SnapshotFile$;
import kafka.log.UnifiedLog;
import kafka.log.UnifiedLog$;
import kafka.server.BrokerTopicStats;
import kafka.server.FetchDataInfo;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.LogDirFailureChannel;
import kafka.server.RequestLocal;
import kafka.server.epoch.EpochEntry;
import kafka.server.epoch.LeaderEpochFileCache;
import kafka.server.metadata.ConfigRepository;
import kafka.server.metadata.MockConfigRepository;
import kafka.utils.CoreUtils$;
import kafka.utils.MockTime;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.ControlRecordType;
import org.apache.kafka.common.record.DefaultRecordBatch;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MemoryRecordsBuilder;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.record.RecordVersion;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.easymock.EasyMock;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.Vector;
import scala.collection.immutable.Vector$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.Set$;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.LazyRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\tuh\u0001\u0002$H\u00011CQa\u0015\u0001\u0005\u0002QCqa\u0016\u0001A\u0002\u0013\u0005\u0001\fC\u0004`\u0001\u0001\u0007I\u0011\u00011\t\r\u0019\u0004\u0001\u0015)\u0003Z\u0011\u001d9\u0007A1A\u0005\u0002!Da\u0001\u001c\u0001!\u0002\u0013I\u0007bB7\u0001\u0005\u0004%\tA\u001c\u0005\u0007e\u0002\u0001\u000b\u0011B8\t\u000fM\u0004!\u0019!C\u0001i\"1Q\u0010\u0001Q\u0001\nUDqA \u0001C\u0002\u0013\u0005A\u000f\u0003\u0004\u0000\u0001\u0001\u0006I!\u001e\u0005\n\u0003\u0003\u0001!\u0019!C\u0001\u0003\u0007A\u0001\"!\u0005\u0001A\u0003%\u0011Q\u0001\u0005\b\u0003'\u0001A\u0011AA\u000b\u0011\u001d\t\t\u0004\u0001C\u0001\u0003+Aq!a\u000f\u0001\t\u0003\t)\u0002C\u0004\u0002F\u0001!\t!!\u0006\t\u000f\u0005%\u0003\u0001\"\u0001\u0002\u0016!9\u0011Q\n\u0001\u0005\n\u0005=\u0003\"CAS\u0001E\u0005I\u0011BAT\u0011%\ti\fAI\u0001\n\u0013\ty\fC\u0005\u0002D\u0002\t\n\u0011\"\u0003\u0002@\"I\u0011Q\u0019\u0001\u0012\u0002\u0013%\u0011q\u0019\u0005\n\u0003\u0017\u0004\u0011\u0013!C\u0005\u0003\u001bD\u0011\"!5\u0001#\u0003%I!a5\t\u0013\u0005]\u0007!%A\u0005\n\u0005M\u0007\"CAm\u0001E\u0005I\u0011BAn\u0011\u001d\ty\u000e\u0001C\u0005\u0003CDq!a=\u0001\t\u0013\t)\u0010C\u0004\u0003\n\u0001!IAa\u0003\t\u0013\t\u001d\u0003!%A\u0005\n\t%\u0003\"\u0003B'\u0001E\u0005I\u0011\u0002B(\u0011%\u0011\u0019\u0006AI\u0001\n\u0013\ty\fC\u0005\u0003V\u0001\t\n\u0011\"\u0003\u0003X!9!1\f\u0001\u0005\n\tu\u0003b\u0002B=\u0001\u0011\u0005\u0011Q\u0003\u0005\b\u0005{\u0002A\u0011AA\u000b\u0011\u001d\u0011\t\t\u0001C\u0001\u0003+AqA!\"\u0001\t\u0003\t)\u0002C\u0004\u0003\n\u0002!\t!!\u0006\t\u000f\t5\u0005\u0001\"\u0001\u0002\u0016!9!\u0011\u0013\u0001\u0005\u0002\u0005U\u0001b\u0002BK\u0001\u0011\u0005\u0011Q\u0003\u0005\b\u00053\u0003A\u0011AA\u000b\u0011\u001d\u0011i\n\u0001C\u0001\u0003+AqA!)\u0001\t\u0003\t)\u0002C\u0004\u0003&\u0002!\t!!\u0006\t\u000f\t%\u0006\u0001\"\u0001\u0002\u0016!9!Q\u0016\u0001\u0005\u0002\u0005U\u0001b\u0002BY\u0001\u0011\u0005\u0011Q\u0003\u0005\b\u0005k\u0003A\u0011AA\u000b\u0011\u001d\u0011I\f\u0001C\u0001\u0003+AqA!0\u0001\t\u0003\t)\u0002C\u0004\u0003B\u0002!\t!!\u0006\t\u000f\t\u0015\u0007\u0001\"\u0001\u0002\u0016!9!\u0011\u001a\u0001\u0005\u0002\u0005U\u0001b\u0002Bg\u0001\u0011\u0005\u0011Q\u0003\u0005\b\u0005#\u0004A\u0011AA\u000b\u0011\u001d\u0011)\u000e\u0001C\u0001\u0003+AqA!7\u0001\t\u0003\t)\u0002C\u0004\u0003^\u0002!\t!!\u0006\t\u000f\t\u0005\b\u0001\"\u0001\u0002\u0016!9!Q\u001d\u0001\u0005\u0002\u0005U\u0001b\u0002Bu\u0001\u0011\u0005\u0011Q\u0003\u0005\b\u0005[\u0004A\u0011AA\u000b\u0011\u001d\u0011\t\u0010\u0001C\u0001\u0003+AqA!>\u0001\t\u0003\t)\u0002C\u0004\u0003z\u0002!\t!!\u0006\u0003\u001b1{w\rT8bI\u0016\u0014H+Z:u\u0015\tA\u0015*A\u0002m_\u001eT\u0011AS\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001Q\n\u0005\u0002O#6\tqJC\u0001Q\u0003\u0015\u00198-\u00197b\u0013\t\u0011vJ\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003U\u0003\"A\u0016\u0001\u000e\u0003\u001d\u000baaY8oM&<W#A-\u0011\u0005ikV\"A.\u000b\u0005qK\u0015AB:feZ,'/\u0003\u0002_7\nY1*\u00194lC\u000e{gNZ5h\u0003)\u0019wN\u001c4jO~#S-\u001d\u000b\u0003C\u0012\u0004\"A\u00142\n\u0005\r|%\u0001B+oSRDq!Z\u0002\u0002\u0002\u0003\u0007\u0011,A\u0002yIE\nqaY8oM&<\u0007%\u0001\tce>\\WM\u001d+pa&\u001c7\u000b^1ugV\t\u0011\u000e\u0005\u0002[U&\u00111n\u0017\u0002\u0011\u0005J|7.\u001a:U_BL7m\u0015;biN\f\u0011C\u0019:pW\u0016\u0014Hk\u001c9jGN#\u0018\r^:!\u0003ei\u0017\r\u001f)s_\u0012,8-\u001a:JI\u0016C\b/\u001b:bi&|g.T:\u0016\u0003=\u0004\"A\u00149\n\u0005E|%aA%oi\u0006QR.\u0019=Qe>$WoY3s\u0013\u0012,\u0005\u0010]5sCRLwN\\'tA\u00051A/\u001c9ESJ,\u0012!\u001e\t\u0003mnl\u0011a\u001e\u0006\u0003qf\f!![8\u000b\u0003i\fAA[1wC&\u0011Ap\u001e\u0002\u0005\r&dW-A\u0004u[B$\u0015N\u001d\u0011\u0002\r1|w\rR5s\u0003\u001dawn\u001a#je\u0002\n\u0001\"\\8dWRKW.Z\u000b\u0003\u0003\u000b\u0001B!a\u0002\u0002\u000e5\u0011\u0011\u0011\u0002\u0006\u0004\u0003\u0017I\u0015!B;uS2\u001c\u0018\u0002BA\b\u0003\u0013\u0011\u0001\"T8dWRKW.Z\u0001\n[>\u001c7\u000eV5nK\u0002\nQa]3u+B$\u0012!\u0019\u0015\u0004\u001f\u0005e\u0001\u0003BA\u000e\u0003[i!!!\b\u000b\t\u0005}\u0011\u0011E\u0001\u0004CBL'\u0002BA\u0012\u0003K\tqA[;qSR,'O\u0003\u0003\u0002(\u0005%\u0012!\u00026v]&$(BAA\u0016\u0003\ry'oZ\u0005\u0005\u0003_\tiB\u0001\u0006CK\u001a|'/Z#bG\"\f\u0001\u0002^3be\u0012{wO\u001c\u0015\u0004!\u0005U\u0002\u0003BA\u000e\u0003oIA!!\u000f\u0002\u001e\tI\u0011I\u001a;fe\u0016\u000b7\r[\u0001'i\u0016\u001cH\u000fT8h%\u0016\u001cwN^3ss&\u001b8)\u00197mK\u0012,\u0006o\u001c8Ce>\\WM]\"sCND\u0007fA\t\u0002@A!\u00111DA!\u0013\u0011\t\u0019%!\b\u0003\tQ+7\u000f^\u00014i\u0016\u001cH\u000f\u0015:pIV\u001cWM]*oCB\u001c\bn\u001c;t%\u0016\u001cwN^3ss\u00063G/\u001a:V]\u000edW-\u00198TQV$Hm\\<o-FB3AEA \u0003\u0015#Xm\u001d;Qe>$WoY3s':\f\u0007o\u001d5piN\u0014VmY8wKJL\u0018I\u001a;feVs7\r\\3b]NCW\u000f\u001e3po:\u001cUO\u001d:f]RlUm]:bO\u00164uN]7bi\"\u001a1#a\u0010\u0002\u0013\r\u0014X-\u0019;f\u0019><GCFA)\u0003/\nY&a\u0019\u0002f\u0005=\u00141OA?\u0003+\u000b9*a'\u0011\u0007Y\u000b\u0019&C\u0002\u0002V\u001d\u0013!\"\u00168jM&,G\rT8h\u0011\u0019\tI\u0006\u0006a\u0001k\u0006\u0019A-\u001b:\t\r]#\u0002\u0019AA/!\r1\u0016qL\u0005\u0004\u0003C:%!\u0003'pO\u000e{gNZ5h\u0011\u001d9G\u0003%AA\u0002%D\u0011\"a\u001a\u0015!\u0003\u0005\r!!\u001b\u0002\u001d1|wm\u0015;beR|eMZ:fiB\u0019a*a\u001b\n\u0007\u00055tJ\u0001\u0003M_:<\u0007\"CA9)A\u0005\t\u0019AA5\u00035\u0011XmY8wKJL\bk\\5oi\"I\u0011Q\u000f\u000b\u0011\u0002\u0003\u0007\u0011qO\u0001\ng\u000eDW\rZ;mKJ\u0004B!a\u0002\u0002z%!\u00111PA\u0005\u0005%\u00196\r[3ek2,'\u000fC\u0005\u0002\u0000Q\u0001\n\u00111\u0001\u0002\u0002\u0006!A/[7f!\u0011\t\u0019)!%\u000e\u0005\u0005\u0015%\u0002BA\u0006\u0003\u000fSA!!#\u0002\f\u000611m\\7n_:T1ASAG\u0015\u0011\ty)!\u000b\u0002\r\u0005\u0004\u0018m\u00195f\u0013\u0011\t\u0019*!\"\u0003\tQKW.\u001a\u0005\b[R\u0001\n\u00111\u0001p\u0011!\tI\n\u0006I\u0001\u0002\u0004y\u0017a\t9s_\u0012,8-\u001a:JI\u0016C\b/\u001b:bi&|gn\u00115fG.Le\u000e^3sm\u0006dWj\u001d\u0005\n\u0003;#\u0002\u0013!a\u0001\u0003?\u000b\u0011\u0003\\1tiNCW\u000f\u001e3po:\u001cE.Z1o!\rq\u0015\u0011U\u0005\u0004\u0003G{%a\u0002\"p_2,\u0017M\\\u0001\u0014GJ,\u0017\r^3M_\u001e$C-\u001a4bk2$HeM\u000b\u0003\u0003SS3![AVW\t\ti\u000b\u0005\u0003\u00020\u0006eVBAAY\u0015\u0011\t\u0019,!.\u0002\u0013Ut7\r[3dW\u0016$'bAA\\\u001f\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005m\u0016\u0011\u0017\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017aE2sK\u0006$X\rT8hI\u0011,g-Y;mi\u0012\"TCAAaU\u0011\tI'a+\u0002'\r\u0014X-\u0019;f\u0019><G\u0005Z3gCVdG\u000fJ\u001b\u0002'\r\u0014X-\u0019;f\u0019><G\u0005Z3gCVdG\u000f\n\u001c\u0016\u0005\u0005%'\u0006BA<\u0003W\u000b1c\u0019:fCR,Gj\\4%I\u00164\u0017-\u001e7uI]*\"!a4+\t\u0005\u0005\u00151V\u0001\u0014GJ,\u0017\r^3M_\u001e$C-\u001a4bk2$H\u0005O\u000b\u0003\u0003+T3a\\AV\u0003M\u0019'/Z1uK2{w\r\n3fM\u0006,H\u000e\u001e\u0013:\u0003Q\u0019'/Z1uK2{w\r\n3fM\u0006,H\u000e\u001e\u00132aU\u0011\u0011Q\u001c\u0016\u0005\u0003?\u000bY+A\u000ede\u0016\fG/\u001a'pO^KG\u000f[(gMN,Go\u0014<fe\u001adwn\u001e\u000b\u0005\u0003G\fy\u000fE\u0004O\u0003K\f\t&!;\n\u0007\u0005\u001dxJ\u0001\u0004UkBdWM\r\t\u0004-\u0006-\u0018bAAw\u000f\nQAj\\4TK\u001elWM\u001c;\t\u000f\u0005EX\u00041\u0001\u0002^\u0005IAn\\4D_:4\u0017nZ\u0001\u0010e\u0016\u001cwN^3s\u0003:$7\t[3dWR1\u0011\u0011KA|\u0003sDaa\u0016\u0010A\u0002\u0005u\u0003bBA~=\u0001\u0007\u0011Q`\u0001\rKb\u0004Xm\u0019;fI.+\u0017p\u001d\t\u0007\u0003\u007f\u0014)!!\u001b\u000e\u0005\t\u0005!b\u0001B\u0002\u001f\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\t\u001d!\u0011\u0001\u0002\t\u0013R,'/\u00192mK\u0006y2/\u001b8hY\u0016$xN\u001c*fG>\u0014Hm],ji\"dU-\u00193fe\u0016\u0003xn\u00195\u0015!\t5!\u0011\u0004B\u0015\u0005[\u0011\tD!\u000e\u0003@\t\r\u0003\u0003\u0002B\b\u0005+i!A!\u0005\u000b\t\tM\u0011qQ\u0001\u0007e\u0016\u001cwN\u001d3\n\t\t]!\u0011\u0003\u0002\u000e\u001b\u0016lwN]=SK\u000e|'\u000fZ:\t\u000f\tmq\u00041\u0001\u0003\u001e\u0005)a/\u00197vKB)aJa\b\u0003$%\u0019!\u0011E(\u0003\u000b\u0005\u0013(/Y=\u0011\u00079\u0013)#C\u0002\u0003(=\u0013AAQ=uK\"I!1F\u0010\u0011\u0002\u0003\u0007!QD\u0001\u0004W\u0016L\bB\u0002B\u0018?\u0001\u0007q.A\u0006mK\u0006$WM]#q_\u000eD\u0007b\u0002B\u001a?\u0001\u0007\u0011\u0011N\u0001\u0007_\u001a47/\u001a;\t\u0013\t]r\u0004%AA\u0002\te\u0012!B2pI\u0016\u001c\u0007\u0003\u0002B\b\u0005wIAA!\u0010\u0003\u0012\ty1i\\7qe\u0016\u001c8/[8o)f\u0004X\rC\u0005\u0003B}\u0001\n\u00111\u0001\u0002j\u0005IA/[7fgR\fW\u000e\u001d\u0005\n\u0005\u000bz\u0002\u0013!a\u0001\u0005G\t!\"\\1hS\u000e4\u0016\r\\;f\u0003%\u001a\u0018N\\4mKR|gNU3d_J$7oV5uQ2+\u0017\rZ3s\u000bB|7\r\u001b\u0013eK\u001a\fW\u000f\u001c;%eU\u0011!1\n\u0016\u0005\u0005;\tY+A\u0015tS:<G.\u001a;p]J+7m\u001c:eg^KG\u000f\u001b'fC\u0012,'/\u00129pG\"$C-\u001a4bk2$H%N\u000b\u0003\u0005#RCA!\u000f\u0002,\u0006I3/\u001b8hY\u0016$xN\u001c*fG>\u0014Hm],ji\"dU-\u00193fe\u0016\u0003xn\u00195%I\u00164\u0017-\u001e7uIY\n\u0011f]5oO2,Go\u001c8SK\u000e|'\u000fZ:XSRDG*Z1eKJ,\u0005o\\2iI\u0011,g-Y;mi\u0012:TC\u0001B-U\u0011\u0011\u0019#a+\u0002cQ,7\u000f\u001e)s_\u0012,8-\u001a:T]\u0006\u00048\u000f[8ugJ+7m\u001c<fef\fe\r^3s+:\u001cG.Z1o'\",H\u000fZ8x]R\u0019\u0011Ma\u0018\t\u000f\t\u0005D\u00051\u0001\u0003d\u0005!R.Z:tC\u001e,gi\u001c:nCR4VM]:j_:\u0004BA!\u001a\u0003t9!!q\rB8!\r\u0011IgT\u0007\u0003\u0005WR1A!\u001cL\u0003\u0019a$o\\8u}%\u0019!\u0011O(\u0002\rA\u0013X\rZ3g\u0013\u0011\u0011)Ha\u001e\u0003\rM#(/\u001b8h\u0015\r\u0011\thT\u00014i\u0016\u001cHoU6ja2{\u0017\rZ5oO&3W)\u001c9usB\u0013x\u000eZ;dKJ\u001cF/\u0019;f\u0005\u00164wN]3UeVt7-\u0019;j_:D3!JA \u0003E\"Xm\u001d;SK\u000e|g/\u001a:BMR,'OT8o\u001b>tw\u000e^8oS\u000e\u001cun\u001c:eS:\fGo\u001c:Fa>\u001c\u0007n\u0016:ji\u0016D3AJA \u0003u\"Xm\u001d;TW&\u0004HK];oG\u0006$X-\u00118e%\u0016dw.\u00193JM>cG-T3tg\u0006<WMR8s[\u0006$\u0018I\u001c3O_\u000ecW-\u00198TQV$Hm\\<oQ\r9\u0013qH\u0001<i\u0016\u001cHoU6jaR\u0013XO\\2bi\u0016\fe\u000e\u001a*fY>\fG-\u00134PY\u0012lUm]:bO\u00164uN]7bi\u0006sGm\u00117fC:\u001c\u0006.\u001e;e_^t\u0007f\u0001\u0015\u0002@\u0005YD/Z:u'.L\u0007\u000f\u0016:v]\u000e\fG/Z!oIJ+Gn\\1e\u0013\u001atUm^'fgN\fw-\u001a$pe6\fG/\u00118e\u00072,\u0017M\\*ikR$wn\u001e8)\u0007%\ny$A\u0017uKN$Hj\\1e!J|G-^2feN\fe\r^3s\t\u0016dW\r^3SK\u000e|'\u000fZ:NS\u0012\u001cVmZ7f]RD3AKA \u0003Q\"Xm\u001d;M_\u0006$\u0017N\\4M_\u001e\\U-\u001a9t\u0019\u0006\u0014x-Z:u'R\u0014\u0018-\u001f)s_\u0012,8-\u001a:Ti\u0006$Xm\u00158baNDw\u000e\u001e\u0015\u0004W\u0005}\u0012\u0001\f;fgRdu.\u00193Qe>$WoY3sg\u00063G/\u001a:EK2,G/\u001a*fG>\u0014Hm](o'\u0016<W.\u001a8uQ\ra\u0013qH\u0001\u001fi\u0016\u001cH\u000fT8h%\u0016\u001cwN^3sgR{7i\u001c:sK\u000e$xJ\u001a4tKRD3!LA \u0003A!Xm\u001d;J]\u0012,\u0007PU3ck&dG\rK\u0002/\u0003\u007f\t!\u0005^3tiJ+'-^5mIRKW.Z%oI\u0016Dhi\u001c:PY\u0012lUm]:bO\u0016\u001c\bfA\u0018\u0002@\u00059B/Z:u\u0007>\u0014(/\u001e9u\u0013:$W\r\u001f*fEVLG\u000e\u001a\u0015\u0004a\u0005}\u0012\u0001\t;fgR\u0014unZ;t\u0013:$W\r_*fO6,g\u000e^:Be\u0016\u0014V-\\8wK\u0012D3!MA \u0003Y!Xm\u001d;SK>\u0004XM\u001c+iK:$&/\u001e8dCR,\u0007f\u0001\u001a\u0002@\u0005aB/Z:u\u001fB,g\u000eR3mKR,7o\u00142t_2,G/\u001a$jY\u0016\u001c\bfA\u001a\u0002@\u0005qA/Z:u\u0007>\u0014(/\u001e9u\u0019><\u0007f\u0001\u001b\u0002@\u0005aB/Z:u\u001fZ,'oQ8na\u0006\u001cG/\u001a3M_\u001e\u0014VmY8wKJL\bfA\u001b\u0002@\u0005aD/Z:u\u0019\u0016\fG-\u001a:Fa>\u001c\u0007nQ1dQ\u0016\u001cE.Z1sK\u0012\fe\r^3s'R\fG/[2NKN\u001c\u0018mZ3G_Jl\u0017\r\u001e#po:<'/\u00193fQ\r1\u0014qH\u0001(i\u0016\u001cHo\u0014<fe\u000e{W\u000e]1di\u0016$Gj\\4SK\u000e|g/\u001a:z\u001bVdG/\u001b*fG>\u0014H\rK\u00028\u0003\u007f\t\u0011\u0006^3ti>3XM]\"p[B\f7\r^3e\u0019><'+Z2pm\u0016\u0014\u00180T;mi&\u0014VmY8sIZ\u000b\u0004f\u0001\u001d\u0002@\u00059C/Z:u%\u0016\u001cwN^3ss>37+Z4nK:$x+\u001b;i\u001f\u001a47/\u001a;Pm\u0016\u0014h\r\\8xQ\rI\u0014qH\u0001(i\u0016\u001cHOU3d_Z,'/_!gi\u0016\u00148I]1tQ\u0012+(/\u001b8h'Bd\u0017\u000e\u001e)iCN,\u0017\u0007K\u0002;\u0003\u007f\tq\u0005^3tiJ+7m\u001c<fef\fe\r^3s\u0007J\f7\u000f\u001b#ve&twm\u00159mSR\u0004\u0006.Y:fe!\u001a1(a\u0010\u0002OQ,7\u000f\u001e*fG>4XM]=BMR,'o\u0011:bg\"$UO]5oON\u0003H.\u001b;QQ\u0006\u001cXm\r\u0015\u0004y\u0005}\u0012a\n;fgR\u0014VmY8wKJL\u0018I\u001a;fe\u000e\u0013\u0018m\u001d5EkJLgnZ*qY&$\b\u000b[1tKRB3!PA \u0003\u001d\"Xm\u001d;SK\u000e|g/\u001a:z\u0003\u001a$XM]\"sCNDG)\u001e:j]\u001e\u001c\u0006\u000f\\5u!\"\f7/Z\u001b)\u0007y\ny$A\u000buKN$8\t\\3b]NCW\u000f\u001e3po:4\u0015\u000e\\3)\u0007}\ny$A\u000fuKN$Hj\\4SK\u000e|g/\u001a:t\r>\u0014H*Z1eKJ,\u0005o\\2iQ\r\u0001\u0015qH\u0001!i\u0016\u001cHOR;mYR\u0013\u0018M\\:bGRLwN\\%oI\u0016D(+Z2pm\u0016\u0014\u0018\u0010K\u0002B\u0003\u007f\t!\u0004^3tiJ+7m\u001c<fe>sG.\u001f'bgR\u001cVmZ7f]RD3AQA \u0003\u0015\"Xm\u001d;SK\u000e|g/\u001a:MCN$8+Z4nK:$x+\u001b;i\u001d>\u001cf.\u00199tQ>$8\u000fK\u0002D\u0003\u007f\t!\u0005^3ti2{w-\u00128e\u0019\u0016\u001c8\u000f\u00165b]N#\u0018M\u001d;BMR,'OU3pa\u0016t\u0007f\u0001#\u0002@\u00059E/Z:u\u0007>\u0014(/\u001e9uK\u0012dun\u001a*fG>4XM]=E_\u0016\u001chj\u001c;EK2,G/\u001a)s_\u0012,8-\u001a:Ti\u0006$Xm\u00158baNDw\u000e^:Q_N$(+Z2pm\u0016\u0014\u0018\u0010K\u0002F\u0003\u007f\u0001")
public class LogLoaderTest {
    private KafkaConfig config = null;
    private final BrokerTopicStats brokerTopicStats = new BrokerTopicStats();
    private final int maxProducerIdExpirationMs;
    private final File tmpDir = TestUtils$.MODULE$.tempDir();
    private final File logDir = TestUtils$.MODULE$.randomPartitionLogDir(this.tmpDir());
    private final MockTime mockTime = new MockTime();

    public KafkaConfig config() {
        return this.config;
    }

    public void config_$eq(KafkaConfig x$1) {
        this.config = x$1;
    }

    public BrokerTopicStats brokerTopicStats() {
        return this.brokerTopicStats;
    }

    public int maxProducerIdExpirationMs() {
        return this.maxProducerIdExpirationMs;
    }

    public File tmpDir() {
        return this.tmpDir;
    }

    public File logDir() {
        return this.logDir;
    }

    public MockTime mockTime() {
        return this.mockTime;
    }

    @BeforeEach
    public void setUp() {
        int x$1 = 0;
        String x$2 = "127.0.0.1:1";
        int x$3 = -1;
        boolean x$4 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$5 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$6 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$7 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$8 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$9 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$10 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$11 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$12 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$13 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$14 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$15 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$16 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        int x$17 = TestUtils$.MODULE$.createBrokerConfig$default$17();
        boolean x$18 = TestUtils$.MODULE$.createBrokerConfig$default$18();
        int x$19 = TestUtils$.MODULE$.createBrokerConfig$default$19();
        short x$20 = TestUtils$.MODULE$.createBrokerConfig$default$20();
        Properties props = TestUtils$.MODULE$.createBrokerConfig(x$1, x$2, x$4, x$5, x$3, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20);
        this.config_$eq(KafkaConfig$.MODULE$.fromProps(props));
    }

    @AfterEach
    public void tearDown() {
        this.brokerTopicStats().close();
        Utils.delete((File)this.tmpDir());
    }

    @Test
    public void testLogRecoveryIsCalledUponBrokerCrash() {
        LazyRef SimulateError$module = new LazyRef();
        File logDir = TestUtils$.MODULE$.tempDir();
        Properties logProps = new Properties();
        LogConfig logConfig = new LogConfig((java.util.Map)logProps, LogConfig$.MODULE$.apply$default$2());
        .colon.colon logDirs = new .colon.colon((Object)logDir, (List)Nil$.MODULE$);
        TopicPartition topicPartition = new TopicPartition("foo", 0);
        MockTime time = new MockTime();
        BooleanRef cleanShutdownInterceptedValue = BooleanRef.create((boolean)false);
        public class Kafka_log_LogLoaderTest$SimulateError$1
        implements Product,
        scala.Serializable {
            private boolean hasError;
            private final /* synthetic */ LogLoaderTest $outer;

            public boolean hasError() {
                return this.hasError;
            }

            public void hasError_$eq(boolean x$1) {
                this.hasError = x$1;
            }

            public Kafka_log_LogLoaderTest$SimulateError$1 copy(boolean hasError) {
                return new Kafka_log_LogLoaderTest$SimulateError$1(this.$outer, hasError);
            }

            public boolean copy$default$1() {
                return this.hasError();
            }

            public String productPrefix() {
                return "SimulateError";
            }

            public int productArity() {
                return 1;
            }

            public Object productElement(int x$1) {
                switch (x$1) {
                    case 0: {
                        return BoxesRunTime.boxToBoolean((boolean)this.hasError());
                    }
                }
                throw new IndexOutOfBoundsException(Integer.toString(x$1));
            }

            public Iterator<Object> productIterator() {
                return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
            }

            public boolean canEqual(Object x$1) {
                return x$1 instanceof Kafka_log_LogLoaderTest$SimulateError$1;
            }

            public int hashCode() {
                return Statics.finalizeHash((int)Statics.mix((int)-889275714, (int)(this.hasError() ? 1231 : 1237)), (int)1);
            }

            public String toString() {
                return ScalaRunTime$.MODULE$._toString((Product)this);
            }

            public boolean equals(Object x$1) {
                block3: {
                    block2: {
                        if (this == x$1) break block2;
                        boolean bl = x$1 instanceof Kafka_log_LogLoaderTest$SimulateError$1;
                        if (!bl) break block3;
                        Kafka_log_LogLoaderTest$SimulateError$1 var3_3 = (Kafka_log_LogLoaderTest$SimulateError$1)x$1;
                        if (!(this.hasError() == var3_3.hasError() && var3_3.canEqual(this))) break block3;
                    }
                    return true;
                }
                return false;
            }

            public Kafka_log_LogLoaderTest$SimulateError$1(LogLoaderTest $outer, boolean hasError) {
                this.hasError = hasError;
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                Product.$init$((Product)this);
            }
        }
        Kafka_log_LogLoaderTest$SimulateError$1 simulateError = this.SimulateError$3(SimulateError$module).apply(this.SimulateError$3(SimulateError$module).apply$default$1());
        File cleanShutdownFile = new File(logDir, LogLoader$.MODULE$.CleanShutdownFile());
        LogManager logManager = this.interceptedLogManager$1(logConfig, (Seq)logDirs, simulateError, time, cleanShutdownInterceptedValue);
        boolean x$2 = true;
        None$ x$3 = None$.MODULE$;
        boolean x$4 = logManager.getOrCreateLog$default$3();
        logManager.getOrCreateLog(topicPartition, x$2, x$4, (Option)x$3);
        Files.createFile(cleanShutdownFile.toPath(), new FileAttribute[0]);
        cleanShutdownInterceptedValue.elem = false;
        LogConfig defaultConfig = logManager.currentDefaultConfig();
        logManager.loadLogs(defaultConfig, logManager.fetchTopicConfigOverrides(defaultConfig, (Set)Predef$.MODULE$.Set().empty()));
        Assertions.assertTrue((boolean)cleanShutdownInterceptedValue.elem, (String)"Unexpected value intercepted for clean shutdown flag");
        Assertions.assertFalse((boolean)cleanShutdownFile.exists(), (String)"Clean shutdown file must not exist after loadLogs has completed");
        cleanShutdownInterceptedValue.elem = true;
        defaultConfig = logManager.currentDefaultConfig();
        logManager.loadLogs(defaultConfig, logManager.fetchTopicConfigOverrides(defaultConfig, (Set)Predef$.MODULE$.Set().empty()));
        Assertions.assertFalse((boolean)cleanShutdownInterceptedValue.elem, (String)"Unexpected value intercepted for clean shutdown flag");
        Assertions.assertFalse((boolean)cleanShutdownFile.exists(), (String)"Clean shutdown file must not exist after loadLogs has completed");
        Files.createFile(cleanShutdownFile.toPath(), new FileAttribute[0]);
        logManager.shutdown();
        Predef$.MODULE$.locally((Object)BoxedUnit.UNIT);
        simulateError.hasError_$eq(true);
        LogManager logManager2 = this.interceptedLogManager$1(logConfig, (Seq)logDirs, simulateError, time, cleanShutdownInterceptedValue);
        boolean x$6 = true;
        None$ x$7 = None$.MODULE$;
        boolean x$8 = logManager2.getOrCreateLog$default$3();
        logManager2.getOrCreateLog(topicPartition, x$6, x$8, (Option)x$7);
        Assertions.assertThrows(RuntimeException.class, () -> {
            LogConfig defaultConfig = logManager2.currentDefaultConfig();
            logManager2.loadLogs(defaultConfig, logManager2.fetchTopicConfigOverrides(defaultConfig, (Set)Predef$.MODULE$.Set().empty()));
        });
        Assertions.assertFalse((boolean)cleanShutdownFile.exists(), (String)"Clean shutdown file must not have existed");
        simulateError.hasError_$eq(false);
        cleanShutdownInterceptedValue.elem = true;
        LogConfig defaultConfig2 = logManager2.currentDefaultConfig();
        logManager2.loadLogs(defaultConfig2, logManager2.fetchTopicConfigOverrides(defaultConfig2, (Set)Predef$.MODULE$.Set().empty()));
        Assertions.assertFalse((boolean)cleanShutdownInterceptedValue.elem, (String)"Unexpected value for clean shutdown flag");
        Predef$.MODULE$.locally((Object)BoxedUnit.UNIT);
    }

    @Test
    public void testProducerSnapshotsRecoveryAfterUncleanShutdownV1() {
        this.testProducerSnapshotsRecoveryAfterUncleanShutdown(ApiVersion$.MODULE$.minSupportedFor(RecordVersion.V1).version());
    }

    @Test
    public void testProducerSnapshotsRecoveryAfterUncleanShutdownCurrentMessageFormat() {
        this.testProducerSnapshotsRecoveryAfterUncleanShutdown(ApiVersion$.MODULE$.latestVersion().version());
    }

    private UnifiedLog createLog(File dir, LogConfig config, BrokerTopicStats brokerTopicStats, long logStartOffset, long recoveryPoint, Scheduler scheduler, Time time, int maxProducerIdExpirationMs, int producerIdExpirationCheckIntervalMs, boolean lastShutdownClean) {
        return LogTestUtils$.MODULE$.createLog(dir, config, brokerTopicStats, scheduler, time, logStartOffset, recoveryPoint, maxProducerIdExpirationMs, producerIdExpirationCheckIntervalMs, lastShutdownClean, LogTestUtils$.MODULE$.createLog$default$11(), LogTestUtils$.MODULE$.createLog$default$12());
    }

    private BrokerTopicStats createLog$default$3() {
        return this.brokerTopicStats();
    }

    private long createLog$default$4() {
        return 0L;
    }

    private long createLog$default$5() {
        return 0L;
    }

    private Scheduler createLog$default$6() {
        return this.mockTime().scheduler();
    }

    private Time createLog$default$7() {
        return this.mockTime();
    }

    private int createLog$default$8() {
        return this.maxProducerIdExpirationMs();
    }

    private int createLog$default$9() {
        return LogManager$.MODULE$.ProducerIdExpirationCheckIntervalMs();
    }

    private boolean createLog$default$10() {
        return true;
    }

    private Tuple2<UnifiedLog, LogSegment> createLogWithOffsetOverflow(LogConfig logConfig) {
        LogTestUtils$.MODULE$.initializeLogDirWithOverflowedSegment(this.logDir());
        File x$1 = this.logDir();
        long x$3 = Long.MAX_VALUE;
        BrokerTopicStats x$4 = this.createLog$default$3();
        long x$5 = this.createLog$default$4();
        Scheduler x$6 = this.createLog$default$6();
        Time x$7 = this.createLog$default$7();
        int x$8 = this.createLog$default$8();
        int x$9 = this.createLog$default$9();
        boolean x$10 = this.createLog$default$10();
        UnifiedLog log = this.createLog(x$1, logConfig, x$4, x$5, x$3, x$6, x$7, x$8, x$9, x$10);
        LogSegment segmentWithOverflow = (LogSegment)LogTestUtils$.MODULE$.firstOverflowSegment(log).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new AssertionError((Object)"Failed to create log with a segment which has overflowed offsets");
        });
        return new Tuple2((Object)log, (Object)segmentWithOverflow);
    }

    private UnifiedLog recoverAndCheck(LogConfig config, Iterable<Object> expectedKeys) {
        return LogTestUtils$.MODULE$.recoverAndCheck(this.logDir(), config, expectedKeys, this.brokerTopicStats(), (Time)this.mockTime(), this.mockTime().scheduler());
    }

    private MemoryRecords singletonRecordsWithLeaderEpoch(byte[] value, byte[] key, int leaderEpoch, long offset, CompressionType codec, long timestamp, byte magicValue) {
        .colon.colon records = new .colon.colon((Object)new SimpleRecord(timestamp, key, value), (List)Nil$.MODULE$);
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)ByteBuffer.allocate(DefaultRecordBatch.sizeInBytes((java.lang.Iterable)((java.lang.Iterable)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)records).asJava()))), (byte)magicValue, (CompressionType)codec, (TimestampType)TimestampType.CREATE_TIME, (long)offset, (long)this.mockTime().milliseconds(), (int)leaderEpoch);
        records.foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            builder.append(x$1);
            return BoxedUnit.UNIT;
        });
        return builder.build();
    }

    private byte[] singletonRecordsWithLeaderEpoch$default$2() {
        return null;
    }

    private CompressionType singletonRecordsWithLeaderEpoch$default$5() {
        return CompressionType.NONE;
    }

    private long singletonRecordsWithLeaderEpoch$default$6() {
        return -1L;
    }

    private byte singletonRecordsWithLeaderEpoch$default$7() {
        return 2;
    }

    /*
     * WARNING - void declaration
     */
    private void testProducerSnapshotsRecoveryAfterUncleanShutdown(String messageFormatVersion) {
        void var14_11;
        void var13_10;
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), "640");
        logProps.put(LogConfig$.MODULE$.MessageFormatVersionProp(), messageFormatVersion);
        LogConfig logConfig = new LogConfig((java.util.Map)logProps, LogConfig$.MODULE$.apply$default$2());
        ObjectRef log = ObjectRef.create((Object)this.createLog(this.logDir(), logConfig, this.createLog$default$3(), this.createLog$default$4(), this.createLog$default$5(), this.createLog$default$6(), this.createLog$default$7(), this.createLog$default$8(), this.createLog$default$9(), this.createLog$default$10()));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)((UnifiedLog)log.elem).oldestProducerSnapshotOffset());
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 100).foreach((Function1 & Serializable & scala.Serializable)i -> LogLoaderTest.$anonfun$testProducerSnapshotsRecoveryAfterUncleanShutdown$1(this, log, BoxesRunTime.unboxToInt((Object)i)));
        Assertions.assertTrue((((UnifiedLog)log.elem).logSegments().size() >= 5 ? 1 : 0) != 0);
        Vector segmentOffsets = (Vector)((UnifiedLog)log.elem).logSegments().toVector().map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToLong((long)x$2.baseOffset()), Vector$.MODULE$.canBuildFrom());
        long activeSegmentOffset = BoxesRunTime.unboxToLong((Object)segmentOffsets.last());
        long offsetForSegmentAfterRecoveryPoint = BoxesRunTime.unboxToLong((Object)segmentOffsets.apply(segmentOffsets.size() - 3));
        long offsetForRecoveryPointSegment = BoxesRunTime.unboxToLong((Object)segmentOffsets.apply(segmentOffsets.size() - 4));
        Tuple2 tuple2 = segmentOffsets.toSet().partition((Function1)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)x$3 -> x$3 < offsetForRecoveryPointSegment);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        scala.collection.immutable.Set segOffsetsBeforeRecovery = (scala.collection.immutable.Set)tuple2._1();
        scala.collection.immutable.Set segOffsetsAfterRecovery = (scala.collection.immutable.Set)tuple2._2();
        void segOffsetsBeforeRecovery2 = var13_10;
        void segOffsetsAfterRecovery2 = var14_11;
        long recoveryPoint = offsetForRecoveryPointSegment + 1L;
        Assertions.assertTrue((recoveryPoint < offsetForSegmentAfterRecoveryPoint ? 1 : 0) != 0);
        ((UnifiedLog)log.elem).close();
        scala.collection.mutable.Set segmentsWithReads = (scala.collection.mutable.Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        scala.collection.mutable.Set recoveredSegments = (scala.collection.mutable.Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        scala.collection.mutable.Set expectedSegmentsWithReads = (scala.collection.mutable.Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        scala.collection.mutable.Set expectedSnapshotOffsets = (scala.collection.mutable.Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        if (logConfig.messageFormatVersion().$less((Object)KAFKA_0_11_0_IV0$.MODULE$)) {
            expectedSegmentsWithReads.$plus$eq((Object)BoxesRunTime.boxToLong((long)activeSegmentOffset));
            expectedSnapshotOffsets.$plus$plus$eq((TraversableOnce)((TraversableOnce)((UnifiedLog)log.elem).logSegments().map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToLong((long)x$5.baseOffset()), Iterable$.MODULE$.canBuildFrom())).toVector().takeRight(2).$colon$plus((Object)BoxesRunTime.boxToLong((long)((UnifiedLog)log.elem).logEndOffset()), Vector$.MODULE$.canBuildFrom()));
        } else {
            expectedSegmentsWithReads.$plus$plus$eq((TraversableOnce)segOffsetsBeforeRecovery2.$plus$plus((GenTraversableOnce)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{activeSegmentOffset}))));
            expectedSnapshotOffsets.$plus$plus$eq((TraversableOnce)((TraversableOnce)((UnifiedLog)log.elem).logSegments().map((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToLong((long)x$6.baseOffset()), Iterable$.MODULE$.canBuildFrom())).toVector().takeRight(4).$colon$plus((Object)BoxesRunTime.boxToLong((long)((UnifiedLog)log.elem).logEndOffset()), Vector$.MODULE$.canBuildFrom()));
        }
        ((UnifiedLog)log.elem).producerStateManager().deleteSnapshotsBefore(BoxesRunTime.unboxToLong((Object)segmentOffsets.apply(segmentOffsets.size() - 2)));
        log.elem = this.createLogWithInterceptedReads$1(offsetForRecoveryPointSegment, segmentsWithReads, recoveredSegments, logConfig);
        Assertions.assertEquals((Object)expectedSegmentsWithReads, (Object)segmentsWithReads.map((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToLong((long)x$7.baseOffset()), Set$.MODULE$.canBuildFrom()));
        Assertions.assertEquals((Object)segOffsetsAfterRecovery2, (Object)recoveredSegments.map((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToLong((long)x$8.baseOffset()), Set$.MODULE$.canBuildFrom()));
        Assertions.assertEquals((Object)expectedSnapshotOffsets, (Object)LogTestUtils$.MODULE$.listProducerSnapshotOffsets(this.logDir()).toSet());
        ((UnifiedLog)log.elem).close();
        segmentsWithReads.clear();
        recoveredSegments.clear();
        ((UnifiedLog)log.elem).producerStateManager().deleteSnapshotsBefore(offsetForRecoveryPointSegment);
        log.elem = this.createLogWithInterceptedReads$1(recoveryPoint, segmentsWithReads, recoveredSegments, logConfig);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{activeSegmentOffset})), (Object)segmentsWithReads.map((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToLong((long)x$9.baseOffset()), Set$.MODULE$.canBuildFrom()));
        Assertions.assertEquals((Object)segOffsetsAfterRecovery2, (Object)recoveredSegments.map((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToLong((long)x$10.baseOffset()), Set$.MODULE$.canBuildFrom()));
        Assertions.assertEquals((Object)expectedSnapshotOffsets, (Object)LogTestUtils$.MODULE$.listProducerSnapshotOffsets(this.logDir()).toSet());
        ((UnifiedLog)log.elem).close();
    }

    @Test
    public void testSkipLoadingIfEmptyProducerStateBeforeTruncation() {
        ProducerStateManager stateManager = (ProducerStateManager)EasyMock.mock(ProducerStateManager.class);
        stateManager.removeStraySnapshots((Seq)EasyMock.anyObject());
        EasyMock.expect((Object)BoxedUnit.UNIT).anyTimes();
        EasyMock.expect((Object)stateManager.latestSnapshotOffset()).andReturn((Object)None$.MODULE$);
        stateManager.updateMapEndOffset(0L);
        EasyMock.expectLastCall().anyTimes();
        EasyMock.expect((Object)BoxesRunTime.boxToLong((long)stateManager.mapEndOffset())).andStubReturn((Object)BoxesRunTime.boxToLong((long)0L));
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)stateManager.isEmpty())).andStubReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        stateManager.takeSnapshot();
        EasyMock.expectLastCall().anyTimes();
        stateManager.truncateAndReload(EasyMock.eq((long)0L), EasyMock.eq((long)0L), EasyMock.anyLong());
        EasyMock.expectLastCall();
        EasyMock.expect((Object)stateManager.firstUnstableOffset()).andStubReturn((Object)None$.MODULE$);
        EasyMock.replay((Object[])new Object[]{stateManager});
        TopicPartition topicPartition = UnifiedLog$.MODULE$.parseTopicPartitionName(this.logDir());
        LogDirFailureChannel logDirFailureChannel = new LogDirFailureChannel(1);
        LogConfig config = new LogConfig((java.util.Map)new Properties(), LogConfig$.MODULE$.apply$default$2());
        int maxProducerIdExpirationMs = 300000;
        LogSegments segments = new LogSegments(topicPartition);
        Option leaderEpochCache = UnifiedLog$.MODULE$.maybeCreateLeaderEpochCache(this.logDir(), topicPartition, logDirFailureChannel, config.recordVersion(), "");
        LoadedLogOffsets offsets = LogLoader$.MODULE$.load(new LoadLogParams(this.logDir(), topicPartition, config, (Scheduler)this.mockTime().scheduler(), (Time)this.mockTime(), logDirFailureChannel, false, segments, 0L, 0L, maxProducerIdExpirationMs, leaderEpochCache, stateManager));
        LocalLog localLog = new LocalLog(this.logDir(), config, segments, offsets.recoveryPoint(), offsets.nextOffsetMetadata(), (Scheduler)this.mockTime().scheduler(), (Time)this.mockTime(), topicPartition, logDirFailureChannel);
        UnifiedLog log = new UnifiedLog(offsets.logStartOffset(), localLog, this.brokerTopicStats(), 30000, leaderEpochCache, stateManager, (Option)None$.MODULE$, true);
        EasyMock.verify((Object[])new Object[]{stateManager});
        EasyMock.reset((Object[])new Object[]{stateManager});
        EasyMock.expect((Object)stateManager.firstUnstableOffset()).andStubReturn((Object)None$.MODULE$);
        stateManager.updateMapEndOffset(1L);
        EasyMock.expectLastCall();
        stateManager.updateMapEndOffset(2L);
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{stateManager});
        log.appendAsLeader(TestUtils$.MODULE$.records((Iterable<SimpleRecord>)new .colon.colon((Object)new SimpleRecord("a".getBytes()), (List)Nil$.MODULE$), TestUtils$.MODULE$.records$default$2(), TestUtils$.MODULE$.records$default$3(), TestUtils$.MODULE$.records$default$4(), TestUtils$.MODULE$.records$default$5(), TestUtils$.MODULE$.records$default$6(), TestUtils$.MODULE$.records$default$7(), TestUtils$.MODULE$.records$default$8()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.appendAsLeader(TestUtils$.MODULE$.records((Iterable<SimpleRecord>)new .colon.colon((Object)new SimpleRecord("b".getBytes()), (List)Nil$.MODULE$), TestUtils$.MODULE$.records$default$2(), TestUtils$.MODULE$.records$default$3(), TestUtils$.MODULE$.records$default$4(), TestUtils$.MODULE$.records$default$5(), TestUtils$.MODULE$.records$default$6(), TestUtils$.MODULE$.records$default$7(), TestUtils$.MODULE$.records$default$8()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        EasyMock.verify((Object[])new Object[]{stateManager});
        EasyMock.reset((Object[])new Object[]{stateManager});
        EasyMock.expect((Object)stateManager.firstUnstableOffset()).andStubReturn((Object)None$.MODULE$);
        EasyMock.expect((Object)stateManager.latestSnapshotOffset()).andReturn((Object)None$.MODULE$);
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)stateManager.isEmpty())).andStubReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        EasyMock.expect((Object)BoxesRunTime.boxToLong((long)stateManager.mapEndOffset())).andReturn((Object)BoxesRunTime.boxToLong((long)2L));
        stateManager.truncateAndReload(EasyMock.eq((long)0L), EasyMock.eq((long)1L), EasyMock.anyLong());
        EasyMock.expectLastCall();
        EasyMock.expect((Object)BoxesRunTime.boxToLong((long)stateManager.mapEndOffset())).andReturn((Object)BoxesRunTime.boxToLong((long)0L));
        stateManager.updateMapEndOffset(1L);
        EasyMock.expect((Object)BoxedUnit.UNIT);
        stateManager.takeSnapshot();
        EasyMock.expectLastCall().once();
        EasyMock.replay((Object[])new Object[]{stateManager});
        log.truncateTo(1L);
        EasyMock.verify((Object[])new Object[]{stateManager});
    }

    @Test
    public void testRecoverAfterNonMonotonicCoordinatorEpochWrite() {
        long producerId = 1L;
        int coordinatorEpoch = 5;
        int x$1 = 0x500000;
        long x$2 = LogTestUtils$.MODULE$.createLogConfig$default$1();
        long x$3 = LogTestUtils$.MODULE$.createLogConfig$default$3();
        long x$4 = LogTestUtils$.MODULE$.createLogConfig$default$4();
        long x$5 = LogTestUtils$.MODULE$.createLogConfig$default$5();
        String x$6 = LogTestUtils$.MODULE$.createLogConfig$default$6();
        int x$7 = LogTestUtils$.MODULE$.createLogConfig$default$7();
        int x$8 = LogTestUtils$.MODULE$.createLogConfig$default$8();
        int x$9 = LogTestUtils$.MODULE$.createLogConfig$default$9();
        long x$10 = LogTestUtils$.MODULE$.createLogConfig$default$10();
        LogConfig logConfig = LogTestUtils$.MODULE$.createLogConfig(x$2, x$1, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10);
        UnifiedLog log = this.createLog(this.logDir(), logConfig, this.createLog$default$3(), this.createLog$default$4(), this.createLog$default$5(), this.createLog$default$6(), this.createLog$default$7(), this.createLog$default$8(), this.createLog$default$9(), this.createLog$default$10());
        short epoch = (short)0;
        long firstAppendTimestamp = this.mockTime().milliseconds();
        LogTestUtils$.MODULE$.appendEndTxnMarkerAsLeader(log, producerId, epoch, ControlRecordType.ABORT, firstAppendTimestamp, coordinatorEpoch, LogTestUtils$.MODULE$.appendEndTxnMarkerAsLeader$default$7());
        Assertions.assertEquals((long)firstAppendTimestamp, (long)((ProducerStateEntry)log.producerStateManager().lastEntry(producerId).get()).lastTimestamp());
        int maxProducerIdExpirationMs = 3600000;
        this.mockTime().sleep(maxProducerIdExpirationMs);
        Assertions.assertEquals((Object)None$.MODULE$, (Object)log.producerStateManager().lastEntry(producerId));
        long secondAppendTimestamp = this.mockTime().milliseconds();
        LogTestUtils$.MODULE$.appendEndTxnMarkerAsLeader(log, producerId, epoch, ControlRecordType.ABORT, secondAppendTimestamp, coordinatorEpoch - 1, LogTestUtils$.MODULE$.appendEndTxnMarkerAsLeader$default$7());
        log.close();
        File x$11 = this.logDir();
        long x$13 = 0L;
        boolean x$14 = false;
        BrokerTopicStats x$15 = this.createLog$default$3();
        long x$16 = this.createLog$default$4();
        Scheduler x$17 = this.createLog$default$6();
        Time x$18 = this.createLog$default$7();
        int x$19 = this.createLog$default$8();
        int x$20 = this.createLog$default$9();
        log = this.createLog(x$11, logConfig, x$15, x$16, x$13, x$17, x$18, x$19, x$20, x$14);
        Assertions.assertEquals((long)secondAppendTimestamp, (long)((ProducerStateEntry)log.producerStateManager().lastEntry(producerId).get()).lastTimestamp());
        log.close();
    }

    @Test
    public void testSkipTruncateAndReloadIfOldMessageFormatAndNoCleanShutdown() {
        ProducerStateManager stateManager = (ProducerStateManager)EasyMock.mock(ProducerStateManager.class);
        stateManager.removeStraySnapshots((Seq)EasyMock.anyObject());
        EasyMock.expect((Object)BoxedUnit.UNIT).anyTimes();
        stateManager.updateMapEndOffset(0L);
        EasyMock.expectLastCall().anyTimes();
        stateManager.takeSnapshot();
        EasyMock.expectLastCall().anyTimes();
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)stateManager.isEmpty())).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        EasyMock.expectLastCall().once();
        EasyMock.expect((Object)stateManager.firstUnstableOffset()).andReturn((Object)None$.MODULE$);
        EasyMock.expectLastCall().once();
        EasyMock.replay((Object[])new Object[]{stateManager});
        TopicPartition topicPartition = UnifiedLog$.MODULE$.parseTopicPartitionName(this.logDir());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.MessageFormatVersionProp(), "0.10.2");
        LogConfig config = new LogConfig((java.util.Map)logProps, LogConfig$.MODULE$.apply$default$2());
        int maxProducerIdExpirationMs = 300000;
        LogSegments segments = new LogSegments(topicPartition);
        Option leaderEpochCache = UnifiedLog$.MODULE$.maybeCreateLeaderEpochCache(this.logDir(), topicPartition, null, config.recordVersion(), "");
        LoadedLogOffsets offsets = LogLoader$.MODULE$.load(new LoadLogParams(this.logDir(), topicPartition, config, (Scheduler)this.mockTime().scheduler(), (Time)this.mockTime(), null, false, segments, 0L, 0L, maxProducerIdExpirationMs, leaderEpochCache, stateManager));
        LocalLog localLog = new LocalLog(this.logDir(), config, segments, offsets.recoveryPoint(), offsets.nextOffsetMetadata(), (Scheduler)this.mockTime().scheduler(), (Time)this.mockTime(), topicPartition, null);
        new UnifiedLog(offsets.logStartOffset(), localLog, this.brokerTopicStats(), 30000, leaderEpochCache, stateManager, (Option)None$.MODULE$, true);
        EasyMock.verify((Object[])new Object[]{stateManager});
    }

    @Test
    public void testSkipTruncateAndReloadIfOldMessageFormatAndCleanShutdown() {
        ProducerStateManager stateManager = (ProducerStateManager)EasyMock.mock(ProducerStateManager.class);
        stateManager.removeStraySnapshots((Seq)EasyMock.anyObject());
        EasyMock.expect((Object)BoxedUnit.UNIT).anyTimes();
        stateManager.updateMapEndOffset(0L);
        EasyMock.expectLastCall().anyTimes();
        stateManager.takeSnapshot();
        EasyMock.expectLastCall().anyTimes();
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)stateManager.isEmpty())).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        EasyMock.expectLastCall().once();
        EasyMock.expect((Object)stateManager.firstUnstableOffset()).andReturn((Object)None$.MODULE$);
        EasyMock.expectLastCall().once();
        EasyMock.replay((Object[])new Object[]{stateManager});
        TopicPartition topicPartition = UnifiedLog$.MODULE$.parseTopicPartitionName(this.logDir());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.MessageFormatVersionProp(), "0.10.2");
        LogConfig config = new LogConfig((java.util.Map)logProps, LogConfig$.MODULE$.apply$default$2());
        int maxProducerIdExpirationMs = 300000;
        LogSegments segments = new LogSegments(topicPartition);
        Option leaderEpochCache = UnifiedLog$.MODULE$.maybeCreateLeaderEpochCache(this.logDir(), topicPartition, null, config.recordVersion(), "");
        LoadedLogOffsets offsets = LogLoader$.MODULE$.load(new LoadLogParams(this.logDir(), topicPartition, config, (Scheduler)this.mockTime().scheduler(), (Time)this.mockTime(), null, true, segments, 0L, 0L, maxProducerIdExpirationMs, leaderEpochCache, stateManager));
        LocalLog localLog = new LocalLog(this.logDir(), config, segments, offsets.recoveryPoint(), offsets.nextOffsetMetadata(), (Scheduler)this.mockTime().scheduler(), (Time)this.mockTime(), topicPartition, null);
        new UnifiedLog(offsets.logStartOffset(), localLog, this.brokerTopicStats(), 30000, leaderEpochCache, stateManager, (Option)None$.MODULE$, true);
        EasyMock.verify((Object[])new Object[]{stateManager});
    }

    @Test
    public void testSkipTruncateAndReloadIfNewMessageFormatAndCleanShutdown() {
        ProducerStateManager stateManager = (ProducerStateManager)EasyMock.mock(ProducerStateManager.class);
        stateManager.removeStraySnapshots((Seq)EasyMock.anyObject());
        EasyMock.expect((Object)BoxedUnit.UNIT).anyTimes();
        EasyMock.expect((Object)stateManager.latestSnapshotOffset()).andReturn((Object)None$.MODULE$);
        stateManager.updateMapEndOffset(0L);
        EasyMock.expectLastCall().anyTimes();
        stateManager.takeSnapshot();
        EasyMock.expectLastCall().anyTimes();
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)stateManager.isEmpty())).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        EasyMock.expectLastCall().once();
        EasyMock.expect((Object)stateManager.firstUnstableOffset()).andReturn((Object)None$.MODULE$);
        EasyMock.expectLastCall().once();
        EasyMock.replay((Object[])new Object[]{stateManager});
        TopicPartition topicPartition = UnifiedLog$.MODULE$.parseTopicPartitionName(this.logDir());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.MessageFormatVersionProp(), "0.11.0");
        LogConfig config = new LogConfig((java.util.Map)logProps, LogConfig$.MODULE$.apply$default$2());
        int maxProducerIdExpirationMs = 300000;
        LogSegments segments = new LogSegments(topicPartition);
        Option leaderEpochCache = UnifiedLog$.MODULE$.maybeCreateLeaderEpochCache(this.logDir(), topicPartition, null, config.recordVersion(), "");
        LoadedLogOffsets offsets = LogLoader$.MODULE$.load(new LoadLogParams(this.logDir(), topicPartition, config, (Scheduler)this.mockTime().scheduler(), (Time)this.mockTime(), null, true, segments, 0L, 0L, maxProducerIdExpirationMs, leaderEpochCache, stateManager));
        LocalLog localLog = new LocalLog(this.logDir(), config, segments, offsets.recoveryPoint(), offsets.nextOffsetMetadata(), (Scheduler)this.mockTime().scheduler(), (Time)this.mockTime(), topicPartition, null);
        new UnifiedLog(offsets.logStartOffset(), localLog, this.brokerTopicStats(), 30000, leaderEpochCache, stateManager, (Option)None$.MODULE$, true);
        EasyMock.verify((Object[])new Object[]{stateManager});
    }

    @Test
    public void testLoadProducersAfterDeleteRecordsMidSegment() {
        int x$1 = 10240;
        long x$2 = LogTestUtils$.MODULE$.createLogConfig$default$1();
        long x$3 = LogTestUtils$.MODULE$.createLogConfig$default$3();
        long x$4 = LogTestUtils$.MODULE$.createLogConfig$default$4();
        long x$5 = LogTestUtils$.MODULE$.createLogConfig$default$5();
        String x$6 = LogTestUtils$.MODULE$.createLogConfig$default$6();
        int x$7 = LogTestUtils$.MODULE$.createLogConfig$default$7();
        int x$8 = LogTestUtils$.MODULE$.createLogConfig$default$8();
        int x$9 = LogTestUtils$.MODULE$.createLogConfig$default$9();
        long x$10 = LogTestUtils$.MODULE$.createLogConfig$default$10();
        LogConfig logConfig = LogTestUtils$.MODULE$.createLogConfig(x$2, x$1, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10);
        UnifiedLog log = this.createLog(this.logDir(), logConfig, this.createLog$default$3(), this.createLog$default$4(), this.createLog$default$5(), this.createLog$default$6(), this.createLog$default$7(), this.createLog$default$8(), this.createLog$default$9(), this.createLog$default$10());
        long pid1 = 1L;
        long pid2 = 2L;
        short epoch = (short)0;
        .colon.colon x$11 = new .colon.colon((Object)new SimpleRecord(this.mockTime().milliseconds(), "a".getBytes()), (List)Nil$.MODULE$);
        int x$14 = 0;
        byte x$15 = TestUtils$.MODULE$.records$default$2();
        CompressionType x$16 = TestUtils$.MODULE$.records$default$3();
        long x$17 = TestUtils$.MODULE$.records$default$7();
        int x$18 = TestUtils$.MODULE$.records$default$8();
        log.appendAsLeader(TestUtils$.MODULE$.records((Iterable<SimpleRecord>)x$11, x$15, x$16, pid1, epoch, x$14, x$17, x$18), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        .colon.colon x$19 = new .colon.colon((Object)new SimpleRecord(this.mockTime().milliseconds(), "b".getBytes()), (List)Nil$.MODULE$);
        int x$22 = 0;
        byte x$23 = TestUtils$.MODULE$.records$default$2();
        CompressionType x$24 = TestUtils$.MODULE$.records$default$3();
        long x$25 = TestUtils$.MODULE$.records$default$7();
        int x$26 = TestUtils$.MODULE$.records$default$8();
        log.appendAsLeader(TestUtils$.MODULE$.records((Iterable<SimpleRecord>)x$19, x$23, x$24, pid2, epoch, x$22, x$25, x$26), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        Assertions.assertEquals((int)2, (int)log.activeProducersWithLastSequence().size());
        log.updateHighWatermark(log.logEndOffset());
        log.maybeIncrementLogStartOffset(1L, (LogStartOffsetIncrementReason)ClientRecordDeletion$.MODULE$);
        Assertions.assertEquals((int)2, (int)log.activeProducersWithLastSequence().size());
        Option retainedLastSeqOpt = log.activeProducersWithLastSequence().get((Object)BoxesRunTime.boxToLong((long)pid2));
        Assertions.assertTrue((boolean)retainedLastSeqOpt.isDefined());
        Assertions.assertEquals((int)0, (int)BoxesRunTime.unboxToInt((Object)retainedLastSeqOpt.get()));
        log.close();
        File x$27 = this.logDir();
        long x$29 = 1L;
        boolean x$30 = false;
        BrokerTopicStats x$31 = this.createLog$default$3();
        long x$32 = this.createLog$default$5();
        Scheduler x$33 = this.createLog$default$6();
        Time x$34 = this.createLog$default$7();
        int x$35 = this.createLog$default$8();
        int x$36 = this.createLog$default$9();
        UnifiedLog reloadedLog = this.createLog(x$27, logConfig, x$31, x$29, x$32, x$33, x$34, x$35, x$36, x$30);
        Assertions.assertEquals((int)2, (int)reloadedLog.activeProducersWithLastSequence().size());
        Option reloadedLastSeqOpt = log.activeProducersWithLastSequence().get((Object)BoxesRunTime.boxToLong((long)pid2));
        Assertions.assertEquals((Object)retainedLastSeqOpt, (Object)reloadedLastSeqOpt);
    }

    @Test
    public void testLoadingLogKeepsLargestStrayProducerStateSnapshot() {
        int x$1 = 10240;
        long x$2 = 0L;
        long x$3 = 60000L;
        long x$4 = 0L;
        long x$5 = LogTestUtils$.MODULE$.createLogConfig$default$1();
        long x$6 = LogTestUtils$.MODULE$.createLogConfig$default$5();
        String x$7 = LogTestUtils$.MODULE$.createLogConfig$default$6();
        int x$8 = LogTestUtils$.MODULE$.createLogConfig$default$7();
        int x$9 = LogTestUtils$.MODULE$.createLogConfig$default$8();
        int x$10 = LogTestUtils$.MODULE$.createLogConfig$default$9();
        LogConfig logConfig = LogTestUtils$.MODULE$.createLogConfig(x$5, x$1, x$3, x$2, x$6, x$7, x$8, x$9, x$10, x$4);
        UnifiedLog log = this.createLog(this.logDir(), logConfig, this.createLog$default$3(), this.createLog$default$4(), this.createLog$default$5(), this.createLog$default$6(), this.createLog$default$7(), this.createLog$default$8(), this.createLog$default$9(), this.createLog$default$10());
        long pid1 = 1L;
        short epoch = (short)0;
        .colon.colon x$112 = new .colon.colon((Object)new SimpleRecord("a".getBytes()), (List)Nil$.MODULE$);
        int x$14 = 0;
        byte x$15 = TestUtils$.MODULE$.records$default$2();
        CompressionType x$16 = TestUtils$.MODULE$.records$default$3();
        long x$17 = TestUtils$.MODULE$.records$default$7();
        int x$18 = TestUtils$.MODULE$.records$default$8();
        log.appendAsLeader(TestUtils$.MODULE$.records((Iterable<SimpleRecord>)x$112, x$15, x$16, pid1, epoch, x$14, x$17, x$18), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.roll(log.roll$default$1());
        .colon.colon x$19 = new .colon.colon((Object)new SimpleRecord("b".getBytes()), (List)Nil$.MODULE$);
        int x$22 = 1;
        byte x$23 = TestUtils$.MODULE$.records$default$2();
        CompressionType x$24 = TestUtils$.MODULE$.records$default$3();
        long x$25 = TestUtils$.MODULE$.records$default$7();
        int x$26 = TestUtils$.MODULE$.records$default$8();
        log.appendAsLeader(TestUtils$.MODULE$.records((Iterable<SimpleRecord>)x$19, x$23, x$24, pid1, epoch, x$22, x$25, x$26), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.roll(log.roll$default$1());
        .colon.colon x$27 = new .colon.colon((Object)new SimpleRecord("c".getBytes()), (List)Nil$.MODULE$);
        int x$30 = 2;
        byte x$31 = TestUtils$.MODULE$.records$default$2();
        CompressionType x$32 = TestUtils$.MODULE$.records$default$3();
        long x$33 = TestUtils$.MODULE$.records$default$7();
        int x$34 = TestUtils$.MODULE$.records$default$8();
        log.appendAsLeader(TestUtils$.MODULE$.records((Iterable<SimpleRecord>)x$27, x$31, x$32, pid1, epoch, x$30, x$33, x$34), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        .colon.colon x$35 = new .colon.colon((Object)new SimpleRecord("d".getBytes()), (List)Nil$.MODULE$);
        int x$38 = 3;
        byte x$39 = TestUtils$.MODULE$.records$default$2();
        CompressionType x$40 = TestUtils$.MODULE$.records$default$3();
        long x$41 = TestUtils$.MODULE$.records$default$7();
        int x$42 = TestUtils$.MODULE$.records$default$8();
        log.appendAsLeader(TestUtils$.MODULE$.records((Iterable<SimpleRecord>)x$35, x$39, x$40, pid1, epoch, x$38, x$41, x$42), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.close();
        Assertions.assertEquals((int)log.logSegments().size(), (int)3);
        Assertions.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 4})), (Object)((SeqLike)ProducerStateManager$.MODULE$.listSnapshotFiles(this.logDir()).map((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToLong((long)x$11.offset()), Seq$.MODULE$.canBuildFrom())).sorted((Ordering)Ordering.Long$.MODULE$));
        Files.createFile(UnifiedLog$.MODULE$.producerSnapshotFile(this.logDir(), 3L).toPath(), new FileAttribute[0]);
        Assertions.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3, 4})), (Object)((SeqLike)ProducerStateManager$.MODULE$.listSnapshotFiles(this.logDir()).map((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToLong((long)x$12.offset()), Seq$.MODULE$.canBuildFrom())).sorted((Ordering)Ordering.Long$.MODULE$));
        File x$43 = this.logDir();
        boolean x$45 = false;
        BrokerTopicStats x$46 = this.createLog$default$3();
        long x$47 = this.createLog$default$4();
        long x$48 = this.createLog$default$5();
        Scheduler x$49 = this.createLog$default$6();
        Time x$50 = this.createLog$default$7();
        int x$51 = this.createLog$default$8();
        int x$52 = this.createLog$default$9();
        this.createLog(x$43, logConfig, x$46, x$47, x$48, x$49, x$50, x$51, x$52, x$45);
        Assertions.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 4})), (Object)((SeqLike)ProducerStateManager$.MODULE$.listSnapshotFiles(this.logDir()).map((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToLong((long)x$13.offset()), Seq$.MODULE$.canBuildFrom())).sorted((Ordering)Ordering.Long$.MODULE$));
    }

    @Test
    public void testLoadProducersAfterDeleteRecordsOnSegment() {
        int x$1 = 10240;
        long x$2 = LogTestUtils$.MODULE$.createLogConfig$default$1();
        long x$3 = LogTestUtils$.MODULE$.createLogConfig$default$3();
        long x$4 = LogTestUtils$.MODULE$.createLogConfig$default$4();
        long x$5 = LogTestUtils$.MODULE$.createLogConfig$default$5();
        String x$6 = LogTestUtils$.MODULE$.createLogConfig$default$6();
        int x$7 = LogTestUtils$.MODULE$.createLogConfig$default$7();
        int x$8 = LogTestUtils$.MODULE$.createLogConfig$default$8();
        int x$9 = LogTestUtils$.MODULE$.createLogConfig$default$9();
        long x$10 = LogTestUtils$.MODULE$.createLogConfig$default$10();
        LogConfig logConfig = LogTestUtils$.MODULE$.createLogConfig(x$2, x$1, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10);
        UnifiedLog log = this.createLog(this.logDir(), logConfig, this.createLog$default$3(), this.createLog$default$4(), this.createLog$default$5(), this.createLog$default$6(), this.createLog$default$7(), this.createLog$default$8(), this.createLog$default$9(), this.createLog$default$10());
        long pid1 = 1L;
        long pid2 = 2L;
        short epoch = (short)0;
        .colon.colon x$11 = new .colon.colon((Object)new SimpleRecord(this.mockTime().milliseconds(), "a".getBytes()), (List)Nil$.MODULE$);
        int x$14 = 0;
        byte x$15 = TestUtils$.MODULE$.records$default$2();
        CompressionType x$16 = TestUtils$.MODULE$.records$default$3();
        long x$17 = TestUtils$.MODULE$.records$default$7();
        int x$18 = TestUtils$.MODULE$.records$default$8();
        log.appendAsLeader(TestUtils$.MODULE$.records((Iterable<SimpleRecord>)x$11, x$15, x$16, pid1, epoch, x$14, x$17, x$18), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.roll(log.roll$default$1());
        .colon.colon x$19 = new .colon.colon((Object)new SimpleRecord(this.mockTime().milliseconds(), "b".getBytes()), (List)Nil$.MODULE$);
        int x$22 = 0;
        byte x$23 = TestUtils$.MODULE$.records$default$2();
        CompressionType x$24 = TestUtils$.MODULE$.records$default$3();
        long x$25 = TestUtils$.MODULE$.records$default$7();
        int x$26 = TestUtils$.MODULE$.records$default$8();
        log.appendAsLeader(TestUtils$.MODULE$.records((Iterable<SimpleRecord>)x$19, x$23, x$24, pid2, epoch, x$22, x$25, x$26), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        Assertions.assertEquals((int)2, (int)log.logSegments().size());
        Assertions.assertEquals((int)2, (int)log.activeProducersWithLastSequence().size());
        log.updateHighWatermark(log.logEndOffset());
        log.maybeIncrementLogStartOffset(1L, (LogStartOffsetIncrementReason)ClientRecordDeletion$.MODULE$);
        log.deleteOldSegments();
        Assertions.assertEquals((int)1, (int)log.logSegments().size());
        Assertions.assertEquals((int)2, (int)log.activeProducersWithLastSequence().size());
        Option retainedLastSeqOpt = log.activeProducersWithLastSequence().get((Object)BoxesRunTime.boxToLong((long)pid2));
        Assertions.assertTrue((boolean)retainedLastSeqOpt.isDefined());
        Assertions.assertEquals((int)0, (int)BoxesRunTime.unboxToInt((Object)retainedLastSeqOpt.get()));
        log.close();
        File x$27 = this.logDir();
        long x$29 = 1L;
        boolean x$30 = false;
        BrokerTopicStats x$31 = this.createLog$default$3();
        long x$32 = this.createLog$default$5();
        Scheduler x$33 = this.createLog$default$6();
        Time x$34 = this.createLog$default$7();
        int x$35 = this.createLog$default$8();
        int x$36 = this.createLog$default$9();
        UnifiedLog reloadedLog = this.createLog(x$27, logConfig, x$31, x$29, x$32, x$33, x$34, x$35, x$36, x$30);
        Assertions.assertEquals((int)1, (int)reloadedLog.activeProducersWithLastSequence().size());
        Option reloadedEntryOpt = log.activeProducersWithLastSequence().get((Object)BoxesRunTime.boxToLong((long)pid2));
        Assertions.assertEquals((Object)retainedLastSeqOpt, (Object)reloadedEntryOpt);
    }

    @Test
    public void testLogRecoversToCorrectOffset() {
        int numMessages = 100;
        int messageSize = 100;
        int segmentSize = 7 * messageSize;
        int indexInterval = 3 * messageSize;
        int x$3 = 4096;
        long x$4 = LogTestUtils$.MODULE$.createLogConfig$default$1();
        long x$5 = LogTestUtils$.MODULE$.createLogConfig$default$3();
        long x$6 = LogTestUtils$.MODULE$.createLogConfig$default$4();
        long x$7 = LogTestUtils$.MODULE$.createLogConfig$default$5();
        String x$8 = LogTestUtils$.MODULE$.createLogConfig$default$6();
        int x$9 = LogTestUtils$.MODULE$.createLogConfig$default$7();
        long x$10 = LogTestUtils$.MODULE$.createLogConfig$default$10();
        LogConfig logConfig = LogTestUtils$.MODULE$.createLogConfig(x$4, segmentSize, x$5, x$6, x$7, x$8, x$9, indexInterval, x$3, x$10);
        ObjectRef log = ObjectRef.create((Object)this.createLog(this.logDir(), logConfig, this.createLog$default$3(), this.createLog$default$4(), this.createLog$default$5(), this.createLog$default$6(), this.createLog$default$7(), this.createLog$default$8(), this.createLog$default$9(), this.createLog$default$10()));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numMessages).foreach((Function1 & Serializable & scala.Serializable)i -> LogLoaderTest.$anonfun$testLogRecoversToCorrectOffset$1(this, log, messageSize, BoxesRunTime.unboxToInt((Object)i)));
        Assertions.assertEquals((long)numMessages, (long)((UnifiedLog)log.elem).logEndOffset(), (String)new StringOps(Predef$.MODULE$.augmentString("After appending %d messages to an empty log, the log end offset should be %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)numMessages), BoxesRunTime.boxToInteger((int)numMessages)})));
        long lastIndexOffset = ((UnifiedLog)log.elem).activeSegment().offsetIndex().lastOffset();
        int numIndexEntries = ((UnifiedLog)log.elem).activeSegment().offsetIndex().entries();
        long lastOffset = ((UnifiedLog)log.elem).logEndOffset();
        long lastTimeIndexOffset = ((UnifiedLog)log.elem).logEndOffset() - 1L;
        long lastTimeIndexTimestamp = ((UnifiedLog)log.elem).activeSegment().largestTimestamp();
        int numTimeIndexEntries = ((UnifiedLog)log.elem).activeSegment().timeIndex().entries() + (((UnifiedLog)log.elem).activeSegment().timeIndex().lastEntry().offset() == ((UnifiedLog)log.elem).logEndOffset() - 1L ? 0 : 1);
        ((UnifiedLog)log.elem).close();
        File x$21 = this.logDir();
        boolean x$24 = false;
        BrokerTopicStats x$25 = this.createLog$default$3();
        long x$26 = this.createLog$default$4();
        Scheduler x$27 = this.createLog$default$6();
        Time x$28 = this.createLog$default$7();
        int x$29 = this.createLog$default$8();
        int x$30 = this.createLog$default$9();
        log.elem = this.createLog(x$21, logConfig, x$25, x$26, lastOffset, x$27, x$28, x$29, x$30, x$24);
        LogLoaderTest.verifyRecoveredLog$1((UnifiedLog)log.elem, lastOffset, numMessages, lastIndexOffset, numIndexEntries, lastTimeIndexTimestamp, lastTimeIndexOffset, numTimeIndexEntries);
        ((UnifiedLog)log.elem).close();
        int recoveryPoint = 10;
        File x$31 = this.logDir();
        long x$33 = recoveryPoint;
        boolean x$34 = false;
        BrokerTopicStats x$35 = this.createLog$default$3();
        long x$36 = this.createLog$default$4();
        Scheduler x$37 = this.createLog$default$6();
        Time x$38 = this.createLog$default$7();
        int x$39 = this.createLog$default$8();
        int x$40 = this.createLog$default$9();
        log.elem = this.createLog(x$31, logConfig, x$35, x$36, x$33, x$37, x$38, x$39, x$40, x$34);
        LogLoaderTest.verifyRecoveredLog$1((UnifiedLog)log.elem, recoveryPoint, numMessages, lastIndexOffset, numIndexEntries, lastTimeIndexTimestamp, lastTimeIndexOffset, numTimeIndexEntries);
        ((UnifiedLog)log.elem).flush();
        LogLoaderTest.verifyRecoveredLog$1((UnifiedLog)log.elem, lastOffset, numMessages, lastIndexOffset, numIndexEntries, lastTimeIndexTimestamp, lastTimeIndexOffset, numTimeIndexEntries);
        ((UnifiedLog)log.elem).close();
    }

    @Test
    public void testIndexRebuild() {
        int numMessages = 200;
        int x$1 = 200;
        int x$2 = 1;
        long x$3 = LogTestUtils$.MODULE$.createLogConfig$default$1();
        long x$4 = LogTestUtils$.MODULE$.createLogConfig$default$3();
        long x$5 = LogTestUtils$.MODULE$.createLogConfig$default$4();
        long x$6 = LogTestUtils$.MODULE$.createLogConfig$default$5();
        String x$7 = LogTestUtils$.MODULE$.createLogConfig$default$6();
        int x$8 = LogTestUtils$.MODULE$.createLogConfig$default$7();
        int x$9 = LogTestUtils$.MODULE$.createLogConfig$default$9();
        long x$10 = LogTestUtils$.MODULE$.createLogConfig$default$10();
        LogConfig logConfig = LogTestUtils$.MODULE$.createLogConfig(x$3, x$1, x$4, x$5, x$6, x$7, x$8, x$2, x$9, x$10);
        ObjectRef log = ObjectRef.create((Object)this.createLog(this.logDir(), logConfig, this.createLog$default$3(), this.createLog$default$4(), this.createLog$default$5(), this.createLog$default$6(), this.createLog$default$7(), this.createLog$default$8(), this.createLog$default$9(), this.createLog$default$10()));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numMessages).foreach((Function1 & Serializable & scala.Serializable)i -> LogLoaderTest.$anonfun$testIndexRebuild$1(this, log, BoxesRunTime.unboxToInt((Object)i)));
        Iterable indexFiles = (Iterable)((UnifiedLog)log.elem).logSegments().map((Function1 & Serializable & scala.Serializable)x$14 -> x$14.lazyOffsetIndex().file(), Iterable$.MODULE$.canBuildFrom());
        Iterable timeIndexFiles = (Iterable)((UnifiedLog)log.elem).logSegments().map((Function1 & Serializable & scala.Serializable)x$15 -> x$15.lazyTimeIndex().file(), Iterable$.MODULE$.canBuildFrom());
        ((UnifiedLog)log.elem).close();
        indexFiles.foreach((Function1 & Serializable & scala.Serializable)x$16 -> BoxesRunTime.boxToBoolean((boolean)x$16.delete()));
        timeIndexFiles.foreach((Function1 & Serializable & scala.Serializable)x$17 -> BoxesRunTime.boxToBoolean((boolean)x$17.delete()));
        File x$21 = this.logDir();
        boolean x$23 = false;
        BrokerTopicStats x$24 = this.createLog$default$3();
        long x$25 = this.createLog$default$4();
        long x$26 = this.createLog$default$5();
        Scheduler x$27 = this.createLog$default$6();
        Time x$28 = this.createLog$default$7();
        int x$29 = this.createLog$default$8();
        int x$30 = this.createLog$default$9();
        log.elem = this.createLog(x$21, logConfig, x$24, x$25, x$26, x$27, x$28, x$29, x$30, x$23);
        Assertions.assertEquals((long)numMessages, (long)((UnifiedLog)log.elem).logEndOffset(), (String)new StringOps(Predef$.MODULE$.augmentString("Should have %d messages when log is reopened")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)numMessages)})));
        Assertions.assertTrue((((LogSegment)((UnifiedLog)log.elem).logSegments().head()).offsetIndex().entries() > 0 ? 1 : 0) != 0, (String)"The index should have been rebuilt");
        Assertions.assertTrue((((LogSegment)((UnifiedLog)log.elem).logSegments().head()).timeIndex().entries() > 0 ? 1 : 0) != 0, (String)"The time index should have been rebuilt");
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numMessages).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            Assertions.assertEquals((long)i, (long)((RecordBatch)LogTestUtils$.MODULE$.readLog((UnifiedLog)log$3.elem, i, 100, LogTestUtils$.MODULE$.readLog$default$4(), LogTestUtils$.MODULE$.readLog$default$5()).records().batches().iterator().next()).lastOffset());
            if (i == 0) {
                Assertions.assertEquals((long)((LogSegment)((UnifiedLog)log$3.elem).logSegments().head()).baseOffset(), (long)((FileRecords.TimestampAndOffset)((UnifiedLog)log$3.elem).fetchOffsetByTimestamp((long)($this.mockTime().milliseconds() + (long)(i * 10))).get()).offset);
                return;
            }
            Assertions.assertEquals((long)i, (long)((FileRecords.TimestampAndOffset)((UnifiedLog)log$3.elem).fetchOffsetByTimestamp((long)($this.mockTime().milliseconds() + (long)(i * 10))).get()).offset);
        });
        ((UnifiedLog)log.elem).close();
    }

    @Test
    public void testRebuildTimeIndexForOldMessages() {
        int numMessages = 200;
        int segmentSize = 200;
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Integer.toString(segmentSize));
        logProps.put(LogConfig$.MODULE$.IndexIntervalBytesProp(), "1");
        logProps.put(LogConfig$.MODULE$.MessageFormatVersionProp(), "0.9.0");
        LogConfig logConfig = new LogConfig((java.util.Map)logProps, LogConfig$.MODULE$.apply$default$2());
        ObjectRef log = ObjectRef.create((Object)this.createLog(this.logDir(), logConfig, this.createLog$default$3(), this.createLog$default$4(), this.createLog$default$5(), this.createLog$default$6(), this.createLog$default$7(), this.createLog$default$8(), this.createLog$default$9(), this.createLog$default$10()));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numMessages).foreach((Function1 & Serializable & scala.Serializable)i -> LogLoaderTest.$anonfun$testRebuildTimeIndexForOldMessages$1(this, log, BoxesRunTime.unboxToInt((Object)i)));
        Iterable timeIndexFiles = (Iterable)((UnifiedLog)log.elem).logSegments().map((Function1 & Serializable & scala.Serializable)x$18 -> x$18.lazyTimeIndex().file(), Iterable$.MODULE$.canBuildFrom());
        ((UnifiedLog)log.elem).close();
        timeIndexFiles.foreach((Function1 & Serializable & scala.Serializable)file -> {
            LogLoaderTest.$anonfun$testRebuildTimeIndexForOldMessages$3(file);
            return BoxedUnit.UNIT;
        });
        File x$11 = this.logDir();
        long x$13 = numMessages + 1;
        boolean x$14 = false;
        BrokerTopicStats x$15 = this.createLog$default$3();
        long x$16 = this.createLog$default$4();
        Scheduler x$17 = this.createLog$default$6();
        Time x$182 = this.createLog$default$7();
        int x$19 = this.createLog$default$8();
        int x$20 = this.createLog$default$9();
        log.elem = this.createLog(x$11, logConfig, x$15, x$16, x$13, x$17, x$182, x$19, x$20, x$14);
        ((IterableLike)((UnifiedLog)log.elem).logSegments().init()).foreach((Function1 & Serializable & scala.Serializable)segment -> {
            LogLoaderTest.$anonfun$testRebuildTimeIndexForOldMessages$4(segment);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testCorruptIndexRebuild() {
        int numMessages = 200;
        int x$1 = 200;
        int x$2 = 1;
        long x$3 = LogTestUtils$.MODULE$.createLogConfig$default$1();
        long x$4 = LogTestUtils$.MODULE$.createLogConfig$default$3();
        long x$5 = LogTestUtils$.MODULE$.createLogConfig$default$4();
        long x$6 = LogTestUtils$.MODULE$.createLogConfig$default$5();
        String x$7 = LogTestUtils$.MODULE$.createLogConfig$default$6();
        int x$8 = LogTestUtils$.MODULE$.createLogConfig$default$7();
        int x$9 = LogTestUtils$.MODULE$.createLogConfig$default$9();
        long x$10 = LogTestUtils$.MODULE$.createLogConfig$default$10();
        LogConfig logConfig = LogTestUtils$.MODULE$.createLogConfig(x$3, x$1, x$4, x$5, x$6, x$7, x$8, x$2, x$9, x$10);
        ObjectRef log = ObjectRef.create((Object)this.createLog(this.logDir(), logConfig, this.createLog$default$3(), this.createLog$default$4(), this.createLog$default$5(), this.createLog$default$6(), this.createLog$default$7(), this.createLog$default$8(), this.createLog$default$9(), this.createLog$default$10()));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numMessages).foreach((Function1 & Serializable & scala.Serializable)i -> LogLoaderTest.$anonfun$testCorruptIndexRebuild$1(this, log, BoxesRunTime.unboxToInt((Object)i)));
        Iterable indexFiles = (Iterable)((UnifiedLog)log.elem).logSegments().map((Function1 & Serializable & scala.Serializable)x$19 -> x$19.lazyOffsetIndex().file(), Iterable$.MODULE$.canBuildFrom());
        Iterable timeIndexFiles = (Iterable)((UnifiedLog)log.elem).logSegments().map((Function1 & Serializable & scala.Serializable)x$20 -> x$20.lazyTimeIndex().file(), Iterable$.MODULE$.canBuildFrom());
        ((UnifiedLog)log.elem).close();
        indexFiles.foreach((Function1 & Serializable & scala.Serializable)file -> {
            LogLoaderTest.$anonfun$testCorruptIndexRebuild$4(file);
            return BoxedUnit.UNIT;
        });
        timeIndexFiles.foreach((Function1 & Serializable & scala.Serializable)file -> {
            LogLoaderTest.$anonfun$testCorruptIndexRebuild$5(file);
            return BoxedUnit.UNIT;
        });
        File x$21 = this.logDir();
        boolean x$23 = false;
        BrokerTopicStats x$24 = this.createLog$default$3();
        long x$25 = this.createLog$default$4();
        long x$26 = this.createLog$default$5();
        Scheduler x$27 = this.createLog$default$6();
        Time x$28 = this.createLog$default$7();
        int x$29 = this.createLog$default$8();
        int x$30 = this.createLog$default$9();
        log.elem = this.createLog(x$21, logConfig, x$24, x$25, x$26, x$27, x$28, x$29, x$30, x$23);
        Assertions.assertEquals((long)numMessages, (long)((UnifiedLog)log.elem).logEndOffset(), (String)new StringOps(Predef$.MODULE$.augmentString("Should have %d messages when log is reopened")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)numMessages)})));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numMessages).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            Assertions.assertEquals((long)i, (long)((RecordBatch)LogTestUtils$.MODULE$.readLog((UnifiedLog)log$5.elem, i, 100, LogTestUtils$.MODULE$.readLog$default$4(), LogTestUtils$.MODULE$.readLog$default$5()).records().batches().iterator().next()).lastOffset());
            if (i == 0) {
                Assertions.assertEquals((long)((LogSegment)((UnifiedLog)log$5.elem).logSegments().head()).baseOffset(), (long)((FileRecords.TimestampAndOffset)((UnifiedLog)log$5.elem).fetchOffsetByTimestamp((long)($this.mockTime().milliseconds() + (long)(i * 10))).get()).offset);
                return;
            }
            Assertions.assertEquals((long)i, (long)((FileRecords.TimestampAndOffset)((UnifiedLog)log$5.elem).fetchOffsetByTimestamp((long)($this.mockTime().milliseconds() + (long)(i * 10))).get()).offset);
        });
        ((UnifiedLog)log.elem).close();
    }

    @Test
    public void testBogusIndexSegmentsAreRemoved() {
        File bogusIndex1 = UnifiedLog$.MODULE$.offsetIndexFile(this.logDir(), 0L, UnifiedLog$.MODULE$.offsetIndexFile$default$3());
        File bogusTimeIndex1 = UnifiedLog$.MODULE$.timeIndexFile(this.logDir(), 0L, UnifiedLog$.MODULE$.timeIndexFile$default$3());
        File bogusIndex2 = UnifiedLog$.MODULE$.offsetIndexFile(this.logDir(), 5L, UnifiedLog$.MODULE$.offsetIndexFile$default$3());
        File bogusTimeIndex2 = UnifiedLog$.MODULE$.timeIndexFile(this.logDir(), 5L, UnifiedLog$.MODULE$.timeIndexFile$default$3());
        bogusIndex2.createNewFile();
        bogusTimeIndex2.createNewFile();
        int x$1 = this.createRecords$1().sizeInBytes() * 5;
        int x$2 = 1000;
        int x$3 = 1;
        long x$4 = LogTestUtils$.MODULE$.createLogConfig$default$1();
        long x$5 = LogTestUtils$.MODULE$.createLogConfig$default$3();
        long x$6 = LogTestUtils$.MODULE$.createLogConfig$default$4();
        long x$7 = LogTestUtils$.MODULE$.createLogConfig$default$5();
        String x$8 = LogTestUtils$.MODULE$.createLogConfig$default$6();
        int x$9 = LogTestUtils$.MODULE$.createLogConfig$default$7();
        long x$10 = LogTestUtils$.MODULE$.createLogConfig$default$10();
        LogConfig logConfig = LogTestUtils$.MODULE$.createLogConfig(x$4, x$1, x$5, x$6, x$7, x$8, x$9, x$3, x$2, x$10);
        UnifiedLog log = this.createLog(this.logDir(), logConfig, this.createLog$default$3(), this.createLog$default$4(), this.createLog$default$5(), this.createLog$default$6(), this.createLog$default$7(), this.createLog$default$8(), this.createLog$default$9(), this.createLog$default$10());
        ((LogSegment)log.logSegments().toSeq().head()).offsetIndex();
        ((LogSegment)log.logSegments().toSeq().head()).timeIndex();
        Assertions.assertTrue((bogusIndex1.length() > 0L ? 1 : 0) != 0, (String)"The first index file should have been replaced with a larger file");
        Assertions.assertTrue((bogusTimeIndex1.length() > 0L ? 1 : 0) != 0, (String)"The first time index file should have been replaced with a larger file");
        Assertions.assertFalse((boolean)bogusIndex2.exists(), (String)"The second index file should have been deleted.");
        Assertions.assertFalse((boolean)bogusTimeIndex2.exists(), (String)"The second time index file should have been deleted.");
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 10).foreach((Function1 & Serializable & scala.Serializable)_ -> log.appendAsLeader(this.createRecords$1(), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5()));
        log.delete();
    }

    @Test
    public void testReopenThenTruncate() {
        int x$1 = this.createRecords$2().sizeInBytes() * 5;
        int x$2 = 1000;
        int x$3 = 10000;
        long x$4 = LogTestUtils$.MODULE$.createLogConfig$default$1();
        long x$5 = LogTestUtils$.MODULE$.createLogConfig$default$3();
        long x$6 = LogTestUtils$.MODULE$.createLogConfig$default$4();
        long x$7 = LogTestUtils$.MODULE$.createLogConfig$default$5();
        String x$8 = LogTestUtils$.MODULE$.createLogConfig$default$6();
        int x$9 = LogTestUtils$.MODULE$.createLogConfig$default$7();
        long x$10 = LogTestUtils$.MODULE$.createLogConfig$default$10();
        LogConfig logConfig = LogTestUtils$.MODULE$.createLogConfig(x$4, x$1, x$5, x$6, x$7, x$8, x$9, x$3, x$2, x$10);
        ObjectRef log = ObjectRef.create((Object)this.createLog(this.logDir(), logConfig, this.createLog$default$3(), this.createLog$default$4(), this.createLog$default$5(), this.createLog$default$6(), this.createLog$default$7(), this.createLog$default$8(), this.createLog$default$9(), this.createLog$default$10()));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 100).foreach((Function1 & Serializable & scala.Serializable)_ -> LogLoaderTest.$anonfun$testReopenThenTruncate$1(this, log, BoxesRunTime.unboxToInt((Object)_)));
        ((UnifiedLog)log.elem).close();
        File x$16 = this.logDir();
        boolean x$18 = false;
        BrokerTopicStats x$19 = this.createLog$default$3();
        long x$20 = this.createLog$default$4();
        long x$21 = this.createLog$default$5();
        Scheduler x$22 = this.createLog$default$6();
        Time x$23 = this.createLog$default$7();
        int x$24 = this.createLog$default$8();
        int x$25 = this.createLog$default$9();
        log.elem = this.createLog(x$16, logConfig, x$19, x$20, x$21, x$22, x$23, x$24, x$25, x$18);
        ((UnifiedLog)log.elem).truncateTo(3L);
        Assertions.assertEquals((int)1, (int)((UnifiedLog)log.elem).numberOfSegments(), (String)"All but one segment should be deleted.");
        Assertions.assertEquals((long)3L, (long)((UnifiedLog)log.elem).logEndOffset(), (String)"Log end offset should be 3.");
    }

    @Test
    public void testOpenDeletesObsoleteFiles() {
        int x$1 = this.createRecords$3().sizeInBytes() * 5;
        int x$2 = 1000;
        long x$3 = 999L;
        long x$4 = LogTestUtils$.MODULE$.createLogConfig$default$1();
        long x$5 = LogTestUtils$.MODULE$.createLogConfig$default$4();
        long x$6 = LogTestUtils$.MODULE$.createLogConfig$default$5();
        String x$7 = LogTestUtils$.MODULE$.createLogConfig$default$6();
        int x$8 = LogTestUtils$.MODULE$.createLogConfig$default$7();
        int x$9 = LogTestUtils$.MODULE$.createLogConfig$default$8();
        long x$10 = LogTestUtils$.MODULE$.createLogConfig$default$10();
        LogConfig logConfig = LogTestUtils$.MODULE$.createLogConfig(x$4, x$1, x$3, x$5, x$6, x$7, x$8, x$9, x$2, x$10);
        ObjectRef log = ObjectRef.create((Object)this.createLog(this.logDir(), logConfig, this.createLog$default$3(), this.createLog$default$4(), this.createLog$default$5(), this.createLog$default$6(), this.createLog$default$7(), this.createLog$default$8(), this.createLog$default$9(), this.createLog$default$10()));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 100).foreach((Function1 & Serializable & scala.Serializable)_ -> LogLoaderTest.$anonfun$testOpenDeletesObsoleteFiles$1(this, log, BoxesRunTime.unboxToInt((Object)_)));
        ((UnifiedLog)log.elem).updateHighWatermark(((UnifiedLog)log.elem).logEndOffset());
        ((UnifiedLog)log.elem).deleteOldSegments();
        ((UnifiedLog)log.elem).close();
        File x$16 = this.logDir();
        boolean x$18 = false;
        BrokerTopicStats x$19 = this.createLog$default$3();
        long x$20 = this.createLog$default$4();
        long x$21 = this.createLog$default$5();
        Scheduler x$22 = this.createLog$default$6();
        Time x$23 = this.createLog$default$7();
        int x$24 = this.createLog$default$8();
        int x$25 = this.createLog$default$9();
        log.elem = this.createLog(x$16, logConfig, x$19, x$20, x$21, x$22, x$23, x$24, x$25, x$18);
        Assertions.assertEquals((int)1, (int)((UnifiedLog)log.elem).numberOfSegments(), (String)"The deleted segments should be gone.");
    }

    @Test
    public void testCorruptLog() {
        int x$1 = 1000;
        int x$2 = 1;
        int x$3 = 65536;
        long x$4 = LogTestUtils$.MODULE$.createLogConfig$default$1();
        long x$5 = LogTestUtils$.MODULE$.createLogConfig$default$3();
        long x$6 = LogTestUtils$.MODULE$.createLogConfig$default$4();
        long x$7 = LogTestUtils$.MODULE$.createLogConfig$default$5();
        String x$8 = LogTestUtils$.MODULE$.createLogConfig$default$6();
        int x$9 = LogTestUtils$.MODULE$.createLogConfig$default$9();
        long x$10 = LogTestUtils$.MODULE$.createLogConfig$default$10();
        LogConfig logConfig = LogTestUtils$.MODULE$.createLogConfig(x$4, x$1, x$5, x$6, x$7, x$8, x$3, x$2, x$9, x$10);
        long recoveryPoint = 50L;
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 10).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_2 -> {
            this.logDir().mkdirs();
            ObjectRef log = ObjectRef.create((Object)this.createLog(this.logDir(), logConfig, this.createLog$default$3(), this.createLog$default$4(), this.createLog$default$5(), this.createLog$default$6(), this.createLog$default$7(), this.createLog$default$8(), this.createLog$default$9(), this.createLog$default$10()));
            int numMessages = 50 + TestUtils$.MODULE$.random().nextInt(50);
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numMessages).foreach((Function1 & Serializable & scala.Serializable)_ -> LogLoaderTest.$anonfun$testCorruptLog$2(this, log, BoxesRunTime.unboxToInt((Object)_)));
            List records = ((TraversableOnce)((UnifiedLog)log.elem).logSegments().flatMap((Function1 & Serializable & scala.Serializable)x$21 -> ((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(x$21.log().records()).asScala()).toList(), Iterable$.MODULE$.canBuildFrom())).toList();
            ((UnifiedLog)log.elem).close();
            TestUtils$.MODULE$.appendNonsenseToFile(((UnifiedLog)log.elem).activeSegment().lazyOffsetIndex().file(), TestUtils$.MODULE$.random().nextInt(1024) + 1);
            TestUtils$.MODULE$.appendNonsenseToFile(((UnifiedLog)log.elem).activeSegment().log().file(), TestUtils$.MODULE$.random().nextInt(1024) + 1);
            File x$16 = this.logDir();
            BrokerTopicStats x$18 = this.brokerTopicStats();
            long x$19 = 0L;
            boolean x$212 = false;
            Scheduler x$222 = this.createLog$default$6();
            Time x$23 = this.createLog$default$7();
            int x$24 = this.createLog$default$8();
            int x$25 = this.createLog$default$9();
            log.elem = this.createLog(x$16, logConfig, x$18, x$19, recoveryPoint, x$222, x$23, x$24, x$25, x$212);
            Assertions.assertEquals((long)numMessages, (long)((UnifiedLog)log.elem).logEndOffset());
            List recovered = ((TraversableOnce)((UnifiedLog)log.elem).logSegments().flatMap((Function1 & Serializable & scala.Serializable)x$22 -> ((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(x$22.log().records()).asScala()).toList(), Iterable$.MODULE$.canBuildFrom())).toList();
            Assertions.assertEquals((int)records.size(), (int)recovered.size());
            records.indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                Record expected = (Record)records.apply(i);
                Record actual = (Record)recovered.apply(i);
                Assertions.assertEquals((Object)expected.key(), (Object)actual.key(), (String)"Keys not equal");
                Assertions.assertEquals((Object)expected.value(), (Object)actual.value(), (String)"Values not equal");
                Assertions.assertEquals((long)expected.timestamp(), (long)actual.timestamp(), (String)"Timestamps not equal");
            });
            Utils.delete((File)this.logDir());
        });
    }

    @Test
    public void testOverCompactedLogRecovery() {
        int x$1 = 1000;
        int x$2 = 1;
        int x$3 = 65536;
        long x$4 = LogTestUtils$.MODULE$.createLogConfig$default$1();
        long x$5 = LogTestUtils$.MODULE$.createLogConfig$default$3();
        long x$6 = LogTestUtils$.MODULE$.createLogConfig$default$4();
        long x$7 = LogTestUtils$.MODULE$.createLogConfig$default$5();
        String x$8 = LogTestUtils$.MODULE$.createLogConfig$default$6();
        int x$9 = LogTestUtils$.MODULE$.createLogConfig$default$9();
        long x$10 = LogTestUtils$.MODULE$.createLogConfig$default$10();
        LogConfig logConfig = LogTestUtils$.MODULE$.createLogConfig(x$4, x$1, x$5, x$6, x$7, x$8, x$3, x$2, x$9, x$10);
        UnifiedLog log = this.createLog(this.logDir(), logConfig, this.createLog$default$3(), this.createLog$default$4(), this.createLog$default$5(), this.createLog$default$6(), this.createLog$default$7(), this.createLog$default$8(), this.createLog$default$9(), this.createLog$default$10());
        MemoryRecords set1 = MemoryRecords.withRecords((long)0L, (CompressionType)CompressionType.NONE, (Integer)Predef$.MODULE$.int2Integer(0), (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("v1".getBytes(), "k1".getBytes())});
        MemoryRecords set2 = MemoryRecords.withRecords((long)((long)Integer.MAX_VALUE + 2L), (CompressionType)CompressionType.NONE, (Integer)Predef$.MODULE$.int2Integer(0), (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("v3".getBytes(), "k3".getBytes())});
        MemoryRecords set3 = MemoryRecords.withRecords((long)((long)Integer.MAX_VALUE + 3L), (CompressionType)CompressionType.NONE, (Integer)Predef$.MODULE$.int2Integer(0), (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("v4".getBytes(), "k4".getBytes())});
        MemoryRecords set4 = MemoryRecords.withRecords((long)((long)Integer.MAX_VALUE + 4L), (CompressionType)CompressionType.NONE, (Integer)Predef$.MODULE$.int2Integer(0), (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("v5".getBytes(), "k5".getBytes())});
        log.appendAsFollower(set1);
        Assertions.assertEquals((long)0L, (long)log.activeSegment().baseOffset());
        log.appendAsFollower(set2);
        Assertions.assertEquals((long)((long)Integer.MAX_VALUE + 2L), (long)log.activeSegment().baseOffset());
        Assertions.assertTrue((boolean)UnifiedLog$.MODULE$.producerSnapshotFile(this.logDir(), (long)Integer.MAX_VALUE + 2L).exists());
        log.appendAsFollower(set3);
        Assertions.assertEquals((long)((long)Integer.MAX_VALUE + 2L), (long)log.activeSegment().baseOffset());
        log.appendAsFollower(set4);
        Assertions.assertEquals((long)((long)Integer.MAX_VALUE + 2L), (long)log.activeSegment().baseOffset());
        log.close();
        File[] indexFiles = (File[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.logDir().listFiles())).filter((Function1 & Serializable & scala.Serializable)file -> BoxesRunTime.boxToBoolean((boolean)LogLoaderTest.$anonfun$testOverCompactedLogRecovery$1(file)));
        Assertions.assertEquals((int)2, (int)indexFiles.length);
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])indexFiles)).foreach((Function1 & Serializable & scala.Serializable)file -> {
            LogLoaderTest.$anonfun$testOverCompactedLogRecovery$2(file);
            return BoxedUnit.UNIT;
        });
        Utils.delete((File)this.logDir());
    }

    @Test
    public void testLeaderEpochCacheClearedAfterStaticMessageFormatDowngrade() {
        int x$1 = 1000;
        int x$2 = 1;
        int x$3 = 65536;
        long x$4 = LogTestUtils$.MODULE$.createLogConfig$default$1();
        long x$5 = LogTestUtils$.MODULE$.createLogConfig$default$3();
        long x$6 = LogTestUtils$.MODULE$.createLogConfig$default$4();
        long x$7 = LogTestUtils$.MODULE$.createLogConfig$default$5();
        String x$8 = LogTestUtils$.MODULE$.createLogConfig$default$6();
        int x$9 = LogTestUtils$.MODULE$.createLogConfig$default$9();
        long x$10 = LogTestUtils$.MODULE$.createLogConfig$default$10();
        LogConfig logConfig = LogTestUtils$.MODULE$.createLogConfig(x$4, x$1, x$5, x$6, x$7, x$8, x$3, x$2, x$9, x$10);
        UnifiedLog log = this.createLog(this.logDir(), logConfig, this.createLog$default$3(), this.createLog$default$4(), this.createLog$default$5(), this.createLog$default$6(), this.createLog$default$7(), this.createLog$default$8(), this.createLog$default$9(), this.createLog$default$10());
        log.appendAsLeader(TestUtils$.MODULE$.records((Iterable<SimpleRecord>)new .colon.colon((Object)new SimpleRecord("foo".getBytes()), (List)Nil$.MODULE$), TestUtils$.MODULE$.records$default$2(), TestUtils$.MODULE$.records$default$3(), TestUtils$.MODULE$.records$default$4(), TestUtils$.MODULE$.records$default$5(), TestUtils$.MODULE$.records$default$6(), TestUtils$.MODULE$.records$default$7(), TestUtils$.MODULE$.records$default$8()), 5, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)5)), (Object)log.latestEpoch());
        log.close();
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), "1000");
        logProps.put(LogConfig$.MODULE$.IndexIntervalBytesProp(), "1");
        logProps.put(LogConfig$.MODULE$.MaxMessageBytesProp(), "65536");
        logProps.put(LogConfig$.MODULE$.MessageFormatVersionProp(), "0.10.2");
        LogConfig downgradedLogConfig = new LogConfig((java.util.Map)logProps, LogConfig$.MODULE$.apply$default$2());
        File x$11 = this.logDir();
        boolean x$13 = false;
        BrokerTopicStats x$14 = this.createLog$default$3();
        long x$15 = this.createLog$default$4();
        long x$16 = this.createLog$default$5();
        Scheduler x$17 = this.createLog$default$6();
        Time x$18 = this.createLog$default$7();
        int x$19 = this.createLog$default$8();
        int x$20 = this.createLog$default$9();
        UnifiedLog reopened = this.createLog(x$11, downgradedLogConfig, x$14, x$15, x$16, x$17, x$18, x$19, x$20, x$13);
        LogTestUtils$.MODULE$.assertLeaderEpochCacheEmpty(reopened);
        reopened.appendAsLeader(TestUtils$.MODULE$.records((Iterable<SimpleRecord>)new .colon.colon((Object)new SimpleRecord("bar".getBytes()), (List)Nil$.MODULE$), RecordVersion.V1.value, TestUtils$.MODULE$.records$default$3(), TestUtils$.MODULE$.records$default$4(), TestUtils$.MODULE$.records$default$5(), TestUtils$.MODULE$.records$default$6(), TestUtils$.MODULE$.records$default$7(), TestUtils$.MODULE$.records$default$8()), 5, reopened.appendAsLeader$default$3(), reopened.appendAsLeader$default$4(), reopened.appendAsLeader$default$5());
        LogTestUtils$.MODULE$.assertLeaderEpochCacheEmpty(reopened);
    }

    @Test
    public void testOverCompactedLogRecoveryMultiRecord() {
        int x$1 = 1000;
        int x$2 = 1;
        int x$3 = 65536;
        long x$4 = LogTestUtils$.MODULE$.createLogConfig$default$1();
        long x$5 = LogTestUtils$.MODULE$.createLogConfig$default$3();
        long x$6 = LogTestUtils$.MODULE$.createLogConfig$default$4();
        long x$7 = LogTestUtils$.MODULE$.createLogConfig$default$5();
        String x$8 = LogTestUtils$.MODULE$.createLogConfig$default$6();
        int x$9 = LogTestUtils$.MODULE$.createLogConfig$default$9();
        long x$10 = LogTestUtils$.MODULE$.createLogConfig$default$10();
        LogConfig logConfig = LogTestUtils$.MODULE$.createLogConfig(x$4, x$1, x$5, x$6, x$7, x$8, x$3, x$2, x$9, x$10);
        UnifiedLog log = this.createLog(this.logDir(), logConfig, this.createLog$default$3(), this.createLog$default$4(), this.createLog$default$5(), this.createLog$default$6(), this.createLog$default$7(), this.createLog$default$8(), this.createLog$default$9(), this.createLog$default$10());
        MemoryRecords set1 = MemoryRecords.withRecords((long)0L, (CompressionType)CompressionType.NONE, (Integer)Predef$.MODULE$.int2Integer(0), (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("v1".getBytes(), "k1".getBytes())});
        MemoryRecords set2 = MemoryRecords.withRecords((long)((long)Integer.MAX_VALUE + 2L), (CompressionType)CompressionType.GZIP, (Integer)Predef$.MODULE$.int2Integer(0), (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("v3".getBytes(), "k3".getBytes()), new SimpleRecord("v4".getBytes(), "k4".getBytes())});
        MemoryRecords set3 = MemoryRecords.withRecords((long)((long)Integer.MAX_VALUE + 4L), (CompressionType)CompressionType.GZIP, (Integer)Predef$.MODULE$.int2Integer(0), (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("v5".getBytes(), "k5".getBytes()), new SimpleRecord("v6".getBytes(), "k6".getBytes())});
        MemoryRecords set4 = MemoryRecords.withRecords((long)((long)Integer.MAX_VALUE + 6L), (CompressionType)CompressionType.GZIP, (Integer)Predef$.MODULE$.int2Integer(0), (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("v7".getBytes(), "k7".getBytes()), new SimpleRecord("v8".getBytes(), "k8".getBytes())});
        log.appendAsFollower(set1);
        Assertions.assertEquals((long)0L, (long)log.activeSegment().baseOffset());
        log.appendAsFollower(set2);
        Assertions.assertEquals((long)((long)Integer.MAX_VALUE + 2L), (long)log.activeSegment().baseOffset());
        Assertions.assertTrue((boolean)UnifiedLog$.MODULE$.producerSnapshotFile(this.logDir(), (long)Integer.MAX_VALUE + 2L).exists());
        log.appendAsFollower(set3);
        Assertions.assertEquals((long)((long)Integer.MAX_VALUE + 2L), (long)log.activeSegment().baseOffset());
        log.appendAsFollower(set4);
        Assertions.assertEquals((long)((long)Integer.MAX_VALUE + 2L), (long)log.activeSegment().baseOffset());
        log.close();
        File[] indexFiles = (File[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.logDir().listFiles())).filter((Function1 & Serializable & scala.Serializable)file -> BoxesRunTime.boxToBoolean((boolean)LogLoaderTest.$anonfun$testOverCompactedLogRecoveryMultiRecord$1(file)));
        Assertions.assertEquals((int)2, (int)indexFiles.length);
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])indexFiles)).foreach((Function1 & Serializable & scala.Serializable)file -> {
            LogLoaderTest.$anonfun$testOverCompactedLogRecoveryMultiRecord$2(file);
            return BoxedUnit.UNIT;
        });
        Utils.delete((File)this.logDir());
    }

    @Test
    public void testOverCompactedLogRecoveryMultiRecordV1() {
        int x$1 = 1000;
        int x$2 = 1;
        int x$3 = 65536;
        long x$4 = LogTestUtils$.MODULE$.createLogConfig$default$1();
        long x$5 = LogTestUtils$.MODULE$.createLogConfig$default$3();
        long x$6 = LogTestUtils$.MODULE$.createLogConfig$default$4();
        long x$7 = LogTestUtils$.MODULE$.createLogConfig$default$5();
        String x$8 = LogTestUtils$.MODULE$.createLogConfig$default$6();
        int x$9 = LogTestUtils$.MODULE$.createLogConfig$default$9();
        long x$10 = LogTestUtils$.MODULE$.createLogConfig$default$10();
        LogConfig logConfig = LogTestUtils$.MODULE$.createLogConfig(x$4, x$1, x$5, x$6, x$7, x$8, x$3, x$2, x$9, x$10);
        UnifiedLog log = this.createLog(this.logDir(), logConfig, this.createLog$default$3(), this.createLog$default$4(), this.createLog$default$5(), this.createLog$default$6(), this.createLog$default$7(), this.createLog$default$8(), this.createLog$default$9(), this.createLog$default$10());
        MemoryRecords set1 = MemoryRecords.withRecords((byte)1, (long)0L, (CompressionType)CompressionType.NONE, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("v1".getBytes(), "k1".getBytes())});
        MemoryRecords set2 = MemoryRecords.withRecords((byte)1, (long)((long)Integer.MAX_VALUE + 2L), (CompressionType)CompressionType.GZIP, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("v3".getBytes(), "k3".getBytes()), new SimpleRecord("v4".getBytes(), "k4".getBytes())});
        MemoryRecords set3 = MemoryRecords.withRecords((byte)1, (long)((long)Integer.MAX_VALUE + 4L), (CompressionType)CompressionType.GZIP, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("v5".getBytes(), "k5".getBytes()), new SimpleRecord("v6".getBytes(), "k6".getBytes())});
        MemoryRecords set4 = MemoryRecords.withRecords((byte)1, (long)((long)Integer.MAX_VALUE + 6L), (CompressionType)CompressionType.GZIP, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("v7".getBytes(), "k7".getBytes()), new SimpleRecord("v8".getBytes(), "k8".getBytes())});
        log.appendAsFollower(set1);
        Assertions.assertEquals((long)0L, (long)log.activeSegment().baseOffset());
        log.appendAsFollower(set2);
        Assertions.assertEquals((long)3L, (long)log.activeSegment().baseOffset());
        Assertions.assertTrue((boolean)UnifiedLog$.MODULE$.producerSnapshotFile(this.logDir(), 3L).exists());
        log.appendAsFollower(set3);
        Assertions.assertEquals((long)((long)Integer.MAX_VALUE + 4L), (long)log.activeSegment().baseOffset());
        Assertions.assertTrue((boolean)UnifiedLog$.MODULE$.producerSnapshotFile(this.logDir(), (long)Integer.MAX_VALUE + 4L).exists());
        log.appendAsFollower(set4);
        Assertions.assertEquals((long)((long)Integer.MAX_VALUE + 4L), (long)log.activeSegment().baseOffset());
        log.close();
        File[] indexFiles = (File[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.logDir().listFiles())).filter((Function1 & Serializable & scala.Serializable)file -> BoxesRunTime.boxToBoolean((boolean)LogLoaderTest.$anonfun$testOverCompactedLogRecoveryMultiRecordV1$1(file)));
        Assertions.assertEquals((int)3, (int)indexFiles.length);
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])indexFiles)).foreach((Function1 & Serializable & scala.Serializable)file -> {
            LogLoaderTest.$anonfun$testOverCompactedLogRecoveryMultiRecordV1$2(file);
            return BoxedUnit.UNIT;
        });
        Utils.delete((File)this.logDir());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testRecoveryOfSegmentWithOffsetOverflow() {
        void var18_13;
        int x$10;
        int x$9;
        String x$8;
        long x$7;
        long x$6;
        long x$5;
        int x$4;
        int x$1 = 1;
        long x$2 = 1000L;
        long x$3 = LogTestUtils$.MODULE$.createLogConfig$default$1();
        LogConfig logConfig = LogTestUtils$.MODULE$.createLogConfig(x$3, x$4 = LogTestUtils$.MODULE$.createLogConfig$default$2(), x$5 = LogTestUtils$.MODULE$.createLogConfig$default$3(), x$6 = LogTestUtils$.MODULE$.createLogConfig$default$4(), x$7 = LogTestUtils$.MODULE$.createLogConfig$default$5(), x$8 = LogTestUtils$.MODULE$.createLogConfig$default$6(), x$9 = LogTestUtils$.MODULE$.createLogConfig$default$7(), x$1, x$10 = LogTestUtils$.MODULE$.createLogConfig$default$9(), x$2);
        Tuple2<UnifiedLog, LogSegment> tuple2 = this.createLogWithOffsetOverflow(logConfig);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        UnifiedLog log = (UnifiedLog)tuple2._1();
        Iterable<Object> expectedKeys = LogTestUtils$.MODULE$.keysInLog((UnifiedLog)var18_13);
        UnifiedLog recoveredLog = this.recoverAndCheck(logConfig, expectedKeys);
        Assertions.assertEquals(expectedKeys, LogTestUtils$.MODULE$.keysInLog(recoveredLog));
        recoveredLog.logSegments().foreach(arg_0 -> LogLoaderTest.$anonfun$testRecoveryOfSegmentWithOffsetOverflow$1((UnifiedLog)var18_13, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testRecoveryAfterCrashDuringSplitPhase1() {
        void var19_14;
        void var18_13;
        int x$10;
        int x$9;
        String x$8;
        long x$7;
        long x$6;
        long x$5;
        int x$4;
        int x$1 = 1;
        long x$2 = 1000L;
        long x$3 = LogTestUtils$.MODULE$.createLogConfig$default$1();
        LogConfig logConfig = LogTestUtils$.MODULE$.createLogConfig(x$3, x$4 = LogTestUtils$.MODULE$.createLogConfig$default$2(), x$5 = LogTestUtils$.MODULE$.createLogConfig$default$3(), x$6 = LogTestUtils$.MODULE$.createLogConfig$default$4(), x$7 = LogTestUtils$.MODULE$.createLogConfig$default$5(), x$8 = LogTestUtils$.MODULE$.createLogConfig$default$6(), x$9 = LogTestUtils$.MODULE$.createLogConfig$default$7(), x$1, x$10 = LogTestUtils$.MODULE$.createLogConfig$default$9(), x$2);
        Tuple2<UnifiedLog, LogSegment> tuple2 = this.createLogWithOffsetOverflow(logConfig);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        UnifiedLog log = (UnifiedLog)tuple2._1();
        LogSegment segmentWithOverflow = (LogSegment)tuple2._2();
        void log2 = var18_13;
        void segmentWithOverflow2 = var19_14;
        Iterable<Object> expectedKeys = LogTestUtils$.MODULE$.keysInLog((UnifiedLog)log2);
        int numSegmentsInitial = log2.logSegments().size();
        log2.splitOverflowedSegment((LogSegment)segmentWithOverflow2).reverse().foreach((Function1 & Serializable & scala.Serializable)segment -> BoxesRunTime.boxToInteger((int)LogLoaderTest.$anonfun$testRecoveryAfterCrashDuringSplitPhase1$1(segment)));
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.logDir().listFiles())).withFilter((Function1 & Serializable & scala.Serializable)file -> BoxesRunTime.boxToBoolean((boolean)LogLoaderTest.$anonfun$testRecoveryAfterCrashDuringSplitPhase1$2(file))).foreach((Function1 & Serializable & scala.Serializable)file -> {
            LogLoaderTest.$anonfun$testRecoveryAfterCrashDuringSplitPhase1$3(file);
            return BoxedUnit.UNIT;
        });
        UnifiedLog recoveredLog = this.recoverAndCheck(logConfig, expectedKeys);
        Assertions.assertEquals(expectedKeys, LogTestUtils$.MODULE$.keysInLog(recoveredLog));
        Assertions.assertEquals((int)(numSegmentsInitial + 1), (int)recoveredLog.logSegments().size());
        recoveredLog.close();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testRecoveryAfterCrashDuringSplitPhase2() {
        void var19_14;
        void var18_13;
        int x$10;
        int x$9;
        String x$8;
        long x$7;
        long x$6;
        long x$5;
        int x$4;
        int x$1 = 1;
        long x$2 = 1000L;
        long x$3 = LogTestUtils$.MODULE$.createLogConfig$default$1();
        LogConfig logConfig = LogTestUtils$.MODULE$.createLogConfig(x$3, x$4 = LogTestUtils$.MODULE$.createLogConfig$default$2(), x$5 = LogTestUtils$.MODULE$.createLogConfig$default$3(), x$6 = LogTestUtils$.MODULE$.createLogConfig$default$4(), x$7 = LogTestUtils$.MODULE$.createLogConfig$default$5(), x$8 = LogTestUtils$.MODULE$.createLogConfig$default$6(), x$9 = LogTestUtils$.MODULE$.createLogConfig$default$7(), x$1, x$10 = LogTestUtils$.MODULE$.createLogConfig$default$9(), x$2);
        Tuple2<UnifiedLog, LogSegment> tuple2 = this.createLogWithOffsetOverflow(logConfig);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        UnifiedLog log = (UnifiedLog)tuple2._1();
        LogSegment segmentWithOverflow = (LogSegment)tuple2._2();
        void log2 = var18_13;
        void segmentWithOverflow2 = var19_14;
        Iterable<Object> expectedKeys = LogTestUtils$.MODULE$.keysInLog((UnifiedLog)log2);
        int numSegmentsInitial = log2.logSegments().size();
        List newSegments = log2.splitOverflowedSegment((LogSegment)segmentWithOverflow2);
        newSegments.reverse().foreach((Function1 & Serializable & scala.Serializable)segment -> BoxesRunTime.boxToInteger((int)LogLoaderTest.$anonfun$testRecoveryAfterCrashDuringSplitPhase2$1(newSegments, segment)));
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.logDir().listFiles())).withFilter((Function1 & Serializable & scala.Serializable)file -> BoxesRunTime.boxToBoolean((boolean)LogLoaderTest.$anonfun$testRecoveryAfterCrashDuringSplitPhase2$2(file))).foreach((Function1 & Serializable & scala.Serializable)file -> {
            LogLoaderTest.$anonfun$testRecoveryAfterCrashDuringSplitPhase2$3(file);
            return BoxedUnit.UNIT;
        });
        UnifiedLog recoveredLog = this.recoverAndCheck(logConfig, expectedKeys);
        Assertions.assertEquals(expectedKeys, LogTestUtils$.MODULE$.keysInLog(recoveredLog));
        Assertions.assertEquals((int)(numSegmentsInitial + 1), (int)recoveredLog.logSegments().size());
        recoveredLog.close();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testRecoveryAfterCrashDuringSplitPhase3() {
        void var19_14;
        void var18_13;
        int x$10;
        int x$9;
        String x$8;
        long x$7;
        long x$6;
        long x$5;
        int x$4;
        int x$1 = 1;
        long x$2 = 1000L;
        long x$3 = LogTestUtils$.MODULE$.createLogConfig$default$1();
        LogConfig logConfig = LogTestUtils$.MODULE$.createLogConfig(x$3, x$4 = LogTestUtils$.MODULE$.createLogConfig$default$2(), x$5 = LogTestUtils$.MODULE$.createLogConfig$default$3(), x$6 = LogTestUtils$.MODULE$.createLogConfig$default$4(), x$7 = LogTestUtils$.MODULE$.createLogConfig$default$5(), x$8 = LogTestUtils$.MODULE$.createLogConfig$default$6(), x$9 = LogTestUtils$.MODULE$.createLogConfig$default$7(), x$1, x$10 = LogTestUtils$.MODULE$.createLogConfig$default$9(), x$2);
        Tuple2<UnifiedLog, LogSegment> tuple2 = this.createLogWithOffsetOverflow(logConfig);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        UnifiedLog log = (UnifiedLog)tuple2._1();
        LogSegment segmentWithOverflow = (LogSegment)tuple2._2();
        void log2 = var18_13;
        void segmentWithOverflow2 = var19_14;
        Iterable<Object> expectedKeys = LogTestUtils$.MODULE$.keysInLog((UnifiedLog)log2);
        int numSegmentsInitial = log2.logSegments().size();
        log2.splitOverflowedSegment((LogSegment)segmentWithOverflow2).reverse().foreach((Function1 & Serializable & scala.Serializable)segment -> {
            segment.changeFileSuffixes("", UnifiedLog$.MODULE$.SwapFileSuffix());
            return BoxedUnit.UNIT;
        });
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.logDir().listFiles())).withFilter((Function1 & Serializable & scala.Serializable)file -> BoxesRunTime.boxToBoolean((boolean)LogLoaderTest.$anonfun$testRecoveryAfterCrashDuringSplitPhase3$2(file))).foreach((Function1 & Serializable & scala.Serializable)file -> {
            LogLoaderTest.$anonfun$testRecoveryAfterCrashDuringSplitPhase3$3(file);
            return BoxedUnit.UNIT;
        });
        segmentWithOverflow2.truncateTo(0L);
        UnifiedLog recoveredLog = this.recoverAndCheck(logConfig, expectedKeys);
        Assertions.assertEquals(expectedKeys, LogTestUtils$.MODULE$.keysInLog(recoveredLog));
        Assertions.assertEquals((int)(numSegmentsInitial + 1), (int)recoveredLog.logSegments().size());
        log2.close();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testRecoveryAfterCrashDuringSplitPhase4() {
        void var19_14;
        void var18_13;
        int x$10;
        int x$9;
        String x$8;
        long x$7;
        long x$6;
        long x$5;
        int x$4;
        int x$1 = 1;
        long x$2 = 1000L;
        long x$3 = LogTestUtils$.MODULE$.createLogConfig$default$1();
        LogConfig logConfig = LogTestUtils$.MODULE$.createLogConfig(x$3, x$4 = LogTestUtils$.MODULE$.createLogConfig$default$2(), x$5 = LogTestUtils$.MODULE$.createLogConfig$default$3(), x$6 = LogTestUtils$.MODULE$.createLogConfig$default$4(), x$7 = LogTestUtils$.MODULE$.createLogConfig$default$5(), x$8 = LogTestUtils$.MODULE$.createLogConfig$default$6(), x$9 = LogTestUtils$.MODULE$.createLogConfig$default$7(), x$1, x$10 = LogTestUtils$.MODULE$.createLogConfig$default$9(), x$2);
        Tuple2<UnifiedLog, LogSegment> tuple2 = this.createLogWithOffsetOverflow(logConfig);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        UnifiedLog log = (UnifiedLog)tuple2._1();
        LogSegment segmentWithOverflow = (LogSegment)tuple2._2();
        void log2 = var18_13;
        void segmentWithOverflow2 = var19_14;
        Iterable<Object> expectedKeys = LogTestUtils$.MODULE$.keysInLog((UnifiedLog)log2);
        int numSegmentsInitial = log2.logSegments().size();
        log2.splitOverflowedSegment((LogSegment)segmentWithOverflow2).reverse().foreach((Function1 & Serializable & scala.Serializable)x$27 -> {
            x$27.changeFileSuffixes("", UnifiedLog$.MODULE$.SwapFileSuffix());
            return BoxedUnit.UNIT;
        });
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.logDir().listFiles())).withFilter((Function1 & Serializable & scala.Serializable)file -> BoxesRunTime.boxToBoolean((boolean)LogLoaderTest.$anonfun$testRecoveryAfterCrashDuringSplitPhase4$2(file))).foreach((Function1 & Serializable & scala.Serializable)file -> {
            LogLoaderTest.$anonfun$testRecoveryAfterCrashDuringSplitPhase4$3(file);
            return BoxedUnit.UNIT;
        });
        segmentWithOverflow2.truncateTo(0L);
        UnifiedLog recoveredLog = this.recoverAndCheck(logConfig, expectedKeys);
        Assertions.assertEquals(expectedKeys, LogTestUtils$.MODULE$.keysInLog(recoveredLog));
        Assertions.assertEquals((int)(numSegmentsInitial + 1), (int)recoveredLog.logSegments().size());
        recoveredLog.close();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testRecoveryAfterCrashDuringSplitPhase5() {
        void var19_14;
        void var18_13;
        int x$10;
        int x$9;
        String x$8;
        long x$7;
        long x$6;
        long x$5;
        int x$4;
        int x$1 = 1;
        long x$2 = 1000L;
        long x$3 = LogTestUtils$.MODULE$.createLogConfig$default$1();
        LogConfig logConfig = LogTestUtils$.MODULE$.createLogConfig(x$3, x$4 = LogTestUtils$.MODULE$.createLogConfig$default$2(), x$5 = LogTestUtils$.MODULE$.createLogConfig$default$3(), x$6 = LogTestUtils$.MODULE$.createLogConfig$default$4(), x$7 = LogTestUtils$.MODULE$.createLogConfig$default$5(), x$8 = LogTestUtils$.MODULE$.createLogConfig$default$6(), x$9 = LogTestUtils$.MODULE$.createLogConfig$default$7(), x$1, x$10 = LogTestUtils$.MODULE$.createLogConfig$default$9(), x$2);
        Tuple2<UnifiedLog, LogSegment> tuple2 = this.createLogWithOffsetOverflow(logConfig);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        UnifiedLog log = (UnifiedLog)tuple2._1();
        LogSegment segmentWithOverflow = (LogSegment)tuple2._2();
        void log2 = var18_13;
        void segmentWithOverflow2 = var19_14;
        Iterable<Object> expectedKeys = LogTestUtils$.MODULE$.keysInLog((UnifiedLog)log2);
        int numSegmentsInitial = log2.logSegments().size();
        ((LogSegment)log2.splitOverflowedSegment((LogSegment)segmentWithOverflow2).last()).changeFileSuffixes("", UnifiedLog$.MODULE$.SwapFileSuffix());
        segmentWithOverflow2.truncateTo(0L);
        UnifiedLog recoveredLog = this.recoverAndCheck(logConfig, expectedKeys);
        Assertions.assertEquals(expectedKeys, LogTestUtils$.MODULE$.keysInLog(recoveredLog));
        Assertions.assertEquals((int)(numSegmentsInitial + 1), (int)recoveredLog.logSegments().size());
        recoveredLog.close();
    }

    @Test
    public void testCleanShutdownFile() {
        int x$1 = 1000;
        int x$2 = 1;
        int x$3 = 65536;
        long x$4 = LogTestUtils$.MODULE$.createLogConfig$default$1();
        long x$5 = LogTestUtils$.MODULE$.createLogConfig$default$3();
        long x$6 = LogTestUtils$.MODULE$.createLogConfig$default$4();
        long x$7 = LogTestUtils$.MODULE$.createLogConfig$default$5();
        String x$8 = LogTestUtils$.MODULE$.createLogConfig$default$6();
        int x$9 = LogTestUtils$.MODULE$.createLogConfig$default$9();
        long x$10 = LogTestUtils$.MODULE$.createLogConfig$default$10();
        LogConfig logConfig = LogTestUtils$.MODULE$.createLogConfig(x$4, x$1, x$5, x$6, x$7, x$8, x$3, x$2, x$9, x$10);
        ObjectRef log = ObjectRef.create((Object)this.createLog(this.logDir(), logConfig, this.createLog$default$3(), this.createLog$default$4(), this.createLog$default$5(), this.createLog$default$6(), this.createLog$default$7(), this.createLog$default$8(), this.createLog$default$9(), this.createLog$default$10()));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 100).foreach((Function1 & Serializable & scala.Serializable)_ -> LogLoaderTest.$anonfun$testCleanShutdownFile$1(this, log, BoxesRunTime.unboxToInt((Object)_)));
        ((UnifiedLog)log.elem).close();
        long recoveryPoint = ((UnifiedLog)log.elem).logEndOffset();
        log.elem = this.createLog(this.logDir(), logConfig, this.createLog$default$3(), this.createLog$default$4(), this.createLog$default$5(), this.createLog$default$6(), this.createLog$default$7(), this.createLog$default$8(), this.createLog$default$9(), this.createLog$default$10());
        Assertions.assertEquals((long)recoveryPoint, (long)((UnifiedLog)log.elem).logEndOffset());
    }

    @Test
    public void testLogRecoversForLeaderEpoch() {
        UnifiedLog log = this.createLog(this.logDir(), LogConfig$.MODULE$.apply(), this.createLog$default$3(), this.createLog$default$4(), this.createLog$default$5(), this.createLog$default$6(), this.createLog$default$7(), this.createLog$default$8(), this.createLog$default$9(), this.createLog$default$10());
        LeaderEpochFileCache leaderEpochCache = (LeaderEpochFileCache)log.leaderEpochCache().get();
        byte[] x$1 = "random".getBytes();
        int x$2 = 1;
        long x$3 = 0L;
        byte[] x$4 = this.singletonRecordsWithLeaderEpoch$default$2();
        CompressionType x$5 = this.singletonRecordsWithLeaderEpoch$default$5();
        long x$6 = this.singletonRecordsWithLeaderEpoch$default$6();
        byte x$7 = this.singletonRecordsWithLeaderEpoch$default$7();
        MemoryRecords firstBatch = this.singletonRecordsWithLeaderEpoch(x$1, x$4, x$2, x$3, x$5, x$6, x$7);
        log.appendAsFollower(firstBatch);
        byte[] x$8 = "random".getBytes();
        int x$9 = 2;
        long x$10 = 1L;
        byte[] x$11 = this.singletonRecordsWithLeaderEpoch$default$2();
        CompressionType x$12 = this.singletonRecordsWithLeaderEpoch$default$5();
        long x$13 = this.singletonRecordsWithLeaderEpoch$default$6();
        byte x$14 = this.singletonRecordsWithLeaderEpoch$default$7();
        MemoryRecords secondBatch = this.singletonRecordsWithLeaderEpoch(x$8, x$11, x$9, x$10, x$12, x$13, x$14);
        log.appendAsFollower(secondBatch);
        byte[] x$15 = "random".getBytes();
        int x$16 = 2;
        long x$17 = 2L;
        byte[] x$18 = this.singletonRecordsWithLeaderEpoch$default$2();
        CompressionType x$19 = this.singletonRecordsWithLeaderEpoch$default$5();
        long x$20 = this.singletonRecordsWithLeaderEpoch$default$6();
        byte x$21 = this.singletonRecordsWithLeaderEpoch$default$7();
        MemoryRecords thirdBatch = this.singletonRecordsWithLeaderEpoch(x$15, x$18, x$16, x$17, x$19, x$20, x$21);
        log.appendAsFollower(thirdBatch);
        byte[] x$22 = "random".getBytes();
        int x$23 = 3;
        long x$24 = 3L;
        byte[] x$25 = this.singletonRecordsWithLeaderEpoch$default$2();
        CompressionType x$26 = this.singletonRecordsWithLeaderEpoch$default$5();
        long x$27 = this.singletonRecordsWithLeaderEpoch$default$6();
        byte x$28 = this.singletonRecordsWithLeaderEpoch$default$7();
        MemoryRecords fourthBatch = this.singletonRecordsWithLeaderEpoch(x$22, x$25, x$23, x$24, x$26, x$27, x$28);
        log.appendAsFollower(fourthBatch);
        Assertions.assertEquals((Object)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EpochEntry[]{new EpochEntry(1, 0L), new EpochEntry(2, 1L), new EpochEntry(3, 3L)})), (Object)leaderEpochCache.epochEntries());
        leaderEpochCache.truncateFromEnd(2L);
        Assertions.assertNotEquals((Object)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EpochEntry[]{new EpochEntry(1, 0L), new EpochEntry(2, 1L), new EpochEntry(3, 3L)})), (Object)leaderEpochCache.epochEntries());
        log.close();
        File x$29 = this.logDir();
        LogConfig x$30 = LogConfig$.MODULE$.apply();
        boolean x$31 = false;
        BrokerTopicStats x$32 = this.createLog$default$3();
        long x$33 = this.createLog$default$4();
        long x$34 = this.createLog$default$5();
        Scheduler x$35 = this.createLog$default$6();
        Time x$36 = this.createLog$default$7();
        int x$37 = this.createLog$default$8();
        int x$38 = this.createLog$default$9();
        UnifiedLog recoveredLog = this.createLog(x$29, x$30, x$32, x$33, x$34, x$35, x$36, x$37, x$38, x$31);
        LeaderEpochFileCache recoveredLeaderEpochCache = (LeaderEpochFileCache)recoveredLog.leaderEpochCache().get();
        Assertions.assertEquals((Object)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EpochEntry[]{new EpochEntry(1, 0L), new EpochEntry(2, 1L), new EpochEntry(3, 3L)})), (Object)recoveredLeaderEpochCache.epochEntries());
        recoveredLog.close();
    }

    @Test
    public void testFullTransactionIndexRecovery() {
        int x$1 = 640;
        long x$2 = LogTestUtils$.MODULE$.createLogConfig$default$1();
        long x$3 = LogTestUtils$.MODULE$.createLogConfig$default$3();
        long x$4 = LogTestUtils$.MODULE$.createLogConfig$default$4();
        long x$5 = LogTestUtils$.MODULE$.createLogConfig$default$5();
        String x$6 = LogTestUtils$.MODULE$.createLogConfig$default$6();
        int x$7 = LogTestUtils$.MODULE$.createLogConfig$default$7();
        int x$8 = LogTestUtils$.MODULE$.createLogConfig$default$8();
        int x$9 = LogTestUtils$.MODULE$.createLogConfig$default$9();
        long x$10 = LogTestUtils$.MODULE$.createLogConfig$default$10();
        LogConfig logConfig = LogTestUtils$.MODULE$.createLogConfig(x$2, x$1, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10);
        UnifiedLog log = this.createLog(this.logDir(), logConfig, this.createLog$default$3(), this.createLog$default$4(), this.createLog$default$5(), this.createLog$default$6(), this.createLog$default$7(), this.createLog$default$8(), this.createLog$default$9(), this.createLog$default$10());
        short epoch = (short)0;
        long pid1 = 1L;
        long pid2 = 2L;
        long pid3 = 3L;
        long pid4 = 4L;
        Function1<Object, BoxedUnit> appendPid1 = LogTestUtils$.MODULE$.appendTransactionalAsLeader(log, pid1, epoch, (Time)this.mockTime());
        Function1<Object, BoxedUnit> appendPid2 = LogTestUtils$.MODULE$.appendTransactionalAsLeader(log, pid2, epoch, (Time)this.mockTime());
        Function1<Object, BoxedUnit> appendPid3 = LogTestUtils$.MODULE$.appendTransactionalAsLeader(log, pid3, epoch, (Time)this.mockTime());
        Function1<Object, BoxedUnit> appendPid4 = LogTestUtils$.MODULE$.appendTransactionalAsLeader(log, pid4, epoch, (Time)this.mockTime());
        appendPid1.apply$mcVI$sp(5);
        LogTestUtils$.MODULE$.appendNonTransactionalAsLeader(log, 3);
        appendPid2.apply$mcVI$sp(2);
        appendPid1.apply$mcVI$sp(4);
        appendPid3.apply$mcVI$sp(3);
        LogTestUtils$.MODULE$.appendNonTransactionalAsLeader(log, 2);
        appendPid1.apply$mcVI$sp(10);
        LogTestUtils$.MODULE$.appendEndTxnMarkerAsLeader(log, pid1, epoch, ControlRecordType.ABORT, this.mockTime().milliseconds(), LogTestUtils$.MODULE$.appendEndTxnMarkerAsLeader$default$6(), LogTestUtils$.MODULE$.appendEndTxnMarkerAsLeader$default$7());
        appendPid2.apply$mcVI$sp(6);
        appendPid4.apply$mcVI$sp(3);
        LogTestUtils$.MODULE$.appendNonTransactionalAsLeader(log, 10);
        appendPid3.apply$mcVI$sp(9);
        LogTestUtils$.MODULE$.appendEndTxnMarkerAsLeader(log, pid3, epoch, ControlRecordType.COMMIT, this.mockTime().milliseconds(), LogTestUtils$.MODULE$.appendEndTxnMarkerAsLeader$default$6(), LogTestUtils$.MODULE$.appendEndTxnMarkerAsLeader$default$7());
        appendPid4.apply$mcVI$sp(8);
        appendPid2.apply$mcVI$sp(7);
        LogTestUtils$.MODULE$.appendEndTxnMarkerAsLeader(log, pid2, epoch, ControlRecordType.ABORT, this.mockTime().milliseconds(), LogTestUtils$.MODULE$.appendEndTxnMarkerAsLeader$default$6(), LogTestUtils$.MODULE$.appendEndTxnMarkerAsLeader$default$7());
        LogTestUtils$.MODULE$.appendNonTransactionalAsLeader(log, 10);
        appendPid4.apply$mcVI$sp(4);
        LogTestUtils$.MODULE$.appendEndTxnMarkerAsLeader(log, pid4, epoch, ControlRecordType.COMMIT, this.mockTime().milliseconds(), LogTestUtils$.MODULE$.appendEndTxnMarkerAsLeader$default$6(), LogTestUtils$.MODULE$.appendEndTxnMarkerAsLeader$default$7());
        log.logSegments().foreach((Function1 & Serializable & scala.Serializable)segment -> BoxesRunTime.boxToBoolean((boolean)LogLoaderTest.$anonfun$testFullTransactionIndexRecovery$1(segment)));
        log.close();
        int x$11 = 5120;
        long x$12 = LogTestUtils$.MODULE$.createLogConfig$default$1();
        long x$13 = LogTestUtils$.MODULE$.createLogConfig$default$3();
        long x$14 = LogTestUtils$.MODULE$.createLogConfig$default$4();
        long x$15 = LogTestUtils$.MODULE$.createLogConfig$default$5();
        String x$16 = LogTestUtils$.MODULE$.createLogConfig$default$6();
        int x$17 = LogTestUtils$.MODULE$.createLogConfig$default$7();
        int x$18 = LogTestUtils$.MODULE$.createLogConfig$default$8();
        int x$19 = LogTestUtils$.MODULE$.createLogConfig$default$9();
        long x$20 = LogTestUtils$.MODULE$.createLogConfig$default$10();
        LogConfig reloadedLogConfig = LogTestUtils$.MODULE$.createLogConfig(x$12, x$11, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20);
        File x$21 = this.logDir();
        boolean x$23 = false;
        BrokerTopicStats x$24 = this.createLog$default$3();
        long x$25 = this.createLog$default$4();
        long x$26 = this.createLog$default$5();
        Scheduler x$27 = this.createLog$default$6();
        Time x$28 = this.createLog$default$7();
        int x$29 = this.createLog$default$8();
        int x$30 = this.createLog$default$9();
        UnifiedLog reloadedLog = this.createLog(x$21, reloadedLogConfig, x$24, x$25, x$26, x$27, x$28, x$29, x$30, x$23);
        Iterable<AbortedTxn> abortedTransactions = LogTestUtils$.MODULE$.allAbortedTransactions(reloadedLog);
        Assertions.assertEquals((Object)new .colon.colon((Object)new AbortedTxn(pid1, 0L, 29L, 8L), (List)new .colon.colon((Object)new AbortedTxn(pid2, 8L, 74L, 36L), (List)Nil$.MODULE$)), abortedTransactions);
    }

    @Test
    public void testRecoverOnlyLastSegment() {
        int x$1 = 640;
        long x$2 = LogTestUtils$.MODULE$.createLogConfig$default$1();
        long x$3 = LogTestUtils$.MODULE$.createLogConfig$default$3();
        long x$4 = LogTestUtils$.MODULE$.createLogConfig$default$4();
        long x$5 = LogTestUtils$.MODULE$.createLogConfig$default$5();
        String x$6 = LogTestUtils$.MODULE$.createLogConfig$default$6();
        int x$7 = LogTestUtils$.MODULE$.createLogConfig$default$7();
        int x$8 = LogTestUtils$.MODULE$.createLogConfig$default$8();
        int x$9 = LogTestUtils$.MODULE$.createLogConfig$default$9();
        long x$10 = LogTestUtils$.MODULE$.createLogConfig$default$10();
        LogConfig logConfig = LogTestUtils$.MODULE$.createLogConfig(x$2, x$1, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10);
        UnifiedLog log = this.createLog(this.logDir(), logConfig, this.createLog$default$3(), this.createLog$default$4(), this.createLog$default$5(), this.createLog$default$6(), this.createLog$default$7(), this.createLog$default$8(), this.createLog$default$9(), this.createLog$default$10());
        short epoch = (short)0;
        long pid1 = 1L;
        long pid2 = 2L;
        long pid3 = 3L;
        long pid4 = 4L;
        Function1<Object, BoxedUnit> appendPid1 = LogTestUtils$.MODULE$.appendTransactionalAsLeader(log, pid1, epoch, (Time)this.mockTime());
        Function1<Object, BoxedUnit> appendPid2 = LogTestUtils$.MODULE$.appendTransactionalAsLeader(log, pid2, epoch, (Time)this.mockTime());
        Function1<Object, BoxedUnit> appendPid3 = LogTestUtils$.MODULE$.appendTransactionalAsLeader(log, pid3, epoch, (Time)this.mockTime());
        Function1<Object, BoxedUnit> appendPid4 = LogTestUtils$.MODULE$.appendTransactionalAsLeader(log, pid4, epoch, (Time)this.mockTime());
        appendPid1.apply$mcVI$sp(5);
        LogTestUtils$.MODULE$.appendNonTransactionalAsLeader(log, 3);
        appendPid2.apply$mcVI$sp(2);
        appendPid1.apply$mcVI$sp(4);
        appendPid3.apply$mcVI$sp(3);
        LogTestUtils$.MODULE$.appendNonTransactionalAsLeader(log, 2);
        appendPid1.apply$mcVI$sp(10);
        LogTestUtils$.MODULE$.appendEndTxnMarkerAsLeader(log, pid1, epoch, ControlRecordType.ABORT, this.mockTime().milliseconds(), LogTestUtils$.MODULE$.appendEndTxnMarkerAsLeader$default$6(), LogTestUtils$.MODULE$.appendEndTxnMarkerAsLeader$default$7());
        appendPid2.apply$mcVI$sp(6);
        appendPid4.apply$mcVI$sp(3);
        LogTestUtils$.MODULE$.appendNonTransactionalAsLeader(log, 10);
        appendPid3.apply$mcVI$sp(9);
        LogTestUtils$.MODULE$.appendEndTxnMarkerAsLeader(log, pid3, epoch, ControlRecordType.COMMIT, this.mockTime().milliseconds(), LogTestUtils$.MODULE$.appendEndTxnMarkerAsLeader$default$6(), LogTestUtils$.MODULE$.appendEndTxnMarkerAsLeader$default$7());
        appendPid4.apply$mcVI$sp(8);
        appendPid2.apply$mcVI$sp(7);
        LogTestUtils$.MODULE$.appendEndTxnMarkerAsLeader(log, pid2, epoch, ControlRecordType.ABORT, this.mockTime().milliseconds(), LogTestUtils$.MODULE$.appendEndTxnMarkerAsLeader$default$6(), LogTestUtils$.MODULE$.appendEndTxnMarkerAsLeader$default$7());
        LogTestUtils$.MODULE$.appendNonTransactionalAsLeader(log, 10);
        appendPid4.apply$mcVI$sp(4);
        LogTestUtils$.MODULE$.appendEndTxnMarkerAsLeader(log, pid4, epoch, ControlRecordType.COMMIT, this.mockTime().milliseconds(), LogTestUtils$.MODULE$.appendEndTxnMarkerAsLeader$default$6(), LogTestUtils$.MODULE$.appendEndTxnMarkerAsLeader$default$7());
        LogSegment lastSegment = (LogSegment)log.logSegments().last();
        long recoveryPoint = lastSegment.baseOffset();
        lastSegment.offsetIndex().deleteIfExists();
        lastSegment.txnIndex().deleteIfExists();
        log.close();
        int x$11 = 5120;
        long x$12 = LogTestUtils$.MODULE$.createLogConfig$default$1();
        long x$13 = LogTestUtils$.MODULE$.createLogConfig$default$3();
        long x$14 = LogTestUtils$.MODULE$.createLogConfig$default$4();
        long x$15 = LogTestUtils$.MODULE$.createLogConfig$default$5();
        String x$16 = LogTestUtils$.MODULE$.createLogConfig$default$6();
        int x$17 = LogTestUtils$.MODULE$.createLogConfig$default$7();
        int x$18 = LogTestUtils$.MODULE$.createLogConfig$default$8();
        int x$19 = LogTestUtils$.MODULE$.createLogConfig$default$9();
        long x$20 = LogTestUtils$.MODULE$.createLogConfig$default$10();
        LogConfig reloadedLogConfig = LogTestUtils$.MODULE$.createLogConfig(x$12, x$11, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20);
        File x$21 = this.logDir();
        boolean x$24 = false;
        BrokerTopicStats x$25 = this.createLog$default$3();
        long x$26 = this.createLog$default$4();
        Scheduler x$27 = this.createLog$default$6();
        Time x$28 = this.createLog$default$7();
        int x$29 = this.createLog$default$8();
        int x$30 = this.createLog$default$9();
        UnifiedLog reloadedLog = this.createLog(x$21, reloadedLogConfig, x$25, x$26, recoveryPoint, x$27, x$28, x$29, x$30, x$24);
        Iterable<AbortedTxn> abortedTransactions = LogTestUtils$.MODULE$.allAbortedTransactions(reloadedLog);
        Assertions.assertEquals((Object)new .colon.colon((Object)new AbortedTxn(pid1, 0L, 29L, 8L), (List)new .colon.colon((Object)new AbortedTxn(pid2, 8L, 74L, 36L), (List)Nil$.MODULE$)), abortedTransactions);
    }

    @Test
    public void testRecoverLastSegmentWithNoSnapshots() {
        int x$1 = 640;
        long x$2 = LogTestUtils$.MODULE$.createLogConfig$default$1();
        long x$3 = LogTestUtils$.MODULE$.createLogConfig$default$3();
        long x$4 = LogTestUtils$.MODULE$.createLogConfig$default$4();
        long x$5 = LogTestUtils$.MODULE$.createLogConfig$default$5();
        String x$6 = LogTestUtils$.MODULE$.createLogConfig$default$6();
        int x$7 = LogTestUtils$.MODULE$.createLogConfig$default$7();
        int x$8 = LogTestUtils$.MODULE$.createLogConfig$default$8();
        int x$9 = LogTestUtils$.MODULE$.createLogConfig$default$9();
        long x$10 = LogTestUtils$.MODULE$.createLogConfig$default$10();
        LogConfig logConfig = LogTestUtils$.MODULE$.createLogConfig(x$2, x$1, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10);
        UnifiedLog log = this.createLog(this.logDir(), logConfig, this.createLog$default$3(), this.createLog$default$4(), this.createLog$default$5(), this.createLog$default$6(), this.createLog$default$7(), this.createLog$default$8(), this.createLog$default$9(), this.createLog$default$10());
        short epoch = (short)0;
        long pid1 = 1L;
        long pid2 = 2L;
        long pid3 = 3L;
        long pid4 = 4L;
        Function1<Object, BoxedUnit> appendPid1 = LogTestUtils$.MODULE$.appendTransactionalAsLeader(log, pid1, epoch, (Time)this.mockTime());
        Function1<Object, BoxedUnit> appendPid2 = LogTestUtils$.MODULE$.appendTransactionalAsLeader(log, pid2, epoch, (Time)this.mockTime());
        Function1<Object, BoxedUnit> appendPid3 = LogTestUtils$.MODULE$.appendTransactionalAsLeader(log, pid3, epoch, (Time)this.mockTime());
        Function1<Object, BoxedUnit> appendPid4 = LogTestUtils$.MODULE$.appendTransactionalAsLeader(log, pid4, epoch, (Time)this.mockTime());
        appendPid1.apply$mcVI$sp(5);
        LogTestUtils$.MODULE$.appendNonTransactionalAsLeader(log, 3);
        appendPid2.apply$mcVI$sp(2);
        appendPid1.apply$mcVI$sp(4);
        appendPid3.apply$mcVI$sp(3);
        LogTestUtils$.MODULE$.appendNonTransactionalAsLeader(log, 2);
        appendPid1.apply$mcVI$sp(10);
        LogTestUtils$.MODULE$.appendEndTxnMarkerAsLeader(log, pid1, epoch, ControlRecordType.ABORT, this.mockTime().milliseconds(), LogTestUtils$.MODULE$.appendEndTxnMarkerAsLeader$default$6(), LogTestUtils$.MODULE$.appendEndTxnMarkerAsLeader$default$7());
        appendPid2.apply$mcVI$sp(6);
        appendPid4.apply$mcVI$sp(3);
        LogTestUtils$.MODULE$.appendNonTransactionalAsLeader(log, 10);
        appendPid3.apply$mcVI$sp(9);
        LogTestUtils$.MODULE$.appendEndTxnMarkerAsLeader(log, pid3, epoch, ControlRecordType.COMMIT, this.mockTime().milliseconds(), LogTestUtils$.MODULE$.appendEndTxnMarkerAsLeader$default$6(), LogTestUtils$.MODULE$.appendEndTxnMarkerAsLeader$default$7());
        appendPid4.apply$mcVI$sp(8);
        appendPid2.apply$mcVI$sp(7);
        LogTestUtils$.MODULE$.appendEndTxnMarkerAsLeader(log, pid2, epoch, ControlRecordType.ABORT, this.mockTime().milliseconds(), LogTestUtils$.MODULE$.appendEndTxnMarkerAsLeader$default$6(), LogTestUtils$.MODULE$.appendEndTxnMarkerAsLeader$default$7());
        LogTestUtils$.MODULE$.appendNonTransactionalAsLeader(log, 10);
        appendPid4.apply$mcVI$sp(4);
        LogTestUtils$.MODULE$.appendEndTxnMarkerAsLeader(log, pid4, epoch, ControlRecordType.COMMIT, this.mockTime().milliseconds(), LogTestUtils$.MODULE$.appendEndTxnMarkerAsLeader$default$6(), LogTestUtils$.MODULE$.appendEndTxnMarkerAsLeader$default$7());
        LogTestUtils$.MODULE$.deleteProducerSnapshotFiles(this.logDir());
        LogSegment lastSegment = (LogSegment)log.logSegments().last();
        long recoveryPoint = lastSegment.baseOffset();
        lastSegment.offsetIndex().deleteIfExists();
        lastSegment.txnIndex().deleteIfExists();
        log.close();
        int x$11 = 5120;
        long x$12 = LogTestUtils$.MODULE$.createLogConfig$default$1();
        long x$13 = LogTestUtils$.MODULE$.createLogConfig$default$3();
        long x$14 = LogTestUtils$.MODULE$.createLogConfig$default$4();
        long x$15 = LogTestUtils$.MODULE$.createLogConfig$default$5();
        String x$16 = LogTestUtils$.MODULE$.createLogConfig$default$6();
        int x$17 = LogTestUtils$.MODULE$.createLogConfig$default$7();
        int x$18 = LogTestUtils$.MODULE$.createLogConfig$default$8();
        int x$19 = LogTestUtils$.MODULE$.createLogConfig$default$9();
        long x$20 = LogTestUtils$.MODULE$.createLogConfig$default$10();
        LogConfig reloadedLogConfig = LogTestUtils$.MODULE$.createLogConfig(x$12, x$11, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20);
        File x$21 = this.logDir();
        boolean x$24 = false;
        BrokerTopicStats x$25 = this.createLog$default$3();
        long x$26 = this.createLog$default$4();
        Scheduler x$27 = this.createLog$default$6();
        Time x$28 = this.createLog$default$7();
        int x$29 = this.createLog$default$8();
        int x$30 = this.createLog$default$9();
        UnifiedLog reloadedLog = this.createLog(x$21, reloadedLogConfig, x$25, x$26, recoveryPoint, x$27, x$28, x$29, x$30, x$24);
        Iterable<AbortedTxn> abortedTransactions = LogTestUtils$.MODULE$.allAbortedTransactions(reloadedLog);
        Assertions.assertEquals((Object)new .colon.colon((Object)new AbortedTxn(pid1, 0L, 29L, 8L), (List)new .colon.colon((Object)new AbortedTxn(pid2, 8L, 74L, 36L), (List)Nil$.MODULE$)), abortedTransactions);
    }

    @Test
    public void testLogEndLessThanStartAfterReopen() {
        LogConfig logConfig = LogTestUtils$.MODULE$.createLogConfig(LogTestUtils$.MODULE$.createLogConfig$default$1(), LogTestUtils$.MODULE$.createLogConfig$default$2(), LogTestUtils$.MODULE$.createLogConfig$default$3(), LogTestUtils$.MODULE$.createLogConfig$default$4(), LogTestUtils$.MODULE$.createLogConfig$default$5(), LogTestUtils$.MODULE$.createLogConfig$default$6(), LogTestUtils$.MODULE$.createLogConfig$default$7(), LogTestUtils$.MODULE$.createLogConfig$default$8(), LogTestUtils$.MODULE$.createLogConfig$default$9(), LogTestUtils$.MODULE$.createLogConfig$default$10());
        ObjectRef log = ObjectRef.create((Object)this.createLog(this.logDir(), logConfig, this.createLog$default$3(), this.createLog$default$4(), this.createLog$default$5(), this.createLog$default$6(), this.createLog$default$7(), this.createLog$default$8(), this.createLog$default$9(), this.createLog$default$10()));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 5).foreach((Function1 & Serializable & scala.Serializable)i -> LogLoaderTest.$anonfun$testLogEndLessThanStartAfterReopen$1(this, log, BoxesRunTime.unboxToInt((Object)i)));
        Assertions.assertEquals((int)6, (int)((UnifiedLog)log.elem).logSegments().size());
        int startOffset = 4;
        ((UnifiedLog)log.elem).updateHighWatermark(((UnifiedLog)log.elem).logEndOffset());
        ((UnifiedLog)log.elem).maybeIncrementLogStartOffset((long)startOffset, (LogStartOffsetIncrementReason)ClientRecordDeletion$.MODULE$);
        Assertions.assertTrue((((UnifiedLog)log.elem).logEndOffset() > ((UnifiedLog)log.elem).logStartOffset() ? 1 : 0) != 0);
        LogSegment segmentToForceTruncation = (LogSegment)((TraversableLike)((UnifiedLog)log.elem).logSegments().take(2)).last();
        BufferedWriter bw = new BufferedWriter(new FileWriter(segmentToForceTruncation.log().file()));
        bw.write("corruptRecord");
        bw.close();
        ((UnifiedLog)log.elem).close();
        File x$7 = this.logDir();
        long x$9 = startOffset;
        boolean x$10 = false;
        BrokerTopicStats x$11 = this.createLog$default$3();
        long x$12 = this.createLog$default$5();
        Scheduler x$13 = this.createLog$default$6();
        Time x$14 = this.createLog$default$7();
        int x$15 = this.createLog$default$8();
        int x$16 = this.createLog$default$9();
        log.elem = this.createLog(x$7, logConfig, x$11, x$9, x$12, x$13, x$14, x$15, x$16, x$10);
        this.mockTime().sleep(Predef$.MODULE$.Long2long(logConfig.fileDeleteDelayMs()));
        Assertions.assertEquals((int)1, (int)((UnifiedLog)log.elem).numberOfSegments());
        Assertions.assertEquals((long)startOffset, (long)((UnifiedLog)log.elem).logStartOffset());
        Assertions.assertEquals((long)startOffset, (long)((UnifiedLog)log.elem).logEndOffset());
        LogSegment onlySegment = (LogSegment)((UnifiedLog)log.elem).logSegments().head();
        Assertions.assertEquals((long)startOffset, (long)onlySegment.baseOffset());
        Assertions.assertTrue((boolean)onlySegment.log().file().exists());
        Assertions.assertTrue((boolean)onlySegment.lazyOffsetIndex().file().exists());
        Assertions.assertTrue((boolean)onlySegment.lazyTimeIndex().file().exists());
    }

    @Test
    public void testCorruptedLogRecoveryDoesNotDeleteProducerStateSnapshotsPostRecovery() {
        LogConfig logConfig = LogTestUtils$.MODULE$.createLogConfig(LogTestUtils$.MODULE$.createLogConfig$default$1(), LogTestUtils$.MODULE$.createLogConfig$default$2(), LogTestUtils$.MODULE$.createLogConfig$default$3(), LogTestUtils$.MODULE$.createLogConfig$default$4(), LogTestUtils$.MODULE$.createLogConfig$default$5(), LogTestUtils$.MODULE$.createLogConfig$default$6(), LogTestUtils$.MODULE$.createLogConfig$default$7(), LogTestUtils$.MODULE$.createLogConfig$default$8(), LogTestUtils$.MODULE$.createLogConfig$default$9(), LogTestUtils$.MODULE$.createLogConfig$default$10());
        ObjectRef log = ObjectRef.create((Object)this.createLog(this.logDir(), logConfig, this.createLog$default$3(), this.createLog$default$4(), this.createLog$default$5(), this.createLog$default$6(), this.createLog$default$7(), this.createLog$default$8(), this.createLog$default$9(), this.createLog$default$10()));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 9).foreach((Function1 & Serializable & scala.Serializable)i -> LogLoaderTest.$anonfun$testCorruptedLogRecoveryDoesNotDeleteProducerStateSnapshotsPostRecovery$1(this, log, BoxesRunTime.unboxToInt((Object)i)));
        Assertions.assertEquals((int)10, (int)((UnifiedLog)log.elem).logSegments().size());
        Assertions.assertEquals((long)0L, (long)((UnifiedLog)log.elem).logStartOffset());
        Assertions.assertEquals((long)9L, (long)((UnifiedLog)log.elem).activeSegment().baseOffset());
        Assertions.assertEquals((long)9L, (long)((UnifiedLog)log.elem).logEndOffset());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), 10).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)offset -> {
            Option snapshotFileBeforeDeletion = ((UnifiedLog)log$13.elem).producerStateManager().snapshotFileForOffset((long)offset);
            Assertions.assertTrue((boolean)snapshotFileBeforeDeletion.isDefined());
            Assertions.assertTrue((boolean)((SnapshotFile)snapshotFileBeforeDeletion.get()).file().exists());
        });
        int newLogStartOffset = 4;
        ((UnifiedLog)log.elem).updateHighWatermark(((UnifiedLog)log.elem).logEndOffset());
        ((UnifiedLog)log.elem).maybeIncrementLogStartOffset((long)newLogStartOffset, (LogStartOffsetIncrementReason)ClientRecordDeletion$.MODULE$);
        Assertions.assertEquals((long)4L, (long)((UnifiedLog)log.elem).logStartOffset());
        Assertions.assertEquals((long)9L, (long)((UnifiedLog)log.elem).logEndOffset());
        LogSegment segmentToForceTruncation = (LogSegment)((TraversableLike)((UnifiedLog)log.elem).logSegments().take(2)).last();
        Assertions.assertEquals((long)1L, (long)segmentToForceTruncation.baseOffset());
        BufferedWriter bw = new BufferedWriter(new FileWriter(segmentToForceTruncation.log().file()));
        bw.write("corruptRecord");
        bw.close();
        ((UnifiedLog)log.elem).close();
        File x$7 = this.logDir();
        long x$9 = newLogStartOffset;
        boolean x$10 = false;
        BrokerTopicStats x$11 = this.createLog$default$3();
        long x$12 = this.createLog$default$5();
        Scheduler x$13 = this.createLog$default$6();
        Time x$14 = this.createLog$default$7();
        int x$15 = this.createLog$default$8();
        int x$16 = this.createLog$default$9();
        log.elem = this.createLog(x$7, logConfig, x$11, x$9, x$12, x$13, x$14, x$15, x$16, x$10);
        Assertions.assertEquals((int)1, (int)((UnifiedLog)log.elem).logSegments().size());
        Assertions.assertEquals((long)4L, (long)((UnifiedLog)log.elem).logStartOffset());
        Assertions.assertEquals((long)4L, (long)((UnifiedLog)log.elem).activeSegment().baseOffset());
        Assertions.assertEquals((long)4L, (long)((UnifiedLog)log.elem).logEndOffset());
        IndexedSeq offsetsWithSnapshotFiles = (IndexedSeq)((TraversableLike)((TraversableLike)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), 5).map((Function1 & Serializable & scala.Serializable)offset -> SnapshotFile$.MODULE$.apply(UnifiedLog$.MODULE$.producerSnapshotFile(this.logDir(), (long)BoxesRunTime.unboxToInt((Object)offset))), IndexedSeq$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)snapshotFile -> BoxesRunTime.boxToBoolean((boolean)LogLoaderTest.$anonfun$testCorruptedLogRecoveryDoesNotDeleteProducerStateSnapshotsPostRecovery$4(snapshotFile)))).map((Function1 & Serializable & scala.Serializable)x$29 -> BoxesRunTime.boxToLong((long)x$29.offset()), IndexedSeq$.MODULE$.canBuildFrom());
        IndexedSeq inMemorySnapshotFiles = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), 5).flatMap((Function1 & Serializable & scala.Serializable)offset -> Option$.MODULE$.option2Iterable(((UnifiedLog)log.elem).producerStateManager().snapshotFileForOffset((long)BoxesRunTime.unboxToInt((Object)offset))), IndexedSeq$.MODULE$.canBuildFrom());
        Assertions.assertTrue((boolean)offsetsWithSnapshotFiles.isEmpty(), (String)new StringBuilder(76).append("Found offsets with producer state snapshot files: ").append(offsetsWithSnapshotFiles).append(" while none were expected.").toString());
        Assertions.assertTrue((boolean)inMemorySnapshotFiles.isEmpty(), (String)new StringBuilder(73).append("Found in-memory producer state snapshot files: ").append(inMemorySnapshotFiles).append(" while none were expected.").toString());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 5).foreach((Function1 & Serializable & scala.Serializable)i -> LogLoaderTest.$anonfun$testCorruptedLogRecoveryDoesNotDeleteProducerStateSnapshotsPostRecovery$7(this, log, BoxesRunTime.unboxToInt((Object)i)));
        Assertions.assertEquals((long)9L, (long)((UnifiedLog)log.elem).activeSegment().baseOffset());
        Assertions.assertEquals((long)9L, (long)((UnifiedLog)log.elem).logEndOffset());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(5), 10).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)offset -> {
            Option snapshotFileBeforeDeletion = ((UnifiedLog)log$13.elem).producerStateManager().snapshotFileForOffset((long)offset);
            Assertions.assertTrue((boolean)snapshotFileBeforeDeletion.isDefined());
            Assertions.assertTrue((boolean)((SnapshotFile)snapshotFileBeforeDeletion.get()).file().exists());
        });
        this.mockTime().sleep(Predef$.MODULE$.Long2long(logConfig.fileDeleteDelayMs()));
        Assertions.assertEquals((long)newLogStartOffset, (long)((UnifiedLog)log.elem).logStartOffset());
        Assertions.assertEquals((long)9L, (long)((UnifiedLog)log.elem).logEndOffset());
        ListBuffer offsetsWithMissingSnapshotFiles = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(5), 10).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)offset -> {
            Option snapshotFile = ((UnifiedLog)log$13.elem).producerStateManager().snapshotFileForOffset((long)offset);
            if (snapshotFile.isEmpty() || !((SnapshotFile)snapshotFile.get()).file().exists()) {
                offsetsWithMissingSnapshotFiles.append((Seq)Predef$.MODULE$.wrapLongArray(new long[]{offset}));
            }
        });
        Assertions.assertTrue((boolean)offsetsWithMissingSnapshotFiles.isEmpty(), (String)new StringBuilder(58).append("Found offsets with missing producer state snapshot files: ").append(offsetsWithMissingSnapshotFiles).toString());
        Assertions.assertFalse((boolean)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.logDir().list())).exists((Function1 & Serializable & scala.Serializable)x$30 -> BoxesRunTime.boxToBoolean((boolean)x$30.endsWith(UnifiedLog$.MODULE$.DeletedFileSuffix()))), (String)"Expected no files to be present with the deleted file suffix");
    }

    private final /* synthetic */ LogLoaderTest$SimulateError$2$ SimulateError$lzycompute$1(LazyRef SimulateError$module$1) {
        synchronized (SimulateError$module$1) {
            LogLoaderTest$SimulateError$2$ logLoaderTest$SimulateError$2$ = SimulateError$module$1.initialized() ? (LogLoaderTest$SimulateError$2$)((Object)SimulateError$module$1.value()) : (LogLoaderTest$SimulateError$2$)((Object)SimulateError$module$1.initialize((Object)new LogLoaderTest$SimulateError$2$(this)));
            return logLoaderTest$SimulateError$2$;
        }
    }

    private final LogLoaderTest$SimulateError$2$ SimulateError$3(LazyRef SimulateError$module$1) {
        if (SimulateError$module$1.initialized()) {
            return (LogLoaderTest$SimulateError$2$)((Object)SimulateError$module$1.value());
        }
        return this.SimulateError$lzycompute$1(SimulateError$module$1);
    }

    private final LogManager interceptedLogManager$1(LogConfig logConfig, Seq logDirs, SimulateError.1 simulateError, MockTime time$1, BooleanRef cleanShutdownInterceptedValue$1) {
        return new LogManager(this, logDirs, logConfig, time$1, simulateError, cleanShutdownInterceptedValue$1){
            private final /* synthetic */ LogLoaderTest $outer;
            private final Kafka_log_LogLoaderTest$SimulateError$1 simulateError$1;
            private final BooleanRef cleanShutdownInterceptedValue$1;
            private final MockTime time$1;
            private final LogConfig logConfig$1;

            public UnifiedLog loadLog(File logDir, boolean hadCleanShutdown, Map<TopicPartition, Object> recoveryPoints, Map<TopicPartition, Object> logStartOffsets, LogConfig defaultConfig, Map<String, LogConfig> topicConfigs) {
                if (this.simulateError$1.hasError()) {
                    throw new RuntimeException("Simulated error");
                }
                this.cleanShutdownInterceptedValue$1.elem = hadCleanShutdown;
                TopicPartition topicPartition = UnifiedLog$.MODULE$.parseTopicPartitionName(logDir);
                LogConfig config = (LogConfig)topicConfigs.getOrElse((Object)topicPartition.topic(), (Function0 & Serializable & scala.Serializable)() -> defaultConfig);
                long logRecoveryPoint = BoxesRunTime.unboxToLong((Object)recoveryPoints.getOrElse((Object)topicPartition, (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L));
                long logStartOffset = BoxesRunTime.unboxToLong((Object)logStartOffsets.getOrElse((Object)topicPartition, (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L));
                LogDirFailureChannel logDirFailureChannel = new LogDirFailureChannel(1);
                int maxProducerIdExpirationMs = 3600000;
                LogSegments segments = new LogSegments(topicPartition);
                Option leaderEpochCache = UnifiedLog$.MODULE$.maybeCreateLeaderEpochCache(logDir, topicPartition, logDirFailureChannel, config.recordVersion(), "");
                ProducerStateManager producerStateManager = new ProducerStateManager(topicPartition, logDir, maxProducerIdExpirationMs, (Time)this.time$1);
                LoadLogParams loadLogParams = new LoadLogParams(logDir, topicPartition, config, (Scheduler)this.time$1.scheduler(), (Time)this.time$1, logDirFailureChannel, hadCleanShutdown, segments, logStartOffset, logRecoveryPoint, maxProducerIdExpirationMs, leaderEpochCache, producerStateManager);
                LoadedLogOffsets offsets = LogLoader$.MODULE$.load(loadLogParams);
                LocalLog localLog = new LocalLog(logDir, this.logConfig$1, segments, offsets.recoveryPoint(), offsets.nextOffsetMetadata(), (Scheduler)this.$outer.mockTime().scheduler(), (Time)this.$outer.mockTime(), topicPartition, logDirFailureChannel);
                return new UnifiedLog(offsets.logStartOffset(), localLog, this.$outer.brokerTopicStats(), LogManager$.MODULE$.ProducerIdExpirationCheckIntervalMs(), leaderEpochCache, producerStateManager, (Option)None$.MODULE$, true);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.simulateError$1 = simulateError$1;
                this.cleanShutdownInterceptedValue$1 = cleanShutdownInterceptedValue$1;
                this.time$1 = time$1;
                this.logConfig$1 = logConfig$1;
                boolean x$1 = false;
                int x$2 = CleanerConfig$.MODULE$.apply$default$1();
                long x$3 = CleanerConfig$.MODULE$.apply$default$2();
                double x$4 = CleanerConfig$.MODULE$.apply$default$3();
                int x$5 = CleanerConfig$.MODULE$.apply$default$4();
                int x$6 = CleanerConfig$.MODULE$.apply$default$5();
                double x$7 = CleanerConfig$.MODULE$.apply$default$6();
                long x$8 = CleanerConfig$.MODULE$.apply$default$7();
                String x$9 = CleanerConfig$.MODULE$.apply$default$9();
                super((Seq)logDirs$1.map((Function1)new scala.Serializable(null){
                    public static final long serialVersionUID = 0L;

                    public final File apply(File x$1) {
                        return x$1.getAbsoluteFile();
                    }
                }, Seq$.MODULE$.canBuildFrom()), (Seq)Predef$.MODULE$.wrapRefArray((Object[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(File.class))), (ConfigRepository)new MockConfigRepository(), logConfig$1, new CleanerConfig(x$2, x$3, x$4, x$5, x$6, x$7, x$8, x$1, x$9), 4, 1000L, 10000L, 10000L, 1000L, 3600000, $outer.config().interBrokerProtocolVersion(), (Scheduler)time$1.scheduler(), new BrokerTopicStats(), new LogDirFailureChannel(logDirs$1.size()), (Time)time$1, $outer.config().usesTopicId());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$loadLog$1(kafka.log.LogConfig ), $anonfun$loadLog$2(), $anonfun$loadLog$3()}, serializedLambda);
            }
        };
    }

    public static final /* synthetic */ LogAppendInfo $anonfun$testProducerSnapshotsRecoveryAfterUncleanShutdown$1(LogLoaderTest $this, ObjectRef log$1, int i) {
        SimpleRecord record = new SimpleRecord($this.mockTime().milliseconds(), Integer.toString(i).getBytes());
        UnifiedLog qual$1 = (UnifiedLog)log$1.elem;
        MemoryRecords x$1 = TestUtils$.MODULE$.records((Iterable<SimpleRecord>)new .colon.colon((Object)record, (List)Nil$.MODULE$), TestUtils$.MODULE$.records$default$2(), TestUtils$.MODULE$.records$default$3(), TestUtils$.MODULE$.records$default$4(), TestUtils$.MODULE$.records$default$5(), TestUtils$.MODULE$.records$default$6(), TestUtils$.MODULE$.records$default$7(), TestUtils$.MODULE$.records$default$8());
        int x$2 = 0;
        AppendOrigin x$3 = qual$1.appendAsLeader$default$3();
        ApiVersion x$4 = qual$1.appendAsLeader$default$4();
        RequestLocal x$5 = qual$1.appendAsLeader$default$5();
        return qual$1.appendAsLeader(x$1, x$2, x$3, x$4, x$5);
    }

    private final UnifiedLog createLogWithInterceptedReads$1(long recoveryPoint, scala.collection.mutable.Set segmentsWithReads$1, scala.collection.mutable.Set recoveredSegments$1, LogConfig logConfig$2) {
        int maxProducerIdExpirationMs = 3600000;
        TopicPartition topicPartition = UnifiedLog$.MODULE$.parseTopicPartitionName(this.logDir());
        LogDirFailureChannel logDirFailureChannel = new LogDirFailureChannel(10);
        LogSegments interceptedLogSegments = new LogSegments(this, topicPartition, segmentsWithReads$1, recoveredSegments$1){
            private final /* synthetic */ LogLoaderTest $outer;
            public final scala.collection.mutable.Set segmentsWithReads$1;
            public final scala.collection.mutable.Set recoveredSegments$1;

            public LogSegment add(LogSegment segment) {
                LogSegment wrapper = new LogSegment(this, segment){
                    private final /* synthetic */ $anon$2 $outer;

                    public FetchDataInfo read(long startOffset, int maxSize, long maxPosition, boolean minOneMessage) {
                        this.$outer.segmentsWithReads$1.$plus$eq((Object)((Object)this));
                        return super.read(startOffset, maxSize, maxPosition, minOneMessage);
                    }

                    public int recover(ProducerStateManager producerStateManager, Option<LeaderEpochFileCache> leaderEpochCache) {
                        this.$outer.recoveredSegments$1.$plus$eq((Object)((Object)this));
                        return super.recover(producerStateManager, leaderEpochCache);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        super(segment$1.log(), segment$1.lazyOffsetIndex(), segment$1.lazyTimeIndex(), segment$1.txnIndex(), segment$1.baseOffset(), segment$1.indexIntervalBytes(), segment$1.rollJitterMs(), (Time)$outer.kafka$log$LogLoaderTest$$anon$$$outer().mockTime());
                    }
                };
                return super.add(wrapper);
            }

            public /* synthetic */ LogLoaderTest kafka$log$LogLoaderTest$$anon$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.segmentsWithReads$1 = segmentsWithReads$1;
                this.recoveredSegments$1 = recoveredSegments$1;
                super(topicPartition$1);
            }
        };
        Option leaderEpochCache = UnifiedLog$.MODULE$.maybeCreateLeaderEpochCache(this.logDir(), topicPartition, logDirFailureChannel, logConfig$2.recordVersion(), "");
        ProducerStateManager producerStateManager = new ProducerStateManager(topicPartition, this.logDir(), maxProducerIdExpirationMs, (Time)this.mockTime());
        LoadLogParams loadLogParams = new LoadLogParams(this.logDir(), topicPartition, logConfig$2, (Scheduler)this.mockTime().scheduler(), (Time)this.mockTime(), logDirFailureChannel, false, interceptedLogSegments, 0L, recoveryPoint, maxProducerIdExpirationMs, leaderEpochCache, producerStateManager);
        LoadedLogOffsets offsets = LogLoader$.MODULE$.load(loadLogParams);
        LocalLog localLog = new LocalLog(this.logDir(), logConfig$2, interceptedLogSegments, offsets.recoveryPoint(), offsets.nextOffsetMetadata(), (Scheduler)this.mockTime().scheduler(), (Time)this.mockTime(), topicPartition, logDirFailureChannel);
        return new UnifiedLog(offsets.logStartOffset(), localLog, this.brokerTopicStats(), LogManager$.MODULE$.ProducerIdExpirationCheckIntervalMs(), leaderEpochCache, producerStateManager, (Option)None$.MODULE$, true);
    }

    public static final /* synthetic */ LogAppendInfo $anonfun$testLogRecoversToCorrectOffset$1(LogLoaderTest $this, ObjectRef log$2, int messageSize$1, int i) {
        UnifiedLog qual$1 = (UnifiedLog)log$2.elem;
        byte[] x$11 = TestUtils$.MODULE$.randomBytes(messageSize$1);
        long x$12 = $this.mockTime().milliseconds() + (long)(i * 10);
        byte[] x$13 = TestUtils$.MODULE$.singletonRecords$default$2();
        CompressionType x$14 = TestUtils$.MODULE$.singletonRecords$default$3();
        byte x$15 = TestUtils$.MODULE$.singletonRecords$default$5();
        MemoryRecords x$16 = TestUtils$.MODULE$.singletonRecords(x$11, x$13, x$14, x$12, x$15);
        int x$17 = 0;
        AppendOrigin x$18 = qual$1.appendAsLeader$default$3();
        ApiVersion x$19 = qual$1.appendAsLeader$default$4();
        RequestLocal x$20 = qual$1.appendAsLeader$default$5();
        return qual$1.appendAsLeader(x$16, x$17, x$18, x$19, x$20);
    }

    private static final void verifyRecoveredLog$1(UnifiedLog log, long expectedRecoveryPoint, int numMessages$1, long lastIndexOffset$1, int numIndexEntries$1, long lastTimeIndexTimestamp$1, long lastTimeIndexOffset$1, int numTimeIndexEntries$1) {
        Assertions.assertEquals((long)expectedRecoveryPoint, (long)log.recoveryPoint(), (String)"Unexpected recovery point");
        Assertions.assertEquals((long)numMessages$1, (long)log.logEndOffset(), (String)new StringBuilder(55).append("Should have ").append(numMessages$1).append(" messages when log is reopened w/o recovery").toString());
        Assertions.assertEquals((long)lastIndexOffset$1, (long)log.activeSegment().offsetIndex().lastOffset(), (String)"Should have same last index offset as before.");
        Assertions.assertEquals((int)numIndexEntries$1, (int)log.activeSegment().offsetIndex().entries(), (String)"Should have same number of index entries as before.");
        Assertions.assertEquals((long)lastTimeIndexTimestamp$1, (long)log.activeSegment().timeIndex().lastEntry().timestamp(), (String)"Should have same last time index timestamp");
        Assertions.assertEquals((long)lastTimeIndexOffset$1, (long)log.activeSegment().timeIndex().lastEntry().offset(), (String)"Should have same last time index offset");
        Assertions.assertEquals((int)numTimeIndexEntries$1, (int)log.activeSegment().timeIndex().entries(), (String)"Should have same number of time index entries as before.");
    }

    public static final /* synthetic */ LogAppendInfo $anonfun$testIndexRebuild$1(LogLoaderTest $this, ObjectRef log$3, int i) {
        UnifiedLog qual$1 = (UnifiedLog)log$3.elem;
        byte[] x$11 = TestUtils$.MODULE$.randomBytes(10);
        long x$12 = $this.mockTime().milliseconds() + (long)(i * 10);
        byte[] x$13 = TestUtils$.MODULE$.singletonRecords$default$2();
        CompressionType x$14 = TestUtils$.MODULE$.singletonRecords$default$3();
        byte x$15 = TestUtils$.MODULE$.singletonRecords$default$5();
        MemoryRecords x$16 = TestUtils$.MODULE$.singletonRecords(x$11, x$13, x$14, x$12, x$15);
        int x$17 = 0;
        AppendOrigin x$18 = qual$1.appendAsLeader$default$3();
        ApiVersion x$19 = qual$1.appendAsLeader$default$4();
        RequestLocal x$20 = qual$1.appendAsLeader$default$5();
        return qual$1.appendAsLeader(x$16, x$17, x$18, x$19, x$20);
    }

    public static final /* synthetic */ LogAppendInfo $anonfun$testRebuildTimeIndexForOldMessages$1(LogLoaderTest $this, ObjectRef log$4, int i) {
        UnifiedLog qual$1 = (UnifiedLog)log$4.elem;
        byte[] x$1 = TestUtils$.MODULE$.randomBytes(10);
        long x$2 = $this.mockTime().milliseconds() + (long)(i * 10);
        byte x$3 = 1;
        byte[] x$4 = TestUtils$.MODULE$.singletonRecords$default$2();
        CompressionType x$5 = TestUtils$.MODULE$.singletonRecords$default$3();
        MemoryRecords x$6 = TestUtils$.MODULE$.singletonRecords(x$1, x$4, x$5, x$2, x$3);
        int x$7 = 0;
        AppendOrigin x$8 = qual$1.appendAsLeader$default$3();
        ApiVersion x$9 = qual$1.appendAsLeader$default$4();
        RequestLocal x$10 = qual$1.appendAsLeader$default$5();
        return qual$1.appendAsLeader(x$6, x$7, x$8, x$9, x$10);
    }

    public static final /* synthetic */ void $anonfun$testRebuildTimeIndexForOldMessages$3(File file) {
        Files.delete(file.toPath());
    }

    public static final /* synthetic */ void $anonfun$testRebuildTimeIndexForOldMessages$4(LogSegment segment) {
        Assertions.assertEquals((int)0, (int)segment.timeIndex().entries(), (String)"The time index should be empty");
        Assertions.assertEquals((long)0L, (long)segment.lazyTimeIndex().file().length(), (String)"The time index file size should be 0");
    }

    public static final /* synthetic */ LogAppendInfo $anonfun$testCorruptIndexRebuild$1(LogLoaderTest $this, ObjectRef log$5, int i) {
        UnifiedLog qual$1 = (UnifiedLog)log$5.elem;
        byte[] x$11 = TestUtils$.MODULE$.randomBytes(10);
        long x$12 = $this.mockTime().milliseconds() + (long)(i * 10);
        byte[] x$13 = TestUtils$.MODULE$.singletonRecords$default$2();
        CompressionType x$14 = TestUtils$.MODULE$.singletonRecords$default$3();
        byte x$15 = TestUtils$.MODULE$.singletonRecords$default$5();
        MemoryRecords x$16 = TestUtils$.MODULE$.singletonRecords(x$11, x$13, x$14, x$12, x$15);
        int x$17 = 0;
        AppendOrigin x$18 = qual$1.appendAsLeader$default$3();
        ApiVersion x$19 = qual$1.appendAsLeader$default$4();
        RequestLocal x$20 = qual$1.appendAsLeader$default$5();
        return qual$1.appendAsLeader(x$16, x$17, x$18, x$19, x$20);
    }

    public static final /* synthetic */ void $anonfun$testCorruptIndexRebuild$4(File file) {
        BufferedWriter bw = new BufferedWriter(new FileWriter(file));
        bw.write("  ");
        bw.close();
    }

    public static final /* synthetic */ void $anonfun$testCorruptIndexRebuild$5(File file) {
        BufferedWriter bw = new BufferedWriter(new FileWriter(file));
        bw.write("  ");
        bw.close();
    }

    private final MemoryRecords createRecords$1() {
        byte[] x$1 = "test".getBytes();
        long x$2 = this.mockTime().milliseconds();
        byte[] x$3 = TestUtils$.MODULE$.singletonRecords$default$2();
        CompressionType x$4 = TestUtils$.MODULE$.singletonRecords$default$3();
        byte x$5 = TestUtils$.MODULE$.singletonRecords$default$5();
        return TestUtils$.MODULE$.singletonRecords(x$1, x$3, x$4, x$2, x$5);
    }

    private final MemoryRecords createRecords$2() {
        byte[] x$1 = "test".getBytes();
        long x$2 = this.mockTime().milliseconds();
        byte[] x$3 = TestUtils$.MODULE$.singletonRecords$default$2();
        CompressionType x$4 = TestUtils$.MODULE$.singletonRecords$default$3();
        byte x$5 = TestUtils$.MODULE$.singletonRecords$default$5();
        return TestUtils$.MODULE$.singletonRecords(x$1, x$3, x$4, x$2, x$5);
    }

    public static final /* synthetic */ LogAppendInfo $anonfun$testReopenThenTruncate$1(LogLoaderTest $this, ObjectRef log$7, int _) {
        UnifiedLog qual$1 = (UnifiedLog)log$7.elem;
        MemoryRecords x$11 = $this.createRecords$2();
        int x$12 = 0;
        AppendOrigin x$13 = qual$1.appendAsLeader$default$3();
        ApiVersion x$14 = qual$1.appendAsLeader$default$4();
        RequestLocal x$15 = qual$1.appendAsLeader$default$5();
        return qual$1.appendAsLeader(x$11, x$12, x$13, x$14, x$15);
    }

    private final MemoryRecords createRecords$3() {
        byte[] x$1 = "test".getBytes();
        long x$2 = this.mockTime().milliseconds() - 1000L;
        byte[] x$3 = TestUtils$.MODULE$.singletonRecords$default$2();
        CompressionType x$4 = TestUtils$.MODULE$.singletonRecords$default$3();
        byte x$5 = TestUtils$.MODULE$.singletonRecords$default$5();
        return TestUtils$.MODULE$.singletonRecords(x$1, x$3, x$4, x$2, x$5);
    }

    public static final /* synthetic */ LogAppendInfo $anonfun$testOpenDeletesObsoleteFiles$1(LogLoaderTest $this, ObjectRef log$8, int _) {
        UnifiedLog qual$1 = (UnifiedLog)log$8.elem;
        MemoryRecords x$11 = $this.createRecords$3();
        int x$12 = 0;
        AppendOrigin x$13 = qual$1.appendAsLeader$default$3();
        ApiVersion x$14 = qual$1.appendAsLeader$default$4();
        RequestLocal x$15 = qual$1.appendAsLeader$default$5();
        return qual$1.appendAsLeader(x$11, x$12, x$13, x$14, x$15);
    }

    private final MemoryRecords createRecords$4() {
        byte[] x$1 = "test".getBytes();
        long x$2 = this.mockTime().milliseconds();
        byte[] x$3 = TestUtils$.MODULE$.singletonRecords$default$2();
        CompressionType x$4 = TestUtils$.MODULE$.singletonRecords$default$3();
        byte x$5 = TestUtils$.MODULE$.singletonRecords$default$5();
        return TestUtils$.MODULE$.singletonRecords(x$1, x$3, x$4, x$2, x$5);
    }

    public static final /* synthetic */ LogAppendInfo $anonfun$testCorruptLog$2(LogLoaderTest $this, ObjectRef log$9, int _) {
        UnifiedLog qual$1 = (UnifiedLog)log$9.elem;
        MemoryRecords x$11 = $this.createRecords$4();
        int x$12 = 0;
        AppendOrigin x$13 = qual$1.appendAsLeader$default$3();
        ApiVersion x$14 = qual$1.appendAsLeader$default$4();
        RequestLocal x$15 = qual$1.appendAsLeader$default$5();
        return qual$1.appendAsLeader(x$11, x$12, x$13, x$14, x$15);
    }

    public static final /* synthetic */ boolean $anonfun$testOverCompactedLogRecovery$1(File file) {
        return file.getName().contains(".index");
    }

    public static final /* synthetic */ void $anonfun$testOverCompactedLogRecovery$2(File file) {
        OffsetIndex offsetIndex = new OffsetIndex(file, new StringOps(Predef$.MODULE$.augmentString(file.getName().replace(".index", ""))).toLong(), OffsetIndex$.MODULE$.$lessinit$greater$default$3(), OffsetIndex$.MODULE$.$lessinit$greater$default$4());
        Assertions.assertTrue((offsetIndex.lastOffset() >= 0L ? 1 : 0) != 0);
        offsetIndex.close();
    }

    public static final /* synthetic */ boolean $anonfun$testOverCompactedLogRecoveryMultiRecord$1(File file) {
        return file.getName().contains(".index");
    }

    public static final /* synthetic */ void $anonfun$testOverCompactedLogRecoveryMultiRecord$2(File file) {
        OffsetIndex offsetIndex = new OffsetIndex(file, new StringOps(Predef$.MODULE$.augmentString(file.getName().replace(".index", ""))).toLong(), OffsetIndex$.MODULE$.$lessinit$greater$default$3(), OffsetIndex$.MODULE$.$lessinit$greater$default$4());
        Assertions.assertTrue((offsetIndex.lastOffset() >= 0L ? 1 : 0) != 0);
        offsetIndex.close();
    }

    public static final /* synthetic */ boolean $anonfun$testOverCompactedLogRecoveryMultiRecordV1$1(File file) {
        return file.getName().contains(".index");
    }

    public static final /* synthetic */ void $anonfun$testOverCompactedLogRecoveryMultiRecordV1$2(File file) {
        OffsetIndex offsetIndex = new OffsetIndex(file, new StringOps(Predef$.MODULE$.augmentString(file.getName().replace(".index", ""))).toLong(), OffsetIndex$.MODULE$.$lessinit$greater$default$3(), OffsetIndex$.MODULE$.$lessinit$greater$default$4());
        Assertions.assertTrue((offsetIndex.lastOffset() >= 0L ? 1 : 0) != 0);
        offsetIndex.close();
    }

    public static final /* synthetic */ IllegalArgumentException $anonfun$testRecoveryOfSegmentWithOffsetOverflow$1(UnifiedLog log$10, LogSegment segment) {
        return (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> log$10.splitOverflowedSegment(segment));
    }

    public static final /* synthetic */ int $anonfun$testRecoveryAfterCrashDuringSplitPhase1$1(LogSegment segment) {
        segment.changeFileSuffixes("", UnifiedLog$.MODULE$.CleanedFileSuffix());
        return segment.truncateTo(0L);
    }

    public static final /* synthetic */ boolean $anonfun$testRecoveryAfterCrashDuringSplitPhase1$2(File file) {
        return file.getName().endsWith(UnifiedLog$.MODULE$.DeletedFileSuffix());
    }

    public static final /* synthetic */ void $anonfun$testRecoveryAfterCrashDuringSplitPhase1$3(File file) {
        Utils.atomicMoveWithFallback((Path)file.toPath(), (Path)Paths.get(CoreUtils$.MODULE$.replaceSuffix(file.getPath(), UnifiedLog$.MODULE$.DeletedFileSuffix(), ""), new String[0]));
    }

    public static final /* synthetic */ int $anonfun$testRecoveryAfterCrashDuringSplitPhase2$1(List newSegments$1, LogSegment segment) {
        LogSegment logSegment = segment;
        Object object = newSegments$1.last();
        if (logSegment == null ? object != null : !logSegment.equals(object)) {
            segment.changeFileSuffixes("", UnifiedLog$.MODULE$.CleanedFileSuffix());
        } else {
            segment.changeFileSuffixes("", UnifiedLog$.MODULE$.SwapFileSuffix());
        }
        return segment.truncateTo(0L);
    }

    public static final /* synthetic */ boolean $anonfun$testRecoveryAfterCrashDuringSplitPhase2$2(File file) {
        return file.getName().endsWith(UnifiedLog$.MODULE$.DeletedFileSuffix());
    }

    public static final /* synthetic */ void $anonfun$testRecoveryAfterCrashDuringSplitPhase2$3(File file) {
        Utils.atomicMoveWithFallback((Path)file.toPath(), (Path)Paths.get(CoreUtils$.MODULE$.replaceSuffix(file.getPath(), UnifiedLog$.MODULE$.DeletedFileSuffix(), ""), new String[0]));
    }

    public static final /* synthetic */ boolean $anonfun$testRecoveryAfterCrashDuringSplitPhase3$2(File file) {
        return file.getName().endsWith(UnifiedLog$.MODULE$.DeletedFileSuffix());
    }

    public static final /* synthetic */ void $anonfun$testRecoveryAfterCrashDuringSplitPhase3$3(File file) {
        Utils.atomicMoveWithFallback((Path)file.toPath(), (Path)Paths.get(CoreUtils$.MODULE$.replaceSuffix(file.getPath(), UnifiedLog$.MODULE$.DeletedFileSuffix(), ""), new String[0]));
    }

    public static final /* synthetic */ boolean $anonfun$testRecoveryAfterCrashDuringSplitPhase4$2(File file) {
        return file.getName().endsWith(UnifiedLog$.MODULE$.DeletedFileSuffix());
    }

    public static final /* synthetic */ void $anonfun$testRecoveryAfterCrashDuringSplitPhase4$3(File file) {
        Utils.delete((File)file);
    }

    private final MemoryRecords createRecords$5() {
        byte[] x$1 = "test".getBytes();
        long x$2 = this.mockTime().milliseconds();
        byte[] x$3 = TestUtils$.MODULE$.singletonRecords$default$2();
        CompressionType x$4 = TestUtils$.MODULE$.singletonRecords$default$3();
        byte x$5 = TestUtils$.MODULE$.singletonRecords$default$5();
        return TestUtils$.MODULE$.singletonRecords(x$1, x$3, x$4, x$2, x$5);
    }

    public static final /* synthetic */ LogAppendInfo $anonfun$testCleanShutdownFile$1(LogLoaderTest $this, ObjectRef log$11, int _) {
        UnifiedLog qual$1 = (UnifiedLog)log$11.elem;
        MemoryRecords x$11 = $this.createRecords$5();
        int x$12 = 0;
        AppendOrigin x$13 = qual$1.appendAsLeader$default$3();
        ApiVersion x$14 = qual$1.appendAsLeader$default$4();
        RequestLocal x$15 = qual$1.appendAsLeader$default$5();
        return qual$1.appendAsLeader(x$11, x$12, x$13, x$14, x$15);
    }

    public static final /* synthetic */ boolean $anonfun$testFullTransactionIndexRecovery$1(LogSegment segment) {
        segment.offsetIndex().deleteIfExists();
        return segment.txnIndex().deleteIfExists();
    }

    public static final /* synthetic */ LogSegment $anonfun$testLogEndLessThanStartAfterReopen$1(LogLoaderTest $this, ObjectRef log$12, int i) {
        SimpleRecord record = new SimpleRecord($this.mockTime().milliseconds(), Integer.toString(i).getBytes());
        UnifiedLog qual$1 = (UnifiedLog)log$12.elem;
        MemoryRecords x$1 = TestUtils$.MODULE$.records((Iterable<SimpleRecord>)new .colon.colon((Object)record, (List)Nil$.MODULE$), TestUtils$.MODULE$.records$default$2(), TestUtils$.MODULE$.records$default$3(), TestUtils$.MODULE$.records$default$4(), TestUtils$.MODULE$.records$default$5(), TestUtils$.MODULE$.records$default$6(), TestUtils$.MODULE$.records$default$7(), TestUtils$.MODULE$.records$default$8());
        int x$2 = 0;
        AppendOrigin x$3 = qual$1.appendAsLeader$default$3();
        ApiVersion x$4 = qual$1.appendAsLeader$default$4();
        RequestLocal x$5 = qual$1.appendAsLeader$default$5();
        qual$1.appendAsLeader(x$1, x$2, x$3, x$4, x$5);
        UnifiedLog qual$2 = (UnifiedLog)log$12.elem;
        Option x$6 = qual$2.roll$default$1();
        return qual$2.roll(x$6);
    }

    public static final /* synthetic */ LogSegment $anonfun$testCorruptedLogRecoveryDoesNotDeleteProducerStateSnapshotsPostRecovery$1(LogLoaderTest $this, ObjectRef log$13, int i) {
        SimpleRecord record = new SimpleRecord($this.mockTime().milliseconds(), Integer.toString(i).getBytes());
        UnifiedLog qual$1 = (UnifiedLog)log$13.elem;
        MemoryRecords x$1 = TestUtils$.MODULE$.records((Iterable<SimpleRecord>)new .colon.colon((Object)record, (List)Nil$.MODULE$), TestUtils$.MODULE$.records$default$2(), TestUtils$.MODULE$.records$default$3(), TestUtils$.MODULE$.records$default$4(), TestUtils$.MODULE$.records$default$5(), TestUtils$.MODULE$.records$default$6(), TestUtils$.MODULE$.records$default$7(), TestUtils$.MODULE$.records$default$8());
        int x$2 = 0;
        AppendOrigin x$3 = qual$1.appendAsLeader$default$3();
        ApiVersion x$4 = qual$1.appendAsLeader$default$4();
        RequestLocal x$5 = qual$1.appendAsLeader$default$5();
        qual$1.appendAsLeader(x$1, x$2, x$3, x$4, x$5);
        UnifiedLog qual$2 = (UnifiedLog)log$13.elem;
        Option x$6 = qual$2.roll$default$1();
        return qual$2.roll(x$6);
    }

    public static final /* synthetic */ boolean $anonfun$testCorruptedLogRecoveryDoesNotDeleteProducerStateSnapshotsPostRecovery$4(SnapshotFile snapshotFile) {
        return snapshotFile.file().exists();
    }

    public static final /* synthetic */ LogSegment $anonfun$testCorruptedLogRecoveryDoesNotDeleteProducerStateSnapshotsPostRecovery$7(LogLoaderTest $this, ObjectRef log$13, int i) {
        SimpleRecord record = new SimpleRecord($this.mockTime().milliseconds(), Integer.toString(i).getBytes());
        UnifiedLog qual$3 = (UnifiedLog)log$13.elem;
        MemoryRecords x$17 = TestUtils$.MODULE$.records((Iterable<SimpleRecord>)new .colon.colon((Object)record, (List)Nil$.MODULE$), TestUtils$.MODULE$.records$default$2(), TestUtils$.MODULE$.records$default$3(), TestUtils$.MODULE$.records$default$4(), TestUtils$.MODULE$.records$default$5(), TestUtils$.MODULE$.records$default$6(), TestUtils$.MODULE$.records$default$7(), TestUtils$.MODULE$.records$default$8());
        int x$18 = 0;
        AppendOrigin x$19 = qual$3.appendAsLeader$default$3();
        ApiVersion x$20 = qual$3.appendAsLeader$default$4();
        RequestLocal x$21 = qual$3.appendAsLeader$default$5();
        qual$3.appendAsLeader(x$17, x$18, x$19, x$20, x$21);
        UnifiedLog qual$4 = (UnifiedLog)log$13.elem;
        Option x$22 = qual$4.roll$default$1();
        return qual$4.roll(x$22);
    }

    public LogLoaderTest() {
        this.maxProducerIdExpirationMs = 3600000;
    }
}

