/*
 * Decompiled with CFR 0.152.
 */
package kafka.network;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import kafka.network.RequestChannel;
import kafka.network.RequestConvertToJson$;
import kafka.utils.NotNothing$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.memory.MemoryPool;
import org.apache.kafka.common.message.IncrementalAlterConfigsRequestData;
import org.apache.kafka.common.network.ByteBufferSend;
import org.apache.kafka.common.network.ClientInformation;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.AlterConfigsRequest;
import org.apache.kafka.common.requests.EnvelopeResponse;
import org.apache.kafka.common.requests.IncrementalAlterConfigsRequest;
import org.apache.kafka.common.requests.MetadataRequest;
import org.apache.kafka.common.requests.MetadataResponse;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.requests.RequestTestUtils;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.KafkaPrincipalSerde;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.common.utils.SecurityUtils;
import org.apache.kafka.common.utils.Utils;
import org.easymock.EasyMock;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\rf\u0001\u0002\r\u001a\u0001yAQ!\n\u0001\u0005\u0002\u0019Bq!\u000b\u0001C\u0002\u0013%!\u0006\u0003\u00043\u0001\u0001\u0006Ia\u000b\u0005\bg\u0001\u0011\r\u0011\"\u00035\u0011\u0019i\u0004\u0001)A\u0005k!9a\b\u0001b\u0001\n\u0013y\u0004BB\"\u0001A\u0003%\u0001\tC\u0004W\u0001\t\u0007I\u0011B,\t\ru\u0003\u0001\u0015!\u0003Y\u0011\u0015q\u0006\u0001\"\u0001`\u0011\u0015q\u0007\u0001\"\u0001`\u0011\u0015\u0001\b\u0001\"\u0001`\u0011\u0015\u0011\b\u0001\"\u0001`\u0011\u0015!\b\u0001\"\u0001`\u0011\u00151\b\u0001\"\u0001`\u0011\u0015A\b\u0001\"\u0001`\u0011\u0015Q\b\u0001\"\u0003|\u0011\u001d\t)\u0001\u0001C\u0005\u0003\u000fAq!a\u0005\u0001\t\u0013\t)\u0002C\u0004\u0002\u0012\u0001!\t!!\u000e\t\u000f\u0005m\u0002\u0001\"\u0003\u0002>!9\u0011Q\u000b\u0001\u0005\n\u0005]\u0003bBA+\u0001\u0011%\u00111\u0012\u0002\u0013%\u0016\fX/Z:u\u0007\"\fgN\\3m)\u0016\u001cHO\u0003\u0002\u001b7\u00059a.\u001a;x_J\\'\"\u0001\u000f\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001a\b\t\u0003A\rj\u0011!\t\u0006\u0002E\u0005)1oY1mC&\u0011A%\t\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u00059\u0003C\u0001\u0015\u0001\u001b\u0005I\u0012!\u0006:fcV,7\u000f^\"iC:tW\r\\'fiJL7m]\u000b\u0002WA\u0011Af\f\b\u0003Q5J!AL\r\u0002\u001dI+\u0017/^3ti\u000eC\u0017M\u001c8fY&\u0011\u0001'\r\u0002\b\u001b\u0016$(/[2t\u0015\tq\u0013$\u0001\fsKF,Xm\u001d;DQ\u0006tg.\u001a7NKR\u0014\u0018nY:!\u0003!\u0019G.[3oi&#W#A\u001b\u0011\u0005YZT\"A\u001c\u000b\u0005aJ\u0014\u0001\u00027b]\u001eT\u0011AO\u0001\u0005U\u00064\u0018-\u0003\u0002=o\t11\u000b\u001e:j]\u001e\f\u0011b\u00197jK:$\u0018\n\u001a\u0011\u0002\u001dA\u0014\u0018N\\2ja\u0006d7+\u001a:eKV\t\u0001IE\u0002B\t\u001e3AAQ\u0004\u0001\u0001\naAH]3gS:,W.\u001a8u}\u0005y\u0001O]5oG&\u0004\u0018\r\\*fe\u0012,\u0007\u0005\u0005\u00027\u000b&\u0011ai\u000e\u0002\u0007\u001f\nTWm\u0019;\u0011\u0005!#V\"A%\u000b\u0005)[\u0015\u0001B1vi\"T!\u0001T'\u0002\u0011M,7-\u001e:jifT!AT(\u0002\r\r|W.\\8o\u0015\ta\u0002K\u0003\u0002R%\u00061\u0011\r]1dQ\u0016T\u0011aU\u0001\u0004_J<\u0017BA+J\u0005MY\u0015MZ6b!JLgnY5qC2\u001cVM\u001d3f\u0003!iwnY6TK:$W#\u0001-\u0011\u0005e[V\"\u0001.\u000b\u0005ii\u0015B\u0001/[\u00059\u0011\u0015\u0010^3Ck\u001a4WM]*f]\u0012\f\u0011\"\\8dWN+g\u000e\u001a\u0011\u0002#Q,7\u000f^!mi\u0016\u0014(+Z9vKN$8\u000fF\u0001a!\t\u0001\u0013-\u0003\u0002cC\t!QK\\5uQ\tQA\r\u0005\u0002fY6\taM\u0003\u0002hQ\u0006\u0019\u0011\r]5\u000b\u0005%T\u0017a\u00026va&$XM\u001d\u0006\u0003WJ\u000bQA[;oSRL!!\u001c4\u0003\tQ+7\u000f^\u0001\u001di\u0016\u001cH/\u00138de\u0016lWM\u001c;bY\u0006cG/\u001a:SKF,Xm\u001d;tQ\tYA-\u0001\u0012uKN$hj\u001c8BYR,'OU3rk\u0016\u001cHo\u001d(piR\u0013\u0018M\\:g_JlW\r\u001a\u0015\u0003\u0019\u0011\f\u0001\u0003^3ti*\u001bxN\u001c*fcV,7\u000f^:)\u00055!\u0017!\u0013;fgR,eN^3m_B,')^5mIJ+7\u000f]8og\u0016\u001cVM\u001c3TQ>,H\u000e\u001a*fiV\u0014hNT8FeJ|'/\u00134J]:,'OU3ta>t7/\u001a%bg:{WI\u001d:pe\"\u0012a\u0002Z\u0001Wi\u0016\u001cH/\u00128wK2|\u0007/\u001a\"vS2$'+Z:q_:\u001cXmU3oINCw.\u001e7e%\u0016$XO\u001d8O_\u0016\u0013(o\u001c:JM&sg.\u001a:SKN\u0004xN\\:f\u0011\u0006\u001chj\u001c(pi\u000e{g\u000e\u001e:pY2,'/\u0012:s_JD#a\u00043\u0002!R,7\u000f^#om\u0016dw\u000e]3Ck&dGMU3ta>t7/Z*f]\u0012\u001c\u0006n\\;mIJ+G/\u001e:o\u001d>$8i\u001c8ue>dG.\u001a:FeJ|'/\u00134J]:,'OU3ta>t7/\u001a%bg>sW\r\u000b\u0002\u0011I\u0006!\"-^5mI6+G/\u00193bi\u0006\u0014V-];fgR$\u0012\u0001 \t\u0004{\u0006\u0005Q\"\u0001@\u000b\u0005}l\u0015\u0001\u0003:fcV,7\u000f^:\n\u0007\u0005\raPA\bBEN$(/Y2u%\u0016\fX/Z:u\u00039\u0012W/\u001b7e\r>\u0014x/\u0019:e%\u0016\fX/Z:u/&$\b.\u00128wK2|\u0007/\u001a*fcV,7\u000f^!ui\u0006\u001c\u0007.\u001a3\u0015\t\u0005%\u0011q\u0002\t\u0004Y\u0005-\u0011bAA\u0007c\t9!+Z9vKN$\bBBA\t%\u0001\u0007A0A\u0004sKF,Xm\u001d;\u0002\u0017%\u001ch+\u00197jI*\u001bxN\u001c\u000b\u0005\u0003/\ti\u0002E\u0002!\u00033I1!a\u0007\"\u0005\u001d\u0011un\u001c7fC:Dq!a\b\u0014\u0001\u0004\t\t#A\u0002tiJ\u0004B!a\t\u000229!\u0011QEA\u0017!\r\t9#I\u0007\u0003\u0003SQ1!a\u000b\u001e\u0003\u0019a$o\\8u}%\u0019\u0011qF\u0011\u0002\rA\u0013X\rZ3g\u0013\ra\u00141\u0007\u0006\u0004\u0003_\tC\u0003BA\u0005\u0003oAa!!\u000f\u0015\u0001\u0004a\u0018a\u0001:fc\u0006\tb.Z<SKF,Xm\u001d;D_:$X\r\u001f;\u0015\t\u0005}\u0012Q\t\t\u0004{\u0006\u0005\u0013bAA\"}\nq!+Z9vKN$8i\u001c8uKb$\bbBA$+\u0001\u0007\u0011\u0011J\u0001\u0007EV4g-\u001a:\u0011\t\u0005-\u0013\u0011K\u0007\u0003\u0003\u001bR1!a\u0014:\u0003\rq\u0017n\\\u0005\u0005\u0003'\niE\u0001\u0006CsR,')\u001e4gKJ\fQ\u0001^8NCB$B!!\u0017\u0002fAA\u00111LA1\u0003C\t\t#\u0004\u0002\u0002^)\u0019\u0011qL\u0011\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002d\u0005u#aA'ba\"9\u0011q\r\fA\u0002\u0005%\u0014AB2p]\u001aLw\r\u0005\u0003\u0002l\u0005\u0015e\u0002BA7\u0003\u0003sA!a\u001c\u0002\u00009!\u0011\u0011OA?\u001d\u0011\t\u0019(a\u001f\u000f\t\u0005U\u0014\u0011\u0010\b\u0005\u0003O\t9(C\u0001T\u0013\t\t&+\u0003\u0002\u001d!&\u0011ajT\u0005\u0003\u007f6K1!a!\u007f\u0003M\tE\u000e^3s\u0007>tg-[4t%\u0016\fX/Z:u\u0013\u0011\t9)!#\u0003\r\r{gNZ5h\u0015\r\t\u0019I \u000b\u0005\u00033\ni\tC\u0004\u0002h]\u0001\r!a$\u0011\t\u0005E\u0015Q\u0014\b\u0005\u0003'\u000bI*\u0004\u0002\u0002\u0016*\u0019\u0011qS'\u0002\u000f5,7o]1hK&!\u00111TAK\u0003\tJen\u0019:f[\u0016tG/\u00197BYR,'oQ8oM&<7OU3rk\u0016\u001cH\u000fR1uC&!\u0011qTAQ\u0005e\tE\u000e^3sC\ndWmQ8oM&<7i\u001c7mK\u000e$\u0018n\u001c8\u000b\t\u0005m\u0015Q\u0013")
public class RequestChannelTest {
    private final RequestChannel.Metrics requestChannelMetrics = (RequestChannel.Metrics)EasyMock.mock(RequestChannel.Metrics.class);
    private final String clientId;
    private final KafkaPrincipalSerde principalSerde = new KafkaPrincipalSerde(null){

        public byte[] serialize(KafkaPrincipal principal) {
            return Utils.utf8((String)principal.toString());
        }

        public KafkaPrincipal deserialize(byte[] bytes) {
            return SecurityUtils.parseKafkaPrincipal((String)Utils.utf8((byte[])bytes));
        }
    };
    private final ByteBufferSend mockSend = (ByteBufferSend)Mockito.mock(ByteBufferSend.class);

    private RequestChannel.Metrics requestChannelMetrics() {
        return this.requestChannelMetrics;
    }

    private String clientId() {
        return this.clientId;
    }

    private KafkaPrincipalSerde principalSerde() {
        return this.principalSerde;
    }

    private ByteBufferSend mockSend() {
        return this.mockSend;
    }

    @Test
    public void testAlterRequests() {
        String sensitiveValue = "secret";
        ConfigResource brokerResource = new ConfigResource(ConfigResource.Type.BROKER, "1");
        AlterConfigsRequest.ConfigEntry keystorePassword = new AlterConfigsRequest.ConfigEntry("ssl.keystore.password", sensitiveValue);
        this.verifyConfig$1(brokerResource, (Seq)new .colon.colon((Object)keystorePassword, (List)Nil$.MODULE$), (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ssl.keystore.password"), (Object)"[hidden]")})), sensitiveValue);
        AlterConfigsRequest.ConfigEntry keystoreLocation = new AlterConfigsRequest.ConfigEntry("ssl.keystore.location", "/path/to/keystore");
        this.verifyConfig$1(brokerResource, (Seq)new .colon.colon((Object)keystoreLocation, (List)Nil$.MODULE$), (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ssl.keystore.location"), (Object)"/path/to/keystore")})), sensitiveValue);
        this.verifyConfig$1(brokerResource, (Seq)new .colon.colon((Object)keystoreLocation, (List)new .colon.colon((Object)keystorePassword, (List)Nil$.MODULE$)), (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ssl.keystore.location"), (Object)"/path/to/keystore"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ssl.keystore.password"), (Object)"[hidden]")})), sensitiveValue);
        AlterConfigsRequest.ConfigEntry listenerKeyPassword = new AlterConfigsRequest.ConfigEntry(new StringBuilder(39).append("listener.name.internal.").append("ssl.key.password").toString(), sensitiveValue);
        this.verifyConfig$1(brokerResource, (Seq)new .colon.colon((Object)listenerKeyPassword, (List)Nil$.MODULE$), (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)listenerKeyPassword.name()), (Object)"[hidden]")})), sensitiveValue);
        AlterConfigsRequest.ConfigEntry listenerKeystore = new AlterConfigsRequest.ConfigEntry(new StringBuilder(44).append("listener.name.internal.").append("ssl.keystore.location").toString(), "/path/to/keystore");
        this.verifyConfig$1(brokerResource, (Seq)new .colon.colon((Object)listenerKeystore, (List)Nil$.MODULE$), (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)listenerKeystore.name()), (Object)"/path/to/keystore")})), sensitiveValue);
        AlterConfigsRequest.ConfigEntry plainJaasConfig = new AlterConfigsRequest.ConfigEntry(new StringBuilder(45).append("listener.name.internal.plain.").append("sasl.jaas.config").toString(), sensitiveValue);
        this.verifyConfig$1(brokerResource, (Seq)new .colon.colon((Object)plainJaasConfig, (List)Nil$.MODULE$), (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)plainJaasConfig.name()), (Object)"[hidden]")})), sensitiveValue);
        AlterConfigsRequest.ConfigEntry plainLoginCallback = new AlterConfigsRequest.ConfigEntry(new StringBuilder(62).append("listener.name.internal.plain.").append("sasl.login.callback.handler.class").toString(), "test.LoginClass");
        this.verifyConfig$1(brokerResource, (Seq)new .colon.colon((Object)plainLoginCallback, (List)Nil$.MODULE$), (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)plainLoginCallback.name()), (Object)plainLoginCallback.value())})), sensitiveValue);
        AlterConfigsRequest.ConfigEntry customConfig = new AlterConfigsRequest.ConfigEntry("custom.config", sensitiveValue);
        this.verifyConfig$1(brokerResource, (Seq)new .colon.colon((Object)customConfig, (List)Nil$.MODULE$), (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)customConfig.name()), (Object)"[hidden]")})), sensitiveValue);
        ConfigResource topicResource = new ConfigResource(ConfigResource.Type.TOPIC, "testTopic");
        AlterConfigsRequest.ConfigEntry compressionType = new AlterConfigsRequest.ConfigEntry("compression.type", "lz4");
        this.verifyConfig$1(topicResource, (Seq)new .colon.colon((Object)compressionType, (List)Nil$.MODULE$), (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"compression.type"), (Object)"lz4")})), sensitiveValue);
        this.verifyConfig$1(topicResource, (Seq)new .colon.colon((Object)customConfig, (List)Nil$.MODULE$), (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)customConfig.name()), (Object)"[hidden]")})), sensitiveValue);
        RequestChannel.Request alterConfigs = this.request(new AlterConfigsRequest.Builder(Collections.emptyMap(), true).build());
        Assertions.assertEquals(Collections.emptyMap(), (Object)((AlterConfigsRequest)alterConfigs.loggableRequest()).configs());
    }

    @Test
    public void testIncrementalAlterRequests() {
        String sensitiveValue = "secret";
        ConfigResource brokerResource = new ConfigResource(ConfigResource.Type.BROKER, "1");
        Map keystorePassword = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ssl.keystore.password"), (Object)sensitiveValue)}));
        this.verifyConfig$2(brokerResource, AlterConfigOp.OpType.SET, keystorePassword, (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ssl.keystore.password"), (Object)"[hidden]")})), sensitiveValue);
        Map keystoreLocation = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ssl.keystore.location"), (Object)"/path/to/keystore")}));
        this.verifyConfig$2(brokerResource, AlterConfigOp.OpType.SET, keystoreLocation, keystoreLocation, sensitiveValue);
        this.verifyConfig$2(brokerResource, AlterConfigOp.OpType.SET, keystoreLocation.$plus$plus((GenTraversableOnce)keystorePassword), (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ssl.keystore.location"), (Object)"/path/to/keystore"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ssl.keystore.password"), (Object)"[hidden]")})), sensitiveValue);
        Map listenerKeyPassword = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(39).append("listener.name.internal.").append("ssl.key.password").toString()), (Object)sensitiveValue)}));
        this.verifyConfig$2(brokerResource, AlterConfigOp.OpType.SET, listenerKeyPassword, (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(39).append("listener.name.internal.").append("ssl.key.password").toString()), (Object)"[hidden]")})), sensitiveValue);
        Map listenerKeystore = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(44).append("listener.name.internal.").append("ssl.keystore.location").toString()), (Object)"/path/to/keystore")}));
        this.verifyConfig$2(brokerResource, AlterConfigOp.OpType.SET, listenerKeystore, listenerKeystore, sensitiveValue);
        Map plainJaasConfig = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(45).append("listener.name.internal.plain.").append("sasl.jaas.config").toString()), (Object)sensitiveValue)}));
        this.verifyConfig$2(brokerResource, AlterConfigOp.OpType.SET, plainJaasConfig, (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(45).append("listener.name.internal.plain.").append("sasl.jaas.config").toString()), (Object)"[hidden]")})), sensitiveValue);
        Map plainLoginCallback = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(62).append("listener.name.internal.plain.").append("sasl.login.callback.handler.class").toString()), (Object)"test.LoginClass")}));
        this.verifyConfig$2(brokerResource, AlterConfigOp.OpType.SET, plainLoginCallback, plainLoginCallback, sensitiveValue);
        Map sslProtocols = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ssl.enabled.protocols"), (Object)"TLSv1.1")}));
        this.verifyConfig$2(brokerResource, AlterConfigOp.OpType.APPEND, sslProtocols, (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ssl.enabled.protocols"), (Object)"TLSv1.1")})), sensitiveValue);
        this.verifyConfig$2(brokerResource, AlterConfigOp.OpType.SUBTRACT, sslProtocols, (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ssl.enabled.protocols"), (Object)"TLSv1.1")})), sensitiveValue);
        Map cipherSuites = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ssl.cipher.suites"), null)}));
        this.verifyConfig$2(brokerResource, AlterConfigOp.OpType.DELETE, cipherSuites, cipherSuites, sensitiveValue);
        Map customConfig = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"custom.config"), (Object)sensitiveValue)}));
        this.verifyConfig$2(brokerResource, AlterConfigOp.OpType.SET, customConfig, (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"custom.config"), (Object)"[hidden]")})), sensitiveValue);
        ConfigResource topicResource = new ConfigResource(ConfigResource.Type.TOPIC, "testTopic");
        Map compressionType = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"compression.type"), (Object)"lz4")}));
        this.verifyConfig$2(topicResource, AlterConfigOp.OpType.SET, compressionType, compressionType, sensitiveValue);
        this.verifyConfig$2(topicResource, AlterConfigOp.OpType.SET, customConfig, (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"custom.config"), (Object)"[hidden]")})), sensitiveValue);
    }

    @Test
    public void testNonAlterRequestsNotTransformed() {
        RequestChannel.Request metadataRequest = this.request(new MetadataRequest.Builder((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)"topic", (List)Nil$.MODULE$)).asJava(), true).build());
        Assertions.assertSame((Object)metadataRequest.body(ClassTag$.MODULE$.apply(MetadataRequest.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals())), (Object)metadataRequest.loggableRequest());
    }

    @Test
    public void testJsonRequests() {
        String sensitiveValue = "secret";
        ConfigResource resource = new ConfigResource(ConfigResource.Type.BROKER, "1");
        AlterConfigsRequest.ConfigEntry keystorePassword = new AlterConfigsRequest.ConfigEntry("ssl.keystore.password", sensitiveValue);
        .colon.colon entries = new .colon.colon((Object)keystorePassword, (List)Nil$.MODULE$);
        RequestChannel.Request alterConfigs = this.request(new AlterConfigsRequest.Builder(Collections.singletonMap(resource, new AlterConfigsRequest.Config(CollectionConverters$.MODULE$.asJavaCollectionConverter((Iterable)entries).asJavaCollection())), true).build());
        Assertions.assertTrue((boolean)this.isValidJson(RequestConvertToJson$.MODULE$.request(alterConfigs.loggableRequest()).toString()));
    }

    @Test
    public void testEnvelopeBuildResponseSendShouldReturnNoErrorIfInnerResponseHasNoError() {
        RequestChannel.Request channelRequest = this.buildForwardRequestWithEnvelopeRequestAttached(this.buildMetadataRequest());
        ArgumentCaptor envelopeResponseArgumentCaptor = ArgumentCaptor.forClass(EnvelopeResponse.class);
        ((RequestContext)Mockito.doAnswer(x$1 -> this.mockSend()).when((Object)((RequestChannel.Request)channelRequest.envelope().get()).context())).buildResponseSend((AbstractResponse)envelopeResponseArgumentCaptor.capture());
        MetadataResponse responseWithoutError = RequestTestUtils.metadataUpdateWith((int)2, Collections.singletonMap("a", Predef$.MODULE$.int2Integer(2)));
        channelRequest.buildResponseSend((AbstractResponse)responseWithoutError);
        Assertions.assertTrue((boolean)((EnvelopeResponse)envelopeResponseArgumentCaptor.getValue()).error().equals((Object)Errors.NONE));
    }

    @Test
    public void testEnvelopeBuildResponseSendShouldReturnNoErrorIfInnerResponseHasNoNotControllerError() {
        RequestChannel.Request channelRequest = this.buildForwardRequestWithEnvelopeRequestAttached(this.buildMetadataRequest());
        ArgumentCaptor envelopeResponseArgumentCaptor = ArgumentCaptor.forClass(EnvelopeResponse.class);
        ((RequestContext)Mockito.doAnswer(x$2 -> this.mockSend()).when((Object)((RequestChannel.Request)channelRequest.envelope().get()).context())).buildResponseSend((AbstractResponse)envelopeResponseArgumentCaptor.capture());
        MetadataResponse responseWithTimeoutError = RequestTestUtils.metadataUpdateWith((String)"cluster1", (int)2, Collections.singletonMap("a", Errors.REQUEST_TIMED_OUT), Collections.singletonMap("a", Predef$.MODULE$.int2Integer(2)));
        channelRequest.buildResponseSend((AbstractResponse)responseWithTimeoutError);
        Assertions.assertTrue((boolean)((EnvelopeResponse)envelopeResponseArgumentCaptor.getValue()).error().equals((Object)Errors.NONE));
    }

    @Test
    public void testEnvelopeBuildResponseSendShouldReturnNotControllerErrorIfInnerResponseHasOne() {
        RequestChannel.Request channelRequest = this.buildForwardRequestWithEnvelopeRequestAttached(this.buildMetadataRequest());
        ArgumentCaptor envelopeResponseArgumentCaptor = ArgumentCaptor.forClass(EnvelopeResponse.class);
        ((RequestContext)Mockito.doAnswer(x$3 -> this.mockSend()).when((Object)((RequestChannel.Request)channelRequest.envelope().get()).context())).buildResponseSend((AbstractResponse)envelopeResponseArgumentCaptor.capture());
        MetadataResponse responseWithNotControllerError = RequestTestUtils.metadataUpdateWith((String)"cluster1", (int)2, Collections.singletonMap("a", Errors.NOT_CONTROLLER), Collections.singletonMap("a", Predef$.MODULE$.int2Integer(2)));
        channelRequest.buildResponseSend((AbstractResponse)responseWithNotControllerError);
        Assertions.assertTrue((boolean)((EnvelopeResponse)envelopeResponseArgumentCaptor.getValue()).error().equals((Object)Errors.NOT_CONTROLLER));
    }

    private AbstractRequest buildMetadataRequest() {
        String resourceName = "topic-1";
        RequestHeader header = new RequestHeader(ApiKeys.METADATA, ApiKeys.METADATA.latestVersion(), this.clientId(), 0);
        return new MetadataRequest.Builder(Collections.singletonList(resourceName), true).build(header.apiVersion());
    }

    private RequestChannel.Request buildForwardRequestWithEnvelopeRequestAttached(AbstractRequest request) {
        KafkaPrincipalSerde x$2 = this.principalSerde();
        RequestChannel.Metrics x$3 = this.requestChannelMetrics();
        long x$4 = System.nanoTime();
        boolean x$5 = true;
        boolean x$6 = TestUtils$.MODULE$.buildRequestWithEnvelope$default$5();
        Option<RequestChannel.Request> x$7 = TestUtils$.MODULE$.buildRequestWithEnvelope$default$7();
        RequestChannel.Request envelopeRequest = TestUtils$.MODULE$.buildRequestWithEnvelope(request, x$2, x$3, x$4, x$6, x$5, x$7);
        KafkaPrincipalSerde x$9 = this.principalSerde();
        RequestChannel.Metrics x$10 = this.requestChannelMetrics();
        long x$11 = System.nanoTime();
        Option x$12 = Option$.MODULE$.apply((Object)envelopeRequest);
        boolean x$13 = TestUtils$.MODULE$.buildRequestWithEnvelope$default$5();
        boolean x$14 = TestUtils$.MODULE$.buildRequestWithEnvelope$default$6();
        return TestUtils$.MODULE$.buildRequestWithEnvelope(request, x$9, x$10, x$11, x$13, x$14, (Option<RequestChannel.Request>)x$12);
    }

    private boolean isValidJson(String str) {
        try {
            new ObjectMapper().readTree(str);
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public RequestChannel.Request request(AbstractRequest req) {
        ByteBuffer buffer = req.serializeWithHeader(new RequestHeader(req.apiKey(), req.version(), "client-id", 1));
        RequestContext requestContext = this.newRequestContext(buffer);
        return new RequestChannel.Request(1, requestContext, 0L, (MemoryPool)EasyMock.createNiceMock(MemoryPool.class), buffer, (RequestChannel.Metrics)EasyMock.createNiceMock(RequestChannel.Metrics.class), RequestChannel.Request$.MODULE$.$lessinit$greater$default$7());
    }

    private RequestContext newRequestContext(ByteBuffer buffer) {
        return new RequestContext(RequestHeader.parse((ByteBuffer)buffer), "connection-id", InetAddress.getLoopbackAddress(), new KafkaPrincipal("User", "user"), ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT), SecurityProtocol.PLAINTEXT, new ClientInformation("name", "version"), false);
    }

    private Map<String, String> toMap(AlterConfigsRequest.Config config) {
        return ((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(config.entries()).asScala()).map((Function1 & Serializable & scala.Serializable)e -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)e.name()), (Object)e.value()), Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    private Map<String, String> toMap(IncrementalAlterConfigsRequestData.AlterableConfigCollection config) {
        return ((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter((Collection)config).asScala()).map((Function1 & Serializable & scala.Serializable)e -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)e.name()), (Object)e.value()), Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    private final void verifyConfig$1(ConfigResource resource, Seq entries, Map expectedValues, String sensitiveValue$1) {
        RequestChannel.Request alterConfigs = this.request(new AlterConfigsRequest.Builder(Collections.singletonMap(resource, new AlterConfigsRequest.Config(CollectionConverters$.MODULE$.asJavaCollectionConverter((Iterable)entries).asJavaCollection())), true).build());
        AlterConfigsRequest.Config loggedConfig = (AlterConfigsRequest.Config)((AlterConfigsRequest)alterConfigs.loggableRequest()).configs().get(resource);
        Assertions.assertEquals((Object)expectedValues, this.toMap(loggedConfig));
        String alterConfigsDesc = RequestConvertToJson$.MODULE$.requestDesc(alterConfigs.header(), alterConfigs.requestLog(), alterConfigs.isForwarded()).toString();
        Assertions.assertFalse((boolean)alterConfigsDesc.contains(sensitiveValue$1), (String)new StringBuilder(24).append("Sensitive config logged ").append(alterConfigsDesc).toString());
    }

    public static final /* synthetic */ boolean $anonfun$testIncrementalAlterRequests$1(IncrementalAlterConfigsRequestData.AlterableConfigCollection alterableConfigs$1, AlterConfigOp.OpType op$1, Tuple2 x0$1) {
        if (x0$1 == null) {
            throw new MatchError(null);
        }
        String name = (String)x0$1._1();
        String value = (String)x0$1._2();
        boolean bl = alterableConfigs$1.add((ImplicitLinkedHashCollection.Element)new IncrementalAlterConfigsRequestData.AlterableConfig().setName(name).setValue(value).setConfigOperation(op$1.id()));
        return bl;
    }

    private static final IncrementalAlterConfigsRequest incrementalAlterConfigs$1(ConfigResource resource, Map entries, AlterConfigOp.OpType op) {
        IncrementalAlterConfigsRequestData data = new IncrementalAlterConfigsRequestData();
        IncrementalAlterConfigsRequestData.AlterableConfigCollection alterableConfigs = new IncrementalAlterConfigsRequestData.AlterableConfigCollection();
        entries.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)RequestChannelTest.$anonfun$testIncrementalAlterRequests$1(alterableConfigs, op, x0$1)));
        data.resources().add((ImplicitLinkedHashCollection.Element)new IncrementalAlterConfigsRequestData.AlterConfigsResource().setResourceName(resource.name()).setResourceType(resource.type().id()).setConfigs(alterableConfigs));
        return (IncrementalAlterConfigsRequest)new IncrementalAlterConfigsRequest.Builder(data).build();
    }

    private final void verifyConfig$2(ConfigResource resource, AlterConfigOp.OpType op, Map entries, Map expectedValues, String sensitiveValue$2) {
        RequestChannel.Request alterConfigs = this.request((AbstractRequest)RequestChannelTest.incrementalAlterConfigs$1(resource, entries, op));
        IncrementalAlterConfigsRequestData.AlterableConfigCollection loggedConfig = ((IncrementalAlterConfigsRequest)alterConfigs.loggableRequest()).data().resources().find(resource.type().id(), resource.name()).configs();
        Assertions.assertEquals((Object)expectedValues, this.toMap(loggedConfig));
        String alterConfigsDesc = RequestConvertToJson$.MODULE$.requestDesc(alterConfigs.header(), alterConfigs.requestLog(), alterConfigs.isForwarded()).toString();
        Assertions.assertFalse((boolean)alterConfigsDesc.contains(sensitiveValue$2), (String)new StringBuilder(24).append("Sensitive config logged ").append(alterConfigsDesc).toString());
    }

    public RequestChannelTest() {
        this.clientId = "id";
    }
}

