/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.util.Properties;
import kafka.cluster.Broker;
import kafka.cluster.EndPoint;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.server.QuorumTestHarness;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u001d3A!\u0003\u0006\u0001\u001f!)A\u0003\u0001C\u0001+!9q\u0003\u0001b\u0001\n\u0003A\u0002B\u0002\u0014\u0001A\u0003%\u0011\u0004C\u0004(\u0001\t\u0007I\u0011\u0001\u0015\t\r5\u0002\u0001\u0015!\u0003*\u0011\u0015q\u0003\u0001\"\u00110\u0011\u0015\u0001\u0005\u0001\"\u00010\u0011\u0015)\u0005\u0001\"\u00010\u0005M\tEM^3si&\u001cXM\u0011:pW\u0016\u0014H+Z:u\u0015\tYA\"\u0001\u0004tKJ4XM\u001d\u0006\u0002\u001b\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\u0011!\t\t\"#D\u0001\u000b\u0013\t\u0019\"BA\tRk>\u0014X/\u001c+fgRD\u0015M\u001d8fgN\fa\u0001P5oSRtD#\u0001\f\u0011\u0005E\u0001\u0011aB:feZ,'o]\u000b\u00023A\u0019!$I\u0012\u000e\u0003mQ!\u0001H\u000f\u0002\u000f5,H/\u00192mK*\u0011adH\u0001\u000bG>dG.Z2uS>t'\"\u0001\u0011\u0002\u000bM\u001c\u0017\r\\1\n\u0005\tZ\"aC!se\u0006L()\u001e4gKJ\u0004\"!\u0005\u0013\n\u0005\u0015R!aC&bM.\f7+\u001a:wKJ\f\u0001b]3sm\u0016\u00148\u000fI\u0001\tEJ|7.\u001a:JIV\t\u0011\u0006\u0005\u0002+W5\tq$\u0003\u0002-?\t\u0019\u0011J\u001c;\u0002\u0013\t\u0014xn[3s\u0013\u0012\u0004\u0013\u0001\u0003;fCJ$un\u001e8\u0015\u0003A\u0002\"AK\u0019\n\u0005Iz\"\u0001B+oSRD#A\u0002\u001b\u0011\u0005UrT\"\u0001\u001c\u000b\u0005]B\u0014aA1qS*\u0011\u0011HO\u0001\bUV\u0004\u0018\u000e^3s\u0015\tYD(A\u0003kk:LGOC\u0001>\u0003\ry'oZ\u0005\u0003\u007fY\u0012\u0011\"\u00114uKJ,\u0015m\u00195\u0002AQ,7\u000f\u001e\"s_.,'/\u00113wKJ$\u0018n]3MSN$XM\\3sgR{'l\u0013\u0015\u0003\u000f\t\u0003\"!N\"\n\u0005\u00113$\u0001\u0002+fgR\fq\u0006^3ti\n\u0013xn[3s\u0003\u00124XM\u001d;jg\u0016d\u0015n\u001d;f]\u0016\u00148oV5uQ\u000e+8\u000f^8n\u001d\u0006lWm\u001d+p5.C#\u0001\u0003\"")
public class AdvertiseBrokerTest
extends QuorumTestHarness {
    private final ArrayBuffer<KafkaServer> servers = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
    private final int brokerId;

    public ArrayBuffer<KafkaServer> servers() {
        return this.servers;
    }

    public int brokerId() {
        return this.brokerId;
    }

    @Override
    @AfterEach
    public void tearDown() {
        TestUtils$.MODULE$.shutdownServers(this.servers());
        super.tearDown();
    }

    @Test
    public void testBrokerAdvertiseListenersToZK() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(this.brokerId(), this.zkConnect(), false, TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20());
        props.put("advertised.listeners", "PLAINTEXT://routable-listener:3334");
        this.servers().$plus$eq((Object)TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(props), TestUtils$.MODULE$.createServer$default$2()));
        Broker brokerInfo = (Broker)this.zkClient().getBroker(this.brokerId()).get();
        Assertions.assertEquals((int)1, (int)brokerInfo.endPoints().size());
        EndPoint endpoint = (EndPoint)brokerInfo.endPoints().head();
        Assertions.assertEquals((Object)"routable-listener", (Object)endpoint.host());
        Assertions.assertEquals((int)3334, (int)endpoint.port());
        Assertions.assertEquals((Object)SecurityProtocol.PLAINTEXT, (Object)endpoint.securityProtocol());
        Assertions.assertEquals((Object)SecurityProtocol.PLAINTEXT.name, (Object)endpoint.listenerName().value());
    }

    @Test
    public void testBrokerAdvertiseListenersWithCustomNamesToZK() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(this.brokerId(), this.zkConnect(), false, TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20());
        props.put("listeners", "INTERNAL://:0,EXTERNAL://:0");
        props.put("advertised.listeners", "EXTERNAL://external-listener:9999,INTERNAL://internal-listener:10999");
        props.put("listener.security.protocol.map", "INTERNAL:PLAINTEXT,EXTERNAL:PLAINTEXT");
        props.put("inter.broker.listener.name", "INTERNAL");
        this.servers().$plus$eq((Object)TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(props), TestUtils$.MODULE$.createServer$default$2()));
        Broker brokerInfo = (Broker)this.zkClient().getBroker(this.brokerId()).get();
        Assertions.assertEquals((int)2, (int)brokerInfo.endPoints().size());
        EndPoint endpoint = (EndPoint)brokerInfo.endPoints().head();
        Assertions.assertEquals((Object)"external-listener", (Object)endpoint.host());
        Assertions.assertEquals((int)9999, (int)endpoint.port());
        Assertions.assertEquals((Object)SecurityProtocol.PLAINTEXT, (Object)endpoint.securityProtocol());
        Assertions.assertEquals((Object)"EXTERNAL", (Object)endpoint.listenerName().value());
        EndPoint endpoint2 = (EndPoint)brokerInfo.endPoints().apply(1);
        Assertions.assertEquals((Object)"internal-listener", (Object)endpoint2.host());
        Assertions.assertEquals((int)10999, (int)endpoint2.port());
        Assertions.assertEquals((Object)SecurityProtocol.PLAINTEXT, (Object)endpoint.securityProtocol());
        Assertions.assertEquals((Object)"INTERNAL", (Object)endpoint2.listenerName().value());
    }

    public AdvertiseBrokerTest() {
        this.brokerId = 0;
    }
}

