/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import kafka.log.LogManager;
import kafka.log.UnifiedLog;
import kafka.server.BaseRequestTest;
import kafka.server.KafkaServer;
import kafka.utils.NotNothing$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.AlterReplicaLogDirsRequestData;
import org.apache.kafka.common.message.AlterReplicaLogDirsResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AlterReplicaLogDirsRequest;
import org.apache.kafka.common.requests.AlterReplicaLogDirsResponse;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.Map;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction1;
import scala.util.Random$;

@ScalaSignature(bytes="\u0006\u0001A4A\u0001D\u0007\u0001%!)q\u0003\u0001C\u00011!9!\u0004\u0001b\u0001\n\u0003Z\u0002B\u0002\u0012\u0001A\u0003%A\u0004C\u0004$\u0001\t\u0007I\u0011I\u000e\t\r\u0011\u0002\u0001\u0015!\u0003\u001d\u0011\u001d)\u0003A1A\u0005\u0002\u0019Baa\f\u0001!\u0002\u00139\u0003\"\u0002\u0019\u0001\t\u0013\t\u0004\"B'\u0001\t\u0003q\u0005\"B/\u0001\t\u0003q\u0005\"B0\u0001\t\u0013\u0001'AH!mi\u0016\u0014(+\u001a9mS\u000e\fGj\\4ESJ\u001c(+Z9vKN$H+Z:u\u0015\tqq\"\u0001\u0004tKJ4XM\u001d\u0006\u0002!\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\u0014!\t!R#D\u0001\u000e\u0013\t1RBA\bCCN,'+Z9vKN$H+Z:u\u0003\u0019a\u0014N\\5u}Q\t\u0011\u0004\u0005\u0002\u0015\u0001\u0005YAn\\4ESJ\u001cu.\u001e8u+\u0005a\u0002CA\u000f!\u001b\u0005q\"\"A\u0010\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0005r\"aA%oi\u0006aAn\\4ESJ\u001cu.\u001e8uA\u0005Y!M]8lKJ\u001cu.\u001e8u\u00031\u0011'o\\6fe\u000e{WO\u001c;!\u0003\u0015!x\u000e]5d+\u00059\u0003C\u0001\u0015.\u001b\u0005I#B\u0001\u0016,\u0003\u0011a\u0017M\\4\u000b\u00031\nAA[1wC&\u0011a&\u000b\u0002\u0007'R\u0014\u0018N\\4\u0002\rQ|\u0007/[2!\u0003U1\u0017N\u001c3FeJ|'OR8s!\u0006\u0014H/\u001b;j_:$2AM H!\t\u0019T(D\u00015\u0015\t)d'\u0001\u0005qe>$xnY8m\u0015\t9\u0004(\u0001\u0004d_6lwN\u001c\u0006\u0003!eR!AO\u001e\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005a\u0014aA8sO&\u0011a\b\u000e\u0002\u0007\u000bJ\u0014xN]:\t\u000b\u0001C\u0001\u0019A!\u0002\u0011I,7\u000f]8og\u0016\u0004\"AQ#\u000e\u0003\rS!\u0001\u0012\u001c\u0002\u0011I,\u0017/^3tiNL!AR\"\u00037\u0005cG/\u001a:SKBd\u0017nY1M_\u001e$\u0015N]:SKN\u0004xN\\:f\u0011\u0015A\u0005\u00021\u0001J\u0003\t!\b\u000f\u0005\u0002K\u00176\ta'\u0003\u0002Mm\tqAk\u001c9jGB\u000b'\u000f^5uS>t\u0017A\b;fgR\fE\u000e^3s%\u0016\u0004H.[2b\u0019><G)\u001b:t%\u0016\fX/Z:u)\u0005y\u0005CA\u000fQ\u0013\t\tfD\u0001\u0003V]&$\bFA\u0005T!\t!6,D\u0001V\u0015\t1v+A\u0002ba&T!\u0001W-\u0002\u000f),\b/\u001b;fe*\u0011!lO\u0001\u0006UVt\u0017\u000e^\u0005\u00039V\u0013A\u0001V3ti\u00069C/Z:u\u00032$XM\u001d*fa2L7-\u0019'pO\u0012K'o\u001d*fcV,7\u000f^#se>\u00148i\u001c3fQ\tQ1+\u0001\u0010tK:$\u0017\t\u001c;feJ+\u0007\u000f\\5dC2{w\rR5sgJ+\u0017/^3tiR\u0011\u0011)\u0019\u0005\u0006E.\u0001\raY\u0001\u000ea\u0006\u0014H/\u001b;j_:$\u0015N]:\u0011\t\u0011\\\u0017J\u001c\b\u0003K&\u0004\"A\u001a\u0010\u000e\u0003\u001dT!\u0001[\t\u0002\rq\u0012xn\u001c;?\u0013\tQg$\u0001\u0004Qe\u0016$WMZ\u0005\u0003Y6\u00141!T1q\u0015\tQg\u0004\u0005\u0002e_&\u0011a&\u001c")
public class AlterReplicaLogDirsRequestTest
extends BaseRequestTest {
    private final int logDirCount;
    private final int brokerCount;
    private final String topic;

    @Override
    public int logDirCount() {
        return this.logDirCount;
    }

    @Override
    public int brokerCount() {
        return this.brokerCount;
    }

    public String topic() {
        return this.topic;
    }

    private Errors findErrorForPartition(AlterReplicaLogDirsResponse response, TopicPartition tp) {
        return Errors.forCode((short)((AlterReplicaLogDirsResponseData.AlterReplicaLogDirPartitionResult)((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(((AlterReplicaLogDirsResponseData.AlterReplicaLogDirTopicResult)((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(response.data().results()).asScala()).find((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToBoolean((boolean)AlterReplicaLogDirsRequestTest.$anonfun$findErrorForPartition$1(tp, x))).get()).partitions()).asScala()).find((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)AlterReplicaLogDirsRequestTest.$anonfun$findErrorForPartition$2(tp, p))).get()).errorCode());
    }

    @Test
    public void testAlterReplicaLogDirsRequest() {
        int partitionNum = 5;
        String logDir1 = new File((String)((KafkaServer)this.servers().head()).config().logDirs().apply(Random$.MODULE$.nextInt(this.logDirCount()))).getAbsolutePath();
        Map partitionDirs1 = ((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), partitionNum).map((Function1 & Serializable & scala.Serializable)partition -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(this.topic(), BoxesRunTime.unboxToInt((Object)partition))), (Object)logDir1), IndexedSeq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        AlterReplicaLogDirsResponse alterReplicaLogDirsResponse1 = this.sendAlterReplicaLogDirsRequest((Map<TopicPartition, String>)partitionDirs1);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), partitionNum).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)partition -> {
            TopicPartition tp = new TopicPartition(this.topic(), partition);
            Assertions.assertEquals((Object)Errors.UNKNOWN_TOPIC_OR_PARTITION, (Object)this.findErrorForPartition(alterReplicaLogDirsResponse1, tp));
            LogManager qual$1 = ((KafkaServer)this.servers().head()).logManager();
            boolean x$2 = qual$1.getLog$default$2();
            Assertions.assertTrue((boolean)qual$1.getLog(tp, x$2).isEmpty());
        });
        this.createTopic(this.topic(), partitionNum, 1, this.createTopic$default$4(), this.createTopic$default$5());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), partitionNum).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)partition -> {
            LogManager qual$2 = ((KafkaServer)this.servers().head()).logManager();
            TopicPartition x$3 = new TopicPartition(this.topic(), partition);
            boolean x$4 = qual$2.getLog$default$2();
            Assertions.assertEquals((Object)logDir1, (Object)((UnifiedLog)qual$2.getLog(x$3, x$4).get()).dir().getParent());
        });
        String logDir2 = new File((String)((KafkaServer)this.servers().head()).config().logDirs().apply(Random$.MODULE$.nextInt(this.logDirCount()))).getAbsolutePath();
        Map partitionDirs2 = ((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), partitionNum).map((Function1 & Serializable & scala.Serializable)partition -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(this.topic(), BoxesRunTime.unboxToInt((Object)partition))), (Object)logDir2), IndexedSeq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        AlterReplicaLogDirsResponse alterReplicaLogDirsResponse2 = this.sendAlterReplicaLogDirsRequest((Map<TopicPartition, String>)partitionDirs2);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), partitionNum).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)partition -> {
            TopicPartition tp = new TopicPartition(this.topic(), partition);
            Assertions.assertEquals((Object)Errors.NONE, (Object)this.findErrorForPartition(alterReplicaLogDirsResponse2, tp));
            long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
            long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
            if (TestUtils$.MODULE$ == null) {
                throw null;
            }
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!AlterReplicaLogDirsRequestTest.$anonfun$testAlterReplicaLogDirsRequest$6(this, logDir2, partition)) {
                void waitUntilTrue_pause;
                void waitUntilTrue_waitTimeMs;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)AlterReplicaLogDirsRequestTest.$anonfun$testAlterReplicaLogDirsRequest$7());
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testAlterReplicaLogDirsRequestErrorCode() {
        String offlineDir = new File((String)((IterableLike)((KafkaServer)this.servers().head()).config().logDirs().tail()).head()).getAbsolutePath();
        String validDir1 = new File((String)((KafkaServer)this.servers().head()).config().logDirs().apply(1)).getAbsolutePath();
        String validDir2 = new File((String)((KafkaServer)this.servers().head()).config().logDirs().apply(2)).getAbsolutePath();
        String validDir3 = new File((String)((KafkaServer)this.servers().head()).config().logDirs().apply(3)).getAbsolutePath();
        scala.collection.mutable.Map partitionDirs1 = Map$.MODULE$.empty();
        partitionDirs1.put((Object)new TopicPartition(this.topic(), 0), (Object)"invalidDir");
        partitionDirs1.put((Object)new TopicPartition(this.topic(), 1), (Object)validDir1);
        AlterReplicaLogDirsResponse alterReplicaDirResponse1 = this.sendAlterReplicaLogDirsRequest((Map<TopicPartition, String>)partitionDirs1.toMap(Predef$.MODULE$.$conforms()));
        Assertions.assertEquals((Object)Errors.LOG_DIR_NOT_FOUND, (Object)this.findErrorForPartition(alterReplicaDirResponse1, new TopicPartition(this.topic(), 0)));
        Assertions.assertEquals((Object)Errors.UNKNOWN_TOPIC_OR_PARTITION, (Object)this.findErrorForPartition(alterReplicaDirResponse1, new TopicPartition(this.topic(), 1)));
        this.createTopic(this.topic(), 3, 1, this.createTopic$default$4(), this.createTopic$default$5());
        scala.collection.mutable.Map partitionDirs2 = Map$.MODULE$.empty();
        partitionDirs2.put((Object)new TopicPartition(this.topic(), 0), (Object)"invalidDir");
        partitionDirs2.put((Object)new TopicPartition(this.topic(), 1), (Object)validDir2);
        AlterReplicaLogDirsResponse alterReplicaDirResponse2 = this.sendAlterReplicaLogDirsRequest((Map<TopicPartition, String>)partitionDirs2.toMap(Predef$.MODULE$.$conforms()));
        Assertions.assertEquals((Object)Errors.LOG_DIR_NOT_FOUND, (Object)this.findErrorForPartition(alterReplicaDirResponse2, new TopicPartition(this.topic(), 0)));
        Assertions.assertEquals((Object)Errors.NONE, (Object)this.findErrorForPartition(alterReplicaDirResponse2, new TopicPartition(this.topic(), 1)));
        ((KafkaServer)this.servers().head()).logDirFailureChannel().maybeAddOfflineLogDir(offlineDir, (Function0 & Serializable & scala.Serializable)() -> "", new IOException());
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = 3000L;
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!AlterReplicaLogDirsRequestTest.$anonfun$testAlterReplicaLogDirsRequestErrorCode$2(this, offlineDir)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)AlterReplicaLogDirsRequestTest.$anonfun$testAlterReplicaLogDirsRequestErrorCode$3(offlineDir));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        scala.collection.mutable.Map partitionDirs3 = Map$.MODULE$.empty();
        partitionDirs3.put((Object)new TopicPartition(this.topic(), 0), (Object)"invalidDir");
        partitionDirs3.put((Object)new TopicPartition(this.topic(), 1), (Object)validDir3);
        partitionDirs3.put((Object)new TopicPartition(this.topic(), 2), (Object)offlineDir);
        AlterReplicaLogDirsResponse alterReplicaDirResponse3 = this.sendAlterReplicaLogDirsRequest((Map<TopicPartition, String>)partitionDirs3.toMap(Predef$.MODULE$.$conforms()));
        Assertions.assertEquals((Object)Errors.LOG_DIR_NOT_FOUND, (Object)this.findErrorForPartition(alterReplicaDirResponse3, new TopicPartition(this.topic(), 0)));
        Assertions.assertEquals((Object)Errors.KAFKA_STORAGE_ERROR, (Object)this.findErrorForPartition(alterReplicaDirResponse3, new TopicPartition(this.topic(), 1)));
        Assertions.assertEquals((Object)Errors.KAFKA_STORAGE_ERROR, (Object)this.findErrorForPartition(alterReplicaDirResponse3, new TopicPartition(this.topic(), 2)));
    }

    private AlterReplicaLogDirsResponse sendAlterReplicaLogDirsRequest(Map<TopicPartition, String> partitionDirs) {
        scala.collection.immutable.Iterable logDirs = (scala.collection.immutable.Iterable)partitionDirs.groupBy((Function1 & Serializable & scala.Serializable)x0$1 -> {
            void var1_1;
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            String dir = (String)x0$1._2();
            return var1_1;
        }).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            if (x0$2 == null) {
                throw new MatchError(null);
            }
            String dir = (String)x0$2._1();
            Map tps = (Map)x0$2._2();
            AlterReplicaLogDirsRequestData.AlterReplicaLogDir alterReplicaLogDir = new AlterReplicaLogDirsRequestData.AlterReplicaLogDir().setPath(dir).setTopics(new AlterReplicaLogDirsRequestData.AlterReplicaLogDirTopicCollection(((List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableOnce)tps.groupBy((Function1 & Serializable & scala.Serializable)x0$3 -> {
                if (x0$3 == null) {
                    throw new MatchError(null);
                }
                String string = ((TopicPartition)x0$3._1()).topic();
                return string;
            }).map((Function1 & Serializable & scala.Serializable)x0$4 -> {
                if (x0$4 == null) {
                    throw new MatchError(null);
                }
                String topic = (String)x0$4._1();
                Map tpPartitions = (Map)x0$4._2();
                AlterReplicaLogDirsRequestData.AlterReplicaLogDirTopic alterReplicaLogDirTopic = new AlterReplicaLogDirsRequestData.AlterReplicaLogDirTopic().setName(topic).setPartitions((List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableOnce)tpPartitions.map((Function1 & Serializable & scala.Serializable)x0$5 -> {
                    if (x0$5 == null) {
                        throw new MatchError(null);
                    }
                    Integer n = BoxesRunTime.boxToInteger((int)((TopicPartition)x0$5._1()).partition());
                    return n;
                }, Iterable$.MODULE$.canBuildFrom())).toList()).asJava());
                return alterReplicaLogDirTopic;
            }, Iterable$.MODULE$.canBuildFrom())).toList()).asJava()).iterator()));
            return alterReplicaLogDir;
        }, Iterable$.MODULE$.canBuildFrom());
        AlterReplicaLogDirsRequestData data = new AlterReplicaLogDirsRequestData().setDirs(new AlterReplicaLogDirsRequestData.AlterReplicaLogDirCollection(((java.lang.Iterable)CollectionConverters$.MODULE$.asJavaIterableConverter((Iterable)logDirs).asJava()).iterator()));
        AlterReplicaLogDirsRequest request = (AlterReplicaLogDirsRequest)new AlterReplicaLogDirsRequest.Builder(data).build();
        return (AlterReplicaLogDirsResponse)this.connectAndReceive((AbstractRequest)request, this.controllerSocketServer(), this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(AlterReplicaLogDirsResponse.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals()));
    }

    public static final /* synthetic */ boolean $anonfun$findErrorForPartition$1(TopicPartition tp$1, AlterReplicaLogDirsResponseData.AlterReplicaLogDirTopicResult x) {
        String string = x.topicName();
        String string2 = tp$1.topic();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$findErrorForPartition$2(TopicPartition tp$1, AlterReplicaLogDirsResponseData.AlterReplicaLogDirPartitionResult p) {
        return p.partitionIndex() == tp$1.partition();
    }

    public static final /* synthetic */ boolean $anonfun$testAlterReplicaLogDirsRequest$6(AlterReplicaLogDirsRequestTest $this, String logDir2$1, int partition$1) {
        String string = logDir2$1;
        LogManager qual$3 = ((KafkaServer)$this.servers().head()).logManager();
        TopicPartition x$5 = new TopicPartition($this.topic(), partition$1);
        boolean x$6 = qual$3.getLog$default$2();
        String string2 = ((UnifiedLog)qual$3.getLog(x$5, x$6).get()).dir().getParent();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ String $anonfun$testAlterReplicaLogDirsRequest$7() {
        return "timed out waiting for replica movement";
    }

    public static final /* synthetic */ boolean $anonfun$testAlterReplicaLogDirsRequestErrorCode$2(AlterReplicaLogDirsRequestTest $this, String offlineDir$1) {
        return !((KafkaServer)$this.servers().head()).logManager().isLogDirOnline(offlineDir$1);
    }

    public static final /* synthetic */ String $anonfun$testAlterReplicaLogDirsRequestErrorCode$3(String offlineDir$1) {
        return new StringBuilder(36).append("timed out waiting for ").append(offlineDir$1).append(" to be offline").toString();
    }

    public AlterReplicaLogDirsRequestTest() {
        this.logDirCount = 5;
        this.brokerCount = 1;
        this.topic = "topic";
    }
}

