/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.IOException;
import java.io.Serializable;
import kafka.network.SocketServer;
import kafka.server.IntegrationTestUtils$;
import kafka.server.KafkaRaftServer$;
import kafka.test.ClusterInstance;
import kafka.test.annotation.ClusterTest;
import kafka.test.annotation.ClusterTestDefaults;
import kafka.test.annotation.Type;
import kafka.test.junit.ClusterTestExtensions;
import kafka.utils.NotNothing;
import kafka.utils.NotNothing$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.DescribeQuorumResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.ApiVersionsRequest;
import org.apache.kafka.common.requests.ApiVersionsResponse;
import org.apache.kafka.common.requests.DescribeQuorumRequest;
import org.apache.kafka.common.requests.DescribeQuorumResponse;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.extension.ExtendWith;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.collection.IterableLike;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ExtendWith(value={ClusterTestExtensions.class})
@ClusterTestDefaults(clusterType=Type.KRAFT)
@Tag(value="integration")
@ScalaSignature(bytes="\u0006\u0001\u0005%a\u0001\u0002\u0004\b\u00011A\u0001b\u0005\u0001\u0003\u0002\u0003\u0006I\u0001\u0006\u0005\u00065\u0001!\ta\u0007\u0005\u0006?\u0001!\t\u0001\t\u0005\u0006c\u0001!\t\u0001\t\u0005\u0006g\u0001!I\u0001\u000e\u0002\u001a\t\u0016\u001c8M]5cKF+xN];n%\u0016\fX/Z:u)\u0016\u001cHO\u0003\u0002\t\u0013\u000511/\u001a:wKJT\u0011AC\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001Q\u0002\u0005\u0002\u000f#5\tqBC\u0001\u0011\u0003\u0015\u00198-\u00197b\u0013\t\u0011rB\u0001\u0004B]f\u0014VMZ\u0001\bG2,8\u000f^3s!\t)\u0002$D\u0001\u0017\u0015\t9\u0012\"\u0001\u0003uKN$\u0018BA\r\u0017\u0005=\u0019E.^:uKJLen\u001d;b]\u000e,\u0017A\u0002\u001fj]&$h\b\u0006\u0002\u001d=A\u0011Q\u0004A\u0007\u0002\u000f!)1C\u0001a\u0001)\u0005IC/Z:u\t\u0016\u001c8M]5cKF+xN];n\u001d>$8+\u001e9q_J$X\r\u001a\"z5.\u0014%o\\6feN$\u0012!\t\t\u0003\u001d\tJ!aI\b\u0003\tUs\u0017\u000e\u001e\u0015\u0005\u0007\u0015ZC\u0006\u0005\u0002'S5\tqE\u0003\u0002)-\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\u0005):#aC\"mkN$XM\u001d+fgR\f1b\u00197vgR,'\u000fV=qK\u0012\nQ&\u0003\u0002/_\u0005\u0011!l\u0013\u0006\u0003a\u001d\nA\u0001V=qK\u0006\u0011B/Z:u\t\u0016\u001c8M]5cKF+xN];nQ\t!Q%A\td_:tWm\u0019;B]\u0012\u0014VmY3jm\u0016,\"!N\u001d\u0015\u0005YbFcA\u001cM)B\u0011\u0001(\u000f\u0007\u0001\t\u0015QTA1\u0001<\u0005\u0005!\u0016C\u0001\u001f@!\tqQ(\u0003\u0002?\u001f\t9aj\u001c;iS:<\u0007C\u0001!K\u001b\u0005\t%B\u0001\"D\u0003!\u0011X-];fgR\u001c(B\u0001#F\u0003\u0019\u0019w.\\7p]*\u0011!B\u0012\u0006\u0003\u000f\"\u000ba!\u00199bG\",'\"A%\u0002\u0007=\u0014x-\u0003\u0002L\u0003\n\u0001\u0012IY:ue\u0006\u001cGOU3ta>t7/\u001a\u0005\u0006\u001b\u0016\u0001\u001dAT\u0001\tG2\f7o\u001d+bOB\u0019qJU\u001c\u000e\u0003AS!!U\b\u0002\u000fI,g\r\\3di&\u00111\u000b\u0015\u0002\t\u00072\f7o\u001d+bO\")Q+\u0002a\u0002-\u0006\u0011aN\u001c\t\u0004/j;T\"\u0001-\u000b\u0005eK\u0011!B;uS2\u001c\u0018BA.Y\u0005)qu\u000e\u001e(pi\"Lgn\u001a\u0005\u0006;\u0016\u0001\rAX\u0001\be\u0016\fX/Z:u!\t\u0001u,\u0003\u0002a\u0003\ny\u0011IY:ue\u0006\u001cGOU3rk\u0016\u001cH\u000f\u000b\u0003\u0001E2l\u0007CA2k\u001b\u0005!'BA3g\u0003\r\t\u0007/\u001b\u0006\u0003O\"\fqA[;qSR,'O\u0003\u0002j\u0011\u0006)!.\u001e8ji&\u00111\u000e\u001a\u0002\u0004)\u0006<\u0017!\u0002<bYV,\u0017%\u00018\u0002\u0017%tG/Z4sCRLwN\u001c\u0015\u0005\u0001A\\3\u000f\u0005\u0002'c&\u0011!o\n\u0002\u0014\u00072,8\u000f^3s)\u0016\u001cH\u000fR3gCVdGo\u001d\u0013\u0002i&\u0011QoL\u0001\u0006\u0017J\u000be\t\u0016\u0015\u0005\u0001]dW\u0010\u0005\u0002yw6\t\u0011P\u0003\u0002{I\u0006IQ\r\u001f;f]NLwN\\\u0005\u0003yf\u0014!\"\u0012=uK:$w+\u001b;iY\u0005q8%A@\u0011\t\u0005\u0005\u0011QA\u0007\u0003\u0003\u0007Q!!\u001b\f\n\t\u0005\u001d\u00111\u0001\u0002\u0016\u00072,8\u000f^3s)\u0016\u001cH/\u0012=uK:\u001c\u0018n\u001c8t\u0001")
public class DescribeQuorumRequestTest {
    private final ClusterInstance cluster;

    @ClusterTest(clusterType=Type.ZK)
    public void testDescribeQuorumNotSupportedByZkBrokers() {
        ApiVersionsRequest apiRequest = (ApiVersionsRequest)new ApiVersionsRequest.Builder().build();
        Assertions.assertNull((Object)((ApiVersionsResponse)this.connectAndReceive((AbstractRequest)apiRequest, ClassTag$.MODULE$.apply(ApiVersionsResponse.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals()))).apiVersion(ApiKeys.DESCRIBE_QUORUM.id));
        DescribeQuorumRequest describeQuorumRequest = (DescribeQuorumRequest)new DescribeQuorumRequest.Builder(DescribeQuorumRequest.singletonRequest((TopicPartition)KafkaRaftServer$.MODULE$.MetadataPartition())).build();
        Assertions.assertThrows(IOException.class, () -> this.connectAndReceive((AbstractRequest)describeQuorumRequest, ClassTag$.MODULE$.apply(DescribeQuorumResponse.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals())));
    }

    @ClusterTest
    public void testDescribeQuorum() {
        DescribeQuorumRequest request = (DescribeQuorumRequest)new DescribeQuorumRequest.Builder(DescribeQuorumRequest.singletonRequest((TopicPartition)KafkaRaftServer$.MODULE$.MetadataPartition())).build();
        DescribeQuorumResponse response = (DescribeQuorumResponse)this.connectAndReceive((AbstractRequest)request, ClassTag$.MODULE$.apply(DescribeQuorumResponse.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals()));
        Assertions.assertEquals((Object)Errors.NONE, (Object)Errors.forCode((short)response.data().errorCode()));
        Assertions.assertEquals((int)1, (int)response.data().topics().size());
        DescribeQuorumResponseData.TopicData topicData = (DescribeQuorumResponseData.TopicData)response.data().topics().get(0);
        Assertions.assertEquals((Object)KafkaRaftServer$.MODULE$.MetadataTopic(), (Object)topicData.topicName());
        Assertions.assertEquals((int)1, (int)topicData.partitions().size());
        DescribeQuorumResponseData.PartitionData partitionData = (DescribeQuorumResponseData.PartitionData)topicData.partitions().get(0);
        Assertions.assertEquals((int)KafkaRaftServer$.MODULE$.MetadataPartition().partition(), (int)partitionData.partitionIndex());
        Assertions.assertEquals((Object)Errors.NONE, (Object)Errors.forCode((short)partitionData.errorCode()));
        Assertions.assertTrue((partitionData.leaderEpoch() > 0 ? 1 : 0) != 0);
        int leaderId = partitionData.leaderId();
        Assertions.assertTrue((leaderId > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((((DescribeQuorumResponseData.ReplicaState)((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(partitionData.currentVoters()).asScala()).find((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)DescribeQuorumRequestTest.$anonfun$testDescribeQuorum$1(leaderId, x$1))).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new AssertionError((Object)"Failed to find leader among current voter states");
        })).logEndOffset() > 0L ? 1 : 0) != 0);
    }

    private <T extends AbstractResponse> T connectAndReceive(AbstractRequest request, ClassTag<T> classTag, NotNothing<T> nn) {
        return IntegrationTestUtils$.MODULE$.connectAndReceive(request, (SocketServer)((IterableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(this.cluster.brokerSocketServers()).asScala()).head(), this.cluster.clientListener(), classTag, nn);
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeQuorum$1(int leaderId$1, DescribeQuorumResponseData.ReplicaState x$1) {
        return x$1.replicaId() == leaderId$1;
    }

    public DescribeQuorumRequestTest(ClusterInstance cluster) {
        this.cluster = cluster;
    }
}

