/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.Serializable;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import kafka.network.SocketServer;
import kafka.utils.Implicits;
import kafka.utils.Implicits$;
import kafka.utils.NotNothing;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.Mode;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.requests.ResponseHeader;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Utils;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.compat.MapExtensionMethods$;
import scala.collection.compat.package$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

public final class IntegrationTestUtils$ {
    public static IntegrationTestUtils$ MODULE$;
    private int correlationId;

    static {
        new IntegrationTestUtils$();
    }

    public void sendRequest(Socket socket, byte[] request) {
        DataOutputStream outgoing = new DataOutputStream(socket.getOutputStream());
        outgoing.writeInt(request.length);
        outgoing.write(request);
        outgoing.flush();
    }

    private void sendWithHeader(AbstractRequest request, RequestHeader header, Socket socket) {
        byte[] serializedBytes = Utils.toArray((ByteBuffer)request.serializeWithHeader(header));
        this.sendRequest(socket, serializedBytes);
    }

    public <T extends AbstractResponse> RequestHeader nextRequestHeader(ApiKeys apiKey, short apiVersion, String clientId, Option<Object> correlationIdOpt) {
        int correlationId = BoxesRunTime.unboxToInt((Object)correlationIdOpt.getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> {
            MODULE$.correlationId_$eq(MODULE$.correlationId() + 1);
            return MODULE$.correlationId();
        }));
        return new RequestHeader(apiKey, apiVersion, clientId, correlationId);
    }

    public <T extends AbstractResponse> String nextRequestHeader$default$3() {
        return "client-id";
    }

    public <T extends AbstractResponse> Option<Object> nextRequestHeader$default$4() {
        return None$.MODULE$;
    }

    public void send(AbstractRequest request, Socket socket, String clientId, Option<Object> correlationId) {
        RequestHeader header = this.nextRequestHeader(request.apiKey(), request.version(), clientId, correlationId);
        this.sendWithHeader(request, header, socket);
    }

    public String send$default$3() {
        return "client-id";
    }

    public Option<Object> send$default$4() {
        return None$.MODULE$;
    }

    public <T extends AbstractResponse> T receive(Socket socket, ApiKeys apiKey, short version, ClassTag<T> classTag, NotNothing<T> nn) {
        DataInputStream incoming = new DataInputStream(socket.getInputStream());
        byte[] responseBytes = new byte[incoming.readInt()];
        incoming.readFully(responseBytes);
        ByteBuffer responseBuffer = ByteBuffer.wrap(responseBytes);
        ResponseHeader.parse((ByteBuffer)responseBuffer, (short)apiKey.responseHeaderVersion(version));
        AbstractResponse abstractResponse = AbstractResponse.parseResponse((ApiKeys)apiKey, (ByteBuffer)responseBuffer, (short)version);
        Option option = classTag.unapply((Object)abstractResponse);
        if (option.isEmpty() || option.get() == null) {
            throw new ClassCastException(new StringBuilder(40).append("Expected response with type ").append(classTag.runtimeClass()).append(", but found ").append(abstractResponse.getClass()).toString());
        }
        return (T)abstractResponse;
    }

    public <T extends AbstractResponse> T sendAndReceive(AbstractRequest request, Socket socket, String clientId, Option<Object> correlationId, ClassTag<T> classTag, NotNothing<T> nn) {
        this.send(request, socket, clientId, correlationId);
        return this.receive(socket, request.apiKey(), request.version(), classTag, nn);
    }

    public <T extends AbstractResponse> String sendAndReceive$default$3() {
        return "client-id";
    }

    public <T extends AbstractResponse> Option<Object> sendAndReceive$default$4() {
        return None$.MODULE$;
    }

    public <T extends AbstractResponse> T connectAndReceive(AbstractRequest request, SocketServer destination, ListenerName listenerName, ClassTag<T> classTag, NotNothing<T> nn) {
        T t;
        try (Socket socket = this.connect(destination, listenerName);){
            t = this.sendAndReceive(request, socket, this.sendAndReceive$default$3(), this.sendAndReceive$default$4(), classTag, nn);
        }
        return t;
    }

    public void createTopic(Admin admin, String topic, int numPartitions, short replicationFactor) {
        List<NewTopic> newTopics = Collections.singletonList(new NewTopic(topic, numPartitions, replicationFactor));
        admin.createTopics(newTopics).all().get();
    }

    /*
     * WARNING - void declaration
     */
    public void createTopic(Admin admin, String topic, scala.collection.immutable.Map<Object, Seq<Object>> replicaAssignment) {
        void forKeyValue$extension_f;
        void forKeyValue$extension_$this;
        HashMap javaAssignment = new HashMap();
        Function2 & Serializable & scala.Serializable intersect = (Function2 & Serializable & scala.Serializable)(partitionId, assignment) -> IntegrationTestUtils$.$anonfun$createTopic$1(javaAssignment, BoxesRunTime.unboxToInt((Object)partitionId), assignment);
        Map map = Implicits$.MODULE$.MapExtensionMethods(replicaAssignment);
        if (Implicits.MapExtensionMethods$.MODULE$ == null) {
            throw null;
        }
        MapExtensionMethods$.MODULE$.foreachEntry$extension(package$.MODULE$.toMapExtensionMethods((Map)forKeyValue$extension_$this), (arg_0, arg_1) -> Implicits.MapExtensionMethods$.$anonfun$forKeyValue$1((Function2)forKeyValue$extension_f, arg_0, arg_1));
        List<NewTopic> newTopics = Collections.singletonList(new NewTopic(topic, javaAssignment));
        admin.createTopics(newTopics).all().get();
    }

    public SecurityProtocol securityProtocol() {
        return SecurityProtocol.PLAINTEXT;
    }

    private int correlationId() {
        return this.correlationId;
    }

    private void correlationId_$eq(int x$1) {
        this.correlationId = x$1;
    }

    public Socket connect(SocketServer socketServer, ListenerName listenerName) {
        return new Socket("localhost", socketServer.boundPort(listenerName));
    }

    public Properties clientSecurityProps(String certAlias) {
        return TestUtils$.MODULE$.securityConfigs(Mode.CLIENT, this.securityProtocol(), (Option<File>)None$.MODULE$, certAlias, TestUtils$.MODULE$.SslCertificateCn(), (Option<Properties>)None$.MODULE$, TestUtils$.MODULE$.securityConfigs$default$7(), TestUtils$.MODULE$.securityConfigs$default$8());
    }

    public static final /* synthetic */ Integer $anonfun$createTopic$2(int x) {
        return BoxesRunTime.boxToInteger((int)x);
    }

    public static final /* synthetic */ List $anonfun$createTopic$1(HashMap javaAssignment$1, int partitionId, Seq assignment) {
        return (List)javaAssignment$1.put(Predef$.MODULE$.int2Integer(partitionId), CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)assignment.map((Function1 & Serializable & scala.Serializable)x -> IntegrationTestUtils$.$anonfun$createTopic$2(BoxesRunTime.unboxToInt((Object)x)), Seq$.MODULE$.canBuildFrom())).asJava());
    }

    private IntegrationTestUtils$() {
        MODULE$ = this;
        this.correlationId = 0;
    }
}

