/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.cluster.Partition;
import kafka.log.LogManager;
import kafka.log.LogOffsetSnapshot;
import kafka.log.UnifiedLog;
import kafka.server.AlterIsrManager;
import kafka.server.BrokerTopicStats;
import kafka.server.DelayedFetch;
import kafka.server.FetchDataInfo;
import kafka.server.FetchDataInfo$;
import kafka.server.FetchHighWatermark$;
import kafka.server.FetchIsolation;
import kafka.server.FetchLogEnd$;
import kafka.server.FetchMetadata;
import kafka.server.FetchPartitionStatus;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.LogDirFailureChannel;
import kafka.server.LogOffsetMetadata;
import kafka.server.LogOffsetMetadata$;
import kafka.server.LogReadResult;
import kafka.server.MetadataCache;
import kafka.server.MetadataCache$;
import kafka.server.QuotaFactory;
import kafka.server.QuotaFactory$;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaManager$;
import kafka.server.ReplicaQuota;
import kafka.server.metadata.ZkMetadataCache;
import kafka.utils.KafkaScheduler;
import kafka.utils.MockTime;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.utils.Time;
import org.easymock.EasyMock;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\tea\u0001\u0002\u0015*\u00019BQ!\u000e\u0001\u0005\u0002YBq!\u000f\u0001C\u0002\u0013\u0005!\b\u0003\u0004E\u0001\u0001\u0006Ia\u000f\u0005\b\u000b\u0002\u0011\r\u0011\"\u0001G\u0011\u0019i\u0005\u0001)A\u0005\u000f\"9a\n\u0001b\u0001\n\u0003y\u0005B\u0002/\u0001A\u0003%\u0001\u000bC\u0004^\u0001\t\u0007I\u0011\u00010\t\r\u0011\u0004\u0001\u0015!\u0003`\u0011\u001d)\u0007A1A\u0005\u0002\u0019Daa\u001b\u0001!\u0002\u00139\u0007b\u00027\u0001\u0005\u0004%\tA\u001a\u0005\u0007[\u0002\u0001\u000b\u0011B4\t\u000f9\u0004!\u0019!C\u0001_\"11\u000f\u0001Q\u0001\nADq\u0001\u001e\u0001C\u0002\u0013\u0005Q\u000fC\u0004\u0002\n\u0001\u0001\u000b\u0011\u0002<\t\u0013\u0005-\u0001A1A\u0005\u0002\u00055\u0001\u0002CA\u000b\u0001\u0001\u0006I!a\u0004\t\u0013\u0005]\u0001A1A\u0005\u0002\u00055\u0001\u0002CA\r\u0001\u0001\u0006I!a\u0004\t\u0013\u0005m\u0001A1A\u0005\u0002\u0005u\u0001\u0002CA*\u0001\u0001\u0006I!a\b\t\u0017\u0005U\u0003\u00011AA\u0002\u0013\u0005\u0011q\u000b\u0005\f\u0003_\u0002\u0001\u0019!a\u0001\n\u0003\t\t\bC\u0006\u0002~\u0001\u0001\r\u0011!Q!\n\u0005e\u0003bCA@\u0001\u0001\u0007\t\u0019!C\u0001\u0003\u0003C1\"!#\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0002\f\"Y\u0011q\u0012\u0001A\u0002\u0003\u0005\u000b\u0015BAB\u0011\u001d\t\t\n\u0001C\u0001\u0003'Cq!a+\u0001\t\u0003\t\u0019\nC\u0004\u00020\u0002!\t!a%\t\u000f\u0005M\u0006\u0001\"\u0001\u0002\u0014\"9\u0011q\u0017\u0001\u0005\u0002\u0005M\u0005bBA^\u0001\u0011\u0005\u0011Q\u0018\u0005\n\u0003;\u0004\u0011\u0013!C\u0001\u0003?D\u0011\"!>\u0001#\u0003%\t!a>\t\u000f\u0005m\b\u0001\"\u0001\u0002\u0014\"9!Q\u0001\u0001\u0005\u0002\t\u001d!\u0001\u0007*fa2L7-Y'b]\u0006<WM])v_R\f7\u000fV3ti*\u0011!fK\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u00031\nQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001_A\u0011\u0001gM\u0007\u0002c)\t!'A\u0003tG\u0006d\u0017-\u0003\u00025c\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#A\u001c\u0011\u0005a\u0002Q\"A\u0015\u0002\u000f\r|gNZ5hgV\t1\bE\u0002=\u007f\u0005k\u0011!\u0010\u0006\u0003}E\n!bY8mY\u0016\u001cG/[8o\u0013\t\u0001UHA\u0002TKF\u0004\"\u0001\u000f\"\n\u0005\rK#aC&bM.\f7i\u001c8gS\u001e\f\u0001bY8oM&<7\u000fI\u0001\u0005i&lW-F\u0001H!\tA5*D\u0001J\u0015\tQ5&A\u0003vi&d7/\u0003\u0002M\u0013\nAQj\\2l)&lW-A\u0003uS6,\u0007%A\u0004nKR\u0014\u0018nY:\u0016\u0003A\u0003\"!\u0015.\u000e\u0003IS!AT*\u000b\u0005Q+\u0016AB2p[6|gN\u0003\u0002--*\u0011q\u000bW\u0001\u0007CB\f7\r[3\u000b\u0003e\u000b1a\u001c:h\u0013\tY&KA\u0004NKR\u0014\u0018nY:\u0002\u00115,GO]5dg\u0002\naA]3d_J$W#A0\u0011\u0005\u0001\u0014W\"A1\u000b\u0005u\u001b\u0016BA2b\u00051\u0019\u0016.\u001c9mKJ+7m\u001c:e\u0003\u001d\u0011XmY8sI\u0002\nq\u0002^8qS\u000e\u0004\u0016M\u001d;ji&|g.M\u000b\u0002OB\u0011\u0001.[\u0007\u0002'&\u0011!n\u0015\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0003A!x\u000e]5d!\u0006\u0014H/\u001b;j_:\f\u0004%A\bu_BL7\rU1si&$\u0018n\u001c83\u0003A!x\u000e]5d!\u0006\u0014H/\u001b;j_:\u0014\u0004%A\u0004u_BL7-\u00133\u0016\u0003A\u0004\"\u0001[9\n\u0005I\u001c&\u0001B+vS\u0012\f\u0001\u0002^8qS\u000eLE\rI\u0001\ti>\u0004\u0018nY%egV\ta\u000f\u0005\u0003xyz\u0004X\"\u0001=\u000b\u0005eT\u0018\u0001B;uS2T\u0011a_\u0001\u0005U\u00064\u0018-\u0003\u0002~q\n\u0019Q*\u00199\u0011\u0007}\f)!\u0004\u0002\u0002\u0002)\u0019\u00111\u0001>\u0002\t1\fgnZ\u0005\u0005\u0003\u000f\t\tA\u0001\u0004TiJLgnZ\u0001\ni>\u0004\u0018nY%eg\u0002\n\u0011\u0003^8qS\u000eLE\rU1si&$\u0018n\u001c82+\t\ty\u0001E\u0002i\u0003#I1!a\u0005T\u0005A!v\u000e]5d\u0013\u0012\u0004\u0016M\u001d;ji&|g.\u0001\nu_BL7-\u00133QCJ$\u0018\u000e^5p]F\u0002\u0013!\u0005;pa&\u001c\u0017\n\u001a)beRLG/[8oe\u0005\u0011Bo\u001c9jG&#\u0007+\u0019:uSRLwN\u001c\u001a!\u0003%1W\r^2i\u0013:4w.\u0006\u0002\u0002 A!AhPA\u0011!\u001d\u0001\u00141EA\b\u0003OI1!!\n2\u0005\u0019!V\u000f\u001d7feA!\u0011\u0011FA'\u001d\u0011\tY#a\u0012\u000f\t\u00055\u00121\t\b\u0005\u0003_\t\tE\u0004\u0003\u00022\u0005}b\u0002BA\u001a\u0003{qA!!\u000e\u0002<5\u0011\u0011q\u0007\u0006\u0004\u0003si\u0013A\u0002\u001fs_>$h(C\u0001Z\u0013\t9\u0006,\u0003\u0002--&\u0011A+V\u0005\u0004\u0003\u000b\u001a\u0016\u0001\u0003:fcV,7\u000f^:\n\t\u0005%\u00131J\u0001\r\r\u0016$8\r\u001b*fcV,7\u000f\u001e\u0006\u0004\u0003\u000b\u001a\u0016\u0002BA(\u0003#\u0012Q\u0002U1si&$\u0018n\u001c8ECR\f'\u0002BA%\u0003\u0017\n!BZ3uG\"LeNZ8!\u00031\tXo\u001c;b\u001b\u0006t\u0017mZ3s+\t\tI\u0006\u0005\u0003\u0002\\\u0005%d\u0002BA/\u0003KrA!a\u0018\u0002d9!\u0011QGA1\u0013\u0005a\u0013B\u0001\u0016,\u0013\r\t9'K\u0001\r#V|G/\u0019$bGR|'/_\u0005\u0005\u0003W\niGA\u0007Rk>$\u0018-T1oC\u001e,'o\u001d\u0006\u0004\u0003OJ\u0013\u0001E9v_R\fW*\u00198bO\u0016\u0014x\fJ3r)\u0011\t\u0019(!\u001f\u0011\u0007A\n)(C\u0002\u0002xE\u0012A!\u00168ji\"I\u00111P\r\u0002\u0002\u0003\u0007\u0011\u0011L\u0001\u0004q\u0012\n\u0014!D9v_R\fW*\u00198bO\u0016\u0014\b%\u0001\bsKBd\u0017nY1NC:\fw-\u001a:\u0016\u0005\u0005\r\u0005c\u0001\u001d\u0002\u0006&\u0019\u0011qQ\u0015\u0003\u001dI+\u0007\u000f\\5dC6\u000bg.Y4fe\u0006\u0011\"/\u001a9mS\u000e\fW*\u00198bO\u0016\u0014x\fJ3r)\u0011\t\u0019(!$\t\u0013\u0005mD$!AA\u0002\u0005\r\u0015a\u0004:fa2L7-Y'b]\u0006<WM\u001d\u0011\u0002UMDw.\u001e7e\u000bb\u001cG.\u001e3f'V\u00147/Z9vK:$H\u000b\u001b:piRdW\r\u001a)beRLG/[8ogR\u0011\u00111\u000f\u0015\u0004=\u0005]\u0005\u0003BAM\u0003Ok!!a'\u000b\t\u0005u\u0015qT\u0001\u0004CBL'\u0002BAQ\u0003G\u000bqA[;qSR,'OC\u0002\u0002&b\u000bQA[;oSRLA!!+\u0002\u001c\n!A+Z:u\u0003e\u001a\bn\\;mI\u001e+GOT8NKN\u001c\u0018mZ3t\u0013\u001a\fVo\u001c;bg\u0016C8-Z3eK\u0012|enU;cg\u0016\fX/\u001a8u!\u0006\u0014H/\u001b;j_:\u001c\bfA\u0010\u0002\u0018\u0006\u00113\u000f[8vY\u0012<U\r\u001e\"pi\"lUm]:bO\u0016\u001c\u0018JZ)v_R\f7/\u00117m_^D3\u0001IAL\u0003\u0011\u001a\bn\\;mI&s7\r\\;eK&s7+\u001f8d)\"\u0014x\u000e\u001e;mK\u0012\u0014V\r\u001d7jG\u0006\u001c\bfA\u0011\u0002\u0018\u0006yC/Z:u\u0007>l\u0007\u000f\\3uK&sG)\u001a7bs\u0016$g)\u001a;dQ^KG\u000f\u001b*fa2L7-\u0019+ie>$H\u000f\\5oO\"\u001a!%a&\u0002\u0015M,G/\u00169N_\u000e\\7\u000f\u0006\u0005\u0002t\u0005}\u0016\u0011[Aj\u0011\u001d\tYb\ta\u0001\u0003\u0003\u0004b!a1\u0002N\u0006\u0005b\u0002BAc\u0003\u0013tA!!\u000e\u0002H&\t!'C\u0002\u0002LF\nq\u0001]1dW\u0006<W-C\u0002A\u0003\u001fT1!a32\u0011\u001di6\u0005%AA\u0002}C\u0011\"!6$!\u0003\u0005\r!a6\u0002%\t|G\u000f\u001b*fa2L7-Y:J]NKhn\u0019\t\u0004a\u0005e\u0017bAAnc\t9!i\\8mK\u0006t\u0017\u0001F:fiV\u0003Xj\\2lg\u0012\"WMZ1vYR$#'\u0006\u0002\u0002b*\u001aq,a9,\u0005\u0005\u0015\b\u0003BAt\u0003cl!!!;\u000b\t\u0005-\u0018Q^\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a<2\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003g\fIOA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fAc]3u+BlunY6tI\u0011,g-Y;mi\u0012\u001aTCAA}U\u0011\t9.a9\u0002\u0011Q,\u0017M\u001d#po:D3AJA\u0000!\u0011\tIJ!\u0001\n\t\t\r\u00111\u0014\u0002\n\u0003\u001a$XM]#bG\"\f\u0011\"\\8dWF+x\u000e^1\u0015\t\t%!q\u0002\t\u0004q\t-\u0011b\u0001B\u0007S\ta!+\u001a9mS\u000e\f\u0017+^8uC\"9!\u0011C\u0014A\u0002\tM\u0011!\u00022pk:$\u0007c\u0001\u0019\u0003\u0016%\u0019!qC\u0019\u0003\t1{gn\u001a")
public class ReplicaManagerQuotasTest {
    private final Seq<KafkaConfig> configs = (Seq)TestUtils$.MODULE$.createBrokerConfigs(2, TestUtils$.MODULE$.MockZkConnect(), TestUtils$.MODULE$.createBrokerConfigs$default$3(), TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13(), TestUtils$.MODULE$.createBrokerConfigs$default$14(), TestUtils$.MODULE$.createBrokerConfigs$default$15(), TestUtils$.MODULE$.createBrokerConfigs$default$16(), TestUtils$.MODULE$.createBrokerConfigs$default$17()).map((Function1 & Serializable & scala.Serializable)x$1 -> KafkaConfig$.MODULE$.fromProps(x$1, new Properties()), Seq$.MODULE$.canBuildFrom());
    private final MockTime time = new MockTime();
    private final Metrics metrics = new Metrics();
    private final SimpleRecord record = new SimpleRecord("some-data-in-a-message".getBytes());
    private final TopicPartition topicPartition1 = new TopicPartition("test-topic", 1);
    private final TopicPartition topicPartition2 = new TopicPartition("test-topic", 2);
    private final Uuid topicId = Uuid.randomUuid();
    private final Map<String, Uuid> topicIds = Collections.singletonMap("test-topic", this.topicId());
    private final TopicIdPartition topicIdPartition1 = new TopicIdPartition(this.topicId(), this.topicPartition1());
    private final TopicIdPartition topicIdPartition2 = new TopicIdPartition(this.topicId(), this.topicPartition2());
    private final Seq<Tuple2<TopicIdPartition, FetchRequest.PartitionData>> fetchInfo = new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicIdPartition1()), (Object)new FetchRequest.PartitionData(Uuid.ZERO_UUID, 0L, 0L, 100, Optional.empty())), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicIdPartition2()), (Object)new FetchRequest.PartitionData(Uuid.ZERO_UUID, 0L, 0L, 100, Optional.empty())), (List)Nil$.MODULE$));
    private QuotaFactory.QuotaManagers quotaManager;
    private ReplicaManager replicaManager;

    public Seq<KafkaConfig> configs() {
        return this.configs;
    }

    public MockTime time() {
        return this.time;
    }

    public Metrics metrics() {
        return this.metrics;
    }

    public SimpleRecord record() {
        return this.record;
    }

    public TopicPartition topicPartition1() {
        return this.topicPartition1;
    }

    public TopicPartition topicPartition2() {
        return this.topicPartition2;
    }

    public Uuid topicId() {
        return this.topicId;
    }

    public Map<String, Uuid> topicIds() {
        return this.topicIds;
    }

    public TopicIdPartition topicIdPartition1() {
        return this.topicIdPartition1;
    }

    public TopicIdPartition topicIdPartition2() {
        return this.topicIdPartition2;
    }

    public Seq<Tuple2<TopicIdPartition, FetchRequest.PartitionData>> fetchInfo() {
        return this.fetchInfo;
    }

    public QuotaFactory.QuotaManagers quotaManager() {
        return this.quotaManager;
    }

    public void quotaManager_$eq(QuotaFactory.QuotaManagers x$1) {
        this.quotaManager = x$1;
    }

    public ReplicaManager replicaManager() {
        return this.replicaManager;
    }

    public void replicaManager_$eq(ReplicaManager x$1) {
        this.replicaManager = x$1;
    }

    @Test
    public void shouldExcludeSubsequentThrottledPartitions() {
        this.setUpMocks(this.fetchInfo(), this.setUpMocks$default$2(), this.setUpMocks$default$3());
        int followerReplicaId = ((KafkaConfig)this.configs().last()).brokerId();
        ReplicaQuota quota = this.mockQuota(1000000L);
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)quota.isQuotaExceeded())).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)false)).once();
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)quota.isQuotaExceeded())).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)true)).once();
        EasyMock.replay((Object[])new Object[]{quota});
        Seq fetch = this.replicaManager().readFromLocalLog(followerReplicaId, true, (FetchIsolation)FetchHighWatermark$.MODULE$, Integer.MAX_VALUE, false, this.fetchInfo(), quota, (Option)None$.MODULE$);
        Assertions.assertEquals((int)1, (int)((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(((LogReadResult)((Tuple2)fetch.find((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)ReplicaManagerQuotasTest.$anonfun$shouldExcludeSubsequentThrottledPartitions$1(this, x$2))).get())._2()).info().records().batches()).asScala()).size(), (String)"Given two partitions, with only one throttled, we should get the first");
        Assertions.assertEquals((int)0, (int)((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(((LogReadResult)((Tuple2)fetch.find((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)ReplicaManagerQuotasTest.$anonfun$shouldExcludeSubsequentThrottledPartitions$2(this, x$3))).get())._2()).info().records().batches()).asScala()).size(), (String)"But we shouldn't get the second");
    }

    @Test
    public void shouldGetNoMessagesIfQuotasExceededOnSubsequentPartitions() {
        this.setUpMocks(this.fetchInfo(), this.setUpMocks$default$2(), this.setUpMocks$default$3());
        int followerReplicaId = ((KafkaConfig)this.configs().last()).brokerId();
        ReplicaQuota quota = this.mockQuota(1000000L);
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)quota.isQuotaExceeded())).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)true)).once();
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)quota.isQuotaExceeded())).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)true)).once();
        EasyMock.replay((Object[])new Object[]{quota});
        Seq fetch = this.replicaManager().readFromLocalLog(followerReplicaId, true, (FetchIsolation)FetchHighWatermark$.MODULE$, Integer.MAX_VALUE, false, this.fetchInfo(), quota, (Option)None$.MODULE$);
        Assertions.assertEquals((int)0, (int)((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(((LogReadResult)((Tuple2)fetch.find((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)ReplicaManagerQuotasTest.$anonfun$shouldGetNoMessagesIfQuotasExceededOnSubsequentPartitions$1(this, x$4))).get())._2()).info().records().batches()).asScala()).size(), (String)"Given two partitions, with both throttled, we should get no messages");
        Assertions.assertEquals((int)0, (int)((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(((LogReadResult)((Tuple2)fetch.find((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)ReplicaManagerQuotasTest.$anonfun$shouldGetNoMessagesIfQuotasExceededOnSubsequentPartitions$2(this, x$5))).get())._2()).info().records().batches()).asScala()).size(), (String)"Given two partitions, with both throttled, we should get no messages");
    }

    @Test
    public void shouldGetBothMessagesIfQuotasAllow() {
        this.setUpMocks(this.fetchInfo(), this.setUpMocks$default$2(), this.setUpMocks$default$3());
        int followerReplicaId = ((KafkaConfig)this.configs().last()).brokerId();
        ReplicaQuota quota = this.mockQuota(1000000L);
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)quota.isQuotaExceeded())).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)false)).once();
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)quota.isQuotaExceeded())).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)false)).once();
        EasyMock.replay((Object[])new Object[]{quota});
        Seq fetch = this.replicaManager().readFromLocalLog(followerReplicaId, true, (FetchIsolation)FetchHighWatermark$.MODULE$, Integer.MAX_VALUE, false, this.fetchInfo(), quota, (Option)None$.MODULE$);
        Assertions.assertEquals((int)1, (int)((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(((LogReadResult)((Tuple2)fetch.find((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)ReplicaManagerQuotasTest.$anonfun$shouldGetBothMessagesIfQuotasAllow$1(this, x$6))).get())._2()).info().records().batches()).asScala()).size(), (String)"Given two partitions, with both non-throttled, we should get both messages");
        Assertions.assertEquals((int)1, (int)((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(((LogReadResult)((Tuple2)fetch.find((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)ReplicaManagerQuotasTest.$anonfun$shouldGetBothMessagesIfQuotasAllow$2(this, x$7))).get())._2()).info().records().batches()).asScala()).size(), (String)"Given two partitions, with both non-throttled, we should get both messages");
    }

    @Test
    public void shouldIncludeInSyncThrottledReplicas() {
        Seq<Tuple2<TopicIdPartition, FetchRequest.PartitionData>> x$1 = this.fetchInfo();
        boolean x$2 = true;
        SimpleRecord x$3 = this.setUpMocks$default$2();
        this.setUpMocks(x$1, x$3, x$2);
        int followerReplicaId = ((KafkaConfig)this.configs().last()).brokerId();
        ReplicaQuota quota = this.mockQuota(1000000L);
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)quota.isQuotaExceeded())).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)false)).once();
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)quota.isQuotaExceeded())).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)true)).once();
        EasyMock.replay((Object[])new Object[]{quota});
        Seq fetch = this.replicaManager().readFromLocalLog(followerReplicaId, true, (FetchIsolation)FetchHighWatermark$.MODULE$, Integer.MAX_VALUE, false, this.fetchInfo(), quota, (Option)None$.MODULE$);
        Assertions.assertEquals((int)1, (int)((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(((LogReadResult)((Tuple2)fetch.find((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)ReplicaManagerQuotasTest.$anonfun$shouldIncludeInSyncThrottledReplicas$1(this, x$8))).get())._2()).info().records().batches()).asScala()).size(), (String)"Given two partitions, with only one throttled, we should get the first");
        Assertions.assertEquals((int)1, (int)((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(((LogReadResult)((Tuple2)fetch.find((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)ReplicaManagerQuotasTest.$anonfun$shouldIncludeInSyncThrottledReplicas$2(this, x$9))).get())._2()).info().records().batches()).asScala()).size(), (String)"But we should get the second too since it's throttled but in sync");
    }

    @Test
    public void testCompleteInDelayedFetchWithReplicaThrottling() {
        Assertions.assertTrue((boolean)ReplicaManagerQuotasTest.setupDelayedFetch$1(true).tryComplete(), (String)"In sync replica should complete");
        Assertions.assertFalse((boolean)ReplicaManagerQuotasTest.setupDelayedFetch$1(false).tryComplete(), (String)"Out of sync replica should not complete");
    }

    public void setUpMocks(Seq<Tuple2<TopicIdPartition, FetchRequest.PartitionData>> fetchInfo, SimpleRecord record, boolean bothReplicasInSync) {
        KafkaScheduler scheduler = (KafkaScheduler)EasyMock.createNiceMock(KafkaScheduler.class);
        UnifiedLog log = (UnifiedLog)EasyMock.createNiceMock(UnifiedLog.class);
        EasyMock.expect((Object)BoxesRunTime.boxToLong((long)log.logStartOffset())).andReturn((Object)BoxesRunTime.boxToLong((long)0L)).anyTimes();
        EasyMock.expect((Object)BoxesRunTime.boxToLong((long)log.logEndOffset())).andReturn((Object)BoxesRunTime.boxToLong((long)20L)).anyTimes();
        EasyMock.expect((Object)BoxesRunTime.boxToLong((long)log.highWatermark())).andReturn((Object)BoxesRunTime.boxToLong((long)5L)).anyTimes();
        EasyMock.expect((Object)BoxesRunTime.boxToLong((long)log.lastStableOffset())).andReturn((Object)BoxesRunTime.boxToLong((long)5L)).anyTimes();
        EasyMock.expect((Object)log.logEndOffsetMetadata()).andReturn((Object)new LogOffsetMetadata(20L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3())).anyTimes();
        EasyMock.expect((Object)log.topicId()).andReturn((Object)new Some((Object)this.topicId())).anyTimes();
        EasyMock.expect((Object)log.read(BoxesRunTime.unboxToLong((Object)EasyMock.anyObject()), EasyMock.geq((int)1), (FetchIsolation)EasyMock.anyObject(), EasyMock.anyBoolean())).andReturn((Object)new FetchDataInfo(new LogOffsetMetadata(0L, 0L, 0), (Records)MemoryRecords.withRecords((CompressionType)CompressionType.NONE, (SimpleRecord[])new SimpleRecord[]{record}), FetchDataInfo$.MODULE$.apply$default$3(), FetchDataInfo$.MODULE$.apply$default$4())).anyTimes();
        EasyMock.expect((Object)log.read(BoxesRunTime.unboxToLong((Object)EasyMock.anyObject()), EasyMock.eq((int)0), (FetchIsolation)EasyMock.anyObject(), EasyMock.anyBoolean())).andReturn((Object)new FetchDataInfo(new LogOffsetMetadata(0L, 0L, 0), (Records)MemoryRecords.EMPTY, FetchDataInfo$.MODULE$.apply$default$3(), FetchDataInfo$.MODULE$.apply$default$4())).anyTimes();
        EasyMock.replay((Object[])new Object[]{log});
        LogManager logManager = (LogManager)EasyMock.createMock(LogManager.class);
        EasyMock.expect((Object)logManager.getLog((TopicPartition)EasyMock.anyObject(), EasyMock.anyBoolean())).andReturn((Object)new Some((Object)log)).anyTimes();
        EasyMock.expect((Object)logManager.liveLogDirs()).andReturn((Object)Predef$.MODULE$.wrapRefArray((Object[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(File.class)))).anyTimes();
        EasyMock.replay((Object[])new Object[]{logManager});
        AlterIsrManager alterIsrManager = (AlterIsrManager)EasyMock.createMock(AlterIsrManager.class);
        int leaderBrokerId = ((KafkaConfig)this.configs().head()).brokerId();
        this.quotaManager_$eq(QuotaFactory$.MODULE$.instantiate((KafkaConfig)this.configs().head(), this.metrics(), (Time)this.time(), ""));
        Metrics x$1 = this.metrics();
        KafkaConfig x$2 = (KafkaConfig)this.configs().head();
        MockTime x$3 = this.time();
        QuotaFactory.QuotaManagers x$6 = this.quotaManager();
        ZkMetadataCache x$7 = MetadataCache$.MODULE$.zkMetadataCache(leaderBrokerId);
        LogDirFailureChannel x$8 = new LogDirFailureChannel(((KafkaConfig)this.configs().head()).logDirs().size());
        BrokerTopicStats x$102 = ReplicaManager$.MODULE$.$lessinit$greater$default$10();
        AtomicBoolean x$11 = ReplicaManager$.MODULE$.$lessinit$greater$default$11();
        Option x$12 = ReplicaManager$.MODULE$.$lessinit$greater$default$12();
        Option x$13 = ReplicaManager$.MODULE$.$lessinit$greater$default$13();
        Option x$14 = ReplicaManager$.MODULE$.$lessinit$greater$default$14();
        Option x$15 = ReplicaManager$.MODULE$.$lessinit$greater$default$15();
        Option x$16 = ReplicaManager$.MODULE$.$lessinit$greater$default$16();
        Option x$17 = ReplicaManager$.MODULE$.$lessinit$greater$default$17();
        this.replicaManager_$eq(new ReplicaManager(x$2, x$1, (Time)x$3, (Scheduler)scheduler, logManager, x$6, (MetadataCache)x$7, x$8, alterIsrManager, x$102, x$11, x$12, x$13, x$14, x$15, x$16, x$17));
        fetchInfo.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$1 != null))).foreach((Function1 & Serializable & scala.Serializable)x$10 -> {
            ReplicaManagerQuotasTest.$anonfun$setUpMocks$2(this, log, leaderBrokerId, bothReplicasInSync, x$10);
            return BoxedUnit.UNIT;
        });
    }

    public SimpleRecord setUpMocks$default$2() {
        return this.record();
    }

    public boolean setUpMocks$default$3() {
        return false;
    }

    @AfterEach
    public void tearDown() {
        Option$.MODULE$.apply((Object)this.replicaManager()).foreach((Function1 & Serializable & scala.Serializable)x$11 -> {
            x$11.shutdown(false);
            return BoxedUnit.UNIT;
        });
        Option$.MODULE$.apply((Object)this.quotaManager()).foreach((Function1 & Serializable & scala.Serializable)x$12 -> {
            x$12.shutdown();
            return BoxedUnit.UNIT;
        });
        this.metrics().close();
    }

    /*
     * WARNING - void declaration
     */
    public ReplicaQuota mockQuota(long bound) {
        void var3_2;
        ReplicaQuota quota = (ReplicaQuota)EasyMock.createMock(ReplicaQuota.class);
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)quota.isThrottled((TopicPartition)EasyMock.anyObject()))).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)true)).anyTimes();
        return var3_2;
    }

    public static final /* synthetic */ boolean $anonfun$shouldExcludeSubsequentThrottledPartitions$1(ReplicaManagerQuotasTest $this, Tuple2 x$2) {
        Object object = x$2._1();
        TopicIdPartition topicIdPartition = $this.topicIdPartition1();
        return !(object != null ? !object.equals(topicIdPartition) : topicIdPartition != null);
    }

    public static final /* synthetic */ boolean $anonfun$shouldExcludeSubsequentThrottledPartitions$2(ReplicaManagerQuotasTest $this, Tuple2 x$3) {
        Object object = x$3._1();
        TopicIdPartition topicIdPartition = $this.topicIdPartition2();
        return !(object != null ? !object.equals(topicIdPartition) : topicIdPartition != null);
    }

    public static final /* synthetic */ boolean $anonfun$shouldGetNoMessagesIfQuotasExceededOnSubsequentPartitions$1(ReplicaManagerQuotasTest $this, Tuple2 x$4) {
        Object object = x$4._1();
        TopicIdPartition topicIdPartition = $this.topicIdPartition1();
        return !(object != null ? !object.equals(topicIdPartition) : topicIdPartition != null);
    }

    public static final /* synthetic */ boolean $anonfun$shouldGetNoMessagesIfQuotasExceededOnSubsequentPartitions$2(ReplicaManagerQuotasTest $this, Tuple2 x$5) {
        Object object = x$5._1();
        TopicIdPartition topicIdPartition = $this.topicIdPartition2();
        return !(object != null ? !object.equals(topicIdPartition) : topicIdPartition != null);
    }

    public static final /* synthetic */ boolean $anonfun$shouldGetBothMessagesIfQuotasAllow$1(ReplicaManagerQuotasTest $this, Tuple2 x$6) {
        Object object = x$6._1();
        TopicIdPartition topicIdPartition = $this.topicIdPartition1();
        return !(object != null ? !object.equals(topicIdPartition) : topicIdPartition != null);
    }

    public static final /* synthetic */ boolean $anonfun$shouldGetBothMessagesIfQuotasAllow$2(ReplicaManagerQuotasTest $this, Tuple2 x$7) {
        Object object = x$7._1();
        TopicIdPartition topicIdPartition = $this.topicIdPartition2();
        return !(object != null ? !object.equals(topicIdPartition) : topicIdPartition != null);
    }

    public static final /* synthetic */ boolean $anonfun$shouldIncludeInSyncThrottledReplicas$1(ReplicaManagerQuotasTest $this, Tuple2 x$8) {
        Object object = x$8._1();
        TopicIdPartition topicIdPartition = $this.topicIdPartition1();
        return !(object != null ? !object.equals(topicIdPartition) : topicIdPartition != null);
    }

    public static final /* synthetic */ boolean $anonfun$shouldIncludeInSyncThrottledReplicas$2(ReplicaManagerQuotasTest $this, Tuple2 x$9) {
        Object object = x$9._1();
        TopicIdPartition topicIdPartition = $this.topicIdPartition2();
        return !(object != null ? !object.equals(topicIdPartition) : topicIdPartition != null);
    }

    private static final DelayedFetch setupDelayedFetch$1(boolean isReplicaInSync) {
        LogOffsetMetadata endOffsetMetadata = new LogOffsetMetadata(100L, 0L, 500);
        Partition partition = (Partition)EasyMock.createMock(Partition.class);
        LogOffsetSnapshot offsetSnapshot = new LogOffsetSnapshot(0L, endOffsetMetadata, endOffsetMetadata, endOffsetMetadata);
        EasyMock.expect((Object)partition.fetchOffsetSnapshot(Optional.empty(), true)).andReturn((Object)offsetSnapshot);
        ReplicaManager replicaManager = (ReplicaManager)EasyMock.createMock(ReplicaManager.class);
        EasyMock.expect((Object)replicaManager.getPartitionOrException((TopicPartition)EasyMock.anyObject())).andReturn((Object)partition).anyTimes();
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)replicaManager.shouldLeaderThrottle((ReplicaQuota)EasyMock.anyObject(), (Partition)EasyMock.anyObject(), BoxesRunTime.unboxToInt((Object)EasyMock.anyObject())))).andReturn((Object)BoxesRunTime.boxToBoolean((!isReplicaInSync ? 1 : 0) != 0)).anyTimes();
        EasyMock.expect((Object)partition.getReplica(1)).andReturn((Object)None$.MODULE$);
        EasyMock.replay((Object[])new Object[]{replicaManager, partition});
        TopicIdPartition tp = new TopicIdPartition(Uuid.randomUuid(), new TopicPartition("t1", 0));
        FetchPartitionStatus fetchPartitionStatus = new FetchPartitionStatus(new LogOffsetMetadata(50L, 0L, 250), new FetchRequest.PartitionData(Uuid.ZERO_UUID, 50L, 0L, 1, Optional.empty()));
        FetchMetadata fetchMetadata = new FetchMetadata(1, 1000, true, true, (FetchIsolation)FetchLogEnd$.MODULE$, true, 1, (Seq)new .colon.colon((Object)new Tuple2((Object)tp, (Object)fetchPartitionStatus), (List)Nil$.MODULE$));
        return new DelayedFetch(null, fetchMetadata, replicaManager){

            public boolean forceComplete() {
                return true;
            }
        };
    }

    public static final /* synthetic */ void $anonfun$setUpMocks$2(ReplicaManagerQuotasTest $this, UnifiedLog log$1, int leaderBrokerId$1, boolean bothReplicasInSync$1, Tuple2 x$10) {
        if (x$10 != null) {
            TopicIdPartition p = (TopicIdPartition)x$10._1();
            Partition partition = $this.replicaManager().createPartition(p.topicPartition());
            log$1.updateHighWatermark(5L);
            partition.leaderReplicaIdOpt_$eq((Option)new Some((Object)BoxesRunTime.boxToInteger((int)leaderBrokerId$1)));
            partition.setLog(log$1, false);
            partition.updateAssignmentAndIsr((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{leaderBrokerId$1, ((KafkaConfig)$this.configs().last()).brokerId()})), bothReplicasInSync$1 ? (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{leaderBrokerId$1, ((KafkaConfig)$this.configs().last()).brokerId()})) : (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{leaderBrokerId$1})), (Seq)Nil$.MODULE$, (Seq)Nil$.MODULE$);
            return;
        }
        throw new MatchError(null);
    }
}

